// Generated by gmmproc 2.64.2 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_CLOCK_H
#define _GSTREAMERMM_CLOCK_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstclock.h>
#include <gstreamermm/object.h>
#include <gstreamermm/clockutils.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GstClock = struct _GstClock;
using GstClockClass = struct _GstClockClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gst
{ class  Clock_Class; } // namespace Gst
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gst
{

class Clock;

/** A data type to hold the handle to an outstanding sync or async clock
 * callback.
 */
class ClockID
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = ClockID;
  using BaseObjectType = GstClockEntry;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstClockEntry*       gobj();

  ///Provides access to the underlying C instance.
  const GstClockEntry* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstClockEntry* gobj_copy() const;

  ClockID() = delete;

  // noncopyable
  ClockID(const ClockID&) = delete;
  ClockID& operator=(const ClockID&) = delete;

protected:
  // Do not derive this.  Gst::ClockID can neither be constructed nor deleted.

  void operator delete(void*, std::size_t);

private:

  
public:
  /** For example,
   * bool on_clock(const Glib::RefPtr<Gst::Clock>& clock, ClockTime time, const
   * Glib::RefPtr<Gst::ClockID>& id);.
   * The clock function return value is currently unused (see GstClockCallback).
   */
  typedef sigc::slot< bool, const Glib::RefPtr<Gst::Clock>&, Gst::ClockTime, const Glib::RefPtr<Gst::ClockID>& > SlotClock;

  
  /** Get the time of the clock ID
   * 
   * @return The time of the given clock id.
   * 
   * MT safe.
   */
  Gst::ClockTime get_time() const;
  
  /** Perform a blocking wait on the Gst::ClockID. 
   * The Gst::ClockID should have been created with
   * Gst::Clock::create_single_shot_id() or Gst::Clock::create_periodic_id()
   * and should not have been unscheduled with a call to unschedule(). 
   * 
   * If this function returns Gst::CLOCK_OK or Gst::CLOCK_EARLY,
   * the @a jitter argument will contain the difference
   * against the clock and the time of the Gst::ClockID when this method was
   * called.
   * Positive values indicate how late the Gst::ClockID was relative to the clock
   * (in which case this function will return Gst::CLOCK_EARLY). 
   * Negative values indicate how much time was spent waiting on the clock 
   * before this function returned.
   * 
   * @param jitter A pointer that will contain the jitter.
   * @return The result of the blocking wait. Gst::CLOCK_EARLY will be returned
   * if the current clock time is past the time of the Gst::ClockID, Gst::CLOCK_OK
   * if Gst::ClockID was scheduled in time. Gst::CLOCK_UNSCHEDULED if Gst::ClockID
   * was unscheduled with unschedule().
   * 
   * MT safe.
   */
  ClockReturn wait(Gst::ClockTimeDiff& jitter);

  /// A wait() convenience overload.
  ClockReturn wait();

  /** Register a slot on the given Gst::ClockID id with the given slot. When
   * passing a Gst::ClockID with an invalid time to this function, the slot
   * will be called immediatly with a time set to Gst::CLOCK_TIME_NONE. The
   * slot will be called when the time of id has been reached.
   *
   * @param slot The slot to callback.
   * @return The result of the non blocking wait. MT safe. 
   */
  ClockReturn wait_async(const SlotClock& slot);
  

  /** Cancel an outstanding request with @a id. This can either
   * be an outstanding async notification or a pending sync notification.
   * After this call, @a id cannot be used anymore to receive sync or
   * async notifications, you need to create a new Gst::ClockID.
   * 
   * MT safe.
   */
  void unschedule();


};

/** Abstract class for global clocks
 * GStreamer uses a global clock to synchronize the plugins in a pipeline.
 * Different clock implementations are possible by implementing this abstract
 * base class.
 *
 * The Gst::Clock returns a monotonically increasing time with the method
 * get_time(). Its accuracy and base time depend on the specific
 * clock implementation but time is always expressed in nanoseconds. Since the
 * baseline of the clock is undefined, the clock time returned is not
 * meaningful in itself, what matters are the deltas between two clock times.
 * The time returned by a clock is called the absolute time.
 *
 * The pipeline uses the clock to calculate the running time. Usually all
 * renderers synchronize to the global clock using the buffer timestamps, the
 * newsegment events and the element's base time, see Gst::Pipeline.
 *
 * A clock implementation can support periodic and single shot clock
 * notifications both synchronous and asynchronous.
 *
 * One first needs to create a Gst::ClockID for the periodic or single shot
 * notification using create_single_shot_id() or create_periodic_id().
 *
 * To perform a blocking wait for the specific time of the Gst::ClockID use the
 * Gst::ClockID::wait(). To receive a callback when the specific time is reached
 * in the clock use Gst::ClockID::wait_async(). Both these calls can be
 * interrupted with the Gst::ClockID::unschedule() call. If the blocking wait is
 * unscheduled a return value of Gst::CLOCK_UNSCHEDULED is returned.
 *
 * Periodic callbacks scheduled async will be repeatedly called automatically
 * until it is unscheduled. To schedule a sync periodic callback,
 * Gst::ClockID::wait() should be called repeatedly.
 *
 * The async callbacks can happen from any thread, either provided by the core
 * or from a streaming thread. The application should be prepared for this.
 *
 * A Gst::ClockID that has been unscheduled cannot be used again for any wait
 * operation, a new Gst::ClockID should be created.
 *
 * It is possible to perform a blocking wait on the same Gst::ClockID from
 * multiple threads. However, registering the same Gst::ClockID for multiple
 * async notifications is not possible, the callback will only be called for
 * the thread registering the entry last.
 *
 * None of the wait operations unref the Gst::ClockID, the owner is responsible
 * for unreffing the ids itself. This holds for both periodic and single shot
 * notifications. The reason being that the owner of the Gst::ClockID has to
 * keep a handle to the Gst::ClockID to unblock the wait on FLUSHING events or
 * state changes and if the entry would be unreffed automatically, the handle
 * might become invalid without any notification. (The RefPtr takes care of
- * unreffing in this case)
 *
 * These clock operations do not operate on the running time, so the callbacks
 * will also occur when not in PLAYING state as if the clock just keeps on
 * running. Some clocks however do not progress when the element that provided
 * the clock is not PLAYING.
 *
 * When a clock has the Gst::CLOCK_FLAG_CAN_SET_MASTER flag set, it can be
 * slaved to another Gst::Clock with the set_master(). The clock will
 * then automatically be synchronized to this master clock by repeatedly
 * sampling the master clock and the slave clock and recalibrating the slave
 * clock with set_calibration(). This feature is mostly useful for
 * plugins that have an internal clock but must operate with another clock
 * selected by the Gst::Pipeline.  They can track the offset and rate difference
 * of their internal clock relative to the master clock by using the
 * get_calibration() method.
 *
 * The master/slave synchronisation can be tuned with the "timeout",
 * "window-size" and "window-threshold" properties. The "timeout" property
 * defines the interval to sample the master clock and run the calibration
 * functions. "window-size" defines the number of samples to use when
 * calibrating and "window-threshold" defines the minimum number of samples
 * before the calibration is performed.
 *
 * Last reviewed on 2016-05-16 (1.8.0)
 */

class Clock : public Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Clock;
  using CppClassType = Clock_Class;
  using BaseObjectType = GstClock;
  using BaseClassType = GstClockClass;

  // noncopyable
  Clock(const Clock&) = delete;
  Clock& operator=(const Clock&) = delete;

private:  friend class Clock_Class;
  static CppClassType clock_class_;

protected:
  explicit Clock(const Glib::ConstructParams& construct_params);
  explicit Clock(GstClock* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Clock(Clock&& src) noexcept;
  Clock& operator=(Clock&& src) noexcept;

  ~Clock() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstClock*       gobj()       { return reinterpret_cast<GstClock*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstClock* gobj() const { return reinterpret_cast<GstClock*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstClock* gobj_copy();

private:


public:
  
  /** The time @a master_time of the master clock and the time @a slave_time of the slave
   * clock are added to the list of observations. If enough observations
   * are available, a linear regression algorithm is run on the
   * observations and @a clock is recalibrated.
   * 
   * If this functions returns <tt>true</tt>, @a result will contain the 
   * correlation coefficient of the interpolation. A value of 1.0
   * means a perfect regression was performed. This value can
   * be used to control the sampling frequency of the master and slave
   * clocks.
   * 
   * @param slave_time A time on the slave.
   * @param master_time A time on the master.
   * @param result A pointer to hold the result.
   * @return <tt>true</tt> if enough observations were added to run the 
   * regression algorithm.
   * 
   * MT safe.
   */
  bool add_observation(Gst::ClockTime slave_time, Gst::ClockTime master_time, gdouble& result);
  
  /** Add a clock observation to the internal slaving algorithm the same as
   * add_observation(), and return the result of the master clock
   * estimation, without updating the internal calibration.
   * 
   * The caller can then take the results and call set_calibration()
   * with the values, or some modified version of them.
   * 
   * @param slave_time A time on the slave.
   * @param master_time A time on the master.
   * @param result A pointer to hold the result.
   * @param internal A location to store the internal time.
   * @param external A location to store the external time.
   * @param rate_num A location to store the rate numerator.
   * @param rate_denom A location to store the rate denominator.
   */
  bool add_observation(Gst::ClockTime slave_time, Gst::ClockTime master_time, gdouble& result, Gst::ClockTime& internal, Gst::ClockTime& external, Gst::ClockTime& rate_num, Gst::ClockTime& rate_denom);
  
  /** Set @a master_clock as the master clock for @a clock. @a clock will be automatically
   * calibrated so that get_time() reports the same time as the
   * master clock.  
   * 
   * A clock provider that slaves its clock to a master can get the current
   * calibration values with get_calibration().
   * 
   *  @a master_clock can be <tt>nullptr</tt> in which case @a clock will not be slaved anymore. It will
   * however keep reporting its time adjusted with the last configured rate 
   * and time offsets.
   * 
   * @param master_clock A master Gst::Clock.
   * @return <tt>true</tt> if the clock is capable of being slaved to a master clock. 
   * Trying to set a master on a clock without the 
   * Gst::CLOCK_FLAG_CAN_SET_MASTER flag will make this function return <tt>false</tt>.
   * 
   * MT safe.
   */
  bool set_master(const Clock& master_clock);
  
  /** Get the master clock that @a clock is slaved to or <tt>nullptr</tt> when the clock is
   * not slaved to any master clock.
   * 
   * @return A master Gst::Clock or <tt>nullptr</tt>
   * when this clock is not slaved to a master clock. Unref after
   * usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<Gst::Clock> get_master();
  
  /** Get the master clock that @a clock is slaved to or <tt>nullptr</tt> when the clock is
   * not slaved to any master clock.
   * 
   * @return A master Gst::Clock or <tt>nullptr</tt>
   * when this clock is not slaved to a master clock. Unref after
   * usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<const Gst::Clock> get_master() const;
  
  /** Set the accuracy of the clock. Some clocks have the possibility to operate
   * with different accuracy at the expense of more resource usage. There is
   * normally no need to change the default resolution of a clock. The resolution
   * of a clock can only be changed if the clock has the
   * Gst::CLOCK_FLAG_CAN_SET_RESOLUTION flag set.
   * 
   * @param resolution The resolution to set.
   * @return The new resolution of the clock.
   */
  Gst::ClockTime set_resolution(Gst::ClockTime resolution);
  
  /** Get the accuracy of the clock. The accuracy of the clock is the granularity
   * of the values returned by get_time().
   * 
   * @return The resolution of the clock in units of Gst::ClockTime.
   * 
   * MT safe.
   */
  Gst::ClockTime get_resolution() const;
  
  /** Gets the current time of the given clock. The time is always
   * monotonically increasing and adjusted according to the current
   * offset and rate.
   * 
   * @return The time of the clock. Or GST_CLOCK_TIME_NONE when
   * given invalid input.
   * 
   * MT safe.
   */
  Gst::ClockTime get_time() const;
  
  /** Get a Gst::ClockID from @a clock to trigger a single shot
   * notification at the requested time. The single shot id should be
   * unreffed after usage.
   * 
   * Free-function: gst_clock_id_unref
   * 
   * @param time The requested time.
   * @return A Gst::ClockID that can be used to request the
   * time notification.
   * 
   * MT safe.
   */
  Glib::RefPtr<Gst::ClockID> create_single_shot_id(Gst::ClockTime time);
  
  /** Get an ID from @a clock to trigger a periodic notification.
   * The periodic notifications will start at time @a start_time and
   * will then be fired with the given @a intervals. @a id should be unreffed
   * after usage.
   * 
   * Free-function: gst_clock_id_unref
   * 
   * @param start_time The requested start time.
   * @param intervals The requested interval.
   * @return A Gst::ClockID that can be used to request the
   * time notification.
   * 
   * MT safe.
   */
  Glib::RefPtr<Gst::ClockID> create_periodic_id(Gst::ClockTime start_time, Gst::ClockTime intervals);
  
  /** Reinitializes the provided single shot @a id to the provided time. Does not
   * modify the reference count.
   * 
   * @param id A Gst::ClockID.
   * @param time The requested time.
   * @return <tt>true</tt> if the GstClockID could be reinitialized to the provided
   *  @a time, else <tt>false</tt>.
   */
  bool single_shot_id_reinit(const Glib::RefPtr<Gst::ClockID>& id, Gst::ClockTime time);
  
  /** Reinitializes the provided periodic @a id to the provided start time and
   * interval. Does not modify the reference count.
   * 
   * @param id A Gst::ClockID.
   * @param start_time The requested start time.
   * @param interval The requested interval.
   * @return <tt>true</tt> if the GstClockID could be reinitialized to the provided
   *  @a time, else <tt>false</tt>.
   */
  bool periodic_id_reinit(const Glib::RefPtr<Gst::ClockID>& id, Gst::ClockTime start_time, Gst::ClockTime interval);
  
  /** Gets the current internal time of the given clock. The time is returned
   * unadjusted for the offset and the rate.
   * 
   * @return The internal time of the clock. Or GST_CLOCK_TIME_NONE when
   * given invalid input.
   * 
   * MT safe.
   */
  Gst::ClockTime get_internal_time() const;
  
  /** Converts the given @a internal_time clock time to the external time, adjusting for the
   * rate and reference time set with set_calibration() and making sure
   * that the returned time is increasing. This function should be called with the
   * clock's OBJECT_LOCK held and is mainly used by clock subclasses.
   * 
   * This function is the reverse of unadjust_unlocked().
   * 
   * @param internal_time A clock time.
   * @return The converted time of the clock.
   */
  Gst::ClockTime adjust_unlocked(Gst::ClockTime internal_time);
  
  /** Converts the given @a external_time clock time to the internal time of @a clock,
   * using the rate and reference time set with set_calibration().
   * This function should be called with the clock's OBJECT_LOCK held and
   * is mainly used by clock subclasses.
   * 
   * This function is the reverse of adjust_unlocked().
   * 
   * @param external_time An external clock time.
   * @return The internal time of the clock corresponding to @a external_time.
   */
  Gst::ClockTime unadjust_unlocked(Gst::ClockTime external_time);
  
  /** Converts the given @a internal_target clock time to the external time,
   * using the passed calibration parameters. This function performs the
   * same calculation as adjust_unlocked() when called using the
   * current calibration parameters, but doesn't ensure a monotonically
   * increasing result as adjust_unlocked() does.
   * 
   * @note The @a clock parameter is unused and can be <tt>nullptr</tt>
   * 
   * @param internal_target A clock time.
   * @param cinternal A reference internal time.
   * @param cexternal A reference external time.
   * @param cnum The numerator of the rate of the clock relative to its
   * internal time.
   * @param cdenom The denominator of the rate of the clock.
   * @return The converted time of the clock.
   */
  Gst::ClockTime adjust_with_calibration(Gst::ClockTime internal_target, Gst::ClockTime cinternal, Gst::ClockTime cexternal, Gst::ClockTime cnum, Gst::ClockTime cdenom);
  
  /** Converts the given @a external_target clock time to the internal time,
   * using the passed calibration parameters. This function performs the
   * same calculation as unadjust_unlocked() when called using the
   * current calibration parameters.
   * 
   * @note The @a clock parameter is unused and can be <tt>nullptr</tt>
   * 
   * @param external_target A clock time.
   * @param cinternal A reference internal time.
   * @param cexternal A reference external time.
   * @param cnum The numerator of the rate of the clock relative to its
   * internal time.
   * @param cdenom The denominator of the rate of the clock.
   * @return The converted time of the clock.
   */
  Gst::ClockTime unadjust_with_calibration(Gst::ClockTime external_target, Gst::ClockTime cinternal, Gst::ClockTime cexternal, Gst::ClockTime cnum, Gst::ClockTime cdenom);
  
  /** Gets the internal rate and reference time of @a clock. See
   * set_calibration() for more information.
   * 
   *  @a internal, @a external, @a rate_num, and @a rate_denom can be left <tt>nullptr</tt> if the
   * caller is not interested in the values.
   * 
   * MT safe.
   * 
   * @param internal A location to store the internal time.
   * @param external A location to store the external time.
   * @param rate_num A location to store the rate numerator.
   * @param rate_denom A location to store the rate denominator.
   */
  void get_calibration(Gst::ClockTime& internal, Gst::ClockTime& external, Gst::ClockTime& rate_num, Gst::ClockTime& rate_denom) const;
  
  /** Adjusts the rate and time of @a clock. A rate of 1/1 is the normal speed of
   * the clock. Values bigger than 1/1 make the clock go faster.
   * 
   *  @a internal and @a external are calibration parameters that arrange that
   * get_time() should have been @a external at internal time @a internal.
   * This internal time should not be in the future; that is, it should be less
   * than the value of get_internal_time() when this function is called.
   * 
   * Subsequent calls to get_time() will return clock times computed as
   * follows:
   * 
   * 
   * time = (internal_time - internal) * rate_num / rate_denom + external
   * 
   * 
   * This formula is implemented in adjust_unlocked(). Of course, it
   * tries to do the integer arithmetic as precisely as possible.
   * 
   * Note that get_time() always returns increasing values so when you
   * move the clock backwards, get_time() will report the previous value
   * until the clock catches up.
   * 
   * MT safe.
   * 
   * @param internal A reference internal time.
   * @param external A reference external time.
   * @param rate_num The numerator of the rate of the clock relative to its
   * internal time.
   * @param rate_denom The denominator of the rate of the clock.
   */
  void set_calibration(Gst::ClockTime internal, Gst::ClockTime external, Gst::ClockTime rate_num, Gst::ClockTime rate_denom);
  
  /** Waits until @a clock is synced for reporting the current time. If @a timeout
   * is Gst::CLOCK_TIME_NONE it will wait forever, otherwise it will time out
   * after @a timeout nanoseconds.
   * 
   * For asynchronous waiting, the GstClock::synced signal can be used.
   * 
   * 
   * This returns immediately with <tt>true</tt> if GST_CLOCK_FLAG_NEEDS_STARTUP_SYNC
   * is not set on the clock, or if the clock is already synced.
   * 
   * @param timeout Timeout for waiting or Gst::CLOCK_TIME_NONE.
   * @return <tt>true</tt> if waiting was successful, or <tt>false</tt> on timeout.
   */
  bool wait_for_sync(Gst::ClockTime timeout);
  
  /** Checks if the clock is currently synced.
   * 
   * This returns if GST_CLOCK_FLAG_NEEDS_STARTUP_SYNC is not set on the clock.
   * 
   * @return <tt>true</tt> if the clock is currently synced.
   */
  bool is_synced() const;
  
  /** Sets @a clock to synced and emits the GstClock::synced signal, and wakes up any
   * thread waiting in wait_for_sync().
   * 
   * This function must only be called if GST_CLOCK_FLAG_NEEDS_STARTUP_SYNC
   * is set on the clock, and is intended to be called by subclasses only.
   * 
   * @param synced If the clock is synced.
   */
  void set_synced(bool synced);

  /// get/set timeout can be achieved through 'timeout' property,
  /// so wrapping gst_clock_{get|set|_timeout is unnecessary.
  

  /** The amount of time, in nanoseconds, to sample master and slave clocks.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint64 > property_timeout() ;

/** The amount of time, in nanoseconds, to sample master and slave clocks.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint64 > property_timeout() const;

  /** The size of the window used to calculate rate and offset.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_window_size() ;

/** The size of the window used to calculate rate and offset.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_window_size() const;

  /** The threshold to start calculating rate and offset.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_window_threshold() ;

/** The threshold to start calculating rate and offset.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_window_threshold() const;


  /** Change the resolution of the clock. Not all values might be acceptable.
   * The new resolution should be returned.
   */
    virtual Gst::ClockTime change_resolution_vfunc(Gst::ClockTime old_resolution, Gst::ClockTime new_resolution);


  /** Get the resolution of the clock.
   */
    virtual Gst::ClockTime get_resolution_vfunc() const;


  /** Get the internal unadjusted time of the clock.
   */
    virtual Gst::ClockTime get_internal_time_vfunc() const;


  /** Perform a blocking wait for the given Gst::ClockID. Deprecated,
   * implement wait_jitter_vfunc() instead.
   */
    virtual ClockReturn wait_vfunc(const Glib::RefPtr<Gst::ClockID>& id, Gst::ClockTimeDiff& jitter);


  /** Perform an asynchronous wait for the given Gst::ClockID.
   */
    virtual ClockReturn wait_async_vfunc(const Glib::RefPtr<Gst::ClockID>& id);


  /** Unblock a blocking or async wait operation.
   */
    virtual void unschedule_vfunc(const Glib::RefPtr<Gst::ClockID>& id);


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%synced(bool synced)</tt>
   *
   * Flags: Run Last
   *
   * Signaled on clocks with GST_CLOCK_FLAG_NEEDS_STARTUP_SYNC set once
   * the clock is synchronized, or when it completely lost synchronization.
   * This signal will not be emitted on clocks without the flag.
   * 
   * This signal will be emitted from an arbitrary thread, most likely not
   * the application's main thread.
   * 
   * @param synced If the clock is synced now.
   */

  Glib::SignalProxy< void,bool > signal_synced();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} //namespace Gst


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gst::ClockID
 */

Glib::RefPtr<Gst::ClockID> wrap(GstClockEntry* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Clock
   */
  
  Glib::RefPtr<Gst::Clock> wrap(GstClock* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_CLOCK_H */

