/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.policyeditor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum PermissionActions {
    NONE(""),
    READ("read"),
    WRITE("write"),
    EXECUTE("execute"),
    DELETE("delete"),
    READLINK("readlink"),
    FILE_ALL("read,write,execute,delete,readlink"),
    ACCEPT("accept"),
    LISTEN("listen"),
    CONNECT("connect"),
    RESOLVE("resolve"),
    NETALL("accept,listen,connect,resolve");

    private final String rawActions;
    private final Set<String> actions;

    private PermissionActions(String actions) {
        this.rawActions = actions;
        this.actions = PermissionActions.setFromString(actions);
    }

    public static PermissionActions fromString(String string) {
        Set<String> actions = PermissionActions.setFromString(string);
        for (PermissionActions action : PermissionActions.values()) {
            if (!actions.equals(action.actions)) continue;
            return action;
        }
        return NONE;
    }

    public Collection<String> getActions() {
        return new HashSet<String>(this.actions);
    }

    private static Set<String> setFromString(String string) {
        HashSet<String> set = new HashSet<String>();
        Collections.addAll(set, string.split(","));
        return set;
    }

    public String rawString() {
        return this.rawActions;
    }
}

