/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javajs.J2SIgnoreImport;
import javajs.util.PT;
import javajs.util.Rdr;
import org.jmol.translation.PO;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

@J2SIgnoreImport(value={Locale.class})
class Resource {
    private ResourceBundle resource;
    private Map<String, String> resourceMap;

    private Resource(Object resource, String className) {
        if (className == null) {
            this.resourceMap = (Map)resource;
        } else {
            this.resource = (ResourceBundle)resource;
        }
    }

    static Resource getResource(Viewer vwr, String className, String name) {
        try {
            BufferedReader br = FileManager.getBufferedReaderForResource(vwr, new PO(), "org/jmol/translation/", (className.indexOf("Applet") >= 0 ? "JmolApplet/" : "Jmol/") + name + ".po");
            String[] data = new String[1];
            Rdr.readAllAsString(br, Integer.MAX_VALUE, false, data, 0);
            String poData = data[0];
            return Resource.getResourceFromPO(poData);
        }
        catch (IOException e) {
            return null;
        }
    }

    String getString(String string) {
        try {
            return this.resource == null ? this.resourceMap.get(string) : this.resource.getString(string);
        }
        catch (Exception e) {
            return null;
        }
    }

    static String getLanguage() {
        String language = null;
        Locale locale = Locale.getDefault();
        if (locale != null) {
            language = locale.getLanguage();
            if (locale.getCountry() != null) {
                language = language + "_" + locale.getCountry();
                if (locale.getVariant() != null && locale.getVariant().length() > 0) {
                    language = language + "_" + locale.getVariant();
                }
            }
        }
        return language;
    }

    static Resource getResourceFromPO(String data) {
        if (data == null || data.length() == 0) {
            return null;
        }
        Hashtable<String, String> map = new Hashtable<String, String>();
        try {
            String[] lines = PT.split(data, "\n");
            int mode = 0;
            String msgstr = "";
            String msgid = "";
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (line.length() <= 2) {
                    if (mode == 2 && msgstr.length() != 0 && msgid.length() != 0) {
                        map.put(msgid, msgstr);
                    }
                    mode = 0;
                    continue;
                }
                if (line.indexOf("msgid") == 0) {
                    mode = 1;
                    msgid = Resource.fix(line);
                    continue;
                }
                if (line.indexOf("msgstr") == 0) {
                    mode = 2;
                    msgstr = Resource.fix(line);
                    continue;
                }
                if (mode == 1) {
                    msgid = msgid + Resource.fix(line);
                    continue;
                }
                if (mode != 2) continue;
                msgstr = msgstr + Resource.fix(line);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logger.info(map.size() + " translations loaded");
        return map.size() == 0 ? null : new Resource(map, null);
    }

    static String fix(String line) {
        if (line.indexOf("\\\"") >= 0) {
            line = PT.rep(line, "\\\"", "\"");
        }
        return PT.rep(line.substring(line.indexOf("\"") + 1, line.lastIndexOf("\"")), "\\n", "\n");
    }
}

