/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.MultiFetchOverpassObjectReader;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.OverpassDownloadReader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class MultiFetchServerObjectReader
extends OsmServerReader {
    private static final int MAX_IDS_PER_REQUEST = 170;
    private final Set<Long> nodes = new LinkedHashSet<Long>();
    private final Set<Long> ways = new LinkedHashSet<Long>();
    private final Set<Long> relations = new LinkedHashSet<Long>();
    private final Set<PrimitiveId> missingPrimitives;
    private final DataSet outputDataSet = new DataSet();
    protected final Map<OsmPrimitiveType, Set<Long>> primitivesMap;
    protected boolean recurseDownRelations;
    private boolean recurseDownAppended = true;
    private ExecutorService exec;

    protected MultiFetchServerObjectReader() {
        this.missingPrimitives = new LinkedHashSet<PrimitiveId>();
        this.primitivesMap = new LinkedHashMap<OsmPrimitiveType, Set<Long>>();
        this.primitivesMap.put(OsmPrimitiveType.RELATION, this.relations);
        this.primitivesMap.put(OsmPrimitiveType.WAY, this.ways);
        this.primitivesMap.put(OsmPrimitiveType.NODE, this.nodes);
    }

    public static MultiFetchServerObjectReader create() {
        return MultiFetchServerObjectReader.create(OverpassDownloadReader.FOR_MULTI_FETCH.get());
    }

    public static MultiFetchServerObjectReader create(boolean fromMirror) {
        if (fromMirror) {
            return new MultiFetchOverpassObjectReader();
        }
        return new MultiFetchServerObjectReader();
    }

    public void append(PrimitiveId id) {
        if (id.isNew()) {
            return;
        }
        switch (id.getType()) {
            case NODE: {
                this.nodes.add(id.getUniqueId());
                break;
            }
            case WAY: {
                this.ways.add(id.getUniqueId());
                break;
            }
            case RELATION: {
                this.relations.add(id.getUniqueId());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public MultiFetchServerObjectReader append(DataSet ds, long id, OsmPrimitiveType type) {
        OsmPrimitive p = (OsmPrimitive)ds.getPrimitiveById(id, type);
        return this.append(p);
    }

    public MultiFetchServerObjectReader appendNode(Node node) {
        if (node == null || node.isNew()) {
            return this;
        }
        this.append(node.getPrimitiveId());
        return this;
    }

    public MultiFetchServerObjectReader appendWay(Way way) {
        if (way == null || way.isNew()) {
            return this;
        }
        if (this.recurseDownAppended) {
            this.append(way.getNodes());
        }
        this.append(way.getPrimitiveId());
        return this;
    }

    protected MultiFetchServerObjectReader appendRelation(Relation relation) {
        if (relation == null || relation.isNew()) {
            return this;
        }
        this.append(relation.getPrimitiveId());
        if (this.recurseDownAppended) {
            for (RelationMember member : relation.getMembers()) {
                if (OsmPrimitiveType.from(member.getMember()) == OsmPrimitiveType.RELATION && this.relations.contains(member.getMember().getId()) || member.getMember().isIncomplete()) continue;
                this.append(member.getMember());
            }
        }
        return this;
    }

    public MultiFetchServerObjectReader append(OsmPrimitive primitive) {
        if (primitive instanceof Node) {
            return this.appendNode((Node)primitive);
        }
        if (primitive instanceof Way) {
            return this.appendWay((Way)primitive);
        }
        if (primitive instanceof Relation) {
            return this.appendRelation((Relation)primitive);
        }
        return this;
    }

    public MultiFetchServerObjectReader append(Collection<? extends OsmPrimitive> primitives) {
        if (primitives == null) {
            return this;
        }
        primitives.forEach(this::append);
        return this;
    }

    protected Set<Long> extractIdPackage(Set<Long> ids) {
        HashSet<Long> pkg = new HashSet<Long>();
        if (ids.isEmpty()) {
            return pkg;
        }
        if (ids.size() > 170) {
            Iterator<Long> it = ids.iterator();
            for (int i = 0; i < 170; ++i) {
                pkg.add(it.next());
            }
            ids.removeAll(pkg);
        } else {
            pkg.addAll(ids);
            ids.clear();
        }
        return pkg;
    }

    protected String buildRequestString(OsmPrimitiveType type, Set<Long> idPackage) {
        return type.getAPIName() + "s?" + type.getAPIName() + "s=" + idPackage.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    protected void rememberNodesOfIncompleteWaysToLoad(DataSet from) {
        for (Way w : from.getWays()) {
            for (Node n : w.getNodes()) {
                if (!n.isIncomplete()) continue;
                this.nodes.add(n.getId());
            }
        }
    }

    protected void merge(DataSet from) {
        DataSetMerger visitor = new DataSetMerger(this.outputDataSet, from);
        visitor.merge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchPrimitives(Set<Long> ids, OsmPrimitiveType type, ProgressMonitor progressMonitor) throws OsmTransferException {
        String msg;
        String baseUrl = this.getBaseUrl();
        switch (type) {
            case NODE: {
                msg = I18n.tr("Fetching a package of nodes from ''{0}''", baseUrl);
                break;
            }
            case WAY: {
                msg = I18n.tr("Fetching a package of ways from ''{0}''", baseUrl);
                break;
            }
            case RELATION: {
                msg = I18n.tr("Fetching a package of relations from ''{0}''", baseUrl);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        progressMonitor.setTicksCount(ids.size());
        progressMonitor.setTicks(0);
        HashSet<Long> toFetch = new HashSet<Long>(ids);
        int threadsNumber = Config.getPref().getInt("osm.download.threads", 2);
        threadsNumber = Utils.clamp(threadsNumber, 1, 2);
        this.exec = Executors.newFixedThreadPool(threadsNumber, Utils.newThreadFactory(this.getClass() + "-%d", 5));
        ExecutorCompletionService<FetchResult> ecs = new ExecutorCompletionService<FetchResult>(this.exec);
        ArrayList<Future<FetchResult>> jobs = new ArrayList<Future<FetchResult>>();
        MultiFetchServerObjectReader multiFetchServerObjectReader = this;
        synchronized (multiFetchServerObjectReader) {
            while (!toFetch.isEmpty() && !this.isCanceled()) {
                jobs.add(ecs.submit(new Fetcher(type, this.extractIdPackage(toFetch), progressMonitor)));
            }
        }
        for (int i = 0; i < jobs.size() && !this.isCanceled(); ++i) {
            progressMonitor.subTask(msg + "... " + progressMonitor.getTicks() + '/' + progressMonitor.getTicksCount());
            try {
                FetchResult fetchResult = (FetchResult)ecs.take().get();
                if (fetchResult.rc404 != null) {
                    ArrayList toSplit = new ArrayList(fetchResult.rc404);
                    int n = toSplit.size() / 2;
                    jobs.add(ecs.submit(new Fetcher(type, new HashSet<Long>(toSplit.subList(0, n)), progressMonitor)));
                    jobs.add(ecs.submit(new Fetcher(type, new HashSet<Long>(toSplit.subList(n, toSplit.size())), progressMonitor)));
                }
                if (fetchResult.missingPrimitives != null) {
                    this.missingPrimitives.addAll(fetchResult.missingPrimitives);
                }
                if (fetchResult.dataSet == null || this.isCanceled()) continue;
                this.rememberNodesOfIncompleteWaysToLoad(fetchResult.dataSet);
                this.merge(fetchResult.dataSet);
                continue;
            }
            catch (InterruptedException | ExecutionException exception) {
                if (exception instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                Logging.error(exception);
                if (!(exception.getCause() instanceof OsmTransferException)) continue;
                throw (OsmTransferException)exception.getCause();
            }
        }
        this.exec.shutdown();
        if (this.isCanceled()) {
            for (Future future : jobs) {
                future.cancel(true);
            }
        }
        this.exec = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        this.missingPrimitives.clear();
        int n = this.nodes.size() + this.ways.size() + this.relations.size();
        progressMonitor.beginTask(I18n.trn("Downloading {0} object from ''{1}''", "Downloading {0} objects from ''{1}''", n, n, this.getBaseUrl()));
        try {
            if (this instanceof MultiFetchOverpassObjectReader) {
                String request = MultiFetchOverpassObjectReader.genOverpassQuery(this.primitivesMap, true, false, this.recurseDownRelations);
                if (this.isCanceled()) {
                    DataSet dataSet = null;
                    return dataSet;
                }
                OverpassDownloadReader reader = new OverpassDownloadReader(new Bounds(0.0, 0.0, 0.0, 0.0), this.getBaseUrl(), request);
                DataSet ds = reader.parseOsm(progressMonitor.createSubTaskMonitor(1, false));
                new DataSetMerger(this.outputDataSet, ds).merge();
                this.checkMissing(this.outputDataSet, progressMonitor);
            } else {
                this.downloadRelations(progressMonitor);
                if (this.isCanceled()) {
                    DataSet dataSet = null;
                    return dataSet;
                }
                this.fetchPrimitives(this.ways, OsmPrimitiveType.WAY, progressMonitor);
                if (this.isCanceled()) {
                    DataSet dataSet = null;
                    return dataSet;
                }
                this.fetchPrimitives(this.nodes, OsmPrimitiveType.NODE, progressMonitor);
            }
            this.outputDataSet.deleteInvisible();
            DataSet dataSet = this.outputDataSet;
            return dataSet;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private void checkMissing(DataSet ds, ProgressMonitor progressMonitor) throws OsmTransferException {
        LinkedHashSet<OsmPrimitive> missing = new LinkedHashSet<OsmPrimitive>();
        for (Map.Entry<OsmPrimitiveType, Set<Long>> e : this.primitivesMap.entrySet()) {
            for (long id : e.getValue()) {
                if (ds.getPrimitiveById(id, e.getKey()) != null) continue;
                missing.add(e.getKey().newInstance(id, true));
            }
        }
        if (this.isCanceled() || missing.isEmpty()) {
            return;
        }
        MultiFetchServerObjectReader missingReader = MultiFetchServerObjectReader.create(false);
        missingReader.setRecurseDownAppended(false);
        missingReader.setRecurseDownRelations(false);
        missingReader.append(missing);
        DataSet mds = missingReader.parseOsm(progressMonitor.createSubTaskMonitor(missing.size(), false));
        new DataSetMerger(ds, mds).merge();
        this.missingPrimitives.addAll(missingReader.getMissingPrimitives());
    }

    private void downloadRelations(ProgressMonitor progressMonitor) throws OsmTransferException {
        boolean removeIncomplete = this.outputDataSet.isEmpty();
        LinkedHashSet<Long> toDownload = new LinkedHashSet<Long>(this.relations);
        this.fetchPrimitives(toDownload, OsmPrimitiveType.RELATION, progressMonitor);
        if (!this.recurseDownRelations) {
            return;
        }
        for (Relation r : this.outputDataSet.getRelations()) {
            if (!r.isVisible()) {
                toDownload.remove(r.getUniqueId());
                continue;
            }
            if (!removeIncomplete) continue;
            this.outputDataSet.removePrimitive((PrimitiveId)r);
        }
        Iterator<Relation> iterator = toDownload.iterator();
        while (iterator.hasNext()) {
            long id = (Long)((Object)iterator.next());
            if (this.isCanceled()) {
                return;
            }
            OsmServerObjectReader reader = new OsmServerObjectReader(id, OsmPrimitiveType.RELATION, true);
            DataSet ds = reader.parseOsm(progressMonitor.createSubTaskMonitor(1, false));
            this.merge(ds);
        }
    }

    public Set<PrimitiveId> getMissingPrimitives() {
        return this.missingPrimitives;
    }

    public MultiFetchServerObjectReader setRecurseDownRelations(boolean recurseDownRelations) {
        this.recurseDownRelations = recurseDownRelations;
        return this;
    }

    public MultiFetchServerObjectReader setRecurseDownAppended(boolean recurseAppended) {
        this.recurseDownAppended = recurseAppended;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        super.cancel();
        MultiFetchServerObjectReader multiFetchServerObjectReader = this;
        synchronized (multiFetchServerObjectReader) {
            if (this.exec != null) {
                this.exec.shutdownNow();
            }
        }
    }

    protected class Fetcher
    extends OsmServerReader
    implements Callable<FetchResult> {
        private final Set<Long> pkg;
        private final OsmPrimitiveType type;
        private final ProgressMonitor progressMonitor;

        public Fetcher(OsmPrimitiveType type, Set<Long> idsPackage, ProgressMonitor progressMonitor) {
            this.pkg = idsPackage;
            this.type = type;
            this.progressMonitor = progressMonitor;
        }

        @Override
        public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
            return this.fetch((ProgressMonitor)progressMonitor).dataSet;
        }

        @Override
        public FetchResult call() throws Exception {
            return this.fetch(this.progressMonitor);
        }

        protected FetchResult fetch(ProgressMonitor progressMonitor) throws OsmTransferException {
            try {
                return this.multiGetIdPackage(this.type, this.pkg, progressMonitor);
            }
            catch (OsmApiException e) {
                if (e.getResponseCode() == 404) {
                    if (this.pkg.size() > 4) {
                        FetchResult res = new FetchResult(null, null);
                        res.rc404 = this.pkg;
                        return res;
                    }
                    if (this.pkg.size() == 1) {
                        FetchResult res = new FetchResult(new DataSet(), new HashSet<PrimitiveId>());
                        res.missingPrimitives.add(new SimplePrimitiveId(this.pkg.iterator().next(), this.type));
                        return res;
                    }
                    Logging.info(I18n.tr("Server replied with response code 404, retrying with an individual request for each object.", new Object[0]));
                    return this.singleGetIdPackage(this.type, this.pkg, progressMonitor);
                }
                throw e;
            }
        }

        @Override
        protected String getBaseUrl() {
            return MultiFetchServerObjectReader.this.getBaseUrl();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected FetchResult multiGetIdPackage(OsmPrimitiveType type, Set<Long> pkg, ProgressMonitor progressMonitor) throws OsmTransferException {
            String request = MultiFetchServerObjectReader.this.buildRequestString(type, pkg);
            FetchResult result = null;
            try (InputStream in = this.getInputStream(request, NullProgressMonitor.INSTANCE);){
                if (in == null) {
                    FetchResult fetchResult = null;
                    return fetchResult;
                }
                progressMonitor.subTask(I18n.tr("Downloading OSM data...", new Object[0]));
                try {
                    result = new FetchResult(OsmReader.parseDataSet(in, progressMonitor.createSubTaskMonitor(pkg.size(), false)), null);
                    return result;
                }
                catch (IllegalDataException e) {
                    throw new OsmTransferException(e);
                }
            }
            catch (IOException ex) {
                Logging.warn(ex);
                throw new OsmTransferException(ex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected DataSet singleGetId(OsmPrimitiveType type, long id, ProgressMonitor progressMonitor) throws OsmTransferException {
            String request = MultiFetchServerObjectReader.this.buildRequestString(type, Collections.singleton(id));
            DataSet result = null;
            try (InputStream in = this.getInputStream(request, NullProgressMonitor.INSTANCE);){
                if (in == null) {
                    DataSet dataSet = null;
                    return dataSet;
                }
                progressMonitor.subTask(I18n.tr("Downloading OSM data...", new Object[0]));
                try {
                    result = OsmReader.parseDataSet(in, progressMonitor.createSubTaskMonitor(1, false));
                    return result;
                }
                catch (IllegalDataException e) {
                    throw new OsmTransferException(e);
                }
            }
            catch (IOException ex) {
                Logging.warn(ex);
            }
            return result;
        }

        protected FetchResult singleGetIdPackage(OsmPrimitiveType type, Set<Long> pkg, ProgressMonitor progressMonitor) throws OsmTransferException {
            FetchResult result = new FetchResult(new DataSet(), new HashSet<PrimitiveId>());
            String baseUrl = OsmApi.getOsmApi().getBaseUrl();
            for (long id : pkg) {
                try {
                    String msg;
                    switch (type) {
                        case NODE: {
                            msg = I18n.tr("Fetching node with id {0} from ''{1}''", id, baseUrl);
                            break;
                        }
                        case WAY: {
                            msg = I18n.tr("Fetching way with id {0} from ''{1}''", id, baseUrl);
                            break;
                        }
                        case RELATION: {
                            msg = I18n.tr("Fetching relation with id {0} from ''{1}''", id, baseUrl);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    progressMonitor.setCustomText(msg);
                    result.dataSet.mergeFrom(this.singleGetId(type, id, progressMonitor));
                }
                catch (OsmApiException e) {
                    if (e.getResponseCode() == 404) {
                        Logging.info(I18n.tr("Server replied with response code 404 for id {0}. Skipping.", Long.toString(id)));
                        result.missingPrimitives.add(new SimplePrimitiveId(id, type));
                        continue;
                    }
                    throw e;
                }
            }
            return result;
        }
    }

    protected static class FetchResult {
        public final DataSet dataSet;
        public final Set<PrimitiveId> missingPrimitives;
        private Set<Long> rc404;

        public FetchResult(DataSet dataSet, Set<PrimitiveId> missingPrimitives) {
            this.dataSet = dataSet;
            this.missingPrimitives = missingPrimitives;
        }
    }
}

