# `MD035` - Horizontal rule style

Tags: `hr`

Aliases: `hr-style`

Parameters:

- `style`: Horizontal rule style (`string`, default `consistent`)

This rule is triggered when inconsistent styles of horizontal rules are used
in the document:

```markdown
---

- - -

***

* * *

****
```

To fix this, ensure any horizontal rules used in the document are consistent,
or match the given style if the rule is so configured:

```markdown
---

---
```

Note: by default, this rule is configured to just require that all horizontal
rules in the document are the same and will trigger if any of the horizontal
rules are different than the first one encountered in the document. If you
want to configure the rule to match a specific style, the parameter given to
the 'style' option is a string containing the exact horizontal rule text that
is allowed.

Rationale: Consistent formatting makes it easier to understand a document.
