# `MD055` - Table pipe style

Tags: `table`

Aliases: `table-pipe-style`

Parameters:

- `style`: Table pipe style (`string`, default `consistent`, values
  `consistent` / `leading_and_trailing` / `leading_only` /
  `no_leading_or_trailing` / `trailing_only`)

This rule is triggered when a [GitHub Flavored Markdown table][gfm-table-055]
is inconsistent about its use of leading and trailing pipe characters (`|`).

By default (`consistent` style), the header row of the first table in a document
is used to determine the style that is enforced for all tables in that document.
A specific style can be required by setting the `style` parameter accordingly.

This table's header row has leading and trailing pipes, but its delimiter row is
missing the trailing pipe and its first row of cells is missing the leading
pipe:

```markdown
| Header | Header |
| ------ | ------
  Cell   | Cell   |
```

To fix these issues, make sure there is a pipe character at the beginning and
end of every row:

```markdown
| Header | Header |
| ------ | ------ |
| Cell   | Cell   |
```

Note that text immediately following a table (i.e., not separated by an empty
line) is treated as part of the table (per the specification) and may also
trigger this rule:

```markdown
| Header | Header |
| ------ | ------ |
| Cell   | Cell   |
This text is part of the table
```

Rationale: Some parsers have difficulty with tables that are missing their
leading or trailing pipe characters. The use of leading/trailing pipes can also
help provide visual clarity.

[gfm-table-055]: https://github.github.com/gfm/#tables-extension-
