/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.demo;

import com.github.lgooddatepicker.components.CalendarPanel;
import com.github.lgooddatepicker.components.DatePicker;
import com.github.lgooddatepicker.components.DatePickerSettings;
import com.github.lgooddatepicker.components.DateTimePicker;
import com.github.lgooddatepicker.components.TimePicker;
import com.github.lgooddatepicker.components.TimePickerSettings;
import com.github.lgooddatepicker.demo.TableEditorsDemo;
import com.github.lgooddatepicker.optionalusertools.CalendarBorderProperties;
import com.github.lgooddatepicker.optionalusertools.CalendarListener;
import com.github.lgooddatepicker.optionalusertools.DateChangeListener;
import com.github.lgooddatepicker.optionalusertools.DateHighlightPolicy;
import com.github.lgooddatepicker.optionalusertools.DateTimeChangeListener;
import com.github.lgooddatepicker.optionalusertools.DateVetoPolicy;
import com.github.lgooddatepicker.optionalusertools.PickerUtilities;
import com.github.lgooddatepicker.optionalusertools.TimeChangeListener;
import com.github.lgooddatepicker.optionalusertools.TimeVetoPolicy;
import com.github.lgooddatepicker.zinternaltools.CalendarSelectionEvent;
import com.github.lgooddatepicker.zinternaltools.DateChangeEvent;
import com.github.lgooddatepicker.zinternaltools.DateTimeChangeEvent;
import com.github.lgooddatepicker.zinternaltools.DemoPanel;
import com.github.lgooddatepicker.zinternaltools.HighlightInformation;
import com.github.lgooddatepicker.zinternaltools.InternalUtilities;
import com.github.lgooddatepicker.zinternaltools.TimeChangeEvent;
import com.github.lgooddatepicker.zinternaltools.WrapLayout;
import com.github.lgooddatepicker.zinternaltools.YearMonthChangeEvent;
import com.privatejgoodies.forms.factories.CC;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;

public class FullDemo {
    static JFrame frame;
    static DemoPanel panel;
    static DatePicker datePicker;
    static DatePicker datePicker1;
    static DatePicker datePicker2;
    static TimePicker timePicker;
    static TimePicker timePicker1;
    static TimePicker timePicker2;
    static DateTimePicker dateTimePicker1;
    static DateTimePicker dateTimePicker2;
    static DateTimePicker dateTimePicker3;
    static DateTimePicker dateTimePicker4;
    static DateTimePicker dateTimePicker5;
    static final int rowMultiplier = 4;

    public static void main(String[] args2) {
        frame = new JFrame();
        frame.setTitle("LGoodDatePicker Demo " + InternalUtilities.getProjectVersionString());
        frame.setDefaultCloseOperation(3);
        panel = new DemoPanel();
        frame.getContentPane().add(new JScrollPane(panel, 20, 30));
        FullDemo.createDemoButtons();
        int row = 4;
        LocalDate today = LocalDate.now();
        int pickerNumber = 0;
        datePicker1 = new DatePicker();
        FullDemo.panel.panel1.add((Component)datePicker1, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel1, 1, row++ * 4, "Date " + ++pickerNumber + ", Default Settings:");
        DatePickerSettings dateSettings = new DatePickerSettings();
        datePicker2 = new DatePicker(dateSettings);
        dateSettings.setHighlightPolicy(new SampleHighlightPolicy());
        FullDemo.panel.panel1.add((Component)datePicker2, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel1, 1, row++ * 4, "Date " + ++pickerNumber + ", Highlight Policy:");
        dateSettings = new DatePickerSettings();
        datePicker = new DatePicker(dateSettings);
        dateSettings.setVetoPolicy(new SampleDateVetoPolicy());
        FullDemo.panel.panel1.add((Component)datePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel1, 1, row++ * 4, "Date " + ++pickerNumber + ", Veto Policy:");
        dateSettings = new DatePickerSettings();
        datePicker = new DatePicker(dateSettings);
        dateSettings.setHighlightPolicy(new SampleHighlightPolicy());
        dateSettings.setVetoPolicy(new SampleDateVetoPolicy());
        FullDemo.panel.panel1.add((Component)datePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel1, 1, row++ * 4, "Date " + ++pickerNumber + ", Both Policies:");
        dateSettings = new DatePickerSettings();
        dateSettings.setVisibleDateTextField(false);
        dateSettings.setGapBeforeButtonPixels(0);
        datePicker = new DatePicker(dateSettings);
        FullDemo.panel.panel1.add((Component)datePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel1, 1, row++ * 4, "Date " + ++pickerNumber + ", Hidden text field (Showing button only):");
        dateSettings = new DatePickerSettings();
        datePicker = new DatePicker(dateSettings);
        dateSettings.setDateRangeLimits(today.minusDays(20L), today.plusDays(20L));
        FullDemo.panel.panel1.add((Component)datePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel1, 1, row++ * 4, "Date " + ++pickerNumber + ", Limit date range (+/- 20 days):");
        URL dateImageURL = FullDemo.class.getResource("/images/datepickerbutton1.png");
        Image dateExampleImage = Toolkit.getDefaultToolkit().getImage(dateImageURL);
        ImageIcon dateExampleIcon = new ImageIcon(dateExampleImage);
        dateSettings = new DatePickerSettings();
        datePicker = new DatePicker(dateSettings);
        datePicker.setDateToToday();
        JButton datePickerButton = datePicker.getComponentToggleCalendarButton();
        datePickerButton.setText("");
        datePickerButton.setIcon(dateExampleIcon);
        FullDemo.panel.panel1.add((Component)datePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel1, 1, row++ * 4, "Date " + ++pickerNumber + ", Custom Icon:");
        dateSettings = new DatePickerSettings();
        int newHeight = (int)((double)dateSettings.getSizeDatePanelMinimumHeight() * 1.6);
        int newWidth = (int)((double)dateSettings.getSizeDatePanelMinimumWidth() * 1.6);
        dateSettings.setSizeDatePanelMinimumHeight(newHeight);
        dateSettings.setSizeDatePanelMinimumWidth(newWidth);
        datePicker = new DatePicker(dateSettings);
        FullDemo.panel.panel1.add((Component)datePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel1, 1, row++ * 4, "Date " + ++pickerNumber + ", Change Calendar Size:");
        dateSettings = new DatePickerSettings();
        dateSettings.setWeekNumbersDisplayed(true, true);
        datePicker = new DatePicker(dateSettings);
        FullDemo.panel.panel1.add((Component)datePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel1, 1, row++ * 4, "Date " + ++pickerNumber + ", Show Week Numbers:");
        dateSettings = new DatePickerSettings();
        dateSettings.setWeekNumbersDisplayed(true, true);
        dateSettings.setColor(DatePickerSettings.DateArea.CalendarBackgroundNormalDates, Color.CYAN);
        dateSettings.setColor(DatePickerSettings.DateArea.BackgroundOverallCalendarPanel, Color.GREEN);
        dateSettings.setColor(DatePickerSettings.DateArea.BackgroundMonthAndYearMenuLabels, Color.YELLOW);
        dateSettings.setColor(DatePickerSettings.DateArea.BackgroundTodayLabel, Color.YELLOW);
        dateSettings.setColor(DatePickerSettings.DateArea.BackgroundClearLabel, Color.YELLOW);
        dateSettings.setColor(DatePickerSettings.DateArea.BackgroundMonthAndYearNavigationButtons, Color.CYAN);
        dateSettings.setColor(DatePickerSettings.DateArea.BackgroundTopLeftLabelAboveWeekNumbers, Color.ORANGE);
        dateSettings.setColor(DatePickerSettings.DateArea.CalendarBackgroundSelectedDate, Color.PINK);
        dateSettings.setColor(DatePickerSettings.DateArea.CalendarBorderSelectedDate, Color.WHITE);
        dateSettings.setColorBackgroundWeekdayLabels(Color.ORANGE, true);
        dateSettings.setColorBackgroundWeekNumberLabels(Color.ORANGE, true);
        Font randomFont = new Font("Monospaced", 3, 20);
        Font smallerFont = new Font("Serif", 1, 18);
        dateSettings.setFontMonthAndYearMenuLabels(randomFont);
        dateSettings.setFontMonthAndYearNavigationButtons(randomFont);
        dateSettings.setFontTodayLabel(randomFont);
        dateSettings.setFontClearLabel(randomFont);
        dateSettings.setFontCalendarDateLabels(randomFont);
        dateSettings.setFontCalendarWeekdayLabels(smallerFont);
        dateSettings.setFontCalendarWeekNumberLabels(smallerFont);
        dateSettings.setColor(DatePickerSettings.DateArea.TextMonthAndYearMenuLabels, Color.BLUE);
        dateSettings.setColor(DatePickerSettings.DateArea.TextMonthAndYearNavigationButtons, Color.BLUE);
        dateSettings.setColor(DatePickerSettings.DateArea.TextTodayLabel, Color.BLUE);
        dateSettings.setColor(DatePickerSettings.DateArea.TextClearLabel, Color.BLUE);
        dateSettings.setColor(DatePickerSettings.DateArea.CalendarTextNormalDates, Color.MAGENTA);
        dateSettings.setColor(DatePickerSettings.DateArea.CalendarTextWeekdays, Color.RED);
        dateSettings.setColor(DatePickerSettings.DateArea.CalendarTextWeekNumbers, Color.RED);
        dateSettings.setColor(DatePickerSettings.DateArea.BackgroundCalendarPanelLabelsOnHover, Color.BLUE);
        dateSettings.setColor(DatePickerSettings.DateArea.TextCalendarPanelLabelsOnHover, Color.YELLOW);
        datePicker = new DatePicker(dateSettings);
        FullDemo.panel.panel1.add((Component)datePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel1, 1, row++ * 4, "Date " + ++pickerNumber + ", Change Colors and Fonts:");
        dateSettings = new DatePickerSettings();
        dateSettings.setFontValidDate(new Font("Monospaced", 3, 17));
        dateSettings.setColor(DatePickerSettings.DateArea.DatePickerTextValidDate, new Color(0, 100, 0));
        datePicker = new DatePicker(dateSettings);
        datePicker.setDateToToday();
        FullDemo.panel.panel1.add((Component)datePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel1, 1, row++ * 4, "Date " + ++pickerNumber + ", Custom Font:");
        dateSettings = new DatePickerSettings();
        dateSettings.setFormatForDatesCommonEra("yyyy/MM/dd");
        dateSettings.setFormatForDatesBeforeCommonEra("uuuu/MM/dd");
        datePicker = new DatePicker(dateSettings);
        datePicker.setDateToToday();
        FullDemo.panel.panel1.add((Component)datePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel1, 1, row++ * 4, "Date " + ++pickerNumber + ", Custom Date Format:");
        dateSettings = new DatePickerSettings();
        dateSettings.setFormatForDatesCommonEra("d MMM yyyy");
        dateSettings.setFormatForDatesBeforeCommonEra("d MMM uuuu");
        datePicker = new DatePicker(dateSettings);
        datePicker.setDateToToday();
        FullDemo.panel.panel1.add((Component)datePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel1, 1, row++ * 4, "Date " + ++pickerNumber + ", Another Custom Date Format:");
        dateSettings = new DatePickerSettings();
        dateSettings.setFormatForDatesCommonEra("yyyyMMdd");
        dateSettings.setFormatForDatesBeforeCommonEra("uuuuMMdd");
        datePicker = new DatePicker(dateSettings);
        datePicker.setDateToToday();
        FullDemo.panel.panel1.add((Component)datePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel1, 1, row++ * 4, "Date " + ++pickerNumber + ", With a fixed length date format:");
        dateSettings = new DatePickerSettings();
        dateSettings.setFirstDayOfWeek(DayOfWeek.MONDAY);
        datePicker = new DatePicker(dateSettings);
        FullDemo.panel.panel1.add((Component)datePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel1, 1, row++ * 4, "Date " + ++pickerNumber + ", Set First Day Of Week (Mon):");
        dateSettings = new DatePickerSettings();
        dateSettings.setAllowEmptyDates(false);
        datePicker = new DatePicker(dateSettings);
        datePicker.addDateChangeListener(new SampleDateChangeListener("datePicker16 (Disallow Empty Dates or Null), "));
        FullDemo.panel.panel1.add((Component)datePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel1, 1, row++ * 4, "Date " + ++pickerNumber + ", Disallow Empty Dates:");
        dateSettings = new DatePickerSettings();
        dateSettings.setAllowKeyboardEditing(false);
        datePicker = new DatePicker(dateSettings);
        datePicker.setDateToToday();
        FullDemo.panel.panel1.add((Component)datePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel1, 1, row++ * 4, "Date " + ++pickerNumber + ", Disallow Keyboard Editing:");
        ArrayList<CalendarBorderProperties> borderProperties = new ArrayList<CalendarBorderProperties>();
        borderProperties.add(new CalendarBorderProperties(new Point(1, 1), new Point(5, 5), Color.YELLOW, 10));
        borderProperties.add(new CalendarBorderProperties(new Point(4, 1), new Point(4, 1), Color.YELLOW, 15));
        borderProperties.add(new CalendarBorderProperties(new Point(3, 3), new Point(5, 5), Color.GREEN, 10));
        borderProperties.add(new CalendarBorderProperties(new Point(3, 3), new Point(3, 3), Color.BLUE, 1));
        borderProperties.add(new CalendarBorderProperties(new Point(5, 3), new Point(5, 3), Color.BLUE, 1));
        dateSettings = new DatePickerSettings();
        dateSettings.setBorderPropertiesList(borderProperties);
        datePicker = new DatePicker(dateSettings);
        FullDemo.panel.panel1.add((Component)datePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel1, 1, row++ * 4, "Date " + ++pickerNumber + ", Custom Borders:");
        dateSettings = new DatePickerSettings();
        dateSettings.setWeekNumbersDisplayed(true, true);
        dateSettings.setBorderPropertiesList(borderProperties);
        datePicker = new DatePicker(dateSettings);
        FullDemo.panel.panel1.add((Component)datePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel1, 1, row++ * 4, "Date " + ++pickerNumber + ", Custom Borders with Week Numbers:");
        dateSettings = new DatePickerSettings();
        datePicker = new DatePicker(dateSettings);
        LocalDate startJuly = today.plusYears(1L);
        startJuly = startJuly.withMonth(7);
        startJuly = startJuly.withDayOfMonth(1);
        LocalDate endJuly = startJuly.withDayOfMonth(startJuly.lengthOfMonth());
        YearMonth yearMonthJuly = YearMonth.from(startJuly);
        dateSettings.setDefaultYearMonth(yearMonthJuly);
        dateSettings.setDateRangeLimits(startJuly.minusDays(10L), endJuly.plusDays(10L));
        FullDemo.panel.panel1.add((Component)datePicker, FullDemo.getConstraints(1, row * 4, 1));
        Checkbox enabledCheckbox = new Checkbox("enabled", true);
        FullDemo.panel.panel1.add((Component)enabledCheckbox, FullDemo.getConstraints(1, row * 4, 1, 13));
        panel.addLabel(FullDemo.panel.panel1, 1, row++ * 4, "<html>Date " + ++pickerNumber + ", Set Default YearMonth with Range<br>(July Next Year + 10 days.):</html>");
        FullDemo.registerEnabledCheckbox(enabledCheckbox, datePicker);
        dateSettings = new DatePickerSettings();
        datePicker = new DatePicker(dateSettings);
        dateSettings.setColor(DatePickerSettings.DateArea.TextFieldBackgroundValidDate, Color.cyan);
        dateSettings.setColor(DatePickerSettings.DateArea.TextFieldBackgroundDisabled, Color.blue);
        dateSettings.setColor(DatePickerSettings.DateArea.DatePickerTextDisabled, Color.yellow);
        FullDemo.panel.panel1.add((Component)datePicker, FullDemo.getConstraints(1, row * 4, 1));
        enabledCheckbox = new Checkbox("enabled", true);
        FullDemo.panel.panel1.add((Component)enabledCheckbox, FullDemo.getConstraints(1, row * 4, 1, 13));
        panel.addLabel(FullDemo.panel.panel1, 1, row++ * 4, "Date " + ++pickerNumber + ", Change the text field background color:");
        FullDemo.registerEnabledCheckbox(enabledCheckbox, datePicker);
        row = 4;
        timePicker1 = new TimePicker();
        FullDemo.panel.panel2.add((Component)timePicker1, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel2, 1, row++ * 4, "Time 1, Default Settings:");
        TimePickerSettings timeSettings = new TimePickerSettings();
        timeSettings.setDisplayToggleTimeMenuButton(false);
        timeSettings.setInitialTimeToNow();
        timePicker2 = new TimePicker(timeSettings);
        FullDemo.panel.panel2.add((Component)timePicker2, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel2, 1, row++ * 4, "Time 2, No Buttons:");
        timeSettings = new TimePickerSettings();
        timeSettings.setDisplayToggleTimeMenuButton(false);
        timeSettings.setDisplaySpinnerButtons(true);
        timeSettings.setInitialTimeToNow();
        timePicker = new TimePicker(timeSettings);
        FullDemo.panel.panel2.add((Component)timePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel2, 1, row++ * 4, "Time 3, With Spinner Buttons:");
        timeSettings = new TimePickerSettings();
        timeSettings.setDisplaySpinnerButtons(true);
        timeSettings.setInitialTimeToNow();
        timePicker = new TimePicker(timeSettings);
        FullDemo.panel.panel2.add((Component)timePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel2, 1, row++ * 4, "Time 4, With All Buttons:");
        timeSettings = new TimePickerSettings();
        timeSettings.use24HourClockFormat();
        timeSettings.initialTime = LocalTime.of(15, 30);
        timeSettings.generatePotentialMenuTimes(TimePickerSettings.TimeIncrement.FifteenMinutes, null, null);
        timePicker = new TimePicker(timeSettings);
        FullDemo.panel.panel2.add((Component)timePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel2, 1, row++ * 4, "Time 5, Interval 15 minutes, and 24 hour clock:");
        Locale chineseLocale = new Locale("zh");
        timeSettings = new TimePickerSettings(chineseLocale);
        timeSettings.initialTime = LocalTime.now();
        timePicker = new TimePicker(timeSettings);
        FullDemo.panel.panel2.add((Component)timePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel2, 1, row++ * 4, "Time 6, Localized (to Chinese):");
        URL timeIconURL = FullDemo.class.getResource("/images/timepickerbutton1.png");
        Image timeExampleImage = Toolkit.getDefaultToolkit().getImage(timeIconURL);
        ImageIcon timeExampleIcon = new ImageIcon(timeExampleImage);
        timeSettings = new TimePickerSettings();
        timeSettings.initialTime = LocalTime.of(15, 0);
        timePicker = new TimePicker(timeSettings);
        JButton timePickerButton = timePicker.getComponentToggleTimeMenuButton();
        timePickerButton.setText("");
        timePickerButton.setIcon(timeExampleIcon);
        Dimension newTimeButtonSize = new Dimension(timeExampleIcon.getIconWidth() + 4, timeExampleIcon.getIconHeight() + 4);
        timePickerButton.setPreferredSize(newTimeButtonSize);
        FullDemo.panel.panel2.add((Component)timePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel2, 1, row++ * 4, "Time 7, Custom Icon:");
        dateTimePicker1 = new DateTimePicker();
        FullDemo.panel.panel2.add((Component)dateTimePicker1, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel2, 1, row++ * 4, "DateTimePicker 1, Default settings:");
        dateSettings = new DatePickerSettings();
        timeSettings = new TimePickerSettings();
        dateSettings.setAllowEmptyDates(false);
        timeSettings.setAllowEmptyTimes(false);
        dateTimePicker2 = new DateTimePicker(dateSettings, timeSettings);
        FullDemo.panel.panel2.add((Component)dateTimePicker2, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel2, 1, row++ * 4, "DateTimePicker 2, Disallow empty dates and times:");
        dateTimePicker3 = new DateTimePicker();
        dateTimePicker3.addDateTimeChangeListener(new SampleDateTimeChangeListener("dateTimePicker3"));
        FullDemo.panel.panel2.add((Component)dateTimePicker3, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel2, 1, row++ * 4, "DateTimePicker 3, With Change Listener:");
        timeSettings = new TimePickerSettings();
        timeSettings.setAllowEmptyTimes(false);
        timePicker = new TimePicker(timeSettings);
        FullDemo.panel.panel2.add((Component)timePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel2, 1, row++ * 4, "Time 8, Disallow Empty Times:");
        timeSettings = new TimePickerSettings();
        timePicker = new TimePicker(timeSettings);
        timePicker.addTimeChangeListener(new SampleTimeChangeListener("timePicker7"));
        FullDemo.panel.panel2.add((Component)timePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel2, 1, row++ * 4, "Time 9, With a TimeChangeListener:");
        timeSettings = new TimePickerSettings();
        timeSettings.maximumVisibleMenuRows = 20;
        timePicker = new TimePicker(timeSettings);
        FullDemo.panel.panel2.add((Component)timePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel2, 1, row++ * 4, "Time 10, With 20 visible menu rows:");
        timeSettings = new TimePickerSettings();
        timeSettings.setFormatForDisplayTime("ha");
        timeSettings.setFormatForMenuTimes("ha");
        timeSettings.initialTime = LocalTime.of(15, 0);
        timeSettings.generatePotentialMenuTimes(TimePickerSettings.TimeIncrement.OneHour, null, null);
        timePicker = new TimePicker(timeSettings);
        FullDemo.panel.panel2.add((Component)timePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel2, 1, row++ * 4, "Time 11, Custom Format:");
        timeSettings = new TimePickerSettings();
        timePicker = new TimePicker(timeSettings);
        timeSettings.setVetoPolicy(new SampleTimeVetoPolicy());
        FullDemo.panel.panel2.add((Component)timePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel2, 1, row++ * 4, "Time 12, With Veto Policy (Only 9a-5p allowed):");
        timeSettings = new TimePickerSettings();
        timeSettings.setFormatForDisplayTime(PickerUtilities.createFormatterFromPatternString("HH:mm:ss", timeSettings.getLocale()));
        timeSettings.setFormatForMenuTimes(PickerUtilities.createFormatterFromPatternString("HH:mm", timeSettings.getLocale()));
        timeSettings.initialTime = LocalTime.of(15, 0, 0);
        timePicker = new TimePicker(timeSettings);
        FullDemo.panel.panel2.add((Component)timePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel2, 1, row++ * 4, "Time 13, Seconds precision (ISO format):");
        timeSettings = new TimePickerSettings();
        timeSettings.setFormatForDisplayTime(PickerUtilities.createFormatterFromPatternString("HH:mm:ss.SSS", timeSettings.getLocale()));
        timeSettings.setFormatForMenuTimes(PickerUtilities.createFormatterFromPatternString("HH:mm", timeSettings.getLocale()));
        timeSettings.initialTime = LocalTime.of(15, 0, 0, 999000000);
        timePicker = new TimePicker(timeSettings);
        FullDemo.panel.panel2.add((Component)timePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel2, 1, row++ * 4, "Time 14, Millisecond precision (ISO format):");
        timeSettings = new TimePickerSettings();
        DateTimeFormatter displayTimeFormatter = DateTimeFormatter.ISO_LOCAL_TIME;
        timeSettings.setFormatForDisplayTime(displayTimeFormatter);
        timeSettings.setFormatForMenuTimes(PickerUtilities.createFormatterFromPatternString("HH:mm", timeSettings.getLocale()));
        timeSettings.initialTime = LocalTime.of(15, 0, 0, 999999999);
        timePicker = new TimePicker(timeSettings);
        FullDemo.panel.panel2.add((Component)timePicker, FullDemo.getConstraints(1, row * 4, 1));
        enabledCheckbox = new Checkbox("enabled", true);
        FullDemo.panel.panel2.add((Component)enabledCheckbox, FullDemo.getConstraints(1, row * 4, 1, 13));
        panel.addLabel(FullDemo.panel.panel2, 1, row++ * 4, "<html>Time 15, Nanosecond precision:<br/>(ISO format. Use \".\" to type nanoseconds.)</html>");
        FullDemo.registerEnabledCheckbox(enabledCheckbox, timePicker);
        timeSettings = new TimePickerSettings();
        timeSettings.setColor(TimePickerSettings.TimeArea.TextFieldBackgroundValidTime, Color.cyan);
        timeSettings.setColor(TimePickerSettings.TimeArea.TextFieldBackgroundDisabled, Color.blue);
        timeSettings.setColor(TimePickerSettings.TimeArea.TimePickerTextDisabled, Color.yellow);
        timePicker = new TimePicker(timeSettings);
        FullDemo.panel.panel2.add((Component)timePicker, FullDemo.getConstraints(1, row * 4, 1));
        enabledCheckbox = new Checkbox("enabled", true);
        FullDemo.panel.panel2.add((Component)enabledCheckbox, FullDemo.getConstraints(1, row * 4, 1, 13));
        panel.addLabel(FullDemo.panel.panel2, 1, row++ * 4, "Time 16, custom backgroud color:");
        FullDemo.registerEnabledCheckbox(enabledCheckbox, timePicker);
        timeSettings = new TimePickerSettings();
        timeSettings.setAllowKeyboardEditing(false);
        timePicker = new TimePicker(timeSettings);
        FullDemo.panel.panel2.add((Component)timePicker, FullDemo.getConstraints(1, row * 4, 1));
        panel.addLabel(FullDemo.panel.panel2, 1, row++ * 4, "Time 17, Disallow Keyboard Editing:");
        int rowMarker = 0;
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Arabic:", "ar");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Bulgarian:", "bg");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Chinese:", "zh");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Czech:", "cs");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Danish:", "da");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Dutch:", "nl");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "English:", "en");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Finnish:", "fi");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "French:", "fr");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "German:", "de");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Greek:", "el");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Hindi:", "hi");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Italian:", "it");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Indonesian:", "in");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Japanese:", "ja");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Korean:", "ko");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Norwegian:", "no");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Polish:", "pl");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Portuguese:", "pt");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Romanian:", "ro");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Russian:", "ru");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Spanish:", "es");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Swedish:", "sv");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Turkish:", "tr");
        FullDemo.addLocalizedPickerAndLabel(++rowMarker, "Vietnamese:", "vi");
        DatePickerSettings settings2 = new DatePickerSettings();
        CalendarPanel calendarPanel = new CalendarPanel(settings2);
        calendarPanel.setSelectedDate(LocalDate.now());
        calendarPanel.addCalendarListener(new SampleCalendarListener());
        calendarPanel.setBorder(new LineBorder(Color.lightGray));
        FullDemo.panel.independentCalendarPanel.add((Component)calendarPanel, CC.xy(2, 2));
        frame.pack();
        frame.validate();
        int maxWidth = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().width;
        int maxHeight = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().height;
        frame.setSize(maxWidth / 4 * 3, maxHeight / 8 * 7);
        frame.setLocation(maxWidth / 8, maxHeight / 16);
        frame.setVisible(true);
    }

    private static void registerEnabledCheckbox(Checkbox cb, final Component managedComp) {
        cb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                managedComp.setEnabled(e.getStateChange() == 1);
            }
        });
    }

    private static GridBagConstraints getConstraints(int gridx, int gridy, int gridwidth) {
        return FullDemo.getConstraints(gridx, gridy, gridwidth, 17);
    }

    private static GridBagConstraints getConstraints(int gridx, int gridy, int gridwidth, int anchor) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 0;
        gc.anchor = anchor;
        gc.gridx = gridx;
        gc.gridy = gridy;
        gc.gridwidth = gridwidth;
        return gc;
    }

    private static void addLocalizedPickerAndLabel(int rowMarker, String labelText, String languageCode) {
        Locale locale = new Locale(languageCode);
        DatePickerSettings settings2 = new DatePickerSettings(locale);
        settings2.setSizeTextFieldMinimumWidth(125);
        settings2.setSizeTextFieldMinimumWidthDefaultOverride(true);
        DatePicker localizedDatePicker = new DatePicker(settings2);
        localizedDatePicker.setDateToToday();
        FullDemo.panel.panel4.add((Component)localizedDatePicker, FullDemo.getConstraints(1, rowMarker * 4, 1));
        panel.addLabel(FullDemo.panel.panel4, 1, rowMarker * 4, labelText);
    }

    private static void setTimeOneWithTimeTwoButtonClicked(ActionEvent e) {
        LocalTime timePicker2Time = timePicker2.getTime();
        timePicker1.setTime(timePicker2Time);
        String message = "The timePicker1 value was set using the timePicker2 value!\n\n";
        String timeString = timePicker1.getTimeStringOrSuppliedString("(null)");
        String messageAddition = "The timePicker1 value is currently set to: " + timeString + ".";
        FullDemo.panel.messageTextArea.setText(message + messageAddition);
    }

    private static void setTwoWithY2KButtonClicked(ActionEvent e) {
        LocalDate dateY2K = LocalDate.of(2000, Month.JANUARY, 1);
        datePicker2.setDate(dateY2K);
        String dateString = datePicker2.getDateStringOrSuppliedString("(null)");
        String message = "The datePicker2 date was set to New Years 2000!\n\n";
        message = message + "The datePicker2 date is currently set to: " + dateString + ".";
        FullDemo.panel.messageTextArea.setText(message);
    }

    private static void setOneWithTwoButtonClicked(ActionEvent e) {
        LocalDate datePicker2Date = datePicker2.getDate();
        datePicker1.setDate(datePicker2Date);
        String message = "The datePicker1 date was set using the datePicker2 date!\n\n";
        message = message + FullDemo.getDatePickerOneDateText();
        FullDemo.panel.messageTextArea.setText(message);
    }

    private static void setOneWithFeb31ButtonClicked(ActionEvent e) {
        datePicker1.setText("February 31, 1950");
        String message = "The datePicker1 text was set to: \"" + datePicker1.getText() + "\".\n";
        message = message + "Note: The stored date (the last valid date), did not change because February never has 31 days.\n\n";
        message = message + FullDemo.getDatePickerOneDateText();
        FullDemo.panel.messageTextArea.setText(message);
    }

    private static void getOneAndShowButtonClicked(ActionEvent e) {
        FullDemo.panel.messageTextArea.setText(FullDemo.getDatePickerOneDateText());
    }

    private static void clearOneAndTwoButtonClicked(ActionEvent e) {
        datePicker1.clear();
        datePicker2.clear();
        String message = "The datePicker1 and datePicker2 dates were cleared!\n\n";
        message = message + FullDemo.getDatePickerOneDateText() + "\n";
        String date2String = datePicker2.getDateStringOrSuppliedString("(null)");
        message = message + "The datePicker2 date is currently set to: " + date2String + ".";
        FullDemo.panel.messageTextArea.setText(message);
    }

    private static String getDatePickerOneDateText() {
        String dateString = datePicker1.getDateStringOrSuppliedString("(null)");
        return "The datePicker1 date is currently set to: " + dateString + ".";
    }

    private static void createDemoButtons() {
        JPanel buttonPanel = new JPanel(new WrapLayout());
        FullDemo.panel.scrollPaneForButtons.setViewportView(buttonPanel);
        JButton showIntro = new JButton("Show Introduction Message");
        showIntro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FullDemo.showIntroductionClicked(e);
            }
        });
        buttonPanel.add(showIntro);
        JButton setTwoWithY2K = new JButton("Set DatePicker Two with New Years Day 2000");
        setTwoWithY2K.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FullDemo.setTwoWithY2KButtonClicked(e);
            }
        });
        buttonPanel.add(setTwoWithY2K);
        JButton setDateOneWithTwo = new JButton("Set DatePicker One with the date in Two");
        setDateOneWithTwo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FullDemo.setOneWithTwoButtonClicked(e);
            }
        });
        buttonPanel.add(setDateOneWithTwo);
        JButton setOneWithFeb31 = new JButton("Set Text in DatePicker One to Feb 31, 1950");
        setOneWithFeb31.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FullDemo.setOneWithFeb31ButtonClicked(e);
            }
        });
        buttonPanel.add(setOneWithFeb31);
        JButton getOneAndShow = new JButton("Get and show the date in DatePicker One");
        getOneAndShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FullDemo.getOneAndShowButtonClicked(e);
            }
        });
        buttonPanel.add(getOneAndShow);
        JButton clearOneAndTwo = new JButton("Clear DatePickers One and Two");
        clearOneAndTwo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FullDemo.clearOneAndTwoButtonClicked(e);
            }
        });
        buttonPanel.add(clearOneAndTwo);
        JButton toggleButton = new JButton("Toggle DatePicker One");
        toggleButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FullDemo.toggleDateOneButtonClicked();
            }
        });
        buttonPanel.add(toggleButton);
        JButton setTimeOneWithTwo = new JButton("TimePickers: Set TimePicker One with the time in Two");
        setTimeOneWithTwo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FullDemo.setTimeOneWithTimeTwoButtonClicked(e);
            }
        });
        buttonPanel.add(setTimeOneWithTwo);
        JButton timeToggleButton = new JButton("Toggle TimePicker One");
        timeToggleButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FullDemo.toggleTimeOneButtonClicked();
            }
        });
        buttonPanel.add(timeToggleButton);
        JButton tableEditorsDemoButton = new JButton("Show TableEditorsDemo");
        tableEditorsDemoButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FullDemo.showTableEditorsDemoButtonClicked();
            }
        });
        buttonPanel.add(tableEditorsDemoButton);
        JButton showSystemInformationButton = new JButton("JDK Versions");
        showSystemInformationButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FullDemo.showSystemInformationButtonClicked();
            }
        });
        buttonPanel.add(showSystemInformationButton);
    }

    private static void showIntroductionClicked(ActionEvent e) {
        FullDemo.panel.messageTextArea.setText("Interface: \nMost items in a date picker are clickable. These include... The buttons for previous and next month, the buttons for previous and next year, the \"today\" text, the \"clear\" text, and individual dates. A click on the month or year label (at the top), will open a menu for changing the month or year.\n\nGeneral features: \n* Automatic internationalization. \n* Relatively compact source code.\n* Creating a DatePicker, TimePicker, or DateTimePicker requires only one line of code.\n* Open source code base.\n\nData types: \nThe standard Java 8 time library is used to store dates, and they are convertible to other data types. \n(The Java 8 time package is also called \"java.time\" or \"JSR-310\", and was developed by the author of Joda Time.)\n\nVeto and Highlight Policies: \nThese policies are optional. A veto policy restricts the dates that can be selected. A highlight policy provides a visual highlight on desired dates, with optional tooltips. If today is vetoed, the \"today\" button will be grey and disabled.\n\nDate values and automatic validation: \nEvery date picker stores its current text, and its last valid date. The last valid date is returned when you call DatePicker.getDate(). If the user types into the text field, any text that is not a valid date will be displayed in red, any vetoed date will have a strikethrough, and valid dates will display in black. When the focus on a date picker is lost, the text is always set to match the last valid date.\n\nTimePicker basic features: \nPressing the up or down arrow keys will change the displayed time by one minute. Holding down the arrow keys, or holding the (optional) timespinner buttons will change the time at an accelerating rate. Clicking the time drop down button (or pressing the right arrow key) will open a time selection menu. The default intervals and range in the time drop down menu may optionally be changed by the programmer (in the TimePickerSettings class).\n\n\n");
        FullDemo.panel.messageTextArea.setCaretPosition(0);
    }

    private static void toggleDateOneButtonClicked() {
        datePicker1.togglePopup();
        String message = "The datePicker1 calendar popup is ";
        message = message + (datePicker1.isPopupOpen() ? "open!" : "closed!");
        FullDemo.panel.messageTextArea.setText(message);
    }

    private static void toggleTimeOneButtonClicked() {
        timePicker1.togglePopup();
        String message = "The timePicker1 menu popup is ";
        message = message + (timePicker1.isPopupOpen() ? "open!" : "closed!");
        FullDemo.panel.messageTextArea.setText(message);
    }

    private static void showSystemInformationButtonClicked() {
        String runningJavaVersion = InternalUtilities.getJavaRunningVersionAsString();
        String targetJavaVersion = InternalUtilities.getJavaTargetVersionFromPom();
        String projectVersion = InternalUtilities.getProjectVersionString();
        boolean isBackport = "1.6".equals(targetJavaVersion);
        String message = "";
        message = message + "## Current configuration ##";
        message = message + "\nLGoodDatePicker version: \"LGoodDatePicker ";
        message = message + (isBackport ? "Backport " + projectVersion : projectVersion + " (Standard)");
        message = message + "\".";
        message = message + "\nJava target version: Java " + targetJavaVersion;
        message = message + "\nJava running version: " + runningJavaVersion;
        message = message + "\n\nMinimum Requirements:\n\"LGoodDatePicker Standard\" requires Java 1.8 (or above). \n\"LGoodDatePicker Backport\" requires Java 1.6 or 1.7.";
        FullDemo.panel.messageTextArea.setText(message);
    }

    private static void showTableEditorsDemoButtonClicked() {
        TableEditorsDemo.createAndShowTableDemoFrame();
    }

    private static class SampleCalendarListener
    implements CalendarListener {
        private SampleCalendarListener() {
        }

        @Override
        public void selectedDateChanged(CalendarSelectionEvent event) {
            LocalDate oldDate = event.getOldDate();
            LocalDate newDate = event.getNewDate();
            String oldDateString = PickerUtilities.localDateToString(oldDate, "(null)");
            String newDateString = PickerUtilities.localDateToString(newDate, "(null)");
            String messageStart = "\nIndependent Calendar Panel:";
            String messagePartTwo = " The selected date has changed from '";
            String fullMessage = messageStart + messagePartTwo + oldDateString + "' to '" + newDateString + "'. ";
            fullMessage = fullMessage + (event.isDuplicate() ? "(Event marked as duplicate.)" : "");
            if (!FullDemo.panel.messageTextArea.getText().startsWith(messageStart)) {
                FullDemo.panel.messageTextArea.setText("");
            }
            FullDemo.panel.messageTextArea.append(fullMessage);
        }

        @Override
        public void yearMonthChanged(YearMonthChangeEvent event) {
            YearMonth oldYearMonth = event.getOldYearMonth();
            YearMonth newYearMonth = event.getNewYearMonth();
            String oldYearMonthString = oldYearMonth.toString();
            String newYearMonthString = newYearMonth.toString();
            String messageStart = "\nIndependent Calendar Panel:";
            String messagePartTwo = " The displayed YearMonth has changed from '";
            String fullMessage = messageStart + messagePartTwo + oldYearMonthString + "' to '" + newYearMonthString + "'. ";
            fullMessage = fullMessage + (event.isDuplicate() ? "(Event marked as duplicate.)" : "");
            if (!FullDemo.panel.messageTextArea.getText().startsWith(messageStart)) {
                FullDemo.panel.messageTextArea.setText("");
            }
            FullDemo.panel.messageTextArea.append(fullMessage);
        }
    }

    private static class SampleTimeVetoPolicy
    implements TimeVetoPolicy {
        private SampleTimeVetoPolicy() {
        }

        @Override
        public boolean isTimeAllowed(LocalTime time) {
            return PickerUtilities.isLocalTimeInRange(time, LocalTime.of(9, 0), LocalTime.of(17, 0), true);
        }
    }

    private static class SampleTimeChangeListener
    implements TimeChangeListener {
        public String timePickerName;

        private SampleTimeChangeListener(String timePickerName) {
            this.timePickerName = timePickerName;
        }

        @Override
        public void timeChanged(TimeChangeEvent event) {
            LocalTime oldTime = event.getOldTime();
            LocalTime newTime = event.getNewTime();
            String oldTimeString = PickerUtilities.localTimeToString(oldTime, "(null)");
            String newTimeString = PickerUtilities.localTimeToString(newTime, "(null)");
            String messageStart = "\nThe time in " + this.timePickerName + " has changed from: ";
            String fullMessage = messageStart + oldTimeString + " to: " + newTimeString + ".";
            if (!FullDemo.panel.messageTextArea.getText().startsWith(messageStart)) {
                FullDemo.panel.messageTextArea.setText("");
            }
            FullDemo.panel.messageTextArea.append(fullMessage);
        }
    }

    private static class SampleHighlightPolicy
    implements DateHighlightPolicy {
        private SampleHighlightPolicy() {
        }

        @Override
        public HighlightInformation getHighlightInformationOrNull(LocalDate date) {
            if (date.getDayOfMonth() == 25) {
                return new HighlightInformation(Color.red, null, "It's the 25th!");
            }
            if (date.getDayOfWeek() == DayOfWeek.SATURDAY) {
                return new HighlightInformation(Color.orange, Color.yellow, "It's Saturday!");
            }
            if (date.getDayOfWeek() == DayOfWeek.SUNDAY) {
                return new HighlightInformation(null, null, "It's Sunday!");
            }
            return null;
        }
    }

    private static class SampleDateVetoPolicy
    implements DateVetoPolicy {
        private SampleDateVetoPolicy() {
        }

        @Override
        public boolean isDateAllowed(LocalDate date) {
            if (date.getDayOfMonth() >= 7 && date.getDayOfMonth() <= 11) {
                return false;
            }
            return date.getDayOfWeek() != DayOfWeek.SATURDAY || date.getDayOfMonth() % 2 != 1;
        }
    }

    private static class SampleDateTimeChangeListener
    implements DateTimeChangeListener {
        public String dateTimePickerName;

        private SampleDateTimeChangeListener(String dateTimePickerName) {
            this.dateTimePickerName = dateTimePickerName;
        }

        @Override
        public void dateOrTimeChanged(DateTimeChangeEvent event) {
            TimeChangeEvent timeEvent;
            String messageStart = "\n\nThe LocalDateTime in " + this.dateTimePickerName + " has changed from: (";
            String fullMessage = messageStart + event.getOldDateTimeStrict() + ") to (" + event.getNewDateTimeStrict() + ").";
            if (!FullDemo.panel.messageTextArea.getText().startsWith(messageStart)) {
                FullDemo.panel.messageTextArea.setText("");
            }
            FullDemo.panel.messageTextArea.append(fullMessage);
            DateChangeEvent dateEvent = event.getDateChangeEvent();
            if (dateEvent != null) {
                String dateChangeMessage = "\nThe DatePicker value has changed from (" + dateEvent.getOldDate() + ") to (" + dateEvent.getNewDate() + ").";
                FullDemo.panel.messageTextArea.append(dateChangeMessage);
            }
            if ((timeEvent = event.getTimeChangeEvent()) != null) {
                String timeChangeMessage = "\nThe TimePicker value has changed from (" + timeEvent.getOldTime() + ") to (" + timeEvent.getNewTime() + ").";
                FullDemo.panel.messageTextArea.append(timeChangeMessage);
            }
        }
    }

    private static class SampleDateChangeListener
    implements DateChangeListener {
        public String datePickerName;

        private SampleDateChangeListener(String datePickerName) {
            this.datePickerName = datePickerName;
        }

        @Override
        public void dateChanged(DateChangeEvent event) {
            LocalDate oldDate = event.getOldDate();
            LocalDate newDate = event.getNewDate();
            String oldDateString = PickerUtilities.localDateToString(oldDate, "(null)");
            String newDateString = PickerUtilities.localDateToString(newDate, "(null)");
            String messageStart = "\nThe date in " + this.datePickerName + " has changed from: ";
            String fullMessage = messageStart + oldDateString + " to: " + newDateString + ".";
            if (!FullDemo.panel.messageTextArea.getText().startsWith(messageStart)) {
                FullDemo.panel.messageTextArea.setText("");
            }
            FullDemo.panel.messageTextArea.append(fullMessage);
        }
    }
}

