/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens.installationcomponents;

import com.install4j.runtime.beans.screens.componentselection.ComponentFolderNode;
import com.install4j.runtime.beans.screens.componentselection.ComponentNode;
import com.install4j.runtime.beans.screens.componentselection.ComponentTree;
import com.install4j.runtime.beans.screens.componentselection.ComponentTreeModel;
import com.install4j.runtime.beans.screens.installationcomponents.InstallationComponentNode;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.ComponentFolderConfig;
import com.install4j.runtime.installer.config.ComponentNodeConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class InstallationComponentTreeModel
extends ComponentTreeModel {
    public InstallationComponentTreeModel(ComponentTree tree) {
        super(tree);
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.root;
        if (config != null) {
            this.addFolder(rootNode, config.getComponentRoot());
        } else {
            this.addDemoNode(rootNode, 1);
            this.addDemoNode(rootNode, 2);
            this.addDemoNode(rootNode, 3);
            this.addFolder(rootNode, new ComponentFolderConfig(null));
        }
    }

    public void addDemoNode(DefaultMutableTreeNode rootNode, int index) {
        ComponentConfig componentConfig = new ComponentConfig(null);
        componentConfig.setName("Installation component " + index);
        componentConfig.setDescription("This is the description for installation component " + index);
        componentConfig.setChangeable(true);
        componentConfig.setHideHelpButton(false);
        rootNode.add(new InstallationComponentNode(componentConfig, this));
    }

    public void checkFolders() {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.root;
        Enumeration<TreeNode> en = rootNode.depthFirstEnumeration();
        ArrayList<ComponentNode> nodesToHide = new ArrayList<ComponentNode>();
        while (en.hasMoreElements()) {
            ComponentNode node = (ComponentNode)en.nextElement();
            if (node.getComponentNodeConfig() == null) continue;
            if (node.getComponentNodeConfig().isHidden()) {
                nodesToHide.add(node);
                continue;
            }
            if (!(node instanceof ComponentFolderNode)) continue;
            ComponentFolderNode componentFolderNode = (ComponentFolderNode)node;
            ComponentFolderConfig componentFolderConfig = componentFolderNode.getComponentFolderConfig();
            if (componentFolderConfig.isExpanded()) {
                this.getTree().expandPath(new TreePath(node.getPath()));
            }
            componentFolderNode.checkState();
        }
        for (ComponentNode node : nodesToHide) {
            ((ComponentFolderNode)node.getParent()).hide(node);
        }
    }

    private void addFolder(DefaultMutableTreeNode parentNode, ComponentFolderConfig folderConfig) {
        for (ComponentNodeConfig componentNodeConfig : folderConfig.getComponents()) {
            ComponentNode childNode = null;
            if (componentNodeConfig instanceof ComponentFolderConfig) {
                ComponentFolderConfig childFolderConfig = (ComponentFolderConfig)componentNodeConfig;
                childNode = new ComponentFolderNode(childFolderConfig, (ComponentTreeModel)this);
                this.addFolder(childNode, childFolderConfig);
            } else if (componentNodeConfig instanceof ComponentConfig) {
                childNode = new InstallationComponentNode((ComponentConfig)componentNodeConfig, this);
            }
            if (childNode == null) continue;
            parentNode.add(childNode);
        }
    }
}

