/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.apiimpl;

import com.install4j.api.context.UserCanceledException;
import com.install4j.api.update.UpdateCheckRequest;
import com.install4j.api.update.UpdateDescriptor;
import com.install4j.runtime.installer.config.update.UpdateDescriptorImpl;
import com.install4j.runtime.installer.helper.content.Downloader;
import com.install4j.runtime.launcher.integration.UpdateLog;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class UpdateCheckerImpl {
    /*
     * Loose catch block
     */
    public static UpdateDescriptor getUpdateDescriptor(UpdateCheckRequest request) throws UserCanceledException, IOException {
        try (Downloader downloader = new Downloader(request.getApplicationDisplayMode().getIntValue(), null);){
            downloader.setAcceptAllCertificates(request.isAcceptAllCertificates());
            downloader.setConnectTimeout(request.getConnectTimeout());
            downloader.setReadTimeout(request.getReadTimeout());
            downloader.setErrorHandlingCallback(request.getErrorHandlingCallback());
            downloader.setRequestHeaders(request.getRequestHeaders());
            File tempFile = null;
            try {
                UpdateLog.log(10, "checking update at " + request.getUrlSpec());
                String urlSpec = request.getUrlSpec();
                tempFile = File.createTempFile("i4jupd", ".xml");
                downloader.connect(urlSpec).download(tempFile, -1L, true);
                UpdateDescriptorImpl updateDescriptor = new UpdateDescriptorImpl();
                updateDescriptor.read(tempFile, new URL(urlSpec));
                UpdateDescriptorImpl updateDescriptorImpl = updateDescriptor;
                return updateDescriptorImpl;
            }
            catch (Exception e) {
                UpdateLog.log(10, e);
                throw e;
            }
            finally {
                if (!Boolean.getBoolean("install4j.keepUpdateDescriptor") && tempFile != null) {
                    tempFile.delete();
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }
}

