/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.api.Util;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;

public class WinDarkModeDetector {
    public static boolean isDarkMode() {
        Object useLightTheme;
        if (!Util.isWindows()) {
            return false;
        }
        Object currentMajorVersion = WinRegistry.getValue(RegistryRoot.HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", "CurrentMajorVersionNumber");
        if (!(currentMajorVersion instanceof Number) || ((Number)currentMajorVersion).intValue() < 10) {
            return false;
        }
        Object releaseId = WinRegistry.getValue(RegistryRoot.HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", "ReleaseId");
        if (releaseId != null) {
            try {
                int intVal = Integer.parseInt(releaseId.toString());
                if (intVal > 0 && intVal < 1809) {
                    return false;
                }
            }
            catch (Throwable intVal) {
                // empty catch block
            }
        }
        if ((useLightTheme = WinRegistry.getValue(RegistryRoot.HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize", "AppsUseLightTheme")) instanceof Number) {
            return ((Number)useLightTheme).intValue() == 0;
        }
        return false;
    }
}

