/*
 * Decompiled with CFR 0.152.
 */
package mediathek;

import com.formdev.flatlaf.FlatLaf;
import com.sun.jna.platform.win32.VersionHelpers;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Taskbar;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Security;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javafx.application.Platform;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.RepaintManager;
import mediathek.SplashScreen;
import mediathek.config.Config;
import mediathek.config.Daten;
import mediathek.config.Konstanten;
import mediathek.config.MVConfig;
import mediathek.config.StandardLocations;
import mediathek.controller.history.SeenHistoryMigrator;
import mediathek.daten.IndexedFilmList;
import mediathek.gui.dialog.DialogStarteinstellungen;
import mediathek.javafx.AustrianVlcCheck;
import mediathek.javafx.tool.JFXHiddenApplication;
import mediathek.mac.MediathekGuiMac;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.DarkModeDetector;
import mediathek.tool.DarkModeFactory;
import mediathek.tool.FileUtils;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.LightModeFactory;
import mediathek.tool.Log4jShutdownCallbackRegistry;
import mediathek.tool.ReplaceList;
import mediathek.tool.RuntimeStatistics;
import mediathek.tool.SingleInstance;
import mediathek.tool.SwingErrorDialog;
import mediathek.tool.UIProgressState;
import mediathek.tool.affinity.Affinity;
import mediathek.tool.affinity.IAffinity;
import mediathek.tool.migrator.SettingsMigrator;
import mediathek.tool.swing.ThreadCheckingRepaintManager;
import mediathek.windows.MediathekGuiWindows;
import mediathek.x11.MediathekGuiX11;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AsyncAppender;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import picocli.CommandLine;

public class Main {
    private static final String MAC_SYSTEM_PROPERTY_APPLE_LAF_USE_SCREEN_MENU_BAR = "apple.laf.useScreenMenuBar";
    private static final Logger logger = LogManager.getLogger(Main.class);
    public static Optional<SplashScreen> splashScreen = Optional.empty();
    public static SingleInstance SINGLE_INSTANCE_WATCHER;

    private static void cleanupOsxFiles() {
        if (!Config.isPortableMode()) {
            try {
                Path oldFilmList = StandardLocations.getSettingsDirectory().resolve("filme.json");
                Files.deleteIfExists(oldFilmList);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void removeMediaDb() {
        try {
            Path mediaDbPath = StandardLocations.getSettingsDirectory().resolve("mediadb.txt");
            if (Files.exists(mediaDbPath, new LinkOption[0])) {
                logger.info("Moving old unsupported media database to trash.");
                FileUtils.moveToTrash(mediaDbPath);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void printJvmParameters() {
        logger.debug("=== JavaVM Parameter ===");
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> jvmArgs = runtimeMXBean.getInputArguments();
        for (String arg : jvmArgs) {
            logger.debug(arg);
        }
        logger.debug("========================");
    }

    private static void printArguments(String ... aArguments) {
        for (String argument : aArguments) {
            logger.info("Startparameter: {}", (Object)argument);
        }
    }

    private static void setupLogging() {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext(false);
        Configuration config = loggerContext.getConfiguration();
        String fileName = "/mediathekview.log";
        String path = !Config.isPortableMode() ? String.valueOf(StandardLocations.getSettingsDirectory()) + "/mediathekview.log" : Config.baseFilePath + "/mediathekview.log";
        PatternLayout consolePattern = Config.isEnhancedLoggingEnabled() || Config.isDebugModeEnabled() ? PatternLayout.newBuilder().withPattern("[%-5level] [%t] %c - %msg%n").build() : PatternLayout.newBuilder().withPattern(". %msg%n").build();
        ConsoleAppender consoleAppender = ConsoleAppender.createDefaultAppenderForLayout(consolePattern);
        if (!Config.isEnhancedLoggingEnabled() && !Config.isDebugModeEnabled()) {
            ThresholdFilter thresholdFilter = ThresholdFilter.createFilter(Level.INFO, Filter.Result.ACCEPT, Filter.Result.DENY);
            consoleAppender.addFilter(thresholdFilter);
        }
        consoleAppender.start();
        FileAppender.Builder fileAppenderBuilder = (FileAppender.Builder)((FileAppender.Builder)((AbstractAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((AbstractAppender.Builder)FileAppender.newBuilder()).setName("LogFile")).withAppend(false)).withFileName(path)).setLayout(PatternLayout.newBuilder().withPattern("%-5p %d  [%t] %C{2} (%F:%L) - %m%n").build())).setConfiguration(config);
        if (!Config.isEnhancedLoggingEnabled() && !Config.isDebugModeEnabled()) {
            ThresholdFilter thresholdFilter = ThresholdFilter.createFilter(Level.DEBUG, Filter.Result.ACCEPT, Filter.Result.DENY);
            fileAppenderBuilder.setFilter(thresholdFilter);
        }
        AsyncAppender asyncAppender = null;
        if (!Config.isFileLoggingDisabled()) {
            FileAppender fileAppender = fileAppenderBuilder.build();
            fileAppender.start();
            config.addAppender(fileAppender);
            asyncAppender = AsyncAppender.newBuilder().setName("Async").setAppenderRefs(new AppenderRef[]{AppenderRef.createAppenderRef(fileAppender.getName(), null, null)}).setConfiguration(config).setIncludeLocation(true).setBlocking(false).build();
            asyncAppender.start();
            config.addAppender(asyncAppender);
        }
        org.apache.logging.log4j.core.Logger rootLogger = loggerContext.getRootLogger();
        rootLogger.setLevel(Level.TRACE);
        rootLogger.addAppender(consoleAppender);
        if (!Config.isFileLoggingDisabled()) {
            rootLogger.addAppender(asyncAppender);
        }
        loggerContext.updateLoggers();
    }

    private static void setupEnvironmentProperties() {
        System.setProperty("file.encoding", "UTF-8");
        Security.setProperty("crypto.policy", "unlimited");
        if (SystemUtils.IS_OS_MAC_OSX) {
            System.setProperty("apple.awt.application.name", "MediathekView");
            System.setProperty("apple.awt.application.appearance", "system");
        }
    }

    private static void printVersionInformation() {
        logger.info("Programmstart: {}", (Object)DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(RuntimeStatistics.startZeit));
        logger.info("Version: {}", (Object)Konstanten.MVVERSION);
        logger.info("=== Java Information ===");
        logger.info("Vendor: {}", (Object)SystemUtils.JAVA_VENDOR);
        logger.info("VMname: {}", (Object)SystemUtils.JAVA_VM_NAME);
        logger.info("Version: {}", (Object)SystemUtils.JAVA_VERSION);
        logger.info("Runtime Version: {}", (Object)SystemUtils.JAVA_RUNTIME_VERSION);
        Runtime runtime = Runtime.getRuntime();
        logger.info("Maximum Memory: {} MB", (Object)(runtime.maxMemory() / 0x100000L));
        logger.info("Operating System: {}", (Object)SystemUtils.OS_NAME);
        logger.info("OS Version: {}", (Object)SystemUtils.OS_VERSION);
        logger.info("OS Arch: {}", (Object)SystemUtils.OS_ARCH);
        if (DarkModeDetector.hasDarkModeDetectionSupport()) {
            logger.info("OS Dark Mode enabled: {}", (Object)DarkModeDetector.isDarkMode());
        } else {
            logger.info("OS Dark Mode detection not supported");
        }
        logger.info("OS Available Processors: {}", (Object)runtime.availableProcessors());
    }

    private static void migrateOldConfigSettings() {
        String settingsDir = StandardLocations.getSettingsDirectory().toString();
        if (!settingsDir.isEmpty()) {
            Path pSettingsDir = Paths.get(settingsDir, new String[0]);
            if (Files.exists(pSettingsDir, new LinkOption[0])) {
                Path settingsFile = pSettingsDir.resolve("mediathek.xml");
                if (Files.exists(settingsFile, new LinkOption[0])) {
                    logger.trace("migrating old config settings {}", (Object)settingsFile.toAbsolutePath().toString());
                    try {
                        SettingsMigrator migrator = new SettingsMigrator(settingsFile);
                        migrator.migrate();
                    }
                    catch (Exception e) {
                        logger.error("settings migration error", (Throwable)e);
                    }
                }
            } else {
                logger.trace("nothing to migrate");
            }
        }
    }

    private static void printPortableModeInfo() {
        if (Config.isPortableMode()) {
            logger.info("Configuring baseFilePath {} for portable mode", (Object)Config.baseFilePath);
        } else {
            logger.info("Configuring for non-portable mode");
        }
    }

    private static void setupCpuAffinity() {
        int numCpus = Config.getNumCpus();
        if (numCpus != 0) {
            IAffinity affinity = Affinity.getAffinityImpl();
            affinity.setDesiredCpuAffinity(numCpus);
        }
    }

    private static void setupDockIcon() {
        try {
            URL url;
            Taskbar taskbar;
            if (Taskbar.isTaskbarSupported() && (taskbar = Taskbar.getTaskbar()).isSupported(Taskbar.Feature.ICON_IMAGE) && (url = Main.class.getResource("/mediathek/res/MediathekView.png")) != null) {
                BufferedImage appImage = ImageIO.read(url);
                Taskbar.getTaskbar().setIconImage(appImage);
            }
        }
        catch (IOException ex) {
            logger.error("OS X Application image could not be loaded", (Throwable)ex);
        }
    }

    private static void setupFlatLaf() {
        boolean darkMode = ApplicationConfiguration.getConfiguration().getBoolean("application.dark_mode", false);
        LookAndFeel laf = darkMode ? DarkModeFactory.getLookAndFeel() : LightModeFactory.getLookAndFeel();
        FlatLaf.setup(laf);
    }

    private static void checkJVMSettings() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        boolean correctParameters = false;
        List<String> paramList = runtimeMXBean.getInputArguments();
        long useShenandoahGC = paramList.stream().filter(s2 -> s2.equalsIgnoreCase("-XX:+UseShenandoahGC")).findAny().stream().count();
        long shenandoahHeuristics = paramList.stream().filter(s2 -> s2.equalsIgnoreCase("-XX:ShenandoahGCHeuristics=compact")).findAny().stream().count();
        long stringDedup = paramList.stream().filter(s2 -> s2.equalsIgnoreCase("-XX:+UseStringDeduplication")).findAny().stream().count();
        long maxRamPct = paramList.stream().filter(s2 -> s2.startsWith("-XX:MaxRAMPercentage=")).findAny().stream().count();
        long addOpens = paramList.stream().filter(s2 -> s2.equalsIgnoreCase("--add-opens=java.desktop/sun.awt.X11=ALL-UNNAMED")).findAny().stream().count();
        long mxParamCount = paramList.stream().filter(s2 -> s2.startsWith("-Xmx")).findAny().stream().count();
        if (useShenandoahGC > 0L && shenandoahHeuristics > 0L && stringDedup > 0L && maxRamPct > 0L && mxParamCount == 0L) {
            correctParameters = true;
        }
        if (SystemUtils.IS_OS_LINUX && addOpens == 0L) {
            correctParameters = false;
        }
        if (!correctParameters) {
            logger.warn("Detected incorrect JVM parameters! Please modify your settings");
            Object message = "<html><b>Inkorrekte/fehlende JVM Parameter erkannt</b><br/><br/>Bitte stellen Sie sicher, dass die folgenden Parameter an die JVM \u00fcbergeben werden:<br/><ul><li>-XX:+UseShenandoahGC</li><li>-XX:ShenandoahGCHeuristics=compact</li><li>-XX:+UseStringDeduplication</li><li>-XX:MaxRAMPercentage=<b>XX.X</b></li>";
            if (SystemUtils.IS_OS_LINUX) {
                message = (String)message + "<li><b>--add-opens=java.desktop/sun.awt.X11=ALL-UNNAMED</b></li>";
            }
            message = (String)message + "</ul><br/><b>-Xmx</b> sollte nicht mehr genutzt werden!</html>";
            JOptionPane.showMessageDialog(null, message, "MediathekView", 2);
        }
    }

    private static void checkUiScaleSetting() {
        String strScale = System.getProperty("sun.java2d.uiScale");
        if (strScale != null) {
            try {
                Integer.parseInt(strScale);
            }
            catch (NumberFormatException ex) {
                float scaleFactor = Float.parseFloat(strScale);
                System.out.println("uiScale factor: " + scaleFactor);
                int newScale = Math.round(scaleFactor);
                System.out.println("new scale: " + newScale);
                JOptionPane.showMessageDialog(null, "<html>Sie verwenden den Parameter <i>-Dsun.java2d.uiScale=" + strScale + "</i>.<br><b>Java unter Linux unterst\u00fctzt nur ganzzahlige Skalierung!</b><br><br>Sie sollten <i>-Dsun.java2d.uiScale=" + newScale + "</i> oder gr\u00f6\u00dfer verwenden falls die Schriftgr\u00f6\u00dfe zu klein ist.", "MediathekView", 2);
            }
        }
    }

    public static void main(String ... args2) {
        if (GraphicsEnvironment.isHeadless()) {
            System.err.println("Diese Version von MediathekView unterst\u00fctzt keine Kommandozeilenausf\u00fchrung.");
            System.exit(1);
        }
        Main.setupEnvironmentProperties();
        EventQueue.invokeLater(() -> {
            CommandLine cmd = new CommandLine(Config.class);
            try {
                CommandLine.ParseResult parseResult = cmd.parseArgs(args2);
                if (parseResult.isUsageHelpRequested()) {
                    cmd.usage(System.out);
                    System.exit(cmd.getCommandSpec().exitCodeOnUsageHelp());
                }
                Config.setPortableMode(parseResult.hasMatchedPositional(0));
                if (Config.isPortableMode()) {
                    StandardLocations.INSTANCE.setPortableBaseDirectory(Config.baseFilePath);
                }
                Main.setupLogging();
                Main.printPortableModeInfo();
                Main.setupDockIcon();
                Main.setupFlatLaf();
                if (SystemUtils.IS_OS_LINUX) {
                    Main.checkUiScaleSetting();
                }
                if (!Config.isDisableJvmParameterChecks()) {
                    Main.checkJVMSettings();
                }
                if (SystemUtils.IS_OS_WINDOWS && !VersionHelpers.IsWindows10OrGreater()) {
                    logger.warn("This Operating System configuration is too old and will be unsupported in the next updates.");
                }
                Main.setupCpuAffinity();
                Platform.setImplicitExit(false);
                Main.removeMediaDb();
                Main.deleteOldFilmDatabaseFiles();
                Main.deleteOldUserAgentsDatabase();
                JFXHiddenApplication.launchApplication();
                Main.checkMemoryRequirements();
                Main.installSingleInstanceHandler();
                Main.printVersionInformation();
                Main.printJvmParameters();
                Main.printArguments(args2);
            }
            catch (CommandLine.ParameterException ex) {
                try (PrintWriter err = cmd.getErr();){
                    String errStr = ex.getMessage() + "\n\n" + ex.getCommandLine().getUsageMessage();
                    JOptionPane.showMessageDialog(null, errStr, "Fehlerhafte Kommandozeilenparameter", 0);
                    err.println(ex.getMessage());
                    if (!CommandLine.UnmatchedArgumentException.printSuggestions(ex, err)) {
                        ex.getCommandLine().usage(err);
                    }
                    System.exit(cmd.getCommandSpec().exitCodeOnInvalidInput());
                }
            }
            catch (Exception ex) {
                logger.error("Command line parse error:", (Throwable)ex);
                System.exit(cmd.getCommandSpec().exitCodeOnExecutionException());
            }
            Main.printDirectoryPaths();
            if (!Main.isDebuggerAttached()) {
                if (!Config.isSplashScreenDisabled()) {
                    splashScreen = Optional.of(new SplashScreen());
                } else {
                    logger.warn("Splash screen disabled...");
                }
            } else {
                logger.warn("Debugger detected -> Splash screen disabled...");
            }
            splashScreen.ifPresent(splash -> splash.setVisible(true));
            Main.migrateOldConfigSettings();
            Main.loadConfigurationData();
            Main.migrateSeenHistory();
            Daten.getInstance().launchHistoryDataLoading();
            Daten.getInstance().loadBookMarkData();
            boolean useModernSearch = ApplicationConfiguration.getConfiguration().getBoolean("application.use.modern_search", false);
            if (useModernSearch) {
                Daten.getInstance().setListeFilmeNachBlackList(new IndexedFilmList());
            }
            Main.startGuiMode();
        });
    }

    private static boolean isDebuggerAttached() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
    }

    private static void migrateSeenHistory() {
        try (SeenHistoryMigrator migrator = new SeenHistoryMigrator();){
            if (migrator.needsMigration()) {
                migrator.migrate();
            }
        }
        catch (Exception e) {
            logger.error("migrateSeenHistory", (Throwable)e);
            splashScreen.ifPresent(SplashScreen::close);
            SwingErrorDialog.showExceptionMessage(null, "<html>Bei der Migration der Historie der Filme ist ein Fehler aufgetreten.<br>\nDas Programm kann nicht fortfahren und wird beendet.<br><br>\nBitte \u00fcberpr\u00fcfen Sie die Fehlermeldung und suchen Sie Hilfe im Forum.</html>\n", e);
            System.exit(99);
        }
    }

    private static void loadConfigurationData() {
        Daten daten = Daten.getInstance();
        if (!daten.allesLaden()) {
            ReplaceList.init();
            splashScreen.ifPresent(SplashScreen::close);
            DialogStarteinstellungen dialog = new DialogStarteinstellungen(null);
            if (dialog.showDialog() == DialogStarteinstellungen.ResultCode.CANCELLED) {
                JOptionPane.showMessageDialog(null, "<html>Sie haben die Einrichtung des Programms abgebrochen.<br>MediathekView muss deshalb beendet werden.</html>", "MediathekView", 0);
                Main.deleteSettingsDirectory();
                System.exit(1);
            }
            MVConfig.loadSystemParameter();
        }
    }

    private static void deleteOldUserAgentsDatabase() {
        try {
            Path settingsPath = StandardLocations.getSettingsDirectory();
            Path agentDb = settingsPath.resolve("user_agents.mv.db");
            Files.deleteIfExists(agentDb);
        }
        catch (IOException e) {
            logger.error("Error deleting old user agent database occured", (Throwable)e);
        }
    }

    private static void deleteOldFilmDatabaseFiles() {
        Path settingsPath = StandardLocations.getSettingsDirectory();
        Path dbFolder = settingsPath.resolve("database");
        Path traceFile = settingsPath.resolve("databasemediathekview.trace.db");
        if (!Files.exists(dbFolder, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> walk = Files.walk(dbFolder, new FileVisitOption[0]);){
            walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            Files.deleteIfExists(traceFile);
        }
        catch (Exception ex) {
            logger.error("Got an error deleting old database directory", (Throwable)ex);
        }
    }

    private static void deleteSettingsDirectory() {
        try (Stream<Path> walk = Files.walk(StandardLocations.getSettingsDirectory(), new FileVisitOption[0]);){
            walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (Exception ex) {
            logger.error("Got an error deleting settings directory", (Throwable)ex);
        }
    }

    private static void printDirectoryPaths() {
        logger.trace("Programmpfad: " + GuiFunktionenProgramme.getPathToApplicationJar());
        logger.info("Verzeichnis Einstellungen: " + String.valueOf(StandardLocations.getSettingsDirectory()));
    }

    private static void installSingleInstanceHandler() {
        SINGLE_INSTANCE_WATCHER = new SingleInstance();
        if (SINGLE_INSTANCE_WATCHER.isAppAlreadyActive()) {
            JOptionPane.showMessageDialog(null, "Es d\u00fcrfen nicht mehrere MediathekView-Instanzen gleichzeitig laufen.\nBitte beenden Sie zuerst das andere Programm.", "MediathekView", 0);
            System.exit(1);
        }
    }

    private static void checkForOfficialOSXAppUse() {
        String osxOfficialApp = System.getProperty("OSX_OFFICIAL_APP");
        if (osxOfficialApp == null || osxOfficialApp.isEmpty() || osxOfficialApp.equalsIgnoreCase("false")) {
            logger.warn("WARN: macOS app NOT launched from official launcher!");
        }
    }

    private static void checkMemoryRequirements() {
        long maxMem = Runtime.getRuntime().maxMemory();
        if (maxMem < 0x30000000L) {
            JOptionPane.showMessageDialog(null, "Es werden mindestens 768MB RAM zum Betrieb ben\u00f6tigt.\nDas Programm wird nun beendet.", "MediathekView", 0);
            System.exit(3);
        }
    }

    private static void startGuiMode() {
        splashScreen.ifPresent(s2 -> s2.update(UIProgressState.INIT_FX));
        splashScreen.ifPresent(s2 -> s2.update(UIProgressState.FILE_CLEANUP));
        if (SystemUtils.IS_OS_MAC_OSX) {
            Main.checkForOfficialOSXAppUse();
            System.setProperty(MAC_SYSTEM_PROPERTY_APPLE_LAF_USE_SCREEN_MENU_BAR, Boolean.TRUE.toString());
            Main.cleanupOsxFiles();
        }
        if (Config.isDebugModeEnabled() || Config.isInstallThreadCheckingRepaintManager()) {
            RepaintManager.setCurrentManager(new ThreadCheckingRepaintManager());
            logger.info("Swing Thread checking repaint manager installed.");
        }
        splashScreen.ifPresent(s2 -> s2.update(UIProgressState.START_UI));
        MediathekGui window = Main.getPlatformWindow();
        splashScreen.ifPresent(SplashScreen::close);
        window.setVisible(true);
        if (!SystemUtils.IS_OS_MAC_OSX) {
            window.toFront();
            window.requestFocus();
        }
        AustrianVlcCheck vlcCheck = new AustrianVlcCheck();
        vlcCheck.perform();
    }

    private static MediathekGui getPlatformWindow() {
        MediathekGui window = null;
        if (SystemUtils.IS_OS_MAC_OSX) {
            window = new MediathekGuiMac();
        } else if (SystemUtils.IS_OS_WINDOWS) {
            window = new MediathekGuiWindows();
        } else if (SystemUtils.IS_OS_LINUX) {
            window = new MediathekGuiX11();
        } else {
            JOptionPane.showMessageDialog(null, "Sie f\u00fchren MediathekView auf einem nicht unterst\u00fctzten Betriebssystem aus.\nEs werden nur macOS, Windows und Linux unterst\u00fctzt.\n\nDas Programm wird beendet, da die Funktionsf\u00e4higkeit nicht gew\u00e4hrleistet werden kann.", "MediathekView", 0);
            System.exit(2);
        }
        return window;
    }

    static {
        System.setProperty("log4j.shutdownCallbackRegistry", Log4jShutdownCallbackRegistry.class.getName());
    }
}

