/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.bookmark;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javax.swing.SwingUtilities;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.javafx.IconNode;
import mediathek.config.Daten;
import mediathek.config.MVColor;
import mediathek.config.MVConfig;
import mediathek.config.StandardLocations;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.gui.actions.UrlHyperlinkAction;
import mediathek.gui.dialog.DialogAddMoreDownload;
import mediathek.gui.messages.DownloadListChangedEvent;
import mediathek.gui.tabs.tab_film.GuiFilme;
import mediathek.javafx.bookmark.BookmarkData;
import mediathek.javafx.bookmark.BookmarkDataList;
import mediathek.javafx.bookmark.BookmarkDateComparator;
import mediathek.javafx.bookmark.BookmarkNoteDialog;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.javafx.tool.TableViewColumnContextMenuHelper;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.MVC;
import mediathek.tool.MessageBus;
import mediathek.tool.TimerPool;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;

public class BookmarkWindowController
implements Initializable {
    private Stage stage;
    private final BookmarkDataList listeBookmarkList;
    private FilteredList<BookmarkData> filteredBookmarkList;
    private Color ColorExpired;
    private Background BackgroundSeen;
    private Background BackgroundSelected;
    private final SeenHistoryController history = new SeenHistoryController();
    private MenuItem playitem;
    private MenuItem loaditem;
    private MenuItem deleteitem;
    private MenuItem viewitem;
    private MenuItem webitem;
    private MenuItem ccopyitem;
    private MenuItem edititem;
    private ContextMenu cellContextMenu;
    private GuiFilme infotab;
    private double divposition;
    private boolean listUpdated = false;
    private ScheduledFuture<?> SaveBookmarkTask;
    private int FilterState;
    @FXML
    private Button btnSaveList;
    @FXML
    private Button btnDeleteEntry;
    @FXML
    private Button btnMarkViewed;
    @FXML
    private ToggleButton btnShowDetails;
    @FXML
    private Button btnFilter;
    @FXML
    private Button btnEditNote;
    @FXML
    private TableView<BookmarkData> tbBookmarks;
    @FXML
    private TableColumn<BookmarkData, String> colSender;
    @FXML
    private TableColumn<BookmarkData, String> colTheme;
    @FXML
    private TableColumn<BookmarkData, String> colTitle;
    @FXML
    private TableColumn<BookmarkData, String> colDuration;
    @FXML
    private TableColumn<BookmarkData, String> colRunDate;
    @FXML
    private TableColumn<BookmarkData, String> colUrl;
    @FXML
    private TableColumn<BookmarkData, String> colBtnPlay;
    @FXML
    private TableColumn<BookmarkData, String> colBtnDownload;
    @FXML
    private TableColumn<BookmarkData, String> colNote;
    @FXML
    private TableColumn<BookmarkData, String> colExpiry;
    @FXML
    private Label lblCount;
    @FXML
    private Label lblSeen;
    @FXML
    private Label lblMessage;
    @FXML
    private Label lblFilter;
    @FXML
    private TextArea taDescription;
    @FXML
    private SplitPane spSplitPane;
    @FXML
    private Hyperlink hyperLink;
    private static final String[] BTNFILTER_TOOLTIPTEXT = new String[]{"Nur ungesehene Filme anzeigen", "Nur gesehene Filme anzeigen", "Alle Filme anzeigen"};
    private static final String[] LBLFILTER_MESSAGETEXT = new String[]{"", "Ungesehene Filme", "Gesehene Filme"};
    private static final boolean[] LBLSEEN_DISABLE = new boolean[]{false, true, false};
    private static final String ALERT_TITLE = "Merkliste";

    public BookmarkWindowController() {
        this.listeBookmarkList = Daten.getInstance().getListeBookmarkList();
    }

    @FXML
    private void btnMarkEntryAsViewed(Event e) {
        ObservableList selections = this.tbBookmarks.getSelectionModel().getSelectedItems();
        if (!selections.isEmpty()) {
            boolean hasUnSeen = this.isUnSeenSelected();
            ArrayList bookmarks = new ArrayList(selections);
            ArrayList filmlist = new ArrayList();
            bookmarks.forEach(data -> {
                data.setSeen(hasUnSeen);
                DatenFilm film = data.getDatenFilm();
                if (film != null) {
                    filmlist.add(film);
                }
            });
            if (hasUnSeen) {
                this.history.markSeen(filmlist);
            } else {
                this.history.markUnseen(filmlist);
            }
            this.setSeenButtonState(hasUnSeen, selections.size() > 1);
            this.tbBookmarks.getSelectionModel().clearSelection();
            bookmarks.forEach(data -> this.tbBookmarks.getSelectionModel().select(data));
        }
    }

    @FXML
    private void btnSaveBookMarkList(Event e) {
        this.cancelBookmarkSave();
        this.saveBookMarkList();
    }

    @FXML
    private void btnDeleteEntry(Event e) {
        ArrayList selections = new ArrayList(this.tbBookmarks.getSelectionModel().getSelectedItems());
        if (!selections.isEmpty()) {
            this.listeBookmarkList.deleteEntries(this.tbBookmarks.getSelectionModel().getSelectedItems());
            this.updateDisplay();
            this.tbBookmarks.getSelectionModel().clearSelection();
            this.infotab.repaint();
        }
    }

    @FXML
    private void btnEditNote(Event e) {
        Stage dlgstage = new Stage();
        dlgstage.initModality(Modality.WINDOW_MODAL);
        dlgstage.initOwner(this.stage);
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/mediathek/res/programm/fxml/bookmarkNoteDialog.fxml"));
            BookmarkNoteDialog bdialog = new BookmarkNoteDialog();
            fxmlLoader.setController(bdialog);
            Scene scene = new Scene((Parent)fxmlLoader.load());
            scene.getStylesheets().add(this.getClass().getResource("/mediathek/res/css/bookmarkNoteDialog.css").toExternalForm());
            dlgstage.getIcons().add(new Image("/mediathek/res/MediathekView.png"));
            dlgstage.setScene(scene);
            if (bdialog.SetandShow(dlgstage, (BookmarkData)this.tbBookmarks.getSelectionModel().getSelectedItem())) {
                this.listUpdated = true;
                this.refresh();
            }
        }
        catch (IOException ex) {
            LogManager.getLogger(BookmarkWindowController.class).error("{} Can't find/load the FXML description! Exception - {}", (Object)this.getClass(), (Object)ex.toString());
        }
    }

    @FXML
    private void hyperLinkSelected(Event e) {
        String url = ((BookmarkData)this.tbBookmarks.getSelectionModel().getSelectedItem()).getWebUrl();
        try {
            if (url != null) {
                UrlHyperlinkAction.openURL(null, url);
            }
        }
        catch (URISyntaxException ex) {
            LogManager.getLogger(BookmarkWindowController.class).error("{} Hyperlink Syntax exception - {}", (Object)this.getClass(), (Object)ex.toString());
        }
    }

    private void copy2Clipboard(Event e) {
        TablePosition pos = (TablePosition)this.tbBookmarks.getSelectionModel().getSelectedCells().get(0);
        BookmarkData item = (BookmarkData)this.tbBookmarks.getItems().get(pos.getRow());
        String data = (String)((TableColumn)pos.getTableColumn()).getCellObservableValue(item).getValue();
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(data), null);
    }

    @Override
    public void initialize(URL arg0, ResourceBundle arg1) {
        this.restoreTableStateAndContextMenu();
        this.colSender.setCellValueFactory(new PropertyValueFactory("sender"));
        this.colTheme.setCellValueFactory(new PropertyValueFactory("thema"));
        this.colTitle.setCellValueFactory(new PropertyValueFactory("titel"));
        this.colDuration.setCellValueFactory(new PropertyValueFactory("dauer"));
        this.colRunDate.setCellValueFactory(new PropertyValueFactory("sendDate"));
        this.colRunDate.setComparator(new BookmarkDateComparator());
        this.colUrl.setCellValueFactory(new PropertyValueFactory("url"));
        this.colNote.setCellValueFactory(new PropertyValueFactory("note"));
        this.colExpiry.setCellValueFactory(new PropertyValueFactory("expiry"));
        this.colExpiry.setComparator(new BookmarkDateComparator());
        this.colBtnPlay.setCellFactory(UNUSED -> new TableCell<BookmarkData, String>(){

            @Override
            public void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (empty || ((BookmarkData)this.getTableView().getItems().get(this.getIndex())).isNotInFilmList()) {
                    this.setGraphic(null);
                } else {
                    this.setGraphic(new IconNode(FontAwesome.PLAY));
                    this.setOnMouseClicked(UNUSED -> BookmarkWindowController.this.playAction((BookmarkData)this.getTableView().getItems().get(this.getIndex())));
                }
            }
        });
        this.colBtnDownload.setCellFactory(UNUSED -> new TableCell<BookmarkData, String>(){

            @Override
            public void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (empty || !((BookmarkData)this.getTableView().getItems().get(this.getIndex())).hasURL()) {
                    this.setGraphic(null);
                } else {
                    this.setGraphic(new IconNode(FontAwesome.DOWNLOAD));
                    this.setOnMouseClicked(UNUSED -> BookmarkWindowController.this.loadAction((BookmarkData)this.getTableView().getItems().get(this.getIndex())));
                }
            }
        });
        this.colExpiry.setCellFactory(UNUSED -> new TableCell<BookmarkData, String>(this){

            @Override
            public void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (!empty) {
                    BookmarkData data = (BookmarkData)this.getTableView().getItems().get(this.getIndex());
                    this.setText(data.getExpiry());
                    if (data.willExpire()) {
                        this.getStyleClass().add("Expiry");
                    } else {
                        this.getStyleClass().removeAll((String[])new String[]{"Expiry"});
                    }
                } else {
                    this.setText(null);
                }
            }
        });
        this.tbBookmarks.setRowFactory(UNUSED -> new TableRow<BookmarkData>(){

            @Override
            protected void updateItem(BookmarkData data, boolean empty) {
                super.updateItem(data, empty);
                if (empty || data == null) {
                    this.setBackground(Background.EMPTY);
                } else {
                    Color fillcolor;
                    this.setBackground(this.isSelected() ? BookmarkWindowController.this.BackgroundSelected : (data.getSeen() ? BookmarkWindowController.this.BackgroundSeen : Background.EMPTY));
                    Color color = this.isSelected() ? Color.WHITE : (fillcolor = data.isNotInFilmList() ? BookmarkWindowController.this.ColorExpired : null);
                    if (fillcolor != null) {
                        this.getChildren().forEach(n -> ((Labeled)n).setTextFill(fillcolor));
                    }
                }
            }
        });
        this.filteredBookmarkList = new FilteredList<BookmarkData>(this.listeBookmarkList.getObervableList(), p -> true);
        SortedList<BookmarkData> slisteBookmarkList = new SortedList<BookmarkData>((ObservableList<BookmarkData>)this.filteredBookmarkList);
        slisteBookmarkList.comparatorProperty().bind(this.tbBookmarks.comparatorProperty());
        this.listeBookmarkList.getObervableList().addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded() && !c.wasRemoved() && !c.wasUpdated()) continue;
                this.listUpdated = true;
                break;
            }
            this.tbBookmarks.refresh();
            JavaFxUtils.invokeInFxThreadAndWait(this::updateDisplay);
        });
        this.tbBookmarks.setItems(slisteBookmarkList);
        this.tbBookmarks.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tbBookmarks.getSelectionModel().selectedIndexProperty().addListener((obs, oldSelection, newSelection) -> {
            boolean disable = newSelection == null || newSelection.intValue() == -1;
            this.btnDeleteEntry.setDisable(disable);
            this.btnMarkViewed.setDisable(disable || this.onlyLifeStreamSelected());
            boolean multipleSelected = this.tbBookmarks.getSelectionModel().getSelectedItems().size() > 1;
            disable = disable || multipleSelected;
            this.btnEditNote.setDisable(disable);
            this.playitem.setDisable(disable);
            this.edititem.setDisable(disable);
            this.loaditem.setDisable(disable);
            this.viewitem.setDisable(this.onlyLifeStreamSelected());
            this.webitem.setDisable(disable || ((BookmarkData)this.tbBookmarks.getSelectionModel().getSelectedItem()).getWebUrl() == null);
            this.ccopyitem.setDisable(disable);
            boolean setViewed = this.isUnSeenSelected();
            this.setSeenButtonState(setViewed, multipleSelected);
            this.deleteitem.setText(String.format("Film%s aus der Merkliste entfernen", multipleSelected ? "e" : ""));
            this.updateDescriptionArea();
        });
        this.tbBookmarks.getSortOrder().addListener(pc -> this.tbBookmarks.getSelectionModel().clearSelection());
        this.FilterState = -1;
        this.btnFilterAction(null);
        this.btnShowDetails.setSelected(ApplicationConfiguration.getConfiguration().getBoolean("application.ui.bookmarklist.details", true));
        this.divposition = ApplicationConfiguration.getConfiguration().getDouble("application.ui.bookmarklist.divider", this.spSplitPane.getDividerPositions()[0]);
        this.btnShowDetailsAction(null);
        this.updateDescriptionArea();
        this.setupColumnContextMenu();
    }

    private void setupColumnContextMenu() {
        this.tbBookmarks.setTableMenuButtonVisible(true);
        new TableViewColumnContextMenuHelper(this, this.tbBookmarks){

            @Override
            protected CustomMenuItem createColumnCustomMenuItem(ContextMenu contextMenu, TableColumn<?, ?> column) {
                CheckBox checkBox;
                if (!column.getText().isEmpty()) {
                    checkBox = new CheckBox(column.getText());
                } else {
                    checkBox = new CheckBox(" ");
                    IconNode icon = switch (column.getId()) {
                        case "colBtnPlay" -> new IconNode(FontAwesome.PLAY);
                        case "colBtnDownload" -> new IconNode(FontAwesome.DOWNLOAD);
                        default -> throw new IllegalStateException("unknown id");
                    };
                    checkBox.setGraphic(icon);
                }
                contextMenu.focusedProperty().addListener(event -> checkBox.setPrefWidth(contextMenu.getWidth() * 0.75));
                checkBox.selectedProperty().bindBidirectional(column.visibleProperty());
                CustomMenuItem customMenuItem = new CustomMenuItem(checkBox);
                customMenuItem.getStyleClass().set(1, "check-menu-item");
                customMenuItem.setOnAction(event -> {
                    checkBox.setSelected(!checkBox.isSelected());
                    event.consume();
                });
                customMenuItem.setHideOnClick(false);
                return customMenuItem;
            }
        };
    }

    private void updateDescriptionArea() {
        String url;
        this.taDescription.setText(this.tbBookmarks.getSelectionModel().getSelectedItems().size() == 1 ? ((BookmarkData)this.tbBookmarks.getSelectionModel().getSelectedItem()).getExtendedDescription() : "");
        boolean showurl = false;
        if (this.tbBookmarks.getSelectionModel().getSelectedItems().size() == 1 && (url = ((BookmarkData)this.tbBookmarks.getSelectionModel().getSelectedItem()).getWebUrl()) != null && !url.isEmpty()) {
            this.hyperLink.setTooltip(new Tooltip(url));
            this.hyperLink.setVisited(false);
            showurl = true;
        }
        this.hyperLink.setVisible(showurl);
    }

    private void setSeenButtonState(boolean setViewed, boolean multipleSelected) {
        this.btnMarkViewed.setGraphic(new IconNode(setViewed ? FontAwesome.EYE : FontAwesome.EYE_SLASH));
        String text = String.format("Film%s als %sgesehen markieren", multipleSelected ? "e" : "", setViewed ? "" : "un");
        this.btnMarkViewed.setTooltip(new Tooltip(text));
        this.viewitem.setText(text);
        this.viewitem.setGraphic(new IconNode(setViewed ? FontAwesome.EYE : FontAwesome.EYE_SLASH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreTableStateAndContextMenu() {
        this.cellContextMenu = new ContextMenu();
        this.playitem = new MenuItem("Film abspielen");
        this.playitem.setOnAction(UNUSED -> this.playAction((BookmarkData)this.tbBookmarks.getSelectionModel().getSelectedItem()));
        this.playitem.setGraphic(new IconNode(FontAwesome.PLAY));
        this.loaditem = new MenuItem("Film aufzeichnen");
        this.loaditem.setOnAction(UNUSED -> this.loadAction((BookmarkData)this.tbBookmarks.getSelectionModel().getSelectedItem()));
        this.loaditem.setGraphic(new IconNode(FontAwesome.DOWNLOAD));
        this.viewitem = new MenuItem();
        this.viewitem.setOnAction(this::btnMarkEntryAsViewed);
        this.edititem = new MenuItem("Anmerkungen bearbeiten");
        this.edititem.setOnAction(this::btnEditNote);
        this.edititem.setGraphic(new IconNode(FontAwesome.PENCIL));
        this.deleteitem = new MenuItem();
        this.deleteitem.setOnAction(this::btnDeleteEntry);
        this.deleteitem.setGraphic(new IconNode(FontAwesome.MINUS));
        this.webitem = new MenuItem("Film Webseite \u00f6ffnen");
        this.webitem.setOnAction(this::hyperLinkSelected);
        this.ccopyitem = new MenuItem("Zellinhalt in die Ablage kopieren");
        this.ccopyitem.setOnAction(this::copy2Clipboard);
        this.cellContextMenu.getItems().addAll((MenuItem[])new MenuItem[]{this.playitem, this.loaditem, this.viewitem, new SeparatorMenuItem(), this.edititem, this.deleteitem, new SeparatorMenuItem(), this.webitem, this.ccopyitem});
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.READ);
            String colbase = "application.ui.bookmarklist.columns.";
            int entries = config.getInt(colbase + "no", 0);
            if (entries > 0) {
                ArrayList collist = new ArrayList(this.tbBookmarks.getColumns());
                this.tbBookmarks.getColumns().clear();
                block3: for (int i = 1; i <= entries; ++i) {
                    String colref = colbase + "col" + i;
                    String colid = config.getString(colref + ".id");
                    int colsize = config.getInt(colref + ".size", 20);
                    boolean colvisible = config.getBoolean(colref + ".visible", true);
                    for (TableColumn tableColumn : collist) {
                        if (!tableColumn.getId().equals(colid)) continue;
                        tableColumn.setPrefWidth(colsize);
                        tableColumn.setVisible(colvisible);
                        this.tbBookmarks.getColumns().add(tableColumn);
                        continue block3;
                    }
                }
            }
        }
        finally {
            config.unlock(LockMode.READ);
        }
    }

    @FXML
    private void btnShowDetailsAction(ActionEvent event) {
        double newposition;
        if (this.btnShowDetails.isSelected()) {
            newposition = this.divposition;
        } else {
            this.divposition = this.spSplitPane.getDividerPositions()[0];
            newposition = 1.0;
        }
        this.spSplitPane.setDividerPositions(newposition);
    }

    @FXML
    private void btnFilterAction(ActionEvent e) {
        if (++this.FilterState > 2) {
            this.FilterState = 0;
        }
        switch (this.FilterState) {
            case 0: {
                this.filteredBookmarkList.setPredicate(f -> true);
                break;
            }
            case 1: {
                this.filteredBookmarkList.setPredicate(film -> !film.getSeen());
                break;
            }
            case 2: {
                this.filteredBookmarkList.setPredicate(BookmarkData::getSeen);
            }
        }
        this.btnFilter.setTooltip(new Tooltip(BTNFILTER_TOOLTIPTEXT[this.FilterState]));
        this.lblFilter.setText(LBLFILTER_MESSAGETEXT[this.FilterState]);
        this.lblSeen.setDisable(LBLSEEN_DISABLE[this.FilterState]);
        this.refresh();
    }

    @FXML
    private void tbviewOnContextRequested(ContextMenuEvent event) {
        if (!this.tbBookmarks.getSelectionModel().getSelectedItems().isEmpty()) {
            if (!this.ccopyitem.isDisable()) {
                TablePosition pos = (TablePosition)this.tbBookmarks.getSelectionModel().getSelectedCells().get(0);
                BookmarkData item = (BookmarkData)this.tbBookmarks.getItems().get(pos.getRow());
                String sdata = pos.getTableColumn() != null ? (String)((TableColumn)pos.getTableColumn()).getCellObservableValue(item).getValue() : "";
                this.ccopyitem.setDisable(sdata == null || sdata.isBlank());
                this.ccopyitem.setText((pos.getTableColumn() != null ? pos.getTableColumn().getText() : "Text") + " kopieren");
            }
            this.cellContextMenu.show(this.tbBookmarks, event.getScreenX(), event.getScreenY());
        }
    }

    @FXML
    private void tbviewMouseClick(MouseEvent e) {
        if (e.getButton() == MouseButton.PRIMARY) {
            if (this.cellContextMenu.isShowing()) {
                this.cellContextMenu.hide();
            }
            if (e.getClickCount() > 1 && this.tbBookmarks.getSelectionModel().getSelectedItems().size() == 1) {
                this.btnEditNote(null);
            }
        }
    }

    public void show() {
        JavaFxUtils.invokeInFxThreadAndWait(() -> {
            if (this.stage == null) {
                this.stage = new Stage();
                BookmarkWindowController.setStageSize(this.stage);
                this.setStageEvents();
                this.stage.setTitle("Merkliste verwalten");
                this.stage.getIcons().add(new Image("/mediathek/res/MediathekView.png"));
                try {
                    FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/mediathek/res/programm/fxml/bookmarkWindow.fxml"));
                    fxmlLoader.setController(this);
                    Scene scene = new Scene((Parent)fxmlLoader.load());
                    this.stage.setScene(scene);
                    scene.getStylesheets().add(this.getClass().getResource("/mediathek/res/css/bookmarkWindow.css").toExternalForm());
                }
                catch (IOException e) {
                    LogManager.getLogger(BookmarkWindowController.class).error("{} Can't find/load the FXML description! Exception - {}", (Object)this.getClass(), (Object)e.toString());
                    this.stage = null;
                }
            } else {
                this.tbBookmarks.getSelectionModel().clearSelection();
                if (this.stage.isIconified()) {
                    this.stage.setIconified(false);
                }
                this.stage.toFront();
                this.stage.requestFocus();
            }
            if (this.stage != null) {
                this.stage.show();
                this.refresh();
            }
        });
    }

    public void setPartner(GuiFilme partner) {
        this.infotab = partner;
    }

    private void refresh() {
        if (this.stage.isShowing()) {
            this.tbBookmarks.refresh();
            this.updateDisplay();
        }
    }

    private void updateDisplay() {
        this.lblCount.setText(String.format("Eintr\u00e4ge: %d / %d", this.filteredBookmarkList.size(), this.listeBookmarkList.getNbOfEntries()));
        this.lblSeen.setText(String.format("Gesehen: %d", this.listeBookmarkList.getSeenNbOfEntries()));
        this.btnSaveList.setDisable(!this.listUpdated);
        if (this.listUpdated) {
            this.cancelBookmarkSave();
            this.SaveBookmarkTask = TimerPool.getTimerPool().schedule(() -> {
                this.saveBookMarkList();
                this.SaveBookmarkTask = null;
            }, 30L, TimeUnit.SECONDS);
        }
        this.lblMessage.setText("");
    }

    private void saveBookMarkList() {
        if (this.listUpdated) {
            this.listeBookmarkList.saveToFile(StandardLocations.getBookmarkFilePath());
            this.btnSaveList.setDisable(true);
            JavaFxUtils.invokeInFxThreadAndWait(() -> this.lblMessage.setText("Merkliste ist gesichert"));
        }
        this.listUpdated = false;
    }

    private void playAction(BookmarkData data) {
        Daten.getInstance().getStarterClass().urlMitProgrammStarten(Daten.listePset.getPsetAbspielen(), data.getDataAsDatenFilm(), "");
        this.tbBookmarks.getSelectionModel().clearSelection();
        this.tbBookmarks.getSelectionModel().select(data);
    }

    private void loadAction(@NotNull BookmarkData data) {
        Optional<DatenFilm> datenFilm = Optional.ofNullable(data.getDatenFilm());
        Daten daten = Daten.getInstance();
        this.refresh();
        datenFilm.ifPresent(film -> {
            DatenDownload previouslyCreatedDownload = daten.getListeDownloads().getDownloadUrlFilm(film.getUrlNormalQuality());
            if (previouslyCreatedDownload == null) {
                this.createDownload((DatenFilm)film);
            } else {
                ButtonType yes = new ButtonType("Ja", ButtonBar.ButtonData.OK_DONE);
                ButtonType no = new ButtonType("Nein", ButtonBar.ButtonData.CANCEL_CLOSE);
                Alert alert = new Alert(Alert.AlertType.WARNING, "Ein Download f\u00fcr den Film existiert bereits.\nNochmal anlegen?", yes, no);
                alert.initOwner(this.stage);
                alert.setTitle(ALERT_TITLE);
                alert.showAndWait().filter(response -> response == ButtonType.OK).ifPresent(response -> this.createDownload((DatenFilm)film));
            }
        });
    }

    private void createDownload(DatenFilm film) {
        Daten daten = Daten.getInstance();
        this.stage.hide();
        SwingUtilities.invokeLater(() -> {
            DatenPset pSet = (DatenPset)Daten.listePset.getListeSpeichern().get(0);
            MediathekGui ui = MediathekGui.ui();
            DialogAddMoreDownload damd = new DialogAddMoreDownload(ui, pSet);
            damd.setLocationRelativeTo(ui);
            damd.setVisible(true);
            String pfad = damd.getPath();
            boolean info = damd.info;
            boolean subtitle = damd.subtitle;
            if (!damd.cancel) {
                DatenDownload datenDownload = new DatenDownload(pSet, film, 2, null, "", pfad, "");
                datenDownload.arr[35] = Boolean.toString(info);
                datenDownload.arr[37] = Boolean.toString(subtitle);
                daten.getListeDownloads().addMitNummer(datenDownload);
                MessageBus.getMessageBus().publishAsync(new DownloadListChangedEvent());
                if (Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD_D_STARTEN))) {
                    datenDownload.startDownload();
                }
            }
            this.showStage();
        });
    }

    private void showStage() {
        Platform.runLater(() -> {
            this.stage.show();
            this.stage.toFront();
            this.stage.requestFocus();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSettings() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.WRITE);
            config.setProperty("application.ui.bookmarklist.width", (int)this.stage.getWidth());
            config.setProperty("application.ui.bookmarklist.heigth", (int)this.stage.getHeight());
            config.setProperty("application.ui.bookmarklist.location.x", (int)this.stage.getX());
            config.setProperty("application.ui.bookmarklist.location.y", (int)this.stage.getY());
            String colbase = "application.ui.bookmarklist.columns";
            config.setProperty(colbase + ".no", this.tbBookmarks.getColumns().size());
            int k = 0;
            for (TableColumn tableColumn : this.tbBookmarks.getColumns()) {
                String colref = colbase + ".col" + ++k;
                config.setProperty(colref + ".id", tableColumn.getId());
                config.setProperty(colref + ".size", (int)tableColumn.getWidth());
                config.setProperty(colref + ".visible", tableColumn.isVisible());
            }
            config.setProperty("application.ui.bookmarklist.details", this.btnShowDetails.isSelected());
            config.setProperty("application.ui.bookmarklist.divider", this.btnShowDetails.isSelected() ? this.spSplitPane.getDividerPositions()[0] : this.divposition);
        }
        catch (Exception e) {
            LogManager.getLogger(ApplicationConfiguration.class).error("Save Config exception: ", (Throwable)e);
        }
        finally {
            config.unlock(LockMode.WRITE);
        }
    }

    private static void setStageSize(Stage window) {
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.READ);
            window.setWidth(config.getInt("application.ui.bookmarklist.width", 640));
            window.setHeight(config.getInt("application.ui.bookmarklist.heigth", 480));
            window.setX(config.getInt("application.ui.bookmarklist.location.x", 0));
            window.setY(config.getInt("application.ui.bookmarklist.location.y", 0));
        }
        finally {
            config.unlock(LockMode.READ);
        }
    }

    private void setStageEvents() {
        this.stage.setOnShowing(e -> this.initSettings());
        this.stage.setOnHiding(e -> {
            if (this.listUpdated) {
                this.cancelBookmarkSave();
                this.saveBookMarkList();
                this.listUpdated = false;
            }
        });
    }

    private boolean isUnSeenSelected() {
        boolean unSeen = false;
        for (BookmarkData data : this.tbBookmarks.getSelectionModel().getSelectedItems()) {
            if (data.getSeen() || data.isLiveStream()) continue;
            unSeen = true;
            break;
        }
        return unSeen;
    }

    private boolean onlyLifeStreamSelected() {
        boolean lifestream = true;
        for (BookmarkData data : this.tbBookmarks.getSelectionModel().getSelectedItems()) {
            if (data.isLiveStream()) continue;
            lifestream = false;
            break;
        }
        return lifestream;
    }

    private static Color convertMVCAWTColor(MVC mvc) {
        return Color.rgb(mvc.color.getRed(), mvc.color.getGreen(), mvc.color.getBlue());
    }

    private void initSettings() {
        Color colorSeen = BookmarkWindowController.convertMVCAWTColor(MVColor.FILM_HISTORY);
        Color colorNew = JavaFxUtils.toFXColor(MVColor.getNewColor());
        this.ColorExpired = BookmarkWindowController.convertMVCAWTColor(MVColor.DOWNLOAD_FEHLER);
        this.BackgroundSeen = new Background(new BackgroundFill(colorSeen, CornerRadii.EMPTY, Insets.EMPTY));
        this.BackgroundSelected = new Background(new BackgroundFill(colorNew, CornerRadii.EMPTY, Insets.EMPTY));
    }

    private void cancelBookmarkSave() {
        if (this.SaveBookmarkTask != null) {
            this.SaveBookmarkTask.cancel(false);
            this.SaveBookmarkTask = null;
        }
    }
}

