/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import java.io.IOException;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.transport.TransportRequest;

public class StartJoinRequest
extends TransportRequest {
    private final DiscoveryNode sourceNode;
    private final long term;

    public StartJoinRequest(DiscoveryNode sourceNode, long term) {
        this.sourceNode = sourceNode;
        this.term = term;
    }

    public StartJoinRequest(StreamInput input) throws IOException {
        super(input);
        this.sourceNode = new DiscoveryNode(input);
        this.term = input.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.sourceNode.writeTo(out);
        out.writeLong(this.term);
    }

    public DiscoveryNode getSourceNode() {
        return this.sourceNode;
    }

    public long getTerm() {
        return this.term;
    }

    public String toString() {
        return "StartJoinRequest{term=" + this.term + ",node=" + this.sourceNode + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StartJoinRequest)) {
            return false;
        }
        StartJoinRequest that = (StartJoinRequest)o;
        if (this.term != that.term) {
            return false;
        }
        return this.sourceNode.equals(that.sourceNode);
    }

    public int hashCode() {
        int result = this.sourceNode.hashCode();
        result = 31 * result + (int)(this.term ^ this.term >>> 32);
        return result;
    }
}

