/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.model;

import java.io.IOException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opensearch.ad.model.Entity;
import org.opensearch.ad.util.Bwc;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class ModelProfile
implements Writeable,
ToXContentObject {
    private final String modelId;
    private final Entity entity;
    private final long modelSizeInBytes;

    public ModelProfile(String modelId, Entity entity, long modelSizeInBytes) {
        this.modelId = modelId;
        this.entity = entity;
        this.modelSizeInBytes = modelSizeInBytes;
    }

    public ModelProfile(StreamInput in) throws IOException {
        this.modelId = in.readString();
        this.entity = Bwc.supportMultiCategoryFields(in.getVersion()) ? (in.readBoolean() ? new Entity(in) : null) : null;
        this.modelSizeInBytes = in.readLong();
        if (!Bwc.supportMultiCategoryFields(in.getVersion())) {
            in.readString();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        if (Bwc.supportMultiCategoryFields(out.getVersion())) {
            if (this.entity != null) {
                out.writeBoolean(true);
                this.entity.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }
        out.writeLong(this.modelSizeInBytes);
        if (!Bwc.supportMultiCategoryFields(out.getVersion())) {
            out.writeString("");
        }
    }

    public String getModelId() {
        return this.modelId;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public long getModelSizeInBytes() {
        return this.modelSizeInBytes;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("model_id", this.modelId);
        if (this.entity != null) {
            builder.field("entity", (ToXContent)this.entity);
        }
        if (this.modelSizeInBytes > 0L) {
            builder.field("model_size_in_bytes", this.modelSizeInBytes);
        }
        return builder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj instanceof ModelProfile) {
            ModelProfile other = (ModelProfile)obj;
            EqualsBuilder equalsBuilder = new EqualsBuilder();
            equalsBuilder.append((Object)this.modelId, (Object)other.modelId);
            return equalsBuilder.isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.modelId).toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("model_id", (Object)this.modelId);
        if (this.modelSizeInBytes > 0L) {
            builder.append("model_size_in_bytes", this.modelSizeInBytes);
        }
        if (this.entity != null) {
            builder.append("entity", (Object)this.entity);
        }
        return builder.toString();
    }
}

