/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.ratelimit;

import java.time.Clock;
import java.time.Duration;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ad.NodeStateManager;
import org.opensearch.ad.breaker.ADCircuitBreakerService;
import org.opensearch.ad.ratelimit.ConcurrentWorker;
import org.opensearch.ad.ratelimit.QueuedRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.threadpool.ThreadPool;

public abstract class SingleRequestWorker<RequestType extends QueuedRequest>
extends ConcurrentWorker<RequestType> {
    private static final Logger LOG = LogManager.getLogger(SingleRequestWorker.class);

    public SingleRequestWorker(String queueName, long heapSize, int singleRequestSize, Setting<Float> maxHeapPercentForQueueSetting, ClusterService clusterService, Random random, ADCircuitBreakerService adCircuitBreakerService, ThreadPool threadPool, Settings settings, float maxQueuedTaskRatio, Clock clock, float mediumSegmentPruneRatio, float lowSegmentPruneRatio, int maintenanceFreqConstant, Setting<Integer> concurrencySetting, Duration executionTtl, Duration stateTtl, NodeStateManager nodeStateManager) {
        super(queueName, heapSize, singleRequestSize, maxHeapPercentForQueueSetting, clusterService, random, adCircuitBreakerService, threadPool, settings, maxQueuedTaskRatio, clock, mediumSegmentPruneRatio, lowSegmentPruneRatio, maintenanceFreqConstant, concurrencySetting, executionTtl, stateTtl, nodeStateManager);
    }

    @Override
    protected void execute(Runnable afterProcessCallback, Runnable emptyQueueCallback) {
        QueuedRequest request = null;
        Optional queueOptional = this.selectNextQueue();
        if (!queueOptional.isPresent()) {
            emptyQueueCallback.run();
            return;
        }
        BlockingQueue queue = queueOptional.get();
        if (!queue.isEmpty()) {
            request = (QueuedRequest)queue.poll();
        }
        if (request == null) {
            emptyQueueCallback.run();
            return;
        }
        ActionListener handlerWithRelease = ActionListener.wrap((Runnable)afterProcessCallback);
        this.executeRequest(request, (ActionListener<Void>)handlerWithRelease);
    }

    protected abstract void executeRequest(RequestType var1, ActionListener<Void> var2);
}

