"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.templateValidator = exports.instanceValidator = void 0;

var _ajv = _interopRequireDefault(require("ajv"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const ajv = new _ajv.default();
const staticAsset = {
  type: 'object',
  properties: {
    path: {
      type: 'string'
    },
    annotation: {
      type: 'string',
      nullable: true
    }
  },
  required: ['path'],
  additionalProperties: false
};
const templateSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string'
    },
    version: {
      type: 'string'
    },
    displayName: {
      type: 'string',
      nullable: true
    },
    license: {
      type: 'string'
    },
    type: {
      type: 'string'
    },
    author: {
      type: 'string',
      nullable: true
    },
    description: {
      type: 'string',
      nullable: true
    },
    sourceUrl: {
      type: 'string',
      nullable: true
    },
    statics: {
      type: 'object',
      properties: {
        logo: { ...staticAsset,
          nullable: true
        },
        gallery: {
          type: 'array',
          items: staticAsset,
          nullable: true
        },
        darkModeLogo: { ...staticAsset,
          nullable: true
        },
        darkModeGallery: {
          type: 'array',
          items: staticAsset,
          nullable: true
        }
      },
      additionalProperties: false,
      nullable: true
    },
    components: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          name: {
            type: 'string'
          },
          version: {
            type: 'string'
          }
        },
        required: ['name', 'version']
      }
    },
    assets: {
      type: 'object',
      properties: {
        savedObjects: {
          type: 'object',
          properties: {
            name: {
              type: 'string'
            },
            version: {
              type: 'string'
            }
          },
          required: ['name', 'version'],
          nullable: true,
          additionalProperties: false
        }
      },
      additionalProperties: false
    },
    sampleData: {
      type: 'object',
      properties: {
        path: {
          type: 'string'
        }
      },
      required: ['path'],
      additionalProperties: false,
      nullable: true
    }
  },
  required: ['name', 'version', 'license', 'type', 'components', 'assets'],
  additionalProperties: false
};
const instanceSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string'
    },
    templateName: {
      type: 'string'
    },
    dataSource: {
      type: 'string'
    },
    creationDate: {
      type: 'string'
    },
    assets: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          assetType: {
            type: 'string'
          },
          assetId: {
            type: 'string'
          },
          isDefaultAsset: {
            type: 'boolean'
          },
          description: {
            type: 'string'
          }
        },
        required: ['assetType', 'assetId', 'isDefaultAsset', 'description']
      }
    }
  },
  required: ['name', 'templateName', 'dataSource', 'creationDate', 'assets']
};
const templateValidator = ajv.compile(templateSchema);
exports.templateValidator = templateValidator;
const instanceValidator = ajv.compile(instanceSchema);
exports.instanceValidator = instanceValidator;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInZhbGlkYXRvcnMudHMiXSwibmFtZXMiOlsiYWp2IiwiQWp2Iiwic3RhdGljQXNzZXQiLCJ0eXBlIiwicHJvcGVydGllcyIsInBhdGgiLCJhbm5vdGF0aW9uIiwibnVsbGFibGUiLCJyZXF1aXJlZCIsImFkZGl0aW9uYWxQcm9wZXJ0aWVzIiwidGVtcGxhdGVTY2hlbWEiLCJuYW1lIiwidmVyc2lvbiIsImRpc3BsYXlOYW1lIiwibGljZW5zZSIsImF1dGhvciIsImRlc2NyaXB0aW9uIiwic291cmNlVXJsIiwic3RhdGljcyIsImxvZ28iLCJnYWxsZXJ5IiwiaXRlbXMiLCJkYXJrTW9kZUxvZ28iLCJkYXJrTW9kZUdhbGxlcnkiLCJjb21wb25lbnRzIiwiYXNzZXRzIiwic2F2ZWRPYmplY3RzIiwic2FtcGxlRGF0YSIsImluc3RhbmNlU2NoZW1hIiwidGVtcGxhdGVOYW1lIiwiZGF0YVNvdXJjZSIsImNyZWF0aW9uRGF0ZSIsImFzc2V0VHlwZSIsImFzc2V0SWQiLCJpc0RlZmF1bHRBc3NldCIsInRlbXBsYXRlVmFsaWRhdG9yIiwiY29tcGlsZSIsImluc3RhbmNlVmFsaWRhdG9yIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBS0E7Ozs7QUFMQTtBQUNBO0FBQ0E7QUFDQTtBQUlBLE1BQU1BLEdBQUcsR0FBRyxJQUFJQyxZQUFKLEVBQVo7QUFFQSxNQUFNQyxXQUF3QyxHQUFHO0FBQy9DQyxFQUFBQSxJQUFJLEVBQUUsUUFEeUM7QUFFL0NDLEVBQUFBLFVBQVUsRUFBRTtBQUNWQyxJQUFBQSxJQUFJLEVBQUU7QUFBRUYsTUFBQUEsSUFBSSxFQUFFO0FBQVIsS0FESTtBQUVWRyxJQUFBQSxVQUFVLEVBQUU7QUFBRUgsTUFBQUEsSUFBSSxFQUFFLFFBQVI7QUFBa0JJLE1BQUFBLFFBQVEsRUFBRTtBQUE1QjtBQUZGLEdBRm1DO0FBTS9DQyxFQUFBQSxRQUFRLEVBQUUsQ0FBQyxNQUFELENBTnFDO0FBTy9DQyxFQUFBQSxvQkFBb0IsRUFBRTtBQVB5QixDQUFqRDtBQVVBLE1BQU1DLGNBQW1ELEdBQUc7QUFDMURQLEVBQUFBLElBQUksRUFBRSxRQURvRDtBQUUxREMsRUFBQUEsVUFBVSxFQUFFO0FBQ1ZPLElBQUFBLElBQUksRUFBRTtBQUFFUixNQUFBQSxJQUFJLEVBQUU7QUFBUixLQURJO0FBRVZTLElBQUFBLE9BQU8sRUFBRTtBQUFFVCxNQUFBQSxJQUFJLEVBQUU7QUFBUixLQUZDO0FBR1ZVLElBQUFBLFdBQVcsRUFBRTtBQUFFVixNQUFBQSxJQUFJLEVBQUUsUUFBUjtBQUFrQkksTUFBQUEsUUFBUSxFQUFFO0FBQTVCLEtBSEg7QUFJVk8sSUFBQUEsT0FBTyxFQUFFO0FBQUVYLE1BQUFBLElBQUksRUFBRTtBQUFSLEtBSkM7QUFLVkEsSUFBQUEsSUFBSSxFQUFFO0FBQUVBLE1BQUFBLElBQUksRUFBRTtBQUFSLEtBTEk7QUFNVlksSUFBQUEsTUFBTSxFQUFFO0FBQUVaLE1BQUFBLElBQUksRUFBRSxRQUFSO0FBQWtCSSxNQUFBQSxRQUFRLEVBQUU7QUFBNUIsS0FORTtBQU9WUyxJQUFBQSxXQUFXLEVBQUU7QUFBRWIsTUFBQUEsSUFBSSxFQUFFLFFBQVI7QUFBa0JJLE1BQUFBLFFBQVEsRUFBRTtBQUE1QixLQVBIO0FBUVZVLElBQUFBLFNBQVMsRUFBRTtBQUFFZCxNQUFBQSxJQUFJLEVBQUUsUUFBUjtBQUFrQkksTUFBQUEsUUFBUSxFQUFFO0FBQTVCLEtBUkQ7QUFTVlcsSUFBQUEsT0FBTyxFQUFFO0FBQ1BmLE1BQUFBLElBQUksRUFBRSxRQURDO0FBRVBDLE1BQUFBLFVBQVUsRUFBRTtBQUNWZSxRQUFBQSxJQUFJLEVBQUUsRUFBRSxHQUFHakIsV0FBTDtBQUFrQkssVUFBQUEsUUFBUSxFQUFFO0FBQTVCLFNBREk7QUFFVmEsUUFBQUEsT0FBTyxFQUFFO0FBQUVqQixVQUFBQSxJQUFJLEVBQUUsT0FBUjtBQUFpQmtCLFVBQUFBLEtBQUssRUFBRW5CLFdBQXhCO0FBQXFDSyxVQUFBQSxRQUFRLEVBQUU7QUFBL0MsU0FGQztBQUdWZSxRQUFBQSxZQUFZLEVBQUUsRUFBRSxHQUFHcEIsV0FBTDtBQUFrQkssVUFBQUEsUUFBUSxFQUFFO0FBQTVCLFNBSEo7QUFJVmdCLFFBQUFBLGVBQWUsRUFBRTtBQUFFcEIsVUFBQUEsSUFBSSxFQUFFLE9BQVI7QUFBaUJrQixVQUFBQSxLQUFLLEVBQUVuQixXQUF4QjtBQUFxQ0ssVUFBQUEsUUFBUSxFQUFFO0FBQS9DO0FBSlAsT0FGTDtBQVFQRSxNQUFBQSxvQkFBb0IsRUFBRSxLQVJmO0FBU1BGLE1BQUFBLFFBQVEsRUFBRTtBQVRILEtBVEM7QUFvQlZpQixJQUFBQSxVQUFVLEVBQUU7QUFDVnJCLE1BQUFBLElBQUksRUFBRSxPQURJO0FBRVZrQixNQUFBQSxLQUFLLEVBQUU7QUFDTGxCLFFBQUFBLElBQUksRUFBRSxRQUREO0FBRUxDLFFBQUFBLFVBQVUsRUFBRTtBQUNWTyxVQUFBQSxJQUFJLEVBQUU7QUFBRVIsWUFBQUEsSUFBSSxFQUFFO0FBQVIsV0FESTtBQUVWUyxVQUFBQSxPQUFPLEVBQUU7QUFBRVQsWUFBQUEsSUFBSSxFQUFFO0FBQVI7QUFGQyxTQUZQO0FBTUxLLFFBQUFBLFFBQVEsRUFBRSxDQUFDLE1BQUQsRUFBUyxTQUFUO0FBTkw7QUFGRyxLQXBCRjtBQStCVmlCLElBQUFBLE1BQU0sRUFBRTtBQUNOdEIsTUFBQUEsSUFBSSxFQUFFLFFBREE7QUFFTkMsTUFBQUEsVUFBVSxFQUFFO0FBQ1ZzQixRQUFBQSxZQUFZLEVBQUU7QUFDWnZCLFVBQUFBLElBQUksRUFBRSxRQURNO0FBRVpDLFVBQUFBLFVBQVUsRUFBRTtBQUNWTyxZQUFBQSxJQUFJLEVBQUU7QUFBRVIsY0FBQUEsSUFBSSxFQUFFO0FBQVIsYUFESTtBQUVWUyxZQUFBQSxPQUFPLEVBQUU7QUFBRVQsY0FBQUEsSUFBSSxFQUFFO0FBQVI7QUFGQyxXQUZBO0FBTVpLLFVBQUFBLFFBQVEsRUFBRSxDQUFDLE1BQUQsRUFBUyxTQUFULENBTkU7QUFPWkQsVUFBQUEsUUFBUSxFQUFFLElBUEU7QUFRWkUsVUFBQUEsb0JBQW9CLEVBQUU7QUFSVjtBQURKLE9BRk47QUFjTkEsTUFBQUEsb0JBQW9CLEVBQUU7QUFkaEIsS0EvQkU7QUErQ1ZrQixJQUFBQSxVQUFVLEVBQUU7QUFDVnhCLE1BQUFBLElBQUksRUFBRSxRQURJO0FBRVZDLE1BQUFBLFVBQVUsRUFBRTtBQUNWQyxRQUFBQSxJQUFJLEVBQUU7QUFDSkYsVUFBQUEsSUFBSSxFQUFFO0FBREY7QUFESSxPQUZGO0FBT1ZLLE1BQUFBLFFBQVEsRUFBRSxDQUFDLE1BQUQsQ0FQQTtBQVFWQyxNQUFBQSxvQkFBb0IsRUFBRSxLQVJaO0FBU1ZGLE1BQUFBLFFBQVEsRUFBRTtBQVRBO0FBL0NGLEdBRjhDO0FBNkQxREMsRUFBQUEsUUFBUSxFQUFFLENBQUMsTUFBRCxFQUFTLFNBQVQsRUFBb0IsU0FBcEIsRUFBK0IsTUFBL0IsRUFBdUMsWUFBdkMsRUFBcUQsUUFBckQsQ0E3RGdEO0FBOEQxREMsRUFBQUEsb0JBQW9CLEVBQUU7QUE5RG9DLENBQTVEO0FBaUVBLE1BQU1tQixjQUFtRCxHQUFHO0FBQzFEekIsRUFBQUEsSUFBSSxFQUFFLFFBRG9EO0FBRTFEQyxFQUFBQSxVQUFVLEVBQUU7QUFDVk8sSUFBQUEsSUFBSSxFQUFFO0FBQUVSLE1BQUFBLElBQUksRUFBRTtBQUFSLEtBREk7QUFFVjBCLElBQUFBLFlBQVksRUFBRTtBQUFFMUIsTUFBQUEsSUFBSSxFQUFFO0FBQVIsS0FGSjtBQUdWMkIsSUFBQUEsVUFBVSxFQUFFO0FBQUUzQixNQUFBQSxJQUFJLEVBQUU7QUFBUixLQUhGO0FBSVY0QixJQUFBQSxZQUFZLEVBQUU7QUFBRTVCLE1BQUFBLElBQUksRUFBRTtBQUFSLEtBSko7QUFLVnNCLElBQUFBLE1BQU0sRUFBRTtBQUNOdEIsTUFBQUEsSUFBSSxFQUFFLE9BREE7QUFFTmtCLE1BQUFBLEtBQUssRUFBRTtBQUNMbEIsUUFBQUEsSUFBSSxFQUFFLFFBREQ7QUFFTEMsUUFBQUEsVUFBVSxFQUFFO0FBQ1Y0QixVQUFBQSxTQUFTLEVBQUU7QUFBRTdCLFlBQUFBLElBQUksRUFBRTtBQUFSLFdBREQ7QUFFVjhCLFVBQUFBLE9BQU8sRUFBRTtBQUFFOUIsWUFBQUEsSUFBSSxFQUFFO0FBQVIsV0FGQztBQUdWK0IsVUFBQUEsY0FBYyxFQUFFO0FBQUUvQixZQUFBQSxJQUFJLEVBQUU7QUFBUixXQUhOO0FBSVZhLFVBQUFBLFdBQVcsRUFBRTtBQUFFYixZQUFBQSxJQUFJLEVBQUU7QUFBUjtBQUpILFNBRlA7QUFRTEssUUFBQUEsUUFBUSxFQUFFLENBQUMsV0FBRCxFQUFjLFNBQWQsRUFBeUIsZ0JBQXpCLEVBQTJDLGFBQTNDO0FBUkw7QUFGRDtBQUxFLEdBRjhDO0FBcUIxREEsRUFBQUEsUUFBUSxFQUFFLENBQUMsTUFBRCxFQUFTLGNBQVQsRUFBeUIsWUFBekIsRUFBdUMsY0FBdkMsRUFBdUQsUUFBdkQ7QUFyQmdELENBQTVEO0FBd0JPLE1BQU0yQixpQkFBaUIsR0FBR25DLEdBQUcsQ0FBQ29DLE9BQUosQ0FBWTFCLGNBQVosQ0FBMUI7O0FBQ0EsTUFBTTJCLGlCQUFpQixHQUFHckMsR0FBRyxDQUFDb0MsT0FBSixDQUFZUixjQUFaLENBQTFCIiwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgQWp2LCB7IEpTT05TY2hlbWFUeXBlIH0gZnJvbSAnYWp2JztcblxuY29uc3QgYWp2ID0gbmV3IEFqdigpO1xuXG5jb25zdCBzdGF0aWNBc3NldDogSlNPTlNjaGVtYVR5cGU8U3RhdGljQXNzZXQ+ID0ge1xuICB0eXBlOiAnb2JqZWN0JyxcbiAgcHJvcGVydGllczoge1xuICAgIHBhdGg6IHsgdHlwZTogJ3N0cmluZycgfSxcbiAgICBhbm5vdGF0aW9uOiB7IHR5cGU6ICdzdHJpbmcnLCBudWxsYWJsZTogdHJ1ZSB9LFxuICB9LFxuICByZXF1aXJlZDogWydwYXRoJ10sXG4gIGFkZGl0aW9uYWxQcm9wZXJ0aWVzOiBmYWxzZSxcbn07XG5cbmNvbnN0IHRlbXBsYXRlU2NoZW1hOiBKU09OU2NoZW1hVHlwZTxJbnRlZ3JhdGlvblRlbXBsYXRlPiA9IHtcbiAgdHlwZTogJ29iamVjdCcsXG4gIHByb3BlcnRpZXM6IHtcbiAgICBuYW1lOiB7IHR5cGU6ICdzdHJpbmcnIH0sXG4gICAgdmVyc2lvbjogeyB0eXBlOiAnc3RyaW5nJyB9LFxuICAgIGRpc3BsYXlOYW1lOiB7IHR5cGU6ICdzdHJpbmcnLCBudWxsYWJsZTogdHJ1ZSB9LFxuICAgIGxpY2Vuc2U6IHsgdHlwZTogJ3N0cmluZycgfSxcbiAgICB0eXBlOiB7IHR5cGU6ICdzdHJpbmcnIH0sXG4gICAgYXV0aG9yOiB7IHR5cGU6ICdzdHJpbmcnLCBudWxsYWJsZTogdHJ1ZSB9LFxuICAgIGRlc2NyaXB0aW9uOiB7IHR5cGU6ICdzdHJpbmcnLCBudWxsYWJsZTogdHJ1ZSB9LFxuICAgIHNvdXJjZVVybDogeyB0eXBlOiAnc3RyaW5nJywgbnVsbGFibGU6IHRydWUgfSxcbiAgICBzdGF0aWNzOiB7XG4gICAgICB0eXBlOiAnb2JqZWN0JyxcbiAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgbG9nbzogeyAuLi5zdGF0aWNBc3NldCwgbnVsbGFibGU6IHRydWUgfSxcbiAgICAgICAgZ2FsbGVyeTogeyB0eXBlOiAnYXJyYXknLCBpdGVtczogc3RhdGljQXNzZXQsIG51bGxhYmxlOiB0cnVlIH0sXG4gICAgICAgIGRhcmtNb2RlTG9nbzogeyAuLi5zdGF0aWNBc3NldCwgbnVsbGFibGU6IHRydWUgfSxcbiAgICAgICAgZGFya01vZGVHYWxsZXJ5OiB7IHR5cGU6ICdhcnJheScsIGl0ZW1zOiBzdGF0aWNBc3NldCwgbnVsbGFibGU6IHRydWUgfSxcbiAgICAgIH0sXG4gICAgICBhZGRpdGlvbmFsUHJvcGVydGllczogZmFsc2UsXG4gICAgICBudWxsYWJsZTogdHJ1ZSxcbiAgICB9LFxuICAgIGNvbXBvbmVudHM6IHtcbiAgICAgIHR5cGU6ICdhcnJheScsXG4gICAgICBpdGVtczoge1xuICAgICAgICB0eXBlOiAnb2JqZWN0JyxcbiAgICAgICAgcHJvcGVydGllczoge1xuICAgICAgICAgIG5hbWU6IHsgdHlwZTogJ3N0cmluZycgfSxcbiAgICAgICAgICB2ZXJzaW9uOiB7IHR5cGU6ICdzdHJpbmcnIH0sXG4gICAgICAgIH0sXG4gICAgICAgIHJlcXVpcmVkOiBbJ25hbWUnLCAndmVyc2lvbiddLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGFzc2V0czoge1xuICAgICAgdHlwZTogJ29iamVjdCcsXG4gICAgICBwcm9wZXJ0aWVzOiB7XG4gICAgICAgIHNhdmVkT2JqZWN0czoge1xuICAgICAgICAgIHR5cGU6ICdvYmplY3QnLFxuICAgICAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgICAgIG5hbWU6IHsgdHlwZTogJ3N0cmluZycgfSxcbiAgICAgICAgICAgIHZlcnNpb246IHsgdHlwZTogJ3N0cmluZycgfSxcbiAgICAgICAgICB9LFxuICAgICAgICAgIHJlcXVpcmVkOiBbJ25hbWUnLCAndmVyc2lvbiddLFxuICAgICAgICAgIG51bGxhYmxlOiB0cnVlLFxuICAgICAgICAgIGFkZGl0aW9uYWxQcm9wZXJ0aWVzOiBmYWxzZSxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgICBhZGRpdGlvbmFsUHJvcGVydGllczogZmFsc2UsXG4gICAgfSxcbiAgICBzYW1wbGVEYXRhOiB7XG4gICAgICB0eXBlOiAnb2JqZWN0JyxcbiAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgcGF0aDoge1xuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICAgIHJlcXVpcmVkOiBbJ3BhdGgnXSxcbiAgICAgIGFkZGl0aW9uYWxQcm9wZXJ0aWVzOiBmYWxzZSxcbiAgICAgIG51bGxhYmxlOiB0cnVlLFxuICAgIH0sXG4gIH0sXG4gIHJlcXVpcmVkOiBbJ25hbWUnLCAndmVyc2lvbicsICdsaWNlbnNlJywgJ3R5cGUnLCAnY29tcG9uZW50cycsICdhc3NldHMnXSxcbiAgYWRkaXRpb25hbFByb3BlcnRpZXM6IGZhbHNlLFxufTtcblxuY29uc3QgaW5zdGFuY2VTY2hlbWE6IEpTT05TY2hlbWFUeXBlPEludGVncmF0aW9uSW5zdGFuY2U+ID0ge1xuICB0eXBlOiAnb2JqZWN0JyxcbiAgcHJvcGVydGllczoge1xuICAgIG5hbWU6IHsgdHlwZTogJ3N0cmluZycgfSxcbiAgICB0ZW1wbGF0ZU5hbWU6IHsgdHlwZTogJ3N0cmluZycgfSxcbiAgICBkYXRhU291cmNlOiB7IHR5cGU6ICdzdHJpbmcnIH0sXG4gICAgY3JlYXRpb25EYXRlOiB7IHR5cGU6ICdzdHJpbmcnIH0sXG4gICAgYXNzZXRzOiB7XG4gICAgICB0eXBlOiAnYXJyYXknLFxuICAgICAgaXRlbXM6IHtcbiAgICAgICAgdHlwZTogJ29iamVjdCcsXG4gICAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgICBhc3NldFR5cGU6IHsgdHlwZTogJ3N0cmluZycgfSxcbiAgICAgICAgICBhc3NldElkOiB7IHR5cGU6ICdzdHJpbmcnIH0sXG4gICAgICAgICAgaXNEZWZhdWx0QXNzZXQ6IHsgdHlwZTogJ2Jvb2xlYW4nIH0sXG4gICAgICAgICAgZGVzY3JpcHRpb246IHsgdHlwZTogJ3N0cmluZycgfSxcbiAgICAgICAgfSxcbiAgICAgICAgcmVxdWlyZWQ6IFsnYXNzZXRUeXBlJywgJ2Fzc2V0SWQnLCAnaXNEZWZhdWx0QXNzZXQnLCAnZGVzY3JpcHRpb24nXSxcbiAgICAgIH0sXG4gICAgfSxcbiAgfSxcbiAgcmVxdWlyZWQ6IFsnbmFtZScsICd0ZW1wbGF0ZU5hbWUnLCAnZGF0YVNvdXJjZScsICdjcmVhdGlvbkRhdGUnLCAnYXNzZXRzJ10sXG59O1xuXG5leHBvcnQgY29uc3QgdGVtcGxhdGVWYWxpZGF0b3IgPSBhanYuY29tcGlsZSh0ZW1wbGF0ZVNjaGVtYSk7XG5leHBvcnQgY29uc3QgaW5zdGFuY2VWYWxpZGF0b3IgPSBhanYuY29tcGlsZShpbnN0YW5jZVNjaGVtYSk7XG4iXX0=