/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.configs;

import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;

public class HotShardRcaConfig {
    public static final String CONFIG_NAME = "hot-shard-rca";
    private final Double cpuUtilizationThreshold;
    private final Integer maxConsumersToSend;
    public static final double DEFAULT_CPU_UTILIZATION_THRESHOLD = 0.015;
    public static final int DEFAULT_TOP_K_CONSUMERS = 50;

    public HotShardRcaConfig(RcaConf rcaConf) {
        this.cpuUtilizationThreshold = rcaConf.readRcaConfig(CONFIG_NAME, "cpu-utilization", 0.015, s -> s > 0.0, Double.class);
        this.maxConsumersToSend = rcaConf.readRcaConfig(CONFIG_NAME, "top-k-consumers", 50, s -> s > 0, Integer.class);
    }

    public double getCpuUtilizationThreshold() {
        return this.cpuUtilizationThreshold;
    }

    public int getMaximumConsumersToSend() {
        return this.maxConsumersToSend;
    }

    public static class RCA_CONF_KEY_CONSTANTS {
        public static final String CPU_UTILIZATION_THRESHOLD = "cpu-utilization";
        public static final String TOP_K_CONSUMERS = "top-k-consumers";
    }
}

