/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.protobuf.GeneratedMessageV3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectJoinStep;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.grpc.FlowUnitMessage;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature.ShardProfileSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.GenericSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.HeatZoneAssigner;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.ShardStore;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.TemperatureDimension;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.TemperatureVector;
import org.opensearch.performanceanalyzer.rca.framework.util.SQLiteQueryUtils;
import org.opensearch.performanceanalyzer.rca.store.rca.hotshard.IndexShardKey;

public class NodeLevelDimensionalSummary
extends GenericSummary {
    public static final String SUMMARY_TABLE_NAME = "NodeLevelDimensionalSummary";
    public static final String ZONE_SUMMARY_TABLE_NAME = "NodeLevelZoneSummary";
    private static final String DIMENSION_KEY = "dimension";
    private static final String MEAN_KEY = "mean";
    private static final String TOTAL_KEY = "total";
    private static final String NUM_SHARDS_KEY = "numShards";
    private final TemperatureDimension profileForDimension;
    private final TemperatureVector.NormalizedValue meanTemperature;
    private final double totalUsage;
    private final NodeLevelZoneSummary[] zoneProfiles;
    private int numberOfShards;

    public NodeLevelDimensionalSummary(TemperatureDimension profileForDimension, TemperatureVector.NormalizedValue meanTemperature, double totalUsage) {
        this.profileForDimension = profileForDimension;
        this.meanTemperature = meanTemperature;
        this.totalUsage = totalUsage;
        this.zoneProfiles = new NodeLevelZoneSummary[HeatZoneAssigner.Zone.values().length];
        for (int i = 0; i < this.zoneProfiles.length; ++i) {
            this.zoneProfiles[i] = new NodeLevelZoneSummary(HeatZoneAssigner.Zone.values()[i]);
        }
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public void setNumberOfShards(int numberOfShards) {
        this.numberOfShards = numberOfShards;
    }

    public void addShardToZone(ShardProfileSummary shard, HeatZoneAssigner.Zone zone) {
        NodeLevelZoneSummary profile = this.zoneProfiles[zone.ordinal()];
        profile.addShard(shard);
    }

    public String toString() {
        return this.toJson().toString();
    }

    public TemperatureVector.NormalizedValue getMeanTemperature() {
        return this.meanTemperature;
    }

    public TemperatureDimension getProfileForDimension() {
        return this.profileForDimension;
    }

    public double getTotalUsage() {
        return this.totalUsage;
    }

    @VisibleForTesting
    public List<ShardProfileSummary> getShardsForZoneInReverseTemperatureOrder(HeatZoneAssigner.Zone zone) {
        return this.zoneProfiles[zone.ordinal()].getShardsInReverseTemperatureOrder();
    }

    @Override
    public <T extends GeneratedMessageV3> T buildSummaryMessage() {
        throw new IllegalArgumentException("This should not be called.");
    }

    @Override
    public void buildSummaryMessageAndAddToFlowUnit(FlowUnitMessage.Builder messageBuilder) {
        throw new IllegalArgumentException("This should not be called.");
    }

    @Override
    public String getTableName() {
        return SUMMARY_TABLE_NAME;
    }

    @Override
    public List<GenericSummary> getNestedSummaryList() {
        ArrayList<GenericSummary> zoneSummaries = new ArrayList<GenericSummary>();
        for (NodeLevelZoneSummary zone : this.zoneProfiles) {
            zoneSummaries.add(zone);
        }
        return zoneSummaries;
    }

    @Override
    public List<Field<?>> getSqlSchema() {
        ArrayList schema = new ArrayList();
        schema.add(DSL.field((Name)DSL.name((String)DIMENSION_KEY), String.class));
        schema.add(DSL.field((Name)DSL.name((String)MEAN_KEY), Short.class));
        schema.add(DSL.field((Name)DSL.name((String)TOTAL_KEY), Double.class));
        schema.add(DSL.field((Name)DSL.name((String)NUM_SHARDS_KEY), Integer.class));
        return schema;
    }

    @Override
    public List<Object> getSqlValue() {
        ArrayList<Object> row = new ArrayList<Object>();
        row.add(this.getProfileForDimension().NAME);
        row.add(this.getMeanTemperature().getPOINTS());
        row.add(this.getTotalUsage());
        row.add(this.getNumberOfShards());
        return row;
    }

    @Override
    public JsonElement toJson() {
        JsonObject summaryObj = new JsonObject();
        summaryObj.addProperty(DIMENSION_KEY, this.getProfileForDimension().NAME);
        summaryObj.addProperty(MEAN_KEY, (Number)this.getMeanTemperature().getPOINTS());
        summaryObj.addProperty(TOTAL_KEY, (Number)this.getTotalUsage());
        summaryObj.addProperty(NUM_SHARDS_KEY, (Number)this.getNumberOfShards());
        JsonArray array = new JsonArray();
        this.getNestedSummaryList().forEach(summary -> array.add(summary.toJson()));
        summaryObj.add(ZONE_SUMMARY_TABLE_NAME, (JsonElement)array);
        return summaryObj;
    }

    public static NodeLevelDimensionalSummary buildFromDb(Record record, DSLContext context) {
        String dimensionName = (String)record.get(DIMENSION_KEY, String.class);
        TemperatureDimension dimension = TemperatureDimension.valueOf(dimensionName);
        Short mean = (Short)record.get(MEAN_KEY, Short.class);
        TemperatureVector.NormalizedValue value = new TemperatureVector.NormalizedValue(mean);
        double total = (Double)record.get(TOTAL_KEY, Double.class);
        int shards = (Integer)record.get(NUM_SHARDS_KEY, Integer.class);
        NodeLevelDimensionalSummary summary = new NodeLevelDimensionalSummary(dimension, value, total);
        summary.setNumberOfShards(shards);
        int dimensionId = (Integer)record.get(SQLiteQueryUtils.getPrimaryKeyColumnName(SUMMARY_TABLE_NAME), Integer.class);
        Field foreignKeyForDimensionalTable = DSL.field((String)SQLiteQueryUtils.getPrimaryKeyColumnName(SUMMARY_TABLE_NAME), Integer.class);
        SelectJoinStep<Record> rcaQuery = SQLiteQueryUtils.buildSummaryQuery(context, ZONE_SUMMARY_TABLE_NAME, dimensionId, (Field<Integer>)foreignKeyForDimensionalTable);
        Result recordList = rcaQuery.fetch();
        ShardStore shardStore = new ShardStore();
        for (Record zoneSummary : recordList) {
            summary.buildZoneProfile(zoneSummary, shardStore);
        }
        return summary;
    }

    private void buildZoneProfile(Record record, ShardStore shardStore) {
        String zoneName = (String)record.get("zone", String.class);
        HeatZoneAssigner.Zone zone = HeatZoneAssigner.Zone.valueOf(zoneName);
        NodeLevelZoneSummary zoneSummary = this.zoneProfiles[zone.ordinal()];
        String jsonString = (String)record.get("all_shards", String.class);
        JsonArray jsonArray = new JsonParser().parse(jsonString).getAsJsonArray();
        for (JsonElement element : jsonArray) {
            String indexName = element.getAsJsonObject().get("index_name").getAsString();
            int shardId = element.getAsJsonObject().get("shard_id").getAsInt();
            IndexShardKey indexShardKey = new IndexShardKey(indexName, shardId);
            ShardProfileSummary shard = shardStore.getOrCreateIfAbsent(indexShardKey);
            JsonArray temperatureProfiles = element.getAsJsonObject().get("temperature").getAsJsonArray();
            for (JsonElement temperature : temperatureProfiles) {
                JsonObject obj = temperature.getAsJsonObject();
                TemperatureDimension dimension = TemperatureDimension.valueOf(obj.get(DIMENSION_KEY).getAsString());
                TemperatureVector.NormalizedValue value = new TemperatureVector.NormalizedValue((short)obj.get("value").getAsInt());
                shard.addTemperatureForDimension(dimension, value);
            }
            zoneSummary.addShard(shard);
        }
    }

    private class ShardProfileComparator
    implements Comparator<ShardProfileSummary> {
        private ShardProfileComparator() {
        }

        @Override
        public int compare(ShardProfileSummary o1, ShardProfileSummary o2) {
            return this.reverseSort(o1, o2);
        }

        private int reverseSort(ShardProfileSummary o1, ShardProfileSummary o2) {
            return o2.getHeatInDimension(NodeLevelDimensionalSummary.this.profileForDimension).getPOINTS() - o1.getHeatInDimension(NodeLevelDimensionalSummary.this.profileForDimension).getPOINTS();
        }
    }

    public class NodeLevelZoneSummary
    extends GenericSummary {
        public static final String ZONE_KEY = "zone";
        public static final String ALL_KEY = "all_shards";
        List<ShardProfileSummary> shardProfileSummaries;
        private final HeatZoneAssigner.Zone myZone;

        NodeLevelZoneSummary(HeatZoneAssigner.Zone myZone) {
            this.myZone = myZone;
            this.shardProfileSummaries = new ArrayList<ShardProfileSummary>();
        }

        void addShard(ShardProfileSummary shard) {
            this.shardProfileSummaries.add(shard);
        }

        public List<ShardProfileSummary> getShardsInReverseTemperatureOrder() {
            this.shardProfileSummaries.sort(new ShardProfileComparator());
            return Collections.unmodifiableList(this.shardProfileSummaries);
        }

        public String toString() {
            return this.toJson().toString();
        }

        @Override
        public <T extends GeneratedMessageV3> T buildSummaryMessage() {
            throw new IllegalArgumentException("");
        }

        @Override
        public void buildSummaryMessageAndAddToFlowUnit(FlowUnitMessage.Builder messageBuilder) {
            throw new IllegalArgumentException("");
        }

        @Override
        public String getTableName() {
            return NodeLevelDimensionalSummary.ZONE_SUMMARY_TABLE_NAME;
        }

        @Override
        public List<Field<?>> getSqlSchema() {
            ArrayList schema = new ArrayList();
            schema.add(DSL.field((Name)DSL.name((String)ZONE_KEY), String.class));
            schema.add(DSL.field((Name)DSL.name((String)ALL_KEY), String.class));
            return schema;
        }

        @Override
        public List<GenericSummary> getNestedSummaryList() {
            ArrayList<GenericSummary> shardSummaries = new ArrayList<GenericSummary>();
            for (ShardProfileSummary shardProfileSummary : this.getShardsInReverseTemperatureOrder()) {
                shardSummaries.add(shardProfileSummary);
            }
            return shardSummaries;
        }

        @Override
        public List<Object> getSqlValue() {
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(this.myZone.name());
            JsonArray array = new JsonArray();
            for (ShardProfileSummary shard : this.shardProfileSummaries) {
                if (shard == null) continue;
                array.add((JsonElement)shard.toJson());
            }
            values.add(array);
            return values;
        }

        @Override
        public JsonElement toJson() {
            JsonObject summaryObj = new JsonObject();
            summaryObj.addProperty(ZONE_KEY, this.myZone.name());
            JsonArray array = new JsonArray();
            this.getNestedSummaryList().forEach(summary -> array.add(summary.toJson()));
            summaryObj.add(ALL_KEY, (JsonElement)array);
            return summaryObj;
        }
    }
}

