/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.core;

import java.util.LinkedList;
import java.util.List;
import org.opensearch.performanceanalyzer.rca.exceptions.MalformedAnalysisGraph;
import org.opensearch.performanceanalyzer.rca.framework.api.Metric;
import org.opensearch.performanceanalyzer.rca.framework.core.GenericFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.core.Node;
import org.opensearch.performanceanalyzer.rca.framework.core.Operable;
import org.opensearch.performanceanalyzer.rca.framework.core.Stats;

public abstract class NonLeafNode<T extends GenericFlowUnit>
extends Node<T>
implements Operable<T> {
    public NonLeafNode(int level, long evaluationDurationSeconds) {
        super(level, evaluationDurationSeconds);
        Stats stats = Stats.getInstance();
        stats.incrementTotalNodesCount();
    }

    public void addAllUpstreams(List<Node<?>> upstreams) {
        int minGraphId = this.validateAndAddDownstream(upstreams);
        this.setGraphId(this.updateGraphs(minGraphId, upstreams));
        this.upStreams = upstreams;
    }

    private int updateGraphs(int minId, List<Node<?>> upstreams) {
        LinkedList bfsQueue = new LinkedList(upstreams);
        while (!bfsQueue.isEmpty()) {
            Node currentNode = (Node)bfsQueue.poll();
            int graphId = currentNode.getGraphId();
            if (minId != graphId) {
                currentNode.setGraphId(minId);
                Stats.getInstance().removeGraph(graphId);
            }
            List<Node<?>> currentNodeUpstreams = currentNode.getUpstreams();
            bfsQueue.addAll(currentNodeUpstreams);
        }
        return minId;
    }

    private int validateAndAddDownstream(List<Node<?>> upstreams) {
        if (this.upStreams != null) {
            throw new MalformedAnalysisGraph("All upstreams of a node should be added at once.");
        }
        StringBuilder metricNodesNotAdded = new StringBuilder();
        String metricNodeDelimeter = "";
        boolean foundNotAddedMetrics = false;
        int maxLevel = 0;
        int minId = Integer.MAX_VALUE;
        for (Node<?> node : upstreams) {
            if (node instanceof Metric && !((Metric)node).isAddedToFlowField()) {
                metricNodesNotAdded.append(metricNodeDelimeter).append(node.getClass().getSimpleName());
                metricNodeDelimeter = ", ";
                foundNotAddedMetrics = true;
            }
            minId = Integer.min(minId, node.getGraphId());
            int nodeLevel = node.getLevel();
            maxLevel = nodeLevel > maxLevel ? nodeLevel : maxLevel;
            node.addDownstream(this);
        }
        if (foundNotAddedMetrics) {
            throw new MalformedAnalysisGraph(String.format("These metrics are not added to the AnalysisGraph yet: %s ", metricNodesNotAdded.toString()));
        }
        this.setLevel(maxLevel + 1);
        return minId;
    }
}

