/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.scheduler;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.commons.stats.ServiceMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.rca.framework.core.Stats;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaGraphMetrics;
import org.opensearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;

public class GraphNodeOperations {
    private static final Logger LOG = LogManager.getLogger(GraphNodeOperations.class);

    static void readFromLocal(FlowUnitOperationArgWrapper args) {
        if (Stats.getInstance().isNodeMuted(args.getNode().name())) {
            args.getNode().handleNodeMuted();
            return;
        }
        args.getNode().generateFlowUnitListFromLocal(args);
        args.getNode().persistFlowUnit(args);
        ServiceMetrics.RCA_GRAPH_METRICS_AGGREGATOR.updateStat((MeasurementSet)RcaGraphMetrics.NUM_NODES_EXECUTED_LOCALLY, (Number)1);
    }

    static void readFromWire(FlowUnitOperationArgWrapper args) {
        args.getNode().generateFlowUnitListFromWire(args);
        ServiceMetrics.RCA_GRAPH_METRICS_AGGREGATOR.updateStat((MeasurementSet)RcaGraphMetrics.NUM_NODES_EXECUTED_REMOTELY, (Number)1);
    }
}

