/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.DatePart;
import org.jooq.Field;
import org.jooq.Function2;
import org.jooq.Param;
import org.jooq.QueryPart;
import org.jooq.SQLDialect;
import org.jooq.Typed;
import org.jooq.conf.TransformUnneededArithmeticExpressions;
import org.jooq.exception.DataTypeException;
import org.jooq.impl.AbstractField;
import org.jooq.impl.AbstractParamX;
import org.jooq.impl.AbstractTransformable;
import org.jooq.impl.DSL;
import org.jooq.impl.DateAdd;
import org.jooq.impl.ExpressionOperator;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.types.DayToSecond;
import org.jooq.types.Interval;
import org.jooq.types.YearToMonth;
import org.jooq.types.YearToSecond;

final class Expression<T>
extends AbstractTransformable<T>
implements QOM.UOperator2<Field<T>, Field<?>, Field<T>> {
    static final Set<SQLDialect> HASH_OP_FOR_BIT_XOR = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> SUPPORT_YEAR_TO_SECOND = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    private final ExpressionOperator operator;
    private final boolean internal;
    private final Field<T> lhs;
    private final Field<?> rhs;
    private static final Pattern TRUNC_TO_MICROS = Pattern.compile("([^.]*\\.\\d{0,6})\\d{0,3}");

    Expression(ExpressionOperator operator, boolean internal, Field<T> lhs, Field<?> rhs) {
        super(DSL.name(operator.toSQL()), lhs.getDataType());
        this.operator = operator;
        this.internal = internal;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    static final DataType<?> getExpressionDataType(AbstractField<?> l, ExpressionOperator operator, AbstractField<?> r) {
        DataType<?> lt = l.getExpressionDataType();
        DataType<?> rt = r.getExpressionDataType();
        switch (operator) {
            case MULTIPLY: 
            case DIVIDE: {
                return rt.isInterval() ? rt : lt;
            }
            case ADD: {
                return lt.isInterval() ? rt : lt;
            }
        }
        return lt;
    }

    @Override
    final DataType<?> getExpressionDataType() {
        return Expression.getExpressionDataType((AbstractField)this.lhs, this.operator, (AbstractField)this.rhs);
    }

    @Override
    final void accept0(Context<?> ctx) {
        SQLDialect family = ctx.family();
        if ((ExpressionOperator.ADD == this.operator || ExpressionOperator.SUBTRACT == this.operator) && this.lhs.getDataType().isDateTime() && (this.rhs.getDataType().isNumeric() || this.rhs.getDataType().isInterval())) {
            ctx.visit(new DateExpression<T>(this.lhs, this.operator, this.rhs));
        } else {
            ctx.sql('(').visit(this.lhs).sql(' ').sql(this.operator.toSQL()).sql(' ').visit(this.rhs).sql(')');
        }
    }

    @Override
    public final Field<T> transform(TransformUnneededArithmeticExpressions transform) {
        return Expression.transform(this, this.lhs, this.operator, this.rhs, this.internal, transform);
    }

    static final <T> Field<T> transform(QOM.UOperator2<Field<T>, Field<T>, Field<T>> expression, Field<T> lhs, ExpressionOperator operator, Field<T> rhs, boolean internal, TransformUnneededArithmeticExpressions transform) {
        return (Field)((Object)expression);
    }

    private final Field<Number> lhsAsNumber() {
        return this.lhs;
    }

    private final Field<Number> rhsAsNumber() {
        return this.rhs;
    }

    static final <Q1 extends QueryPart, Q2 extends Q1> void acceptAssociative(Context<?> ctx, Q2 exp, Function<? super Q2, ? extends Expr<Q1>> expProvider, Consumer<? super Context<?>> formatSeparator) {
        Object o;
        Expr<Q1> e = expProvider.apply(exp);
        Class<?> expType = exp.getClass();
        ArrayList<Object> elements = new ArrayList<Object>();
        ArrayDeque<Expr<Object>> queue = new ArrayDeque<Expr<Object>>();
        queue.push(e);
        while ((o = queue.pollFirst()) != null) {
            if (o instanceof Expr) {
                boolean associativity;
                Expr p = (Expr)o;
                boolean bl = associativity = e.lhs instanceof Typed && e.rhs instanceof Typed ? ((Typed)e.lhs).getDataType().equals(((Typed)e.rhs).getDataType()) : true;
                if (associativity && expType.isInstance(p.rhs)) {
                    queue.push(expProvider.apply(p.rhs));
                } else {
                    queue.push((Expr<Object>)p.rhs);
                }
                if (associativity && expType.isInstance(p.lhs)) {
                    queue.push(expProvider.apply(p.lhs));
                    continue;
                }
                elements.add(p.lhs);
                continue;
            }
            elements.add((QueryPart)o);
        }
        for (int i = 0; i < elements.size(); ++i) {
            if (i > 0) {
                formatSeparator.accept(ctx);
                ctx.visit(e.op).sql(' ');
            }
            ctx.visit((QueryPart)elements.get(i));
        }
    }

    @Override
    public final Field<T> $arg1() {
        return this.lhs;
    }

    @Override
    public final Field<?> $arg2() {
        return this.rhs;
    }

    @Override
    public final Expression<T> $arg1(Field<T> newValue) {
        return this.constructor().apply(newValue, (Field<?>)this.$arg2());
    }

    @Override
    public final Expression<T> $arg2(Field<?> newValue) {
        return this.constructor().apply((Field<T>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T>, ? super Field<?>, ? extends Expression<T>> constructor() {
        return (a1, a2) -> new Expression<T>(this.operator, this.internal, a1, (Field<?>)a2);
    }

    static final class Expr<Q extends QueryPart> {
        private final Q lhs;
        private final QueryPart op;
        private final Q rhs;

        public Expr(Q lhs, QueryPart op, Q rhs) {
            this.lhs = lhs;
            this.op = op;
            this.rhs = rhs;
        }

        public Q lhs() {
            return this.lhs;
        }

        public QueryPart op() {
            return this.op;
        }

        public Q rhs() {
            return this.rhs;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Expr)) {
                return false;
            }
            Expr other = (Expr)o;
            if (!Objects.equals(this.lhs, other.lhs)) {
                return false;
            }
            if (!Objects.equals(this.op, other.op)) {
                return false;
            }
            return Objects.equals(this.rhs, other.rhs);
        }

        public int hashCode() {
            return Objects.hash(this.lhs, this.op, this.rhs);
        }

        public String toString() {
            return "Expr[" + "lhs=" + this.lhs + ", op=" + this.op + ", rhs=" + this.rhs + "]";
        }
    }

    private static class DateExpression<T>
    extends AbstractField<T>
    implements QOM.UTransient {
        private final Field<T> lhs;
        private final ExpressionOperator operator;
        private final Field<?> rhs;

        DateExpression(Field<T> lhs, ExpressionOperator operator, Field<?> rhs) {
            super(DSL.name(operator.toSQL()), lhs.getDataType());
            this.lhs = lhs;
            this.operator = operator;
            this.rhs = rhs;
        }

        private final <U> Field<U> p(U u) {
            Param<U> result = DSL.val(u);
            if (((Param)this.rhs).isInline()) {
                ((AbstractParamX)result).setInline0(true);
            }
            return result;
        }

        @Override
        public final void accept(Context<?> ctx) {
            if (this.rhs.getType() == YearToSecond.class && !SUPPORT_YEAR_TO_SECOND.contains((Object)ctx.dialect())) {
                this.acceptYTSExpression(ctx);
            } else if (this.rhs.getDataType().isInterval()) {
                this.acceptIntervalExpression(ctx);
            } else {
                this.acceptNumberExpression(ctx);
            }
        }

        private final void acceptYTSExpression(Context<?> ctx) {
            if (this.rhs instanceof Param) {
                YearToSecond yts = this.rhsAsYTS();
                ctx.visit(new DateExpression<T>(new DateExpression<T>(this.lhs, this.operator, this.p(yts.getYearToMonth())), this.operator, this.p(yts.getDayToSecond())));
            } else {
                this.acceptIntervalExpression(ctx);
            }
        }

        private final void acceptIntervalExpression(Context<?> ctx) {
            SQLDialect family = ctx.family();
            int sign = this.operator == ExpressionOperator.ADD ? 1 : -1;
            switch (family) {
                case CUBRID: 
                case MARIADB: 
                case MYSQL: {
                    Interval interval = this.rhsAsInterval();
                    if (this.operator == ExpressionOperator.SUBTRACT) {
                        interval = interval.neg();
                    }
                    if (this.rhs.getType() == YearToMonth.class) {
                        ctx.visit(Names.N_DATE_ADD).sql('(').visit(this.lhs).sql(", ").visit(Keywords.K_INTERVAL).sql(' ').visit(Tools.field((Object)interval, SQLDataType.VARCHAR)).sql(' ').visit(Keywords.K_YEAR_MONTH).sql(')');
                        break;
                    }
                    if (family == SQLDialect.CUBRID) {
                        ctx.visit(Names.N_DATE_ADD).sql('(').visit(this.lhs).sql(", ").visit(Keywords.K_INTERVAL).sql(' ').visit(Tools.field((Object)interval, SQLDataType.VARCHAR)).sql(' ').visit(Keywords.K_DAY_MILLISECOND).sql(')');
                        break;
                    }
                    ctx.visit(Names.N_DATE_ADD).sql('(').visit(this.lhs).sql(", ").visit(Keywords.K_INTERVAL).sql(' ').visit(Tools.field((Object)TRUNC_TO_MICROS.matcher("" + interval).replaceAll("$1"), SQLDataType.VARCHAR)).sql(' ').visit(Keywords.K_DAY_MICROSECOND).sql(')');
                    break;
                }
                case DERBY: {
                    boolean needsCast;
                    boolean bl = needsCast = this.getDataType().getType() != Timestamp.class;
                    if (needsCast) {
                        ctx.visit(Keywords.K_CAST).sql('(');
                    }
                    if (this.rhs.getType() == YearToMonth.class) {
                        ctx.sql("{fn ").visit(Names.N_TIMESTAMPADD).sql('(').visit(Names.N_SQL_TSI_MONTH).sql(", ").visit(this.p(sign * this.rhsAsYTM().intValue())).sql(", ").visit(this.lhs).sql(") }");
                    } else {
                        ctx.sql("{fn ").visit(Names.N_TIMESTAMPADD).sql('(').visit(Names.N_SQL_TSI_SECOND).sql(", ").visit(this.p((long)sign * (long)this.rhsAsDTS().getTotalSeconds())).sql(", {fn ").visit(Names.N_TIMESTAMPADD).sql('(').visit(ctx.family() == SQLDialect.DERBY ? Names.N_SQL_TSI_FRAC_SECOND : Names.N_SQL_TSI_MILLI_SECOND).sql(", ").visit(this.p((long)sign * (long)this.rhsAsDTS().getMilli() * (ctx.family() == SQLDialect.DERBY ? 1000000L : 1L))).sql(", ").visit(this.lhs).sql(") }) }");
                    }
                    if (!needsCast) break;
                    ctx.sql(' ').visit(Keywords.K_AS).sql(' ').visit(DSL.keyword(this.getDataType().getCastTypeName(ctx.configuration()))).sql(')');
                    break;
                }
                case FIREBIRD: {
                    if (this.rhs.getType() == YearToMonth.class) {
                        ctx.visit(Names.N_DATEADD).sql('(').visit(Keywords.K_MONTH).sql(", ").visit(this.p(sign * this.rhsAsYTM().intValue())).sql(", ").visit(this.lhs).sql(')');
                        break;
                    }
                    if (this.rhsAsDTS().getMilli() > 0) {
                        ctx.visit(Names.N_DATEADD).sql('(').visit(Keywords.K_MILLISECOND).sql(", ").visit(this.p((long)sign * (long)this.rhsAsDTS().getMilli())).sql(", ").visit(Names.N_DATEADD).sql('(').visit(Keywords.K_SECOND).sql(", ").visit(this.p((long)sign * (long)this.rhsAsDTS().getTotalSeconds())).sql(", ").visit(this.lhs).sql(')').sql(')');
                        break;
                    }
                    ctx.visit(Names.N_DATEADD).sql('(').visit(Keywords.K_SECOND).sql(", ").visit(this.p((long)sign * (long)this.rhsAsDTS().getTotalSeconds())).sql(", ").visit(this.lhs).sql(')');
                    break;
                }
                case SQLITE: {
                    boolean ytm = this.rhs.getType() == YearToMonth.class;
                    Field<Object> interval = this.p(ytm ? (double)this.rhsAsYTM().intValue() : this.rhsAsDTS().getTotalSeconds());
                    if (sign < 0) {
                        interval = interval.neg();
                    }
                    interval = interval.concat(DSL.inline(ytm ? " months" : " seconds"));
                    ctx.visit(Names.N_STRFTIME).sql("('%Y-%m-%d %H:%M:%f', ").visit(this.lhs).sql(", ").visit(interval).sql(')');
                    break;
                }
                default: {
                    ctx.sql('(').visit(this.lhs).sql(' ').sql(this.operator.toSQL()).sql(' ').visit(this.rhs).sql(')');
                }
            }
        }

        private final void acceptNumberExpression(Context<?> ctx) {
            switch (ctx.family()) {
                case FIREBIRD: {
                    if (this.operator == ExpressionOperator.ADD) {
                        ctx.visit(Names.N_DATEADD).sql('(').visit(Keywords.K_DAY).sql(", ").visit(this.rhsAsNumber()).sql(", ").visit(this.lhs).sql(')');
                        break;
                    }
                    ctx.visit(Names.N_DATEADD).sql('(').visit(Keywords.K_DAY).sql(", ").visit(this.rhsAsNumber().neg()).sql(", ").visit(this.lhs).sql(')');
                    break;
                }
                case HSQLDB: {
                    if (this.operator == ExpressionOperator.ADD) {
                        ctx.visit(this.lhs.add(DSL.field("({0}) day", this.rhsAsNumber())));
                        break;
                    }
                    ctx.visit(this.lhs.sub(DSL.field("({0}) day", this.rhsAsNumber())));
                    break;
                }
                case DERBY: {
                    boolean needsCast;
                    boolean bl = needsCast = this.getDataType().getType() != Timestamp.class;
                    if (needsCast) {
                        ctx.visit(Keywords.K_CAST).sql('(');
                    }
                    if (this.operator == ExpressionOperator.ADD) {
                        ctx.sql("{fn ").visit(Names.N_TIMESTAMPADD).sql('(').visit(DSL.keyword("sql_tsi_day")).sql(", ").visit(this.rhsAsNumber()).sql(", ").visit(this.lhs).sql(") }");
                    } else {
                        ctx.sql("{fn ").visit(Names.N_TIMESTAMPADD).sql('(').visit(DSL.keyword("sql_tsi_day")).sql(", ").visit(this.rhsAsNumber().neg()).sql(", ").visit(this.lhs).sql(") }");
                    }
                    if (!needsCast) break;
                    ctx.sql(' ').visit(Keywords.K_AS).sql(' ').visit(DSL.keyword(this.getDataType().getCastTypeName(ctx.configuration()))).sql(')');
                    break;
                }
                case CUBRID: 
                case MARIADB: 
                case MYSQL: {
                    if (this.operator == ExpressionOperator.ADD) {
                        ctx.visit(Names.N_DATE_ADD).sql('(').visit(this.lhs).sql(", ").visit(Keywords.K_INTERVAL).sql(' ').visit(this.rhsAsNumber()).sql(' ').visit(Keywords.K_DAY).sql(')');
                        break;
                    }
                    ctx.visit(Names.N_DATE_ADD).sql('(').visit(this.lhs).sql(", ").visit(Keywords.K_INTERVAL).sql(' ').visit(this.rhsAsNumber().neg()).sql(' ').visit(Keywords.K_DAY).sql(')');
                    break;
                }
                case POSTGRES: 
                case YUGABYTEDB: {
                    if (this.operator == ExpressionOperator.ADD) {
                        ctx.visit(new DateAdd<T>(this.lhs, this.rhsAsNumber(), DatePart.DAY));
                        break;
                    }
                    ctx.visit(new DateAdd<T>(this.lhs, this.rhsAsNumber().neg(), DatePart.DAY));
                    break;
                }
                case SQLITE: {
                    if (this.operator == ExpressionOperator.ADD) {
                        ctx.visit(Names.N_STRFTIME).sql("('%Y-%m-%d %H:%M:%f', ").visit(this.lhs).sql(", ").visit(this.rhsAsNumber().concat(DSL.inline(" day"))).sql(')');
                        break;
                    }
                    ctx.visit(Names.N_STRFTIME).sql("('%Y-%m-%d %H:%M:%f', ").visit(this.lhs).sql(", ").visit(this.rhsAsNumber().neg().concat(DSL.inline(" day"))).sql(')');
                    break;
                }
                default: {
                    ctx.sql('(').visit(this.lhs).sql(' ').sql(this.operator.toSQL()).sql(' ').visit(this.rhs).sql(')');
                }
            }
        }

        private final YearToSecond rhsAsYTS() {
            try {
                return (YearToSecond)((Param)this.rhs).getValue();
            }
            catch (ClassCastException e) {
                throw new DataTypeException("Cannot perform datetime arithmetic with a non-numeric, non-interval data type on the right hand side of the expression: " + this.rhs, e);
            }
        }

        private final YearToMonth rhsAsYTM() {
            try {
                return (YearToMonth)((Param)this.rhs).getValue();
            }
            catch (ClassCastException e) {
                throw new DataTypeException("Cannot perform datetime arithmetic with a non-numeric, non-interval data type on the right hand side of the expression: " + this.rhs, e);
            }
        }

        private final DayToSecond rhsAsDTS() {
            try {
                return (DayToSecond)((Param)this.rhs).getValue();
            }
            catch (ClassCastException e) {
                throw new DataTypeException("Cannot perform datetime arithmetic with a non-numeric, non-interval data type on the right hand side of the expression: " + this.rhs, e);
            }
        }

        private final Interval rhsAsInterval() {
            try {
                return (Interval)((Param)this.rhs).getValue();
            }
            catch (ClassCastException e) {
                throw new DataTypeException("Cannot perform datetime arithmetic with a non-numeric, non-interval data type on the right hand side of the expression: " + this.rhs, e);
            }
        }

        private final Field<Number> rhsAsNumber() {
            return this.rhs;
        }
    }
}

