/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jooq.AggregateFilterStep;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Fields;
import org.jooq.JSON;
import org.jooq.JSONArrayAggNullStep;
import org.jooq.JSONArrayAggOrderByStep;
import org.jooq.JSONArrayAggReturningStep;
import org.jooq.JSONArrayNullStep;
import org.jooq.JSONArrayReturningStep;
import org.jooq.JSONB;
import org.jooq.JSONEntry;
import org.jooq.JSONObjectNullStep;
import org.jooq.JSONObjectReturningStep;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Scope;
import org.jooq.Select;
import org.jooq.SelectJoinStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.XML;
import org.jooq.XMLAggOrderByStep;
import org.jooq.impl.AbstractField;
import org.jooq.impl.AbstractRow;
import org.jooq.impl.AliasedSelect;
import org.jooq.impl.DSL;
import org.jooq.impl.JSONArrayAgg;
import org.jooq.impl.JSONEntryImpl;
import org.jooq.impl.Keywords;
import org.jooq.impl.MultisetDataType;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;

final class Multiset<R extends Record>
extends AbstractField<Result<R>>
implements QOM.Multiset<R> {
    static final Set<SQLDialect> NO_SUPPORT_JSON_COMPARE = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> NO_SUPPORT_JSONB_COMPARE = SQLDialect.supportedBy(new SQLDialect[0]);
    static final Set<SQLDialect> NO_SUPPORT_XML_COMPARE = SQLDialect.supportedBy(SQLDialect.POSTGRES);
    static final Set<SQLDialect> FORCE_LIMIT_IN_DERIVED_TABLE = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    final Select<R> select;

    Multiset(Select<R> select) {
        super(Names.N_MULTISET, new MultisetDataType((AbstractRow)((Object)DSL.row(select.getSelect())), select.getRecordType()));
        this.select = select;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (Boolean.TRUE.equals(ctx.data((Object)Tools.BooleanDataKey.DATA_MULTISET_CONDITION))) {
            ctx.data().remove((Object)Tools.BooleanDataKey.DATA_MULTISET_CONDITION);
            ctx.data((Object)Tools.BooleanDataKey.DATA_MULTISET_CONTENT, true, c -> this.accept0((Context<?>)c, true));
            ctx.data((Object)Tools.BooleanDataKey.DATA_MULTISET_CONDITION, true);
        } else {
            ctx.data((Object)Tools.BooleanDataKey.DATA_MULTISET_CONTENT, true, c -> this.accept0((Context<?>)c, false));
        }
    }

    private final void accept0(Context<?> ctx, boolean multisetCondition) {
        switch (Tools.emulateMultiset(ctx.configuration())) {
            case JSON: {
                JSONArrayAggOrderByStep<JSON> order;
                Table<R> t = new AliasedSelect<R>(this.select, true, false, FORCE_LIMIT_IN_DERIVED_TABLE.contains((Object)ctx.dialect()), Tools.fieldNames(this.select.getSelect().size())).as(DSL.name("t"), (Name[])null);
                switch (ctx.family()) {
                    default: 
                }
                JSONArrayAggNullStep<JSON> returning = order = Multiset.jsonArrayaggEmulation(ctx, t, false);
                if (multisetCondition) {
                    returning = order.orderBy(t.fields());
                }
                Select s = JSONArrayAgg.patchOracleArrayAggBug(ctx, DSL.select(DSL.coalesce(Multiset.returningClob(ctx, returning), Multiset.returningClob(ctx, DSL.jsonArray(new Field[0])))).from((TableLike<?>)t));
                if (multisetCondition && NO_SUPPORT_JSON_COMPARE.contains((Object)ctx.dialect())) {
                    ctx.visit(DSL.field(s).cast(SQLDataType.VARCHAR));
                    break;
                }
                Tools.visitSubquery(ctx, s, true);
                break;
            }
            case JSONB: {
                JSONArrayAggOrderByStep<JSONB> order;
                Table<R> t = new AliasedSelect<R>(this.select, true, false, FORCE_LIMIT_IN_DERIVED_TABLE.contains((Object)ctx.dialect()), Tools.fieldNames(this.select.getSelect().size())).as(DSL.name("t"), (Name[])null);
                switch (ctx.family()) {
                    default: 
                }
                JSONArrayAggNullStep<JSONB> returning = order = Multiset.jsonbArrayaggEmulation(ctx, t, false);
                if (multisetCondition) {
                    returning = order.orderBy(t.fields());
                }
                Select s = JSONArrayAgg.patchOracleArrayAggBug(ctx, DSL.select(DSL.coalesce(Multiset.returningClob(ctx, returning), Multiset.returningClob(ctx, DSL.jsonbArray(new Field[0])))).from((TableLike<?>)t));
                if (multisetCondition && NO_SUPPORT_JSONB_COMPARE.contains((Object)ctx.dialect())) {
                    ctx.visit(DSL.field(s).cast(SQLDataType.VARCHAR));
                    break;
                }
                Tools.visitSubquery(ctx, s, true);
                break;
            }
            case XML: {
                XMLAggOrderByStep<XML> order;
                List<Field<?>> fields = this.select.getSelect();
                Table<R> t = new AliasedSelect<R>(this.select, true, false, FORCE_LIMIT_IN_DERIVED_TABLE.contains((Object)ctx.dialect()), Tools.fieldNames(fields.size())).as(DSL.name("t"), (Name[])null);
                switch (ctx.family()) {
                    default: 
                }
                AggregateFilterStep<XML> filter = order = Multiset.xmlaggEmulation(t, false);
                if (multisetCondition) {
                    filter = order.orderBy(t.fields());
                }
                SelectJoinStep s = DSL.select(DSL.xmlelement(Names.N_RESULT, filter)).from((TableLike<?>)t);
                if (multisetCondition && NO_SUPPORT_XML_COMPARE.contains((Object)ctx.dialect())) {
                    ctx.visit(DSL.xmlserializeContent(DSL.field(s), SQLDataType.VARCHAR));
                    break;
                }
                Tools.visitSubquery(ctx, s, true);
                break;
            }
            case NATIVE: {
                Tools.visitSubquery(ctx.visit(Keywords.K_MULTISET), this.select, true);
            }
        }
    }

    static final <J> Field<J> returningClob(Scope ctx, JSONObjectReturningStep<J> j) {
        switch (ctx.family()) {
            default: 
        }
        return j;
    }

    static final <J> Field<J> returningClob(Scope ctx, JSONArrayReturningStep<J> j) {
        switch (ctx.family()) {
            default: 
        }
        return j;
    }

    static final <J> Field<J> returningClob(Scope ctx, JSONArrayAggReturningStep<J> j) {
        switch (ctx.family()) {
            default: 
        }
        return j;
    }

    static final JSONArrayAggOrderByStep<JSON> jsonArrayaggEmulation(Scope ctx, Fields fields, boolean agg) {
        return Multiset.jsonxArrayaggEmulation(ctx, fields, agg, DSL::jsonArrayAgg, DSL::jsonObject, DSL::jsonArray);
    }

    static final JSONArrayAggOrderByStep<JSONB> jsonbArrayaggEmulation(Scope ctx, Fields fields, boolean agg) {
        return Multiset.jsonxArrayaggEmulation(ctx, fields, agg, DSL::jsonbArrayAgg, DSL::jsonbObject, DSL::jsonbArray);
    }

    static final <J> JSONArrayAggOrderByStep<J> jsonxArrayaggEmulation(Scope ctx, Fields fields, boolean agg, Function<? super Field<?>, ? extends JSONArrayAggOrderByStep<J>> jsonxArrayAgg, Function<? super Collection<? extends JSONEntry<?>>, ? extends JSONObjectNullStep<J>> jsonxObject, Function<? super Collection<? extends Field<?>>, ? extends JSONArrayNullStep<J>> jsonxArray) {
        switch (ctx.family()) {
            default: 
        }
        return jsonxArrayAgg.apply(Multiset.returningClob(ctx, jsonxArray.apply(Tools.map(fields.fields(), (f, i) -> JSONEntryImpl.unescapeNestedJSON(ctx, agg ? f : DSL.field(Tools.fieldName(i), f.getDataType())))).nullOnNull()));
    }

    static final XMLAggOrderByStep<XML> xmlaggEmulation(Fields fields, boolean agg) {
        return DSL.xmlagg(DSL.xmlelement(Names.N_RECORD, Tools.map(fields.fields(), (f, i) -> DSL.xmlelement(Tools.fieldNameString(i), agg ? f : DSL.field(Tools.fieldName(i), f.getDataType())))));
    }

    @Override
    public final Select<R> $select() {
        return this.select;
    }
}

