/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.collectors;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.stats.ServiceMetrics;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatMetrics;

public class ScheduledMetricCollectorsExecutor
extends Thread {
    private static final Logger LOG = LogManager.getLogger(ScheduledMetricCollectorsExecutor.class);
    private final int collectorThreadCount;
    private static final int DEFAULT_COLLECTOR_THREAD_COUNT = 5;
    private static final int COLLECTOR_THREAD_KEEPALIVE_SECS = 1000;
    private final boolean checkFeatureDisabledFlag;
    private boolean paEnabled = false;
    private boolean threadContentionMonitoringEnabled = false;
    private int minTimeIntervalToSleep = Integer.MAX_VALUE;
    private Map<PerformanceAnalyzerMetricsCollector, Long> metricsCollectors = new HashMap<PerformanceAnalyzerMetricsCollector, Long>();
    public static final String COLLECTOR_THREAD_POOL_NAME = "pa-collectors-th";
    private ThreadPoolExecutor metricsCollectorsTP = null;

    public ScheduledMetricCollectorsExecutor(int collectorThreadCount, boolean checkFeatureDisabledFlag) {
        this.collectorThreadCount = collectorThreadCount;
        this.checkFeatureDisabledFlag = checkFeatureDisabledFlag;
    }

    public ScheduledMetricCollectorsExecutor() {
        this(5, true);
    }

    public synchronized void setEnabled(boolean enabled) {
        this.paEnabled = enabled;
    }

    public synchronized boolean getEnabled() {
        return this.paEnabled;
    }

    public synchronized void setThreadContentionMonitoringEnabled(boolean enabled) {
        this.metricsCollectors.keySet().forEach(collector -> collector.setThreadContentionMonitoringEnabled(enabled));
        this.threadContentionMonitoringEnabled = enabled;
    }

    private synchronized boolean getThreadContentionMonitoringEnabled() {
        return this.threadContentionMonitoringEnabled;
    }

    public void addScheduledMetricCollector(PerformanceAnalyzerMetricsCollector task) {
        task.setThreadContentionMonitoringEnabled(this.getThreadContentionMonitoringEnabled());
        this.metricsCollectors.put(task, System.currentTimeMillis() + (long)task.getTimeInterval());
        if (task.getTimeInterval() < this.minTimeIntervalToSleep) {
            this.minTimeIntervalToSleep = task.getTimeInterval();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        Thread.currentThread().setName(this.getClass().getSimpleName());
        if (this.metricsCollectorsTP == null) {
            taskThreadFactory = new ThreadFactoryBuilder().setNameFormat("pa-collectors-th").setDaemon(true).build();
            this.metricsCollectorsTP = new ThreadPoolExecutor(this.collectorThreadCount, this.collectorThreadCount, 1000L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.metricsCollectors.size()), taskThreadFactory);
        }
        prevStartTimestamp = System.currentTimeMillis();
        block2: while (true) {
            try {
                millisToSleep = (long)this.minTimeIntervalToSleep - System.currentTimeMillis() + prevStartTimestamp;
                if (millisToSleep > 0L) {
                    Thread.sleep(millisToSleep);
                }
            }
            catch (Exception ex) {
                ScheduledMetricCollectorsExecutor.LOG.error("Exception in Thread Sleep", (Throwable)ex);
            }
            prevStartTimestamp = System.currentTimeMillis();
            if (!this.getEnabled()) continue;
            currentTime = System.currentTimeMillis();
            var5_5 = this.metricsCollectors.entrySet().iterator();
            while (true) {
                if (var5_5.hasNext()) ** break;
                continue block2;
                entry = var5_5.next();
                if (entry.getValue() > currentTime) continue;
                collector = entry.getKey();
                if (collector.getState() == PerformanceAnalyzerMetricsCollector.State.MUTED) {
                    ServiceMetrics.COMMONS_STAT_METRICS_AGGREGATOR.updateStat(StatMetrics.COLLECTORS_MUTED, collector.getCollectorName(), 1);
                    continue;
                }
                this.metricsCollectors.put(collector, entry.getValue() + (long)collector.getTimeInterval());
                if (!collector.inProgress()) {
                    collector.setStartTime(currentTime);
                    this.metricsCollectorsTP.execute(collector);
                    continue;
                }
                if (collector.getCollectorName().equals("StatsCollector")) {
                    ScheduledMetricCollectorsExecutor.LOG.info(" {} is still in progress; StatsCollector is critical for framework service metrics", (Object)"StatsCollector");
                    return;
                }
                if (collector.getState() == PerformanceAnalyzerMetricsCollector.State.HEALTHY) {
                    collector.setState(PerformanceAnalyzerMetricsCollector.State.SLOW);
                    ServiceMetrics.COMMONS_STAT_METRICS_AGGREGATOR.updateStat(StatMetrics.COLLECTORS_SLOW, collector.getCollectorName(), 1);
                } else if (collector.getState() == PerformanceAnalyzerMetricsCollector.State.SLOW) {
                    collector.setState(PerformanceAnalyzerMetricsCollector.State.MUTED);
                }
                ScheduledMetricCollectorsExecutor.LOG.info("Collector {} is still in progress, so skipping this Interval", (Object)collector.getCollectorName());
                ServiceMetrics.COMMONS_STAT_METRICS_AGGREGATOR.updateStat(StatMetrics.COLLECTORS_SKIPPED, collector.getCollectorName(), 1);
            }
            break;
        }
    }
}

