/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor.format;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.sql.legacy.domain.IndexStatement;

public class Schema
implements Iterable<Column> {
    private String indexName;
    private List<Column> columns;
    private static Set<String> types = Schema.getTypes();

    public Schema(String indexName, List<Column> columns) {
        this.indexName = indexName;
        this.columns = columns;
    }

    public Schema(IndexStatement statement, List<Column> columns) {
        this.indexName = statement.getIndexPattern();
        this.columns = columns;
    }

    public Schema(List<Column> columns) {
        this.columns = columns;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public List<String> getHeaders() {
        return this.columns.stream().map(column -> column.getName()).collect(Collectors.toList());
    }

    public List<Column> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    private static Set<String> getTypes() {
        HashSet<String> types = new HashSet<String>();
        for (Type type : Type.values()) {
            types.add(type.name());
        }
        return types;
    }

    public static boolean hasType(String type) {
        return types.contains(type);
    }

    @Override
    public Iterator<Column> iterator() {
        return new Iterator<Column>(){
            private final Iterator<Column> iter;
            {
                this.iter = Schema.this.columns.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Column next() {
                return this.iter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("No changes allowed to Schema columns");
            }
        };
    }

    public static class Column {
        private final String name;
        private String alias;
        private final Type type;
        private boolean identifiedByAlias;

        public Column(String name, String alias, Type type, boolean identifiedByAlias) {
            this.name = name;
            this.alias = alias;
            this.type = type;
            this.identifiedByAlias = identifiedByAlias;
        }

        public Column(String name, String alias, Type type) {
            this(name, alias, type, false);
        }

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getType() {
            return this.type.nameLowerCase();
        }

        public String getIdentifier() {
            if (this.identifiedByAlias && this.alias != null) {
                return this.alias;
            }
            return this.name;
        }

        public Type getEnumType() {
            return this.type;
        }
    }

    public static enum Type {
        TEXT,
        KEYWORD,
        IP,
        LONG,
        INTEGER,
        SHORT,
        BYTE,
        DOUBLE,
        FLOAT,
        HALF_FLOAT,
        SCALED_FLOAT,
        DATE,
        BOOLEAN,
        BINARY,
        OBJECT,
        NESTED,
        INTEGER_RANGE,
        FLOAT_RANGE,
        LONG_RANGE,
        DOUBLE_RANGE,
        DATE_RANGE;


        public String nameLowerCase() {
            return this.name().toLowerCase();
        }
    }
}

