/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasource.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.sql.datasource.model.DataSourceType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DataSourceMetadata {
    @JsonProperty
    private String name;
    @JsonProperty
    private String description;
    @JsonProperty
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})
    private DataSourceType connector;
    @JsonProperty
    private List<String> allowedRoles;
    @JsonProperty
    private Map<String, String> properties;
    @JsonProperty
    private String resultIndex;

    public DataSourceMetadata(String name, DataSourceType connector, List<String> allowedRoles, Map<String, String> properties, String resultIndex) {
        this.name = name;
        this.connector = connector;
        this.description = "";
        this.properties = properties;
        this.allowedRoles = allowedRoles;
        this.resultIndex = resultIndex;
    }

    public DataSourceMetadata() {
        this.description = "";
        this.allowedRoles = new ArrayList<String>();
        this.properties = new HashMap<String, String>();
    }

    public static DataSourceMetadata defaultOpenSearchDataSourceMetadata() {
        return new DataSourceMetadata("@opensearch", DataSourceType.OPENSEARCH, Collections.emptyList(), (Map<String, String>)ImmutableMap.of(), null);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public DataSourceType getConnector() {
        return this.connector;
    }

    @Generated
    public List<String> getAllowedRoles() {
        return this.allowedRoles;
    }

    @Generated
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Generated
    public String getResultIndex() {
        return this.resultIndex;
    }

    @JsonProperty
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty
    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})
    @Generated
    public void setConnector(DataSourceType connector) {
        this.connector = connector;
    }

    @JsonProperty
    @Generated
    public void setAllowedRoles(List<String> allowedRoles) {
        this.allowedRoles = allowedRoles;
    }

    @JsonProperty
    @Generated
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @JsonProperty
    @Generated
    public void setResultIndex(String resultIndex) {
        this.resultIndex = resultIndex;
    }

    @Generated
    public DataSourceMetadata(String name, String description, DataSourceType connector, List<String> allowedRoles, Map<String, String> properties, String resultIndex) {
        this.name = name;
        this.description = description;
        this.connector = connector;
        this.allowedRoles = allowedRoles;
        this.properties = properties;
        this.resultIndex = resultIndex;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSourceMetadata)) {
            return false;
        }
        DataSourceMetadata other = (DataSourceMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        DataSourceType this$connector = this.getConnector();
        DataSourceType other$connector = other.getConnector();
        if (this$connector == null ? other$connector != null : !((Object)((Object)this$connector)).equals((Object)other$connector)) {
            return false;
        }
        List<String> this$allowedRoles = this.getAllowedRoles();
        List<String> other$allowedRoles = other.getAllowedRoles();
        if (this$allowedRoles == null ? other$allowedRoles != null : !((Object)this$allowedRoles).equals(other$allowedRoles)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$resultIndex = this.getResultIndex();
        String other$resultIndex = other.getResultIndex();
        return !(this$resultIndex == null ? other$resultIndex != null : !this$resultIndex.equals(other$resultIndex));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataSourceMetadata;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        DataSourceType $connector = this.getConnector();
        result = result * 59 + ($connector == null ? 43 : ((Object)((Object)$connector)).hashCode());
        List<String> $allowedRoles = this.getAllowedRoles();
        result = result * 59 + ($allowedRoles == null ? 43 : ((Object)$allowedRoles).hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $resultIndex = this.getResultIndex();
        result = result * 59 + ($resultIndex == null ? 43 : $resultIndex.hashCode());
        return result;
    }
}

