/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.register;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.AccessMode;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.model.MLModelConfig;
import org.opensearch.ml.common.model.MLModelFormat;
import org.opensearch.ml.common.model.MetricsCorrelationModelConfig;
import org.opensearch.ml.common.model.TextEmbeddingModelConfig;

public class MLRegisterModelInput
implements ToXContentObject,
Writeable {
    public static final String FUNCTION_NAME_FIELD = "function_name";
    public static final String NAME_FIELD = "name";
    public static final String MODEL_GROUP_ID_FIELD = "model_group_id";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String VERSION_FIELD = "version";
    public static final String URL_FIELD = "url";
    public static final String HASH_VALUE_FIELD = "model_content_hash_value";
    public static final String MODEL_FORMAT_FIELD = "model_format";
    public static final String MODEL_CONFIG_FIELD = "model_config";
    public static final String DEPLOY_MODEL_FIELD = "deploy_model";
    public static final String MODEL_NODE_IDS_FIELD = "model_node_ids";
    public static final String CONNECTOR_FIELD = "connector";
    public static final String CONNECTOR_ID_FIELD = "connector_id";
    public static final String MODEL_CONTENT_HASH_VALUE_FIELD = "model_content_hash_value";
    public static final String ACCESS_MODE_FIELD = "access_mode";
    public static final String BACKEND_ROLES_FIELD = "backend_roles";
    public static final String ADD_ALL_BACKEND_ROLES_FIELD = "add_all_backend_roles";
    public static final String DOES_VERSION_CREATE_MODEL_GROUP = "does_version_create_model_group";
    private FunctionName functionName;
    private String modelName;
    private String modelGroupId;
    private String version;
    private String description;
    private String url;
    private String hashValue;
    private MLModelFormat modelFormat;
    private MLModelConfig modelConfig;
    private boolean deployModel;
    private String[] modelNodeIds;
    private Connector connector;
    private String connectorId;
    private List<String> backendRoles;
    private Boolean addAllBackendRoles;
    private AccessMode accessMode;
    private Boolean doesVersionCreateModelGroup;

    public MLRegisterModelInput(FunctionName functionName, String modelName, String modelGroupId, String version, String description, String url, String hashValue, MLModelFormat modelFormat, MLModelConfig modelConfig, boolean deployModel, String[] modelNodeIds, Connector connector, String connectorId, List<String> backendRoles, Boolean addAllBackendRoles, AccessMode accessMode, Boolean doesVersionCreateModelGroup) {
        this.functionName = functionName == null ? FunctionName.TEXT_EMBEDDING : functionName;
        if (modelName == null) {
            throw new IllegalArgumentException("model name is null");
        }
        if (functionName != FunctionName.REMOTE) {
            if (modelFormat == null) {
                throw new IllegalArgumentException("model format is null");
            }
            if (url != null && modelConfig == null && functionName != FunctionName.SPARSE_TOKENIZE && functionName != FunctionName.SPARSE_ENCODING) {
                throw new IllegalArgumentException("model config is null");
            }
        }
        this.modelName = modelName;
        this.modelGroupId = modelGroupId;
        this.version = version;
        this.description = description;
        this.url = url;
        this.hashValue = hashValue;
        this.modelFormat = modelFormat;
        this.modelConfig = modelConfig;
        this.deployModel = deployModel;
        this.modelNodeIds = modelNodeIds;
        this.connector = connector;
        this.connectorId = connectorId;
        this.backendRoles = backendRoles;
        this.addAllBackendRoles = addAllBackendRoles;
        this.accessMode = accessMode;
        this.doesVersionCreateModelGroup = doesVersionCreateModelGroup;
    }

    public MLRegisterModelInput(StreamInput in) throws IOException {
        this.functionName = (FunctionName)in.readEnum(FunctionName.class);
        this.modelName = in.readString();
        this.modelGroupId = in.readOptionalString();
        this.version = in.readOptionalString();
        this.description = in.readOptionalString();
        this.url = in.readOptionalString();
        this.hashValue = in.readOptionalString();
        if (in.readBoolean()) {
            this.modelFormat = (MLModelFormat)in.readEnum(MLModelFormat.class);
        }
        if (in.readBoolean()) {
            this.modelConfig = this.functionName.equals((Object)FunctionName.METRICS_CORRELATION) ? new MetricsCorrelationModelConfig(in) : new TextEmbeddingModelConfig(in);
        }
        this.deployModel = in.readBoolean();
        this.modelNodeIds = in.readOptionalStringArray();
        if (in.readBoolean()) {
            this.connector = Connector.fromStream(in);
        }
        this.connectorId = in.readOptionalString();
        if (in.readBoolean()) {
            this.backendRoles = in.readOptionalStringList();
        }
        this.addAllBackendRoles = in.readOptionalBoolean();
        if (in.readBoolean()) {
            this.accessMode = (AccessMode)in.readEnum(AccessMode.class);
        }
        this.doesVersionCreateModelGroup = in.readOptionalBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.functionName);
        out.writeString(this.modelName);
        out.writeOptionalString(this.modelGroupId);
        out.writeOptionalString(this.version);
        out.writeOptionalString(this.description);
        out.writeOptionalString(this.url);
        out.writeOptionalString(this.hashValue);
        if (this.modelFormat != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.modelFormat);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelConfig != null) {
            out.writeBoolean(true);
            this.modelConfig.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.deployModel);
        out.writeOptionalStringArray(this.modelNodeIds);
        if (this.connector != null) {
            out.writeBoolean(true);
            this.connector.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.connectorId);
        if (this.backendRoles != null) {
            out.writeBoolean(true);
            out.writeOptionalStringCollection(this.backendRoles);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalBoolean(this.addAllBackendRoles);
        if (this.accessMode != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.accessMode);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalBoolean(this.doesVersionCreateModelGroup);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FUNCTION_NAME_FIELD, (Object)this.functionName);
        builder.field(NAME_FIELD, this.modelName);
        if (this.version != null) {
            builder.field(VERSION_FIELD, this.version);
        }
        if (this.modelGroupId != null) {
            builder.field(MODEL_GROUP_ID_FIELD, this.modelGroupId);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.url != null) {
            builder.field(URL_FIELD, this.url);
        }
        if (this.hashValue != null) {
            builder.field("model_content_hash_value", this.hashValue);
        }
        if (this.modelFormat != null) {
            builder.field(MODEL_FORMAT_FIELD, (Object)this.modelFormat);
        }
        if (this.modelConfig != null) {
            builder.field(MODEL_CONFIG_FIELD, (ToXContent)this.modelConfig);
        }
        builder.field(DEPLOY_MODEL_FIELD, this.deployModel);
        if (this.modelNodeIds != null) {
            builder.field(MODEL_NODE_IDS_FIELD, (Object)this.modelNodeIds);
        }
        if (this.connector != null) {
            builder.field(CONNECTOR_FIELD, (ToXContent)this.connector);
        }
        if (this.connectorId != null) {
            builder.field(CONNECTOR_ID_FIELD, this.connectorId);
        }
        if (this.backendRoles != null) {
            builder.field(BACKEND_ROLES_FIELD, this.backendRoles);
        }
        if (this.addAllBackendRoles != null) {
            builder.field(ADD_ALL_BACKEND_ROLES_FIELD, this.addAllBackendRoles);
        }
        if (this.accessMode != null) {
            builder.field(ACCESS_MODE_FIELD, (Object)this.accessMode);
        }
        if (this.doesVersionCreateModelGroup != null) {
            builder.field(DOES_VERSION_CREATE_MODEL_GROUP, this.doesVersionCreateModelGroup);
        }
        builder.endObject();
        return builder;
    }

    public static MLRegisterModelInput parse(XContentParser parser, String modelName, String version, boolean deployModel) throws IOException {
        FunctionName functionName = null;
        String modelGroupId = null;
        String url = null;
        String hashValue = null;
        String description = null;
        MLModelFormat modelFormat = null;
        TextEmbeddingModelConfig modelConfig = null;
        ArrayList<String> modelNodeIds = new ArrayList<String>();
        Connector connector = null;
        String connectorId = null;
        ArrayList<String> backendRoles = new ArrayList<String>();
        Boolean addAllBackendRoles = null;
        AccessMode accessMode = null;
        Boolean doesVersionCreateModelGroup = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block32: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "function_name": {
                    functionName = FunctionName.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block32;
                }
                case "model_group_id": {
                    modelGroupId = parser.text();
                    continue block32;
                }
                case "url": {
                    url = parser.text();
                    continue block32;
                }
                case "model_content_hash_value": {
                    hashValue = parser.text();
                    continue block32;
                }
                case "description": {
                    description = parser.text();
                    continue block32;
                }
                case "model_format": {
                    modelFormat = MLModelFormat.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block32;
                }
                case "model_config": {
                    modelConfig = TextEmbeddingModelConfig.parse(parser);
                    continue block32;
                }
                case "connector": {
                    connector = Connector.createConnector(parser);
                    continue block32;
                }
                case "connector_id": {
                    connectorId = parser.text();
                    continue block32;
                }
                case "model_node_ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        modelNodeIds.add(parser.text());
                    }
                    continue block32;
                }
                case "backend_roles": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        backendRoles.add(parser.text());
                    }
                    continue block32;
                }
                case "add_all_backend_roles": {
                    addAllBackendRoles = parser.booleanValue();
                    continue block32;
                }
                case "access_mode": {
                    accessMode = AccessMode.from(parser.text());
                    continue block32;
                }
                case "does_version_create_model_group": {
                    doesVersionCreateModelGroup = parser.booleanValue();
                    continue block32;
                }
            }
            parser.skipChildren();
        }
        return new MLRegisterModelInput(functionName, modelName, modelGroupId, version, description, url, hashValue, modelFormat, modelConfig, deployModel, modelNodeIds.toArray(new String[0]), connector, connectorId, backendRoles, addAllBackendRoles, accessMode, doesVersionCreateModelGroup);
    }

    public static MLRegisterModelInput parse(XContentParser parser, boolean deployModel) throws IOException {
        FunctionName functionName = null;
        String name = null;
        String modelGroupId = null;
        String version = null;
        String url = null;
        String hashValue = null;
        String description = null;
        MLModelFormat modelFormat = null;
        TextEmbeddingModelConfig modelConfig = null;
        ArrayList<String> modelNodeIds = new ArrayList<String>();
        Connector connector = null;
        String connectorId = null;
        ArrayList<String> backendRoles = new ArrayList<String>();
        AccessMode accessMode = null;
        Boolean addAllBackendRoles = null;
        Boolean doesVersionCreateModelGroup = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block36: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "function_name": {
                    functionName = FunctionName.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block36;
                }
                case "name": {
                    name = parser.text();
                    continue block36;
                }
                case "model_group_id": {
                    modelGroupId = parser.text();
                    continue block36;
                }
                case "version": {
                    version = parser.text();
                    continue block36;
                }
                case "description": {
                    description = parser.text();
                    continue block36;
                }
                case "url": {
                    url = parser.text();
                    continue block36;
                }
                case "connector": {
                    connector = Connector.createConnector(parser);
                    continue block36;
                }
                case "model_content_hash_value": {
                    hashValue = parser.text();
                    continue block36;
                }
                case "connector_id": {
                    connectorId = parser.text();
                    continue block36;
                }
                case "model_format": {
                    modelFormat = MLModelFormat.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block36;
                }
                case "model_config": {
                    modelConfig = TextEmbeddingModelConfig.parse(parser);
                    continue block36;
                }
                case "model_node_ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        modelNodeIds.add(parser.text());
                    }
                    continue block36;
                }
                case "backend_roles": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        backendRoles.add(parser.text());
                    }
                    continue block36;
                }
                case "add_all_backend_roles": {
                    addAllBackendRoles = parser.booleanValue();
                    continue block36;
                }
                case "access_mode": {
                    accessMode = AccessMode.from(parser.text());
                    continue block36;
                }
                case "does_version_create_model_group": {
                    doesVersionCreateModelGroup = parser.booleanValue();
                    continue block36;
                }
            }
            parser.skipChildren();
        }
        return new MLRegisterModelInput(functionName, name, modelGroupId, version, description, url, hashValue, modelFormat, modelConfig, deployModel, modelNodeIds.toArray(new String[0]), connector, connectorId, backendRoles, addAllBackendRoles, accessMode, doesVersionCreateModelGroup);
    }

    @Generated
    public static MLRegisterModelInputBuilder builder() {
        return new MLRegisterModelInputBuilder();
    }

    @Generated
    public MLRegisterModelInputBuilder toBuilder() {
        return new MLRegisterModelInputBuilder().functionName(this.functionName).modelName(this.modelName).modelGroupId(this.modelGroupId).version(this.version).description(this.description).url(this.url).hashValue(this.hashValue).modelFormat(this.modelFormat).modelConfig(this.modelConfig).deployModel(this.deployModel).modelNodeIds(this.modelNodeIds).connector(this.connector).connectorId(this.connectorId).backendRoles(this.backendRoles).addAllBackendRoles(this.addAllBackendRoles).accessMode(this.accessMode).doesVersionCreateModelGroup(this.doesVersionCreateModelGroup);
    }

    @Generated
    public FunctionName getFunctionName() {
        return this.functionName;
    }

    @Generated
    public String getModelName() {
        return this.modelName;
    }

    @Generated
    public String getModelGroupId() {
        return this.modelGroupId;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getHashValue() {
        return this.hashValue;
    }

    @Generated
    public MLModelFormat getModelFormat() {
        return this.modelFormat;
    }

    @Generated
    public MLModelConfig getModelConfig() {
        return this.modelConfig;
    }

    @Generated
    public boolean isDeployModel() {
        return this.deployModel;
    }

    @Generated
    public String[] getModelNodeIds() {
        return this.modelNodeIds;
    }

    @Generated
    public Connector getConnector() {
        return this.connector;
    }

    @Generated
    public String getConnectorId() {
        return this.connectorId;
    }

    @Generated
    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    @Generated
    public Boolean getAddAllBackendRoles() {
        return this.addAllBackendRoles;
    }

    @Generated
    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    @Generated
    public Boolean getDoesVersionCreateModelGroup() {
        return this.doesVersionCreateModelGroup;
    }

    @Generated
    public void setFunctionName(FunctionName functionName) {
        this.functionName = functionName;
    }

    @Generated
    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    @Generated
    public void setModelGroupId(String modelGroupId) {
        this.modelGroupId = modelGroupId;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setHashValue(String hashValue) {
        this.hashValue = hashValue;
    }

    @Generated
    public void setModelFormat(MLModelFormat modelFormat) {
        this.modelFormat = modelFormat;
    }

    @Generated
    public void setModelConfig(MLModelConfig modelConfig) {
        this.modelConfig = modelConfig;
    }

    @Generated
    public void setDeployModel(boolean deployModel) {
        this.deployModel = deployModel;
    }

    @Generated
    public void setModelNodeIds(String[] modelNodeIds) {
        this.modelNodeIds = modelNodeIds;
    }

    @Generated
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    @Generated
    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    @Generated
    public void setBackendRoles(List<String> backendRoles) {
        this.backendRoles = backendRoles;
    }

    @Generated
    public void setAddAllBackendRoles(Boolean addAllBackendRoles) {
        this.addAllBackendRoles = addAllBackendRoles;
    }

    @Generated
    public void setAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    @Generated
    public void setDoesVersionCreateModelGroup(Boolean doesVersionCreateModelGroup) {
        this.doesVersionCreateModelGroup = doesVersionCreateModelGroup;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLRegisterModelInput)) {
            return false;
        }
        MLRegisterModelInput other = (MLRegisterModelInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDeployModel() != other.isDeployModel()) {
            return false;
        }
        Boolean this$addAllBackendRoles = this.getAddAllBackendRoles();
        Boolean other$addAllBackendRoles = other.getAddAllBackendRoles();
        if (this$addAllBackendRoles == null ? other$addAllBackendRoles != null : !((Object)this$addAllBackendRoles).equals(other$addAllBackendRoles)) {
            return false;
        }
        Boolean this$doesVersionCreateModelGroup = this.getDoesVersionCreateModelGroup();
        Boolean other$doesVersionCreateModelGroup = other.getDoesVersionCreateModelGroup();
        if (this$doesVersionCreateModelGroup == null ? other$doesVersionCreateModelGroup != null : !((Object)this$doesVersionCreateModelGroup).equals(other$doesVersionCreateModelGroup)) {
            return false;
        }
        FunctionName this$functionName = this.getFunctionName();
        FunctionName other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !((Object)((Object)this$functionName)).equals((Object)other$functionName)) {
            return false;
        }
        String this$modelName = this.getModelName();
        String other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) {
            return false;
        }
        String this$modelGroupId = this.getModelGroupId();
        String other$modelGroupId = other.getModelGroupId();
        if (this$modelGroupId == null ? other$modelGroupId != null : !this$modelGroupId.equals(other$modelGroupId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$hashValue = this.getHashValue();
        String other$hashValue = other.getHashValue();
        if (this$hashValue == null ? other$hashValue != null : !this$hashValue.equals(other$hashValue)) {
            return false;
        }
        MLModelFormat this$modelFormat = this.getModelFormat();
        MLModelFormat other$modelFormat = other.getModelFormat();
        if (this$modelFormat == null ? other$modelFormat != null : !((Object)((Object)this$modelFormat)).equals((Object)other$modelFormat)) {
            return false;
        }
        MLModelConfig this$modelConfig = this.getModelConfig();
        MLModelConfig other$modelConfig = other.getModelConfig();
        if (this$modelConfig == null ? other$modelConfig != null : !this$modelConfig.equals(other$modelConfig)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getModelNodeIds(), other.getModelNodeIds())) {
            return false;
        }
        Connector this$connector = this.getConnector();
        Connector other$connector = other.getConnector();
        if (this$connector == null ? other$connector != null : !this$connector.equals(other$connector)) {
            return false;
        }
        String this$connectorId = this.getConnectorId();
        String other$connectorId = other.getConnectorId();
        if (this$connectorId == null ? other$connectorId != null : !this$connectorId.equals(other$connectorId)) {
            return false;
        }
        List<String> this$backendRoles = this.getBackendRoles();
        List<String> other$backendRoles = other.getBackendRoles();
        if (this$backendRoles == null ? other$backendRoles != null : !((Object)this$backendRoles).equals(other$backendRoles)) {
            return false;
        }
        AccessMode this$accessMode = this.getAccessMode();
        AccessMode other$accessMode = other.getAccessMode();
        return !(this$accessMode == null ? other$accessMode != null : !((Object)((Object)this$accessMode)).equals((Object)other$accessMode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLRegisterModelInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeployModel() ? 79 : 97);
        Boolean $addAllBackendRoles = this.getAddAllBackendRoles();
        result = result * 59 + ($addAllBackendRoles == null ? 43 : ((Object)$addAllBackendRoles).hashCode());
        Boolean $doesVersionCreateModelGroup = this.getDoesVersionCreateModelGroup();
        result = result * 59 + ($doesVersionCreateModelGroup == null ? 43 : ((Object)$doesVersionCreateModelGroup).hashCode());
        FunctionName $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : ((Object)((Object)$functionName)).hashCode());
        String $modelName = this.getModelName();
        result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
        String $modelGroupId = this.getModelGroupId();
        result = result * 59 + ($modelGroupId == null ? 43 : $modelGroupId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $hashValue = this.getHashValue();
        result = result * 59 + ($hashValue == null ? 43 : $hashValue.hashCode());
        MLModelFormat $modelFormat = this.getModelFormat();
        result = result * 59 + ($modelFormat == null ? 43 : ((Object)((Object)$modelFormat)).hashCode());
        MLModelConfig $modelConfig = this.getModelConfig();
        result = result * 59 + ($modelConfig == null ? 43 : $modelConfig.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getModelNodeIds());
        Connector $connector = this.getConnector();
        result = result * 59 + ($connector == null ? 43 : $connector.hashCode());
        String $connectorId = this.getConnectorId();
        result = result * 59 + ($connectorId == null ? 43 : $connectorId.hashCode());
        List<String> $backendRoles = this.getBackendRoles();
        result = result * 59 + ($backendRoles == null ? 43 : ((Object)$backendRoles).hashCode());
        AccessMode $accessMode = this.getAccessMode();
        result = result * 59 + ($accessMode == null ? 43 : ((Object)((Object)$accessMode)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MLRegisterModelInput(functionName=" + this.getFunctionName() + ", modelName=" + this.getModelName() + ", modelGroupId=" + this.getModelGroupId() + ", version=" + this.getVersion() + ", description=" + this.getDescription() + ", url=" + this.getUrl() + ", hashValue=" + this.getHashValue() + ", modelFormat=" + this.getModelFormat() + ", modelConfig=" + this.getModelConfig() + ", deployModel=" + this.isDeployModel() + ", modelNodeIds=" + Arrays.deepToString(this.getModelNodeIds()) + ", connector=" + this.getConnector() + ", connectorId=" + this.getConnectorId() + ", backendRoles=" + this.getBackendRoles() + ", addAllBackendRoles=" + this.getAddAllBackendRoles() + ", accessMode=" + this.getAccessMode() + ", doesVersionCreateModelGroup=" + this.getDoesVersionCreateModelGroup() + ")";
    }

    @Generated
    public static class MLRegisterModelInputBuilder {
        @Generated
        private FunctionName functionName;
        @Generated
        private String modelName;
        @Generated
        private String modelGroupId;
        @Generated
        private String version;
        @Generated
        private String description;
        @Generated
        private String url;
        @Generated
        private String hashValue;
        @Generated
        private MLModelFormat modelFormat;
        @Generated
        private MLModelConfig modelConfig;
        @Generated
        private boolean deployModel;
        @Generated
        private String[] modelNodeIds;
        @Generated
        private Connector connector;
        @Generated
        private String connectorId;
        @Generated
        private List<String> backendRoles;
        @Generated
        private Boolean addAllBackendRoles;
        @Generated
        private AccessMode accessMode;
        @Generated
        private Boolean doesVersionCreateModelGroup;

        @Generated
        MLRegisterModelInputBuilder() {
        }

        @Generated
        public MLRegisterModelInputBuilder functionName(FunctionName functionName) {
            this.functionName = functionName;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder modelGroupId(String modelGroupId) {
            this.modelGroupId = modelGroupId;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder hashValue(String hashValue) {
            this.hashValue = hashValue;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder modelFormat(MLModelFormat modelFormat) {
            this.modelFormat = modelFormat;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder modelConfig(MLModelConfig modelConfig) {
            this.modelConfig = modelConfig;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder deployModel(boolean deployModel) {
            this.deployModel = deployModel;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder modelNodeIds(String[] modelNodeIds) {
            this.modelNodeIds = modelNodeIds;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder connector(Connector connector) {
            this.connector = connector;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder backendRoles(List<String> backendRoles) {
            this.backendRoles = backendRoles;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder addAllBackendRoles(Boolean addAllBackendRoles) {
            this.addAllBackendRoles = addAllBackendRoles;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder accessMode(AccessMode accessMode) {
            this.accessMode = accessMode;
            return this;
        }

        @Generated
        public MLRegisterModelInputBuilder doesVersionCreateModelGroup(Boolean doesVersionCreateModelGroup) {
            this.doesVersionCreateModelGroup = doesVersionCreateModelGroup;
            return this;
        }

        @Generated
        public MLRegisterModelInput build() {
            return new MLRegisterModelInput(this.functionName, this.modelName, this.modelGroupId, this.version, this.description, this.url, this.hashValue, this.modelFormat, this.modelConfig, this.deployModel, this.modelNodeIds, this.connector, this.connectorId, this.backendRoles, this.addAllBackendRoles, this.accessMode, this.doesVersionCreateModelGroup);
        }

        @Generated
        public String toString() {
            return "MLRegisterModelInput.MLRegisterModelInputBuilder(functionName=" + this.functionName + ", modelName=" + this.modelName + ", modelGroupId=" + this.modelGroupId + ", version=" + this.version + ", description=" + this.description + ", url=" + this.url + ", hashValue=" + this.hashValue + ", modelFormat=" + this.modelFormat + ", modelConfig=" + this.modelConfig + ", deployModel=" + this.deployModel + ", modelNodeIds=" + Arrays.deepToString(this.modelNodeIds) + ", connector=" + this.connector + ", connectorId=" + this.connectorId + ", backendRoles=" + this.backendRoles + ", addAllBackendRoles=" + this.addAllBackendRoles + ", accessMode=" + this.accessMode + ", doesVersionCreateModelGroup=" + this.doesVersionCreateModelGroup + ")";
        }
    }
}

