/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.compilerservices;

import com.strobel.compilerservices.UnsafeAccess;
import com.strobel.core.ExceptionUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.util.ContractUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;

public final class RuntimeHelpers {
    protected static void ensureInitializedSafely(Class<?> clazz) {
        try {
            Class.forName(clazz.getName(), true, clazz.getClassLoader());
        }
        catch (Throwable t) {
            ExceptionUtilities.wrapOrThrow(t);
        }
    }

    private RuntimeHelpers() {
        throw ContractUtils.unreachable();
    }

    public static void ensureClassInitialized(Class<?> clazz) {
        try {
            LazyInit.ENSURE_INITIALIZED.invokeExact(VerifyArgument.notNull(clazz, "clazz"));
        }
        catch (Throwable t) {
            throw ExceptionUtilities.wrapOrThrow(t);
        }
    }

    private static final class LazyInit {
        static final MethodHandle ENSURE_INITIALIZED = LazyInit.makeEnsureInitialized();

        private LazyInit() {
        }

        private static MethodHandle makeEnsureInitialized() {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            try {
                Object unsafe = UnsafeAccess.unsafe();
                Method ensureClassInitialized = unsafe.getClass().getDeclaredMethod("ensureClassInitialized", Class.class);
                if (!ensureClassInitialized.isAnnotationPresent(Deprecated.class)) {
                    MethodHandle handle = lookup.unreflect(ensureClassInitialized);
                    MethodHandle boundHandle = MethodHandles.insertArguments(handle, 0, unsafe);
                    return boundHandle;
                }
            }
            catch (Throwable ignored) {
                ExceptionUtilities.rethrowCritical(ignored);
            }
            try {
                return lookup.findStatic(RuntimeHelpers.class, "ensureInitializedSafely", MethodType.methodType(Void.TYPE, Class.class));
            }
            catch (ReflectiveOperationException e) {
                throw ExceptionUtilities.wrapOrThrow(e);
            }
        }
    }
}

