complete -c bindgen -l depfile -d 'Path to write depfile to' -r
complete -c bindgen -l default-enum-style -d 'The default STYLE of code used to generate enums' -r
complete -c bindgen -l bitfield-enum -d 'Mark any enum whose name matches REGEX as a set of bitfield flags' -r
complete -c bindgen -l newtype-enum -d 'Mark any enum whose name matches REGEX as a newtype' -r
complete -c bindgen -l newtype-global-enum -d 'Mark any enum whose name matches REGEX as a global newtype' -r
complete -c bindgen -l rustified-enum -d 'Mark any enum whose name matches REGEX as a Rust enum' -r
complete -c bindgen -l constified-enum -d 'Mark any enum whose name matches REGEX as a series of constants' -r
complete -c bindgen -l constified-enum-module -d 'Mark any enum whose name matches REGEX as a module of constants' -r
complete -c bindgen -l default-macro-constant-type -d 'The default signed/unsigned TYPE for C macro constants' -r
complete -c bindgen -l default-alias-style -d 'The default STYLE of code used to generate typedefs' -r
complete -c bindgen -l normal-alias -d 'Mark any typedef alias whose name matches REGEX to use normal type aliasing' -r
complete -c bindgen -l new-type-alias -d 'Mark any typedef alias whose name matches REGEX to have a new type generated for it' -r
complete -c bindgen -l new-type-alias-deref -d 'Mark any typedef alias whose name matches REGEX to have a new type with Deref and DerefMut to the inner type' -r
complete -c bindgen -l default-non-copy-union-style -d 'The default STYLE of code used to generate unions with non-Copy members. Note that ManuallyDrop was first stabilized in Rust 1.20.0' -r
complete -c bindgen -l bindgen-wrapper-union -d 'Mark any union whose name matches REGEX and who has a non-Copy member to use a bindgen-generated wrapper for fields' -r
complete -c bindgen -l manually-drop-union -d 'Mark any union whose name matches REGEX and who has a non-Copy member to use ManuallyDrop (stabilized in Rust 1.20.0) for fields' -r
complete -c bindgen -l blocklist-type -d 'Mark TYPE as hidden' -r
complete -c bindgen -l blocklist-function -d 'Mark FUNCTION as hidden' -r
complete -c bindgen -l blocklist-item -d 'Mark ITEM as hidden' -r
complete -c bindgen -l blocklist-file -d 'Mark FILE as hidden' -r
complete -c bindgen -l blocklist-var -d 'Mark VAR as hidden' -r
complete -c bindgen -l ctypes-prefix -d 'Use the given PREFIX before raw types instead of ::std::os::raw' -r
complete -c bindgen -l anon-fields-prefix -d 'Use the given PREFIX for anonymous fields' -r
complete -c bindgen -l emit-ir-graphviz -d 'Dump a graphviz dot file to PATH' -r
complete -c bindgen -l generate -d 'Generate only given items, split by commas. Valid values are `functions`,`types`, `vars`, `methods`, `constructors` and `destructors`' -r
complete -c bindgen -l opaque-type -d 'Mark TYPE as opaque' -r
complete -c bindgen -s o -l output -d 'Write Rust bindings to OUTPUT' -r
complete -c bindgen -l raw-line -d 'Add a raw line of Rust code at the beginning of output' -r
complete -c bindgen -l module-raw-line -d 'Add a RAW_LINE of Rust code to a given module with name MODULE_NAME' -r
complete -c bindgen -l rust-target -d 'Version of the Rust compiler to target. Valid options are: ["1.73", "1.71", "1.68", "1.64", "1.59", "1.47", "1.40", "1.36", "1.33", "1.30", "1.28", "1.27", "1.26", "1.25", "1.21", "1.20", "1.19", "1.17", "1.0"]. Defaults to 1.73.' -r
complete -c bindgen -l allowlist-function -d 'Allowlist all the free-standing functions matching REGEX. Other non-allowlisted functions will not be generated' -r
complete -c bindgen -l allowlist-type -d 'Only generate types matching REGEX. Other non-allowlisted types will not be generated' -r
complete -c bindgen -l allowlist-var -d 'Allowlist all the free-standing variables matching REGEX. Other non-allowlisted variables will not be generated' -r
complete -c bindgen -l allowlist-file -d 'Allowlist all contents of PATH' -r
complete -c bindgen -l allowlist-item -d 'Allowlist all items matching REGEX. Other non-allowlisted items will not be generated' -r
complete -c bindgen -l formatter -d 'Which FORMATTER should be used for the bindings' -r
complete -c bindgen -l rustfmt-configuration-file -d 'The absolute PATH to the rustfmt configuration file. The configuration file will be used for formatting the bindings. This parameter sets `formatter` to `rustfmt`' -r -F
complete -c bindgen -l no-partialeq -d 'Avoid deriving PartialEq for types matching REGEX' -r
complete -c bindgen -l no-copy -d 'Avoid deriving Copy and Clone for types matching REGEX' -r
complete -c bindgen -l no-debug -d 'Avoid deriving Debug for types matching REGEX' -r
complete -c bindgen -l no-default -d 'Avoid deriving/implementing Default for types matching REGEX' -r
complete -c bindgen -l no-hash -d 'Avoid deriving Hash for types matching REGEX' -r
complete -c bindgen -l must-use-type -d 'Add `#[must_use]` annotation to types matching REGEX' -r
complete -c bindgen -l wasm-import-module-name -d 'The NAME to be used in a #[link(wasm_import_module = ...)] statement' -r
complete -c bindgen -l dynamic-loading -d 'Use dynamic loading mode with the given library NAME' -r
complete -c bindgen -l prefix-link-name -d 'Prefix the name of exported symbols' -r
complete -c bindgen -l override-abi -d 'Overrides the ABI of functions matching REGEX. The OVERRIDE value must be of the shape REGEX=ABI where ABI can be one of C, stdcall, efiapi, fastcall, thiscall, aapcs, win64 or C-unwind<.>' -r
complete -c bindgen -l with-derive-custom -d 'Derive custom traits on any kind of type. The CUSTOM value must be of the shape REGEX=DERIVE where DERIVE is a coma-separated list of derive macros' -r
complete -c bindgen -l with-derive-custom-struct -d 'Derive custom traits on a `struct`. The CUSTOM value must be of the shape REGEX=DERIVE where DERIVE is a coma-separated list of derive macros' -r
complete -c bindgen -l with-derive-custom-enum -d 'Derive custom traits on an `enum. The CUSTOM value must be of the shape REGEX=DERIVE where DERIVE is a coma-separated list of derive macros' -r
complete -c bindgen -l with-derive-custom-union -d 'Derive custom traits on a `union`. The CUSTOM value must be of the shape REGEX=DERIVE where DERIVE is a coma-separated list of derive macros' -r
complete -c bindgen -l wrap-static-fns-path -d 'Sets the PATH for the source file that must be created due to the presence of `static` and `static inline` functions' -r -F
complete -c bindgen -l wrap-static-fns-suffix -d 'Sets the SUFFIX added to the extern wrapper functions generated for `static` and `static inline` functions' -r
complete -c bindgen -l default-visibility -d 'Set the default VISIBILITY of fields, including bitfields and accessor methods for bitfields. This flag is ignored if the `--respect-cxx-access-specs` flag is used' -r
complete -c bindgen -l generate-shell-completions -d 'Generates completions for the specified SHELL, sends them to `stdout` and exits' -r -f -a "{bash	,elvish	,fish	,powershell	,zsh	}"
complete -c bindgen -l no-layout-tests -d 'Avoid generating layout tests for any type'
complete -c bindgen -l no-derive-copy -d 'Avoid deriving Copy on any type'
complete -c bindgen -l no-derive-debug -d 'Avoid deriving Debug on any type'
complete -c bindgen -l no-derive-default -d 'Avoid deriving Default on any type'
complete -c bindgen -l impl-debug -d 'Create a Debug implementation if it cannot be derived automatically'
complete -c bindgen -l impl-partialeq -d 'Create a PartialEq implementation if it cannot be derived automatically'
complete -c bindgen -l with-derive-default -d 'Derive Default on any type'
complete -c bindgen -l with-derive-hash -d 'Derive Hash on any type'
complete -c bindgen -l with-derive-partialeq -d 'Derive PartialEq on any type'
complete -c bindgen -l with-derive-partialord -d 'Derive PartialOrd on any type'
complete -c bindgen -l with-derive-eq -d 'Derive Eq on any type'
complete -c bindgen -l with-derive-ord -d 'Derive Ord on any type'
complete -c bindgen -l no-doc-comments -d 'Avoid including doc comments in the output, see: <https://github.com/rust-lang/rust-bindgen/issues/426>'
complete -c bindgen -l no-recursive-allowlist -d 'Disable allowlisting types recursively. This will cause bindgen to emit Rust code that won\'t compile! See the `bindgen::Builder::allowlist_recursively` method\'s documentation for details'
complete -c bindgen -l objc-extern-crate -d 'Use extern crate instead of use for objc'
complete -c bindgen -l generate-block -d 'Generate block signatures instead of void pointers'
complete -c bindgen -l generate-cstr -d 'Generate string constants as `&CStr` instead of `&[u8]`'
complete -c bindgen -l block-extern-crate -d 'Use extern crate instead of use for block'
complete -c bindgen -l distrust-clang-mangling -d 'Do not trust the libclang-provided mangling'
complete -c bindgen -l builtins -d 'Output bindings for builtin definitions, e.g. __builtin_va_list'
complete -c bindgen -l time-phases -d 'Time the different bindgen phases and print to stderr'
complete -c bindgen -l emit-clang-ast -d 'Output the Clang AST for debugging purposes'
complete -c bindgen -l emit-ir -d 'Output our internal IR for debugging purposes'
complete -c bindgen -l enable-cxx-namespaces -d 'Enable support for C++ namespaces'
complete -c bindgen -l disable-name-namespacing -d 'Disable namespacing via mangling, causing bindgen to generate names like `Baz` instead of `foo_bar_Baz` for an input name `foo::bar::Baz`'
complete -c bindgen -l disable-nested-struct-naming -d 'Disable nested struct naming, causing bindgen to generate names like `bar` instead of `foo_bar` for a nested definition `struct foo { struct bar { } b; };`'
complete -c bindgen -l disable-untagged-union -d 'Disable support for native Rust unions'
complete -c bindgen -l disable-header-comment -d 'Suppress insertion of bindgen\'s version identifier into generated bindings'
complete -c bindgen -l ignore-functions -d 'Do not generate bindings for functions or methods. This is useful when you only care about struct layouts'
complete -c bindgen -l ignore-methods -d 'Do not generate bindings for methods'
complete -c bindgen -l no-convert-floats -d 'Do not automatically convert floats to f32/f64'
complete -c bindgen -l no-prepend-enum-name -d 'Do not prepend the enum name to constant or newtype variants'
complete -c bindgen -l no-include-path-detection -d 'Do not try to detect default include paths'
complete -c bindgen -l fit-macro-constant-types -d 'Try to fit macro constants into types smaller than u32/i32'
complete -c bindgen -l use-core -d 'Use types from Rust core instead of std'
complete -c bindgen -l conservative-inline-namespaces -d 'Conservatively generate inline namespaces to avoid name conflicts'
complete -c bindgen -l generate-inline-functions -d 'Generate inline functions'
complete -c bindgen -l verbose -d 'Print verbose error messages'
complete -c bindgen -l dump-preprocessed-input -d 'Preprocess and dump the input header files to disk. Useful when debugging bindgen, using C-Reduce, or when filing issues. The resulting file will be named something like `__bindgen.i` or `__bindgen.ii`'
complete -c bindgen -l no-record-matches -d 'Do not record matching items in the regex sets. This disables reporting of unused items'
complete -c bindgen -l no-size_t-is-usize -d 'Do not bind size_t as usize (useful on platforms where those types are incompatible)'
complete -c bindgen -l no-rustfmt-bindings -d 'Do not format the generated bindings with rustfmt. This option is deprecated, please use `--formatter=none` instead'
complete -c bindgen -l enable-function-attribute-detection -d 'Enables detecting unexposed attributes in functions (slow). Used to generate `#[must_use]` annotations'
complete -c bindgen -l use-array-pointers-in-arguments -d 'Use `*const [T; size]` instead of `*const T` for C arrays'
complete -c bindgen -l dynamic-link-require-all -d 'Require successful linkage to all functions in the library'
complete -c bindgen -l respect-cxx-access-specs -d 'Makes generated bindings `pub` only for items if the items are publically accessible in C++'
complete -c bindgen -l translate-enum-integer-types -d 'Always translate enum integer types to native Rust integer types'
complete -c bindgen -l c-naming -d 'Generate types with C style naming'
complete -c bindgen -l explicit-padding -d 'Always output explicit padding fields'
complete -c bindgen -l vtable-generation -d 'Enables generation of vtable functions'
complete -c bindgen -l sort-semantically -d 'Enables sorting of code generation in a predefined manner'
complete -c bindgen -l merge-extern-blocks -d 'Deduplicates extern blocks'
complete -c bindgen -l wrap-unsafe-ops -d 'Wrap unsafe operations in unsafe blocks'
complete -c bindgen -l wrap-static-fns -d 'Generate wrappers for `static` and `static inline` functions'
complete -c bindgen -l emit-diagnostics -d 'Whether to emit diagnostics or not'
complete -c bindgen -l experimental -d 'Enables experimental features'
complete -c bindgen -s V -l version -d 'Prints the version, and exits'
complete -c bindgen -s h -l help -d 'Print help'
