"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateListChangeSets = void 0;
const CloudFormationClient_1 = require("../CloudFormationClient");
const ListChangeSetsCommand_1 = require("../commands/ListChangeSetsCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListChangeSetsCommand_1.ListChangeSetsCommand(input), ...args);
};
async function* paginateListChangeSets(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        if (config.client instanceof CloudFormationClient_1.CloudFormationClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected CloudFormation | CloudFormationClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateListChangeSets = paginateListChangeSets;
