import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@smithy/types";
import {
  CloudFormationClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../CloudFormationClient";
import {
  UpdateStackInstancesInput,
  UpdateStackInstancesOutput,
} from "../models/models_0";
export { __MetadataBearer, $Command };
export interface UpdateStackInstancesCommandInput
  extends UpdateStackInstancesInput {}
export interface UpdateStackInstancesCommandOutput
  extends UpdateStackInstancesOutput,
    __MetadataBearer {}
export declare class UpdateStackInstancesCommand extends $Command<
  UpdateStackInstancesCommandInput,
  UpdateStackInstancesCommandOutput,
  CloudFormationClientResolvedConfig
> {
  readonly input: UpdateStackInstancesCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: UpdateStackInstancesCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: CloudFormationClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    UpdateStackInstancesCommandInput,
    UpdateStackInstancesCommandOutput
  >;
  private serialize;
  private deserialize;
}
