import ts from 'typescript';
import { DocumentSnapshot } from './DocumentSnapshot';
/**
 * Creates a module loader specifically for `.svelte` files.
 *
 * The typescript language service tries to look up other files that are referenced in the currently open svelte file.
 * For `.ts`/`.js` files this works, for `.svelte` files it does not by default.
 * Reason: The typescript language service does not know about the `.svelte` file ending,
 * so it assumes it's a normal typescript file and searches for files like `../Component.svelte.ts`, which is wrong.
 * In order to fix this, we need to wrap typescript's module resolution and reroute all `.svelte.ts` file lookups to .svelte.
 *
 * @param getSnapshot A function which returns a (in case of svelte file fully preprocessed) typescript/javascript snapshot
 * @param compilerOptions The typescript compiler options
 */
export declare function createSvelteModuleLoader(getSnapshot: (fileName: string) => DocumentSnapshot, compilerOptions: ts.CompilerOptions, tsSystem: ts.System, tsModule: typeof ts): {
    fileExists: (path: string) => boolean;
    readFile: (path: string, encoding?: string | undefined) => string | undefined;
    readDirectory: (path: string, extensions?: readonly string[] | undefined, exclude?: readonly string[] | undefined, include?: readonly string[] | undefined, depth?: number | undefined) => string[];
    deleteFromModuleCache: (path: string) => void;
    deleteUnresolvedResolutionsFromCache: (path: string) => void;
    resolveModuleNames: (moduleNames: string[], containingFile: string, _reusedNames: string[] | undefined, _redirectedReference: ts.ResolvedProjectReference | undefined, _options: ts.CompilerOptions, containingSourceFile?: ts.SourceFile | undefined) => Array<ts.ResolvedModule | undefined>;
    resolveTypeReferenceDirectiveReferences: <T extends string | ts.FileReference>(typeDirectiveNames: readonly T[], containingFile: string, redirectedReference: ts.ResolvedProjectReference | undefined, options: ts.CompilerOptions, containingSourceFile: ts.SourceFile | undefined) => readonly ts.ResolvedTypeReferenceDirectiveWithFailedLookupLocations[];
};
