/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.Ground3D;
import com.eteks.sweethome3d.j3d.OBJWriter;
import com.eteks.sweethome3d.j3d.Object3DBranchFactory;
import com.eteks.sweethome3d.model.BackgroundImage;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Compass;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.DimensionLine;
import com.eteks.sweethome3d.model.Elevatable;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeDescriptor;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.InterruptedRecorderException;
import com.eteks.sweethome3d.model.Label;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Library;
import com.eteks.sweethome3d.model.ObjectProperty;
import com.eteks.sweethome3d.model.Polyline;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.TextStyle;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.plugin.HomePluginController;
import com.eteks.sweethome3d.plugin.Plugin;
import com.eteks.sweethome3d.plugin.PluginAction;
import com.eteks.sweethome3d.swing.Component3DTransferHandler;
import com.eteks.sweethome3d.swing.ControllerAction;
import com.eteks.sweethome3d.swing.FurnitureCatalogTransferHandler;
import com.eteks.sweethome3d.swing.FurnitureTable;
import com.eteks.sweethome3d.swing.FurnitureTransferHandler;
import com.eteks.sweethome3d.swing.HomeComponent3D;
import com.eteks.sweethome3d.swing.HomePDFPrinter;
import com.eteks.sweethome3d.swing.HomePrintableComponent;
import com.eteks.sweethome3d.swing.HomeTransferableList;
import com.eteks.sweethome3d.swing.IconManager;
import com.eteks.sweethome3d.swing.InterruptedPrinterException;
import com.eteks.sweethome3d.swing.PlanComponent;
import com.eteks.sweethome3d.swing.PlanTransferHandler;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.swing.UnfocusableToolBar;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.URLContent;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.ExportableView;
import com.eteks.sweethome3d.viewcontroller.FurnitureController;
import com.eteks.sweethome3d.viewcontroller.HomeController;
import com.eteks.sweethome3d.viewcontroller.HomeController3D;
import com.eteks.sweethome3d.viewcontroller.HomeView;
import com.eteks.sweethome3d.viewcontroller.Object3DFactory;
import com.eteks.sweethome3d.viewcontroller.PlanController;
import com.eteks.sweethome3d.viewcontroller.PlanView;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.View3D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.im.InputContext;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import javax.media.j3d.Node;
import javax.media.j3d.VirtualUniverse;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.ListCellRenderer;
import javax.swing.MenuElement;
import javax.swing.RootPaneContainer;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;

public class HomePane
extends JRootPane
implements HomeView {
    private static final String MAIN_PANE_DIVIDER_LOCATION_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.MainPaneDividerLocation";
    private static final String CATALOG_PANE_DIVIDER_LOCATION_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.CatalogPaneDividerLocation";
    private static final String PLAN_PANE_DIVIDER_LOCATION_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.PlanPaneDividerLocation";
    private static final String PLAN_VIEWPORT_X_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.PlanViewportX";
    private static final String PLAN_VIEWPORT_Y_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.PlanViewportY";
    private static final String FURNITURE_VIEWPORT_Y_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.FurnitureViewportY";
    private static final String DETACHED_VIEW_VISUAL_PROPERTY = ".detachedView";
    private static final String DETACHED_VIEW_DIVIDER_LOCATION_VISUAL_PROPERTY = ".detachedViewDividerLocation";
    private static final String DETACHED_VIEW_X_VISUAL_PROPERTY = ".detachedViewX";
    private static final String DETACHED_VIEW_Y_VISUAL_PROPERTY = ".detachedViewY";
    private static final String DETACHED_VIEW_WIDTH_VISUAL_PROPERTY = ".detachedViewWidth";
    private static final String DETACHED_VIEW_HEIGHT_VISUAL_PROPERTY = ".detachedViewHeight";
    private static final int DEFAULT_SMALL_ICON_HEIGHT = Math.round(16.0f * SwingTools.getResolutionScale());
    private final Home home;
    private final UserPreferences preferences;
    private final HomeController controller;
    private JComponent lastFocusedComponent;
    private PlanController.Mode previousPlanControllerMode;
    private TransferHandler catalogTransferHandler;
    private TransferHandler furnitureTransferHandler;
    private TransferHandler planTransferHandler;
    private TransferHandler view3DTransferHandler;
    private boolean transferHandlerEnabled;
    private MouseInputAdapter furnitureCatalogDragAndDropListener;
    private boolean clipboardEmpty = true;
    private boolean exportAllToOBJ = true;
    private ActionMap menuActionMap;
    private List<Action> pluginActions;
    private KeyListener specialKeysListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            PlanController planController = HomePane.this.controller.getPlanController();
            if (keyEvent.getKeyCode() == 32 && (keyEvent.getModifiers() & 0xE) == 0 && HomePane.this.getActionMap().get((Object)HomeView.ActionType.PAN).getValue("Name") != null && planController.getMode() != PlanController.Mode.PANNING && !planController.isModificationState() && SwingUtilities.isDescendingFrom(HomePane.this.lastFocusedComponent, HomePane.this) && !this.isSpaceUsedByComponent(HomePane.this.lastFocusedComponent)) {
                HomePane.this.previousPlanControllerMode = planController.getMode();
                planController.setMode(PlanController.Mode.PANNING);
                keyEvent.consume();
            } else if (OperatingSystem.isMacOSX() && OperatingSystem.isJavaVersionGreaterOrEqual("1.7")) {
                this.keyTyped(keyEvent);
            }
        }

        private boolean isSpaceUsedByComponent(JComponent jComponent) {
            return jComponent instanceof JTextComponent || jComponent instanceof JComboBox;
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 32 && HomePane.this.previousPlanControllerMode != null) {
                HomePane.this.controller.getPlanController().setMode(HomePane.this.previousPlanControllerMode);
                HomePane.this.previousPlanControllerMode = null;
                keyEvent.consume();
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            int n = keyEvent.getKeyChar();
            if (n != 65535) {
                Object object;
                ActionMap actionMap = HomePane.this.getActionMap();
                List<Action> list = Arrays.asList(actionMap.get((Object)HomeView.ActionType.ZOOM_IN), actionMap.get((Object)HomeView.ActionType.ZOOM_OUT), actionMap.get((Object)HomeView.ActionType.INCREASE_TEXT_SIZE), actionMap.get((Object)HomeView.ActionType.DECREASE_TEXT_SIZE), actionMap.get((Object)HomeView.ActionType.HELP));
                if (!Boolean.getBoolean("apple.laf.useScreenMenuBar") && Boolean.getBoolean("sweethome3d.bundle")) {
                    list = new ArrayList<Action>(list);
                    list.add(actionMap.get((Object)HomeView.ActionType.PREFERENCES));
                }
                int n2 = 14;
                if (OperatingSystem.isMacOSX() && keyEvent.isMetaDown() && (object = InputContext.getInstance().getLocale()) != null) {
                    boolean bl = keyEvent.isShiftDown();
                    boolean bl2 = keyEvent.isControlDown();
                    if (n == 61 && bl && Arrays.binarySearch(new String[]{"en", "es", "ja", "ko", "lv", "nl", "pt", "ro", "uk"}, ((Locale)object).getLanguage()) >= 0 || n == 51 && bl && keyEvent.getKeyCode() != 99 && Arrays.binarySearch(new String[]{"bg", "hu"}, ((Locale)object).getLanguage()) >= 0 || n == 49 && !bl && keyEvent.getKeyCode() != 97 && Arrays.binarySearch(new String[]{"cs", "sk"}, ((Locale)object).getLanguage()) >= 0 || n == 53 && bl && keyEvent.getKeyCode() != 101 && "pl".equals(((Locale)object).getLanguage()) || n == 61 && !bl && "sr".equals(((Locale)object).getLanguage()) || bl2 && (n == 61 && bl && Arrays.binarySearch(new String[]{"ar", "fr", "ru", "vi", "zh"}, ((Locale)object).getLanguage()) >= 0 || n == 61 && !bl && Arrays.binarySearch(new String[]{"hr", "sl"}, ((Locale)object).getLanguage()) >= 0 || n == 29 && !bl && "it".equals(((Locale)object).getLanguage()) || n == 47 && bl && "nl".equals(((Locale)object).getLanguage()))) {
                        n = 43;
                    } else if (bl2 && (n == 31 && Arrays.binarySearch(new String[]{"ar", "bg", "cs", "en", "es", "el", "fi", "fr", "hr", "ja", "ko", "lt", "lv", "nl", "pt", "ro", "ru", "sk", "sv", "uk", "vi", "zh"}, ((Locale)object).getLanguage()) >= 0 || n == 47 && Arrays.binarySearch(new String[]{"hr", "hu", "pl", "sl", "sr"}, ((Locale)object).getLanguage()) >= 0 || n == 33 && "it".equals(((Locale)object).getLanguage()) || n == 61 && "nl".equals(((Locale)object).getLanguage()))) {
                        n = 45;
                    }
                }
                for (Action action : list) {
                    KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
                    if (keyStroke == null || n != keyStroke.getKeyChar() || (keyEvent.getModifiers() & n2) != (keyStroke.getModifiers() & n2) || !action.isEnabled()) continue;
                    action.actionPerformed(new ActionEvent(HomePane.this, 1001, (String)action.getValue("ActionCommandKey")));
                    keyEvent.consume();
                }
            }
        }
    };

    public HomePane(Home home, UserPreferences userPreferences, HomeController homeController) {
        this.home = home;
        this.preferences = userPreferences;
        this.controller = homeController;
        if (!Boolean.getBoolean("com.eteks.sweethome3d.j3d.useOffScreen3DView")) {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        }
        this.createActions(home, userPreferences, homeController);
        this.createMenuActions(userPreferences, homeController);
        this.createPluginActions(homeController instanceof HomePluginController ? ((HomePluginController)homeController).getPlugins() : null);
        this.initActions(userPreferences);
        this.createTransferHandlers(home, homeController);
        this.addLevelVisibilityListener(home);
        this.addUserPreferencesListener(userPreferences);
        this.addPlanControllerListener(homeController.getPlanController());
        this.addFocusListener();
        this.updateFocusTraversalPolicy();
        this.addClipboardListener();
        JMenuBar jMenuBar = this.createMenuBar(home, userPreferences, homeController);
        this.setJMenuBar(jMenuBar);
        this.addHomeListeners(home, homeController);
        Container container = this.getContentPane();
        container.add((Component)this.createToolBar(home, userPreferences), "North");
        container.add(this.createMainPane(home, userPreferences, homeController));
        if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
            container.add((Component)new JLabel(), "West");
            container.add((Component)new JLabel(), "East");
        }
        this.disableMenuItemsDuringDragAndDrop(homeController.getPlanController().getView(), jMenuBar);
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
    }

    private void createActions(Home home, UserPreferences userPreferences, HomeController homeController) {
        Object object;
        ButtonGroup buttonGroup;
        this.createAction(HomeView.ActionType.NEW_HOME, userPreferences, homeController, "newHome", new Object[0]);
        this.createAction(HomeView.ActionType.NEW_HOME_FROM_EXAMPLE, userPreferences, homeController, "newHomeFromExample", new Object[0]);
        this.createAction(HomeView.ActionType.OPEN, userPreferences, homeController, "open", new Object[0]);
        this.createAction(HomeView.ActionType.DELETE_RECENT_HOMES, userPreferences, homeController, "deleteRecentHomes", new Object[0]);
        this.createAction(HomeView.ActionType.CLOSE, userPreferences, homeController, "close", new Object[0]);
        this.createAction(HomeView.ActionType.SAVE, userPreferences, homeController, "save", new Object[0]);
        this.createAction(HomeView.ActionType.SAVE_AS, userPreferences, homeController, "saveAs", new Object[0]);
        this.createAction(HomeView.ActionType.SAVE_AND_COMPRESS, userPreferences, homeController, "saveAndCompress", new Object[0]);
        this.createAction(HomeView.ActionType.PAGE_SETUP, userPreferences, homeController, "setupPage", new Object[0]);
        this.createAction(HomeView.ActionType.PRINT_PREVIEW, userPreferences, homeController, "previewPrint", new Object[0]);
        this.createAction(HomeView.ActionType.PRINT, userPreferences, homeController, "print", new Object[0]);
        this.createAction(HomeView.ActionType.PRINT_TO_PDF, userPreferences, homeController, "printToPDF", new Object[0]);
        this.createAction(HomeView.ActionType.PREFERENCES, userPreferences, homeController, "editPreferences", new Object[0]);
        this.createAction(HomeView.ActionType.EXIT, userPreferences, homeController, "exit", new Object[0]);
        this.createAction(HomeView.ActionType.UNDO, userPreferences, homeController, "undo", new Object[0]);
        this.createAction(HomeView.ActionType.REDO, userPreferences, homeController, "redo", new Object[0]);
        this.createClipboardAction(HomeView.ActionType.CUT, userPreferences, TransferHandler.getCutAction(), true);
        this.createClipboardAction(HomeView.ActionType.COPY, userPreferences, TransferHandler.getCopyAction(), true);
        this.createClipboardAction(HomeView.ActionType.PASTE, userPreferences, TransferHandler.getPasteAction(), false);
        this.createAction(HomeView.ActionType.PASTE_TO_GROUP, userPreferences, homeController, "pasteToGroup", new Object[0]);
        this.createAction(HomeView.ActionType.PASTE_STYLE, userPreferences, homeController, "pasteStyle", new Object[0]);
        this.createAction(HomeView.ActionType.DELETE, userPreferences, homeController, "delete", new Object[0]);
        this.createAction(HomeView.ActionType.SELECT_ALL, userPreferences, homeController, "selectAll", new Object[0]);
        this.createAction(HomeView.ActionType.ADD_HOME_FURNITURE, userPreferences, homeController, "addHomeFurniture", new Object[0]);
        this.createAction(HomeView.ActionType.ADD_FURNITURE_TO_GROUP, userPreferences, homeController, "addFurnitureToGroup", new Object[0]);
        FurnitureController furnitureController = homeController.getFurnitureController();
        this.createAction(HomeView.ActionType.DELETE_HOME_FURNITURE, userPreferences, furnitureController, "deleteSelection", new Object[0]);
        this.createAction(HomeView.ActionType.MODIFY_FURNITURE, userPreferences, homeController, "modifySelectedFurniture", new Object[0]);
        this.createAction(HomeView.ActionType.GROUP_FURNITURE, userPreferences, furnitureController, "groupSelectedFurniture", new Object[0]);
        this.createAction(HomeView.ActionType.UNGROUP_FURNITURE, userPreferences, furnitureController, "ungroupSelectedFurniture", new Object[0]);
        this.createAction(HomeView.ActionType.ALIGN_FURNITURE_ON_TOP, userPreferences, furnitureController, "alignSelectedFurnitureOnTop", new Object[0]);
        this.createAction(HomeView.ActionType.ALIGN_FURNITURE_ON_BOTTOM, userPreferences, furnitureController, "alignSelectedFurnitureOnBottom", new Object[0]);
        this.createAction(HomeView.ActionType.ALIGN_FURNITURE_ON_LEFT, userPreferences, furnitureController, "alignSelectedFurnitureOnLeft", new Object[0]);
        this.createAction(HomeView.ActionType.ALIGN_FURNITURE_ON_RIGHT, userPreferences, furnitureController, "alignSelectedFurnitureOnRight", new Object[0]);
        this.createAction(HomeView.ActionType.ALIGN_FURNITURE_ON_FRONT_SIDE, userPreferences, furnitureController, "alignSelectedFurnitureOnFrontSide", new Object[0]);
        this.createAction(HomeView.ActionType.ALIGN_FURNITURE_ON_BACK_SIDE, userPreferences, furnitureController, "alignSelectedFurnitureOnBackSide", new Object[0]);
        this.createAction(HomeView.ActionType.ALIGN_FURNITURE_ON_LEFT_SIDE, userPreferences, furnitureController, "alignSelectedFurnitureOnLeftSide", new Object[0]);
        this.createAction(HomeView.ActionType.ALIGN_FURNITURE_ON_RIGHT_SIDE, userPreferences, furnitureController, "alignSelectedFurnitureOnRightSide", new Object[0]);
        this.createAction(HomeView.ActionType.ALIGN_FURNITURE_SIDE_BY_SIDE, userPreferences, furnitureController, "alignSelectedFurnitureSideBySide", new Object[0]);
        this.createAction(HomeView.ActionType.DISTRIBUTE_FURNITURE_HORIZONTALLY, userPreferences, furnitureController, "distributeSelectedFurnitureHorizontally", new Object[0]);
        this.createAction(HomeView.ActionType.DISTRIBUTE_FURNITURE_VERTICALLY, userPreferences, furnitureController, "distributeSelectedFurnitureVertically", new Object[0]);
        this.createAction(HomeView.ActionType.RESET_FURNITURE_ELEVATION, userPreferences, furnitureController, "resetFurnitureElevation", new Object[0]);
        HomeController3D homeController3D = homeController.getHomeController3D();
        if (homeController3D.getView() != null) {
            this.createAction(HomeView.ActionType.IMPORT_FURNITURE, userPreferences, homeController, "importFurniture", new Object[0]);
        }
        this.createAction(HomeView.ActionType.IMPORT_FURNITURE_LIBRARY, userPreferences, homeController, "importFurnitureLibrary", new Object[0]);
        this.createAction(HomeView.ActionType.IMPORT_TEXTURE, userPreferences, homeController, "importTexture", new Object[0]);
        this.createAction(HomeView.ActionType.IMPORT_TEXTURES_LIBRARY, userPreferences, homeController, "importTexturesLibrary", new Object[0]);
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_CATALOG_ID, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.CATALOG_ID.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_NAME, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.NAME.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_DESCRIPTION, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.DESCRIPTION.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_CREATOR, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.CREATOR.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_LICENSE, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.LICENSE.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_WIDTH, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.WIDTH.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_DEPTH, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.DEPTH.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_HEIGHT, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.HEIGHT.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_X, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.X.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_Y, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.Y.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_ELEVATION, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.ELEVATION.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_ANGLE, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.ANGLE.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_LEVEL, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.LEVEL.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_MODEL_SIZE, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.MODEL_SIZE.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_COLOR, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.COLOR.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_TEXTURE, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.TEXTURE.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_MOVABILITY, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.MOVABLE.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_TYPE, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.DOOR_OR_WINDOW.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_VISIBILITY, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.VISIBLE.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_PRICE, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.PRICE.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_VALUE_ADDED_TAX_PERCENTAGE, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX_PERCENTAGE.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_VALUE_ADDED_TAX, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_PRICE_VALUE_ADDED_TAX_INCLUDED, userPreferences, furnitureController, "toggleFurnitureSort", HomePieceOfFurniture.SortableProperty.PRICE_VALUE_ADDED_TAX_INCLUDED.name());
        this.createAction(HomeView.ActionType.SORT_HOME_FURNITURE_BY_DESCENDING_ORDER, userPreferences, furnitureController, "toggleFurnitureSortOrder", new Object[0]);
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_CATALOG_ID, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.CATALOG_ID.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_NAME, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.NAME.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_DESCRIPTION, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.DESCRIPTION.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_CREATOR, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.CREATOR.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_LICENSE, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.LICENSE.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_WIDTH, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.WIDTH.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_DEPTH, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.DEPTH.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_HEIGHT, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.HEIGHT.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_X, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.X.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_Y, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.Y.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_ELEVATION, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.ELEVATION.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_ANGLE, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.ANGLE.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_LEVEL, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.LEVEL.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_MODEL_SIZE, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.MODEL_SIZE.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_COLOR, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.COLOR.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_TEXTURE, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.TEXTURE.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_MOVABLE, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.MOVABLE.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_DOOR_OR_WINDOW, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.DOOR_OR_WINDOW.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_VISIBLE, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.VISIBLE.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_PRICE, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.PRICE.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_VALUE_ADDED_TAX_PERCENTAGE, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX_PERCENTAGE.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_VALUE_ADDED_TAX, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX.name());
        this.createAction(HomeView.ActionType.DISPLAY_HOME_FURNITURE_PRICE_VALUE_ADDED_TAX_INCLUDED, userPreferences, furnitureController, "toggleFurnitureVisibleProperty", HomePieceOfFurniture.SortableProperty.PRICE_VALUE_ADDED_TAX_INCLUDED.name());
        this.createAction(HomeView.ActionType.EXPORT_TO_CSV, userPreferences, homeController, "exportToCSV", new Object[0]);
        PlanController planController = homeController.getPlanController();
        if (planController.getView() != null) {
            this.createAction(HomeView.ActionType.SELECT_ALL_AT_ALL_LEVELS, userPreferences, planController, "selectAllAtAllLevels", new Object[0]);
            buttonGroup = new ButtonGroup();
            this.createToggleAction(HomeView.ActionType.SELECT, planController.getMode() == PlanController.Mode.SELECTION, buttonGroup, userPreferences, homeController, "setMode", PlanController.Mode.SELECTION);
            this.createToggleAction(HomeView.ActionType.PAN, planController.getMode() == PlanController.Mode.PANNING, buttonGroup, userPreferences, homeController, "setMode", PlanController.Mode.PANNING);
            this.createToggleAction(HomeView.ActionType.CREATE_WALLS, planController.getMode() == PlanController.Mode.WALL_CREATION, buttonGroup, userPreferences, homeController, "setMode", PlanController.Mode.WALL_CREATION);
            this.createToggleAction(HomeView.ActionType.CREATE_ROOMS, planController.getMode() == PlanController.Mode.ROOM_CREATION, buttonGroup, userPreferences, homeController, "setMode", PlanController.Mode.ROOM_CREATION);
            this.createToggleAction(HomeView.ActionType.CREATE_POLYLINES, planController.getMode() == PlanController.Mode.POLYLINE_CREATION, buttonGroup, userPreferences, homeController, "setMode", PlanController.Mode.POLYLINE_CREATION);
            this.createToggleAction(HomeView.ActionType.CREATE_DIMENSION_LINES, planController.getMode() == PlanController.Mode.DIMENSION_LINE_CREATION, buttonGroup, userPreferences, homeController, "setMode", PlanController.Mode.DIMENSION_LINE_CREATION);
            this.createToggleAction(HomeView.ActionType.CREATE_LABELS, planController.getMode() == PlanController.Mode.LABEL_CREATION, buttonGroup, userPreferences, homeController, "setMode", PlanController.Mode.LABEL_CREATION);
            this.createAction(HomeView.ActionType.DELETE_SELECTION, userPreferences, planController, "deleteSelection", new Object[0]);
            this.createAction(HomeView.ActionType.LOCK_BASE_PLAN, userPreferences, planController, "lockBasePlan", new Object[0]);
            this.createAction(HomeView.ActionType.UNLOCK_BASE_PLAN, userPreferences, planController, "unlockBasePlan", new Object[0]);
            this.createAction(HomeView.ActionType.ENABLE_MAGNETISM, userPreferences, homeController, "enableMagnetism", new Object[0]);
            this.createAction(HomeView.ActionType.DISABLE_MAGNETISM, userPreferences, homeController, "disableMagnetism", new Object[0]);
            this.createAction(HomeView.ActionType.FLIP_HORIZONTALLY, userPreferences, planController, "flipHorizontally", new Object[0]);
            this.createAction(HomeView.ActionType.FLIP_VERTICALLY, userPreferences, planController, "flipVertically", new Object[0]);
            this.createAction(HomeView.ActionType.MODIFY_COMPASS, userPreferences, planController, "modifyCompass", new Object[0]);
            this.createAction(HomeView.ActionType.MODIFY_WALL, userPreferences, planController, "modifySelectedWalls", new Object[0]);
            this.createAction(HomeView.ActionType.JOIN_WALLS, userPreferences, planController, "joinSelectedWalls", new Object[0]);
            this.createAction(HomeView.ActionType.REVERSE_WALL_DIRECTION, userPreferences, planController, "reverseSelectedWallsDirection", new Object[0]);
            this.createAction(HomeView.ActionType.SPLIT_WALL, userPreferences, planController, "splitSelectedWall", new Object[0]);
            this.createAction(HomeView.ActionType.MODIFY_ROOM, userPreferences, planController, "modifySelectedRooms", new Object[0]);
            this.createAction(HomeView.ActionType.ADD_ROOM_POINT, userPreferences);
            this.createAction(HomeView.ActionType.DELETE_ROOM_POINT, userPreferences);
            this.createAction(HomeView.ActionType.RECOMPUTE_ROOM_POINTS, userPreferences);
            this.createAction(HomeView.ActionType.MODIFY_POLYLINE, userPreferences, planController, "modifySelectedPolylines", new Object[0]);
            this.createAction(HomeView.ActionType.MODIFY_DIMENSION_LINE, userPreferences, planController, "modifySelectedDimensionLines", new Object[0]);
            this.createAction(HomeView.ActionType.MODIFY_LABEL, userPreferences, planController, "modifySelectedLabels", new Object[0]);
            this.createAction(HomeView.ActionType.INCREASE_TEXT_SIZE, userPreferences, planController, "increaseTextSize", new Object[0]);
            this.createAction(HomeView.ActionType.DECREASE_TEXT_SIZE, userPreferences, planController, "decreaseTextSize", new Object[0]);
            object = this.createAction(HomeView.ActionType.TOGGLE_BOLD_STYLE, userPreferences, planController, "toggleBoldStyle", new Object[0]);
            object.putValue("ToggleButtonModel", this.createBoldStyleToggleModel(home, userPreferences));
            Action action = this.createAction(HomeView.ActionType.TOGGLE_ITALIC_STYLE, userPreferences, planController, "toggleItalicStyle", new Object[0]);
            action.putValue("ToggleButtonModel", this.createItalicStyleToggleModel(home, userPreferences));
            this.createAction(HomeView.ActionType.IMPORT_BACKGROUND_IMAGE, userPreferences, homeController, "importBackgroundImage", new Object[0]);
            this.createAction(HomeView.ActionType.MODIFY_BACKGROUND_IMAGE, userPreferences, homeController, "modifyBackgroundImage", new Object[0]);
            this.createAction(HomeView.ActionType.HIDE_BACKGROUND_IMAGE, userPreferences, homeController, "hideBackgroundImage", new Object[0]);
            this.createAction(HomeView.ActionType.SHOW_BACKGROUND_IMAGE, userPreferences, homeController, "showBackgroundImage", new Object[0]);
            this.createAction(HomeView.ActionType.DELETE_BACKGROUND_IMAGE, userPreferences, homeController, "deleteBackgroundImage", new Object[0]);
            this.createAction(HomeView.ActionType.ADD_LEVEL, userPreferences, planController, "addLevel", new Object[0]);
            this.createAction(HomeView.ActionType.ADD_LEVEL_AT_SAME_ELEVATION, userPreferences, planController, "addLevelAtSameElevation", new Object[0]);
            this.createAction(HomeView.ActionType.MAKE_LEVEL_VIEWABLE, userPreferences, planController, "toggleSelectedLevelViewability", new Object[0]);
            this.createAction(HomeView.ActionType.MAKE_LEVEL_UNVIEWABLE, userPreferences, planController, "toggleSelectedLevelViewability", new Object[0]);
            this.createAction(HomeView.ActionType.MAKE_LEVEL_ONLY_VIEWABLE_ONE, userPreferences, planController, "setSelectedLevelOnlyViewable", new Object[0]);
            this.createAction(HomeView.ActionType.MAKE_ALL_LEVELS_VIEWABLE, userPreferences, planController, "setAllLevelsViewable", new Object[0]);
            this.createAction(HomeView.ActionType.MODIFY_LEVEL, userPreferences, planController, "modifySelectedLevel", new Object[0]);
            this.createAction(HomeView.ActionType.DELETE_LEVEL, userPreferences, planController, "deleteSelectedLevel", new Object[0]);
            this.createAction(HomeView.ActionType.ZOOM_IN, userPreferences, homeController, "zoomIn", new Object[0]);
            this.createAction(HomeView.ActionType.ZOOM_OUT, userPreferences, homeController, "zoomOut", new Object[0]);
            this.createAction(HomeView.ActionType.EXPORT_TO_SVG, userPreferences, homeController, "exportToSVG", new Object[0]);
        }
        if (homeController3D.getView() != null) {
            this.createAction(HomeView.ActionType.SELECT_OBJECT, userPreferences);
            this.createAction(HomeView.ActionType.TOGGLE_SELECTION, userPreferences);
            buttonGroup = new ButtonGroup();
            this.createToggleAction(HomeView.ActionType.VIEW_FROM_TOP, home.getCamera() == home.getTopCamera(), buttonGroup, userPreferences, homeController3D, "viewFromTop", new Object[0]);
            this.createToggleAction(HomeView.ActionType.VIEW_FROM_OBSERVER, home.getCamera() == home.getObserverCamera(), buttonGroup, userPreferences, homeController3D, "viewFromObserver", new Object[0]);
            this.createAction(HomeView.ActionType.MODIFY_OBSERVER, userPreferences, planController, "modifyObserverCamera", new Object[0]);
            this.createAction(HomeView.ActionType.STORE_POINT_OF_VIEW, userPreferences, homeController, "storeCamera", new Object[0]);
            this.createAction(HomeView.ActionType.DELETE_POINTS_OF_VIEW, userPreferences, homeController, "deleteCameras", new Object[0]);
            this.createAction(HomeView.ActionType.DETACH_3D_VIEW, userPreferences, homeController, "detachView", homeController.getHomeController3D().getView());
            this.createAction(HomeView.ActionType.ATTACH_3D_VIEW, userPreferences, homeController, "attachView", homeController.getHomeController3D().getView());
            object = new ButtonGroup();
            boolean bl = home.getEnvironment().isAllLevelsVisible();
            this.createToggleAction(HomeView.ActionType.DISPLAY_ALL_LEVELS, bl, (ButtonGroup)object, userPreferences, homeController3D, "displayAllLevels", new Object[0]);
            this.createToggleAction(HomeView.ActionType.DISPLAY_SELECTED_LEVEL, !bl, (ButtonGroup)object, userPreferences, homeController3D, "displaySelectedLevel", new Object[0]);
            this.createAction(HomeView.ActionType.MODIFY_3D_ATTRIBUTES, userPreferences, homeController3D, "modifyAttributes", new Object[0]);
            this.createAction(HomeView.ActionType.CREATE_PHOTO, userPreferences, homeController, "createPhoto", new Object[0]);
            this.createAction(HomeView.ActionType.CREATE_PHOTOS_AT_POINTS_OF_VIEW, userPreferences, homeController, "createPhotos", new Object[0]);
            this.createAction(HomeView.ActionType.CREATE_VIDEO, userPreferences, homeController, "createVideo", new Object[0]);
            this.createAction(HomeView.ActionType.EXPORT_TO_OBJ, userPreferences, homeController, "exportToOBJ", new Object[0]);
        }
        this.createAction(HomeView.ActionType.HELP, userPreferences, homeController, "help", new Object[0]);
        this.createAction(HomeView.ActionType.ABOUT, userPreferences, homeController, "about", new Object[0]);
        this.createAdditionalActions(home, homeController);
    }

    private void createAdditionalActions(Home home, HomeController homeController) {
        ActionMap actionMap = this.getActionMap();
        final FurnitureController furnitureController = homeController.getFurnitureController();
        for (final ObjectProperty objectProperty : home.getFurnitureAdditionalProperties()) {
            AbstractAction abstractAction = new AbstractAction(objectProperty.getDisplayedName()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    furnitureController.toggleFurnitureSort(objectProperty.getName());
                }
            };
            abstractAction.putValue("ResourcePrefix", "SORT_HOME_FURNITURE_ADDITIONAL_PROPERTY_BY_");
            actionMap.put("SORT_HOME_FURNITURE_ADDITIONAL_PROPERTY_BY_" + objectProperty.getName(), abstractAction);
            abstractAction = new AbstractAction(objectProperty.getDisplayedName()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    furnitureController.toggleFurnitureVisibleProperty(objectProperty.getName());
                }
            };
            abstractAction.putValue("ResourcePrefix", "DISPLAY_HOME_FURNITURE_ADDITIONAL_PROPERTY_");
            actionMap.put("DISPLAY_HOME_FURNITURE_ADDITIONAL_PROPERTY_" + objectProperty.getName(), abstractAction);
        }
    }

    private Action createAction(HomeView.ActionType actionType, UserPreferences userPreferences, Object object, String string, Object ... objectArray) {
        try {
            ControllerAction controllerAction = new ControllerAction(userPreferences, HomePane.class, actionType.name(), object, string, objectArray);
            this.getActionMap().put((Object)actionType, controllerAction);
            return controllerAction;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    private Action createAction(HomeView.ActionType actionType, UserPreferences userPreferences) {
        ResourceAction resourceAction = new ResourceAction(userPreferences, HomePane.class, actionType.name()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.getActionMap().put((Object)actionType, resourceAction);
        return resourceAction;
    }

    private Action createToggleAction(HomeView.ActionType actionType, boolean bl, ButtonGroup buttonGroup, UserPreferences userPreferences, Object object, String string, Object ... objectArray) {
        Action action = this.createAction(actionType, userPreferences, object, string, objectArray);
        JToggleButton.ToggleButtonModel toggleButtonModel = new JToggleButton.ToggleButtonModel();
        if (buttonGroup != null) {
            toggleButtonModel.setGroup(buttonGroup);
        }
        toggleButtonModel.setSelected(bl);
        action.putValue("ToggleButtonModel", toggleButtonModel);
        return action;
    }

    private void createClipboardAction(HomeView.ActionType actionType, UserPreferences userPreferences, final Action action, final boolean bl) {
        this.getActionMap().put((Object)actionType, new ResourceAction(userPreferences, HomePane.class, actionType.name()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (bl) {
                    HomePane.this.clipboardEmpty = false;
                }
                actionEvent = new ActionEvent(HomePane.this.lastFocusedComponent, 1001, null);
                action.actionPerformed(actionEvent);
            }
        });
    }

    private void createMenuActions(UserPreferences userPreferences, HomeController homeController) {
        this.menuActionMap = new ActionMap();
        this.createMenuAction(userPreferences, MenuActionType.FILE_MENU);
        this.createMenuAction(userPreferences, MenuActionType.EDIT_MENU);
        this.createMenuAction(userPreferences, MenuActionType.FURNITURE_MENU);
        this.createMenuAction(userPreferences, MenuActionType.PLAN_MENU);
        this.createMenuAction(userPreferences, MenuActionType.VIEW_3D_MENU);
        this.createMenuAction(userPreferences, MenuActionType.HELP_MENU);
        this.createMenuAction(userPreferences, MenuActionType.OPEN_RECENT_HOME_MENU);
        this.createMenuAction(userPreferences, MenuActionType.SORT_HOME_FURNITURE_MENU);
        this.createMenuAction(userPreferences, MenuActionType.ALIGN_OR_DISTRIBUTE_MENU);
        this.createMenuAction(userPreferences, MenuActionType.DISPLAY_HOME_FURNITURE_PROPERTY_MENU);
        this.createMenuAction(userPreferences, MenuActionType.MODIFY_TEXT_STYLE);
        this.createMenuAction(userPreferences, MenuActionType.LEVELS_MENU);
        this.createMenuAction(userPreferences, MenuActionType.GO_TO_POINT_OF_VIEW);
        this.createMenuAction(userPreferences, MenuActionType.SELECT_OBJECT_MENU);
        this.createMenuAction(userPreferences, MenuActionType.TOGGLE_SELECTION_MENU);
    }

    private void createMenuAction(UserPreferences userPreferences, MenuActionType menuActionType) {
        this.menuActionMap.put((Object)menuActionType, new ResourceAction(userPreferences, HomePane.class, menuActionType.name(), true));
    }

    private void createPluginActions(List<Plugin> list) {
        this.pluginActions = new ArrayList<Action>();
        if (list != null) {
            for (Plugin plugin : list) {
                for (PluginAction pluginAction : plugin.getActions()) {
                    this.pluginActions.add(new ActionAdapter(pluginAction));
                }
            }
        }
    }

    private void createTransferHandlers(Home home, HomeController homeController) {
        this.catalogTransferHandler = new FurnitureCatalogTransferHandler(homeController.getContentManager(), homeController.getFurnitureCatalogController(), homeController.getFurnitureController());
        this.furnitureTransferHandler = new FurnitureTransferHandler(home, homeController.getContentManager(), homeController);
        this.planTransferHandler = new PlanTransferHandler(home, homeController.getContentManager(), homeController);
        this.view3DTransferHandler = new Component3DTransferHandler(home, homeController);
    }

    private void addHomeListeners(final Home home, final HomeController homeController) {
        home.addPropertyChangeListener(Home.Property.CAMERA, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomePane.this.setToggleButtonModelSelected(HomeView.ActionType.VIEW_FROM_TOP, home.getCamera() == home.getTopCamera());
                HomePane.this.setToggleButtonModelSelected(HomeView.ActionType.VIEW_FROM_OBSERVER, home.getCamera() == home.getObserverCamera());
            }
        });
        final JMenuBar jMenuBar = this.getJMenuBar();
        home.addPropertyChangeListener(Home.Property.FURNITURE_ADDITIONAL_PROPERTIES, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JPopupMenu jPopupMenu;
                HomePane.this.createAdditionalActions(home, homeController);
                HomePane.this.updateFurnitureSortMenu(this.findMenu(jMenuBar, MenuActionType.SORT_HOME_FURNITURE_MENU), home);
                HomePane.this.updateDisplayPropertyMenu(this.findMenu(jMenuBar, MenuActionType.DISPLAY_HOME_FURNITURE_PROPERTY_MENU), home);
                JComponent jComponent = (JComponent)((Object)homeController.getFurnitureController().getView());
                if (jComponent != null && (jPopupMenu = jComponent.getComponentPopupMenu()) != null) {
                    HomePane.this.updateFurnitureSortMenu(this.findMenu(jPopupMenu, MenuActionType.SORT_HOME_FURNITURE_MENU), home);
                    HomePane.this.updateDisplayPropertyMenu(this.findMenu(jPopupMenu, MenuActionType.DISPLAY_HOME_FURNITURE_PROPERTY_MENU), home);
                }
            }

            private JMenu findMenu(MenuElement menuElement, MenuActionType menuActionType) {
                if (menuElement instanceof JMenu && ((JMenu)menuElement).getAction() != null && menuActionType.name().equals(((JMenu)menuElement).getAction().getValue("ResourcePrefix"))) {
                    return (JMenu)menuElement;
                }
                for (MenuElement menuElement2 : menuElement.getSubElements()) {
                    JMenu jMenu = this.findMenu(menuElement2, menuActionType);
                    if (jMenu == null) continue;
                    return jMenu;
                }
                return null;
            }
        });
    }

    private void setToggleButtonModelSelected(HomeView.ActionType actionType, boolean bl) {
        ((JToggleButton.ToggleButtonModel)this.getActionMap().get((Object)actionType).getValue("ToggleButtonModel")).setSelected(bl);
    }

    private void addLevelVisibilityListener(final Home home) {
        home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.ALL_LEVELS_VISIBLE, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = home.getEnvironment().isAllLevelsVisible();
                HomePane.this.setToggleButtonModelSelected(HomeView.ActionType.DISPLAY_ALL_LEVELS, bl);
                HomePane.this.setToggleButtonModelSelected(HomeView.ActionType.DISPLAY_SELECTED_LEVEL, !bl);
            }
        });
    }

    private void addUserPreferencesListener(UserPreferences userPreferences) {
        UserPreferencesChangeListener userPreferencesChangeListener = new UserPreferencesChangeListener(this);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, userPreferencesChangeListener);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.CURRENCY, userPreferencesChangeListener);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.VALUE_ADDED_TAX_ENABLED, userPreferencesChangeListener);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.EDITING_IN_3D_VIEW_ENABLED, userPreferencesChangeListener);
    }

    private void initActions(UserPreferences userPreferences) {
        ActionMap actionMap = this.getActionMap();
        actionMap.get((Object)HomeView.ActionType.DISPLAY_HOME_FURNITURE_CATALOG_ID).putValue("Visible", Boolean.FALSE);
        actionMap.get((Object)HomeView.ActionType.SORT_HOME_FURNITURE_BY_CATALOG_ID).putValue("Visible", Boolean.FALSE);
        actionMap.get((Object)HomeView.ActionType.DISPLAY_HOME_FURNITURE_PRICE).putValue("Visible", userPreferences.getCurrency() != null);
        actionMap.get((Object)HomeView.ActionType.SORT_HOME_FURNITURE_BY_PRICE).putValue("Visible", userPreferences.getCurrency() != null);
        actionMap.get((Object)HomeView.ActionType.DISPLAY_HOME_FURNITURE_VALUE_ADDED_TAX_PERCENTAGE).putValue("Visible", userPreferences.isValueAddedTaxEnabled());
        actionMap.get((Object)HomeView.ActionType.DISPLAY_HOME_FURNITURE_VALUE_ADDED_TAX).putValue("Visible", userPreferences.isValueAddedTaxEnabled());
        actionMap.get((Object)HomeView.ActionType.DISPLAY_HOME_FURNITURE_PRICE_VALUE_ADDED_TAX_INCLUDED).putValue("Visible", userPreferences.isValueAddedTaxEnabled());
        actionMap.get((Object)HomeView.ActionType.SORT_HOME_FURNITURE_BY_VALUE_ADDED_TAX_PERCENTAGE).putValue("Visible", userPreferences.isValueAddedTaxEnabled());
        actionMap.get((Object)HomeView.ActionType.SORT_HOME_FURNITURE_BY_VALUE_ADDED_TAX).putValue("Visible", userPreferences.isValueAddedTaxEnabled());
        actionMap.get((Object)HomeView.ActionType.SORT_HOME_FURNITURE_BY_PRICE_VALUE_ADDED_TAX_INCLUDED).putValue("Visible", userPreferences.isValueAddedTaxEnabled());
    }

    private void addPlanControllerListener(final PlanController planController) {
        planController.addPropertyChangeListener(PlanController.Property.MODE, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PlanController.Mode mode = planController.getMode();
                HomePane.this.setToggleButtonModelSelected(HomeView.ActionType.SELECT, mode == PlanController.Mode.SELECTION);
                HomePane.this.setToggleButtonModelSelected(HomeView.ActionType.PAN, mode == PlanController.Mode.PANNING);
                HomePane.this.setToggleButtonModelSelected(HomeView.ActionType.CREATE_WALLS, mode == PlanController.Mode.WALL_CREATION);
                HomePane.this.setToggleButtonModelSelected(HomeView.ActionType.CREATE_ROOMS, mode == PlanController.Mode.ROOM_CREATION);
                HomePane.this.setToggleButtonModelSelected(HomeView.ActionType.CREATE_POLYLINES, mode == PlanController.Mode.POLYLINE_CREATION);
                HomePane.this.setToggleButtonModelSelected(HomeView.ActionType.CREATE_DIMENSION_LINES, mode == PlanController.Mode.DIMENSION_LINE_CREATION);
                HomePane.this.setToggleButtonModelSelected(HomeView.ActionType.CREATE_LABELS, mode == PlanController.Mode.LABEL_CREATION);
            }
        });
    }

    private void addFocusListener() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("currentFocusCycleRoot", new FocusCycleRootChangeListener(this));
    }

    private void updateFocusTraversalPolicy() {
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            protected boolean accept(Component component) {
                if (super.accept(component)) {
                    JSplitPane jSplitPane;
                    while ((jSplitPane = (JSplitPane)SwingUtilities.getAncestorOfClass(JSplitPane.class, component)) != null) {
                        if (HomePane.this.isChildComponentInvisible(jSplitPane, component)) {
                            return false;
                        }
                        component = jSplitPane;
                    }
                    return true;
                }
                return false;
            }
        });
        this.setFocusTraversalPolicyProvider(true);
    }

    private boolean isChildComponentInvisible(JSplitPane jSplitPane, Component component) {
        return SwingUtilities.isDescendingFrom(component, jSplitPane.getTopComponent()) && (jSplitPane.getTopComponent().getWidth() == 0 || jSplitPane.getTopComponent().getHeight() == 0) || SwingUtilities.isDescendingFrom(component, jSplitPane.getBottomComponent()) && (jSplitPane.getBottomComponent().getWidth() == 0 || jSplitPane.getBottomComponent().getHeight() == 0);
    }

    private JMenuBar createMenuBar(Home home, UserPreferences userPreferences, final HomeController homeController) {
        JMenuItem jMenuItem;
        JMenu jMenu;
        JMenu jMenu2 = new JMenu(this.menuActionMap.get((Object)MenuActionType.FILE_MENU));
        this.addActionToMenu(HomeView.ActionType.NEW_HOME, jMenu2);
        if (userPreferences.getHomeExamples().size() > 0) {
            this.addActionToMenu(HomeView.ActionType.NEW_HOME_FROM_EXAMPLE, jMenu2);
        }
        this.addActionToMenu(HomeView.ActionType.OPEN, jMenu2);
        Action action = this.menuActionMap.get((Object)MenuActionType.OPEN_RECENT_HOME_MENU);
        if (action.getValue("Name") != null) {
            jMenu = new JMenu(new ResourceAction.MenuItemAction(action));
            this.addActionToMenu(HomeView.ActionType.DELETE_RECENT_HOMES, jMenu);
            jMenu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent menuEvent) {
                    HomePane.this.updateOpenRecentHomeMenu(jMenu, homeController);
                }

                @Override
                public void menuCanceled(MenuEvent menuEvent) {
                }

                @Override
                public void menuDeselected(MenuEvent menuEvent) {
                }
            });
            jMenu2.add(jMenu);
        }
        jMenu2.addSeparator();
        this.addActionToMenu(HomeView.ActionType.CLOSE, jMenu2);
        this.addActionToMenu(HomeView.ActionType.SAVE, jMenu2);
        this.addActionToMenu(HomeView.ActionType.SAVE_AS, jMenu2);
        this.addActionToMenu(HomeView.ActionType.SAVE_AND_COMPRESS, jMenu2);
        jMenu2.addSeparator();
        this.addActionToMenu(HomeView.ActionType.PAGE_SETUP, jMenu2);
        this.addActionToMenu(HomeView.ActionType.PRINT_PREVIEW, jMenu2);
        this.addActionToMenu(HomeView.ActionType.PRINT, jMenu2);
        if (!OperatingSystem.isMacOSX()) {
            this.addActionToMenu(HomeView.ActionType.PRINT_TO_PDF, jMenu2);
        }
        if (!OperatingSystem.isMacOSX() || !Boolean.getBoolean("apple.laf.useScreenMenuBar")) {
            jMenu2.addSeparator();
            this.addActionToMenu(HomeView.ActionType.PREFERENCES, jMenu2);
        }
        jMenu = new JMenu(this.menuActionMap.get((Object)MenuActionType.EDIT_MENU));
        this.addActionToMenu(HomeView.ActionType.UNDO, jMenu);
        this.addActionToMenu(HomeView.ActionType.REDO, jMenu);
        jMenu.addSeparator();
        this.addActionToMenu(HomeView.ActionType.CUT, jMenu);
        this.addActionToMenu(HomeView.ActionType.COPY, jMenu);
        this.addActionToMenu(HomeView.ActionType.PASTE, jMenu);
        this.addActionToMenu(HomeView.ActionType.PASTE_TO_GROUP, jMenu);
        this.addActionToMenu(HomeView.ActionType.PASTE_STYLE, jMenu);
        jMenu.addSeparator();
        this.addActionToMenu(HomeView.ActionType.DELETE, jMenu);
        this.addActionToMenu(HomeView.ActionType.SELECT_ALL, jMenu);
        this.addActionToMenu(HomeView.ActionType.SELECT_ALL_AT_ALL_LEVELS, jMenu);
        JMenu jMenu3 = new JMenu(this.menuActionMap.get((Object)MenuActionType.FURNITURE_MENU));
        this.addActionToMenu(HomeView.ActionType.ADD_HOME_FURNITURE, jMenu3);
        this.addActionToMenu(HomeView.ActionType.ADD_FURNITURE_TO_GROUP, jMenu3);
        this.addActionToMenu(HomeView.ActionType.MODIFY_FURNITURE, jMenu3);
        this.addActionToMenu(HomeView.ActionType.GROUP_FURNITURE, jMenu3);
        this.addActionToMenu(HomeView.ActionType.UNGROUP_FURNITURE, jMenu3);
        jMenu3.addSeparator();
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_ON_TOP, jMenu3);
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_ON_BOTTOM, jMenu3);
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_ON_LEFT, jMenu3);
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_ON_RIGHT, jMenu3);
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_ON_FRONT_SIDE, jMenu3);
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_ON_BACK_SIDE, jMenu3);
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_ON_LEFT_SIDE, jMenu3);
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_ON_RIGHT_SIDE, jMenu3);
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_SIDE_BY_SIDE, jMenu3);
        this.addActionToMenu(HomeView.ActionType.DISTRIBUTE_FURNITURE_HORIZONTALLY, jMenu3);
        this.addActionToMenu(HomeView.ActionType.DISTRIBUTE_FURNITURE_VERTICALLY, jMenu3);
        this.addActionToMenu(HomeView.ActionType.RESET_FURNITURE_ELEVATION, jMenu3);
        jMenu3.addSeparator();
        this.addActionToMenu(HomeView.ActionType.IMPORT_FURNITURE, jMenu3);
        this.addActionToMenu(HomeView.ActionType.IMPORT_FURNITURE_LIBRARY, jMenu3);
        this.addActionToMenu(HomeView.ActionType.IMPORT_TEXTURE, jMenu3);
        this.addActionToMenu(HomeView.ActionType.IMPORT_TEXTURES_LIBRARY, jMenu3);
        jMenu3.addSeparator();
        jMenu3.add(this.createFurnitureSortMenu(home, userPreferences));
        jMenu3.add(this.createFurnitureDisplayPropertyMenu(home, userPreferences));
        jMenu3.addSeparator();
        this.addActionToMenu(HomeView.ActionType.EXPORT_TO_CSV, jMenu3);
        JMenu jMenu4 = new JMenu(this.menuActionMap.get((Object)MenuActionType.PLAN_MENU));
        this.addToggleActionToMenu(HomeView.ActionType.SELECT, true, jMenu4);
        this.addToggleActionToMenu(HomeView.ActionType.PAN, true, jMenu4);
        this.addToggleActionToMenu(HomeView.ActionType.CREATE_WALLS, true, jMenu4);
        this.addToggleActionToMenu(HomeView.ActionType.CREATE_ROOMS, true, jMenu4);
        this.addToggleActionToMenu(HomeView.ActionType.CREATE_POLYLINES, true, jMenu4);
        this.addToggleActionToMenu(HomeView.ActionType.CREATE_DIMENSION_LINES, true, jMenu4);
        this.addToggleActionToMenu(HomeView.ActionType.CREATE_LABELS, true, jMenu4);
        jMenu4.addSeparator();
        JMenuItem jMenuItem2 = this.createLockUnlockBasePlanMenuItem(home, false);
        if (jMenuItem2 != null) {
            jMenu4.add(jMenuItem2);
        }
        this.addActionToMenu(HomeView.ActionType.FLIP_HORIZONTALLY, jMenu4);
        this.addActionToMenu(HomeView.ActionType.FLIP_VERTICALLY, jMenu4);
        this.addActionToMenu(HomeView.ActionType.MODIFY_COMPASS, jMenu4);
        this.addActionToMenu(HomeView.ActionType.MODIFY_WALL, jMenu4);
        this.addActionToMenu(HomeView.ActionType.JOIN_WALLS, jMenu4);
        this.addActionToMenu(HomeView.ActionType.REVERSE_WALL_DIRECTION, jMenu4);
        this.addActionToMenu(HomeView.ActionType.SPLIT_WALL, jMenu4);
        this.addActionToMenu(HomeView.ActionType.MODIFY_ROOM, jMenu4);
        this.addActionToMenu(HomeView.ActionType.MODIFY_POLYLINE, jMenu4);
        this.addActionToMenu(HomeView.ActionType.MODIFY_DIMENSION_LINE, jMenu4);
        this.addActionToMenu(HomeView.ActionType.MODIFY_LABEL, jMenu4);
        jMenu4.add(this.createTextStyleMenu(home, userPreferences, false));
        jMenu4.addSeparator();
        JMenuItem jMenuItem3 = this.createImportModifyBackgroundImageMenuItem(home, false);
        if (jMenuItem3 != null) {
            jMenu4.add(jMenuItem3);
        }
        if ((jMenuItem = this.createHideShowBackgroundImageMenuItem(home, false)) != null) {
            jMenu4.add(jMenuItem);
        }
        this.addActionToMenu(HomeView.ActionType.DELETE_BACKGROUND_IMAGE, jMenu4);
        jMenu4.addSeparator();
        jMenu4.add(this.createLevelsMenu(home, userPreferences));
        jMenu4.addSeparator();
        this.addActionToMenu(HomeView.ActionType.ZOOM_IN, jMenu4);
        this.addActionToMenu(HomeView.ActionType.ZOOM_OUT, jMenu4);
        jMenu4.addSeparator();
        this.addActionToMenu(HomeView.ActionType.EXPORT_TO_SVG, jMenu4);
        JMenu jMenu5 = new JMenu(this.menuActionMap.get((Object)MenuActionType.VIEW_3D_MENU));
        this.addToggleActionToMenu(HomeView.ActionType.VIEW_FROM_TOP, true, jMenu5);
        this.addToggleActionToMenu(HomeView.ActionType.VIEW_FROM_OBSERVER, true, jMenu5);
        this.addActionToMenu(HomeView.ActionType.MODIFY_OBSERVER, jMenu5);
        this.addActionToMenu(HomeView.ActionType.STORE_POINT_OF_VIEW, jMenu5);
        JMenu jMenu6 = this.createGoToPointOfViewMenu(home, userPreferences, homeController);
        if (jMenu6 != null) {
            jMenu5.add(jMenu6);
        }
        this.addActionToMenu(HomeView.ActionType.DELETE_POINTS_OF_VIEW, jMenu5);
        jMenu5.addSeparator();
        JMenuItem jMenuItem4 = this.createAttachDetach3DViewMenuItem(homeController, false);
        if (jMenuItem4 != null) {
            jMenu5.add(jMenuItem4);
        }
        this.addToggleActionToMenu(HomeView.ActionType.DISPLAY_ALL_LEVELS, true, jMenu5);
        this.addToggleActionToMenu(HomeView.ActionType.DISPLAY_SELECTED_LEVEL, true, jMenu5);
        this.addActionToMenu(HomeView.ActionType.MODIFY_3D_ATTRIBUTES, jMenu5);
        jMenu5.addSeparator();
        this.addActionToMenu(HomeView.ActionType.CREATE_PHOTO, jMenu5);
        this.addActionToMenu(HomeView.ActionType.CREATE_PHOTOS_AT_POINTS_OF_VIEW, jMenu5);
        this.addActionToMenu(HomeView.ActionType.CREATE_VIDEO, jMenu5);
        jMenu5.addSeparator();
        this.addActionToMenu(HomeView.ActionType.EXPORT_TO_OBJ, jMenu5);
        JMenu jMenu7 = new JMenu(this.menuActionMap.get((Object)MenuActionType.HELP_MENU));
        this.addActionToMenu(HomeView.ActionType.HELP, jMenu7);
        if (!OperatingSystem.isMacOSX() || !Boolean.getBoolean("apple.laf.useScreenMenuBar")) {
            this.addActionToMenu(HomeView.ActionType.ABOUT, jMenu7);
        }
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu3);
        if (homeController.getPlanController().getView() != null) {
            jMenuBar.add(jMenu4);
        }
        if (homeController.getHomeController3D().getView() != null) {
            jMenuBar.add(jMenu5);
        }
        jMenuBar.add(jMenu7);
        for (Action action2 : this.pluginActions) {
            String string = (String)action2.getValue(PluginAction.Property.MENU.name());
            if (string == null) continue;
            boolean bl = false;
            for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
                JMenu jMenu8 = jMenuBar.getMenu(i);
                if (!jMenu8.getText().equals(string)) continue;
                jMenu8.addSeparator();
                jMenu8.add(new ResourceAction.MenuItemAction(action2));
                bl = true;
                break;
            }
            if (bl) continue;
            JMenu jMenu9 = new JMenu(string);
            jMenu9.add(new ResourceAction.MenuItemAction(action2));
            jMenuBar.add((Component)jMenu9, jMenuBar.getMenuCount() - 1);
        }
        if (!OperatingSystem.isMacOSX() || !Boolean.getBoolean("apple.laf.useScreenMenuBar")) {
            jMenu2.addSeparator();
            this.addActionToMenu(HomeView.ActionType.EXIT, jMenu2);
        }
        this.removeUselessSeparatorsAndEmptyMenus(jMenuBar);
        return jMenuBar;
    }

    private void addActionToMenu(HomeView.ActionType actionType, JMenu jMenu) {
        this.addActionToMenu(actionType, false, jMenu);
    }

    private void addActionToMenu(HomeView.ActionType actionType, boolean bl, JMenu jMenu) {
        Action action = this.getActionMap().get((Object)actionType);
        if (action != null && action.getValue("Name") != null) {
            jMenu.add(bl ? new ResourceAction.PopupMenuItemAction(action) : new ResourceAction.MenuItemAction(action));
        }
    }

    private void addToggleActionToMenu(HomeView.ActionType actionType, boolean bl, JMenu jMenu) {
        this.addToggleActionToMenu(actionType, false, bl, jMenu);
    }

    private void addToggleActionToMenu(HomeView.ActionType actionType, boolean bl, boolean bl2, JMenu jMenu) {
        Action action = this.getActionMap().get((Object)actionType);
        if (action != null && action.getValue("Name") != null) {
            jMenu.add(this.createToggleMenuItem(action, bl, bl2));
        }
    }

    private JMenuItem createToggleMenuItem(Action action, boolean bl, boolean bl2) {
        JMenuItem jMenuItem = bl2 ? new JRadioButtonMenuItem() : new JCheckBoxMenuItem();
        jMenuItem.setModel((JToggleButton.ToggleButtonModel)action.getValue("ToggleButtonModel"));
        jMenuItem.setAction(bl ? new ResourceAction.PopupMenuItemAction(action) : new ResourceAction.MenuItemAction(action));
        return jMenuItem;
    }

    private JMenuItem addActionToPopupMenu(HomeView.ActionType actionType, JPopupMenu jPopupMenu) {
        Action action = this.getActionMap().get((Object)actionType);
        if (action != null && action.getValue("Name") != null) {
            jPopupMenu.add(new ResourceAction.PopupMenuItemAction(action));
            return (JMenuItem)jPopupMenu.getComponent(jPopupMenu.getComponentCount() - 1);
        }
        return null;
    }

    private void addToggleActionToPopupMenu(HomeView.ActionType actionType, boolean bl, JPopupMenu jPopupMenu) {
        Action action = this.getActionMap().get((Object)actionType);
        if (action != null && action.getValue("Name") != null) {
            jPopupMenu.add(this.createToggleMenuItem(action, true, bl));
        }
    }

    private void removeUselessSeparatorsAndEmptyMenus(JComponent jComponent) {
        for (int i = jComponent.getComponentCount() - 1; i >= 0; --i) {
            Component component = jComponent.getComponent(i);
            if (component instanceof JSeparator && (i == jComponent.getComponentCount() - 1 || i > 0 && jComponent.getComponent(i - 1) instanceof JSeparator)) {
                jComponent.remove(i);
            } else if (component instanceof JMenu) {
                this.removeUselessSeparatorsAndEmptyMenus(((JMenu)component).getPopupMenu());
            }
            if (!(component instanceof JMenu) || ((JMenu)component).getMenuComponentCount() != 0 && (((JMenu)component).getMenuComponentCount() != 1 || !(((JMenu)component).getMenuComponent(0) instanceof JSeparator))) continue;
            jComponent.remove(i);
        }
        if (jComponent.getComponentCount() > 0 && jComponent.getComponent(0) instanceof JSeparator) {
            jComponent.remove(0);
        }
    }

    private JMenu createAlignOrDistributeMenu(Home home, UserPreferences userPreferences, boolean bl) {
        JMenu jMenu = new JMenu(this.menuActionMap.get((Object)MenuActionType.ALIGN_OR_DISTRIBUTE_MENU));
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_ON_TOP, bl, jMenu);
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_ON_BOTTOM, bl, jMenu);
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_ON_LEFT, bl, jMenu);
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_ON_RIGHT, bl, jMenu);
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_ON_FRONT_SIDE, bl, jMenu);
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_ON_BACK_SIDE, bl, jMenu);
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_ON_LEFT_SIDE, bl, jMenu);
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_ON_RIGHT_SIDE, bl, jMenu);
        this.addActionToMenu(HomeView.ActionType.ALIGN_FURNITURE_SIDE_BY_SIDE, bl, jMenu);
        this.addActionToMenu(HomeView.ActionType.DISTRIBUTE_FURNITURE_HORIZONTALLY, bl, jMenu);
        this.addActionToMenu(HomeView.ActionType.DISTRIBUTE_FURNITURE_VERTICALLY, bl, jMenu);
        return jMenu;
    }

    private JMenu createFurnitureSortMenu(final Home home, UserPreferences userPreferences) {
        JMenu jMenu = new JMenu(new ResourceAction.MenuItemAction(this.menuActionMap.get((Object)MenuActionType.SORT_HOME_FURNITURE_MENU)));
        LinkedHashMap<Object, Action> linkedHashMap = new LinkedHashMap<Object, Action>();
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_CATALOG_ID, linkedHashMap, HomePieceOfFurniture.SortableProperty.CATALOG_ID.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_NAME, linkedHashMap, HomePieceOfFurniture.SortableProperty.NAME.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_DESCRIPTION, linkedHashMap, HomePieceOfFurniture.SortableProperty.DESCRIPTION.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_CREATOR, linkedHashMap, HomePieceOfFurniture.SortableProperty.CREATOR.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_LICENSE, linkedHashMap, HomePieceOfFurniture.SortableProperty.LICENSE.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_WIDTH, linkedHashMap, HomePieceOfFurniture.SortableProperty.WIDTH.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_DEPTH, linkedHashMap, HomePieceOfFurniture.SortableProperty.DEPTH.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_HEIGHT, linkedHashMap, HomePieceOfFurniture.SortableProperty.HEIGHT.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_X, linkedHashMap, HomePieceOfFurniture.SortableProperty.X.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_Y, linkedHashMap, HomePieceOfFurniture.SortableProperty.Y.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_ELEVATION, linkedHashMap, HomePieceOfFurniture.SortableProperty.ELEVATION.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_ANGLE, linkedHashMap, HomePieceOfFurniture.SortableProperty.ANGLE.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_LEVEL, linkedHashMap, HomePieceOfFurniture.SortableProperty.LEVEL.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_MODEL_SIZE, linkedHashMap, HomePieceOfFurniture.SortableProperty.MODEL_SIZE.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_COLOR, linkedHashMap, HomePieceOfFurniture.SortableProperty.COLOR.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_TEXTURE, linkedHashMap, HomePieceOfFurniture.SortableProperty.TEXTURE.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_MOVABILITY, linkedHashMap, HomePieceOfFurniture.SortableProperty.MOVABLE.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_TYPE, linkedHashMap, HomePieceOfFurniture.SortableProperty.DOOR_OR_WINDOW.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_VISIBILITY, linkedHashMap, HomePieceOfFurniture.SortableProperty.VISIBLE.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_PRICE, linkedHashMap, HomePieceOfFurniture.SortableProperty.PRICE.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_VALUE_ADDED_TAX_PERCENTAGE, linkedHashMap, HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX_PERCENTAGE.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_VALUE_ADDED_TAX, linkedHashMap, HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX.name());
        this.addActionToMap(HomeView.ActionType.SORT_HOME_FURNITURE_BY_PRICE_VALUE_ADDED_TAX_INCLUDED, linkedHashMap, HomePieceOfFurniture.SortableProperty.PRICE_VALUE_ADDED_TAX_INCLUDED.name());
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Map.Entry object : linkedHashMap.entrySet()) {
            final Object k = object.getKey();
            Action action = (Action)object.getValue();
            final JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
            jRadioButtonMenuItem.setModel(new JToggleButton.ToggleButtonModel(){

                @Override
                public boolean isSelected() {
                    return k.equals(home.getFurnitureSortedPropertyName());
                }
            });
            final ResourceAction.MenuItemAction menuItemAction = new ResourceAction.MenuItemAction(action);
            jRadioButtonMenuItem.setAction(menuItemAction);
            if (action instanceof ResourceAction) {
                jRadioButtonMenuItem.setVisible(Boolean.TRUE.equals(action.getValue("Visible")));
                action.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("Visible".equals(propertyChangeEvent.getPropertyName())) {
                            Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                            jRadioButtonMenuItem.setVisible(bl);
                            if (k.equals(home.getFurnitureSortedPropertyName())) {
                                menuItemAction.actionPerformed(null);
                            }
                        }
                    }
                });
            }
            jMenu.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem);
        }
        Action action = this.getActionMap().get((Object)HomeView.ActionType.SORT_HOME_FURNITURE_BY_DESCENDING_ORDER);
        if (action.getValue("Name") != null) {
            jMenu.addSeparator();
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
            jCheckBoxMenuItem.setModel(new JToggleButton.ToggleButtonModel(){

                @Override
                public boolean isSelected() {
                    return home.isFurnitureDescendingSorted();
                }
            });
            jCheckBoxMenuItem.setAction(new ResourceAction.MenuItemAction(action));
            jMenu.add(jCheckBoxMenuItem);
        }
        this.updateFurnitureSortMenu(jMenu, home);
        return jMenu;
    }

    private void updateFurnitureSortMenu(JMenu jMenu, final Home home) {
        Serializable serializable;
        int n = -1;
        for (int i = jMenu.getMenuComponentCount() - 1; i > 0; --i) {
            Object object;
            serializable = (JComponent)jMenu.getMenuComponent(i);
            if (!(serializable instanceof JMenuItem) || (object = (String)((JMenuItem)serializable).getAction().getValue("ResourcePrefix")) == null || !((String)object).startsWith("SORT_HOME_FURNITURE_ADDITIONAL_PROPERTY_BY_")) continue;
            jMenu.remove((Component)serializable);
            n = i;
        }
        List<ObjectProperty> list = home.getFurnitureAdditionalProperties();
        if (list.size() > 0) {
            if (n == -1) {
                jMenu.add((Component)new JPopupMenu.Separator(), jMenu.getMenuComponentCount() - 2);
            }
            serializable = ((DefaultButtonModel)((AbstractButton)jMenu.getMenuComponent(0)).getModel()).getGroup();
            for (final ObjectProperty objectProperty : list) {
                if (!objectProperty.isDisplayable()) continue;
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
                jRadioButtonMenuItem.setModel(new JToggleButton.ToggleButtonModel(){

                    @Override
                    public boolean isSelected() {
                        return objectProperty.getName().equals(home.getFurnitureSortedPropertyName());
                    }
                });
                jRadioButtonMenuItem.setAction(new ResourceAction.MenuItemAction(this.getActionMap().get("SORT_HOME_FURNITURE_ADDITIONAL_PROPERTY_BY_" + objectProperty.getName())));
                jMenu.add((Component)jRadioButtonMenuItem, jMenu.getMenuComponentCount() - 2);
                ((ButtonGroup)serializable).add(jRadioButtonMenuItem);
            }
        } else {
            jMenu.remove(jMenu.getMenuComponentCount() - 3);
        }
    }

    private void addActionToMap(HomeView.ActionType actionType, Map<Object, Action> map, Object object) {
        Action action = this.getActionMap().get((Object)actionType);
        if (action != null && action.getValue("Name") != null) {
            map.put(object, action);
        }
    }

    private JMenu createFurnitureDisplayPropertyMenu(final Home home, UserPreferences userPreferences) {
        JMenu jMenu = new JMenu(new ResourceAction.MenuItemAction(this.menuActionMap.get((Object)MenuActionType.DISPLAY_HOME_FURNITURE_PROPERTY_MENU)));
        LinkedHashMap<Object, Action> linkedHashMap = new LinkedHashMap<Object, Action>();
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_CATALOG_ID, linkedHashMap, HomePieceOfFurniture.SortableProperty.CATALOG_ID.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_NAME, linkedHashMap, HomePieceOfFurniture.SortableProperty.NAME.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_DESCRIPTION, linkedHashMap, HomePieceOfFurniture.SortableProperty.DESCRIPTION.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_CREATOR, linkedHashMap, HomePieceOfFurniture.SortableProperty.CREATOR.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_LICENSE, linkedHashMap, HomePieceOfFurniture.SortableProperty.LICENSE.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_WIDTH, linkedHashMap, HomePieceOfFurniture.SortableProperty.WIDTH.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_DEPTH, linkedHashMap, HomePieceOfFurniture.SortableProperty.DEPTH.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_HEIGHT, linkedHashMap, HomePieceOfFurniture.SortableProperty.HEIGHT.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_X, linkedHashMap, HomePieceOfFurniture.SortableProperty.X.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_Y, linkedHashMap, HomePieceOfFurniture.SortableProperty.Y.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_ELEVATION, linkedHashMap, HomePieceOfFurniture.SortableProperty.ELEVATION.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_ANGLE, linkedHashMap, HomePieceOfFurniture.SortableProperty.ANGLE.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_LEVEL, linkedHashMap, HomePieceOfFurniture.SortableProperty.LEVEL.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_MODEL_SIZE, linkedHashMap, HomePieceOfFurniture.SortableProperty.MODEL_SIZE.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_COLOR, linkedHashMap, HomePieceOfFurniture.SortableProperty.COLOR.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_TEXTURE, linkedHashMap, HomePieceOfFurniture.SortableProperty.TEXTURE.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_MOVABLE, linkedHashMap, HomePieceOfFurniture.SortableProperty.MOVABLE.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_DOOR_OR_WINDOW, linkedHashMap, HomePieceOfFurniture.SortableProperty.DOOR_OR_WINDOW.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_VISIBLE, linkedHashMap, HomePieceOfFurniture.SortableProperty.VISIBLE.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_PRICE, linkedHashMap, HomePieceOfFurniture.SortableProperty.PRICE.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_VALUE_ADDED_TAX_PERCENTAGE, linkedHashMap, HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX_PERCENTAGE.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_VALUE_ADDED_TAX, linkedHashMap, HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX.name());
        this.addActionToMap(HomeView.ActionType.DISPLAY_HOME_FURNITURE_PRICE_VALUE_ADDED_TAX_INCLUDED, linkedHashMap, HomePieceOfFurniture.SortableProperty.PRICE_VALUE_ADDED_TAX_INCLUDED.name());
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            final Object k = entry.getKey();
            final Action action = (Action)entry.getValue();
            final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
            jCheckBoxMenuItem.setModel(new JToggleButton.ToggleButtonModel(){

                @Override
                public boolean isSelected() {
                    return home.getFurnitureVisiblePropertyNames().contains(k);
                }
            });
            jCheckBoxMenuItem.setAction(action);
            if (action instanceof ResourceAction) {
                jCheckBoxMenuItem.setVisible(Boolean.TRUE.equals(action.getValue("Visible")));
                action.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("Visible".equals(propertyChangeEvent.getPropertyName())) {
                            Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                            jCheckBoxMenuItem.setVisible(bl);
                            if (!bl.booleanValue() && home.getFurnitureVisiblePropertyNames().contains(k)) {
                                action.actionPerformed(null);
                            }
                        }
                    }
                });
            }
            jMenu.add(jCheckBoxMenuItem);
        }
        this.updateDisplayPropertyMenu(jMenu, home);
        return jMenu;
    }

    private void updateDisplayPropertyMenu(JMenu jMenu, final Home home) {
        int n = -1;
        for (int i = jMenu.getMenuComponentCount() - 1; i > 0; --i) {
            String object;
            JComponent jComponent = (JComponent)jMenu.getMenuComponent(i);
            if (!(jComponent instanceof JMenuItem) || (object = (String)((JMenuItem)jComponent).getAction().getValue("ResourcePrefix")) == null || !object.startsWith("DISPLAY_HOME_FURNITURE_ADDITIONAL_PROPERTY_")) continue;
            jMenu.remove(jComponent);
            n = i;
        }
        List<ObjectProperty> list = home.getFurnitureAdditionalProperties();
        if (list.size() > 0) {
            if (n == -1) {
                jMenu.addSeparator();
            }
            for (final ObjectProperty objectProperty : list) {
                if (!objectProperty.isDisplayable()) continue;
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
                jCheckBoxMenuItem.setModel(new JToggleButton.ToggleButtonModel(){

                    @Override
                    public boolean isSelected() {
                        return home.getFurnitureVisiblePropertyNames().contains(objectProperty.getName());
                    }
                });
                jCheckBoxMenuItem.setAction(this.getActionMap().get("DISPLAY_HOME_FURNITURE_ADDITIONAL_PROPERTY_" + objectProperty.getName()));
                jMenu.add(jCheckBoxMenuItem);
            }
        } else {
            jMenu.remove(jMenu.getMenuComponentCount() - 1);
        }
    }

    private JMenuItem createLockUnlockBasePlanMenuItem(final Home home, final boolean bl) {
        ActionMap actionMap = this.getActionMap();
        Action action = actionMap.get((Object)HomeView.ActionType.UNLOCK_BASE_PLAN);
        Action action2 = actionMap.get((Object)HomeView.ActionType.LOCK_BASE_PLAN);
        if (action != null && action.getValue("Name") != null && action2.getValue("Name") != null) {
            final JMenuItem jMenuItem = new JMenuItem(this.createLockUnlockBasePlanAction(home, bl));
            home.addPropertyChangeListener(Home.Property.BASE_PLAN_LOCKED, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    jMenuItem.setAction(HomePane.this.createLockUnlockBasePlanAction(home, bl));
                }
            });
            return jMenuItem;
        }
        return null;
    }

    private Action createLockUnlockBasePlanAction(Home home, boolean bl) {
        HomeView.ActionType actionType = home.isBasePlanLocked() ? HomeView.ActionType.UNLOCK_BASE_PLAN : HomeView.ActionType.LOCK_BASE_PLAN;
        Action action = this.getActionMap().get((Object)actionType);
        return bl ? new ResourceAction.PopupMenuItemAction(action) : new ResourceAction.MenuItemAction(action);
    }

    private JComponent createLockUnlockBasePlanButton(final Home home) {
        ActionMap actionMap = this.getActionMap();
        final Action action = actionMap.get((Object)HomeView.ActionType.UNLOCK_BASE_PLAN);
        final Action action2 = actionMap.get((Object)HomeView.ActionType.LOCK_BASE_PLAN);
        if (action != null && action.getValue("Name") != null && action2.getValue("Name") != null) {
            final JButton jButton = new JButton(new ResourceAction.ToolBarAction(home.isBasePlanLocked() ? action : action2));
            jButton.setBorderPainted(false);
            jButton.setContentAreaFilled(false);
            jButton.setFocusable(false);
            home.addPropertyChangeListener(Home.Property.BASE_PLAN_LOCKED, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    jButton.setAction(new ResourceAction.ToolBarAction(home.isBasePlanLocked() ? action : action2));
                }
            });
            return jButton;
        }
        return null;
    }

    private JComponent createEnableDisableMagnetismButton(UserPreferences userPreferences) {
        ActionMap actionMap = this.getActionMap();
        Action action = actionMap.get((Object)HomeView.ActionType.DISABLE_MAGNETISM);
        Action action2 = actionMap.get((Object)HomeView.ActionType.ENABLE_MAGNETISM);
        if (action != null && action.getValue("Name") != null && action2.getValue("Name") != null) {
            JButton jButton = new JButton(new ResourceAction.ToolBarAction(userPreferences.isMagnetismEnabled() ? action : action2));
            userPreferences.addPropertyChangeListener(UserPreferences.Property.MAGNETISM_ENABLED, new MagnetismChangeListener(this, jButton));
            return jButton;
        }
        return null;
    }

    private JMenu createTextStyleMenu(Home home, UserPreferences userPreferences, boolean bl) {
        JMenu jMenu = new JMenu(new ResourceAction.MenuItemAction(this.menuActionMap.get((Object)MenuActionType.MODIFY_TEXT_STYLE)));
        this.addActionToMenu(HomeView.ActionType.INCREASE_TEXT_SIZE, bl, jMenu);
        this.addActionToMenu(HomeView.ActionType.DECREASE_TEXT_SIZE, bl, jMenu);
        jMenu.addSeparator();
        this.addToggleActionToMenu(HomeView.ActionType.TOGGLE_BOLD_STYLE, bl, false, jMenu);
        this.addToggleActionToMenu(HomeView.ActionType.TOGGLE_ITALIC_STYLE, bl, false, jMenu);
        return jMenu;
    }

    private JMenu createLevelsMenu(Home home, UserPreferences userPreferences) {
        JMenu jMenu = new JMenu(new ResourceAction.MenuItemAction(this.menuActionMap.get((Object)MenuActionType.LEVELS_MENU)));
        this.addActionToMenu(HomeView.ActionType.ADD_LEVEL, jMenu);
        this.addActionToMenu(HomeView.ActionType.ADD_LEVEL_AT_SAME_ELEVATION, jMenu);
        JMenuItem jMenuItem = this.createMakeLevelUnviewableViewableMenuItem(home, false);
        if (jMenuItem != null) {
            jMenu.add(jMenuItem);
        }
        this.addActionToMenu(HomeView.ActionType.MAKE_LEVEL_ONLY_VIEWABLE_ONE, jMenu);
        this.addActionToMenu(HomeView.ActionType.MAKE_ALL_LEVELS_VIEWABLE, jMenu);
        this.addActionToMenu(HomeView.ActionType.MODIFY_LEVEL, jMenu);
        this.addActionToMenu(HomeView.ActionType.DELETE_LEVEL, jMenu);
        return jMenu;
    }

    private JToggleButton.ToggleButtonModel createBoldStyleToggleModel(final Home home, final UserPreferences userPreferences) {
        return new JToggleButton.ToggleButtonModel(){
            {
                home.addSelectionListener(new SelectionListener(){

                    @Override
                    public void selectionChanged(SelectionEvent selectionEvent) {
                        this.fireStateChanged();
                    }
                });
            }

            @Override
            public boolean isSelected() {
                Boolean bl = null;
                for (Selectable selectable : home.getSelectedItems()) {
                    Boolean bl2;
                    if (selectable instanceof Label) {
                        bl2 = this.isItemTextBold(selectable, ((Label)selectable).getStyle());
                    } else if (selectable instanceof HomePieceOfFurniture && ((HomePieceOfFurniture)selectable).isVisible()) {
                        bl2 = this.isItemTextBold(selectable, ((HomePieceOfFurniture)selectable).getNameStyle());
                    } else if (selectable instanceof Room) {
                        Room room = (Room)selectable;
                        bl2 = this.isItemTextBold(room, room.getNameStyle());
                        if (bl2.booleanValue() != this.isItemTextBold(room, room.getAreaStyle())) {
                            bl2 = null;
                        }
                    } else {
                        if (!(selectable instanceof DimensionLine)) continue;
                        bl2 = this.isItemTextBold(selectable, ((DimensionLine)selectable).getLengthStyle());
                    }
                    if (bl == null) {
                        bl = bl2;
                        continue;
                    }
                    if (bl2 != null && bl.equals(bl2)) continue;
                    bl = null;
                    break;
                }
                return bl != null && bl != false;
            }

            private boolean isItemTextBold(Selectable selectable, TextStyle textStyle) {
                if (textStyle == null) {
                    textStyle = userPreferences.getDefaultTextStyle(selectable.getClass());
                }
                return textStyle.isBold();
            }
        };
    }

    private JToggleButton.ToggleButtonModel createItalicStyleToggleModel(final Home home, final UserPreferences userPreferences) {
        return new JToggleButton.ToggleButtonModel(){
            {
                home.addSelectionListener(new SelectionListener(){

                    @Override
                    public void selectionChanged(SelectionEvent selectionEvent) {
                        this.fireStateChanged();
                    }
                });
            }

            @Override
            public boolean isSelected() {
                Boolean bl = null;
                for (Selectable selectable : home.getSelectedItems()) {
                    Boolean bl2;
                    if (selectable instanceof Label) {
                        bl2 = this.isItemTextItalic(selectable, ((Label)selectable).getStyle());
                    } else if (selectable instanceof HomePieceOfFurniture && ((HomePieceOfFurniture)selectable).isVisible()) {
                        bl2 = this.isItemTextItalic(selectable, ((HomePieceOfFurniture)selectable).getNameStyle());
                    } else if (selectable instanceof Room) {
                        Room room = (Room)selectable;
                        bl2 = this.isItemTextItalic(room, room.getNameStyle());
                        if (bl2.booleanValue() != this.isItemTextItalic(room, room.getAreaStyle())) {
                            bl2 = null;
                        }
                    } else {
                        if (!(selectable instanceof DimensionLine)) continue;
                        bl2 = this.isItemTextItalic(selectable, ((DimensionLine)selectable).getLengthStyle());
                    }
                    if (bl == null) {
                        bl = bl2;
                        continue;
                    }
                    if (bl2 != null && bl.equals(bl2)) continue;
                    bl = null;
                    break;
                }
                return bl != null && bl != false;
            }

            private boolean isItemTextItalic(Selectable selectable, TextStyle textStyle) {
                if (textStyle == null) {
                    textStyle = userPreferences.getDefaultTextStyle(selectable.getClass());
                }
                return textStyle.isItalic();
            }
        };
    }

    private JMenuItem createImportModifyBackgroundImageMenuItem(final Home home, final boolean bl) {
        ActionMap actionMap = this.getActionMap();
        Action action = actionMap.get((Object)HomeView.ActionType.IMPORT_BACKGROUND_IMAGE);
        Action action2 = actionMap.get((Object)HomeView.ActionType.MODIFY_BACKGROUND_IMAGE);
        if (action != null && action.getValue("Name") != null && action2.getValue("Name") != null) {
            final JMenuItem jMenuItem = new JMenuItem(this.createImportModifyBackgroundImageAction(home, bl));
            this.addBackgroundImageChangeListener(home, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    jMenuItem.setAction(HomePane.this.createImportModifyBackgroundImageAction(home, bl));
                }
            });
            return jMenuItem;
        }
        return null;
    }

    private void addBackgroundImageChangeListener(Home home, final PropertyChangeListener propertyChangeListener) {
        home.addPropertyChangeListener(Home.Property.BACKGROUND_IMAGE, propertyChangeListener);
        home.addPropertyChangeListener(Home.Property.SELECTED_LEVEL, propertyChangeListener);
        final PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (Level.Property.BACKGROUND_IMAGE.name().equals(propertyChangeEvent.getPropertyName())) {
                    propertyChangeListener.propertyChange(propertyChangeEvent);
                }
            }
        };
        for (Level level : this.home.getLevels()) {
            level.addPropertyChangeListener(propertyChangeListener2);
        }
        this.home.addLevelsListener(new CollectionListener<Level>(){

            @Override
            public void collectionChanged(CollectionEvent<Level> collectionEvent) {
                switch (collectionEvent.getType()) {
                    case ADD: {
                        collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener2);
                        break;
                    }
                    case DELETE: {
                        collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener2);
                    }
                }
            }
        });
    }

    private Action createImportModifyBackgroundImageAction(Home home, boolean bl) {
        BackgroundImage backgroundImage = home.getSelectedLevel() != null ? home.getSelectedLevel().getBackgroundImage() : home.getBackgroundImage();
        HomeView.ActionType actionType = backgroundImage == null ? HomeView.ActionType.IMPORT_BACKGROUND_IMAGE : HomeView.ActionType.MODIFY_BACKGROUND_IMAGE;
        Action action = this.getActionMap().get((Object)actionType);
        return bl ? new ResourceAction.PopupMenuItemAction(action) : new ResourceAction.MenuItemAction(action);
    }

    private JMenuItem createHideShowBackgroundImageMenuItem(final Home home, final boolean bl) {
        ActionMap actionMap = this.getActionMap();
        Action action = actionMap.get((Object)HomeView.ActionType.HIDE_BACKGROUND_IMAGE);
        Action action2 = actionMap.get((Object)HomeView.ActionType.SHOW_BACKGROUND_IMAGE);
        if (action != null && action.getValue("Name") != null && action2.getValue("Name") != null) {
            final JMenuItem jMenuItem = new JMenuItem(this.createHideShowBackgroundImageAction(home, bl));
            this.addBackgroundImageChangeListener(home, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    jMenuItem.setAction(HomePane.this.createHideShowBackgroundImageAction(home, bl));
                }
            });
            return jMenuItem;
        }
        return null;
    }

    private Action createHideShowBackgroundImageAction(Home home, boolean bl) {
        BackgroundImage backgroundImage = home.getSelectedLevel() != null ? home.getSelectedLevel().getBackgroundImage() : home.getBackgroundImage();
        HomeView.ActionType actionType = backgroundImage == null || backgroundImage.isVisible() ? HomeView.ActionType.HIDE_BACKGROUND_IMAGE : HomeView.ActionType.SHOW_BACKGROUND_IMAGE;
        Action action = this.getActionMap().get((Object)actionType);
        return bl ? new ResourceAction.PopupMenuItemAction(action) : new ResourceAction.MenuItemAction(action);
    }

    private JMenuItem createMakeLevelUnviewableViewableMenuItem(final Home home, final boolean bl) {
        ActionMap actionMap = this.getActionMap();
        Action action = actionMap.get((Object)HomeView.ActionType.MAKE_LEVEL_UNVIEWABLE);
        Action action2 = actionMap.get((Object)HomeView.ActionType.MAKE_LEVEL_VIEWABLE);
        if (action != null && action.getValue("Name") != null && action2.getValue("Name") != null) {
            final JMenuItem jMenuItem = new JMenuItem(this.createMakeLevelUnviewableViewableAction(home, bl));
            final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    jMenuItem.setAction(HomePane.this.createMakeLevelUnviewableViewableAction(home, bl));
                }
            };
            Level level = home.getSelectedLevel();
            if (level != null) {
                level.addPropertyChangeListener(propertyChangeListener);
            }
            home.addPropertyChangeListener(Home.Property.SELECTED_LEVEL, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    jMenuItem.setAction(HomePane.this.createMakeLevelUnviewableViewableAction(home, bl));
                    if (propertyChangeEvent.getOldValue() != null) {
                        ((Level)propertyChangeEvent.getOldValue()).removePropertyChangeListener(propertyChangeListener);
                    }
                    if (propertyChangeEvent.getNewValue() != null) {
                        ((Level)propertyChangeEvent.getNewValue()).addPropertyChangeListener(propertyChangeListener);
                    }
                }
            });
            return jMenuItem;
        }
        return null;
    }

    private Action createMakeLevelUnviewableViewableAction(Home home, boolean bl) {
        Level level = home.getSelectedLevel();
        HomeView.ActionType actionType = level == null || level.isViewable() ? HomeView.ActionType.MAKE_LEVEL_UNVIEWABLE : HomeView.ActionType.MAKE_LEVEL_VIEWABLE;
        Action action = this.getActionMap().get((Object)actionType);
        return bl ? new ResourceAction.PopupMenuItemAction(action) : new ResourceAction.MenuItemAction(action);
    }

    private JMenu createGoToPointOfViewMenu(final Home home, UserPreferences userPreferences, final HomeController homeController) {
        Action action = this.menuActionMap.get((Object)MenuActionType.GO_TO_POINT_OF_VIEW);
        if (action.getValue("Name") != null) {
            final JMenu jMenu = new JMenu(new ResourceAction.MenuItemAction(action));
            this.updateGoToPointOfViewMenu(jMenu, home, homeController);
            home.addPropertyChangeListener(Home.Property.STORED_CAMERAS, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomePane.this.updateGoToPointOfViewMenu(jMenu, home, homeController);
                }
            });
            return jMenu;
        }
        return null;
    }

    private void updateGoToPointOfViewMenu(JMenu jMenu, Home home, final HomeController homeController) {
        List<Camera> list = home.getStoredCameras();
        jMenu.removeAll();
        if (list.isEmpty()) {
            jMenu.setEnabled(false);
            jMenu.add(new ResourceAction(this.preferences, HomePane.class, "NoStoredPointOfView", false));
        } else {
            jMenu.setEnabled(true);
            for (final Camera camera : list) {
                jMenu.add(new AbstractAction(camera.getName()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        homeController.getHomeController3D().goToCamera(camera);
                    }
                });
            }
        }
    }

    private JMenuItem createAttachDetach3DViewMenuItem(final HomeController homeController, final boolean bl) {
        ActionMap actionMap = this.getActionMap();
        Action action = actionMap.get((Object)HomeView.ActionType.DETACH_3D_VIEW);
        Action action2 = actionMap.get((Object)HomeView.ActionType.ATTACH_3D_VIEW);
        if (action != null && action.getValue("Name") != null && action2.getValue("Name") != null) {
            final JMenuItem jMenuItem = new JMenuItem(this.createAttachDetach3DViewAction(homeController, bl));
            JComponent jComponent = (JComponent)((Object)homeController.getHomeController3D().getView());
            jComponent.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent ancestorEvent) {
                    jMenuItem.setAction(HomePane.this.createAttachDetach3DViewAction(homeController, bl));
                }

                @Override
                public void ancestorRemoved(AncestorEvent ancestorEvent) {
                }

                @Override
                public void ancestorMoved(AncestorEvent ancestorEvent) {
                }
            });
            return jMenuItem;
        }
        return null;
    }

    private Action createAttachDetach3DViewAction(HomeController homeController, boolean bl) {
        JRootPane jRootPane = SwingUtilities.getRootPane((JComponent)((Object)homeController.getHomeController3D().getView()));
        HomeView.ActionType actionType = jRootPane == this ? HomeView.ActionType.DETACH_3D_VIEW : HomeView.ActionType.ATTACH_3D_VIEW;
        Action action = this.getActionMap().get((Object)actionType);
        return bl ? new ResourceAction.PopupMenuItemAction(action) : new ResourceAction.MenuItemAction(action);
    }

    protected void updateOpenRecentHomeMenu(JMenu jMenu, final HomeController homeController) {
        jMenu.removeAll();
        for (final String string : homeController.getRecentHomes()) {
            jMenu.add(new AbstractAction(homeController.getContentManager().getPresentationName(string, ContentManager.ContentType.SWEET_HOME_3D)){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    homeController.open(string);
                }
            });
        }
        if (jMenu.getMenuComponentCount() > 0) {
            jMenu.addSeparator();
        }
        this.addActionToMenu(HomeView.ActionType.DELETE_RECENT_HOMES, jMenu);
    }

    private JToolBar createToolBar(Home home, UserPreferences userPreferences) {
        JComponent jComponent;
        UnfocusableToolBar unfocusableToolBar = new UnfocusableToolBar();
        this.addActionToToolBar(HomeView.ActionType.NEW_HOME, (JToolBar)unfocusableToolBar);
        this.addActionToToolBar(HomeView.ActionType.OPEN, (JToolBar)unfocusableToolBar);
        this.addActionToToolBar(HomeView.ActionType.SAVE, (JToolBar)unfocusableToolBar);
        if (!OperatingSystem.isMacOSX()) {
            this.addActionToToolBar(HomeView.ActionType.PREFERENCES, (JToolBar)unfocusableToolBar);
        }
        unfocusableToolBar.addSeparator();
        int n = unfocusableToolBar.getComponentCount();
        this.addActionToToolBar(HomeView.ActionType.UNDO, (JToolBar)unfocusableToolBar);
        this.addActionToToolBar(HomeView.ActionType.REDO, (JToolBar)unfocusableToolBar);
        if (n != unfocusableToolBar.getComponentCount()) {
            unfocusableToolBar.add(Box.createRigidArea(new Dimension(2, 2)));
        }
        this.addActionToToolBar(HomeView.ActionType.CUT, (JToolBar)unfocusableToolBar);
        this.addActionToToolBar(HomeView.ActionType.COPY, (JToolBar)unfocusableToolBar);
        this.addActionToToolBar(HomeView.ActionType.PASTE, (JToolBar)unfocusableToolBar);
        unfocusableToolBar.addSeparator();
        this.addActionToToolBar(HomeView.ActionType.ADD_HOME_FURNITURE, (JToolBar)unfocusableToolBar);
        unfocusableToolBar.addSeparator();
        n = unfocusableToolBar.getComponentCount();
        this.addToggleActionToToolBar(HomeView.ActionType.SELECT, unfocusableToolBar);
        this.addToggleActionToToolBar(HomeView.ActionType.PAN, unfocusableToolBar);
        this.addToggleActionToToolBar(HomeView.ActionType.CREATE_WALLS, unfocusableToolBar);
        this.addToggleActionToToolBar(HomeView.ActionType.CREATE_ROOMS, unfocusableToolBar);
        this.addToggleActionToToolBar(HomeView.ActionType.CREATE_POLYLINES, unfocusableToolBar);
        this.addToggleActionToToolBar(HomeView.ActionType.CREATE_DIMENSION_LINES, unfocusableToolBar);
        this.addToggleActionToToolBar(HomeView.ActionType.CREATE_LABELS, unfocusableToolBar);
        if (n != unfocusableToolBar.getComponentCount()) {
            unfocusableToolBar.add(Box.createRigidArea(new Dimension(2, 2)));
            n = unfocusableToolBar.getComponentCount();
        }
        this.addActionToToolBar(HomeView.ActionType.INCREASE_TEXT_SIZE, (JToolBar)unfocusableToolBar);
        this.addActionToToolBar(HomeView.ActionType.DECREASE_TEXT_SIZE, (JToolBar)unfocusableToolBar);
        this.addToggleActionToToolBar(HomeView.ActionType.TOGGLE_BOLD_STYLE, unfocusableToolBar);
        this.addToggleActionToToolBar(HomeView.ActionType.TOGGLE_ITALIC_STYLE, unfocusableToolBar);
        if (n != unfocusableToolBar.getComponentCount()) {
            unfocusableToolBar.add(Box.createRigidArea(new Dimension(2, 2)));
        }
        this.addActionToToolBar(HomeView.ActionType.ZOOM_IN, (JToolBar)unfocusableToolBar);
        this.addActionToToolBar(HomeView.ActionType.ZOOM_OUT, (JToolBar)unfocusableToolBar);
        if (!(OperatingSystem.isMacOSX() && this.getToolkit().getScreenSize().width < 1024 || (jComponent = this.createEnableDisableMagnetismButton(userPreferences)) == null)) {
            unfocusableToolBar.add(Box.createRigidArea(new Dimension(2, 2)));
            unfocusableToolBar.add(jComponent);
        }
        unfocusableToolBar.addSeparator();
        this.addActionToToolBar(HomeView.ActionType.CREATE_PHOTO, (JToolBar)unfocusableToolBar);
        this.addActionToToolBar(HomeView.ActionType.CREATE_VIDEO, (JToolBar)unfocusableToolBar);
        unfocusableToolBar.addSeparator();
        boolean bl = false;
        for (Action object : this.pluginActions) {
            if (!Boolean.TRUE.equals(object.getValue(PluginAction.Property.TOOL_BAR.name()))) continue;
            this.addActionToToolBar(new ResourceAction.ToolBarAction(object), (JToolBar)unfocusableToolBar);
            bl = true;
        }
        if (bl) {
            unfocusableToolBar.addSeparator();
        }
        this.addActionToToolBar(HomeView.ActionType.HELP, (JToolBar)unfocusableToolBar);
        for (int i = unfocusableToolBar.getComponentCount() - 1; i > 0; --i) {
            Component component = unfocusableToolBar.getComponent(i);
            if (!(component instanceof JSeparator) || i != unfocusableToolBar.getComponentCount() - 1 && (i <= 0 || !(unfocusableToolBar.getComponent(i - 1) instanceof JSeparator))) continue;
            unfocusableToolBar.remove(i);
        }
        if (OperatingSystem.isMacOSXLeopardOrSuperior() && OperatingSystem.isJavaVersionBetween("1.7", "1.7.0_40")) {
            unfocusableToolBar.setPreferredSize(new Dimension(0, unfocusableToolBar.getPreferredSize().height - 4));
        }
        return unfocusableToolBar;
    }

    private void addToggleActionToToolBar(HomeView.ActionType actionType, JToolBar jToolBar) {
        Action action = this.getActionMap().get((Object)actionType);
        if (action != null && action.getValue("Name") != null) {
            ResourceAction.ToolBarAction toolBarAction = new ResourceAction.ToolBarAction(action);
            JToggleButton jToggleButton = OperatingSystem.isMacOSXLeopardOrSuperior() && OperatingSystem.isJavaVersionBetween("1.7", "1.7.0_40") ? new JToggleButton(toolBarAction){

                @Override
                public Insets getInsets() {
                    Insets insets = super.getInsets();
                    insets.top += 3;
                    insets.bottom += 3;
                    return insets;
                }
            } : new JToggleButton(toolBarAction);
            jToggleButton.setModel((JToggleButton.ToggleButtonModel)action.getValue("ToggleButtonModel"));
            jToolBar.add(jToggleButton);
        }
    }

    private void addActionToToolBar(HomeView.ActionType actionType, JToolBar jToolBar) {
        Action action = this.getActionMap().get((Object)actionType);
        if (action != null && action.getValue("Name") != null) {
            this.addActionToToolBar(new ResourceAction.ToolBarAction(action), jToolBar);
        }
    }

    private void addActionToToolBar(Action action, JToolBar jToolBar) {
        if (OperatingSystem.isMacOSXLeopardOrSuperior() && OperatingSystem.isJavaVersionBetween("1.7", "1.7.0_40")) {
            jToolBar.add(new JButton(new ResourceAction.ToolBarAction(action)){

                @Override
                public Insets getInsets() {
                    Insets insets = super.getInsets();
                    insets.top += 3;
                    insets.bottom += 3;
                    return insets;
                }
            });
        } else {
            jToolBar.add(new JButton(new ResourceAction.ToolBarAction(action)));
        }
    }

    @Override
    public void setEnabled(HomeView.ActionType actionType, boolean bl) {
        Action action = this.getActionMap().get((Object)actionType);
        if (action != null) {
            action.setEnabled(bl);
        }
    }

    @Override
    public void setActionEnabled(String string, boolean bl) {
        Action action = this.getActionMap().get(string);
        if (action != null) {
            action.setEnabled(bl);
        }
    }

    @Override
    public void setUndoRedoName(String string, String string2) {
        this.setNameAndShortDescription(HomeView.ActionType.UNDO, string);
        this.setNameAndShortDescription(HomeView.ActionType.REDO, string2);
    }

    private void setNameAndShortDescription(HomeView.ActionType actionType, String string) {
        Action action = this.getActionMap().get((Object)actionType);
        if (action != null) {
            if (string == null) {
                string = (String)action.getValue("Default");
            }
            action.putValue("Name", string);
            action.putValue("ShortDescription", string);
        }
    }

    @Override
    public void setTransferEnabled(boolean bl) {
        boolean bl2;
        try {
            bl2 = !Boolean.getBoolean("com.eteks.sweethome3d.dragAndDropWithoutTransferHandler");
        }
        catch (AccessControlException accessControlException) {
            bl2 = false;
        }
        JComponent jComponent = (JComponent)((Object)this.controller.getFurnitureCatalogController().getView());
        JComponent jComponent2 = (JComponent)((Object)this.controller.getFurnitureController().getView());
        JComponent jComponent3 = (JComponent)((Object)this.controller.getPlanController().getView());
        JComponent jComponent4 = (JComponent)((Object)this.controller.getHomeController3D().getView());
        if (bl) {
            if (jComponent != null) {
                jComponent.setTransferHandler(this.catalogTransferHandler);
            }
            if (jComponent2 != null) {
                jComponent2.setTransferHandler(this.furnitureTransferHandler);
                if (jComponent2 instanceof Scrollable) {
                    ((JViewport)jComponent2.getParent()).setTransferHandler(this.furnitureTransferHandler);
                }
            }
            if (jComponent3 != null) {
                jComponent3.setTransferHandler(this.planTransferHandler);
            }
            if (jComponent4 != null && this.preferences.isEditingIn3DViewEnabled()) {
                jComponent4.setTransferHandler(this.view3DTransferHandler);
            }
            if (!bl2 && jComponent != null) {
                List<JViewport> list = SwingTools.findChildren(jComponent, JViewport.class);
                JComponent jComponent5 = list.size() > 0 ? (JComponent)list.get(0).getView() : jComponent;
                if (this.furnitureCatalogDragAndDropListener == null) {
                    this.furnitureCatalogDragAndDropListener = this.createFurnitureCatalogMouseListener();
                }
                jComponent5.addMouseListener(this.furnitureCatalogDragAndDropListener);
                jComponent5.addMouseMotionListener(this.furnitureCatalogDragAndDropListener);
            }
        } else {
            if (jComponent != null) {
                jComponent.setTransferHandler(null);
            }
            if (jComponent2 != null) {
                jComponent2.setTransferHandler(null);
                if (jComponent2 instanceof Scrollable) {
                    ((JViewport)jComponent2.getParent()).setTransferHandler(null);
                }
            }
            if (jComponent3 != null) {
                jComponent3.setTransferHandler(null);
            }
            if (jComponent4 != null) {
                jComponent4.setTransferHandler(null);
            }
            if (!bl2 && jComponent != null) {
                List<JViewport> list = SwingTools.findChildren(jComponent, JViewport.class);
                JComponent jComponent6 = list.size() > 0 ? (JComponent)list.get(0).getView() : jComponent;
                jComponent6.removeMouseListener(this.furnitureCatalogDragAndDropListener);
                jComponent6.removeMouseMotionListener(this.furnitureCatalogDragAndDropListener);
            }
        }
        this.transferHandlerEnabled = bl;
    }

    private MouseInputAdapter createFurnitureCatalogMouseListener() {
        return new MouseInputAdapter(){
            private CatalogPieceOfFurniture selectedPiece;
            private TransferHandler transferHandler;
            private boolean autoscrolls;
            private Cursor previousCursor;
            private View previousView;
            private boolean escaped;
            {
                HomePane.this.getActionMap().put("EscapeDragFromFurnitureCatalog", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (!escaped) {
                            if (previousView != null) {
                                if (previousView == HomePane.this.controller.getPlanController().getView()) {
                                    HomePane.this.controller.getPlanController().stopDraggedItems();
                                }
                                if (previousCursor != null) {
                                    JComponent jComponent = (JComponent)((Object)previousView);
                                    jComponent.setCursor(previousCursor);
                                    if (jComponent.getParent() instanceof JViewport) {
                                        jComponent.getParent().setCursor(previousCursor);
                                    }
                                }
                            }
                            escaped = true;
                        }
                    }
                });
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                List<CatalogPieceOfFurniture> list;
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && (list = HomePane.this.controller.getFurnitureCatalogController().getSelectedFurniture()).size() > 0) {
                    JComponent jComponent = (JComponent)mouseEvent.getSource();
                    this.transferHandler = jComponent.getTransferHandler();
                    jComponent.setTransferHandler(null);
                    this.autoscrolls = jComponent.getAutoscrolls();
                    jComponent.setAutoscrolls(false);
                    this.selectedPiece = list.get(0);
                    this.previousCursor = null;
                    this.previousView = null;
                    this.escaped = false;
                    InputMap inputMap = HomePane.this.getInputMap(2);
                    inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "EscapeDragFromFurnitureCatalog");
                    HomePane.this.setInputMap(2, inputMap);
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.selectedPiece != null) {
                    List<CatalogPieceOfFurniture> list = Collections.emptyList();
                    HomePane.this.controller.getFurnitureCatalogController().setSelectedFurniture(list);
                    HomePane.this.controller.getFurnitureCatalogController().setSelectedFurniture(Arrays.asList(this.selectedPiece));
                    Level level = HomePane.this.home.getSelectedLevel();
                    if (level == null || level.isViewable()) {
                        View view;
                        List<Selectable> list2 = Arrays.asList(HomePane.this.controller.getFurnitureController().createHomePieceOfFurniture(this.selectedPiece));
                        float[] fArray = this.getPointInPlanView(mouseEvent, list2);
                        if (fArray != null) {
                            view = HomePane.this.controller.getPlanController().getView();
                        } else {
                            view = HomePane.this.controller.getFurnitureController().getView();
                            fArray = this.getPointInFurnitureView(mouseEvent);
                        }
                        if (this.previousView != view) {
                            JComponent jComponent;
                            if (this.previousView != null) {
                                if (this.previousView == HomePane.this.controller.getPlanController().getView() && !this.escaped) {
                                    HomePane.this.controller.getPlanController().stopDraggedItems();
                                }
                                jComponent = (JComponent)((Object)this.previousView);
                                jComponent.setCursor(this.previousCursor);
                                if (jComponent.getParent() instanceof JViewport) {
                                    jComponent.setCursor(this.previousCursor);
                                }
                                this.previousCursor = null;
                                this.previousView = null;
                            }
                            if (view != null) {
                                jComponent = (JComponent)((Object)view);
                                this.previousCursor = jComponent.getCursor();
                                this.previousView = view;
                                if (!this.escaped) {
                                    jComponent.setCursor(DragSource.DefaultCopyDrop);
                                    if (jComponent.getParent() instanceof JViewport) {
                                        ((JViewport)jComponent.getParent()).setCursor(DragSource.DefaultCopyDrop);
                                    }
                                    if (view == HomePane.this.controller.getPlanController().getView()) {
                                        HomePane.this.controller.getPlanController().startDraggedItems(list2, fArray[0], fArray[1]);
                                    }
                                }
                            }
                        } else if (fArray != null) {
                            HomePane.this.controller.getPlanController().moveMouse(fArray[0], fArray[1]);
                        }
                    }
                }
            }

            private float[] getPointInPlanView(MouseEvent mouseEvent, List<Selectable> list) {
                PlanView planView = HomePane.this.controller.getPlanController().getView();
                if (planView != null) {
                    JComponent jComponent = (JComponent)((Object)planView);
                    Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), jComponent);
                    if (jComponent.getParent() instanceof JViewport && ((JViewport)jComponent.getParent()).contains(SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), jComponent.getParent())) || !(jComponent.getParent() instanceof JViewport) && planView.canImportDraggedItems(list, point.x, point.y)) {
                        return new float[]{planView.convertXPixelToModel(point.x), planView.convertYPixelToModel(point.y)};
                    }
                }
                return null;
            }

            private float[] getPointInFurnitureView(MouseEvent mouseEvent) {
                View view = HomePane.this.controller.getFurnitureController().getView();
                if (view != null) {
                    JComponent jComponent = (JComponent)((Object)view);
                    Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), jComponent.getParent() instanceof JViewport ? jComponent.getParent() : jComponent);
                    if (jComponent.getParent() instanceof JViewport && ((JViewport)jComponent.getParent()).contains(point) || !(jComponent.getParent() instanceof JViewport) && jComponent.contains(point)) {
                        return new float[]{0.0f, 0.0f};
                    }
                }
                return null;
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.selectedPiece != null) {
                    List<Selectable> list;
                    Serializable serializable;
                    if (!this.escaped && ((serializable = HomePane.this.home.getSelectedLevel()) == null || ((Level)serializable).isViewable())) {
                        View view;
                        list = Arrays.asList(HomePane.this.controller.getFurnitureController().createHomePieceOfFurniture(this.selectedPiece));
                        float[] fArray = this.getPointInPlanView(mouseEvent, list);
                        if (fArray != null) {
                            HomePane.this.controller.getPlanController().stopDraggedItems();
                            view = HomePane.this.controller.getPlanController().getView();
                        } else {
                            view = HomePane.this.controller.getFurnitureController().getView();
                            fArray = this.getPointInFurnitureView(mouseEvent);
                        }
                        if (fArray != null) {
                            HomePane.this.controller.drop((List<? extends Selectable>)list, view, fArray[0], fArray[1]);
                            JComponent jComponent = (JComponent)((Object)this.previousView);
                            jComponent.setCursor(this.previousCursor);
                            if (jComponent.getParent() instanceof JViewport) {
                                jComponent.getParent().setCursor(this.previousCursor);
                            }
                        }
                        this.selectedPiece = null;
                    }
                    serializable = (JComponent)mouseEvent.getSource();
                    ((JComponent)serializable).setTransferHandler(this.transferHandler);
                    ((JComponent)serializable).setAutoscrolls(this.autoscrolls);
                    list = HomePane.this.getInputMap(2);
                    ((InputMap)((Object)list)).remove(KeyStroke.getKeyStroke("ESCAPE"));
                    HomePane.this.setInputMap(2, (InputMap)((Object)list));
                }
            }
        };
    }

    private JComponent createMainPane(Home home, UserPreferences userPreferences, HomeController homeController) {
        final JComponent jComponent = this.createCatalogFurniturePane(home, userPreferences, homeController);
        final JComponent jComponent2 = this.createPlanView3DPane(home, userPreferences, homeController);
        if (jComponent == null) {
            return jComponent2;
        }
        if (jComponent2 == null) {
            return jComponent;
        }
        boolean bl = ComponentOrientation.getOrientation(Locale.getDefault()).isLeftToRight();
        final JSplitPane jSplitPane = new JSplitPane(1, bl ? jComponent : jComponent2, bl ? jComponent2 : jComponent);
        jSplitPane.setDividerLocation((int)((float)(bl ? 360 : 670) * SwingTools.getResolutionScale()));
        this.configureSplitPane(jSplitPane, home, MAIN_PANE_DIVIDER_LOCATION_VISUAL_PROPERTY, bl ? 0.3 : 0.7, true, homeController);
        jSplitPane.addPropertyChangeListener("componentOrientation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (jSplitPane.getComponentOrientation().isLeftToRight()) {
                    jSplitPane.setRightComponent(null);
                    jSplitPane.setLeftComponent(jComponent);
                    jSplitPane.setRightComponent(jComponent2);
                } else {
                    jSplitPane.setRightComponent(null);
                    jSplitPane.setLeftComponent(jComponent2);
                    jSplitPane.setRightComponent(jComponent);
                }
                if (jSplitPane.isShowing()) {
                    jSplitPane.setDividerLocation(jSplitPane.getWidth() - jSplitPane.getDividerLocation());
                }
            }
        });
        return jSplitPane;
    }

    private void configureSplitPane(final JSplitPane jSplitPane, Home home, final String string, final double d, boolean bl, final HomeController homeController) {
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(d);
        if (!bl) {
            jSplitPane.setBorder(null);
        }
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (jSplitPane.getDividerLocation() <= 0) {
                    jSplitPane.setResizeWeight(0.0);
                } else if (jSplitPane.getDividerLocation() + jSplitPane.getDividerSize() >= (jSplitPane.getOrientation() == 1 ? jSplitPane.getWidth() - jSplitPane.getInsets().left : jSplitPane.getHeight() - jSplitPane.getInsets().top)) {
                    jSplitPane.setResizeWeight(1.0);
                } else {
                    jSplitPane.setResizeWeight(d);
                }
            }
        };
        jSplitPane.addPropertyChangeListener("dividerLocation", propertyChangeListener);
        Number number = home.getNumericProperty(string);
        if (number != null) {
            jSplitPane.setDividerLocation(number.intValue());
            jSplitPane.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent ancestorEvent) {
                    propertyChangeListener.propertyChange(null);
                    jSplitPane.removeAncestorListener(this);
                }

                @Override
                public void ancestorRemoved(AncestorEvent ancestorEvent) {
                }

                @Override
                public void ancestorMoved(AncestorEvent ancestorEvent) {
                }
            });
        }
        jSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                        if (component != null && HomePane.this.isChildComponentInvisible(jSplitPane, component)) {
                            FocusTraversalPolicy focusTraversalPolicy = HomePane.this.getFocusTraversalPolicy();
                            Component component2 = focusTraversalPolicy.getComponentAfter(HomePane.this, component);
                            if (component2 == null) {
                                component2 = focusTraversalPolicy.getComponentBefore(HomePane.this, component);
                            }
                            if (component2 != null) {
                                component2.requestFocusInWindow();
                            }
                        }
                        homeController.setHomeProperty(string, String.valueOf(propertyChangeEvent.getNewValue()));
                    }
                });
            }
        });
    }

    private JComponent createCatalogFurniturePane(Home home, UserPreferences userPreferences, final HomeController homeController) {
        JComponent jComponent;
        JComponent jComponent2;
        JComponent jComponent3 = (JComponent)((Object)homeController.getFurnitureCatalogController().getView());
        if (jComponent3 != null) {
            jComponent2 = new JPopupMenu();
            this.addActionToPopupMenu(HomeView.ActionType.COPY, (JPopupMenu)jComponent2);
            ((JPopupMenu)jComponent2).addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.DELETE, (JPopupMenu)jComponent2);
            ((JPopupMenu)jComponent2).addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.ADD_HOME_FURNITURE, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.ADD_FURNITURE_TO_GROUP, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.MODIFY_FURNITURE, (JPopupMenu)jComponent2);
            ((JPopupMenu)jComponent2).addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.IMPORT_FURNITURE, (JPopupMenu)jComponent2);
            SwingTools.hideDisabledMenuItems((JPopupMenu)jComponent2);
            jComponent3.setComponentPopupMenu((JPopupMenu)jComponent2);
            userPreferences.addPropertyChangeListener(UserPreferences.Property.FURNITURE_CATALOG_VIEWED_IN_TREE, new FurnitureCatalogViewChangeListener(this, jComponent3));
            if (jComponent3 instanceof Scrollable) {
                jComponent3 = SwingTools.createScrollPane(jComponent3);
            }
        }
        if ((jComponent2 = (JComponent)((Object)homeController.getFurnitureController().getView())) != null) {
            jComponent = new JPopupMenu();
            this.addActionToPopupMenu(HomeView.ActionType.UNDO, (JPopupMenu)jComponent);
            this.addActionToPopupMenu(HomeView.ActionType.REDO, (JPopupMenu)jComponent);
            ((JPopupMenu)jComponent).addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.CUT, (JPopupMenu)jComponent);
            this.addActionToPopupMenu(HomeView.ActionType.COPY, (JPopupMenu)jComponent);
            this.addActionToPopupMenu(HomeView.ActionType.PASTE, (JPopupMenu)jComponent);
            this.addActionToPopupMenu(HomeView.ActionType.PASTE_TO_GROUP, (JPopupMenu)jComponent);
            this.addActionToPopupMenu(HomeView.ActionType.PASTE_STYLE, (JPopupMenu)jComponent);
            ((JPopupMenu)jComponent).addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.DELETE, (JPopupMenu)jComponent);
            this.addActionToPopupMenu(HomeView.ActionType.SELECT_ALL, (JPopupMenu)jComponent);
            ((JPopupMenu)jComponent).addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.MODIFY_FURNITURE, (JPopupMenu)jComponent);
            this.addActionToPopupMenu(HomeView.ActionType.GROUP_FURNITURE, (JPopupMenu)jComponent);
            this.addActionToPopupMenu(HomeView.ActionType.UNGROUP_FURNITURE, (JPopupMenu)jComponent);
            ((JPopupMenu)jComponent).add(this.createAlignOrDistributeMenu(home, userPreferences, true));
            this.addActionToPopupMenu(HomeView.ActionType.RESET_FURNITURE_ELEVATION, (JPopupMenu)jComponent);
            ((JPopupMenu)jComponent).addSeparator();
            ((JPopupMenu)jComponent).add(this.createFurnitureSortMenu(home, userPreferences));
            ((JPopupMenu)jComponent).add(this.createFurnitureDisplayPropertyMenu(home, userPreferences));
            ((JPopupMenu)jComponent).addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.EXPORT_TO_CSV, (JPopupMenu)jComponent);
            SwingTools.hideDisabledMenuItems((JPopupMenu)jComponent);
            jComponent2.setComponentPopupMenu((JPopupMenu)jComponent);
            if (jComponent2 instanceof Scrollable) {
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                jComponent2.setFocusTraversalKeys(0, keyboardFocusManager.getDefaultFocusTraversalKeys(0));
                jComponent2.setFocusTraversalKeys(1, keyboardFocusManager.getDefaultFocusTraversalKeys(1));
                JScrollPane jScrollPane = SwingTools.createScrollPane(jComponent2);
                final JViewport jViewport = jScrollPane.getViewport();
                jViewport.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        jViewport.getView().requestFocusInWindow();
                    }
                });
                Number number = home.getNumericProperty(FURNITURE_VIEWPORT_Y_VISUAL_PROPERTY);
                if (number != null) {
                    jViewport.setViewPosition(new Point(0, number.intValue()));
                }
                jViewport.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        homeController.setHomeProperty(HomePane.FURNITURE_VIEWPORT_Y_VISUAL_PROPERTY, String.valueOf(jViewport.getViewPosition().y));
                    }
                });
                ((JViewport)jComponent2.getParent()).setComponentPopupMenu((JPopupMenu)jComponent);
                if (OperatingSystem.isMacOSXHighSierraOrSuperior() && !OperatingSystem.isJavaVersionGreaterOrEqual("1.7")) {
                    jScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                        @Override
                        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                            jViewport.repaint();
                        }
                    });
                }
                jComponent2 = jScrollPane;
            }
        }
        if (jComponent3 == null) {
            return jComponent2;
        }
        if (jComponent2 == null) {
            return jComponent3;
        }
        jComponent = new JSplitPane(0, jComponent3, jComponent2);
        jComponent.setBorder(null);
        jComponent.setMinimumSize(new Dimension());
        this.configureSplitPane((JSplitPane)jComponent, home, CATALOG_PANE_DIVIDER_LOCATION_VISUAL_PROPERTY, 0.5, false, homeController);
        return jComponent;
    }

    private JComponent createPlanView3DPane(Home home, UserPreferences userPreferences, final HomeController homeController) {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        Serializable serializable4;
        JComponent jComponent;
        Object object;
        Object object2;
        JMenuItem jMenuItem;
        Object object3;
        JComponent jComponent2;
        JComponent jComponent3 = (JComponent)((Object)homeController.getPlanController().getView());
        if (jComponent3 != null) {
            List<JScrollPane> list;
            jComponent2 = new JPopupMenu();
            this.addActionToPopupMenu(HomeView.ActionType.UNDO, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.REDO, (JPopupMenu)jComponent2);
            ((JPopupMenu)jComponent2).addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.CUT, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.COPY, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.PASTE, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.PASTE_STYLE, (JPopupMenu)jComponent2);
            ((JPopupMenu)jComponent2).addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.DELETE, (JPopupMenu)jComponent2);
            object3 = this.menuActionMap.get((Object)MenuActionType.SELECT_OBJECT_MENU);
            if (object3.getValue("Name") != null) {
                jMenuItem = new JMenu((Action)object3);
                ((JPopupMenu)jComponent2).add(jMenuItem);
                object2 = this.menuActionMap.get((Object)MenuActionType.TOGGLE_SELECTION_MENU);
                if (object2.getValue("Name") != null) {
                    object = new KeyEventDispatcher((JMenu)jMenuItem){
                        final /* synthetic */ JMenu val$selectObjectMenu;
                        {
                            this.val$selectObjectMenu = jMenu;
                        }

                        @Override
                        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                            this.val$selectObjectMenu.setAction(HomePane.this.menuActionMap.get((Object)(keyEvent.isShiftDown() ? MenuActionType.TOGGLE_SELECTION_MENU : MenuActionType.SELECT_OBJECT_MENU)));
                            return false;
                        }
                    };
                    this.addAncestorListener(new AncestorListener((KeyEventDispatcher)object){
                        final /* synthetic */ KeyEventDispatcher val$shiftKeyListener;
                        {
                            this.val$shiftKeyListener = keyEventDispatcher;
                        }

                        @Override
                        public void ancestorAdded(AncestorEvent ancestorEvent) {
                            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.val$shiftKeyListener);
                        }

                        @Override
                        public void ancestorRemoved(AncestorEvent ancestorEvent) {
                            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.val$shiftKeyListener);
                        }

                        @Override
                        public void ancestorMoved(AncestorEvent ancestorEvent) {
                        }
                    });
                }
            } else {
                jMenuItem = null;
            }
            this.addActionToPopupMenu(HomeView.ActionType.SELECT_ALL, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.SELECT_ALL_AT_ALL_LEVELS, (JPopupMenu)jComponent2);
            ((JPopupMenu)jComponent2).addSeparator();
            this.addToggleActionToPopupMenu(HomeView.ActionType.SELECT, true, (JPopupMenu)jComponent2);
            this.addToggleActionToPopupMenu(HomeView.ActionType.PAN, true, (JPopupMenu)jComponent2);
            this.addToggleActionToPopupMenu(HomeView.ActionType.CREATE_WALLS, true, (JPopupMenu)jComponent2);
            this.addToggleActionToPopupMenu(HomeView.ActionType.CREATE_ROOMS, true, (JPopupMenu)jComponent2);
            this.addToggleActionToPopupMenu(HomeView.ActionType.CREATE_POLYLINES, true, (JPopupMenu)jComponent2);
            this.addToggleActionToPopupMenu(HomeView.ActionType.CREATE_DIMENSION_LINES, true, (JPopupMenu)jComponent2);
            this.addToggleActionToPopupMenu(HomeView.ActionType.CREATE_LABELS, true, (JPopupMenu)jComponent2);
            ((JPopupMenu)jComponent2).addSeparator();
            object2 = this.createLockUnlockBasePlanMenuItem(home, true);
            if (object2 != null) {
                ((JPopupMenu)jComponent2).add((JMenuItem)object2);
            }
            this.addActionToPopupMenu(HomeView.ActionType.FLIP_HORIZONTALLY, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.FLIP_VERTICALLY, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.MODIFY_FURNITURE, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.GROUP_FURNITURE, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.UNGROUP_FURNITURE, (JPopupMenu)jComponent2);
            ((JPopupMenu)jComponent2).add(this.createAlignOrDistributeMenu(home, userPreferences, true));
            this.addActionToPopupMenu(HomeView.ActionType.RESET_FURNITURE_ELEVATION, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.MODIFY_COMPASS, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.MODIFY_WALL, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.JOIN_WALLS, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.REVERSE_WALL_DIRECTION, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.SPLIT_WALL, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.MODIFY_ROOM, (JPopupMenu)jComponent2);
            object = this.addActionToPopupMenu(HomeView.ActionType.ADD_ROOM_POINT, (JPopupMenu)jComponent2);
            jComponent = this.addActionToPopupMenu(HomeView.ActionType.DELETE_ROOM_POINT, (JPopupMenu)jComponent2);
            JMenuItem jMenuItem2 = this.addActionToPopupMenu(HomeView.ActionType.RECOMPUTE_ROOM_POINTS, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.MODIFY_POLYLINE, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.MODIFY_DIMENSION_LINE, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.MODIFY_LABEL, (JPopupMenu)jComponent2);
            ((JPopupMenu)jComponent2).add(this.createTextStyleMenu(home, userPreferences, true));
            ((JPopupMenu)jComponent2).addSeparator();
            serializable4 = this.createImportModifyBackgroundImageMenuItem(home, true);
            if (serializable4 != null) {
                ((JPopupMenu)jComponent2).add((JMenuItem)serializable4);
            }
            if ((serializable3 = this.createHideShowBackgroundImageMenuItem(home, true)) != null) {
                ((JPopupMenu)jComponent2).add((JMenuItem)serializable3);
            }
            this.addActionToPopupMenu(HomeView.ActionType.DELETE_BACKGROUND_IMAGE, (JPopupMenu)jComponent2);
            ((JPopupMenu)jComponent2).addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.ADD_LEVEL, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.ADD_LEVEL_AT_SAME_ELEVATION, (JPopupMenu)jComponent2);
            serializable2 = this.createMakeLevelUnviewableViewableMenuItem(home, true);
            if (serializable2 != null) {
                ((JPopupMenu)jComponent2).add((JMenuItem)serializable2);
            }
            this.addActionToPopupMenu(HomeView.ActionType.MAKE_LEVEL_ONLY_VIEWABLE_ONE, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.MAKE_ALL_LEVELS_VIEWABLE, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.MODIFY_LEVEL, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.DELETE_LEVEL, (JPopupMenu)jComponent2);
            ((JPopupMenu)jComponent2).addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.ZOOM_OUT, (JPopupMenu)jComponent2);
            this.addActionToPopupMenu(HomeView.ActionType.ZOOM_IN, (JPopupMenu)jComponent2);
            ((JPopupMenu)jComponent2).addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.EXPORT_TO_SVG, (JPopupMenu)jComponent2);
            SwingTools.hideDisabledMenuItems((JPopupMenu)jComponent2);
            if (jMenuItem != null) {
                this.addSelectObjectMenuItems((JMenu)jMenuItem, homeController.getPlanController(), userPreferences);
            }
            if (object != null || jComponent != null || jMenuItem2 != null) {
                this.updateRoomActions((JMenuItem)object, (JMenuItem)jComponent, jMenuItem2, homeController.getPlanController(), userPreferences);
            }
            jComponent3.setComponentPopupMenu((JPopupMenu)jComponent2);
            if (jComponent3 instanceof Scrollable) {
                serializable = SwingTools.createScrollPane(jComponent3);
                jComponent3 = serializable;
            } else {
                list = SwingTools.findChildren(jComponent3, JScrollPane.class);
                serializable = list.size() == 1 ? list.get(0) : null;
            }
            if (serializable != null) {
                this.setPlanRulersVisible((JScrollPane)serializable, homeController, userPreferences.isRulersVisible());
                if (((JScrollPane)serializable).getCorner("UPPER_LEADING_CORNER") == null && (list = this.createLockUnlockBasePlanButton(home)) != null) {
                    ((JScrollPane)serializable).setCorner("UPPER_LEADING_CORNER", (Component)((Object)list));
                    ((Container)serializable).addPropertyChangeListener("componentOrientation", new PropertyChangeListener((JComponent)((Object)list), (JScrollPane)serializable){
                        final /* synthetic */ JComponent val$lockUnlockBasePlanButton;
                        final /* synthetic */ JScrollPane val$planScrollPane;
                        {
                            this.val$lockUnlockBasePlanButton = jComponent;
                            this.val$planScrollPane = jScrollPane;
                        }

                        @Override
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            if (this.val$lockUnlockBasePlanButton.getParent() != null) {
                                this.val$planScrollPane.setCorner("UPPER_LEADING_CORNER", this.val$lockUnlockBasePlanButton);
                            }
                        }
                    });
                }
                userPreferences.addPropertyChangeListener(UserPreferences.Property.RULERS_VISIBLE, new RulersVisibilityChangeListener(this, (JScrollPane)serializable, homeController));
                list = ((JScrollPane)serializable).getViewport();
                Number number = home.getNumericProperty(PLAN_VIEWPORT_X_VISUAL_PROPERTY);
                Number number2 = home.getNumericProperty(PLAN_VIEWPORT_Y_VISUAL_PROPERTY);
                if (number != null && number2 != null) {
                    ((JViewport)((Object)list)).setViewPosition(new Point(number.intValue(), number2.intValue()));
                }
                ((JViewport)((Object)list)).addChangeListener(new ChangeListener((JViewport)((Object)list), homeController){
                    final /* synthetic */ JViewport val$viewport;
                    final /* synthetic */ HomeController val$controller;
                    {
                        this.val$viewport = jViewport;
                        this.val$controller = homeController;
                    }

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        Point point = this.val$viewport.getViewPosition();
                        this.val$controller.setHomeProperty(HomePane.PLAN_VIEWPORT_X_VISUAL_PROPERTY, String.valueOf(point.x));
                        this.val$controller.setHomeProperty(HomePane.PLAN_VIEWPORT_Y_VISUAL_PROPERTY, String.valueOf(point.y));
                    }
                });
            }
        }
        if ((jComponent2 = (JComponent)((Object)homeController.getHomeController3D().getView())) != null) {
            jComponent2.setPreferredSize(jComponent3 != null ? jComponent3.getPreferredSize() : new Dimension(400, 400));
            jComponent2.setMinimumSize(new Dimension());
            object3 = new JPopupMenu();
            jMenuItem = this.addActionToPopupMenu(HomeView.ActionType.SELECT_OBJECT, (JPopupMenu)object3);
            if (jMenuItem != null && (object2 = this.getActionMap().get((Object)HomeView.ActionType.TOGGLE_SELECTION)).getValue("Name") != null) {
                object = new KeyEventDispatcher(){

                    @Override
                    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                        jMenuItem.setAction(HomePane.this.getActionMap().get((Object)(keyEvent.isShiftDown() ? HomeView.ActionType.TOGGLE_SELECTION : HomeView.ActionType.SELECT_OBJECT)));
                        return false;
                    }
                };
                this.addAncestorListener(new AncestorListener((KeyEventDispatcher)object){
                    final /* synthetic */ KeyEventDispatcher val$shiftKeyListener;
                    {
                        this.val$shiftKeyListener = keyEventDispatcher;
                    }

                    @Override
                    public void ancestorAdded(AncestorEvent ancestorEvent) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.val$shiftKeyListener);
                    }

                    @Override
                    public void ancestorRemoved(AncestorEvent ancestorEvent) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.val$shiftKeyListener);
                    }

                    @Override
                    public void ancestorMoved(AncestorEvent ancestorEvent) {
                    }
                });
            }
            ((JPopupMenu)object3).addSeparator();
            this.addToggleActionToPopupMenu(HomeView.ActionType.VIEW_FROM_TOP, true, (JPopupMenu)object3);
            this.addToggleActionToPopupMenu(HomeView.ActionType.VIEW_FROM_OBSERVER, true, (JPopupMenu)object3);
            this.addActionToPopupMenu(HomeView.ActionType.MODIFY_OBSERVER, (JPopupMenu)object3);
            this.addActionToPopupMenu(HomeView.ActionType.STORE_POINT_OF_VIEW, (JPopupMenu)object3);
            object2 = this.createGoToPointOfViewMenu(home, userPreferences, homeController);
            if (object2 != null) {
                ((JPopupMenu)object3).add((JMenuItem)object2);
            }
            this.addActionToPopupMenu(HomeView.ActionType.DELETE_POINTS_OF_VIEW, (JPopupMenu)object3);
            ((JPopupMenu)object3).addSeparator();
            object = this.createAttachDetach3DViewMenuItem(homeController, true);
            if (object != null) {
                ((JPopupMenu)object3).add((JMenuItem)object);
            }
            this.addToggleActionToPopupMenu(HomeView.ActionType.DISPLAY_ALL_LEVELS, true, (JPopupMenu)object3);
            this.addToggleActionToPopupMenu(HomeView.ActionType.DISPLAY_SELECTED_LEVEL, true, (JPopupMenu)object3);
            this.addActionToPopupMenu(HomeView.ActionType.MODIFY_3D_ATTRIBUTES, (JPopupMenu)object3);
            ((JPopupMenu)object3).addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.CREATE_PHOTO, (JPopupMenu)object3);
            this.addActionToPopupMenu(HomeView.ActionType.CREATE_PHOTOS_AT_POINTS_OF_VIEW, (JPopupMenu)object3);
            this.addActionToPopupMenu(HomeView.ActionType.CREATE_VIDEO, (JPopupMenu)object3);
            ((JPopupMenu)object3).addSeparator();
            this.addActionToPopupMenu(HomeView.ActionType.EXPORT_TO_OBJ, (JPopupMenu)object3);
            SwingTools.hideDisabledMenuItems((JPopupMenu)object3);
            if (jMenuItem != null) {
                this.updatePickingActions(jMenuItem, homeController.getHomeController3D(), homeController.getPlanController(), userPreferences);
            }
            jComponent2.setComponentPopupMenu((JPopupMenu)object3);
            if (jComponent2 instanceof Scrollable) {
                jComponent2 = SwingTools.createScrollPane(jComponent2);
            }
            boolean bl = Boolean.parseBoolean(home.getProperty(jComponent2.getClass().getName() + DETACHED_VIEW_VISUAL_PROPERTY));
            if (jComponent3 != null) {
                serializable4 = new JSplitPane(0, jComponent3, jComponent2);
                ((JComponent)serializable4).setMinimumSize(new Dimension());
                this.configureSplitPane((JSplitPane)serializable4, home, PLAN_PANE_DIVIDER_LOCATION_VISUAL_PROPERTY, 0.5, false, homeController);
                serializable3 = home.getNumericProperty(PLAN_PANE_DIVIDER_LOCATION_VISUAL_PROPERTY);
                if (OperatingSystem.isMacOSX() && !OperatingSystem.isJavaVersionGreaterOrEqual("1.7") && !bl && serializable3 != null && serializable3.intValue() > 2 && !Boolean.getBoolean("com.eteks.sweethome3d.j3d.useOffScreen3DView")) {
                    ((JComponent)serializable4).addAncestorListener(new AncestorListener((JSplitPane)serializable4, (Number)serializable3){
                        final /* synthetic */ JSplitPane val$planView3DSplitPane;
                        final /* synthetic */ Number val$dividerLocation;
                        {
                            this.val$planView3DSplitPane = jSplitPane;
                            this.val$dividerLocation = number;
                        }

                        @Override
                        public void ancestorAdded(AncestorEvent ancestorEvent) {
                            this.val$planView3DSplitPane.removeAncestorListener(this);
                            if (this.val$planView3DSplitPane.getRightComponent().getHeight() == 0) {
                                this.val$planView3DSplitPane.setDividerLocation(this.val$dividerLocation.intValue() - 2);
                                new Timer(1000, new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        ((Timer)actionEvent.getSource()).stop();
                                        val$planView3DSplitPane.setDividerLocation(val$dividerLocation.intValue());
                                    }
                                }).start();
                            }
                        }

                        @Override
                        public void ancestorRemoved(AncestorEvent ancestorEvent) {
                        }

                        @Override
                        public void ancestorMoved(AncestorEvent ancestorEvent) {
                        }
                    });
                }
                jComponent = serializable4;
            } else {
                jComponent = jComponent2;
            }
            if (bl) {
                serializable4 = this.home.getNumericProperty(jComponent2.getClass().getName() + DETACHED_VIEW_X_VISUAL_PROPERTY);
                serializable3 = this.home.getNumericProperty(jComponent2.getClass().getName() + DETACHED_VIEW_Y_VISUAL_PROPERTY);
                serializable2 = home.getNumericProperty(jComponent2.getClass().getName() + DETACHED_VIEW_WIDTH_VISUAL_PROPERTY);
                serializable = home.getNumericProperty(jComponent2.getClass().getName() + DETACHED_VIEW_HEIGHT_VISUAL_PROPERTY);
                if (serializable4 != null && serializable3 != null && serializable2 != null && serializable != null) {
                    EventQueue.invokeLater(new Runnable((Number)serializable4, (Number)serializable3, (Number)serializable2, (Number)serializable, jComponent, home){
                        final /* synthetic */ Number val$dialogX;
                        final /* synthetic */ Number val$dialogY;
                        final /* synthetic */ Number val$dialogWidth;
                        final /* synthetic */ Number val$dialogHeight;
                        final /* synthetic */ JComponent val$planView3DPane;
                        final /* synthetic */ Home val$home;
                        {
                            this.val$dialogX = number;
                            this.val$dialogY = number2;
                            this.val$dialogWidth = number3;
                            this.val$dialogHeight = number4;
                            this.val$planView3DPane = jComponent;
                            this.val$home = home;
                        }

                        @Override
                        public void run() {
                            View view = homeController.getHomeController3D().getView();
                            if (HomePane.this.getActionMap().get((Object)HomeView.ActionType.DETACH_3D_VIEW).isEnabled() && HomePane.this.isRectanglePartiallyVisible(this.val$dialogX.intValue(), this.val$dialogY.intValue(), this.val$dialogWidth.intValue(), this.val$dialogHeight.intValue())) {
                                HomePane.this.detachView(view, this.val$dialogX.intValue(), this.val$dialogY.intValue(), this.val$dialogWidth.intValue(), this.val$dialogHeight.intValue());
                            } else if (this.val$planView3DPane instanceof JSplitPane) {
                                JSplitPane jSplitPane = (JSplitPane)this.val$planView3DPane;
                                Number number = this.val$home.getNumericProperty(view.getClass().getName() + HomePane.DETACHED_VIEW_DIVIDER_LOCATION_VISUAL_PROPERTY);
                                if (number != null && number.floatValue() != -1.0f) {
                                    jSplitPane.setDividerLocation(number.floatValue());
                                }
                                homeController.setHomeProperty(view.getClass().getName() + HomePane.DETACHED_VIEW_VISUAL_PROPERTY, String.valueOf(false));
                            }
                        }
                    });
                    return jComponent;
                }
                homeController.setHomeProperty(jComponent2.getClass().getName() + DETACHED_VIEW_X_VISUAL_PROPERTY, null);
            }
            return jComponent;
        }
        return jComponent3;
    }

    private void updateRoomActions(final JMenuItem jMenuItem, final JMenuItem jMenuItem2, final JMenuItem jMenuItem3, final PlanController planController, final UserPreferences userPreferences) {
        JPopupMenu jPopupMenu = (JPopupMenu)(jMenuItem != null ? jMenuItem : jMenuItem2).getParent();
        jPopupMenu.addPopupMenuListener(new PopupMenuListenerWithMouseLocation((JComponent)((Object)planController.getView())){
            private boolean deleteRoomPointActionEnabled;
            private boolean recomputeRoomPointsActionEnabled;
            {
                ResourceAction resourceAction;
                super(jComponent);
                ActionMap actionMap = HomePane.this.getActionMap();
                if (jMenuItem != null) {
                    resourceAction = new ResourceAction(userPreferences, HomePane.class, HomeView.ActionType.ADD_ROOM_POINT.name()){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            PlanView planView = planController.getView();
                            planController.addPointToSelectedRoom(planView.convertXPixelToModel(this.getMouseLocation().x), planView.convertYPixelToModel(this.getMouseLocation().y));
                        }
                    };
                    actionMap.put((Object)HomeView.ActionType.ADD_ROOM_POINT, resourceAction);
                    jMenuItem.setAction(new ResourceAction.PopupMenuItemAction(resourceAction));
                }
                if (jMenuItem2 != null) {
                    resourceAction = new ResourceAction(userPreferences, HomePane.class, HomeView.ActionType.DELETE_ROOM_POINT.name()){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            PlanView planView = planController.getView();
                            planController.deletePointFromSelectedRoom(planView.convertXPixelToModel(this.getMouseLocation().x), planView.convertYPixelToModel(this.getMouseLocation().y));
                        }
                    };
                    actionMap.put((Object)HomeView.ActionType.DELETE_ROOM_POINT, resourceAction);
                    jMenuItem2.setAction(new ResourceAction.PopupMenuItemAction(resourceAction));
                }
                if (jMenuItem3 != null) {
                    resourceAction = new ResourceAction(userPreferences, HomePane.class, HomeView.ActionType.RECOMPUTE_ROOM_POINTS.name()){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            PlanView planView = planController.getView();
                            planController.recomputeSelectedRoomPoints(planView.convertXPixelToModel(this.getMouseLocation().x), planView.convertYPixelToModel(this.getMouseLocation().y));
                        }
                    };
                    actionMap.put((Object)HomeView.ActionType.RECOMPUTE_ROOM_POINTS, resourceAction);
                    jMenuItem3.setAction(new ResourceAction.PopupMenuItemAction(resourceAction));
                }
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                super.popupMenuWillBecomeVisible(popupMenuEvent);
                Point point = this.getMouseLocation();
                if (point != null && jMenuItem2 != null) {
                    float f;
                    Object object;
                    Action action = HomePane.this.getActionMap().get((Object)HomeView.ActionType.DELETE_ROOM_POINT);
                    this.deleteRoomPointActionEnabled = action.isEnabled();
                    if (this.deleteRoomPointActionEnabled) {
                        object = (Room)HomePane.this.home.getSelectedItems().get(0);
                        float f2 = planController.getView().convertXPixelToModel(point.x);
                        f = planController.getView().convertYPixelToModel(point.y);
                        action.setEnabled(planController.isRoomPointDeletableAt((Room)object, f2, f));
                    }
                    object = HomePane.this.getActionMap().get((Object)HomeView.ActionType.RECOMPUTE_ROOM_POINTS);
                    this.recomputeRoomPointsActionEnabled = object.isEnabled();
                    if (this.recomputeRoomPointsActionEnabled) {
                        Room room = (Room)HomePane.this.home.getSelectedItems().get(0);
                        f = planController.getView().convertXPixelToModel(point.x);
                        float f3 = planController.getView().convertYPixelToModel(point.y);
                        object.setEnabled(planController.isRoomPointsComputableAt(room, f, f3));
                    }
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HomePane.this.getActionMap().get((Object)HomeView.ActionType.DELETE_ROOM_POINT).setEnabled(deleteRoomPointActionEnabled);
                        HomePane.this.getActionMap().get((Object)HomeView.ActionType.RECOMPUTE_ROOM_POINTS).setEnabled(recomputeRoomPointsActionEnabled);
                    }
                });
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                this.popupMenuWillBecomeInvisible(popupMenuEvent);
            }
        });
    }

    private void addSelectObjectMenuItems(final JMenu jMenu, final PlanController planController, final UserPreferences userPreferences) {
        ((JPopupMenu)jMenu.getParent()).addPopupMenuListener(new PopupMenuListenerWithMouseLocation((JComponent)((Object)planController.getView())){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                super.popupMenuWillBecomeVisible(popupMenuEvent);
                Point point = this.getMouseLocation();
                if (point != null && !planController.isModificationState()) {
                    List<Selectable> list = planController.getSelectableItemsAt(planController.getView().convertXPixelToModel(point.x), planController.getView().convertYPixelToModel(point.y));
                    HashMap<Class<Label>, SelectableFormat<Compass>> hashMap = new HashMap<Class<Label>, SelectableFormat<Compass>>();
                    hashMap.put(Compass.class, new SelectableFormat<Compass>(){

                        @Override
                        public String format(Compass compass) {
                            return userPreferences.getLocalizedString(HomePane.class, "selectObject.compass", new Object[0]);
                        }
                    });
                    hashMap.put(HomePieceOfFurniture.class, new SelectableFormat<HomePieceOfFurniture>(){

                        @Override
                        public String format(HomePieceOfFurniture homePieceOfFurniture) {
                            if (homePieceOfFurniture.getName().length() > 0) {
                                return homePieceOfFurniture.getName();
                            }
                            return userPreferences.getLocalizedString(HomePane.class, "selectObject.furniture", new Object[0]);
                        }
                    });
                    hashMap.put(Wall.class, new SelectableFormat<Wall>(){

                        @Override
                        public String format(Wall wall) {
                            return userPreferences.getLocalizedString(HomePane.class, "selectObject.wall", userPreferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(wall.getLength())));
                        }
                    });
                    hashMap.put(Room.class, new SelectableFormat<Room>(){

                        @Override
                        public String format(Room room) {
                            String string;
                            String string2 = room.getName() != null && room.getName().length() > 0 ? room.getName() : (string = room.isAreaVisible() ? userPreferences.getLengthUnit().getAreaFormatWithUnit().format(Float.valueOf(room.getArea())) : "");
                            if (room.isFloorVisible() && !room.isCeilingVisible()) {
                                return userPreferences.getLocalizedString(HomePane.class, "selectObject.floor", string);
                            }
                            if (!room.isFloorVisible() && room.isCeilingVisible()) {
                                return userPreferences.getLocalizedString(HomePane.class, "selectObject.ceiling", string);
                            }
                            return userPreferences.getLocalizedString(HomePane.class, "selectObject.room", string);
                        }
                    });
                    hashMap.put(Polyline.class, new SelectableFormat<Polyline>(){

                        @Override
                        public String format(Polyline polyline) {
                            return userPreferences.getLocalizedString(HomePane.class, "selectObject.polyline", userPreferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(polyline.getLength())));
                        }
                    });
                    hashMap.put(DimensionLine.class, new SelectableFormat<DimensionLine>(){

                        @Override
                        public String format(DimensionLine dimensionLine) {
                            return userPreferences.getLocalizedString(HomePane.class, "selectObject.dimensionLine", userPreferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(dimensionLine.getLength())));
                        }
                    });
                    hashMap.put(Label.class, new SelectableFormat<Label>(){

                        @Override
                        public String format(Label label) {
                            if (label.getText().length() > 0) {
                                return label.getText();
                            }
                            return userPreferences.getLocalizedString(HomePane.class, "selectObject.label", new Object[0]);
                        }
                    });
                    for (final Selectable selectable : list) {
                        String string = null;
                        for (Map.Entry entry : hashMap.entrySet()) {
                            if (!((Class)entry.getKey()).isInstance(selectable)) continue;
                            string = ((SelectableFormat)entry.getValue()).format(selectable);
                            break;
                        }
                        if (string == null) continue;
                        jMenu.add(new JMenuItem(new AbstractAction(string){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                if ((actionEvent.getModifiers() & 1) == 1) {
                                    planController.toggleItemSelection(selectable);
                                } else {
                                    planController.selectItem(selectable);
                                }
                            }
                        }));
                    }
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                jMenu.removeAll();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    private void updatePickingActions(final JMenuItem jMenuItem, final HomeController3D homeController3D, final PlanController planController, UserPreferences userPreferences) {
        JPopupMenu jPopupMenu = (JPopupMenu)jMenuItem.getParent();
        jPopupMenu.addPopupMenuListener(new PopupMenuListenerWithMouseLocation((JComponent)((Object)homeController3D.getView())){
            private Selectable selectableItem;
            {
                super(jComponent);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if ((actionEvent.getModifiers() & 1) == 1) {
                            planController.toggleItemSelection(selectableItem);
                        } else {
                            planController.selectItem(selectableItem);
                            if (selectableItem instanceof Elevatable && !((Elevatable)((Object)selectableItem)).isAtLevel(HomePane.this.home.getSelectedLevel())) {
                                planController.setSelectedLevel(((Elevatable)((Object)selectableItem)).getLevel());
                            }
                            planController.getView().makeSelectionVisible();
                        }
                    }
                });
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                super.popupMenuWillBecomeVisible(popupMenuEvent);
                Point point = this.getMouseLocation();
                this.selectableItem = point != null && planController != null && !planController.isModificationState() ? (homeController3D.getView() instanceof View3D ? ((View3D)homeController3D.getView()).getClosestSelectableItemAt(point.x, point.y) : null) : null;
                HomePane.this.getActionMap().get((Object)HomeView.ActionType.SELECT_OBJECT).setEnabled(this.selectableItem != null);
                HomePane.this.getActionMap().get((Object)HomeView.ActionType.TOGGLE_SELECTION).setEnabled(this.selectableItem != null);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    private void setPlanRulersVisible(JScrollPane jScrollPane, HomeController homeController, boolean bl) {
        if (bl) {
            jScrollPane.setColumnHeaderView((JComponent)((Object)homeController.getPlanController().getHorizontalRulerView()));
            jScrollPane.setRowHeaderView((JComponent)((Object)homeController.getPlanController().getVerticalRulerView()));
        } else {
            jScrollPane.setColumnHeaderView(null);
            jScrollPane.setRowHeaderView(null);
        }
    }

    private void disableMenuItemsDuringDragAndDrop(View view, final JMenuBar jMenuBar) {
        class MouseAndFocusListener
        extends MouseAdapter
        implements FocusListener {
            MouseAndFocusListener() {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    this.setMenusEnabled(jMenuBar, false);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    this.setMenusEnabled(jMenuBar, true);
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                this.setMenusEnabled(jMenuBar, true);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                this.setMenusEnabled(jMenuBar, true);
            }

            private void setMenusEnabled(final JMenuBar jMenuBar2, final boolean bl) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int n = jMenuBar2.getMenuCount();
                        for (int i = 0; i < n; ++i) {
                            this.setMenuItemsEnabled(jMenuBar2.getMenu(i), bl);
                        }
                    }
                });
            }

            private void setMenuItemsEnabled(JMenu jMenu, boolean bl) {
                int n = jMenu.getItemCount();
                for (int i = 0; i < n; ++i) {
                    JMenuItem jMenuItem = jMenu.getItem(i);
                    if (jMenuItem instanceof JMenu) {
                        this.setMenuItemsEnabled((JMenu)jMenuItem, bl);
                        continue;
                    }
                    if (jMenuItem == null) continue;
                    jMenuItem.setEnabled(bl ? jMenuItem.getAction().isEnabled() : false);
                }
            }
        }
        MouseAndFocusListener mouseAndFocusListener = new MouseAndFocusListener();
        if (view != null) {
            ((JComponent)((Object)view)).addMouseListener(mouseAndFocusListener);
            ((JComponent)((Object)view)).addFocusListener(mouseAndFocusListener);
        }
    }

    @Override
    public void detachView(View view) {
        Serializable serializable;
        JComponent jComponent = (JComponent)((Object)view);
        Container container = jComponent.getParent();
        if (container instanceof JViewport) {
            jComponent = (JComponent)container.getParent();
            container = jComponent.getParent();
        }
        float f = container instanceof JSplitPane ? (((JSplitPane)(serializable = (JSplitPane)container)).getOrientation() == 0 ? (float)((JSplitPane)serializable).getDividerLocation() / (float)(((JComponent)serializable).getHeight() - ((JSplitPane)serializable).getDividerSize()) : (float)((JSplitPane)serializable).getDividerLocation() / (float)(((JComponent)serializable).getWidth() - ((JSplitPane)serializable).getDividerSize())) : -1.0f;
        serializable = this.home.getNumericProperty(view.getClass().getName() + DETACHED_VIEW_X_VISUAL_PROPERTY);
        Number number = this.home.getNumericProperty(view.getClass().getName() + DETACHED_VIEW_Y_VISUAL_PROPERTY);
        Number number2 = this.home.getNumericProperty(view.getClass().getName() + DETACHED_VIEW_WIDTH_VISUAL_PROPERTY);
        Number number3 = this.home.getNumericProperty(view.getClass().getName() + DETACHED_VIEW_HEIGHT_VISUAL_PROPERTY);
        if (serializable != null && number != null && number2 != null && number3 != null) {
            this.detachView(view, ((Number)serializable).intValue(), number.intValue(), number2.intValue(), number3.intValue());
        } else {
            Point point = new Point();
            Dimension dimension = jComponent.getSize();
            Dimension dimension2 = jComponent.getPreferredSize();
            SwingUtilities.convertPointToScreen(point, jComponent);
            Insets insets = new JDialog().getInsets();
            this.detachView(view, point.x - insets.left, point.y - insets.top, (dimension.width == 0 || dimension.height == 0 ? Math.max(dimension2.width, dimension.width) : dimension.width) + insets.left + insets.right, (dimension.width == 0 || dimension.height == 0 ? Math.max(dimension2.height, dimension.height) : dimension.height) + insets.top + insets.bottom);
        }
        this.controller.setHomeProperty(view.getClass().getName() + DETACHED_VIEW_DIVIDER_LOCATION_VISUAL_PROPERTY, String.valueOf(f));
    }

    private void detachView(final View view, int n, int n2, int n3, int n4) {
        Window window;
        Container container;
        Container container2;
        JComponent jComponent = (JComponent)((Object)view);
        Container container3 = jComponent.getParent();
        if (container3 instanceof JViewport) {
            jComponent = (JComponent)container3.getParent();
            container3 = jComponent.getParent();
        }
        final JPanel jPanel = new JPanel();
        jPanel.setMaximumSize(new Dimension());
        jPanel.setMinimumSize(new Dimension());
        jPanel.setName(view.getClass().getName());
        jPanel.setBorder(jComponent.getBorder());
        if (container3 instanceof JSplitPane) {
            float f;
            container2 = (JSplitPane)container3;
            ((JSplitPane)container2).setDividerSize(0);
            if (((JSplitPane)container2).getLeftComponent() == jComponent) {
                ((JSplitPane)container2).setLeftComponent(jPanel);
                f = 0.0f;
            } else {
                ((JSplitPane)container2).setRightComponent(jPanel);
                f = 1.0f;
            }
            ((JSplitPane)container2).setDividerLocation(f);
            jPanel.addComponentListener(new ComponentAdapter((JSplitPane)container2, f){
                final /* synthetic */ JSplitPane val$splitPane;
                final /* synthetic */ float val$dividerLocation;
                {
                    this.val$splitPane = jSplitPane;
                    this.val$dividerLocation = f;
                }

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    jPanel.removeComponentListener(this);
                    this.val$splitPane.setDividerLocation(this.val$dividerLocation);
                    jPanel.addComponentListener(this);
                }
            });
        } else {
            int n5 = container3.getComponentZOrder(jComponent);
            container3.remove(n5);
            container3.add((Component)jPanel, n5);
        }
        container2 = SwingUtilities.getWindowAncestor(this);
        if (!(container2 instanceof Frame)) {
            container2 = JOptionPane.getRootFrame();
        }
        Frame frame = (Frame)container2;
        if (OperatingSystem.isMacOSX() && OperatingSystem.isJavaVersionGreaterOrEqual("1.7") && GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length > 1) {
            container = new JFrame(frame.getTitle(), frame.getGraphicsConfiguration());
            ((JFrame)container).setDefaultCloseOperation(0);
            if (frame instanceof JFrame) {
                ((JFrame)container).setJMenuBar(this.createMenuBar(this.home, this.preferences, this.controller));
            }
            try {
                JFrame.class.getMethod("setIconImages", List.class).invoke((Object)container, JFrame.class.getMethod("getIconImages", new Class[0]).invoke((Object)frame, new Object[0]));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            frame.addWindowListener(new WindowAdapter((JFrame)container){
                final /* synthetic */ JFrame val$separateFrame;
                {
                    this.val$separateFrame = jFrame;
                }

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    this.val$separateFrame.dispose();
                    windowEvent.getWindow().removeWindowListener(this);
                }
            });
            window = container;
        } else {
            container = new JDialog(frame, frame.getTitle(), false);
            ((Dialog)container).setResizable(true);
            ((JDialog)container).setDefaultCloseOperation(0);
            ActionMap actionMap = this.getActionMap();
            ((JDialog)container).getRootPane().setActionMap(actionMap);
            InputMap inputMap = ((JDialog)container).getRootPane().getInputMap(2);
            for (Object object : actionMap.allKeys()) {
                Action action = actionMap.get(object);
                KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
                if (object == HomeView.ActionType.CLOSE || object == HomeView.ActionType.DETACH_3D_VIEW || object == HomeView.ActionType.EXIT && OperatingSystem.isMacOSX() || keyStroke == null) continue;
                inputMap.put(keyStroke, object);
            }
            window = container;
        }
        frame.addPropertyChangeListener("title", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (window instanceof JFrame) {
                    ((JFrame)window).setTitle((String)propertyChangeEvent.getNewValue());
                } else {
                    ((JDialog)window).setTitle((String)propertyChangeEvent.getNewValue());
                }
            }
        });
        container = ((RootPaneContainer)((Object)window)).getRootPane();
        if (frame instanceof RootPaneContainer) {
            if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
                ((RootPaneContainer)((Object)frame)).getRootPane().addPropertyChangeListener("Window.documentModified", new PropertyChangeListener((JRootPane)container){
                    final /* synthetic */ JRootPane val$separateRootPane;
                    {
                        this.val$separateRootPane = jRootPane;
                    }

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        this.val$separateRootPane.putClientProperty("Window.documentModified", propertyChangeEvent.getNewValue());
                    }
                });
            } else if (OperatingSystem.isMacOSX()) {
                ((RootPaneContainer)((Object)frame)).getRootPane().addPropertyChangeListener("windowModified", new PropertyChangeListener((JRootPane)container){
                    final /* synthetic */ JRootPane val$separateRootPane;
                    {
                        this.val$separateRootPane = jRootPane;
                    }

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        this.val$separateRootPane.putClientProperty("windowModified", propertyChangeEvent.getNewValue());
                    }
                });
            }
        }
        ((JRootPane)container).setContentPane(jComponent);
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HomePane.this.controller.attachView(view);
            }
        });
        window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                HomePane.this.controller.setHomeProperty(view.getClass().getName() + HomePane.DETACHED_VIEW_WIDTH_VISUAL_PROPERTY, String.valueOf(window.getWidth()));
                HomePane.this.controller.setHomeProperty(view.getClass().getName() + HomePane.DETACHED_VIEW_HEIGHT_VISUAL_PROPERTY, String.valueOf(window.getHeight()));
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                HomePane.this.controller.setHomeProperty(view.getClass().getName() + HomePane.DETACHED_VIEW_X_VISUAL_PROPERTY, String.valueOf(window.getX()));
                HomePane.this.controller.setHomeProperty(view.getClass().getName() + HomePane.DETACHED_VIEW_Y_VISUAL_PROPERTY, String.valueOf(window.getY()));
            }
        });
        window.setBounds(n, n2, n3, n4);
        window.setLocationByPlatform(!this.isRectanglePartiallyVisible(n, n2, n3, n4));
        window.setVisible(true);
        this.controller.setHomeProperty(view.getClass().getName() + DETACHED_VIEW_VISUAL_PROPERTY, Boolean.TRUE.toString());
    }

    private boolean isRectanglePartiallyVisible(int n, int n2, int n3, int n4) {
        Area area = new Area(new Rectangle(n, n2, n3, n4));
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : graphicsEnvironment.getScreenDevices()) {
            Area area2 = new Area(graphicsDevice.getDefaultConfiguration().getBounds());
            area2.intersect(area);
            Rectangle rectangle = area2.getBounds();
            if (!(rectangle.getWidth() * rectangle.getHeight() >= (double)(n3 * n4 / 10))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void attachView(View view) {
        this.controller.setHomeProperty(view.getClass().getName() + DETACHED_VIEW_VISUAL_PROPERTY, String.valueOf(false));
        JComponent jComponent = (JComponent)this.findChild(this, view.getClass().getName());
        if (jComponent != null) {
            JComponent jComponent2 = (JComponent)((Object)view);
            Window window = SwingUtilities.getWindowAncestor(jComponent2);
            ((RootPaneContainer)((Object)window)).getRootPane().setActionMap(null);
            window.dispose();
            jComponent2.setBorder(jComponent.getBorder());
            Container container = jComponent.getParent();
            if (container instanceof JSplitPane) {
                JSplitPane jSplitPane = (JSplitPane)container;
                jSplitPane.setDividerSize(UIManager.getInt("SplitPane.dividerSize"));
                Number number = this.home.getNumericProperty(view.getClass().getName() + DETACHED_VIEW_DIVIDER_LOCATION_VISUAL_PROPERTY);
                if (number != null) {
                    jSplitPane.setDividerLocation(number.floatValue());
                }
                if (jSplitPane.getLeftComponent() == jComponent) {
                    jSplitPane.setLeftComponent(jComponent2);
                } else {
                    jSplitPane.setRightComponent(jComponent2);
                }
            } else {
                int n = container.getComponentZOrder(jComponent);
                container.remove(n);
                container.add((Component)jComponent2, n);
            }
        }
    }

    private Component findChild(Container container, String string) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (string.equals(component.getName())) {
                return component;
            }
            if (!(component instanceof Container) || (component = this.findChild((Container)component, string)) == null) continue;
            return component;
        }
        return null;
    }

    @Override
    public String showOpenDialog() {
        return this.controller.getContentManager().showOpenDialog(this, this.preferences.getLocalizedString(HomePane.class, "openHomeDialog.title", new Object[0]), ContentManager.ContentType.SWEET_HOME_3D);
    }

    @Override
    public String showNewHomeFromExampleDialog() {
        Object[] objectArray;
        String string = this.preferences.getLocalizedString(HomePane.class, "newHomeFromExample.message", new Object[0]);
        String string2 = this.preferences.getLocalizedString(HomePane.class, "newHomeFromExample.title", new Object[0]);
        final String string3 = this.preferences.getLocalizedString(HomePane.class, "newHomeFromExample.useSelectedExample", new Object[0]);
        String string4 = this.preferences.getLocalizedString(HomePane.class, "newHomeFromExample.findMoreExamples", new Object[0]);
        String string5 = this.preferences.getLocalizedString(HomePane.class, "newHomeFromExample.cancel", new Object[0]);
        final JList jList = new JList(this.preferences.getHomeExamples().toArray()){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                int n = this.locationToIndex(mouseEvent.getPoint());
                return n != -1 ? ((HomeDescriptor)this.getModel().getElementAt(n)).getName() : null;
            }
        };
        jList.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public void removeSelectionInterval(int n, int n2) {
            }
        });
        jList.setSelectionMode(0);
        jList.setSelectedIndex(0);
        jList.setLayoutOrientation(2);
        jList.setVisibleRowCount(3);
        final int n = (int)(192.0f * SwingTools.getResolutionScale());
        jList.setFixedCellWidth(n + 8);
        jList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList2, Object object, int n2, boolean bl, boolean bl2) {
                HomeDescriptor homeDescriptor = (HomeDescriptor)object;
                super.getListCellRendererComponent((JList<?>)jList2, homeDescriptor.getName(), n2, bl, bl2);
                this.setIcon(IconManager.getInstance().getIcon(homeDescriptor.getIcon(), n * 3 / 4, jList));
                this.setHorizontalAlignment(0);
                this.setHorizontalTextPosition(0);
                this.setVerticalTextPosition(3);
                this.setBorder(BorderFactory.createCompoundBorder(this.getBorder(), BorderFactory.createEmptyBorder(2, 0, 2, 0)));
                return this;
            }
        });
        jList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ((JOptionPane)SwingUtilities.getAncestorOfClass(JOptionPane.class, mouseEvent.getComponent())).setValue(string3);
                }
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(string), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, (int)(5.0f * SwingTools.getResolutionScale()), 0), 0, 0));
        jPanel.add((Component)new JScrollPane(jList), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (string4.length() > 0) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = string3;
            objectArray2[1] = string4;
            objectArray = objectArray2;
            objectArray2[2] = string5;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = string3;
            objectArray = objectArray3;
            objectArray3[1] = string5;
        }
        Object[] objectArray4 = objectArray;
        int n2 = JOptionPane.showOptionDialog(this, jPanel, string2, string4.length() > 0 ? 1 : 2, -1, null, objectArray4, string3);
        switch (n2) {
            case 0: {
                Content content = ((HomeDescriptor)jList.getSelectedValue()).getContent();
                return content instanceof URLContent ? ((URLContent)content).getURL().toString() : null;
            }
            case 1: {
                if (string4.length() <= 0) break;
                String string6 = this.preferences.getLocalizedString(HomePane.class, "findMoreExamples.url", new Object[0]);
                boolean bl = false;
                try {
                    bl = SwingTools.showDocumentInBrowser(new URL(string6));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                if (bl) break;
                JTextArea jTextArea = new JTextArea(this.preferences.getLocalizedString(HomePane.class, "findMoreExamplesMessage.text", new Object[0]));
                String string7 = this.preferences.getLocalizedString(HomePane.class, "findMoreExamplesMessage.title", new Object[0]);
                jTextArea.setEditable(false);
                jTextArea.setOpaque(false);
                SwingTools.showMessageDialog(this, jTextArea, string7, 1);
            }
        }
        return null;
    }

    @Override
    public HomeView.OpenDamagedHomeAnswer confirmOpenDamagedHome(String string, Home home, List<Content> list) {
        String string2 = this.preferences.getLocalizedString(HomePane.class, "openDamagedHome.message", string, Math.max(1, list.size()));
        String string3 = this.preferences.getLocalizedString(HomePane.class, "openDamagedHome.title", new Object[0]);
        String string4 = this.preferences.getLocalizedString(HomePane.class, "openDamagedHome.removeDamagedItems", new Object[0]);
        String string5 = this.preferences.getLocalizedString(HomePane.class, "openDamagedHome.replaceDamagedItems", new Object[0]);
        String string6 = this.preferences.getLocalizedString(HomePane.class, "openDamagedHome.doNotOpenHome", new Object[0]);
        switch (SwingTools.showOptionDialog(this, string2, string3, 1, 2, new Object[]{string4, string5, string6}, string6)) {
            case 0: {
                return HomeView.OpenDamagedHomeAnswer.REMOVE_DAMAGED_ITEMS;
            }
            case 1: {
                return HomeView.OpenDamagedHomeAnswer.REPLACE_DAMAGED_ITEMS;
            }
        }
        return HomeView.OpenDamagedHomeAnswer.DO_NOT_OPEN_HOME;
    }

    @Override
    public String showImportLanguageLibraryDialog() {
        return this.controller.getContentManager().showOpenDialog(this, this.preferences.getLocalizedString(HomePane.class, "importLanguageLibraryDialog.title", new Object[0]), ContentManager.ContentType.LANGUAGE_LIBRARY);
    }

    @Override
    public boolean confirmReplaceLanguageLibrary(String string) {
        String string2 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceLanguageLibrary.message", this.controller.getContentManager().getPresentationName(string, ContentManager.ContentType.LANGUAGE_LIBRARY));
        String string3 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceLanguageLibrary.title", new Object[0]);
        String string4 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceLanguageLibrary.replace", new Object[0]);
        String string5 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceLanguageLibrary.doNotReplace", new Object[0]);
        return SwingTools.showOptionDialog(this, string2, string3, 2, 3, new Object[]{string4, string5}, string5) == 0;
    }

    @Override
    public String showImportFurnitureLibraryDialog() {
        return this.controller.getContentManager().showOpenDialog(this, this.preferences.getLocalizedString(HomePane.class, "importFurnitureLibraryDialog.title", new Object[0]), ContentManager.ContentType.FURNITURE_LIBRARY);
    }

    @Override
    public boolean confirmReplaceFurnitureLibrary(String string) {
        String string2 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceFurnitureLibrary.message", this.controller.getContentManager().getPresentationName(string, ContentManager.ContentType.FURNITURE_LIBRARY));
        String string3 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceFurnitureLibrary.title", new Object[0]);
        String string4 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceFurnitureLibrary.replace", new Object[0]);
        String string5 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceFurnitureLibrary.doNotReplace", new Object[0]);
        return SwingTools.showOptionDialog(this, string2, string3, 2, 3, new Object[]{string4, string5}, string5) == 0;
    }

    @Override
    public String showImportTexturesLibraryDialog() {
        return this.controller.getContentManager().showOpenDialog(this, this.preferences.getLocalizedString(HomePane.class, "importTexturesLibraryDialog.title", new Object[0]), ContentManager.ContentType.TEXTURES_LIBRARY);
    }

    @Override
    public boolean confirmReplaceTexturesLibrary(String string) {
        String string2 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceTexturesLibrary.message", this.controller.getContentManager().getPresentationName(string, ContentManager.ContentType.TEXTURES_LIBRARY));
        String string3 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceTexturesLibrary.title", new Object[0]);
        String string4 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceTexturesLibrary.replace", new Object[0]);
        String string5 = this.preferences.getLocalizedString(HomePane.class, "confirmReplaceTexturesLibrary.doNotReplace", new Object[0]);
        return SwingTools.showOptionDialog(this, string2, string3, 2, 3, new Object[]{string4, string5}, string5) == 0;
    }

    @Override
    public boolean confirmReplacePlugin(String string) {
        String string2 = this.preferences.getLocalizedString(HomePane.class, "confirmReplacePlugin.message", this.controller.getContentManager().getPresentationName(string, ContentManager.ContentType.PLUGIN));
        String string3 = this.preferences.getLocalizedString(HomePane.class, "confirmReplacePlugin.title", new Object[0]);
        String string4 = this.preferences.getLocalizedString(HomePane.class, "confirmReplacePlugin.replace", new Object[0]);
        String string5 = this.preferences.getLocalizedString(HomePane.class, "confirmReplacePlugin.doNotReplace", new Object[0]);
        return SwingTools.showOptionDialog(this, string2, string3, 2, 3, new Object[]{string4, string5}, string5) == 0;
    }

    @Override
    public String showSaveDialog(String string) {
        return this.controller.getContentManager().showSaveDialog(this, this.preferences.getLocalizedString(HomePane.class, "saveHomeDialog.title", new Object[0]), ContentManager.ContentType.SWEET_HOME_3D, string);
    }

    @Override
    public void showError(String string) {
        String string2 = this.preferences.getLocalizedString(HomePane.class, "error.title", new Object[0]);
        SwingTools.showMessageDialog(this, string, string2, 0);
    }

    @Override
    public void showMessage(String string) {
        String string2 = this.preferences.getLocalizedString(HomePane.class, "message.title", new Object[0]);
        SwingTools.showMessageDialog(this, string, string2, 1);
    }

    @Override
    public boolean showActionTipMessage(String string) {
        String string2 = this.preferences.getLocalizedString(HomePane.class, string + ".tipTitle", new Object[0]);
        String string3 = this.preferences.getLocalizedString(HomePane.class, string + ".tipMessage", new Object[0]);
        if (string3.length() > 0) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            JLabel jLabel = new JLabel(string3);
            jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 10, 0), 0, 0));
            JCheckBox jCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(this.preferences, HomePane.class, "doNotDisplayTipCheckBox.text", new Object[0]));
            if (!OperatingSystem.isMacOSX()) {
                jCheckBox.setMnemonic(KeyStroke.getKeyStroke(this.preferences.getLocalizedString(HomePane.class, "doNotDisplayTipCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            jPanel.add((Component)jCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, (int)(5.0f * SwingTools.getResolutionScale()), 0), 0, 0));
            SwingTools.showMessageDialog(this, jPanel, string2, 1, jCheckBox);
            return jCheckBox.isSelected();
        }
        return true;
    }

    @Override
    public HomeView.SaveAnswer confirmSave(String string) {
        String string2 = string != null ? this.preferences.getLocalizedString(HomePane.class, "confirmSave.message", "\"" + this.controller.getContentManager().getPresentationName(string, ContentManager.ContentType.SWEET_HOME_3D) + "\"") : this.preferences.getLocalizedString(HomePane.class, "confirmSave.message", "");
        String string3 = this.preferences.getLocalizedString(HomePane.class, "confirmSave.title", new Object[0]);
        String string4 = this.preferences.getLocalizedString(HomePane.class, "confirmSave.save", new Object[0]);
        String string5 = this.preferences.getLocalizedString(HomePane.class, "confirmSave.doNotSave", new Object[0]);
        String string6 = this.preferences.getLocalizedString(HomePane.class, "confirmSave.cancel", new Object[0]);
        switch (SwingTools.showOptionDialog(this, string2, string3, 1, 3, new Object[]{string4, string5, string6}, string4)) {
            case 0: {
                return HomeView.SaveAnswer.SAVE;
            }
            case 1: {
                return HomeView.SaveAnswer.DO_NOT_SAVE;
            }
        }
        return HomeView.SaveAnswer.CANCEL;
    }

    @Override
    public boolean confirmSaveNewerHome(String string) {
        String string2 = this.preferences.getLocalizedString(HomePane.class, "confirmSaveNewerHome.message", this.controller.getContentManager().getPresentationName(string, ContentManager.ContentType.SWEET_HOME_3D));
        String string3 = this.preferences.getLocalizedString(HomePane.class, "confirmSaveNewerHome.title", new Object[0]);
        String string4 = this.preferences.getLocalizedString(HomePane.class, "confirmSaveNewerHome.save", new Object[0]);
        String string5 = this.preferences.getLocalizedString(HomePane.class, "confirmSaveNewerHome.doNotSave", new Object[0]);
        return SwingTools.showOptionDialog(this, string2, string3, 0, 3, new Object[]{string4, string5}, string5) == 0;
    }

    @Override
    public boolean confirmExit() {
        String string = this.preferences.getLocalizedString(HomePane.class, "confirmExit.message", new Object[0]);
        String string2 = this.preferences.getLocalizedString(HomePane.class, "confirmExit.title", new Object[0]);
        String string3 = this.preferences.getLocalizedString(HomePane.class, "confirmExit.quit", new Object[0]);
        String string4 = this.preferences.getLocalizedString(HomePane.class, "confirmExit.doNotQuit", new Object[0]);
        return SwingTools.showOptionDialog(this, string, string2, 0, 3, new Object[]{string3, string4}, string4) == 0;
    }

    @Override
    public void showAboutDialog() {
        final JTextComponent jTextComponent = this.createEditorPane(this.getAboutMessage());
        jTextComponent.setOpaque(false);
        Timer timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jTextComponent.isShowing()) {
                    System.gc();
                    jTextComponent.setText(HomePane.this.getAboutMessage());
                }
            }
        });
        timer.start();
        String string = this.preferences.getLocalizedString(HomePane.class, "about.title", new Object[0]);
        ImageIcon imageIcon = new ImageIcon(HomePane.class.getResource(this.preferences.getLocalizedString(HomePane.class, "about.icon", new Object[0])));
        try {
            String string2 = this.preferences.getLocalizedString(HomePane.class, "about.close", new Object[0]);
            String string3 = this.preferences.getLocalizedString(HomePane.class, "about.showLibraries", new Object[0]);
            List<Library> list = this.preferences.getLibraries();
            if (!list.isEmpty()) {
                int n = JOptionPane.showOptionDialog(this, jTextComponent, string, 0, 1, imageIcon, new Object[]{string2, string3}, string2);
                timer.stop();
                if (n == 1) {
                    this.showLibrariesDialog(list);
                }
                return;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        JOptionPane.showMessageDialog(this, jTextComponent, string, 1, imageIcon);
        timer.stop();
    }

    private String getAboutMessage() {
        Object object;
        String string = this.preferences.getLocalizedString(HomePane.class, "about.message", new Object[0]);
        String string2 = this.controller.getVersion();
        String string3 = System.getProperty("java.version");
        String string4 = System.getProperty("java.runtime.name", "Java").split("\\W")[0];
        String string5 = System.getProperty("java.vendor", "Oracle");
        String string6 = System.getProperty("java.vendor.url");
        if (string6 != null) {
            string5 = "<a href='" + string6 + "'>" + string5 + "</a>";
        }
        try {
            object = System.getProperty("sun.arch.data.model");
            if (object != null) {
                string3 = string3 + " - <span>" + Integer.parseInt((String)object) + "bit</span>";
                if (System.getProperty("os.arch").startsWith("aarch")) {
                    string3 = string3 + " - ARM";
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        object = Runtime.getRuntime();
        float f = Math.max(0.1f, (float)(((Runtime)object).totalMemory() - ((Runtime)object).freeMemory()) / 1.0737418E9f);
        float f2 = Math.max(0.1f, (float)((Runtime)object).maxMemory() / 1.0737418E9f);
        DecimalFormat decimalFormat = new DecimalFormat("#.#");
        string3 = string3 + " - " + decimalFormat.format(f) + " / " + decimalFormat.format(f2) + " " + (Locale.FRENCH.getLanguage().equals(Locale.getDefault().getLanguage()) ? "Go" : "GB");
        String string7 = "<i>not available</i>";
        try {
            if (!Boolean.getBoolean("com.eteks.sweethome3d.no3D")) {
                Map map = VirtualUniverse.getProperties();
                string7 = (String)map.get("j3d.version");
                if (string7 != null) {
                    string7 = string7.split("\\s")[0];
                }
                String string8 = (String)map.get("j3d.pipeline");
                string7 = string7 + " - " + string8;
                if ("JOGL".equals(string8)) {
                    String string9;
                    Object object2 = Class.forName("com.jogamp.opengl.JoglVersion").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                    Method method = object2.getClass().getMethod("getAttribute", Attributes.Name.class);
                    String string10 = (String)method.invoke(object2, Attributes.Name.IMPLEMENTATION_VERSION);
                    if (string10 != null) {
                        string7 = string7 + " " + string10;
                    }
                    String string11 = (String)method.invoke(object2, Attributes.Name.IMPLEMENTATION_VENDOR);
                    String string12 = (String)method.invoke(object2, Attributes.Name.IMPLEMENTATION_URL);
                    if (string11 != null && string12 != null && (string9 = this.preferences.getLocalizedString(HomePane.class, "about.java3DProvider", "<a href='" + string12 + "'>" + string11 + "</a>")) != null && string9.trim().length() > 0) {
                        string7 = string7 + "<br>" + string9;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return String.format(string, string2, string3, string7, string4, string5);
    }

    private JTextComponent createEditorPane(String string) {
        JEditorPane jEditorPane = new JEditorPane("text/html", string);
        jEditorPane.setEditable(false);
        if (SwingTools.getResolutionScale() != 1.0f) {
            jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        }
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SwingTools.showDocumentInBrowser(hyperlinkEvent.getURL());
                }
            }
        });
        return jEditorPane;
    }

    private void showLibrariesDialog(List<Library> list) {
        String string = this.preferences.getLocalizedString(HomePane.class, "libraries.title", new Object[0]);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("Furniture library", this.preferences.getLocalizedString(HomePane.class, "libraries.furnitureLibraries", new Object[0]));
        linkedHashMap.put("Textures library", this.preferences.getLocalizedString(HomePane.class, "libraries.texturesLibraries", new Object[0]));
        linkedHashMap.put("Language library", this.preferences.getLocalizedString(HomePane.class, "libraries.languageLibraries", new Object[0]));
        linkedHashMap.put("Plugin", this.preferences.getLocalizedString(HomePane.class, "libraries.plugins", new Object[0]));
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            ArrayList<Library> arrayList = new ArrayList<Library>();
            for (Library library : list) {
                if (!((String)entry.getKey()).equals(library.getType())) continue;
                arrayList.add(library);
            }
            if (arrayList.isEmpty()) continue;
            jPanel.add((Component)new JLabel((String)entry.getValue()), new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 21, 0, new Insets(n == 0 ? 0 : 5, 2, 2, 0), 0, 0));
            JTable jTable = this.createLibrariesTable(arrayList);
            JScrollPane jScrollPane = SwingTools.createScrollPane(jTable);
            jScrollPane.setPreferredSize(new Dimension(Math.round(500.0f * SwingTools.getResolutionScale()), jTable.getTableHeader().getPreferredSize().height + jTable.getRowHeight() * 5 + 3));
            jPanel.add((Component)jScrollPane, new GridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        SwingTools.showMessageDialog(this, jPanel, string, -1);
    }

    private JTable createLibrariesTable(final List<Library> list) {
        int n;
        AbstractTableModel abstractTableModel = new AbstractTableModel(){
            private String[] columnNames;
            {
                this.columnNames = new String[]{HomePane.this.preferences.getLocalizedString(HomePane.class, "libraries.libraryFileColumn", new Object[0]), HomePane.this.preferences.getLocalizedString(HomePane.class, "libraries.libraryNameColumn", new Object[0]), HomePane.this.preferences.getLocalizedString(HomePane.class, "libraries.libraryVersionColumn", new Object[0]), HomePane.this.preferences.getLocalizedString(HomePane.class, "libraries.libraryLicenseColumn", new Object[0]), HomePane.this.preferences.getLocalizedString(HomePane.class, "libraries.libraryProviderColumn", new Object[0])};
            }

            @Override
            public int getRowCount() {
                return list.size();
            }

            @Override
            public int getColumnCount() {
                return this.columnNames.length;
            }

            @Override
            public String getColumnName(int n) {
                return this.columnNames[n];
            }

            @Override
            public Object getValueAt(int n, int n2) {
                Library library = (Library)list.get(n);
                switch (n2) {
                    case 0: {
                        return library.getLocation();
                    }
                    case 1: {
                        return library.getName() != null ? library.getName() : library.getDescription();
                    }
                    case 2: {
                        return library.getVersion();
                    }
                    case 3: {
                        return library.getLicense();
                    }
                    case 4: {
                        return library.getProvider();
                    }
                }
                throw new IllegalArgumentException();
            }
        };
        final JTable jTable = new JTable(abstractTableModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                int n;
                if (this.columnAtPoint(mouseEvent.getPoint()) == 0 && (n = this.rowAtPoint(mouseEvent.getPoint())) >= 0) {
                    return ((Library)list.get(n)).getLocation();
                }
                return null;
            }
        };
        float f = SwingTools.getResolutionScale();
        if (f != 1.0f) {
            jTable.setRowHeight(Math.round((float)jTable.getRowHeight() * f));
        }
        jTable.setAutoResizeMode(0);
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int[] nArray = new int[]{15, 20, 7, 50, 20};
        Font font = new DefaultTableCellRenderer().getFont();
        int n2 = font != null ? this.getFontMetrics(font).getWidths()[65] : 10;
        for (n = 0; n < nArray.length; ++n) {
            tableColumnModel.getColumn(n).setPreferredWidth(nArray[n] * n2);
        }
        n = 0;
        if (OperatingSystem.isJavaVersionGreaterOrEqual("1.6")) {
            try {
                Class<?> clazz = Class.forName("java.awt.Desktop");
                Object object = clazz.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                Class<?> clazz2 = Class.forName("java.awt.Desktop$Action");
                Method method = clazz.getMethod("isSupported", clazz2);
                n = ((Boolean)method.invoke(object, clazz2.getMethod("valueOf", String.class).invoke(null, "OPEN"))).booleanValue() ? 1 : 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        final boolean bl = n != 0 || OperatingSystem.isMacOSX() || OperatingSystem.isLinux();
        tableColumnModel.getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){
            {
                if (bl) {
                    this.setForeground(Color.BLUE);
                }
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl3, boolean bl2, int n, int n2) {
                String string = (String)object;
                try {
                    string = new URL(string).getFile().substring(string.lastIndexOf(47) + 1);
                }
                catch (MalformedURLException malformedURLException) {
                    string = string.substring(string.lastIndexOf(File.separatorChar) + 1);
                }
                super.getTableCellRendererComponent(jTable, string, bl3, bl2, n, n2);
                return this;
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (bl) {
                    Insets insets = this.getInsets();
                    graphics.drawLine(insets.left, this.getHeight() - 1 - insets.bottom, Math.min(this.getPreferredSize().width, this.getWidth()) - insets.right, this.getHeight() - 1 - insets.bottom);
                }
            }
        });
        if (bl) {
            jTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (jTable.columnAtPoint(mouseEvent.getPoint()) == 0 && (n = jTable.rowAtPoint(mouseEvent.getPoint())) >= 0) {
                        String string = ((Library)list.get(n)).getLocation();
                        try {
                            new URL(string);
                        }
                        catch (MalformedURLException malformedURLException) {
                            HomePane.this.showLibraryFolderInSystem(string);
                        }
                    }
                }
            });
        }
        return jTable;
    }

    protected void showLibraryFolderInSystem(String string) {
        File file = new File(string).getParentFile();
        Object object = null;
        Method method = null;
        if (OperatingSystem.isJavaVersionGreaterOrEqual("1.6")) {
            try {
                Class<?> clazz = Class.forName("java.awt.Desktop");
                object = clazz.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                Class<?> clazz2 = Class.forName("java.awt.Desktop$Action");
                Method method2 = clazz.getMethod("isSupported", clazz2);
                if (((Boolean)method2.invoke(object, clazz2.getMethod("valueOf", String.class).invoke(null, "OPEN"))).booleanValue()) {
                    method = clazz.getMethod("open", File.class);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (method != null) {
                method.invoke(object, file);
            } else if (OperatingSystem.isMacOSX()) {
                Runtime.getRuntime().exec(new String[]{"open", file.getAbsolutePath()});
            } else {
                Runtime.getRuntime().exec(new String[]{"xdg-open", file.getAbsolutePath()});
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean showUpdatesMessage(String string, boolean bl) {
        if (!bl) {
            for (Frame frame : Frame.getFrames()) {
                if (frame == SwingUtilities.getWindowAncestor(this)) continue;
                for (Window window : frame.getOwnedWindows()) {
                    if (!window.isShowing() || !(window instanceof Dialog)) continue;
                    return true;
                }
            }
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        final JScrollPane jScrollPane = new JScrollPane(this.createEditorPane(string));
        jScrollPane.setPreferredSize(new Dimension(500, 400));
        jScrollPane.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                jScrollPane.getViewport().setViewPosition(new Point(0, 0));
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, (int)(5.0f * SwingTools.getResolutionScale()), 0), 0, 0));
        JCheckBox jCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(this.preferences, HomePane.class, "doNotDisplayShownUpdatesCheckBox.text", new Object[0]));
        if (!OperatingSystem.isMacOSX()) {
            jCheckBox.setMnemonic(KeyStroke.getKeyStroke(this.preferences.getLocalizedString(HomePane.class, "doNotDisplayShownUpdatesCheckBox.mnemonic", new Object[0])).getKeyCode());
        }
        if (!bl) {
            jPanel.add((Component)jCheckBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        SwingTools.showMessageDialog(this, jPanel, this.preferences.getLocalizedString(HomePane.class, "showUpdatesMessage.title", new Object[0]), -1, jCheckBox);
        return !jCheckBox.isSelected();
    }

    @Override
    public Callable<Void> showPrintDialog() {
        PageFormat pageFormat = HomePrintableComponent.getPageFormat(this.home.getPrint());
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(new HomePrintableComponent(this.home, this.controller, this.getFont()), pageFormat);
        String string = this.preferences.getLocalizedString(HomePane.class, "print.jobName", new Object[0]);
        if (this.home.getName() != null) {
            string = string + " - " + this.controller.getContentManager().getPresentationName(this.home.getName(), ContentManager.ContentType.SWEET_HOME_3D);
        }
        printerJob.setJobName(string);
        if (printerJob.printDialog()) {
            return new Callable<Void>(){
                private List<Selectable> selectedItems;

                @Override
                public Void call() throws RecorderException, InterruptedPrinterException {
                    boolean bl;
                    this.selectedItems = HomePane.this.home.getSelectedItems();
                    boolean bl2 = bl = (HomePane.this.home.getPrint() == null || HomePane.this.home.getPrint().isView3DPrinted()) && HomePane.this.preferences.isEditingIn3DViewEnabled() && !this.selectedItems.isEmpty();
                    if (bl) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                List list = Collections.emptyList();
                                HomePane.this.home.setSelectedItems(list);
                            }
                        });
                        try {
                            EventQueue.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                }
                            });
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                        catch (InterruptedException interruptedException) {
                            throw new InterruptedRecorderException("Print interrupted");
                        }
                    }
                    try {
                        printerJob.print();
                    }
                    catch (InterruptedPrinterException interruptedPrinterException) {
                        throw new InterruptedRecorderException("Print interrupted");
                    }
                    catch (PrinterException printerException) {
                        throw new RecorderException("Couldn't print", printerException);
                    }
                    if (bl) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                HomePane.this.home.setSelectedItems(selectedItems);
                            }
                        });
                    }
                    return null;
                }
            };
        }
        return null;
    }

    @Override
    public String showPrintToPDFDialog(String string) {
        return this.controller.getContentManager().showSaveDialog(this, this.preferences.getLocalizedString(HomePane.class, "printToPDFDialog.title", new Object[0]), ContentManager.ContentType.PDF, string);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void printToPDF(String string) throws RecorderException {
        boolean bl3;
        FileOutputStream fileOutputStream;
        block19: {
            boolean bl2;
            List<Selectable> list = this.home.getSelectedItems();
            boolean bl3 = bl2 = (this.home.getPrint() == null || this.home.getPrint().isView3DPrinted()) && this.preferences.isEditingIn3DViewEnabled() && !list.isEmpty();
            if (bl2) {
                if (EventQueue.isDispatchThread()) {
                    System.out.println("Can't avoid printing selection!");
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            List list = Collections.emptyList();
                            HomePane.this.home.setSelectedItems(list);
                        }
                    });
                    try {
                        EventQueue.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                            }
                        });
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedRecorderException("Print interrupted");
                    }
                }
            }
            fileOutputStream = null;
            bl3 = false;
            try {
                fileOutputStream = new FileOutputStream(string);
                new HomePDFPrinter(this.home, this.preferences, this.controller, this.getFont()).write(fileOutputStream);
                if (!bl2) break block19;
            }
            catch (InterruptedIOException interruptedIOException) {
                try {
                    bl3 = true;
                    throw new InterruptedRecorderException("Print interrupted");
                    catch (IOException iOException) {
                        throw new RecorderException("Couldn't export to PDF", iOException);
                    }
                }
                catch (Throwable throwable) {
                    if (bl2 && !EventQueue.isDispatchThread()) {
                        EventQueue.invokeLater(new Runnable(list){
                            final /* synthetic */ List val$selectedItems;
                            {
                                this.val$selectedItems = list;
                            }

                            @Override
                            public void run() {
                                HomePane.this.home.setSelectedItems(this.val$selectedItems);
                            }
                        });
                    }
                    try {
                        if (fileOutputStream != null) {
                            ((OutputStream)fileOutputStream).close();
                        }
                        if (!bl3) throw throwable;
                        new File(string).delete();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        throw new RecorderException("Couldn't export to PDF", iOException);
                    }
                }
            }
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
        try {
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
            if (!bl3) return;
            new File(string).delete();
            return;
        }
        catch (IOException iOException) {
            throw new RecorderException("Couldn't export to PDF", iOException);
        }
    }

    @Override
    public String showExportToCSVDialog(String string) {
        return this.controller.getContentManager().showSaveDialog(this, this.preferences.getLocalizedString(HomePane.class, "exportToCSVDialog.title", new Object[0]), ContentManager.ContentType.CSV, string);
    }

    @Override
    public void exportToCSV(String string) throws RecorderException {
        View view = this.controller.getFurnitureController().getView();
        ExportableView exportableView = view instanceof ExportableView && ((ExportableView)view).isFormatTypeSupported(ExportableView.FormatType.CSV) ? (ExportableView)view : new FurnitureTable(this.home, this.preferences);
        OutputStream outputStream = null;
        boolean bl = false;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(string));
            exportableView.exportData(outputStream, ExportableView.FormatType.CSV, null);
        }
        catch (InterruptedIOException interruptedIOException) {
            bl = true;
            throw new InterruptedRecorderException("Export to " + string + " interrupted");
        }
        catch (IOException iOException) {
            throw new RecorderException("Couldn't export to CSV in " + string, iOException);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                    if (bl) {
                        new File(string).delete();
                    }
                }
                catch (IOException iOException) {
                    throw new RecorderException("Couldn't export to CSV in " + string, iOException);
                }
            }
        }
    }

    @Override
    public String showExportToSVGDialog(String string) {
        return this.controller.getContentManager().showSaveDialog(this, this.preferences.getLocalizedString(HomePane.class, "exportToSVGDialog.title", new Object[0]), ContentManager.ContentType.SVG, string);
    }

    @Override
    public void exportToSVG(String string) throws RecorderException {
        PlanView planView = this.controller.getPlanController().getView();
        ExportableView exportableView = planView instanceof ExportableView && ((ExportableView)planView).isFormatTypeSupported(ExportableView.FormatType.SVG) ? (ExportableView)planView : new PlanComponent(this.cloneHomeInEventDispatchThread(this.home), this.preferences, null);
        OutputStream outputStream = null;
        boolean bl = false;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(string));
            exportableView.exportData(outputStream, ExportableView.FormatType.SVG, null);
        }
        catch (InterruptedIOException interruptedIOException) {
            bl = true;
            throw new InterruptedRecorderException("Export to " + string + " interrupted");
        }
        catch (IOException iOException) {
            throw new RecorderException("Couldn't export to SVG in " + string, iOException);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                    if (bl) {
                        new File(string).delete();
                    }
                }
                catch (IOException iOException) {
                    throw new RecorderException("Couldn't export to SVG in " + string, iOException);
                }
            }
        }
    }

    @Override
    public String showExportToOBJDialog(String string) {
        string = this.controller.getContentManager().showSaveDialog(this, this.preferences.getLocalizedString(HomePane.class, "exportToOBJDialog.title", new Object[0]), ContentManager.ContentType.OBJ, string);
        this.exportAllToOBJ = true;
        List<Selectable> list = this.home.getSelectedItems();
        if (!(string == null || list.isEmpty() || list.size() <= 1 && list.get(0) instanceof Camera || Home.getDimensionLinesSubList(list).size() >= list.size())) {
            String string2;
            String string3;
            String string4;
            String string5;
            String string6 = this.preferences.getLocalizedString(HomePane.class, "confirmExportAllToOBJ.message", new Object[0]);
            int n = SwingTools.showOptionDialog(this, string6, string5 = this.preferences.getLocalizedString(HomePane.class, "confirmExportAllToOBJ.title", new Object[0]), 1, 3, new Object[]{string4 = this.preferences.getLocalizedString(HomePane.class, "confirmExportAllToOBJ.exportAll", new Object[0]), string3 = this.preferences.getLocalizedString(HomePane.class, "confirmExportAllToOBJ.exportSelection", new Object[0]), string2 = this.preferences.getLocalizedString(HomePane.class, "confirmExportAllToOBJ.cancel", new Object[0])}, string4);
            if (n == 1) {
                this.exportAllToOBJ = false;
            } else if (n != 0) {
                return null;
            }
        }
        return string;
    }

    @Override
    public void exportToOBJ(String string) throws RecorderException {
        View view = this.controller.getHomeController3D().getView();
        Object3DFactory object3DFactory = view instanceof HomeComponent3D ? ((HomeComponent3D)view).getObject3DFactory() : new Object3DBranchFactory();
        this.exportToOBJ(string, object3DFactory);
    }

    protected void exportToOBJ(String string, Object3DFactory object3DFactory) throws RecorderException {
        String string2 = this.preferences != null ? this.preferences.getLocalizedString(HomePane.class, "exportToOBJ.header", new Date()) : "";
        OBJExporter.exportHomeToFile(this.cloneHomeInEventDispatchThread(this.home), string, string2, this.exportAllToOBJ, object3DFactory);
    }

    private Home cloneHomeInEventDispatchThread(final Home home) throws RecorderException {
        if (EventQueue.isDispatchThread()) {
            return home.clone();
        }
        try {
            final AtomicReference atomicReference = new AtomicReference();
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    atomicReference.set(home.clone());
                }
            });
            return (Home)atomicReference.get();
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedRecorderException(interruptedException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RecorderException("Couldn't clone home", invocationTargetException.getCause());
        }
    }

    @Override
    public boolean confirmDeleteCatalogSelection() {
        String string = this.preferences.getLocalizedString(HomePane.class, "confirmDeleteCatalogSelection.message", new Object[0]);
        String string2 = this.preferences.getLocalizedString(HomePane.class, "confirmDeleteCatalogSelection.title", new Object[0]);
        String string3 = this.preferences.getLocalizedString(HomePane.class, "confirmDeleteCatalogSelection.delete", new Object[0]);
        String string4 = this.preferences.getLocalizedString(HomePane.class, "confirmDeleteCatalogSelection.cancel", new Object[0]);
        return SwingTools.showOptionDialog(this, string, string2, 2, 3, new Object[]{string3, string4}, string4) == 0;
    }

    @Override
    public String showStoreCameraDialog(String string) {
        Object object;
        JComponent jComponent;
        JTextComponent jTextComponent;
        String string2 = this.preferences.getLocalizedString(HomePane.class, "showStoreCameraDialog.message", new Object[0]);
        String string3 = this.preferences.getLocalizedString(HomePane.class, "showStoreCameraDialog.title", new Object[0]);
        List<Camera> list = this.home.getStoredCameras();
        if (list.isEmpty()) {
            jTextComponent = new JTextField(string, 20);
            jComponent = jTextComponent;
        } else {
            object = new String[list.size()];
            for (int i = 0; i < ((String[])object).length; ++i) {
                object[i] = list.get(i).getName();
            }
            JComboBox<String> jComboBox = new JComboBox<String>((E[])object);
            jComboBox.setEditable(true);
            jComboBox.getEditor().setItem(string);
            Component component = jComboBox.getEditor().getEditorComponent();
            if (component instanceof JTextComponent) {
                jTextComponent = (JTextComponent)component;
                jComponent = jComboBox;
            } else {
                jTextComponent = new JTextField(string, 20);
                jComponent = jTextComponent;
            }
        }
        if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
            SwingTools.addAutoSelectionOnFocusGain(jTextComponent);
        }
        object = new JPanel(new BorderLayout(2, 2));
        ((Container)object).add((Component)new JLabel(string2), "North");
        ((Container)object).add((Component)jComponent, "South");
        if (SwingTools.showConfirmDialog(this, (JComponent)object, string3, jTextComponent) == 0 && (string = jTextComponent.getText().trim()).length() > 0) {
            return string;
        }
        return null;
    }

    @Override
    public List<Camera> showDeletedCamerasDialog() {
        String string;
        String string2;
        String string3;
        List<Camera> list = this.home.getStoredCameras();
        final ArrayList<Camera> arrayList = new ArrayList<Camera>();
        final JList<Object> jList = new JList<Object>(list.toArray());
        jList.setCellRenderer(new ListCellRenderer(){
            private JCheckBox cameraCheckBox = new JCheckBox();

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.cameraCheckBox.setText(((Camera)object).getName());
                this.cameraCheckBox.setSelected(arrayList.contains(object));
                this.cameraCheckBox.setOpaque(true);
                if (bl && jList.hasFocus()) {
                    this.cameraCheckBox.setBackground(jList.getSelectionBackground());
                    this.cameraCheckBox.setForeground(jList.getSelectionForeground());
                } else {
                    this.cameraCheckBox.setBackground(jList.getBackground());
                    this.cameraCheckBox.setForeground(jList.getForeground());
                }
                return this.cameraCheckBox;
            }
        });
        jList.getInputMap().put(KeyStroke.getKeyStroke("pressed SPACE"), "toggleSelection");
        final AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Camera camera = (Camera)jList.getSelectedValue();
                if (camera != null) {
                    int n = arrayList.indexOf(camera);
                    if (n >= 0) {
                        arrayList.remove(n);
                    } else {
                        arrayList.add(camera);
                    }
                    jList.repaint();
                }
            }
        };
        jList.getActionMap().put("toggleSelection", abstractAction);
        jList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                abstractAction.actionPerformed(null);
            }
        });
        jList.setSelectionMode(0);
        jList.setSelectedIndex(0);
        String string4 = this.preferences.getLocalizedString(HomePane.class, "showDeletedCamerasDialog.message", new Object[0]);
        String string5 = this.preferences.getLocalizedString(HomePane.class, "showDeletedCamerasDialog.title", new Object[0]);
        JPanel jPanel = new JPanel(new BorderLayout(0, (int)(5.0f * SwingTools.getResolutionScale())));
        jPanel.add((Component)new JLabel(string4), "North");
        jPanel.add((Component)SwingTools.createScrollPane(jList), "Center");
        if (SwingTools.showConfirmDialog(this, jPanel, string5, jList) == 0 && arrayList.size() > 0 && SwingTools.showOptionDialog(this, string3 = this.preferences.getLocalizedString(HomePane.class, "confirmDeleteCameras.message", new Object[0]), string5, 2, 3, new Object[]{string2 = this.preferences.getLocalizedString(HomePane.class, "confirmDeleteCameras.delete", new Object[0]), string = this.preferences.getLocalizedString(HomePane.class, "confirmDeleteCameras.cancel", new Object[0])}, string) == 0) {
            return arrayList;
        }
        return null;
    }

    private void addClipboardListener() {
        if (!OperatingSystem.isMacOSX() || OperatingSystem.isJavaVersionGreaterOrEqual("1.8.0_60")) {
            try {
                final FlavorListener flavorListener = new FlavorListener(){

                    @Override
                    public void flavorsChanged(FlavorEvent flavorEvent) {
                        HomePane.this.checkClipboardContainsHomeItemsOrFiles();
                    }
                };
                flavorListener.flavorsChanged(null);
                this.addAncestorListener(new AncestorListener(){

                    @Override
                    public void ancestorAdded(AncestorEvent ancestorEvent) {
                        HomePane.this.getToolkit().getSystemClipboard().addFlavorListener(flavorListener);
                    }

                    @Override
                    public void ancestorRemoved(AncestorEvent ancestorEvent) {
                        HomePane.this.getToolkit().getSystemClipboard().removeFlavorListener(flavorListener);
                    }

                    @Override
                    public void ancestorMoved(AncestorEvent ancestorEvent) {
                    }
                });
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isClipboardEmpty() {
        if (OperatingSystem.isMacOSX() && !OperatingSystem.isJavaVersionGreaterOrEqual("1.8.0_60")) {
            try {
                this.checkClipboardContainsHomeItemsOrFiles();
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        return this.clipboardEmpty;
    }

    private void checkClipboardContainsHomeItemsOrFiles() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        this.clipboardEmpty = !clipboard.isDataFlavorAvailable(HomeTransferableList.HOME_FLAVOR) && !clipboard.isDataFlavorAvailable(DataFlavor.javaFileListFlavor);
    }

    @Override
    public List<Selectable> getClipboardItems() {
        try {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            if (clipboard.isDataFlavorAvailable(HomeTransferableList.HOME_FLAVOR)) {
                return (List)clipboard.getData(HomeTransferableList.HOME_FLAVOR);
            }
        }
        catch (AccessControlException accessControlException) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    private static abstract class PopupMenuListenerWithMouseLocation
    implements PopupMenuListener {
        private Point mouseLocation;
        private Point lastMouseMoveLocation;

        public PopupMenuListenerWithMouseLocation(JComponent jComponent) {
            jComponent.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    PopupMenuListenerWithMouseLocation.this.lastMouseMoveLocation = mouseEvent.getPoint();
                }
            });
            jComponent.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    PopupMenuListenerWithMouseLocation.this.lastMouseMoveLocation = null;
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    PopupMenuListenerWithMouseLocation.this.lastMouseMoveLocation = mouseEvent.getPoint();
                }
            });
        }

        protected Point getMouseLocation() {
            return this.mouseLocation;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            this.mouseLocation = this.lastMouseMoveLocation;
        }
    }

    private static interface SelectableFormat<T extends Selectable> {
        public String format(T var1);
    }

    private class ActionAdapter
    implements Action {
        private PluginAction pluginAction;
        private SwingPropertyChangeSupport propertyChangeSupport;

        private ActionAdapter(PluginAction pluginAction) {
            this.pluginAction = pluginAction;
            this.propertyChangeSupport = new SwingPropertyChangeSupport(this);
            this.pluginAction.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = propertyChangeEvent.getOldValue();
                    Object object2 = propertyChangeEvent.getNewValue();
                    if (PluginAction.Property.ENABLED.name().equals(string)) {
                        ActionAdapter.this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(propertyChangeEvent.getSource(), "enabled", object, object2));
                    } else if (object2 != null) {
                        if (PluginAction.Property.NAME.name().equals(string)) {
                            ActionAdapter.this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(propertyChangeEvent.getSource(), "Name", object, object2));
                        } else if (PluginAction.Property.SHORT_DESCRIPTION.name().equals(string)) {
                            ActionAdapter.this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(propertyChangeEvent.getSource(), "ShortDescription", object, object2));
                        } else if (PluginAction.Property.MNEMONIC.name().equals(string)) {
                            ActionAdapter.this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(propertyChangeEvent.getSource(), "MnemonicKey", object != null ? new Integer(((Character)object).charValue()) : null, object2));
                        } else if (PluginAction.Property.SMALL_ICON.name().equals(string)) {
                            ActionAdapter.this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(propertyChangeEvent.getSource(), "SmallIcon", object != null ? IconManager.getInstance().getIcon((Content)object, DEFAULT_SMALL_ICON_HEIGHT, HomePane.this) : null, object2));
                        } else {
                            ActionAdapter.this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(propertyChangeEvent.getSource(), string, object, object2));
                        }
                    }
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.pluginAction.execute();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }

        @Override
        public Object getValue(String string) {
            if ("Name".equals(string)) {
                return this.pluginAction.getPropertyValue(PluginAction.Property.NAME);
            }
            if ("ShortDescription".equals(string)) {
                return this.pluginAction.getPropertyValue(PluginAction.Property.SHORT_DESCRIPTION);
            }
            if ("SmallIcon".equals(string)) {
                Content content = (Content)this.pluginAction.getPropertyValue(PluginAction.Property.SMALL_ICON);
                return content != null ? IconManager.getInstance().getIcon(content, DEFAULT_SMALL_ICON_HEIGHT, HomePane.this) : null;
            }
            if ("MnemonicKey".equals(string)) {
                Character c = (Character)this.pluginAction.getPropertyValue(PluginAction.Property.MNEMONIC);
                return c != null ? new Integer(c.charValue()) : null;
            }
            if (PluginAction.Property.TOOL_BAR.name().equals(string)) {
                return this.pluginAction.getPropertyValue(PluginAction.Property.TOOL_BAR);
            }
            if (PluginAction.Property.MENU.name().equals(string)) {
                return this.pluginAction.getPropertyValue(PluginAction.Property.MENU);
            }
            return null;
        }

        @Override
        public void putValue(String string, Object object) {
            if ("Name".equals(string)) {
                this.pluginAction.putPropertyValue(PluginAction.Property.NAME, object);
            } else if ("ShortDescription".equals(string)) {
                this.pluginAction.putPropertyValue(PluginAction.Property.SHORT_DESCRIPTION, object);
            } else if (!"SmallIcon".equals(string)) {
                if ("MnemonicKey".equals(string)) {
                    this.pluginAction.putPropertyValue(PluginAction.Property.MNEMONIC, new Character((char)((Integer)object).intValue()));
                } else if (PluginAction.Property.TOOL_BAR.name().equals(string)) {
                    this.pluginAction.putPropertyValue(PluginAction.Property.TOOL_BAR, object);
                } else if (PluginAction.Property.MENU.name().equals(string)) {
                    this.pluginAction.putPropertyValue(PluginAction.Property.MENU, object);
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return this.pluginAction.isEnabled();
        }

        @Override
        public void setEnabled(boolean bl) {
            this.pluginAction.setEnabled(bl);
        }
    }

    private static class OBJExporter {
        private OBJExporter() {
        }

        public static void exportHomeToFile(Home home, String string, String string2, boolean bl, Object3DFactory object3DFactory) throws RecorderException {
            OBJWriter oBJWriter = null;
            boolean bl2 = false;
            try {
                Object object;
                oBJWriter = new OBJWriter(string, string2, -1);
                ArrayList<Selectable> arrayList = new ArrayList<Selectable>(bl ? home.getSelectableViewableItems() : home.getSelectedItems());
                ArrayList<HomePieceOfFurniture> arrayList2 = new ArrayList<HomePieceOfFurniture>();
                Object object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    object = (Selectable)object2.next();
                    if (!(object instanceof HomeFurnitureGroup)) continue;
                    object2.remove();
                    for (HomePieceOfFurniture homePieceOfFurniture : ((HomeFurnitureGroup)object).getAllFurniture()) {
                        if (homePieceOfFurniture instanceof HomeFurnitureGroup) continue;
                        arrayList2.add(homePieceOfFurniture);
                    }
                }
                arrayList.addAll(arrayList2);
                object2 = Collections.emptyList();
                home.setSelectedItems((List<? extends Selectable>)object2);
                if (bl) {
                    object = OBJExporter.getExportedHomeBounds(home);
                    if (object != null) {
                        Ground3D ground3D = new Ground3D(home, (float)((RectangularShape)object).getX(), (float)((RectangularShape)object).getY(), (float)((RectangularShape)object).getWidth(), (float)((RectangularShape)object).getHeight(), true);
                        oBJWriter.writeNode((Node)ground3D, "ground");
                    }
                } else if (home.isAllLevelsSelection()) {
                    for (Level level : home.getLevels()) {
                        if (!level.isViewable()) continue;
                        level.setVisible(true);
                    }
                }
                int n = 0;
                for (Selectable selectable : arrayList) {
                    Node node = (Node)object3DFactory.createObject3D(home, selectable, true);
                    if (node == null) continue;
                    if (selectable instanceof HomePieceOfFurniture) {
                        oBJWriter.writeNode(node);
                        continue;
                    }
                    if (selectable instanceof DimensionLine) continue;
                    oBJWriter.writeNode(node, selectable.getClass().getSimpleName().toLowerCase() + "_" + ++n);
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                bl2 = true;
                throw new InterruptedRecorderException("Export to " + string + " interrupted");
            }
            catch (IOException iOException) {
                throw new RecorderException("Couldn't export to OBJ in " + string, iOException);
            }
            finally {
                if (oBJWriter != null) {
                    try {
                        oBJWriter.close();
                        if (bl2) {
                            new File(string).delete();
                        }
                    }
                    catch (IOException iOException) {
                        throw new RecorderException("Couldn't export to OBJ in " + string, iOException);
                    }
                }
            }
        }

        private static Rectangle2D getExportedHomeBounds(Home home) {
            Rectangle2D rectangle2D = OBJExporter.updateObjectsBounds(null, home.getWalls());
            for (HomePieceOfFurniture homePieceOfFurniture : OBJExporter.getVisibleFurniture(home.getFurniture())) {
                for (float[] fArray : homePieceOfFurniture.getPoints()) {
                    if (rectangle2D == null) {
                        rectangle2D = new Rectangle2D.Float(fArray[0], fArray[1], 0.0f, 0.0f);
                        continue;
                    }
                    rectangle2D.add(fArray[0], fArray[1]);
                }
            }
            return OBJExporter.updateObjectsBounds(rectangle2D, home.getRooms());
        }

        private static List<HomePieceOfFurniture> getVisibleFurniture(List<HomePieceOfFurniture> list) {
            ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>(list.size());
            for (HomePieceOfFurniture homePieceOfFurniture : list) {
                if (!homePieceOfFurniture.isVisible() || homePieceOfFurniture.getLevel() != null && !homePieceOfFurniture.getLevel().isViewable()) continue;
                if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                    arrayList.addAll(OBJExporter.getVisibleFurniture(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()));
                    continue;
                }
                arrayList.add(homePieceOfFurniture);
            }
            return arrayList;
        }

        private static Rectangle2D updateObjectsBounds(Rectangle2D rectangle2D, Collection<? extends Selectable> collection) {
            for (Selectable selectable : collection) {
                if (selectable instanceof Elevatable && ((Elevatable)((Object)selectable)).getLevel() != null && !((Elevatable)((Object)selectable)).getLevel().isViewableAndVisible()) continue;
                for (float[] fArray : selectable.getPoints()) {
                    if (rectangle2D == null) {
                        rectangle2D = new Rectangle2D.Float(fArray[0], fArray[1], 0.0f, 0.0f);
                        continue;
                    }
                    rectangle2D.add(fArray[0], fArray[1]);
                }
            }
            return rectangle2D;
        }
    }

    private static class RulersVisibilityChangeListener
    implements PropertyChangeListener {
        private WeakReference<HomePane> homePane;
        private WeakReference<JScrollPane> planScrollPane;
        private WeakReference<HomeController> controller;

        public RulersVisibilityChangeListener(HomePane homePane, JScrollPane jScrollPane, HomeController homeController) {
            this.homePane = new WeakReference<HomePane>(homePane);
            this.planScrollPane = new WeakReference<JScrollPane>(jScrollPane);
            this.controller = new WeakReference<HomeController>(homeController);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HomePane homePane = (HomePane)this.homePane.get();
            JScrollPane jScrollPane = (JScrollPane)this.planScrollPane.get();
            HomeController homeController = (HomeController)this.controller.get();
            if (homePane == null || jScrollPane == null || homeController == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.RULERS_VISIBLE, this);
            } else {
                homePane.setPlanRulersVisible(jScrollPane, homeController, (Boolean)propertyChangeEvent.getNewValue());
            }
        }
    }

    private static class FurnitureCatalogViewChangeListener
    implements PropertyChangeListener {
        private WeakReference<HomePane> homePane;
        private WeakReference<JComponent> furnitureCatalogView;

        public FurnitureCatalogViewChangeListener(HomePane homePane, JComponent jComponent) {
            this.homePane = new WeakReference<HomePane>(homePane);
            this.furnitureCatalogView = new WeakReference<JComponent>(jComponent);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HomePane homePane = (HomePane)this.homePane.get();
            if (homePane == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.FURNITURE_CATALOG_VIEWED_IN_TREE, this);
            } else {
                JComponent jComponent = (JComponent)this.furnitureCatalogView.get();
                if (jComponent != null) {
                    boolean bl = homePane.transferHandlerEnabled;
                    homePane.setTransferEnabled(false);
                    JComponent jComponent2 = (JComponent)((Object)homePane.controller.getFurnitureCatalogController().getView());
                    jComponent2.setComponentPopupMenu(jComponent.getComponentPopupMenu());
                    homePane.setTransferEnabled(bl);
                    JComponent jComponent3 = jComponent2;
                    jComponent3 = jComponent2 instanceof Scrollable ? SwingTools.createScrollPane(jComponent2) : jComponent2;
                    ((JSplitPane)SwingUtilities.getAncestorOfClass(JSplitPane.class, jComponent)).setTopComponent(jComponent3);
                    jComponent2.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
                    this.furnitureCatalogView = new WeakReference<JComponent>(jComponent2);
                }
            }
        }
    }

    private static class MagnetismChangeListener
    implements PropertyChangeListener {
        private WeakReference<HomePane> homePane;
        private WeakReference<JButton> enableDisableMagnetismButton;

        public MagnetismChangeListener(HomePane homePane, JButton jButton) {
            this.enableDisableMagnetismButton = new WeakReference<JButton>(jButton);
            this.homePane = new WeakReference<HomePane>(homePane);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HomePane homePane = (HomePane)this.homePane.get();
            JButton jButton = (JButton)this.enableDisableMagnetismButton.get();
            UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
            UserPreferences.Property property = UserPreferences.Property.valueOf(propertyChangeEvent.getPropertyName());
            if (homePane == null || jButton == null) {
                userPreferences.removePropertyChangeListener(property, this);
            } else {
                jButton.setAction(new ResourceAction.ToolBarAction(userPreferences.isMagnetismEnabled() ? homePane.getActionMap().get((Object)HomeView.ActionType.DISABLE_MAGNETISM) : homePane.getActionMap().get((Object)HomeView.ActionType.ENABLE_MAGNETISM)));
            }
        }
    }

    private static class FocusOwnerChangeListener
    implements PropertyChangeListener {
        private WeakReference<HomePane> homePane;

        private FocusOwnerChangeListener(HomePane homePane) {
            this.homePane = new WeakReference<HomePane>(homePane);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HomePane homePane = (HomePane)this.homePane.get();
            if (homePane == null) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this);
            } else {
                Component component;
                if (homePane.lastFocusedComponent != null && SwingUtilities.isDescendingFrom(component = homePane.lastFocusedComponent, SwingUtilities.getWindowAncestor(homePane))) {
                    component.removeKeyListener(homePane.specialKeysListener);
                    if (homePane.previousPlanControllerMode != null && (component == homePane.controller.getPlanController().getView() || propertyChangeEvent.getNewValue() == null)) {
                        homePane.controller.getPlanController().setMode(homePane.previousPlanControllerMode);
                        homePane.previousPlanControllerMode = null;
                    }
                }
                if (propertyChangeEvent.getNewValue() != null && SwingUtilities.isDescendingFrom(component = (Component)propertyChangeEvent.getNewValue(), SwingUtilities.getWindowAncestor(homePane)) && component instanceof JComponent) {
                    View[] viewArray;
                    for (View view : viewArray = new View[]{homePane.controller.getFurnitureCatalogController().getView(), homePane.controller.getFurnitureController().getView(), homePane.controller.getPlanController().getView(), homePane.controller.getHomeController3D().getView()}) {
                        if (view == null || !SwingUtilities.isDescendingFrom(component, (JComponent)((Object)view))) continue;
                        homePane.controller.focusedViewChanged(view);
                        component.addKeyListener(homePane.specialKeysListener);
                        homePane.lastFocusedComponent = (JComponent)component;
                        break;
                    }
                }
            }
        }
    }

    private static class FocusCycleRootChangeListener
    implements PropertyChangeListener {
        private WeakReference<HomePane> homePane;
        private PropertyChangeListener focusChangeListener;

        public FocusCycleRootChangeListener(HomePane homePane) {
            this.homePane = new WeakReference<HomePane>(homePane);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HomePane homePane = (HomePane)this.homePane.get();
            if (homePane == null) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("currentFocusCycleRoot", this);
            } else if (SwingUtilities.isDescendingFrom(homePane, (Component)propertyChangeEvent.getOldValue())) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this.focusChangeListener);
                this.focusChangeListener = null;
            } else if (SwingUtilities.isDescendingFrom(homePane, (Component)propertyChangeEvent.getNewValue())) {
                this.focusChangeListener = new FocusOwnerChangeListener(homePane);
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.focusChangeListener);
            }
        }
    }

    private static class UserPreferencesChangeListener
    implements PropertyChangeListener {
        private WeakReference<HomePane> homePane;

        public UserPreferencesChangeListener(HomePane homePane) {
            this.homePane = new WeakReference<HomePane>(homePane);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HomePane homePane = (HomePane)this.homePane.get();
            UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
            UserPreferences.Property property = UserPreferences.Property.valueOf(propertyChangeEvent.getPropertyName());
            if (homePane == null) {
                userPreferences.removePropertyChangeListener(property, this);
            } else {
                ActionMap actionMap = homePane.getActionMap();
                switch (property) {
                    case LANGUAGE: {
                        SwingTools.updateSwingResourceLanguage((UserPreferences)propertyChangeEvent.getSource());
                        break;
                    }
                    case CURRENCY: {
                        actionMap.get((Object)HomeView.ActionType.DISPLAY_HOME_FURNITURE_PRICE).putValue("Visible", propertyChangeEvent.getNewValue() != null);
                        actionMap.get((Object)HomeView.ActionType.SORT_HOME_FURNITURE_BY_PRICE).putValue("Visible", propertyChangeEvent.getNewValue() != null);
                        break;
                    }
                    case VALUE_ADDED_TAX_ENABLED: {
                        actionMap.get((Object)HomeView.ActionType.DISPLAY_HOME_FURNITURE_VALUE_ADDED_TAX_PERCENTAGE).putValue("Visible", Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
                        actionMap.get((Object)HomeView.ActionType.DISPLAY_HOME_FURNITURE_VALUE_ADDED_TAX).putValue("Visible", Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
                        actionMap.get((Object)HomeView.ActionType.DISPLAY_HOME_FURNITURE_PRICE_VALUE_ADDED_TAX_INCLUDED).putValue("Visible", Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
                        actionMap.get((Object)HomeView.ActionType.SORT_HOME_FURNITURE_BY_VALUE_ADDED_TAX_PERCENTAGE).putValue("Visible", Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
                        actionMap.get((Object)HomeView.ActionType.SORT_HOME_FURNITURE_BY_VALUE_ADDED_TAX).putValue("Visible", Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
                        actionMap.get((Object)HomeView.ActionType.SORT_HOME_FURNITURE_BY_PRICE_VALUE_ADDED_TAX_INCLUDED).putValue("Visible", Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
                        break;
                    }
                    case EDITING_IN_3D_VIEW_ENABLED: {
                        JComponent jComponent = (JComponent)((Object)homePane.controller.getHomeController3D().getView());
                        if (jComponent == null) break;
                        jComponent.setTransferHandler(userPreferences.isEditingIn3DViewEnabled() ? homePane.view3DTransferHandler : null);
                    }
                }
            }
        }
    }

    private static enum MenuActionType {
        FILE_MENU,
        EDIT_MENU,
        FURNITURE_MENU,
        PLAN_MENU,
        VIEW_3D_MENU,
        HELP_MENU,
        OPEN_RECENT_HOME_MENU,
        ALIGN_OR_DISTRIBUTE_MENU,
        SORT_HOME_FURNITURE_MENU,
        DISPLAY_HOME_FURNITURE_PROPERTY_MENU,
        MODIFY_TEXT_STYLE,
        LEVELS_MENU,
        GO_TO_POINT_OF_VIEW,
        SELECT_OBJECT_MENU,
        TOGGLE_SELECTION_MENU;

    }
}

