// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from LPC800_v0.3.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/NXP

//go:build nxp && lpc800

// LPC800
//

package nxp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "LPC800"
	CPU          = "CM0"
	FPUPresent   = false
	NVICPrioBits = 2
)

// Interrupt numbers.
const (
	// SPI
	IRQ_SPI0 = 0

	IRQ_SPI1 = 1

	// USART
	IRQ_UART0 = 3

	IRQ_UART1 = 4

	IRQ_UART2 = 5

	// I2C-bus interface
	IRQ_I2C = 8

	// State Configurable Timer (SCT)
	IRQ_SCT = 9

	// Multi-Rate Timer (MRT)
	IRQ_MRT = 10

	// Analog comparator
	IRQ_CMP = 11

	// Windowed Watchdog Timer (WWDT)
	IRQ_WDT = 12

	// System configuration (SYSCON)
	IRQ_BOD = 13

	// Flash controller
	IRQ_FLASH_IRQ = 14

	// Self wake-up timer (WKT)
	IRQ_WKT = 15

	// Pin interrupt and pattern match engine
	IRQ_PININT0 = 24

	// Pin interrupt and pattern match engine
	IRQ_PININT1 = 25

	// Pin interrupt and pattern match engine
	IRQ_PININT2 = 26

	// Pin interrupt and pattern match engine
	IRQ_PININT3 = 27

	// Pin interrupt and pattern match engine
	IRQ_PININT4 = 28

	// Pin interrupt and pattern match engine
	IRQ_PININT5 = 29

	// Pin interrupt and pattern match engine
	IRQ_PININT6 = 30

	// Pin interrupt and pattern match engine
	IRQ_PININT7 = 31

	// Highest interrupt number on this device.
	IRQ_max = 31
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export SPI0_IRQHandler
func interruptSPI0() {
	callHandlers(IRQ_SPI0)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export UART0_IRQHandler
func interruptUART0() {
	callHandlers(IRQ_UART0)
}

//export UART1_IRQHandler
func interruptUART1() {
	callHandlers(IRQ_UART1)
}

//export UART2_IRQHandler
func interruptUART2() {
	callHandlers(IRQ_UART2)
}

//export I2C_IRQHandler
func interruptI2C() {
	callHandlers(IRQ_I2C)
}

//export SCT_IRQHandler
func interruptSCT() {
	callHandlers(IRQ_SCT)
}

//export MRT_IRQHandler
func interruptMRT() {
	callHandlers(IRQ_MRT)
}

//export CMP_IRQHandler
func interruptCMP() {
	callHandlers(IRQ_CMP)
}

//export WDT_IRQHandler
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export BOD_IRQHandler
func interruptBOD() {
	callHandlers(IRQ_BOD)
}

//export FLASH_IRQ_IRQHandler
func interruptFLASH_IRQ() {
	callHandlers(IRQ_FLASH_IRQ)
}

//export WKT_IRQHandler
func interruptWKT() {
	callHandlers(IRQ_WKT)
}

//export PININT0_IRQHandler
func interruptPININT0() {
	callHandlers(IRQ_PININT0)
}

//export PININT1_IRQHandler
func interruptPININT1() {
	callHandlers(IRQ_PININT1)
}

//export PININT2_IRQHandler
func interruptPININT2() {
	callHandlers(IRQ_PININT2)
}

//export PININT3_IRQHandler
func interruptPININT3() {
	callHandlers(IRQ_PININT3)
}

//export PININT4_IRQHandler
func interruptPININT4() {
	callHandlers(IRQ_PININT4)
}

//export PININT5_IRQHandler
func interruptPININT5() {
	callHandlers(IRQ_PININT5)
}

//export PININT6_IRQHandler
func interruptPININT6() {
	callHandlers(IRQ_PININT6)
}

//export PININT7_IRQHandler
func interruptPININT7() {
	callHandlers(IRQ_PININT7)
}

// Peripherals.
var (
	// Windowed Watchdog Timer (WWDT)
	WWDT = (*WWDT_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Multi-Rate Timer (MRT)
	MRT = (*MRT_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Self wake-up timer (WKT)
	WKT = (*WKT_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Switch matrix (SWM)
	SWM = (*SWM_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// Power Management Unit (PMU)
	PMU = (*PMU_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Analog comparator
	CMP = (*CMP_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// Flash controller
	FLASHCTRL = (*FLASHCTRL_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// I/O configuration (IOCON)
	IOCON = (*IOCON_Type)(unsafe.Pointer(uintptr(0x40044000)))

	// System configuration (SYSCON)
	SYSCON = (*SYSCON_Type)(unsafe.Pointer(uintptr(0x40048000)))

	// I2C-bus interface
	I2C = (*I2C_Type)(unsafe.Pointer(uintptr(0x40050000)))

	// SPI
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40058000)))

	// USART
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0x40064000)))

	// Cyclic Redundancy Check (CRC) engine
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// State Configurable Timer (SCT)
	SCT = (*SCT_Type)(unsafe.Pointer(uintptr(0x50004000)))

	// General Purpose I/O port (GPIO)
	GPIO_PORT = (*GPIO_PORT_Type)(unsafe.Pointer(uintptr(0xa0000000)))

	// Pin interrupt and pattern match engine
	PIN_INT = (*GPIO_PIN_INT_Type)(unsafe.Pointer(uintptr(0xa0004000)))

	// SPI
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x4005c000)))

	// USART
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40068000)))

	// USART
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x4006c000)))
)

// Windowed Watchdog Timer (WWDT)
type WWDT_Type struct {
	MOD     volatile.Register32 // 0x0
	TC      volatile.Register32 // 0x4
	FEED    volatile.Register32 // 0x8
	TV      volatile.Register32 // 0xC
	_       [4]byte
	WARNINT volatile.Register32 // 0x14
	WINDOW  volatile.Register32 // 0x18
}

// WWDT.MOD: Watchdog mode register. This register contains the basic mode and status of the Watchdog Timer.
func (o *WWDT_Type) SetMOD_WDEN(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x1)|value)
}
func (o *WWDT_Type) GetMOD_WDEN() uint32 {
	return volatile.LoadUint32(&o.MOD.Reg) & 0x1
}
func (o *WWDT_Type) SetMOD_WDRESET(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x2)|value<<1)
}
func (o *WWDT_Type) GetMOD_WDRESET() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x2) >> 1
}
func (o *WWDT_Type) SetMOD_WDTOF(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x4)|value<<2)
}
func (o *WWDT_Type) GetMOD_WDTOF() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x4) >> 2
}
func (o *WWDT_Type) SetMOD_WDINT(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x8)|value<<3)
}
func (o *WWDT_Type) GetMOD_WDINT() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x8) >> 3
}
func (o *WWDT_Type) SetMOD_WDPROTECT(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x10)|value<<4)
}
func (o *WWDT_Type) GetMOD_WDPROTECT() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x10) >> 4
}
func (o *WWDT_Type) SetMOD_LOCK(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x20)|value<<5)
}
func (o *WWDT_Type) GetMOD_LOCK() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x20) >> 5
}
func (o *WWDT_Type) SetMOD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0xffffffc0)|value<<6)
}
func (o *WWDT_Type) GetMOD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0xffffffc0) >> 6
}

// WWDT.TC: Watchdog timer constant register. This 24-bit register determines the time-out value.
func (o *WWDT_Type) SetTC_COUNT(value uint32) {
	volatile.StoreUint32(&o.TC.Reg, volatile.LoadUint32(&o.TC.Reg)&^(0xffffff)|value)
}
func (o *WWDT_Type) GetTC_COUNT() uint32 {
	return volatile.LoadUint32(&o.TC.Reg) & 0xffffff
}
func (o *WWDT_Type) SetTC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TC.Reg, volatile.LoadUint32(&o.TC.Reg)&^(0xff000000)|value<<24)
}
func (o *WWDT_Type) GetTC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TC.Reg) & 0xff000000) >> 24
}

// WWDT.FEED: Watchdog feed sequence register. Writing 0xAA followed by 0x55 to this register reloads the Watchdog timer with the value contained in WDTC.
func (o *WWDT_Type) SetFEED(value uint32) {
	volatile.StoreUint32(&o.FEED.Reg, volatile.LoadUint32(&o.FEED.Reg)&^(0xff)|value)
}
func (o *WWDT_Type) GetFEED() uint32 {
	return volatile.LoadUint32(&o.FEED.Reg) & 0xff
}
func (o *WWDT_Type) SetFEED_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FEED.Reg, volatile.LoadUint32(&o.FEED.Reg)&^(0xffffff00)|value<<8)
}
func (o *WWDT_Type) GetFEED_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FEED.Reg) & 0xffffff00) >> 8
}

// WWDT.TV: Watchdog timer value register. This 24-bit register reads out the current value of the Watchdog timer.
func (o *WWDT_Type) SetTV_COUNT(value uint32) {
	volatile.StoreUint32(&o.TV.Reg, volatile.LoadUint32(&o.TV.Reg)&^(0xffffff)|value)
}
func (o *WWDT_Type) GetTV_COUNT() uint32 {
	return volatile.LoadUint32(&o.TV.Reg) & 0xffffff
}
func (o *WWDT_Type) SetTV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TV.Reg, volatile.LoadUint32(&o.TV.Reg)&^(0xff000000)|value<<24)
}
func (o *WWDT_Type) GetTV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TV.Reg) & 0xff000000) >> 24
}

// WWDT.WARNINT: Watchdog Warning Interrupt compare value.
func (o *WWDT_Type) SetWARNINT(value uint32) {
	volatile.StoreUint32(&o.WARNINT.Reg, volatile.LoadUint32(&o.WARNINT.Reg)&^(0x3ff)|value)
}
func (o *WWDT_Type) GetWARNINT() uint32 {
	return volatile.LoadUint32(&o.WARNINT.Reg) & 0x3ff
}
func (o *WWDT_Type) SetWARNINT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.WARNINT.Reg, volatile.LoadUint32(&o.WARNINT.Reg)&^(0xfffffc00)|value<<10)
}
func (o *WWDT_Type) GetWARNINT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.WARNINT.Reg) & 0xfffffc00) >> 10
}

// WWDT.WINDOW: Watchdog Window compare value.
func (o *WWDT_Type) SetWINDOW(value uint32) {
	volatile.StoreUint32(&o.WINDOW.Reg, volatile.LoadUint32(&o.WINDOW.Reg)&^(0xffffff)|value)
}
func (o *WWDT_Type) GetWINDOW() uint32 {
	return volatile.LoadUint32(&o.WINDOW.Reg) & 0xffffff
}
func (o *WWDT_Type) SetWINDOW_RESERVED(value uint32) {
	volatile.StoreUint32(&o.WINDOW.Reg, volatile.LoadUint32(&o.WINDOW.Reg)&^(0xff000000)|value<<24)
}
func (o *WWDT_Type) GetWINDOW_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.WINDOW.Reg) & 0xff000000) >> 24
}

// Multi-Rate Timer (MRT)
type MRT_Type struct {
	INTVAL0  volatile.Register32 // 0x0
	TIMER0   volatile.Register32 // 0x4
	CTRL0    volatile.Register32 // 0x8
	STAT0    volatile.Register32 // 0xC
	INTVAL1  volatile.Register32 // 0x10
	TIMER1   volatile.Register32 // 0x14
	CTRL1    volatile.Register32 // 0x18
	STAT1    volatile.Register32 // 0x1C
	INTVAL2  volatile.Register32 // 0x20
	TIMER2   volatile.Register32 // 0x24
	CTRL2    volatile.Register32 // 0x28
	STAT2    volatile.Register32 // 0x2C
	INTVAL3  volatile.Register32 // 0x30
	TIMER3   volatile.Register32 // 0x34
	CTRL3    volatile.Register32 // 0x38
	STAT3    volatile.Register32 // 0x3C
	_        [180]byte
	IDLE_CH  volatile.Register32 // 0xF4
	IRQ_FLAG volatile.Register32 // 0xF8
}

// MRT.INTVAL0: MRT0 Time interval value register. This value is loaded into the TIMER0 register.
func (o *MRT_Type) SetINTVAL0_IVALUE(value uint32) {
	volatile.StoreUint32(&o.INTVAL0.Reg, volatile.LoadUint32(&o.INTVAL0.Reg)&^(0xffffff)|value)
}
func (o *MRT_Type) GetINTVAL0_IVALUE() uint32 {
	return volatile.LoadUint32(&o.INTVAL0.Reg) & 0xffffff
}
func (o *MRT_Type) SetINTVAL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTVAL0.Reg, volatile.LoadUint32(&o.INTVAL0.Reg)&^(0x7f000000)|value<<24)
}
func (o *MRT_Type) GetINTVAL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTVAL0.Reg) & 0x7f000000) >> 24
}
func (o *MRT_Type) SetINTVAL0_LOAD(value uint32) {
	volatile.StoreUint32(&o.INTVAL0.Reg, volatile.LoadUint32(&o.INTVAL0.Reg)&^(0x80000000)|value<<31)
}
func (o *MRT_Type) GetINTVAL0_LOAD() uint32 {
	return (volatile.LoadUint32(&o.INTVAL0.Reg) & 0x80000000) >> 31
}

// MRT.TIMER0: MRT0 Timer register. This register reads the value of the down-counter.
func (o *MRT_Type) SetTIMER0_VALUE(value uint32) {
	volatile.StoreUint32(&o.TIMER0.Reg, volatile.LoadUint32(&o.TIMER0.Reg)&^(0xffffff)|value)
}
func (o *MRT_Type) GetTIMER0_VALUE() uint32 {
	return volatile.LoadUint32(&o.TIMER0.Reg) & 0xffffff
}
func (o *MRT_Type) SetTIMER0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TIMER0.Reg, volatile.LoadUint32(&o.TIMER0.Reg)&^(0xff000000)|value<<24)
}
func (o *MRT_Type) GetTIMER0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TIMER0.Reg) & 0xff000000) >> 24
}

// MRT.CTRL0: MRT0 Control register. This register controls the MRT0 modes.
func (o *MRT_Type) SetCTRL0_INTEN(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0x1)|value)
}
func (o *MRT_Type) GetCTRL0_INTEN() uint32 {
	return volatile.LoadUint32(&o.CTRL0.Reg) & 0x1
}
func (o *MRT_Type) SetCTRL0_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0x6)|value<<1)
}
func (o *MRT_Type) GetCTRL0_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRL0.Reg) & 0x6) >> 1
}
func (o *MRT_Type) SetCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0xfffffff8)|value<<3)
}
func (o *MRT_Type) GetCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL0.Reg) & 0xfffffff8) >> 3
}

// MRT.STAT0: MRT0 Status register.
func (o *MRT_Type) SetSTAT0_INTFLAG(value uint32) {
	volatile.StoreUint32(&o.STAT0.Reg, volatile.LoadUint32(&o.STAT0.Reg)&^(0x1)|value)
}
func (o *MRT_Type) GetSTAT0_INTFLAG() uint32 {
	return volatile.LoadUint32(&o.STAT0.Reg) & 0x1
}
func (o *MRT_Type) SetSTAT0_RUN(value uint32) {
	volatile.StoreUint32(&o.STAT0.Reg, volatile.LoadUint32(&o.STAT0.Reg)&^(0x2)|value<<1)
}
func (o *MRT_Type) GetSTAT0_RUN() uint32 {
	return (volatile.LoadUint32(&o.STAT0.Reg) & 0x2) >> 1
}
func (o *MRT_Type) SetSTAT0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT0.Reg, volatile.LoadUint32(&o.STAT0.Reg)&^(0xfffffffc)|value<<2)
}
func (o *MRT_Type) GetSTAT0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT0.Reg) & 0xfffffffc) >> 2
}

// MRT.INTVAL1: MRT0 Time interval value register. This value is loaded into the TIMER0 register.
func (o *MRT_Type) SetINTVAL1_IVALUE(value uint32) {
	volatile.StoreUint32(&o.INTVAL1.Reg, volatile.LoadUint32(&o.INTVAL1.Reg)&^(0xffffff)|value)
}
func (o *MRT_Type) GetINTVAL1_IVALUE() uint32 {
	return volatile.LoadUint32(&o.INTVAL1.Reg) & 0xffffff
}
func (o *MRT_Type) SetINTVAL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTVAL1.Reg, volatile.LoadUint32(&o.INTVAL1.Reg)&^(0x7f000000)|value<<24)
}
func (o *MRT_Type) GetINTVAL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTVAL1.Reg) & 0x7f000000) >> 24
}
func (o *MRT_Type) SetINTVAL1_LOAD(value uint32) {
	volatile.StoreUint32(&o.INTVAL1.Reg, volatile.LoadUint32(&o.INTVAL1.Reg)&^(0x80000000)|value<<31)
}
func (o *MRT_Type) GetINTVAL1_LOAD() uint32 {
	return (volatile.LoadUint32(&o.INTVAL1.Reg) & 0x80000000) >> 31
}

// MRT.TIMER1: MRT0 Timer register. This register reads the value of the down-counter.
func (o *MRT_Type) SetTIMER1_VALUE(value uint32) {
	volatile.StoreUint32(&o.TIMER1.Reg, volatile.LoadUint32(&o.TIMER1.Reg)&^(0xffffff)|value)
}
func (o *MRT_Type) GetTIMER1_VALUE() uint32 {
	return volatile.LoadUint32(&o.TIMER1.Reg) & 0xffffff
}
func (o *MRT_Type) SetTIMER1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TIMER1.Reg, volatile.LoadUint32(&o.TIMER1.Reg)&^(0xff000000)|value<<24)
}
func (o *MRT_Type) GetTIMER1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TIMER1.Reg) & 0xff000000) >> 24
}

// MRT.CTRL1: MRT0 Control register. This register controls the MRT0 modes.
func (o *MRT_Type) SetCTRL1_INTEN(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x1)|value)
}
func (o *MRT_Type) GetCTRL1_INTEN() uint32 {
	return volatile.LoadUint32(&o.CTRL1.Reg) & 0x1
}
func (o *MRT_Type) SetCTRL1_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x6)|value<<1)
}
func (o *MRT_Type) GetCTRL1_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x6) >> 1
}
func (o *MRT_Type) SetCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0xfffffff8)|value<<3)
}
func (o *MRT_Type) GetCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0xfffffff8) >> 3
}

// MRT.STAT1: MRT0 Status register.
func (o *MRT_Type) SetSTAT1_INTFLAG(value uint32) {
	volatile.StoreUint32(&o.STAT1.Reg, volatile.LoadUint32(&o.STAT1.Reg)&^(0x1)|value)
}
func (o *MRT_Type) GetSTAT1_INTFLAG() uint32 {
	return volatile.LoadUint32(&o.STAT1.Reg) & 0x1
}
func (o *MRT_Type) SetSTAT1_RUN(value uint32) {
	volatile.StoreUint32(&o.STAT1.Reg, volatile.LoadUint32(&o.STAT1.Reg)&^(0x2)|value<<1)
}
func (o *MRT_Type) GetSTAT1_RUN() uint32 {
	return (volatile.LoadUint32(&o.STAT1.Reg) & 0x2) >> 1
}
func (o *MRT_Type) SetSTAT1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT1.Reg, volatile.LoadUint32(&o.STAT1.Reg)&^(0xfffffffc)|value<<2)
}
func (o *MRT_Type) GetSTAT1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT1.Reg) & 0xfffffffc) >> 2
}

// MRT.INTVAL2: MRT0 Time interval value register. This value is loaded into the TIMER0 register.
func (o *MRT_Type) SetINTVAL2_IVALUE(value uint32) {
	volatile.StoreUint32(&o.INTVAL2.Reg, volatile.LoadUint32(&o.INTVAL2.Reg)&^(0xffffff)|value)
}
func (o *MRT_Type) GetINTVAL2_IVALUE() uint32 {
	return volatile.LoadUint32(&o.INTVAL2.Reg) & 0xffffff
}
func (o *MRT_Type) SetINTVAL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTVAL2.Reg, volatile.LoadUint32(&o.INTVAL2.Reg)&^(0x7f000000)|value<<24)
}
func (o *MRT_Type) GetINTVAL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTVAL2.Reg) & 0x7f000000) >> 24
}
func (o *MRT_Type) SetINTVAL2_LOAD(value uint32) {
	volatile.StoreUint32(&o.INTVAL2.Reg, volatile.LoadUint32(&o.INTVAL2.Reg)&^(0x80000000)|value<<31)
}
func (o *MRT_Type) GetINTVAL2_LOAD() uint32 {
	return (volatile.LoadUint32(&o.INTVAL2.Reg) & 0x80000000) >> 31
}

// MRT.TIMER2: MRT0 Timer register. This register reads the value of the down-counter.
func (o *MRT_Type) SetTIMER2_VALUE(value uint32) {
	volatile.StoreUint32(&o.TIMER2.Reg, volatile.LoadUint32(&o.TIMER2.Reg)&^(0xffffff)|value)
}
func (o *MRT_Type) GetTIMER2_VALUE() uint32 {
	return volatile.LoadUint32(&o.TIMER2.Reg) & 0xffffff
}
func (o *MRT_Type) SetTIMER2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TIMER2.Reg, volatile.LoadUint32(&o.TIMER2.Reg)&^(0xff000000)|value<<24)
}
func (o *MRT_Type) GetTIMER2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TIMER2.Reg) & 0xff000000) >> 24
}

// MRT.CTRL2: MRT0 Control register. This register controls the MRT0 modes.
func (o *MRT_Type) SetCTRL2_INTEN(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x1)|value)
}
func (o *MRT_Type) GetCTRL2_INTEN() uint32 {
	return volatile.LoadUint32(&o.CTRL2.Reg) & 0x1
}
func (o *MRT_Type) SetCTRL2_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x6)|value<<1)
}
func (o *MRT_Type) GetCTRL2_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x6) >> 1
}
func (o *MRT_Type) SetCTRL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0xfffffff8)|value<<3)
}
func (o *MRT_Type) GetCTRL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0xfffffff8) >> 3
}

// MRT.STAT2: MRT0 Status register.
func (o *MRT_Type) SetSTAT2_INTFLAG(value uint32) {
	volatile.StoreUint32(&o.STAT2.Reg, volatile.LoadUint32(&o.STAT2.Reg)&^(0x1)|value)
}
func (o *MRT_Type) GetSTAT2_INTFLAG() uint32 {
	return volatile.LoadUint32(&o.STAT2.Reg) & 0x1
}
func (o *MRT_Type) SetSTAT2_RUN(value uint32) {
	volatile.StoreUint32(&o.STAT2.Reg, volatile.LoadUint32(&o.STAT2.Reg)&^(0x2)|value<<1)
}
func (o *MRT_Type) GetSTAT2_RUN() uint32 {
	return (volatile.LoadUint32(&o.STAT2.Reg) & 0x2) >> 1
}
func (o *MRT_Type) SetSTAT2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT2.Reg, volatile.LoadUint32(&o.STAT2.Reg)&^(0xfffffffc)|value<<2)
}
func (o *MRT_Type) GetSTAT2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT2.Reg) & 0xfffffffc) >> 2
}

// MRT.INTVAL3: MRT0 Time interval value register. This value is loaded into the TIMER0 register.
func (o *MRT_Type) SetINTVAL3_IVALUE(value uint32) {
	volatile.StoreUint32(&o.INTVAL3.Reg, volatile.LoadUint32(&o.INTVAL3.Reg)&^(0xffffff)|value)
}
func (o *MRT_Type) GetINTVAL3_IVALUE() uint32 {
	return volatile.LoadUint32(&o.INTVAL3.Reg) & 0xffffff
}
func (o *MRT_Type) SetINTVAL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTVAL3.Reg, volatile.LoadUint32(&o.INTVAL3.Reg)&^(0x7f000000)|value<<24)
}
func (o *MRT_Type) GetINTVAL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTVAL3.Reg) & 0x7f000000) >> 24
}
func (o *MRT_Type) SetINTVAL3_LOAD(value uint32) {
	volatile.StoreUint32(&o.INTVAL3.Reg, volatile.LoadUint32(&o.INTVAL3.Reg)&^(0x80000000)|value<<31)
}
func (o *MRT_Type) GetINTVAL3_LOAD() uint32 {
	return (volatile.LoadUint32(&o.INTVAL3.Reg) & 0x80000000) >> 31
}

// MRT.TIMER3: MRT0 Timer register. This register reads the value of the down-counter.
func (o *MRT_Type) SetTIMER3_VALUE(value uint32) {
	volatile.StoreUint32(&o.TIMER3.Reg, volatile.LoadUint32(&o.TIMER3.Reg)&^(0xffffff)|value)
}
func (o *MRT_Type) GetTIMER3_VALUE() uint32 {
	return volatile.LoadUint32(&o.TIMER3.Reg) & 0xffffff
}
func (o *MRT_Type) SetTIMER3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TIMER3.Reg, volatile.LoadUint32(&o.TIMER3.Reg)&^(0xff000000)|value<<24)
}
func (o *MRT_Type) GetTIMER3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TIMER3.Reg) & 0xff000000) >> 24
}

// MRT.CTRL3: MRT0 Control register. This register controls the MRT0 modes.
func (o *MRT_Type) SetCTRL3_INTEN(value uint32) {
	volatile.StoreUint32(&o.CTRL3.Reg, volatile.LoadUint32(&o.CTRL3.Reg)&^(0x1)|value)
}
func (o *MRT_Type) GetCTRL3_INTEN() uint32 {
	return volatile.LoadUint32(&o.CTRL3.Reg) & 0x1
}
func (o *MRT_Type) SetCTRL3_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRL3.Reg, volatile.LoadUint32(&o.CTRL3.Reg)&^(0x6)|value<<1)
}
func (o *MRT_Type) GetCTRL3_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRL3.Reg) & 0x6) >> 1
}
func (o *MRT_Type) SetCTRL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL3.Reg, volatile.LoadUint32(&o.CTRL3.Reg)&^(0xfffffff8)|value<<3)
}
func (o *MRT_Type) GetCTRL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL3.Reg) & 0xfffffff8) >> 3
}

// MRT.STAT3: MRT0 Status register.
func (o *MRT_Type) SetSTAT3_INTFLAG(value uint32) {
	volatile.StoreUint32(&o.STAT3.Reg, volatile.LoadUint32(&o.STAT3.Reg)&^(0x1)|value)
}
func (o *MRT_Type) GetSTAT3_INTFLAG() uint32 {
	return volatile.LoadUint32(&o.STAT3.Reg) & 0x1
}
func (o *MRT_Type) SetSTAT3_RUN(value uint32) {
	volatile.StoreUint32(&o.STAT3.Reg, volatile.LoadUint32(&o.STAT3.Reg)&^(0x2)|value<<1)
}
func (o *MRT_Type) GetSTAT3_RUN() uint32 {
	return (volatile.LoadUint32(&o.STAT3.Reg) & 0x2) >> 1
}
func (o *MRT_Type) SetSTAT3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT3.Reg, volatile.LoadUint32(&o.STAT3.Reg)&^(0xfffffffc)|value<<2)
}
func (o *MRT_Type) GetSTAT3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT3.Reg) & 0xfffffffc) >> 2
}

// MRT.IDLE_CH: Idle channel register. This register returns the number of the first idle channel.
func (o *MRT_Type) SetIDLE_CH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IDLE_CH.Reg, volatile.LoadUint32(&o.IDLE_CH.Reg)&^(0xf)|value)
}
func (o *MRT_Type) GetIDLE_CH_RESERVED() uint32 {
	return volatile.LoadUint32(&o.IDLE_CH.Reg) & 0xf
}
func (o *MRT_Type) SetIDLE_CH_CHAN(value uint32) {
	volatile.StoreUint32(&o.IDLE_CH.Reg, volatile.LoadUint32(&o.IDLE_CH.Reg)&^(0xf0)|value<<4)
}
func (o *MRT_Type) GetIDLE_CH_CHAN() uint32 {
	return (volatile.LoadUint32(&o.IDLE_CH.Reg) & 0xf0) >> 4
}
func (o *MRT_Type) SetIDLE_CH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IDLE_CH.Reg, volatile.LoadUint32(&o.IDLE_CH.Reg)&^(0xffffff00)|value<<8)
}
func (o *MRT_Type) GetIDLE_CH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IDLE_CH.Reg) & 0xffffff00) >> 8
}

// MRT.IRQ_FLAG: Global interrupt flag register
func (o *MRT_Type) SetIRQ_FLAG_GFLAG0(value uint32) {
	volatile.StoreUint32(&o.IRQ_FLAG.Reg, volatile.LoadUint32(&o.IRQ_FLAG.Reg)&^(0x1)|value)
}
func (o *MRT_Type) GetIRQ_FLAG_GFLAG0() uint32 {
	return volatile.LoadUint32(&o.IRQ_FLAG.Reg) & 0x1
}
func (o *MRT_Type) SetIRQ_FLAG_GFLAG1(value uint32) {
	volatile.StoreUint32(&o.IRQ_FLAG.Reg, volatile.LoadUint32(&o.IRQ_FLAG.Reg)&^(0x2)|value<<1)
}
func (o *MRT_Type) GetIRQ_FLAG_GFLAG1() uint32 {
	return (volatile.LoadUint32(&o.IRQ_FLAG.Reg) & 0x2) >> 1
}
func (o *MRT_Type) SetIRQ_FLAG_GFLAG2(value uint32) {
	volatile.StoreUint32(&o.IRQ_FLAG.Reg, volatile.LoadUint32(&o.IRQ_FLAG.Reg)&^(0x4)|value<<2)
}
func (o *MRT_Type) GetIRQ_FLAG_GFLAG2() uint32 {
	return (volatile.LoadUint32(&o.IRQ_FLAG.Reg) & 0x4) >> 2
}
func (o *MRT_Type) SetIRQ_FLAG_GFLAG3(value uint32) {
	volatile.StoreUint32(&o.IRQ_FLAG.Reg, volatile.LoadUint32(&o.IRQ_FLAG.Reg)&^(0x8)|value<<3)
}
func (o *MRT_Type) GetIRQ_FLAG_GFLAG3() uint32 {
	return (volatile.LoadUint32(&o.IRQ_FLAG.Reg) & 0x8) >> 3
}
func (o *MRT_Type) SetIRQ_FLAG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IRQ_FLAG.Reg, volatile.LoadUint32(&o.IRQ_FLAG.Reg)&^(0xfffffff0)|value<<4)
}
func (o *MRT_Type) GetIRQ_FLAG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IRQ_FLAG.Reg) & 0xfffffff0) >> 4
}

// Self wake-up timer (WKT)
type WKT_Type struct {
	CTRL  volatile.Register32 // 0x0
	_     [8]byte
	COUNT volatile.Register32 // 0xC
}

// WKT.CTRL: Self wake-up timer control register.
func (o *WKT_Type) SetCTRL_CLKSEL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *WKT_Type) GetCTRL_CLKSEL() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *WKT_Type) SetCTRL_ALARMFLAG(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *WKT_Type) GetCTRL_ALARMFLAG() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *WKT_Type) SetCTRL_CLEARCTR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *WKT_Type) GetCTRL_CLEARCTR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *WKT_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xfffffff8)|value<<3)
}
func (o *WKT_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xfffffff8) >> 3
}

// WKT.COUNT: Counter register.
func (o *WKT_Type) SetCOUNT(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, value)
}
func (o *WKT_Type) GetCOUNT() uint32 {
	return volatile.LoadUint32(&o.COUNT.Reg)
}

// Switch matrix (SWM)
type SWM_Type struct {
	PINASSIGN0 volatile.Register32 // 0x0
	PINASSIGN1 volatile.Register32 // 0x4
	PINASSIGN2 volatile.Register32 // 0x8
	PINASSIGN3 volatile.Register32 // 0xC
	PINASSIGN4 volatile.Register32 // 0x10
	PINASSIGN5 volatile.Register32 // 0x14
	PINASSIGN6 volatile.Register32 // 0x18
	PINASSIGN7 volatile.Register32 // 0x1C
	PINASSIGN8 volatile.Register32 // 0x20
	_          [412]byte
	PINENABLE0 volatile.Register32 // 0x1C0
}

// SWM.PINASSIGN0: Pin assign register 0. Assign movable functions U0_TXD, U0_RXD, U0_RTS, U0_CTS
func (o *SWM_Type) SetPINASSIGN0_U0_TXD_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN0.Reg, volatile.LoadUint32(&o.PINASSIGN0.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN0_U0_TXD_O() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN0.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN0_U0_RXD_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN0.Reg, volatile.LoadUint32(&o.PINASSIGN0.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN0_U0_RXD_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN0.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN0_U0_RTS_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN0.Reg, volatile.LoadUint32(&o.PINASSIGN0.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN0_U0_RTS_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN0.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN0_U0_CTS_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN0.Reg, volatile.LoadUint32(&o.PINASSIGN0.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN0_U0_CTS_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN0.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN1: Pin assign register 1. Assign movable functions U0_SCLC, U1_TXD, U1_RXD
func (o *SWM_Type) SetPINASSIGN1_U0_SCLK_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN1.Reg, volatile.LoadUint32(&o.PINASSIGN1.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN1_U0_SCLK_IO() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN1.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN1_U1_TXD_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN1.Reg, volatile.LoadUint32(&o.PINASSIGN1.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN1_U1_TXD_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN1.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN1_U1_RXD_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN1.Reg, volatile.LoadUint32(&o.PINASSIGN1.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN1_U1_RXD_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN1.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN1_U1_RTS_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN1.Reg, volatile.LoadUint32(&o.PINASSIGN1.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN1_U1_RTS_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN1.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN2: Pin assign register 2. Assign movable functions U2_TXD, U2_RXD
func (o *SWM_Type) SetPINASSIGN2_U1_CTS_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN2.Reg, volatile.LoadUint32(&o.PINASSIGN2.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN2_U1_CTS_I() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN2.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN2_U1_SCLK_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN2.Reg, volatile.LoadUint32(&o.PINASSIGN2.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN2_U1_SCLK_IO() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN2.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN2_U2_TXD_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN2.Reg, volatile.LoadUint32(&o.PINASSIGN2.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN2_U2_TXD_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN2.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN2_U2_RXD_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN2.Reg, volatile.LoadUint32(&o.PINASSIGN2.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN2_U2_RXD_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN2.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN3: Pin assignregister 3. Assign movable function SPI0_SCK
func (o *SWM_Type) SetPINASSIGN3_U2_RTS_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN3.Reg, volatile.LoadUint32(&o.PINASSIGN3.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN3_U2_RTS_O() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN3.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN3_U2_CTS_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN3.Reg, volatile.LoadUint32(&o.PINASSIGN3.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN3_U2_CTS_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN3.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN3_U2_SCLK_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN3.Reg, volatile.LoadUint32(&o.PINASSIGN3.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN3_U2_SCLK_IO() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN3.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN3_SPI0_SCK_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN3.Reg, volatile.LoadUint32(&o.PINASSIGN3.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN3_SPI0_SCK_IO() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN3.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN4: Pin assign register 4. Assign movable functions SPI0_MOSI, SPI0_MISO, SPI0_SSEL, SPI1_SCK
func (o *SWM_Type) SetPINASSIGN4_SPI0_MOSI_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN4.Reg, volatile.LoadUint32(&o.PINASSIGN4.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN4_SPI0_MOSI_IO() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN4.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN4_SPI0_MISO_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN4.Reg, volatile.LoadUint32(&o.PINASSIGN4.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN4_SPI0_MISO_IO() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN4.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN4_SPI0_SSEL_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN4.Reg, volatile.LoadUint32(&o.PINASSIGN4.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN4_SPI0_SSEL_IO() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN4.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN4_SPI1_SCK_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN4.Reg, volatile.LoadUint32(&o.PINASSIGN4.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN4_SPI1_SCK_IO() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN4.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN5: Pin assign register 5. Assign movable functions SPI1_MOSI, SPI1_MISO, SPI1_SSEL, CTIN_0
func (o *SWM_Type) SetPINASSIGN5_SPI1_MOSI_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN5.Reg, volatile.LoadUint32(&o.PINASSIGN5.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN5_SPI1_MOSI_IO() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN5.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN5_SPI1_MISO_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN5.Reg, volatile.LoadUint32(&o.PINASSIGN5.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN5_SPI1_MISO_IO() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN5.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN5_SPI1_SSEL_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN5.Reg, volatile.LoadUint32(&o.PINASSIGN5.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN5_SPI1_SSEL_IO() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN5.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN5_CTIN_0_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN5.Reg, volatile.LoadUint32(&o.PINASSIGN5.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN5_CTIN_0_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN5.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN6: Pin assign register 6. Assign movable functions CTIN_1, CTIN_2, CTIN_3, CTOUT_0
func (o *SWM_Type) SetPINASSIGN6_CTIN_1_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN6.Reg, volatile.LoadUint32(&o.PINASSIGN6.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN6_CTIN_1_I() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN6.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN6_CTIN_2_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN6.Reg, volatile.LoadUint32(&o.PINASSIGN6.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN6_CTIN_2_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN6.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN6_CTIN_3_I(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN6.Reg, volatile.LoadUint32(&o.PINASSIGN6.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN6_CTIN_3_I() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN6.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN6_CTOUT_0_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN6.Reg, volatile.LoadUint32(&o.PINASSIGN6.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN6_CTOUT_0_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN6.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN7: Pin assign egister 7. Assign movable functions CTOUT_1, CTOUT_2, CTOUT_3, I2C_SDA
func (o *SWM_Type) SetPINASSIGN7_CTOUT_1_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN7.Reg, volatile.LoadUint32(&o.PINASSIGN7.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN7_CTOUT_1_O() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN7.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN7_CTOUT_2_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN7.Reg, volatile.LoadUint32(&o.PINASSIGN7.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN7_CTOUT_2_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN7.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN7_CTOUT_3_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN7.Reg, volatile.LoadUint32(&o.PINASSIGN7.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN7_CTOUT_3_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN7.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN7_I2C_SDA_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN7.Reg, volatile.LoadUint32(&o.PINASSIGN7.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN7_I2C_SDA_IO() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN7.Reg) & 0xff000000) >> 24
}

// SWM.PINASSIGN8: Pin assign register 8. Assign movable functions I2C_SCL, ACMP_O, CLKOUT, GPIO_INT_BMAT
func (o *SWM_Type) SetPINASSIGN8_I2C_SCL_IO(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN8.Reg, volatile.LoadUint32(&o.PINASSIGN8.Reg)&^(0xff)|value)
}
func (o *SWM_Type) GetPINASSIGN8_I2C_SCL_IO() uint32 {
	return volatile.LoadUint32(&o.PINASSIGN8.Reg) & 0xff
}
func (o *SWM_Type) SetPINASSIGN8_ACMP_O_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN8.Reg, volatile.LoadUint32(&o.PINASSIGN8.Reg)&^(0xff00)|value<<8)
}
func (o *SWM_Type) GetPINASSIGN8_ACMP_O_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN8.Reg) & 0xff00) >> 8
}
func (o *SWM_Type) SetPINASSIGN8_CLKOUT_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN8.Reg, volatile.LoadUint32(&o.PINASSIGN8.Reg)&^(0xff0000)|value<<16)
}
func (o *SWM_Type) GetPINASSIGN8_CLKOUT_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN8.Reg) & 0xff0000) >> 16
}
func (o *SWM_Type) SetPINASSIGN8_GPIO_INT_BMAT_O(value uint32) {
	volatile.StoreUint32(&o.PINASSIGN8.Reg, volatile.LoadUint32(&o.PINASSIGN8.Reg)&^(0xff000000)|value<<24)
}
func (o *SWM_Type) GetPINASSIGN8_GPIO_INT_BMAT_O() uint32 {
	return (volatile.LoadUint32(&o.PINASSIGN8.Reg) & 0xff000000) >> 24
}

// SWM.PINENABLE0: Pin enable register 0. Enables fixed-pin functions ACMP_I0, ACMP_I1, SWCLK, SWDIO, XTALIN, XTALOUT, RESET, CLKIN, VDDCMP
func (o *SWM_Type) SetPINENABLE0_ACMP_I1_EN(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x1)|value)
}
func (o *SWM_Type) GetPINENABLE0_ACMP_I1_EN() uint32 {
	return volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x1
}
func (o *SWM_Type) SetPINENABLE0_ACMP_I2_EN(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x2)|value<<1)
}
func (o *SWM_Type) GetPINENABLE0_ACMP_I2_EN() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x2) >> 1
}
func (o *SWM_Type) SetPINENABLE0_SWCLK_EN(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x4)|value<<2)
}
func (o *SWM_Type) GetPINENABLE0_SWCLK_EN() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x4) >> 2
}
func (o *SWM_Type) SetPINENABLE0_SWDIO_EN(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x8)|value<<3)
}
func (o *SWM_Type) GetPINENABLE0_SWDIO_EN() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x8) >> 3
}
func (o *SWM_Type) SetPINENABLE0_XTALIN_EN(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x10)|value<<4)
}
func (o *SWM_Type) GetPINENABLE0_XTALIN_EN() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x10) >> 4
}
func (o *SWM_Type) SetPINENABLE0_XTALOUT_EN(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x20)|value<<5)
}
func (o *SWM_Type) GetPINENABLE0_XTALOUT_EN() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x20) >> 5
}
func (o *SWM_Type) SetPINENABLE0_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x40)|value<<6)
}
func (o *SWM_Type) GetPINENABLE0_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x40) >> 6
}
func (o *SWM_Type) SetPINENABLE0_CLKIN(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x80)|value<<7)
}
func (o *SWM_Type) GetPINENABLE0_CLKIN() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x80) >> 7
}
func (o *SWM_Type) SetPINENABLE0_VDDCMP(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0x100)|value<<8)
}
func (o *SWM_Type) GetPINENABLE0_VDDCMP() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0x100) >> 8
}
func (o *SWM_Type) SetPINENABLE0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINENABLE0.Reg, volatile.LoadUint32(&o.PINENABLE0.Reg)&^(0xfffffe00)|value<<9)
}
func (o *SWM_Type) GetPINENABLE0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINENABLE0.Reg) & 0xfffffe00) >> 9
}

// Power Management Unit (PMU)
type PMU_Type struct {
	PCON    volatile.Register32 // 0x0
	GPREG0  volatile.Register32 // 0x4
	GPREG1  volatile.Register32 // 0x8
	GPREG2  volatile.Register32 // 0xC
	GPREG3  volatile.Register32 // 0x10
	DPDCTRL volatile.Register32 // 0x14
}

// PMU.PCON: Power control register
func (o *PMU_Type) SetPCON_PM(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x7)|value)
}
func (o *PMU_Type) GetPCON_PM() uint32 {
	return volatile.LoadUint32(&o.PCON.Reg) & 0x7
}
func (o *PMU_Type) SetPCON_NODPD(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x8)|value<<3)
}
func (o *PMU_Type) GetPCON_NODPD() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0x8) >> 3
}
func (o *PMU_Type) SetPCON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0xf0)|value<<4)
}
func (o *PMU_Type) GetPCON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0xf0) >> 4
}
func (o *PMU_Type) SetPCON_SLEEPFLAG(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x100)|value<<8)
}
func (o *PMU_Type) GetPCON_SLEEPFLAG() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0x100) >> 8
}
func (o *PMU_Type) SetPCON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x600)|value<<9)
}
func (o *PMU_Type) GetPCON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0x600) >> 9
}
func (o *PMU_Type) SetPCON_DPDFLAG(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x800)|value<<11)
}
func (o *PMU_Type) GetPCON_DPDFLAG() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0x800) >> 11
}
func (o *PMU_Type) SetPCON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0xfffff000)|value<<12)
}
func (o *PMU_Type) GetPCON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0xfffff000) >> 12
}

// PMU.GPREG0: General purpose register 0
func (o *PMU_Type) SetGPREG0(value uint32) {
	volatile.StoreUint32(&o.GPREG0.Reg, value)
}
func (o *PMU_Type) GetGPREG0() uint32 {
	return volatile.LoadUint32(&o.GPREG0.Reg)
}

// PMU.GPREG1: General purpose register 0
func (o *PMU_Type) SetGPREG1(value uint32) {
	volatile.StoreUint32(&o.GPREG1.Reg, value)
}
func (o *PMU_Type) GetGPREG1() uint32 {
	return volatile.LoadUint32(&o.GPREG1.Reg)
}

// PMU.GPREG2: General purpose register 0
func (o *PMU_Type) SetGPREG2(value uint32) {
	volatile.StoreUint32(&o.GPREG2.Reg, value)
}
func (o *PMU_Type) GetGPREG2() uint32 {
	return volatile.LoadUint32(&o.GPREG2.Reg)
}

// PMU.GPREG3: General purpose register 0
func (o *PMU_Type) SetGPREG3(value uint32) {
	volatile.StoreUint32(&o.GPREG3.Reg, value)
}
func (o *PMU_Type) GetGPREG3() uint32 {
	return volatile.LoadUint32(&o.GPREG3.Reg)
}

// PMU.DPDCTRL: Deep power-down control register
func (o *PMU_Type) SetDPDCTRL_WAKEUPHYS(value uint32) {
	volatile.StoreUint32(&o.DPDCTRL.Reg, volatile.LoadUint32(&o.DPDCTRL.Reg)&^(0x1)|value)
}
func (o *PMU_Type) GetDPDCTRL_WAKEUPHYS() uint32 {
	return volatile.LoadUint32(&o.DPDCTRL.Reg) & 0x1
}
func (o *PMU_Type) SetDPDCTRL_WAKEPAD_DISABLE(value uint32) {
	volatile.StoreUint32(&o.DPDCTRL.Reg, volatile.LoadUint32(&o.DPDCTRL.Reg)&^(0x2)|value<<1)
}
func (o *PMU_Type) GetDPDCTRL_WAKEPAD_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.DPDCTRL.Reg) & 0x2) >> 1
}
func (o *PMU_Type) SetDPDCTRL_LPOSCEN(value uint32) {
	volatile.StoreUint32(&o.DPDCTRL.Reg, volatile.LoadUint32(&o.DPDCTRL.Reg)&^(0x4)|value<<2)
}
func (o *PMU_Type) GetDPDCTRL_LPOSCEN() uint32 {
	return (volatile.LoadUint32(&o.DPDCTRL.Reg) & 0x4) >> 2
}
func (o *PMU_Type) SetDPDCTRL_LPOSCDPDEN(value uint32) {
	volatile.StoreUint32(&o.DPDCTRL.Reg, volatile.LoadUint32(&o.DPDCTRL.Reg)&^(0x8)|value<<3)
}
func (o *PMU_Type) GetDPDCTRL_LPOSCDPDEN() uint32 {
	return (volatile.LoadUint32(&o.DPDCTRL.Reg) & 0x8) >> 3
}
func (o *PMU_Type) SetDPDCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DPDCTRL.Reg, volatile.LoadUint32(&o.DPDCTRL.Reg)&^(0xfffffff0)|value<<4)
}
func (o *PMU_Type) GetDPDCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DPDCTRL.Reg) & 0xfffffff0) >> 4
}

// Analog comparator
type CMP_Type struct {
	CTRL volatile.Register32 // 0x0
	LAD  volatile.Register32 // 0x4
}

// CMP.CTRL: Comparator control register
func (o *CMP_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x7)|value)
}
func (o *CMP_Type) GetCTRL_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x7
}
func (o *CMP_Type) SetCTRL_EDGESEL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x18)|value<<3)
}
func (o *CMP_Type) GetCTRL_EDGESEL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x18) >> 3
}
func (o *CMP_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20)|value<<5)
}
func (o *CMP_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20) >> 5
}
func (o *CMP_Type) SetCTRL_COMPSA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40)|value<<6)
}
func (o *CMP_Type) GetCTRL_COMPSA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40) >> 6
}
func (o *CMP_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *CMP_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80) >> 7
}
func (o *CMP_Type) SetCTRL_COMP_VP_SEL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x700)|value<<8)
}
func (o *CMP_Type) GetCTRL_COMP_VP_SEL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x700) >> 8
}
func (o *CMP_Type) SetCTRL_COMP_VM_SEL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x3800)|value<<11)
}
func (o *CMP_Type) GetCTRL_COMP_VM_SEL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x3800) >> 11
}
func (o *CMP_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xfc000)|value<<14)
}
func (o *CMP_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xfc000) >> 14
}
func (o *CMP_Type) SetCTRL_EDGECLR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *CMP_Type) GetCTRL_EDGECLR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100000) >> 20
}
func (o *CMP_Type) SetCTRL_COMPSTAT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200000)|value<<21)
}
func (o *CMP_Type) GetCTRL_COMPSTAT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200000) >> 21
}
func (o *CMP_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *CMP_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x400000) >> 22
}
func (o *CMP_Type) SetCTRL_COMPEDGE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *CMP_Type) GetCTRL_COMPEDGE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800000) >> 23
}
func (o *CMP_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *CMP_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1000000) >> 24
}
func (o *CMP_Type) SetCTRL_HYS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x6000000)|value<<25)
}
func (o *CMP_Type) GetCTRL_HYS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x6000000) >> 25
}
func (o *CMP_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xf8000000)|value<<27)
}
func (o *CMP_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xf8000000) >> 27
}

// CMP.LAD: Voltage ladder register
func (o *CMP_Type) SetLAD_LADEN(value uint32) {
	volatile.StoreUint32(&o.LAD.Reg, volatile.LoadUint32(&o.LAD.Reg)&^(0x1)|value)
}
func (o *CMP_Type) GetLAD_LADEN() uint32 {
	return volatile.LoadUint32(&o.LAD.Reg) & 0x1
}
func (o *CMP_Type) SetLAD_LADSEL(value uint32) {
	volatile.StoreUint32(&o.LAD.Reg, volatile.LoadUint32(&o.LAD.Reg)&^(0x3e)|value<<1)
}
func (o *CMP_Type) GetLAD_LADSEL() uint32 {
	return (volatile.LoadUint32(&o.LAD.Reg) & 0x3e) >> 1
}
func (o *CMP_Type) SetLAD_LADREF(value uint32) {
	volatile.StoreUint32(&o.LAD.Reg, volatile.LoadUint32(&o.LAD.Reg)&^(0x40)|value<<6)
}
func (o *CMP_Type) GetLAD_LADREF() uint32 {
	return (volatile.LoadUint32(&o.LAD.Reg) & 0x40) >> 6
}
func (o *CMP_Type) SetLAD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LAD.Reg, volatile.LoadUint32(&o.LAD.Reg)&^(0xffffff80)|value<<7)
}
func (o *CMP_Type) GetLAD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LAD.Reg) & 0xffffff80) >> 7
}

// Flash controller
type FLASHCTRL_Type struct {
	_        [16]byte
	FLASHCFG volatile.Register32 // 0x10
	_        [12]byte
	FMSSTART volatile.Register32 // 0x20
	FMSSTOP  volatile.Register32 // 0x24
	_        [4]byte
	FMSW0    volatile.Register32 // 0x2C
}

// FLASHCTRL.FLASHCFG: Flash configuration register
func (o *FLASHCTRL_Type) SetFLASHCFG_FLASHTIM(value uint32) {
	volatile.StoreUint32(&o.FLASHCFG.Reg, volatile.LoadUint32(&o.FLASHCFG.Reg)&^(0x3)|value)
}
func (o *FLASHCTRL_Type) GetFLASHCFG_FLASHTIM() uint32 {
	return volatile.LoadUint32(&o.FLASHCFG.Reg) & 0x3
}
func (o *FLASHCTRL_Type) SetFLASHCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FLASHCFG.Reg, volatile.LoadUint32(&o.FLASHCFG.Reg)&^(0xfffffffc)|value<<2)
}
func (o *FLASHCTRL_Type) GetFLASHCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FLASHCFG.Reg) & 0xfffffffc) >> 2
}

// FLASHCTRL.FMSSTART: Signature start address register
func (o *FLASHCTRL_Type) SetFMSSTART_START(value uint32) {
	volatile.StoreUint32(&o.FMSSTART.Reg, volatile.LoadUint32(&o.FMSSTART.Reg)&^(0x1ffff)|value)
}
func (o *FLASHCTRL_Type) GetFMSSTART_START() uint32 {
	return volatile.LoadUint32(&o.FMSSTART.Reg) & 0x1ffff
}
func (o *FLASHCTRL_Type) SetFMSSTART_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FMSSTART.Reg, volatile.LoadUint32(&o.FMSSTART.Reg)&^(0xfffe0000)|value<<17)
}
func (o *FLASHCTRL_Type) GetFMSSTART_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FMSSTART.Reg) & 0xfffe0000) >> 17
}

// FLASHCTRL.FMSSTOP: Signature stop-address register
func (o *FLASHCTRL_Type) SetFMSSTOP_STOPA(value uint32) {
	volatile.StoreUint32(&o.FMSSTOP.Reg, volatile.LoadUint32(&o.FMSSTOP.Reg)&^(0x1ffff)|value)
}
func (o *FLASHCTRL_Type) GetFMSSTOP_STOPA() uint32 {
	return volatile.LoadUint32(&o.FMSSTOP.Reg) & 0x1ffff
}
func (o *FLASHCTRL_Type) SetFMSSTOP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FMSSTOP.Reg, volatile.LoadUint32(&o.FMSSTOP.Reg)&^(0x7ffe0000)|value<<17)
}
func (o *FLASHCTRL_Type) GetFMSSTOP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FMSSTOP.Reg) & 0x7ffe0000) >> 17
}
func (o *FLASHCTRL_Type) SetFMSSTOP_STRTBIST(value uint32) {
	volatile.StoreUint32(&o.FMSSTOP.Reg, volatile.LoadUint32(&o.FMSSTOP.Reg)&^(0x80000000)|value<<31)
}
func (o *FLASHCTRL_Type) GetFMSSTOP_STRTBIST() uint32 {
	return (volatile.LoadUint32(&o.FMSSTOP.Reg) & 0x80000000) >> 31
}

// FLASHCTRL.FMSW0: Signature Word
func (o *FLASHCTRL_Type) SetFMSW0(value uint32) {
	volatile.StoreUint32(&o.FMSW0.Reg, value)
}
func (o *FLASHCTRL_Type) GetFMSW0() uint32 {
	return volatile.LoadUint32(&o.FMSW0.Reg)
}

// I/O configuration (IOCON)
type IOCON_Type struct {
	PIO0_17 volatile.Register32 // 0x0
	PIO0_13 volatile.Register32 // 0x4
	PIO0_12 volatile.Register32 // 0x8
	PIO0_5  volatile.Register32 // 0xC
	PIO0_4  volatile.Register32 // 0x10
	PIO0_3  volatile.Register32 // 0x14
	PIO0_2  volatile.Register32 // 0x18
	PIO0_11 volatile.Register32 // 0x1C
	PIO0_10 volatile.Register32 // 0x20
	PIO0_16 volatile.Register32 // 0x24
	PIO0_15 volatile.Register32 // 0x28
	PIO0_1  volatile.Register32 // 0x2C
	_       [4]byte
	PIO0_9  volatile.Register32 // 0x34
	PIO0_8  volatile.Register32 // 0x38
	PIO0_7  volatile.Register32 // 0x3C
	PIO0_6  volatile.Register32 // 0x40
	PIO0_0  volatile.Register32 // 0x44
	PIO0_14 volatile.Register32 // 0x48
}

// IOCON.PIO0_17: I/O configuration for pin PIO0_17
func (o *IOCON_Type) SetPIO0_17_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_17_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_17.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_17_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_17_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_17_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_17_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_17_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_17_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_17_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_17_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_17_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_17_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_17_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_17_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_17_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_17_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_17_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_17.Reg, volatile.LoadUint32(&o.PIO0_17.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_17_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_17.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_13: I/O configuration for pin PIO0_13
func (o *IOCON_Type) SetPIO0_13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_13_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_13.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_13_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_13_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_13_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_13_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_13_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_13_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_13_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_13_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_13_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_13_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_13_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_13_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_13_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_13.Reg, volatile.LoadUint32(&o.PIO0_13.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_13_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_13.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_12: I/O configuration for pin PIO0_12
func (o *IOCON_Type) SetPIO0_12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_12_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_12.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_12_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_12_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_12_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_12_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_12_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_12_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_12_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_12_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_12_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_12_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_12_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_12_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_12_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_12.Reg, volatile.LoadUint32(&o.PIO0_12.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_12_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_12.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_5: I/O configuration for pin PIO0_5/RESET
func (o *IOCON_Type) SetPIO0_5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_5_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_5.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_5_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_5_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_5.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_5_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_5_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_5.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_5_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_5_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_5.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_5.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_5_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_5_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_5.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_5_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_5_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_5.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_5_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_5_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_5.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_5.Reg, volatile.LoadUint32(&o.PIO0_5.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_5.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_4: I/O configuration for pin PIO0_4
func (o *IOCON_Type) SetPIO0_4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_4_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_4.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_4_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_4_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_4_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_4_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_4_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_4_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_4_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_4_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_4_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_4_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_4_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_4_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_4.Reg, volatile.LoadUint32(&o.PIO0_4.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_4.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_3: I/O configuration for pin PIO0_3/SWCLK
func (o *IOCON_Type) SetPIO0_3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_3_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_3.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_3_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_3_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_3_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_3_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_3_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_3_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_3_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_3_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_3_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_3_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_3_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_3_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_3.Reg, volatile.LoadUint32(&o.PIO0_3.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_3.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_2: I/O configuration for pin PIO0_2/SWDIO
func (o *IOCON_Type) SetPIO0_2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_2_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_2.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_2_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_2_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_2_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_2_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_2_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_2_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_2_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_2_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_2_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_2_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_2_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_2_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_2.Reg, volatile.LoadUint32(&o.PIO0_2.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_2.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_11: I/O configuration for pin PIO0_11. This is the pin configuration for the true open-drain pin.
func (o *IOCON_Type) SetPIO0_11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0x3f)|value)
}
func (o *IOCON_Type) GetPIO0_11_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_11.Reg) & 0x3f
}
func (o *IOCON_Type) SetPIO0_11_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_11_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetPIO0_11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetPIO0_11_I2CMODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0x300)|value<<8)
}
func (o *IOCON_Type) GetPIO0_11_I2CMODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0x300) >> 8
}
func (o *IOCON_Type) SetPIO0_11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_11_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_11_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_11_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_11_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_11_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_11.Reg, volatile.LoadUint32(&o.PIO0_11.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_11_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_11.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_10: I/O configuration for pin PIO0_10. This is the pin configuration for the true open-drain pin.
func (o *IOCON_Type) SetPIO0_10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_10.Reg, volatile.LoadUint32(&o.PIO0_10.Reg)&^(0x3f)|value)
}
func (o *IOCON_Type) GetPIO0_10_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_10.Reg) & 0x3f
}
func (o *IOCON_Type) SetPIO0_10_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_10.Reg, volatile.LoadUint32(&o.PIO0_10.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_10_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_10.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_10.Reg, volatile.LoadUint32(&o.PIO0_10.Reg)&^(0x80)|value<<7)
}
func (o *IOCON_Type) GetPIO0_10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_10.Reg) & 0x80) >> 7
}
func (o *IOCON_Type) SetPIO0_10_I2CMODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_10.Reg, volatile.LoadUint32(&o.PIO0_10.Reg)&^(0x300)|value<<8)
}
func (o *IOCON_Type) GetPIO0_10_I2CMODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_10.Reg) & 0x300) >> 8
}
func (o *IOCON_Type) SetPIO0_10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_10.Reg, volatile.LoadUint32(&o.PIO0_10.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_10.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_10_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_10.Reg, volatile.LoadUint32(&o.PIO0_10.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_10_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_10.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_10_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_10.Reg, volatile.LoadUint32(&o.PIO0_10.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_10_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_10.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_10.Reg, volatile.LoadUint32(&o.PIO0_10.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_10.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_16: I/O configuration for pin PIO0_16
func (o *IOCON_Type) SetPIO0_16_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_16_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_16.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_16_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_16_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_16_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_16_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_16_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_16_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_16_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_16_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_16_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_16_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_16_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_16_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_16_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_16_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_16_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_16.Reg, volatile.LoadUint32(&o.PIO0_16.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_16_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_16.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_15: I/O configuration for pin PIO0_15
func (o *IOCON_Type) SetPIO0_15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_15_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_15.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_15_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_15_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_15_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_15_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_15_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_15_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_15_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_15_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_15_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_15_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_15_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_15_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_15_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_15.Reg, volatile.LoadUint32(&o.PIO0_15.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_15_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_15.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_1: I/O configuration for pin PIO0_1/ACMP_I1/CLKIN
func (o *IOCON_Type) SetPIO0_1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_1_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_1.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_1_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_1_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_1_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_1_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_1_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_1_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_1_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_1_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_1_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_1_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_1_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_1_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_1.Reg, volatile.LoadUint32(&o.PIO0_1.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_1.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_9: I/O configuration for pin PIO0_9/XTALOUT
func (o *IOCON_Type) SetPIO0_9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_9.Reg, volatile.LoadUint32(&o.PIO0_9.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_9_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_9.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_9_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_9.Reg, volatile.LoadUint32(&o.PIO0_9.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_9_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_9.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_9_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_9.Reg, volatile.LoadUint32(&o.PIO0_9.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_9_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_9.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_9_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_9.Reg, volatile.LoadUint32(&o.PIO0_9.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_9_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_9.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_9.Reg, volatile.LoadUint32(&o.PIO0_9.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_9.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_9_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_9.Reg, volatile.LoadUint32(&o.PIO0_9.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_9_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_9.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_9_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_9.Reg, volatile.LoadUint32(&o.PIO0_9.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_9_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_9.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_9_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_9.Reg, volatile.LoadUint32(&o.PIO0_9.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_9_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_9.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_9.Reg, volatile.LoadUint32(&o.PIO0_9.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_9.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_8: I/O configuration for pin PIO0_8/XTALIN
func (o *IOCON_Type) SetPIO0_8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_8.Reg, volatile.LoadUint32(&o.PIO0_8.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_8_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_8.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_8_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_8.Reg, volatile.LoadUint32(&o.PIO0_8.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_8_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_8.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_8_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_8.Reg, volatile.LoadUint32(&o.PIO0_8.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_8_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_8.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_8_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_8.Reg, volatile.LoadUint32(&o.PIO0_8.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_8_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_8.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_8.Reg, volatile.LoadUint32(&o.PIO0_8.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_8.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_8_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_8.Reg, volatile.LoadUint32(&o.PIO0_8.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_8_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_8.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_8_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_8.Reg, volatile.LoadUint32(&o.PIO0_8.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_8_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_8.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_8_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_8.Reg, volatile.LoadUint32(&o.PIO0_8.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_8_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_8.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_8_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_8.Reg, volatile.LoadUint32(&o.PIO0_8.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_8_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_8.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_7: I/O configuration for pin PIO0_7
func (o *IOCON_Type) SetPIO0_7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_7.Reg, volatile.LoadUint32(&o.PIO0_7.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_7_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_7.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_7_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_7.Reg, volatile.LoadUint32(&o.PIO0_7.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_7_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_7.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_7_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_7.Reg, volatile.LoadUint32(&o.PIO0_7.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_7_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_7.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_7_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_7.Reg, volatile.LoadUint32(&o.PIO0_7.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_7_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_7.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_7.Reg, volatile.LoadUint32(&o.PIO0_7.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_7.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_7_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_7.Reg, volatile.LoadUint32(&o.PIO0_7.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_7_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_7.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_7_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_7.Reg, volatile.LoadUint32(&o.PIO0_7.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_7_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_7.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_7_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_7.Reg, volatile.LoadUint32(&o.PIO0_7.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_7_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_7.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_7.Reg, volatile.LoadUint32(&o.PIO0_7.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_7.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_6: I/O configuration for pin PIO0_6/VDDCMP
func (o *IOCON_Type) SetPIO0_6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_6.Reg, volatile.LoadUint32(&o.PIO0_6.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_6_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_6.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_6_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_6.Reg, volatile.LoadUint32(&o.PIO0_6.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_6_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_6.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_6_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_6.Reg, volatile.LoadUint32(&o.PIO0_6.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_6_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_6.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_6_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_6.Reg, volatile.LoadUint32(&o.PIO0_6.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_6_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_6.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_6.Reg, volatile.LoadUint32(&o.PIO0_6.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_6.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_6_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_6.Reg, volatile.LoadUint32(&o.PIO0_6.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_6_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_6.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_6_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_6.Reg, volatile.LoadUint32(&o.PIO0_6.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_6_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_6.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_6_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_6.Reg, volatile.LoadUint32(&o.PIO0_6.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_6_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_6.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_6.Reg, volatile.LoadUint32(&o.PIO0_6.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_6.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_0: I/O configuration for pin PIO0_0/ACMP_I0
func (o *IOCON_Type) SetPIO0_0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_0_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_0.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_0_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_0_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_0_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_0_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_0_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_0_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_0_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_0_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_0_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_0_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_0_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_0_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_0.Reg, volatile.LoadUint32(&o.PIO0_0.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_0.Reg) & 0xffff0000) >> 16
}

// IOCON.PIO0_14: I/O configuration for pin PIO0_14
func (o *IOCON_Type) SetPIO0_14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetPIO0_14_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PIO0_14.Reg) & 0x7
}
func (o *IOCON_Type) SetPIO0_14_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetPIO0_14_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetPIO0_14_HYS(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetPIO0_14_HYS() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetPIO0_14_INV(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetPIO0_14_INV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetPIO0_14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x380)|value<<7)
}
func (o *IOCON_Type) GetPIO0_14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0x380) >> 7
}
func (o *IOCON_Type) SetPIO0_14_OD(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetPIO0_14_OD() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetPIO0_14_S_MODE(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0x1800)|value<<11)
}
func (o *IOCON_Type) GetPIO0_14_S_MODE() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0x1800) >> 11
}
func (o *IOCON_Type) SetPIO0_14_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0xe000)|value<<13)
}
func (o *IOCON_Type) GetPIO0_14_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0xe000) >> 13
}
func (o *IOCON_Type) SetPIO0_14_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIO0_14.Reg, volatile.LoadUint32(&o.PIO0_14.Reg)&^(0xffff0000)|value<<16)
}
func (o *IOCON_Type) GetPIO0_14_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIO0_14.Reg) & 0xffff0000) >> 16
}

// System configuration (SYSCON)
type SYSCON_Type struct {
	SYSMEMREMAP   volatile.Register32 // 0x0
	PRESETCTRL    volatile.Register32 // 0x4
	SYSPLLCTRL    volatile.Register32 // 0x8
	SYSPLLSTAT    volatile.Register32 // 0xC
	_             [16]byte
	SYSOSCCTRL    volatile.Register32 // 0x20
	WDTOSCCTRL    volatile.Register32 // 0x24
	_             [8]byte
	SYSRSTSTAT    volatile.Register32 // 0x30
	_             [12]byte
	SYSPLLCLKSEL  volatile.Register32 // 0x40
	SYSPLLCLKUEN  volatile.Register32 // 0x44
	_             [40]byte
	MAINCLKSEL    volatile.Register32 // 0x70
	MAINCLKUEN    volatile.Register32 // 0x74
	SYSAHBCLKDIV  volatile.Register32 // 0x78
	_             [4]byte
	SYSAHBCLKCTRL volatile.Register32 // 0x80
	_             [16]byte
	UARTCLKDIV    volatile.Register32 // 0x94
	_             [72]byte
	CLKOUTSEL     volatile.Register32 // 0xE0
	CLKOUTUEN     volatile.Register32 // 0xE4
	CLKOUTDIV     volatile.Register32 // 0xE8
	_             [4]byte
	UARTFRGDIV    volatile.Register32 // 0xF0
	UARTFRGMULT   volatile.Register32 // 0xF4
	_             [4]byte
	EXTTRACECMD   volatile.Register32 // 0xFC
	PIOPORCAP0    volatile.Register32 // 0x100
	_             [48]byte
	IOCONCLKDIV6  volatile.Register32 // 0x134
	IOCONCLKDIV5  volatile.Register32 // 0x138
	IOCONCLKDIV4  volatile.Register32 // 0x13C
	IOCONCLKDIV3  volatile.Register32 // 0x140
	IOCONCLKDIV2  volatile.Register32 // 0x144
	IOCONCLKDIV1  volatile.Register32 // 0x148
	IOCONCLKDIV0  volatile.Register32 // 0x14C
	BODCTRL       volatile.Register32 // 0x150
	SYSTCKCAL     volatile.Register32 // 0x154
	_             [24]byte
	IRQLATENCY    volatile.Register32 // 0x170
	NMISRC        volatile.Register32 // 0x174
	PINTSEL0      volatile.Register32 // 0x178
	PINTSEL1      volatile.Register32 // 0x17C
	PINTSEL2      volatile.Register32 // 0x180
	PINTSEL3      volatile.Register32 // 0x184
	PINTSEL4      volatile.Register32 // 0x188
	PINTSEL5      volatile.Register32 // 0x18C
	PINTSEL6      volatile.Register32 // 0x190
	PINTSEL7      volatile.Register32 // 0x194
	_             [108]byte
	STARTERP0     volatile.Register32 // 0x204
	_             [12]byte
	STARTERP1     volatile.Register32 // 0x214
	_             [24]byte
	PDSLEEPCFG    volatile.Register32 // 0x230
	PDAWAKECFG    volatile.Register32 // 0x234
	PDRUNCFG      volatile.Register32 // 0x238
	_             [440]byte
	DEVICE_ID     volatile.Register32 // 0x3F4
}

// SYSCON.SYSMEMREMAP: System memory remap
func (o *SYSCON_Type) SetSYSMEMREMAP_MAP(value uint32) {
	volatile.StoreUint32(&o.SYSMEMREMAP.Reg, volatile.LoadUint32(&o.SYSMEMREMAP.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetSYSMEMREMAP_MAP() uint32 {
	return volatile.LoadUint32(&o.SYSMEMREMAP.Reg) & 0x3
}
func (o *SYSCON_Type) SetSYSMEMREMAP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSMEMREMAP.Reg, volatile.LoadUint32(&o.SYSMEMREMAP.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetSYSMEMREMAP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSMEMREMAP.Reg) & 0xfffffffc) >> 2
}

// SYSCON.PRESETCTRL: Peripheral reset control
func (o *SYSCON_Type) SetPRESETCTRL_SPI0_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetPRESETCTRL_SPI0_RST_N() uint32 {
	return volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x1
}
func (o *SYSCON_Type) SetPRESETCTRL_SPI1_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetPRESETCTRL_SPI1_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetPRESETCTRL_UARTFRG_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetPRESETCTRL_UARTFRG_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetPRESETCTRL_USART0_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetPRESETCTRL_USART0_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetPRESETCTRL_UART1_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetPRESETCTRL_UART1_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetPRESETCTRL_UART2_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetPRESETCTRL_UART2_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetPRESETCTRL_I2C_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetPRESETCTRL_I2C_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetPRESETCTRL_MRT_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetPRESETCTRL_MRT_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetPRESETCTRL_SCT_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetPRESETCTRL_SCT_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetPRESETCTRL_WKT_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x200)|value<<9)
}
func (o *SYSCON_Type) GetPRESETCTRL_WKT_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x200) >> 9
}
func (o *SYSCON_Type) SetPRESETCTRL_GPIO_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x400)|value<<10)
}
func (o *SYSCON_Type) GetPRESETCTRL_GPIO_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x400) >> 10
}
func (o *SYSCON_Type) SetPRESETCTRL_FLASH_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x800)|value<<11)
}
func (o *SYSCON_Type) GetPRESETCTRL_FLASH_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x800) >> 11
}
func (o *SYSCON_Type) SetPRESETCTRL_ACMP_RST_N(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCON_Type) GetPRESETCTRL_ACMP_RST_N() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0x1000) >> 12
}
func (o *SYSCON_Type) SetPRESETCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PRESETCTRL.Reg, volatile.LoadUint32(&o.PRESETCTRL.Reg)&^(0xfffff000)|value<<12)
}
func (o *SYSCON_Type) GetPRESETCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PRESETCTRL.Reg) & 0xfffff000) >> 12
}

// SYSCON.SYSPLLCTRL: System PLL control
func (o *SYSCON_Type) SetSYSPLLCTRL_MSEL(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCTRL.Reg, volatile.LoadUint32(&o.SYSPLLCTRL.Reg)&^(0x1f)|value)
}
func (o *SYSCON_Type) GetSYSPLLCTRL_MSEL() uint32 {
	return volatile.LoadUint32(&o.SYSPLLCTRL.Reg) & 0x1f
}
func (o *SYSCON_Type) SetSYSPLLCTRL_PSEL(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCTRL.Reg, volatile.LoadUint32(&o.SYSPLLCTRL.Reg)&^(0x60)|value<<5)
}
func (o *SYSCON_Type) GetSYSPLLCTRL_PSEL() uint32 {
	return (volatile.LoadUint32(&o.SYSPLLCTRL.Reg) & 0x60) >> 5
}
func (o *SYSCON_Type) SetSYSPLLCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCTRL.Reg, volatile.LoadUint32(&o.SYSPLLCTRL.Reg)&^(0xffffff80)|value<<7)
}
func (o *SYSCON_Type) GetSYSPLLCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSPLLCTRL.Reg) & 0xffffff80) >> 7
}

// SYSCON.SYSPLLSTAT: System PLL status
func (o *SYSCON_Type) SetSYSPLLSTAT_LOCK(value uint32) {
	volatile.StoreUint32(&o.SYSPLLSTAT.Reg, volatile.LoadUint32(&o.SYSPLLSTAT.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSYSPLLSTAT_LOCK() uint32 {
	return volatile.LoadUint32(&o.SYSPLLSTAT.Reg) & 0x1
}
func (o *SYSCON_Type) SetSYSPLLSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSPLLSTAT.Reg, volatile.LoadUint32(&o.SYSPLLSTAT.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SYSCON_Type) GetSYSPLLSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSPLLSTAT.Reg) & 0xfffffffe) >> 1
}

// SYSCON.SYSOSCCTRL: System oscillator control
func (o *SYSCON_Type) SetSYSOSCCTRL_BYPASS(value uint32) {
	volatile.StoreUint32(&o.SYSOSCCTRL.Reg, volatile.LoadUint32(&o.SYSOSCCTRL.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSYSOSCCTRL_BYPASS() uint32 {
	return volatile.LoadUint32(&o.SYSOSCCTRL.Reg) & 0x1
}
func (o *SYSCON_Type) SetSYSOSCCTRL_FREQRANGE(value uint32) {
	volatile.StoreUint32(&o.SYSOSCCTRL.Reg, volatile.LoadUint32(&o.SYSOSCCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetSYSOSCCTRL_FREQRANGE() uint32 {
	return (volatile.LoadUint32(&o.SYSOSCCTRL.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetSYSOSCCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSOSCCTRL.Reg, volatile.LoadUint32(&o.SYSOSCCTRL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetSYSOSCCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSOSCCTRL.Reg) & 0xfffffffc) >> 2
}

// SYSCON.WDTOSCCTRL: Watchdog oscillator control
func (o *SYSCON_Type) SetWDTOSCCTRL_DIVSEL(value uint32) {
	volatile.StoreUint32(&o.WDTOSCCTRL.Reg, volatile.LoadUint32(&o.WDTOSCCTRL.Reg)&^(0x1f)|value)
}
func (o *SYSCON_Type) GetWDTOSCCTRL_DIVSEL() uint32 {
	return volatile.LoadUint32(&o.WDTOSCCTRL.Reg) & 0x1f
}
func (o *SYSCON_Type) SetWDTOSCCTRL_FREQSEL(value uint32) {
	volatile.StoreUint32(&o.WDTOSCCTRL.Reg, volatile.LoadUint32(&o.WDTOSCCTRL.Reg)&^(0x1e0)|value<<5)
}
func (o *SYSCON_Type) GetWDTOSCCTRL_FREQSEL() uint32 {
	return (volatile.LoadUint32(&o.WDTOSCCTRL.Reg) & 0x1e0) >> 5
}
func (o *SYSCON_Type) SetWDTOSCCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.WDTOSCCTRL.Reg, volatile.LoadUint32(&o.WDTOSCCTRL.Reg)&^(0xfffffe00)|value<<9)
}
func (o *SYSCON_Type) GetWDTOSCCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.WDTOSCCTRL.Reg) & 0xfffffe00) >> 9
}

// SYSCON.SYSRSTSTAT: System reset status register
func (o *SYSCON_Type) SetSYSRSTSTAT_POR(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_POR() uint32 {
	return volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0x1
}
func (o *SYSCON_Type) SetSYSRSTSTAT_EXTRST(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_EXTRST() uint32 {
	return (volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetSYSRSTSTAT_WDT(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_WDT() uint32 {
	return (volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetSYSRSTSTAT_BOD(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_BOD() uint32 {
	return (volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetSYSRSTSTAT_SYSRST(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_SYSRST() uint32 {
	return (volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetSYSRSTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSRSTSTAT.Reg, volatile.LoadUint32(&o.SYSRSTSTAT.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSCON_Type) GetSYSRSTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSRSTSTAT.Reg) & 0xffffffe0) >> 5
}

// SYSCON.SYSPLLCLKSEL: System PLL clock source select
func (o *SYSCON_Type) SetSYSPLLCLKSEL_SEL(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCLKSEL.Reg, volatile.LoadUint32(&o.SYSPLLCLKSEL.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetSYSPLLCLKSEL_SEL() uint32 {
	return volatile.LoadUint32(&o.SYSPLLCLKSEL.Reg) & 0x3
}
func (o *SYSCON_Type) SetSYSPLLCLKSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCLKSEL.Reg, volatile.LoadUint32(&o.SYSPLLCLKSEL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetSYSPLLCLKSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSPLLCLKSEL.Reg) & 0xfffffffc) >> 2
}

// SYSCON.SYSPLLCLKUEN: System PLL clock source update enable
func (o *SYSCON_Type) SetSYSPLLCLKUEN_ENA(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCLKUEN.Reg, volatile.LoadUint32(&o.SYSPLLCLKUEN.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSYSPLLCLKUEN_ENA() uint32 {
	return volatile.LoadUint32(&o.SYSPLLCLKUEN.Reg) & 0x1
}
func (o *SYSCON_Type) SetSYSPLLCLKUEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSPLLCLKUEN.Reg, volatile.LoadUint32(&o.SYSPLLCLKUEN.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SYSCON_Type) GetSYSPLLCLKUEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSPLLCLKUEN.Reg) & 0xfffffffe) >> 1
}

// SYSCON.MAINCLKSEL: Main clock source select
func (o *SYSCON_Type) SetMAINCLKSEL_SEL(value uint32) {
	volatile.StoreUint32(&o.MAINCLKSEL.Reg, volatile.LoadUint32(&o.MAINCLKSEL.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetMAINCLKSEL_SEL() uint32 {
	return volatile.LoadUint32(&o.MAINCLKSEL.Reg) & 0x3
}
func (o *SYSCON_Type) SetMAINCLKSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAINCLKSEL.Reg, volatile.LoadUint32(&o.MAINCLKSEL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetMAINCLKSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAINCLKSEL.Reg) & 0xfffffffc) >> 2
}

// SYSCON.MAINCLKUEN: Main clock source update enable
func (o *SYSCON_Type) SetMAINCLKUEN_ENA(value uint32) {
	volatile.StoreUint32(&o.MAINCLKUEN.Reg, volatile.LoadUint32(&o.MAINCLKUEN.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetMAINCLKUEN_ENA() uint32 {
	return volatile.LoadUint32(&o.MAINCLKUEN.Reg) & 0x1
}
func (o *SYSCON_Type) SetMAINCLKUEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAINCLKUEN.Reg, volatile.LoadUint32(&o.MAINCLKUEN.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SYSCON_Type) GetMAINCLKUEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAINCLKUEN.Reg) & 0xfffffffe) >> 1
}

// SYSCON.SYSAHBCLKDIV: System clock divider
func (o *SYSCON_Type) SetSYSAHBCLKDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKDIV.Reg, volatile.LoadUint32(&o.SYSAHBCLKDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetSYSAHBCLKDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.SYSAHBCLKDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetSYSAHBCLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKDIV.Reg, volatile.LoadUint32(&o.SYSAHBCLKDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetSYSAHBCLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.SYSAHBCLKCTRL: System clock control
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_SYS(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_SYS() uint32 {
	return volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x1
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_ROM(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_ROM() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_RAM(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_RAM() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_FLASHREG(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_FLASHREG() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_FLASH(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_FLASH() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_I2C(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_I2C() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_GPIO(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_GPIO() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_SWM(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_SWM() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_SCT(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_SCT() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_WKT(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x200)|value<<9)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_WKT() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x200) >> 9
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_MRT(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x400)|value<<10)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_MRT() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x400) >> 10
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_SPI0(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x800)|value<<11)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_SPI0() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x800) >> 11
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_SPI1(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_SPI1() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x1000) >> 12
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_CRC(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_CRC() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x2000) >> 13
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_UART0(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_UART0() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x4000) >> 14
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_UART1(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_UART1() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x8000) >> 15
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_UART2(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_UART2() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x10000) >> 16
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_WWDT(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_WWDT() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x20000) >> 17
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_IOCON(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_IOCON() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x40000) >> 18
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_ACMP(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_ACMP() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0x80000) >> 19
}
func (o *SYSCON_Type) SetSYSAHBCLKCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSAHBCLKCTRL.Reg, volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg)&^(0xfff00000)|value<<20)
}
func (o *SYSCON_Type) GetSYSAHBCLKCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSAHBCLKCTRL.Reg) & 0xfff00000) >> 20
}

// SYSCON.UARTCLKDIV: UART clock divider
func (o *SYSCON_Type) SetUARTCLKDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.UARTCLKDIV.Reg, volatile.LoadUint32(&o.UARTCLKDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetUARTCLKDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.UARTCLKDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetUARTCLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.UARTCLKDIV.Reg, volatile.LoadUint32(&o.UARTCLKDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetUARTCLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.UARTCLKDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.CLKOUTSEL: CLKOUT clock source select
func (o *SYSCON_Type) SetCLKOUTSEL_SEL(value uint32) {
	volatile.StoreUint32(&o.CLKOUTSEL.Reg, volatile.LoadUint32(&o.CLKOUTSEL.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetCLKOUTSEL_SEL() uint32 {
	return volatile.LoadUint32(&o.CLKOUTSEL.Reg) & 0x3
}
func (o *SYSCON_Type) SetCLKOUTSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKOUTSEL.Reg, volatile.LoadUint32(&o.CLKOUTSEL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetCLKOUTSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKOUTSEL.Reg) & 0xfffffffc) >> 2
}

// SYSCON.CLKOUTUEN: CLKOUT clock source update enable
func (o *SYSCON_Type) SetCLKOUTUEN_ENA(value uint32) {
	volatile.StoreUint32(&o.CLKOUTUEN.Reg, volatile.LoadUint32(&o.CLKOUTUEN.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetCLKOUTUEN_ENA() uint32 {
	return volatile.LoadUint32(&o.CLKOUTUEN.Reg) & 0x1
}
func (o *SYSCON_Type) SetCLKOUTUEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKOUTUEN.Reg, volatile.LoadUint32(&o.CLKOUTUEN.Reg)&^(0xfffffffe)|value<<1)
}
func (o *SYSCON_Type) GetCLKOUTUEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKOUTUEN.Reg) & 0xfffffffe) >> 1
}

// SYSCON.CLKOUTDIV: CLKOUT clock divider
func (o *SYSCON_Type) SetCLKOUTDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.CLKOUTDIV.Reg, volatile.LoadUint32(&o.CLKOUTDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetCLKOUTDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.CLKOUTDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetCLKOUTDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKOUTDIV.Reg, volatile.LoadUint32(&o.CLKOUTDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetCLKOUTDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKOUTDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.UARTFRGDIV: UART fractional generator divider value
func (o *SYSCON_Type) SetUARTFRGDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.UARTFRGDIV.Reg, volatile.LoadUint32(&o.UARTFRGDIV.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetUARTFRGDIV_DIV() uint32 {
	return volatile.LoadUint32(&o.UARTFRGDIV.Reg) & 0xff
}
func (o *SYSCON_Type) SetUARTFRGDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.UARTFRGDIV.Reg, volatile.LoadUint32(&o.UARTFRGDIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetUARTFRGDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.UARTFRGDIV.Reg) & 0xffffff00) >> 8
}

// SYSCON.UARTFRGMULT: UART fractional generator multiplier value
func (o *SYSCON_Type) SetUARTFRGMULT_MULT(value uint32) {
	volatile.StoreUint32(&o.UARTFRGMULT.Reg, volatile.LoadUint32(&o.UARTFRGMULT.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetUARTFRGMULT_MULT() uint32 {
	return volatile.LoadUint32(&o.UARTFRGMULT.Reg) & 0xff
}
func (o *SYSCON_Type) SetUARTFRGMULT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.UARTFRGMULT.Reg, volatile.LoadUint32(&o.UARTFRGMULT.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetUARTFRGMULT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.UARTFRGMULT.Reg) & 0xffffff00) >> 8
}

// SYSCON.EXTTRACECMD: External trace buffer command register
func (o *SYSCON_Type) SetEXTTRACECMD_START(value uint32) {
	volatile.StoreUint32(&o.EXTTRACECMD.Reg, volatile.LoadUint32(&o.EXTTRACECMD.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetEXTTRACECMD_START() uint32 {
	return volatile.LoadUint32(&o.EXTTRACECMD.Reg) & 0x1
}
func (o *SYSCON_Type) SetEXTTRACECMD_STOP(value uint32) {
	volatile.StoreUint32(&o.EXTTRACECMD.Reg, volatile.LoadUint32(&o.EXTTRACECMD.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetEXTTRACECMD_STOP() uint32 {
	return (volatile.LoadUint32(&o.EXTTRACECMD.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetEXTTRACECMD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EXTTRACECMD.Reg, volatile.LoadUint32(&o.EXTTRACECMD.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetEXTTRACECMD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EXTTRACECMD.Reg) & 0xfffffffc) >> 2
}

// SYSCON.PIOPORCAP0: POR captured PIO status 0
func (o *SYSCON_Type) SetPIOPORCAP0_PIOSTAT(value uint32) {
	volatile.StoreUint32(&o.PIOPORCAP0.Reg, volatile.LoadUint32(&o.PIOPORCAP0.Reg)&^(0x3ffff)|value)
}
func (o *SYSCON_Type) GetPIOPORCAP0_PIOSTAT() uint32 {
	return volatile.LoadUint32(&o.PIOPORCAP0.Reg) & 0x3ffff
}
func (o *SYSCON_Type) SetPIOPORCAP0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIOPORCAP0.Reg, volatile.LoadUint32(&o.PIOPORCAP0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *SYSCON_Type) GetPIOPORCAP0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIOPORCAP0.Reg) & 0xfffc0000) >> 18
}

// SYSCON.IOCONCLKDIV6: Peripheral clock 6 to the IOCON block for programmable glitch filter
func (o *SYSCON_Type) SetIOCONCLKDIV6_DIV(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV6.Reg, volatile.LoadUint32(&o.IOCONCLKDIV6.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetIOCONCLKDIV6_DIV() uint32 {
	return volatile.LoadUint32(&o.IOCONCLKDIV6.Reg) & 0xff
}
func (o *SYSCON_Type) SetIOCONCLKDIV6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV6.Reg, volatile.LoadUint32(&o.IOCONCLKDIV6.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetIOCONCLKDIV6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IOCONCLKDIV6.Reg) & 0xffffff00) >> 8
}

// SYSCON.IOCONCLKDIV5: Peripheral clock 5 to the IOCON block for programmable glitch filter
func (o *SYSCON_Type) SetIOCONCLKDIV5_DIV(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV5.Reg, volatile.LoadUint32(&o.IOCONCLKDIV5.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetIOCONCLKDIV5_DIV() uint32 {
	return volatile.LoadUint32(&o.IOCONCLKDIV5.Reg) & 0xff
}
func (o *SYSCON_Type) SetIOCONCLKDIV5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV5.Reg, volatile.LoadUint32(&o.IOCONCLKDIV5.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetIOCONCLKDIV5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IOCONCLKDIV5.Reg) & 0xffffff00) >> 8
}

// SYSCON.IOCONCLKDIV4: Peripheral clock 4 to the IOCON block for programmable glitch filter
func (o *SYSCON_Type) SetIOCONCLKDIV4_DIV(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV4.Reg, volatile.LoadUint32(&o.IOCONCLKDIV4.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetIOCONCLKDIV4_DIV() uint32 {
	return volatile.LoadUint32(&o.IOCONCLKDIV4.Reg) & 0xff
}
func (o *SYSCON_Type) SetIOCONCLKDIV4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV4.Reg, volatile.LoadUint32(&o.IOCONCLKDIV4.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetIOCONCLKDIV4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IOCONCLKDIV4.Reg) & 0xffffff00) >> 8
}

// SYSCON.IOCONCLKDIV3: Peripheral clock 3 to the IOCON block for programmable glitch filter
func (o *SYSCON_Type) SetIOCONCLKDIV3_DIV(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV3.Reg, volatile.LoadUint32(&o.IOCONCLKDIV3.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetIOCONCLKDIV3_DIV() uint32 {
	return volatile.LoadUint32(&o.IOCONCLKDIV3.Reg) & 0xff
}
func (o *SYSCON_Type) SetIOCONCLKDIV3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV3.Reg, volatile.LoadUint32(&o.IOCONCLKDIV3.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetIOCONCLKDIV3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IOCONCLKDIV3.Reg) & 0xffffff00) >> 8
}

// SYSCON.IOCONCLKDIV2: Peripheral clock 2 to the IOCON block for programmable glitch filter
func (o *SYSCON_Type) SetIOCONCLKDIV2_DIV(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV2.Reg, volatile.LoadUint32(&o.IOCONCLKDIV2.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetIOCONCLKDIV2_DIV() uint32 {
	return volatile.LoadUint32(&o.IOCONCLKDIV2.Reg) & 0xff
}
func (o *SYSCON_Type) SetIOCONCLKDIV2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV2.Reg, volatile.LoadUint32(&o.IOCONCLKDIV2.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetIOCONCLKDIV2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IOCONCLKDIV2.Reg) & 0xffffff00) >> 8
}

// SYSCON.IOCONCLKDIV1: Peripheral clock 1 to the IOCON block for programmable glitch filter
func (o *SYSCON_Type) SetIOCONCLKDIV1_DIV(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV1.Reg, volatile.LoadUint32(&o.IOCONCLKDIV1.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetIOCONCLKDIV1_DIV() uint32 {
	return volatile.LoadUint32(&o.IOCONCLKDIV1.Reg) & 0xff
}
func (o *SYSCON_Type) SetIOCONCLKDIV1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV1.Reg, volatile.LoadUint32(&o.IOCONCLKDIV1.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetIOCONCLKDIV1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IOCONCLKDIV1.Reg) & 0xffffff00) >> 8
}

// SYSCON.IOCONCLKDIV0: Peripheral clock 0 to the IOCON block for programmable glitch filter
func (o *SYSCON_Type) SetIOCONCLKDIV0_DIV(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV0.Reg, volatile.LoadUint32(&o.IOCONCLKDIV0.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetIOCONCLKDIV0_DIV() uint32 {
	return volatile.LoadUint32(&o.IOCONCLKDIV0.Reg) & 0xff
}
func (o *SYSCON_Type) SetIOCONCLKDIV0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IOCONCLKDIV0.Reg, volatile.LoadUint32(&o.IOCONCLKDIV0.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetIOCONCLKDIV0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IOCONCLKDIV0.Reg) & 0xffffff00) >> 8
}

// SYSCON.BODCTRL: Brown-Out Detect
func (o *SYSCON_Type) SetBODCTRL_BODRSTLEV(value uint32) {
	volatile.StoreUint32(&o.BODCTRL.Reg, volatile.LoadUint32(&o.BODCTRL.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetBODCTRL_BODRSTLEV() uint32 {
	return volatile.LoadUint32(&o.BODCTRL.Reg) & 0x3
}
func (o *SYSCON_Type) SetBODCTRL_BODINTVAL(value uint32) {
	volatile.StoreUint32(&o.BODCTRL.Reg, volatile.LoadUint32(&o.BODCTRL.Reg)&^(0xc)|value<<2)
}
func (o *SYSCON_Type) GetBODCTRL_BODINTVAL() uint32 {
	return (volatile.LoadUint32(&o.BODCTRL.Reg) & 0xc) >> 2
}
func (o *SYSCON_Type) SetBODCTRL_BODRSTENA(value uint32) {
	volatile.StoreUint32(&o.BODCTRL.Reg, volatile.LoadUint32(&o.BODCTRL.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetBODCTRL_BODRSTENA() uint32 {
	return (volatile.LoadUint32(&o.BODCTRL.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetBODCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BODCTRL.Reg, volatile.LoadUint32(&o.BODCTRL.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSCON_Type) GetBODCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.BODCTRL.Reg) & 0xffffffe0) >> 5
}

// SYSCON.SYSTCKCAL: System tick counter calibration
func (o *SYSCON_Type) SetSYSTCKCAL_CAL(value uint32) {
	volatile.StoreUint32(&o.SYSTCKCAL.Reg, volatile.LoadUint32(&o.SYSTCKCAL.Reg)&^(0x3ffffff)|value)
}
func (o *SYSCON_Type) GetSYSTCKCAL_CAL() uint32 {
	return volatile.LoadUint32(&o.SYSTCKCAL.Reg) & 0x3ffffff
}
func (o *SYSCON_Type) SetSYSTCKCAL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYSTCKCAL.Reg, volatile.LoadUint32(&o.SYSTCKCAL.Reg)&^(0xfc000000)|value<<26)
}
func (o *SYSCON_Type) GetSYSTCKCAL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYSTCKCAL.Reg) & 0xfc000000) >> 26
}

// SYSCON.IRQLATENCY: IQR delay. Allows trade-off between interrupt latency and determinism.
func (o *SYSCON_Type) SetIRQLATENCY_LATENCY(value uint32) {
	volatile.StoreUint32(&o.IRQLATENCY.Reg, volatile.LoadUint32(&o.IRQLATENCY.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetIRQLATENCY_LATENCY() uint32 {
	return volatile.LoadUint32(&o.IRQLATENCY.Reg) & 0xff
}
func (o *SYSCON_Type) SetIRQLATENCY_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IRQLATENCY.Reg, volatile.LoadUint32(&o.IRQLATENCY.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetIRQLATENCY_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IRQLATENCY.Reg) & 0xffffff00) >> 8
}

// SYSCON.NMISRC: NMI Source Control
func (o *SYSCON_Type) SetNMISRC_IRQNO(value uint32) {
	volatile.StoreUint32(&o.NMISRC.Reg, volatile.LoadUint32(&o.NMISRC.Reg)&^(0x1f)|value)
}
func (o *SYSCON_Type) GetNMISRC_IRQNO() uint32 {
	return volatile.LoadUint32(&o.NMISRC.Reg) & 0x1f
}
func (o *SYSCON_Type) SetNMISRC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.NMISRC.Reg, volatile.LoadUint32(&o.NMISRC.Reg)&^(0x7fffffe0)|value<<5)
}
func (o *SYSCON_Type) GetNMISRC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.NMISRC.Reg) & 0x7fffffe0) >> 5
}
func (o *SYSCON_Type) SetNMISRC_NMIEN(value uint32) {
	volatile.StoreUint32(&o.NMISRC.Reg, volatile.LoadUint32(&o.NMISRC.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSCON_Type) GetNMISRC_NMIEN() uint32 {
	return (volatile.LoadUint32(&o.NMISRC.Reg) & 0x80000000) >> 31
}

// SYSCON.PINTSEL0: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL0_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL0.Reg, volatile.LoadUint32(&o.PINTSEL0.Reg)&^(0x3f)|value)
}
func (o *SYSCON_Type) GetPINTSEL0_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL0.Reg) & 0x3f
}
func (o *SYSCON_Type) SetPINTSEL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL0.Reg, volatile.LoadUint32(&o.PINTSEL0.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL0.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PINTSEL1: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL1_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL1.Reg, volatile.LoadUint32(&o.PINTSEL1.Reg)&^(0x3f)|value)
}
func (o *SYSCON_Type) GetPINTSEL1_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL1.Reg) & 0x3f
}
func (o *SYSCON_Type) SetPINTSEL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL1.Reg, volatile.LoadUint32(&o.PINTSEL1.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL1.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PINTSEL2: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL2_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL2.Reg, volatile.LoadUint32(&o.PINTSEL2.Reg)&^(0x3f)|value)
}
func (o *SYSCON_Type) GetPINTSEL2_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL2.Reg) & 0x3f
}
func (o *SYSCON_Type) SetPINTSEL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL2.Reg, volatile.LoadUint32(&o.PINTSEL2.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL2.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PINTSEL3: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL3_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL3.Reg, volatile.LoadUint32(&o.PINTSEL3.Reg)&^(0x3f)|value)
}
func (o *SYSCON_Type) GetPINTSEL3_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL3.Reg) & 0x3f
}
func (o *SYSCON_Type) SetPINTSEL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL3.Reg, volatile.LoadUint32(&o.PINTSEL3.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL3.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PINTSEL4: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL4_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL4.Reg, volatile.LoadUint32(&o.PINTSEL4.Reg)&^(0x3f)|value)
}
func (o *SYSCON_Type) GetPINTSEL4_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL4.Reg) & 0x3f
}
func (o *SYSCON_Type) SetPINTSEL4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL4.Reg, volatile.LoadUint32(&o.PINTSEL4.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL4.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PINTSEL5: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL5_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL5.Reg, volatile.LoadUint32(&o.PINTSEL5.Reg)&^(0x3f)|value)
}
func (o *SYSCON_Type) GetPINTSEL5_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL5.Reg) & 0x3f
}
func (o *SYSCON_Type) SetPINTSEL5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL5.Reg, volatile.LoadUint32(&o.PINTSEL5.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL5.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PINTSEL6: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL6_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL6.Reg, volatile.LoadUint32(&o.PINTSEL6.Reg)&^(0x3f)|value)
}
func (o *SYSCON_Type) GetPINTSEL6_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL6.Reg) & 0x3f
}
func (o *SYSCON_Type) SetPINTSEL6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL6.Reg, volatile.LoadUint32(&o.PINTSEL6.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL6.Reg) & 0xffffffc0) >> 6
}

// SYSCON.PINTSEL7: GPIO Pin Interrupt Select register 0
func (o *SYSCON_Type) SetPINTSEL7_INTPIN(value uint32) {
	volatile.StoreUint32(&o.PINTSEL7.Reg, volatile.LoadUint32(&o.PINTSEL7.Reg)&^(0x3f)|value)
}
func (o *SYSCON_Type) GetPINTSEL7_INTPIN() uint32 {
	return volatile.LoadUint32(&o.PINTSEL7.Reg) & 0x3f
}
func (o *SYSCON_Type) SetPINTSEL7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINTSEL7.Reg, volatile.LoadUint32(&o.PINTSEL7.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SYSCON_Type) GetPINTSEL7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINTSEL7.Reg) & 0xffffffc0) >> 6
}

// SYSCON.STARTERP0: Start logic 0 pin wake-up enable register
func (o *SYSCON_Type) SetSTARTERP0_PINT0(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT0() uint32 {
	return volatile.LoadUint32(&o.STARTERP0.Reg) & 0x1
}
func (o *SYSCON_Type) SetSTARTERP0_PINT1(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT1() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetSTARTERP0_PINT2(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT2() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetSTARTERP0_PINT3(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT3() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetSTARTERP0_PINT4(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT4() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetSTARTERP0_PINT5(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT5() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetSTARTERP0_PINT6(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT6() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetSTARTERP0_PINT7(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetSTARTERP0_PINT7() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetSTARTERP0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STARTERP0.Reg, volatile.LoadUint32(&o.STARTERP0.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetSTARTERP0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STARTERP0.Reg) & 0xffffff00) >> 8
}

// SYSCON.STARTERP1: Start logic 1 interrupt wake-up enable register
func (o *SYSCON_Type) SetSTARTERP1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0xfff)|value)
}
func (o *SYSCON_Type) GetSTARTERP1_RESERVED() uint32 {
	return volatile.LoadUint32(&o.STARTERP1.Reg) & 0xfff
}
func (o *SYSCON_Type) SetSTARTERP1_WWDT(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCON_Type) GetSTARTERP1_WWDT() uint32 {
	return (volatile.LoadUint32(&o.STARTERP1.Reg) & 0x1000) >> 12
}
func (o *SYSCON_Type) SetSTARTERP1_BOD(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCON_Type) GetSTARTERP1_BOD() uint32 {
	return (volatile.LoadUint32(&o.STARTERP1.Reg) & 0x2000) >> 13
}
func (o *SYSCON_Type) SetSTARTERP1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCON_Type) GetSTARTERP1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STARTERP1.Reg) & 0x4000) >> 14
}
func (o *SYSCON_Type) SetSTARTERP1_WKT(value uint32) {
	volatile.StoreUint32(&o.STARTERP1.Reg, volatile.LoadUint32(&o.STARTERP1.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCON_Type) GetSTARTERP1_WKT() uint32 {
	return (volatile.LoadUint32(&o.STARTERP1.Reg) & 0x8000) >> 15
}

// SYSCON.PDSLEEPCFG: Power-down states in deep-sleep mode
func (o *SYSCON_Type) SetPDSLEEPCFG_BOD_PD(value uint32) {
	volatile.StoreUint32(&o.PDSLEEPCFG.Reg, volatile.LoadUint32(&o.PDSLEEPCFG.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetPDSLEEPCFG_BOD_PD() uint32 {
	return (volatile.LoadUint32(&o.PDSLEEPCFG.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetPDSLEEPCFG_WDTOSC_PD(value uint32) {
	volatile.StoreUint32(&o.PDSLEEPCFG.Reg, volatile.LoadUint32(&o.PDSLEEPCFG.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetPDSLEEPCFG_WDTOSC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDSLEEPCFG.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetPDSLEEPCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDSLEEPCFG.Reg, volatile.LoadUint32(&o.PDSLEEPCFG.Reg)&^(0xff80)|value<<7)
}
func (o *SYSCON_Type) GetPDSLEEPCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDSLEEPCFG.Reg) & 0xff80) >> 7
}
func (o *SYSCON_Type) SetPDSLEEPCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDSLEEPCFG.Reg, volatile.LoadUint32(&o.PDSLEEPCFG.Reg)&^(0xffffff80)|value<<7)
}
func (o *SYSCON_Type) GetPDSLEEPCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDSLEEPCFG.Reg) & 0xffffff80) >> 7
}

// SYSCON.PDAWAKECFG: Power-down states for wake-up from deep-sleep
func (o *SYSCON_Type) SetPDAWAKECFG_IRCOUT_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetPDAWAKECFG_IRCOUT_PD() uint32 {
	return volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x1
}
func (o *SYSCON_Type) SetPDAWAKECFG_IRC_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetPDAWAKECFG_IRC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetPDAWAKECFG_FLASH_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetPDAWAKECFG_FLASH_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetPDAWAKECFG_BOD_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetPDAWAKECFG_BOD_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetPDAWAKECFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetPDAWAKECFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetPDAWAKECFG_SYSOSC_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetPDAWAKECFG_SYSOSC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetPDAWAKECFG_WDTOSC_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetPDAWAKECFG_WDTOSC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetPDAWAKECFG_SYSPLL_PD(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetPDAWAKECFG_SYSPLL_PD() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetPDAWAKECFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCON_Type) GetPDAWAKECFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0xf00) >> 8
}
func (o *SYSCON_Type) SetPDAWAKECFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x7000)|value<<12)
}
func (o *SYSCON_Type) GetPDAWAKECFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x7000) >> 12
}
func (o *SYSCON_Type) SetPDAWAKECFG_ACMP(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCON_Type) GetPDAWAKECFG_ACMP() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0x8000) >> 15
}
func (o *SYSCON_Type) SetPDAWAKECFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDAWAKECFG.Reg, volatile.LoadUint32(&o.PDAWAKECFG.Reg)&^(0xffff0000)|value<<16)
}
func (o *SYSCON_Type) GetPDAWAKECFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDAWAKECFG.Reg) & 0xffff0000) >> 16
}

// SYSCON.PDRUNCFG: Power configuration register
func (o *SYSCON_Type) SetPDRUNCFG_IRCOUT_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetPDRUNCFG_IRCOUT_PD() uint32 {
	return volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x1
}
func (o *SYSCON_Type) SetPDRUNCFG_IRC_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetPDRUNCFG_IRC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetPDRUNCFG_FLASH_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetPDRUNCFG_FLASH_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetPDRUNCFG_BOD_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetPDRUNCFG_BOD_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetPDRUNCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetPDRUNCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetPDRUNCFG_SYSOSC_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetPDRUNCFG_SYSOSC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetPDRUNCFG_WDTOSC_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetPDRUNCFG_WDTOSC_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetPDRUNCFG_SYSPLL_PD(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetPDRUNCFG_SYSPLL_PD() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetPDRUNCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCON_Type) GetPDRUNCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0xf00) >> 8
}
func (o *SYSCON_Type) SetPDRUNCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x7000)|value<<12)
}
func (o *SYSCON_Type) GetPDRUNCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x7000) >> 12
}
func (o *SYSCON_Type) SetPDRUNCFG_ACMP(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCON_Type) GetPDRUNCFG_ACMP() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0x8000) >> 15
}
func (o *SYSCON_Type) SetPDRUNCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PDRUNCFG.Reg, volatile.LoadUint32(&o.PDRUNCFG.Reg)&^(0xffff0000)|value<<16)
}
func (o *SYSCON_Type) GetPDRUNCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PDRUNCFG.Reg) & 0xffff0000) >> 16
}

// SYSCON.DEVICE_ID: Device ID
func (o *SYSCON_Type) SetDEVICE_ID(value uint32) {
	volatile.StoreUint32(&o.DEVICE_ID.Reg, value)
}
func (o *SYSCON_Type) GetDEVICE_ID() uint32 {
	return volatile.LoadUint32(&o.DEVICE_ID.Reg)
}

// I2C-bus interface
type I2C_Type struct {
	CFG      volatile.Register32 // 0x0
	STAT     volatile.Register32 // 0x4
	INTENSET volatile.Register32 // 0x8
	INTENCLR volatile.Register32 // 0xC
	TIMEOUT  volatile.Register32 // 0x10
	DIV      volatile.Register32 // 0x14
	INTSTAT  volatile.Register32 // 0x18
	_        [4]byte
	MSTCTL   volatile.Register32 // 0x20
	MSTTIME  volatile.Register32 // 0x24
	MSTDAT   volatile.Register32 // 0x28
	_        [20]byte
	SLVCTL   volatile.Register32 // 0x40
	SLVDAT   volatile.Register32 // 0x44
	SLVADR0  volatile.Register32 // 0x48
	SLVADR1  volatile.Register32 // 0x4C
	SLVADR2  volatile.Register32 // 0x50
	SLVADR3  volatile.Register32 // 0x54
	SLVQUAL0 volatile.Register32 // 0x58
	_        [36]byte
	MONRXDAT volatile.Register32 // 0x80
}

// I2C.CFG: Configuration for shared functions.
func (o *I2C_Type) SetCFG_MSTEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCFG_MSTEN() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x1
}
func (o *I2C_Type) SetCFG_SLVEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCFG_SLVEN() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCFG_MONEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCFG_MONEN() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCFG_TIMEOUTEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCFG_TIMEOUTEN() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCFG_MONCLKSTR(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCFG_MONCLKSTR() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0xffffffe0)|value<<5)
}
func (o *I2C_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0xffffffe0) >> 5
}

// I2C.STAT: Status register for Master, Slave, and Monitor functions.
func (o *I2C_Type) SetSTAT_MSTPENDING(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSTAT_MSTPENDING() uint32 {
	return volatile.LoadUint32(&o.STAT.Reg) & 0x1
}
func (o *I2C_Type) SetSTAT_MSTSTATE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xe)|value<<1)
}
func (o *I2C_Type) GetSTAT_MSTSTATE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xe) >> 1
}
func (o *I2C_Type) SetSTAT_MSTARBLOSS(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetSTAT_MSTARBLOSS() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetSTAT_MSTSTSTPERR(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetSTAT_MSTSTSTPERR() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetSTAT_SLVPENDING(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetSTAT_SLVPENDING() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetSTAT_SLVSTATE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x600)|value<<9)
}
func (o *I2C_Type) GetSTAT_SLVSTATE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x600) >> 9
}
func (o *I2C_Type) SetSTAT_SLVNOTSTR(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetSTAT_SLVNOTSTR() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetSTAT_SLVIDX(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x3000)|value<<12)
}
func (o *I2C_Type) GetSTAT_SLVIDX() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x3000) >> 12
}
func (o *I2C_Type) SetSTAT_SLVSEL(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetSTAT_SLVSEL() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetSTAT_SLVDESEL(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetSTAT_SLVDESEL() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetSTAT_MONRDY(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetSTAT_MONRDY() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetSTAT_MONOV(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x20000)|value<<17)
}
func (o *I2C_Type) GetSTAT_MONOV() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x20000) >> 17
}
func (o *I2C_Type) SetSTAT_MONACTIVE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x40000)|value<<18)
}
func (o *I2C_Type) GetSTAT_MONACTIVE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x40000) >> 18
}
func (o *I2C_Type) SetSTAT_MONIDLE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x80000)|value<<19)
}
func (o *I2C_Type) GetSTAT_MONIDLE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x80000) >> 19
}
func (o *I2C_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xf00000)|value<<20)
}
func (o *I2C_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xf00000) >> 20
}
func (o *I2C_Type) SetSTAT_EVENTTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C_Type) GetSTAT_EVENTTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x1000000) >> 24
}
func (o *I2C_Type) SetSTAT_SCLTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x2000000)|value<<25)
}
func (o *I2C_Type) GetSTAT_SCLTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x2000000) >> 25
}
func (o *I2C_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xfc000000)|value<<26)
}
func (o *I2C_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xfc000000) >> 26
}

// I2C.INTENSET: Interrupt Enable Set and read register.
func (o *I2C_Type) SetINTENSET_MSTPENDINGEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINTENSET_MSTPENDINGEN() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *I2C_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0xe)|value<<1)
}
func (o *I2C_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0xe) >> 1
}
func (o *I2C_Type) SetINTENSET_MSTARBLOSSEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINTENSET_MSTARBLOSSEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINTENSET_MSTSTSTPERREN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINTENSET_MSTSTSTPERREN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINTENSET_SLVPENDINGEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINTENSET_SLVPENDINGEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x600)|value<<9)
}
func (o *I2C_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x600) >> 9
}
func (o *I2C_Type) SetINTENSET_SLVNOTSTREN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINTENSET_SLVNOTSTREN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x7000)|value<<12)
}
func (o *I2C_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x7000) >> 12
}
func (o *I2C_Type) SetINTENSET_SLVDESELEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetINTENSET_SLVDESELEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetINTENSET_MONRDYEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetINTENSET_MONRDYEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetINTENSET_MONOVEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *I2C_Type) GetINTENSET_MONOVEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *I2C_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *I2C_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *I2C_Type) SetINTENSET_MONIDLEEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *I2C_Type) GetINTENSET_MONIDLEEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *I2C_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0xf00000)|value<<20)
}
func (o *I2C_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0xf00000) >> 20
}
func (o *I2C_Type) SetINTENSET_EVENTTIMEOUTEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C_Type) GetINTENSET_EVENTTIMEOUTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000000) >> 24
}
func (o *I2C_Type) SetINTENSET_SCLTIMEOUTEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000000)|value<<25)
}
func (o *I2C_Type) GetINTENSET_SCLTIMEOUTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000000) >> 25
}
func (o *I2C_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0xfc000000)|value<<26)
}
func (o *I2C_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0xfc000000) >> 26
}

// I2C.INTENCLR: Interrupt Enable Clear register.
func (o *I2C_Type) SetINTENCLR_MSTPENDINGCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINTENCLR_MSTPENDINGCLR() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *I2C_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0xe)|value<<1)
}
func (o *I2C_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0xe) >> 1
}
func (o *I2C_Type) SetINTENCLR_MSTARBLOSSCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINTENCLR_MSTARBLOSSCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINTENCLR_MSTSTSTPERRCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINTENCLR_MSTSTSTPERRCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINTENCLR_SLVPENDINGCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINTENCLR_SLVPENDINGCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x600)|value<<9)
}
func (o *I2C_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x600) >> 9
}
func (o *I2C_Type) SetINTENCLR_SLVNOTSTRCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINTENCLR_SLVNOTSTRCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x7000)|value<<12)
}
func (o *I2C_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x7000) >> 12
}
func (o *I2C_Type) SetINTENCLR_SLVDESELCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetINTENCLR_SLVDESELCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetINTENCLR_MONRDYCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetINTENCLR_MONRDYCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetINTENCLR_MONOVCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *I2C_Type) GetINTENCLR_MONOVCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *I2C_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *I2C_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *I2C_Type) SetINTENCLR_MONIDLECLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *I2C_Type) GetINTENCLR_MONIDLECLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *I2C_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0xf00000)|value<<20)
}
func (o *I2C_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0xf00000) >> 20
}
func (o *I2C_Type) SetINTENCLR_EVENTTIMEOUTCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C_Type) GetINTENCLR_EVENTTIMEOUTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000000) >> 24
}
func (o *I2C_Type) SetINTENCLR_SCLTIMEOUTCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *I2C_Type) GetINTENCLR_SCLTIMEOUTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000000) >> 25
}
func (o *I2C_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0xfc000000)|value<<26)
}
func (o *I2C_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0xfc000000) >> 26
}

// I2C.TIMEOUT: Time-out value register.
func (o *I2C_Type) SetTIMEOUT_TOMIN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUT.Reg, volatile.LoadUint32(&o.TIMEOUT.Reg)&^(0xf)|value)
}
func (o *I2C_Type) GetTIMEOUT_TOMIN() uint32 {
	return volatile.LoadUint32(&o.TIMEOUT.Reg) & 0xf
}
func (o *I2C_Type) SetTIMEOUT_TO(value uint32) {
	volatile.StoreUint32(&o.TIMEOUT.Reg, volatile.LoadUint32(&o.TIMEOUT.Reg)&^(0xfff0)|value<<4)
}
func (o *I2C_Type) GetTIMEOUT_TO() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUT.Reg) & 0xfff0) >> 4
}
func (o *I2C_Type) SetTIMEOUT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TIMEOUT.Reg, volatile.LoadUint32(&o.TIMEOUT.Reg)&^(0xffff0000)|value<<16)
}
func (o *I2C_Type) GetTIMEOUT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUT.Reg) & 0xffff0000) >> 16
}

// I2C.DIV: Clock pre-divider for the entire I2C block. This determines what time increments are used for the MSTTIME and SLVTIME registers.
func (o *I2C_Type) SetDIV_DIVVAL(value uint32) {
	volatile.StoreUint32(&o.DIV.Reg, volatile.LoadUint32(&o.DIV.Reg)&^(0xffff)|value)
}
func (o *I2C_Type) GetDIV_DIVVAL() uint32 {
	return volatile.LoadUint32(&o.DIV.Reg) & 0xffff
}
func (o *I2C_Type) SetDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DIV.Reg, volatile.LoadUint32(&o.DIV.Reg)&^(0xffff0000)|value<<16)
}
func (o *I2C_Type) GetDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DIV.Reg) & 0xffff0000) >> 16
}

// I2C.INTSTAT: Interrupt Status register for Master, Slave, and Monitor functions.
func (o *I2C_Type) SetINTSTAT_MSTPENDING(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINTSTAT_MSTPENDING() uint32 {
	return volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1
}
func (o *I2C_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0xe)|value<<1)
}
func (o *I2C_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0xe) >> 1
}
func (o *I2C_Type) SetINTSTAT_MSTARBLOSS(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINTSTAT_MSTARBLOSS() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINTSTAT_MSTSTSTPERR(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINTSTAT_MSTSTSTPERR() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINTSTAT_SLVPENDING(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINTSTAT_SLVPENDING() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x600)|value<<9)
}
func (o *I2C_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x600) >> 9
}
func (o *I2C_Type) SetINTSTAT_SLVNOTSTR(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINTSTAT_SLVNOTSTR() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x7000)|value<<12)
}
func (o *I2C_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x7000) >> 12
}
func (o *I2C_Type) SetINTSTAT_SLVDESEL(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetINTSTAT_SLVDESEL() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetINTSTAT_MONRDY(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetINTSTAT_MONRDY() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetINTSTAT_MONOV(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x20000)|value<<17)
}
func (o *I2C_Type) GetINTSTAT_MONOV() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x20000) >> 17
}
func (o *I2C_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x40000)|value<<18)
}
func (o *I2C_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x40000) >> 18
}
func (o *I2C_Type) SetINTSTAT_MONIDLE(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x80000)|value<<19)
}
func (o *I2C_Type) GetINTSTAT_MONIDLE() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x80000) >> 19
}
func (o *I2C_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0xf00000)|value<<20)
}
func (o *I2C_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0xf00000) >> 20
}
func (o *I2C_Type) SetINTSTAT_EVENTTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C_Type) GetINTSTAT_EVENTTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1000000) >> 24
}
func (o *I2C_Type) SetINTSTAT_SCLTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2000000)|value<<25)
}
func (o *I2C_Type) GetINTSTAT_SCLTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2000000) >> 25
}
func (o *I2C_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0xfc000000)|value<<26)
}
func (o *I2C_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0xfc000000) >> 26
}

// I2C.MSTCTL: Master control register.
func (o *I2C_Type) SetMSTCTL_MSTCONTINUE(value uint32) {
	volatile.StoreUint32(&o.MSTCTL.Reg, volatile.LoadUint32(&o.MSTCTL.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetMSTCTL_MSTCONTINUE() uint32 {
	return volatile.LoadUint32(&o.MSTCTL.Reg) & 0x1
}
func (o *I2C_Type) SetMSTCTL_MSTSTART(value uint32) {
	volatile.StoreUint32(&o.MSTCTL.Reg, volatile.LoadUint32(&o.MSTCTL.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetMSTCTL_MSTSTART() uint32 {
	return (volatile.LoadUint32(&o.MSTCTL.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetMSTCTL_MSTSTOP(value uint32) {
	volatile.StoreUint32(&o.MSTCTL.Reg, volatile.LoadUint32(&o.MSTCTL.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetMSTCTL_MSTSTOP() uint32 {
	return (volatile.LoadUint32(&o.MSTCTL.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetMSTCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MSTCTL.Reg, volatile.LoadUint32(&o.MSTCTL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *I2C_Type) GetMSTCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MSTCTL.Reg) & 0xfffffffc) >> 2
}

// I2C.MSTTIME: Master timing configuration.
func (o *I2C_Type) SetMSTTIME_MSTSCLLOW(value uint32) {
	volatile.StoreUint32(&o.MSTTIME.Reg, volatile.LoadUint32(&o.MSTTIME.Reg)&^(0x7)|value)
}
func (o *I2C_Type) GetMSTTIME_MSTSCLLOW() uint32 {
	return volatile.LoadUint32(&o.MSTTIME.Reg) & 0x7
}
func (o *I2C_Type) SetMSTTIME_MSTSCLHIGH(value uint32) {
	volatile.StoreUint32(&o.MSTTIME.Reg, volatile.LoadUint32(&o.MSTTIME.Reg)&^(0x70)|value<<4)
}
func (o *I2C_Type) GetMSTTIME_MSTSCLHIGH() uint32 {
	return (volatile.LoadUint32(&o.MSTTIME.Reg) & 0x70) >> 4
}
func (o *I2C_Type) SetMSTTIME_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MSTTIME.Reg, volatile.LoadUint32(&o.MSTTIME.Reg)&^(0xffffff80)|value<<7)
}
func (o *I2C_Type) GetMSTTIME_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MSTTIME.Reg) & 0xffffff80) >> 7
}

// I2C.MSTDAT: Combined Master receiver and transmitter data register.
func (o *I2C_Type) SetMSTDAT_DATA(value uint32) {
	volatile.StoreUint32(&o.MSTDAT.Reg, volatile.LoadUint32(&o.MSTDAT.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetMSTDAT_DATA() uint32 {
	return volatile.LoadUint32(&o.MSTDAT.Reg) & 0xff
}
func (o *I2C_Type) SetMSTDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MSTDAT.Reg, volatile.LoadUint32(&o.MSTDAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetMSTDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MSTDAT.Reg) & 0xffffff00) >> 8
}

// I2C.SLVCTL: Slave control register.
func (o *I2C_Type) SetSLVCTL_SlvContinue(value uint32) {
	volatile.StoreUint32(&o.SLVCTL.Reg, volatile.LoadUint32(&o.SLVCTL.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSLVCTL_SlvContinue() uint32 {
	return volatile.LoadUint32(&o.SLVCTL.Reg) & 0x1
}
func (o *I2C_Type) SetSLVCTL_SlvNack(value uint32) {
	volatile.StoreUint32(&o.SLVCTL.Reg, volatile.LoadUint32(&o.SLVCTL.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetSLVCTL_SlvNack() uint32 {
	return (volatile.LoadUint32(&o.SLVCTL.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetSLVCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SLVCTL.Reg, volatile.LoadUint32(&o.SLVCTL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *I2C_Type) GetSLVCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SLVCTL.Reg) & 0xfffffffc) >> 2
}

// I2C.SLVDAT: Combined Slave receiver and transmitter data register.
func (o *I2C_Type) SetSLVDAT_DATA(value uint32) {
	volatile.StoreUint32(&o.SLVDAT.Reg, volatile.LoadUint32(&o.SLVDAT.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetSLVDAT_DATA() uint32 {
	return volatile.LoadUint32(&o.SLVDAT.Reg) & 0xff
}
func (o *I2C_Type) SetSLVDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SLVDAT.Reg, volatile.LoadUint32(&o.SLVDAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetSLVDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SLVDAT.Reg) & 0xffffff00) >> 8
}

// I2C.SLVADR0: Slave address 0.
func (o *I2C_Type) SetSLVADR0_SADISABLE(value uint32) {
	volatile.StoreUint32(&o.SLVADR0.Reg, volatile.LoadUint32(&o.SLVADR0.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSLVADR0_SADISABLE() uint32 {
	return volatile.LoadUint32(&o.SLVADR0.Reg) & 0x1
}
func (o *I2C_Type) SetSLVADR0_SLVADR(value uint32) {
	volatile.StoreUint32(&o.SLVADR0.Reg, volatile.LoadUint32(&o.SLVADR0.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetSLVADR0_SLVADR() uint32 {
	return (volatile.LoadUint32(&o.SLVADR0.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetSLVADR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SLVADR0.Reg, volatile.LoadUint32(&o.SLVADR0.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetSLVADR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SLVADR0.Reg) & 0xffffff00) >> 8
}

// I2C.SLVADR1: Slave address 0.
func (o *I2C_Type) SetSLVADR1_SADISABLE(value uint32) {
	volatile.StoreUint32(&o.SLVADR1.Reg, volatile.LoadUint32(&o.SLVADR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSLVADR1_SADISABLE() uint32 {
	return volatile.LoadUint32(&o.SLVADR1.Reg) & 0x1
}
func (o *I2C_Type) SetSLVADR1_SLVADR(value uint32) {
	volatile.StoreUint32(&o.SLVADR1.Reg, volatile.LoadUint32(&o.SLVADR1.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetSLVADR1_SLVADR() uint32 {
	return (volatile.LoadUint32(&o.SLVADR1.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetSLVADR1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SLVADR1.Reg, volatile.LoadUint32(&o.SLVADR1.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetSLVADR1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SLVADR1.Reg) & 0xffffff00) >> 8
}

// I2C.SLVADR2: Slave address 0.
func (o *I2C_Type) SetSLVADR2_SADISABLE(value uint32) {
	volatile.StoreUint32(&o.SLVADR2.Reg, volatile.LoadUint32(&o.SLVADR2.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSLVADR2_SADISABLE() uint32 {
	return volatile.LoadUint32(&o.SLVADR2.Reg) & 0x1
}
func (o *I2C_Type) SetSLVADR2_SLVADR(value uint32) {
	volatile.StoreUint32(&o.SLVADR2.Reg, volatile.LoadUint32(&o.SLVADR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetSLVADR2_SLVADR() uint32 {
	return (volatile.LoadUint32(&o.SLVADR2.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetSLVADR2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SLVADR2.Reg, volatile.LoadUint32(&o.SLVADR2.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetSLVADR2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SLVADR2.Reg) & 0xffffff00) >> 8
}

// I2C.SLVADR3: Slave address 0.
func (o *I2C_Type) SetSLVADR3_SADISABLE(value uint32) {
	volatile.StoreUint32(&o.SLVADR3.Reg, volatile.LoadUint32(&o.SLVADR3.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSLVADR3_SADISABLE() uint32 {
	return volatile.LoadUint32(&o.SLVADR3.Reg) & 0x1
}
func (o *I2C_Type) SetSLVADR3_SLVADR(value uint32) {
	volatile.StoreUint32(&o.SLVADR3.Reg, volatile.LoadUint32(&o.SLVADR3.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetSLVADR3_SLVADR() uint32 {
	return (volatile.LoadUint32(&o.SLVADR3.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetSLVADR3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SLVADR3.Reg, volatile.LoadUint32(&o.SLVADR3.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetSLVADR3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SLVADR3.Reg) & 0xffffff00) >> 8
}

// I2C.SLVQUAL0: Slave Qualification for address 0.
func (o *I2C_Type) SetSLVQUAL0_QUALMODE0(value uint32) {
	volatile.StoreUint32(&o.SLVQUAL0.Reg, volatile.LoadUint32(&o.SLVQUAL0.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSLVQUAL0_QUALMODE0() uint32 {
	return volatile.LoadUint32(&o.SLVQUAL0.Reg) & 0x1
}
func (o *I2C_Type) SetSLVQUAL0(value uint32) {
	volatile.StoreUint32(&o.SLVQUAL0.Reg, volatile.LoadUint32(&o.SLVQUAL0.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetSLVQUAL0() uint32 {
	return (volatile.LoadUint32(&o.SLVQUAL0.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetSLVQUAL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SLVQUAL0.Reg, volatile.LoadUint32(&o.SLVQUAL0.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetSLVQUAL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SLVQUAL0.Reg) & 0xffffff00) >> 8
}

// I2C.MONRXDAT: Monitor receiver data register.
func (o *I2C_Type) SetMONRXDAT(value uint32) {
	volatile.StoreUint32(&o.MONRXDAT.Reg, volatile.LoadUint32(&o.MONRXDAT.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetMONRXDAT() uint32 {
	return volatile.LoadUint32(&o.MONRXDAT.Reg) & 0xff
}
func (o *I2C_Type) SetMONRXDAT_MONSTART(value uint32) {
	volatile.StoreUint32(&o.MONRXDAT.Reg, volatile.LoadUint32(&o.MONRXDAT.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetMONRXDAT_MONSTART() uint32 {
	return (volatile.LoadUint32(&o.MONRXDAT.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetMONRXDAT_MONRESTART(value uint32) {
	volatile.StoreUint32(&o.MONRXDAT.Reg, volatile.LoadUint32(&o.MONRXDAT.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetMONRXDAT_MONRESTART() uint32 {
	return (volatile.LoadUint32(&o.MONRXDAT.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetMONRXDAT_MONNACK(value uint32) {
	volatile.StoreUint32(&o.MONRXDAT.Reg, volatile.LoadUint32(&o.MONRXDAT.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetMONRXDAT_MONNACK() uint32 {
	return (volatile.LoadUint32(&o.MONRXDAT.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetMONRXDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MONRXDAT.Reg, volatile.LoadUint32(&o.MONRXDAT.Reg)&^(0xfffff800)|value<<11)
}
func (o *I2C_Type) GetMONRXDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MONRXDAT.Reg) & 0xfffff800) >> 11
}

// SPI
type SPI_Type struct {
	CFG      volatile.Register32 // 0x0
	DLY      volatile.Register32 // 0x4
	STAT     volatile.Register32 // 0x8
	INTENSET volatile.Register32 // 0xC
	INTENCLR volatile.Register32 // 0x10
	RXDAT    volatile.Register32 // 0x14
	TXDATCTL volatile.Register32 // 0x18
	TXDAT    volatile.Register32 // 0x1C
	TXCTL    volatile.Register32 // 0x20
	DIV      volatile.Register32 // 0x24
	INTSTAT  volatile.Register32 // 0x28
}

// SPI.CFG: SPI Configuration register
func (o *SPI_Type) SetCFG_Enable(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCFG_Enable() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x1
}
func (o *SPI_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCFG_Master(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCFG_Master() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCFG_LSBF(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetCFG_LSBF() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetCFG_CPHA(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetCFG_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetCFG_CPOL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetCFG_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCFG_Loop(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCFG_Loop() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCFG_SPOL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetCFG_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0xfffffe00)|value<<9)
}
func (o *SPI_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0xfffffe00) >> 9
}

// SPI.DLY: SPI Delay register
func (o *SPI_Type) SetDLY_PRE_DELAY(value uint32) {
	volatile.StoreUint32(&o.DLY.Reg, volatile.LoadUint32(&o.DLY.Reg)&^(0xf)|value)
}
func (o *SPI_Type) GetDLY_PRE_DELAY() uint32 {
	return volatile.LoadUint32(&o.DLY.Reg) & 0xf
}
func (o *SPI_Type) SetDLY_POST_DELAY(value uint32) {
	volatile.StoreUint32(&o.DLY.Reg, volatile.LoadUint32(&o.DLY.Reg)&^(0xf0)|value<<4)
}
func (o *SPI_Type) GetDLY_POST_DELAY() uint32 {
	return (volatile.LoadUint32(&o.DLY.Reg) & 0xf0) >> 4
}
func (o *SPI_Type) SetDLY_FRAME_DELAY(value uint32) {
	volatile.StoreUint32(&o.DLY.Reg, volatile.LoadUint32(&o.DLY.Reg)&^(0xf00)|value<<8)
}
func (o *SPI_Type) GetDLY_FRAME_DELAY() uint32 {
	return (volatile.LoadUint32(&o.DLY.Reg) & 0xf00) >> 8
}
func (o *SPI_Type) SetDLY_TRANSFER_DELAY(value uint32) {
	volatile.StoreUint32(&o.DLY.Reg, volatile.LoadUint32(&o.DLY.Reg)&^(0xf000)|value<<12)
}
func (o *SPI_Type) GetDLY_TRANSFER_DELAY() uint32 {
	return (volatile.LoadUint32(&o.DLY.Reg) & 0xf000) >> 12
}
func (o *SPI_Type) SetDLY_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DLY.Reg, volatile.LoadUint32(&o.DLY.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI_Type) GetDLY_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DLY.Reg) & 0xffff0000) >> 16
}

// SPI.STAT: SPI Status. Some status flags can be cleared by writing a 1 to that bit position
func (o *SPI_Type) SetSTAT_RXRDY(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSTAT_RXRDY() uint32 {
	return volatile.LoadUint32(&o.STAT.Reg) & 0x1
}
func (o *SPI_Type) SetSTAT_TXRDY(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSTAT_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSTAT_RXOV(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetSTAT_RXOV() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetSTAT_TXUR(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetSTAT_TXUR() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetSTAT_SSA(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetSTAT_SSA() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetSTAT_SSD(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetSTAT_SSD() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetSTAT_STALLED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetSTAT_STALLED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetSTAT_ENDTRANSFER(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetSTAT_ENDTRANSFER() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetSTAT_IDLE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSTAT_IDLE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xfffffe00)|value<<9)
}
func (o *SPI_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xfffffe00) >> 9
}

// SPI.INTENSET: SPI Interrupt Enable read and Set. A complete value may be read from this register. Writing a 1 to any implemented bit position causes that bit to be set.
func (o *SPI_Type) SetINTENSET_RXRDYEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetINTENSET_RXRDYEN() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *SPI_Type) SetINTENSET_TXRDYEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetINTENSET_TXRDYEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetINTENSET_RXOVEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetINTENSET_RXOVEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetINTENSET_TXUREN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetINTENSET_TXUREN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetINTENSET_SSAEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetINTENSET_SSAEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetINTENSET_SSDEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetINTENSET_SSDEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SPI_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0xffffffc0) >> 6
}

// SPI.INTENCLR: SPI Interrupt Enable Clear. Writing a 1 to any implemented bit position causes the corresponding bit in INTENSET to be cleared.
func (o *SPI_Type) SetINTENCLR_RXRDYEN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetINTENCLR_RXRDYEN() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *SPI_Type) SetINTENCLR_TXRDYEN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetINTENCLR_TXRDYEN() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetINTENCLR_RXOVEN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetINTENCLR_RXOVEN() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetINTENCLR_TXUREN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetINTENCLR_TXUREN() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetINTENCLR_SSAEN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetINTENCLR_SSAEN() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetINTENCLR_SSDEN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetINTENCLR_SSDEN() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SPI_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0xffffffc0) >> 6
}

// SPI.RXDAT: SPI Receive Data
func (o *SPI_Type) SetRXDAT(value uint32) {
	volatile.StoreUint32(&o.RXDAT.Reg, volatile.LoadUint32(&o.RXDAT.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRXDAT() uint32 {
	return volatile.LoadUint32(&o.RXDAT.Reg) & 0xffff
}
func (o *SPI_Type) SetRXDAT_RXSSELN(value uint32) {
	volatile.StoreUint32(&o.RXDAT.Reg, volatile.LoadUint32(&o.RXDAT.Reg)&^(0x10000)|value<<16)
}
func (o *SPI_Type) GetRXDAT_RXSSELN() uint32 {
	return (volatile.LoadUint32(&o.RXDAT.Reg) & 0x10000) >> 16
}
func (o *SPI_Type) SetRXDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXDAT.Reg, volatile.LoadUint32(&o.RXDAT.Reg)&^(0xe0000)|value<<17)
}
func (o *SPI_Type) GetRXDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXDAT.Reg) & 0xe0000) >> 17
}
func (o *SPI_Type) SetRXDAT_SOT(value uint32) {
	volatile.StoreUint32(&o.RXDAT.Reg, volatile.LoadUint32(&o.RXDAT.Reg)&^(0x100000)|value<<20)
}
func (o *SPI_Type) GetRXDAT_SOT() uint32 {
	return (volatile.LoadUint32(&o.RXDAT.Reg) & 0x100000) >> 20
}
func (o *SPI_Type) SetRXDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXDAT.Reg, volatile.LoadUint32(&o.RXDAT.Reg)&^(0xffe00000)|value<<21)
}
func (o *SPI_Type) GetRXDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXDAT.Reg) & 0xffe00000) >> 21
}

// SPI.TXDATCTL: SPI Transmit Data with Control
func (o *SPI_Type) SetTXDATCTL_TXDAT(value uint32) {
	volatile.StoreUint32(&o.TXDATCTL.Reg, volatile.LoadUint32(&o.TXDATCTL.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXDATCTL_TXDAT() uint32 {
	return volatile.LoadUint32(&o.TXDATCTL.Reg) & 0xffff
}
func (o *SPI_Type) SetTXDATCTL_TXSSELN(value uint32) {
	volatile.StoreUint32(&o.TXDATCTL.Reg, volatile.LoadUint32(&o.TXDATCTL.Reg)&^(0x10000)|value<<16)
}
func (o *SPI_Type) GetTXDATCTL_TXSSELN() uint32 {
	return (volatile.LoadUint32(&o.TXDATCTL.Reg) & 0x10000) >> 16
}
func (o *SPI_Type) SetTXDATCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXDATCTL.Reg, volatile.LoadUint32(&o.TXDATCTL.Reg)&^(0xe0000)|value<<17)
}
func (o *SPI_Type) GetTXDATCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXDATCTL.Reg) & 0xe0000) >> 17
}
func (o *SPI_Type) SetTXDATCTL_EOT(value uint32) {
	volatile.StoreUint32(&o.TXDATCTL.Reg, volatile.LoadUint32(&o.TXDATCTL.Reg)&^(0x100000)|value<<20)
}
func (o *SPI_Type) GetTXDATCTL_EOT() uint32 {
	return (volatile.LoadUint32(&o.TXDATCTL.Reg) & 0x100000) >> 20
}
func (o *SPI_Type) SetTXDATCTL_EOF(value uint32) {
	volatile.StoreUint32(&o.TXDATCTL.Reg, volatile.LoadUint32(&o.TXDATCTL.Reg)&^(0x200000)|value<<21)
}
func (o *SPI_Type) GetTXDATCTL_EOF() uint32 {
	return (volatile.LoadUint32(&o.TXDATCTL.Reg) & 0x200000) >> 21
}
func (o *SPI_Type) SetTXDATCTL_RXIGNORE(value uint32) {
	volatile.StoreUint32(&o.TXDATCTL.Reg, volatile.LoadUint32(&o.TXDATCTL.Reg)&^(0x400000)|value<<22)
}
func (o *SPI_Type) GetTXDATCTL_RXIGNORE() uint32 {
	return (volatile.LoadUint32(&o.TXDATCTL.Reg) & 0x400000) >> 22
}
func (o *SPI_Type) SetTXDATCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXDATCTL.Reg, volatile.LoadUint32(&o.TXDATCTL.Reg)&^(0x800000)|value<<23)
}
func (o *SPI_Type) GetTXDATCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXDATCTL.Reg) & 0x800000) >> 23
}
func (o *SPI_Type) SetTXDATCTL_FLEN(value uint32) {
	volatile.StoreUint32(&o.TXDATCTL.Reg, volatile.LoadUint32(&o.TXDATCTL.Reg)&^(0xf000000)|value<<24)
}
func (o *SPI_Type) GetTXDATCTL_FLEN() uint32 {
	return (volatile.LoadUint32(&o.TXDATCTL.Reg) & 0xf000000) >> 24
}
func (o *SPI_Type) SetTXDATCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXDATCTL.Reg, volatile.LoadUint32(&o.TXDATCTL.Reg)&^(0xf0000000)|value<<28)
}
func (o *SPI_Type) GetTXDATCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXDATCTL.Reg) & 0xf0000000) >> 28
}

// SPI.TXDAT: SPI Transmit Data
func (o *SPI_Type) SetTXDAT_DATA(value uint32) {
	volatile.StoreUint32(&o.TXDAT.Reg, volatile.LoadUint32(&o.TXDAT.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXDAT_DATA() uint32 {
	return volatile.LoadUint32(&o.TXDAT.Reg) & 0xffff
}
func (o *SPI_Type) SetTXDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXDAT.Reg, volatile.LoadUint32(&o.TXDAT.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI_Type) GetTXDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXDAT.Reg) & 0xffff0000) >> 16
}

// SPI.TXCTL: SPI Transmit Control
func (o *SPI_Type) SetTXCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXCTL.Reg, volatile.LoadUint32(&o.TXCTL.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXCTL_RESERVED() uint32 {
	return volatile.LoadUint32(&o.TXCTL.Reg) & 0xffff
}
func (o *SPI_Type) SetTXCTL_TX_SSEL(value uint32) {
	volatile.StoreUint32(&o.TXCTL.Reg, volatile.LoadUint32(&o.TXCTL.Reg)&^(0x10000)|value<<16)
}
func (o *SPI_Type) GetTXCTL_TX_SSEL() uint32 {
	return (volatile.LoadUint32(&o.TXCTL.Reg) & 0x10000) >> 16
}
func (o *SPI_Type) SetTXCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXCTL.Reg, volatile.LoadUint32(&o.TXCTL.Reg)&^(0xe0000)|value<<17)
}
func (o *SPI_Type) GetTXCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXCTL.Reg) & 0xe0000) >> 17
}
func (o *SPI_Type) SetTXCTL_EOT(value uint32) {
	volatile.StoreUint32(&o.TXCTL.Reg, volatile.LoadUint32(&o.TXCTL.Reg)&^(0x100000)|value<<20)
}
func (o *SPI_Type) GetTXCTL_EOT() uint32 {
	return (volatile.LoadUint32(&o.TXCTL.Reg) & 0x100000) >> 20
}
func (o *SPI_Type) SetTXCTL_EOF(value uint32) {
	volatile.StoreUint32(&o.TXCTL.Reg, volatile.LoadUint32(&o.TXCTL.Reg)&^(0x200000)|value<<21)
}
func (o *SPI_Type) GetTXCTL_EOF() uint32 {
	return (volatile.LoadUint32(&o.TXCTL.Reg) & 0x200000) >> 21
}
func (o *SPI_Type) SetTXCTL_RXIGNORE(value uint32) {
	volatile.StoreUint32(&o.TXCTL.Reg, volatile.LoadUint32(&o.TXCTL.Reg)&^(0x400000)|value<<22)
}
func (o *SPI_Type) GetTXCTL_RXIGNORE() uint32 {
	return (volatile.LoadUint32(&o.TXCTL.Reg) & 0x400000) >> 22
}
func (o *SPI_Type) SetTXCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXCTL.Reg, volatile.LoadUint32(&o.TXCTL.Reg)&^(0x800000)|value<<23)
}
func (o *SPI_Type) GetTXCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXCTL.Reg) & 0x800000) >> 23
}
func (o *SPI_Type) SetTXCTL_FLEN(value uint32) {
	volatile.StoreUint32(&o.TXCTL.Reg, volatile.LoadUint32(&o.TXCTL.Reg)&^(0xf000000)|value<<24)
}
func (o *SPI_Type) GetTXCTL_FLEN() uint32 {
	return (volatile.LoadUint32(&o.TXCTL.Reg) & 0xf000000) >> 24
}
func (o *SPI_Type) SetTXCTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXCTL.Reg, volatile.LoadUint32(&o.TXCTL.Reg)&^(0xf0000000)|value<<28)
}
func (o *SPI_Type) GetTXCTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXCTL.Reg) & 0xf0000000) >> 28
}

// SPI.DIV: SPI clock Divider
func (o *SPI_Type) SetDIV_DIVVAL(value uint32) {
	volatile.StoreUint32(&o.DIV.Reg, volatile.LoadUint32(&o.DIV.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetDIV_DIVVAL() uint32 {
	return volatile.LoadUint32(&o.DIV.Reg) & 0xffff
}
func (o *SPI_Type) SetDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DIV.Reg, volatile.LoadUint32(&o.DIV.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI_Type) GetDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DIV.Reg) & 0xffff0000) >> 16
}

// SPI.INTSTAT: SPI Interrupt Status
func (o *SPI_Type) SetINTSTAT_RXRDY(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetINTSTAT_RXRDY() uint32 {
	return volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1
}
func (o *SPI_Type) SetINTSTAT_TXRDY(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetINTSTAT_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetINTSTAT_RXOV(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetINTSTAT_RXOV() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetINTSTAT_TXUR(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetINTSTAT_TXUR() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetINTSTAT_SSA(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetINTSTAT_SSA() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetINTSTAT_SSD(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetINTSTAT_SSD() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SPI_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0xffffffc0) >> 6
}

// USART
type USART_Type struct {
	CFG        volatile.Register32 // 0x0
	CTRL       volatile.Register32 // 0x4
	STAT       volatile.Register32 // 0x8
	INTENSET   volatile.Register32 // 0xC
	INTENCLR   volatile.Register32 // 0x10
	RXDATA     volatile.Register32 // 0x14
	RXDATASTAT volatile.Register32 // 0x18
	TXDATA     volatile.Register32 // 0x1C
	BRG        volatile.Register32 // 0x20
	INTSTAT    volatile.Register32 // 0x24
}

// USART.CFG: USART Configuration register. Basic USART configuration settings that typically are not changed during operation.
func (o *USART_Type) SetCFG_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCFG_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x1
}
func (o *USART_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCFG_DATALEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0xc)|value<<2)
}
func (o *USART_Type) GetCFG_DATALEN() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0xc) >> 2
}
func (o *USART_Type) SetCFG_PARITYSEL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x30)|value<<4)
}
func (o *USART_Type) GetCFG_PARITYSEL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x30) >> 4
}
func (o *USART_Type) SetCFG_STOPLEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCFG_STOPLEN() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCFG_CTSEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCFG_CTSEN() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCFG_SYNCEN(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCFG_SYNCEN() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCFG_CLKPOL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCFG_CLKPOL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCFG_SYNCMST(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCFG_SYNCMST() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCFG_LOOP(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCFG_LOOP() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0xffff0000)|value<<16)
}
func (o *USART_Type) GetCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0xffff0000) >> 16
}

// USART.CTRL: USART Control register. USART control settings that are more likely to change during operation.
func (o *USART_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCTRL_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *USART_Type) SetCTRL_TXBRKEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCTRL_TXBRKEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCTRL_ADDRDET(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCTRL_ADDRDET() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x38)|value<<3)
}
func (o *USART_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x38) >> 3
}
func (o *USART_Type) SetCTRL_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCTRL_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCTRL_CC(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCTRL_CC() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCTRL_CLRCC(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCTRL_CLRCC() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xfffffc00)|value<<10)
}
func (o *USART_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xfffffc00) >> 10
}

// USART.STAT: USART Status register. The complete status value can be read here. Writing 1s clears some bits in the register. Some bits can be cleared by writing a 1 to them.
func (o *USART_Type) SetSTAT_RXRDY(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetSTAT_RXRDY() uint32 {
	return volatile.LoadUint32(&o.STAT.Reg) & 0x1
}
func (o *USART_Type) SetSTAT_RXIDLE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetSTAT_RXIDLE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetSTAT_TXRDY(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetSTAT_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetSTAT_TXIDLE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetSTAT_TXIDLE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetSTAT_CTS(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetSTAT_CTS() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetSTAT_DELTACTS(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetSTAT_DELTACTS() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetSTAT_TXDISINT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetSTAT_TXDISINT() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetSTAT_OVERRUNINT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetSTAT_OVERRUNINT() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetSTAT_RXBRK(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetSTAT_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetSTAT_DELTARXBRK(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetSTAT_DELTARXBRK() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetSTAT_START(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetSTAT_START() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetSTAT_FRAMERRINT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetSTAT_FRAMERRINT() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetSTAT_PARITYERRINT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetSTAT_PARITYERRINT() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetSTAT_RXNOISEINT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetSTAT_RXNOISEINT() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xffff0000)|value<<16)
}
func (o *USART_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xffff0000) >> 16
}

// USART.INTENSET: Interrupt Enable read and Set register. Contains an individual interrupt enable bit for each potential USART interrupt. A complete value may be read from this register. Writing a 1 to any implemented bit position causes that bit to be set.
func (o *USART_Type) SetINTENSET_RXRDYEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetINTENSET_RXRDYEN() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *USART_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetINTENSET_TXRDYEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetINTENSET_TXRDYEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x18)|value<<3)
}
func (o *USART_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x18) >> 3
}
func (o *USART_Type) SetINTENSET_DELTACTSEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetINTENSET_DELTACTSEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetINTENSET_TXDISINTEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetINTENSET_TXDISINTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetINTENSET_OVERRUNEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetINTENSET_OVERRUNEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x600)|value<<9)
}
func (o *USART_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x600) >> 9
}
func (o *USART_Type) SetINTENSET_DELTARXBRKEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetINTENSET_DELTARXBRKEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetINTENSET_STARTEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetINTENSET_STARTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetINTENSET_FRAMERREN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetINTENSET_FRAMERREN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetINTENSET_PARITYERREN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetINTENSET_PARITYERREN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetINTENSET_RXNOISEEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetINTENSET_RXNOISEEN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetINTENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0xffff0000)|value<<16)
}
func (o *USART_Type) GetINTENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0xffff0000) >> 16
}

// USART.INTENCLR: Interrupt Enable Clear register. Allows clearing any combination of bits in the INTENSET register. Writing a 1 to any implemented bit position causes the corresponding bit to be cleared.
func (o *USART_Type) SetINTENCLR_RXRDYCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetINTENCLR_RXRDYCLR() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *USART_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetINTENCLR_TXRDYCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetINTENCLR_TXRDYCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x18)|value<<3)
}
func (o *USART_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x18) >> 3
}
func (o *USART_Type) SetINTENCLR_DELTACTSCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetINTENCLR_DELTACTSCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetINTENCLR_TXDISINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetINTENCLR_TXDISINTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetINTENCLR_OVERRUNCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetINTENCLR_OVERRUNCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x600)|value<<9)
}
func (o *USART_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x600) >> 9
}
func (o *USART_Type) SetINTENCLR_DELTARXBRKCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetINTENCLR_DELTARXBRKCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetINTENCLR_STARTCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetINTENCLR_STARTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetINTENCLR_FRAMERRCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetINTENCLR_FRAMERRCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetINTENCLR_PARITYERRCLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetINTENCLR_PARITYERRCLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetINTENCLR_RXNOISECLR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetINTENCLR_RXNOISECLR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetINTENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *USART_Type) GetINTENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0xffff0000) >> 16
}

// USART.RXDATA: Receiver Data register. Contains the last character received.
func (o *USART_Type) SetRXDATA_RXDAT(value uint32) {
	volatile.StoreUint32(&o.RXDATA.Reg, volatile.LoadUint32(&o.RXDATA.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetRXDATA_RXDAT() uint32 {
	return volatile.LoadUint32(&o.RXDATA.Reg) & 0x1ff
}
func (o *USART_Type) SetRXDATA_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXDATA.Reg, volatile.LoadUint32(&o.RXDATA.Reg)&^(0xfffffe00)|value<<9)
}
func (o *USART_Type) GetRXDATA_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXDATA.Reg) & 0xfffffe00) >> 9
}

// USART.RXDATASTAT: Receiver Data with Status register. Combines the last character received with the current USART receive status. Allows software to recover incoming data and status together.
func (o *USART_Type) SetRXDATASTAT_RXDAT(value uint32) {
	volatile.StoreUint32(&o.RXDATASTAT.Reg, volatile.LoadUint32(&o.RXDATASTAT.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetRXDATASTAT_RXDAT() uint32 {
	return volatile.LoadUint32(&o.RXDATASTAT.Reg) & 0x1ff
}
func (o *USART_Type) SetRXDATASTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXDATASTAT.Reg, volatile.LoadUint32(&o.RXDATASTAT.Reg)&^(0x1e00)|value<<9)
}
func (o *USART_Type) GetRXDATASTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXDATASTAT.Reg) & 0x1e00) >> 9
}
func (o *USART_Type) SetRXDATASTAT_FRAMERR(value uint32) {
	volatile.StoreUint32(&o.RXDATASTAT.Reg, volatile.LoadUint32(&o.RXDATASTAT.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetRXDATASTAT_FRAMERR() uint32 {
	return (volatile.LoadUint32(&o.RXDATASTAT.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetRXDATASTAT_PARITYERR(value uint32) {
	volatile.StoreUint32(&o.RXDATASTAT.Reg, volatile.LoadUint32(&o.RXDATASTAT.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetRXDATASTAT_PARITYERR() uint32 {
	return (volatile.LoadUint32(&o.RXDATASTAT.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetRXDATASTAT_RXNOISE(value uint32) {
	volatile.StoreUint32(&o.RXDATASTAT.Reg, volatile.LoadUint32(&o.RXDATASTAT.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetRXDATASTAT_RXNOISE() uint32 {
	return (volatile.LoadUint32(&o.RXDATASTAT.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetRXDATASTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXDATASTAT.Reg, volatile.LoadUint32(&o.RXDATASTAT.Reg)&^(0xffff0000)|value<<16)
}
func (o *USART_Type) GetRXDATASTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXDATASTAT.Reg) & 0xffff0000) >> 16
}

// USART.TXDATA: Transmit Data register. Data to be transmitted is written here.
func (o *USART_Type) SetTXDATA_TXDAT(value uint32) {
	volatile.StoreUint32(&o.TXDATA.Reg, volatile.LoadUint32(&o.TXDATA.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetTXDATA_TXDAT() uint32 {
	return volatile.LoadUint32(&o.TXDATA.Reg) & 0x1ff
}
func (o *USART_Type) SetTXDATA_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXDATA.Reg, volatile.LoadUint32(&o.TXDATA.Reg)&^(0xfffffe00)|value<<9)
}
func (o *USART_Type) GetTXDATA_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXDATA.Reg) & 0xfffffe00) >> 9
}

// USART.BRG: Baud Rate Generator register. 16-bit integer baud rate divisor value.
func (o *USART_Type) SetBRG_BRGVAL(value uint32) {
	volatile.StoreUint32(&o.BRG.Reg, volatile.LoadUint32(&o.BRG.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetBRG_BRGVAL() uint32 {
	return volatile.LoadUint32(&o.BRG.Reg) & 0xffff
}
func (o *USART_Type) SetBRG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BRG.Reg, volatile.LoadUint32(&o.BRG.Reg)&^(0xffff0000)|value<<16)
}
func (o *USART_Type) GetBRG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.BRG.Reg) & 0xffff0000) >> 16
}

// USART.INTSTAT: Interrupt status register. Reflects interrupts that are currently enabled.
func (o *USART_Type) SetINTSTAT_RXRDY(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetINTSTAT_RXRDY() uint32 {
	return volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1
}
func (o *USART_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetINTSTAT_TXRDY(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetINTSTAT_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x18)|value<<3)
}
func (o *USART_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x18) >> 3
}
func (o *USART_Type) SetINTSTAT_DELTACTS(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetINTSTAT_DELTACTS() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetINTSTAT_TXDISINT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetINTSTAT_TXDISINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetINTSTAT_OVERRUNINT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetINTSTAT_OVERRUNINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x600)|value<<9)
}
func (o *USART_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x600) >> 9
}
func (o *USART_Type) SetINTSTAT_DELTARXBRK(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetINTSTAT_DELTARXBRK() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetINTSTAT_START(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetINTSTAT_START() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetINTSTAT_FRAMERRINT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetINTSTAT_FRAMERRINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetINTSTAT_PARITYERRINT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetINTSTAT_PARITYERRINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetINTSTAT_RXNOISEINT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetINTSTAT_RXNOISEINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0xffff0000)|value<<16)
}
func (o *USART_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0xffff0000) >> 16
}

// Cyclic Redundancy Check (CRC) engine
type CRC_Type struct {
	MODE volatile.Register32 // 0x0
	SEED volatile.Register32 // 0x4
	SUM  volatile.Register32 // 0x8
}

// CRC.MODE: CRC mode register
func (o *CRC_Type) SetMODE_CRC_POLY(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x3)|value)
}
func (o *CRC_Type) GetMODE_CRC_POLY() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x3
}
func (o *CRC_Type) SetMODE_BIT_RVS_WR(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x4)|value<<2)
}
func (o *CRC_Type) GetMODE_BIT_RVS_WR() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x4) >> 2
}
func (o *CRC_Type) SetMODE_CMPL_WR(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x8)|value<<3)
}
func (o *CRC_Type) GetMODE_CMPL_WR() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x8) >> 3
}
func (o *CRC_Type) SetMODE_BIT_RVS_SUM(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x10)|value<<4)
}
func (o *CRC_Type) GetMODE_BIT_RVS_SUM() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x10) >> 4
}
func (o *CRC_Type) SetMODE_CMPL_SUM(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x20)|value<<5)
}
func (o *CRC_Type) GetMODE_CMPL_SUM() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x20) >> 5
}
func (o *CRC_Type) SetMODE_Reserved(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0xffffffc0)|value<<6)
}
func (o *CRC_Type) GetMODE_Reserved() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0xffffffc0) >> 6
}

// CRC.SEED: CRC seed register
func (o *CRC_Type) SetSEED(value uint32) {
	volatile.StoreUint32(&o.SEED.Reg, value)
}
func (o *CRC_Type) GetSEED() uint32 {
	return volatile.LoadUint32(&o.SEED.Reg)
}

// CRC.SUM: CRC checksum register
func (o *CRC_Type) SetSUM(value uint32) {
	volatile.StoreUint32(&o.SUM.Reg, value)
}
func (o *CRC_Type) GetSUM() uint32 {
	return volatile.LoadUint32(&o.SUM.Reg)
}

// State Configurable Timer (SCT)
type SCT_Type struct {
	CONFIG        volatile.Register32 // 0x0
	CTRL          volatile.Register32 // 0x4
	LIMIT         volatile.Register32 // 0x8
	HALT          volatile.Register32 // 0xC
	STOP          volatile.Register32 // 0x10
	START         volatile.Register32 // 0x14
	_             [40]byte
	COUNT         volatile.Register32 // 0x40
	STATE         volatile.Register32 // 0x44
	INPUT         volatile.Register32 // 0x48
	REGMODE       volatile.Register32 // 0x4C
	OUTPUT        volatile.Register32 // 0x50
	OUTPUTDIRCTRL volatile.Register32 // 0x54
	RES           volatile.Register32 // 0x58
	_             [148]byte
	EVEN          volatile.Register32 // 0xF0
	EVFLAG        volatile.Register32 // 0xF4
	CONEN         volatile.Register32 // 0xF8
	CONFLAG       volatile.Register32 // 0xFC
	MATCH0        volatile.Register32 // 0x100
	MATCH1        volatile.Register32 // 0x104
	MATCH2        volatile.Register32 // 0x108
	MATCH3        volatile.Register32 // 0x10C
	MATCH4        volatile.Register32 // 0x110
	_             [236]byte
	MATCHREL0     volatile.Register32 // 0x200
	MATCHREL1     volatile.Register32 // 0x204
	MATCHREL2     volatile.Register32 // 0x208
	MATCHREL3     volatile.Register32 // 0x20C
	MATCHREL4     volatile.Register32 // 0x210
	_             [236]byte
	EV0_STATE     volatile.Register32 // 0x300
	EV0_CTRL      volatile.Register32 // 0x304
	EV1_STATE     volatile.Register32 // 0x308
	EV1_CTRL      volatile.Register32 // 0x30C
	EV2_STATE     volatile.Register32 // 0x310
	EV2_CTRL      volatile.Register32 // 0x314
	EV3_STATE     volatile.Register32 // 0x318
	EV3_CTRL      volatile.Register32 // 0x31C
	EV4_STATE     volatile.Register32 // 0x320
	EV4_CTRL      volatile.Register32 // 0x324
	EV5_STATE     volatile.Register32 // 0x328
	EV5_CTRL      volatile.Register32 // 0x32C
	_             [464]byte
	OUT0_SET      volatile.Register32 // 0x500
	OUT0_CLR      volatile.Register32 // 0x504
	OUT1_SET      volatile.Register32 // 0x508
	OUT1_CLR      volatile.Register32 // 0x50C
	OUT2_SET      volatile.Register32 // 0x510
	OUT2_CLR      volatile.Register32 // 0x514
	OUT3_SET      volatile.Register32 // 0x518
	OUT3_CLR      volatile.Register32 // 0x51C
}

// SCT.CONFIG: SCT configuration register
func (o *SCT_Type) SetCONFIG_UNIFY(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetCONFIG_UNIFY() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *SCT_Type) SetCONFIG_CLKMODE(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x6)|value<<1)
}
func (o *SCT_Type) GetCONFIG_CLKMODE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x6) >> 1
}
func (o *SCT_Type) SetCONFIG_CLKSEL(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x78)|value<<3)
}
func (o *SCT_Type) GetCONFIG_CLKSEL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x78) >> 3
}
func (o *SCT_Type) SetCONFIG_NORELAOD_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x80)|value<<7)
}
func (o *SCT_Type) GetCONFIG_NORELAOD_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x80) >> 7
}
func (o *SCT_Type) SetCONFIG_NORELOAD_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x100)|value<<8)
}
func (o *SCT_Type) GetCONFIG_NORELOAD_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x100) >> 8
}
func (o *SCT_Type) SetCONFIG_INSYNC(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1fe00)|value<<9)
}
func (o *SCT_Type) GetCONFIG_INSYNC() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x1fe00) >> 9
}
func (o *SCT_Type) SetCONFIG_AUTOLIMIT_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetCONFIG_AUTOLIMIT_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetCONFIG_AUTOLIMIT_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetCONFIG_AUTOLIMIT_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetCONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0xfff80000)|value<<19)
}
func (o *SCT_Type) GetCONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0xfff80000) >> 19
}

// SCT.CTRL: SCT control register
func (o *SCT_Type) SetCTRL_DOWN_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetCTRL_DOWN_L() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *SCT_Type) SetCTRL_STOP_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetCTRL_STOP_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetCTRL_HALT_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetCTRL_HALT_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetCTRL_CLRCTR_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetCTRL_CLRCTR_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetCTRL_BIDIR_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetCTRL_BIDIR_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetCTRL_PRE_L(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1fe0)|value<<5)
}
func (o *SCT_Type) GetCTRL_PRE_L() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1fe0) >> 5
}
func (o *SCT_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xe000)|value<<13)
}
func (o *SCT_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xe000) >> 13
}
func (o *SCT_Type) SetCTRL_DOWN_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *SCT_Type) GetCTRL_DOWN_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000) >> 16
}
func (o *SCT_Type) SetCTRL_STOP_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetCTRL_STOP_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetCTRL_HALT_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetCTRL_HALT_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetCTRL_CLRCTR_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80000)|value<<19)
}
func (o *SCT_Type) GetCTRL_CLRCTR_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80000) >> 19
}
func (o *SCT_Type) SetCTRL_BIDIR_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetCTRL_BIDIR_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetCTRL_PRE_H(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1fe00000)|value<<21)
}
func (o *SCT_Type) GetCTRL_PRE_H() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1fe00000) >> 21
}
func (o *SCT_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xe0000000)|value<<29)
}
func (o *SCT_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xe0000000) >> 29
}

// SCT.LIMIT: SCT limit register
func (o *SCT_Type) SetLIMIT_LIMMSK_L(value uint32) {
	volatile.StoreUint32(&o.LIMIT.Reg, volatile.LoadUint32(&o.LIMIT.Reg)&^(0x3f)|value)
}
func (o *SCT_Type) GetLIMIT_LIMMSK_L() uint32 {
	return volatile.LoadUint32(&o.LIMIT.Reg) & 0x3f
}
func (o *SCT_Type) SetLIMIT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LIMIT.Reg, volatile.LoadUint32(&o.LIMIT.Reg)&^(0xffc0)|value<<6)
}
func (o *SCT_Type) GetLIMIT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LIMIT.Reg) & 0xffc0) >> 6
}
func (o *SCT_Type) SetLIMIT_LIMMSK_H(value uint32) {
	volatile.StoreUint32(&o.LIMIT.Reg, volatile.LoadUint32(&o.LIMIT.Reg)&^(0x1f0000)|value<<16)
}
func (o *SCT_Type) GetLIMIT_LIMMSK_H() uint32 {
	return (volatile.LoadUint32(&o.LIMIT.Reg) & 0x1f0000) >> 16
}
func (o *SCT_Type) SetLIMIT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LIMIT.Reg, volatile.LoadUint32(&o.LIMIT.Reg)&^(0xffe00000)|value<<21)
}
func (o *SCT_Type) GetLIMIT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LIMIT.Reg) & 0xffe00000) >> 21
}

// SCT.HALT: SCT halt condition register
func (o *SCT_Type) SetHALT_HALTMSK_L(value uint32) {
	volatile.StoreUint32(&o.HALT.Reg, volatile.LoadUint32(&o.HALT.Reg)&^(0x3f)|value)
}
func (o *SCT_Type) GetHALT_HALTMSK_L() uint32 {
	return volatile.LoadUint32(&o.HALT.Reg) & 0x3f
}
func (o *SCT_Type) SetHALT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.HALT.Reg, volatile.LoadUint32(&o.HALT.Reg)&^(0xffc0)|value<<6)
}
func (o *SCT_Type) GetHALT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.HALT.Reg) & 0xffc0) >> 6
}
func (o *SCT_Type) SetHALT_HALTMSK_H(value uint32) {
	volatile.StoreUint32(&o.HALT.Reg, volatile.LoadUint32(&o.HALT.Reg)&^(0x1f0000)|value<<16)
}
func (o *SCT_Type) GetHALT_HALTMSK_H() uint32 {
	return (volatile.LoadUint32(&o.HALT.Reg) & 0x1f0000) >> 16
}
func (o *SCT_Type) SetHALT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.HALT.Reg, volatile.LoadUint32(&o.HALT.Reg)&^(0xffe00000)|value<<21)
}
func (o *SCT_Type) GetHALT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.HALT.Reg) & 0xffe00000) >> 21
}

// SCT.STOP: SCT stop condition register
func (o *SCT_Type) SetSTOP_STOPMSK_L(value uint32) {
	volatile.StoreUint32(&o.STOP.Reg, volatile.LoadUint32(&o.STOP.Reg)&^(0x3f)|value)
}
func (o *SCT_Type) GetSTOP_STOPMSK_L() uint32 {
	return volatile.LoadUint32(&o.STOP.Reg) & 0x3f
}
func (o *SCT_Type) SetSTOP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STOP.Reg, volatile.LoadUint32(&o.STOP.Reg)&^(0xffc0)|value<<6)
}
func (o *SCT_Type) GetSTOP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STOP.Reg) & 0xffc0) >> 6
}
func (o *SCT_Type) SetSTOP_STOPMSK_H(value uint32) {
	volatile.StoreUint32(&o.STOP.Reg, volatile.LoadUint32(&o.STOP.Reg)&^(0x1f0000)|value<<16)
}
func (o *SCT_Type) GetSTOP_STOPMSK_H() uint32 {
	return (volatile.LoadUint32(&o.STOP.Reg) & 0x1f0000) >> 16
}
func (o *SCT_Type) SetSTOP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STOP.Reg, volatile.LoadUint32(&o.STOP.Reg)&^(0xffe00000)|value<<21)
}
func (o *SCT_Type) GetSTOP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STOP.Reg) & 0xffe00000) >> 21
}

// SCT.START: SCT start condition register
func (o *SCT_Type) SetSTART_STARTMSK_L(value uint32) {
	volatile.StoreUint32(&o.START.Reg, volatile.LoadUint32(&o.START.Reg)&^(0x3f)|value)
}
func (o *SCT_Type) GetSTART_STARTMSK_L() uint32 {
	return volatile.LoadUint32(&o.START.Reg) & 0x3f
}
func (o *SCT_Type) SetSTART_RESERVED(value uint32) {
	volatile.StoreUint32(&o.START.Reg, volatile.LoadUint32(&o.START.Reg)&^(0xffc0)|value<<6)
}
func (o *SCT_Type) GetSTART_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.START.Reg) & 0xffc0) >> 6
}
func (o *SCT_Type) SetSTART_STARTMSK_H(value uint32) {
	volatile.StoreUint32(&o.START.Reg, volatile.LoadUint32(&o.START.Reg)&^(0x1f0000)|value<<16)
}
func (o *SCT_Type) GetSTART_STARTMSK_H() uint32 {
	return (volatile.LoadUint32(&o.START.Reg) & 0x1f0000) >> 16
}
func (o *SCT_Type) SetSTART_RESERVED(value uint32) {
	volatile.StoreUint32(&o.START.Reg, volatile.LoadUint32(&o.START.Reg)&^(0xffe00000)|value<<21)
}
func (o *SCT_Type) GetSTART_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.START.Reg) & 0xffe00000) >> 21
}

// SCT.COUNT: SCT counter register
func (o *SCT_Type) SetCOUNT_CTR_L(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, volatile.LoadUint32(&o.COUNT.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetCOUNT_CTR_L() uint32 {
	return volatile.LoadUint32(&o.COUNT.Reg) & 0xffff
}
func (o *SCT_Type) SetCOUNT_CTR_H(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, volatile.LoadUint32(&o.COUNT.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetCOUNT_CTR_H() uint32 {
	return (volatile.LoadUint32(&o.COUNT.Reg) & 0xffff0000) >> 16
}

// SCT.STATE: SCT state register
func (o *SCT_Type) SetSTATE_STATE_L(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x1f)|value)
}
func (o *SCT_Type) GetSTATE_STATE_L() uint32 {
	return volatile.LoadUint32(&o.STATE.Reg) & 0x1f
}
func (o *SCT_Type) SetSTATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0xffe0)|value<<5)
}
func (o *SCT_Type) GetSTATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0xffe0) >> 5
}
func (o *SCT_Type) SetSTATE_STATE_H(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x1f0000)|value<<16)
}
func (o *SCT_Type) GetSTATE_STATE_H() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0x1f0000) >> 16
}
func (o *SCT_Type) SetSTATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0xffe00000)|value<<21)
}
func (o *SCT_Type) GetSTATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0xffe00000) >> 21
}

// SCT.INPUT: SCT input register
func (o *SCT_Type) SetINPUT_AIN0(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x1)|value)
}
func (o *SCT_Type) GetINPUT_AIN0() uint32 {
	return volatile.LoadUint32(&o.INPUT.Reg) & 0x1
}
func (o *SCT_Type) SetINPUT_AIN1(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x2)|value<<1)
}
func (o *SCT_Type) GetINPUT_AIN1() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x2) >> 1
}
func (o *SCT_Type) SetINPUT_AIN2(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x4)|value<<2)
}
func (o *SCT_Type) GetINPUT_AIN2() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x4) >> 2
}
func (o *SCT_Type) SetINPUT_AIN3(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x8)|value<<3)
}
func (o *SCT_Type) GetINPUT_AIN3() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x8) >> 3
}
func (o *SCT_Type) SetINPUT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0xfff0)|value<<4)
}
func (o *SCT_Type) GetINPUT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0xfff0) >> 4
}
func (o *SCT_Type) SetINPUT_SIN0(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x10000)|value<<16)
}
func (o *SCT_Type) GetINPUT_SIN0() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x10000) >> 16
}
func (o *SCT_Type) SetINPUT_SIN1(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x20000)|value<<17)
}
func (o *SCT_Type) GetINPUT_SIN1() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x20000) >> 17
}
func (o *SCT_Type) SetINPUT_SIN2(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x40000)|value<<18)
}
func (o *SCT_Type) GetINPUT_SIN2() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x40000) >> 18
}
func (o *SCT_Type) SetINPUT_SIN3(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0x80000)|value<<19)
}
func (o *SCT_Type) GetINPUT_SIN3() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0x80000) >> 19
}
func (o *SCT_Type) SetINPUT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INPUT.Reg, volatile.LoadUint32(&o.INPUT.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT_Type) GetINPUT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INPUT.Reg) & 0xfff00000) >> 20
}

// SCT.REGMODE: SCT match/capture registers mode register
func (o *SCT_Type) SetREGMODE_REGMOD_L(value uint32) {
	volatile.StoreUint32(&o.REGMODE.Reg, volatile.LoadUint32(&o.REGMODE.Reg)&^(0x1f)|value)
}
func (o *SCT_Type) GetREGMODE_REGMOD_L() uint32 {
	return volatile.LoadUint32(&o.REGMODE.Reg) & 0x1f
}
func (o *SCT_Type) SetREGMODE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.REGMODE.Reg, volatile.LoadUint32(&o.REGMODE.Reg)&^(0xffe0)|value<<5)
}
func (o *SCT_Type) GetREGMODE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.REGMODE.Reg) & 0xffe0) >> 5
}
func (o *SCT_Type) SetREGMODE_REGMOD_H(value uint32) {
	volatile.StoreUint32(&o.REGMODE.Reg, volatile.LoadUint32(&o.REGMODE.Reg)&^(0xf0000)|value<<16)
}
func (o *SCT_Type) GetREGMODE_REGMOD_H() uint32 {
	return (volatile.LoadUint32(&o.REGMODE.Reg) & 0xf0000) >> 16
}
func (o *SCT_Type) SetREGMODE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.REGMODE.Reg, volatile.LoadUint32(&o.REGMODE.Reg)&^(0xfff00000)|value<<20)
}
func (o *SCT_Type) GetREGMODE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.REGMODE.Reg) & 0xfff00000) >> 20
}

// SCT.OUTPUT: SCT output register
func (o *SCT_Type) SetOUTPUT_OUT(value uint32) {
	volatile.StoreUint32(&o.OUTPUT.Reg, volatile.LoadUint32(&o.OUTPUT.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetOUTPUT_OUT() uint32 {
	return volatile.LoadUint32(&o.OUTPUT.Reg) & 0xf
}
func (o *SCT_Type) SetOUTPUT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUTPUT.Reg, volatile.LoadUint32(&o.OUTPUT.Reg)&^(0xfffffff0)|value<<4)
}
func (o *SCT_Type) GetOUTPUT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUTPUT.Reg) & 0xfffffff0) >> 4
}

// SCT.OUTPUTDIRCTRL: SCT output counter direction control register
func (o *SCT_Type) SetOUTPUTDIRCTRL_SETCLR0(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0x3)|value)
}
func (o *SCT_Type) GetOUTPUTDIRCTRL_SETCLR0() uint32 {
	return volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0x3
}
func (o *SCT_Type) SetOUTPUTDIRCTRL_SETCLR1(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xc)|value<<2)
}
func (o *SCT_Type) GetOUTPUTDIRCTRL_SETCLR1() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xc) >> 2
}
func (o *SCT_Type) SetOUTPUTDIRCTRL_SETCLR2(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0x30)|value<<4)
}
func (o *SCT_Type) GetOUTPUTDIRCTRL_SETCLR2() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0x30) >> 4
}
func (o *SCT_Type) SetOUTPUTDIRCTRL_SETCLR3(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xc0)|value<<6)
}
func (o *SCT_Type) GetOUTPUTDIRCTRL_SETCLR3() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xc0) >> 6
}
func (o *SCT_Type) SetOUTPUTDIRCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUTPUTDIRCTRL.Reg, volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg)&^(0xffffff00)|value<<8)
}
func (o *SCT_Type) GetOUTPUTDIRCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUTPUTDIRCTRL.Reg) & 0xffffff00) >> 8
}

// SCT.RES: SCT conflict resolution register
func (o *SCT_Type) SetRES_O0RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0x3)|value)
}
func (o *SCT_Type) GetRES_O0RES() uint32 {
	return volatile.LoadUint32(&o.RES.Reg) & 0x3
}
func (o *SCT_Type) SetRES_O1RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xc)|value<<2)
}
func (o *SCT_Type) GetRES_O1RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xc) >> 2
}
func (o *SCT_Type) SetRES_O2RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0x30)|value<<4)
}
func (o *SCT_Type) GetRES_O2RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0x30) >> 4
}
func (o *SCT_Type) SetRES_O3RES(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xc0)|value<<6)
}
func (o *SCT_Type) GetRES_O3RES() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xc0) >> 6
}
func (o *SCT_Type) SetRES_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RES.Reg, volatile.LoadUint32(&o.RES.Reg)&^(0xffffff00)|value<<8)
}
func (o *SCT_Type) GetRES_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RES.Reg) & 0xffffff00) >> 8
}

// SCT.EVEN: SCT event enable register
func (o *SCT_Type) SetEVEN_IEN(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0x3f)|value)
}
func (o *SCT_Type) GetEVEN_IEN() uint32 {
	return volatile.LoadUint32(&o.EVEN.Reg) & 0x3f
}
func (o *SCT_Type) SetEVEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EVEN.Reg, volatile.LoadUint32(&o.EVEN.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SCT_Type) GetEVEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EVEN.Reg) & 0xffffffc0) >> 6
}

// SCT.EVFLAG: SCT event flag register
func (o *SCT_Type) SetEVFLAG_FLAG(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0x3f)|value)
}
func (o *SCT_Type) GetEVFLAG_FLAG() uint32 {
	return volatile.LoadUint32(&o.EVFLAG.Reg) & 0x3f
}
func (o *SCT_Type) SetEVFLAG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EVFLAG.Reg, volatile.LoadUint32(&o.EVFLAG.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SCT_Type) GetEVFLAG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EVFLAG.Reg) & 0xffffffc0) >> 6
}

// SCT.CONEN: SCT conflict enable register
func (o *SCT_Type) SetCONEN_NCEN(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetCONEN_NCEN() uint32 {
	return volatile.LoadUint32(&o.CONEN.Reg) & 0xf
}
func (o *SCT_Type) SetCONEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONEN.Reg, volatile.LoadUint32(&o.CONEN.Reg)&^(0xfffffff0)|value<<4)
}
func (o *SCT_Type) GetCONEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONEN.Reg) & 0xfffffff0) >> 4
}

// SCT.CONFLAG: SCT conflict flag register
func (o *SCT_Type) SetCONFLAG_NCFLAG(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetCONFLAG_NCFLAG() uint32 {
	return volatile.LoadUint32(&o.CONFLAG.Reg) & 0xf
}
func (o *SCT_Type) SetCONFLAG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x3ffffff0)|value<<4)
}
func (o *SCT_Type) GetCONFLAG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x3ffffff0) >> 4
}
func (o *SCT_Type) SetCONFLAG_BUSERRL(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x40000000)|value<<30)
}
func (o *SCT_Type) GetCONFLAG_BUSERRL() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x40000000) >> 30
}
func (o *SCT_Type) SetCONFLAG_BUSERRH(value uint32) {
	volatile.StoreUint32(&o.CONFLAG.Reg, volatile.LoadUint32(&o.CONFLAG.Reg)&^(0x80000000)|value<<31)
}
func (o *SCT_Type) GetCONFLAG_BUSERRH() uint32 {
	return (volatile.LoadUint32(&o.CONFLAG.Reg) & 0x80000000) >> 31
}

// SCT.MATCH0: SCT match value register of match channels 0 to 4; REGMOD0 to REGMODE4 = 0
func (o *SCT_Type) SetMATCH0_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH0.Reg, volatile.LoadUint32(&o.MATCH0.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCH0_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH0.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCH0_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH0.Reg, volatile.LoadUint32(&o.MATCH0.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCH0_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH0.Reg) & 0xffff0000) >> 16
}

// SCT.MATCH1: SCT match value register of match channels 0 to 4; REGMOD0 to REGMODE4 = 0
func (o *SCT_Type) SetMATCH1_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH1.Reg, volatile.LoadUint32(&o.MATCH1.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCH1_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH1.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCH1_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH1.Reg, volatile.LoadUint32(&o.MATCH1.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCH1_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH1.Reg) & 0xffff0000) >> 16
}

// SCT.MATCH2: SCT match value register of match channels 0 to 4; REGMOD0 to REGMODE4 = 0
func (o *SCT_Type) SetMATCH2_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH2.Reg, volatile.LoadUint32(&o.MATCH2.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCH2_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH2.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCH2_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH2.Reg, volatile.LoadUint32(&o.MATCH2.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCH2_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH2.Reg) & 0xffff0000) >> 16
}

// SCT.MATCH3: SCT match value register of match channels 0 to 4; REGMOD0 to REGMODE4 = 0
func (o *SCT_Type) SetMATCH3_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH3.Reg, volatile.LoadUint32(&o.MATCH3.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCH3_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH3.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCH3_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH3.Reg, volatile.LoadUint32(&o.MATCH3.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCH3_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH3.Reg) & 0xffff0000) >> 16
}

// SCT.MATCH4: SCT match value register of match channels 0 to 4; REGMOD0 to REGMODE4 = 0
func (o *SCT_Type) SetMATCH4_MATCHn_L(value uint32) {
	volatile.StoreUint32(&o.MATCH4.Reg, volatile.LoadUint32(&o.MATCH4.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCH4_MATCHn_L() uint32 {
	return volatile.LoadUint32(&o.MATCH4.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCH4_MATCHn_H(value uint32) {
	volatile.StoreUint32(&o.MATCH4.Reg, volatile.LoadUint32(&o.MATCH4.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCH4_MATCHn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCH4.Reg) & 0xffff0000) >> 16
}

// SCT.MATCHREL0: SCT match reload value register 0 to 4 REGMOD0 = 0 to REGMODE4 = 0
func (o *SCT_Type) SetMATCHREL0_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL0.Reg, volatile.LoadUint32(&o.MATCHREL0.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCHREL0_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL0.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCHREL0_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL0.Reg, volatile.LoadUint32(&o.MATCHREL0.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCHREL0_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL0.Reg) & 0xffff0000) >> 16
}

// SCT.MATCHREL1: SCT match reload value register 0 to 4 REGMOD0 = 0 to REGMODE4 = 0
func (o *SCT_Type) SetMATCHREL1_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL1.Reg, volatile.LoadUint32(&o.MATCHREL1.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCHREL1_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL1.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCHREL1_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL1.Reg, volatile.LoadUint32(&o.MATCHREL1.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCHREL1_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL1.Reg) & 0xffff0000) >> 16
}

// SCT.MATCHREL2: SCT match reload value register 0 to 4 REGMOD0 = 0 to REGMODE4 = 0
func (o *SCT_Type) SetMATCHREL2_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL2.Reg, volatile.LoadUint32(&o.MATCHREL2.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCHREL2_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL2.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCHREL2_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL2.Reg, volatile.LoadUint32(&o.MATCHREL2.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCHREL2_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL2.Reg) & 0xffff0000) >> 16
}

// SCT.MATCHREL3: SCT match reload value register 0 to 4 REGMOD0 = 0 to REGMODE4 = 0
func (o *SCT_Type) SetMATCHREL3_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL3.Reg, volatile.LoadUint32(&o.MATCHREL3.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCHREL3_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL3.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCHREL3_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL3.Reg, volatile.LoadUint32(&o.MATCHREL3.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCHREL3_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL3.Reg) & 0xffff0000) >> 16
}

// SCT.MATCHREL4: SCT match reload value register 0 to 4 REGMOD0 = 0 to REGMODE4 = 0
func (o *SCT_Type) SetMATCHREL4_RELOADn_L(value uint32) {
	volatile.StoreUint32(&o.MATCHREL4.Reg, volatile.LoadUint32(&o.MATCHREL4.Reg)&^(0xffff)|value)
}
func (o *SCT_Type) GetMATCHREL4_RELOADn_L() uint32 {
	return volatile.LoadUint32(&o.MATCHREL4.Reg) & 0xffff
}
func (o *SCT_Type) SetMATCHREL4_RELOADn_H(value uint32) {
	volatile.StoreUint32(&o.MATCHREL4.Reg, volatile.LoadUint32(&o.MATCHREL4.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCT_Type) GetMATCHREL4_RELOADn_H() uint32 {
	return (volatile.LoadUint32(&o.MATCHREL4.Reg) & 0xffff0000) >> 16
}

// SCT.EV0_STATE: SCT event state register 0
func (o *SCT_Type) SetEV0_STATE_STATEMSKm(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0x3)|value)
}
func (o *SCT_Type) GetEV0_STATE_STATEMSKm() uint32 {
	return volatile.LoadUint32(&o.EV0_STATE.Reg) & 0x3
}
func (o *SCT_Type) SetEV0_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV0_STATE.Reg, volatile.LoadUint32(&o.EV0_STATE.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SCT_Type) GetEV0_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV0_STATE.Reg) & 0xfffffffc) >> 2
}

// SCT.EV0_CTRL: SCT event control register 0
func (o *SCT_Type) SetEV0_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV0_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV0_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV0_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV0_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV0_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV0_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV0_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV0_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV0_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV0_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV0_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV0_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV0_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV0_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV0_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV0_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV0_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV0_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV0_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV0_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV0_CTRL.Reg, volatile.LoadUint32(&o.EV0_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV0_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV0_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.EV1_STATE: SCT event state register 1
func (o *SCT_Type) SetEV1_STATE_STATEMSKm(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0x3)|value)
}
func (o *SCT_Type) GetEV1_STATE_STATEMSKm() uint32 {
	return volatile.LoadUint32(&o.EV1_STATE.Reg) & 0x3
}
func (o *SCT_Type) SetEV1_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV1_STATE.Reg, volatile.LoadUint32(&o.EV1_STATE.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SCT_Type) GetEV1_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV1_STATE.Reg) & 0xfffffffc) >> 2
}

// SCT.EV1_CTRL: SCT event control register 1
func (o *SCT_Type) SetEV1_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV1_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV1_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV1_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV1_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV1_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV1_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV1_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV1_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV1_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV1_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV1_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV1_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV1_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV1_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV1_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV1_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV1_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV1_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV1_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV1_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV1_CTRL.Reg, volatile.LoadUint32(&o.EV1_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV1_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV1_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.EV2_STATE: SCT event state register 2
func (o *SCT_Type) SetEV2_STATE_STATEMSKm(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0x3)|value)
}
func (o *SCT_Type) GetEV2_STATE_STATEMSKm() uint32 {
	return volatile.LoadUint32(&o.EV2_STATE.Reg) & 0x3
}
func (o *SCT_Type) SetEV2_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV2_STATE.Reg, volatile.LoadUint32(&o.EV2_STATE.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SCT_Type) GetEV2_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV2_STATE.Reg) & 0xfffffffc) >> 2
}

// SCT.EV2_CTRL: SCT event control register 2
func (o *SCT_Type) SetEV2_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV2_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV2_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV2_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV2_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV2_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV2_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV2_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV2_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV2_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV2_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV2_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV2_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV2_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV2_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV2_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV2_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV2_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV2_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV2_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV2_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV2_CTRL.Reg, volatile.LoadUint32(&o.EV2_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV2_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV2_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.EV3_STATE: SCT event state register 3
func (o *SCT_Type) SetEV3_STATE_STATEMSKm(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0x3)|value)
}
func (o *SCT_Type) GetEV3_STATE_STATEMSKm() uint32 {
	return volatile.LoadUint32(&o.EV3_STATE.Reg) & 0x3
}
func (o *SCT_Type) SetEV3_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV3_STATE.Reg, volatile.LoadUint32(&o.EV3_STATE.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SCT_Type) GetEV3_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV3_STATE.Reg) & 0xfffffffc) >> 2
}

// SCT.EV3_CTRL: SCT event control register 3
func (o *SCT_Type) SetEV3_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV3_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV3_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV3_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV3_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV3_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV3_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV3_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV3_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV3_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV3_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV3_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV3_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV3_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV3_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV3_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV3_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV3_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV3_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV3_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV3_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV3_CTRL.Reg, volatile.LoadUint32(&o.EV3_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV3_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV3_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.EV4_STATE: SCT event state register 4
func (o *SCT_Type) SetEV4_STATE_STATEMSKm(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0x3)|value)
}
func (o *SCT_Type) GetEV4_STATE_STATEMSKm() uint32 {
	return volatile.LoadUint32(&o.EV4_STATE.Reg) & 0x3
}
func (o *SCT_Type) SetEV4_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV4_STATE.Reg, volatile.LoadUint32(&o.EV4_STATE.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SCT_Type) GetEV4_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV4_STATE.Reg) & 0xfffffffc) >> 2
}

// SCT.EV4_CTRL: SCT event control register 4
func (o *SCT_Type) SetEV4_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV4_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV4_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV4_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV4_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV4_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV4_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV4_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV4_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV4_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV4_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV4_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV4_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV4_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV4_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV4_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV4_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV4_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV4_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV4_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV4_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV4_CTRL.Reg, volatile.LoadUint32(&o.EV4_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV4_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV4_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.EV5_STATE: SCT event state register 5
func (o *SCT_Type) SetEV5_STATE_STATEMSKm(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0x3)|value)
}
func (o *SCT_Type) GetEV5_STATE_STATEMSKm() uint32 {
	return volatile.LoadUint32(&o.EV5_STATE.Reg) & 0x3
}
func (o *SCT_Type) SetEV5_STATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV5_STATE.Reg, volatile.LoadUint32(&o.EV5_STATE.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SCT_Type) GetEV5_STATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV5_STATE.Reg) & 0xfffffffc) >> 2
}

// SCT.EV5_CTRL: SCT event control register 5
func (o *SCT_Type) SetEV5_CTRL_MATCHSEL(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0xf)|value)
}
func (o *SCT_Type) GetEV5_CTRL_MATCHSEL() uint32 {
	return volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0xf
}
func (o *SCT_Type) SetEV5_CTRL_HEVENT(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *SCT_Type) GetEV5_CTRL_HEVENT() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x10) >> 4
}
func (o *SCT_Type) SetEV5_CTRL_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *SCT_Type) GetEV5_CTRL_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x20) >> 5
}
func (o *SCT_Type) SetEV5_CTRL_IOSEL(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x3c0)|value<<6)
}
func (o *SCT_Type) GetEV5_CTRL_IOSEL() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x3c0) >> 6
}
func (o *SCT_Type) SetEV5_CTRL_IOCOND(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *SCT_Type) GetEV5_CTRL_IOCOND() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0xc00) >> 10
}
func (o *SCT_Type) SetEV5_CTRL_COMBMODE(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *SCT_Type) GetEV5_CTRL_COMBMODE() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x3000) >> 12
}
func (o *SCT_Type) SetEV5_CTRL_STATELD(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *SCT_Type) GetEV5_CTRL_STATELD() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x4000) >> 14
}
func (o *SCT_Type) SetEV5_CTRL_STATEV(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0xf8000)|value<<15)
}
func (o *SCT_Type) GetEV5_CTRL_STATEV() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0xf8000) >> 15
}
func (o *SCT_Type) SetEV5_CTRL_MATCHMEM(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *SCT_Type) GetEV5_CTRL_MATCHMEM() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x100000) >> 20
}
func (o *SCT_Type) SetEV5_CTRL_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0x600000)|value<<21)
}
func (o *SCT_Type) GetEV5_CTRL_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0x600000) >> 21
}
func (o *SCT_Type) SetEV5_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EV5_CTRL.Reg, volatile.LoadUint32(&o.EV5_CTRL.Reg)&^(0xff800000)|value<<23)
}
func (o *SCT_Type) GetEV5_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EV5_CTRL.Reg) & 0xff800000) >> 23
}

// SCT.OUT0_SET: SCT output 0 set register
func (o *SCT_Type) SetOUT0_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0x3f)|value)
}
func (o *SCT_Type) GetOUT0_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT0_SET.Reg) & 0x3f
}
func (o *SCT_Type) SetOUT0_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT0_SET.Reg, volatile.LoadUint32(&o.OUT0_SET.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SCT_Type) GetOUT0_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT0_SET.Reg) & 0xffffffc0) >> 6
}

// SCT.OUT0_CLR: SCT output 0 clear register
func (o *SCT_Type) SetOUT0_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0x3f)|value)
}
func (o *SCT_Type) GetOUT0_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0x3f
}
func (o *SCT_Type) SetOUT0_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT0_CLR.Reg, volatile.LoadUint32(&o.OUT0_CLR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SCT_Type) GetOUT0_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT0_CLR.Reg) & 0xffffffc0) >> 6
}

// SCT.OUT1_SET: SCT output 1 set register
func (o *SCT_Type) SetOUT1_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0x3f)|value)
}
func (o *SCT_Type) GetOUT1_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT1_SET.Reg) & 0x3f
}
func (o *SCT_Type) SetOUT1_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT1_SET.Reg, volatile.LoadUint32(&o.OUT1_SET.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SCT_Type) GetOUT1_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT1_SET.Reg) & 0xffffffc0) >> 6
}

// SCT.OUT1_CLR: SCT output 1 clear register
func (o *SCT_Type) SetOUT1_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0x3f)|value)
}
func (o *SCT_Type) GetOUT1_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0x3f
}
func (o *SCT_Type) SetOUT1_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT1_CLR.Reg, volatile.LoadUint32(&o.OUT1_CLR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SCT_Type) GetOUT1_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT1_CLR.Reg) & 0xffffffc0) >> 6
}

// SCT.OUT2_SET: SCT output 2 set register
func (o *SCT_Type) SetOUT2_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0x3f)|value)
}
func (o *SCT_Type) GetOUT2_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT2_SET.Reg) & 0x3f
}
func (o *SCT_Type) SetOUT2_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT2_SET.Reg, volatile.LoadUint32(&o.OUT2_SET.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SCT_Type) GetOUT2_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT2_SET.Reg) & 0xffffffc0) >> 6
}

// SCT.OUT2_CLR: SCT output 2 clear register
func (o *SCT_Type) SetOUT2_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0x3f)|value)
}
func (o *SCT_Type) GetOUT2_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0x3f
}
func (o *SCT_Type) SetOUT2_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT2_CLR.Reg, volatile.LoadUint32(&o.OUT2_CLR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SCT_Type) GetOUT2_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT2_CLR.Reg) & 0xffffffc0) >> 6
}

// SCT.OUT3_SET: SCT output 3 set register
func (o *SCT_Type) SetOUT3_SET_SET(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0x3f)|value)
}
func (o *SCT_Type) GetOUT3_SET_SET() uint32 {
	return volatile.LoadUint32(&o.OUT3_SET.Reg) & 0x3f
}
func (o *SCT_Type) SetOUT3_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT3_SET.Reg, volatile.LoadUint32(&o.OUT3_SET.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SCT_Type) GetOUT3_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT3_SET.Reg) & 0xffffffc0) >> 6
}

// SCT.OUT3_CLR: SCT output 3 clear register
func (o *SCT_Type) SetOUT3_CLR_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0x3f)|value)
}
func (o *SCT_Type) GetOUT3_CLR_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0x3f
}
func (o *SCT_Type) SetOUT3_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OUT3_CLR.Reg, volatile.LoadUint32(&o.OUT3_CLR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *SCT_Type) GetOUT3_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OUT3_CLR.Reg) & 0xffffffc0) >> 6
}

// General Purpose I/O port (GPIO)
type GPIO_PORT_Type struct {
	B0    volatile.Register8 // 0x0
	B1    volatile.Register8 // 0x1
	B2    volatile.Register8 // 0x2
	B3    volatile.Register8 // 0x3
	B4    volatile.Register8 // 0x4
	B5    volatile.Register8 // 0x5
	B6    volatile.Register8 // 0x6
	B7    volatile.Register8 // 0x7
	B8    volatile.Register8 // 0x8
	B9    volatile.Register8 // 0x9
	B10   volatile.Register8 // 0xA
	B11   volatile.Register8 // 0xB
	B12   volatile.Register8 // 0xC
	B13   volatile.Register8 // 0xD
	B14   volatile.Register8 // 0xE
	B15   volatile.Register8 // 0xF
	B16   volatile.Register8 // 0x10
	B17   volatile.Register8 // 0x11
	_     [4078]byte
	W0    volatile.Register32 // 0x1000
	W1    volatile.Register32 // 0x1004
	W2    volatile.Register32 // 0x1008
	W3    volatile.Register32 // 0x100C
	W4    volatile.Register32 // 0x1010
	W5    volatile.Register32 // 0x1014
	W6    volatile.Register32 // 0x1018
	W7    volatile.Register32 // 0x101C
	W8    volatile.Register32 // 0x1020
	W9    volatile.Register32 // 0x1024
	W10   volatile.Register32 // 0x1028
	W11   volatile.Register32 // 0x102C
	W12   volatile.Register32 // 0x1030
	W13   volatile.Register32 // 0x1034
	W14   volatile.Register32 // 0x1038
	W15   volatile.Register32 // 0x103C
	W16   volatile.Register32 // 0x1040
	W17   volatile.Register32 // 0x1044
	_     [4024]byte
	DIR0  volatile.Register32 // 0x2000
	_     [124]byte
	MASK0 volatile.Register32 // 0x2080
	_     [124]byte
	PIN0  volatile.Register32 // 0x2100
	_     [124]byte
	MPIN0 volatile.Register32 // 0x2180
	_     [124]byte
	SET0  volatile.Register32 // 0x2200
	_     [124]byte
	CLR0  volatile.Register32 // 0x2280
	_     [124]byte
	NOT0  volatile.Register32 // 0x2300
}

// GPIO_PORT.B0: Byte pin registers port 0; pins PIO0_0 to PIO0_17
func (o *GPIO_PORT_Type) SetB0_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B0.Reg, volatile.LoadUint8(&o.B0.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB0_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B0.Reg) & 0x1
}

// GPIO_PORT.B1: Byte pin registers port 0; pins PIO0_0 to PIO0_17
func (o *GPIO_PORT_Type) SetB1_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B1.Reg, volatile.LoadUint8(&o.B1.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB1_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B1.Reg) & 0x1
}

// GPIO_PORT.B2: Byte pin registers port 0; pins PIO0_0 to PIO0_17
func (o *GPIO_PORT_Type) SetB2_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B2.Reg, volatile.LoadUint8(&o.B2.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB2_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B2.Reg) & 0x1
}

// GPIO_PORT.B3: Byte pin registers port 0; pins PIO0_0 to PIO0_17
func (o *GPIO_PORT_Type) SetB3_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B3.Reg, volatile.LoadUint8(&o.B3.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB3_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B3.Reg) & 0x1
}

// GPIO_PORT.B4: Byte pin registers port 0; pins PIO0_0 to PIO0_17
func (o *GPIO_PORT_Type) SetB4_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B4.Reg, volatile.LoadUint8(&o.B4.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB4_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B4.Reg) & 0x1
}

// GPIO_PORT.B5: Byte pin registers port 0; pins PIO0_0 to PIO0_17
func (o *GPIO_PORT_Type) SetB5_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B5.Reg, volatile.LoadUint8(&o.B5.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB5_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B5.Reg) & 0x1
}

// GPIO_PORT.B6: Byte pin registers port 0; pins PIO0_0 to PIO0_17
func (o *GPIO_PORT_Type) SetB6_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B6.Reg, volatile.LoadUint8(&o.B6.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB6_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B6.Reg) & 0x1
}

// GPIO_PORT.B7: Byte pin registers port 0; pins PIO0_0 to PIO0_17
func (o *GPIO_PORT_Type) SetB7_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B7.Reg, volatile.LoadUint8(&o.B7.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB7_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B7.Reg) & 0x1
}

// GPIO_PORT.B8: Byte pin registers port 0; pins PIO0_0 to PIO0_17
func (o *GPIO_PORT_Type) SetB8_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B8.Reg, volatile.LoadUint8(&o.B8.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB8_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B8.Reg) & 0x1
}

// GPIO_PORT.B9: Byte pin registers port 0; pins PIO0_0 to PIO0_17
func (o *GPIO_PORT_Type) SetB9_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B9.Reg, volatile.LoadUint8(&o.B9.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB9_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B9.Reg) & 0x1
}

// GPIO_PORT.B10: Byte pin registers port 0; pins PIO0_0 to PIO0_17
func (o *GPIO_PORT_Type) SetB10_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B10.Reg, volatile.LoadUint8(&o.B10.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB10_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B10.Reg) & 0x1
}

// GPIO_PORT.B11: Byte pin registers port 0; pins PIO0_0 to PIO0_17
func (o *GPIO_PORT_Type) SetB11_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B11.Reg, volatile.LoadUint8(&o.B11.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB11_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B11.Reg) & 0x1
}

// GPIO_PORT.B12: Byte pin registers port 0; pins PIO0_0 to PIO0_17
func (o *GPIO_PORT_Type) SetB12_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B12.Reg, volatile.LoadUint8(&o.B12.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB12_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B12.Reg) & 0x1
}

// GPIO_PORT.B13: Byte pin registers port 0; pins PIO0_0 to PIO0_17
func (o *GPIO_PORT_Type) SetB13_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B13.Reg, volatile.LoadUint8(&o.B13.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB13_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B13.Reg) & 0x1
}

// GPIO_PORT.B14: Byte pin registers port 0; pins PIO0_0 to PIO0_17
func (o *GPIO_PORT_Type) SetB14_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B14.Reg, volatile.LoadUint8(&o.B14.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB14_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B14.Reg) & 0x1
}

// GPIO_PORT.B15: Byte pin registers port 0; pins PIO0_0 to PIO0_17
func (o *GPIO_PORT_Type) SetB15_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B15.Reg, volatile.LoadUint8(&o.B15.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB15_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B15.Reg) & 0x1
}

// GPIO_PORT.B16: Byte pin registers port 0; pins PIO0_0 to PIO0_17
func (o *GPIO_PORT_Type) SetB16_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B16.Reg, volatile.LoadUint8(&o.B16.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB16_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B16.Reg) & 0x1
}

// GPIO_PORT.B17: Byte pin registers port 0; pins PIO0_0 to PIO0_17
func (o *GPIO_PORT_Type) SetB17_PBYTE(value uint8) {
	volatile.StoreUint8(&o.B17.Reg, volatile.LoadUint8(&o.B17.Reg)&^(0x1)|value)
}
func (o *GPIO_PORT_Type) GetB17_PBYTE() uint8 {
	return volatile.LoadUint8(&o.B17.Reg) & 0x1
}

// GPIO_PORT.W0: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW0(value uint32) {
	volatile.StoreUint32(&o.W0.Reg, value)
}
func (o *GPIO_PORT_Type) GetW0() uint32 {
	return volatile.LoadUint32(&o.W0.Reg)
}

// GPIO_PORT.W1: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW1(value uint32) {
	volatile.StoreUint32(&o.W1.Reg, value)
}
func (o *GPIO_PORT_Type) GetW1() uint32 {
	return volatile.LoadUint32(&o.W1.Reg)
}

// GPIO_PORT.W2: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW2(value uint32) {
	volatile.StoreUint32(&o.W2.Reg, value)
}
func (o *GPIO_PORT_Type) GetW2() uint32 {
	return volatile.LoadUint32(&o.W2.Reg)
}

// GPIO_PORT.W3: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW3(value uint32) {
	volatile.StoreUint32(&o.W3.Reg, value)
}
func (o *GPIO_PORT_Type) GetW3() uint32 {
	return volatile.LoadUint32(&o.W3.Reg)
}

// GPIO_PORT.W4: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW4(value uint32) {
	volatile.StoreUint32(&o.W4.Reg, value)
}
func (o *GPIO_PORT_Type) GetW4() uint32 {
	return volatile.LoadUint32(&o.W4.Reg)
}

// GPIO_PORT.W5: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW5(value uint32) {
	volatile.StoreUint32(&o.W5.Reg, value)
}
func (o *GPIO_PORT_Type) GetW5() uint32 {
	return volatile.LoadUint32(&o.W5.Reg)
}

// GPIO_PORT.W6: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW6(value uint32) {
	volatile.StoreUint32(&o.W6.Reg, value)
}
func (o *GPIO_PORT_Type) GetW6() uint32 {
	return volatile.LoadUint32(&o.W6.Reg)
}

// GPIO_PORT.W7: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW7(value uint32) {
	volatile.StoreUint32(&o.W7.Reg, value)
}
func (o *GPIO_PORT_Type) GetW7() uint32 {
	return volatile.LoadUint32(&o.W7.Reg)
}

// GPIO_PORT.W8: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW8(value uint32) {
	volatile.StoreUint32(&o.W8.Reg, value)
}
func (o *GPIO_PORT_Type) GetW8() uint32 {
	return volatile.LoadUint32(&o.W8.Reg)
}

// GPIO_PORT.W9: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW9(value uint32) {
	volatile.StoreUint32(&o.W9.Reg, value)
}
func (o *GPIO_PORT_Type) GetW9() uint32 {
	return volatile.LoadUint32(&o.W9.Reg)
}

// GPIO_PORT.W10: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW10(value uint32) {
	volatile.StoreUint32(&o.W10.Reg, value)
}
func (o *GPIO_PORT_Type) GetW10() uint32 {
	return volatile.LoadUint32(&o.W10.Reg)
}

// GPIO_PORT.W11: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW11(value uint32) {
	volatile.StoreUint32(&o.W11.Reg, value)
}
func (o *GPIO_PORT_Type) GetW11() uint32 {
	return volatile.LoadUint32(&o.W11.Reg)
}

// GPIO_PORT.W12: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW12(value uint32) {
	volatile.StoreUint32(&o.W12.Reg, value)
}
func (o *GPIO_PORT_Type) GetW12() uint32 {
	return volatile.LoadUint32(&o.W12.Reg)
}

// GPIO_PORT.W13: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW13(value uint32) {
	volatile.StoreUint32(&o.W13.Reg, value)
}
func (o *GPIO_PORT_Type) GetW13() uint32 {
	return volatile.LoadUint32(&o.W13.Reg)
}

// GPIO_PORT.W14: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW14(value uint32) {
	volatile.StoreUint32(&o.W14.Reg, value)
}
func (o *GPIO_PORT_Type) GetW14() uint32 {
	return volatile.LoadUint32(&o.W14.Reg)
}

// GPIO_PORT.W15: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW15(value uint32) {
	volatile.StoreUint32(&o.W15.Reg, value)
}
func (o *GPIO_PORT_Type) GetW15() uint32 {
	return volatile.LoadUint32(&o.W15.Reg)
}

// GPIO_PORT.W16: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW16(value uint32) {
	volatile.StoreUint32(&o.W16.Reg, value)
}
func (o *GPIO_PORT_Type) GetW16() uint32 {
	return volatile.LoadUint32(&o.W16.Reg)
}

// GPIO_PORT.W17: Word pin registers port 0
func (o *GPIO_PORT_Type) SetW17(value uint32) {
	volatile.StoreUint32(&o.W17.Reg, value)
}
func (o *GPIO_PORT_Type) GetW17() uint32 {
	return volatile.LoadUint32(&o.W17.Reg)
}

// GPIO_PORT.DIR0: Direction registers port 0
func (o *GPIO_PORT_Type) SetDIR0_DIRP0(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x3ffff)|value)
}
func (o *GPIO_PORT_Type) GetDIR0_DIRP0() uint32 {
	return volatile.LoadUint32(&o.DIR0.Reg) & 0x3ffff
}
func (o *GPIO_PORT_Type) SetDIR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *GPIO_PORT_Type) GetDIR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0xfffc0000) >> 18
}

// GPIO_PORT.MASK0: Mask register port 0
func (o *GPIO_PORT_Type) SetMASK0_MASKP0(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x3ffff)|value)
}
func (o *GPIO_PORT_Type) GetMASK0_MASKP0() uint32 {
	return volatile.LoadUint32(&o.MASK0.Reg) & 0x3ffff
}
func (o *GPIO_PORT_Type) SetMASK0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *GPIO_PORT_Type) GetMASK0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0xfffc0000) >> 18
}

// GPIO_PORT.PIN0: Port pin register port 0
func (o *GPIO_PORT_Type) SetPIN0_PORT0(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x3ffff)|value)
}
func (o *GPIO_PORT_Type) GetPIN0_PORT0() uint32 {
	return volatile.LoadUint32(&o.PIN0.Reg) & 0x3ffff
}
func (o *GPIO_PORT_Type) SetPIN0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *GPIO_PORT_Type) GetPIN0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0xfffc0000) >> 18
}

// GPIO_PORT.MPIN0: Masked port register port 0
func (o *GPIO_PORT_Type) SetMPIN0_MPORTP0(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0x3ffff)|value)
}
func (o *GPIO_PORT_Type) GetMPIN0_MPORTP0() uint32 {
	return volatile.LoadUint32(&o.MPIN0.Reg) & 0x3ffff
}
func (o *GPIO_PORT_Type) SetMPIN0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MPIN0.Reg, volatile.LoadUint32(&o.MPIN0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *GPIO_PORT_Type) GetMPIN0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MPIN0.Reg) & 0xfffc0000) >> 18
}

// GPIO_PORT.SET0: Write: Set register for port 0 Read: output bits for port 0
func (o *GPIO_PORT_Type) SetSET0_SETP0(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x3ffff)|value)
}
func (o *GPIO_PORT_Type) GetSET0_SETP0() uint32 {
	return volatile.LoadUint32(&o.SET0.Reg) & 0x3ffff
}
func (o *GPIO_PORT_Type) SetSET0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *GPIO_PORT_Type) GetSET0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0xfffc0000) >> 18
}

// GPIO_PORT.CLR0: Clear port 0
func (o *GPIO_PORT_Type) SetCLR0_CLRP0(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x3ffff)|value)
}
func (o *GPIO_PORT_Type) GetCLR0_CLRP0() uint32 {
	return volatile.LoadUint32(&o.CLR0.Reg) & 0x3ffff
}
func (o *GPIO_PORT_Type) SetCLR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *GPIO_PORT_Type) GetCLR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0xfffc0000) >> 18
}

// GPIO_PORT.NOT0: Toggle port 0
func (o *GPIO_PORT_Type) SetNOT0_NOTP0(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0x3ffff)|value)
}
func (o *GPIO_PORT_Type) GetNOT0_NOTP0() uint32 {
	return volatile.LoadUint32(&o.NOT0.Reg) & 0x3ffff
}
func (o *GPIO_PORT_Type) SetNOT0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.NOT0.Reg, volatile.LoadUint32(&o.NOT0.Reg)&^(0xfffc0000)|value<<18)
}
func (o *GPIO_PORT_Type) GetNOT0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.NOT0.Reg) & 0xfffc0000) >> 18
}

// Pin interrupt and pattern match engine
type GPIO_PIN_INT_Type struct {
	ISEL   volatile.Register32 // 0x0
	IENR   volatile.Register32 // 0x4
	SIENR  volatile.Register32 // 0x8
	CIENR  volatile.Register32 // 0xC
	IENF   volatile.Register32 // 0x10
	SIENF  volatile.Register32 // 0x14
	CIENF  volatile.Register32 // 0x18
	RISE   volatile.Register32 // 0x1C
	FALL   volatile.Register32 // 0x20
	IST    volatile.Register32 // 0x24
	PMCTRL volatile.Register32 // 0x28
	PMSRC  volatile.Register32 // 0x2C
	PMCFG  volatile.Register32 // 0x30
}

// GPIO_PIN_INT.ISEL: Pin Interrupt Mode register
func (o *GPIO_PIN_INT_Type) SetISEL_PMODE(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0xff)|value)
}
func (o *GPIO_PIN_INT_Type) GetISEL_PMODE() uint32 {
	return volatile.LoadUint32(&o.ISEL.Reg) & 0xff
}
func (o *GPIO_PIN_INT_Type) SetISEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ISEL.Reg, volatile.LoadUint32(&o.ISEL.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetISEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ISEL.Reg) & 0xffffff00) >> 8
}

// GPIO_PIN_INT.IENR: Pin interrupt level or rising edge interrupt enable register
func (o *GPIO_PIN_INT_Type) SetIENR_ENRL(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0xff)|value)
}
func (o *GPIO_PIN_INT_Type) GetIENR_ENRL() uint32 {
	return volatile.LoadUint32(&o.IENR.Reg) & 0xff
}
func (o *GPIO_PIN_INT_Type) SetIENR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IENR.Reg, volatile.LoadUint32(&o.IENR.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetIENR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IENR.Reg) & 0xffffff00) >> 8
}

// GPIO_PIN_INT.SIENR: Pin interrupt level (rising edge) interrupt set register
func (o *GPIO_PIN_INT_Type) SetSIENR_SETENRL(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0xff)|value)
}
func (o *GPIO_PIN_INT_Type) GetSIENR_SETENRL() uint32 {
	return volatile.LoadUint32(&o.SIENR.Reg) & 0xff
}
func (o *GPIO_PIN_INT_Type) SetSIENR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SIENR.Reg, volatile.LoadUint32(&o.SIENR.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetSIENR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SIENR.Reg) & 0xffffff00) >> 8
}

// GPIO_PIN_INT.CIENR: Pin interrupt level or rising edge interrupt clear register
func (o *GPIO_PIN_INT_Type) SetCIENR_CENRL(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0xff)|value)
}
func (o *GPIO_PIN_INT_Type) GetCIENR_CENRL() uint32 {
	return volatile.LoadUint32(&o.CIENR.Reg) & 0xff
}
func (o *GPIO_PIN_INT_Type) SetCIENR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CIENR.Reg, volatile.LoadUint32(&o.CIENR.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetCIENR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CIENR.Reg) & 0xffffff00) >> 8
}

// GPIO_PIN_INT.IENF: Pin interrupt active level or falling edge interrupt enable register
func (o *GPIO_PIN_INT_Type) SetIENF_ENAF(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0xff)|value)
}
func (o *GPIO_PIN_INT_Type) GetIENF_ENAF() uint32 {
	return volatile.LoadUint32(&o.IENF.Reg) & 0xff
}
func (o *GPIO_PIN_INT_Type) SetIENF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IENF.Reg, volatile.LoadUint32(&o.IENF.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetIENF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IENF.Reg) & 0xffffff00) >> 8
}

// GPIO_PIN_INT.SIENF: Pin interrupt active level or falling edge interrupt set register
func (o *GPIO_PIN_INT_Type) SetSIENF_SETENAF(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0xff)|value)
}
func (o *GPIO_PIN_INT_Type) GetSIENF_SETENAF() uint32 {
	return volatile.LoadUint32(&o.SIENF.Reg) & 0xff
}
func (o *GPIO_PIN_INT_Type) SetSIENF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SIENF.Reg, volatile.LoadUint32(&o.SIENF.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetSIENF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SIENF.Reg) & 0xffffff00) >> 8
}

// GPIO_PIN_INT.CIENF: Pin interrupt active level (falling edge) interrupt clear register
func (o *GPIO_PIN_INT_Type) SetCIENF_CENAF(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0xff)|value)
}
func (o *GPIO_PIN_INT_Type) GetCIENF_CENAF() uint32 {
	return volatile.LoadUint32(&o.CIENF.Reg) & 0xff
}
func (o *GPIO_PIN_INT_Type) SetCIENF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CIENF.Reg, volatile.LoadUint32(&o.CIENF.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetCIENF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CIENF.Reg) & 0xffffff00) >> 8
}

// GPIO_PIN_INT.RISE: Pin interrupt rising edge register
func (o *GPIO_PIN_INT_Type) SetRISE_RDET(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0xff)|value)
}
func (o *GPIO_PIN_INT_Type) GetRISE_RDET() uint32 {
	return volatile.LoadUint32(&o.RISE.Reg) & 0xff
}
func (o *GPIO_PIN_INT_Type) SetRISE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RISE.Reg, volatile.LoadUint32(&o.RISE.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetRISE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RISE.Reg) & 0xffffff00) >> 8
}

// GPIO_PIN_INT.FALL: Pin interrupt falling edge register
func (o *GPIO_PIN_INT_Type) SetFALL_FDET(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0xff)|value)
}
func (o *GPIO_PIN_INT_Type) GetFALL_FDET() uint32 {
	return volatile.LoadUint32(&o.FALL.Reg) & 0xff
}
func (o *GPIO_PIN_INT_Type) SetFALL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FALL.Reg, volatile.LoadUint32(&o.FALL.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetFALL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FALL.Reg) & 0xffffff00) >> 8
}

// GPIO_PIN_INT.IST: Pin interrupt status register
func (o *GPIO_PIN_INT_Type) SetIST_PSTAT(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0xff)|value)
}
func (o *GPIO_PIN_INT_Type) GetIST_PSTAT() uint32 {
	return volatile.LoadUint32(&o.IST.Reg) & 0xff
}
func (o *GPIO_PIN_INT_Type) SetIST_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IST.Reg, volatile.LoadUint32(&o.IST.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetIST_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IST.Reg) & 0xffffff00) >> 8
}

// GPIO_PIN_INT.PMCTRL: GPIO pattern match interrupt control register
func (o *GPIO_PIN_INT_Type) SetPMCTRL_SEL_PMATCH(value uint32) {
	volatile.StoreUint32(&o.PMCTRL.Reg, volatile.LoadUint32(&o.PMCTRL.Reg)&^(0x1)|value)
}
func (o *GPIO_PIN_INT_Type) GetPMCTRL_SEL_PMATCH() uint32 {
	return volatile.LoadUint32(&o.PMCTRL.Reg) & 0x1
}
func (o *GPIO_PIN_INT_Type) SetPMCTRL_ENA_RXEV(value uint32) {
	volatile.StoreUint32(&o.PMCTRL.Reg, volatile.LoadUint32(&o.PMCTRL.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_PIN_INT_Type) GetPMCTRL_ENA_RXEV() uint32 {
	return (volatile.LoadUint32(&o.PMCTRL.Reg) & 0x2) >> 1
}
func (o *GPIO_PIN_INT_Type) SetPMCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PMCTRL.Reg, volatile.LoadUint32(&o.PMCTRL.Reg)&^(0xfffffc)|value<<2)
}
func (o *GPIO_PIN_INT_Type) GetPMCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PMCTRL.Reg) & 0xfffffc) >> 2
}
func (o *GPIO_PIN_INT_Type) SetPMCTRL_PMAT(value uint32) {
	volatile.StoreUint32(&o.PMCTRL.Reg, volatile.LoadUint32(&o.PMCTRL.Reg)&^(0xff000000)|value<<24)
}
func (o *GPIO_PIN_INT_Type) GetPMCTRL_PMAT() uint32 {
	return (volatile.LoadUint32(&o.PMCTRL.Reg) & 0xff000000) >> 24
}

// GPIO_PIN_INT.PMSRC: GPIO pattern match interrupt bit-slice source register
func (o *GPIO_PIN_INT_Type) SetPMSRC_Reserved(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0xff)|value)
}
func (o *GPIO_PIN_INT_Type) GetPMSRC_Reserved() uint32 {
	return volatile.LoadUint32(&o.PMSRC.Reg) & 0xff
}
func (o *GPIO_PIN_INT_Type) SetPMSRC_SRC0(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0x700)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetPMSRC_SRC0() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0x700) >> 8
}
func (o *GPIO_PIN_INT_Type) SetPMSRC_SRC1(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0x3800)|value<<11)
}
func (o *GPIO_PIN_INT_Type) GetPMSRC_SRC1() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0x3800) >> 11
}
func (o *GPIO_PIN_INT_Type) SetPMSRC_SRC2(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0x1c000)|value<<14)
}
func (o *GPIO_PIN_INT_Type) GetPMSRC_SRC2() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0x1c000) >> 14
}
func (o *GPIO_PIN_INT_Type) SetPMSRC_SRC3(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0xe0000)|value<<17)
}
func (o *GPIO_PIN_INT_Type) GetPMSRC_SRC3() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0xe0000) >> 17
}
func (o *GPIO_PIN_INT_Type) SetPMSRC_SRC4(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0x700000)|value<<20)
}
func (o *GPIO_PIN_INT_Type) GetPMSRC_SRC4() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0x700000) >> 20
}
func (o *GPIO_PIN_INT_Type) SetPMSRC_SRC5(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0x3800000)|value<<23)
}
func (o *GPIO_PIN_INT_Type) GetPMSRC_SRC5() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0x3800000) >> 23
}
func (o *GPIO_PIN_INT_Type) SetPMSRC_SRC6(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0x1c000000)|value<<26)
}
func (o *GPIO_PIN_INT_Type) GetPMSRC_SRC6() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0x1c000000) >> 26
}
func (o *GPIO_PIN_INT_Type) SetPMSRC_SRC7(value uint32) {
	volatile.StoreUint32(&o.PMSRC.Reg, volatile.LoadUint32(&o.PMSRC.Reg)&^(0xe0000000)|value<<29)
}
func (o *GPIO_PIN_INT_Type) GetPMSRC_SRC7() uint32 {
	return (volatile.LoadUint32(&o.PMSRC.Reg) & 0xe0000000) >> 29
}

// GPIO_PIN_INT.PMCFG: GPIO pattern match interrupt bit slice configuration register
func (o *GPIO_PIN_INT_Type) SetPMCFG_PROD_ENDPTS(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x7f)|value)
}
func (o *GPIO_PIN_INT_Type) GetPMCFG_PROD_ENDPTS() uint32 {
	return volatile.LoadUint32(&o.PMCFG.Reg) & 0x7f
}
func (o *GPIO_PIN_INT_Type) SetPMCFG_Reserved(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_PIN_INT_Type) GetPMCFG_Reserved() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0x80) >> 7
}
func (o *GPIO_PIN_INT_Type) SetPMCFG_CFG0(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x700)|value<<8)
}
func (o *GPIO_PIN_INT_Type) GetPMCFG_CFG0() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0x700) >> 8
}
func (o *GPIO_PIN_INT_Type) SetPMCFG_CFG1(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x3800)|value<<11)
}
func (o *GPIO_PIN_INT_Type) GetPMCFG_CFG1() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0x3800) >> 11
}
func (o *GPIO_PIN_INT_Type) SetPMCFG_CFG2(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x1c000)|value<<14)
}
func (o *GPIO_PIN_INT_Type) GetPMCFG_CFG2() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0x1c000) >> 14
}
func (o *GPIO_PIN_INT_Type) SetPMCFG_CFG3(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0xe0000)|value<<17)
}
func (o *GPIO_PIN_INT_Type) GetPMCFG_CFG3() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0xe0000) >> 17
}
func (o *GPIO_PIN_INT_Type) SetPMCFG_CFG4(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x700000)|value<<20)
}
func (o *GPIO_PIN_INT_Type) GetPMCFG_CFG4() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0x700000) >> 20
}
func (o *GPIO_PIN_INT_Type) SetPMCFG_CFG5(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x3800000)|value<<23)
}
func (o *GPIO_PIN_INT_Type) GetPMCFG_CFG5() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0x3800000) >> 23
}
func (o *GPIO_PIN_INT_Type) SetPMCFG_CFG6(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0x1c000000)|value<<26)
}
func (o *GPIO_PIN_INT_Type) GetPMCFG_CFG6() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0x1c000000) >> 26
}
func (o *GPIO_PIN_INT_Type) SetPMCFG_CFG7(value uint32) {
	volatile.StoreUint32(&o.PMCFG.Reg, volatile.LoadUint32(&o.PMCFG.Reg)&^(0xe0000000)|value<<29)
}
func (o *GPIO_PIN_INT_Type) GetPMCFG_CFG7() uint32 {
	return (volatile.LoadUint32(&o.PMCFG.Reg) & 0xe0000000) >> 29
}

// Constants for WWDT: Windowed Watchdog Timer (WWDT)
const (
	// MOD: Watchdog mode register. This register contains the basic mode and status of the Watchdog Timer.
	// Position of WDEN field.
	WWDT_MOD_WDEN_Pos = 0x0
	// Bit mask of WDEN field.
	WWDT_MOD_WDEN_Msk = 0x1
	// Bit WDEN.
	WWDT_MOD_WDEN = 0x1
	// The watchdog timer is stopped.
	WWDT_MOD_WDEN_STOPPED = 0x0
	// The watchdog timer is running.
	WWDT_MOD_WDEN_RUNNING = 0x1
	// Position of WDRESET field.
	WWDT_MOD_WDRESET_Pos = 0x1
	// Bit mask of WDRESET field.
	WWDT_MOD_WDRESET_Msk = 0x2
	// Bit WDRESET.
	WWDT_MOD_WDRESET = 0x2
	// A watchdog timeout will not cause a chip reset.
	WWDT_MOD_WDRESET_NORESET = 0x0
	// A watchdog timeout will cause a chip reset.
	WWDT_MOD_WDRESET_RESET = 0x1
	// Position of WDTOF field.
	WWDT_MOD_WDTOF_Pos = 0x2
	// Bit mask of WDTOF field.
	WWDT_MOD_WDTOF_Msk = 0x4
	// Bit WDTOF.
	WWDT_MOD_WDTOF = 0x4
	// Position of WDINT field.
	WWDT_MOD_WDINT_Pos = 0x3
	// Bit mask of WDINT field.
	WWDT_MOD_WDINT_Msk = 0x8
	// Bit WDINT.
	WWDT_MOD_WDINT = 0x8
	// Position of WDPROTECT field.
	WWDT_MOD_WDPROTECT_Pos = 0x4
	// Bit mask of WDPROTECT field.
	WWDT_MOD_WDPROTECT_Msk = 0x10
	// Bit WDPROTECT.
	WWDT_MOD_WDPROTECT = 0x10
	// Position of LOCK field.
	WWDT_MOD_LOCK_Pos = 0x5
	// Bit mask of LOCK field.
	WWDT_MOD_LOCK_Msk = 0x20
	// Bit LOCK.
	WWDT_MOD_LOCK = 0x20
	// Position of RESERVED field.
	WWDT_MOD_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	WWDT_MOD_RESERVED_Msk = 0xffffffc0

	// TC: Watchdog timer constant register. This 24-bit register determines the time-out value.
	// Position of COUNT field.
	WWDT_TC_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	WWDT_TC_COUNT_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_TC_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_TC_RESERVED_Msk = 0xff000000

	// FEED: Watchdog feed sequence register. Writing 0xAA followed by 0x55 to this register reloads the Watchdog timer with the value contained in WDTC.
	// Position of FEED field.
	WWDT_FEED_FEED_Pos = 0x0
	// Bit mask of FEED field.
	WWDT_FEED_FEED_Msk = 0xff
	// Position of RESERVED field.
	WWDT_FEED_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	WWDT_FEED_RESERVED_Msk = 0xffffff00

	// TV: Watchdog timer value register. This 24-bit register reads out the current value of the Watchdog timer.
	// Position of COUNT field.
	WWDT_TV_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	WWDT_TV_COUNT_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_TV_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_TV_RESERVED_Msk = 0xff000000

	// WARNINT: Watchdog Warning Interrupt compare value.
	// Position of WARNINT field.
	WWDT_WARNINT_WARNINT_Pos = 0x0
	// Bit mask of WARNINT field.
	WWDT_WARNINT_WARNINT_Msk = 0x3ff
	// Position of RESERVED field.
	WWDT_WARNINT_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	WWDT_WARNINT_RESERVED_Msk = 0xfffffc00

	// WINDOW: Watchdog Window compare value.
	// Position of WINDOW field.
	WWDT_WINDOW_WINDOW_Pos = 0x0
	// Bit mask of WINDOW field.
	WWDT_WINDOW_WINDOW_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_WINDOW_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_WINDOW_RESERVED_Msk = 0xff000000
)

// Constants for MRT: Multi-Rate Timer (MRT)
const (
	// INTVAL0: MRT0 Time interval value register. This value is loaded into the TIMER0 register.
	// Position of IVALUE field.
	MRT_INTVAL_IVALUE_Pos = 0x0
	// Bit mask of IVALUE field.
	MRT_INTVAL_IVALUE_Msk = 0xffffff
	// Position of RESERVED field.
	MRT_INTVAL_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	MRT_INTVAL_RESERVED_Msk = 0x7f000000
	// Position of LOAD field.
	MRT_INTVAL_LOAD_Pos = 0x1f
	// Bit mask of LOAD field.
	MRT_INTVAL_LOAD_Msk = 0x80000000
	// Bit LOAD.
	MRT_INTVAL_LOAD = 0x80000000
	// No force load. The load from the INTVALn register to the TIMERn register is processed at the end of the time interval if the repeat mode is selected.
	MRT_INTVAL_LOAD_NO_FORCE_LOAD_THE_L = 0x0
	// Force load. The INTVALn interval value IVALUE is immediately loaded into the TIMERn register while TIMERn is running.
	MRT_INTVAL_LOAD_FORCE_LOAD_THE_INTV = 0x1

	// TIMER0: MRT0 Timer register. This register reads the value of the down-counter.
	// Position of VALUE field.
	MRT_TIMER_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	MRT_TIMER_VALUE_Msk = 0xffffff
	// Position of RESERVED field.
	MRT_TIMER_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	MRT_TIMER_RESERVED_Msk = 0xff000000

	// CTRL0: MRT0 Control register. This register controls the MRT0 modes.
	// Position of INTEN field.
	MRT_CTRL_INTEN_Pos = 0x0
	// Bit mask of INTEN field.
	MRT_CTRL_INTEN_Msk = 0x1
	// Bit INTEN.
	MRT_CTRL_INTEN = 0x1
	// Disable.
	MRT_CTRL_INTEN_DISABLE_ = 0x0
	// Enable.
	MRT_CTRL_INTEN_ENABLE_ = 0x1
	// Position of MODE field.
	MRT_CTRL_MODE_Pos = 0x1
	// Bit mask of MODE field.
	MRT_CTRL_MODE_Msk = 0x6
	// Repeat interrupt mode.
	MRT_CTRL_MODE_REPEAT_INTERRUPT_MOD = 0x0
	// One-shot interrupt mode.
	MRT_CTRL_MODE_ONE_SHOT_INTERRUPT_M = 0x1
	// One-shot bus stall mode.
	MRT_CTRL_MODE_ONE_SHOT_BUS_STALL_M = 0x2
	// Reserved.
	MRT_CTRL_MODE_RESERVED_ = 0x3
	// Position of RESERVED field.
	MRT_CTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	MRT_CTRL_RESERVED_Msk = 0xfffffff8

	// STAT0: MRT0 Status register.
	// Position of INTFLAG field.
	MRT_STAT_INTFLAG_Pos = 0x0
	// Bit mask of INTFLAG field.
	MRT_STAT_INTFLAG_Msk = 0x1
	// Bit INTFLAG.
	MRT_STAT_INTFLAG = 0x1
	// No pending interrupt. Writing a zero is equivalent to no operation.
	MRT_STAT_INTFLAG_NO_PENDING_INTERRUPT = 0x0
	// Pending interrupt. The interrupt is pending because TIMERn has reached the end of the time interval. If the INTEN bit in the CONTROLn is also set to 1, the interrupt for timer channel n and the global interrupt are raised. Writing a 1 to this bit clears the interrupt request.
	MRT_STAT_INTFLAG_PENDING_INTERRUPT_T = 0x1
	// Position of RUN field.
	MRT_STAT_RUN_Pos = 0x1
	// Bit mask of RUN field.
	MRT_STAT_RUN_Msk = 0x2
	// Bit RUN.
	MRT_STAT_RUN = 0x2
	// Idle state. TIMERn is stopped.
	MRT_STAT_RUN_IDLE_STATE_TIMERN_I = 0x0
	// Running. TIMERn is running.
	MRT_STAT_RUN_RUNNING_TIMERN_IS_R = 0x1
	// Position of RESERVED field.
	MRT_STAT_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	MRT_STAT_RESERVED_Msk = 0xfffffffc

	// IDLE_CH: Idle channel register. This register returns the number of the first idle channel.
	// Position of RESERVED field.
	MRT_IDLE_CH_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	MRT_IDLE_CH_RESERVED_Msk = 0xf
	// Position of CHAN field.
	MRT_IDLE_CH_CHAN_Pos = 0x4
	// Bit mask of CHAN field.
	MRT_IDLE_CH_CHAN_Msk = 0xf0
	// Position of RESERVED field.
	MRT_IDLE_CH_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	MRT_IDLE_CH_RESERVED_Msk = 0xffffff00

	// IRQ_FLAG: Global interrupt flag register
	// Position of GFLAG0 field.
	MRT_IRQ_FLAG_GFLAG0_Pos = 0x0
	// Bit mask of GFLAG0 field.
	MRT_IRQ_FLAG_GFLAG0_Msk = 0x1
	// Bit GFLAG0.
	MRT_IRQ_FLAG_GFLAG0 = 0x1
	// No pending interrupt. Writing a zero is equivalent to no operation.
	MRT_IRQ_FLAG_GFLAG0_NO_PENDING_INTERRUPT = 0x0
	// Pending interrupt. The interrupt is pending because TIMER0 has reached the end of the time interval. If the INTEN bit in the CONTROL0 register is also set to 1, the interrupt for timer channel 0 and the global interrupt are raised. Writing a 1 to this bit clears the interrupt request.
	MRT_IRQ_FLAG_GFLAG0_PENDING_INTERRUPT_T = 0x1
	// Position of GFLAG1 field.
	MRT_IRQ_FLAG_GFLAG1_Pos = 0x1
	// Bit mask of GFLAG1 field.
	MRT_IRQ_FLAG_GFLAG1_Msk = 0x2
	// Bit GFLAG1.
	MRT_IRQ_FLAG_GFLAG1 = 0x2
	// No pending interrupt. Writing a zero is equivalent to no operation.
	MRT_IRQ_FLAG_GFLAG1_NO_PENDING_INTERRUPT = 0x0
	// Pending interrupt. The interrupt is pending because TIMER1 has reached the end of the time interval. If the INTEN bit in the CONTROL1 register is also set to 1, the interrupt for timer channel 1 and the global interrupt are raised. Writing a 1 to this bit clears the interrupt request.
	MRT_IRQ_FLAG_GFLAG1_PENDING_INTERRUPT_T = 0x1
	// Position of GFLAG2 field.
	MRT_IRQ_FLAG_GFLAG2_Pos = 0x2
	// Bit mask of GFLAG2 field.
	MRT_IRQ_FLAG_GFLAG2_Msk = 0x4
	// Bit GFLAG2.
	MRT_IRQ_FLAG_GFLAG2 = 0x4
	// No pending interrupt. Writing a zero is equivalent to no operation.
	MRT_IRQ_FLAG_GFLAG2_NO_PENDING_INTERRUPT = 0x0
	// Pending interrupt. The interrupt is pending because TIMER2 has reached the end of the time interval. If the INTEN bit in the CONTROL2 register is also set to 1, the interrupt for timer channel 2 and the global interrupt are raised. Writing a 1 to this bit clears the interrupt request.
	MRT_IRQ_FLAG_GFLAG2_PENDING_INTERRUPT_T = 0x1
	// Position of GFLAG3 field.
	MRT_IRQ_FLAG_GFLAG3_Pos = 0x3
	// Bit mask of GFLAG3 field.
	MRT_IRQ_FLAG_GFLAG3_Msk = 0x8
	// Bit GFLAG3.
	MRT_IRQ_FLAG_GFLAG3 = 0x8
	// No pending interrupt. Writing a zero is equivalent to no operation.
	MRT_IRQ_FLAG_GFLAG3_NO_PENDING_INTERRUPT = 0x0
	// Pending interrupt. The interrupt is pending because TIMER3 has reached the end of the time interval. If the INTEN bit in the CONTROL3 register is also set to 1, the interrupt for timer channel 3 and the global interrupt are raised. Writing a 1 to this bit clears the interrupt request.
	MRT_IRQ_FLAG_GFLAG3_PENDING_INTERRUPT_T = 0x1
	// Position of RESERVED field.
	MRT_IRQ_FLAG_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	MRT_IRQ_FLAG_RESERVED_Msk = 0xfffffff0
)

// Constants for WKT: Self wake-up timer (WKT)
const (
	// CTRL: Self wake-up timer control register.
	// Position of CLKSEL field.
	WKT_CTRL_CLKSEL_Pos = 0x0
	// Bit mask of CLKSEL field.
	WKT_CTRL_CLKSEL_Msk = 0x1
	// Bit CLKSEL.
	WKT_CTRL_CLKSEL = 0x1
	// Divided IRC clock. This clock runs at 750 kHz and provides time-out periods of up to approximately 95 minutes in 1.33 us increments. This clock is not available in most low-power modes and must not be selected if the timer is to be used to wake up from one of these modes.
	WKT_CTRL_CLKSEL_DIVIDED_IRC_CLOCK_T = 0x0
	// Low power clock. This is the (nominally) 10 kHz clock and provides time-out periods of up to approximately 119 hours in 100 CTS can be from the input pin, or fs increments. The accuracy of this clock is limited to +/- 45 % over temperature and processing. This clock is available in all power modes. Prior to use, the low-power oscillator must be enabled. The oscillator must also be set to remain active in Deep power-down if needed.
	WKT_CTRL_CLKSEL_LOW_POWER_CLOCK_THI = 0x1
	// Position of ALARMFLAG field.
	WKT_CTRL_ALARMFLAG_Pos = 0x1
	// Bit mask of ALARMFLAG field.
	WKT_CTRL_ALARMFLAG_Msk = 0x2
	// Bit ALARMFLAG.
	WKT_CTRL_ALARMFLAG = 0x2
	// No time-out. The self wake-up timer has not timed out. Writing a 0 to has no effect.
	WKT_CTRL_ALARMFLAG_NO_TIME_OUT_THE_SEL = 0x0
	// Time-out. The self wake-up timer has timed out. This flag generates an interrupt request which can wake up the part from any low power mode not deep power-down. Writing a 1 clears this status bit and the interrupt too?
	WKT_CTRL_ALARMFLAG_TIME_OUT_THE_SELF_W = 0x1
	// Position of CLEARCTR field.
	WKT_CTRL_CLEARCTR_Pos = 0x2
	// Bit mask of CLEARCTR field.
	WKT_CTRL_CLEARCTR_Msk = 0x4
	// Bit CLEARCTR.
	WKT_CTRL_CLEARCTR = 0x4
	// No effect. Reading this bit always returns 0.
	WKT_CTRL_CLEARCTR_NO_EFFECT_READING_T = 0x0
	// Clear the counter. Counting is halted until a new count value is loaded.
	WKT_CTRL_CLEARCTR_CLEAR_THE_COUNTER_C = 0x1
	// Position of RESERVED field.
	WKT_CTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	WKT_CTRL_RESERVED_Msk = 0xfffffff8

	// COUNT: Counter register.
	// Position of VALUE field.
	WKT_COUNT_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	WKT_COUNT_VALUE_Msk = 0xffffffff
)

// Constants for SWM: Switch matrix (SWM)
const (
	// PINASSIGN0: Pin assign register 0. Assign movable functions U0_TXD, U0_RXD, U0_RTS, U0_CTS
	// Position of U0_TXD_O field.
	SWM_PINASSIGN0_U0_TXD_O_Pos = 0x0
	// Bit mask of U0_TXD_O field.
	SWM_PINASSIGN0_U0_TXD_O_Msk = 0xff
	// Position of U0_RXD_I field.
	SWM_PINASSIGN0_U0_RXD_I_Pos = 0x8
	// Bit mask of U0_RXD_I field.
	SWM_PINASSIGN0_U0_RXD_I_Msk = 0xff00
	// Position of U0_RTS_O field.
	SWM_PINASSIGN0_U0_RTS_O_Pos = 0x10
	// Bit mask of U0_RTS_O field.
	SWM_PINASSIGN0_U0_RTS_O_Msk = 0xff0000
	// Position of U0_CTS_I field.
	SWM_PINASSIGN0_U0_CTS_I_Pos = 0x18
	// Bit mask of U0_CTS_I field.
	SWM_PINASSIGN0_U0_CTS_I_Msk = 0xff000000

	// PINASSIGN1: Pin assign register 1. Assign movable functions U0_SCLC, U1_TXD, U1_RXD
	// Position of U0_SCLK_IO field.
	SWM_PINASSIGN1_U0_SCLK_IO_Pos = 0x0
	// Bit mask of U0_SCLK_IO field.
	SWM_PINASSIGN1_U0_SCLK_IO_Msk = 0xff
	// Position of U1_TXD_O field.
	SWM_PINASSIGN1_U1_TXD_O_Pos = 0x8
	// Bit mask of U1_TXD_O field.
	SWM_PINASSIGN1_U1_TXD_O_Msk = 0xff00
	// Position of U1_RXD_I field.
	SWM_PINASSIGN1_U1_RXD_I_Pos = 0x10
	// Bit mask of U1_RXD_I field.
	SWM_PINASSIGN1_U1_RXD_I_Msk = 0xff0000
	// Position of U1_RTS_O field.
	SWM_PINASSIGN1_U1_RTS_O_Pos = 0x18
	// Bit mask of U1_RTS_O field.
	SWM_PINASSIGN1_U1_RTS_O_Msk = 0xff000000

	// PINASSIGN2: Pin assign register 2. Assign movable functions U2_TXD, U2_RXD
	// Position of U1_CTS_I field.
	SWM_PINASSIGN2_U1_CTS_I_Pos = 0x0
	// Bit mask of U1_CTS_I field.
	SWM_PINASSIGN2_U1_CTS_I_Msk = 0xff
	// Position of U1_SCLK_IO field.
	SWM_PINASSIGN2_U1_SCLK_IO_Pos = 0x8
	// Bit mask of U1_SCLK_IO field.
	SWM_PINASSIGN2_U1_SCLK_IO_Msk = 0xff00
	// Position of U2_TXD_O field.
	SWM_PINASSIGN2_U2_TXD_O_Pos = 0x10
	// Bit mask of U2_TXD_O field.
	SWM_PINASSIGN2_U2_TXD_O_Msk = 0xff0000
	// Position of U2_RXD_I field.
	SWM_PINASSIGN2_U2_RXD_I_Pos = 0x18
	// Bit mask of U2_RXD_I field.
	SWM_PINASSIGN2_U2_RXD_I_Msk = 0xff000000

	// PINASSIGN3: Pin assignregister 3. Assign movable function SPI0_SCK
	// Position of U2_RTS_O field.
	SWM_PINASSIGN3_U2_RTS_O_Pos = 0x0
	// Bit mask of U2_RTS_O field.
	SWM_PINASSIGN3_U2_RTS_O_Msk = 0xff
	// Position of U2_CTS_I field.
	SWM_PINASSIGN3_U2_CTS_I_Pos = 0x8
	// Bit mask of U2_CTS_I field.
	SWM_PINASSIGN3_U2_CTS_I_Msk = 0xff00
	// Position of U2_SCLK_IO field.
	SWM_PINASSIGN3_U2_SCLK_IO_Pos = 0x10
	// Bit mask of U2_SCLK_IO field.
	SWM_PINASSIGN3_U2_SCLK_IO_Msk = 0xff0000
	// Position of SPI0_SCK_IO field.
	SWM_PINASSIGN3_SPI0_SCK_IO_Pos = 0x18
	// Bit mask of SPI0_SCK_IO field.
	SWM_PINASSIGN3_SPI0_SCK_IO_Msk = 0xff000000

	// PINASSIGN4: Pin assign register 4. Assign movable functions SPI0_MOSI, SPI0_MISO, SPI0_SSEL, SPI1_SCK
	// Position of SPI0_MOSI_IO field.
	SWM_PINASSIGN4_SPI0_MOSI_IO_Pos = 0x0
	// Bit mask of SPI0_MOSI_IO field.
	SWM_PINASSIGN4_SPI0_MOSI_IO_Msk = 0xff
	// Position of SPI0_MISO_IO field.
	SWM_PINASSIGN4_SPI0_MISO_IO_Pos = 0x8
	// Bit mask of SPI0_MISO_IO field.
	SWM_PINASSIGN4_SPI0_MISO_IO_Msk = 0xff00
	// Position of SPI0_SSEL_IO field.
	SWM_PINASSIGN4_SPI0_SSEL_IO_Pos = 0x10
	// Bit mask of SPI0_SSEL_IO field.
	SWM_PINASSIGN4_SPI0_SSEL_IO_Msk = 0xff0000
	// Position of SPI1_SCK_IO field.
	SWM_PINASSIGN4_SPI1_SCK_IO_Pos = 0x18
	// Bit mask of SPI1_SCK_IO field.
	SWM_PINASSIGN4_SPI1_SCK_IO_Msk = 0xff000000

	// PINASSIGN5: Pin assign register 5. Assign movable functions SPI1_MOSI, SPI1_MISO, SPI1_SSEL, CTIN_0
	// Position of SPI1_MOSI_IO field.
	SWM_PINASSIGN5_SPI1_MOSI_IO_Pos = 0x0
	// Bit mask of SPI1_MOSI_IO field.
	SWM_PINASSIGN5_SPI1_MOSI_IO_Msk = 0xff
	// Position of SPI1_MISO_IO field.
	SWM_PINASSIGN5_SPI1_MISO_IO_Pos = 0x8
	// Bit mask of SPI1_MISO_IO field.
	SWM_PINASSIGN5_SPI1_MISO_IO_Msk = 0xff00
	// Position of SPI1_SSEL_IO field.
	SWM_PINASSIGN5_SPI1_SSEL_IO_Pos = 0x10
	// Bit mask of SPI1_SSEL_IO field.
	SWM_PINASSIGN5_SPI1_SSEL_IO_Msk = 0xff0000
	// Position of CTIN_0_I field.
	SWM_PINASSIGN5_CTIN_0_I_Pos = 0x18
	// Bit mask of CTIN_0_I field.
	SWM_PINASSIGN5_CTIN_0_I_Msk = 0xff000000

	// PINASSIGN6: Pin assign register 6. Assign movable functions CTIN_1, CTIN_2, CTIN_3, CTOUT_0
	// Position of CTIN_1_I field.
	SWM_PINASSIGN6_CTIN_1_I_Pos = 0x0
	// Bit mask of CTIN_1_I field.
	SWM_PINASSIGN6_CTIN_1_I_Msk = 0xff
	// Position of CTIN_2_I field.
	SWM_PINASSIGN6_CTIN_2_I_Pos = 0x8
	// Bit mask of CTIN_2_I field.
	SWM_PINASSIGN6_CTIN_2_I_Msk = 0xff00
	// Position of CTIN_3_I field.
	SWM_PINASSIGN6_CTIN_3_I_Pos = 0x10
	// Bit mask of CTIN_3_I field.
	SWM_PINASSIGN6_CTIN_3_I_Msk = 0xff0000
	// Position of CTOUT_0_O field.
	SWM_PINASSIGN6_CTOUT_0_O_Pos = 0x18
	// Bit mask of CTOUT_0_O field.
	SWM_PINASSIGN6_CTOUT_0_O_Msk = 0xff000000

	// PINASSIGN7: Pin assign egister 7. Assign movable functions CTOUT_1, CTOUT_2, CTOUT_3, I2C_SDA
	// Position of CTOUT_1_O field.
	SWM_PINASSIGN7_CTOUT_1_O_Pos = 0x0
	// Bit mask of CTOUT_1_O field.
	SWM_PINASSIGN7_CTOUT_1_O_Msk = 0xff
	// Position of CTOUT_2_O field.
	SWM_PINASSIGN7_CTOUT_2_O_Pos = 0x8
	// Bit mask of CTOUT_2_O field.
	SWM_PINASSIGN7_CTOUT_2_O_Msk = 0xff00
	// Position of CTOUT_3_O field.
	SWM_PINASSIGN7_CTOUT_3_O_Pos = 0x10
	// Bit mask of CTOUT_3_O field.
	SWM_PINASSIGN7_CTOUT_3_O_Msk = 0xff0000
	// Position of I2C_SDA_IO field.
	SWM_PINASSIGN7_I2C_SDA_IO_Pos = 0x18
	// Bit mask of I2C_SDA_IO field.
	SWM_PINASSIGN7_I2C_SDA_IO_Msk = 0xff000000

	// PINASSIGN8: Pin assign register 8. Assign movable functions I2C_SCL, ACMP_O, CLKOUT, GPIO_INT_BMAT
	// Position of I2C_SCL_IO field.
	SWM_PINASSIGN8_I2C_SCL_IO_Pos = 0x0
	// Bit mask of I2C_SCL_IO field.
	SWM_PINASSIGN8_I2C_SCL_IO_Msk = 0xff
	// Position of ACMP_O_O field.
	SWM_PINASSIGN8_ACMP_O_O_Pos = 0x8
	// Bit mask of ACMP_O_O field.
	SWM_PINASSIGN8_ACMP_O_O_Msk = 0xff00
	// Position of CLKOUT_O field.
	SWM_PINASSIGN8_CLKOUT_O_Pos = 0x10
	// Bit mask of CLKOUT_O field.
	SWM_PINASSIGN8_CLKOUT_O_Msk = 0xff0000
	// Position of GPIO_INT_BMAT_O field.
	SWM_PINASSIGN8_GPIO_INT_BMAT_O_Pos = 0x18
	// Bit mask of GPIO_INT_BMAT_O field.
	SWM_PINASSIGN8_GPIO_INT_BMAT_O_Msk = 0xff000000

	// PINENABLE0: Pin enable register 0. Enables fixed-pin functions ACMP_I0, ACMP_I1, SWCLK, SWDIO, XTALIN, XTALOUT, RESET, CLKIN, VDDCMP
	// Position of ACMP_I1_EN field.
	SWM_PINENABLE0_ACMP_I1_EN_Pos = 0x0
	// Bit mask of ACMP_I1_EN field.
	SWM_PINENABLE0_ACMP_I1_EN_Msk = 0x1
	// Bit ACMP_I1_EN.
	SWM_PINENABLE0_ACMP_I1_EN = 0x1
	// Enable ACMP_I1. This function is enabled on pin PIO0_0.
	SWM_PINENABLE0_ACMP_I1_EN_ENABLE_ACMP_I1_THIS = 0x0
	// Disable ACMP_I1. GPIO function PIO0_0 (default) or any other movable function can be assigned to pin PIO0_0.
	SWM_PINENABLE0_ACMP_I1_EN_DISABLE_ACMP_I1_GPI = 0x1
	// Position of ACMP_I2_EN field.
	SWM_PINENABLE0_ACMP_I2_EN_Pos = 0x1
	// Bit mask of ACMP_I2_EN field.
	SWM_PINENABLE0_ACMP_I2_EN_Msk = 0x2
	// Bit ACMP_I2_EN.
	SWM_PINENABLE0_ACMP_I2_EN = 0x2
	// Enable ACMP_I2. This function is enabled on pin PIO0_1.
	SWM_PINENABLE0_ACMP_I2_EN_ENABLE_ACMP_I2_THIS = 0x0
	// Disable ACMP_I2. GPIO function PIO0_1 (default) or any other movable function can be assigned to pin PIO0_1.
	SWM_PINENABLE0_ACMP_I2_EN_DISABLE_ACMP_I2_GPI = 0x1
	// Position of SWCLK_EN field.
	SWM_PINENABLE0_SWCLK_EN_Pos = 0x2
	// Bit mask of SWCLK_EN field.
	SWM_PINENABLE0_SWCLK_EN_Msk = 0x4
	// Bit SWCLK_EN.
	SWM_PINENABLE0_SWCLK_EN = 0x4
	// Enable SWCLK. This function is enabled on pin PIO0_3.
	SWM_PINENABLE0_SWCLK_EN_ENABLE_SWCLK_THIS_F = 0x0
	// Disable SWCLK. GPIO function PIO0_3 is selected on this pin. Any other movable function can be assigned to pin PIO0_3.
	SWM_PINENABLE0_SWCLK_EN_DISABLE_SWCLK_GPIO_ = 0x1
	// Position of SWDIO_EN field.
	SWM_PINENABLE0_SWDIO_EN_Pos = 0x3
	// Bit mask of SWDIO_EN field.
	SWM_PINENABLE0_SWDIO_EN_Msk = 0x8
	// Bit SWDIO_EN.
	SWM_PINENABLE0_SWDIO_EN = 0x8
	// Enable SWDIO. This function is enabled on pin PIO0_2.
	SWM_PINENABLE0_SWDIO_EN_ENABLE_SWDIO_THIS_F = 0x0
	// Disable SWDIO. GPIO function PIO0_2 is selected on this pin. Any other movable function can be assigned to pin PIO0_2.
	SWM_PINENABLE0_SWDIO_EN_DISABLE_SWDIO_GPIO_ = 0x1
	// Position of XTALIN_EN field.
	SWM_PINENABLE0_XTALIN_EN_Pos = 0x4
	// Bit mask of XTALIN_EN field.
	SWM_PINENABLE0_XTALIN_EN_Msk = 0x10
	// Bit XTALIN_EN.
	SWM_PINENABLE0_XTALIN_EN = 0x10
	// Enable XTALIN. This function is enabled on pin PIO0_8.
	SWM_PINENABLE0_XTALIN_EN_ENABLE_XTALIN_THIS_ = 0x0
	// Disable XTALIN. GPIO function PIO0_8 (default) or any other movable function can be assigned to pin PIO0_8.
	SWM_PINENABLE0_XTALIN_EN_DISABLE_XTALIN_GPIO = 0x1
	// Position of XTALOUT_EN field.
	SWM_PINENABLE0_XTALOUT_EN_Pos = 0x5
	// Bit mask of XTALOUT_EN field.
	SWM_PINENABLE0_XTALOUT_EN_Msk = 0x20
	// Bit XTALOUT_EN.
	SWM_PINENABLE0_XTALOUT_EN = 0x20
	// Enable XTALOUT. This function is enabled on pin PIO0_9.
	SWM_PINENABLE0_XTALOUT_EN_ENABLE_XTALOUT_THIS = 0x0
	// Disable XTALOUT. GPIO function PIO0_9 (default) or any other movable function can be assigned to pin PIO0_9.
	SWM_PINENABLE0_XTALOUT_EN_DISABLE_XTALOUT_GPI = 0x1
	// Position of RESET_EN field.
	SWM_PINENABLE0_RESET_EN_Pos = 0x6
	// Bit mask of RESET_EN field.
	SWM_PINENABLE0_RESET_EN_Msk = 0x40
	// Bit RESET_EN.
	SWM_PINENABLE0_RESET_EN = 0x40
	// Enable RESET. This function is enabled on pin PIO0_5.
	SWM_PINENABLE0_RESET_EN_ENABLE_RESET_THIS_F = 0x0
	// Disable RESET. GPIO function PIO0_5 is selected on this pin. Any other movable function can be assigned to pin PIO0_5.
	SWM_PINENABLE0_RESET_EN_DISABLE_RESET_GPIO_ = 0x1
	// Position of CLKIN field.
	SWM_PINENABLE0_CLKIN_Pos = 0x7
	// Bit mask of CLKIN field.
	SWM_PINENABLE0_CLKIN_Msk = 0x80
	// Bit CLKIN.
	SWM_PINENABLE0_CLKIN = 0x80
	// Enable CLKIN. This function is enabled on pin PIO0_1.
	SWM_PINENABLE0_CLKIN_ENABLE_CLKIN_THIS_F = 0x0
	// Disable CLKIN. GPIO function PIO0_1 (default) or any other movable function can be assigned to pin CLKIN.
	SWM_PINENABLE0_CLKIN_DISABLE_CLKIN_GPIO_ = 0x1
	// Position of VDDCMP field.
	SWM_PINENABLE0_VDDCMP_Pos = 0x8
	// Bit mask of VDDCMP field.
	SWM_PINENABLE0_VDDCMP_Msk = 0x100
	// Bit VDDCMP.
	SWM_PINENABLE0_VDDCMP = 0x100
	// Enable VDDCMP. This function is enabled on pin PIO0_6.
	SWM_PINENABLE0_VDDCMP_ENABLE_VDDCMP_THIS_ = 0x0
	// Disable VDDCMP. GPIO function PIO0_6 (default) or any other movable function can be assigned to pin PIO0_6.
	SWM_PINENABLE0_VDDCMP_DISABLE_VDDCMP_GPIO = 0x1
	// Position of RESERVED field.
	SWM_PINENABLE0_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SWM_PINENABLE0_RESERVED_Msk = 0xfffffe00
)

// Constants for PMU: Power Management Unit (PMU)
const (
	// PCON: Power control register
	// Position of PM field.
	PMU_PCON_PM_Pos = 0x0
	// Bit mask of PM field.
	PMU_PCON_PM_Msk = 0x7
	// Default. The part is in active or sleep mode.
	PMU_PCON_PM_DEFAULT_THE_PART_IS = 0x0
	// ARM WFI will enter Power-down mode.
	PMU_PCON_PM_ARM_WFI_WILL_ENTER_P = 0x2
	// Position of NODPD field.
	PMU_PCON_NODPD_Pos = 0x3
	// Bit mask of NODPD field.
	PMU_PCON_NODPD_Msk = 0x8
	// Bit NODPD.
	PMU_PCON_NODPD = 0x8
	// Position of RESERVED field.
	PMU_PCON_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	PMU_PCON_RESERVED_Msk = 0xf0
	// Position of SLEEPFLAG field.
	PMU_PCON_SLEEPFLAG_Pos = 0x8
	// Bit mask of SLEEPFLAG field.
	PMU_PCON_SLEEPFLAG_Msk = 0x100
	// Bit SLEEPFLAG.
	PMU_PCON_SLEEPFLAG = 0x100
	// Read: No power-down mode entered. LPC11Uxx is in Active mode. Write: No effect.
	PMU_PCON_SLEEPFLAG_READ_NO_POWER_DOWN_ = 0x0
	// Read: Sleep/Deep-sleep or Deep power-down mode entered. Write: Writing a 1 clears the SLEEPFLAG bit to 0.
	PMU_PCON_SLEEPFLAG_READ_SLEEPDEEP_SLE = 0x1
	// Position of RESERVED field.
	PMU_PCON_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	PMU_PCON_RESERVED_Msk = 0x600
	// Position of DPDFLAG field.
	PMU_PCON_DPDFLAG_Pos = 0xb
	// Bit mask of DPDFLAG field.
	PMU_PCON_DPDFLAG_Msk = 0x800
	// Bit DPDFLAG.
	PMU_PCON_DPDFLAG = 0x800
	// Position of RESERVED field.
	PMU_PCON_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	PMU_PCON_RESERVED_Msk = 0xfffff000

	// GPREG0: General purpose register 0
	// Position of GPDATA field.
	PMU_GPREG_GPDATA_Pos = 0x0
	// Bit mask of GPDATA field.
	PMU_GPREG_GPDATA_Msk = 0xffffffff

	// DPDCTRL: Deep power-down control register
	// Position of WAKEUPHYS field.
	PMU_DPDCTRL_WAKEUPHYS_Pos = 0x0
	// Bit mask of WAKEUPHYS field.
	PMU_DPDCTRL_WAKEUPHYS_Msk = 0x1
	// Bit WAKEUPHYS.
	PMU_DPDCTRL_WAKEUPHYS = 0x1
	// Disabled. Hysteresis for WAKUP pin disabled.
	PMU_DPDCTRL_WAKEUPHYS_DISABLED_HYSTERESIS = 0x0
	// Enabled. Hysteresis for WAKEUP pin enabled.
	PMU_DPDCTRL_WAKEUPHYS_ENABLED_HYSTERESIS_ = 0x1
	// Position of WAKEPAD_DISABLE field.
	PMU_DPDCTRL_WAKEPAD_DISABLE_Pos = 0x1
	// Bit mask of WAKEPAD_DISABLE field.
	PMU_DPDCTRL_WAKEPAD_DISABLE_Msk = 0x2
	// Bit WAKEPAD_DISABLE.
	PMU_DPDCTRL_WAKEPAD_DISABLE = 0x2
	// Enabled. The wake-up function is enabled on pin PIO0_4.
	PMU_DPDCTRL_WAKEPAD_DISABLE_ENABLED_THE_WAKE_UP = 0x0
	// Disabled. Setting this bit disables the wake-up function on pin PIO0_4.
	PMU_DPDCTRL_WAKEPAD_DISABLE_DISABLED_SETTING_TH = 0x1
	// Position of LPOSCEN field.
	PMU_DPDCTRL_LPOSCEN_Pos = 0x2
	// Bit mask of LPOSCEN field.
	PMU_DPDCTRL_LPOSCEN_Msk = 0x4
	// Bit LPOSCEN.
	PMU_DPDCTRL_LPOSCEN = 0x4
	// Disabled.
	PMU_DPDCTRL_LPOSCEN_DISABLED_ = 0x0
	// Enabled.
	PMU_DPDCTRL_LPOSCEN_ENABLED_ = 0x1
	// Position of LPOSCDPDEN field.
	PMU_DPDCTRL_LPOSCDPDEN_Pos = 0x3
	// Bit mask of LPOSCDPDEN field.
	PMU_DPDCTRL_LPOSCDPDEN_Msk = 0x8
	// Bit LPOSCDPDEN.
	PMU_DPDCTRL_LPOSCDPDEN = 0x8
	// Disabled.
	PMU_DPDCTRL_LPOSCDPDEN_DISABLED_ = 0x0
	// Enabled.
	PMU_DPDCTRL_LPOSCDPDEN_ENABLED_ = 0x1
	// Position of RESERVED field.
	PMU_DPDCTRL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	PMU_DPDCTRL_RESERVED_Msk = 0xfffffff0
)

// Constants for CMP: Analog comparator
const (
	// CTRL: Comparator control register
	// Position of RESERVED field.
	CMP_CTRL_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	CMP_CTRL_RESERVED_Msk = 0x7
	// Position of EDGESEL field.
	CMP_CTRL_EDGESEL_Pos = 0x3
	// Bit mask of EDGESEL field.
	CMP_CTRL_EDGESEL_Msk = 0x18
	// Falling edges
	CMP_CTRL_EDGESEL_FALLING_EDGES = 0x0
	// Rising edges
	CMP_CTRL_EDGESEL_RISING_EDGES = 0x1
	// Position of RESERVED field.
	CMP_CTRL_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	CMP_CTRL_RESERVED_Msk = 0x20
	// Bit RESERVED.
	CMP_CTRL_RESERVED = 0x20
	// Position of COMPSA field.
	CMP_CTRL_COMPSA_Pos = 0x6
	// Bit mask of COMPSA field.
	CMP_CTRL_COMPSA_Msk = 0x40
	// Bit COMPSA.
	CMP_CTRL_COMPSA = 0x40
	// Comparator output is used directly.
	CMP_CTRL_COMPSA_DIRECT = 0x0
	// Comparator output is synchronized to the bus clock for output to other modules.
	CMP_CTRL_COMPSA_SYNCH = 0x1
	// Position of RESERVED field.
	CMP_CTRL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	CMP_CTRL_RESERVED_Msk = 0x80
	// Bit RESERVED.
	CMP_CTRL_RESERVED = 0x80
	// Position of COMP_VP_SEL field.
	CMP_CTRL_COMP_VP_SEL_Pos = 0x8
	// Bit mask of COMP_VP_SEL field.
	CMP_CTRL_COMP_VP_SEL_Msk = 0x700
	// Voltage ladder output
	CMP_CTRL_COMP_VP_SEL_VOLTAGE_LADDER_OUTPU = 0x0
	// ACMP_I1
	CMP_CTRL_COMP_VP_SEL_ACMP_I1 = 0x1
	// ACMP_I2
	CMP_CTRL_COMP_VP_SEL_ACMP_I2 = 0x2
	// Internal reference voltage
	CMP_CTRL_COMP_VP_SEL_INTERNAL_REFERENCE_V = 0x6
	// Position of COMP_VM_SEL field.
	CMP_CTRL_COMP_VM_SEL_Pos = 0xb
	// Bit mask of COMP_VM_SEL field.
	CMP_CTRL_COMP_VM_SEL_Msk = 0x3800
	// voltage ladder output
	CMP_CTRL_COMP_VM_SEL_VOLTAGE_LADDER_OUTPU = 0x0
	// ACMP_I1
	CMP_CTRL_COMP_VM_SEL_ACMP_I1 = 0x1
	// ACMP_I2
	CMP_CTRL_COMP_VM_SEL_ACMP_I2 = 0x2
	// Internal reference voltage
	CMP_CTRL_COMP_VM_SEL_INTERNAL_REFERENCE_V = 0x6
	// Position of RESERVED field.
	CMP_CTRL_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	CMP_CTRL_RESERVED_Msk = 0xfc000
	// Position of EDGECLR field.
	CMP_CTRL_EDGECLR_Pos = 0x14
	// Bit mask of EDGECLR field.
	CMP_CTRL_EDGECLR_Msk = 0x100000
	// Bit EDGECLR.
	CMP_CTRL_EDGECLR = 0x100000
	// Position of COMPSTAT field.
	CMP_CTRL_COMPSTAT_Pos = 0x15
	// Bit mask of COMPSTAT field.
	CMP_CTRL_COMPSTAT_Msk = 0x200000
	// Bit COMPSTAT.
	CMP_CTRL_COMPSTAT = 0x200000
	// Position of RESERVED field.
	CMP_CTRL_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	CMP_CTRL_RESERVED_Msk = 0x400000
	// Bit RESERVED.
	CMP_CTRL_RESERVED = 0x400000
	// Position of COMPEDGE field.
	CMP_CTRL_COMPEDGE_Pos = 0x17
	// Bit mask of COMPEDGE field.
	CMP_CTRL_COMPEDGE_Msk = 0x800000
	// Bit COMPEDGE.
	CMP_CTRL_COMPEDGE = 0x800000
	// Position of RESERVED field.
	CMP_CTRL_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	CMP_CTRL_RESERVED_Msk = 0x1000000
	// Bit RESERVED.
	CMP_CTRL_RESERVED = 0x1000000
	// Position of HYS field.
	CMP_CTRL_HYS_Pos = 0x19
	// Bit mask of HYS field.
	CMP_CTRL_HYS_Msk = 0x6000000
	// None (the output will switch as the voltages cross)
	CMP_CTRL_HYS_NONE_THE_OUTPUT_WIL = 0x0
	// 5 mV
	CMP_CTRL_HYS_5_MV = 0x1
	// 10 mV
	CMP_CTRL_HYS_10_MV = 0x2
	// 20 mV
	CMP_CTRL_HYS_20_MV = 0x3
	// Position of RESERVED field.
	CMP_CTRL_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	CMP_CTRL_RESERVED_Msk = 0xf8000000

	// LAD: Voltage ladder register
	// Position of LADEN field.
	CMP_LAD_LADEN_Pos = 0x0
	// Bit mask of LADEN field.
	CMP_LAD_LADEN_Msk = 0x1
	// Bit LADEN.
	CMP_LAD_LADEN = 0x1
	// Position of LADSEL field.
	CMP_LAD_LADSEL_Pos = 0x1
	// Bit mask of LADSEL field.
	CMP_LAD_LADSEL_Msk = 0x3e
	// Position of LADREF field.
	CMP_LAD_LADREF_Pos = 0x6
	// Bit mask of LADREF field.
	CMP_LAD_LADREF_Msk = 0x40
	// Bit LADREF.
	CMP_LAD_LADREF = 0x40
	// Supply pin VDD
	CMP_LAD_LADREF_SUPPLY_PIN_VDD = 0x0
	// VDDCMP pin
	CMP_LAD_LADREF_VDDCMP_PIN = 0x1
	// Position of RESERVED field.
	CMP_LAD_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	CMP_LAD_RESERVED_Msk = 0xffffff80
)

// Constants for FLASHCTRL: Flash controller
const (
	// FLASHCFG: Flash configuration register
	// Position of FLASHTIM field.
	FLASHCTRL_FLASHCFG_FLASHTIM_Pos = 0x0
	// Bit mask of FLASHTIM field.
	FLASHCTRL_FLASHCFG_FLASHTIM_Msk = 0x3
	// 1 system clock flash access time (for system clock frequencies of up to 20 MHz).
	FLASHCTRL_FLASHCFG_FLASHTIM_1_SYSTEM_CLOCK_FLASH = 0x0
	// 2 system clocks flash access time (for system clock frequencies of up to 30 MHz).
	FLASHCTRL_FLASHCFG_FLASHTIM_2_SYSTEM_CLOCKS_FLAS = 0x1
	// Position of RESERVED field.
	FLASHCTRL_FLASHCFG_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	FLASHCTRL_FLASHCFG_RESERVED_Msk = 0xfffffffc

	// FMSSTART: Signature start address register
	// Position of START field.
	FLASHCTRL_FMSSTART_START_Pos = 0x0
	// Bit mask of START field.
	FLASHCTRL_FMSSTART_START_Msk = 0x1ffff
	// Position of RESERVED field.
	FLASHCTRL_FMSSTART_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSSTART_RESERVED_Msk = 0xfffe0000

	// FMSSTOP: Signature stop-address register
	// Position of STOPA field.
	FLASHCTRL_FMSSTOP_STOPA_Pos = 0x0
	// Bit mask of STOPA field.
	FLASHCTRL_FMSSTOP_STOPA_Msk = 0x1ffff
	// Position of RESERVED field.
	FLASHCTRL_FMSSTOP_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSSTOP_RESERVED_Msk = 0x7ffe0000
	// Position of STRTBIST field.
	FLASHCTRL_FMSSTOP_STRTBIST_Pos = 0x1f
	// Bit mask of STRTBIST field.
	FLASHCTRL_FMSSTOP_STRTBIST_Msk = 0x80000000
	// Bit STRTBIST.
	FLASHCTRL_FMSSTOP_STRTBIST = 0x80000000

	// FMSW0: Signature Word
	// Position of SIG field.
	FLASHCTRL_FMSW0_SIG_Pos = 0x0
	// Bit mask of SIG field.
	FLASHCTRL_FMSW0_SIG_Msk = 0xffffffff
)

// Constants for IOCON: I/O configuration (IOCON)
const (
	// PIO0_17: I/O configuration for pin PIO0_17
	// Position of RESERVED field.
	IOCON_PIO0_17_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_17_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_17_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_17_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_17_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_17_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_17_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_17_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_17_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_17_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_17_HYS = 0x20
	// Disable.
	IOCON_PIO0_17_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_17_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_17_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_17_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_17_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_17_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_17_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_17_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_17_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_17_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_17_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_17_OD = 0x400
	// Disable.
	IOCON_PIO0_17_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_17_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_17_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_17_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_17_S_MODE_BYPASS_INPUT_FILTER_ = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_17_S_MODE_1_CLOCK_CYCLE_INPUT = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_17_S_MODE_2_CLOCK_CYCLES_INPU = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_17_S_MODE_3_CLOCK_CYCLES_INPU = 0x3
	// Position of CLK_DIV field.
	IOCON_PIO0_17_CLK_DIV_Pos = 0xd
	// Bit mask of CLK_DIV field.
	IOCON_PIO0_17_CLK_DIV_Msk = 0xe000
	// IOCONFILTRCLKDIV0.
	IOCON_PIO0_17_CLK_DIV_IOCONFILTRCLKDIV0_ = 0x0
	// IOCONFILTRCLKDIV1.
	IOCON_PIO0_17_CLK_DIV_IOCONFILTRCLKDIV1_ = 0x1
	// IOCONFILTRCLKDIV2.
	IOCON_PIO0_17_CLK_DIV_IOCONFILTRCLKDIV2_ = 0x2
	// IOCONFILTRCLKDIV3.
	IOCON_PIO0_17_CLK_DIV_IOCONFILTRCLKDIV3_ = 0x3
	// IOCONFILTRCLKDIV4.
	IOCON_PIO0_17_CLK_DIV_IOCONFILTRCLKDIV4_ = 0x4
	// IOCONFILTRCLKDIV5.
	IOCON_PIO0_17_CLK_DIV_IOCONFILTRCLKDIV5_ = 0x5
	// IOCONFILTRCLKDIV6.
	IOCON_PIO0_17_CLK_DIV_IOCONFILTRCLKDIV6_ = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_17_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_17_RESERVED_Msk = 0xffff0000

	// PIO0_13: I/O configuration for pin PIO0_13
	// Position of RESERVED field.
	IOCON_PIO0_13_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_13_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_13_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_13_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_13_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_13_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_13_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_13_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_13_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_13_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_13_HYS = 0x20
	// Disable.
	IOCON_PIO0_13_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_13_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_13_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_13_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_13_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_13_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_13_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_13_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_13_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_13_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_13_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_13_OD = 0x400
	// Disable.
	IOCON_PIO0_13_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_13_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_13_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_13_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_13_S_MODE_BYPASS_INPUT_FILTER_ = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_13_S_MODE_1_CLOCK_CYCLE_INPUT = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_13_S_MODE_2_CLOCK_CYCLES_INPU = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_13_S_MODE_3_CLOCK_CYCLES_INPU = 0x3
	// Position of CLK_DIV field.
	IOCON_PIO0_13_CLK_DIV_Pos = 0xd
	// Bit mask of CLK_DIV field.
	IOCON_PIO0_13_CLK_DIV_Msk = 0xe000
	// IOCONFILTRCLKDIV0.
	IOCON_PIO0_13_CLK_DIV_IOCONFILTRCLKDIV0_ = 0x0
	// IOCONFILTRCLKDIV1.
	IOCON_PIO0_13_CLK_DIV_IOCONFILTRCLKDIV1_ = 0x1
	// IOCONFILTRCLKDIV2.
	IOCON_PIO0_13_CLK_DIV_IOCONFILTRCLKDIV2_ = 0x2
	// IOCONFILTRCLKDIV3.
	IOCON_PIO0_13_CLK_DIV_IOCONFILTRCLKDIV3_ = 0x3
	// IOCONFILTRCLKDIV4.
	IOCON_PIO0_13_CLK_DIV_IOCONFILTRCLKDIV4_ = 0x4
	// IOCONFILTRCLKDIV5.
	IOCON_PIO0_13_CLK_DIV_IOCONFILTRCLKDIV5_ = 0x5
	// IOCONFILTRCLKDIV6.
	IOCON_PIO0_13_CLK_DIV_IOCONFILTRCLKDIV6_ = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_13_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_13_RESERVED_Msk = 0xffff0000

	// PIO0_12: I/O configuration for pin PIO0_12
	// Position of RESERVED field.
	IOCON_PIO0_12_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_12_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_12_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_12_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_12_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_12_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_12_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_12_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_12_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_12_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_12_HYS = 0x20
	// Disable.
	IOCON_PIO0_12_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_12_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_12_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_12_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_12_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_12_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_12_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_12_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_12_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_12_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_12_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_12_OD = 0x400
	// Disable.
	IOCON_PIO0_12_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_12_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_12_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_12_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_12_S_MODE_BYPASS_INPUT_FILTER_ = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_12_S_MODE_1_CLOCK_CYCLE_INPUT = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_12_S_MODE_2_CLOCK_CYCLES_INPU = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_12_S_MODE_3_CLOCK_CYCLES_INPU = 0x3
	// Position of CLK_DIV field.
	IOCON_PIO0_12_CLK_DIV_Pos = 0xd
	// Bit mask of CLK_DIV field.
	IOCON_PIO0_12_CLK_DIV_Msk = 0xe000
	// IOCONFILTRCLKDIV0.
	IOCON_PIO0_12_CLK_DIV_IOCONFILTRCLKDIV0_ = 0x0
	// IOCONFILTRCLKDIV1.
	IOCON_PIO0_12_CLK_DIV_IOCONFILTRCLKDIV1_ = 0x1
	// IOCONFILTRCLKDIV2.
	IOCON_PIO0_12_CLK_DIV_IOCONFILTRCLKDIV2_ = 0x2
	// IOCONFILTRCLKDIV3.
	IOCON_PIO0_12_CLK_DIV_IOCONFILTRCLKDIV3_ = 0x3
	// IOCONFILTRCLKDIV4.
	IOCON_PIO0_12_CLK_DIV_IOCONFILTRCLKDIV4_ = 0x4
	// IOCONFILTRCLKDIV5.
	IOCON_PIO0_12_CLK_DIV_IOCONFILTRCLKDIV5_ = 0x5
	// IOCONFILTRCLKDIV6.
	IOCON_PIO0_12_CLK_DIV_IOCONFILTRCLKDIV6_ = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_12_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_12_RESERVED_Msk = 0xffff0000

	// PIO0_5: I/O configuration for pin PIO0_5/RESET
	// Position of RESERVED field.
	IOCON_PIO0_5_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_5_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_5_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_5_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_5_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_5_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_5_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_5_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_5_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_5_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_5_HYS = 0x20
	// Disable.
	IOCON_PIO0_5_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_5_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_5_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_5_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_5_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_5_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_5_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_5_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_5_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_5_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_5_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_5_OD = 0x400
	// Disable.
	IOCON_PIO0_5_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_5_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_5_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_5_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_5_S_MODE_BYPASS_INPUT_FILTER_ = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_5_S_MODE_1_CLOCK_CYCLE_INPUT = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_5_S_MODE_2_CLOCK_CYCLES_INPU = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_5_S_MODE_3_CLOCK_CYCLES_INPU = 0x3
	// Position of CLK_DIV field.
	IOCON_PIO0_5_CLK_DIV_Pos = 0xd
	// Bit mask of CLK_DIV field.
	IOCON_PIO0_5_CLK_DIV_Msk = 0xe000
	// IOCONFILTRCLKDIV0.
	IOCON_PIO0_5_CLK_DIV_IOCONFILTRCLKDIV0_ = 0x0
	// IOCONFILTRCLKDIV1.
	IOCON_PIO0_5_CLK_DIV_IOCONFILTRCLKDIV1_ = 0x1
	// IOCONFILTRCLKDIV2.
	IOCON_PIO0_5_CLK_DIV_IOCONFILTRCLKDIV2_ = 0x2
	// IOCONFILTRCLKDIV3.
	IOCON_PIO0_5_CLK_DIV_IOCONFILTRCLKDIV3_ = 0x3
	// IOCONFILTRCLKDIV4.
	IOCON_PIO0_5_CLK_DIV_IOCONFILTRCLKDIV4_ = 0x4
	// IOCONFILTRCLKDIV5.
	IOCON_PIO0_5_CLK_DIV_IOCONFILTRCLKDIV5_ = 0x5
	// IOCONFILTRCLKDIV6.
	IOCON_PIO0_5_CLK_DIV_IOCONFILTRCLKDIV6_ = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_5_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_5_RESERVED_Msk = 0xffff0000

	// PIO0_4: I/O configuration for pin PIO0_4
	// Position of RESERVED field.
	IOCON_PIO0_4_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_4_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_4_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_4_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_4_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_4_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_4_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_4_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_4_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_4_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_4_HYS = 0x20
	// Disable.
	IOCON_PIO0_4_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_4_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_4_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_4_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_4_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_4_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_4_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_4_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_4_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_4_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_4_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_4_OD = 0x400
	// Disable.
	IOCON_PIO0_4_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_4_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_4_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_4_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_4_S_MODE_BYPASS_INPUT_FILTER_ = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_4_S_MODE_1_CLOCK_CYCLE_INPUT = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_4_S_MODE_2_CLOCK_CYCLES_INPU = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_4_S_MODE_3_CLOCK_CYCLES_INPU = 0x3
	// Position of CLK_DIV field.
	IOCON_PIO0_4_CLK_DIV_Pos = 0xd
	// Bit mask of CLK_DIV field.
	IOCON_PIO0_4_CLK_DIV_Msk = 0xe000
	// IOCONFILTRCLKDIV0.
	IOCON_PIO0_4_CLK_DIV_IOCONFILTRCLKDIV0_ = 0x0
	// IOCONFILTRCLKDIV1.
	IOCON_PIO0_4_CLK_DIV_IOCONFILTRCLKDIV1_ = 0x1
	// IOCONFILTRCLKDIV2.
	IOCON_PIO0_4_CLK_DIV_IOCONFILTRCLKDIV2_ = 0x2
	// IOCONFILTRCLKDIV3.
	IOCON_PIO0_4_CLK_DIV_IOCONFILTRCLKDIV3_ = 0x3
	// IOCONFILTRCLKDIV4.
	IOCON_PIO0_4_CLK_DIV_IOCONFILTRCLKDIV4_ = 0x4
	// IOCONFILTRCLKDIV5.
	IOCON_PIO0_4_CLK_DIV_IOCONFILTRCLKDIV5_ = 0x5
	// IOCONFILTRCLKDIV6.
	IOCON_PIO0_4_CLK_DIV_IOCONFILTRCLKDIV6_ = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_4_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_4_RESERVED_Msk = 0xffff0000

	// PIO0_3: I/O configuration for pin PIO0_3/SWCLK
	// Position of RESERVED field.
	IOCON_PIO0_3_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_3_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_3_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_3_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_3_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_3_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_3_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_3_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_3_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_3_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_3_HYS = 0x20
	// Disable.
	IOCON_PIO0_3_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_3_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_3_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_3_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_3_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_3_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_3_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_3_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_3_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_3_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_3_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_3_OD = 0x400
	// Disable.
	IOCON_PIO0_3_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_3_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_3_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_3_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_3_S_MODE_BYPASS_INPUT_FILTER_ = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_3_S_MODE_1_CLOCK_CYCLE_INPUT = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_3_S_MODE_2_CLOCK_CYCLES_INPU = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_3_S_MODE_3_CLOCK_CYCLES_INPU = 0x3
	// Position of CLK_DIV field.
	IOCON_PIO0_3_CLK_DIV_Pos = 0xd
	// Bit mask of CLK_DIV field.
	IOCON_PIO0_3_CLK_DIV_Msk = 0xe000
	// IOCONFILTRCLKDIV0.
	IOCON_PIO0_3_CLK_DIV_IOCONFILTRCLKDIV0_ = 0x0
	// IOCONFILTRCLKDIV1.
	IOCON_PIO0_3_CLK_DIV_IOCONFILTRCLKDIV1_ = 0x1
	// IOCONFILTRCLKDIV2.
	IOCON_PIO0_3_CLK_DIV_IOCONFILTRCLKDIV2_ = 0x2
	// IOCONFILTRCLKDIV3.
	IOCON_PIO0_3_CLK_DIV_IOCONFILTRCLKDIV3_ = 0x3
	// IOCONFILTRCLKDIV4.
	IOCON_PIO0_3_CLK_DIV_IOCONFILTRCLKDIV4_ = 0x4
	// IOCONFILTRCLKDIV5.
	IOCON_PIO0_3_CLK_DIV_IOCONFILTRCLKDIV5_ = 0x5
	// IOCONFILTRCLKDIV6.
	IOCON_PIO0_3_CLK_DIV_IOCONFILTRCLKDIV6_ = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_3_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_3_RESERVED_Msk = 0xffff0000

	// PIO0_2: I/O configuration for pin PIO0_2/SWDIO
	// Position of RESERVED field.
	IOCON_PIO0_2_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_2_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_2_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_2_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_2_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_2_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_2_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_2_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_2_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_2_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_2_HYS = 0x20
	// Disable.
	IOCON_PIO0_2_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_2_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_2_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_2_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_2_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_2_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_2_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_2_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_2_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_2_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_2_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_2_OD = 0x400
	// Disable.
	IOCON_PIO0_2_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_2_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_2_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_2_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_2_S_MODE_BYPASS_INPUT_FILTER_ = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_2_S_MODE_1_CLOCK_CYCLE_INPUT = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_2_S_MODE_2_CLOCK_CYCLES_INPU = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_2_S_MODE_3_CLOCK_CYCLES_INPU = 0x3
	// Position of CLK_DIV field.
	IOCON_PIO0_2_CLK_DIV_Pos = 0xd
	// Bit mask of CLK_DIV field.
	IOCON_PIO0_2_CLK_DIV_Msk = 0xe000
	// IOCONFILTRCLKDIV0.
	IOCON_PIO0_2_CLK_DIV_IOCONFILTRCLKDIV0_ = 0x0
	// IOCONFILTRCLKDIV1.
	IOCON_PIO0_2_CLK_DIV_IOCONFILTRCLKDIV1_ = 0x1
	// IOCONFILTRCLKDIV2.
	IOCON_PIO0_2_CLK_DIV_IOCONFILTRCLKDIV2_ = 0x2
	// IOCONFILTRCLKDIV3.
	IOCON_PIO0_2_CLK_DIV_IOCONFILTRCLKDIV3_ = 0x3
	// IOCONFILTRCLKDIV4.
	IOCON_PIO0_2_CLK_DIV_IOCONFILTRCLKDIV4_ = 0x4
	// IOCONFILTRCLKDIV5.
	IOCON_PIO0_2_CLK_DIV_IOCONFILTRCLKDIV5_ = 0x5
	// IOCONFILTRCLKDIV6.
	IOCON_PIO0_2_CLK_DIV_IOCONFILTRCLKDIV6_ = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_2_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_2_RESERVED_Msk = 0xffff0000

	// PIO0_11: I/O configuration for pin PIO0_11. This is the pin configuration for the true open-drain pin.
	// Position of RESERVED field.
	IOCON_PIO0_11_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_11_RESERVED_Msk = 0x3f
	// Position of INV field.
	IOCON_PIO0_11_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_11_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_11_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_11_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_11_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_11_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_11_RESERVED_Msk = 0x80
	// Bit RESERVED.
	IOCON_PIO0_11_RESERVED = 0x80
	// Position of I2CMODE field.
	IOCON_PIO0_11_I2CMODE_Pos = 0x8
	// Bit mask of I2CMODE field.
	IOCON_PIO0_11_I2CMODE_Msk = 0x300
	// Standard mode/ Fast-mode I2C.
	IOCON_PIO0_11_I2CMODE_STANDARD_MODE = 0x0
	// Standard I/O functionality
	IOCON_PIO0_11_I2CMODE_STANDARD_IO = 0x1
	// Fast-mode Plus I2C
	IOCON_PIO0_11_I2CMODE_FAST_MODE_PLUS_I2C = 0x2
	// Reserved.
	IOCON_PIO0_11_I2CMODE_RESERVED_ = 0x3
	// Position of RESERVED field.
	IOCON_PIO0_11_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	IOCON_PIO0_11_RESERVED_Msk = 0x400
	// Bit RESERVED.
	IOCON_PIO0_11_RESERVED = 0x400
	// Position of S_MODE field.
	IOCON_PIO0_11_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_11_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_11_S_MODE_BYPASS_INPUT_FILTER_ = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_11_S_MODE_1_CLOCK_CYCLE_INPUT = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_11_S_MODE_2_CLOCK_CYCLES_INPU = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_11_S_MODE_3_CLOCK_CYCLES_INPU = 0x3
	// Position of CLK_DIV field.
	IOCON_PIO0_11_CLK_DIV_Pos = 0xd
	// Bit mask of CLK_DIV field.
	IOCON_PIO0_11_CLK_DIV_Msk = 0xe000
	// IOCONFILTRCLKDIV0.
	IOCON_PIO0_11_CLK_DIV_IOCONFILTRCLKDIV0_ = 0x0
	// IOCONFILTRCLKDIV1.
	IOCON_PIO0_11_CLK_DIV_IOCONFILTRCLKDIV1_ = 0x1
	// IOCONFILTRCLKDIV2.
	IOCON_PIO0_11_CLK_DIV_IOCONFILTRCLKDIV2_ = 0x2
	// IOCONFILTRCLKDIV3.
	IOCON_PIO0_11_CLK_DIV_IOCONFILTRCLKDIV3_ = 0x3
	// IOCONFILTRCLKDIV4.
	IOCON_PIO0_11_CLK_DIV_IOCONFILTRCLKDIV4_ = 0x4
	// IOCONFILTRCLKDIV5.
	IOCON_PIO0_11_CLK_DIV_IOCONFILTRCLKDIV5_ = 0x5
	// IOCONFILTRCLKDIV6.
	IOCON_PIO0_11_CLK_DIV_IOCONFILTRCLKDIV6_ = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_11_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_11_RESERVED_Msk = 0xffff0000

	// PIO0_10: I/O configuration for pin PIO0_10. This is the pin configuration for the true open-drain pin.
	// Position of RESERVED field.
	IOCON_PIO0_10_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_10_RESERVED_Msk = 0x3f
	// Position of INV field.
	IOCON_PIO0_10_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_10_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_10_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_10_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_10_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_10_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_10_RESERVED_Msk = 0x80
	// Bit RESERVED.
	IOCON_PIO0_10_RESERVED = 0x80
	// Position of I2CMODE field.
	IOCON_PIO0_10_I2CMODE_Pos = 0x8
	// Bit mask of I2CMODE field.
	IOCON_PIO0_10_I2CMODE_Msk = 0x300
	// Standard mode/ Fast-mode I2C.
	IOCON_PIO0_10_I2CMODE_STANDARD_MODE = 0x0
	// Standard I/O functionality
	IOCON_PIO0_10_I2CMODE_STANDARD_IO = 0x1
	// Fast-mode Plus I2C
	IOCON_PIO0_10_I2CMODE_FAST_MODE_PLUS_I2C = 0x2
	// Reserved.
	IOCON_PIO0_10_I2CMODE_RESERVED_ = 0x3
	// Position of RESERVED field.
	IOCON_PIO0_10_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	IOCON_PIO0_10_RESERVED_Msk = 0x400
	// Bit RESERVED.
	IOCON_PIO0_10_RESERVED = 0x400
	// Position of S_MODE field.
	IOCON_PIO0_10_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_10_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_10_S_MODE_BYPASS_INPUT_FILTER_ = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_10_S_MODE_1_CLOCK_CYCLE_INPUT = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_10_S_MODE_2_CLOCK_CYCLES_INPU = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_10_S_MODE_3_CLOCK_CYCLES_INPU = 0x3
	// Position of CLK_DIV field.
	IOCON_PIO0_10_CLK_DIV_Pos = 0xd
	// Bit mask of CLK_DIV field.
	IOCON_PIO0_10_CLK_DIV_Msk = 0xe000
	// IOCONFILTRCLKDIV0.
	IOCON_PIO0_10_CLK_DIV_IOCONFILTRCLKDIV0_ = 0x0
	// IOCONFILTRCLKDIV1.
	IOCON_PIO0_10_CLK_DIV_IOCONFILTRCLKDIV1_ = 0x1
	// IOCONFILTRCLKDIV2.
	IOCON_PIO0_10_CLK_DIV_IOCONFILTRCLKDIV2_ = 0x2
	// IOCONFILTRCLKDIV3.
	IOCON_PIO0_10_CLK_DIV_IOCONFILTRCLKDIV3_ = 0x3
	// IOCONFILTRCLKDIV4.
	IOCON_PIO0_10_CLK_DIV_IOCONFILTRCLKDIV4_ = 0x4
	// IOCONFILTRCLKDIV5.
	IOCON_PIO0_10_CLK_DIV_IOCONFILTRCLKDIV5_ = 0x5
	// IOCONFILTRCLKDIV6.
	IOCON_PIO0_10_CLK_DIV_IOCONFILTRCLKDIV6_ = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_10_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_10_RESERVED_Msk = 0xffff0000

	// PIO0_16: I/O configuration for pin PIO0_16
	// Position of RESERVED field.
	IOCON_PIO0_16_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_16_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_16_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_16_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_16_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_16_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_16_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_16_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_16_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_16_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_16_HYS = 0x20
	// Disable.
	IOCON_PIO0_16_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_16_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_16_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_16_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_16_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_16_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_16_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_16_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_16_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_16_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_16_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_16_OD = 0x400
	// Disable.
	IOCON_PIO0_16_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_16_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_16_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_16_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_16_S_MODE_BYPASS_INPUT_FILTER_ = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_16_S_MODE_1_CLOCK_CYCLE_INPUT = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_16_S_MODE_2_CLOCK_CYCLES_INPU = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_16_S_MODE_3_CLOCK_CYCLES_INPU = 0x3
	// Position of CLK_DIV field.
	IOCON_PIO0_16_CLK_DIV_Pos = 0xd
	// Bit mask of CLK_DIV field.
	IOCON_PIO0_16_CLK_DIV_Msk = 0xe000
	// IOCONFILTRCLKDIV0.
	IOCON_PIO0_16_CLK_DIV_IOCONFILTRCLKDIV0_ = 0x0
	// IOCONFILTRCLKDIV1.
	IOCON_PIO0_16_CLK_DIV_IOCONFILTRCLKDIV1_ = 0x1
	// IOCONFILTRCLKDIV2.
	IOCON_PIO0_16_CLK_DIV_IOCONFILTRCLKDIV2_ = 0x2
	// IOCONFILTRCLKDIV3.
	IOCON_PIO0_16_CLK_DIV_IOCONFILTRCLKDIV3_ = 0x3
	// IOCONFILTRCLKDIV4.
	IOCON_PIO0_16_CLK_DIV_IOCONFILTRCLKDIV4_ = 0x4
	// IOCONFILTRCLKDIV5.
	IOCON_PIO0_16_CLK_DIV_IOCONFILTRCLKDIV5_ = 0x5
	// IOCONFILTRCLKDIV6.
	IOCON_PIO0_16_CLK_DIV_IOCONFILTRCLKDIV6_ = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_16_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_16_RESERVED_Msk = 0xffff0000

	// PIO0_15: I/O configuration for pin PIO0_15
	// Position of RESERVED field.
	IOCON_PIO0_15_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_15_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_15_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_15_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_15_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_15_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_15_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_15_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_15_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_15_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_15_HYS = 0x20
	// Disable.
	IOCON_PIO0_15_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_15_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_15_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_15_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_15_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_15_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_15_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_15_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_15_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_15_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_15_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_15_OD = 0x400
	// Disable.
	IOCON_PIO0_15_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_15_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_15_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_15_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_15_S_MODE_BYPASS_INPUT_FILTER_ = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_15_S_MODE_1_CLOCK_CYCLE_INPUT = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_15_S_MODE_2_CLOCK_CYCLES_INPU = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_15_S_MODE_3_CLOCK_CYCLES_INPU = 0x3
	// Position of CLK_DIV field.
	IOCON_PIO0_15_CLK_DIV_Pos = 0xd
	// Bit mask of CLK_DIV field.
	IOCON_PIO0_15_CLK_DIV_Msk = 0xe000
	// IOCONFILTRCLKDIV0.
	IOCON_PIO0_15_CLK_DIV_IOCONFILTRCLKDIV0_ = 0x0
	// IOCONFILTRCLKDIV1.
	IOCON_PIO0_15_CLK_DIV_IOCONFILTRCLKDIV1_ = 0x1
	// IOCONFILTRCLKDIV2.
	IOCON_PIO0_15_CLK_DIV_IOCONFILTRCLKDIV2_ = 0x2
	// IOCONFILTRCLKDIV3.
	IOCON_PIO0_15_CLK_DIV_IOCONFILTRCLKDIV3_ = 0x3
	// IOCONFILTRCLKDIV4.
	IOCON_PIO0_15_CLK_DIV_IOCONFILTRCLKDIV4_ = 0x4
	// IOCONFILTRCLKDIV5.
	IOCON_PIO0_15_CLK_DIV_IOCONFILTRCLKDIV5_ = 0x5
	// IOCONFILTRCLKDIV6.
	IOCON_PIO0_15_CLK_DIV_IOCONFILTRCLKDIV6_ = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_15_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_15_RESERVED_Msk = 0xffff0000

	// PIO0_1: I/O configuration for pin PIO0_1/ACMP_I1/CLKIN
	// Position of RESERVED field.
	IOCON_PIO0_1_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_1_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_1_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_1_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_1_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_1_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_1_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_1_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_1_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_1_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_1_HYS = 0x20
	// Disable.
	IOCON_PIO0_1_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_1_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_1_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_1_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_1_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_1_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_1_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_1_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_1_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_1_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_1_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_1_OD = 0x400
	// Disable.
	IOCON_PIO0_1_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_1_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_1_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_1_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_1_S_MODE_BYPASS_INPUT_FILTER_ = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_1_S_MODE_1_CLOCK_CYCLE_INPUT = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_1_S_MODE_2_CLOCK_CYCLES_INPU = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_1_S_MODE_3_CLOCK_CYCLES_INPU = 0x3
	// Position of CLK_DIV field.
	IOCON_PIO0_1_CLK_DIV_Pos = 0xd
	// Bit mask of CLK_DIV field.
	IOCON_PIO0_1_CLK_DIV_Msk = 0xe000
	// IOCONFILTRCLKDIV0.
	IOCON_PIO0_1_CLK_DIV_IOCONFILTRCLKDIV0_ = 0x0
	// IOCONFILTRCLKDIV1.
	IOCON_PIO0_1_CLK_DIV_IOCONFILTRCLKDIV1_ = 0x1
	// IOCONFILTRCLKDIV2.
	IOCON_PIO0_1_CLK_DIV_IOCONFILTRCLKDIV2_ = 0x2
	// IOCONFILTRCLKDIV3.
	IOCON_PIO0_1_CLK_DIV_IOCONFILTRCLKDIV3_ = 0x3
	// IOCONFILTRCLKDIV4.
	IOCON_PIO0_1_CLK_DIV_IOCONFILTRCLKDIV4_ = 0x4
	// IOCONFILTRCLKDIV5.
	IOCON_PIO0_1_CLK_DIV_IOCONFILTRCLKDIV5_ = 0x5
	// IOCONFILTRCLKDIV6.
	IOCON_PIO0_1_CLK_DIV_IOCONFILTRCLKDIV6_ = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_1_RESERVED_Msk = 0xffff0000

	// PIO0_9: I/O configuration for pin PIO0_9/XTALOUT
	// Position of RESERVED field.
	IOCON_PIO0_9_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_9_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_9_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_9_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_9_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_9_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_9_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_9_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_9_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_9_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_9_HYS = 0x20
	// Disable.
	IOCON_PIO0_9_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_9_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_9_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_9_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_9_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_9_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_9_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_9_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_9_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_9_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_9_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_9_OD = 0x400
	// Disable.
	IOCON_PIO0_9_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_9_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_9_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_9_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_9_S_MODE_BYPASS_INPUT_FILTER_ = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_9_S_MODE_1_CLOCK_CYCLE_INPUT = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_9_S_MODE_2_CLOCK_CYCLES_INPU = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_9_S_MODE_3_CLOCK_CYCLES_INPU = 0x3
	// Position of CLK_DIV field.
	IOCON_PIO0_9_CLK_DIV_Pos = 0xd
	// Bit mask of CLK_DIV field.
	IOCON_PIO0_9_CLK_DIV_Msk = 0xe000
	// IOCONFILTRCLKDIV0.
	IOCON_PIO0_9_CLK_DIV_IOCONFILTRCLKDIV0_ = 0x0
	// IOCONFILTRCLKDIV1.
	IOCON_PIO0_9_CLK_DIV_IOCONFILTRCLKDIV1_ = 0x1
	// IOCONFILTRCLKDIV2.
	IOCON_PIO0_9_CLK_DIV_IOCONFILTRCLKDIV2_ = 0x2
	// IOCONFILTRCLKDIV3.
	IOCON_PIO0_9_CLK_DIV_IOCONFILTRCLKDIV3_ = 0x3
	// IOCONFILTRCLKDIV4.
	IOCON_PIO0_9_CLK_DIV_IOCONFILTRCLKDIV4_ = 0x4
	// IOCONFILTRCLKDIV5.
	IOCON_PIO0_9_CLK_DIV_IOCONFILTRCLKDIV5_ = 0x5
	// IOCONFILTRCLKDIV6.
	IOCON_PIO0_9_CLK_DIV_IOCONFILTRCLKDIV6_ = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_9_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_9_RESERVED_Msk = 0xffff0000

	// PIO0_8: I/O configuration for pin PIO0_8/XTALIN
	// Position of RESERVED field.
	IOCON_PIO0_8_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_8_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_8_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_8_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_8_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_8_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_8_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_8_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_8_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_8_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_8_HYS = 0x20
	// Disable.
	IOCON_PIO0_8_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_8_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_8_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_8_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_8_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_8_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_8_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_8_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_8_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_8_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_8_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_8_OD = 0x400
	// Disable.
	IOCON_PIO0_8_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_8_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_8_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_8_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_8_S_MODE_BYPASS_INPUT_FILTER_ = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_8_S_MODE_1_CLOCK_CYCLE_INPUT = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_8_S_MODE_2_CLOCK_CYCLES_INPU = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_8_S_MODE_3_CLOCK_CYCLES_INPU = 0x3
	// Position of CLK_DIV field.
	IOCON_PIO0_8_CLK_DIV_Pos = 0xd
	// Bit mask of CLK_DIV field.
	IOCON_PIO0_8_CLK_DIV_Msk = 0xe000
	// IOCONFILTRCLKDIV0.
	IOCON_PIO0_8_CLK_DIV_IOCONFILTRCLKDIV0_ = 0x0
	// IOCONFILTRCLKDIV1.
	IOCON_PIO0_8_CLK_DIV_IOCONFILTRCLKDIV1_ = 0x1
	// IOCONFILTRCLKDIV2.
	IOCON_PIO0_8_CLK_DIV_IOCONFILTRCLKDIV2_ = 0x2
	// IOCONFILTRCLKDIV3.
	IOCON_PIO0_8_CLK_DIV_IOCONFILTRCLKDIV3_ = 0x3
	// IOCONFILTRCLKDIV4.
	IOCON_PIO0_8_CLK_DIV_IOCONFILTRCLKDIV4_ = 0x4
	// IOCONFILTRCLKDIV5.
	IOCON_PIO0_8_CLK_DIV_IOCONFILTRCLKDIV5_ = 0x5
	// IOCONFILTRCLKDIV6.
	IOCON_PIO0_8_CLK_DIV_IOCONFILTRCLKDIV6_ = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_8_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_8_RESERVED_Msk = 0xffff0000

	// PIO0_7: I/O configuration for pin PIO0_7
	// Position of RESERVED field.
	IOCON_PIO0_7_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_7_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_7_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_7_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_7_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_7_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_7_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_7_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_7_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_7_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_7_HYS = 0x20
	// Disable.
	IOCON_PIO0_7_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_7_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_7_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_7_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_7_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_7_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_7_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_7_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_7_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_7_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_7_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_7_OD = 0x400
	// Disable.
	IOCON_PIO0_7_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_7_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_7_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_7_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_7_S_MODE_BYPASS_INPUT_FILTER_ = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_7_S_MODE_1_CLOCK_CYCLE_INPUT = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_7_S_MODE_2_CLOCK_CYCLES_INPU = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_7_S_MODE_3_CLOCK_CYCLES_INPU = 0x3
	// Position of CLK_DIV field.
	IOCON_PIO0_7_CLK_DIV_Pos = 0xd
	// Bit mask of CLK_DIV field.
	IOCON_PIO0_7_CLK_DIV_Msk = 0xe000
	// IOCONFILTRCLKDIV0.
	IOCON_PIO0_7_CLK_DIV_IOCONFILTRCLKDIV0_ = 0x0
	// IOCONFILTRCLKDIV1.
	IOCON_PIO0_7_CLK_DIV_IOCONFILTRCLKDIV1_ = 0x1
	// IOCONFILTRCLKDIV2.
	IOCON_PIO0_7_CLK_DIV_IOCONFILTRCLKDIV2_ = 0x2
	// IOCONFILTRCLKDIV3.
	IOCON_PIO0_7_CLK_DIV_IOCONFILTRCLKDIV3_ = 0x3
	// IOCONFILTRCLKDIV4.
	IOCON_PIO0_7_CLK_DIV_IOCONFILTRCLKDIV4_ = 0x4
	// IOCONFILTRCLKDIV5.
	IOCON_PIO0_7_CLK_DIV_IOCONFILTRCLKDIV5_ = 0x5
	// IOCONFILTRCLKDIV6.
	IOCON_PIO0_7_CLK_DIV_IOCONFILTRCLKDIV6_ = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_7_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_7_RESERVED_Msk = 0xffff0000

	// PIO0_6: I/O configuration for pin PIO0_6/VDDCMP
	// Position of RESERVED field.
	IOCON_PIO0_6_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_6_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_6_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_6_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_6_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_6_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_6_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_6_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_6_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_6_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_6_HYS = 0x20
	// Disable.
	IOCON_PIO0_6_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_6_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_6_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_6_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_6_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_6_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_6_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_6_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_6_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_6_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_6_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_6_OD = 0x400
	// Disable.
	IOCON_PIO0_6_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_6_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_6_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_6_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_6_S_MODE_BYPASS_INPUT_FILTER_ = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_6_S_MODE_1_CLOCK_CYCLE_INPUT = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_6_S_MODE_2_CLOCK_CYCLES_INPU = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_6_S_MODE_3_CLOCK_CYCLES_INPU = 0x3
	// Position of CLK_DIV field.
	IOCON_PIO0_6_CLK_DIV_Pos = 0xd
	// Bit mask of CLK_DIV field.
	IOCON_PIO0_6_CLK_DIV_Msk = 0xe000
	// IOCONFILTRCLKDIV0.
	IOCON_PIO0_6_CLK_DIV_IOCONFILTRCLKDIV0_ = 0x0
	// IOCONFILTRCLKDIV1.
	IOCON_PIO0_6_CLK_DIV_IOCONFILTRCLKDIV1_ = 0x1
	// IOCONFILTRCLKDIV2.
	IOCON_PIO0_6_CLK_DIV_IOCONFILTRCLKDIV2_ = 0x2
	// IOCONFILTRCLKDIV3.
	IOCON_PIO0_6_CLK_DIV_IOCONFILTRCLKDIV3_ = 0x3
	// IOCONFILTRCLKDIV4.
	IOCON_PIO0_6_CLK_DIV_IOCONFILTRCLKDIV4_ = 0x4
	// IOCONFILTRCLKDIV5.
	IOCON_PIO0_6_CLK_DIV_IOCONFILTRCLKDIV5_ = 0x5
	// IOCONFILTRCLKDIV6.
	IOCON_PIO0_6_CLK_DIV_IOCONFILTRCLKDIV6_ = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_6_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_6_RESERVED_Msk = 0xffff0000

	// PIO0_0: I/O configuration for pin PIO0_0/ACMP_I0
	// Position of RESERVED field.
	IOCON_PIO0_0_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_0_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_0_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_0_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_0_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_0_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_0_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_0_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_0_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_0_HYS = 0x20
	// Disable.
	IOCON_PIO0_0_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_0_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_0_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_0_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_0_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_0_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_0_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_0_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_0_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_0_OD = 0x400
	// Disable.
	IOCON_PIO0_0_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_0_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_0_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_0_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_0_S_MODE_BYPASS_INPUT_FILTER_ = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_0_S_MODE_1_CLOCK_CYCLE_INPUT = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_0_S_MODE_2_CLOCK_CYCLES_INPU = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_0_S_MODE_3_CLOCK_CYCLES_INPU = 0x3
	// Position of CLK_DIV field.
	IOCON_PIO0_0_CLK_DIV_Pos = 0xd
	// Bit mask of CLK_DIV field.
	IOCON_PIO0_0_CLK_DIV_Msk = 0xe000
	// IOCONFILTRCLKDIV0.
	IOCON_PIO0_0_CLK_DIV_IOCONFILTRCLKDIV0_ = 0x0
	// IOCONFILTRCLKDIV1.
	IOCON_PIO0_0_CLK_DIV_IOCONFILTRCLKDIV1_ = 0x1
	// IOCONFILTRCLKDIV2.
	IOCON_PIO0_0_CLK_DIV_IOCONFILTRCLKDIV2_ = 0x2
	// IOCONFILTRCLKDIV3.
	IOCON_PIO0_0_CLK_DIV_IOCONFILTRCLKDIV3_ = 0x3
	// IOCONFILTRCLKDIV4.
	IOCON_PIO0_0_CLK_DIV_IOCONFILTRCLKDIV4_ = 0x4
	// IOCONFILTRCLKDIV5.
	IOCON_PIO0_0_CLK_DIV_IOCONFILTRCLKDIV5_ = 0x5
	// IOCONFILTRCLKDIV6.
	IOCON_PIO0_0_CLK_DIV_IOCONFILTRCLKDIV6_ = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_0_RESERVED_Msk = 0xffff0000

	// PIO0_14: I/O configuration for pin PIO0_14
	// Position of RESERVED field.
	IOCON_PIO0_14_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	IOCON_PIO0_14_RESERVED_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_14_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_14_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_14_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_PIO0_14_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_PIO0_14_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_PIO0_14_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_PIO0_14_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_PIO0_14_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_PIO0_14_HYS = 0x20
	// Disable.
	IOCON_PIO0_14_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_PIO0_14_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_PIO0_14_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_PIO0_14_INV_Msk = 0x40
	// Bit INV.
	IOCON_PIO0_14_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1; LOW on pin reads as 0).
	IOCON_PIO0_14_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_PIO0_14_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_14_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_PIO0_14_RESERVED_Msk = 0x380
	// Position of OD field.
	IOCON_PIO0_14_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_14_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_14_OD = 0x400
	// Disable.
	IOCON_PIO0_14_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_PIO0_14_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of S_MODE field.
	IOCON_PIO0_14_S_MODE_Pos = 0xb
	// Bit mask of S_MODE field.
	IOCON_PIO0_14_S_MODE_Msk = 0x1800
	// Bypass input filter.
	IOCON_PIO0_14_S_MODE_BYPASS_INPUT_FILTER_ = 0x0
	// 1 clock cycle. Input pulses shorter than one filter clock are rejected.
	IOCON_PIO0_14_S_MODE_1_CLOCK_CYCLE_INPUT = 0x1
	// 2 clock cycles. Input pulses shorter than two filter clocks are rejected.
	IOCON_PIO0_14_S_MODE_2_CLOCK_CYCLES_INPU = 0x2
	// 3 clock cycles. Input pulses shorter than three filter clocks are rejected.
	IOCON_PIO0_14_S_MODE_3_CLOCK_CYCLES_INPU = 0x3
	// Position of CLK_DIV field.
	IOCON_PIO0_14_CLK_DIV_Pos = 0xd
	// Bit mask of CLK_DIV field.
	IOCON_PIO0_14_CLK_DIV_Msk = 0xe000
	// IOCONFILTRCLKDIV0.
	IOCON_PIO0_14_CLK_DIV_IOCONFILTRCLKDIV0_ = 0x0
	// IOCONFILTRCLKDIV1.
	IOCON_PIO0_14_CLK_DIV_IOCONFILTRCLKDIV1_ = 0x1
	// IOCONFILTRCLKDIV2.
	IOCON_PIO0_14_CLK_DIV_IOCONFILTRCLKDIV2_ = 0x2
	// IOCONFILTRCLKDIV3.
	IOCON_PIO0_14_CLK_DIV_IOCONFILTRCLKDIV3_ = 0x3
	// IOCONFILTRCLKDIV4.
	IOCON_PIO0_14_CLK_DIV_IOCONFILTRCLKDIV4_ = 0x4
	// IOCONFILTRCLKDIV5.
	IOCON_PIO0_14_CLK_DIV_IOCONFILTRCLKDIV5_ = 0x5
	// IOCONFILTRCLKDIV6.
	IOCON_PIO0_14_CLK_DIV_IOCONFILTRCLKDIV6_ = 0x6
	// Position of RESERVED field.
	IOCON_PIO0_14_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	IOCON_PIO0_14_RESERVED_Msk = 0xffff0000
)

// Constants for SYSCON: System configuration (SYSCON)
const (
	// SYSMEMREMAP: System memory remap
	// Position of MAP field.
	SYSCON_SYSMEMREMAP_MAP_Pos = 0x0
	// Bit mask of MAP field.
	SYSCON_SYSMEMREMAP_MAP_Msk = 0x3
	// Boot Loader Mode. Interrupt vectors are re-mapped to Boot ROM.
	SYSCON_SYSMEMREMAP_MAP_BOOT_LOADER_MODE_IN = 0x0
	// User RAM Mode. Interrupt vectors are re-mapped to Static RAM.
	SYSCON_SYSMEMREMAP_MAP_USER_RAM_MODE_INTER = 0x1
	// User Flash Mode. Interrupt vectors are not re-mapped and reside in Flash.
	SYSCON_SYSMEMREMAP_MAP_USER_FLASH_MODE_INT = 0x2
	// Position of RESERVED field.
	SYSCON_SYSMEMREMAP_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSMEMREMAP_RESERVED_Msk = 0xfffffffc

	// PRESETCTRL: Peripheral reset control
	// Position of SPI0_RST_N field.
	SYSCON_PRESETCTRL_SPI0_RST_N_Pos = 0x0
	// Bit mask of SPI0_RST_N field.
	SYSCON_PRESETCTRL_SPI0_RST_N_Msk = 0x1
	// Bit SPI0_RST_N.
	SYSCON_PRESETCTRL_SPI0_RST_N = 0x1
	// Assert the SPI0 reset.
	SYSCON_PRESETCTRL_SPI0_RST_N_ASSERT_THE_SPI0_RESE = 0x0
	// Clear the SPI0 reset.
	SYSCON_PRESETCTRL_SPI0_RST_N_CLEAR_THE_SPI0_RESET = 0x1
	// Position of SPI1_RST_N field.
	SYSCON_PRESETCTRL_SPI1_RST_N_Pos = 0x1
	// Bit mask of SPI1_RST_N field.
	SYSCON_PRESETCTRL_SPI1_RST_N_Msk = 0x2
	// Bit SPI1_RST_N.
	SYSCON_PRESETCTRL_SPI1_RST_N = 0x2
	// Assert the SPI1 reset.
	SYSCON_PRESETCTRL_SPI1_RST_N_ASSERT_THE_SPI1_RESE = 0x0
	// Clear the SPI1 reset.
	SYSCON_PRESETCTRL_SPI1_RST_N_CLEAR_THE_SPI1_RESET = 0x1
	// Position of UARTFRG_RST_N field.
	SYSCON_PRESETCTRL_UARTFRG_RST_N_Pos = 0x2
	// Bit mask of UARTFRG_RST_N field.
	SYSCON_PRESETCTRL_UARTFRG_RST_N_Msk = 0x4
	// Bit UARTFRG_RST_N.
	SYSCON_PRESETCTRL_UARTFRG_RST_N = 0x4
	// Assert the UARTFRG reset.
	SYSCON_PRESETCTRL_UARTFRG_RST_N_ASSERT_THE_UARTFRG_R = 0x0
	// Clear the UARTFRG reset.
	SYSCON_PRESETCTRL_UARTFRG_RST_N_CLEAR_THE_UARTFRG_RE = 0x1
	// Position of USART0_RST_N field.
	SYSCON_PRESETCTRL_USART0_RST_N_Pos = 0x3
	// Bit mask of USART0_RST_N field.
	SYSCON_PRESETCTRL_USART0_RST_N_Msk = 0x8
	// Bit USART0_RST_N.
	SYSCON_PRESETCTRL_USART0_RST_N = 0x8
	// Assert the USART0 reset.
	SYSCON_PRESETCTRL_USART0_RST_N_ASSERT_THE_USART0_RE = 0x0
	// Clear the USART0 reset.
	SYSCON_PRESETCTRL_USART0_RST_N_CLEAR_THE_USART0_RES = 0x1
	// Position of UART1_RST_N field.
	SYSCON_PRESETCTRL_UART1_RST_N_Pos = 0x4
	// Bit mask of UART1_RST_N field.
	SYSCON_PRESETCTRL_UART1_RST_N_Msk = 0x10
	// Bit UART1_RST_N.
	SYSCON_PRESETCTRL_UART1_RST_N = 0x10
	// Assert the UART reset.
	SYSCON_PRESETCTRL_UART1_RST_N_ASSERT_THE_UART_RESE = 0x0
	// Clear the UART1 reset.
	SYSCON_PRESETCTRL_UART1_RST_N_CLEAR_THE_UART1_RESE = 0x1
	// Position of UART2_RST_N field.
	SYSCON_PRESETCTRL_UART2_RST_N_Pos = 0x5
	// Bit mask of UART2_RST_N field.
	SYSCON_PRESETCTRL_UART2_RST_N_Msk = 0x20
	// Bit UART2_RST_N.
	SYSCON_PRESETCTRL_UART2_RST_N = 0x20
	// Assert the UART2 reset.
	SYSCON_PRESETCTRL_UART2_RST_N_ASSERT_THE_UART2_RES = 0x0
	// Clear the UART2 reset.
	SYSCON_PRESETCTRL_UART2_RST_N_CLEAR_THE_UART2_RESE = 0x1
	// Position of I2C_RST_N field.
	SYSCON_PRESETCTRL_I2C_RST_N_Pos = 0x6
	// Bit mask of I2C_RST_N field.
	SYSCON_PRESETCTRL_I2C_RST_N_Msk = 0x40
	// Bit I2C_RST_N.
	SYSCON_PRESETCTRL_I2C_RST_N = 0x40
	// Assert the I2C reset.
	SYSCON_PRESETCTRL_I2C_RST_N_ASSERT_THE_I2C_RESET = 0x0
	// Clear the I2C reset.
	SYSCON_PRESETCTRL_I2C_RST_N_CLEAR_THE_I2C_RESET_ = 0x1
	// Position of MRT_RST_N field.
	SYSCON_PRESETCTRL_MRT_RST_N_Pos = 0x7
	// Bit mask of MRT_RST_N field.
	SYSCON_PRESETCTRL_MRT_RST_N_Msk = 0x80
	// Bit MRT_RST_N.
	SYSCON_PRESETCTRL_MRT_RST_N = 0x80
	// Assert the MRT reset.
	SYSCON_PRESETCTRL_MRT_RST_N_ASSERT_THE_MRT_RESET = 0x0
	// Clear the MRT reset.
	SYSCON_PRESETCTRL_MRT_RST_N_CLEAR_THE_MRT_RESET_ = 0x1
	// Position of SCT_RST_N field.
	SYSCON_PRESETCTRL_SCT_RST_N_Pos = 0x8
	// Bit mask of SCT_RST_N field.
	SYSCON_PRESETCTRL_SCT_RST_N_Msk = 0x100
	// Bit SCT_RST_N.
	SYSCON_PRESETCTRL_SCT_RST_N = 0x100
	// Assert the SCT reset.
	SYSCON_PRESETCTRL_SCT_RST_N_ASSERT_THE_SCT_RESET = 0x0
	// Clear the SCT reset.
	SYSCON_PRESETCTRL_SCT_RST_N_CLEAR_THE_SCT_RESET_ = 0x1
	// Position of WKT_RST_N field.
	SYSCON_PRESETCTRL_WKT_RST_N_Pos = 0x9
	// Bit mask of WKT_RST_N field.
	SYSCON_PRESETCTRL_WKT_RST_N_Msk = 0x200
	// Bit WKT_RST_N.
	SYSCON_PRESETCTRL_WKT_RST_N = 0x200
	// Assert the WKT reset.
	SYSCON_PRESETCTRL_WKT_RST_N_ASSERT_THE_WKT_RESET = 0x0
	// Clear the WKT reset.
	SYSCON_PRESETCTRL_WKT_RST_N_CLEAR_THE_WKT_RESET_ = 0x1
	// Position of GPIO_RST_N field.
	SYSCON_PRESETCTRL_GPIO_RST_N_Pos = 0xa
	// Bit mask of GPIO_RST_N field.
	SYSCON_PRESETCTRL_GPIO_RST_N_Msk = 0x400
	// Bit GPIO_RST_N.
	SYSCON_PRESETCTRL_GPIO_RST_N = 0x400
	// Assert the GPIO reset.
	SYSCON_PRESETCTRL_GPIO_RST_N_ASSERT_THE_GPIO_RESE = 0x0
	// Clear the GPIO reset.
	SYSCON_PRESETCTRL_GPIO_RST_N_CLEAR_THE_GPIO_RESET = 0x1
	// Position of FLASH_RST_N field.
	SYSCON_PRESETCTRL_FLASH_RST_N_Pos = 0xb
	// Bit mask of FLASH_RST_N field.
	SYSCON_PRESETCTRL_FLASH_RST_N_Msk = 0x800
	// Bit FLASH_RST_N.
	SYSCON_PRESETCTRL_FLASH_RST_N = 0x800
	// Assert the flash controller reset.
	SYSCON_PRESETCTRL_FLASH_RST_N_ASSERT_THE_FLASH_CON = 0x0
	// Clear the flash controller reset.
	SYSCON_PRESETCTRL_FLASH_RST_N_CLEAR_THE_FLASH_CONT = 0x1
	// Position of ACMP_RST_N field.
	SYSCON_PRESETCTRL_ACMP_RST_N_Pos = 0xc
	// Bit mask of ACMP_RST_N field.
	SYSCON_PRESETCTRL_ACMP_RST_N_Msk = 0x1000
	// Bit ACMP_RST_N.
	SYSCON_PRESETCTRL_ACMP_RST_N = 0x1000
	// Assert the analog comparator reset.
	SYSCON_PRESETCTRL_ACMP_RST_N_ASSERT_THE_ANALOG_CO = 0x0
	// Clear the analog comparator controller reset.
	SYSCON_PRESETCTRL_ACMP_RST_N_CLEAR_THE_ANALOG_COM = 0x1
	// Position of RESERVED field.
	SYSCON_PRESETCTRL_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL_RESERVED_Msk = 0xfffff000

	// SYSPLLCTRL: System PLL control
	// Position of MSEL field.
	SYSCON_SYSPLLCTRL_MSEL_Pos = 0x0
	// Bit mask of MSEL field.
	SYSCON_SYSPLLCTRL_MSEL_Msk = 0x1f
	// Position of PSEL field.
	SYSCON_SYSPLLCTRL_PSEL_Pos = 0x5
	// Bit mask of PSEL field.
	SYSCON_SYSPLLCTRL_PSEL_Msk = 0x60
	// P = 1
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_1 = 0x0
	// P = 2
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_2 = 0x1
	// P = 4
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_4 = 0x2
	// P = 8
	SYSCON_SYSPLLCTRL_PSEL_P_EQ_8 = 0x3
	// Position of RESERVED field.
	SYSCON_SYSPLLCTRL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCTRL_RESERVED_Msk = 0xffffff80

	// SYSPLLSTAT: System PLL status
	// Position of LOCK field.
	SYSCON_SYSPLLSTAT_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	SYSCON_SYSPLLSTAT_LOCK_Msk = 0x1
	// Bit LOCK.
	SYSCON_SYSPLLSTAT_LOCK = 0x1
	// PLL not locked
	SYSCON_SYSPLLSTAT_LOCK_PLL_NOT_LOCKED = 0x0
	// PLL locked
	SYSCON_SYSPLLSTAT_LOCK_PLL_LOCKED = 0x1
	// Position of RESERVED field.
	SYSCON_SYSPLLSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLSTAT_RESERVED_Msk = 0xfffffffe

	// SYSOSCCTRL: System oscillator control
	// Position of BYPASS field.
	SYSCON_SYSOSCCTRL_BYPASS_Pos = 0x0
	// Bit mask of BYPASS field.
	SYSCON_SYSOSCCTRL_BYPASS_Msk = 0x1
	// Bit BYPASS.
	SYSCON_SYSOSCCTRL_BYPASS = 0x1
	// Disabled. Oscillator is not bypassed.
	SYSCON_SYSOSCCTRL_BYPASS_DISABLED_OSCILLATOR = 0x0
	// Enabled. PLL input (sys_osc_clk) is fed directly from the XTALIN pin bypassing the oscillator. Use this mode when using an external clock source instead of the crystal oscillator.
	SYSCON_SYSOSCCTRL_BYPASS_ENABLED_PLL_INPUT_ = 0x1
	// Position of FREQRANGE field.
	SYSCON_SYSOSCCTRL_FREQRANGE_Pos = 0x1
	// Bit mask of FREQRANGE field.
	SYSCON_SYSOSCCTRL_FREQRANGE_Msk = 0x2
	// Bit FREQRANGE.
	SYSCON_SYSOSCCTRL_FREQRANGE = 0x2
	// 1 - 20 MHz frequency range.
	SYSCON_SYSOSCCTRL_FREQRANGE_1__20_MHZ_FREQUENCY = 0x0
	// 15 - 25 MHz frequency range
	SYSCON_SYSOSCCTRL_FREQRANGE_15__25_MHZ_FREQUENC = 0x1
	// Position of RESERVED field.
	SYSCON_SYSOSCCTRL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSOSCCTRL_RESERVED_Msk = 0xfffffffc

	// WDTOSCCTRL: Watchdog oscillator control
	// Position of DIVSEL field.
	SYSCON_WDTOSCCTRL_DIVSEL_Pos = 0x0
	// Bit mask of DIVSEL field.
	SYSCON_WDTOSCCTRL_DIVSEL_Msk = 0x1f
	// Position of FREQSEL field.
	SYSCON_WDTOSCCTRL_FREQSEL_Pos = 0x5
	// Bit mask of FREQSEL field.
	SYSCON_WDTOSCCTRL_FREQSEL_Msk = 0x1e0
	// 0.6 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_0_6_MHZ = 0x1
	// 1.05 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_1_05_MHZ = 0x2
	// 1.4 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_1_4_MHZ = 0x3
	// 1.75 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_1_75_MHZ = 0x4
	// 2.1 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_2_1_MHZ = 0x5
	// 2.4 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_2_4_MHZ = 0x6
	// 2.7 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_2_7_MHZ = 0x7
	// 3.0 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_3_0_MHZ = 0x8
	// 3.25 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_3_25_MHZ = 0x9
	// 3.5 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_3_5_MHZ = 0xa
	// 3.75 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_3_75_MHZ = 0xb
	// 4.0 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_4_0_MHZ = 0xc
	// 4.2 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_4_2_MHZ = 0xd
	// 4.4 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_4_4_MHZ = 0xe
	// 4.6 MHz
	SYSCON_WDTOSCCTRL_FREQSEL_4_6_MHZ = 0xf
	// Position of RESERVED field.
	SYSCON_WDTOSCCTRL_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SYSCON_WDTOSCCTRL_RESERVED_Msk = 0xfffffe00

	// SYSRSTSTAT: System reset status register
	// Position of POR field.
	SYSCON_SYSRSTSTAT_POR_Pos = 0x0
	// Bit mask of POR field.
	SYSCON_SYSRSTSTAT_POR_Msk = 0x1
	// Bit POR.
	SYSCON_SYSRSTSTAT_POR = 0x1
	// No POR detected
	SYSCON_SYSRSTSTAT_POR_NO_POR_DETECTED = 0x0
	// POR detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_POR_POR_DETECTED_WRITIN = 0x1
	// Position of EXTRST field.
	SYSCON_SYSRSTSTAT_EXTRST_Pos = 0x1
	// Bit mask of EXTRST field.
	SYSCON_SYSRSTSTAT_EXTRST_Msk = 0x2
	// Bit EXTRST.
	SYSCON_SYSRSTSTAT_EXTRST = 0x2
	// No reset event detected.
	SYSCON_SYSRSTSTAT_EXTRST_NO_RESET_EVENT_DETEC = 0x0
	// Reset detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_EXTRST_RESET_DETECTED_WRIT = 0x1
	// Position of WDT field.
	SYSCON_SYSRSTSTAT_WDT_Pos = 0x2
	// Bit mask of WDT field.
	SYSCON_SYSRSTSTAT_WDT_Msk = 0x4
	// Bit WDT.
	SYSCON_SYSRSTSTAT_WDT = 0x4
	// No WDT reset detected
	SYSCON_SYSRSTSTAT_WDT_NO_WDT_RESET_DETECTE = 0x0
	// WDT reset detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_WDT_WDT_RESET_DETECTED_ = 0x1
	// Position of BOD field.
	SYSCON_SYSRSTSTAT_BOD_Pos = 0x3
	// Bit mask of BOD field.
	SYSCON_SYSRSTSTAT_BOD_Msk = 0x8
	// Bit BOD.
	SYSCON_SYSRSTSTAT_BOD = 0x8
	// No BOD reset detected
	SYSCON_SYSRSTSTAT_BOD_NO_BOD_RESET_DETECTE = 0x0
	// BOD reset detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_BOD_BOD_RESET_DETECTED_ = 0x1
	// Position of SYSRST field.
	SYSCON_SYSRSTSTAT_SYSRST_Pos = 0x4
	// Bit mask of SYSRST field.
	SYSCON_SYSRSTSTAT_SYSRST_Msk = 0x10
	// Bit SYSRST.
	SYSCON_SYSRSTSTAT_SYSRST = 0x10
	// No System reset detected
	SYSCON_SYSRSTSTAT_SYSRST_NO_SYSTEM_RESET_DETE = 0x0
	// System reset detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_SYSRST_SYSTEM_RESET_DETECTE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSRSTSTAT_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_SYSRSTSTAT_RESERVED_Msk = 0xffffffe0

	// SYSPLLCLKSEL: System PLL clock source select
	// Position of SEL field.
	SYSCON_SYSPLLCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_SYSPLLCLKSEL_SEL_Msk = 0x3
	// IRC
	SYSCON_SYSPLLCLKSEL_SEL_IRC = 0x0
	// Crystal Oscillator (SYSOSC)
	SYSCON_SYSPLLCLKSEL_SEL_CRYSTAL_OSCILLATOR_ = 0x1
	// Reserved.
	SYSCON_SYSPLLCLKSEL_SEL_RESERVED_ = 0x2
	// CLKIN. External clock input.
	SYSCON_SYSPLLCLKSEL_SEL_CLKIN_EXTERNAL_CLOC = 0x3
	// Position of RESERVED field.
	SYSCON_SYSPLLCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCLKSEL_RESERVED_Msk = 0xfffffffc

	// SYSPLLCLKUEN: System PLL clock source update enable
	// Position of ENA field.
	SYSCON_SYSPLLCLKUEN_ENA_Pos = 0x0
	// Bit mask of ENA field.
	SYSCON_SYSPLLCLKUEN_ENA_Msk = 0x1
	// Bit ENA.
	SYSCON_SYSPLLCLKUEN_ENA = 0x1
	// No change
	SYSCON_SYSPLLCLKUEN_ENA_NO_CHANGE = 0x0
	// Update clock source
	SYSCON_SYSPLLCLKUEN_ENA_UPDATE_CLOCK_SOURCE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSPLLCLKUEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCLKUEN_RESERVED_Msk = 0xfffffffe

	// MAINCLKSEL: Main clock source select
	// Position of SEL field.
	SYSCON_MAINCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_MAINCLKSEL_SEL_Msk = 0x3
	// IRC Oscillator
	SYSCON_MAINCLKSEL_SEL_IRC_OSCILLATOR = 0x0
	// PLL input
	SYSCON_MAINCLKSEL_SEL_PLL_INPUT = 0x1
	// Watchdog oscillator
	SYSCON_MAINCLKSEL_SEL_WATCHDOG_OSCILLATOR = 0x2
	// PLL output
	SYSCON_MAINCLKSEL_SEL_PLL_OUTPUT = 0x3
	// Position of RESERVED field.
	SYSCON_MAINCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_MAINCLKSEL_RESERVED_Msk = 0xfffffffc

	// MAINCLKUEN: Main clock source update enable
	// Position of ENA field.
	SYSCON_MAINCLKUEN_ENA_Pos = 0x0
	// Bit mask of ENA field.
	SYSCON_MAINCLKUEN_ENA_Msk = 0x1
	// Bit ENA.
	SYSCON_MAINCLKUEN_ENA = 0x1
	// No change
	SYSCON_MAINCLKUEN_ENA_NO_CHANGE = 0x0
	// Update clock source
	SYSCON_MAINCLKUEN_ENA_UPDATE_CLOCK_SOURCE = 0x1
	// Position of RESERVED field.
	SYSCON_MAINCLKUEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_MAINCLKUEN_RESERVED_Msk = 0xfffffffe

	// SYSAHBCLKDIV: System clock divider
	// Position of DIV field.
	SYSCON_SYSAHBCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_SYSAHBCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKDIV_RESERVED_Msk = 0xffffff00

	// SYSAHBCLKCTRL: System clock control
	// Position of SYS field.
	SYSCON_SYSAHBCLKCTRL_SYS_Pos = 0x0
	// Bit mask of SYS field.
	SYSCON_SYSAHBCLKCTRL_SYS_Msk = 0x1
	// Bit SYS.
	SYSCON_SYSAHBCLKCTRL_SYS = 0x1
	// Enable
	SYSCON_SYSAHBCLKCTRL_SYS_ENABLE = 0x1
	// Position of ROM field.
	SYSCON_SYSAHBCLKCTRL_ROM_Pos = 0x1
	// Bit mask of ROM field.
	SYSCON_SYSAHBCLKCTRL_ROM_Msk = 0x2
	// Bit ROM.
	SYSCON_SYSAHBCLKCTRL_ROM = 0x2
	// Disable
	SYSCON_SYSAHBCLKCTRL_ROM_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_ROM_ENABLE = 0x1
	// Position of RAM field.
	SYSCON_SYSAHBCLKCTRL_RAM_Pos = 0x2
	// Bit mask of RAM field.
	SYSCON_SYSAHBCLKCTRL_RAM_Msk = 0x4
	// Bit RAM.
	SYSCON_SYSAHBCLKCTRL_RAM = 0x4
	// Disable
	SYSCON_SYSAHBCLKCTRL_RAM_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_RAM_ENABLE = 0x1
	// Position of FLASHREG field.
	SYSCON_SYSAHBCLKCTRL_FLASHREG_Pos = 0x3
	// Bit mask of FLASHREG field.
	SYSCON_SYSAHBCLKCTRL_FLASHREG_Msk = 0x8
	// Bit FLASHREG.
	SYSCON_SYSAHBCLKCTRL_FLASHREG = 0x8
	// Disable
	SYSCON_SYSAHBCLKCTRL_FLASHREG_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_FLASHREG_ENABLE = 0x1
	// Position of FLASH field.
	SYSCON_SYSAHBCLKCTRL_FLASH_Pos = 0x4
	// Bit mask of FLASH field.
	SYSCON_SYSAHBCLKCTRL_FLASH_Msk = 0x10
	// Bit FLASH.
	SYSCON_SYSAHBCLKCTRL_FLASH = 0x10
	// Disable
	SYSCON_SYSAHBCLKCTRL_FLASH_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_FLASH_ENABLE = 0x1
	// Position of I2C field.
	SYSCON_SYSAHBCLKCTRL_I2C_Pos = 0x5
	// Bit mask of I2C field.
	SYSCON_SYSAHBCLKCTRL_I2C_Msk = 0x20
	// Bit I2C.
	SYSCON_SYSAHBCLKCTRL_I2C = 0x20
	// Disable
	SYSCON_SYSAHBCLKCTRL_I2C_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_I2C_ENABLE = 0x1
	// Position of GPIO field.
	SYSCON_SYSAHBCLKCTRL_GPIO_Pos = 0x6
	// Bit mask of GPIO field.
	SYSCON_SYSAHBCLKCTRL_GPIO_Msk = 0x40
	// Bit GPIO.
	SYSCON_SYSAHBCLKCTRL_GPIO = 0x40
	// Disable
	SYSCON_SYSAHBCLKCTRL_GPIO_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_GPIO_ENABLE = 0x1
	// Position of SWM field.
	SYSCON_SYSAHBCLKCTRL_SWM_Pos = 0x7
	// Bit mask of SWM field.
	SYSCON_SYSAHBCLKCTRL_SWM_Msk = 0x80
	// Bit SWM.
	SYSCON_SYSAHBCLKCTRL_SWM = 0x80
	// Disable
	SYSCON_SYSAHBCLKCTRL_SWM_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_SWM_ENABLE = 0x1
	// Position of SCT field.
	SYSCON_SYSAHBCLKCTRL_SCT_Pos = 0x8
	// Bit mask of SCT field.
	SYSCON_SYSAHBCLKCTRL_SCT_Msk = 0x100
	// Bit SCT.
	SYSCON_SYSAHBCLKCTRL_SCT = 0x100
	// Disable
	SYSCON_SYSAHBCLKCTRL_SCT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_SCT_ENABLE = 0x1
	// Position of WKT field.
	SYSCON_SYSAHBCLKCTRL_WKT_Pos = 0x9
	// Bit mask of WKT field.
	SYSCON_SYSAHBCLKCTRL_WKT_Msk = 0x200
	// Bit WKT.
	SYSCON_SYSAHBCLKCTRL_WKT = 0x200
	// Disable
	SYSCON_SYSAHBCLKCTRL_WKT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_WKT_ENABLE = 0x1
	// Position of MRT field.
	SYSCON_SYSAHBCLKCTRL_MRT_Pos = 0xa
	// Bit mask of MRT field.
	SYSCON_SYSAHBCLKCTRL_MRT_Msk = 0x400
	// Bit MRT.
	SYSCON_SYSAHBCLKCTRL_MRT = 0x400
	// Disable
	SYSCON_SYSAHBCLKCTRL_MRT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_MRT_ENABLE = 0x1
	// Position of SPI0 field.
	SYSCON_SYSAHBCLKCTRL_SPI0_Pos = 0xb
	// Bit mask of SPI0 field.
	SYSCON_SYSAHBCLKCTRL_SPI0_Msk = 0x800
	// Bit SPI0.
	SYSCON_SYSAHBCLKCTRL_SPI0 = 0x800
	// Disable
	SYSCON_SYSAHBCLKCTRL_SPI0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_SPI0_ENABLE = 0x1
	// Position of SPI1 field.
	SYSCON_SYSAHBCLKCTRL_SPI1_Pos = 0xc
	// Bit mask of SPI1 field.
	SYSCON_SYSAHBCLKCTRL_SPI1_Msk = 0x1000
	// Bit SPI1.
	SYSCON_SYSAHBCLKCTRL_SPI1 = 0x1000
	// Disable
	SYSCON_SYSAHBCLKCTRL_SPI1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_SPI1_ENABLE = 0x1
	// Position of CRC field.
	SYSCON_SYSAHBCLKCTRL_CRC_Pos = 0xd
	// Bit mask of CRC field.
	SYSCON_SYSAHBCLKCTRL_CRC_Msk = 0x2000
	// Bit CRC.
	SYSCON_SYSAHBCLKCTRL_CRC = 0x2000
	// Disable
	SYSCON_SYSAHBCLKCTRL_CRC_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_CRC_ENABLE = 0x1
	// Position of UART0 field.
	SYSCON_SYSAHBCLKCTRL_UART0_Pos = 0xe
	// Bit mask of UART0 field.
	SYSCON_SYSAHBCLKCTRL_UART0_Msk = 0x4000
	// Bit UART0.
	SYSCON_SYSAHBCLKCTRL_UART0 = 0x4000
	// Disable
	SYSCON_SYSAHBCLKCTRL_UART0_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_UART0_ENABLE = 0x1
	// Position of UART1 field.
	SYSCON_SYSAHBCLKCTRL_UART1_Pos = 0xf
	// Bit mask of UART1 field.
	SYSCON_SYSAHBCLKCTRL_UART1_Msk = 0x8000
	// Bit UART1.
	SYSCON_SYSAHBCLKCTRL_UART1 = 0x8000
	// Disable
	SYSCON_SYSAHBCLKCTRL_UART1_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_UART1_ENABLE = 0x1
	// Position of UART2 field.
	SYSCON_SYSAHBCLKCTRL_UART2_Pos = 0x10
	// Bit mask of UART2 field.
	SYSCON_SYSAHBCLKCTRL_UART2_Msk = 0x10000
	// Bit UART2.
	SYSCON_SYSAHBCLKCTRL_UART2 = 0x10000
	// Disable
	SYSCON_SYSAHBCLKCTRL_UART2_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_UART2_ENABLE = 0x1
	// Position of WWDT field.
	SYSCON_SYSAHBCLKCTRL_WWDT_Pos = 0x11
	// Bit mask of WWDT field.
	SYSCON_SYSAHBCLKCTRL_WWDT_Msk = 0x20000
	// Bit WWDT.
	SYSCON_SYSAHBCLKCTRL_WWDT = 0x20000
	// Disable
	SYSCON_SYSAHBCLKCTRL_WWDT_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_WWDT_ENABLE = 0x1
	// Position of IOCON field.
	SYSCON_SYSAHBCLKCTRL_IOCON_Pos = 0x12
	// Bit mask of IOCON field.
	SYSCON_SYSAHBCLKCTRL_IOCON_Msk = 0x40000
	// Bit IOCON.
	SYSCON_SYSAHBCLKCTRL_IOCON = 0x40000
	// Disable
	SYSCON_SYSAHBCLKCTRL_IOCON_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_IOCON_ENABLE = 0x1
	// Position of ACMP field.
	SYSCON_SYSAHBCLKCTRL_ACMP_Pos = 0x13
	// Bit mask of ACMP field.
	SYSCON_SYSAHBCLKCTRL_ACMP_Msk = 0x80000
	// Bit ACMP.
	SYSCON_SYSAHBCLKCTRL_ACMP = 0x80000
	// Disable
	SYSCON_SYSAHBCLKCTRL_ACMP_DISABLE = 0x0
	// Enable
	SYSCON_SYSAHBCLKCTRL_ACMP_ENABLE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	SYSCON_SYSAHBCLKCTRL_RESERVED_Msk = 0xfff00000

	// UARTCLKDIV: UART clock divider
	// Position of DIV field.
	SYSCON_UARTCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_UARTCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_UARTCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_UARTCLKDIV_RESERVED_Msk = 0xffffff00

	// CLKOUTSEL: CLKOUT clock source select
	// Position of SEL field.
	SYSCON_CLKOUTSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_CLKOUTSEL_SEL_Msk = 0x3
	// IRC oscillator
	SYSCON_CLKOUTSEL_SEL_IRC_OSCILLATOR = 0x0
	// Crystal oscillator (SYSOSC)
	SYSCON_CLKOUTSEL_SEL_CRYSTAL_OSCILLATOR_ = 0x1
	// Watchdog oscillator
	SYSCON_CLKOUTSEL_SEL_WATCHDOG_OSCILLATOR = 0x2
	// Main clock
	SYSCON_CLKOUTSEL_SEL_MAIN_CLOCK = 0x3
	// Position of RESERVED field.
	SYSCON_CLKOUTSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTSEL_RESERVED_Msk = 0xfffffffc

	// CLKOUTUEN: CLKOUT clock source update enable
	// Position of ENA field.
	SYSCON_CLKOUTUEN_ENA_Pos = 0x0
	// Bit mask of ENA field.
	SYSCON_CLKOUTUEN_ENA_Msk = 0x1
	// Bit ENA.
	SYSCON_CLKOUTUEN_ENA = 0x1
	// No change
	SYSCON_CLKOUTUEN_ENA_NO_CHANGE = 0x0
	// Update clock source
	SYSCON_CLKOUTUEN_ENA_UPDATE_CLOCK_SOURCE = 0x1
	// Position of RESERVED field.
	SYSCON_CLKOUTUEN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTUEN_RESERVED_Msk = 0xfffffffe

	// CLKOUTDIV: CLKOUT clock divider
	// Position of DIV field.
	SYSCON_CLKOUTDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_CLKOUTDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_CLKOUTDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTDIV_RESERVED_Msk = 0xffffff00

	// UARTFRGDIV: UART fractional generator divider value
	// Position of DIV field.
	SYSCON_UARTFRGDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_UARTFRGDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_UARTFRGDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_UARTFRGDIV_RESERVED_Msk = 0xffffff00

	// UARTFRGMULT: UART fractional generator multiplier value
	// Position of MULT field.
	SYSCON_UARTFRGMULT_MULT_Pos = 0x0
	// Bit mask of MULT field.
	SYSCON_UARTFRGMULT_MULT_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_UARTFRGMULT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_UARTFRGMULT_RESERVED_Msk = 0xffffff00

	// EXTTRACECMD: External trace buffer command register
	// Position of START field.
	SYSCON_EXTTRACECMD_START_Pos = 0x0
	// Bit mask of START field.
	SYSCON_EXTTRACECMD_START_Msk = 0x1
	// Bit START.
	SYSCON_EXTTRACECMD_START = 0x1
	// Position of STOP field.
	SYSCON_EXTTRACECMD_STOP_Pos = 0x1
	// Bit mask of STOP field.
	SYSCON_EXTTRACECMD_STOP_Msk = 0x2
	// Bit STOP.
	SYSCON_EXTTRACECMD_STOP = 0x2
	// Position of RESERVED field.
	SYSCON_EXTTRACECMD_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_EXTTRACECMD_RESERVED_Msk = 0xfffffffc

	// PIOPORCAP0: POR captured PIO status 0
	// Position of PIOSTAT field.
	SYSCON_PIOPORCAP0_PIOSTAT_Pos = 0x0
	// Bit mask of PIOSTAT field.
	SYSCON_PIOPORCAP0_PIOSTAT_Msk = 0x3ffff
	// Position of RESERVED field.
	SYSCON_PIOPORCAP0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	SYSCON_PIOPORCAP0_RESERVED_Msk = 0xfffc0000

	// IOCONCLKDIV6: Peripheral clock 6 to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV6_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV6_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV6_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV6_RESERVED_Msk = 0xffffff00

	// IOCONCLKDIV5: Peripheral clock 5 to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV5_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV5_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV5_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV5_RESERVED_Msk = 0xffffff00

	// IOCONCLKDIV4: Peripheral clock 4 to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV4_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV4_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV4_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV4_RESERVED_Msk = 0xffffff00

	// IOCONCLKDIV3: Peripheral clock 3 to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV3_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV3_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV3_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV3_RESERVED_Msk = 0xffffff00

	// IOCONCLKDIV2: Peripheral clock 2 to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV2_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV2_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV2_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV2_RESERVED_Msk = 0xffffff00

	// IOCONCLKDIV1: Peripheral clock 1 to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV1_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV1_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV1_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV1_RESERVED_Msk = 0xffffff00

	// IOCONCLKDIV0: Peripheral clock 0 to the IOCON block for programmable glitch filter
	// Position of DIV field.
	SYSCON_IOCONCLKDIV0_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_IOCONCLKDIV0_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IOCONCLKDIV0_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IOCONCLKDIV0_RESERVED_Msk = 0xffffff00

	// BODCTRL: Brown-Out Detect
	// Position of BODRSTLEV field.
	SYSCON_BODCTRL_BODRSTLEV_Pos = 0x0
	// Bit mask of BODRSTLEV field.
	SYSCON_BODCTRL_BODRSTLEV_Msk = 0x3
	// Level 0: The reset assertion threshold voltage is ; the reset de-assertion threshold voltage is .
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_0_THE_RESET_A = 0x0
	// Level 1: The reset assertion threshold voltage is ; the reset de-assertion threshold voltage is .
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_1_THE_RESET_A = 0x1
	// Level 2: The reset assertion threshold voltage is ; the reset de-assertion threshold voltage is .
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_2_THE_RESET_A = 0x2
	// Level 3: The reset assertion threshold voltage is ; the reset de-assertion threshold voltage is.
	SYSCON_BODCTRL_BODRSTLEV_LEVEL_3_THE_RESET_A = 0x3
	// Position of BODINTVAL field.
	SYSCON_BODCTRL_BODINTVAL_Pos = 0x2
	// Bit mask of BODINTVAL field.
	SYSCON_BODCTRL_BODINTVAL_Msk = 0xc
	// Level 0: The interrupt assertion threshold voltage is ; the interrupt de-assertion threshold voltage is
	SYSCON_BODCTRL_BODINTVAL_LEVEL_0_THE_INTERRU = 0x0
	// Level 1:The interrupt assertion threshold voltage is ; the interrupt de-assertion threshold voltage is .
	SYSCON_BODCTRL_BODINTVAL_LEVEL_1THE_INTERRUP = 0x1
	// Level 2: The interrupt assertion threshold voltage is ; the interrupt de-assertion threshold voltage is .
	SYSCON_BODCTRL_BODINTVAL_LEVEL_2_THE_INTERRU = 0x2
	// Level 3: The interrupt assertion threshold voltage is ; the interrupt de-assertion threshold voltage is .
	SYSCON_BODCTRL_BODINTVAL_LEVEL_3_THE_INTERRU = 0x3
	// Position of BODRSTENA field.
	SYSCON_BODCTRL_BODRSTENA_Pos = 0x4
	// Bit mask of BODRSTENA field.
	SYSCON_BODCTRL_BODRSTENA_Msk = 0x10
	// Bit BODRSTENA.
	SYSCON_BODCTRL_BODRSTENA = 0x10
	// Disable reset function.
	SYSCON_BODCTRL_BODRSTENA_DISABLE_RESET_FUNCTI = 0x0
	// Enable reset function.
	SYSCON_BODCTRL_BODRSTENA_ENABLE_RESET_FUNCTIO = 0x1
	// Position of RESERVED field.
	SYSCON_BODCTRL_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_BODCTRL_RESERVED_Msk = 0xffffffe0

	// SYSTCKCAL: System tick counter calibration
	// Position of CAL field.
	SYSCON_SYSTCKCAL_CAL_Pos = 0x0
	// Bit mask of CAL field.
	SYSCON_SYSTCKCAL_CAL_Msk = 0x3ffffff
	// Position of RESERVED field.
	SYSCON_SYSTCKCAL_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	SYSCON_SYSTCKCAL_RESERVED_Msk = 0xfc000000

	// IRQLATENCY: IQR delay. Allows trade-off between interrupt latency and determinism.
	// Position of LATENCY field.
	SYSCON_IRQLATENCY_LATENCY_Pos = 0x0
	// Bit mask of LATENCY field.
	SYSCON_IRQLATENCY_LATENCY_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IRQLATENCY_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IRQLATENCY_RESERVED_Msk = 0xffffff00

	// NMISRC: NMI Source Control
	// Position of IRQNO field.
	SYSCON_NMISRC_IRQNO_Pos = 0x0
	// Bit mask of IRQNO field.
	SYSCON_NMISRC_IRQNO_Msk = 0x1f
	// Position of RESERVED field.
	SYSCON_NMISRC_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_NMISRC_RESERVED_Msk = 0x7fffffe0
	// Position of NMIEN field.
	SYSCON_NMISRC_NMIEN_Pos = 0x1f
	// Bit mask of NMIEN field.
	SYSCON_NMISRC_NMIEN_Msk = 0x80000000
	// Bit NMIEN.
	SYSCON_NMISRC_NMIEN = 0x80000000

	// PINTSEL0: GPIO Pin Interrupt Select register 0
	// Position of INTPIN field.
	SYSCON_PINTSEL_INTPIN_Pos = 0x0
	// Bit mask of INTPIN field.
	SYSCON_PINTSEL_INTPIN_Msk = 0x3f
	// Position of RESERVED field.
	SYSCON_PINTSEL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SYSCON_PINTSEL_RESERVED_Msk = 0xffffffc0

	// STARTERP0: Start logic 0 pin wake-up enable register
	// Position of PINT0 field.
	SYSCON_STARTERP0_PINT0_Pos = 0x0
	// Bit mask of PINT0 field.
	SYSCON_STARTERP0_PINT0_Msk = 0x1
	// Bit PINT0.
	SYSCON_STARTERP0_PINT0 = 0x1
	// Disabled
	SYSCON_STARTERP0_PINT0_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT0_ENABLED = 0x1
	// Position of PINT1 field.
	SYSCON_STARTERP0_PINT1_Pos = 0x1
	// Bit mask of PINT1 field.
	SYSCON_STARTERP0_PINT1_Msk = 0x2
	// Bit PINT1.
	SYSCON_STARTERP0_PINT1 = 0x2
	// Disabled
	SYSCON_STARTERP0_PINT1_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT1_ENABLED = 0x1
	// Position of PINT2 field.
	SYSCON_STARTERP0_PINT2_Pos = 0x2
	// Bit mask of PINT2 field.
	SYSCON_STARTERP0_PINT2_Msk = 0x4
	// Bit PINT2.
	SYSCON_STARTERP0_PINT2 = 0x4
	// Disabled
	SYSCON_STARTERP0_PINT2_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT2_ENABLED = 0x1
	// Position of PINT3 field.
	SYSCON_STARTERP0_PINT3_Pos = 0x3
	// Bit mask of PINT3 field.
	SYSCON_STARTERP0_PINT3_Msk = 0x8
	// Bit PINT3.
	SYSCON_STARTERP0_PINT3 = 0x8
	// Disabled
	SYSCON_STARTERP0_PINT3_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT3_ENABLED = 0x1
	// Position of PINT4 field.
	SYSCON_STARTERP0_PINT4_Pos = 0x4
	// Bit mask of PINT4 field.
	SYSCON_STARTERP0_PINT4_Msk = 0x10
	// Bit PINT4.
	SYSCON_STARTERP0_PINT4 = 0x10
	// Disabled
	SYSCON_STARTERP0_PINT4_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT4_ENABLED = 0x1
	// Position of PINT5 field.
	SYSCON_STARTERP0_PINT5_Pos = 0x5
	// Bit mask of PINT5 field.
	SYSCON_STARTERP0_PINT5_Msk = 0x20
	// Bit PINT5.
	SYSCON_STARTERP0_PINT5 = 0x20
	// Disabled
	SYSCON_STARTERP0_PINT5_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT5_ENABLED = 0x1
	// Position of PINT6 field.
	SYSCON_STARTERP0_PINT6_Pos = 0x6
	// Bit mask of PINT6 field.
	SYSCON_STARTERP0_PINT6_Msk = 0x40
	// Bit PINT6.
	SYSCON_STARTERP0_PINT6 = 0x40
	// Disabled
	SYSCON_STARTERP0_PINT6_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT6_ENABLED = 0x1
	// Position of PINT7 field.
	SYSCON_STARTERP0_PINT7_Pos = 0x7
	// Bit mask of PINT7 field.
	SYSCON_STARTERP0_PINT7_Msk = 0x80
	// Bit PINT7.
	SYSCON_STARTERP0_PINT7 = 0x80
	// Disabled
	SYSCON_STARTERP0_PINT7_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP0_PINT7_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Msk = 0xffffff00

	// STARTERP1: Start logic 1 interrupt wake-up enable register
	// Position of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Msk = 0xfff
	// Position of WWDT field.
	SYSCON_STARTERP1_WWDT_Pos = 0xc
	// Bit mask of WWDT field.
	SYSCON_STARTERP1_WWDT_Msk = 0x1000
	// Bit WWDT.
	SYSCON_STARTERP1_WWDT = 0x1000
	// Disabled
	SYSCON_STARTERP1_WWDT_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_WWDT_ENABLED = 0x1
	// Position of BOD field.
	SYSCON_STARTERP1_BOD_Pos = 0xd
	// Bit mask of BOD field.
	SYSCON_STARTERP1_BOD_Msk = 0x2000
	// Bit BOD.
	SYSCON_STARTERP1_BOD = 0x2000
	// Disabled
	SYSCON_STARTERP1_BOD_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_BOD_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Msk = 0x4000
	// Bit RESERVED.
	SYSCON_STARTERP1_RESERVED = 0x4000
	// Position of WKT field.
	SYSCON_STARTERP1_WKT_Pos = 0xf
	// Bit mask of WKT field.
	SYSCON_STARTERP1_WKT_Msk = 0x8000
	// Bit WKT.
	SYSCON_STARTERP1_WKT = 0x8000
	// Disabled
	SYSCON_STARTERP1_WKT_DISABLED = 0x0
	// Enabled
	SYSCON_STARTERP1_WKT_ENABLED = 0x1

	// PDSLEEPCFG: Power-down states in deep-sleep mode
	// Position of BOD_PD field.
	SYSCON_PDSLEEPCFG_BOD_PD_Pos = 0x3
	// Bit mask of BOD_PD field.
	SYSCON_PDSLEEPCFG_BOD_PD_Msk = 0x8
	// Bit BOD_PD.
	SYSCON_PDSLEEPCFG_BOD_PD = 0x8
	// Powered
	SYSCON_PDSLEEPCFG_BOD_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDSLEEPCFG_BOD_PD_POWERED_DOWN = 0x1
	// Position of WDTOSC_PD field.
	SYSCON_PDSLEEPCFG_WDTOSC_PD_Pos = 0x6
	// Bit mask of WDTOSC_PD field.
	SYSCON_PDSLEEPCFG_WDTOSC_PD_Msk = 0x40
	// Bit WDTOSC_PD.
	SYSCON_PDSLEEPCFG_WDTOSC_PD = 0x40
	// Powered
	SYSCON_PDSLEEPCFG_WDTOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDSLEEPCFG_WDTOSC_PD_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Msk = 0xff80
	// Position of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	SYSCON_PDSLEEPCFG_RESERVED_Msk = 0xffffff80

	// PDAWAKECFG: Power-down states for wake-up from deep-sleep
	// Position of IRCOUT_PD field.
	SYSCON_PDAWAKECFG_IRCOUT_PD_Pos = 0x0
	// Bit mask of IRCOUT_PD field.
	SYSCON_PDAWAKECFG_IRCOUT_PD_Msk = 0x1
	// Bit IRCOUT_PD.
	SYSCON_PDAWAKECFG_IRCOUT_PD = 0x1
	// Powered
	SYSCON_PDAWAKECFG_IRCOUT_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_IRCOUT_PD_POWERED_DOWN = 0x1
	// Position of IRC_PD field.
	SYSCON_PDAWAKECFG_IRC_PD_Pos = 0x1
	// Bit mask of IRC_PD field.
	SYSCON_PDAWAKECFG_IRC_PD_Msk = 0x2
	// Bit IRC_PD.
	SYSCON_PDAWAKECFG_IRC_PD = 0x2
	// Powered
	SYSCON_PDAWAKECFG_IRC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_IRC_PD_POWERED_DOWN = 0x1
	// Position of FLASH_PD field.
	SYSCON_PDAWAKECFG_FLASH_PD_Pos = 0x2
	// Bit mask of FLASH_PD field.
	SYSCON_PDAWAKECFG_FLASH_PD_Msk = 0x4
	// Bit FLASH_PD.
	SYSCON_PDAWAKECFG_FLASH_PD = 0x4
	// Powered
	SYSCON_PDAWAKECFG_FLASH_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_FLASH_PD_POWERED_DOWN = 0x1
	// Position of BOD_PD field.
	SYSCON_PDAWAKECFG_BOD_PD_Pos = 0x3
	// Bit mask of BOD_PD field.
	SYSCON_PDAWAKECFG_BOD_PD_Msk = 0x8
	// Bit BOD_PD.
	SYSCON_PDAWAKECFG_BOD_PD = 0x8
	// Powered
	SYSCON_PDAWAKECFG_BOD_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_BOD_PD_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x10
	// Bit RESERVED.
	SYSCON_PDAWAKECFG_RESERVED = 0x10
	// Position of SYSOSC_PD field.
	SYSCON_PDAWAKECFG_SYSOSC_PD_Pos = 0x5
	// Bit mask of SYSOSC_PD field.
	SYSCON_PDAWAKECFG_SYSOSC_PD_Msk = 0x20
	// Bit SYSOSC_PD.
	SYSCON_PDAWAKECFG_SYSOSC_PD = 0x20
	// Powered
	SYSCON_PDAWAKECFG_SYSOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_SYSOSC_PD_POWERED_DOWN = 0x1
	// Position of WDTOSC_PD field.
	SYSCON_PDAWAKECFG_WDTOSC_PD_Pos = 0x6
	// Bit mask of WDTOSC_PD field.
	SYSCON_PDAWAKECFG_WDTOSC_PD_Msk = 0x40
	// Bit WDTOSC_PD.
	SYSCON_PDAWAKECFG_WDTOSC_PD = 0x40
	// Powered
	SYSCON_PDAWAKECFG_WDTOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_WDTOSC_PD_POWERED_DOWN = 0x1
	// Position of SYSPLL_PD field.
	SYSCON_PDAWAKECFG_SYSPLL_PD_Pos = 0x7
	// Bit mask of SYSPLL_PD field.
	SYSCON_PDAWAKECFG_SYSPLL_PD_Msk = 0x80
	// Bit SYSPLL_PD.
	SYSCON_PDAWAKECFG_SYSPLL_PD = 0x80
	// Powered
	SYSCON_PDAWAKECFG_SYSPLL_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_SYSPLL_PD_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0xf00
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0x7000
	// Position of ACMP field.
	SYSCON_PDAWAKECFG_ACMP_Pos = 0xf
	// Bit mask of ACMP field.
	SYSCON_PDAWAKECFG_ACMP_Msk = 0x8000
	// Bit ACMP.
	SYSCON_PDAWAKECFG_ACMP = 0x8000
	// Powered
	SYSCON_PDAWAKECFG_ACMP_POWERED = 0x0
	// Powered down
	SYSCON_PDAWAKECFG_ACMP_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SYSCON_PDAWAKECFG_RESERVED_Msk = 0xffff0000

	// PDRUNCFG: Power configuration register
	// Position of IRCOUT_PD field.
	SYSCON_PDRUNCFG_IRCOUT_PD_Pos = 0x0
	// Bit mask of IRCOUT_PD field.
	SYSCON_PDRUNCFG_IRCOUT_PD_Msk = 0x1
	// Bit IRCOUT_PD.
	SYSCON_PDRUNCFG_IRCOUT_PD = 0x1
	// Powered
	SYSCON_PDRUNCFG_IRCOUT_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_IRCOUT_PD_POWERED_DOWN = 0x1
	// Position of IRC_PD field.
	SYSCON_PDRUNCFG_IRC_PD_Pos = 0x1
	// Bit mask of IRC_PD field.
	SYSCON_PDRUNCFG_IRC_PD_Msk = 0x2
	// Bit IRC_PD.
	SYSCON_PDRUNCFG_IRC_PD = 0x2
	// Powered
	SYSCON_PDRUNCFG_IRC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_IRC_PD_POWERED_DOWN = 0x1
	// Position of FLASH_PD field.
	SYSCON_PDRUNCFG_FLASH_PD_Pos = 0x2
	// Bit mask of FLASH_PD field.
	SYSCON_PDRUNCFG_FLASH_PD_Msk = 0x4
	// Bit FLASH_PD.
	SYSCON_PDRUNCFG_FLASH_PD = 0x4
	// Powered
	SYSCON_PDRUNCFG_FLASH_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_FLASH_PD_POWERED_DOWN = 0x1
	// Position of BOD_PD field.
	SYSCON_PDRUNCFG_BOD_PD_Pos = 0x3
	// Bit mask of BOD_PD field.
	SYSCON_PDRUNCFG_BOD_PD_Msk = 0x8
	// Bit BOD_PD.
	SYSCON_PDRUNCFG_BOD_PD = 0x8
	// Powered
	SYSCON_PDRUNCFG_BOD_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_BOD_PD_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x10
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x10
	// Position of SYSOSC_PD field.
	SYSCON_PDRUNCFG_SYSOSC_PD_Pos = 0x5
	// Bit mask of SYSOSC_PD field.
	SYSCON_PDRUNCFG_SYSOSC_PD_Msk = 0x20
	// Bit SYSOSC_PD.
	SYSCON_PDRUNCFG_SYSOSC_PD = 0x20
	// Powered
	SYSCON_PDRUNCFG_SYSOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_SYSOSC_PD_POWERED_DOWN = 0x1
	// Position of WDTOSC_PD field.
	SYSCON_PDRUNCFG_WDTOSC_PD_Pos = 0x6
	// Bit mask of WDTOSC_PD field.
	SYSCON_PDRUNCFG_WDTOSC_PD_Msk = 0x40
	// Bit WDTOSC_PD.
	SYSCON_PDRUNCFG_WDTOSC_PD = 0x40
	// Powered
	SYSCON_PDRUNCFG_WDTOSC_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_WDTOSC_PD_POWERED_DOWN = 0x1
	// Position of SYSPLL_PD field.
	SYSCON_PDRUNCFG_SYSPLL_PD_Pos = 0x7
	// Bit mask of SYSPLL_PD field.
	SYSCON_PDRUNCFG_SYSPLL_PD_Msk = 0x80
	// Bit SYSPLL_PD.
	SYSCON_PDRUNCFG_SYSPLL_PD = 0x80
	// Powered
	SYSCON_PDRUNCFG_SYSPLL_PD_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_SYSPLL_PD_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0xf00
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x7000
	// Position of ACMP field.
	SYSCON_PDRUNCFG_ACMP_Pos = 0xf
	// Bit mask of ACMP field.
	SYSCON_PDRUNCFG_ACMP_Msk = 0x8000
	// Bit ACMP.
	SYSCON_PDRUNCFG_ACMP = 0x8000
	// Powered
	SYSCON_PDRUNCFG_ACMP_POWERED = 0x0
	// Powered down
	SYSCON_PDRUNCFG_ACMP_POWERED_DOWN = 0x1
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0xffff0000

	// DEVICE_ID: Device ID
	// Position of DEVICEID field.
	SYSCON_DEVICE_ID_DEVICEID_Pos = 0x0
	// Bit mask of DEVICEID field.
	SYSCON_DEVICE_ID_DEVICEID_Msk = 0xffffffff
)

// Constants for I2C: I2C-bus interface
const (
	// CFG: Configuration for shared functions.
	// Position of MSTEN field.
	I2C_CFG_MSTEN_Pos = 0x0
	// Bit mask of MSTEN field.
	I2C_CFG_MSTEN_Msk = 0x1
	// Bit MSTEN.
	I2C_CFG_MSTEN = 0x1
	// Disabled. The I2C Master function is disabled.
	I2C_CFG_MSTEN_DISABLED_THE_I2C_MA = 0x0
	// Enabled. The I2C Master function is enabled.
	I2C_CFG_MSTEN_ENABLED_THE_I2C_MAS = 0x1
	// Position of SLVEN field.
	I2C_CFG_SLVEN_Pos = 0x1
	// Bit mask of SLVEN field.
	I2C_CFG_SLVEN_Msk = 0x2
	// Bit SLVEN.
	I2C_CFG_SLVEN = 0x2
	// Disabled. The I2C slave function is disabled.
	I2C_CFG_SLVEN_DISABLED_THE_I2C_SL = 0x0
	// Enabled. The I2C slave function is enabled.
	I2C_CFG_SLVEN_ENABLED_THE_I2C_SLA = 0x1
	// Position of MONEN field.
	I2C_CFG_MONEN_Pos = 0x2
	// Bit mask of MONEN field.
	I2C_CFG_MONEN_Msk = 0x4
	// Bit MONEN.
	I2C_CFG_MONEN = 0x4
	// Disabled. The I2C monitor function is disabled.
	I2C_CFG_MONEN_DISABLED_THE_I2C_MO = 0x0
	// Enabled. The I2C monitor function is enabled.
	I2C_CFG_MONEN_ENABLED_THE_I2C_MON = 0x1
	// Position of TIMEOUTEN field.
	I2C_CFG_TIMEOUTEN_Pos = 0x3
	// Bit mask of TIMEOUTEN field.
	I2C_CFG_TIMEOUTEN_Msk = 0x8
	// Bit TIMEOUTEN.
	I2C_CFG_TIMEOUTEN = 0x8
	// Disabled. Time-out function is disabled.
	I2C_CFG_TIMEOUTEN_DISABLED_TIME_OUT_F = 0x0
	// Enabled. Time-out function is enabled. Both types of time-out flags will be generated and will cause interrupts if they are enabled. Typically, only one timeout will be used in a system.
	I2C_CFG_TIMEOUTEN_ENABLED_TIME_OUT_FU = 0x1
	// Position of MONCLKSTR field.
	I2C_CFG_MONCLKSTR_Pos = 0x4
	// Bit mask of MONCLKSTR field.
	I2C_CFG_MONCLKSTR_Msk = 0x10
	// Bit MONCLKSTR.
	I2C_CFG_MONCLKSTR = 0x10
	// Disabled. The monitor function will not perform clock stretching. Software may not always be able to read data provided by the monitor function before it is overwritten. This mode may be used when non-invasive monitoring is critical.
	I2C_CFG_MONCLKSTR_DISABLED_THE_MONITO = 0x0
	// Enabled. The monitor function will perform clock stretching in order to ensure that software can read all incoming data supplied by the monitor function.
	I2C_CFG_MONCLKSTR_ENABLED_THE_MONITOR = 0x1
	// Position of RESERVED field.
	I2C_CFG_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	I2C_CFG_RESERVED_Msk = 0xffffffe0

	// STAT: Status register for Master, Slave, and Monitor functions.
	// Position of MSTPENDING field.
	I2C_STAT_MSTPENDING_Pos = 0x0
	// Bit mask of MSTPENDING field.
	I2C_STAT_MSTPENDING_Msk = 0x1
	// Bit MSTPENDING.
	I2C_STAT_MSTPENDING = 0x1
	// No service needed. The Master function does not currently need service.
	I2C_STAT_MSTPENDING_NO_SERVICE_NEEDED_T = 0x0
	// Service needed. The Master function needs service. Information on what is needed can be found in the adjacent MSTSTATE field.
	I2C_STAT_MSTPENDING_SERVICE_NEEDED_THE_ = 0x1
	// Position of MSTSTATE field.
	I2C_STAT_MSTSTATE_Pos = 0x1
	// Bit mask of MSTSTATE field.
	I2C_STAT_MSTSTATE_Msk = 0xe
	// Idle. The Master function is available to be used for a new transaction.
	I2C_STAT_MSTSTATE_IDLE_THE_MASTER_FUN = 0x0
	// Receive ready. Received data available (Master Receiver mode). Address plus Read was previously sent and Acknowledged by slave.
	I2C_STAT_MSTSTATE_RECEIVE_READY_RECEI = 0x1
	// Transmit ready. Data can be transmitted (Master Transmitter mode). Address plus Write was previously sent and Acknowledged by slave.
	I2C_STAT_MSTSTATE_TRANSMIT_READY_DATA = 0x2
	// Address. Slave Nacked address.
	I2C_STAT_MSTSTATE_ADDRESS_SLAVE_NACKE = 0x3
	// Data. Slave Nacked transmitted data.
	I2C_STAT_MSTSTATE_DATA_SLAVE_NACKED_T = 0x4
	// Position of MSTARBLOSS field.
	I2C_STAT_MSTARBLOSS_Pos = 0x4
	// Bit mask of MSTARBLOSS field.
	I2C_STAT_MSTARBLOSS_Msk = 0x10
	// Bit MSTARBLOSS.
	I2C_STAT_MSTARBLOSS = 0x10
	// No loss. No Arbitration Loss has occurred.
	I2C_STAT_MSTARBLOSS_NO_LOSS_NO_ARBITRAT = 0x0
	// Arbitration loss. The Master function has experienced an Arbitration Loss. At this point, the Master function has already stopped driving the bus and gone to an idle state. Software can respond by doing nothing, or by sending a Start in order to attempt to gain control of the bus when it next becomes idle.
	I2C_STAT_MSTARBLOSS_ARBITRATION_LOSS_TH = 0x1
	// Position of RESERVED field.
	I2C_STAT_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	I2C_STAT_RESERVED_Msk = 0x20
	// Bit RESERVED.
	I2C_STAT_RESERVED = 0x20
	// Position of MSTSTSTPERR field.
	I2C_STAT_MSTSTSTPERR_Pos = 0x6
	// Bit mask of MSTSTSTPERR field.
	I2C_STAT_MSTSTSTPERR_Msk = 0x40
	// Bit MSTSTSTPERR.
	I2C_STAT_MSTSTSTPERR = 0x40
	// No Start/Stop Error has occurred.
	I2C_STAT_MSTSTSTPERR_NO_STARTSTOP_ERROR_ = 0x0
	// Start/stop error has occurred. The Master function has experienced a Start/Stop Error. A Start or Stop was detected at a time when it is not allowed by the I2C specification. The Master interface has stopped driving the bus and gone to an idle state, no action is required. A request for a Start could be made, or software could attempt to insure that the bus has not stalled.
	I2C_STAT_MSTSTSTPERR_STARTSTOP_ERROR_HAS = 0x1
	// Position of RESERVED field.
	I2C_STAT_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C_STAT_RESERVED_Msk = 0x80
	// Bit RESERVED.
	I2C_STAT_RESERVED = 0x80
	// Position of SLVPENDING field.
	I2C_STAT_SLVPENDING_Pos = 0x8
	// Bit mask of SLVPENDING field.
	I2C_STAT_SLVPENDING_Msk = 0x100
	// Bit SLVPENDING.
	I2C_STAT_SLVPENDING = 0x100
	// No service needed. The Slave function does not currently need service.
	I2C_STAT_SLVPENDING_NO_SERVICE_NEEDED_T = 0x0
	// Service needed. The Slave function needs service. Information on what is needed can be found in the adjacent SLVSTATE field.
	I2C_STAT_SLVPENDING_SERVICE_NEEDED_THE_ = 0x1
	// Position of SLVSTATE field.
	I2C_STAT_SLVSTATE_Pos = 0x9
	// Bit mask of SLVSTATE field.
	I2C_STAT_SLVSTATE_Msk = 0x600
	// Received. Address plus R/W received. At least one of the four slave addresses has been matched by hardware.
	I2C_STAT_SLVSTATE_RECEIVED_ADDRESS_PL = 0x0
	// Data available. Received data is available (Slave Receiver mode).
	I2C_STAT_SLVSTATE_DATA_AVAILABLE_RECE = 0x1
	// Data ready for transmit. Data can be transmitted (Slave Transmitter mode).
	I2C_STAT_SLVSTATE_DATA_READY_FOR_TRANS = 0x2
	// Reserved.
	I2C_STAT_SLVSTATE_RESERVED_ = 0x3
	// Position of SLVNOTSTR field.
	I2C_STAT_SLVNOTSTR_Pos = 0xb
	// Bit mask of SLVNOTSTR field.
	I2C_STAT_SLVNOTSTR_Msk = 0x800
	// Bit SLVNOTSTR.
	I2C_STAT_SLVNOTSTR = 0x800
	// Stretching. The slave function is currently stretching the I2C bus clock. Deep-Sleep or Power-down mode cannot be entered at this time.
	I2C_STAT_SLVNOTSTR_STRETCHING_THE_SLAV = 0x0
	// Not stretching. The slave function is not currently stretching the I 2C bus clock. Deep-sleep or Power-down mode could be entered at this time.
	I2C_STAT_SLVNOTSTR_NOT_STRETCHING_THE_ = 0x1
	// Position of SLVIDX field.
	I2C_STAT_SLVIDX_Pos = 0xc
	// Bit mask of SLVIDX field.
	I2C_STAT_SLVIDX_Msk = 0x3000
	// Slave address 0 was matched.
	I2C_STAT_SLVIDX_SLAVE_ADDRESS_0_WAS_ = 0x0
	// Slave address 1 was matched.
	I2C_STAT_SLVIDX_SLAVE_ADDRESS_1_WAS_ = 0x1
	// Slave address 2 was matched.
	I2C_STAT_SLVIDX_SLAVE_ADDRESS_2_WAS_ = 0x2
	// Slave address 3 was matched.
	I2C_STAT_SLVIDX_SLAVE_ADDRESS_3_WAS_ = 0x3
	// Position of SLVSEL field.
	I2C_STAT_SLVSEL_Pos = 0xe
	// Bit mask of SLVSEL field.
	I2C_STAT_SLVSEL_Msk = 0x4000
	// Bit SLVSEL.
	I2C_STAT_SLVSEL = 0x4000
	// Not selected. The Slave function is not currently selected.
	I2C_STAT_SLVSEL_NOT_SELECTED_THE_SL = 0x0
	// Selected. The Slave function is currently selected.
	I2C_STAT_SLVSEL_SELECTED_THE_SLAVE_ = 0x1
	// Position of SLVDESEL field.
	I2C_STAT_SLVDESEL_Pos = 0xf
	// Bit mask of SLVDESEL field.
	I2C_STAT_SLVDESEL_Msk = 0x8000
	// Bit SLVDESEL.
	I2C_STAT_SLVDESEL = 0x8000
	// Not deselected. The Slave function has not become deselected. This does not mean that it is currently selected. That information can be found in the SLVSEL flag.
	I2C_STAT_SLVDESEL_NOT_DESELECTED_THE_ = 0x0
	// Deselected. The Slave function has become deselected. This is specifically caused by the SLVSEL flag changing from 1 to 0. See the description of SLVSEL for details on when that event occurs.
	I2C_STAT_SLVDESEL_DESELECTED_THE_SLAV = 0x1
	// Position of MONRDY field.
	I2C_STAT_MONRDY_Pos = 0x10
	// Bit mask of MONRDY field.
	I2C_STAT_MONRDY_Msk = 0x10000
	// Bit MONRDY.
	I2C_STAT_MONRDY = 0x10000
	// No data. The Monitor function does not currently have data available.
	I2C_STAT_MONRDY_NO_DATA_THE_MONITOR = 0x0
	// Data waiting. The Monitor function has data waiting to be read.
	I2C_STAT_MONRDY_DATA_WAITING_THE_MO = 0x1
	// Position of MONOV field.
	I2C_STAT_MONOV_Pos = 0x11
	// Bit mask of MONOV field.
	I2C_STAT_MONOV_Msk = 0x20000
	// Bit MONOV.
	I2C_STAT_MONOV = 0x20000
	// No overrun. Monitor data has not overrun.
	I2C_STAT_MONOV_NO_OVERRUN_MONITOR_ = 0x0
	// Overrun. A Monitor data overrun has occurred. This can only happen when Monitor clock stretching not enabled via the MONCLKSTR bit in the CFG register. Writing 1 to this bit clears the flag.
	I2C_STAT_MONOV_OVERRUN_A_MONITOR_D = 0x1
	// Position of MONACTIVE field.
	I2C_STAT_MONACTIVE_Pos = 0x12
	// Bit mask of MONACTIVE field.
	I2C_STAT_MONACTIVE_Msk = 0x40000
	// Bit MONACTIVE.
	I2C_STAT_MONACTIVE = 0x40000
	// Inactive. The Monitor function considers the I2C bus to be inactive.
	I2C_STAT_MONACTIVE_INACTIVE_THE_MONITO = 0x0
	// Active. The Monitor function considers the I2C bus to be active.
	I2C_STAT_MONACTIVE_ACTIVE_THE_MONITOR_ = 0x1
	// Position of MONIDLE field.
	I2C_STAT_MONIDLE_Pos = 0x13
	// Bit mask of MONIDLE field.
	I2C_STAT_MONIDLE_Msk = 0x80000
	// Bit MONIDLE.
	I2C_STAT_MONIDLE = 0x80000
	// Not idle. The I2C bus is not idle, or this flag has been cleared by software.
	I2C_STAT_MONIDLE_NOT_IDLE_THE_I2C_BU = 0x0
	// Idle. The I2C bus has gone idle at least once since the last time this flag was cleared by software.
	I2C_STAT_MONIDLE_IDLE_THE_I2C_BUS_HA = 0x1
	// Position of RESERVED field.
	I2C_STAT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	I2C_STAT_RESERVED_Msk = 0xf00000
	// Position of EVENTTIMEOUT field.
	I2C_STAT_EVENTTIMEOUT_Pos = 0x18
	// Bit mask of EVENTTIMEOUT field.
	I2C_STAT_EVENTTIMEOUT_Msk = 0x1000000
	// Bit EVENTTIMEOUT.
	I2C_STAT_EVENTTIMEOUT = 0x1000000
	// No time-out. I2C bus events have not caused a timeout.
	I2C_STAT_EVENTTIMEOUT_NO_TIME_OUT_I2C_BUS = 0x0
	// Event time-out. The time between I2C bus events has been longer than the time specified by the I2C Timeout register.
	I2C_STAT_EVENTTIMEOUT_EVENT_TIME_OUT_THE_ = 0x1
	// Position of SCLTIMEOUT field.
	I2C_STAT_SCLTIMEOUT_Pos = 0x19
	// Bit mask of SCLTIMEOUT field.
	I2C_STAT_SCLTIMEOUT_Msk = 0x2000000
	// Bit SCLTIMEOUT.
	I2C_STAT_SCLTIMEOUT = 0x2000000
	// No time-out. SCL low time has not caused a timeout.
	I2C_STAT_SCLTIMEOUT_NO_TIME_OUT_SCL_LOW = 0x0
	// Time-out. SCL low time has caused a timeout.
	I2C_STAT_SCLTIMEOUT_TIME_OUT_SCL_LOW_TI = 0x1
	// Position of RESERVED field.
	I2C_STAT_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	I2C_STAT_RESERVED_Msk = 0xfc000000

	// INTENSET: Interrupt Enable Set and read register.
	// Position of MSTPENDINGEN field.
	I2C_INTENSET_MSTPENDINGEN_Pos = 0x0
	// Bit mask of MSTPENDINGEN field.
	I2C_INTENSET_MSTPENDINGEN_Msk = 0x1
	// Bit MSTPENDINGEN.
	I2C_INTENSET_MSTPENDINGEN = 0x1
	// Position of RESERVED field.
	I2C_INTENSET_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	I2C_INTENSET_RESERVED_Msk = 0xe
	// Position of MSTARBLOSSEN field.
	I2C_INTENSET_MSTARBLOSSEN_Pos = 0x4
	// Bit mask of MSTARBLOSSEN field.
	I2C_INTENSET_MSTARBLOSSEN_Msk = 0x10
	// Bit MSTARBLOSSEN.
	I2C_INTENSET_MSTARBLOSSEN = 0x10
	// Position of RESERVED field.
	I2C_INTENSET_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	I2C_INTENSET_RESERVED_Msk = 0x20
	// Bit RESERVED.
	I2C_INTENSET_RESERVED = 0x20
	// Position of MSTSTSTPERREN field.
	I2C_INTENSET_MSTSTSTPERREN_Pos = 0x6
	// Bit mask of MSTSTSTPERREN field.
	I2C_INTENSET_MSTSTSTPERREN_Msk = 0x40
	// Bit MSTSTSTPERREN.
	I2C_INTENSET_MSTSTSTPERREN = 0x40
	// Position of RESERVED field.
	I2C_INTENSET_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C_INTENSET_RESERVED_Msk = 0x80
	// Bit RESERVED.
	I2C_INTENSET_RESERVED = 0x80
	// Position of SLVPENDINGEN field.
	I2C_INTENSET_SLVPENDINGEN_Pos = 0x8
	// Bit mask of SLVPENDINGEN field.
	I2C_INTENSET_SLVPENDINGEN_Msk = 0x100
	// Bit SLVPENDINGEN.
	I2C_INTENSET_SLVPENDINGEN = 0x100
	// Position of RESERVED field.
	I2C_INTENSET_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	I2C_INTENSET_RESERVED_Msk = 0x600
	// Position of SLVNOTSTREN field.
	I2C_INTENSET_SLVNOTSTREN_Pos = 0xb
	// Bit mask of SLVNOTSTREN field.
	I2C_INTENSET_SLVNOTSTREN_Msk = 0x800
	// Bit SLVNOTSTREN.
	I2C_INTENSET_SLVNOTSTREN = 0x800
	// Position of RESERVED field.
	I2C_INTENSET_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	I2C_INTENSET_RESERVED_Msk = 0x7000
	// Position of SLVDESELEN field.
	I2C_INTENSET_SLVDESELEN_Pos = 0xf
	// Bit mask of SLVDESELEN field.
	I2C_INTENSET_SLVDESELEN_Msk = 0x8000
	// Bit SLVDESELEN.
	I2C_INTENSET_SLVDESELEN = 0x8000
	// Position of MONRDYEN field.
	I2C_INTENSET_MONRDYEN_Pos = 0x10
	// Bit mask of MONRDYEN field.
	I2C_INTENSET_MONRDYEN_Msk = 0x10000
	// Bit MONRDYEN.
	I2C_INTENSET_MONRDYEN = 0x10000
	// Position of MONOVEN field.
	I2C_INTENSET_MONOVEN_Pos = 0x11
	// Bit mask of MONOVEN field.
	I2C_INTENSET_MONOVEN_Msk = 0x20000
	// Bit MONOVEN.
	I2C_INTENSET_MONOVEN = 0x20000
	// Position of RESERVED field.
	I2C_INTENSET_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	I2C_INTENSET_RESERVED_Msk = 0x40000
	// Bit RESERVED.
	I2C_INTENSET_RESERVED = 0x40000
	// Position of MONIDLEEN field.
	I2C_INTENSET_MONIDLEEN_Pos = 0x13
	// Bit mask of MONIDLEEN field.
	I2C_INTENSET_MONIDLEEN_Msk = 0x80000
	// Bit MONIDLEEN.
	I2C_INTENSET_MONIDLEEN = 0x80000
	// Position of RESERVED field.
	I2C_INTENSET_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	I2C_INTENSET_RESERVED_Msk = 0xf00000
	// Position of EVENTTIMEOUTEN field.
	I2C_INTENSET_EVENTTIMEOUTEN_Pos = 0x18
	// Bit mask of EVENTTIMEOUTEN field.
	I2C_INTENSET_EVENTTIMEOUTEN_Msk = 0x1000000
	// Bit EVENTTIMEOUTEN.
	I2C_INTENSET_EVENTTIMEOUTEN = 0x1000000
	// Position of SCLTIMEOUTEN field.
	I2C_INTENSET_SCLTIMEOUTEN_Pos = 0x19
	// Bit mask of SCLTIMEOUTEN field.
	I2C_INTENSET_SCLTIMEOUTEN_Msk = 0x2000000
	// Bit SCLTIMEOUTEN.
	I2C_INTENSET_SCLTIMEOUTEN = 0x2000000
	// Position of RESERVED field.
	I2C_INTENSET_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	I2C_INTENSET_RESERVED_Msk = 0xfc000000

	// INTENCLR: Interrupt Enable Clear register.
	// Position of MSTPENDINGCLR field.
	I2C_INTENCLR_MSTPENDINGCLR_Pos = 0x0
	// Bit mask of MSTPENDINGCLR field.
	I2C_INTENCLR_MSTPENDINGCLR_Msk = 0x1
	// Bit MSTPENDINGCLR.
	I2C_INTENCLR_MSTPENDINGCLR = 0x1
	// Position of RESERVED field.
	I2C_INTENCLR_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	I2C_INTENCLR_RESERVED_Msk = 0xe
	// Position of MSTARBLOSSCLR field.
	I2C_INTENCLR_MSTARBLOSSCLR_Pos = 0x4
	// Bit mask of MSTARBLOSSCLR field.
	I2C_INTENCLR_MSTARBLOSSCLR_Msk = 0x10
	// Bit MSTARBLOSSCLR.
	I2C_INTENCLR_MSTARBLOSSCLR = 0x10
	// Position of RESERVED field.
	I2C_INTENCLR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	I2C_INTENCLR_RESERVED_Msk = 0x20
	// Bit RESERVED.
	I2C_INTENCLR_RESERVED = 0x20
	// Position of MSTSTSTPERRCLR field.
	I2C_INTENCLR_MSTSTSTPERRCLR_Pos = 0x6
	// Bit mask of MSTSTSTPERRCLR field.
	I2C_INTENCLR_MSTSTSTPERRCLR_Msk = 0x40
	// Bit MSTSTSTPERRCLR.
	I2C_INTENCLR_MSTSTSTPERRCLR = 0x40
	// Position of RESERVED field.
	I2C_INTENCLR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C_INTENCLR_RESERVED_Msk = 0x80
	// Bit RESERVED.
	I2C_INTENCLR_RESERVED = 0x80
	// Position of SLVPENDINGCLR field.
	I2C_INTENCLR_SLVPENDINGCLR_Pos = 0x8
	// Bit mask of SLVPENDINGCLR field.
	I2C_INTENCLR_SLVPENDINGCLR_Msk = 0x100
	// Bit SLVPENDINGCLR.
	I2C_INTENCLR_SLVPENDINGCLR = 0x100
	// Position of RESERVED field.
	I2C_INTENCLR_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	I2C_INTENCLR_RESERVED_Msk = 0x600
	// Position of SLVNOTSTRCLR field.
	I2C_INTENCLR_SLVNOTSTRCLR_Pos = 0xb
	// Bit mask of SLVNOTSTRCLR field.
	I2C_INTENCLR_SLVNOTSTRCLR_Msk = 0x800
	// Bit SLVNOTSTRCLR.
	I2C_INTENCLR_SLVNOTSTRCLR = 0x800
	// Position of RESERVED field.
	I2C_INTENCLR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	I2C_INTENCLR_RESERVED_Msk = 0x7000
	// Position of SLVDESELCLR field.
	I2C_INTENCLR_SLVDESELCLR_Pos = 0xf
	// Bit mask of SLVDESELCLR field.
	I2C_INTENCLR_SLVDESELCLR_Msk = 0x8000
	// Bit SLVDESELCLR.
	I2C_INTENCLR_SLVDESELCLR = 0x8000
	// Position of MONRDYCLR field.
	I2C_INTENCLR_MONRDYCLR_Pos = 0x10
	// Bit mask of MONRDYCLR field.
	I2C_INTENCLR_MONRDYCLR_Msk = 0x10000
	// Bit MONRDYCLR.
	I2C_INTENCLR_MONRDYCLR = 0x10000
	// Position of MONOVCLR field.
	I2C_INTENCLR_MONOVCLR_Pos = 0x11
	// Bit mask of MONOVCLR field.
	I2C_INTENCLR_MONOVCLR_Msk = 0x20000
	// Bit MONOVCLR.
	I2C_INTENCLR_MONOVCLR = 0x20000
	// Position of RESERVED field.
	I2C_INTENCLR_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	I2C_INTENCLR_RESERVED_Msk = 0x40000
	// Bit RESERVED.
	I2C_INTENCLR_RESERVED = 0x40000
	// Position of MONIDLECLR field.
	I2C_INTENCLR_MONIDLECLR_Pos = 0x13
	// Bit mask of MONIDLECLR field.
	I2C_INTENCLR_MONIDLECLR_Msk = 0x80000
	// Bit MONIDLECLR.
	I2C_INTENCLR_MONIDLECLR = 0x80000
	// Position of RESERVED field.
	I2C_INTENCLR_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	I2C_INTENCLR_RESERVED_Msk = 0xf00000
	// Position of EVENTTIMEOUTCLR field.
	I2C_INTENCLR_EVENTTIMEOUTCLR_Pos = 0x18
	// Bit mask of EVENTTIMEOUTCLR field.
	I2C_INTENCLR_EVENTTIMEOUTCLR_Msk = 0x1000000
	// Bit EVENTTIMEOUTCLR.
	I2C_INTENCLR_EVENTTIMEOUTCLR = 0x1000000
	// Position of SCLTIMEOUTCLR field.
	I2C_INTENCLR_SCLTIMEOUTCLR_Pos = 0x19
	// Bit mask of SCLTIMEOUTCLR field.
	I2C_INTENCLR_SCLTIMEOUTCLR_Msk = 0x2000000
	// Bit SCLTIMEOUTCLR.
	I2C_INTENCLR_SCLTIMEOUTCLR = 0x2000000
	// Position of RESERVED field.
	I2C_INTENCLR_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	I2C_INTENCLR_RESERVED_Msk = 0xfc000000

	// TIMEOUT: Time-out value register.
	// Position of TOMIN field.
	I2C_TIMEOUT_TOMIN_Pos = 0x0
	// Bit mask of TOMIN field.
	I2C_TIMEOUT_TOMIN_Msk = 0xf
	// Position of TO field.
	I2C_TIMEOUT_TO_Pos = 0x4
	// Bit mask of TO field.
	I2C_TIMEOUT_TO_Msk = 0xfff0
	// Position of RESERVED field.
	I2C_TIMEOUT_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	I2C_TIMEOUT_RESERVED_Msk = 0xffff0000

	// DIV: Clock pre-divider for the entire I2C block. This determines what time increments are used for the MSTTIME and SLVTIME registers.
	// Position of DIVVAL field.
	I2C_DIV_DIVVAL_Pos = 0x0
	// Bit mask of DIVVAL field.
	I2C_DIV_DIVVAL_Msk = 0xffff
	// Position of RESERVED field.
	I2C_DIV_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	I2C_DIV_RESERVED_Msk = 0xffff0000

	// INTSTAT: Interrupt Status register for Master, Slave, and Monitor functions.
	// Position of MSTPENDING field.
	I2C_INTSTAT_MSTPENDING_Pos = 0x0
	// Bit mask of MSTPENDING field.
	I2C_INTSTAT_MSTPENDING_Msk = 0x1
	// Bit MSTPENDING.
	I2C_INTSTAT_MSTPENDING = 0x1
	// Position of RESERVED field.
	I2C_INTSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	I2C_INTSTAT_RESERVED_Msk = 0xe
	// Position of MSTARBLOSS field.
	I2C_INTSTAT_MSTARBLOSS_Pos = 0x4
	// Bit mask of MSTARBLOSS field.
	I2C_INTSTAT_MSTARBLOSS_Msk = 0x10
	// Bit MSTARBLOSS.
	I2C_INTSTAT_MSTARBLOSS = 0x10
	// Position of RESERVED field.
	I2C_INTSTAT_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	I2C_INTSTAT_RESERVED_Msk = 0x20
	// Bit RESERVED.
	I2C_INTSTAT_RESERVED = 0x20
	// Position of MSTSTSTPERR field.
	I2C_INTSTAT_MSTSTSTPERR_Pos = 0x6
	// Bit mask of MSTSTSTPERR field.
	I2C_INTSTAT_MSTSTSTPERR_Msk = 0x40
	// Bit MSTSTSTPERR.
	I2C_INTSTAT_MSTSTSTPERR = 0x40
	// Position of RESERVED field.
	I2C_INTSTAT_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C_INTSTAT_RESERVED_Msk = 0x80
	// Bit RESERVED.
	I2C_INTSTAT_RESERVED = 0x80
	// Position of SLVPENDING field.
	I2C_INTSTAT_SLVPENDING_Pos = 0x8
	// Bit mask of SLVPENDING field.
	I2C_INTSTAT_SLVPENDING_Msk = 0x100
	// Bit SLVPENDING.
	I2C_INTSTAT_SLVPENDING = 0x100
	// Position of RESERVED field.
	I2C_INTSTAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	I2C_INTSTAT_RESERVED_Msk = 0x600
	// Position of SLVNOTSTR field.
	I2C_INTSTAT_SLVNOTSTR_Pos = 0xb
	// Bit mask of SLVNOTSTR field.
	I2C_INTSTAT_SLVNOTSTR_Msk = 0x800
	// Bit SLVNOTSTR.
	I2C_INTSTAT_SLVNOTSTR = 0x800
	// Position of RESERVED field.
	I2C_INTSTAT_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	I2C_INTSTAT_RESERVED_Msk = 0x7000
	// Position of SLVDESEL field.
	I2C_INTSTAT_SLVDESEL_Pos = 0xf
	// Bit mask of SLVDESEL field.
	I2C_INTSTAT_SLVDESEL_Msk = 0x8000
	// Bit SLVDESEL.
	I2C_INTSTAT_SLVDESEL = 0x8000
	// Position of MONRDY field.
	I2C_INTSTAT_MONRDY_Pos = 0x10
	// Bit mask of MONRDY field.
	I2C_INTSTAT_MONRDY_Msk = 0x10000
	// Bit MONRDY.
	I2C_INTSTAT_MONRDY = 0x10000
	// Position of MONOV field.
	I2C_INTSTAT_MONOV_Pos = 0x11
	// Bit mask of MONOV field.
	I2C_INTSTAT_MONOV_Msk = 0x20000
	// Bit MONOV.
	I2C_INTSTAT_MONOV = 0x20000
	// Position of RESERVED field.
	I2C_INTSTAT_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	I2C_INTSTAT_RESERVED_Msk = 0x40000
	// Bit RESERVED.
	I2C_INTSTAT_RESERVED = 0x40000
	// Position of MONIDLE field.
	I2C_INTSTAT_MONIDLE_Pos = 0x13
	// Bit mask of MONIDLE field.
	I2C_INTSTAT_MONIDLE_Msk = 0x80000
	// Bit MONIDLE.
	I2C_INTSTAT_MONIDLE = 0x80000
	// Position of RESERVED field.
	I2C_INTSTAT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	I2C_INTSTAT_RESERVED_Msk = 0xf00000
	// Position of EVENTTIMEOUT field.
	I2C_INTSTAT_EVENTTIMEOUT_Pos = 0x18
	// Bit mask of EVENTTIMEOUT field.
	I2C_INTSTAT_EVENTTIMEOUT_Msk = 0x1000000
	// Bit EVENTTIMEOUT.
	I2C_INTSTAT_EVENTTIMEOUT = 0x1000000
	// Position of SCLTIMEOUT field.
	I2C_INTSTAT_SCLTIMEOUT_Pos = 0x19
	// Bit mask of SCLTIMEOUT field.
	I2C_INTSTAT_SCLTIMEOUT_Msk = 0x2000000
	// Bit SCLTIMEOUT.
	I2C_INTSTAT_SCLTIMEOUT = 0x2000000
	// Position of RESERVED field.
	I2C_INTSTAT_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	I2C_INTSTAT_RESERVED_Msk = 0xfc000000

	// MSTCTL: Master control register.
	// Position of MSTCONTINUE field.
	I2C_MSTCTL_MSTCONTINUE_Pos = 0x0
	// Bit mask of MSTCONTINUE field.
	I2C_MSTCTL_MSTCONTINUE_Msk = 0x1
	// Bit MSTCONTINUE.
	I2C_MSTCTL_MSTCONTINUE = 0x1
	// No effect.
	I2C_MSTCTL_MSTCONTINUE_NO_EFFECT_ = 0x0
	// Continue. Informs the Master function to continue to the next operation. This must done after writing transmit data, reading received data, or any other housekeeping related to the next bus operation.
	I2C_MSTCTL_MSTCONTINUE_CONTINUE_INFORMS_TH = 0x1
	// Position of MSTSTART field.
	I2C_MSTCTL_MSTSTART_Pos = 0x1
	// Bit mask of MSTSTART field.
	I2C_MSTCTL_MSTSTART_Msk = 0x2
	// Bit MSTSTART.
	I2C_MSTCTL_MSTSTART = 0x2
	// No effect.
	I2C_MSTCTL_MSTSTART_NO_EFFECT_ = 0x0
	// Start. A Start will be generated on the I2C bus at the next allowed time.
	I2C_MSTCTL_MSTSTART_START_A_START_WILL_ = 0x1
	// Position of MSTSTOP field.
	I2C_MSTCTL_MSTSTOP_Pos = 0x2
	// Bit mask of MSTSTOP field.
	I2C_MSTCTL_MSTSTOP_Msk = 0x4
	// Bit MSTSTOP.
	I2C_MSTCTL_MSTSTOP = 0x4
	// No effect.
	I2C_MSTCTL_MSTSTOP_NO_EFFECT_ = 0x0
	// Stop. A Stop will be generated on the I2C bus at the next allowed time, preceded by a Nack to the slave if the master is receiving data from the slave (Master Receiver mode).
	I2C_MSTCTL_MSTSTOP_STOP_A_STOP_WILL_BE = 0x1
	// Position of RESERVED field.
	I2C_MSTCTL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	I2C_MSTCTL_RESERVED_Msk = 0xfffffffc

	// MSTTIME: Master timing configuration.
	// Position of MSTSCLLOW field.
	I2C_MSTTIME_MSTSCLLOW_Pos = 0x0
	// Bit mask of MSTSCLLOW field.
	I2C_MSTTIME_MSTSCLLOW_Msk = 0x7
	// 2 clocks. Minimum SCL low time is 2 clocks of the I2C clock pre-divider.
	I2C_MSTTIME_MSTSCLLOW_2_CLOCKS_MINIMUM_SC = 0x0
	// 3 clocks. Minimum SCL low time is 3 clocks of the I2C clock pre-divider.
	I2C_MSTTIME_MSTSCLLOW_3_CLOCKS_MINIMUM_SC = 0x1
	// 4 clocks. Minimum SCL low time is 4 clocks of the I2C clock pre-divider.
	I2C_MSTTIME_MSTSCLLOW_4_CLOCKS_MINIMUM_SC = 0x2
	// 5 clocks. Minimum SCL low time is 5 clocks of the I2C clock pre-divider.
	I2C_MSTTIME_MSTSCLLOW_5_CLOCKS_MINIMUM_SC = 0x3
	// 6 clocks. Minimum SCL low time is 6 clocks of the I2C clock pre-divider.
	I2C_MSTTIME_MSTSCLLOW_6_CLOCKS_MINIMUM_SC = 0x4
	// 7 clocks. Minimum SCL low time is 7 clocks of the I2C clock pre-divider.
	I2C_MSTTIME_MSTSCLLOW_7_CLOCKS_MINIMUM_SC = 0x5
	// 8 clocks. Minimum SCL low time is 8 clocks of the I2C clock pre-divider.
	I2C_MSTTIME_MSTSCLLOW_8_CLOCKS_MINIMUM_SC = 0x6
	// 9 clocks. Minimum SCL low time is 9 clocks of the I2C clock pre-divider.
	I2C_MSTTIME_MSTSCLLOW_9_CLOCKS_MINIMUM_SC = 0x7
	// Position of MSTSCLHIGH field.
	I2C_MSTTIME_MSTSCLHIGH_Pos = 0x4
	// Bit mask of MSTSCLHIGH field.
	I2C_MSTTIME_MSTSCLHIGH_Msk = 0x70
	// 2 clocks. Minimum SCL high time is 2 clock of the I2C clock pre-divider.
	I2C_MSTTIME_MSTSCLHIGH_2_CLOCKS_MINIMUM_SC = 0x0
	// 3 clocks. Minimum SCL high time is 3 clocks of the I2C clock pre-divider .
	I2C_MSTTIME_MSTSCLHIGH_3_CLOCKS_MINIMUM_SC = 0x1
	// 4 clocks. Minimum SCL high time is 4 clock of the I2C clock pre-divider.
	I2C_MSTTIME_MSTSCLHIGH_4_CLOCKS_MINIMUM_SC = 0x2
	// 5 clocks. Minimum SCL high time is 5 clock of the I2C clock pre-divider.
	I2C_MSTTIME_MSTSCLHIGH_5_CLOCKS_MINIMUM_SC = 0x3
	// 6 clocks. Minimum SCL high time is 6 clock of the I2C clock pre-divider.
	I2C_MSTTIME_MSTSCLHIGH_6_CLOCKS_MINIMUM_SC = 0x4
	// 7 clocks. Minimum SCL high time is 7 clock of the I2C clock pre-divider.
	I2C_MSTTIME_MSTSCLHIGH_7_CLOCKS_MINIMUM_SC = 0x5
	// 8 clocks. Minimum SCL high time is 8 clock of the I2C clock pre-divider.
	I2C_MSTTIME_MSTSCLHIGH_8_CLOCKS_MINIMUM_SC = 0x6
	// 9 clocks. Minimum SCL high time is 9 clocks of the I2C clock pre-divider.
	I2C_MSTTIME_MSTSCLHIGH_9_CLOCKS_MINIMUM_SC = 0x7
	// Position of RESERVED field.
	I2C_MSTTIME_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C_MSTTIME_RESERVED_Msk = 0xffffff80

	// MSTDAT: Combined Master receiver and transmitter data register.
	// Position of DATA field.
	I2C_MSTDAT_DATA_Pos = 0x0
	// Bit mask of DATA field.
	I2C_MSTDAT_DATA_Msk = 0xff
	// Position of RESERVED field.
	I2C_MSTDAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_MSTDAT_RESERVED_Msk = 0xffffff00

	// SLVCTL: Slave control register.
	// Position of SlvContinue field.
	I2C_SLVCTL_SlvContinue_Pos = 0x0
	// Bit mask of SlvContinue field.
	I2C_SLVCTL_SlvContinue_Msk = 0x1
	// Bit SlvContinue.
	I2C_SLVCTL_SlvContinue = 0x1
	// No effect.
	I2C_SLVCTL_SlvContinue_NO_EFFECT_ = 0x0
	// Continue. Informs the Slave function to continue to the next operation. This must done after writing transmit data, reading received data, or any other housekeeping related to the next bus operation.
	I2C_SLVCTL_SlvContinue_CONTINUE_INFORMS_TH = 0x1
	// Position of SlvNack field.
	I2C_SLVCTL_SlvNack_Pos = 0x1
	// Bit mask of SlvNack field.
	I2C_SLVCTL_SlvNack_Msk = 0x2
	// Bit SlvNack.
	I2C_SLVCTL_SlvNack = 0x2
	// No effect.
	I2C_SLVCTL_SlvNack_NO_EFFECT_ = 0x0
	// Nack. Causes the Slave function to Nack the master when the slave is receiving data from the master (Slave Receiver mode).
	I2C_SLVCTL_SlvNack_NACK_CAUSES_THE_SLA = 0x1
	// Position of RESERVED field.
	I2C_SLVCTL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	I2C_SLVCTL_RESERVED_Msk = 0xfffffffc

	// SLVDAT: Combined Slave receiver and transmitter data register.
	// Position of DATA field.
	I2C_SLVDAT_DATA_Pos = 0x0
	// Bit mask of DATA field.
	I2C_SLVDAT_DATA_Msk = 0xff
	// Position of RESERVED field.
	I2C_SLVDAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_SLVDAT_RESERVED_Msk = 0xffffff00

	// SLVADR0: Slave address 0.
	// Position of SADISABLE field.
	I2C_SLVADR_SADISABLE_Pos = 0x0
	// Bit mask of SADISABLE field.
	I2C_SLVADR_SADISABLE_Msk = 0x1
	// Bit SADISABLE.
	I2C_SLVADR_SADISABLE = 0x1
	// Enabled. Slave Address n is enabled and will be recognized with any changes specified by the SLVQUAL0 register.
	I2C_SLVADR_SADISABLE_ENABLED_SLAVE_ADDRE = 0x0
	// Ignored Slave Address n is ignored.
	I2C_SLVADR_SADISABLE_IGNORED_SLAVE_ADDRES = 0x1
	// Position of SLVADR field.
	I2C_SLVADR_SLVADR_Pos = 0x1
	// Bit mask of SLVADR field.
	I2C_SLVADR_SLVADR_Msk = 0xfe
	// Position of RESERVED field.
	I2C_SLVADR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_SLVADR_RESERVED_Msk = 0xffffff00

	// SLVQUAL0: Slave Qualification for address 0.
	// Position of QUALMODE0 field.
	I2C_SLVQUAL0_QUALMODE0_Pos = 0x0
	// Bit mask of QUALMODE0 field.
	I2C_SLVQUAL0_QUALMODE0_Msk = 0x1
	// Bit QUALMODE0.
	I2C_SLVQUAL0_QUALMODE0 = 0x1
	// Position of SLVQUAL0 field.
	I2C_SLVQUAL0_SLVQUAL0_Pos = 0x1
	// Bit mask of SLVQUAL0 field.
	I2C_SLVQUAL0_SLVQUAL0_Msk = 0xfe
	// Position of RESERVED field.
	I2C_SLVQUAL0_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_SLVQUAL0_RESERVED_Msk = 0xffffff00

	// MONRXDAT: Monitor receiver data register.
	// Position of MONRXDAT field.
	I2C_MONRXDAT_MONRXDAT_Pos = 0x0
	// Bit mask of MONRXDAT field.
	I2C_MONRXDAT_MONRXDAT_Msk = 0xff
	// Position of MONSTART field.
	I2C_MONRXDAT_MONSTART_Pos = 0x8
	// Bit mask of MONSTART field.
	I2C_MONRXDAT_MONSTART_Msk = 0x100
	// Bit MONSTART.
	I2C_MONRXDAT_MONSTART = 0x100
	// No detect. The monitor function has not detected a Start event on the I2C bus.
	I2C_MONRXDAT_MONSTART_NO_DETECT_THE_MONIT = 0x0
	// Start detect. The monitor function has detected a Start event on the I2C bus.
	I2C_MONRXDAT_MONSTART_START_DETECT_THE_MO = 0x1
	// Position of MONRESTART field.
	I2C_MONRXDAT_MONRESTART_Pos = 0x9
	// Bit mask of MONRESTART field.
	I2C_MONRXDAT_MONRESTART_Msk = 0x200
	// Bit MONRESTART.
	I2C_MONRXDAT_MONRESTART = 0x200
	// No start detect. The monitor function has not detected a Repeated Start event on the I2C bus.
	I2C_MONRXDAT_MONRESTART_NO_START_DETECT_THE = 0x0
	// Repeated start detect. The monitor function has detected a Repeated Start event on the I 2C bus.
	I2C_MONRXDAT_MONRESTART_REPEATED_START_DETEC = 0x1
	// Position of MONNACK field.
	I2C_MONRXDAT_MONNACK_Pos = 0xa
	// Bit mask of MONNACK field.
	I2C_MONRXDAT_MONNACK_Msk = 0x400
	// Bit MONNACK.
	I2C_MONRXDAT_MONNACK = 0x400
	// Acknowledged. The data currently being provided by the monitor function was acknowledged by at least one master or slave receiver.
	I2C_MONRXDAT_MONNACK_ACKNOWLEDGED_THE_DA = 0x0
	// Not acknowledged. The data currently being provided by the monitor function was not acknowledged by any receiver.
	I2C_MONRXDAT_MONNACK_NOT_ACKNOWLEDGED_TH = 0x1
	// Position of RESERVED field.
	I2C_MONRXDAT_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	I2C_MONRXDAT_RESERVED_Msk = 0xfffff800
)

// Constants for SPI0: SPI
const (
	// CFG: SPI Configuration register
	// Position of Enable field.
	SPI_CFG_Enable_Pos = 0x0
	// Bit mask of Enable field.
	SPI_CFG_Enable_Msk = 0x1
	// Bit Enable.
	SPI_CFG_Enable = 0x1
	// Disabled. The SPI is disabled and the internal state machine and counters are reset.
	SPI_CFG_Enable_DISABLED_THE_SPI_IS = 0x0
	// Enabled. The SPI is enabled for operation.
	SPI_CFG_Enable_ENABLED_THE_SPI_IS_ = 0x1
	// Position of RESERVED field.
	SPI_CFG_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SPI_CFG_RESERVED_Msk = 0x2
	// Bit RESERVED.
	SPI_CFG_RESERVED = 0x2
	// Position of Master field.
	SPI_CFG_Master_Pos = 0x2
	// Bit mask of Master field.
	SPI_CFG_Master_Msk = 0x4
	// Bit Master.
	SPI_CFG_Master = 0x4
	// Slave mode. The SPI will operate in slave mode. SCK, MOSI, and the SSEL signals are inputs, MISO is an output.
	SPI_CFG_Master_SLAVE_MODE_THE_SPI_ = 0x0
	// Master mode. The SPI will operate in master mode. SCK, MOSI, and the SSEL signals are outputs, MISO is an input.
	SPI_CFG_Master_MASTER_MODE_THE_SPI = 0x1
	// Position of LSBF field.
	SPI_CFG_LSBF_Pos = 0x3
	// Bit mask of LSBF field.
	SPI_CFG_LSBF_Msk = 0x8
	// Bit LSBF.
	SPI_CFG_LSBF = 0x8
	// Standard. Data is transmitted and received in standard MSB first order.
	SPI_CFG_LSBF_STANDARD_DATA_IS_TR = 0x0
	// Reverse. Data is transmitted and received in reverse order (LSB first).
	SPI_CFG_LSBF_REVERSE_DATA_IS_TRA = 0x1
	// Position of CPHA field.
	SPI_CFG_CPHA_Pos = 0x4
	// Bit mask of CPHA field.
	SPI_CFG_CPHA_Msk = 0x10
	// Bit CPHA.
	SPI_CFG_CPHA = 0x10
	// Change. The SPI captures serial data on the first clock transition of the frame (when the clock changes away from the rest state). Data is changed on the following edge.
	SPI_CFG_CPHA_CHANGE_THE_SPI_CAPT = 0x0
	// Capture. The SPI changes serial data on the first clock transition of the frame (when the clock changes away from the rest state). Data is captured on the following edge.
	SPI_CFG_CPHA_CAPTURE_THE_SPI_CHA = 0x1
	// Position of CPOL field.
	SPI_CFG_CPOL_Pos = 0x5
	// Bit mask of CPOL field.
	SPI_CFG_CPOL_Msk = 0x20
	// Bit CPOL.
	SPI_CFG_CPOL = 0x20
	// Low. The rest state of the clock (between frames) is low.
	SPI_CFG_CPOL_LOW_THE_REST_STATE_ = 0x0
	// High. The rest state of the clock (between frames) is high.
	SPI_CFG_CPOL_HIGH_THE_REST_STATE = 0x1
	// Position of RESERVED field.
	SPI_CFG_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SPI_CFG_RESERVED_Msk = 0x40
	// Bit RESERVED.
	SPI_CFG_RESERVED = 0x40
	// Position of Loop field.
	SPI_CFG_Loop_Pos = 0x7
	// Bit mask of Loop field.
	SPI_CFG_Loop_Msk = 0x80
	// Bit Loop.
	SPI_CFG_Loop = 0x80
	// Disabled.
	SPI_CFG_Loop_DISABLED_ = 0x0
	// Enabled.
	SPI_CFG_Loop_ENABLED_ = 0x1
	// Position of SPOL field.
	SPI_CFG_SPOL_Pos = 0x8
	// Bit mask of SPOL field.
	SPI_CFG_SPOL_Msk = 0x100
	// Bit SPOL.
	SPI_CFG_SPOL = 0x100
	// Low. The SSEL pin is active low. The value in the SSEL fields of the RXDAT, TXDATCTL, and TXCTL registers related to SSEL is not inverted relative to the pins.
	SPI_CFG_SPOL_LOW_THE_SSEL_PIN_IS = 0x0
	// High. The SSEL pin is active high. The value in the SSEL fields of the RXDAT, TXDATCTL, and TXCTL registers related to SSEL is inverted relative to the pins.
	SPI_CFG_SPOL_HIGH_THE_SSEL_PIN_I = 0x1
	// Position of RESERVED field.
	SPI_CFG_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SPI_CFG_RESERVED_Msk = 0xfffffe00

	// DLY: SPI Delay register
	// Position of PRE_DELAY field.
	SPI_DLY_PRE_DELAY_Pos = 0x0
	// Bit mask of PRE_DELAY field.
	SPI_DLY_PRE_DELAY_Msk = 0xf
	// Position of POST_DELAY field.
	SPI_DLY_POST_DELAY_Pos = 0x4
	// Bit mask of POST_DELAY field.
	SPI_DLY_POST_DELAY_Msk = 0xf0
	// Position of FRAME_DELAY field.
	SPI_DLY_FRAME_DELAY_Pos = 0x8
	// Bit mask of FRAME_DELAY field.
	SPI_DLY_FRAME_DELAY_Msk = 0xf00
	// Position of TRANSFER_DELAY field.
	SPI_DLY_TRANSFER_DELAY_Pos = 0xc
	// Bit mask of TRANSFER_DELAY field.
	SPI_DLY_TRANSFER_DELAY_Msk = 0xf000
	// Position of RESERVED field.
	SPI_DLY_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SPI_DLY_RESERVED_Msk = 0xffff0000

	// STAT: SPI Status. Some status flags can be cleared by writing a 1 to that bit position
	// Position of RXRDY field.
	SPI_STAT_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	SPI_STAT_RXRDY_Msk = 0x1
	// Bit RXRDY.
	SPI_STAT_RXRDY = 0x1
	// Position of TXRDY field.
	SPI_STAT_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	SPI_STAT_TXRDY_Msk = 0x2
	// Bit TXRDY.
	SPI_STAT_TXRDY = 0x2
	// Position of RXOV field.
	SPI_STAT_RXOV_Pos = 0x2
	// Bit mask of RXOV field.
	SPI_STAT_RXOV_Msk = 0x4
	// Bit RXOV.
	SPI_STAT_RXOV = 0x4
	// Position of TXUR field.
	SPI_STAT_TXUR_Pos = 0x3
	// Bit mask of TXUR field.
	SPI_STAT_TXUR_Msk = 0x8
	// Bit TXUR.
	SPI_STAT_TXUR = 0x8
	// Position of SSA field.
	SPI_STAT_SSA_Pos = 0x4
	// Bit mask of SSA field.
	SPI_STAT_SSA_Msk = 0x10
	// Bit SSA.
	SPI_STAT_SSA = 0x10
	// Position of SSD field.
	SPI_STAT_SSD_Pos = 0x5
	// Bit mask of SSD field.
	SPI_STAT_SSD_Msk = 0x20
	// Bit SSD.
	SPI_STAT_SSD = 0x20
	// Position of STALLED field.
	SPI_STAT_STALLED_Pos = 0x6
	// Bit mask of STALLED field.
	SPI_STAT_STALLED_Msk = 0x40
	// Bit STALLED.
	SPI_STAT_STALLED = 0x40
	// Position of ENDTRANSFER field.
	SPI_STAT_ENDTRANSFER_Pos = 0x7
	// Bit mask of ENDTRANSFER field.
	SPI_STAT_ENDTRANSFER_Msk = 0x80
	// Bit ENDTRANSFER.
	SPI_STAT_ENDTRANSFER = 0x80
	// Position of IDLE field.
	SPI_STAT_IDLE_Pos = 0x8
	// Bit mask of IDLE field.
	SPI_STAT_IDLE_Msk = 0x100
	// Bit IDLE.
	SPI_STAT_IDLE = 0x100
	// Position of RESERVED field.
	SPI_STAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SPI_STAT_RESERVED_Msk = 0xfffffe00

	// INTENSET: SPI Interrupt Enable read and Set. A complete value may be read from this register. Writing a 1 to any implemented bit position causes that bit to be set.
	// Position of RXRDYEN field.
	SPI_INTENSET_RXRDYEN_Pos = 0x0
	// Bit mask of RXRDYEN field.
	SPI_INTENSET_RXRDYEN_Msk = 0x1
	// Bit RXRDYEN.
	SPI_INTENSET_RXRDYEN = 0x1
	// No interrupt will be generated when receiver data is available.
	SPI_INTENSET_RXRDYEN_NO_INTERRUPT_WILL_BE = 0x0
	// An interrupt will be generated when receiver data is available in the RXDAT register.
	SPI_INTENSET_RXRDYEN_AN_INTERRUPT_WILL_BE = 0x1
	// Position of TXRDYEN field.
	SPI_INTENSET_TXRDYEN_Pos = 0x1
	// Bit mask of TXRDYEN field.
	SPI_INTENSET_TXRDYEN_Msk = 0x2
	// Bit TXRDYEN.
	SPI_INTENSET_TXRDYEN = 0x2
	// No interrupt will be generated when the transmitter holding register is available.
	SPI_INTENSET_TXRDYEN_NO_INTERRUPT_WILL_BE = 0x0
	// An interrupt will be generated when data may be written to TXDAT.
	SPI_INTENSET_TXRDYEN_AN_INTERRUPT_WILL_BE = 0x1
	// Position of RXOVEN field.
	SPI_INTENSET_RXOVEN_Pos = 0x2
	// Bit mask of RXOVEN field.
	SPI_INTENSET_RXOVEN_Msk = 0x4
	// Bit RXOVEN.
	SPI_INTENSET_RXOVEN = 0x4
	// No interrupt will be generated when a receiver overrun occurs.
	SPI_INTENSET_RXOVEN_NO_INTERRUPT_WILL_BE = 0x0
	// An interrupt will be generated if a receiver overrun occurs.
	SPI_INTENSET_RXOVEN_AN_INTERRUPT_WILL_BE = 0x1
	// Position of TXUREN field.
	SPI_INTENSET_TXUREN_Pos = 0x3
	// Bit mask of TXUREN field.
	SPI_INTENSET_TXUREN_Msk = 0x8
	// Bit TXUREN.
	SPI_INTENSET_TXUREN = 0x8
	// No interrupt will be generated when the transmitter underruns.
	SPI_INTENSET_TXUREN_NO_INTERRUPT_WILL_BE = 0x0
	// An interrupt will be generated if the transmitter underruns.
	SPI_INTENSET_TXUREN_AN_INTERRUPT_WILL_BE = 0x1
	// Position of SSAEN field.
	SPI_INTENSET_SSAEN_Pos = 0x4
	// Bit mask of SSAEN field.
	SPI_INTENSET_SSAEN_Msk = 0x10
	// Bit SSAEN.
	SPI_INTENSET_SSAEN = 0x10
	// No interrupt will be generated when any Slave Select transitions from deasserted to asserted.
	SPI_INTENSET_SSAEN_NO_INTERRUPT_WILL_BE = 0x0
	// An interrupt will be generated when any Slave Select transitions from deasserted to asserted.
	SPI_INTENSET_SSAEN_AN_INTERRUPT_WILL_BE = 0x1
	// Position of SSDEN field.
	SPI_INTENSET_SSDEN_Pos = 0x5
	// Bit mask of SSDEN field.
	SPI_INTENSET_SSDEN_Msk = 0x20
	// Bit SSDEN.
	SPI_INTENSET_SSDEN = 0x20
	// No interrupt will be generated when all asserted Slave Selects transition to deasserted.
	SPI_INTENSET_SSDEN_NO_INTERRUPT_WILL_BE = 0x0
	// An interrupt will be generated when all asserted Slave Selects transition to deasserted.
	SPI_INTENSET_SSDEN_AN_INTERRUPT_WILL_BE = 0x1
	// Position of RESERVED field.
	SPI_INTENSET_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SPI_INTENSET_RESERVED_Msk = 0xffffffc0

	// INTENCLR: SPI Interrupt Enable Clear. Writing a 1 to any implemented bit position causes the corresponding bit in INTENSET to be cleared.
	// Position of RXRDYEN field.
	SPI_INTENCLR_RXRDYEN_Pos = 0x0
	// Bit mask of RXRDYEN field.
	SPI_INTENCLR_RXRDYEN_Msk = 0x1
	// Bit RXRDYEN.
	SPI_INTENCLR_RXRDYEN = 0x1
	// Position of TXRDYEN field.
	SPI_INTENCLR_TXRDYEN_Pos = 0x1
	// Bit mask of TXRDYEN field.
	SPI_INTENCLR_TXRDYEN_Msk = 0x2
	// Bit TXRDYEN.
	SPI_INTENCLR_TXRDYEN = 0x2
	// Position of RXOVEN field.
	SPI_INTENCLR_RXOVEN_Pos = 0x2
	// Bit mask of RXOVEN field.
	SPI_INTENCLR_RXOVEN_Msk = 0x4
	// Bit RXOVEN.
	SPI_INTENCLR_RXOVEN = 0x4
	// Position of TXUREN field.
	SPI_INTENCLR_TXUREN_Pos = 0x3
	// Bit mask of TXUREN field.
	SPI_INTENCLR_TXUREN_Msk = 0x8
	// Bit TXUREN.
	SPI_INTENCLR_TXUREN = 0x8
	// Position of SSAEN field.
	SPI_INTENCLR_SSAEN_Pos = 0x4
	// Bit mask of SSAEN field.
	SPI_INTENCLR_SSAEN_Msk = 0x10
	// Bit SSAEN.
	SPI_INTENCLR_SSAEN = 0x10
	// Position of SSDEN field.
	SPI_INTENCLR_SSDEN_Pos = 0x5
	// Bit mask of SSDEN field.
	SPI_INTENCLR_SSDEN_Msk = 0x20
	// Bit SSDEN.
	SPI_INTENCLR_SSDEN = 0x20
	// Position of RESERVED field.
	SPI_INTENCLR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SPI_INTENCLR_RESERVED_Msk = 0xffffffc0

	// RXDAT: SPI Receive Data
	// Position of RXDAT field.
	SPI_RXDAT_RXDAT_Pos = 0x0
	// Bit mask of RXDAT field.
	SPI_RXDAT_RXDAT_Msk = 0xffff
	// Position of RXSSELN field.
	SPI_RXDAT_RXSSELN_Pos = 0x10
	// Bit mask of RXSSELN field.
	SPI_RXDAT_RXSSELN_Msk = 0x10000
	// Bit RXSSELN.
	SPI_RXDAT_RXSSELN = 0x10000
	// Position of RESERVED field.
	SPI_RXDAT_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	SPI_RXDAT_RESERVED_Msk = 0xe0000
	// Position of SOT field.
	SPI_RXDAT_SOT_Pos = 0x14
	// Bit mask of SOT field.
	SPI_RXDAT_SOT_Msk = 0x100000
	// Bit SOT.
	SPI_RXDAT_SOT = 0x100000
	// Position of RESERVED field.
	SPI_RXDAT_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	SPI_RXDAT_RESERVED_Msk = 0xffe00000

	// TXDATCTL: SPI Transmit Data with Control
	// Position of TXDAT field.
	SPI_TXDATCTL_TXDAT_Pos = 0x0
	// Bit mask of TXDAT field.
	SPI_TXDATCTL_TXDAT_Msk = 0xffff
	// Position of TXSSELN field.
	SPI_TXDATCTL_TXSSELN_Pos = 0x10
	// Bit mask of TXSSELN field.
	SPI_TXDATCTL_TXSSELN_Msk = 0x10000
	// Bit TXSSELN.
	SPI_TXDATCTL_TXSSELN = 0x10000
	// SSEL asserted.
	SPI_TXDATCTL_TXSSELN_SSEL_ASSERTED_ = 0x0
	// SSEL not asserted.
	SPI_TXDATCTL_TXSSELN_SSEL_NOT_ASSERTED_ = 0x1
	// Position of RESERVED field.
	SPI_TXDATCTL_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	SPI_TXDATCTL_RESERVED_Msk = 0xe0000
	// Position of EOT field.
	SPI_TXDATCTL_EOT_Pos = 0x14
	// Bit mask of EOT field.
	SPI_TXDATCTL_EOT_Msk = 0x100000
	// Bit EOT.
	SPI_TXDATCTL_EOT = 0x100000
	// SSEL not deasserted. This piece of data is not treated as the end of a transfer. SSEL will not be deasserted at the end of this data.
	SPI_TXDATCTL_EOT_SSEL_NOT_DEASSERTED_ = 0x0
	// SSEL deasserted. This piece of data is treated as the end of a transfer. SSELs will be deasserted at the end of this piece of data.
	SPI_TXDATCTL_EOT_SSEL_DEASSERTED_THI = 0x1
	// Position of EOF field.
	SPI_TXDATCTL_EOF_Pos = 0x15
	// Bit mask of EOF field.
	SPI_TXDATCTL_EOF_Msk = 0x200000
	// Bit EOF.
	SPI_TXDATCTL_EOF = 0x200000
	// Data not EOF. This piece of data transmitted is not treated as the end of a frame.
	SPI_TXDATCTL_EOF_DATA_NOT_EOF_THIS_P = 0x0
	// Data EOF. This piece of data is treated as the end of a frame, causing the FRAME_DELAY time to be inserted before subsequent data is transmitted.
	SPI_TXDATCTL_EOF_DATA_EOF_THIS_PIECE = 0x1
	// Position of RXIGNORE field.
	SPI_TXDATCTL_RXIGNORE_Pos = 0x16
	// Bit mask of RXIGNORE field.
	SPI_TXDATCTL_RXIGNORE_Msk = 0x400000
	// Bit RXIGNORE.
	SPI_TXDATCTL_RXIGNORE = 0x400000
	// Read received data. Received data must be read in order to allow transmission to progress. In slave mode, an overrun error will occur if received data is not read before new data is received.
	SPI_TXDATCTL_RXIGNORE_READ_RECEIVED_DATA_ = 0x0
	// Ignore received data. Received data is ignored, allowing transmission without reading unneeded received data. No receiver flags are generated.
	SPI_TXDATCTL_RXIGNORE_IGNORE_RECEIVED_DATA = 0x1
	// Position of RESERVED field.
	SPI_TXDATCTL_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	SPI_TXDATCTL_RESERVED_Msk = 0x800000
	// Bit RESERVED.
	SPI_TXDATCTL_RESERVED = 0x800000
	// Position of FLEN field.
	SPI_TXDATCTL_FLEN_Pos = 0x18
	// Bit mask of FLEN field.
	SPI_TXDATCTL_FLEN_Msk = 0xf000000
	// Position of RESERVED field.
	SPI_TXDATCTL_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	SPI_TXDATCTL_RESERVED_Msk = 0xf0000000

	// TXDAT: SPI Transmit Data
	// Position of DATA field.
	SPI_TXDAT_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SPI_TXDAT_DATA_Msk = 0xffff
	// Position of RESERVED field.
	SPI_TXDAT_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SPI_TXDAT_RESERVED_Msk = 0xffff0000

	// TXCTL: SPI Transmit Control
	// Position of RESERVED field.
	SPI_TXCTL_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	SPI_TXCTL_RESERVED_Msk = 0xffff
	// Position of TX_SSEL field.
	SPI_TXCTL_TX_SSEL_Pos = 0x10
	// Bit mask of TX_SSEL field.
	SPI_TXCTL_TX_SSEL_Msk = 0x10000
	// Bit TX_SSEL.
	SPI_TXCTL_TX_SSEL = 0x10000
	// Position of RESERVED field.
	SPI_TXCTL_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	SPI_TXCTL_RESERVED_Msk = 0xe0000
	// Position of EOT field.
	SPI_TXCTL_EOT_Pos = 0x14
	// Bit mask of EOT field.
	SPI_TXCTL_EOT_Msk = 0x100000
	// Bit EOT.
	SPI_TXCTL_EOT = 0x100000
	// Position of EOF field.
	SPI_TXCTL_EOF_Pos = 0x15
	// Bit mask of EOF field.
	SPI_TXCTL_EOF_Msk = 0x200000
	// Bit EOF.
	SPI_TXCTL_EOF = 0x200000
	// Position of RXIGNORE field.
	SPI_TXCTL_RXIGNORE_Pos = 0x16
	// Bit mask of RXIGNORE field.
	SPI_TXCTL_RXIGNORE_Msk = 0x400000
	// Bit RXIGNORE.
	SPI_TXCTL_RXIGNORE = 0x400000
	// Position of RESERVED field.
	SPI_TXCTL_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	SPI_TXCTL_RESERVED_Msk = 0x800000
	// Bit RESERVED.
	SPI_TXCTL_RESERVED = 0x800000
	// Position of FLEN field.
	SPI_TXCTL_FLEN_Pos = 0x18
	// Bit mask of FLEN field.
	SPI_TXCTL_FLEN_Msk = 0xf000000
	// Position of RESERVED field.
	SPI_TXCTL_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	SPI_TXCTL_RESERVED_Msk = 0xf0000000

	// DIV: SPI clock Divider
	// Position of DIVVAL field.
	SPI_DIV_DIVVAL_Pos = 0x0
	// Bit mask of DIVVAL field.
	SPI_DIV_DIVVAL_Msk = 0xffff
	// Position of RESERVED field.
	SPI_DIV_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SPI_DIV_RESERVED_Msk = 0xffff0000

	// INTSTAT: SPI Interrupt Status
	// Position of RXRDY field.
	SPI_INTSTAT_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	SPI_INTSTAT_RXRDY_Msk = 0x1
	// Bit RXRDY.
	SPI_INTSTAT_RXRDY = 0x1
	// Position of TXRDY field.
	SPI_INTSTAT_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	SPI_INTSTAT_TXRDY_Msk = 0x2
	// Bit TXRDY.
	SPI_INTSTAT_TXRDY = 0x2
	// Position of RXOV field.
	SPI_INTSTAT_RXOV_Pos = 0x2
	// Bit mask of RXOV field.
	SPI_INTSTAT_RXOV_Msk = 0x4
	// Bit RXOV.
	SPI_INTSTAT_RXOV = 0x4
	// Position of TXUR field.
	SPI_INTSTAT_TXUR_Pos = 0x3
	// Bit mask of TXUR field.
	SPI_INTSTAT_TXUR_Msk = 0x8
	// Bit TXUR.
	SPI_INTSTAT_TXUR = 0x8
	// Position of SSA field.
	SPI_INTSTAT_SSA_Pos = 0x4
	// Bit mask of SSA field.
	SPI_INTSTAT_SSA_Msk = 0x10
	// Bit SSA.
	SPI_INTSTAT_SSA = 0x10
	// Position of SSD field.
	SPI_INTSTAT_SSD_Pos = 0x5
	// Bit mask of SSD field.
	SPI_INTSTAT_SSD_Msk = 0x20
	// Bit SSD.
	SPI_INTSTAT_SSD = 0x20
	// Position of RESERVED field.
	SPI_INTSTAT_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SPI_INTSTAT_RESERVED_Msk = 0xffffffc0
)

// Constants for USART0: USART
const (
	// CFG: USART Configuration register. Basic USART configuration settings that typically are not changed during operation.
	// Position of ENABLE field.
	USART_CFG_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	USART_CFG_ENABLE_Msk = 0x1
	// Bit ENABLE.
	USART_CFG_ENABLE = 0x1
	// Disabled. The USART is disabled and the internal state machine and counters are reset. While Enable = 0, all USART interrupts are disabled. When Enable is set again, CFG and most other control bits remain unchanged. For instance, when re-enabled, the USART will immediately generate a TxRdy interrupt if enabled because the transmitter has been reset and is therefore available.
	USART_CFG_ENABLE_DISABLED_THE_USART_ = 0x0
	// Enabled. The USART is enabled for operation.
	USART_CFG_ENABLE_ENABLED_THE_USART_I = 0x1
	// Position of RESERVED field.
	USART_CFG_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART_CFG_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USART_CFG_RESERVED = 0x2
	// Position of DATALEN field.
	USART_CFG_DATALEN_Pos = 0x2
	// Bit mask of DATALEN field.
	USART_CFG_DATALEN_Msk = 0xc
	// 7 bit Data length.
	USART_CFG_DATALEN_7_BIT_DATA_LENGTH_ = 0x0
	// 8 bit Data length.
	USART_CFG_DATALEN_8_BIT_DATA_LENGTH_ = 0x1
	// 9 bit data length. The 9th bit is commonly used for addressing in multidrop mode. See the ADDRDET bit in the CTRL register.
	USART_CFG_DATALEN_9_BIT_DATA_LENGTH_T = 0x2
	// Reserved.
	USART_CFG_DATALEN_RESERVED_ = 0x3
	// Position of PARITYSEL field.
	USART_CFG_PARITYSEL_Pos = 0x4
	// Bit mask of PARITYSEL field.
	USART_CFG_PARITYSEL_Msk = 0x30
	// No parity.
	USART_CFG_PARITYSEL_NO_PARITY_ = 0x0
	// Reserved.
	USART_CFG_PARITYSEL_RESERVED_ = 0x1
	// Even parity. Adds a bit to each character such that the number of 1s in a transmitted character is even, and the number of 1s in a received character is expected to be even.
	USART_CFG_PARITYSEL_EVEN_PARITY_ADDS_A_ = 0x2
	// Odd parity. Adds a bit to each character such that the number of 1s in a transmitted character is odd, and the number of 1s in a received character is expected to be odd.
	USART_CFG_PARITYSEL_ODD_PARITY_ADDS_A_B = 0x3
	// Position of STOPLEN field.
	USART_CFG_STOPLEN_Pos = 0x6
	// Bit mask of STOPLEN field.
	USART_CFG_STOPLEN_Msk = 0x40
	// Bit STOPLEN.
	USART_CFG_STOPLEN = 0x40
	// 1 stop bit.
	USART_CFG_STOPLEN_1_STOP_BIT_ = 0x0
	// 2 stop bits. This setting should only be used for asynchronous communication.
	USART_CFG_STOPLEN_2_STOP_BITS_THIS_SE = 0x1
	// Position of RESERVED field.
	USART_CFG_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART_CFG_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART_CFG_RESERVED = 0x80
	// Position of RESERVED field.
	USART_CFG_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART_CFG_RESERVED_Msk = 0x100
	// Bit RESERVED.
	USART_CFG_RESERVED = 0x100
	// Position of CTSEN field.
	USART_CFG_CTSEN_Pos = 0x9
	// Bit mask of CTSEN field.
	USART_CFG_CTSEN_Msk = 0x200
	// Bit CTSEN.
	USART_CFG_CTSEN = 0x200
	// No flow control. The transmitter does not receive any automatic flow control signal.
	USART_CFG_CTSEN_NO_FLOW_CONTROL_THE = 0x0
	// Flow control enabled. The transmitter uses external or internal CTS for flow control purposes.
	USART_CFG_CTSEN_FLOW_CONTROL_ENABLED = 0x1
	// Position of RESERVED field.
	USART_CFG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART_CFG_RESERVED_Msk = 0x400
	// Bit RESERVED.
	USART_CFG_RESERVED = 0x400
	// Position of SYNCEN field.
	USART_CFG_SYNCEN_Pos = 0xb
	// Bit mask of SYNCEN field.
	USART_CFG_SYNCEN_Msk = 0x800
	// Bit SYNCEN.
	USART_CFG_SYNCEN = 0x800
	// Asynchronous mode is selected.
	USART_CFG_SYNCEN_ASYNCHRONOUS_MODE_IS = 0x0
	// Synchronous mode is selected.
	USART_CFG_SYNCEN_SYNCHRONOUS_MODE_IS_ = 0x1
	// Position of CLKPOL field.
	USART_CFG_CLKPOL_Pos = 0xc
	// Bit mask of CLKPOL field.
	USART_CFG_CLKPOL_Msk = 0x1000
	// Bit CLKPOL.
	USART_CFG_CLKPOL = 0x1000
	// Falling edge. Un_RXD is sampled on the falling edge of SCLK.
	USART_CFG_CLKPOL_FALLING_EDGE_UN_RXD = 0x0
	// Rising edge. Un_RXD is sampled on the rising edge of SCLK.
	USART_CFG_CLKPOL_RISING_EDGE_UN_RXD_ = 0x1
	// Position of RESERVED field.
	USART_CFG_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	USART_CFG_RESERVED_Msk = 0x2000
	// Bit RESERVED.
	USART_CFG_RESERVED = 0x2000
	// Position of SYNCMST field.
	USART_CFG_SYNCMST_Pos = 0xe
	// Bit mask of SYNCMST field.
	USART_CFG_SYNCMST_Msk = 0x4000
	// Bit SYNCMST.
	USART_CFG_SYNCMST = 0x4000
	// Slave. When synchronous mode is enabled, the USART is a slave.
	USART_CFG_SYNCMST_SLAVE_WHEN_SYNCHRON = 0x0
	// Master. When synchronous mode is enabled, the USART is a master. In asynchronous mode, the baud rate clock will be output on SCLK if it is connected to a pin.
	USART_CFG_SYNCMST_MASTER_WHEN_SYNCHRO = 0x1
	// Position of LOOP field.
	USART_CFG_LOOP_Pos = 0xf
	// Bit mask of LOOP field.
	USART_CFG_LOOP_Msk = 0x8000
	// Bit LOOP.
	USART_CFG_LOOP = 0x8000
	// Normal operation.
	USART_CFG_LOOP_NORMAL_OPERATION_ = 0x0
	// Loopback mode. This provides a mechanism to perform diagnostic loopback testing for USART data. Serial data from the transmitter (Un_TXD) is connected internally to serial input of the receive (Un_RXD). Un_TXD and Un_RTS activity will also appear on external pins if these functions are configured to appear on device pins. The receiver RTS signal is also looped back to CTS and performs flow control if enabled by CTSEN.
	USART_CFG_LOOP_LOOPBACK_MODE_THIS_ = 0x1
	// Position of RESERVED field.
	USART_CFG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART_CFG_RESERVED_Msk = 0xffff0000

	// CTRL: USART Control register. USART control settings that are more likely to change during operation.
	// Position of RESERVED field.
	USART_CTRL_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USART_CTRL_RESERVED_Msk = 0x1
	// Bit RESERVED.
	USART_CTRL_RESERVED = 0x1
	// Position of TXBRKEN field.
	USART_CTRL_TXBRKEN_Pos = 0x1
	// Bit mask of TXBRKEN field.
	USART_CTRL_TXBRKEN_Msk = 0x2
	// Bit TXBRKEN.
	USART_CTRL_TXBRKEN = 0x2
	// Normal operation.
	USART_CTRL_TXBRKEN_NORMAL_OPERATION_ = 0x0
	// Continuous break is sent immediately when this bit is set, and remains until this bit is cleared. A break may be sent without danger of corrupting any currently transmitting character if the transmitter is first disabled (TXDIS in CTRL is set) and then waiting for the transmitter to be disabled (TXDISINT in STAT = 1) before writing 1 to TXBRKEN.
	USART_CTRL_TXBRKEN_CONTINUOUS_BREAK_IS_ = 0x1
	// Position of ADDRDET field.
	USART_CTRL_ADDRDET_Pos = 0x2
	// Bit mask of ADDRDET field.
	USART_CTRL_ADDRDET_Msk = 0x4
	// Bit ADDRDET.
	USART_CTRL_ADDRDET = 0x4
	// Enabled. The USART receiver is enabled for all incoming data.
	USART_CTRL_ADDRDET_ENABLED_THE_USART_R = 0x0
	// Disabled. The USART receiver ignores incoming data that does not have the most significant bit of the data (typically the 9th bit) = 1. When the data MSB bit = 1, the receiver treats the incoming data normally, generating a received data interrupt. Software can then check the data to see if this is an address that should be handled. If it is, the ADDRDET bit is cleared by software and further incoming data is handled normally.
	USART_CTRL_ADDRDET_DISABLED_THE_USART_ = 0x1
	// Position of RESERVED field.
	USART_CTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART_CTRL_RESERVED_Msk = 0x38
	// Position of TXDIS field.
	USART_CTRL_TXDIS_Pos = 0x6
	// Bit mask of TXDIS field.
	USART_CTRL_TXDIS_Msk = 0x40
	// Bit TXDIS.
	USART_CTRL_TXDIS = 0x40
	// Not disabled. USART transmitter is not disabled.
	USART_CTRL_TXDIS_NOT_DISABLED_USART_ = 0x0
	// Disabled. USART transmitter is disabled after any character currently being transmitted is complete. This feature can be used to facilitate software flow control.
	USART_CTRL_TXDIS_DISABLED_USART_TRAN = 0x1
	// Position of RESERVED field.
	USART_CTRL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART_CTRL_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART_CTRL_RESERVED = 0x80
	// Position of CC field.
	USART_CTRL_CC_Pos = 0x8
	// Bit mask of CC field.
	USART_CTRL_CC_Msk = 0x100
	// Bit CC.
	USART_CTRL_CC = 0x100
	// Clock on character. In synchronous mode, SCLK cycles only when characters are being sent on Un_TXD or to complete a character that is being received.
	USART_CTRL_CC_CLOCK_ON_CHARACTER_ = 0x0
	// Continuous clock. SCLK runs continuously in synchronous mode, allowing characters to be received on Un_RxD independently from transmission on Un_TXD).
	USART_CTRL_CC_CONTINUOUS_CLOCK_SC = 0x1
	// Position of CLRCC field.
	USART_CTRL_CLRCC_Pos = 0x9
	// Bit mask of CLRCC field.
	USART_CTRL_CLRCC_Msk = 0x200
	// Bit CLRCC.
	USART_CTRL_CLRCC = 0x200
	// No affect on the CC bit.
	USART_CTRL_CLRCC_NO_AFFECT_ON_THE_CC_ = 0x0
	// Auto-clear. The CC bit is automatically cleared when a complete character has been received. This bit is cleared at the same time.
	USART_CTRL_CLRCC_AUTO_CLEAR_THE_CC_B = 0x1
	// Position of RESERVED field.
	USART_CTRL_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART_CTRL_RESERVED_Msk = 0xfffffc00

	// STAT: USART Status register. The complete status value can be read here. Writing 1s clears some bits in the register. Some bits can be cleared by writing a 1 to them.
	// Position of RXRDY field.
	USART_STAT_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_STAT_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_STAT_RXRDY = 0x1
	// Position of RXIDLE field.
	USART_STAT_RXIDLE_Pos = 0x1
	// Bit mask of RXIDLE field.
	USART_STAT_RXIDLE_Msk = 0x2
	// Bit RXIDLE.
	USART_STAT_RXIDLE = 0x2
	// Position of TXRDY field.
	USART_STAT_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	USART_STAT_TXRDY_Msk = 0x4
	// Bit TXRDY.
	USART_STAT_TXRDY = 0x4
	// Position of TXIDLE field.
	USART_STAT_TXIDLE_Pos = 0x3
	// Bit mask of TXIDLE field.
	USART_STAT_TXIDLE_Msk = 0x8
	// Bit TXIDLE.
	USART_STAT_TXIDLE = 0x8
	// Position of CTS field.
	USART_STAT_CTS_Pos = 0x4
	// Bit mask of CTS field.
	USART_STAT_CTS_Msk = 0x10
	// Bit CTS.
	USART_STAT_CTS = 0x10
	// Position of DELTACTS field.
	USART_STAT_DELTACTS_Pos = 0x5
	// Bit mask of DELTACTS field.
	USART_STAT_DELTACTS_Msk = 0x20
	// Bit DELTACTS.
	USART_STAT_DELTACTS = 0x20
	// Position of TXDISINT field.
	USART_STAT_TXDISINT_Pos = 0x6
	// Bit mask of TXDISINT field.
	USART_STAT_TXDISINT_Msk = 0x40
	// Bit TXDISINT.
	USART_STAT_TXDISINT = 0x40
	// Position of RESERVED field.
	USART_STAT_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART_STAT_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART_STAT_RESERVED = 0x80
	// Position of OVERRUNINT field.
	USART_STAT_OVERRUNINT_Pos = 0x8
	// Bit mask of OVERRUNINT field.
	USART_STAT_OVERRUNINT_Msk = 0x100
	// Bit OVERRUNINT.
	USART_STAT_OVERRUNINT = 0x100
	// Position of RESERVED field.
	USART_STAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART_STAT_RESERVED_Msk = 0x200
	// Bit RESERVED.
	USART_STAT_RESERVED = 0x200
	// Position of RXBRK field.
	USART_STAT_RXBRK_Pos = 0xa
	// Bit mask of RXBRK field.
	USART_STAT_RXBRK_Msk = 0x400
	// Bit RXBRK.
	USART_STAT_RXBRK = 0x400
	// Position of DELTARXBRK field.
	USART_STAT_DELTARXBRK_Pos = 0xb
	// Bit mask of DELTARXBRK field.
	USART_STAT_DELTARXBRK_Msk = 0x800
	// Bit DELTARXBRK.
	USART_STAT_DELTARXBRK = 0x800
	// Position of START field.
	USART_STAT_START_Pos = 0xc
	// Bit mask of START field.
	USART_STAT_START_Msk = 0x1000
	// Bit START.
	USART_STAT_START = 0x1000
	// Position of FRAMERRINT field.
	USART_STAT_FRAMERRINT_Pos = 0xd
	// Bit mask of FRAMERRINT field.
	USART_STAT_FRAMERRINT_Msk = 0x2000
	// Bit FRAMERRINT.
	USART_STAT_FRAMERRINT = 0x2000
	// Position of PARITYERRINT field.
	USART_STAT_PARITYERRINT_Pos = 0xe
	// Bit mask of PARITYERRINT field.
	USART_STAT_PARITYERRINT_Msk = 0x4000
	// Bit PARITYERRINT.
	USART_STAT_PARITYERRINT = 0x4000
	// Position of RXNOISEINT field.
	USART_STAT_RXNOISEINT_Pos = 0xf
	// Bit mask of RXNOISEINT field.
	USART_STAT_RXNOISEINT_Msk = 0x8000
	// Bit RXNOISEINT.
	USART_STAT_RXNOISEINT = 0x8000
	// Position of RESERVED field.
	USART_STAT_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART_STAT_RESERVED_Msk = 0xffff0000

	// INTENSET: Interrupt Enable read and Set register. Contains an individual interrupt enable bit for each potential USART interrupt. A complete value may be read from this register. Writing a 1 to any implemented bit position causes that bit to be set.
	// Position of RXRDYEN field.
	USART_INTENSET_RXRDYEN_Pos = 0x0
	// Bit mask of RXRDYEN field.
	USART_INTENSET_RXRDYEN_Msk = 0x1
	// Bit RXRDYEN.
	USART_INTENSET_RXRDYEN = 0x1
	// Position of RESERVED field.
	USART_INTENSET_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART_INTENSET_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USART_INTENSET_RESERVED = 0x2
	// Position of TXRDYEN field.
	USART_INTENSET_TXRDYEN_Pos = 0x2
	// Bit mask of TXRDYEN field.
	USART_INTENSET_TXRDYEN_Msk = 0x4
	// Bit TXRDYEN.
	USART_INTENSET_TXRDYEN = 0x4
	// Position of RESERVED field.
	USART_INTENSET_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART_INTENSET_RESERVED_Msk = 0x18
	// Position of DELTACTSEN field.
	USART_INTENSET_DELTACTSEN_Pos = 0x5
	// Bit mask of DELTACTSEN field.
	USART_INTENSET_DELTACTSEN_Msk = 0x20
	// Bit DELTACTSEN.
	USART_INTENSET_DELTACTSEN = 0x20
	// Position of TXDISINTEN field.
	USART_INTENSET_TXDISINTEN_Pos = 0x6
	// Bit mask of TXDISINTEN field.
	USART_INTENSET_TXDISINTEN_Msk = 0x40
	// Bit TXDISINTEN.
	USART_INTENSET_TXDISINTEN = 0x40
	// Position of RESERVED field.
	USART_INTENSET_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART_INTENSET_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART_INTENSET_RESERVED = 0x80
	// Position of OVERRUNEN field.
	USART_INTENSET_OVERRUNEN_Pos = 0x8
	// Bit mask of OVERRUNEN field.
	USART_INTENSET_OVERRUNEN_Msk = 0x100
	// Bit OVERRUNEN.
	USART_INTENSET_OVERRUNEN = 0x100
	// Position of RESERVED field.
	USART_INTENSET_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART_INTENSET_RESERVED_Msk = 0x600
	// Position of DELTARXBRKEN field.
	USART_INTENSET_DELTARXBRKEN_Pos = 0xb
	// Bit mask of DELTARXBRKEN field.
	USART_INTENSET_DELTARXBRKEN_Msk = 0x800
	// Bit DELTARXBRKEN.
	USART_INTENSET_DELTARXBRKEN = 0x800
	// Position of STARTEN field.
	USART_INTENSET_STARTEN_Pos = 0xc
	// Bit mask of STARTEN field.
	USART_INTENSET_STARTEN_Msk = 0x1000
	// Bit STARTEN.
	USART_INTENSET_STARTEN = 0x1000
	// Position of FRAMERREN field.
	USART_INTENSET_FRAMERREN_Pos = 0xd
	// Bit mask of FRAMERREN field.
	USART_INTENSET_FRAMERREN_Msk = 0x2000
	// Bit FRAMERREN.
	USART_INTENSET_FRAMERREN = 0x2000
	// Position of PARITYERREN field.
	USART_INTENSET_PARITYERREN_Pos = 0xe
	// Bit mask of PARITYERREN field.
	USART_INTENSET_PARITYERREN_Msk = 0x4000
	// Bit PARITYERREN.
	USART_INTENSET_PARITYERREN = 0x4000
	// Position of RXNOISEEN field.
	USART_INTENSET_RXNOISEEN_Pos = 0xf
	// Bit mask of RXNOISEEN field.
	USART_INTENSET_RXNOISEEN_Msk = 0x8000
	// Bit RXNOISEEN.
	USART_INTENSET_RXNOISEEN = 0x8000
	// Position of RESERVED field.
	USART_INTENSET_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART_INTENSET_RESERVED_Msk = 0xffff0000

	// INTENCLR: Interrupt Enable Clear register. Allows clearing any combination of bits in the INTENSET register. Writing a 1 to any implemented bit position causes the corresponding bit to be cleared.
	// Position of RXRDYCLR field.
	USART_INTENCLR_RXRDYCLR_Pos = 0x0
	// Bit mask of RXRDYCLR field.
	USART_INTENCLR_RXRDYCLR_Msk = 0x1
	// Bit RXRDYCLR.
	USART_INTENCLR_RXRDYCLR = 0x1
	// Position of RESERVED field.
	USART_INTENCLR_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART_INTENCLR_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USART_INTENCLR_RESERVED = 0x2
	// Position of TXRDYCLR field.
	USART_INTENCLR_TXRDYCLR_Pos = 0x2
	// Bit mask of TXRDYCLR field.
	USART_INTENCLR_TXRDYCLR_Msk = 0x4
	// Bit TXRDYCLR.
	USART_INTENCLR_TXRDYCLR = 0x4
	// Position of RESERVED field.
	USART_INTENCLR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART_INTENCLR_RESERVED_Msk = 0x18
	// Position of DELTACTSCLR field.
	USART_INTENCLR_DELTACTSCLR_Pos = 0x5
	// Bit mask of DELTACTSCLR field.
	USART_INTENCLR_DELTACTSCLR_Msk = 0x20
	// Bit DELTACTSCLR.
	USART_INTENCLR_DELTACTSCLR = 0x20
	// Position of TXDISINTCLR field.
	USART_INTENCLR_TXDISINTCLR_Pos = 0x6
	// Bit mask of TXDISINTCLR field.
	USART_INTENCLR_TXDISINTCLR_Msk = 0x40
	// Bit TXDISINTCLR.
	USART_INTENCLR_TXDISINTCLR = 0x40
	// Position of RESERVED field.
	USART_INTENCLR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART_INTENCLR_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART_INTENCLR_RESERVED = 0x80
	// Position of OVERRUNCLR field.
	USART_INTENCLR_OVERRUNCLR_Pos = 0x8
	// Bit mask of OVERRUNCLR field.
	USART_INTENCLR_OVERRUNCLR_Msk = 0x100
	// Bit OVERRUNCLR.
	USART_INTENCLR_OVERRUNCLR = 0x100
	// Position of RESERVED field.
	USART_INTENCLR_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART_INTENCLR_RESERVED_Msk = 0x600
	// Position of DELTARXBRKCLR field.
	USART_INTENCLR_DELTARXBRKCLR_Pos = 0xb
	// Bit mask of DELTARXBRKCLR field.
	USART_INTENCLR_DELTARXBRKCLR_Msk = 0x800
	// Bit DELTARXBRKCLR.
	USART_INTENCLR_DELTARXBRKCLR = 0x800
	// Position of STARTCLR field.
	USART_INTENCLR_STARTCLR_Pos = 0xc
	// Bit mask of STARTCLR field.
	USART_INTENCLR_STARTCLR_Msk = 0x1000
	// Bit STARTCLR.
	USART_INTENCLR_STARTCLR = 0x1000
	// Position of FRAMERRCLR field.
	USART_INTENCLR_FRAMERRCLR_Pos = 0xd
	// Bit mask of FRAMERRCLR field.
	USART_INTENCLR_FRAMERRCLR_Msk = 0x2000
	// Bit FRAMERRCLR.
	USART_INTENCLR_FRAMERRCLR = 0x2000
	// Position of PARITYERRCLR field.
	USART_INTENCLR_PARITYERRCLR_Pos = 0xe
	// Bit mask of PARITYERRCLR field.
	USART_INTENCLR_PARITYERRCLR_Msk = 0x4000
	// Bit PARITYERRCLR.
	USART_INTENCLR_PARITYERRCLR = 0x4000
	// Position of RXNOISECLR field.
	USART_INTENCLR_RXNOISECLR_Pos = 0xf
	// Bit mask of RXNOISECLR field.
	USART_INTENCLR_RXNOISECLR_Msk = 0x8000
	// Bit RXNOISECLR.
	USART_INTENCLR_RXNOISECLR = 0x8000
	// Position of RESERVED field.
	USART_INTENCLR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART_INTENCLR_RESERVED_Msk = 0xffff0000

	// RXDATA: Receiver Data register. Contains the last character received.
	// Position of RXDAT field.
	USART_RXDATA_RXDAT_Pos = 0x0
	// Bit mask of RXDAT field.
	USART_RXDATA_RXDAT_Msk = 0x1ff
	// Position of RESERVED field.
	USART_RXDATA_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART_RXDATA_RESERVED_Msk = 0xfffffe00

	// RXDATASTAT: Receiver Data with Status register. Combines the last character received with the current USART receive status. Allows software to recover incoming data and status together.
	// Position of RXDAT field.
	USART_RXDATASTAT_RXDAT_Pos = 0x0
	// Bit mask of RXDAT field.
	USART_RXDATASTAT_RXDAT_Msk = 0x1ff
	// Position of RESERVED field.
	USART_RXDATASTAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART_RXDATASTAT_RESERVED_Msk = 0x1e00
	// Position of FRAMERR field.
	USART_RXDATASTAT_FRAMERR_Pos = 0xd
	// Bit mask of FRAMERR field.
	USART_RXDATASTAT_FRAMERR_Msk = 0x2000
	// Bit FRAMERR.
	USART_RXDATASTAT_FRAMERR = 0x2000
	// Position of PARITYERR field.
	USART_RXDATASTAT_PARITYERR_Pos = 0xe
	// Bit mask of PARITYERR field.
	USART_RXDATASTAT_PARITYERR_Msk = 0x4000
	// Bit PARITYERR.
	USART_RXDATASTAT_PARITYERR = 0x4000
	// Position of RXNOISE field.
	USART_RXDATASTAT_RXNOISE_Pos = 0xf
	// Bit mask of RXNOISE field.
	USART_RXDATASTAT_RXNOISE_Msk = 0x8000
	// Bit RXNOISE.
	USART_RXDATASTAT_RXNOISE = 0x8000
	// Position of RESERVED field.
	USART_RXDATASTAT_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART_RXDATASTAT_RESERVED_Msk = 0xffff0000

	// TXDATA: Transmit Data register. Data to be transmitted is written here.
	// Position of TXDAT field.
	USART_TXDATA_TXDAT_Pos = 0x0
	// Bit mask of TXDAT field.
	USART_TXDATA_TXDAT_Msk = 0x1ff
	// Position of RESERVED field.
	USART_TXDATA_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART_TXDATA_RESERVED_Msk = 0xfffffe00

	// BRG: Baud Rate Generator register. 16-bit integer baud rate divisor value.
	// Position of BRGVAL field.
	USART_BRG_BRGVAL_Pos = 0x0
	// Bit mask of BRGVAL field.
	USART_BRG_BRGVAL_Msk = 0xffff
	// Position of RESERVED field.
	USART_BRG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART_BRG_RESERVED_Msk = 0xffff0000

	// INTSTAT: Interrupt status register. Reflects interrupts that are currently enabled.
	// Position of RXRDY field.
	USART_INTSTAT_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_INTSTAT_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_INTSTAT_RXRDY = 0x1
	// Position of RESERVED field.
	USART_INTSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART_INTSTAT_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USART_INTSTAT_RESERVED = 0x2
	// Position of TXRDY field.
	USART_INTSTAT_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	USART_INTSTAT_TXRDY_Msk = 0x4
	// Bit TXRDY.
	USART_INTSTAT_TXRDY = 0x4
	// Position of RESERVED field.
	USART_INTSTAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART_INTSTAT_RESERVED_Msk = 0x18
	// Position of DELTACTS field.
	USART_INTSTAT_DELTACTS_Pos = 0x5
	// Bit mask of DELTACTS field.
	USART_INTSTAT_DELTACTS_Msk = 0x20
	// Bit DELTACTS.
	USART_INTSTAT_DELTACTS = 0x20
	// Position of TXDISINT field.
	USART_INTSTAT_TXDISINT_Pos = 0x6
	// Bit mask of TXDISINT field.
	USART_INTSTAT_TXDISINT_Msk = 0x40
	// Bit TXDISINT.
	USART_INTSTAT_TXDISINT = 0x40
	// Position of RESERVED field.
	USART_INTSTAT_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART_INTSTAT_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART_INTSTAT_RESERVED = 0x80
	// Position of OVERRUNINT field.
	USART_INTSTAT_OVERRUNINT_Pos = 0x8
	// Bit mask of OVERRUNINT field.
	USART_INTSTAT_OVERRUNINT_Msk = 0x100
	// Bit OVERRUNINT.
	USART_INTSTAT_OVERRUNINT = 0x100
	// Position of RESERVED field.
	USART_INTSTAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART_INTSTAT_RESERVED_Msk = 0x600
	// Position of DELTARXBRK field.
	USART_INTSTAT_DELTARXBRK_Pos = 0xb
	// Bit mask of DELTARXBRK field.
	USART_INTSTAT_DELTARXBRK_Msk = 0x800
	// Bit DELTARXBRK.
	USART_INTSTAT_DELTARXBRK = 0x800
	// Position of START field.
	USART_INTSTAT_START_Pos = 0xc
	// Bit mask of START field.
	USART_INTSTAT_START_Msk = 0x1000
	// Bit START.
	USART_INTSTAT_START = 0x1000
	// Position of FRAMERRINT field.
	USART_INTSTAT_FRAMERRINT_Pos = 0xd
	// Bit mask of FRAMERRINT field.
	USART_INTSTAT_FRAMERRINT_Msk = 0x2000
	// Bit FRAMERRINT.
	USART_INTSTAT_FRAMERRINT = 0x2000
	// Position of PARITYERRINT field.
	USART_INTSTAT_PARITYERRINT_Pos = 0xe
	// Bit mask of PARITYERRINT field.
	USART_INTSTAT_PARITYERRINT_Msk = 0x4000
	// Bit PARITYERRINT.
	USART_INTSTAT_PARITYERRINT = 0x4000
	// Position of RXNOISEINT field.
	USART_INTSTAT_RXNOISEINT_Pos = 0xf
	// Bit mask of RXNOISEINT field.
	USART_INTSTAT_RXNOISEINT_Msk = 0x8000
	// Bit RXNOISEINT.
	USART_INTSTAT_RXNOISEINT = 0x8000
	// Position of RESERVED field.
	USART_INTSTAT_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART_INTSTAT_RESERVED_Msk = 0xffff0000
)

// Constants for CRC: Cyclic Redundancy Check (CRC) engine
const (
	// MODE: CRC mode register
	// Position of CRC_POLY field.
	CRC_MODE_CRC_POLY_Pos = 0x0
	// Bit mask of CRC_POLY field.
	CRC_MODE_CRC_POLY_Msk = 0x3
	// Position of BIT_RVS_WR field.
	CRC_MODE_BIT_RVS_WR_Pos = 0x2
	// Bit mask of BIT_RVS_WR field.
	CRC_MODE_BIT_RVS_WR_Msk = 0x4
	// Bit BIT_RVS_WR.
	CRC_MODE_BIT_RVS_WR = 0x4
	// Position of CMPL_WR field.
	CRC_MODE_CMPL_WR_Pos = 0x3
	// Bit mask of CMPL_WR field.
	CRC_MODE_CMPL_WR_Msk = 0x8
	// Bit CMPL_WR.
	CRC_MODE_CMPL_WR = 0x8
	// Position of BIT_RVS_SUM field.
	CRC_MODE_BIT_RVS_SUM_Pos = 0x4
	// Bit mask of BIT_RVS_SUM field.
	CRC_MODE_BIT_RVS_SUM_Msk = 0x10
	// Bit BIT_RVS_SUM.
	CRC_MODE_BIT_RVS_SUM = 0x10
	// Position of CMPL_SUM field.
	CRC_MODE_CMPL_SUM_Pos = 0x5
	// Bit mask of CMPL_SUM field.
	CRC_MODE_CMPL_SUM_Msk = 0x20
	// Bit CMPL_SUM.
	CRC_MODE_CMPL_SUM = 0x20
	// Position of Reserved field.
	CRC_MODE_Reserved_Pos = 0x6
	// Bit mask of Reserved field.
	CRC_MODE_Reserved_Msk = 0xffffffc0

	// SEED: CRC seed register
	// Position of CRC_SEED field.
	CRC_SEED_CRC_SEED_Pos = 0x0
	// Bit mask of CRC_SEED field.
	CRC_SEED_CRC_SEED_Msk = 0xffffffff

	// SUM: CRC checksum register
	// Position of CRC_SUM field.
	CRC_SUM_CRC_SUM_Pos = 0x0
	// Bit mask of CRC_SUM field.
	CRC_SUM_CRC_SUM_Msk = 0xffffffff

	// WR_DATA: CRC data register
	// Position of CRC_WR_DATA field.
	CRC_WR_DATA_CRC_WR_DATA_Pos = 0x0
	// Bit mask of CRC_WR_DATA field.
	CRC_WR_DATA_CRC_WR_DATA_Msk = 0xffffffff
)

// Constants for SCT: State Configurable Timer (SCT)
const (
	// CONFIG: SCT configuration register
	// Position of UNIFY field.
	SCT_CONFIG_UNIFY_Pos = 0x0
	// Bit mask of UNIFY field.
	SCT_CONFIG_UNIFY_Msk = 0x1
	// Bit UNIFY.
	SCT_CONFIG_UNIFY = 0x1
	// Position of CLKMODE field.
	SCT_CONFIG_CLKMODE_Pos = 0x1
	// Bit mask of CLKMODE field.
	SCT_CONFIG_CLKMODE_Msk = 0x6
	// The bus clock clocks the SCT and prescalers.
	SCT_CONFIG_CLKMODE_THE_BUS_CLOCK_CLOCKS = 0x0
	// The SCT clock is the bus clock, but the prescalers are enabled to count only when sampling of the input selected by the CKSEL field finds the selected edge. The minimum pulse width on the clock input is 1 bus clock period. This mode is the high-performance sampled-clock mode.
	SCT_CONFIG_CLKMODE_THE_SCT_CLOCK_IS_THE = 0x1
	// The input selected by CKSEL clocks the SCT and prescalers. The input is synchronized to the bus clock and possibly inverted. The minimum pulse width on the clock input is 1 bus clock period. This mode is the low-power sampled-clock mode.
	SCT_CONFIG_CLKMODE_THE_INPUT_SELECTED_B = 0x2
	// Reserved.
	SCT_CONFIG_CLKMODE_RESERVED_ = 0x3
	// Position of CLKSEL field.
	SCT_CONFIG_CLKSEL_Pos = 0x3
	// Bit mask of CLKSEL field.
	SCT_CONFIG_CLKSEL_Msk = 0x78
	// Position of NORELAOD_L field.
	SCT_CONFIG_NORELAOD_L_Pos = 0x7
	// Bit mask of NORELAOD_L field.
	SCT_CONFIG_NORELAOD_L_Msk = 0x80
	// Bit NORELAOD_L.
	SCT_CONFIG_NORELAOD_L = 0x80
	// Position of NORELOAD_H field.
	SCT_CONFIG_NORELOAD_H_Pos = 0x8
	// Bit mask of NORELOAD_H field.
	SCT_CONFIG_NORELOAD_H_Msk = 0x100
	// Bit NORELOAD_H.
	SCT_CONFIG_NORELOAD_H = 0x100
	// Position of INSYNC field.
	SCT_CONFIG_INSYNC_Pos = 0x9
	// Bit mask of INSYNC field.
	SCT_CONFIG_INSYNC_Msk = 0x1fe00
	// Position of AUTOLIMIT_L field.
	SCT_CONFIG_AUTOLIMIT_L_Pos = 0x11
	// Bit mask of AUTOLIMIT_L field.
	SCT_CONFIG_AUTOLIMIT_L_Msk = 0x20000
	// Bit AUTOLIMIT_L.
	SCT_CONFIG_AUTOLIMIT_L = 0x20000
	// Position of AUTOLIMIT_H field.
	SCT_CONFIG_AUTOLIMIT_H_Pos = 0x12
	// Bit mask of AUTOLIMIT_H field.
	SCT_CONFIG_AUTOLIMIT_H_Msk = 0x40000
	// Bit AUTOLIMIT_H.
	SCT_CONFIG_AUTOLIMIT_H = 0x40000
	// Position of RESERVED field.
	SCT_CONFIG_RESERVED_Pos = 0x13
	// Bit mask of RESERVED field.
	SCT_CONFIG_RESERVED_Msk = 0xfff80000

	// CTRL: SCT control register
	// Position of DOWN_L field.
	SCT_CTRL_DOWN_L_Pos = 0x0
	// Bit mask of DOWN_L field.
	SCT_CTRL_DOWN_L_Msk = 0x1
	// Bit DOWN_L.
	SCT_CTRL_DOWN_L = 0x1
	// Position of STOP_L field.
	SCT_CTRL_STOP_L_Pos = 0x1
	// Bit mask of STOP_L field.
	SCT_CTRL_STOP_L_Msk = 0x2
	// Bit STOP_L.
	SCT_CTRL_STOP_L = 0x2
	// Position of HALT_L field.
	SCT_CTRL_HALT_L_Pos = 0x2
	// Bit mask of HALT_L field.
	SCT_CTRL_HALT_L_Msk = 0x4
	// Bit HALT_L.
	SCT_CTRL_HALT_L = 0x4
	// Position of CLRCTR_L field.
	SCT_CTRL_CLRCTR_L_Pos = 0x3
	// Bit mask of CLRCTR_L field.
	SCT_CTRL_CLRCTR_L_Msk = 0x8
	// Bit CLRCTR_L.
	SCT_CTRL_CLRCTR_L = 0x8
	// Position of BIDIR_L field.
	SCT_CTRL_BIDIR_L_Pos = 0x4
	// Bit mask of BIDIR_L field.
	SCT_CTRL_BIDIR_L_Msk = 0x10
	// Bit BIDIR_L.
	SCT_CTRL_BIDIR_L = 0x10
	// Position of PRE_L field.
	SCT_CTRL_PRE_L_Pos = 0x5
	// Bit mask of PRE_L field.
	SCT_CTRL_PRE_L_Msk = 0x1fe0
	// Position of RESERVED field.
	SCT_CTRL_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	SCT_CTRL_RESERVED_Msk = 0xe000
	// Position of DOWN_H field.
	SCT_CTRL_DOWN_H_Pos = 0x10
	// Bit mask of DOWN_H field.
	SCT_CTRL_DOWN_H_Msk = 0x10000
	// Bit DOWN_H.
	SCT_CTRL_DOWN_H = 0x10000
	// Position of STOP_H field.
	SCT_CTRL_STOP_H_Pos = 0x11
	// Bit mask of STOP_H field.
	SCT_CTRL_STOP_H_Msk = 0x20000
	// Bit STOP_H.
	SCT_CTRL_STOP_H = 0x20000
	// Position of HALT_H field.
	SCT_CTRL_HALT_H_Pos = 0x12
	// Bit mask of HALT_H field.
	SCT_CTRL_HALT_H_Msk = 0x40000
	// Bit HALT_H.
	SCT_CTRL_HALT_H = 0x40000
	// Position of CLRCTR_H field.
	SCT_CTRL_CLRCTR_H_Pos = 0x13
	// Bit mask of CLRCTR_H field.
	SCT_CTRL_CLRCTR_H_Msk = 0x80000
	// Bit CLRCTR_H.
	SCT_CTRL_CLRCTR_H = 0x80000
	// Position of BIDIR_H field.
	SCT_CTRL_BIDIR_H_Pos = 0x14
	// Bit mask of BIDIR_H field.
	SCT_CTRL_BIDIR_H_Msk = 0x100000
	// Bit BIDIR_H.
	SCT_CTRL_BIDIR_H = 0x100000
	// Position of PRE_H field.
	SCT_CTRL_PRE_H_Pos = 0x15
	// Bit mask of PRE_H field.
	SCT_CTRL_PRE_H_Msk = 0x1fe00000
	// Position of RESERVED field.
	SCT_CTRL_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	SCT_CTRL_RESERVED_Msk = 0xe0000000

	// LIMIT: SCT limit register
	// Position of LIMMSK_L field.
	SCT_LIMIT_LIMMSK_L_Pos = 0x0
	// Bit mask of LIMMSK_L field.
	SCT_LIMIT_LIMMSK_L_Msk = 0x3f
	// Position of RESERVED field.
	SCT_LIMIT_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT_LIMIT_RESERVED_Msk = 0xffc0
	// Position of LIMMSK_H field.
	SCT_LIMIT_LIMMSK_H_Pos = 0x10
	// Bit mask of LIMMSK_H field.
	SCT_LIMIT_LIMMSK_H_Msk = 0x1f0000
	// Position of RESERVED field.
	SCT_LIMIT_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	SCT_LIMIT_RESERVED_Msk = 0xffe00000

	// HALT: SCT halt condition register
	// Position of HALTMSK_L field.
	SCT_HALT_HALTMSK_L_Pos = 0x0
	// Bit mask of HALTMSK_L field.
	SCT_HALT_HALTMSK_L_Msk = 0x3f
	// Position of RESERVED field.
	SCT_HALT_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT_HALT_RESERVED_Msk = 0xffc0
	// Position of HALTMSK_H field.
	SCT_HALT_HALTMSK_H_Pos = 0x10
	// Bit mask of HALTMSK_H field.
	SCT_HALT_HALTMSK_H_Msk = 0x1f0000
	// Position of RESERVED field.
	SCT_HALT_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	SCT_HALT_RESERVED_Msk = 0xffe00000

	// STOP: SCT stop condition register
	// Position of STOPMSK_L field.
	SCT_STOP_STOPMSK_L_Pos = 0x0
	// Bit mask of STOPMSK_L field.
	SCT_STOP_STOPMSK_L_Msk = 0x3f
	// Position of RESERVED field.
	SCT_STOP_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT_STOP_RESERVED_Msk = 0xffc0
	// Position of STOPMSK_H field.
	SCT_STOP_STOPMSK_H_Pos = 0x10
	// Bit mask of STOPMSK_H field.
	SCT_STOP_STOPMSK_H_Msk = 0x1f0000
	// Position of RESERVED field.
	SCT_STOP_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	SCT_STOP_RESERVED_Msk = 0xffe00000

	// START: SCT start condition register
	// Position of STARTMSK_L field.
	SCT_START_STARTMSK_L_Pos = 0x0
	// Bit mask of STARTMSK_L field.
	SCT_START_STARTMSK_L_Msk = 0x3f
	// Position of RESERVED field.
	SCT_START_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT_START_RESERVED_Msk = 0xffc0
	// Position of STARTMSK_H field.
	SCT_START_STARTMSK_H_Pos = 0x10
	// Bit mask of STARTMSK_H field.
	SCT_START_STARTMSK_H_Msk = 0x1f0000
	// Position of RESERVED field.
	SCT_START_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	SCT_START_RESERVED_Msk = 0xffe00000

	// COUNT: SCT counter register
	// Position of CTR_L field.
	SCT_COUNT_CTR_L_Pos = 0x0
	// Bit mask of CTR_L field.
	SCT_COUNT_CTR_L_Msk = 0xffff
	// Position of CTR_H field.
	SCT_COUNT_CTR_H_Pos = 0x10
	// Bit mask of CTR_H field.
	SCT_COUNT_CTR_H_Msk = 0xffff0000

	// STATE: SCT state register
	// Position of STATE_L field.
	SCT_STATE_STATE_L_Pos = 0x0
	// Bit mask of STATE_L field.
	SCT_STATE_STATE_L_Msk = 0x1f
	// Position of RESERVED field.
	SCT_STATE_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SCT_STATE_RESERVED_Msk = 0xffe0
	// Position of STATE_H field.
	SCT_STATE_STATE_H_Pos = 0x10
	// Bit mask of STATE_H field.
	SCT_STATE_STATE_H_Msk = 0x1f0000
	// Position of RESERVED field.
	SCT_STATE_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	SCT_STATE_RESERVED_Msk = 0xffe00000

	// INPUT: SCT input register
	// Position of AIN0 field.
	SCT_INPUT_AIN0_Pos = 0x0
	// Bit mask of AIN0 field.
	SCT_INPUT_AIN0_Msk = 0x1
	// Bit AIN0.
	SCT_INPUT_AIN0 = 0x1
	// Position of AIN1 field.
	SCT_INPUT_AIN1_Pos = 0x1
	// Bit mask of AIN1 field.
	SCT_INPUT_AIN1_Msk = 0x2
	// Bit AIN1.
	SCT_INPUT_AIN1 = 0x2
	// Position of AIN2 field.
	SCT_INPUT_AIN2_Pos = 0x2
	// Bit mask of AIN2 field.
	SCT_INPUT_AIN2_Msk = 0x4
	// Bit AIN2.
	SCT_INPUT_AIN2 = 0x4
	// Position of AIN3 field.
	SCT_INPUT_AIN3_Pos = 0x3
	// Bit mask of AIN3 field.
	SCT_INPUT_AIN3_Msk = 0x8
	// Bit AIN3.
	SCT_INPUT_AIN3 = 0x8
	// Position of RESERVED field.
	SCT_INPUT_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SCT_INPUT_RESERVED_Msk = 0xfff0
	// Position of SIN0 field.
	SCT_INPUT_SIN0_Pos = 0x10
	// Bit mask of SIN0 field.
	SCT_INPUT_SIN0_Msk = 0x10000
	// Bit SIN0.
	SCT_INPUT_SIN0 = 0x10000
	// Position of SIN1 field.
	SCT_INPUT_SIN1_Pos = 0x11
	// Bit mask of SIN1 field.
	SCT_INPUT_SIN1_Msk = 0x20000
	// Bit SIN1.
	SCT_INPUT_SIN1 = 0x20000
	// Position of SIN2 field.
	SCT_INPUT_SIN2_Pos = 0x12
	// Bit mask of SIN2 field.
	SCT_INPUT_SIN2_Msk = 0x40000
	// Bit SIN2.
	SCT_INPUT_SIN2 = 0x40000
	// Position of SIN3 field.
	SCT_INPUT_SIN3_Pos = 0x13
	// Bit mask of SIN3 field.
	SCT_INPUT_SIN3_Msk = 0x80000
	// Bit SIN3.
	SCT_INPUT_SIN3 = 0x80000
	// Position of RESERVED field.
	SCT_INPUT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	SCT_INPUT_RESERVED_Msk = 0xfff00000

	// REGMODE: SCT match/capture registers mode register
	// Position of REGMOD_L field.
	SCT_REGMODE_REGMOD_L_Pos = 0x0
	// Bit mask of REGMOD_L field.
	SCT_REGMODE_REGMOD_L_Msk = 0x1f
	// Position of RESERVED field.
	SCT_REGMODE_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SCT_REGMODE_RESERVED_Msk = 0xffe0
	// Position of REGMOD_H field.
	SCT_REGMODE_REGMOD_H_Pos = 0x10
	// Bit mask of REGMOD_H field.
	SCT_REGMODE_REGMOD_H_Msk = 0xf0000
	// Position of RESERVED field.
	SCT_REGMODE_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	SCT_REGMODE_RESERVED_Msk = 0xfff00000

	// OUTPUT: SCT output register
	// Position of OUT field.
	SCT_OUTPUT_OUT_Pos = 0x0
	// Bit mask of OUT field.
	SCT_OUTPUT_OUT_Msk = 0xf
	// Position of RESERVED field.
	SCT_OUTPUT_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SCT_OUTPUT_RESERVED_Msk = 0xfffffff0

	// OUTPUTDIRCTRL: SCT output counter direction control register
	// Position of SETCLR0 field.
	SCT_OUTPUTDIRCTRL_SETCLR0_Pos = 0x0
	// Bit mask of SETCLR0 field.
	SCT_OUTPUTDIRCTRL_SETCLR0_Msk = 0x3
	// Set and clear do not depend on any counter.
	SCT_OUTPUTDIRCTRL_SETCLR0_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of SETCLR1 field.
	SCT_OUTPUTDIRCTRL_SETCLR1_Pos = 0x2
	// Bit mask of SETCLR1 field.
	SCT_OUTPUTDIRCTRL_SETCLR1_Msk = 0xc
	// Set and clear do not depend on any counter.
	SCT_OUTPUTDIRCTRL_SETCLR1_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of SETCLR2 field.
	SCT_OUTPUTDIRCTRL_SETCLR2_Pos = 0x4
	// Bit mask of SETCLR2 field.
	SCT_OUTPUTDIRCTRL_SETCLR2_Msk = 0x30
	// Set and clear do not depend on any counter.
	SCT_OUTPUTDIRCTRL_SETCLR2_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of SETCLR3 field.
	SCT_OUTPUTDIRCTRL_SETCLR3_Pos = 0x6
	// Bit mask of SETCLR3 field.
	SCT_OUTPUTDIRCTRL_SETCLR3_Msk = 0xc0
	// Set and clear do not depend on any counter.
	SCT_OUTPUTDIRCTRL_SETCLR3_SET_AND_CLEAR_DO_NOT = 0x0
	// Position of RESERVED field.
	SCT_OUTPUTDIRCTRL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCT_OUTPUTDIRCTRL_RESERVED_Msk = 0xffffff00

	// RES: SCT conflict resolution register
	// Position of O0RES field.
	SCT_RES_O0RES_Pos = 0x0
	// Bit mask of O0RES field.
	SCT_RES_O0RES_Msk = 0x3
	// No change.
	SCT_RES_O0RES_NO_CHANGE_ = 0x0
	// Set output (or clear based on the SETCLR0 field).
	SCT_RES_O0RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR0 field).
	SCT_RES_O0RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT_RES_O0RES_TOGGLE_OUTPUT_ = 0x3
	// Position of O1RES field.
	SCT_RES_O1RES_Pos = 0x2
	// Bit mask of O1RES field.
	SCT_RES_O1RES_Msk = 0xc
	// No change.
	SCT_RES_O1RES_NO_CHANGE_ = 0x0
	// Set output (or clear based on the SETCLR1 field).
	SCT_RES_O1RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR1 field).
	SCT_RES_O1RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT_RES_O1RES_TOGGLE_OUTPUT_ = 0x3
	// Position of O2RES field.
	SCT_RES_O2RES_Pos = 0x4
	// Bit mask of O2RES field.
	SCT_RES_O2RES_Msk = 0x30
	// No change.
	SCT_RES_O2RES_NO_CHANGE_ = 0x0
	// Set output (or clear based on the SETCLR2 field).
	SCT_RES_O2RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output n (or set based on the SETCLR2 field).
	SCT_RES_O2RES_CLEAR_OUTPUT_N_OR_S = 0x2
	// Toggle output.
	SCT_RES_O2RES_TOGGLE_OUTPUT_ = 0x3
	// Position of O3RES field.
	SCT_RES_O3RES_Pos = 0x6
	// Bit mask of O3RES field.
	SCT_RES_O3RES_Msk = 0xc0
	// No change.
	SCT_RES_O3RES_NO_CHANGE_ = 0x0
	// Set output (or clear based on the SETCLR3 field).
	SCT_RES_O3RES_SET_OUTPUT_OR_CLEAR = 0x1
	// Clear output (or set based on the SETCLR3 field).
	SCT_RES_O3RES_CLEAR_OUTPUT_OR_SET = 0x2
	// Toggle output.
	SCT_RES_O3RES_TOGGLE_OUTPUT_ = 0x3
	// Position of RESERVED field.
	SCT_RES_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCT_RES_RESERVED_Msk = 0xffffff00

	// EVEN: SCT event enable register
	// Position of IEN field.
	SCT_EVEN_IEN_Pos = 0x0
	// Bit mask of IEN field.
	SCT_EVEN_IEN_Msk = 0x3f
	// Position of RESERVED field.
	SCT_EVEN_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT_EVEN_RESERVED_Msk = 0xffffffc0

	// EVFLAG: SCT event flag register
	// Position of FLAG field.
	SCT_EVFLAG_FLAG_Pos = 0x0
	// Bit mask of FLAG field.
	SCT_EVFLAG_FLAG_Msk = 0x3f
	// Position of RESERVED field.
	SCT_EVFLAG_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT_EVFLAG_RESERVED_Msk = 0xffffffc0

	// CONEN: SCT conflict enable register
	// Position of NCEN field.
	SCT_CONEN_NCEN_Pos = 0x0
	// Bit mask of NCEN field.
	SCT_CONEN_NCEN_Msk = 0xf
	// Position of RESERVED field.
	SCT_CONEN_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SCT_CONEN_RESERVED_Msk = 0xfffffff0

	// CONFLAG: SCT conflict flag register
	// Position of NCFLAG field.
	SCT_CONFLAG_NCFLAG_Pos = 0x0
	// Bit mask of NCFLAG field.
	SCT_CONFLAG_NCFLAG_Msk = 0xf
	// Position of RESERVED field.
	SCT_CONFLAG_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SCT_CONFLAG_RESERVED_Msk = 0x3ffffff0
	// Position of BUSERRL field.
	SCT_CONFLAG_BUSERRL_Pos = 0x1e
	// Bit mask of BUSERRL field.
	SCT_CONFLAG_BUSERRL_Msk = 0x40000000
	// Bit BUSERRL.
	SCT_CONFLAG_BUSERRL = 0x40000000
	// Position of BUSERRH field.
	SCT_CONFLAG_BUSERRH_Pos = 0x1f
	// Bit mask of BUSERRH field.
	SCT_CONFLAG_BUSERRH_Msk = 0x80000000
	// Bit BUSERRH.
	SCT_CONFLAG_BUSERRH = 0x80000000

	// MATCH0: SCT match value register of match channels 0 to 4; REGMOD0 to REGMODE4 = 0
	// Position of MATCHn_L field.
	SCT_MATCH_MATCHn_L_Pos = 0x0
	// Bit mask of MATCHn_L field.
	SCT_MATCH_MATCHn_L_Msk = 0xffff
	// Position of MATCHn_H field.
	SCT_MATCH_MATCHn_H_Pos = 0x10
	// Bit mask of MATCHn_H field.
	SCT_MATCH_MATCHn_H_Msk = 0xffff0000

	// CAP0: SCT capture register of capture channel 0 to 4; REGMOD0 to REGMODE4 = 1
	// Position of CAPn_L field.
	SCT_CAP_CAPn_L_Pos = 0x0
	// Bit mask of CAPn_L field.
	SCT_CAP_CAPn_L_Msk = 0xffff
	// Position of CAPn_H field.
	SCT_CAP_CAPn_H_Pos = 0x10
	// Bit mask of CAPn_H field.
	SCT_CAP_CAPn_H_Msk = 0xffff0000

	// MATCHREL0: SCT match reload value register 0 to 4 REGMOD0 = 0 to REGMODE4 = 0
	// Position of RELOADn_L field.
	SCT_MATCHREL_RELOADn_L_Pos = 0x0
	// Bit mask of RELOADn_L field.
	SCT_MATCHREL_RELOADn_L_Msk = 0xffff
	// Position of RELOADn_H field.
	SCT_MATCHREL_RELOADn_H_Pos = 0x10
	// Bit mask of RELOADn_H field.
	SCT_MATCHREL_RELOADn_H_Msk = 0xffff0000

	// CAPCTRL0: SCT capture control register 0 to 4; REGMOD0 = 1 to REGMODE4 = 1
	// Position of CAPCONm_L field.
	SCT_CAPCTRL_CAPCONm_L_Pos = 0x0
	// Bit mask of CAPCONm_L field.
	SCT_CAPCTRL_CAPCONm_L_Msk = 0x3f
	// Position of RESERVED field.
	SCT_CAPCTRL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT_CAPCTRL_RESERVED_Msk = 0xffc0
	// Position of CAPCONm_H field.
	SCT_CAPCTRL_CAPCONm_H_Pos = 0x10
	// Bit mask of CAPCONm_H field.
	SCT_CAPCTRL_CAPCONm_H_Msk = 0x1f0000
	// Position of RESERVED field.
	SCT_CAPCTRL_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	SCT_CAPCTRL_RESERVED_Msk = 0xfffe0000

	// EV0_STATE: SCT event state register 0
	// Position of STATEMSKm field.
	SCT_EV0_STATE_STATEMSKm_Pos = 0x0
	// Bit mask of STATEMSKm field.
	SCT_EV0_STATE_STATEMSKm_Msk = 0x3
	// Position of RESERVED field.
	SCT_EV0_STATE_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SCT_EV0_STATE_RESERVED_Msk = 0xfffffffc

	// EV0_CTRL: SCT event control register 0
	// Position of MATCHSEL field.
	SCT_EV0_CTRL_MATCHSEL_Pos = 0x0
	// Bit mask of MATCHSEL field.
	SCT_EV0_CTRL_MATCHSEL_Msk = 0xf
	// Position of HEVENT field.
	SCT_EV0_CTRL_HEVENT_Pos = 0x4
	// Bit mask of HEVENT field.
	SCT_EV0_CTRL_HEVENT_Msk = 0x10
	// Bit HEVENT.
	SCT_EV0_CTRL_HEVENT = 0x10
	// Selects the L state and the L match register selected by MATCHSEL.
	SCT_EV0_CTRL_HEVENT_SELECTS_THE_L_STATE_ = 0x0
	// Selects the H state and the H match register selected by MATCHSEL.
	SCT_EV0_CTRL_HEVENT_SELECTS_THE_H_STATE_ = 0x1
	// Position of OUTSEL field.
	SCT_EV0_CTRL_OUTSEL_Pos = 0x5
	// Bit mask of OUTSEL field.
	SCT_EV0_CTRL_OUTSEL_Msk = 0x20
	// Bit OUTSEL.
	SCT_EV0_CTRL_OUTSEL = 0x20
	// Selects the inputs elected by IOSEL.
	SCT_EV0_CTRL_OUTSEL_SELECTS_THE_INPUTS_E = 0x0
	// Selects the outputs selected by IOSEL.
	SCT_EV0_CTRL_OUTSEL_SELECTS_THE_OUTPUTS_ = 0x1
	// Position of IOSEL field.
	SCT_EV0_CTRL_IOSEL_Pos = 0x6
	// Bit mask of IOSEL field.
	SCT_EV0_CTRL_IOSEL_Msk = 0x3c0
	// Position of IOCOND field.
	SCT_EV0_CTRL_IOCOND_Pos = 0xa
	// Bit mask of IOCOND field.
	SCT_EV0_CTRL_IOCOND_Msk = 0xc00
	// LOW
	SCT_EV0_CTRL_IOCOND_LOW = 0x0
	// Rise
	SCT_EV0_CTRL_IOCOND_RISE = 0x1
	// Fall
	SCT_EV0_CTRL_IOCOND_FALL = 0x2
	// HIGH
	SCT_EV0_CTRL_IOCOND_HIGH = 0x3
	// Position of COMBMODE field.
	SCT_EV0_CTRL_COMBMODE_Pos = 0xc
	// Bit mask of COMBMODE field.
	SCT_EV0_CTRL_COMBMODE_Msk = 0x3000
	// OR. The event occurs when either the specified match or I/O condition occurs.
	SCT_EV0_CTRL_COMBMODE_OR_THE_EVENT_OCCURS = 0x0
	// MATCH. Uses the specified match only.
	SCT_EV0_CTRL_COMBMODE_MATCH_USES_THE_SPEC = 0x1
	// IO. Uses the specified I/O condition only.
	SCT_EV0_CTRL_COMBMODE_IO_USES_THE_SPECIFI = 0x2
	// AND. The event occurs when the specified match and I/O condition occur simultaneously.
	SCT_EV0_CTRL_COMBMODE_AND_THE_EVENT_OCCUR = 0x3
	// Position of STATELD field.
	SCT_EV0_CTRL_STATELD_Pos = 0xe
	// Bit mask of STATELD field.
	SCT_EV0_CTRL_STATELD_Msk = 0x4000
	// Bit STATELD.
	SCT_EV0_CTRL_STATELD = 0x4000
	// STATEV value is added into STATE (the carry-out is ignored).
	SCT_EV0_CTRL_STATELD_STATEV_VALUE_IS_ADDE = 0x0
	// STATEV value is loaded into STATE.
	SCT_EV0_CTRL_STATELD_STATEV_VALUE_IS_LOAD = 0x1
	// Position of STATEV field.
	SCT_EV0_CTRL_STATEV_Pos = 0xf
	// Bit mask of STATEV field.
	SCT_EV0_CTRL_STATEV_Msk = 0xf8000
	// Position of MATCHMEM field.
	SCT_EV0_CTRL_MATCHMEM_Pos = 0x14
	// Bit mask of MATCHMEM field.
	SCT_EV0_CTRL_MATCHMEM_Msk = 0x100000
	// Bit MATCHMEM.
	SCT_EV0_CTRL_MATCHMEM = 0x100000
	// Position of DIRECTION field.
	SCT_EV0_CTRL_DIRECTION_Pos = 0x15
	// Bit mask of DIRECTION field.
	SCT_EV0_CTRL_DIRECTION_Msk = 0x600000
	// Direction independent. This event is triggered regardless of the count direction.
	SCT_EV0_CTRL_DIRECTION_DIRECTION_INDEPENDEN = 0x0
	// Counting up. This event is triggered only during up-counting when BIDIR = 1.
	SCT_EV0_CTRL_DIRECTION_COUNTING_UP_THIS_EV = 0x1
	// Counting down. This event is triggered only during down-counting when BIDIR = 1.
	SCT_EV0_CTRL_DIRECTION_COUNTING_DOWN_THIS_ = 0x2
	// Position of RESERVED field.
	SCT_EV0_CTRL_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	SCT_EV0_CTRL_RESERVED_Msk = 0xff800000

	// EV1_STATE: SCT event state register 1
	// Position of STATEMSKm field.
	SCT_EV1_STATE_STATEMSKm_Pos = 0x0
	// Bit mask of STATEMSKm field.
	SCT_EV1_STATE_STATEMSKm_Msk = 0x3
	// Position of RESERVED field.
	SCT_EV1_STATE_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SCT_EV1_STATE_RESERVED_Msk = 0xfffffffc

	// EV1_CTRL: SCT event control register 1
	// Position of MATCHSEL field.
	SCT_EV1_CTRL_MATCHSEL_Pos = 0x0
	// Bit mask of MATCHSEL field.
	SCT_EV1_CTRL_MATCHSEL_Msk = 0xf
	// Position of HEVENT field.
	SCT_EV1_CTRL_HEVENT_Pos = 0x4
	// Bit mask of HEVENT field.
	SCT_EV1_CTRL_HEVENT_Msk = 0x10
	// Bit HEVENT.
	SCT_EV1_CTRL_HEVENT = 0x10
	// Selects the L state and the L match register selected by MATCHSEL.
	SCT_EV1_CTRL_HEVENT_SELECTS_THE_L_STATE_ = 0x0
	// Selects the H state and the H match register selected by MATCHSEL.
	SCT_EV1_CTRL_HEVENT_SELECTS_THE_H_STATE_ = 0x1
	// Position of OUTSEL field.
	SCT_EV1_CTRL_OUTSEL_Pos = 0x5
	// Bit mask of OUTSEL field.
	SCT_EV1_CTRL_OUTSEL_Msk = 0x20
	// Bit OUTSEL.
	SCT_EV1_CTRL_OUTSEL = 0x20
	// Selects the inputs elected by IOSEL.
	SCT_EV1_CTRL_OUTSEL_SELECTS_THE_INPUTS_E = 0x0
	// Selects the outputs selected by IOSEL.
	SCT_EV1_CTRL_OUTSEL_SELECTS_THE_OUTPUTS_ = 0x1
	// Position of IOSEL field.
	SCT_EV1_CTRL_IOSEL_Pos = 0x6
	// Bit mask of IOSEL field.
	SCT_EV1_CTRL_IOSEL_Msk = 0x3c0
	// Position of IOCOND field.
	SCT_EV1_CTRL_IOCOND_Pos = 0xa
	// Bit mask of IOCOND field.
	SCT_EV1_CTRL_IOCOND_Msk = 0xc00
	// LOW
	SCT_EV1_CTRL_IOCOND_LOW = 0x0
	// Rise
	SCT_EV1_CTRL_IOCOND_RISE = 0x1
	// Fall
	SCT_EV1_CTRL_IOCOND_FALL = 0x2
	// HIGH
	SCT_EV1_CTRL_IOCOND_HIGH = 0x3
	// Position of COMBMODE field.
	SCT_EV1_CTRL_COMBMODE_Pos = 0xc
	// Bit mask of COMBMODE field.
	SCT_EV1_CTRL_COMBMODE_Msk = 0x3000
	// OR. The event occurs when either the specified match or I/O condition occurs.
	SCT_EV1_CTRL_COMBMODE_OR_THE_EVENT_OCCURS = 0x0
	// MATCH. Uses the specified match only.
	SCT_EV1_CTRL_COMBMODE_MATCH_USES_THE_SPEC = 0x1
	// IO. Uses the specified I/O condition only.
	SCT_EV1_CTRL_COMBMODE_IO_USES_THE_SPECIFI = 0x2
	// AND. The event occurs when the specified match and I/O condition occur simultaneously.
	SCT_EV1_CTRL_COMBMODE_AND_THE_EVENT_OCCUR = 0x3
	// Position of STATELD field.
	SCT_EV1_CTRL_STATELD_Pos = 0xe
	// Bit mask of STATELD field.
	SCT_EV1_CTRL_STATELD_Msk = 0x4000
	// Bit STATELD.
	SCT_EV1_CTRL_STATELD = 0x4000
	// STATEV value is added into STATE (the carry-out is ignored).
	SCT_EV1_CTRL_STATELD_STATEV_VALUE_IS_ADDE = 0x0
	// STATEV value is loaded into STATE.
	SCT_EV1_CTRL_STATELD_STATEV_VALUE_IS_LOAD = 0x1
	// Position of STATEV field.
	SCT_EV1_CTRL_STATEV_Pos = 0xf
	// Bit mask of STATEV field.
	SCT_EV1_CTRL_STATEV_Msk = 0xf8000
	// Position of MATCHMEM field.
	SCT_EV1_CTRL_MATCHMEM_Pos = 0x14
	// Bit mask of MATCHMEM field.
	SCT_EV1_CTRL_MATCHMEM_Msk = 0x100000
	// Bit MATCHMEM.
	SCT_EV1_CTRL_MATCHMEM = 0x100000
	// Position of DIRECTION field.
	SCT_EV1_CTRL_DIRECTION_Pos = 0x15
	// Bit mask of DIRECTION field.
	SCT_EV1_CTRL_DIRECTION_Msk = 0x600000
	// Direction independent. This event is triggered regardless of the count direction.
	SCT_EV1_CTRL_DIRECTION_DIRECTION_INDEPENDEN = 0x0
	// Counting up. This event is triggered only during up-counting when BIDIR = 1.
	SCT_EV1_CTRL_DIRECTION_COUNTING_UP_THIS_EV = 0x1
	// Counting down. This event is triggered only during down-counting when BIDIR = 1.
	SCT_EV1_CTRL_DIRECTION_COUNTING_DOWN_THIS_ = 0x2
	// Position of RESERVED field.
	SCT_EV1_CTRL_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	SCT_EV1_CTRL_RESERVED_Msk = 0xff800000

	// EV2_STATE: SCT event state register 2
	// Position of STATEMSKm field.
	SCT_EV2_STATE_STATEMSKm_Pos = 0x0
	// Bit mask of STATEMSKm field.
	SCT_EV2_STATE_STATEMSKm_Msk = 0x3
	// Position of RESERVED field.
	SCT_EV2_STATE_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SCT_EV2_STATE_RESERVED_Msk = 0xfffffffc

	// EV2_CTRL: SCT event control register 2
	// Position of MATCHSEL field.
	SCT_EV2_CTRL_MATCHSEL_Pos = 0x0
	// Bit mask of MATCHSEL field.
	SCT_EV2_CTRL_MATCHSEL_Msk = 0xf
	// Position of HEVENT field.
	SCT_EV2_CTRL_HEVENT_Pos = 0x4
	// Bit mask of HEVENT field.
	SCT_EV2_CTRL_HEVENT_Msk = 0x10
	// Bit HEVENT.
	SCT_EV2_CTRL_HEVENT = 0x10
	// Selects the L state and the L match register selected by MATCHSEL.
	SCT_EV2_CTRL_HEVENT_SELECTS_THE_L_STATE_ = 0x0
	// Selects the H state and the H match register selected by MATCHSEL.
	SCT_EV2_CTRL_HEVENT_SELECTS_THE_H_STATE_ = 0x1
	// Position of OUTSEL field.
	SCT_EV2_CTRL_OUTSEL_Pos = 0x5
	// Bit mask of OUTSEL field.
	SCT_EV2_CTRL_OUTSEL_Msk = 0x20
	// Bit OUTSEL.
	SCT_EV2_CTRL_OUTSEL = 0x20
	// Selects the inputs elected by IOSEL.
	SCT_EV2_CTRL_OUTSEL_SELECTS_THE_INPUTS_E = 0x0
	// Selects the outputs selected by IOSEL.
	SCT_EV2_CTRL_OUTSEL_SELECTS_THE_OUTPUTS_ = 0x1
	// Position of IOSEL field.
	SCT_EV2_CTRL_IOSEL_Pos = 0x6
	// Bit mask of IOSEL field.
	SCT_EV2_CTRL_IOSEL_Msk = 0x3c0
	// Position of IOCOND field.
	SCT_EV2_CTRL_IOCOND_Pos = 0xa
	// Bit mask of IOCOND field.
	SCT_EV2_CTRL_IOCOND_Msk = 0xc00
	// LOW
	SCT_EV2_CTRL_IOCOND_LOW = 0x0
	// Rise
	SCT_EV2_CTRL_IOCOND_RISE = 0x1
	// Fall
	SCT_EV2_CTRL_IOCOND_FALL = 0x2
	// HIGH
	SCT_EV2_CTRL_IOCOND_HIGH = 0x3
	// Position of COMBMODE field.
	SCT_EV2_CTRL_COMBMODE_Pos = 0xc
	// Bit mask of COMBMODE field.
	SCT_EV2_CTRL_COMBMODE_Msk = 0x3000
	// OR. The event occurs when either the specified match or I/O condition occurs.
	SCT_EV2_CTRL_COMBMODE_OR_THE_EVENT_OCCURS = 0x0
	// MATCH. Uses the specified match only.
	SCT_EV2_CTRL_COMBMODE_MATCH_USES_THE_SPEC = 0x1
	// IO. Uses the specified I/O condition only.
	SCT_EV2_CTRL_COMBMODE_IO_USES_THE_SPECIFI = 0x2
	// AND. The event occurs when the specified match and I/O condition occur simultaneously.
	SCT_EV2_CTRL_COMBMODE_AND_THE_EVENT_OCCUR = 0x3
	// Position of STATELD field.
	SCT_EV2_CTRL_STATELD_Pos = 0xe
	// Bit mask of STATELD field.
	SCT_EV2_CTRL_STATELD_Msk = 0x4000
	// Bit STATELD.
	SCT_EV2_CTRL_STATELD = 0x4000
	// STATEV value is added into STATE (the carry-out is ignored).
	SCT_EV2_CTRL_STATELD_STATEV_VALUE_IS_ADDE = 0x0
	// STATEV value is loaded into STATE.
	SCT_EV2_CTRL_STATELD_STATEV_VALUE_IS_LOAD = 0x1
	// Position of STATEV field.
	SCT_EV2_CTRL_STATEV_Pos = 0xf
	// Bit mask of STATEV field.
	SCT_EV2_CTRL_STATEV_Msk = 0xf8000
	// Position of MATCHMEM field.
	SCT_EV2_CTRL_MATCHMEM_Pos = 0x14
	// Bit mask of MATCHMEM field.
	SCT_EV2_CTRL_MATCHMEM_Msk = 0x100000
	// Bit MATCHMEM.
	SCT_EV2_CTRL_MATCHMEM = 0x100000
	// Position of DIRECTION field.
	SCT_EV2_CTRL_DIRECTION_Pos = 0x15
	// Bit mask of DIRECTION field.
	SCT_EV2_CTRL_DIRECTION_Msk = 0x600000
	// Direction independent. This event is triggered regardless of the count direction.
	SCT_EV2_CTRL_DIRECTION_DIRECTION_INDEPENDEN = 0x0
	// Counting up. This event is triggered only during up-counting when BIDIR = 1.
	SCT_EV2_CTRL_DIRECTION_COUNTING_UP_THIS_EV = 0x1
	// Counting down. This event is triggered only during down-counting when BIDIR = 1.
	SCT_EV2_CTRL_DIRECTION_COUNTING_DOWN_THIS_ = 0x2
	// Position of RESERVED field.
	SCT_EV2_CTRL_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	SCT_EV2_CTRL_RESERVED_Msk = 0xff800000

	// EV3_STATE: SCT event state register 3
	// Position of STATEMSKm field.
	SCT_EV3_STATE_STATEMSKm_Pos = 0x0
	// Bit mask of STATEMSKm field.
	SCT_EV3_STATE_STATEMSKm_Msk = 0x3
	// Position of RESERVED field.
	SCT_EV3_STATE_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SCT_EV3_STATE_RESERVED_Msk = 0xfffffffc

	// EV3_CTRL: SCT event control register 3
	// Position of MATCHSEL field.
	SCT_EV3_CTRL_MATCHSEL_Pos = 0x0
	// Bit mask of MATCHSEL field.
	SCT_EV3_CTRL_MATCHSEL_Msk = 0xf
	// Position of HEVENT field.
	SCT_EV3_CTRL_HEVENT_Pos = 0x4
	// Bit mask of HEVENT field.
	SCT_EV3_CTRL_HEVENT_Msk = 0x10
	// Bit HEVENT.
	SCT_EV3_CTRL_HEVENT = 0x10
	// Selects the L state and the L match register selected by MATCHSEL.
	SCT_EV3_CTRL_HEVENT_SELECTS_THE_L_STATE_ = 0x0
	// Selects the H state and the H match register selected by MATCHSEL.
	SCT_EV3_CTRL_HEVENT_SELECTS_THE_H_STATE_ = 0x1
	// Position of OUTSEL field.
	SCT_EV3_CTRL_OUTSEL_Pos = 0x5
	// Bit mask of OUTSEL field.
	SCT_EV3_CTRL_OUTSEL_Msk = 0x20
	// Bit OUTSEL.
	SCT_EV3_CTRL_OUTSEL = 0x20
	// Selects the inputs elected by IOSEL.
	SCT_EV3_CTRL_OUTSEL_SELECTS_THE_INPUTS_E = 0x0
	// Selects the outputs selected by IOSEL.
	SCT_EV3_CTRL_OUTSEL_SELECTS_THE_OUTPUTS_ = 0x1
	// Position of IOSEL field.
	SCT_EV3_CTRL_IOSEL_Pos = 0x6
	// Bit mask of IOSEL field.
	SCT_EV3_CTRL_IOSEL_Msk = 0x3c0
	// Position of IOCOND field.
	SCT_EV3_CTRL_IOCOND_Pos = 0xa
	// Bit mask of IOCOND field.
	SCT_EV3_CTRL_IOCOND_Msk = 0xc00
	// LOW
	SCT_EV3_CTRL_IOCOND_LOW = 0x0
	// Rise
	SCT_EV3_CTRL_IOCOND_RISE = 0x1
	// Fall
	SCT_EV3_CTRL_IOCOND_FALL = 0x2
	// HIGH
	SCT_EV3_CTRL_IOCOND_HIGH = 0x3
	// Position of COMBMODE field.
	SCT_EV3_CTRL_COMBMODE_Pos = 0xc
	// Bit mask of COMBMODE field.
	SCT_EV3_CTRL_COMBMODE_Msk = 0x3000
	// OR. The event occurs when either the specified match or I/O condition occurs.
	SCT_EV3_CTRL_COMBMODE_OR_THE_EVENT_OCCURS = 0x0
	// MATCH. Uses the specified match only.
	SCT_EV3_CTRL_COMBMODE_MATCH_USES_THE_SPEC = 0x1
	// IO. Uses the specified I/O condition only.
	SCT_EV3_CTRL_COMBMODE_IO_USES_THE_SPECIFI = 0x2
	// AND. The event occurs when the specified match and I/O condition occur simultaneously.
	SCT_EV3_CTRL_COMBMODE_AND_THE_EVENT_OCCUR = 0x3
	// Position of STATELD field.
	SCT_EV3_CTRL_STATELD_Pos = 0xe
	// Bit mask of STATELD field.
	SCT_EV3_CTRL_STATELD_Msk = 0x4000
	// Bit STATELD.
	SCT_EV3_CTRL_STATELD = 0x4000
	// STATEV value is added into STATE (the carry-out is ignored).
	SCT_EV3_CTRL_STATELD_STATEV_VALUE_IS_ADDE = 0x0
	// STATEV value is loaded into STATE.
	SCT_EV3_CTRL_STATELD_STATEV_VALUE_IS_LOAD = 0x1
	// Position of STATEV field.
	SCT_EV3_CTRL_STATEV_Pos = 0xf
	// Bit mask of STATEV field.
	SCT_EV3_CTRL_STATEV_Msk = 0xf8000
	// Position of MATCHMEM field.
	SCT_EV3_CTRL_MATCHMEM_Pos = 0x14
	// Bit mask of MATCHMEM field.
	SCT_EV3_CTRL_MATCHMEM_Msk = 0x100000
	// Bit MATCHMEM.
	SCT_EV3_CTRL_MATCHMEM = 0x100000
	// Position of DIRECTION field.
	SCT_EV3_CTRL_DIRECTION_Pos = 0x15
	// Bit mask of DIRECTION field.
	SCT_EV3_CTRL_DIRECTION_Msk = 0x600000
	// Direction independent. This event is triggered regardless of the count direction.
	SCT_EV3_CTRL_DIRECTION_DIRECTION_INDEPENDEN = 0x0
	// Counting up. This event is triggered only during up-counting when BIDIR = 1.
	SCT_EV3_CTRL_DIRECTION_COUNTING_UP_THIS_EV = 0x1
	// Counting down. This event is triggered only during down-counting when BIDIR = 1.
	SCT_EV3_CTRL_DIRECTION_COUNTING_DOWN_THIS_ = 0x2
	// Position of RESERVED field.
	SCT_EV3_CTRL_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	SCT_EV3_CTRL_RESERVED_Msk = 0xff800000

	// EV4_STATE: SCT event state register 4
	// Position of STATEMSKm field.
	SCT_EV4_STATE_STATEMSKm_Pos = 0x0
	// Bit mask of STATEMSKm field.
	SCT_EV4_STATE_STATEMSKm_Msk = 0x3
	// Position of RESERVED field.
	SCT_EV4_STATE_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SCT_EV4_STATE_RESERVED_Msk = 0xfffffffc

	// EV4_CTRL: SCT event control register 4
	// Position of MATCHSEL field.
	SCT_EV4_CTRL_MATCHSEL_Pos = 0x0
	// Bit mask of MATCHSEL field.
	SCT_EV4_CTRL_MATCHSEL_Msk = 0xf
	// Position of HEVENT field.
	SCT_EV4_CTRL_HEVENT_Pos = 0x4
	// Bit mask of HEVENT field.
	SCT_EV4_CTRL_HEVENT_Msk = 0x10
	// Bit HEVENT.
	SCT_EV4_CTRL_HEVENT = 0x10
	// Selects the L state and the L match register selected by MATCHSEL.
	SCT_EV4_CTRL_HEVENT_SELECTS_THE_L_STATE_ = 0x0
	// Selects the H state and the H match register selected by MATCHSEL.
	SCT_EV4_CTRL_HEVENT_SELECTS_THE_H_STATE_ = 0x1
	// Position of OUTSEL field.
	SCT_EV4_CTRL_OUTSEL_Pos = 0x5
	// Bit mask of OUTSEL field.
	SCT_EV4_CTRL_OUTSEL_Msk = 0x20
	// Bit OUTSEL.
	SCT_EV4_CTRL_OUTSEL = 0x20
	// Selects the inputs elected by IOSEL.
	SCT_EV4_CTRL_OUTSEL_SELECTS_THE_INPUTS_E = 0x0
	// Selects the outputs selected by IOSEL.
	SCT_EV4_CTRL_OUTSEL_SELECTS_THE_OUTPUTS_ = 0x1
	// Position of IOSEL field.
	SCT_EV4_CTRL_IOSEL_Pos = 0x6
	// Bit mask of IOSEL field.
	SCT_EV4_CTRL_IOSEL_Msk = 0x3c0
	// Position of IOCOND field.
	SCT_EV4_CTRL_IOCOND_Pos = 0xa
	// Bit mask of IOCOND field.
	SCT_EV4_CTRL_IOCOND_Msk = 0xc00
	// LOW
	SCT_EV4_CTRL_IOCOND_LOW = 0x0
	// Rise
	SCT_EV4_CTRL_IOCOND_RISE = 0x1
	// Fall
	SCT_EV4_CTRL_IOCOND_FALL = 0x2
	// HIGH
	SCT_EV4_CTRL_IOCOND_HIGH = 0x3
	// Position of COMBMODE field.
	SCT_EV4_CTRL_COMBMODE_Pos = 0xc
	// Bit mask of COMBMODE field.
	SCT_EV4_CTRL_COMBMODE_Msk = 0x3000
	// OR. The event occurs when either the specified match or I/O condition occurs.
	SCT_EV4_CTRL_COMBMODE_OR_THE_EVENT_OCCURS = 0x0
	// MATCH. Uses the specified match only.
	SCT_EV4_CTRL_COMBMODE_MATCH_USES_THE_SPEC = 0x1
	// IO. Uses the specified I/O condition only.
	SCT_EV4_CTRL_COMBMODE_IO_USES_THE_SPECIFI = 0x2
	// AND. The event occurs when the specified match and I/O condition occur simultaneously.
	SCT_EV4_CTRL_COMBMODE_AND_THE_EVENT_OCCUR = 0x3
	// Position of STATELD field.
	SCT_EV4_CTRL_STATELD_Pos = 0xe
	// Bit mask of STATELD field.
	SCT_EV4_CTRL_STATELD_Msk = 0x4000
	// Bit STATELD.
	SCT_EV4_CTRL_STATELD = 0x4000
	// STATEV value is added into STATE (the carry-out is ignored).
	SCT_EV4_CTRL_STATELD_STATEV_VALUE_IS_ADDE = 0x0
	// STATEV value is loaded into STATE.
	SCT_EV4_CTRL_STATELD_STATEV_VALUE_IS_LOAD = 0x1
	// Position of STATEV field.
	SCT_EV4_CTRL_STATEV_Pos = 0xf
	// Bit mask of STATEV field.
	SCT_EV4_CTRL_STATEV_Msk = 0xf8000
	// Position of MATCHMEM field.
	SCT_EV4_CTRL_MATCHMEM_Pos = 0x14
	// Bit mask of MATCHMEM field.
	SCT_EV4_CTRL_MATCHMEM_Msk = 0x100000
	// Bit MATCHMEM.
	SCT_EV4_CTRL_MATCHMEM = 0x100000
	// Position of DIRECTION field.
	SCT_EV4_CTRL_DIRECTION_Pos = 0x15
	// Bit mask of DIRECTION field.
	SCT_EV4_CTRL_DIRECTION_Msk = 0x600000
	// Direction independent. This event is triggered regardless of the count direction.
	SCT_EV4_CTRL_DIRECTION_DIRECTION_INDEPENDEN = 0x0
	// Counting up. This event is triggered only during up-counting when BIDIR = 1.
	SCT_EV4_CTRL_DIRECTION_COUNTING_UP_THIS_EV = 0x1
	// Counting down. This event is triggered only during down-counting when BIDIR = 1.
	SCT_EV4_CTRL_DIRECTION_COUNTING_DOWN_THIS_ = 0x2
	// Position of RESERVED field.
	SCT_EV4_CTRL_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	SCT_EV4_CTRL_RESERVED_Msk = 0xff800000

	// EV5_STATE: SCT event state register 5
	// Position of STATEMSKm field.
	SCT_EV5_STATE_STATEMSKm_Pos = 0x0
	// Bit mask of STATEMSKm field.
	SCT_EV5_STATE_STATEMSKm_Msk = 0x3
	// Position of RESERVED field.
	SCT_EV5_STATE_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SCT_EV5_STATE_RESERVED_Msk = 0xfffffffc

	// EV5_CTRL: SCT event control register 5
	// Position of MATCHSEL field.
	SCT_EV5_CTRL_MATCHSEL_Pos = 0x0
	// Bit mask of MATCHSEL field.
	SCT_EV5_CTRL_MATCHSEL_Msk = 0xf
	// Position of HEVENT field.
	SCT_EV5_CTRL_HEVENT_Pos = 0x4
	// Bit mask of HEVENT field.
	SCT_EV5_CTRL_HEVENT_Msk = 0x10
	// Bit HEVENT.
	SCT_EV5_CTRL_HEVENT = 0x10
	// Selects the L state and the L match register selected by MATCHSEL.
	SCT_EV5_CTRL_HEVENT_SELECTS_THE_L_STATE_ = 0x0
	// Selects the H state and the H match register selected by MATCHSEL.
	SCT_EV5_CTRL_HEVENT_SELECTS_THE_H_STATE_ = 0x1
	// Position of OUTSEL field.
	SCT_EV5_CTRL_OUTSEL_Pos = 0x5
	// Bit mask of OUTSEL field.
	SCT_EV5_CTRL_OUTSEL_Msk = 0x20
	// Bit OUTSEL.
	SCT_EV5_CTRL_OUTSEL = 0x20
	// Selects the inputs elected by IOSEL.
	SCT_EV5_CTRL_OUTSEL_SELECTS_THE_INPUTS_E = 0x0
	// Selects the outputs selected by IOSEL.
	SCT_EV5_CTRL_OUTSEL_SELECTS_THE_OUTPUTS_ = 0x1
	// Position of IOSEL field.
	SCT_EV5_CTRL_IOSEL_Pos = 0x6
	// Bit mask of IOSEL field.
	SCT_EV5_CTRL_IOSEL_Msk = 0x3c0
	// Position of IOCOND field.
	SCT_EV5_CTRL_IOCOND_Pos = 0xa
	// Bit mask of IOCOND field.
	SCT_EV5_CTRL_IOCOND_Msk = 0xc00
	// LOW
	SCT_EV5_CTRL_IOCOND_LOW = 0x0
	// Rise
	SCT_EV5_CTRL_IOCOND_RISE = 0x1
	// Fall
	SCT_EV5_CTRL_IOCOND_FALL = 0x2
	// HIGH
	SCT_EV5_CTRL_IOCOND_HIGH = 0x3
	// Position of COMBMODE field.
	SCT_EV5_CTRL_COMBMODE_Pos = 0xc
	// Bit mask of COMBMODE field.
	SCT_EV5_CTRL_COMBMODE_Msk = 0x3000
	// OR. The event occurs when either the specified match or I/O condition occurs.
	SCT_EV5_CTRL_COMBMODE_OR_THE_EVENT_OCCURS = 0x0
	// MATCH. Uses the specified match only.
	SCT_EV5_CTRL_COMBMODE_MATCH_USES_THE_SPEC = 0x1
	// IO. Uses the specified I/O condition only.
	SCT_EV5_CTRL_COMBMODE_IO_USES_THE_SPECIFI = 0x2
	// AND. The event occurs when the specified match and I/O condition occur simultaneously.
	SCT_EV5_CTRL_COMBMODE_AND_THE_EVENT_OCCUR = 0x3
	// Position of STATELD field.
	SCT_EV5_CTRL_STATELD_Pos = 0xe
	// Bit mask of STATELD field.
	SCT_EV5_CTRL_STATELD_Msk = 0x4000
	// Bit STATELD.
	SCT_EV5_CTRL_STATELD = 0x4000
	// STATEV value is added into STATE (the carry-out is ignored).
	SCT_EV5_CTRL_STATELD_STATEV_VALUE_IS_ADDE = 0x0
	// STATEV value is loaded into STATE.
	SCT_EV5_CTRL_STATELD_STATEV_VALUE_IS_LOAD = 0x1
	// Position of STATEV field.
	SCT_EV5_CTRL_STATEV_Pos = 0xf
	// Bit mask of STATEV field.
	SCT_EV5_CTRL_STATEV_Msk = 0xf8000
	// Position of MATCHMEM field.
	SCT_EV5_CTRL_MATCHMEM_Pos = 0x14
	// Bit mask of MATCHMEM field.
	SCT_EV5_CTRL_MATCHMEM_Msk = 0x100000
	// Bit MATCHMEM.
	SCT_EV5_CTRL_MATCHMEM = 0x100000
	// Position of DIRECTION field.
	SCT_EV5_CTRL_DIRECTION_Pos = 0x15
	// Bit mask of DIRECTION field.
	SCT_EV5_CTRL_DIRECTION_Msk = 0x600000
	// Direction independent. This event is triggered regardless of the count direction.
	SCT_EV5_CTRL_DIRECTION_DIRECTION_INDEPENDEN = 0x0
	// Counting up. This event is triggered only during up-counting when BIDIR = 1.
	SCT_EV5_CTRL_DIRECTION_COUNTING_UP_THIS_EV = 0x1
	// Counting down. This event is triggered only during down-counting when BIDIR = 1.
	SCT_EV5_CTRL_DIRECTION_COUNTING_DOWN_THIS_ = 0x2
	// Position of RESERVED field.
	SCT_EV5_CTRL_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	SCT_EV5_CTRL_RESERVED_Msk = 0xff800000

	// OUT0_SET: SCT output 0 set register
	// Position of SET field.
	SCT_OUT0_SET_SET_Pos = 0x0
	// Bit mask of SET field.
	SCT_OUT0_SET_SET_Msk = 0x3f
	// Position of RESERVED field.
	SCT_OUT0_SET_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT_OUT0_SET_RESERVED_Msk = 0xffffffc0

	// OUT0_CLR: SCT output 0 clear register
	// Position of CLR field.
	SCT_OUT0_CLR_CLR_Pos = 0x0
	// Bit mask of CLR field.
	SCT_OUT0_CLR_CLR_Msk = 0x3f
	// Position of RESERVED field.
	SCT_OUT0_CLR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT_OUT0_CLR_RESERVED_Msk = 0xffffffc0

	// OUT1_SET: SCT output 1 set register
	// Position of SET field.
	SCT_OUT1_SET_SET_Pos = 0x0
	// Bit mask of SET field.
	SCT_OUT1_SET_SET_Msk = 0x3f
	// Position of RESERVED field.
	SCT_OUT1_SET_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT_OUT1_SET_RESERVED_Msk = 0xffffffc0

	// OUT1_CLR: SCT output 1 clear register
	// Position of CLR field.
	SCT_OUT1_CLR_CLR_Pos = 0x0
	// Bit mask of CLR field.
	SCT_OUT1_CLR_CLR_Msk = 0x3f
	// Position of RESERVED field.
	SCT_OUT1_CLR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT_OUT1_CLR_RESERVED_Msk = 0xffffffc0

	// OUT2_SET: SCT output 2 set register
	// Position of SET field.
	SCT_OUT2_SET_SET_Pos = 0x0
	// Bit mask of SET field.
	SCT_OUT2_SET_SET_Msk = 0x3f
	// Position of RESERVED field.
	SCT_OUT2_SET_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT_OUT2_SET_RESERVED_Msk = 0xffffffc0

	// OUT2_CLR: SCT output 2 clear register
	// Position of CLR field.
	SCT_OUT2_CLR_CLR_Pos = 0x0
	// Bit mask of CLR field.
	SCT_OUT2_CLR_CLR_Msk = 0x3f
	// Position of RESERVED field.
	SCT_OUT2_CLR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT_OUT2_CLR_RESERVED_Msk = 0xffffffc0

	// OUT3_SET: SCT output 3 set register
	// Position of SET field.
	SCT_OUT3_SET_SET_Pos = 0x0
	// Bit mask of SET field.
	SCT_OUT3_SET_SET_Msk = 0x3f
	// Position of RESERVED field.
	SCT_OUT3_SET_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT_OUT3_SET_RESERVED_Msk = 0xffffffc0

	// OUT3_CLR: SCT output 3 clear register
	// Position of CLR field.
	SCT_OUT3_CLR_CLR_Pos = 0x0
	// Bit mask of CLR field.
	SCT_OUT3_CLR_CLR_Msk = 0x3f
	// Position of RESERVED field.
	SCT_OUT3_CLR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT_OUT3_CLR_RESERVED_Msk = 0xffffffc0
)

// Constants for GPIO_PORT: General Purpose I/O port (GPIO)
const (
	// B0: Byte pin registers port 0; pins PIO0_0 to PIO0_17
	// Position of PBYTE field.
	GPIO_PORT_B_PBYTE_Pos = 0x0
	// Bit mask of PBYTE field.
	GPIO_PORT_B_PBYTE_Msk = 0x1
	// Bit PBYTE.
	GPIO_PORT_B_PBYTE = 0x1

	// W0: Word pin registers port 0
	// Position of PWORD field.
	GPIO_PORT_W_PWORD_Pos = 0x0
	// Bit mask of PWORD field.
	GPIO_PORT_W_PWORD_Msk = 0xffffffff

	// DIR0: Direction registers port 0
	// Position of DIRP0 field.
	GPIO_PORT_DIR0_DIRP0_Pos = 0x0
	// Bit mask of DIRP0 field.
	GPIO_PORT_DIR0_DIRP0_Msk = 0x3ffff
	// Position of RESERVED field.
	GPIO_PORT_DIR0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	GPIO_PORT_DIR0_RESERVED_Msk = 0xfffc0000

	// MASK0: Mask register port 0
	// Position of MASKP0 field.
	GPIO_PORT_MASK0_MASKP0_Pos = 0x0
	// Bit mask of MASKP0 field.
	GPIO_PORT_MASK0_MASKP0_Msk = 0x3ffff
	// Position of RESERVED field.
	GPIO_PORT_MASK0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	GPIO_PORT_MASK0_RESERVED_Msk = 0xfffc0000

	// PIN0: Port pin register port 0
	// Position of PORT0 field.
	GPIO_PORT_PIN0_PORT0_Pos = 0x0
	// Bit mask of PORT0 field.
	GPIO_PORT_PIN0_PORT0_Msk = 0x3ffff
	// Position of RESERVED field.
	GPIO_PORT_PIN0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	GPIO_PORT_PIN0_RESERVED_Msk = 0xfffc0000

	// MPIN0: Masked port register port 0
	// Position of MPORTP0 field.
	GPIO_PORT_MPIN0_MPORTP0_Pos = 0x0
	// Bit mask of MPORTP0 field.
	GPIO_PORT_MPIN0_MPORTP0_Msk = 0x3ffff
	// Position of RESERVED field.
	GPIO_PORT_MPIN0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	GPIO_PORT_MPIN0_RESERVED_Msk = 0xfffc0000

	// SET0: Write: Set register for port 0 Read: output bits for port 0
	// Position of SETP0 field.
	GPIO_PORT_SET0_SETP0_Pos = 0x0
	// Bit mask of SETP0 field.
	GPIO_PORT_SET0_SETP0_Msk = 0x3ffff
	// Position of RESERVED field.
	GPIO_PORT_SET0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	GPIO_PORT_SET0_RESERVED_Msk = 0xfffc0000

	// CLR0: Clear port 0
	// Position of CLRP0 field.
	GPIO_PORT_CLR0_CLRP0_Pos = 0x0
	// Bit mask of CLRP0 field.
	GPIO_PORT_CLR0_CLRP0_Msk = 0x3ffff
	// Position of RESERVED field.
	GPIO_PORT_CLR0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	GPIO_PORT_CLR0_RESERVED_Msk = 0xfffc0000

	// NOT0: Toggle port 0
	// Position of NOTP0 field.
	GPIO_PORT_NOT0_NOTP0_Pos = 0x0
	// Bit mask of NOTP0 field.
	GPIO_PORT_NOT0_NOTP0_Msk = 0x3ffff
	// Position of RESERVED field.
	GPIO_PORT_NOT0_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	GPIO_PORT_NOT0_RESERVED_Msk = 0xfffc0000
)

// Constants for PIN_INT: Pin interrupt and pattern match engine
const (
	// ISEL: Pin Interrupt Mode register
	// Position of PMODE field.
	GPIO_PIN_INT_ISEL_PMODE_Pos = 0x0
	// Bit mask of PMODE field.
	GPIO_PIN_INT_ISEL_PMODE_Msk = 0xff
	// Position of RESERVED field.
	GPIO_PIN_INT_ISEL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_ISEL_RESERVED_Msk = 0xffffff00

	// IENR: Pin interrupt level or rising edge interrupt enable register
	// Position of ENRL field.
	GPIO_PIN_INT_IENR_ENRL_Pos = 0x0
	// Bit mask of ENRL field.
	GPIO_PIN_INT_IENR_ENRL_Msk = 0xff
	// Position of RESERVED field.
	GPIO_PIN_INT_IENR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_IENR_RESERVED_Msk = 0xffffff00

	// SIENR: Pin interrupt level (rising edge) interrupt set register
	// Position of SETENRL field.
	GPIO_PIN_INT_SIENR_SETENRL_Pos = 0x0
	// Bit mask of SETENRL field.
	GPIO_PIN_INT_SIENR_SETENRL_Msk = 0xff
	// Position of RESERVED field.
	GPIO_PIN_INT_SIENR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_SIENR_RESERVED_Msk = 0xffffff00

	// CIENR: Pin interrupt level or rising edge interrupt clear register
	// Position of CENRL field.
	GPIO_PIN_INT_CIENR_CENRL_Pos = 0x0
	// Bit mask of CENRL field.
	GPIO_PIN_INT_CIENR_CENRL_Msk = 0xff
	// Position of RESERVED field.
	GPIO_PIN_INT_CIENR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_CIENR_RESERVED_Msk = 0xffffff00

	// IENF: Pin interrupt active level or falling edge interrupt enable register
	// Position of ENAF field.
	GPIO_PIN_INT_IENF_ENAF_Pos = 0x0
	// Bit mask of ENAF field.
	GPIO_PIN_INT_IENF_ENAF_Msk = 0xff
	// Position of RESERVED field.
	GPIO_PIN_INT_IENF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_IENF_RESERVED_Msk = 0xffffff00

	// SIENF: Pin interrupt active level or falling edge interrupt set register
	// Position of SETENAF field.
	GPIO_PIN_INT_SIENF_SETENAF_Pos = 0x0
	// Bit mask of SETENAF field.
	GPIO_PIN_INT_SIENF_SETENAF_Msk = 0xff
	// Position of RESERVED field.
	GPIO_PIN_INT_SIENF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_SIENF_RESERVED_Msk = 0xffffff00

	// CIENF: Pin interrupt active level (falling edge) interrupt clear register
	// Position of CENAF field.
	GPIO_PIN_INT_CIENF_CENAF_Pos = 0x0
	// Bit mask of CENAF field.
	GPIO_PIN_INT_CIENF_CENAF_Msk = 0xff
	// Position of RESERVED field.
	GPIO_PIN_INT_CIENF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_CIENF_RESERVED_Msk = 0xffffff00

	// RISE: Pin interrupt rising edge register
	// Position of RDET field.
	GPIO_PIN_INT_RISE_RDET_Pos = 0x0
	// Bit mask of RDET field.
	GPIO_PIN_INT_RISE_RDET_Msk = 0xff
	// Position of RESERVED field.
	GPIO_PIN_INT_RISE_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_RISE_RESERVED_Msk = 0xffffff00

	// FALL: Pin interrupt falling edge register
	// Position of FDET field.
	GPIO_PIN_INT_FALL_FDET_Pos = 0x0
	// Bit mask of FDET field.
	GPIO_PIN_INT_FALL_FDET_Msk = 0xff
	// Position of RESERVED field.
	GPIO_PIN_INT_FALL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_FALL_RESERVED_Msk = 0xffffff00

	// IST: Pin interrupt status register
	// Position of PSTAT field.
	GPIO_PIN_INT_IST_PSTAT_Pos = 0x0
	// Bit mask of PSTAT field.
	GPIO_PIN_INT_IST_PSTAT_Msk = 0xff
	// Position of RESERVED field.
	GPIO_PIN_INT_IST_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_IST_RESERVED_Msk = 0xffffff00

	// PMCTRL: GPIO pattern match interrupt control register
	// Position of SEL_PMATCH field.
	GPIO_PIN_INT_PMCTRL_SEL_PMATCH_Pos = 0x0
	// Bit mask of SEL_PMATCH field.
	GPIO_PIN_INT_PMCTRL_SEL_PMATCH_Msk = 0x1
	// Bit SEL_PMATCH.
	GPIO_PIN_INT_PMCTRL_SEL_PMATCH = 0x1
	// Pin interrupt. Interrupts are driven in response to the standard pin interrupt function
	GPIO_PIN_INT_PMCTRL_SEL_PMATCH_PIN_INTERRUPT_INTER = 0x0
	// Pattern match. Interrupts are driven in response to pattern matches.
	GPIO_PIN_INT_PMCTRL_SEL_PMATCH_PATTERN_MATCH_INTER = 0x1
	// Position of ENA_RXEV field.
	GPIO_PIN_INT_PMCTRL_ENA_RXEV_Pos = 0x1
	// Bit mask of ENA_RXEV field.
	GPIO_PIN_INT_PMCTRL_ENA_RXEV_Msk = 0x2
	// Bit ENA_RXEV.
	GPIO_PIN_INT_PMCTRL_ENA_RXEV = 0x2
	// Disabled. RxEv output to the cpu is disabled.
	GPIO_PIN_INT_PMCTRL_ENA_RXEV_DISABLED_RXEV_OUTPU = 0x0
	// Enabled. RxEv output to the cpu is enabled.
	GPIO_PIN_INT_PMCTRL_ENA_RXEV_ENABLED_RXEV_OUTPUT = 0x1
	// Position of RESERVED field.
	GPIO_PIN_INT_PMCTRL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	GPIO_PIN_INT_PMCTRL_RESERVED_Msk = 0xfffffc
	// Position of PMAT field.
	GPIO_PIN_INT_PMCTRL_PMAT_Pos = 0x18
	// Bit mask of PMAT field.
	GPIO_PIN_INT_PMCTRL_PMAT_Msk = 0xff000000

	// PMSRC: GPIO pattern match interrupt bit-slice source register
	// Position of Reserved field.
	GPIO_PIN_INT_PMSRC_Reserved_Pos = 0x0
	// Bit mask of Reserved field.
	GPIO_PIN_INT_PMSRC_Reserved_Msk = 0xff
	// Position of SRC0 field.
	GPIO_PIN_INT_PMSRC_SRC0_Pos = 0x8
	// Bit mask of SRC0 field.
	GPIO_PIN_INT_PMSRC_SRC0_Msk = 0x700
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 0.
	GPIO_PIN_INT_PMSRC_SRC0_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 0.
	GPIO_PIN_INT_PMSRC_SRC0_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 0.
	GPIO_PIN_INT_PMSRC_SRC0_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 0.
	GPIO_PIN_INT_PMSRC_SRC0_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 0.
	GPIO_PIN_INT_PMSRC_SRC0_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 0.
	GPIO_PIN_INT_PMSRC_SRC0_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 0.
	GPIO_PIN_INT_PMSRC_SRC0_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 0.
	GPIO_PIN_INT_PMSRC_SRC0_INPUT_7_SELECTS_PIN = 0x7
	// Position of SRC1 field.
	GPIO_PIN_INT_PMSRC_SRC1_Pos = 0xb
	// Bit mask of SRC1 field.
	GPIO_PIN_INT_PMSRC_SRC1_Msk = 0x3800
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 1.
	GPIO_PIN_INT_PMSRC_SRC1_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 1.
	GPIO_PIN_INT_PMSRC_SRC1_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 1.
	GPIO_PIN_INT_PMSRC_SRC1_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 1.
	GPIO_PIN_INT_PMSRC_SRC1_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 1.
	GPIO_PIN_INT_PMSRC_SRC1_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 1.
	GPIO_PIN_INT_PMSRC_SRC1_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 1.
	GPIO_PIN_INT_PMSRC_SRC1_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 1.
	GPIO_PIN_INT_PMSRC_SRC1_INPUT_7_SELECTS_PIN = 0x7
	// Position of SRC2 field.
	GPIO_PIN_INT_PMSRC_SRC2_Pos = 0xe
	// Bit mask of SRC2 field.
	GPIO_PIN_INT_PMSRC_SRC2_Msk = 0x1c000
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 2.
	GPIO_PIN_INT_PMSRC_SRC2_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 2.
	GPIO_PIN_INT_PMSRC_SRC2_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 2.
	GPIO_PIN_INT_PMSRC_SRC2_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 2.
	GPIO_PIN_INT_PMSRC_SRC2_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 2.
	GPIO_PIN_INT_PMSRC_SRC2_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 2.
	GPIO_PIN_INT_PMSRC_SRC2_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 2.
	GPIO_PIN_INT_PMSRC_SRC2_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 2.
	GPIO_PIN_INT_PMSRC_SRC2_INPUT_7_SELECTS_PIN = 0x7
	// Position of SRC3 field.
	GPIO_PIN_INT_PMSRC_SRC3_Pos = 0x11
	// Bit mask of SRC3 field.
	GPIO_PIN_INT_PMSRC_SRC3_Msk = 0xe0000
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 3.
	GPIO_PIN_INT_PMSRC_SRC3_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 3.
	GPIO_PIN_INT_PMSRC_SRC3_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 3.
	GPIO_PIN_INT_PMSRC_SRC3_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 3.
	GPIO_PIN_INT_PMSRC_SRC3_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 3.
	GPIO_PIN_INT_PMSRC_SRC3_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 3.
	GPIO_PIN_INT_PMSRC_SRC3_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 3.
	GPIO_PIN_INT_PMSRC_SRC3_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 3.
	GPIO_PIN_INT_PMSRC_SRC3_INPUT_7_SELECTS_PIN = 0x7
	// Position of SRC4 field.
	GPIO_PIN_INT_PMSRC_SRC4_Pos = 0x14
	// Bit mask of SRC4 field.
	GPIO_PIN_INT_PMSRC_SRC4_Msk = 0x700000
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 4.
	GPIO_PIN_INT_PMSRC_SRC4_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 4.
	GPIO_PIN_INT_PMSRC_SRC4_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 4.
	GPIO_PIN_INT_PMSRC_SRC4_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 4.
	GPIO_PIN_INT_PMSRC_SRC4_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 4.
	GPIO_PIN_INT_PMSRC_SRC4_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 4.
	GPIO_PIN_INT_PMSRC_SRC4_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 4.
	GPIO_PIN_INT_PMSRC_SRC4_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 4.
	GPIO_PIN_INT_PMSRC_SRC4_INPUT_7_SELECTS_PIN = 0x7
	// Position of SRC5 field.
	GPIO_PIN_INT_PMSRC_SRC5_Pos = 0x17
	// Bit mask of SRC5 field.
	GPIO_PIN_INT_PMSRC_SRC5_Msk = 0x3800000
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 5.
	GPIO_PIN_INT_PMSRC_SRC5_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 5.
	GPIO_PIN_INT_PMSRC_SRC5_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 5.
	GPIO_PIN_INT_PMSRC_SRC5_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 5.
	GPIO_PIN_INT_PMSRC_SRC5_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 5.
	GPIO_PIN_INT_PMSRC_SRC5_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 5.
	GPIO_PIN_INT_PMSRC_SRC5_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 5.
	GPIO_PIN_INT_PMSRC_SRC5_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 5.
	GPIO_PIN_INT_PMSRC_SRC5_INPUT_7_SELECTS_PIN = 0x7
	// Position of SRC6 field.
	GPIO_PIN_INT_PMSRC_SRC6_Pos = 0x1a
	// Bit mask of SRC6 field.
	GPIO_PIN_INT_PMSRC_SRC6_Msk = 0x1c000000
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 6.
	GPIO_PIN_INT_PMSRC_SRC6_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 6.
	GPIO_PIN_INT_PMSRC_SRC6_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 6.
	GPIO_PIN_INT_PMSRC_SRC6_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 6.
	GPIO_PIN_INT_PMSRC_SRC6_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 6.
	GPIO_PIN_INT_PMSRC_SRC6_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 6.
	GPIO_PIN_INT_PMSRC_SRC6_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 6.
	GPIO_PIN_INT_PMSRC_SRC6_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 6.
	GPIO_PIN_INT_PMSRC_SRC6_INPUT_7_SELECTS_PIN = 0x7
	// Position of SRC7 field.
	GPIO_PIN_INT_PMSRC_SRC7_Pos = 0x1d
	// Bit mask of SRC7 field.
	GPIO_PIN_INT_PMSRC_SRC7_Msk = 0xe0000000
	// Input 0. Selects pin interrupt input 0 as the source to bit slice 7.
	GPIO_PIN_INT_PMSRC_SRC7_INPUT_0_SELECTS_PIN = 0x0
	// Input 1. Selects pin interrupt input 1 as the source to bit slice 7.
	GPIO_PIN_INT_PMSRC_SRC7_INPUT_1_SELECTS_PIN = 0x1
	// Input 2. Selects pin interrupt input 2 as the source to bit slice 7.
	GPIO_PIN_INT_PMSRC_SRC7_INPUT_2_SELECTS_PIN = 0x2
	// Input 3. Selects pin interrupt input 3 as the source to bit slice 7.
	GPIO_PIN_INT_PMSRC_SRC7_INPUT_3_SELECTS_PIN = 0x3
	// Input 4. Selects pin interrupt input 4 as the source to bit slice 7.
	GPIO_PIN_INT_PMSRC_SRC7_INPUT_4_SELECTS_PIN = 0x4
	// Input 5. Selects pin interrupt input 5 as the source to bit slice 7.
	GPIO_PIN_INT_PMSRC_SRC7_INPUT_5_SELECTS_PIN = 0x5
	// Input 6. Selects pin interrupt input 6 as the source to bit slice 7.
	GPIO_PIN_INT_PMSRC_SRC7_INPUT_6_SELECTS_PIN = 0x6
	// Input 7. Selects pin interrupt input 7 as the source to bit slice 7.
	GPIO_PIN_INT_PMSRC_SRC7_INPUT_7_SELECTS_PIN = 0x7

	// PMCFG: GPIO pattern match interrupt bit slice configuration register
	// Position of PROD_ENDPTS field.
	GPIO_PIN_INT_PMCFG_PROD_ENDPTS_Pos = 0x0
	// Bit mask of PROD_ENDPTS field.
	GPIO_PIN_INT_PMCFG_PROD_ENDPTS_Msk = 0x7f
	// Position of Reserved field.
	GPIO_PIN_INT_PMCFG_Reserved_Pos = 0x7
	// Bit mask of Reserved field.
	GPIO_PIN_INT_PMCFG_Reserved_Msk = 0x80
	// Bit Reserved.
	GPIO_PIN_INT_PMCFG_Reserved = 0x80
	// Position of CFG0 field.
	GPIO_PIN_INT_PMCFG_CFG0_Pos = 0x8
	// Bit mask of CFG0 field.
	GPIO_PIN_INT_PMCFG_CFG0_Msk = 0x700
	// Constant 1. This bit slice always contributes to a product term match.
	GPIO_PIN_INT_PMCFG_CFG0_CONSTANT_1_THIS_BIT = 0x0
	// Rising edge. Match occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG0_RISING_EDGE_MATCH_O = 0x1
	// Falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG0_FALLING_EDGE_MATCH_ = 0x2
	// Rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG0_RISING_OR_FALLING_ED = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	GPIO_PIN_INT_PMCFG_CFG0_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	GPIO_PIN_INT_PMCFG_CFG0_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices)
	GPIO_PIN_INT_PMCFG_CFG0_CONSTANT_0_THIS_BIT = 0x6
	// Event. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3)
	GPIO_PIN_INT_PMCFG_CFG0_EVENT_MATCH_OCCURS_ = 0x7
	// Position of CFG1 field.
	GPIO_PIN_INT_PMCFG_CFG1_Pos = 0xb
	// Bit mask of CFG1 field.
	GPIO_PIN_INT_PMCFG_CFG1_Msk = 0x3800
	// Constant 1. This bit slice always contributes to a product term match.
	GPIO_PIN_INT_PMCFG_CFG1_CONSTANT_1_THIS_BIT = 0x0
	// Rising edge. Match occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG1_RISING_EDGE_MATCH_O = 0x1
	// Falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG1_FALLING_EDGE_MATCH_ = 0x2
	// Rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG1_RISING_OR_FALLING_ED = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	GPIO_PIN_INT_PMCFG_CFG1_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	GPIO_PIN_INT_PMCFG_CFG1_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices)
	GPIO_PIN_INT_PMCFG_CFG1_CONSTANT_0_THIS_BIT = 0x6
	// Event. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3)
	GPIO_PIN_INT_PMCFG_CFG1_EVENT_MATCH_OCCURS_ = 0x7
	// Position of CFG2 field.
	GPIO_PIN_INT_PMCFG_CFG2_Pos = 0xe
	// Bit mask of CFG2 field.
	GPIO_PIN_INT_PMCFG_CFG2_Msk = 0x1c000
	// Constant 1. This bit slice always contributes to a product term match.
	GPIO_PIN_INT_PMCFG_CFG2_CONSTANT_1_THIS_BIT = 0x0
	// Rising edge. Match occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG2_RISING_EDGE_MATCH_O = 0x1
	// Falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG2_FALLING_EDGE_MATCH_ = 0x2
	// Rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG2_RISING_OR_FALLING_ED = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	GPIO_PIN_INT_PMCFG_CFG2_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	GPIO_PIN_INT_PMCFG_CFG2_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices)
	GPIO_PIN_INT_PMCFG_CFG2_CONSTANT_0_THIS_BIT = 0x6
	// Event. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3)
	GPIO_PIN_INT_PMCFG_CFG2_EVENT_MATCH_OCCURS_ = 0x7
	// Position of CFG3 field.
	GPIO_PIN_INT_PMCFG_CFG3_Pos = 0x11
	// Bit mask of CFG3 field.
	GPIO_PIN_INT_PMCFG_CFG3_Msk = 0xe0000
	// Constant 1. This bit slice always contributes to a product term match.
	GPIO_PIN_INT_PMCFG_CFG3_CONSTANT_1_THIS_BIT = 0x0
	// Rising edge. Match occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG3_RISING_EDGE_MATCH_O = 0x1
	// Falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG3_FALLING_EDGE_MATCH_ = 0x2
	// Rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG3_RISING_OR_FALLING_ED = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	GPIO_PIN_INT_PMCFG_CFG3_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	GPIO_PIN_INT_PMCFG_CFG3_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices)
	GPIO_PIN_INT_PMCFG_CFG3_CONSTANT_0_THIS_BIT = 0x6
	// Event. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3)
	GPIO_PIN_INT_PMCFG_CFG3_EVENT_MATCH_OCCURS_ = 0x7
	// Position of CFG4 field.
	GPIO_PIN_INT_PMCFG_CFG4_Pos = 0x14
	// Bit mask of CFG4 field.
	GPIO_PIN_INT_PMCFG_CFG4_Msk = 0x700000
	// Constant 1. This bit slice always contributes to a product term match.
	GPIO_PIN_INT_PMCFG_CFG4_CONSTANT_1_THIS_BIT = 0x0
	// Rising edge. Match occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG4_RISING_EDGE_MATCH_O = 0x1
	// Falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG4_FALLING_EDGE_MATCH_ = 0x2
	// Rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG4_RISING_OR_FALLING_ED = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	GPIO_PIN_INT_PMCFG_CFG4_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	GPIO_PIN_INT_PMCFG_CFG4_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices)
	GPIO_PIN_INT_PMCFG_CFG4_CONSTANT_0_THIS_BIT = 0x6
	// Event. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3)
	GPIO_PIN_INT_PMCFG_CFG4_EVENT_MATCH_OCCURS_ = 0x7
	// Position of CFG5 field.
	GPIO_PIN_INT_PMCFG_CFG5_Pos = 0x17
	// Bit mask of CFG5 field.
	GPIO_PIN_INT_PMCFG_CFG5_Msk = 0x3800000
	// Constant 1. This bit slice always contributes to a product term match.
	GPIO_PIN_INT_PMCFG_CFG5_CONSTANT_1_THIS_BIT = 0x0
	// Rising edge. Match occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG5_RISING_EDGE_MATCH_O = 0x1
	// Falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG5_FALLING_EDGE_MATCH_ = 0x2
	// Rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG5_RISING_OR_FALLING_ED = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	GPIO_PIN_INT_PMCFG_CFG5_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	GPIO_PIN_INT_PMCFG_CFG5_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices)
	GPIO_PIN_INT_PMCFG_CFG5_CONSTANT_0_THIS_BIT = 0x6
	// Event. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3)
	GPIO_PIN_INT_PMCFG_CFG5_EVENT_MATCH_OCCURS_ = 0x7
	// Position of CFG6 field.
	GPIO_PIN_INT_PMCFG_CFG6_Pos = 0x1a
	// Bit mask of CFG6 field.
	GPIO_PIN_INT_PMCFG_CFG6_Msk = 0x1c000000
	// Constant 1. This bit slice always contributes to a product term match.
	GPIO_PIN_INT_PMCFG_CFG6_CONSTANT_1_THIS_BIT = 0x0
	// Rising edge. Match occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG6_RISING_EDGE_MATCH_O = 0x1
	// Falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG6_FALLING_EDGE_MATCH_ = 0x2
	// Rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG6_RISING_OR_FALLING_ED = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	GPIO_PIN_INT_PMCFG_CFG6_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	GPIO_PIN_INT_PMCFG_CFG6_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices)
	GPIO_PIN_INT_PMCFG_CFG6_CONSTANT_0_THIS_BIT = 0x6
	// Event. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3)
	GPIO_PIN_INT_PMCFG_CFG6_EVENT_MATCH_OCCURS_ = 0x7
	// Position of CFG7 field.
	GPIO_PIN_INT_PMCFG_CFG7_Pos = 0x1d
	// Bit mask of CFG7 field.
	GPIO_PIN_INT_PMCFG_CFG7_Msk = 0xe0000000
	// Constant 1. This bit slice always contributes to a product term match.
	GPIO_PIN_INT_PMCFG_CFG7_CONSTANT_1_THIS_BIT = 0x0
	// Rising edge. Match occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG7_RISING_EDGE_MATCH_O = 0x1
	// Falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG7_FALLING_EDGE_MATCH_ = 0x2
	// Rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared.
	GPIO_PIN_INT_PMCFG_CFG7_RISING_OR_FALLING_ED = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	GPIO_PIN_INT_PMCFG_CFG7_HIGH_LEVEL_MATCH_F = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	GPIO_PIN_INT_PMCFG_CFG7_LOW_LEVEL_MATCH_OCC = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices)
	GPIO_PIN_INT_PMCFG_CFG7_CONSTANT_0_THIS_BIT = 0x6
	// Event. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of option 3)
	GPIO_PIN_INT_PMCFG_CFG7_EVENT_MATCH_OCCURS_ = 0x7
)
