// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32h735.svd, see https://github.com/tinygo-org/stm32-svd

//go:build stm32 && stm32h73x

// STM32H73x
//

package stm32

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32H73x"
	CPU          = "CM7"
	FPUPresent   = true
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// WWDG
	IRQ_WWDG1 = 0

	// DELAY_Block_SDMMC1 // External interrupt/event controller
	IRQ_PVD_PVM = 1

	// RTC
	IRQ_RTC_TAMP_STAMP_CSS_LSE = 2

	// RTC
	IRQ_RTC_WKUP = 3

	// Flash
	IRQ_FLASH = 4

	// Reset and clock control
	IRQ_RCC = 5

	// DELAY_Block_SDMMC1 // External interrupt/event controller
	IRQ_EXTI0 = 6

	// DELAY_Block_SDMMC1 // External interrupt/event controller
	IRQ_EXTI1 = 7

	// DELAY_Block_SDMMC1 // External interrupt/event controller
	IRQ_EXTI2 = 8

	// DELAY_Block_SDMMC1 // External interrupt/event controller
	IRQ_EXTI3 = 9

	// DELAY_Block_SDMMC1 // External interrupt/event controller
	IRQ_EXTI4 = 10

	// DMA controller
	IRQ_DMA_STR0 = 11

	// DMA controller
	IRQ_DMA1_STR0 = 11

	// DMA controller
	IRQ_DMA_STR1 = 12

	// DMA controller
	IRQ_DMA1_STR1 = 12

	// DMA controller
	IRQ_DMA_STR2 = 13

	// DMA controller
	IRQ_DMA1_STR2 = 13

	// DMA controller
	IRQ_DMA_STR3 = 14

	// DMA controller
	IRQ_DMA1_STR3 = 14

	// DMA controller
	IRQ_DMA_STR4 = 15

	// DMA controller
	IRQ_DMA1_STR4 = 15

	// DMA controller
	IRQ_DMA_STR5 = 16

	// DMA controller
	IRQ_DMA1_STR5 = 16

	// DMA controller
	IRQ_DMA_STR6 = 17

	// DMA controller
	IRQ_DMA1_STR6 = 17

	// Analog-to-Digital Converter
	IRQ_ADC1_2 = 18

	// FDCAN1
	IRQ_FDCAN1_IT0 = 19

	IRQ_FDCAN2_IT0 = 20

	// FDCAN1
	IRQ_FDCAN1_IT1 = 21

	IRQ_FDCAN2_IT1 = 22

	// DELAY_Block_SDMMC1 // External interrupt/event controller
	IRQ_EXTI9_5 = 23

	// Advanced-timers
	IRQ_TIM1_BRK = 24

	// Advanced-timers
	IRQ_TIM1_UP = 25

	// Advanced-timers
	IRQ_TIM1_TRG_COM = 26

	// Advanced-timers
	IRQ_TIM_CC = 27

	// General purpose timers
	IRQ_TIM2 = 28

	// General purpose timers
	IRQ_TIM3 = 29

	// General purpose timers
	IRQ_TIM4 = 30

	// I2C
	IRQ_I2C1_EV = 31

	// I2C
	IRQ_I2C1_ER = 32

	IRQ_I2C2_EV = 33

	IRQ_I2C2_ER = 34

	// Serial peripheral interface
	IRQ_SPI1 = 35

	IRQ_SPI2 = 36

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1 = 37

	IRQ_USART2 = 38

	IRQ_USART3 = 39

	// DELAY_Block_SDMMC1 // External interrupt/event controller
	IRQ_EXTI15_10 = 40

	// RTC
	IRQ_RTC_ALARM = 41

	IRQ_TIM8_BRK_TIM12 = 43

	IRQ_TIM8_UP_TIM13 = 44

	IRQ_TIM8_TRG_COM_TIM14 = 45

	IRQ_TIM8_CC = 46

	// DMA controller
	IRQ_DMA1_STR7 = 47

	// FMC
	IRQ_FMC = 48

	// SDMMC1
	IRQ_SDMMC1 = 49

	IRQ_TIM5 = 50

	IRQ_SPI3 = 51

	IRQ_UART4 = 52

	IRQ_UART5 = 53

	// Basic timers
	IRQ_TIM6_DAC = 54

	IRQ_TIM7 = 55

	IRQ_DMA2_STR0 = 56

	IRQ_DMA2_STR1 = 57

	IRQ_DMA2_STR2 = 58

	IRQ_DMA2_STR3 = 59

	IRQ_DMA2_STR4 = 60

	// Ethernet: media access control (MAC)
	IRQ_ETH = 61

	// Ethernet: media access control (MAC)
	IRQ_ETH_WKUP = 62

	// FDCAN1
	IRQ_FDCAN_CAL = 63

	IRQ_DMA2_STR5 = 68

	IRQ_DMA2_STR6 = 69

	IRQ_DMA2_STR7 = 70

	IRQ_USART6 = 71

	IRQ_I2C3_EV = 72

	IRQ_I2C3_ER = 73

	// Digital camera interface
	IRQ_DCMI = 78

	// Cryptographic processor
	IRQ_CRYP = 79

	// Floting point unit
	IRQ_FPU = 81

	IRQ_UART7 = 82

	IRQ_UART8 = 83

	IRQ_SPI4 = 84

	IRQ_SPI5 = 85

	IRQ_SPI6 = 86

	// SAI
	IRQ_SAI1 = 87

	// LCD-TFT Controller
	IRQ_LTDC = 88

	// LCD-TFT Controller
	IRQ_LTDC_ER = 89

	// DMA2D
	IRQ_DMA2D = 90

	// OctoSPI
	IRQ_OCTOSPI1 = 92

	// Low power timer
	IRQ_LPTIM1 = 93

	// CEC
	IRQ_CEC = 94

	IRQ_I2C4_EV = 95

	IRQ_I2C4_ER = 96

	// Receiver Interface
	IRQ_SPDIF = 97

	// DMAMUX
	IRQ_DMAMUX1_OV = 102

	// Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT0 = 110

	// Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT1 = 111

	// Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT2 = 112

	// Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT3 = 113

	// Single Wire Protocol Master Interface
	IRQ_SWPMI1 = 115

	// General purpose timers
	IRQ_TIM15 = 116

	// General-purpose-timers
	IRQ_TIM16 = 117

	// General-purpose-timers
	IRQ_TIM17 = 118

	// Management data input/output slave
	IRQ_MDIOS_WKUP = 119

	// Management data input/output slave
	IRQ_MDIOS = 120

	// MDMA
	IRQ_MDMA = 122

	IRQ_SDMMC2 = 124

	// HSEM
	IRQ_HSEM0 = 125

	IRQ_ADC3 = 127

	// DMAMUX2
	IRQ_DMAMUX2_OVR = 128

	// Basic Direct Memory Access
	IRQ_BDMA_CH0 = 129

	// Basic Direct Memory Access
	IRQ_BDMA_CH1 = 130

	// Basic Direct Memory Access
	IRQ_BDMA_CH2 = 131

	// Basic Direct Memory Access
	IRQ_BDMA_CH3 = 132

	// Basic Direct Memory Access
	IRQ_BDMA_CH4 = 133

	// Basic Direct Memory Access
	IRQ_BDMA_CH5 = 134

	// Basic Direct Memory Access
	IRQ_BDMA_CH6 = 135

	// Basic Direct Memory Access
	IRQ_BDMA_CH7 = 136

	// COMP1
	IRQ_COMP = 137

	IRQ_LPTIM2 = 138

	// Low power timer
	IRQ_LPTIM3 = 139

	IRQ_LPTIM4 = 140

	IRQ_LPTIM5 = 141

	// LPUART1
	IRQ_LPUART = 142

	// Clock Recovery System
	IRQ_CRS = 144

	IRQ_SAI4 = 146

	// DELAY_Block_SDMMC1 // External interrupt/event controller
	IRQ_WKUP = 149

	IRQ_OCTOSPI2 = 150

	// Highest interrupt number on this device.
	IRQ_max = 150
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WWDG1_IRQHandler
func interruptWWDG1() {
	callHandlers(IRQ_WWDG1)
}

//export PVD_PVM_IRQHandler
func interruptPVD_PVM() {
	callHandlers(IRQ_PVD_PVM)
}

//export RTC_TAMP_STAMP_CSS_LSE_IRQHandler
func interruptRTC_TAMP_STAMP_CSS_LSE() {
	callHandlers(IRQ_RTC_TAMP_STAMP_CSS_LSE)
}

//export RTC_WKUP_IRQHandler
func interruptRTC_WKUP() {
	callHandlers(IRQ_RTC_WKUP)
}

//export FLASH_IRQHandler
func interruptFLASH() {
	callHandlers(IRQ_FLASH)
}

//export RCC_IRQHandler
func interruptRCC() {
	callHandlers(IRQ_RCC)
}

//export EXTI0_IRQHandler
func interruptEXTI0() {
	callHandlers(IRQ_EXTI0)
}

//export EXTI1_IRQHandler
func interruptEXTI1() {
	callHandlers(IRQ_EXTI1)
}

//export EXTI2_IRQHandler
func interruptEXTI2() {
	callHandlers(IRQ_EXTI2)
}

//export EXTI3_IRQHandler
func interruptEXTI3() {
	callHandlers(IRQ_EXTI3)
}

//export EXTI4_IRQHandler
func interruptEXTI4() {
	callHandlers(IRQ_EXTI4)
}

//export DMA_STR0_IRQHandler
func interruptDMA_STR0() {
	callHandlers(IRQ_DMA_STR0)
}

//export DMA1_STR0_IRQHandler
func interruptDMA1_STR0() {
	callHandlers(IRQ_DMA1_STR0)
}

//export DMA_STR1_IRQHandler
func interruptDMA_STR1() {
	callHandlers(IRQ_DMA_STR1)
}

//export DMA1_STR1_IRQHandler
func interruptDMA1_STR1() {
	callHandlers(IRQ_DMA1_STR1)
}

//export DMA_STR2_IRQHandler
func interruptDMA_STR2() {
	callHandlers(IRQ_DMA_STR2)
}

//export DMA1_STR2_IRQHandler
func interruptDMA1_STR2() {
	callHandlers(IRQ_DMA1_STR2)
}

//export DMA_STR3_IRQHandler
func interruptDMA_STR3() {
	callHandlers(IRQ_DMA_STR3)
}

//export DMA1_STR3_IRQHandler
func interruptDMA1_STR3() {
	callHandlers(IRQ_DMA1_STR3)
}

//export DMA_STR4_IRQHandler
func interruptDMA_STR4() {
	callHandlers(IRQ_DMA_STR4)
}

//export DMA1_STR4_IRQHandler
func interruptDMA1_STR4() {
	callHandlers(IRQ_DMA1_STR4)
}

//export DMA_STR5_IRQHandler
func interruptDMA_STR5() {
	callHandlers(IRQ_DMA_STR5)
}

//export DMA1_STR5_IRQHandler
func interruptDMA1_STR5() {
	callHandlers(IRQ_DMA1_STR5)
}

//export DMA_STR6_IRQHandler
func interruptDMA_STR6() {
	callHandlers(IRQ_DMA_STR6)
}

//export DMA1_STR6_IRQHandler
func interruptDMA1_STR6() {
	callHandlers(IRQ_DMA1_STR6)
}

//export ADC1_2_IRQHandler
func interruptADC1_2() {
	callHandlers(IRQ_ADC1_2)
}

//export FDCAN1_IT0_IRQHandler
func interruptFDCAN1_IT0() {
	callHandlers(IRQ_FDCAN1_IT0)
}

//export FDCAN2_IT0_IRQHandler
func interruptFDCAN2_IT0() {
	callHandlers(IRQ_FDCAN2_IT0)
}

//export FDCAN1_IT1_IRQHandler
func interruptFDCAN1_IT1() {
	callHandlers(IRQ_FDCAN1_IT1)
}

//export FDCAN2_IT1_IRQHandler
func interruptFDCAN2_IT1() {
	callHandlers(IRQ_FDCAN2_IT1)
}

//export EXTI9_5_IRQHandler
func interruptEXTI9_5() {
	callHandlers(IRQ_EXTI9_5)
}

//export TIM1_BRK_IRQHandler
func interruptTIM1_BRK() {
	callHandlers(IRQ_TIM1_BRK)
}

//export TIM1_UP_IRQHandler
func interruptTIM1_UP() {
	callHandlers(IRQ_TIM1_UP)
}

//export TIM1_TRG_COM_IRQHandler
func interruptTIM1_TRG_COM() {
	callHandlers(IRQ_TIM1_TRG_COM)
}

//export TIM_CC_IRQHandler
func interruptTIM_CC() {
	callHandlers(IRQ_TIM_CC)
}

//export TIM2_IRQHandler
func interruptTIM2() {
	callHandlers(IRQ_TIM2)
}

//export TIM3_IRQHandler
func interruptTIM3() {
	callHandlers(IRQ_TIM3)
}

//export TIM4_IRQHandler
func interruptTIM4() {
	callHandlers(IRQ_TIM4)
}

//export I2C1_EV_IRQHandler
func interruptI2C1_EV() {
	callHandlers(IRQ_I2C1_EV)
}

//export I2C1_ER_IRQHandler
func interruptI2C1_ER() {
	callHandlers(IRQ_I2C1_ER)
}

//export I2C2_EV_IRQHandler
func interruptI2C2_EV() {
	callHandlers(IRQ_I2C2_EV)
}

//export I2C2_ER_IRQHandler
func interruptI2C2_ER() {
	callHandlers(IRQ_I2C2_ER)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export SPI2_IRQHandler
func interruptSPI2() {
	callHandlers(IRQ_SPI2)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export USART3_IRQHandler
func interruptUSART3() {
	callHandlers(IRQ_USART3)
}

//export EXTI15_10_IRQHandler
func interruptEXTI15_10() {
	callHandlers(IRQ_EXTI15_10)
}

//export RTC_ALARM_IRQHandler
func interruptRTC_ALARM() {
	callHandlers(IRQ_RTC_ALARM)
}

//export TIM8_BRK_TIM12_IRQHandler
func interruptTIM8_BRK_TIM12() {
	callHandlers(IRQ_TIM8_BRK_TIM12)
}

//export TIM8_UP_TIM13_IRQHandler
func interruptTIM8_UP_TIM13() {
	callHandlers(IRQ_TIM8_UP_TIM13)
}

//export TIM8_TRG_COM_TIM14_IRQHandler
func interruptTIM8_TRG_COM_TIM14() {
	callHandlers(IRQ_TIM8_TRG_COM_TIM14)
}

//export TIM8_CC_IRQHandler
func interruptTIM8_CC() {
	callHandlers(IRQ_TIM8_CC)
}

//export DMA1_STR7_IRQHandler
func interruptDMA1_STR7() {
	callHandlers(IRQ_DMA1_STR7)
}

//export FMC_IRQHandler
func interruptFMC() {
	callHandlers(IRQ_FMC)
}

//export SDMMC1_IRQHandler
func interruptSDMMC1() {
	callHandlers(IRQ_SDMMC1)
}

//export TIM5_IRQHandler
func interruptTIM5() {
	callHandlers(IRQ_TIM5)
}

//export SPI3_IRQHandler
func interruptSPI3() {
	callHandlers(IRQ_SPI3)
}

//export UART4_IRQHandler
func interruptUART4() {
	callHandlers(IRQ_UART4)
}

//export UART5_IRQHandler
func interruptUART5() {
	callHandlers(IRQ_UART5)
}

//export TIM6_DAC_IRQHandler
func interruptTIM6_DAC() {
	callHandlers(IRQ_TIM6_DAC)
}

//export TIM7_IRQHandler
func interruptTIM7() {
	callHandlers(IRQ_TIM7)
}

//export DMA2_STR0_IRQHandler
func interruptDMA2_STR0() {
	callHandlers(IRQ_DMA2_STR0)
}

//export DMA2_STR1_IRQHandler
func interruptDMA2_STR1() {
	callHandlers(IRQ_DMA2_STR1)
}

//export DMA2_STR2_IRQHandler
func interruptDMA2_STR2() {
	callHandlers(IRQ_DMA2_STR2)
}

//export DMA2_STR3_IRQHandler
func interruptDMA2_STR3() {
	callHandlers(IRQ_DMA2_STR3)
}

//export DMA2_STR4_IRQHandler
func interruptDMA2_STR4() {
	callHandlers(IRQ_DMA2_STR4)
}

//export ETH_IRQHandler
func interruptETH() {
	callHandlers(IRQ_ETH)
}

//export ETH_WKUP_IRQHandler
func interruptETH_WKUP() {
	callHandlers(IRQ_ETH_WKUP)
}

//export FDCAN_CAL_IRQHandler
func interruptFDCAN_CAL() {
	callHandlers(IRQ_FDCAN_CAL)
}

//export DMA2_STR5_IRQHandler
func interruptDMA2_STR5() {
	callHandlers(IRQ_DMA2_STR5)
}

//export DMA2_STR6_IRQHandler
func interruptDMA2_STR6() {
	callHandlers(IRQ_DMA2_STR6)
}

//export DMA2_STR7_IRQHandler
func interruptDMA2_STR7() {
	callHandlers(IRQ_DMA2_STR7)
}

//export USART6_IRQHandler
func interruptUSART6() {
	callHandlers(IRQ_USART6)
}

//export I2C3_EV_IRQHandler
func interruptI2C3_EV() {
	callHandlers(IRQ_I2C3_EV)
}

//export I2C3_ER_IRQHandler
func interruptI2C3_ER() {
	callHandlers(IRQ_I2C3_ER)
}

//export DCMI_IRQHandler
func interruptDCMI() {
	callHandlers(IRQ_DCMI)
}

//export CRYP_IRQHandler
func interruptCRYP() {
	callHandlers(IRQ_CRYP)
}

//export FPU_IRQHandler
func interruptFPU() {
	callHandlers(IRQ_FPU)
}

//export UART7_IRQHandler
func interruptUART7() {
	callHandlers(IRQ_UART7)
}

//export UART8_IRQHandler
func interruptUART8() {
	callHandlers(IRQ_UART8)
}

//export SPI4_IRQHandler
func interruptSPI4() {
	callHandlers(IRQ_SPI4)
}

//export SPI5_IRQHandler
func interruptSPI5() {
	callHandlers(IRQ_SPI5)
}

//export SPI6_IRQHandler
func interruptSPI6() {
	callHandlers(IRQ_SPI6)
}

//export SAI1_IRQHandler
func interruptSAI1() {
	callHandlers(IRQ_SAI1)
}

//export LTDC_IRQHandler
func interruptLTDC() {
	callHandlers(IRQ_LTDC)
}

//export LTDC_ER_IRQHandler
func interruptLTDC_ER() {
	callHandlers(IRQ_LTDC_ER)
}

//export DMA2D_IRQHandler
func interruptDMA2D() {
	callHandlers(IRQ_DMA2D)
}

//export OCTOSPI1_IRQHandler
func interruptOCTOSPI1() {
	callHandlers(IRQ_OCTOSPI1)
}

//export LPTIM1_IRQHandler
func interruptLPTIM1() {
	callHandlers(IRQ_LPTIM1)
}

//export CEC_IRQHandler
func interruptCEC() {
	callHandlers(IRQ_CEC)
}

//export I2C4_EV_IRQHandler
func interruptI2C4_EV() {
	callHandlers(IRQ_I2C4_EV)
}

//export I2C4_ER_IRQHandler
func interruptI2C4_ER() {
	callHandlers(IRQ_I2C4_ER)
}

//export SPDIF_IRQHandler
func interruptSPDIF() {
	callHandlers(IRQ_SPDIF)
}

//export DMAMUX1_OV_IRQHandler
func interruptDMAMUX1_OV() {
	callHandlers(IRQ_DMAMUX1_OV)
}

//export DFSDM1_FLT0_IRQHandler
func interruptDFSDM1_FLT0() {
	callHandlers(IRQ_DFSDM1_FLT0)
}

//export DFSDM1_FLT1_IRQHandler
func interruptDFSDM1_FLT1() {
	callHandlers(IRQ_DFSDM1_FLT1)
}

//export DFSDM1_FLT2_IRQHandler
func interruptDFSDM1_FLT2() {
	callHandlers(IRQ_DFSDM1_FLT2)
}

//export DFSDM1_FLT3_IRQHandler
func interruptDFSDM1_FLT3() {
	callHandlers(IRQ_DFSDM1_FLT3)
}

//export SWPMI1_IRQHandler
func interruptSWPMI1() {
	callHandlers(IRQ_SWPMI1)
}

//export TIM15_IRQHandler
func interruptTIM15() {
	callHandlers(IRQ_TIM15)
}

//export TIM16_IRQHandler
func interruptTIM16() {
	callHandlers(IRQ_TIM16)
}

//export TIM17_IRQHandler
func interruptTIM17() {
	callHandlers(IRQ_TIM17)
}

//export MDIOS_WKUP_IRQHandler
func interruptMDIOS_WKUP() {
	callHandlers(IRQ_MDIOS_WKUP)
}

//export MDIOS_IRQHandler
func interruptMDIOS() {
	callHandlers(IRQ_MDIOS)
}

//export MDMA_IRQHandler
func interruptMDMA() {
	callHandlers(IRQ_MDMA)
}

//export SDMMC2_IRQHandler
func interruptSDMMC2() {
	callHandlers(IRQ_SDMMC2)
}

//export HSEM0_IRQHandler
func interruptHSEM0() {
	callHandlers(IRQ_HSEM0)
}

//export ADC3_IRQHandler
func interruptADC3() {
	callHandlers(IRQ_ADC3)
}

//export DMAMUX2_OVR_IRQHandler
func interruptDMAMUX2_OVR() {
	callHandlers(IRQ_DMAMUX2_OVR)
}

//export BDMA_CH0_IRQHandler
func interruptBDMA_CH0() {
	callHandlers(IRQ_BDMA_CH0)
}

//export BDMA_CH1_IRQHandler
func interruptBDMA_CH1() {
	callHandlers(IRQ_BDMA_CH1)
}

//export BDMA_CH2_IRQHandler
func interruptBDMA_CH2() {
	callHandlers(IRQ_BDMA_CH2)
}

//export BDMA_CH3_IRQHandler
func interruptBDMA_CH3() {
	callHandlers(IRQ_BDMA_CH3)
}

//export BDMA_CH4_IRQHandler
func interruptBDMA_CH4() {
	callHandlers(IRQ_BDMA_CH4)
}

//export BDMA_CH5_IRQHandler
func interruptBDMA_CH5() {
	callHandlers(IRQ_BDMA_CH5)
}

//export BDMA_CH6_IRQHandler
func interruptBDMA_CH6() {
	callHandlers(IRQ_BDMA_CH6)
}

//export BDMA_CH7_IRQHandler
func interruptBDMA_CH7() {
	callHandlers(IRQ_BDMA_CH7)
}

//export COMP_IRQHandler
func interruptCOMP() {
	callHandlers(IRQ_COMP)
}

//export LPTIM2_IRQHandler
func interruptLPTIM2() {
	callHandlers(IRQ_LPTIM2)
}

//export LPTIM3_IRQHandler
func interruptLPTIM3() {
	callHandlers(IRQ_LPTIM3)
}

//export LPTIM4_IRQHandler
func interruptLPTIM4() {
	callHandlers(IRQ_LPTIM4)
}

//export LPTIM5_IRQHandler
func interruptLPTIM5() {
	callHandlers(IRQ_LPTIM5)
}

//export LPUART_IRQHandler
func interruptLPUART() {
	callHandlers(IRQ_LPUART)
}

//export CRS_IRQHandler
func interruptCRS() {
	callHandlers(IRQ_CRS)
}

//export SAI4_IRQHandler
func interruptSAI4() {
	callHandlers(IRQ_SAI4)
}

//export WKUP_IRQHandler
func interruptWKUP() {
	callHandlers(IRQ_WKUP)
}

//export OCTOSPI2_IRQHandler
func interruptOCTOSPI2() {
	callHandlers(IRQ_OCTOSPI2)
}

// Peripherals.
var (
	// Access control
	AC = (*AC_Type)(unsafe.Pointer(uintptr(0xe000ef90)))

	// Analog to Digital Converter
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40022000)))

	// Analog-to-Digital Converter
	ADC12_Common = (*ADC_Type)(unsafe.Pointer(uintptr(0x40022300)))

	// AXI interconnect registers
	AXI = (*AXI_Type)(unsafe.Pointer(uintptr(0x51000000)))

	// CCU registers
	CAN_CCU = (*FDCAN_Type)(unsafe.Pointer(uintptr(0x4000a800)))

	// CEC
	CEC = (*CEC_Type)(unsafe.Pointer(uintptr(0x40006c00)))

	// COMP1
	COMP1 = (*COMP1_Type)(unsafe.Pointer(uintptr(0x58003800)))

	// Cryptographic processor
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x58024c00)))

	// Clock Recovery System
	CRS = (*CRS_Type)(unsafe.Pointer(uintptr(0x40008400)))

	// Cryptographic processor
	CRYP = (*CRYP_Type)(unsafe.Pointer(uintptr(0x48021000)))

	// DAC
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))

	// Microcontroller Debug Unit
	DBGMCU = (*DBGMCU_Type)(unsafe.Pointer(uintptr(0x5c001000)))

	// Digital camera interface
	DCMI = (*DCMI_Type)(unsafe.Pointer(uintptr(0x48020000)))

	// DELAY_Block_SDMMC1
	DELAY_Block_SDMMC1 = (*DLYB_Type)(unsafe.Pointer(uintptr(0x52008000)))

	// Digital filter for sigma delta modulators
	DFSDM = (*DFSDM_Type)(unsafe.Pointer(uintptr(0x40017800)))

	// DMA controller
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// DMA2D
	DMA2D = (*DMA2D_Type)(unsafe.Pointer(uintptr(0x52001000)))

	// DMAMUX
	DMAMUX1 = (*DMAMUX_Type)(unsafe.Pointer(uintptr(0x40020800)))

	// DMAMUX2
	DMAMUX2 = (*DMAMUX_Type)(unsafe.Pointer(uintptr(0x58025800)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x58000000)))

	// Ethernet: media access control (MAC)
	Ethernet_MAC = (*Ethernet_Type)(unsafe.Pointer(uintptr(0x40028000)))

	// FDCAN1
	FDCAN1 = (*FDCAN_Type)(unsafe.Pointer(uintptr(0x4000a000)))

	// FMC
	FMC = (*FMC_Type)(unsafe.Pointer(uintptr(0x52004000)))

	// Floting point unit
	FPU = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef34)))

	// Floating point unit CPACR
	FPU_CPACR = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ed88)))

	// Flash
	FLASH = (*FLASH_Type)(unsafe.Pointer(uintptr(0x52002000)))

	// GPIO
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x58020000)))

	// HSEM
	HSEM = (*HSEM_Type)(unsafe.Pointer(uintptr(0x58026400)))

	// I2C
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// IWDG
	IWDG1 = (*IWDG_Type)(unsafe.Pointer(uintptr(0x58004800)))

	// Low power timer
	LPTIM1 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40002400)))

	// Low power timer
	LPTIM3 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x58002800)))

	// LPUART1
	LPUART1 = (*LPUART_Type)(unsafe.Pointer(uintptr(0x58000c00)))

	// LCD-TFT Controller
	LTDC = (*LTDC_Type)(unsafe.Pointer(uintptr(0x50001000)))

	// Management data input/output slave
	MDIOS = (*MDIOS_Type)(unsafe.Pointer(uintptr(0x40009400)))

	// MDMA
	MDMA = (*MDMA_Type)(unsafe.Pointer(uintptr(0x52000000)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// OctoSPI
	OCTOSPI1 = (*OctoSPI_Type)(unsafe.Pointer(uintptr(0x52005000)))

	// Operational amplifiers
	OPAMP = (*OPAMP_Type)(unsafe.Pointer(uintptr(0x40009000)))

	// USB 1 on the go high speed
	OTG1_HS_DEVICE = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040800)))

	// USB 1 on the go high speed
	OTG1_HS_GLOBAL = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// USB 1 on the go high speed
	OTG1_HS_HOST = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040400)))

	// USB 1 on the go high speed
	OTG1_HS_PWRCLK = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040e00)))

	// OctoSPI IO Manager
	OctoSPII_O_Manager = (*OctoSPII_O_Manager_Type)(unsafe.Pointer(uintptr(0x5200b400)))

	// Processor features
	PF = (*PF_Type)(unsafe.Pointer(uintptr(0xe000ed78)))

	// PWR
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x58024800)))

	// ECC controller is associated to each RAM area
	RAMECC1 = (*RAMECC_Type)(unsafe.Pointer(uintptr(0x52009000)))

	// ECC controller is associated to each RAM area
	RAMECC2 = (*RAMECC_Type)(unsafe.Pointer(uintptr(0x48023000)))

	// ECC controller is associated to each RAM area
	RAMECC3 = (*RAMECC_Type)(unsafe.Pointer(uintptr(0x58027000)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x58024400)))

	// RNG
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x48021800)))

	// RTC
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x58004000)))

	// SAI
	SAI1 = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015800)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// System control block ACTLR
	SCB_ACTRL = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))

	// SDMMC1
	SDMMC1 = (*SDMMC_Type)(unsafe.Pointer(uintptr(0x52007000)))

	// Receiver Interface
	SPDIFRX = (*SPDIFRX_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Serial peripheral interface
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// Single Wire Protocol Master Interface
	SWPMI = (*SWPMI_Type)(unsafe.Pointer(uintptr(0x40008800)))

	// System configuration controller
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x58000400)))

	// Advanced-timers
	TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// General purpose timers
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Basic timers
	TIM6 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// General purpose timers
	TIM15 = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// General-purpose-timers
	TIM16 = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// General-purpose-timers
	TIM17 = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40011000)))

	// VREFBUF
	VREFBUF = (*VREFBUF_Type)(unsafe.Pointer(uintptr(0x58003c00)))

	// WWDG
	WWDG1 = (*WWDG_Type)(unsafe.Pointer(uintptr(0x50003000)))

	// General purpose timers
	TIM3 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// General purpose timers
	TIM4 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))

	// General purpose timers
	TIM12 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001800)))

	// General purpose timers
	TIM13 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001c00)))

	// General purpose timers
	TIM14 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// Basic Direct Memory Access
	BDMA = (*BDMA_Type)(unsafe.Pointer(uintptr(0x58025400)))

	// Ethernet DMA
	Ethernet_DMA = (*Ethernet_DMA_Type)(unsafe.Pointer(uintptr(0x40029000)))

	// Ethernet MTL
	Ethernet_MTL = (*Ethernet_MTL_Type)(unsafe.Pointer(uintptr(0x40028c00)))

	// Analog to Digital Converter
	ADC3 = (*ADC_Type)(unsafe.Pointer(uintptr(0x58026000)))

	// Analog-to-Digital Converter
	ADC3_Common = (*ADC_Type)(unsafe.Pointer(uintptr(0x58026300)))

	// DELAY_Block_SDMMC1
	DELAY_Block_SDMMC2 = (*DLYB_Type)(unsafe.Pointer(uintptr(0x48022800)))

	// DELAY_Block_SDMMC1
	Delay_Block_OCTOSPI1 = (*DLYB_Type)(unsafe.Pointer(uintptr(0x52006000)))

	// DELAY_Block_SDMMC1
	Delay_Block_OCTOSPI2 = (*DLYB_Type)(unsafe.Pointer(uintptr(0x5200b000)))

	// FDCAN1
	FDCAN2 = (*FDCAN_Type)(unsafe.Pointer(uintptr(0x4000a400)))

	// GPIO
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x58020400)))

	// GPIO
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x58020800)))

	// GPIO
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x58020c00)))

	// GPIO
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x58021000)))

	// GPIO
	GPIOF = (*GPIO_Type)(unsafe.Pointer(uintptr(0x58021400)))

	// GPIO
	GPIOG = (*GPIO_Type)(unsafe.Pointer(uintptr(0x58021800)))

	// GPIO
	GPIOH = (*GPIO_Type)(unsafe.Pointer(uintptr(0x58021c00)))

	// GPIO
	GPIOJ = (*GPIO_Type)(unsafe.Pointer(uintptr(0x58022400)))

	// GPIO
	GPIOK = (*GPIO_Type)(unsafe.Pointer(uintptr(0x58022800)))

	// I2C
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// I2C
	I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// I2C
	I2C4 = (*I2C_Type)(unsafe.Pointer(uintptr(0x58001c00)))

	// Low power timer
	LPTIM2 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x58002400)))

	// Low power timer
	LPTIM4 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x58002c00)))

	// Low power timer
	LPTIM5 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x58003000)))

	// OctoSPI
	OCTOSPI2 = (*OctoSPI_Type)(unsafe.Pointer(uintptr(0x5200a000)))

	// USB 1 on the go high speed
	OTG2_HS_DEVICE = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40080800)))

	// USB 1 on the go high speed
	OTG2_HS_HOST = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40080400)))

	// USB 1 on the go high speed
	OTG2_HS_PWRCLK = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40080e00)))

	// SAI
	SAI4 = (*SAI_Type)(unsafe.Pointer(uintptr(0x58005400)))

	// SDMMC1
	SDMMC2 = (*SDMMC_Type)(unsafe.Pointer(uintptr(0x48022400)))

	// Serial peripheral interface
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// Serial peripheral interface
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))

	// Serial peripheral interface
	SPI4 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013400)))

	// Serial peripheral interface
	SPI5 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40015000)))

	// Serial peripheral interface
	SPI6 = (*SPI_Type)(unsafe.Pointer(uintptr(0x58001400)))

	// General purpose timers
	TIM5 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000c00)))

	// Basic timers
	TIM7 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// Advanced-timers
	TIM8 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010400)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))

	// Universal synchronous asynchronous receiver transmitter
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))

	// Universal synchronous asynchronous receiver transmitter
	UART4 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))

	// Universal synchronous asynchronous receiver transmitter
	UART5 = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// Universal synchronous asynchronous receiver transmitter
	USART6 = (*USART_Type)(unsafe.Pointer(uintptr(0x40011400)))

	// Universal synchronous asynchronous receiver transmitter
	UART7 = (*USART_Type)(unsafe.Pointer(uintptr(0x40007800)))

	// Universal synchronous asynchronous receiver transmitter
	UART8 = (*USART_Type)(unsafe.Pointer(uintptr(0x40007c00)))

	// Analog to Digital Converter
	ADC2 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40022100)))

	// DMA controller
	DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020400)))
)

// Access control
type AC_Type struct {
	ITCMCR volatile.Register32 // 0x0
	DTCMCR volatile.Register32 // 0x4
	AHBPCR volatile.Register32 // 0x8
	CACR   volatile.Register32 // 0xC
	AHBSCR volatile.Register32 // 0x10
	_      [4]byte
	ABFSR  volatile.Register32 // 0x18
}

// AC.ITCMCR: Instruction and Data Tightly-Coupled Memory Control Registers
func (o *AC_Type) SetITCMCR_EN(value uint32) {
	volatile.StoreUint32(&o.ITCMCR.Reg, volatile.LoadUint32(&o.ITCMCR.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetITCMCR_EN() uint32 {
	return volatile.LoadUint32(&o.ITCMCR.Reg) & 0x1
}
func (o *AC_Type) SetITCMCR_RMW(value uint32) {
	volatile.StoreUint32(&o.ITCMCR.Reg, volatile.LoadUint32(&o.ITCMCR.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetITCMCR_RMW() uint32 {
	return (volatile.LoadUint32(&o.ITCMCR.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetITCMCR_RETEN(value uint32) {
	volatile.StoreUint32(&o.ITCMCR.Reg, volatile.LoadUint32(&o.ITCMCR.Reg)&^(0x4)|value<<2)
}
func (o *AC_Type) GetITCMCR_RETEN() uint32 {
	return (volatile.LoadUint32(&o.ITCMCR.Reg) & 0x4) >> 2
}
func (o *AC_Type) SetITCMCR_SZ(value uint32) {
	volatile.StoreUint32(&o.ITCMCR.Reg, volatile.LoadUint32(&o.ITCMCR.Reg)&^(0x78)|value<<3)
}
func (o *AC_Type) GetITCMCR_SZ() uint32 {
	return (volatile.LoadUint32(&o.ITCMCR.Reg) & 0x78) >> 3
}

// AC.DTCMCR: Instruction and Data Tightly-Coupled Memory Control Registers
func (o *AC_Type) SetDTCMCR_EN(value uint32) {
	volatile.StoreUint32(&o.DTCMCR.Reg, volatile.LoadUint32(&o.DTCMCR.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetDTCMCR_EN() uint32 {
	return volatile.LoadUint32(&o.DTCMCR.Reg) & 0x1
}
func (o *AC_Type) SetDTCMCR_RMW(value uint32) {
	volatile.StoreUint32(&o.DTCMCR.Reg, volatile.LoadUint32(&o.DTCMCR.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetDTCMCR_RMW() uint32 {
	return (volatile.LoadUint32(&o.DTCMCR.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetDTCMCR_RETEN(value uint32) {
	volatile.StoreUint32(&o.DTCMCR.Reg, volatile.LoadUint32(&o.DTCMCR.Reg)&^(0x4)|value<<2)
}
func (o *AC_Type) GetDTCMCR_RETEN() uint32 {
	return (volatile.LoadUint32(&o.DTCMCR.Reg) & 0x4) >> 2
}
func (o *AC_Type) SetDTCMCR_SZ(value uint32) {
	volatile.StoreUint32(&o.DTCMCR.Reg, volatile.LoadUint32(&o.DTCMCR.Reg)&^(0x78)|value<<3)
}
func (o *AC_Type) GetDTCMCR_SZ() uint32 {
	return (volatile.LoadUint32(&o.DTCMCR.Reg) & 0x78) >> 3
}

// AC.AHBPCR: AHBP Control register
func (o *AC_Type) SetAHBPCR_EN(value uint32) {
	volatile.StoreUint32(&o.AHBPCR.Reg, volatile.LoadUint32(&o.AHBPCR.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetAHBPCR_EN() uint32 {
	return volatile.LoadUint32(&o.AHBPCR.Reg) & 0x1
}
func (o *AC_Type) SetAHBPCR_SZ(value uint32) {
	volatile.StoreUint32(&o.AHBPCR.Reg, volatile.LoadUint32(&o.AHBPCR.Reg)&^(0xe)|value<<1)
}
func (o *AC_Type) GetAHBPCR_SZ() uint32 {
	return (volatile.LoadUint32(&o.AHBPCR.Reg) & 0xe) >> 1
}

// AC.CACR: Auxiliary Cache Control register
func (o *AC_Type) SetCACR_SIWT(value uint32) {
	volatile.StoreUint32(&o.CACR.Reg, volatile.LoadUint32(&o.CACR.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetCACR_SIWT() uint32 {
	return volatile.LoadUint32(&o.CACR.Reg) & 0x1
}
func (o *AC_Type) SetCACR_ECCEN(value uint32) {
	volatile.StoreUint32(&o.CACR.Reg, volatile.LoadUint32(&o.CACR.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetCACR_ECCEN() uint32 {
	return (volatile.LoadUint32(&o.CACR.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetCACR_FORCEWT(value uint32) {
	volatile.StoreUint32(&o.CACR.Reg, volatile.LoadUint32(&o.CACR.Reg)&^(0x4)|value<<2)
}
func (o *AC_Type) GetCACR_FORCEWT() uint32 {
	return (volatile.LoadUint32(&o.CACR.Reg) & 0x4) >> 2
}

// AC.AHBSCR: AHB Slave Control register
func (o *AC_Type) SetAHBSCR_CTL(value uint32) {
	volatile.StoreUint32(&o.AHBSCR.Reg, volatile.LoadUint32(&o.AHBSCR.Reg)&^(0x3)|value)
}
func (o *AC_Type) GetAHBSCR_CTL() uint32 {
	return volatile.LoadUint32(&o.AHBSCR.Reg) & 0x3
}
func (o *AC_Type) SetAHBSCR_TPRI(value uint32) {
	volatile.StoreUint32(&o.AHBSCR.Reg, volatile.LoadUint32(&o.AHBSCR.Reg)&^(0x7fc)|value<<2)
}
func (o *AC_Type) GetAHBSCR_TPRI() uint32 {
	return (volatile.LoadUint32(&o.AHBSCR.Reg) & 0x7fc) >> 2
}
func (o *AC_Type) SetAHBSCR_INITCOUNT(value uint32) {
	volatile.StoreUint32(&o.AHBSCR.Reg, volatile.LoadUint32(&o.AHBSCR.Reg)&^(0xf800)|value<<11)
}
func (o *AC_Type) GetAHBSCR_INITCOUNT() uint32 {
	return (volatile.LoadUint32(&o.AHBSCR.Reg) & 0xf800) >> 11
}

// AC.ABFSR: Auxiliary Bus Fault Status register
func (o *AC_Type) SetABFSR_ITCM(value uint32) {
	volatile.StoreUint32(&o.ABFSR.Reg, volatile.LoadUint32(&o.ABFSR.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetABFSR_ITCM() uint32 {
	return volatile.LoadUint32(&o.ABFSR.Reg) & 0x1
}
func (o *AC_Type) SetABFSR_DTCM(value uint32) {
	volatile.StoreUint32(&o.ABFSR.Reg, volatile.LoadUint32(&o.ABFSR.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetABFSR_DTCM() uint32 {
	return (volatile.LoadUint32(&o.ABFSR.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetABFSR_AHBP(value uint32) {
	volatile.StoreUint32(&o.ABFSR.Reg, volatile.LoadUint32(&o.ABFSR.Reg)&^(0x4)|value<<2)
}
func (o *AC_Type) GetABFSR_AHBP() uint32 {
	return (volatile.LoadUint32(&o.ABFSR.Reg) & 0x4) >> 2
}
func (o *AC_Type) SetABFSR_AXIM(value uint32) {
	volatile.StoreUint32(&o.ABFSR.Reg, volatile.LoadUint32(&o.ABFSR.Reg)&^(0x8)|value<<3)
}
func (o *AC_Type) GetABFSR_AXIM() uint32 {
	return (volatile.LoadUint32(&o.ABFSR.Reg) & 0x8) >> 3
}
func (o *AC_Type) SetABFSR_EPPB(value uint32) {
	volatile.StoreUint32(&o.ABFSR.Reg, volatile.LoadUint32(&o.ABFSR.Reg)&^(0x10)|value<<4)
}
func (o *AC_Type) GetABFSR_EPPB() uint32 {
	return (volatile.LoadUint32(&o.ABFSR.Reg) & 0x10) >> 4
}
func (o *AC_Type) SetABFSR_AXIMTYPE(value uint32) {
	volatile.StoreUint32(&o.ABFSR.Reg, volatile.LoadUint32(&o.ABFSR.Reg)&^(0x300)|value<<8)
}
func (o *AC_Type) GetABFSR_AXIMTYPE() uint32 {
	return (volatile.LoadUint32(&o.ABFSR.Reg) & 0x300) >> 8
}

// Analog to Digital Converter
type ADC_Type struct {
	ISR      volatile.Register32 // 0x0
	IER      volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	CFGR     volatile.Register32 // 0xC
	CFGR2    volatile.Register32 // 0x10
	SMPR1    volatile.Register32 // 0x14
	SMPR2    volatile.Register32 // 0x18
	PCSEL    volatile.Register32 // 0x1C
	LTR1     volatile.Register32 // 0x20
	HTR1     volatile.Register32 // 0x24
	_        [8]byte
	SQR1     volatile.Register32 // 0x30
	SQR2     volatile.Register32 // 0x34
	SQR3     volatile.Register32 // 0x38
	SQR4     volatile.Register32 // 0x3C
	DR       volatile.Register32 // 0x40
	_        [8]byte
	JSQR     volatile.Register32 // 0x4C
	_        [16]byte
	OFR1     volatile.Register32 // 0x60
	OFR2     volatile.Register32 // 0x64
	OFR3     volatile.Register32 // 0x68
	OFR4     volatile.Register32 // 0x6C
	_        [16]byte
	JDR1     volatile.Register32 // 0x80
	JDR2     volatile.Register32 // 0x84
	JDR3     volatile.Register32 // 0x88
	JDR4     volatile.Register32 // 0x8C
	_        [16]byte
	AWD2CR   volatile.Register32 // 0xA0
	AWD3CR   volatile.Register32 // 0xA4
	_        [8]byte
	LTR2     volatile.Register32 // 0xB0
	HTR2     volatile.Register32 // 0xB4
	LTR3     volatile.Register32 // 0xB8
	HTR3     volatile.Register32 // 0xBC
	DIFSEL   volatile.Register32 // 0xC0
	CALFACT  volatile.Register32 // 0xC4
	CALFACT2 volatile.Register32 // 0xC8
}

// ADC.ISR: ADC interrupt and status register
func (o *ADC_Type) SetISR_JQOVF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetISR_JQOVF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetISR_AWD3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetISR_AWD3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetISR_AWD2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetISR_AWD2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetISR_AWD1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetISR_AWD1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetISR_JEOS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetISR_JEOS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetISR_JEOC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetISR_JEOC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetISR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetISR_EOS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetISR_EOS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetISR_EOC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetISR_EOC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetISR_EOSMP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetISR_EOSMP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetISR_ADRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetISR_ADRDY() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// ADC.IER: ADC interrupt enable register
func (o *ADC_Type) SetIER_JQOVFIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIER_JQOVFIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIER_AWD3IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIER_AWD3IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIER_AWD2IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIER_AWD2IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIER_AWD1IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIER_AWD1IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIER_JEOSIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIER_JEOSIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIER_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIER_JEOCIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIER_OVRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIER_OVRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIER_EOSIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIER_EOSIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIER_EOCIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIER_EOCIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIER_EOSMPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIER_EOSMPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIER_ADRDYIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIER_ADRDYIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// ADC.CR: ADC control register
func (o *ADC_Type) SetCR_ADCAL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetCR_ADCAL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetCR_ADCALDIF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetCR_ADCALDIF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetCR_DEEPPWD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetCR_DEEPPWD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetCR_ADVREGEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetCR_ADVREGEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *ADC_Type) SetCR_LINCALRDYW6(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetCR_LINCALRDYW6() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetCR_LINCALRDYW5(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetCR_LINCALRDYW5() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetCR_LINCALRDYW4(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetCR_LINCALRDYW4() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetCR_LINCALRDYW3(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetCR_LINCALRDYW3() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetCR_LINCALRDYW2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCR_LINCALRDYW2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCR_LINCALRDYW1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCR_LINCALRDYW1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCR_ADCALLIN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetCR_ADCALLIN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetCR_BOOST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *ADC_Type) GetCR_BOOST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *ADC_Type) SetCR_JADSTP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCR_JADSTP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCR_ADSTP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCR_ADSTP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCR_JADSTART(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCR_JADSTART() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCR_ADSTART(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCR_ADSTART() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCR_ADDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCR_ADDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCR_ADEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCR_ADEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// ADC.CFGR: ADC configuration register 1
func (o *ADC_Type) SetCFGR_JQDIS(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetCFGR_JQDIS() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetCFGR_AWD1CH(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetCFGR_AWD1CH() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetCFGR_JAUTO(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetCFGR_JAUTO() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetCFGR_JAWD1EN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetCFGR_JAWD1EN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetCFGR_AWD1EN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCFGR_AWD1EN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCFGR_AWD1SGL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCFGR_AWD1SGL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCFGR_JQM(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetCFGR_JQM() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetCFGR_JDISCEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetCFGR_JDISCEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetCFGR_DISCNUM(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe0000)|value<<17)
}
func (o *ADC_Type) GetCFGR_DISCNUM() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe0000) >> 17
}
func (o *ADC_Type) SetCFGR_DISCEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetCFGR_DISCEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetCFGR_AUTDLY(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCFGR_AUTDLY() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCFGR_CONT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCFGR_CONT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCFGR_OVRMOD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCFGR_OVRMOD() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCFGR_EXTEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc00)|value<<10)
}
func (o *ADC_Type) GetCFGR_EXTEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc00) >> 10
}
func (o *ADC_Type) SetCFGR_EXTSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetCFGR_EXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetCFGR_RES(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1c)|value<<2)
}
func (o *ADC_Type) GetCFGR_RES() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1c) >> 2
}
func (o *ADC_Type) SetCFGR_DMNGT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetCFGR_DMNGT() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x3
}

// ADC.CFGR2: ADC configuration register 2
func (o *ADC_Type) SetCFGR2_ROVSE(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCFGR2_ROVSE() uint32 {
	return volatile.LoadUint32(&o.CFGR2.Reg) & 0x1
}
func (o *ADC_Type) SetCFGR2_JOVSE(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCFGR2_JOVSE() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCFGR2_OVSS(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1e0)|value<<5)
}
func (o *ADC_Type) GetCFGR2_OVSS() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x1e0) >> 5
}
func (o *ADC_Type) SetCFGR2_TROVS(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCFGR2_TROVS() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCFGR2_ROVSM(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCFGR2_ROVSM() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCFGR2_RSHIFT1(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCFGR2_RSHIFT1() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCFGR2_RSHIFT2(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCFGR2_RSHIFT2() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCFGR2_RSHIFT3(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCFGR2_RSHIFT3() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCFGR2_RSHIFT4(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCFGR2_RSHIFT4() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCFGR2_OSVR(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x3ff0000)|value<<16)
}
func (o *ADC_Type) GetCFGR2_OSVR() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x3ff0000) >> 16
}
func (o *ADC_Type) SetCFGR2_LSHIFT(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0xf0000000)|value<<28)
}
func (o *ADC_Type) GetCFGR2_LSHIFT() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0xf0000000) >> 28
}

// ADC.SMPR1: ADC sampling time register 1
func (o *ADC_Type) SetSMPR1_SMP9(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38000000)|value<<27)
}
func (o *ADC_Type) GetSMPR1_SMP9() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38000000) >> 27
}
func (o *ADC_Type) SetSMPR1_SMP8(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7000000)|value<<24)
}
func (o *ADC_Type) GetSMPR1_SMP8() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x7000000) >> 24
}
func (o *ADC_Type) SetSMPR1_SMP7(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0xe00000)|value<<21)
}
func (o *ADC_Type) GetSMPR1_SMP7() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0xe00000) >> 21
}
func (o *ADC_Type) SetSMPR1_SMP6(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x1c0000)|value<<18)
}
func (o *ADC_Type) GetSMPR1_SMP6() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x1c0000) >> 18
}
func (o *ADC_Type) SetSMPR1_SMP5(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38000)|value<<15)
}
func (o *ADC_Type) GetSMPR1_SMP5() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38000) >> 15
}
func (o *ADC_Type) SetSMPR1_SMP4(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetSMPR1_SMP4() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetSMPR1_SMP3(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0xe00)|value<<9)
}
func (o *ADC_Type) GetSMPR1_SMP3() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0xe00) >> 9
}
func (o *ADC_Type) SetSMPR1_SMP2(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x1c0)|value<<6)
}
func (o *ADC_Type) GetSMPR1_SMP2() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x1c0) >> 6
}
func (o *ADC_Type) SetSMPR1_SMP1(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38)|value<<3)
}
func (o *ADC_Type) GetSMPR1_SMP1() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38) >> 3
}
func (o *ADC_Type) SetSMPR1_SMP0(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetSMPR1_SMP0() uint32 {
	return volatile.LoadUint32(&o.SMPR1.Reg) & 0x7
}

// ADC.SMPR2: ADC sampling time register 2
func (o *ADC_Type) SetSMPR2_SMP19(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38000000)|value<<27)
}
func (o *ADC_Type) GetSMPR2_SMP19() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38000000) >> 27
}
func (o *ADC_Type) SetSMPR2_SMP18(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7000000)|value<<24)
}
func (o *ADC_Type) GetSMPR2_SMP18() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x7000000) >> 24
}
func (o *ADC_Type) SetSMPR2_SMP17(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0xe00000)|value<<21)
}
func (o *ADC_Type) GetSMPR2_SMP17() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0xe00000) >> 21
}
func (o *ADC_Type) SetSMPR2_SMP16(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x1c0000)|value<<18)
}
func (o *ADC_Type) GetSMPR2_SMP16() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x1c0000) >> 18
}
func (o *ADC_Type) SetSMPR2_SMP15(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38000)|value<<15)
}
func (o *ADC_Type) GetSMPR2_SMP15() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38000) >> 15
}
func (o *ADC_Type) SetSMPR2_SMP14(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetSMPR2_SMP14() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetSMPR2_SMP13(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0xe00)|value<<9)
}
func (o *ADC_Type) GetSMPR2_SMP13() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0xe00) >> 9
}
func (o *ADC_Type) SetSMPR2_SMP12(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x1c0)|value<<6)
}
func (o *ADC_Type) GetSMPR2_SMP12() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x1c0) >> 6
}
func (o *ADC_Type) SetSMPR2_SMP11(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38)|value<<3)
}
func (o *ADC_Type) GetSMPR2_SMP11() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38) >> 3
}
func (o *ADC_Type) SetSMPR2_SMP10(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetSMPR2_SMP10() uint32 {
	return volatile.LoadUint32(&o.SMPR2.Reg) & 0x7
}

// ADC.PCSEL: ADC pre channel selection register
func (o *ADC_Type) SetPCSEL(value uint32) {
	volatile.StoreUint32(&o.PCSEL.Reg, volatile.LoadUint32(&o.PCSEL.Reg)&^(0xfffff)|value)
}
func (o *ADC_Type) GetPCSEL() uint32 {
	return volatile.LoadUint32(&o.PCSEL.Reg) & 0xfffff
}

// ADC.LTR1: ADC analog watchdog 1 threshold register
func (o *ADC_Type) SetLTR1(value uint32) {
	volatile.StoreUint32(&o.LTR1.Reg, volatile.LoadUint32(&o.LTR1.Reg)&^(0x3ffffff)|value)
}
func (o *ADC_Type) GetLTR1() uint32 {
	return volatile.LoadUint32(&o.LTR1.Reg) & 0x3ffffff
}

// ADC.HTR1: ADC analog watchdog 2 threshold register
func (o *ADC_Type) SetHTR1(value uint32) {
	volatile.StoreUint32(&o.HTR1.Reg, volatile.LoadUint32(&o.HTR1.Reg)&^(0x3ffffff)|value)
}
func (o *ADC_Type) GetHTR1() uint32 {
	return volatile.LoadUint32(&o.HTR1.Reg) & 0x3ffffff
}

// ADC.SQR1: ADC group regular sequencer ranks register 1
func (o *ADC_Type) SetSQR1_SQ4(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x1f000000)|value<<24)
}
func (o *ADC_Type) GetSQR1_SQ4() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x1f000000) >> 24
}
func (o *ADC_Type) SetSQR1_SQ3(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x7c0000)|value<<18)
}
func (o *ADC_Type) GetSQR1_SQ3() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x7c0000) >> 18
}
func (o *ADC_Type) SetSQR1_SQ2(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x1f000)|value<<12)
}
func (o *ADC_Type) GetSQR1_SQ2() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x1f000) >> 12
}
func (o *ADC_Type) SetSQR1_SQ1(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR1_SQ1() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR1_L(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSQR1_L() uint32 {
	return volatile.LoadUint32(&o.SQR1.Reg) & 0xf
}

// ADC.SQR2: ADC group regular sequencer ranks register 2
func (o *ADC_Type) SetSQR2_SQ9(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f000000)|value<<24)
}
func (o *ADC_Type) GetSQR2_SQ9() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x1f000000) >> 24
}
func (o *ADC_Type) SetSQR2_SQ8(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x7c0000)|value<<18)
}
func (o *ADC_Type) GetSQR2_SQ8() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x7c0000) >> 18
}
func (o *ADC_Type) SetSQR2_SQ7(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f000)|value<<12)
}
func (o *ADC_Type) GetSQR2_SQ7() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x1f000) >> 12
}
func (o *ADC_Type) SetSQR2_SQ6(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR2_SQ6() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR2_SQ5(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR2_SQ5() uint32 {
	return volatile.LoadUint32(&o.SQR2.Reg) & 0x1f
}

// ADC.SQR3: ADC group regular sequencer ranks register 3
func (o *ADC_Type) SetSQR3_SQ14(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f000000)|value<<24)
}
func (o *ADC_Type) GetSQR3_SQ14() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x1f000000) >> 24
}
func (o *ADC_Type) SetSQR3_SQ13(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x7c0000)|value<<18)
}
func (o *ADC_Type) GetSQR3_SQ13() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x7c0000) >> 18
}
func (o *ADC_Type) SetSQR3_SQ12(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f000)|value<<12)
}
func (o *ADC_Type) GetSQR3_SQ12() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x1f000) >> 12
}
func (o *ADC_Type) SetSQR3_SQ11(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR3_SQ11() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR3_SQ10(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR3_SQ10() uint32 {
	return volatile.LoadUint32(&o.SQR3.Reg) & 0x1f
}

// ADC.SQR4: ADC group regular sequencer ranks register 4
func (o *ADC_Type) SetSQR4_SQ16(value uint32) {
	volatile.StoreUint32(&o.SQR4.Reg, volatile.LoadUint32(&o.SQR4.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR4_SQ16() uint32 {
	return (volatile.LoadUint32(&o.SQR4.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR4_SQ15(value uint32) {
	volatile.StoreUint32(&o.SQR4.Reg, volatile.LoadUint32(&o.SQR4.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR4_SQ15() uint32 {
	return volatile.LoadUint32(&o.SQR4.Reg) & 0x1f
}

// ADC.DR: ADC group regular conversion data register
func (o *ADC_Type) SetDR_RDATA(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetDR_RDATA() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// ADC.JSQR: ADC group injected sequencer register
func (o *ADC_Type) SetJSQR_JSQ4(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0xf8000000)|value<<27)
}
func (o *ADC_Type) GetJSQR_JSQ4() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0xf8000000) >> 27
}
func (o *ADC_Type) SetJSQR_JSQ3(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x3e00000)|value<<21)
}
func (o *ADC_Type) GetJSQR_JSQ3() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x3e00000) >> 21
}
func (o *ADC_Type) SetJSQR_JSQ2(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetJSQR_JSQ2() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetJSQR_JSQ1(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x3e00)|value<<9)
}
func (o *ADC_Type) GetJSQR_JSQ1() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x3e00) >> 9
}
func (o *ADC_Type) SetJSQR_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x180)|value<<7)
}
func (o *ADC_Type) GetJSQR_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x180) >> 7
}
func (o *ADC_Type) SetJSQR_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x7c)|value<<2)
}
func (o *ADC_Type) GetJSQR_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x7c) >> 2
}
func (o *ADC_Type) SetJSQR_JL(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetJSQR_JL() uint32 {
	return volatile.LoadUint32(&o.JSQR.Reg) & 0x3
}

// ADC.OFR1: ADC offset number 1 register
func (o *ADC_Type) SetOFR1_SSATE(value uint32) {
	volatile.StoreUint32(&o.OFR1.Reg, volatile.LoadUint32(&o.OFR1.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR1_SSATE() uint32 {
	return (volatile.LoadUint32(&o.OFR1.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR1_OFFSET1_CH(value uint32) {
	volatile.StoreUint32(&o.OFR1.Reg, volatile.LoadUint32(&o.OFR1.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR1_OFFSET1_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR1.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR1_OFFSET1(value uint32) {
	volatile.StoreUint32(&o.OFR1.Reg, volatile.LoadUint32(&o.OFR1.Reg)&^(0x3ffffff)|value)
}
func (o *ADC_Type) GetOFR1_OFFSET1() uint32 {
	return volatile.LoadUint32(&o.OFR1.Reg) & 0x3ffffff
}

// ADC.OFR2: ADC offset number 2 register
func (o *ADC_Type) SetOFR2_SSATE(value uint32) {
	volatile.StoreUint32(&o.OFR2.Reg, volatile.LoadUint32(&o.OFR2.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR2_SSATE() uint32 {
	return (volatile.LoadUint32(&o.OFR2.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR2_OFFSET2_CH(value uint32) {
	volatile.StoreUint32(&o.OFR2.Reg, volatile.LoadUint32(&o.OFR2.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR2_OFFSET2_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR2.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR2_OFFSET2(value uint32) {
	volatile.StoreUint32(&o.OFR2.Reg, volatile.LoadUint32(&o.OFR2.Reg)&^(0x3ffffff)|value)
}
func (o *ADC_Type) GetOFR2_OFFSET2() uint32 {
	return volatile.LoadUint32(&o.OFR2.Reg) & 0x3ffffff
}

// ADC.OFR3: ADC offset number 3 register
func (o *ADC_Type) SetOFR3_SSATE(value uint32) {
	volatile.StoreUint32(&o.OFR3.Reg, volatile.LoadUint32(&o.OFR3.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR3_SSATE() uint32 {
	return (volatile.LoadUint32(&o.OFR3.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR3_OFFSET3_CH(value uint32) {
	volatile.StoreUint32(&o.OFR3.Reg, volatile.LoadUint32(&o.OFR3.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR3_OFFSET3_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR3.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR3_OFFSET3(value uint32) {
	volatile.StoreUint32(&o.OFR3.Reg, volatile.LoadUint32(&o.OFR3.Reg)&^(0x3ffffff)|value)
}
func (o *ADC_Type) GetOFR3_OFFSET3() uint32 {
	return volatile.LoadUint32(&o.OFR3.Reg) & 0x3ffffff
}

// ADC.OFR4: ADC offset number 4 register
func (o *ADC_Type) SetOFR4_SSATE(value uint32) {
	volatile.StoreUint32(&o.OFR4.Reg, volatile.LoadUint32(&o.OFR4.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR4_SSATE() uint32 {
	return (volatile.LoadUint32(&o.OFR4.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR4_OFFSET4_CH(value uint32) {
	volatile.StoreUint32(&o.OFR4.Reg, volatile.LoadUint32(&o.OFR4.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR4_OFFSET4_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR4.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR4_OFFSET4(value uint32) {
	volatile.StoreUint32(&o.OFR4.Reg, volatile.LoadUint32(&o.OFR4.Reg)&^(0x3ffffff)|value)
}
func (o *ADC_Type) GetOFR4_OFFSET4() uint32 {
	return volatile.LoadUint32(&o.OFR4.Reg) & 0x3ffffff
}

// ADC.JDR1: ADC group injected sequencer rank 1 register
func (o *ADC_Type) SetJDR1(value uint32) {
	volatile.StoreUint32(&o.JDR1.Reg, value)
}
func (o *ADC_Type) GetJDR1() uint32 {
	return volatile.LoadUint32(&o.JDR1.Reg)
}

// ADC.JDR2: ADC group injected sequencer rank 2 register
func (o *ADC_Type) SetJDR2(value uint32) {
	volatile.StoreUint32(&o.JDR2.Reg, value)
}
func (o *ADC_Type) GetJDR2() uint32 {
	return volatile.LoadUint32(&o.JDR2.Reg)
}

// ADC.JDR3: ADC group injected sequencer rank 3 register
func (o *ADC_Type) SetJDR3(value uint32) {
	volatile.StoreUint32(&o.JDR3.Reg, value)
}
func (o *ADC_Type) GetJDR3() uint32 {
	return volatile.LoadUint32(&o.JDR3.Reg)
}

// ADC.JDR4: ADC group injected sequencer rank 4 register
func (o *ADC_Type) SetJDR4(value uint32) {
	volatile.StoreUint32(&o.JDR4.Reg, value)
}
func (o *ADC_Type) GetJDR4() uint32 {
	return volatile.LoadUint32(&o.JDR4.Reg)
}

// ADC.AWD2CR: ADC analog watchdog 2 configuration register
func (o *ADC_Type) SetAWD2CR_AWD2CH0(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH0() uint32 {
	return volatile.LoadUint32(&o.AWD2CR.Reg) & 0x1
}
func (o *ADC_Type) SetAWD2CR_AWD2CH1(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH1() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetAWD2CR_AWD2CH2(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH2() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetAWD2CR_AWD2CH3(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH3() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetAWD2CR_AWD2CH4(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH4() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetAWD2CR_AWD2CH5(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH5() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetAWD2CR_AWD2CH6(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH6() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetAWD2CR_AWD2CH7(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH7() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetAWD2CR_AWD2CH8(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH8() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetAWD2CR_AWD2CH9(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH9() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetAWD2CR_AWD2CH10(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH10() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetAWD2CR_AWD2CH11(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH11() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetAWD2CR_AWD2CH12(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH12() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetAWD2CR_AWD2CH13(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH13() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetAWD2CR_AWD2CH14(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH14() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetAWD2CR_AWD2CH15(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH15() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetAWD2CR_AWD2CH16(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH16() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetAWD2CR_AWD2CH17(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH17() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetAWD2CR_AWD2CH18(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH18() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x40000) >> 18
}
func (o *ADC_Type) SetAWD2CR_AWD2CH19(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x80000)|value<<19)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH19() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x80000) >> 19
}

// ADC.AWD3CR: ADC analog watchdog 3 configuration register
func (o *ADC_Type) SetAWD3CR_AWD3CH0(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH0() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetAWD3CR_AWD3CH1(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH1() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetAWD3CR_AWD3CH2(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH2() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetAWD3CR_AWD3CH3(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH3() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetAWD3CR_AWD3CH4(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH4() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetAWD3CR_AWD3CH5(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH5() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetAWD3CR_AWD3CH6(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH6() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetAWD3CR_AWD3CH7(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH7() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetAWD3CR_AWD3CH8(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH8() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetAWD3CR_AWD3CH9(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH9() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetAWD3CR_AWD3CH10(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH10() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetAWD3CR_AWD3CH11(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH11() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetAWD3CR_AWD3CH12(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH12() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetAWD3CR_AWD3CH13(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH13() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetAWD3CR_AWD3CH14(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH14() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetAWD3CR_AWD3CH15(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH15() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetAWD3CR_AWD3CH16(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH16() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetAWD3CR_AWD3CH17(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH17() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x40000) >> 18
}
func (o *ADC_Type) SetAWD3CR_AWD3CH18(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x80000)|value<<19)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH18() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x80000) >> 19
}
func (o *ADC_Type) SetAWD3CR_AWD3CH19(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH19() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x100000) >> 20
}

// ADC.LTR2: ADC watchdog lower threshold register 2
func (o *ADC_Type) SetLTR2(value uint32) {
	volatile.StoreUint32(&o.LTR2.Reg, volatile.LoadUint32(&o.LTR2.Reg)&^(0x3ffffff)|value)
}
func (o *ADC_Type) GetLTR2() uint32 {
	return volatile.LoadUint32(&o.LTR2.Reg) & 0x3ffffff
}

// ADC.HTR2: ADC watchdog higher threshold register 2
func (o *ADC_Type) SetHTR2(value uint32) {
	volatile.StoreUint32(&o.HTR2.Reg, volatile.LoadUint32(&o.HTR2.Reg)&^(0x3ffffff)|value)
}
func (o *ADC_Type) GetHTR2() uint32 {
	return volatile.LoadUint32(&o.HTR2.Reg) & 0x3ffffff
}

// ADC.LTR3: ADC watchdog lower threshold register 3
func (o *ADC_Type) SetLTR3(value uint32) {
	volatile.StoreUint32(&o.LTR3.Reg, volatile.LoadUint32(&o.LTR3.Reg)&^(0x3ffffff)|value)
}
func (o *ADC_Type) GetLTR3() uint32 {
	return volatile.LoadUint32(&o.LTR3.Reg) & 0x3ffffff
}

// ADC.HTR3: ADC watchdog higher threshold register 3
func (o *ADC_Type) SetHTR3(value uint32) {
	volatile.StoreUint32(&o.HTR3.Reg, volatile.LoadUint32(&o.HTR3.Reg)&^(0x3ffffff)|value)
}
func (o *ADC_Type) GetHTR3() uint32 {
	return volatile.LoadUint32(&o.HTR3.Reg) & 0x3ffffff
}

// ADC.DIFSEL: ADC channel differential or single-ended mode selection register
func (o *ADC_Type) SetDIFSEL_DIFSEL0(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL0() uint32 {
	return volatile.LoadUint32(&o.DIFSEL.Reg) & 0x1
}
func (o *ADC_Type) SetDIFSEL_DIFSEL1(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL1() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetDIFSEL_DIFSEL2(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL2() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetDIFSEL_DIFSEL3(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL3() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetDIFSEL_DIFSEL4(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL4() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetDIFSEL_DIFSEL5(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL5() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetDIFSEL_DIFSEL6(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL6() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetDIFSEL_DIFSEL7(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL7() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetDIFSEL_DIFSEL8(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL8() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetDIFSEL_DIFSEL9(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL9() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetDIFSEL_DIFSEL10(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL10() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetDIFSEL_DIFSEL11(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL11() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetDIFSEL_DIFSEL12(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL12() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetDIFSEL_DIFSEL13(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL13() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetDIFSEL_DIFSEL14(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL14() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetDIFSEL_DIFSEL15(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL15() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetDIFSEL_DIFSEL16(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL16() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetDIFSEL_DIFSEL17(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL17() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetDIFSEL_DIFSEL18(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL18() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x40000) >> 18
}
func (o *ADC_Type) SetDIFSEL_DIFSEL19(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x80000)|value<<19)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL19() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x80000) >> 19
}

// ADC.CALFACT: ADC calibration factors register
func (o *ADC_Type) SetCALFACT_CALFACT_D(value uint32) {
	volatile.StoreUint32(&o.CALFACT.Reg, volatile.LoadUint32(&o.CALFACT.Reg)&^(0x7ff0000)|value<<16)
}
func (o *ADC_Type) GetCALFACT_CALFACT_D() uint32 {
	return (volatile.LoadUint32(&o.CALFACT.Reg) & 0x7ff0000) >> 16
}
func (o *ADC_Type) SetCALFACT_CALFACT_S(value uint32) {
	volatile.StoreUint32(&o.CALFACT.Reg, volatile.LoadUint32(&o.CALFACT.Reg)&^(0x7ff)|value)
}
func (o *ADC_Type) GetCALFACT_CALFACT_S() uint32 {
	return volatile.LoadUint32(&o.CALFACT.Reg) & 0x7ff
}

// ADC.CALFACT2: ADC Calibration Factor register 2
func (o *ADC_Type) SetCALFACT2_LINCALFACT(value uint32) {
	volatile.StoreUint32(&o.CALFACT2.Reg, volatile.LoadUint32(&o.CALFACT2.Reg)&^(0x3fffffff)|value)
}
func (o *ADC_Type) GetCALFACT2_LINCALFACT() uint32 {
	return volatile.LoadUint32(&o.CALFACT2.Reg) & 0x3fffffff
}

// AXI interconnect registers
type AXI_Type struct {
	_                   [8144]byte
	PERIPH_ID_4         volatile.Register32 // 0x1FD0
	_                   [12]byte
	PERIPH_ID_0         volatile.Register32 // 0x1FE0
	PERIPH_ID_1         volatile.Register32 // 0x1FE4
	PERIPH_ID_2         volatile.Register32 // 0x1FE8
	PERIPH_ID_3         volatile.Register32 // 0x1FEC
	COMP_ID_0           volatile.Register32 // 0x1FF0
	COMP_ID_1           volatile.Register32 // 0x1FF4
	COMP_ID_2           volatile.Register32 // 0x1FF8
	COMP_ID_3           volatile.Register32 // 0x1FFC
	_                   [8]byte
	TARG1_FN_MOD_ISS_BM volatile.Register32 // 0x2008
	_                   [24]byte
	TARG1_FN_MOD2       volatile.Register32 // 0x2024
	_                   [4]byte
	TARG1_FN_MOD_LB     volatile.Register32 // 0x202C
	_                   [216]byte
	TARG1_FN_MOD        volatile.Register32 // 0x2108
	_                   [3836]byte
	TARG2_FN_MOD_ISS_BM volatile.Register32 // 0x3008
	_                   [24]byte
	TARG2_FN_MOD2       volatile.Register32 // 0x3024
	_                   [4]byte
	TARG2_FN_MOD_LB     volatile.Register32 // 0x302C
	_                   [216]byte
	TARG2_FN_MOD        volatile.Register32 // 0x3108
	_                   [3836]byte
	TARG3_FN_MOD_ISS_BM volatile.Register32 // 0x4008
	_                   [4092]byte
	TARG4_FN_MOD_ISS_BM volatile.Register32 // 0x5008
	_                   [4092]byte
	TARG5_FN_MOD_ISS_BM volatile.Register32 // 0x6008
	_                   [4092]byte
	TARG6_FN_MOD_ISS_BM volatile.Register32 // 0x7008
	_                   [4096]byte
	TARG7_FN_MOD_ISS_BM volatile.Register32 // 0x800C
	_                   [20]byte
	TARG7_FN_MOD2       volatile.Register32 // 0x8024
	_                   [224]byte
	TARG7_FN_MOD        volatile.Register32 // 0x8108
	_                   [237336]byte
	INI1_FN_MOD2        volatile.Register32 // 0x42024
	INI1_FN_MOD_AHB     volatile.Register32 // 0x42028
	_                   [212]byte
	INI1_READ_QOS       volatile.Register32 // 0x42100
	INI1_WRITE_QOS      volatile.Register32 // 0x42104
	INI1_FN_MOD         volatile.Register32 // 0x42108
	_                   [4084]byte
	INI2_READ_QOS       volatile.Register32 // 0x43100
	INI2_WRITE_QOS      volatile.Register32 // 0x43104
	INI2_FN_MOD         volatile.Register32 // 0x43108
	_                   [3864]byte
	INI3_FN_MOD2        volatile.Register32 // 0x44024
	INI3_FN_MOD_AHB     volatile.Register32 // 0x44028
	_                   [212]byte
	INI3_READ_QOS       volatile.Register32 // 0x44100
	INI3_WRITE_QOS      volatile.Register32 // 0x44104
	INI3_FN_MOD         volatile.Register32 // 0x44108
	_                   [4084]byte
	INI4_READ_QOS       volatile.Register32 // 0x45100
	INI4_WRITE_QOS      volatile.Register32 // 0x45104
	INI4_FN_MOD         volatile.Register32 // 0x45108
	_                   [4084]byte
	INI5_READ_QOS       volatile.Register32 // 0x46100
	INI5_WRITE_QOS      volatile.Register32 // 0x46104
	INI5_FN_MOD         volatile.Register32 // 0x46108
	_                   [4084]byte
	INI6_READ_QOS       volatile.Register32 // 0x47100
	INI6_WRITE_QOS      volatile.Register32 // 0x47104
	INI6_FN_MOD         volatile.Register32 // 0x47108
}

// AXI.PERIPH_ID_4: AXI interconnect - peripheral ID4 register
func (o *AXI_Type) SetPERIPH_ID_4_JEP106CON(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID_4.Reg, volatile.LoadUint32(&o.PERIPH_ID_4.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetPERIPH_ID_4_JEP106CON() uint32 {
	return volatile.LoadUint32(&o.PERIPH_ID_4.Reg) & 0xf
}
func (o *AXI_Type) SetPERIPH_ID_4_KCOUNT4(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID_4.Reg, volatile.LoadUint32(&o.PERIPH_ID_4.Reg)&^(0xf0)|value<<4)
}
func (o *AXI_Type) GetPERIPH_ID_4_KCOUNT4() uint32 {
	return (volatile.LoadUint32(&o.PERIPH_ID_4.Reg) & 0xf0) >> 4
}

// AXI.PERIPH_ID_0: AXI interconnect - peripheral ID0 register
func (o *AXI_Type) SetPERIPH_ID_0_PARTNUM(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID_0.Reg, volatile.LoadUint32(&o.PERIPH_ID_0.Reg)&^(0xff)|value)
}
func (o *AXI_Type) GetPERIPH_ID_0_PARTNUM() uint32 {
	return volatile.LoadUint32(&o.PERIPH_ID_0.Reg) & 0xff
}

// AXI.PERIPH_ID_1: AXI interconnect - peripheral ID1 register
func (o *AXI_Type) SetPERIPH_ID_1_PARTNUM(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID_1.Reg, volatile.LoadUint32(&o.PERIPH_ID_1.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetPERIPH_ID_1_PARTNUM() uint32 {
	return volatile.LoadUint32(&o.PERIPH_ID_1.Reg) & 0xf
}
func (o *AXI_Type) SetPERIPH_ID_1_JEP106I(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID_1.Reg, volatile.LoadUint32(&o.PERIPH_ID_1.Reg)&^(0xf0)|value<<4)
}
func (o *AXI_Type) GetPERIPH_ID_1_JEP106I() uint32 {
	return (volatile.LoadUint32(&o.PERIPH_ID_1.Reg) & 0xf0) >> 4
}

// AXI.PERIPH_ID_2: AXI interconnect - peripheral ID2 register
func (o *AXI_Type) SetPERIPH_ID_2_JEP106ID(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID_2.Reg, volatile.LoadUint32(&o.PERIPH_ID_2.Reg)&^(0x7)|value)
}
func (o *AXI_Type) GetPERIPH_ID_2_JEP106ID() uint32 {
	return volatile.LoadUint32(&o.PERIPH_ID_2.Reg) & 0x7
}
func (o *AXI_Type) SetPERIPH_ID_2_JEDEC(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID_2.Reg, volatile.LoadUint32(&o.PERIPH_ID_2.Reg)&^(0x8)|value<<3)
}
func (o *AXI_Type) GetPERIPH_ID_2_JEDEC() uint32 {
	return (volatile.LoadUint32(&o.PERIPH_ID_2.Reg) & 0x8) >> 3
}
func (o *AXI_Type) SetPERIPH_ID_2_REVISION(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID_2.Reg, volatile.LoadUint32(&o.PERIPH_ID_2.Reg)&^(0xf0)|value<<4)
}
func (o *AXI_Type) GetPERIPH_ID_2_REVISION() uint32 {
	return (volatile.LoadUint32(&o.PERIPH_ID_2.Reg) & 0xf0) >> 4
}

// AXI.PERIPH_ID_3: AXI interconnect - peripheral ID3 register
func (o *AXI_Type) SetPERIPH_ID_3_CUST_MOD_NUM(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID_3.Reg, volatile.LoadUint32(&o.PERIPH_ID_3.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetPERIPH_ID_3_CUST_MOD_NUM() uint32 {
	return volatile.LoadUint32(&o.PERIPH_ID_3.Reg) & 0xf
}
func (o *AXI_Type) SetPERIPH_ID_3_REV_AND(value uint32) {
	volatile.StoreUint32(&o.PERIPH_ID_3.Reg, volatile.LoadUint32(&o.PERIPH_ID_3.Reg)&^(0xf0)|value<<4)
}
func (o *AXI_Type) GetPERIPH_ID_3_REV_AND() uint32 {
	return (volatile.LoadUint32(&o.PERIPH_ID_3.Reg) & 0xf0) >> 4
}

// AXI.COMP_ID_0: AXI interconnect - component ID0 register
func (o *AXI_Type) SetCOMP_ID_0_PREAMBLE(value uint32) {
	volatile.StoreUint32(&o.COMP_ID_0.Reg, volatile.LoadUint32(&o.COMP_ID_0.Reg)&^(0xff)|value)
}
func (o *AXI_Type) GetCOMP_ID_0_PREAMBLE() uint32 {
	return volatile.LoadUint32(&o.COMP_ID_0.Reg) & 0xff
}

// AXI.COMP_ID_1: AXI interconnect - component ID1 register
func (o *AXI_Type) SetCOMP_ID_1_PREAMBLE(value uint32) {
	volatile.StoreUint32(&o.COMP_ID_1.Reg, volatile.LoadUint32(&o.COMP_ID_1.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetCOMP_ID_1_PREAMBLE() uint32 {
	return volatile.LoadUint32(&o.COMP_ID_1.Reg) & 0xf
}
func (o *AXI_Type) SetCOMP_ID_1_CLASS(value uint32) {
	volatile.StoreUint32(&o.COMP_ID_1.Reg, volatile.LoadUint32(&o.COMP_ID_1.Reg)&^(0xf0)|value<<4)
}
func (o *AXI_Type) GetCOMP_ID_1_CLASS() uint32 {
	return (volatile.LoadUint32(&o.COMP_ID_1.Reg) & 0xf0) >> 4
}

// AXI.COMP_ID_2: AXI interconnect - component ID2 register
func (o *AXI_Type) SetCOMP_ID_2_PREAMBLE(value uint32) {
	volatile.StoreUint32(&o.COMP_ID_2.Reg, volatile.LoadUint32(&o.COMP_ID_2.Reg)&^(0xff)|value)
}
func (o *AXI_Type) GetCOMP_ID_2_PREAMBLE() uint32 {
	return volatile.LoadUint32(&o.COMP_ID_2.Reg) & 0xff
}

// AXI.COMP_ID_3: AXI interconnect - component ID3 register
func (o *AXI_Type) SetCOMP_ID_3_PREAMBLE(value uint32) {
	volatile.StoreUint32(&o.COMP_ID_3.Reg, volatile.LoadUint32(&o.COMP_ID_3.Reg)&^(0xff)|value)
}
func (o *AXI_Type) GetCOMP_ID_3_PREAMBLE() uint32 {
	return volatile.LoadUint32(&o.COMP_ID_3.Reg) & 0xff
}

// AXI.TARG1_FN_MOD_ISS_BM: AXI interconnect - TARG x bus matrix issuing functionality register
func (o *AXI_Type) SetTARG1_FN_MOD_ISS_BM_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG1_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG1_FN_MOD_ISS_BM.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG1_FN_MOD_ISS_BM_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TARG1_FN_MOD_ISS_BM.Reg) & 0x1
}
func (o *AXI_Type) SetTARG1_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG1_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG1_FN_MOD_ISS_BM.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetTARG1_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.TARG1_FN_MOD_ISS_BM.Reg) & 0x2) >> 1
}

// AXI.TARG1_FN_MOD2: AXI interconnect - TARG x bus matrix functionality 2 register
func (o *AXI_Type) SetTARG1_FN_MOD2_BYPASS_MERGE(value uint32) {
	volatile.StoreUint32(&o.TARG1_FN_MOD2.Reg, volatile.LoadUint32(&o.TARG1_FN_MOD2.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG1_FN_MOD2_BYPASS_MERGE() uint32 {
	return volatile.LoadUint32(&o.TARG1_FN_MOD2.Reg) & 0x1
}

// AXI.TARG1_FN_MOD_LB: AXI interconnect - TARG x long burst functionality modification
func (o *AXI_Type) SetTARG1_FN_MOD_LB_FN_MOD_LB(value uint32) {
	volatile.StoreUint32(&o.TARG1_FN_MOD_LB.Reg, volatile.LoadUint32(&o.TARG1_FN_MOD_LB.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG1_FN_MOD_LB_FN_MOD_LB() uint32 {
	return volatile.LoadUint32(&o.TARG1_FN_MOD_LB.Reg) & 0x1
}

// AXI.TARG1_FN_MOD: AXI interconnect - TARG x long burst functionality modification
func (o *AXI_Type) SetTARG1_FN_MOD_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG1_FN_MOD.Reg, volatile.LoadUint32(&o.TARG1_FN_MOD.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG1_FN_MOD_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TARG1_FN_MOD.Reg) & 0x1
}
func (o *AXI_Type) SetTARG1_FN_MOD_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG1_FN_MOD.Reg, volatile.LoadUint32(&o.TARG1_FN_MOD.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetTARG1_FN_MOD_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.TARG1_FN_MOD.Reg) & 0x2) >> 1
}

// AXI.TARG2_FN_MOD_ISS_BM: AXI interconnect - TARG x bus matrix issuing functionality register
func (o *AXI_Type) SetTARG2_FN_MOD_ISS_BM_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG2_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG2_FN_MOD_ISS_BM.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG2_FN_MOD_ISS_BM_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TARG2_FN_MOD_ISS_BM.Reg) & 0x1
}
func (o *AXI_Type) SetTARG2_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG2_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG2_FN_MOD_ISS_BM.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetTARG2_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.TARG2_FN_MOD_ISS_BM.Reg) & 0x2) >> 1
}

// AXI.TARG2_FN_MOD2: AXI interconnect - TARG x bus matrix functionality 2 register
func (o *AXI_Type) SetTARG2_FN_MOD2_BYPASS_MERGE(value uint32) {
	volatile.StoreUint32(&o.TARG2_FN_MOD2.Reg, volatile.LoadUint32(&o.TARG2_FN_MOD2.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG2_FN_MOD2_BYPASS_MERGE() uint32 {
	return volatile.LoadUint32(&o.TARG2_FN_MOD2.Reg) & 0x1
}

// AXI.TARG2_FN_MOD_LB: AXI interconnect - TARG x long burst functionality modification
func (o *AXI_Type) SetTARG2_FN_MOD_LB_FN_MOD_LB(value uint32) {
	volatile.StoreUint32(&o.TARG2_FN_MOD_LB.Reg, volatile.LoadUint32(&o.TARG2_FN_MOD_LB.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG2_FN_MOD_LB_FN_MOD_LB() uint32 {
	return volatile.LoadUint32(&o.TARG2_FN_MOD_LB.Reg) & 0x1
}

// AXI.TARG2_FN_MOD: AXI interconnect - TARG x long burst functionality modification
func (o *AXI_Type) SetTARG2_FN_MOD_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG2_FN_MOD.Reg, volatile.LoadUint32(&o.TARG2_FN_MOD.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG2_FN_MOD_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TARG2_FN_MOD.Reg) & 0x1
}
func (o *AXI_Type) SetTARG2_FN_MOD_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG2_FN_MOD.Reg, volatile.LoadUint32(&o.TARG2_FN_MOD.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetTARG2_FN_MOD_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.TARG2_FN_MOD.Reg) & 0x2) >> 1
}

// AXI.TARG3_FN_MOD_ISS_BM: AXI interconnect - TARG x bus matrix issuing functionality register
func (o *AXI_Type) SetTARG3_FN_MOD_ISS_BM_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG3_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG3_FN_MOD_ISS_BM.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG3_FN_MOD_ISS_BM_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TARG3_FN_MOD_ISS_BM.Reg) & 0x1
}
func (o *AXI_Type) SetTARG3_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG3_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG3_FN_MOD_ISS_BM.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetTARG3_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.TARG3_FN_MOD_ISS_BM.Reg) & 0x2) >> 1
}

// AXI.TARG4_FN_MOD_ISS_BM: AXI interconnect - TARG x bus matrix issuing functionality register
func (o *AXI_Type) SetTARG4_FN_MOD_ISS_BM_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG4_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG4_FN_MOD_ISS_BM.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG4_FN_MOD_ISS_BM_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TARG4_FN_MOD_ISS_BM.Reg) & 0x1
}
func (o *AXI_Type) SetTARG4_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG4_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG4_FN_MOD_ISS_BM.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetTARG4_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.TARG4_FN_MOD_ISS_BM.Reg) & 0x2) >> 1
}

// AXI.TARG5_FN_MOD_ISS_BM: AXI interconnect - TARG x bus matrix issuing functionality register
func (o *AXI_Type) SetTARG5_FN_MOD_ISS_BM_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG5_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG5_FN_MOD_ISS_BM.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG5_FN_MOD_ISS_BM_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TARG5_FN_MOD_ISS_BM.Reg) & 0x1
}
func (o *AXI_Type) SetTARG5_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG5_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG5_FN_MOD_ISS_BM.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetTARG5_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.TARG5_FN_MOD_ISS_BM.Reg) & 0x2) >> 1
}

// AXI.TARG6_FN_MOD_ISS_BM: AXI interconnect - TARG x bus matrix issuing functionality register
func (o *AXI_Type) SetTARG6_FN_MOD_ISS_BM_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG6_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG6_FN_MOD_ISS_BM.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG6_FN_MOD_ISS_BM_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TARG6_FN_MOD_ISS_BM.Reg) & 0x1
}
func (o *AXI_Type) SetTARG6_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG6_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG6_FN_MOD_ISS_BM.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetTARG6_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.TARG6_FN_MOD_ISS_BM.Reg) & 0x2) >> 1
}

// AXI.TARG7_FN_MOD_ISS_BM: AXI interconnect - TARG x bus matrix issuing functionality register
func (o *AXI_Type) SetTARG7_FN_MOD_ISS_BM_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG7_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG7_FN_MOD_ISS_BM.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG7_FN_MOD_ISS_BM_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TARG7_FN_MOD_ISS_BM.Reg) & 0x1
}
func (o *AXI_Type) SetTARG7_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG7_FN_MOD_ISS_BM.Reg, volatile.LoadUint32(&o.TARG7_FN_MOD_ISS_BM.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetTARG7_FN_MOD_ISS_BM_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.TARG7_FN_MOD_ISS_BM.Reg) & 0x2) >> 1
}

// AXI.TARG7_FN_MOD2: AXI interconnect - TARG x bus matrix functionality 2 register
func (o *AXI_Type) SetTARG7_FN_MOD2_BYPASS_MERGE(value uint32) {
	volatile.StoreUint32(&o.TARG7_FN_MOD2.Reg, volatile.LoadUint32(&o.TARG7_FN_MOD2.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG7_FN_MOD2_BYPASS_MERGE() uint32 {
	return volatile.LoadUint32(&o.TARG7_FN_MOD2.Reg) & 0x1
}

// AXI.TARG7_FN_MOD: AXI interconnect - TARG x long burst functionality modification
func (o *AXI_Type) SetTARG7_FN_MOD_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG7_FN_MOD.Reg, volatile.LoadUint32(&o.TARG7_FN_MOD.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetTARG7_FN_MOD_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TARG7_FN_MOD.Reg) & 0x1
}
func (o *AXI_Type) SetTARG7_FN_MOD_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TARG7_FN_MOD.Reg, volatile.LoadUint32(&o.TARG7_FN_MOD.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetTARG7_FN_MOD_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.TARG7_FN_MOD.Reg) & 0x2) >> 1
}

// AXI.INI1_FN_MOD2: AXI interconnect - INI x functionality modification 2 register
func (o *AXI_Type) SetINI1_FN_MOD2_BYPASS_MERGE(value uint32) {
	volatile.StoreUint32(&o.INI1_FN_MOD2.Reg, volatile.LoadUint32(&o.INI1_FN_MOD2.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetINI1_FN_MOD2_BYPASS_MERGE() uint32 {
	return volatile.LoadUint32(&o.INI1_FN_MOD2.Reg) & 0x1
}

// AXI.INI1_FN_MOD_AHB: AXI interconnect - INI x AHB functionality modification register
func (o *AXI_Type) SetINI1_FN_MOD_AHB_RD_INC_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI1_FN_MOD_AHB.Reg, volatile.LoadUint32(&o.INI1_FN_MOD_AHB.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetINI1_FN_MOD_AHB_RD_INC_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.INI1_FN_MOD_AHB.Reg) & 0x1
}
func (o *AXI_Type) SetINI1_FN_MOD_AHB_WR_INC_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI1_FN_MOD_AHB.Reg, volatile.LoadUint32(&o.INI1_FN_MOD_AHB.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetINI1_FN_MOD_AHB_WR_INC_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.INI1_FN_MOD_AHB.Reg) & 0x2) >> 1
}

// AXI.INI1_READ_QOS: AXI interconnect - INI x read QoS register
func (o *AXI_Type) SetINI1_READ_QOS_AR_QOS(value uint32) {
	volatile.StoreUint32(&o.INI1_READ_QOS.Reg, volatile.LoadUint32(&o.INI1_READ_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI1_READ_QOS_AR_QOS() uint32 {
	return volatile.LoadUint32(&o.INI1_READ_QOS.Reg) & 0xf
}

// AXI.INI1_WRITE_QOS: AXI interconnect - INI x write QoS register
func (o *AXI_Type) SetINI1_WRITE_QOS_AW_QOS(value uint32) {
	volatile.StoreUint32(&o.INI1_WRITE_QOS.Reg, volatile.LoadUint32(&o.INI1_WRITE_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI1_WRITE_QOS_AW_QOS() uint32 {
	return volatile.LoadUint32(&o.INI1_WRITE_QOS.Reg) & 0xf
}

// AXI.INI1_FN_MOD: AXI interconnect - INI x issuing functionality modification register
func (o *AXI_Type) SetINI1_FN_MOD_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI1_FN_MOD.Reg, volatile.LoadUint32(&o.INI1_FN_MOD.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetINI1_FN_MOD_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.INI1_FN_MOD.Reg) & 0x1
}
func (o *AXI_Type) SetINI1_FN_MOD_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI1_FN_MOD.Reg, volatile.LoadUint32(&o.INI1_FN_MOD.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetINI1_FN_MOD_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.INI1_FN_MOD.Reg) & 0x2) >> 1
}

// AXI.INI2_READ_QOS: AXI interconnect - INI x read QoS register
func (o *AXI_Type) SetINI2_READ_QOS_AR_QOS(value uint32) {
	volatile.StoreUint32(&o.INI2_READ_QOS.Reg, volatile.LoadUint32(&o.INI2_READ_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI2_READ_QOS_AR_QOS() uint32 {
	return volatile.LoadUint32(&o.INI2_READ_QOS.Reg) & 0xf
}

// AXI.INI2_WRITE_QOS: AXI interconnect - INI x write QoS register
func (o *AXI_Type) SetINI2_WRITE_QOS_AW_QOS(value uint32) {
	volatile.StoreUint32(&o.INI2_WRITE_QOS.Reg, volatile.LoadUint32(&o.INI2_WRITE_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI2_WRITE_QOS_AW_QOS() uint32 {
	return volatile.LoadUint32(&o.INI2_WRITE_QOS.Reg) & 0xf
}

// AXI.INI2_FN_MOD: AXI interconnect - INI x issuing functionality modification register
func (o *AXI_Type) SetINI2_FN_MOD_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI2_FN_MOD.Reg, volatile.LoadUint32(&o.INI2_FN_MOD.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetINI2_FN_MOD_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.INI2_FN_MOD.Reg) & 0x1
}
func (o *AXI_Type) SetINI2_FN_MOD_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI2_FN_MOD.Reg, volatile.LoadUint32(&o.INI2_FN_MOD.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetINI2_FN_MOD_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.INI2_FN_MOD.Reg) & 0x2) >> 1
}

// AXI.INI3_FN_MOD2: AXI interconnect - INI x functionality modification 2 register
func (o *AXI_Type) SetINI3_FN_MOD2_BYPASS_MERGE(value uint32) {
	volatile.StoreUint32(&o.INI3_FN_MOD2.Reg, volatile.LoadUint32(&o.INI3_FN_MOD2.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetINI3_FN_MOD2_BYPASS_MERGE() uint32 {
	return volatile.LoadUint32(&o.INI3_FN_MOD2.Reg) & 0x1
}

// AXI.INI3_FN_MOD_AHB: AXI interconnect - INI x AHB functionality modification register
func (o *AXI_Type) SetINI3_FN_MOD_AHB_RD_INC_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI3_FN_MOD_AHB.Reg, volatile.LoadUint32(&o.INI3_FN_MOD_AHB.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetINI3_FN_MOD_AHB_RD_INC_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.INI3_FN_MOD_AHB.Reg) & 0x1
}
func (o *AXI_Type) SetINI3_FN_MOD_AHB_WR_INC_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI3_FN_MOD_AHB.Reg, volatile.LoadUint32(&o.INI3_FN_MOD_AHB.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetINI3_FN_MOD_AHB_WR_INC_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.INI3_FN_MOD_AHB.Reg) & 0x2) >> 1
}

// AXI.INI3_READ_QOS: AXI interconnect - INI x read QoS register
func (o *AXI_Type) SetINI3_READ_QOS_AR_QOS(value uint32) {
	volatile.StoreUint32(&o.INI3_READ_QOS.Reg, volatile.LoadUint32(&o.INI3_READ_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI3_READ_QOS_AR_QOS() uint32 {
	return volatile.LoadUint32(&o.INI3_READ_QOS.Reg) & 0xf
}

// AXI.INI3_WRITE_QOS: AXI interconnect - INI x write QoS register
func (o *AXI_Type) SetINI3_WRITE_QOS_AW_QOS(value uint32) {
	volatile.StoreUint32(&o.INI3_WRITE_QOS.Reg, volatile.LoadUint32(&o.INI3_WRITE_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI3_WRITE_QOS_AW_QOS() uint32 {
	return volatile.LoadUint32(&o.INI3_WRITE_QOS.Reg) & 0xf
}

// AXI.INI3_FN_MOD: AXI interconnect - INI x issuing functionality modification register
func (o *AXI_Type) SetINI3_FN_MOD_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI3_FN_MOD.Reg, volatile.LoadUint32(&o.INI3_FN_MOD.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetINI3_FN_MOD_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.INI3_FN_MOD.Reg) & 0x1
}
func (o *AXI_Type) SetINI3_FN_MOD_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI3_FN_MOD.Reg, volatile.LoadUint32(&o.INI3_FN_MOD.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetINI3_FN_MOD_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.INI3_FN_MOD.Reg) & 0x2) >> 1
}

// AXI.INI4_READ_QOS: AXI interconnect - INI x read QoS register
func (o *AXI_Type) SetINI4_READ_QOS_AR_QOS(value uint32) {
	volatile.StoreUint32(&o.INI4_READ_QOS.Reg, volatile.LoadUint32(&o.INI4_READ_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI4_READ_QOS_AR_QOS() uint32 {
	return volatile.LoadUint32(&o.INI4_READ_QOS.Reg) & 0xf
}

// AXI.INI4_WRITE_QOS: AXI interconnect - INI x write QoS register
func (o *AXI_Type) SetINI4_WRITE_QOS_AW_QOS(value uint32) {
	volatile.StoreUint32(&o.INI4_WRITE_QOS.Reg, volatile.LoadUint32(&o.INI4_WRITE_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI4_WRITE_QOS_AW_QOS() uint32 {
	return volatile.LoadUint32(&o.INI4_WRITE_QOS.Reg) & 0xf
}

// AXI.INI4_FN_MOD: AXI interconnect - INI x issuing functionality modification register
func (o *AXI_Type) SetINI4_FN_MOD_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI4_FN_MOD.Reg, volatile.LoadUint32(&o.INI4_FN_MOD.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetINI4_FN_MOD_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.INI4_FN_MOD.Reg) & 0x1
}
func (o *AXI_Type) SetINI4_FN_MOD_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI4_FN_MOD.Reg, volatile.LoadUint32(&o.INI4_FN_MOD.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetINI4_FN_MOD_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.INI4_FN_MOD.Reg) & 0x2) >> 1
}

// AXI.INI5_READ_QOS: AXI interconnect - INI x read QoS register
func (o *AXI_Type) SetINI5_READ_QOS_AR_QOS(value uint32) {
	volatile.StoreUint32(&o.INI5_READ_QOS.Reg, volatile.LoadUint32(&o.INI5_READ_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI5_READ_QOS_AR_QOS() uint32 {
	return volatile.LoadUint32(&o.INI5_READ_QOS.Reg) & 0xf
}

// AXI.INI5_WRITE_QOS: AXI interconnect - INI x write QoS register
func (o *AXI_Type) SetINI5_WRITE_QOS_AW_QOS(value uint32) {
	volatile.StoreUint32(&o.INI5_WRITE_QOS.Reg, volatile.LoadUint32(&o.INI5_WRITE_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI5_WRITE_QOS_AW_QOS() uint32 {
	return volatile.LoadUint32(&o.INI5_WRITE_QOS.Reg) & 0xf
}

// AXI.INI5_FN_MOD: AXI interconnect - INI x issuing functionality modification register
func (o *AXI_Type) SetINI5_FN_MOD_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI5_FN_MOD.Reg, volatile.LoadUint32(&o.INI5_FN_MOD.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetINI5_FN_MOD_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.INI5_FN_MOD.Reg) & 0x1
}
func (o *AXI_Type) SetINI5_FN_MOD_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI5_FN_MOD.Reg, volatile.LoadUint32(&o.INI5_FN_MOD.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetINI5_FN_MOD_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.INI5_FN_MOD.Reg) & 0x2) >> 1
}

// AXI.INI6_READ_QOS: AXI interconnect - INI x read QoS register
func (o *AXI_Type) SetINI6_READ_QOS_AR_QOS(value uint32) {
	volatile.StoreUint32(&o.INI6_READ_QOS.Reg, volatile.LoadUint32(&o.INI6_READ_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI6_READ_QOS_AR_QOS() uint32 {
	return volatile.LoadUint32(&o.INI6_READ_QOS.Reg) & 0xf
}

// AXI.INI6_WRITE_QOS: AXI interconnect - INI x write QoS register
func (o *AXI_Type) SetINI6_WRITE_QOS_AW_QOS(value uint32) {
	volatile.StoreUint32(&o.INI6_WRITE_QOS.Reg, volatile.LoadUint32(&o.INI6_WRITE_QOS.Reg)&^(0xf)|value)
}
func (o *AXI_Type) GetINI6_WRITE_QOS_AW_QOS() uint32 {
	return volatile.LoadUint32(&o.INI6_WRITE_QOS.Reg) & 0xf
}

// AXI.INI6_FN_MOD: AXI interconnect - INI x issuing functionality modification register
func (o *AXI_Type) SetINI6_FN_MOD_READ_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI6_FN_MOD.Reg, volatile.LoadUint32(&o.INI6_FN_MOD.Reg)&^(0x1)|value)
}
func (o *AXI_Type) GetINI6_FN_MOD_READ_ISS_OVERRIDE() uint32 {
	return volatile.LoadUint32(&o.INI6_FN_MOD.Reg) & 0x1
}
func (o *AXI_Type) SetINI6_FN_MOD_WRITE_ISS_OVERRIDE(value uint32) {
	volatile.StoreUint32(&o.INI6_FN_MOD.Reg, volatile.LoadUint32(&o.INI6_FN_MOD.Reg)&^(0x2)|value<<1)
}
func (o *AXI_Type) GetINI6_FN_MOD_WRITE_ISS_OVERRIDE() uint32 {
	return (volatile.LoadUint32(&o.INI6_FN_MOD.Reg) & 0x2) >> 1
}

// CCU registers
type FDCAN_Type struct {
	CREL  volatile.Register32 // 0x0
	CCFG  volatile.Register32 // 0x4
	CSTAT volatile.Register32 // 0x8
	CWD   volatile.Register32 // 0xC
	IR    volatile.Register32 // 0x10
	IE    volatile.Register32 // 0x14
}

// FDCAN.CREL: Clock Calibration Unit Core Release Register
func (o *FDCAN_Type) SetCREL_DAY(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xff)|value)
}
func (o *FDCAN_Type) GetCREL_DAY() uint32 {
	return volatile.LoadUint32(&o.CREL.Reg) & 0xff
}
func (o *FDCAN_Type) SetCREL_MON(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xff00)|value<<8)
}
func (o *FDCAN_Type) GetCREL_MON() uint32 {
	return (volatile.LoadUint32(&o.CREL.Reg) & 0xff00) >> 8
}
func (o *FDCAN_Type) SetCREL_YEAR(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xf0000)|value<<16)
}
func (o *FDCAN_Type) GetCREL_YEAR() uint32 {
	return (volatile.LoadUint32(&o.CREL.Reg) & 0xf0000) >> 16
}
func (o *FDCAN_Type) SetCREL_SUBSTEP(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xf00000)|value<<20)
}
func (o *FDCAN_Type) GetCREL_SUBSTEP() uint32 {
	return (volatile.LoadUint32(&o.CREL.Reg) & 0xf00000) >> 20
}
func (o *FDCAN_Type) SetCREL_STEP(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xf000000)|value<<24)
}
func (o *FDCAN_Type) GetCREL_STEP() uint32 {
	return (volatile.LoadUint32(&o.CREL.Reg) & 0xf000000) >> 24
}
func (o *FDCAN_Type) SetCREL_REL(value uint32) {
	volatile.StoreUint32(&o.CREL.Reg, volatile.LoadUint32(&o.CREL.Reg)&^(0xf0000000)|value<<28)
}
func (o *FDCAN_Type) GetCREL_REL() uint32 {
	return (volatile.LoadUint32(&o.CREL.Reg) & 0xf0000000) >> 28
}

// FDCAN.CCFG: Calibration Configuration Register
func (o *FDCAN_Type) SetCCFG_TQBT(value uint32) {
	volatile.StoreUint32(&o.CCFG.Reg, volatile.LoadUint32(&o.CCFG.Reg)&^(0x1f)|value)
}
func (o *FDCAN_Type) GetCCFG_TQBT() uint32 {
	return volatile.LoadUint32(&o.CCFG.Reg) & 0x1f
}
func (o *FDCAN_Type) SetCCFG_BCC(value uint32) {
	volatile.StoreUint32(&o.CCFG.Reg, volatile.LoadUint32(&o.CCFG.Reg)&^(0x40)|value<<6)
}
func (o *FDCAN_Type) GetCCFG_BCC() uint32 {
	return (volatile.LoadUint32(&o.CCFG.Reg) & 0x40) >> 6
}
func (o *FDCAN_Type) SetCCFG_CFL(value uint32) {
	volatile.StoreUint32(&o.CCFG.Reg, volatile.LoadUint32(&o.CCFG.Reg)&^(0x80)|value<<7)
}
func (o *FDCAN_Type) GetCCFG_CFL() uint32 {
	return (volatile.LoadUint32(&o.CCFG.Reg) & 0x80) >> 7
}
func (o *FDCAN_Type) SetCCFG_OCPM(value uint32) {
	volatile.StoreUint32(&o.CCFG.Reg, volatile.LoadUint32(&o.CCFG.Reg)&^(0xff00)|value<<8)
}
func (o *FDCAN_Type) GetCCFG_OCPM() uint32 {
	return (volatile.LoadUint32(&o.CCFG.Reg) & 0xff00) >> 8
}
func (o *FDCAN_Type) SetCCFG_CDIV(value uint32) {
	volatile.StoreUint32(&o.CCFG.Reg, volatile.LoadUint32(&o.CCFG.Reg)&^(0xf0000)|value<<16)
}
func (o *FDCAN_Type) GetCCFG_CDIV() uint32 {
	return (volatile.LoadUint32(&o.CCFG.Reg) & 0xf0000) >> 16
}
func (o *FDCAN_Type) SetCCFG_SWR(value uint32) {
	volatile.StoreUint32(&o.CCFG.Reg, volatile.LoadUint32(&o.CCFG.Reg)&^(0x80000000)|value<<31)
}
func (o *FDCAN_Type) GetCCFG_SWR() uint32 {
	return (volatile.LoadUint32(&o.CCFG.Reg) & 0x80000000) >> 31
}

// FDCAN.CSTAT: Calibration Status Register
func (o *FDCAN_Type) SetCSTAT_OCPC(value uint32) {
	volatile.StoreUint32(&o.CSTAT.Reg, volatile.LoadUint32(&o.CSTAT.Reg)&^(0x3ffff)|value)
}
func (o *FDCAN_Type) GetCSTAT_OCPC() uint32 {
	return volatile.LoadUint32(&o.CSTAT.Reg) & 0x3ffff
}
func (o *FDCAN_Type) SetCSTAT_TQC(value uint32) {
	volatile.StoreUint32(&o.CSTAT.Reg, volatile.LoadUint32(&o.CSTAT.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *FDCAN_Type) GetCSTAT_TQC() uint32 {
	return (volatile.LoadUint32(&o.CSTAT.Reg) & 0x1ffc0000) >> 18
}
func (o *FDCAN_Type) SetCSTAT_CALS(value uint32) {
	volatile.StoreUint32(&o.CSTAT.Reg, volatile.LoadUint32(&o.CSTAT.Reg)&^(0xc0000000)|value<<30)
}
func (o *FDCAN_Type) GetCSTAT_CALS() uint32 {
	return (volatile.LoadUint32(&o.CSTAT.Reg) & 0xc0000000) >> 30
}

// FDCAN.CWD: Calibration Watchdog Register
func (o *FDCAN_Type) SetCWD_WDC(value uint32) {
	volatile.StoreUint32(&o.CWD.Reg, volatile.LoadUint32(&o.CWD.Reg)&^(0xffff)|value)
}
func (o *FDCAN_Type) GetCWD_WDC() uint32 {
	return volatile.LoadUint32(&o.CWD.Reg) & 0xffff
}
func (o *FDCAN_Type) SetCWD_WDV(value uint32) {
	volatile.StoreUint32(&o.CWD.Reg, volatile.LoadUint32(&o.CWD.Reg)&^(0xffff0000)|value<<16)
}
func (o *FDCAN_Type) GetCWD_WDV() uint32 {
	return (volatile.LoadUint32(&o.CWD.Reg) & 0xffff0000) >> 16
}

// FDCAN.IR: Clock Calibration Unit Interrupt Register
func (o *FDCAN_Type) SetIR_CWE(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x1)|value)
}
func (o *FDCAN_Type) GetIR_CWE() uint32 {
	return volatile.LoadUint32(&o.IR.Reg) & 0x1
}
func (o *FDCAN_Type) SetIR_CSC(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x2)|value<<1)
}
func (o *FDCAN_Type) GetIR_CSC() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x2) >> 1
}

// FDCAN.IE: Clock Calibration Unit Interrupt Enable Register
func (o *FDCAN_Type) SetIE_CWEE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x1)|value)
}
func (o *FDCAN_Type) GetIE_CWEE() uint32 {
	return volatile.LoadUint32(&o.IE.Reg) & 0x1
}
func (o *FDCAN_Type) SetIE_CSCE(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x2)|value<<1)
}
func (o *FDCAN_Type) GetIE_CSCE() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x2) >> 1
}

// CEC
type CEC_Type struct {
	CR   volatile.Register32 // 0x0
	CFGR volatile.Register32 // 0x4
	TXDR volatile.Register32 // 0x8
	RXDR volatile.Register32 // 0xC
	ISR  volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
}

// CEC.CR: CEC control register
func (o *CEC_Type) SetCR_CECEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CEC_Type) GetCR_CECEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *CEC_Type) SetCR_TXSOM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *CEC_Type) GetCR_TXSOM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *CEC_Type) SetCR_TXEOM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *CEC_Type) GetCR_TXEOM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}

// CEC.CFGR: This register is used to configure the HDMI-CEC controller. It is mandatory to write CEC_CFGR only when CECEN=0.
func (o *CEC_Type) SetCFGR_SFT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7)|value)
}
func (o *CEC_Type) GetCFGR_SFT() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x7
}
func (o *CEC_Type) SetCFGR_RXTOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x8)|value<<3)
}
func (o *CEC_Type) GetCFGR_RXTOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x8) >> 3
}
func (o *CEC_Type) SetCFGR_BRESTP(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x10)|value<<4)
}
func (o *CEC_Type) GetCFGR_BRESTP() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x10) >> 4
}
func (o *CEC_Type) SetCFGR_BREGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x20)|value<<5)
}
func (o *CEC_Type) GetCFGR_BREGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x20) >> 5
}
func (o *CEC_Type) SetCFGR_LBPEGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x40)|value<<6)
}
func (o *CEC_Type) GetCFGR_LBPEGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x40) >> 6
}
func (o *CEC_Type) SetCFGR_BRDNOGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80)|value<<7)
}
func (o *CEC_Type) GetCFGR_BRDNOGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80) >> 7
}
func (o *CEC_Type) SetCFGR_SFTOPT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x100)|value<<8)
}
func (o *CEC_Type) GetCFGR_SFTOPT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x100) >> 8
}
func (o *CEC_Type) SetCFGR_OAR(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7fff0000)|value<<16)
}
func (o *CEC_Type) GetCFGR_OAR() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7fff0000) >> 16
}
func (o *CEC_Type) SetCFGR_LSTN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000000)|value<<31)
}
func (o *CEC_Type) GetCFGR_LSTN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000000) >> 31
}

// CEC.TXDR: CEC Tx data register
func (o *CEC_Type) SetTXDR_TXD(value uint32) {
	volatile.StoreUint32(&o.TXDR.Reg, volatile.LoadUint32(&o.TXDR.Reg)&^(0xff)|value)
}
func (o *CEC_Type) GetTXDR_TXD() uint32 {
	return volatile.LoadUint32(&o.TXDR.Reg) & 0xff
}

// CEC.RXDR: CEC Rx Data Register
func (o *CEC_Type) SetRXDR_RXD(value uint32) {
	volatile.StoreUint32(&o.RXDR.Reg, volatile.LoadUint32(&o.RXDR.Reg)&^(0xff)|value)
}
func (o *CEC_Type) GetRXDR_RXD() uint32 {
	return volatile.LoadUint32(&o.RXDR.Reg) & 0xff
}

// CEC.ISR: CEC Interrupt and Status Register
func (o *CEC_Type) SetISR_RXBR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *CEC_Type) GetISR_RXBR() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *CEC_Type) SetISR_RXEND(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *CEC_Type) GetISR_RXEND() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *CEC_Type) SetISR_RXOVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *CEC_Type) GetISR_RXOVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *CEC_Type) SetISR_BRE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *CEC_Type) GetISR_BRE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *CEC_Type) SetISR_SBPE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *CEC_Type) GetISR_SBPE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *CEC_Type) SetISR_LBPE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *CEC_Type) GetISR_LBPE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *CEC_Type) SetISR_RXACKE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *CEC_Type) GetISR_RXACKE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *CEC_Type) SetISR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *CEC_Type) GetISR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *CEC_Type) SetISR_TXBR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *CEC_Type) GetISR_TXBR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *CEC_Type) SetISR_TXEND(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *CEC_Type) GetISR_TXEND() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *CEC_Type) SetISR_TXUDR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *CEC_Type) GetISR_TXUDR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *CEC_Type) SetISR_TXERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *CEC_Type) GetISR_TXERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *CEC_Type) SetISR_TXACKE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *CEC_Type) GetISR_TXACKE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}

// CEC.IER: CEC interrupt enable register
func (o *CEC_Type) SetIER_RXBRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *CEC_Type) GetIER_RXBRIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *CEC_Type) SetIER_RXENDIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *CEC_Type) GetIER_RXENDIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *CEC_Type) SetIER_RXOVRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *CEC_Type) GetIER_RXOVRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *CEC_Type) SetIER_BREIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *CEC_Type) GetIER_BREIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *CEC_Type) SetIER_SBPEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *CEC_Type) GetIER_SBPEIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *CEC_Type) SetIER_LBPEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *CEC_Type) GetIER_LBPEIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *CEC_Type) SetIER_RXACKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *CEC_Type) GetIER_RXACKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *CEC_Type) SetIER_ARBLSTIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *CEC_Type) GetIER_ARBLSTIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *CEC_Type) SetIER_TXBRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *CEC_Type) GetIER_TXBRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *CEC_Type) SetIER_TXENDIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *CEC_Type) GetIER_TXENDIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *CEC_Type) SetIER_TXUDRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *CEC_Type) GetIER_TXUDRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *CEC_Type) SetIER_TXERRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *CEC_Type) GetIER_TXERRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *CEC_Type) SetIER_TXACKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *CEC_Type) GetIER_TXACKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}

// COMP1
type COMP1_Type struct {
	SR    volatile.Register32 // 0x0
	ICFR  volatile.Register32 // 0x4
	OR    volatile.Register32 // 0x8
	CFGR1 volatile.Register32 // 0xC
	CFGR2 volatile.Register32 // 0x10
}

// COMP1.SR: Comparator status register
func (o *COMP1_Type) SetSR_C1VAL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *COMP1_Type) GetSR_C1VAL() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *COMP1_Type) SetSR_C2VAL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *COMP1_Type) GetSR_C2VAL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *COMP1_Type) SetSR_C1IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *COMP1_Type) GetSR_C1IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *COMP1_Type) SetSR_C2IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *COMP1_Type) GetSR_C2IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// COMP1.ICFR: Comparator interrupt clear flag register
func (o *COMP1_Type) SetICFR_CC1IF(value uint32) {
	volatile.StoreUint32(&o.ICFR.Reg, volatile.LoadUint32(&o.ICFR.Reg)&^(0x10000)|value<<16)
}
func (o *COMP1_Type) GetICFR_CC1IF() uint32 {
	return (volatile.LoadUint32(&o.ICFR.Reg) & 0x10000) >> 16
}
func (o *COMP1_Type) SetICFR_CC2IF(value uint32) {
	volatile.StoreUint32(&o.ICFR.Reg, volatile.LoadUint32(&o.ICFR.Reg)&^(0x20000)|value<<17)
}
func (o *COMP1_Type) GetICFR_CC2IF() uint32 {
	return (volatile.LoadUint32(&o.ICFR.Reg) & 0x20000) >> 17
}

// COMP1.OR: Comparator option register
func (o *COMP1_Type) SetOR_AFOP(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x7ff)|value)
}
func (o *COMP1_Type) GetOR_AFOP() uint32 {
	return volatile.LoadUint32(&o.OR.Reg) & 0x7ff
}
func (o *COMP1_Type) SetOR(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0xfffff800)|value<<11)
}
func (o *COMP1_Type) GetOR() uint32 {
	return (volatile.LoadUint32(&o.OR.Reg) & 0xfffff800) >> 11
}

// COMP1.CFGR1: Comparator configuration register 1
func (o *COMP1_Type) SetCFGR1_EN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x1)|value)
}
func (o *COMP1_Type) GetCFGR1_EN() uint32 {
	return volatile.LoadUint32(&o.CFGR1.Reg) & 0x1
}
func (o *COMP1_Type) SetCFGR1_BRGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x2)|value<<1)
}
func (o *COMP1_Type) GetCFGR1_BRGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x2) >> 1
}
func (o *COMP1_Type) SetCFGR1_SCALEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x4)|value<<2)
}
func (o *COMP1_Type) GetCFGR1_SCALEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x4) >> 2
}
func (o *COMP1_Type) SetCFGR1_POLARITY(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x8)|value<<3)
}
func (o *COMP1_Type) GetCFGR1_POLARITY() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x8) >> 3
}
func (o *COMP1_Type) SetCFGR1_ITEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x40)|value<<6)
}
func (o *COMP1_Type) GetCFGR1_ITEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x40) >> 6
}
func (o *COMP1_Type) SetCFGR1_HYST(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x300)|value<<8)
}
func (o *COMP1_Type) GetCFGR1_HYST() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x300) >> 8
}
func (o *COMP1_Type) SetCFGR1_PWRMODE(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x3000)|value<<12)
}
func (o *COMP1_Type) GetCFGR1_PWRMODE() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x3000) >> 12
}
func (o *COMP1_Type) SetCFGR1_INMSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x70000)|value<<16)
}
func (o *COMP1_Type) GetCFGR1_INMSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x70000) >> 16
}
func (o *COMP1_Type) SetCFGR1_INPSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x100000)|value<<20)
}
func (o *COMP1_Type) GetCFGR1_INPSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x100000) >> 20
}
func (o *COMP1_Type) SetCFGR1_BLANKING(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0xf000000)|value<<24)
}
func (o *COMP1_Type) GetCFGR1_BLANKING() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0xf000000) >> 24
}
func (o *COMP1_Type) SetCFGR1_LOCK(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP1_Type) GetCFGR1_LOCK() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x80000000) >> 31
}

// COMP1.CFGR2: Comparator configuration register 2
func (o *COMP1_Type) SetCFGR2_EN(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1)|value)
}
func (o *COMP1_Type) GetCFGR2_EN() uint32 {
	return volatile.LoadUint32(&o.CFGR2.Reg) & 0x1
}
func (o *COMP1_Type) SetCFGR2_BRGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x2)|value<<1)
}
func (o *COMP1_Type) GetCFGR2_BRGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x2) >> 1
}
func (o *COMP1_Type) SetCFGR2_SCALEN(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x4)|value<<2)
}
func (o *COMP1_Type) GetCFGR2_SCALEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x4) >> 2
}
func (o *COMP1_Type) SetCFGR2_POLARITY(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x8)|value<<3)
}
func (o *COMP1_Type) GetCFGR2_POLARITY() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x8) >> 3
}
func (o *COMP1_Type) SetCFGR2_WINMODE(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x10)|value<<4)
}
func (o *COMP1_Type) GetCFGR2_WINMODE() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x10) >> 4
}
func (o *COMP1_Type) SetCFGR2_ITEN(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x40)|value<<6)
}
func (o *COMP1_Type) GetCFGR2_ITEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x40) >> 6
}
func (o *COMP1_Type) SetCFGR2_HYST(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x300)|value<<8)
}
func (o *COMP1_Type) GetCFGR2_HYST() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x300) >> 8
}
func (o *COMP1_Type) SetCFGR2_PWRMODE(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x3000)|value<<12)
}
func (o *COMP1_Type) GetCFGR2_PWRMODE() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x3000) >> 12
}
func (o *COMP1_Type) SetCFGR2_INMSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x70000)|value<<16)
}
func (o *COMP1_Type) GetCFGR2_INMSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x70000) >> 16
}
func (o *COMP1_Type) SetCFGR2_INPSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x100000)|value<<20)
}
func (o *COMP1_Type) GetCFGR2_INPSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x100000) >> 20
}
func (o *COMP1_Type) SetCFGR2_BLANKING(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0xf000000)|value<<24)
}
func (o *COMP1_Type) GetCFGR2_BLANKING() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0xf000000) >> 24
}
func (o *COMP1_Type) SetCFGR2_LOCK(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP1_Type) GetCFGR2_LOCK() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x80000000) >> 31
}

// Cryptographic processor
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	_    [4]byte
	INIT volatile.Register32 // 0x10
	POL  volatile.Register32 // 0x14
}

// CRC.DR: Data register
func (o *CRC_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *CRC_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// CRC.IDR: Independent Data register
func (o *CRC_Type) SetIDR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, value)
}
func (o *CRC_Type) GetIDR() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg)
}

// CRC.CR: Control register
func (o *CRC_Type) SetCR_RESET(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CRC_Type) GetCR_RESET() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *CRC_Type) SetCR_POLYSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x18)|value<<3)
}
func (o *CRC_Type) GetCR_POLYSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x18) >> 3
}
func (o *CRC_Type) SetCR_REV_IN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *CRC_Type) GetCR_REV_IN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *CRC_Type) SetCR_REV_OUT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *CRC_Type) GetCR_REV_OUT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// CRC.INIT: Initial CRC value
func (o *CRC_Type) SetINIT(value uint32) {
	volatile.StoreUint32(&o.INIT.Reg, value)
}
func (o *CRC_Type) GetINIT() uint32 {
	return volatile.LoadUint32(&o.INIT.Reg)
}

// CRC.POL: CRC polynomial
func (o *CRC_Type) SetPOL(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, value)
}
func (o *CRC_Type) GetPOL() uint32 {
	return volatile.LoadUint32(&o.POL.Reg)
}

// Clock Recovery System
type CRS_Type struct {
	CR   volatile.Register32 // 0x0
	CFGR volatile.Register32 // 0x4
	ISR  volatile.Register32 // 0x8
	ICR  volatile.Register32 // 0xC
}

// CRS.CR: CRS control register
func (o *CRS_Type) SetCR_SYNCOKIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CRS_Type) GetCR_SYNCOKIE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *CRS_Type) SetCR_SYNCWARNIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *CRS_Type) GetCR_SYNCWARNIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *CRS_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *CRS_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *CRS_Type) SetCR_ESYNCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *CRS_Type) GetCR_ESYNCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *CRS_Type) SetCR_CEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *CRS_Type) GetCR_CEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *CRS_Type) SetCR_AUTOTRIMEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *CRS_Type) GetCR_AUTOTRIMEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *CRS_Type) SetCR_SWSYNC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *CRS_Type) GetCR_SWSYNC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *CRS_Type) SetCR_TRIM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3f00)|value<<8)
}
func (o *CRS_Type) GetCR_TRIM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x3f00) >> 8
}

// CRS.CFGR: This register can be written only when the frequency error counter is disabled (CEN bit is cleared in CRS_CR). When the counter is enabled, this register is write-protected.
func (o *CRS_Type) SetCFGR_RELOAD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xffff)|value)
}
func (o *CRS_Type) GetCFGR_RELOAD() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0xffff
}
func (o *CRS_Type) SetCFGR_FELIM(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xff0000)|value<<16)
}
func (o *CRS_Type) GetCFGR_FELIM() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xff0000) >> 16
}
func (o *CRS_Type) SetCFGR_SYNCDIV(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7000000)|value<<24)
}
func (o *CRS_Type) GetCFGR_SYNCDIV() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7000000) >> 24
}
func (o *CRS_Type) SetCFGR_SYNCSRC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x30000000)|value<<28)
}
func (o *CRS_Type) GetCFGR_SYNCSRC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x30000000) >> 28
}
func (o *CRS_Type) SetCFGR_SYNCPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000000)|value<<31)
}
func (o *CRS_Type) GetCFGR_SYNCPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000000) >> 31
}

// CRS.ISR: CRS interrupt and status register
func (o *CRS_Type) SetISR_SYNCOKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *CRS_Type) GetISR_SYNCOKF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *CRS_Type) SetISR_SYNCWARNF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *CRS_Type) GetISR_SYNCWARNF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *CRS_Type) SetISR_ERRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *CRS_Type) GetISR_ERRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *CRS_Type) SetISR_ESYNCF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *CRS_Type) GetISR_ESYNCF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *CRS_Type) SetISR_SYNCERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *CRS_Type) GetISR_SYNCERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *CRS_Type) SetISR_SYNCMISS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *CRS_Type) GetISR_SYNCMISS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *CRS_Type) SetISR_TRIMOVF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *CRS_Type) GetISR_TRIMOVF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *CRS_Type) SetISR_FEDIR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *CRS_Type) GetISR_FEDIR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *CRS_Type) SetISR_FECAP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CRS_Type) GetISR_FECAP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xffff0000) >> 16
}

// CRS.ICR: CRS interrupt flag clear register
func (o *CRS_Type) SetICR_SYNCOKC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *CRS_Type) GetICR_SYNCOKC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}
func (o *CRS_Type) SetICR_SYNCWARNC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *CRS_Type) GetICR_SYNCWARNC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *CRS_Type) SetICR_ERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *CRS_Type) GetICR_ERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *CRS_Type) SetICR_ESYNCC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *CRS_Type) GetICR_ESYNCC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}

// Cryptographic processor
type CRYP_Type struct {
	CR         volatile.Register32 // 0x0
	SR         volatile.Register32 // 0x4
	DIN        volatile.Register32 // 0x8
	DOUT       volatile.Register32 // 0xC
	DMACR      volatile.Register32 // 0x10
	IMSCR      volatile.Register32 // 0x14
	RISR       volatile.Register32 // 0x18
	MISR       volatile.Register32 // 0x1C
	K0LR       volatile.Register32 // 0x20
	K0RR       volatile.Register32 // 0x24
	K1LR       volatile.Register32 // 0x28
	K1RR       volatile.Register32 // 0x2C
	K2LR       volatile.Register32 // 0x30
	K2RR       volatile.Register32 // 0x34
	K3LR       volatile.Register32 // 0x38
	K3RR       volatile.Register32 // 0x3C
	IV0LR      volatile.Register32 // 0x40
	IV0RR      volatile.Register32 // 0x44
	IV1LR      volatile.Register32 // 0x48
	IV1RR      volatile.Register32 // 0x4C
	CSGCMCCM0R volatile.Register32 // 0x50
	CSGCMCCM1R volatile.Register32 // 0x54
	CSGCMCCM2R volatile.Register32 // 0x58
	CSGCMCCM3R volatile.Register32 // 0x5C
	CSGCMCCM4R volatile.Register32 // 0x60
	CSGCMCCM5R volatile.Register32 // 0x64
	CSGCMCCM6R volatile.Register32 // 0x68
	CSGCMCCM7R volatile.Register32 // 0x6C
	CSGCM0R    volatile.Register32 // 0x70
	CSGCM1R    volatile.Register32 // 0x74
	CSGCM2R    volatile.Register32 // 0x78
	CSGCM3R    volatile.Register32 // 0x7C
	CSGCM4R    volatile.Register32 // 0x80
	CSGCM5R    volatile.Register32 // 0x84
	CSGCM6R    volatile.Register32 // 0x88
	CSGCM7R    volatile.Register32 // 0x8C
}

// CRYP.CR: control register
func (o *CRYP_Type) SetCR_ALGODIR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *CRYP_Type) GetCR_ALGODIR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *CRYP_Type) SetCR_ALGOMODE0(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x38)|value<<3)
}
func (o *CRYP_Type) GetCR_ALGOMODE0() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x38) >> 3
}
func (o *CRYP_Type) SetCR_DATATYPE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *CRYP_Type) GetCR_DATATYPE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}
func (o *CRYP_Type) SetCR_KEYSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *CRYP_Type) GetCR_KEYSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *CRYP_Type) SetCR_FFLUSH(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *CRYP_Type) GetCR_FFLUSH() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *CRYP_Type) SetCR_CRYPEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *CRYP_Type) GetCR_CRYPEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *CRYP_Type) SetCR_GCM_CCMPH(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30000)|value<<16)
}
func (o *CRYP_Type) GetCR_GCM_CCMPH() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30000) >> 16
}
func (o *CRYP_Type) SetCR_ALGOMODE3(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *CRYP_Type) GetCR_ALGOMODE3() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}

// CRYP.SR: status register
func (o *CRYP_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *CRYP_Type) GetSR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *CRYP_Type) SetSR_OFFU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *CRYP_Type) GetSR_OFFU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *CRYP_Type) SetSR_OFNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *CRYP_Type) GetSR_OFNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *CRYP_Type) SetSR_IFNF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *CRYP_Type) GetSR_IFNF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *CRYP_Type) SetSR_IFEM(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *CRYP_Type) GetSR_IFEM() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// CRYP.DIN: data input register
func (o *CRYP_Type) SetDIN(value uint32) {
	volatile.StoreUint32(&o.DIN.Reg, value)
}
func (o *CRYP_Type) GetDIN() uint32 {
	return volatile.LoadUint32(&o.DIN.Reg)
}

// CRYP.DOUT: data output register
func (o *CRYP_Type) SetDOUT(value uint32) {
	volatile.StoreUint32(&o.DOUT.Reg, value)
}
func (o *CRYP_Type) GetDOUT() uint32 {
	return volatile.LoadUint32(&o.DOUT.Reg)
}

// CRYP.DMACR: DMA control register
func (o *CRYP_Type) SetDMACR_DOEN(value uint32) {
	volatile.StoreUint32(&o.DMACR.Reg, volatile.LoadUint32(&o.DMACR.Reg)&^(0x2)|value<<1)
}
func (o *CRYP_Type) GetDMACR_DOEN() uint32 {
	return (volatile.LoadUint32(&o.DMACR.Reg) & 0x2) >> 1
}
func (o *CRYP_Type) SetDMACR_DIEN(value uint32) {
	volatile.StoreUint32(&o.DMACR.Reg, volatile.LoadUint32(&o.DMACR.Reg)&^(0x1)|value)
}
func (o *CRYP_Type) GetDMACR_DIEN() uint32 {
	return volatile.LoadUint32(&o.DMACR.Reg) & 0x1
}

// CRYP.IMSCR: interrupt mask set/clear register
func (o *CRYP_Type) SetIMSCR_OUTIM(value uint32) {
	volatile.StoreUint32(&o.IMSCR.Reg, volatile.LoadUint32(&o.IMSCR.Reg)&^(0x2)|value<<1)
}
func (o *CRYP_Type) GetIMSCR_OUTIM() uint32 {
	return (volatile.LoadUint32(&o.IMSCR.Reg) & 0x2) >> 1
}
func (o *CRYP_Type) SetIMSCR_INIM(value uint32) {
	volatile.StoreUint32(&o.IMSCR.Reg, volatile.LoadUint32(&o.IMSCR.Reg)&^(0x1)|value)
}
func (o *CRYP_Type) GetIMSCR_INIM() uint32 {
	return volatile.LoadUint32(&o.IMSCR.Reg) & 0x1
}

// CRYP.RISR: raw interrupt status register
func (o *CRYP_Type) SetRISR_OUTRIS(value uint32) {
	volatile.StoreUint32(&o.RISR.Reg, volatile.LoadUint32(&o.RISR.Reg)&^(0x2)|value<<1)
}
func (o *CRYP_Type) GetRISR_OUTRIS() uint32 {
	return (volatile.LoadUint32(&o.RISR.Reg) & 0x2) >> 1
}
func (o *CRYP_Type) SetRISR_INRIS(value uint32) {
	volatile.StoreUint32(&o.RISR.Reg, volatile.LoadUint32(&o.RISR.Reg)&^(0x1)|value)
}
func (o *CRYP_Type) GetRISR_INRIS() uint32 {
	return volatile.LoadUint32(&o.RISR.Reg) & 0x1
}

// CRYP.MISR: masked interrupt status register
func (o *CRYP_Type) SetMISR_OUTMIS(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x2)|value<<1)
}
func (o *CRYP_Type) GetMISR_OUTMIS() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x2) >> 1
}
func (o *CRYP_Type) SetMISR_INMIS(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x1)|value)
}
func (o *CRYP_Type) GetMISR_INMIS() uint32 {
	return volatile.LoadUint32(&o.MISR.Reg) & 0x1
}

// CRYP.K0LR: key registers
func (o *CRYP_Type) SetK0LR(value uint32) {
	volatile.StoreUint32(&o.K0LR.Reg, value)
}
func (o *CRYP_Type) GetK0LR() uint32 {
	return volatile.LoadUint32(&o.K0LR.Reg)
}

// CRYP.K0RR: key registers
func (o *CRYP_Type) SetK0RR(value uint32) {
	volatile.StoreUint32(&o.K0RR.Reg, value)
}
func (o *CRYP_Type) GetK0RR() uint32 {
	return volatile.LoadUint32(&o.K0RR.Reg)
}

// CRYP.K1LR: key registers
func (o *CRYP_Type) SetK1LR(value uint32) {
	volatile.StoreUint32(&o.K1LR.Reg, value)
}
func (o *CRYP_Type) GetK1LR() uint32 {
	return volatile.LoadUint32(&o.K1LR.Reg)
}

// CRYP.K1RR: key registers
func (o *CRYP_Type) SetK1RR(value uint32) {
	volatile.StoreUint32(&o.K1RR.Reg, value)
}
func (o *CRYP_Type) GetK1RR() uint32 {
	return volatile.LoadUint32(&o.K1RR.Reg)
}

// CRYP.K2LR: key registers
func (o *CRYP_Type) SetK2LR_B121(value uint32) {
	volatile.StoreUint32(&o.K2LR.Reg, volatile.LoadUint32(&o.K2LR.Reg)&^(0x2000000)|value<<25)
}
func (o *CRYP_Type) GetK2LR_B121() uint32 {
	return (volatile.LoadUint32(&o.K2LR.Reg) & 0x2000000) >> 25
}
func (o *CRYP_Type) SetK2LR_K(value uint32) {
	volatile.StoreUint32(&o.K2LR.Reg, volatile.LoadUint32(&o.K2LR.Reg)&^(0x7fffffff)|value)
}
func (o *CRYP_Type) GetK2LR_K() uint32 {
	return volatile.LoadUint32(&o.K2LR.Reg) & 0x7fffffff
}

// CRYP.K2RR: key registers
func (o *CRYP_Type) SetK2RR(value uint32) {
	volatile.StoreUint32(&o.K2RR.Reg, value)
}
func (o *CRYP_Type) GetK2RR() uint32 {
	return volatile.LoadUint32(&o.K2RR.Reg)
}

// CRYP.K3LR: key registers
func (o *CRYP_Type) SetK3LR(value uint32) {
	volatile.StoreUint32(&o.K3LR.Reg, value)
}
func (o *CRYP_Type) GetK3LR() uint32 {
	return volatile.LoadUint32(&o.K3LR.Reg)
}

// CRYP.K3RR: key registers
func (o *CRYP_Type) SetK3RR(value uint32) {
	volatile.StoreUint32(&o.K3RR.Reg, value)
}
func (o *CRYP_Type) GetK3RR() uint32 {
	return volatile.LoadUint32(&o.K3RR.Reg)
}

// CRYP.IV0LR: Initialization vector register 0L
func (o *CRYP_Type) SetIV0LR(value uint32) {
	volatile.StoreUint32(&o.IV0LR.Reg, value)
}
func (o *CRYP_Type) GetIV0LR() uint32 {
	return volatile.LoadUint32(&o.IV0LR.Reg)
}

// CRYP.IV0RR: initialization vector register 0R
func (o *CRYP_Type) SetIV0RR(value uint32) {
	volatile.StoreUint32(&o.IV0RR.Reg, value)
}
func (o *CRYP_Type) GetIV0RR() uint32 {
	return volatile.LoadUint32(&o.IV0RR.Reg)
}

// CRYP.IV1LR: Initialization vector register 1L
func (o *CRYP_Type) SetIV1LR(value uint32) {
	volatile.StoreUint32(&o.IV1LR.Reg, value)
}
func (o *CRYP_Type) GetIV1LR() uint32 {
	return volatile.LoadUint32(&o.IV1LR.Reg)
}

// CRYP.IV1RR: Initialization vector register 1R
func (o *CRYP_Type) SetIV1RR(value uint32) {
	volatile.StoreUint32(&o.IV1RR.Reg, value)
}
func (o *CRYP_Type) GetIV1RR() uint32 {
	return volatile.LoadUint32(&o.IV1RR.Reg)
}

// CRYP.CSGCMCCM0R: context swap register
func (o *CRYP_Type) SetCSGCMCCM0R(value uint32) {
	volatile.StoreUint32(&o.CSGCMCCM0R.Reg, value)
}
func (o *CRYP_Type) GetCSGCMCCM0R() uint32 {
	return volatile.LoadUint32(&o.CSGCMCCM0R.Reg)
}

// CRYP.CSGCMCCM1R: context swap register
func (o *CRYP_Type) SetCSGCMCCM1R(value uint32) {
	volatile.StoreUint32(&o.CSGCMCCM1R.Reg, value)
}
func (o *CRYP_Type) GetCSGCMCCM1R() uint32 {
	return volatile.LoadUint32(&o.CSGCMCCM1R.Reg)
}

// CRYP.CSGCMCCM2R: context swap register
func (o *CRYP_Type) SetCSGCMCCM2R(value uint32) {
	volatile.StoreUint32(&o.CSGCMCCM2R.Reg, value)
}
func (o *CRYP_Type) GetCSGCMCCM2R() uint32 {
	return volatile.LoadUint32(&o.CSGCMCCM2R.Reg)
}

// CRYP.CSGCMCCM3R: context swap register
func (o *CRYP_Type) SetCSGCMCCM3R(value uint32) {
	volatile.StoreUint32(&o.CSGCMCCM3R.Reg, value)
}
func (o *CRYP_Type) GetCSGCMCCM3R() uint32 {
	return volatile.LoadUint32(&o.CSGCMCCM3R.Reg)
}

// CRYP.CSGCMCCM4R: context swap register
func (o *CRYP_Type) SetCSGCMCCM4R(value uint32) {
	volatile.StoreUint32(&o.CSGCMCCM4R.Reg, value)
}
func (o *CRYP_Type) GetCSGCMCCM4R() uint32 {
	return volatile.LoadUint32(&o.CSGCMCCM4R.Reg)
}

// CRYP.CSGCMCCM5R: context swap register
func (o *CRYP_Type) SetCSGCMCCM5R(value uint32) {
	volatile.StoreUint32(&o.CSGCMCCM5R.Reg, value)
}
func (o *CRYP_Type) GetCSGCMCCM5R() uint32 {
	return volatile.LoadUint32(&o.CSGCMCCM5R.Reg)
}

// CRYP.CSGCMCCM6R: context swap register
func (o *CRYP_Type) SetCSGCMCCM6R(value uint32) {
	volatile.StoreUint32(&o.CSGCMCCM6R.Reg, value)
}
func (o *CRYP_Type) GetCSGCMCCM6R() uint32 {
	return volatile.LoadUint32(&o.CSGCMCCM6R.Reg)
}

// CRYP.CSGCMCCM7R: context swap register
func (o *CRYP_Type) SetCSGCMCCM7R(value uint32) {
	volatile.StoreUint32(&o.CSGCMCCM7R.Reg, value)
}
func (o *CRYP_Type) GetCSGCMCCM7R() uint32 {
	return volatile.LoadUint32(&o.CSGCMCCM7R.Reg)
}

// CRYP.CSGCM0R: context swap register
func (o *CRYP_Type) SetCSGCM0R(value uint32) {
	volatile.StoreUint32(&o.CSGCM0R.Reg, value)
}
func (o *CRYP_Type) GetCSGCM0R() uint32 {
	return volatile.LoadUint32(&o.CSGCM0R.Reg)
}

// CRYP.CSGCM1R: context swap register
func (o *CRYP_Type) SetCSGCM1R(value uint32) {
	volatile.StoreUint32(&o.CSGCM1R.Reg, value)
}
func (o *CRYP_Type) GetCSGCM1R() uint32 {
	return volatile.LoadUint32(&o.CSGCM1R.Reg)
}

// CRYP.CSGCM2R: context swap register
func (o *CRYP_Type) SetCSGCM2R(value uint32) {
	volatile.StoreUint32(&o.CSGCM2R.Reg, value)
}
func (o *CRYP_Type) GetCSGCM2R() uint32 {
	return volatile.LoadUint32(&o.CSGCM2R.Reg)
}

// CRYP.CSGCM3R: context swap register
func (o *CRYP_Type) SetCSGCM3R(value uint32) {
	volatile.StoreUint32(&o.CSGCM3R.Reg, value)
}
func (o *CRYP_Type) GetCSGCM3R() uint32 {
	return volatile.LoadUint32(&o.CSGCM3R.Reg)
}

// CRYP.CSGCM4R: context swap register
func (o *CRYP_Type) SetCSGCM4R(value uint32) {
	volatile.StoreUint32(&o.CSGCM4R.Reg, value)
}
func (o *CRYP_Type) GetCSGCM4R() uint32 {
	return volatile.LoadUint32(&o.CSGCM4R.Reg)
}

// CRYP.CSGCM5R: context swap register
func (o *CRYP_Type) SetCSGCM5R(value uint32) {
	volatile.StoreUint32(&o.CSGCM5R.Reg, value)
}
func (o *CRYP_Type) GetCSGCM5R() uint32 {
	return volatile.LoadUint32(&o.CSGCM5R.Reg)
}

// CRYP.CSGCM6R: context swap register
func (o *CRYP_Type) SetCSGCM6R(value uint32) {
	volatile.StoreUint32(&o.CSGCM6R.Reg, value)
}
func (o *CRYP_Type) GetCSGCM6R() uint32 {
	return volatile.LoadUint32(&o.CSGCM6R.Reg)
}

// CRYP.CSGCM7R: context swap register
func (o *CRYP_Type) SetCSGCM7R(value uint32) {
	volatile.StoreUint32(&o.CSGCM7R.Reg, value)
}
func (o *CRYP_Type) GetCSGCM7R() uint32 {
	return volatile.LoadUint32(&o.CSGCM7R.Reg)
}

// DAC
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRGR  volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
	CCR     volatile.Register32 // 0x38
	MCR     volatile.Register32 // 0x3C
	SHSR1   volatile.Register32 // 0x40
	SHSR2   volatile.Register32 // 0x44
	SHHR    volatile.Register32 // 0x48
	SHRR    volatile.Register32 // 0x4C
}

// DAC.CR: DAC control register
func (o *DAC_Type) SetCR_EN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetCR_EN1() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DAC_Type) SetCR_TEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetCR_TEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetCR_TSEL1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1c)|value<<2)
}
func (o *DAC_Type) GetCR_TSEL1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1c) >> 2
}
func (o *DAC_Type) SetCR_WAVE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DAC_Type) GetCR_WAVE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}
func (o *DAC_Type) SetCR_MAMP1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00)|value<<8)
}
func (o *DAC_Type) GetCR_MAMP1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00) >> 8
}
func (o *DAC_Type) SetCR_DMAEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *DAC_Type) GetCR_DMAEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *DAC_Type) SetCR_DMAUDRIE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetCR_DMAUDRIE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *DAC_Type) SetCR_CEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *DAC_Type) GetCR_CEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *DAC_Type) SetCR_EN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *DAC_Type) GetCR_EN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *DAC_Type) SetCR_TEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *DAC_Type) GetCR_TEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *DAC_Type) SetCR_TSEL2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1c0000)|value<<18)
}
func (o *DAC_Type) GetCR_TSEL2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1c0000) >> 18
}
func (o *DAC_Type) SetCR_WAVE2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00000)|value<<22)
}
func (o *DAC_Type) GetCR_WAVE2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00000) >> 22
}
func (o *DAC_Type) SetCR_MAMP2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf000000)|value<<24)
}
func (o *DAC_Type) GetCR_MAMP2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf000000) >> 24
}
func (o *DAC_Type) SetCR_DMAEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *DAC_Type) GetCR_DMAEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *DAC_Type) SetCR_DMAUDRIE2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetCR_DMAUDRIE2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetCR_CEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000000)|value<<30)
}
func (o *DAC_Type) GetCR_CEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000000) >> 30
}

// DAC.SWTRGR: DAC software trigger register
func (o *DAC_Type) SetSWTRGR_SWTRIG1(value uint32) {
	volatile.StoreUint32(&o.SWTRGR.Reg, volatile.LoadUint32(&o.SWTRGR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetSWTRGR_SWTRIG1() uint32 {
	return volatile.LoadUint32(&o.SWTRGR.Reg) & 0x1
}
func (o *DAC_Type) SetSWTRGR_SWTRIG2(value uint32) {
	volatile.StoreUint32(&o.SWTRGR.Reg, volatile.LoadUint32(&o.SWTRGR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetSWTRGR_SWTRIG2() uint32 {
	return (volatile.LoadUint32(&o.SWTRGR.Reg) & 0x2) >> 1
}

// DAC.DHR12R1: DAC channel1 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R1.Reg, volatile.LoadUint32(&o.DHR12R1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R1.Reg) & 0xfff
}

// DAC.DHR12L1: DAC channel1 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12L1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L1.Reg, volatile.LoadUint32(&o.DHR12L1.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12L1_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L1.Reg) & 0xfff0) >> 4
}

// DAC.DHR8R1: DAC channel1 8-bit right aligned data holding register
func (o *DAC_Type) SetDHR8R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R1.Reg, volatile.LoadUint32(&o.DHR8R1.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R1.Reg) & 0xff
}

// DAC.DHR12R2: DAC channel2 12-bit right aligned data holding register
func (o *DAC_Type) SetDHR12R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R2.Reg, volatile.LoadUint32(&o.DHR12R2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R2.Reg) & 0xfff
}

// DAC.DHR12L2: DAC channel2 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12L2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L2.Reg, volatile.LoadUint32(&o.DHR12L2.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12L2_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L2.Reg) & 0xfff0) >> 4
}

// DAC.DHR8R2: DAC channel2 8-bit right-aligned data holding register
func (o *DAC_Type) SetDHR8R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R2.Reg, volatile.LoadUint32(&o.DHR8R2.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R2.Reg) & 0xff
}

// DAC.DHR12RD: Dual DAC 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12RD.Reg, volatile.LoadUint32(&o.DHR12RD.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12RD.Reg) & 0xfff
}
func (o *DAC_Type) SetDHR12RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12RD.Reg, volatile.LoadUint32(&o.DHR12RD.Reg)&^(0xfff0000)|value<<16)
}
func (o *DAC_Type) GetDHR12RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12RD.Reg) & 0xfff0000) >> 16
}

// DAC.DHR12LD: DUAL DAC 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12LD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12LD.Reg, volatile.LoadUint32(&o.DHR12LD.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12LD_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12LD.Reg) & 0xfff0) >> 4
}
func (o *DAC_Type) SetDHR12LD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12LD.Reg, volatile.LoadUint32(&o.DHR12LD.Reg)&^(0xfff00000)|value<<20)
}
func (o *DAC_Type) GetDHR12LD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12LD.Reg) & 0xfff00000) >> 20
}

// DAC.DHR8RD: DUAL DAC 8-bit right aligned data holding register
func (o *DAC_Type) SetDHR8RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8RD.Reg, volatile.LoadUint32(&o.DHR8RD.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8RD.Reg) & 0xff
}
func (o *DAC_Type) SetDHR8RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8RD.Reg, volatile.LoadUint32(&o.DHR8RD.Reg)&^(0xff00)|value<<8)
}
func (o *DAC_Type) GetDHR8RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR8RD.Reg) & 0xff00) >> 8
}

// DAC.DOR1: DAC channel1 data output register
func (o *DAC_Type) SetDOR1_DACC1DOR(value uint32) {
	volatile.StoreUint32(&o.DOR1.Reg, volatile.LoadUint32(&o.DOR1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDOR1_DACC1DOR() uint32 {
	return volatile.LoadUint32(&o.DOR1.Reg) & 0xfff
}

// DAC.DOR2: DAC channel2 data output register
func (o *DAC_Type) SetDOR2_DACC2DOR(value uint32) {
	volatile.StoreUint32(&o.DOR2.Reg, volatile.LoadUint32(&o.DOR2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDOR2_DACC2DOR() uint32 {
	return volatile.LoadUint32(&o.DOR2.Reg) & 0xfff
}

// DAC.SR: DAC status register
func (o *DAC_Type) SetSR_DMAUDR1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetSR_DMAUDR1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *DAC_Type) SetSR_CAL_FLAG1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *DAC_Type) GetSR_CAL_FLAG1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *DAC_Type) SetSR_BWST1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *DAC_Type) GetSR_BWST1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}
func (o *DAC_Type) SetSR_DMAUDR2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetSR_DMAUDR2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetSR_CAL_FLAG2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000000)|value<<30)
}
func (o *DAC_Type) GetSR_CAL_FLAG2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000000) >> 30
}
func (o *DAC_Type) SetSR_BWST2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000000)|value<<31)
}
func (o *DAC_Type) GetSR_BWST2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000000) >> 31
}

// DAC.CCR: DAC calibration control register
func (o *DAC_Type) SetCCR_OTRIM1(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1f)|value)
}
func (o *DAC_Type) GetCCR_OTRIM1() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1f
}
func (o *DAC_Type) SetCCR_OTRIM2(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1f0000)|value<<16)
}
func (o *DAC_Type) GetCCR_OTRIM2() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x1f0000) >> 16
}

// DAC.MCR: DAC mode control register
func (o *DAC_Type) SetMCR_MODE1(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x7)|value)
}
func (o *DAC_Type) GetMCR_MODE1() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x7
}
func (o *DAC_Type) SetMCR_MODE2(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x70000)|value<<16)
}
func (o *DAC_Type) GetMCR_MODE2() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x70000) >> 16
}

// DAC.SHSR1: DAC Sample and Hold sample time register 1
func (o *DAC_Type) SetSHSR1_TSAMPLE1(value uint32) {
	volatile.StoreUint32(&o.SHSR1.Reg, volatile.LoadUint32(&o.SHSR1.Reg)&^(0x3ff)|value)
}
func (o *DAC_Type) GetSHSR1_TSAMPLE1() uint32 {
	return volatile.LoadUint32(&o.SHSR1.Reg) & 0x3ff
}

// DAC.SHSR2: DAC Sample and Hold sample time register 2
func (o *DAC_Type) SetSHSR2_TSAMPLE2(value uint32) {
	volatile.StoreUint32(&o.SHSR2.Reg, volatile.LoadUint32(&o.SHSR2.Reg)&^(0x3ff)|value)
}
func (o *DAC_Type) GetSHSR2_TSAMPLE2() uint32 {
	return volatile.LoadUint32(&o.SHSR2.Reg) & 0x3ff
}

// DAC.SHHR: DAC Sample and Hold hold time register
func (o *DAC_Type) SetSHHR_THOLD1(value uint32) {
	volatile.StoreUint32(&o.SHHR.Reg, volatile.LoadUint32(&o.SHHR.Reg)&^(0x3ff)|value)
}
func (o *DAC_Type) GetSHHR_THOLD1() uint32 {
	return volatile.LoadUint32(&o.SHHR.Reg) & 0x3ff
}
func (o *DAC_Type) SetSHHR_THOLD2(value uint32) {
	volatile.StoreUint32(&o.SHHR.Reg, volatile.LoadUint32(&o.SHHR.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DAC_Type) GetSHHR_THOLD2() uint32 {
	return (volatile.LoadUint32(&o.SHHR.Reg) & 0x3ff0000) >> 16
}

// DAC.SHRR: DAC Sample and Hold refresh time register
func (o *DAC_Type) SetSHRR_TREFRESH1(value uint32) {
	volatile.StoreUint32(&o.SHRR.Reg, volatile.LoadUint32(&o.SHRR.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetSHRR_TREFRESH1() uint32 {
	return volatile.LoadUint32(&o.SHRR.Reg) & 0xff
}
func (o *DAC_Type) SetSHRR_TREFRESH2(value uint32) {
	volatile.StoreUint32(&o.SHRR.Reg, volatile.LoadUint32(&o.SHRR.Reg)&^(0xff0000)|value<<16)
}
func (o *DAC_Type) GetSHRR_TREFRESH2() uint32 {
	return (volatile.LoadUint32(&o.SHRR.Reg) & 0xff0000) >> 16
}

// Microcontroller Debug Unit
type DBGMCU_Type struct {
	IDC      volatile.Register32 // 0x0
	CR       volatile.Register32 // 0x4
	_        [44]byte
	APB3FZ1  volatile.Register32 // 0x34
	APB3FZ2  volatile.Register32 // 0x38
	APB1LFZ1 volatile.Register32 // 0x3C
	APB1LFZ2 volatile.Register32 // 0x40
	_        [8]byte
	APB2FZ1  volatile.Register32 // 0x4C
	APB2FZ2  volatile.Register32 // 0x50
	APB4FZ1  volatile.Register32 // 0x54
	APB4FZ2  volatile.Register32 // 0x58
}

// DBGMCU.IDC: DBGMCU Identity Code Register
func (o *DBGMCU_Type) SetIDC_DEV_ID(value uint32) {
	volatile.StoreUint32(&o.IDC.Reg, volatile.LoadUint32(&o.IDC.Reg)&^(0xfff)|value)
}
func (o *DBGMCU_Type) GetIDC_DEV_ID() uint32 {
	return volatile.LoadUint32(&o.IDC.Reg) & 0xfff
}
func (o *DBGMCU_Type) SetIDC_REV_ID(value uint32) {
	volatile.StoreUint32(&o.IDC.Reg, volatile.LoadUint32(&o.IDC.Reg)&^(0xffff0000)|value<<16)
}
func (o *DBGMCU_Type) GetIDC_REV_ID() uint32 {
	return (volatile.LoadUint32(&o.IDC.Reg) & 0xffff0000) >> 16
}

// DBGMCU.CR: DBGMCU Configuration Register
func (o *DBGMCU_Type) SetCR_DBGSLPD1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DBGMCU_Type) GetCR_DBGSLPD1() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DBGMCU_Type) SetCR_DBGSTPD1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DBGMCU_Type) GetCR_DBGSTPD1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DBGMCU_Type) SetCR_DBGSTBD1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DBGMCU_Type) GetCR_DBGSTBD1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DBGMCU_Type) SetCR_DBGSLPD2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *DBGMCU_Type) GetCR_DBGSLPD2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *DBGMCU_Type) SetCR_DBGSTPD2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DBGMCU_Type) GetCR_DBGSTPD2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DBGMCU_Type) SetCR_DBGSTBD2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DBGMCU_Type) GetCR_DBGSTBD2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DBGMCU_Type) SetCR_DBGSTPD3(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *DBGMCU_Type) GetCR_DBGSTPD3() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *DBGMCU_Type) SetCR_DBGSTBD3(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *DBGMCU_Type) GetCR_DBGSTBD3() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *DBGMCU_Type) SetCR_TRACECLKEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *DBGMCU_Type) GetCR_TRACECLKEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *DBGMCU_Type) SetCR_D1DBGCKEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200000)|value<<21)
}
func (o *DBGMCU_Type) GetCR_D1DBGCKEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200000) >> 21
}
func (o *DBGMCU_Type) SetCR_D3DBGCKEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400000)|value<<22)
}
func (o *DBGMCU_Type) GetCR_D3DBGCKEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400000) >> 22
}
func (o *DBGMCU_Type) SetCR_TRGOEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *DBGMCU_Type) GetCR_TRGOEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}

// DBGMCU.APB3FZ1: DBGMCU APB3 peripheral freeze register CPU1
func (o *DBGMCU_Type) SetAPB3FZ1_WWDG1(value uint32) {
	volatile.StoreUint32(&o.APB3FZ1.Reg, volatile.LoadUint32(&o.APB3FZ1.Reg)&^(0x40)|value<<6)
}
func (o *DBGMCU_Type) GetAPB3FZ1_WWDG1() uint32 {
	return (volatile.LoadUint32(&o.APB3FZ1.Reg) & 0x40) >> 6
}

// DBGMCU.APB3FZ2: DBGMCU APB3 peripheral freeze register CPU2
func (o *DBGMCU_Type) SetAPB3FZ2_WWDG1(value uint32) {
	volatile.StoreUint32(&o.APB3FZ2.Reg, volatile.LoadUint32(&o.APB3FZ2.Reg)&^(0x40)|value<<6)
}
func (o *DBGMCU_Type) GetAPB3FZ2_WWDG1() uint32 {
	return (volatile.LoadUint32(&o.APB3FZ2.Reg) & 0x40) >> 6
}

// DBGMCU.APB1LFZ1: DBGMCU APB1L peripheral freeze register
func (o *DBGMCU_Type) SetAPB1LFZ1_DBG_TIM2(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ1.Reg, volatile.LoadUint32(&o.APB1LFZ1.Reg)&^(0x1)|value)
}
func (o *DBGMCU_Type) GetAPB1LFZ1_DBG_TIM2() uint32 {
	return volatile.LoadUint32(&o.APB1LFZ1.Reg) & 0x1
}
func (o *DBGMCU_Type) SetAPB1LFZ1_DBG_TIM3(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ1.Reg, volatile.LoadUint32(&o.APB1LFZ1.Reg)&^(0x2)|value<<1)
}
func (o *DBGMCU_Type) GetAPB1LFZ1_DBG_TIM3() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ1.Reg) & 0x2) >> 1
}
func (o *DBGMCU_Type) SetAPB1LFZ1_DBG_TIM4(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ1.Reg, volatile.LoadUint32(&o.APB1LFZ1.Reg)&^(0x4)|value<<2)
}
func (o *DBGMCU_Type) GetAPB1LFZ1_DBG_TIM4() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ1.Reg) & 0x4) >> 2
}
func (o *DBGMCU_Type) SetAPB1LFZ1_DBG_TIM5(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ1.Reg, volatile.LoadUint32(&o.APB1LFZ1.Reg)&^(0x8)|value<<3)
}
func (o *DBGMCU_Type) GetAPB1LFZ1_DBG_TIM5() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ1.Reg) & 0x8) >> 3
}
func (o *DBGMCU_Type) SetAPB1LFZ1_DBG_TIM6(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ1.Reg, volatile.LoadUint32(&o.APB1LFZ1.Reg)&^(0x10)|value<<4)
}
func (o *DBGMCU_Type) GetAPB1LFZ1_DBG_TIM6() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ1.Reg) & 0x10) >> 4
}
func (o *DBGMCU_Type) SetAPB1LFZ1_DBG_TIM7(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ1.Reg, volatile.LoadUint32(&o.APB1LFZ1.Reg)&^(0x20)|value<<5)
}
func (o *DBGMCU_Type) GetAPB1LFZ1_DBG_TIM7() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ1.Reg) & 0x20) >> 5
}
func (o *DBGMCU_Type) SetAPB1LFZ1_DBG_TIM12(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ1.Reg, volatile.LoadUint32(&o.APB1LFZ1.Reg)&^(0x40)|value<<6)
}
func (o *DBGMCU_Type) GetAPB1LFZ1_DBG_TIM12() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ1.Reg) & 0x40) >> 6
}
func (o *DBGMCU_Type) SetAPB1LFZ1_DBG_TIM13(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ1.Reg, volatile.LoadUint32(&o.APB1LFZ1.Reg)&^(0x80)|value<<7)
}
func (o *DBGMCU_Type) GetAPB1LFZ1_DBG_TIM13() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ1.Reg) & 0x80) >> 7
}
func (o *DBGMCU_Type) SetAPB1LFZ1_DBG_TIM14(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ1.Reg, volatile.LoadUint32(&o.APB1LFZ1.Reg)&^(0x100)|value<<8)
}
func (o *DBGMCU_Type) GetAPB1LFZ1_DBG_TIM14() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ1.Reg) & 0x100) >> 8
}
func (o *DBGMCU_Type) SetAPB1LFZ1_DBG_LPTIM1(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ1.Reg, volatile.LoadUint32(&o.APB1LFZ1.Reg)&^(0x200)|value<<9)
}
func (o *DBGMCU_Type) GetAPB1LFZ1_DBG_LPTIM1() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ1.Reg) & 0x200) >> 9
}
func (o *DBGMCU_Type) SetAPB1LFZ1_DBG_WWDG2(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ1.Reg, volatile.LoadUint32(&o.APB1LFZ1.Reg)&^(0x800)|value<<11)
}
func (o *DBGMCU_Type) GetAPB1LFZ1_DBG_WWDG2() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ1.Reg) & 0x800) >> 11
}
func (o *DBGMCU_Type) SetAPB1LFZ1_DBG_I2C1(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ1.Reg, volatile.LoadUint32(&o.APB1LFZ1.Reg)&^(0x200000)|value<<21)
}
func (o *DBGMCU_Type) GetAPB1LFZ1_DBG_I2C1() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ1.Reg) & 0x200000) >> 21
}
func (o *DBGMCU_Type) SetAPB1LFZ1_DBG_I2C2(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ1.Reg, volatile.LoadUint32(&o.APB1LFZ1.Reg)&^(0x400000)|value<<22)
}
func (o *DBGMCU_Type) GetAPB1LFZ1_DBG_I2C2() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ1.Reg) & 0x400000) >> 22
}
func (o *DBGMCU_Type) SetAPB1LFZ1_DBG_I2C3(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ1.Reg, volatile.LoadUint32(&o.APB1LFZ1.Reg)&^(0x800000)|value<<23)
}
func (o *DBGMCU_Type) GetAPB1LFZ1_DBG_I2C3() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ1.Reg) & 0x800000) >> 23
}

// DBGMCU.APB1LFZ2: DBGMCU APB1L peripheral freeze register CPU2
func (o *DBGMCU_Type) SetAPB1LFZ2_DBG_TIM2(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ2.Reg, volatile.LoadUint32(&o.APB1LFZ2.Reg)&^(0x1)|value)
}
func (o *DBGMCU_Type) GetAPB1LFZ2_DBG_TIM2() uint32 {
	return volatile.LoadUint32(&o.APB1LFZ2.Reg) & 0x1
}
func (o *DBGMCU_Type) SetAPB1LFZ2_DBG_TIM3(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ2.Reg, volatile.LoadUint32(&o.APB1LFZ2.Reg)&^(0x2)|value<<1)
}
func (o *DBGMCU_Type) GetAPB1LFZ2_DBG_TIM3() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ2.Reg) & 0x2) >> 1
}
func (o *DBGMCU_Type) SetAPB1LFZ2_DBG_TIM4(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ2.Reg, volatile.LoadUint32(&o.APB1LFZ2.Reg)&^(0x4)|value<<2)
}
func (o *DBGMCU_Type) GetAPB1LFZ2_DBG_TIM4() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ2.Reg) & 0x4) >> 2
}
func (o *DBGMCU_Type) SetAPB1LFZ2_DBG_TIM5(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ2.Reg, volatile.LoadUint32(&o.APB1LFZ2.Reg)&^(0x8)|value<<3)
}
func (o *DBGMCU_Type) GetAPB1LFZ2_DBG_TIM5() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ2.Reg) & 0x8) >> 3
}
func (o *DBGMCU_Type) SetAPB1LFZ2_DBG_TIM6(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ2.Reg, volatile.LoadUint32(&o.APB1LFZ2.Reg)&^(0x10)|value<<4)
}
func (o *DBGMCU_Type) GetAPB1LFZ2_DBG_TIM6() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ2.Reg) & 0x10) >> 4
}
func (o *DBGMCU_Type) SetAPB1LFZ2_DBG_TIM7(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ2.Reg, volatile.LoadUint32(&o.APB1LFZ2.Reg)&^(0x20)|value<<5)
}
func (o *DBGMCU_Type) GetAPB1LFZ2_DBG_TIM7() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ2.Reg) & 0x20) >> 5
}
func (o *DBGMCU_Type) SetAPB1LFZ2_DBG_TIM12(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ2.Reg, volatile.LoadUint32(&o.APB1LFZ2.Reg)&^(0x40)|value<<6)
}
func (o *DBGMCU_Type) GetAPB1LFZ2_DBG_TIM12() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ2.Reg) & 0x40) >> 6
}
func (o *DBGMCU_Type) SetAPB1LFZ2_DBG_TIM13(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ2.Reg, volatile.LoadUint32(&o.APB1LFZ2.Reg)&^(0x80)|value<<7)
}
func (o *DBGMCU_Type) GetAPB1LFZ2_DBG_TIM13() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ2.Reg) & 0x80) >> 7
}
func (o *DBGMCU_Type) SetAPB1LFZ2_DBG_TIM14(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ2.Reg, volatile.LoadUint32(&o.APB1LFZ2.Reg)&^(0x100)|value<<8)
}
func (o *DBGMCU_Type) GetAPB1LFZ2_DBG_TIM14() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ2.Reg) & 0x100) >> 8
}
func (o *DBGMCU_Type) SetAPB1LFZ2_DBG_LPTIM1(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ2.Reg, volatile.LoadUint32(&o.APB1LFZ2.Reg)&^(0x200)|value<<9)
}
func (o *DBGMCU_Type) GetAPB1LFZ2_DBG_LPTIM1() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ2.Reg) & 0x200) >> 9
}
func (o *DBGMCU_Type) SetAPB1LFZ2_DBG_WWDG2(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ2.Reg, volatile.LoadUint32(&o.APB1LFZ2.Reg)&^(0x800)|value<<11)
}
func (o *DBGMCU_Type) GetAPB1LFZ2_DBG_WWDG2() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ2.Reg) & 0x800) >> 11
}
func (o *DBGMCU_Type) SetAPB1LFZ2_DBG_I2C1(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ2.Reg, volatile.LoadUint32(&o.APB1LFZ2.Reg)&^(0x200000)|value<<21)
}
func (o *DBGMCU_Type) GetAPB1LFZ2_DBG_I2C1() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ2.Reg) & 0x200000) >> 21
}
func (o *DBGMCU_Type) SetAPB1LFZ2_DBG_I2C2(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ2.Reg, volatile.LoadUint32(&o.APB1LFZ2.Reg)&^(0x400000)|value<<22)
}
func (o *DBGMCU_Type) GetAPB1LFZ2_DBG_I2C2() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ2.Reg) & 0x400000) >> 22
}
func (o *DBGMCU_Type) SetAPB1LFZ2_DBG_I2C3(value uint32) {
	volatile.StoreUint32(&o.APB1LFZ2.Reg, volatile.LoadUint32(&o.APB1LFZ2.Reg)&^(0x800000)|value<<23)
}
func (o *DBGMCU_Type) GetAPB1LFZ2_DBG_I2C3() uint32 {
	return (volatile.LoadUint32(&o.APB1LFZ2.Reg) & 0x800000) >> 23
}

// DBGMCU.APB2FZ1: DBGMCU APB2 peripheral freeze register
func (o *DBGMCU_Type) SetAPB2FZ1_DBG_TIM1(value uint32) {
	volatile.StoreUint32(&o.APB2FZ1.Reg, volatile.LoadUint32(&o.APB2FZ1.Reg)&^(0x1)|value)
}
func (o *DBGMCU_Type) GetAPB2FZ1_DBG_TIM1() uint32 {
	return volatile.LoadUint32(&o.APB2FZ1.Reg) & 0x1
}
func (o *DBGMCU_Type) SetAPB2FZ1_DBG_TIM8(value uint32) {
	volatile.StoreUint32(&o.APB2FZ1.Reg, volatile.LoadUint32(&o.APB2FZ1.Reg)&^(0x2)|value<<1)
}
func (o *DBGMCU_Type) GetAPB2FZ1_DBG_TIM8() uint32 {
	return (volatile.LoadUint32(&o.APB2FZ1.Reg) & 0x2) >> 1
}
func (o *DBGMCU_Type) SetAPB2FZ1_DBG_TIM15(value uint32) {
	volatile.StoreUint32(&o.APB2FZ1.Reg, volatile.LoadUint32(&o.APB2FZ1.Reg)&^(0x10000)|value<<16)
}
func (o *DBGMCU_Type) GetAPB2FZ1_DBG_TIM15() uint32 {
	return (volatile.LoadUint32(&o.APB2FZ1.Reg) & 0x10000) >> 16
}
func (o *DBGMCU_Type) SetAPB2FZ1_DBG_TIM16(value uint32) {
	volatile.StoreUint32(&o.APB2FZ1.Reg, volatile.LoadUint32(&o.APB2FZ1.Reg)&^(0x20000)|value<<17)
}
func (o *DBGMCU_Type) GetAPB2FZ1_DBG_TIM16() uint32 {
	return (volatile.LoadUint32(&o.APB2FZ1.Reg) & 0x20000) >> 17
}
func (o *DBGMCU_Type) SetAPB2FZ1_DBG_TIM17(value uint32) {
	volatile.StoreUint32(&o.APB2FZ1.Reg, volatile.LoadUint32(&o.APB2FZ1.Reg)&^(0x40000)|value<<18)
}
func (o *DBGMCU_Type) GetAPB2FZ1_DBG_TIM17() uint32 {
	return (volatile.LoadUint32(&o.APB2FZ1.Reg) & 0x40000) >> 18
}
func (o *DBGMCU_Type) SetAPB2FZ1_DBG_HRTIM(value uint32) {
	volatile.StoreUint32(&o.APB2FZ1.Reg, volatile.LoadUint32(&o.APB2FZ1.Reg)&^(0x20000000)|value<<29)
}
func (o *DBGMCU_Type) GetAPB2FZ1_DBG_HRTIM() uint32 {
	return (volatile.LoadUint32(&o.APB2FZ1.Reg) & 0x20000000) >> 29
}

// DBGMCU.APB2FZ2: DBGMCU APB2 peripheral freeze register CPU2
func (o *DBGMCU_Type) SetAPB2FZ2_DBG_TIM1(value uint32) {
	volatile.StoreUint32(&o.APB2FZ2.Reg, volatile.LoadUint32(&o.APB2FZ2.Reg)&^(0x1)|value)
}
func (o *DBGMCU_Type) GetAPB2FZ2_DBG_TIM1() uint32 {
	return volatile.LoadUint32(&o.APB2FZ2.Reg) & 0x1
}
func (o *DBGMCU_Type) SetAPB2FZ2_DBG_TIM8(value uint32) {
	volatile.StoreUint32(&o.APB2FZ2.Reg, volatile.LoadUint32(&o.APB2FZ2.Reg)&^(0x2)|value<<1)
}
func (o *DBGMCU_Type) GetAPB2FZ2_DBG_TIM8() uint32 {
	return (volatile.LoadUint32(&o.APB2FZ2.Reg) & 0x2) >> 1
}
func (o *DBGMCU_Type) SetAPB2FZ2_DBG_TIM15(value uint32) {
	volatile.StoreUint32(&o.APB2FZ2.Reg, volatile.LoadUint32(&o.APB2FZ2.Reg)&^(0x10000)|value<<16)
}
func (o *DBGMCU_Type) GetAPB2FZ2_DBG_TIM15() uint32 {
	return (volatile.LoadUint32(&o.APB2FZ2.Reg) & 0x10000) >> 16
}
func (o *DBGMCU_Type) SetAPB2FZ2_DBG_TIM16(value uint32) {
	volatile.StoreUint32(&o.APB2FZ2.Reg, volatile.LoadUint32(&o.APB2FZ2.Reg)&^(0x20000)|value<<17)
}
func (o *DBGMCU_Type) GetAPB2FZ2_DBG_TIM16() uint32 {
	return (volatile.LoadUint32(&o.APB2FZ2.Reg) & 0x20000) >> 17
}
func (o *DBGMCU_Type) SetAPB2FZ2_DBG_TIM17(value uint32) {
	volatile.StoreUint32(&o.APB2FZ2.Reg, volatile.LoadUint32(&o.APB2FZ2.Reg)&^(0x40000)|value<<18)
}
func (o *DBGMCU_Type) GetAPB2FZ2_DBG_TIM17() uint32 {
	return (volatile.LoadUint32(&o.APB2FZ2.Reg) & 0x40000) >> 18
}
func (o *DBGMCU_Type) SetAPB2FZ2_DBG_HRTIM(value uint32) {
	volatile.StoreUint32(&o.APB2FZ2.Reg, volatile.LoadUint32(&o.APB2FZ2.Reg)&^(0x20000000)|value<<29)
}
func (o *DBGMCU_Type) GetAPB2FZ2_DBG_HRTIM() uint32 {
	return (volatile.LoadUint32(&o.APB2FZ2.Reg) & 0x20000000) >> 29
}

// DBGMCU.APB4FZ1: DBGMCU APB4 peripheral freeze register
func (o *DBGMCU_Type) SetAPB4FZ1_DBG_I2C4(value uint32) {
	volatile.StoreUint32(&o.APB4FZ1.Reg, volatile.LoadUint32(&o.APB4FZ1.Reg)&^(0x80)|value<<7)
}
func (o *DBGMCU_Type) GetAPB4FZ1_DBG_I2C4() uint32 {
	return (volatile.LoadUint32(&o.APB4FZ1.Reg) & 0x80) >> 7
}
func (o *DBGMCU_Type) SetAPB4FZ1_DBG_LPTIM2(value uint32) {
	volatile.StoreUint32(&o.APB4FZ1.Reg, volatile.LoadUint32(&o.APB4FZ1.Reg)&^(0x200)|value<<9)
}
func (o *DBGMCU_Type) GetAPB4FZ1_DBG_LPTIM2() uint32 {
	return (volatile.LoadUint32(&o.APB4FZ1.Reg) & 0x200) >> 9
}
func (o *DBGMCU_Type) SetAPB4FZ1_DBG_LPTIM3(value uint32) {
	volatile.StoreUint32(&o.APB4FZ1.Reg, volatile.LoadUint32(&o.APB4FZ1.Reg)&^(0x400)|value<<10)
}
func (o *DBGMCU_Type) GetAPB4FZ1_DBG_LPTIM3() uint32 {
	return (volatile.LoadUint32(&o.APB4FZ1.Reg) & 0x400) >> 10
}
func (o *DBGMCU_Type) SetAPB4FZ1_DBG_LPTIM4(value uint32) {
	volatile.StoreUint32(&o.APB4FZ1.Reg, volatile.LoadUint32(&o.APB4FZ1.Reg)&^(0x800)|value<<11)
}
func (o *DBGMCU_Type) GetAPB4FZ1_DBG_LPTIM4() uint32 {
	return (volatile.LoadUint32(&o.APB4FZ1.Reg) & 0x800) >> 11
}
func (o *DBGMCU_Type) SetAPB4FZ1_DBG_LPTIM5(value uint32) {
	volatile.StoreUint32(&o.APB4FZ1.Reg, volatile.LoadUint32(&o.APB4FZ1.Reg)&^(0x1000)|value<<12)
}
func (o *DBGMCU_Type) GetAPB4FZ1_DBG_LPTIM5() uint32 {
	return (volatile.LoadUint32(&o.APB4FZ1.Reg) & 0x1000) >> 12
}
func (o *DBGMCU_Type) SetAPB4FZ1_DBG_RTC(value uint32) {
	volatile.StoreUint32(&o.APB4FZ1.Reg, volatile.LoadUint32(&o.APB4FZ1.Reg)&^(0x10000)|value<<16)
}
func (o *DBGMCU_Type) GetAPB4FZ1_DBG_RTC() uint32 {
	return (volatile.LoadUint32(&o.APB4FZ1.Reg) & 0x10000) >> 16
}
func (o *DBGMCU_Type) SetAPB4FZ1_DBG_WDGLSD1(value uint32) {
	volatile.StoreUint32(&o.APB4FZ1.Reg, volatile.LoadUint32(&o.APB4FZ1.Reg)&^(0x40000)|value<<18)
}
func (o *DBGMCU_Type) GetAPB4FZ1_DBG_WDGLSD1() uint32 {
	return (volatile.LoadUint32(&o.APB4FZ1.Reg) & 0x40000) >> 18
}
func (o *DBGMCU_Type) SetAPB4FZ1_DBG_WDGLSD2(value uint32) {
	volatile.StoreUint32(&o.APB4FZ1.Reg, volatile.LoadUint32(&o.APB4FZ1.Reg)&^(0x80000)|value<<19)
}
func (o *DBGMCU_Type) GetAPB4FZ1_DBG_WDGLSD2() uint32 {
	return (volatile.LoadUint32(&o.APB4FZ1.Reg) & 0x80000) >> 19
}

// DBGMCU.APB4FZ2: DBGMCU APB4 peripheral freeze register CPU2
func (o *DBGMCU_Type) SetAPB4FZ2_DBG_I2C4(value uint32) {
	volatile.StoreUint32(&o.APB4FZ2.Reg, volatile.LoadUint32(&o.APB4FZ2.Reg)&^(0x80)|value<<7)
}
func (o *DBGMCU_Type) GetAPB4FZ2_DBG_I2C4() uint32 {
	return (volatile.LoadUint32(&o.APB4FZ2.Reg) & 0x80) >> 7
}
func (o *DBGMCU_Type) SetAPB4FZ2_DBG_LPTIM2(value uint32) {
	volatile.StoreUint32(&o.APB4FZ2.Reg, volatile.LoadUint32(&o.APB4FZ2.Reg)&^(0x200)|value<<9)
}
func (o *DBGMCU_Type) GetAPB4FZ2_DBG_LPTIM2() uint32 {
	return (volatile.LoadUint32(&o.APB4FZ2.Reg) & 0x200) >> 9
}
func (o *DBGMCU_Type) SetAPB4FZ2_DBG_LPTIM3(value uint32) {
	volatile.StoreUint32(&o.APB4FZ2.Reg, volatile.LoadUint32(&o.APB4FZ2.Reg)&^(0x400)|value<<10)
}
func (o *DBGMCU_Type) GetAPB4FZ2_DBG_LPTIM3() uint32 {
	return (volatile.LoadUint32(&o.APB4FZ2.Reg) & 0x400) >> 10
}
func (o *DBGMCU_Type) SetAPB4FZ2_DBG_LPTIM4(value uint32) {
	volatile.StoreUint32(&o.APB4FZ2.Reg, volatile.LoadUint32(&o.APB4FZ2.Reg)&^(0x800)|value<<11)
}
func (o *DBGMCU_Type) GetAPB4FZ2_DBG_LPTIM4() uint32 {
	return (volatile.LoadUint32(&o.APB4FZ2.Reg) & 0x800) >> 11
}
func (o *DBGMCU_Type) SetAPB4FZ2_DBG_LPTIM5(value uint32) {
	volatile.StoreUint32(&o.APB4FZ2.Reg, volatile.LoadUint32(&o.APB4FZ2.Reg)&^(0x1000)|value<<12)
}
func (o *DBGMCU_Type) GetAPB4FZ2_DBG_LPTIM5() uint32 {
	return (volatile.LoadUint32(&o.APB4FZ2.Reg) & 0x1000) >> 12
}
func (o *DBGMCU_Type) SetAPB4FZ2_DBG_RTC(value uint32) {
	volatile.StoreUint32(&o.APB4FZ2.Reg, volatile.LoadUint32(&o.APB4FZ2.Reg)&^(0x10000)|value<<16)
}
func (o *DBGMCU_Type) GetAPB4FZ2_DBG_RTC() uint32 {
	return (volatile.LoadUint32(&o.APB4FZ2.Reg) & 0x10000) >> 16
}
func (o *DBGMCU_Type) SetAPB4FZ2_DBG_WDGLSD1(value uint32) {
	volatile.StoreUint32(&o.APB4FZ2.Reg, volatile.LoadUint32(&o.APB4FZ2.Reg)&^(0x40000)|value<<18)
}
func (o *DBGMCU_Type) GetAPB4FZ2_DBG_WDGLSD1() uint32 {
	return (volatile.LoadUint32(&o.APB4FZ2.Reg) & 0x40000) >> 18
}
func (o *DBGMCU_Type) SetAPB4FZ2_DBG_WDGLSD2(value uint32) {
	volatile.StoreUint32(&o.APB4FZ2.Reg, volatile.LoadUint32(&o.APB4FZ2.Reg)&^(0x80000)|value<<19)
}
func (o *DBGMCU_Type) GetAPB4FZ2_DBG_WDGLSD2() uint32 {
	return (volatile.LoadUint32(&o.APB4FZ2.Reg) & 0x80000) >> 19
}

// Digital camera interface
type DCMI_Type struct {
	CR     volatile.Register32 // 0x0
	SR     volatile.Register32 // 0x4
	RIS    volatile.Register32 // 0x8
	IER    volatile.Register32 // 0xC
	MIS    volatile.Register32 // 0x10
	ICR    volatile.Register32 // 0x14
	ESCR   volatile.Register32 // 0x18
	ESUR   volatile.Register32 // 0x1C
	CWSTRT volatile.Register32 // 0x20
	CWSIZE volatile.Register32 // 0x24
	DR     volatile.Register32 // 0x28
}

// DCMI.CR: control register 1
func (o *DCMI_Type) SetCR_OELS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *DCMI_Type) GetCR_OELS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *DCMI_Type) SetCR_LSM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *DCMI_Type) GetCR_LSM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *DCMI_Type) SetCR_OEBS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *DCMI_Type) GetCR_OEBS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *DCMI_Type) SetCR_BSM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30000)|value<<16)
}
func (o *DCMI_Type) GetCR_BSM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30000) >> 16
}
func (o *DCMI_Type) SetCR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *DCMI_Type) GetCR_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *DCMI_Type) SetCR_EDM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00)|value<<10)
}
func (o *DCMI_Type) GetCR_EDM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00) >> 10
}
func (o *DCMI_Type) SetCR_FCRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *DCMI_Type) GetCR_FCRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *DCMI_Type) SetCR_VSPOL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *DCMI_Type) GetCR_VSPOL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *DCMI_Type) SetCR_HSPOL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *DCMI_Type) GetCR_HSPOL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *DCMI_Type) SetCR_PCKPOL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DCMI_Type) GetCR_PCKPOL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DCMI_Type) SetCR_ESS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DCMI_Type) GetCR_ESS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DCMI_Type) SetCR_JPEG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *DCMI_Type) GetCR_JPEG() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *DCMI_Type) SetCR_CROP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetCR_CROP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetCR_CM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetCR_CM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetCR_CAPTURE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetCR_CAPTURE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// DCMI.SR: status register
func (o *DCMI_Type) SetSR_FNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetSR_FNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetSR_VSYNC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetSR_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetSR_HSYNC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetSR_HSYNC() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// DCMI.RIS: raw interrupt status register
func (o *DCMI_Type) SetRIS_LINE_RIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x10)|value<<4)
}
func (o *DCMI_Type) GetRIS_LINE_RIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x10) >> 4
}
func (o *DCMI_Type) SetRIS_VSYNC_RIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x8)|value<<3)
}
func (o *DCMI_Type) GetRIS_VSYNC_RIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x8) >> 3
}
func (o *DCMI_Type) SetRIS_ERR_RIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetRIS_ERR_RIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetRIS_OVR_RIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetRIS_OVR_RIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetRIS_FRAME_RIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetRIS_FRAME_RIS() uint32 {
	return volatile.LoadUint32(&o.RIS.Reg) & 0x1
}

// DCMI.IER: interrupt enable register
func (o *DCMI_Type) SetIER_LINE_IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *DCMI_Type) GetIER_LINE_IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *DCMI_Type) SetIER_VSYNC_IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *DCMI_Type) GetIER_VSYNC_IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *DCMI_Type) SetIER_ERR_IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetIER_ERR_IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetIER_OVR_IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetIER_OVR_IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetIER_FRAME_IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetIER_FRAME_IE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// DCMI.MIS: masked interrupt status register
func (o *DCMI_Type) SetMIS_LINE_MIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x10)|value<<4)
}
func (o *DCMI_Type) GetMIS_LINE_MIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x10) >> 4
}
func (o *DCMI_Type) SetMIS_VSYNC_MIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x8)|value<<3)
}
func (o *DCMI_Type) GetMIS_VSYNC_MIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x8) >> 3
}
func (o *DCMI_Type) SetMIS_ERR_MIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetMIS_ERR_MIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetMIS_OVR_MIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetMIS_OVR_MIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetMIS_FRAME_MIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetMIS_FRAME_MIS() uint32 {
	return volatile.LoadUint32(&o.MIS.Reg) & 0x1
}

// DCMI.ICR: interrupt clear register
func (o *DCMI_Type) SetICR_LINE_ISC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *DCMI_Type) GetICR_LINE_ISC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *DCMI_Type) SetICR_VSYNC_ISC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *DCMI_Type) GetICR_VSYNC_ISC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *DCMI_Type) SetICR_ERR_ISC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *DCMI_Type) GetICR_ERR_ISC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *DCMI_Type) SetICR_OVR_ISC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *DCMI_Type) GetICR_OVR_ISC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *DCMI_Type) SetICR_FRAME_ISC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *DCMI_Type) GetICR_FRAME_ISC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// DCMI.ESCR: embedded synchronization code register
func (o *DCMI_Type) SetESCR_FEC(value uint32) {
	volatile.StoreUint32(&o.ESCR.Reg, volatile.LoadUint32(&o.ESCR.Reg)&^(0xff000000)|value<<24)
}
func (o *DCMI_Type) GetESCR_FEC() uint32 {
	return (volatile.LoadUint32(&o.ESCR.Reg) & 0xff000000) >> 24
}
func (o *DCMI_Type) SetESCR_LEC(value uint32) {
	volatile.StoreUint32(&o.ESCR.Reg, volatile.LoadUint32(&o.ESCR.Reg)&^(0xff0000)|value<<16)
}
func (o *DCMI_Type) GetESCR_LEC() uint32 {
	return (volatile.LoadUint32(&o.ESCR.Reg) & 0xff0000) >> 16
}
func (o *DCMI_Type) SetESCR_LSC(value uint32) {
	volatile.StoreUint32(&o.ESCR.Reg, volatile.LoadUint32(&o.ESCR.Reg)&^(0xff00)|value<<8)
}
func (o *DCMI_Type) GetESCR_LSC() uint32 {
	return (volatile.LoadUint32(&o.ESCR.Reg) & 0xff00) >> 8
}
func (o *DCMI_Type) SetESCR_FSC(value uint32) {
	volatile.StoreUint32(&o.ESCR.Reg, volatile.LoadUint32(&o.ESCR.Reg)&^(0xff)|value)
}
func (o *DCMI_Type) GetESCR_FSC() uint32 {
	return volatile.LoadUint32(&o.ESCR.Reg) & 0xff
}

// DCMI.ESUR: embedded synchronization unmask register
func (o *DCMI_Type) SetESUR_FEU(value uint32) {
	volatile.StoreUint32(&o.ESUR.Reg, volatile.LoadUint32(&o.ESUR.Reg)&^(0xff000000)|value<<24)
}
func (o *DCMI_Type) GetESUR_FEU() uint32 {
	return (volatile.LoadUint32(&o.ESUR.Reg) & 0xff000000) >> 24
}
func (o *DCMI_Type) SetESUR_LEU(value uint32) {
	volatile.StoreUint32(&o.ESUR.Reg, volatile.LoadUint32(&o.ESUR.Reg)&^(0xff0000)|value<<16)
}
func (o *DCMI_Type) GetESUR_LEU() uint32 {
	return (volatile.LoadUint32(&o.ESUR.Reg) & 0xff0000) >> 16
}
func (o *DCMI_Type) SetESUR_LSU(value uint32) {
	volatile.StoreUint32(&o.ESUR.Reg, volatile.LoadUint32(&o.ESUR.Reg)&^(0xff00)|value<<8)
}
func (o *DCMI_Type) GetESUR_LSU() uint32 {
	return (volatile.LoadUint32(&o.ESUR.Reg) & 0xff00) >> 8
}
func (o *DCMI_Type) SetESUR_FSU(value uint32) {
	volatile.StoreUint32(&o.ESUR.Reg, volatile.LoadUint32(&o.ESUR.Reg)&^(0xff)|value)
}
func (o *DCMI_Type) GetESUR_FSU() uint32 {
	return volatile.LoadUint32(&o.ESUR.Reg) & 0xff
}

// DCMI.CWSTRT: crop window start
func (o *DCMI_Type) SetCWSTRT_VST(value uint32) {
	volatile.StoreUint32(&o.CWSTRT.Reg, volatile.LoadUint32(&o.CWSTRT.Reg)&^(0x1fff0000)|value<<16)
}
func (o *DCMI_Type) GetCWSTRT_VST() uint32 {
	return (volatile.LoadUint32(&o.CWSTRT.Reg) & 0x1fff0000) >> 16
}
func (o *DCMI_Type) SetCWSTRT_HOFFCNT(value uint32) {
	volatile.StoreUint32(&o.CWSTRT.Reg, volatile.LoadUint32(&o.CWSTRT.Reg)&^(0x3fff)|value)
}
func (o *DCMI_Type) GetCWSTRT_HOFFCNT() uint32 {
	return volatile.LoadUint32(&o.CWSTRT.Reg) & 0x3fff
}

// DCMI.CWSIZE: crop window size
func (o *DCMI_Type) SetCWSIZE_VLINE(value uint32) {
	volatile.StoreUint32(&o.CWSIZE.Reg, volatile.LoadUint32(&o.CWSIZE.Reg)&^(0x3fff0000)|value<<16)
}
func (o *DCMI_Type) GetCWSIZE_VLINE() uint32 {
	return (volatile.LoadUint32(&o.CWSIZE.Reg) & 0x3fff0000) >> 16
}
func (o *DCMI_Type) SetCWSIZE_CAPCNT(value uint32) {
	volatile.StoreUint32(&o.CWSIZE.Reg, volatile.LoadUint32(&o.CWSIZE.Reg)&^(0x3fff)|value)
}
func (o *DCMI_Type) GetCWSIZE_CAPCNT() uint32 {
	return volatile.LoadUint32(&o.CWSIZE.Reg) & 0x3fff
}

// DCMI.DR: data register
func (o *DCMI_Type) SetDR_Byte3(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff000000)|value<<24)
}
func (o *DCMI_Type) GetDR_Byte3() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xff000000) >> 24
}
func (o *DCMI_Type) SetDR_Byte2(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff0000)|value<<16)
}
func (o *DCMI_Type) GetDR_Byte2() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xff0000) >> 16
}
func (o *DCMI_Type) SetDR_Byte1(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff00)|value<<8)
}
func (o *DCMI_Type) GetDR_Byte1() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xff00) >> 8
}
func (o *DCMI_Type) SetDR_Byte0(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff)|value)
}
func (o *DCMI_Type) GetDR_Byte0() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xff
}

// DELAY_Block_SDMMC1
type DLYB_Type struct {
	CR   volatile.Register32 // 0x0
	CFGR volatile.Register32 // 0x4
}

// DLYB.CR: DLYB control register
func (o *DLYB_Type) SetCR_DEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DLYB_Type) GetCR_DEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DLYB_Type) SetCR_SEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DLYB_Type) GetCR_SEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}

// DLYB.CFGR: DLYB configuration register
func (o *DLYB_Type) SetCFGR_SEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf)|value)
}
func (o *DLYB_Type) GetCFGR_SEL() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0xf
}
func (o *DLYB_Type) SetCFGR_UNIT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7f00)|value<<8)
}
func (o *DLYB_Type) GetCFGR_UNIT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7f00) >> 8
}
func (o *DLYB_Type) SetCFGR_LNG(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xfff0000)|value<<16)
}
func (o *DLYB_Type) GetCFGR_LNG() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xfff0000) >> 16
}
func (o *DLYB_Type) SetCFGR_LNGF(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000000)|value<<31)
}
func (o *DLYB_Type) GetCFGR_LNGF() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000000) >> 31
}

// Digital filter for sigma delta modulators
type DFSDM_Type struct {
	CH  [8]DFSDM_CH_Type  // 0x0
	FLT [4]DFSDM_FLT_Type // 0x100
}

// Cluster CH%s, containing CH?CFGR1, CH?CFGR2, CH?AWSCDR, CH?WDATR, CH?DATINR
type DFSDM_CH_Type struct {
	CFGR1  volatile.Register32 // 0x0
	CFGR2  volatile.Register32 // 0x4
	AWSCDR volatile.Register32 // 0x8
	WDATR  volatile.Register32 // 0xC
	DATINR volatile.Register32 // 0x10
	_      [12]byte
}

// DFSDM_CH.CFGR1: channel configuration y register
func (o *DFSDM_CH_Type) SetCFGR1_DFSDMEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x80000000)|value<<31)
}
func (o *DFSDM_CH_Type) GetCFGR1_DFSDMEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x80000000) >> 31
}
func (o *DFSDM_CH_Type) SetCFGR1_CKOUTSRC(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DFSDM_CH_Type) GetCFGR1_CKOUTSRC() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x40000000) >> 30
}
func (o *DFSDM_CH_Type) SetCFGR1_CKOUTDIV(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_CH_Type) GetCFGR1_CKOUTDIV() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_CH_Type) SetCFGR1_DATPACK(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0xc000)|value<<14)
}
func (o *DFSDM_CH_Type) GetCFGR1_DATPACK() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0xc000) >> 14
}
func (o *DFSDM_CH_Type) SetCFGR1_DATMPX(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x3000)|value<<12)
}
func (o *DFSDM_CH_Type) GetCFGR1_DATMPX() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x3000) >> 12
}
func (o *DFSDM_CH_Type) SetCFGR1_CHINSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x100)|value<<8)
}
func (o *DFSDM_CH_Type) GetCFGR1_CHINSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x100) >> 8
}
func (o *DFSDM_CH_Type) SetCFGR1_CHEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x80)|value<<7)
}
func (o *DFSDM_CH_Type) GetCFGR1_CHEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x80) >> 7
}
func (o *DFSDM_CH_Type) SetCFGR1_CKABEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_CH_Type) GetCFGR1_CKABEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x40) >> 6
}
func (o *DFSDM_CH_Type) SetCFGR1_SCDEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_CH_Type) GetCFGR1_SCDEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x20) >> 5
}
func (o *DFSDM_CH_Type) SetCFGR1_SPICKSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0xc)|value<<2)
}
func (o *DFSDM_CH_Type) GetCFGR1_SPICKSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0xc) >> 2
}
func (o *DFSDM_CH_Type) SetCFGR1_SITP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x3)|value)
}
func (o *DFSDM_CH_Type) GetCFGR1_SITP() uint32 {
	return volatile.LoadUint32(&o.CFGR1.Reg) & 0x3
}

// DFSDM_CH.CFGR2: channel configuration y register
func (o *DFSDM_CH_Type) SetCFGR2_OFFSET(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_CH_Type) GetCFGR2_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_CH_Type) SetCFGR2_DTRBS(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0xf8)|value<<3)
}
func (o *DFSDM_CH_Type) GetCFGR2_DTRBS() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0xf8) >> 3
}

// DFSDM_CH.AWSCDR: analog watchdog and short-circuit detector register
func (o *DFSDM_CH_Type) SetAWSCDR_AWFORD(value uint32) {
	volatile.StoreUint32(&o.AWSCDR.Reg, volatile.LoadUint32(&o.AWSCDR.Reg)&^(0xc00000)|value<<22)
}
func (o *DFSDM_CH_Type) GetAWSCDR_AWFORD() uint32 {
	return (volatile.LoadUint32(&o.AWSCDR.Reg) & 0xc00000) >> 22
}
func (o *DFSDM_CH_Type) SetAWSCDR_AWFOSR(value uint32) {
	volatile.StoreUint32(&o.AWSCDR.Reg, volatile.LoadUint32(&o.AWSCDR.Reg)&^(0x1f0000)|value<<16)
}
func (o *DFSDM_CH_Type) GetAWSCDR_AWFOSR() uint32 {
	return (volatile.LoadUint32(&o.AWSCDR.Reg) & 0x1f0000) >> 16
}
func (o *DFSDM_CH_Type) SetAWSCDR_BKSCD(value uint32) {
	volatile.StoreUint32(&o.AWSCDR.Reg, volatile.LoadUint32(&o.AWSCDR.Reg)&^(0xf000)|value<<12)
}
func (o *DFSDM_CH_Type) GetAWSCDR_BKSCD() uint32 {
	return (volatile.LoadUint32(&o.AWSCDR.Reg) & 0xf000) >> 12
}
func (o *DFSDM_CH_Type) SetAWSCDR_SCDT(value uint32) {
	volatile.StoreUint32(&o.AWSCDR.Reg, volatile.LoadUint32(&o.AWSCDR.Reg)&^(0xff)|value)
}
func (o *DFSDM_CH_Type) GetAWSCDR_SCDT() uint32 {
	return volatile.LoadUint32(&o.AWSCDR.Reg) & 0xff
}

// DFSDM_CH.WDATR: channel watchdog filter data register
func (o *DFSDM_CH_Type) SetWDATR_WDATA(value uint32) {
	volatile.StoreUint32(&o.WDATR.Reg, volatile.LoadUint32(&o.WDATR.Reg)&^(0xffff)|value)
}
func (o *DFSDM_CH_Type) GetWDATR_WDATA() uint32 {
	return volatile.LoadUint32(&o.WDATR.Reg) & 0xffff
}

// DFSDM_CH.DATINR: channel data input register
func (o *DFSDM_CH_Type) SetDATINR_INDAT1(value uint32) {
	volatile.StoreUint32(&o.DATINR.Reg, volatile.LoadUint32(&o.DATINR.Reg)&^(0xffff0000)|value<<16)
}
func (o *DFSDM_CH_Type) GetDATINR_INDAT1() uint32 {
	return (volatile.LoadUint32(&o.DATINR.Reg) & 0xffff0000) >> 16
}
func (o *DFSDM_CH_Type) SetDATINR_INDAT0(value uint32) {
	volatile.StoreUint32(&o.DATINR.Reg, volatile.LoadUint32(&o.DATINR.Reg)&^(0xffff)|value)
}
func (o *DFSDM_CH_Type) GetDATINR_INDAT0() uint32 {
	return volatile.LoadUint32(&o.DATINR.Reg) & 0xffff
}

// Cluster FLT%s, containing FLT?CR1, FLT?CR2, FLT?ISR, FLT?ICR, FLT?JCHGR, FLT?FCR, FLT?JDATAR, FLT?RDATAR, FLT?AWHTR, FLT?AWLTR, FLT?AWSR, FLT?AWCFR, FLT?EXMAX, FLT?EXMIN, FLT?CNVTIMR
type DFSDM_FLT_Type struct {
	CR1        volatile.Register32 // 0x100
	CR2        volatile.Register32 // 0x104
	ISR        volatile.Register32 // 0x108
	ICR        volatile.Register32 // 0x10C
	JCHGR      volatile.Register32 // 0x110
	FCR        volatile.Register32 // 0x114
	JDATAR     volatile.Register32 // 0x118
	RDATAR     volatile.Register32 // 0x11C
	AWHTR      volatile.Register32 // 0x120
	AWLTR      volatile.Register32 // 0x124
	AWSR       volatile.Register32 // 0x128
	AWCFR      volatile.Register32 // 0x12C
	EXMAX      volatile.Register32 // 0x130
	EXMIN      volatile.Register32 // 0x134
	FLTCNVTIMR volatile.Register32 // 0x138
	_          [68]byte
}

// DFSDM_FLT.CR1: control register 1
func (o *DFSDM_FLT_Type) SetCR1_AWFSEL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DFSDM_FLT_Type) GetCR1_AWFSEL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000000) >> 30
}
func (o *DFSDM_FLT_Type) SetCR1_FAST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000000)|value<<29)
}
func (o *DFSDM_FLT_Type) GetCR1_FAST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000000) >> 29
}
func (o *DFSDM_FLT_Type) SetCR1_RCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x7000000)|value<<24)
}
func (o *DFSDM_FLT_Type) GetCR1_RCH() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x7000000) >> 24
}
func (o *DFSDM_FLT_Type) SetCR1_RDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200000)|value<<21)
}
func (o *DFSDM_FLT_Type) GetCR1_RDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200000) >> 21
}
func (o *DFSDM_FLT_Type) SetCR1_RSYNC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *DFSDM_FLT_Type) GetCR1_RSYNC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *DFSDM_FLT_Type) SetCR1_RCONT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000)|value<<18)
}
func (o *DFSDM_FLT_Type) GetCR1_RCONT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000) >> 18
}
func (o *DFSDM_FLT_Type) SetCR1_RSWSTART(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *DFSDM_FLT_Type) GetCR1_RSWSTART() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *DFSDM_FLT_Type) SetCR1_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x6000)|value<<13)
}
func (o *DFSDM_FLT_Type) GetCR1_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x6000) >> 13
}
func (o *DFSDM_FLT_Type) SetCR1_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x700)|value<<8)
}
func (o *DFSDM_FLT_Type) GetCR1_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x700) >> 8
}
func (o *DFSDM_FLT_Type) SetCR1_JDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_FLT_Type) GetCR1_JDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *DFSDM_FLT_Type) SetCR1_JSCAN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_FLT_Type) GetCR1_JSCAN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *DFSDM_FLT_Type) SetCR1_JSYNC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_FLT_Type) GetCR1_JSYNC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *DFSDM_FLT_Type) SetCR1_JSWSTART(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_FLT_Type) GetCR1_JSWSTART() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *DFSDM_FLT_Type) SetCR1_DFEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *DFSDM_FLT_Type) GetCR1_DFEN() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// DFSDM_FLT.CR2: control register 2
func (o *DFSDM_FLT_Type) SetCR2_AWDCH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_FLT_Type) GetCR2_AWDCH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_FLT_Type) SetCR2_EXCH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_FLT_Type) GetCR2_EXCH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff00) >> 8
}
func (o *DFSDM_FLT_Type) SetCR2_CKABIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_FLT_Type) GetCR2_CKABIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *DFSDM_FLT_Type) SetCR2_SCDIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_FLT_Type) GetCR2_SCDIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *DFSDM_FLT_Type) SetCR2_AWDIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_FLT_Type) GetCR2_AWDIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *DFSDM_FLT_Type) SetCR2_ROVRIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_FLT_Type) GetCR2_ROVRIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *DFSDM_FLT_Type) SetCR2_JOVRIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_FLT_Type) GetCR2_JOVRIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *DFSDM_FLT_Type) SetCR2_REOCIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_FLT_Type) GetCR2_REOCIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *DFSDM_FLT_Type) SetCR2_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *DFSDM_FLT_Type) GetCR2_JEOCIE() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// DFSDM_FLT.ISR: interrupt and status register
func (o *DFSDM_FLT_Type) SetISR_SCDF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xff000000)|value<<24)
}
func (o *DFSDM_FLT_Type) GetISR_SCDF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xff000000) >> 24
}
func (o *DFSDM_FLT_Type) SetISR_CKABF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_FLT_Type) GetISR_CKABF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_FLT_Type) SetISR_RCIP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *DFSDM_FLT_Type) GetISR_RCIP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *DFSDM_FLT_Type) SetISR_JCIP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *DFSDM_FLT_Type) GetISR_JCIP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *DFSDM_FLT_Type) SetISR_AWDF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_FLT_Type) GetISR_AWDF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *DFSDM_FLT_Type) SetISR_ROVRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_FLT_Type) GetISR_ROVRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *DFSDM_FLT_Type) SetISR_JOVRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_FLT_Type) GetISR_JOVRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *DFSDM_FLT_Type) SetISR_REOCF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_FLT_Type) GetISR_REOCF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DFSDM_FLT_Type) SetISR_JEOCF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DFSDM_FLT_Type) GetISR_JEOCF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// DFSDM_FLT.ICR: interrupt flag clear register
func (o *DFSDM_FLT_Type) SetICR_CLRSCDF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xff000000)|value<<24)
}
func (o *DFSDM_FLT_Type) GetICR_CLRSCDF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0xff000000) >> 24
}
func (o *DFSDM_FLT_Type) SetICR_CLRCKABF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_FLT_Type) GetICR_CLRCKABF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_FLT_Type) SetICR_CLRROVRF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_FLT_Type) GetICR_CLRROVRF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *DFSDM_FLT_Type) SetICR_CLRJOVRF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_FLT_Type) GetICR_CLRJOVRF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}

// DFSDM_FLT.JCHGR: injected channel group selection register
func (o *DFSDM_FLT_Type) SetJCHGR_JCHG(value uint32) {
	volatile.StoreUint32(&o.JCHGR.Reg, volatile.LoadUint32(&o.JCHGR.Reg)&^(0xff)|value)
}
func (o *DFSDM_FLT_Type) GetJCHGR_JCHG() uint32 {
	return volatile.LoadUint32(&o.JCHGR.Reg) & 0xff
}

// DFSDM_FLT.FCR: filter control register
func (o *DFSDM_FLT_Type) SetFCR_FORD(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xe0000000)|value<<29)
}
func (o *DFSDM_FLT_Type) GetFCR_FORD() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0xe0000000) >> 29
}
func (o *DFSDM_FLT_Type) SetFCR_FOSR(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DFSDM_FLT_Type) GetFCR_FOSR() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x3ff0000) >> 16
}
func (o *DFSDM_FLT_Type) SetFCR_IOSR(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xff)|value)
}
func (o *DFSDM_FLT_Type) GetFCR_IOSR() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0xff
}

// DFSDM_FLT.JDATAR: data register for injected group
func (o *DFSDM_FLT_Type) SetJDATAR_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDATAR.Reg, volatile.LoadUint32(&o.JDATAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_FLT_Type) GetJDATAR_JDATA() uint32 {
	return (volatile.LoadUint32(&o.JDATAR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_FLT_Type) SetJDATAR_JDATACH(value uint32) {
	volatile.StoreUint32(&o.JDATAR.Reg, volatile.LoadUint32(&o.JDATAR.Reg)&^(0x7)|value)
}
func (o *DFSDM_FLT_Type) GetJDATAR_JDATACH() uint32 {
	return volatile.LoadUint32(&o.JDATAR.Reg) & 0x7
}

// DFSDM_FLT.RDATAR: data register for the regular channel
func (o *DFSDM_FLT_Type) SetRDATAR_RDATA(value uint32) {
	volatile.StoreUint32(&o.RDATAR.Reg, volatile.LoadUint32(&o.RDATAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_FLT_Type) GetRDATAR_RDATA() uint32 {
	return (volatile.LoadUint32(&o.RDATAR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_FLT_Type) SetRDATAR_RPEND(value uint32) {
	volatile.StoreUint32(&o.RDATAR.Reg, volatile.LoadUint32(&o.RDATAR.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_FLT_Type) GetRDATAR_RPEND() uint32 {
	return (volatile.LoadUint32(&o.RDATAR.Reg) & 0x10) >> 4
}
func (o *DFSDM_FLT_Type) SetRDATAR_RDATACH(value uint32) {
	volatile.StoreUint32(&o.RDATAR.Reg, volatile.LoadUint32(&o.RDATAR.Reg)&^(0x7)|value)
}
func (o *DFSDM_FLT_Type) GetRDATAR_RDATACH() uint32 {
	return volatile.LoadUint32(&o.RDATAR.Reg) & 0x7
}

// DFSDM_FLT.AWHTR: analog watchdog high threshold register
func (o *DFSDM_FLT_Type) SetAWHTR_AWHT(value uint32) {
	volatile.StoreUint32(&o.AWHTR.Reg, volatile.LoadUint32(&o.AWHTR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_FLT_Type) GetAWHTR_AWHT() uint32 {
	return (volatile.LoadUint32(&o.AWHTR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_FLT_Type) SetAWHTR_BKAWH(value uint32) {
	volatile.StoreUint32(&o.AWHTR.Reg, volatile.LoadUint32(&o.AWHTR.Reg)&^(0xf)|value)
}
func (o *DFSDM_FLT_Type) GetAWHTR_BKAWH() uint32 {
	return volatile.LoadUint32(&o.AWHTR.Reg) & 0xf
}

// DFSDM_FLT.AWLTR: analog watchdog low threshold register
func (o *DFSDM_FLT_Type) SetAWLTR_AWLT(value uint32) {
	volatile.StoreUint32(&o.AWLTR.Reg, volatile.LoadUint32(&o.AWLTR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_FLT_Type) GetAWLTR_AWLT() uint32 {
	return (volatile.LoadUint32(&o.AWLTR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_FLT_Type) SetAWLTR_BKAWL(value uint32) {
	volatile.StoreUint32(&o.AWLTR.Reg, volatile.LoadUint32(&o.AWLTR.Reg)&^(0xf)|value)
}
func (o *DFSDM_FLT_Type) GetAWLTR_BKAWL() uint32 {
	return volatile.LoadUint32(&o.AWLTR.Reg) & 0xf
}

// DFSDM_FLT.AWSR: analog watchdog status register
func (o *DFSDM_FLT_Type) SetAWSR_AWHTF(value uint32) {
	volatile.StoreUint32(&o.AWSR.Reg, volatile.LoadUint32(&o.AWSR.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_FLT_Type) GetAWSR_AWHTF() uint32 {
	return (volatile.LoadUint32(&o.AWSR.Reg) & 0xff00) >> 8
}
func (o *DFSDM_FLT_Type) SetAWSR_AWLTF(value uint32) {
	volatile.StoreUint32(&o.AWSR.Reg, volatile.LoadUint32(&o.AWSR.Reg)&^(0xff)|value)
}
func (o *DFSDM_FLT_Type) GetAWSR_AWLTF() uint32 {
	return volatile.LoadUint32(&o.AWSR.Reg) & 0xff
}

// DFSDM_FLT.AWCFR: analog watchdog clear flag register
func (o *DFSDM_FLT_Type) SetAWCFR_CLRAWHTF(value uint32) {
	volatile.StoreUint32(&o.AWCFR.Reg, volatile.LoadUint32(&o.AWCFR.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_FLT_Type) GetAWCFR_CLRAWHTF() uint32 {
	return (volatile.LoadUint32(&o.AWCFR.Reg) & 0xff00) >> 8
}
func (o *DFSDM_FLT_Type) SetAWCFR_CLRAWLTF(value uint32) {
	volatile.StoreUint32(&o.AWCFR.Reg, volatile.LoadUint32(&o.AWCFR.Reg)&^(0xff)|value)
}
func (o *DFSDM_FLT_Type) GetAWCFR_CLRAWLTF() uint32 {
	return volatile.LoadUint32(&o.AWCFR.Reg) & 0xff
}

// DFSDM_FLT.EXMAX: Extremes detector maximum register
func (o *DFSDM_FLT_Type) SetEXMAX(value uint32) {
	volatile.StoreUint32(&o.EXMAX.Reg, volatile.LoadUint32(&o.EXMAX.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_FLT_Type) GetEXMAX() uint32 {
	return (volatile.LoadUint32(&o.EXMAX.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_FLT_Type) SetEXMAX_EXMAXCH(value uint32) {
	volatile.StoreUint32(&o.EXMAX.Reg, volatile.LoadUint32(&o.EXMAX.Reg)&^(0x7)|value)
}
func (o *DFSDM_FLT_Type) GetEXMAX_EXMAXCH() uint32 {
	return volatile.LoadUint32(&o.EXMAX.Reg) & 0x7
}

// DFSDM_FLT.EXMIN: Extremes detector minimum register
func (o *DFSDM_FLT_Type) SetEXMIN(value uint32) {
	volatile.StoreUint32(&o.EXMIN.Reg, volatile.LoadUint32(&o.EXMIN.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_FLT_Type) GetEXMIN() uint32 {
	return (volatile.LoadUint32(&o.EXMIN.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_FLT_Type) SetEXMIN_EXMINCH(value uint32) {
	volatile.StoreUint32(&o.EXMIN.Reg, volatile.LoadUint32(&o.EXMIN.Reg)&^(0x7)|value)
}
func (o *DFSDM_FLT_Type) GetEXMIN_EXMINCH() uint32 {
	return volatile.LoadUint32(&o.EXMIN.Reg) & 0x7
}

// DFSDM_FLT.FLTCNVTIMR: conversion timer register
func (o *DFSDM_FLT_Type) SetFLTCNVTIMR_CNVCNT(value uint32) {
	volatile.StoreUint32(&o.FLTCNVTIMR.Reg, volatile.LoadUint32(&o.FLTCNVTIMR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *DFSDM_FLT_Type) GetFLTCNVTIMR_CNVCNT() uint32 {
	return (volatile.LoadUint32(&o.FLTCNVTIMR.Reg) & 0xfffffff0) >> 4
}

// DMA controller
type DMA_Type struct {
	LISR  volatile.Register32 // 0x0
	HISR  volatile.Register32 // 0x4
	LIFCR volatile.Register32 // 0x8
	HIFCR volatile.Register32 // 0xC
	ST    [8]DMA_ST_Type      // 0x10
}

// DMA.LISR: low interrupt status register
func (o *DMA_Type) SetLISR_TCIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetLISR_TCIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetLISR_HTIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetLISR_HTIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetLISR_TEIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetLISR_TEIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetLISR_DMEIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetLISR_DMEIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetLISR_FEIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetLISR_FEIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetLISR_TCIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetLISR_TCIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetLISR_HTIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetLISR_HTIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetLISR_TEIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetLISR_TEIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetLISR_DMEIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetLISR_DMEIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetLISR_FEIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetLISR_FEIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetLISR_TCIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetLISR_TCIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetLISR_HTIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetLISR_HTIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetLISR_TEIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetLISR_TEIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetLISR_DMEIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetLISR_DMEIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetLISR_FEIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetLISR_FEIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetLISR_TCIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetLISR_TCIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetLISR_HTIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetLISR_HTIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetLISR_TEIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetLISR_TEIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetLISR_DMEIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetLISR_DMEIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetLISR_FEIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetLISR_FEIF0() uint32 {
	return volatile.LoadUint32(&o.LISR.Reg) & 0x1
}

// DMA.HISR: high interrupt status register
func (o *DMA_Type) SetHISR_TCIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetHISR_TCIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetHISR_HTIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetHISR_HTIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetHISR_TEIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetHISR_TEIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetHISR_DMEIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetHISR_DMEIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetHISR_FEIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetHISR_FEIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetHISR_TCIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetHISR_TCIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetHISR_HTIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetHISR_HTIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetHISR_TEIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetHISR_TEIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetHISR_DMEIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetHISR_DMEIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetHISR_FEIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetHISR_FEIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetHISR_TCIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetHISR_TCIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetHISR_HTIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetHISR_HTIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetHISR_TEIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetHISR_TEIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetHISR_DMEIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetHISR_DMEIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetHISR_FEIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetHISR_FEIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetHISR_TCIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetHISR_TCIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetHISR_HTIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetHISR_HTIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetHISR_TEIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetHISR_TEIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetHISR_DMEIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetHISR_DMEIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetHISR_FEIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetHISR_FEIF4() uint32 {
	return volatile.LoadUint32(&o.HISR.Reg) & 0x1
}

// DMA.LIFCR: low interrupt flag clear register
func (o *DMA_Type) SetLIFCR_CTCIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetLIFCR_CTCIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetLIFCR_CHTIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetLIFCR_CHTIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetLIFCR_CTEIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetLIFCR_CTEIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetLIFCR_CDMEIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetLIFCR_CDMEIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetLIFCR_CFEIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetLIFCR_CFEIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetLIFCR_CTCIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetLIFCR_CTCIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetLIFCR_CHTIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetLIFCR_CHTIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetLIFCR_CTEIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetLIFCR_CTEIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetLIFCR_CDMEIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetLIFCR_CDMEIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetLIFCR_CFEIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetLIFCR_CFEIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetLIFCR_CTCIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetLIFCR_CTCIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetLIFCR_CHTIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetLIFCR_CHTIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetLIFCR_CTEIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetLIFCR_CTEIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetLIFCR_CDMEIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetLIFCR_CDMEIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetLIFCR_CFEIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetLIFCR_CFEIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetLIFCR_CTCIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetLIFCR_CTCIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetLIFCR_CHTIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetLIFCR_CHTIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetLIFCR_CTEIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetLIFCR_CTEIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetLIFCR_CDMEIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetLIFCR_CDMEIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetLIFCR_CFEIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetLIFCR_CFEIF0() uint32 {
	return volatile.LoadUint32(&o.LIFCR.Reg) & 0x1
}
func (o *DMA_Type) SetLIFCR_TRBUFF(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetLIFCR_TRBUFF() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x100000) >> 20
}

// DMA.HIFCR: high interrupt flag clear register
func (o *DMA_Type) SetHIFCR_CTCIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetHIFCR_CTCIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetHIFCR_CHTIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetHIFCR_CHTIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetHIFCR_CTEIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetHIFCR_CTEIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetHIFCR_CDMEIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetHIFCR_CDMEIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetHIFCR_CFEIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetHIFCR_CFEIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetHIFCR_CTCIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetHIFCR_CTCIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetHIFCR_CHTIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetHIFCR_CHTIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetHIFCR_CTEIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetHIFCR_CTEIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetHIFCR_CDMEIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetHIFCR_CDMEIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetHIFCR_CFEIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetHIFCR_CFEIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetHIFCR_CTCIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetHIFCR_CTCIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetHIFCR_CHTIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetHIFCR_CHTIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetHIFCR_CTEIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetHIFCR_CTEIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetHIFCR_CDMEIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetHIFCR_CDMEIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetHIFCR_CFEIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetHIFCR_CFEIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetHIFCR_CTCIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetHIFCR_CTCIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetHIFCR_CHTIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetHIFCR_CHTIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetHIFCR_CTEIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetHIFCR_CTEIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetHIFCR_CDMEIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetHIFCR_CDMEIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetHIFCR_CFEIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetHIFCR_CFEIF4() uint32 {
	return volatile.LoadUint32(&o.HIFCR.Reg) & 0x1
}
func (o *DMA_Type) SetHIFCR_TRBUFF(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetHIFCR_TRBUFF() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x100000) >> 20
}

// Stream cluster: S?CR, S?NDTR, S?M0AR, S?M1AR and S?FCR registers
type DMA_ST_Type struct {
	CR   volatile.Register32 // 0x10
	NDTR volatile.Register32 // 0x14
	PAR  volatile.Register32 // 0x18
	M0AR volatile.Register32 // 0x1C
	M1AR volatile.Register32 // 0x20
	FCR  volatile.Register32 // 0x24
}

// DMA_ST.CR: stream x configuration register
func (o *DMA_ST_Type) SetCR_MBURST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1800000)|value<<23)
}
func (o *DMA_ST_Type) GetCR_MBURST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1800000) >> 23
}
func (o *DMA_ST_Type) SetCR_PBURST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x600000)|value<<21)
}
func (o *DMA_ST_Type) GetCR_PBURST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x600000) >> 21
}
func (o *DMA_ST_Type) SetCR_CT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_ST_Type) GetCR_CT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *DMA_ST_Type) SetCR_DBM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_ST_Type) GetCR_DBM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *DMA_ST_Type) SetCR_PL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_ST_Type) GetCR_PL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30000) >> 16
}
func (o *DMA_ST_Type) SetCR_PINCOS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_ST_Type) GetCR_PINCOS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *DMA_ST_Type) SetCR_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_ST_Type) GetCR_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x6000) >> 13
}
func (o *DMA_ST_Type) SetCR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1800)|value<<11)
}
func (o *DMA_ST_Type) GetCR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1800) >> 11
}
func (o *DMA_ST_Type) SetCR_MINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_ST_Type) GetCR_MINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *DMA_ST_Type) SetCR_PINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_ST_Type) GetCR_PINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *DMA_ST_Type) SetCR_CIRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_ST_Type) GetCR_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *DMA_ST_Type) SetCR_DIR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_ST_Type) GetCR_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}
func (o *DMA_ST_Type) SetCR_PFCTRL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_ST_Type) GetCR_PFCTRL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DMA_ST_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_ST_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DMA_ST_Type) SetCR_HTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_ST_Type) GetCR_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *DMA_ST_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_ST_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DMA_ST_Type) SetCR_DMEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_ST_Type) GetCR_DMEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DMA_ST_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DMA_ST_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DMA_ST_Type) SetCR_TRBUFF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_ST_Type) GetCR_TRBUFF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}

// DMA_ST.NDTR: stream x number of data register
func (o *DMA_ST_Type) SetNDTR_NDT(value uint32) {
	volatile.StoreUint32(&o.NDTR.Reg, volatile.LoadUint32(&o.NDTR.Reg)&^(0xffff)|value)
}
func (o *DMA_ST_Type) GetNDTR_NDT() uint32 {
	return volatile.LoadUint32(&o.NDTR.Reg) & 0xffff
}

// DMA_ST.PAR: stream x peripheral address register
func (o *DMA_ST_Type) SetPAR(value uint32) {
	volatile.StoreUint32(&o.PAR.Reg, value)
}
func (o *DMA_ST_Type) GetPAR() uint32 {
	return volatile.LoadUint32(&o.PAR.Reg)
}

// DMA_ST.M0AR: stream x memory 0 address register
func (o *DMA_ST_Type) SetM0AR(value uint32) {
	volatile.StoreUint32(&o.M0AR.Reg, value)
}
func (o *DMA_ST_Type) GetM0AR() uint32 {
	return volatile.LoadUint32(&o.M0AR.Reg)
}

// DMA_ST.M1AR: stream x memory 1 address register
func (o *DMA_ST_Type) SetM1AR(value uint32) {
	volatile.StoreUint32(&o.M1AR.Reg, value)
}
func (o *DMA_ST_Type) GetM1AR() uint32 {
	return volatile.LoadUint32(&o.M1AR.Reg)
}

// DMA_ST.FCR: stream x FIFO control register
func (o *DMA_ST_Type) SetFCR_FEIE(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_ST_Type) GetFCR_FEIE() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x80) >> 7
}
func (o *DMA_ST_Type) SetFCR_FS(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x38)|value<<3)
}
func (o *DMA_ST_Type) GetFCR_FS() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x38) >> 3
}
func (o *DMA_ST_Type) SetFCR_DMDIS(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_ST_Type) GetFCR_DMDIS() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x4) >> 2
}
func (o *DMA_ST_Type) SetFCR_FTH(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x3)|value)
}
func (o *DMA_ST_Type) GetFCR_FTH() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0x3
}
func (o *DMA_ST_Type) SetFCR_TRBUFF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_ST_Type) GetFCR_TRBUFF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x100000) >> 20
}

// DMA2D
type DMA2D_Type struct {
	CR      volatile.Register32 // 0x0
	ISR     volatile.Register32 // 0x4
	IFCR    volatile.Register32 // 0x8
	FGMAR   volatile.Register32 // 0xC
	FGOR    volatile.Register32 // 0x10
	BGMAR   volatile.Register32 // 0x14
	BGOR    volatile.Register32 // 0x18
	FGPFCCR volatile.Register32 // 0x1C
	FGCOLR  volatile.Register32 // 0x20
	BGPFCCR volatile.Register32 // 0x24
	BGCOLR  volatile.Register32 // 0x28
	FGCMAR  volatile.Register32 // 0x2C
	BGCMAR  volatile.Register32 // 0x30
	OPFCCR  volatile.Register32 // 0x34
	OCOLR   volatile.Register32 // 0x38
	OMAR    volatile.Register32 // 0x3C
	OOR     volatile.Register32 // 0x40
	NLR     volatile.Register32 // 0x44
	LWR     volatile.Register32 // 0x48
	AMTCR   volatile.Register32 // 0x4C
}

// DMA2D.CR: DMA2D control register
func (o *DMA2D_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DMA2D_Type) GetCR_START() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DMA2D_Type) SetCR_SUSP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA2D_Type) GetCR_SUSP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DMA2D_Type) SetCR_ABORT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA2D_Type) GetCR_ABORT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DMA2D_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *DMA2D_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *DMA2D_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *DMA2D_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *DMA2D_Type) SetCR_TWIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *DMA2D_Type) GetCR_TWIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *DMA2D_Type) SetCR_CAEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *DMA2D_Type) GetCR_CAEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *DMA2D_Type) SetCR_CTCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA2D_Type) GetCR_CTCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *DMA2D_Type) SetCR_CEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA2D_Type) GetCR_CEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *DMA2D_Type) SetCR_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA2D_Type) GetCR_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30000) >> 16
}

// DMA2D.ISR: DMA2D Interrupt Status Register
func (o *DMA2D_Type) SetISR_TEIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DMA2D_Type) GetISR_TEIF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *DMA2D_Type) SetISR_TCIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DMA2D_Type) GetISR_TCIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DMA2D_Type) SetISR_TWIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA2D_Type) GetISR_TWIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *DMA2D_Type) SetISR_CAEIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA2D_Type) GetISR_CAEIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *DMA2D_Type) SetISR_CTCIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2D_Type) GetISR_CTCIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *DMA2D_Type) SetISR_CEIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2D_Type) GetISR_CEIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}

// DMA2D.IFCR: DMA2D interrupt flag clear register
func (o *DMA2D_Type) SetIFCR_CTEIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1)|value)
}
func (o *DMA2D_Type) GetIFCR_CTEIF() uint32 {
	return volatile.LoadUint32(&o.IFCR.Reg) & 0x1
}
func (o *DMA2D_Type) SetIFCR_CTCIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2)|value<<1)
}
func (o *DMA2D_Type) GetIFCR_CTCIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2) >> 1
}
func (o *DMA2D_Type) SetIFCR_CTWIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA2D_Type) GetIFCR_CTWIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4) >> 2
}
func (o *DMA2D_Type) SetIFCR_CAECIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA2D_Type) GetIFCR_CAECIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8) >> 3
}
func (o *DMA2D_Type) SetIFCR_CCTCIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2D_Type) GetIFCR_CCTCIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10) >> 4
}
func (o *DMA2D_Type) SetIFCR_CCEIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2D_Type) GetIFCR_CCEIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20) >> 5
}

// DMA2D.FGMAR: DMA2D foreground memory address register
func (o *DMA2D_Type) SetFGMAR(value uint32) {
	volatile.StoreUint32(&o.FGMAR.Reg, value)
}
func (o *DMA2D_Type) GetFGMAR() uint32 {
	return volatile.LoadUint32(&o.FGMAR.Reg)
}

// DMA2D.FGOR: DMA2D foreground offset register
func (o *DMA2D_Type) SetFGOR_LO(value uint32) {
	volatile.StoreUint32(&o.FGOR.Reg, volatile.LoadUint32(&o.FGOR.Reg)&^(0xffff)|value)
}
func (o *DMA2D_Type) GetFGOR_LO() uint32 {
	return volatile.LoadUint32(&o.FGOR.Reg) & 0xffff
}

// DMA2D.BGMAR: DMA2D background memory address register
func (o *DMA2D_Type) SetBGMAR(value uint32) {
	volatile.StoreUint32(&o.BGMAR.Reg, value)
}
func (o *DMA2D_Type) GetBGMAR() uint32 {
	return volatile.LoadUint32(&o.BGMAR.Reg)
}

// DMA2D.BGOR: DMA2D background offset register
func (o *DMA2D_Type) SetBGOR_LO(value uint32) {
	volatile.StoreUint32(&o.BGOR.Reg, volatile.LoadUint32(&o.BGOR.Reg)&^(0xffff)|value)
}
func (o *DMA2D_Type) GetBGOR_LO() uint32 {
	return volatile.LoadUint32(&o.BGOR.Reg) & 0xffff
}

// DMA2D.FGPFCCR: DMA2D foreground PFC control register
func (o *DMA2D_Type) SetFGPFCCR_CM(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0xf)|value)
}
func (o *DMA2D_Type) GetFGPFCCR_CM() uint32 {
	return volatile.LoadUint32(&o.FGPFCCR.Reg) & 0xf
}
func (o *DMA2D_Type) SetFGPFCCR_CCM(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2D_Type) GetFGPFCCR_CCM() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0x10) >> 4
}
func (o *DMA2D_Type) SetFGPFCCR_START(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2D_Type) GetFGPFCCR_START() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0x20) >> 5
}
func (o *DMA2D_Type) SetFGPFCCR_CS(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetFGPFCCR_CS() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetFGPFCCR_AM(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA2D_Type) GetFGPFCCR_AM() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0x30000) >> 16
}
func (o *DMA2D_Type) SetFGPFCCR_CSS(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA2D_Type) GetFGPFCCR_CSS() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0xc0000) >> 18
}
func (o *DMA2D_Type) SetFGPFCCR_AI(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA2D_Type) GetFGPFCCR_AI() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0x100000) >> 20
}
func (o *DMA2D_Type) SetFGPFCCR_RBS(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA2D_Type) GetFGPFCCR_RBS() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0x200000) >> 21
}
func (o *DMA2D_Type) SetFGPFCCR_ALPHA(value uint32) {
	volatile.StoreUint32(&o.FGPFCCR.Reg, volatile.LoadUint32(&o.FGPFCCR.Reg)&^(0xff000000)|value<<24)
}
func (o *DMA2D_Type) GetFGPFCCR_ALPHA() uint32 {
	return (volatile.LoadUint32(&o.FGPFCCR.Reg) & 0xff000000) >> 24
}

// DMA2D.FGCOLR: DMA2D foreground color register
func (o *DMA2D_Type) SetFGCOLR_BLUE(value uint32) {
	volatile.StoreUint32(&o.FGCOLR.Reg, volatile.LoadUint32(&o.FGCOLR.Reg)&^(0xff)|value)
}
func (o *DMA2D_Type) GetFGCOLR_BLUE() uint32 {
	return volatile.LoadUint32(&o.FGCOLR.Reg) & 0xff
}
func (o *DMA2D_Type) SetFGCOLR_GREEN(value uint32) {
	volatile.StoreUint32(&o.FGCOLR.Reg, volatile.LoadUint32(&o.FGCOLR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetFGCOLR_GREEN() uint32 {
	return (volatile.LoadUint32(&o.FGCOLR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetFGCOLR_RED(value uint32) {
	volatile.StoreUint32(&o.FGCOLR.Reg, volatile.LoadUint32(&o.FGCOLR.Reg)&^(0xff0000)|value<<16)
}
func (o *DMA2D_Type) GetFGCOLR_RED() uint32 {
	return (volatile.LoadUint32(&o.FGCOLR.Reg) & 0xff0000) >> 16
}

// DMA2D.BGPFCCR: DMA2D background PFC control register
func (o *DMA2D_Type) SetBGPFCCR_CM(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0xf)|value)
}
func (o *DMA2D_Type) GetBGPFCCR_CM() uint32 {
	return volatile.LoadUint32(&o.BGPFCCR.Reg) & 0xf
}
func (o *DMA2D_Type) SetBGPFCCR_CCM(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA2D_Type) GetBGPFCCR_CCM() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0x10) >> 4
}
func (o *DMA2D_Type) SetBGPFCCR_START(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA2D_Type) GetBGPFCCR_START() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0x20) >> 5
}
func (o *DMA2D_Type) SetBGPFCCR_CS(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetBGPFCCR_CS() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetBGPFCCR_AM(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA2D_Type) GetBGPFCCR_AM() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0x30000) >> 16
}
func (o *DMA2D_Type) SetBGPFCCR_AI(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA2D_Type) GetBGPFCCR_AI() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0x100000) >> 20
}
func (o *DMA2D_Type) SetBGPFCCR_RBS(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA2D_Type) GetBGPFCCR_RBS() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0x200000) >> 21
}
func (o *DMA2D_Type) SetBGPFCCR_ALPHA(value uint32) {
	volatile.StoreUint32(&o.BGPFCCR.Reg, volatile.LoadUint32(&o.BGPFCCR.Reg)&^(0xff000000)|value<<24)
}
func (o *DMA2D_Type) GetBGPFCCR_ALPHA() uint32 {
	return (volatile.LoadUint32(&o.BGPFCCR.Reg) & 0xff000000) >> 24
}

// DMA2D.BGCOLR: DMA2D background color register
func (o *DMA2D_Type) SetBGCOLR_BLUE(value uint32) {
	volatile.StoreUint32(&o.BGCOLR.Reg, volatile.LoadUint32(&o.BGCOLR.Reg)&^(0xff)|value)
}
func (o *DMA2D_Type) GetBGCOLR_BLUE() uint32 {
	return volatile.LoadUint32(&o.BGCOLR.Reg) & 0xff
}
func (o *DMA2D_Type) SetBGCOLR_GREEN(value uint32) {
	volatile.StoreUint32(&o.BGCOLR.Reg, volatile.LoadUint32(&o.BGCOLR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetBGCOLR_GREEN() uint32 {
	return (volatile.LoadUint32(&o.BGCOLR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetBGCOLR_RED(value uint32) {
	volatile.StoreUint32(&o.BGCOLR.Reg, volatile.LoadUint32(&o.BGCOLR.Reg)&^(0xff0000)|value<<16)
}
func (o *DMA2D_Type) GetBGCOLR_RED() uint32 {
	return (volatile.LoadUint32(&o.BGCOLR.Reg) & 0xff0000) >> 16
}

// DMA2D.FGCMAR: DMA2D foreground CLUT memory address register
func (o *DMA2D_Type) SetFGCMAR(value uint32) {
	volatile.StoreUint32(&o.FGCMAR.Reg, value)
}
func (o *DMA2D_Type) GetFGCMAR() uint32 {
	return volatile.LoadUint32(&o.FGCMAR.Reg)
}

// DMA2D.BGCMAR: DMA2D background CLUT memory address register
func (o *DMA2D_Type) SetBGCMAR(value uint32) {
	volatile.StoreUint32(&o.BGCMAR.Reg, value)
}
func (o *DMA2D_Type) GetBGCMAR() uint32 {
	return volatile.LoadUint32(&o.BGCMAR.Reg)
}

// DMA2D.OPFCCR: DMA2D output PFC control register
func (o *DMA2D_Type) SetOPFCCR_CM(value uint32) {
	volatile.StoreUint32(&o.OPFCCR.Reg, volatile.LoadUint32(&o.OPFCCR.Reg)&^(0x7)|value)
}
func (o *DMA2D_Type) GetOPFCCR_CM() uint32 {
	return volatile.LoadUint32(&o.OPFCCR.Reg) & 0x7
}
func (o *DMA2D_Type) SetOPFCCR_AI(value uint32) {
	volatile.StoreUint32(&o.OPFCCR.Reg, volatile.LoadUint32(&o.OPFCCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA2D_Type) GetOPFCCR_AI() uint32 {
	return (volatile.LoadUint32(&o.OPFCCR.Reg) & 0x100000) >> 20
}
func (o *DMA2D_Type) SetOPFCCR_RBS(value uint32) {
	volatile.StoreUint32(&o.OPFCCR.Reg, volatile.LoadUint32(&o.OPFCCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA2D_Type) GetOPFCCR_RBS() uint32 {
	return (volatile.LoadUint32(&o.OPFCCR.Reg) & 0x200000) >> 21
}
func (o *DMA2D_Type) SetOPFCCR_SB(value uint32) {
	volatile.StoreUint32(&o.OPFCCR.Reg, volatile.LoadUint32(&o.OPFCCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA2D_Type) GetOPFCCR_SB() uint32 {
	return (volatile.LoadUint32(&o.OPFCCR.Reg) & 0x100) >> 8
}

// DMA2D.OCOLR: DMA2D output color register
func (o *DMA2D_Type) SetOCOLR_BLUE(value uint32) {
	volatile.StoreUint32(&o.OCOLR.Reg, volatile.LoadUint32(&o.OCOLR.Reg)&^(0xff)|value)
}
func (o *DMA2D_Type) GetOCOLR_BLUE() uint32 {
	return volatile.LoadUint32(&o.OCOLR.Reg) & 0xff
}
func (o *DMA2D_Type) SetOCOLR_GREEN(value uint32) {
	volatile.StoreUint32(&o.OCOLR.Reg, volatile.LoadUint32(&o.OCOLR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetOCOLR_GREEN() uint32 {
	return (volatile.LoadUint32(&o.OCOLR.Reg) & 0xff00) >> 8
}
func (o *DMA2D_Type) SetOCOLR_RED(value uint32) {
	volatile.StoreUint32(&o.OCOLR.Reg, volatile.LoadUint32(&o.OCOLR.Reg)&^(0xff0000)|value<<16)
}
func (o *DMA2D_Type) GetOCOLR_RED() uint32 {
	return (volatile.LoadUint32(&o.OCOLR.Reg) & 0xff0000) >> 16
}
func (o *DMA2D_Type) SetOCOLR_ALPHA(value uint32) {
	volatile.StoreUint32(&o.OCOLR.Reg, volatile.LoadUint32(&o.OCOLR.Reg)&^(0xff000000)|value<<24)
}
func (o *DMA2D_Type) GetOCOLR_ALPHA() uint32 {
	return (volatile.LoadUint32(&o.OCOLR.Reg) & 0xff000000) >> 24
}

// DMA2D.OMAR: DMA2D output memory address register
func (o *DMA2D_Type) SetOMAR(value uint32) {
	volatile.StoreUint32(&o.OMAR.Reg, value)
}
func (o *DMA2D_Type) GetOMAR() uint32 {
	return volatile.LoadUint32(&o.OMAR.Reg)
}

// DMA2D.OOR: DMA2D output offset register
func (o *DMA2D_Type) SetOOR_LO(value uint32) {
	volatile.StoreUint32(&o.OOR.Reg, volatile.LoadUint32(&o.OOR.Reg)&^(0xffff)|value)
}
func (o *DMA2D_Type) GetOOR_LO() uint32 {
	return volatile.LoadUint32(&o.OOR.Reg) & 0xffff
}

// DMA2D.NLR: DMA2D number of line register
func (o *DMA2D_Type) SetNLR_NL(value uint32) {
	volatile.StoreUint32(&o.NLR.Reg, volatile.LoadUint32(&o.NLR.Reg)&^(0xffff)|value)
}
func (o *DMA2D_Type) GetNLR_NL() uint32 {
	return volatile.LoadUint32(&o.NLR.Reg) & 0xffff
}
func (o *DMA2D_Type) SetNLR_PL(value uint32) {
	volatile.StoreUint32(&o.NLR.Reg, volatile.LoadUint32(&o.NLR.Reg)&^(0x3fff0000)|value<<16)
}
func (o *DMA2D_Type) GetNLR_PL() uint32 {
	return (volatile.LoadUint32(&o.NLR.Reg) & 0x3fff0000) >> 16
}

// DMA2D.LWR: DMA2D line watermark register
func (o *DMA2D_Type) SetLWR_LW(value uint32) {
	volatile.StoreUint32(&o.LWR.Reg, volatile.LoadUint32(&o.LWR.Reg)&^(0xffff)|value)
}
func (o *DMA2D_Type) GetLWR_LW() uint32 {
	return volatile.LoadUint32(&o.LWR.Reg) & 0xffff
}

// DMA2D.AMTCR: DMA2D AXI master timer configuration register
func (o *DMA2D_Type) SetAMTCR_EN(value uint32) {
	volatile.StoreUint32(&o.AMTCR.Reg, volatile.LoadUint32(&o.AMTCR.Reg)&^(0x1)|value)
}
func (o *DMA2D_Type) GetAMTCR_EN() uint32 {
	return volatile.LoadUint32(&o.AMTCR.Reg) & 0x1
}
func (o *DMA2D_Type) SetAMTCR_DT(value uint32) {
	volatile.StoreUint32(&o.AMTCR.Reg, volatile.LoadUint32(&o.AMTCR.Reg)&^(0xff00)|value<<8)
}
func (o *DMA2D_Type) GetAMTCR_DT() uint32 {
	return (volatile.LoadUint32(&o.AMTCR.Reg) & 0xff00) >> 8
}

// DMAMUX
type DMAMUX_Type struct {
	CCR0  volatile.Register32 // 0x0
	CCR1  volatile.Register32 // 0x4
	CCR2  volatile.Register32 // 0x8
	CCR3  volatile.Register32 // 0xC
	CCR4  volatile.Register32 // 0x10
	CCR5  volatile.Register32 // 0x14
	CCR6  volatile.Register32 // 0x18
	CCR7  volatile.Register32 // 0x1C
	CCR8  volatile.Register32 // 0x20
	CCR9  volatile.Register32 // 0x24
	CCR10 volatile.Register32 // 0x28
	CCR11 volatile.Register32 // 0x2C
	CCR12 volatile.Register32 // 0x30
	CCR13 volatile.Register32 // 0x34
	CCR14 volatile.Register32 // 0x38
	CCR15 volatile.Register32 // 0x3C
	_     [64]byte
	CSR   volatile.Register32 // 0x80
	CFR   volatile.Register32 // 0x84
	_     [120]byte
	RGCR0 volatile.Register32 // 0x100
	RGCR1 volatile.Register32 // 0x104
	RGCR2 volatile.Register32 // 0x108
	RGCR3 volatile.Register32 // 0x10C
	RGCR4 volatile.Register32 // 0x110
	RGCR5 volatile.Register32 // 0x114
	RGCR6 volatile.Register32 // 0x118
	RGCR7 volatile.Register32 // 0x11C
	_     [32]byte
	RGSR  volatile.Register32 // 0x140
	RGCFR volatile.Register32 // 0x144
}

// DMAMUX.CCR0: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR0_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR0_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR0.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR0_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR0_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR0_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR0_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR0_SE(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR0_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR0_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR0_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR0_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR0_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR0_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR0_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR1: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR1_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR1_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR1_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR1_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR1_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR1_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR1_SE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR1_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR1_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR1_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR1_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR1_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR1_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR1_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR2: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR2_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR2_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR2_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR2_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR2_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR2_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR2_SE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR2_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR2_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR2_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR2_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR2_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR2_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR2_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR3: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR3_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR3_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR3.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR3_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR3_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR3_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR3_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR3_SE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR3_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR3_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR3_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR3_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR3_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR3_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR3_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR4: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR4_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR4_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR4.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR4_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR4_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR4_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR4_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR4_SE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR4_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR4_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR4_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR4_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR4_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR4_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR4_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR5: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR5_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR5_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR5.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR5_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR5_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR5_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR5_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR5_SE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR5_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR5_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR5_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR5_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR5_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR5_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR5_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR6: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR6_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR6_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR6.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR6_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR6_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR6_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR6_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR6_SE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR6_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR6_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR6_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR6_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR6_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR6_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR6_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR7: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR7_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR7_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR7.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR7_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR7_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR7_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR7_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR7_SE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR7_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR7_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR7_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR7_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR7_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR7_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR7_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR8: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR8_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR8.Reg, volatile.LoadUint32(&o.CCR8.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR8_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR8.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR8_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR8.Reg, volatile.LoadUint32(&o.CCR8.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR8_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR8.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR8_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR8.Reg, volatile.LoadUint32(&o.CCR8.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR8_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR8.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR8_SE(value uint32) {
	volatile.StoreUint32(&o.CCR8.Reg, volatile.LoadUint32(&o.CCR8.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR8_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR8.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR8_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR8.Reg, volatile.LoadUint32(&o.CCR8.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR8_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR8.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR8_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR8.Reg, volatile.LoadUint32(&o.CCR8.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR8_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR8.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR8_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR8.Reg, volatile.LoadUint32(&o.CCR8.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR8_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR8.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR9: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR9_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR9.Reg, volatile.LoadUint32(&o.CCR9.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR9_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR9.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR9_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR9.Reg, volatile.LoadUint32(&o.CCR9.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR9_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR9.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR9_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR9.Reg, volatile.LoadUint32(&o.CCR9.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR9_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR9.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR9_SE(value uint32) {
	volatile.StoreUint32(&o.CCR9.Reg, volatile.LoadUint32(&o.CCR9.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR9_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR9.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR9_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR9.Reg, volatile.LoadUint32(&o.CCR9.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR9_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR9.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR9_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR9.Reg, volatile.LoadUint32(&o.CCR9.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR9_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR9.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR9_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR9.Reg, volatile.LoadUint32(&o.CCR9.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR9_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR9.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR10: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR10_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR10.Reg, volatile.LoadUint32(&o.CCR10.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR10_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR10.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR10_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR10.Reg, volatile.LoadUint32(&o.CCR10.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR10_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR10.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR10_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR10.Reg, volatile.LoadUint32(&o.CCR10.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR10_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR10.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR10_SE(value uint32) {
	volatile.StoreUint32(&o.CCR10.Reg, volatile.LoadUint32(&o.CCR10.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR10_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR10.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR10_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR10.Reg, volatile.LoadUint32(&o.CCR10.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR10_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR10.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR10_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR10.Reg, volatile.LoadUint32(&o.CCR10.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR10_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR10.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR10_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR10.Reg, volatile.LoadUint32(&o.CCR10.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR10_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR10.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR11: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR11_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR11.Reg, volatile.LoadUint32(&o.CCR11.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR11_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR11.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR11_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR11.Reg, volatile.LoadUint32(&o.CCR11.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR11_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR11.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR11_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR11.Reg, volatile.LoadUint32(&o.CCR11.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR11_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR11.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR11_SE(value uint32) {
	volatile.StoreUint32(&o.CCR11.Reg, volatile.LoadUint32(&o.CCR11.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR11_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR11.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR11_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR11.Reg, volatile.LoadUint32(&o.CCR11.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR11_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR11.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR11_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR11.Reg, volatile.LoadUint32(&o.CCR11.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR11_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR11.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR11_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR11.Reg, volatile.LoadUint32(&o.CCR11.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR11_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR11.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR12: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR12_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR12.Reg, volatile.LoadUint32(&o.CCR12.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR12_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR12.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR12_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR12.Reg, volatile.LoadUint32(&o.CCR12.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR12_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR12.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR12_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR12.Reg, volatile.LoadUint32(&o.CCR12.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR12_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR12.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR12_SE(value uint32) {
	volatile.StoreUint32(&o.CCR12.Reg, volatile.LoadUint32(&o.CCR12.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR12_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR12.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR12_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR12.Reg, volatile.LoadUint32(&o.CCR12.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR12_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR12.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR12_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR12.Reg, volatile.LoadUint32(&o.CCR12.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR12_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR12.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR12_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR12.Reg, volatile.LoadUint32(&o.CCR12.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR12_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR12.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR13: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR13_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR13.Reg, volatile.LoadUint32(&o.CCR13.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR13_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR13.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR13_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR13.Reg, volatile.LoadUint32(&o.CCR13.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR13_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR13.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR13_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR13.Reg, volatile.LoadUint32(&o.CCR13.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR13_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR13.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR13_SE(value uint32) {
	volatile.StoreUint32(&o.CCR13.Reg, volatile.LoadUint32(&o.CCR13.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR13_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR13.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR13_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR13.Reg, volatile.LoadUint32(&o.CCR13.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR13_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR13.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR13_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR13.Reg, volatile.LoadUint32(&o.CCR13.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR13_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR13.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR13_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR13.Reg, volatile.LoadUint32(&o.CCR13.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR13_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR13.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR14: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR14_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR14.Reg, volatile.LoadUint32(&o.CCR14.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR14_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR14.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR14_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR14.Reg, volatile.LoadUint32(&o.CCR14.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR14_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR14.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR14_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR14.Reg, volatile.LoadUint32(&o.CCR14.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR14_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR14.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR14_SE(value uint32) {
	volatile.StoreUint32(&o.CCR14.Reg, volatile.LoadUint32(&o.CCR14.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR14_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR14.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR14_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR14.Reg, volatile.LoadUint32(&o.CCR14.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR14_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR14.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR14_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR14.Reg, volatile.LoadUint32(&o.CCR14.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR14_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR14.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR14_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR14.Reg, volatile.LoadUint32(&o.CCR14.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR14_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR14.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CCR15: DMAMux - DMA request line multiplexer channel x control register
func (o *DMAMUX_Type) SetCCR15_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.CCR15.Reg, volatile.LoadUint32(&o.CCR15.Reg)&^(0xff)|value)
}
func (o *DMAMUX_Type) GetCCR15_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.CCR15.Reg) & 0xff
}
func (o *DMAMUX_Type) SetCCR15_SOIE(value uint32) {
	volatile.StoreUint32(&o.CCR15.Reg, volatile.LoadUint32(&o.CCR15.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCR15_SOIE() uint32 {
	return (volatile.LoadUint32(&o.CCR15.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCR15_EGE(value uint32) {
	volatile.StoreUint32(&o.CCR15.Reg, volatile.LoadUint32(&o.CCR15.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCR15_EGE() uint32 {
	return (volatile.LoadUint32(&o.CCR15.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCR15_SE(value uint32) {
	volatile.StoreUint32(&o.CCR15.Reg, volatile.LoadUint32(&o.CCR15.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetCCR15_SE() uint32 {
	return (volatile.LoadUint32(&o.CCR15.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetCCR15_SPOL(value uint32) {
	volatile.StoreUint32(&o.CCR15.Reg, volatile.LoadUint32(&o.CCR15.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetCCR15_SPOL() uint32 {
	return (volatile.LoadUint32(&o.CCR15.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetCCR15_NBREQ(value uint32) {
	volatile.StoreUint32(&o.CCR15.Reg, volatile.LoadUint32(&o.CCR15.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetCCR15_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.CCR15.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetCCR15_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.CCR15.Reg, volatile.LoadUint32(&o.CCR15.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetCCR15_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.CCR15.Reg) & 0x1f000000) >> 24
}

// DMAMUX.CSR: DMAMUX request line multiplexer interrupt channel status register
func (o *DMAMUX_Type) SetCSR_SOF0(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetCSR_SOF0() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetCSR_SOF1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetCSR_SOF1() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetCSR_SOF2(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetCSR_SOF2() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetCSR_SOF3(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetCSR_SOF3() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *DMAMUX_Type) SetCSR_SOF4(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMAMUX_Type) GetCSR_SOF4() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10) >> 4
}
func (o *DMAMUX_Type) SetCSR_SOF5(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMAMUX_Type) GetCSR_SOF5() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20) >> 5
}
func (o *DMAMUX_Type) SetCSR_SOF6(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCSR_SOF6() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCSR_SOF7(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCSR_SOF7() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80) >> 7
}
func (o *DMAMUX_Type) SetCSR_SOF8(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCSR_SOF8() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCSR_SOF9(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCSR_SOF9() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCSR_SOF10(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400)|value<<10)
}
func (o *DMAMUX_Type) GetCSR_SOF10() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400) >> 10
}
func (o *DMAMUX_Type) SetCSR_SOF11(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800)|value<<11)
}
func (o *DMAMUX_Type) GetCSR_SOF11() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800) >> 11
}
func (o *DMAMUX_Type) SetCSR_SOF12(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAMUX_Type) GetCSR_SOF12() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000) >> 12
}
func (o *DMAMUX_Type) SetCSR_SOF13(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAMUX_Type) GetCSR_SOF13() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000) >> 13
}
func (o *DMAMUX_Type) SetCSR_SOF14(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4000)|value<<14)
}
func (o *DMAMUX_Type) GetCSR_SOF14() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4000) >> 14
}
func (o *DMAMUX_Type) SetCSR_SOF15(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8000)|value<<15)
}
func (o *DMAMUX_Type) GetCSR_SOF15() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8000) >> 15
}

// DMAMUX.CFR: DMAMUX request line multiplexer interrupt clear flag register
func (o *DMAMUX_Type) SetCFR_CSOF0(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetCFR_CSOF0() uint32 {
	return volatile.LoadUint32(&o.CFR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetCFR_CSOF1(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetCFR_CSOF1() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetCFR_CSOF2(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetCFR_CSOF2() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetCFR_CSOF3(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetCFR_CSOF3() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x8) >> 3
}
func (o *DMAMUX_Type) SetCFR_CSOF4(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x10)|value<<4)
}
func (o *DMAMUX_Type) GetCFR_CSOF4() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x10) >> 4
}
func (o *DMAMUX_Type) SetCFR_CSOF5(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x20)|value<<5)
}
func (o *DMAMUX_Type) GetCFR_CSOF5() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x20) >> 5
}
func (o *DMAMUX_Type) SetCFR_CSOF6(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCFR_CSOF6() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCFR_CSOF7(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCFR_CSOF7() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x80) >> 7
}
func (o *DMAMUX_Type) SetCFR_CSOF8(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCFR_CSOF8() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCFR_CSOF9(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCFR_CSOF9() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCFR_CSOF10(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x400)|value<<10)
}
func (o *DMAMUX_Type) GetCFR_CSOF10() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x400) >> 10
}
func (o *DMAMUX_Type) SetCFR_CSOF11(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x800)|value<<11)
}
func (o *DMAMUX_Type) GetCFR_CSOF11() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x800) >> 11
}
func (o *DMAMUX_Type) SetCFR_CSOF12(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAMUX_Type) GetCFR_CSOF12() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x1000) >> 12
}
func (o *DMAMUX_Type) SetCFR_CSOF13(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAMUX_Type) GetCFR_CSOF13() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x2000) >> 13
}
func (o *DMAMUX_Type) SetCFR_CSOF14(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x4000)|value<<14)
}
func (o *DMAMUX_Type) GetCFR_CSOF14() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x4000) >> 14
}
func (o *DMAMUX_Type) SetCFR_CSOF15(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x8000)|value<<15)
}
func (o *DMAMUX_Type) GetCFR_CSOF15() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x8000) >> 15
}

// DMAMUX.RGCR0: DMAMux - DMA request generator channel x control register
func (o *DMAMUX_Type) SetRGCR0_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RGCR0.Reg, volatile.LoadUint32(&o.RGCR0.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRGCR0_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RGCR0.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRGCR0_OIE(value uint32) {
	volatile.StoreUint32(&o.RGCR0.Reg, volatile.LoadUint32(&o.RGCR0.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRGCR0_OIE() uint32 {
	return (volatile.LoadUint32(&o.RGCR0.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRGCR0_GE(value uint32) {
	volatile.StoreUint32(&o.RGCR0.Reg, volatile.LoadUint32(&o.RGCR0.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRGCR0_GE() uint32 {
	return (volatile.LoadUint32(&o.RGCR0.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRGCR0_GPOL(value uint32) {
	volatile.StoreUint32(&o.RGCR0.Reg, volatile.LoadUint32(&o.RGCR0.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRGCR0_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RGCR0.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRGCR0_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RGCR0.Reg, volatile.LoadUint32(&o.RGCR0.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRGCR0_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RGCR0.Reg) & 0xf80000) >> 19
}

// DMAMUX.RGCR1: DMAMux - DMA request generator channel x control register
func (o *DMAMUX_Type) SetRGCR1_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RGCR1.Reg, volatile.LoadUint32(&o.RGCR1.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRGCR1_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RGCR1.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRGCR1_OIE(value uint32) {
	volatile.StoreUint32(&o.RGCR1.Reg, volatile.LoadUint32(&o.RGCR1.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRGCR1_OIE() uint32 {
	return (volatile.LoadUint32(&o.RGCR1.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRGCR1_GE(value uint32) {
	volatile.StoreUint32(&o.RGCR1.Reg, volatile.LoadUint32(&o.RGCR1.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRGCR1_GE() uint32 {
	return (volatile.LoadUint32(&o.RGCR1.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRGCR1_GPOL(value uint32) {
	volatile.StoreUint32(&o.RGCR1.Reg, volatile.LoadUint32(&o.RGCR1.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRGCR1_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RGCR1.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRGCR1_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RGCR1.Reg, volatile.LoadUint32(&o.RGCR1.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRGCR1_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RGCR1.Reg) & 0xf80000) >> 19
}

// DMAMUX.RGCR2: DMAMux - DMA request generator channel x control register
func (o *DMAMUX_Type) SetRGCR2_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RGCR2.Reg, volatile.LoadUint32(&o.RGCR2.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRGCR2_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RGCR2.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRGCR2_OIE(value uint32) {
	volatile.StoreUint32(&o.RGCR2.Reg, volatile.LoadUint32(&o.RGCR2.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRGCR2_OIE() uint32 {
	return (volatile.LoadUint32(&o.RGCR2.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRGCR2_GE(value uint32) {
	volatile.StoreUint32(&o.RGCR2.Reg, volatile.LoadUint32(&o.RGCR2.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRGCR2_GE() uint32 {
	return (volatile.LoadUint32(&o.RGCR2.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRGCR2_GPOL(value uint32) {
	volatile.StoreUint32(&o.RGCR2.Reg, volatile.LoadUint32(&o.RGCR2.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRGCR2_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RGCR2.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRGCR2_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RGCR2.Reg, volatile.LoadUint32(&o.RGCR2.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRGCR2_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RGCR2.Reg) & 0xf80000) >> 19
}

// DMAMUX.RGCR3: DMAMux - DMA request generator channel x control register
func (o *DMAMUX_Type) SetRGCR3_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RGCR3.Reg, volatile.LoadUint32(&o.RGCR3.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRGCR3_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RGCR3.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRGCR3_OIE(value uint32) {
	volatile.StoreUint32(&o.RGCR3.Reg, volatile.LoadUint32(&o.RGCR3.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRGCR3_OIE() uint32 {
	return (volatile.LoadUint32(&o.RGCR3.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRGCR3_GE(value uint32) {
	volatile.StoreUint32(&o.RGCR3.Reg, volatile.LoadUint32(&o.RGCR3.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRGCR3_GE() uint32 {
	return (volatile.LoadUint32(&o.RGCR3.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRGCR3_GPOL(value uint32) {
	volatile.StoreUint32(&o.RGCR3.Reg, volatile.LoadUint32(&o.RGCR3.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRGCR3_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RGCR3.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRGCR3_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RGCR3.Reg, volatile.LoadUint32(&o.RGCR3.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRGCR3_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RGCR3.Reg) & 0xf80000) >> 19
}

// DMAMUX.RGCR4: DMAMux - DMA request generator channel x control register
func (o *DMAMUX_Type) SetRGCR4_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RGCR4.Reg, volatile.LoadUint32(&o.RGCR4.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRGCR4_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RGCR4.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRGCR4_OIE(value uint32) {
	volatile.StoreUint32(&o.RGCR4.Reg, volatile.LoadUint32(&o.RGCR4.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRGCR4_OIE() uint32 {
	return (volatile.LoadUint32(&o.RGCR4.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRGCR4_GE(value uint32) {
	volatile.StoreUint32(&o.RGCR4.Reg, volatile.LoadUint32(&o.RGCR4.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRGCR4_GE() uint32 {
	return (volatile.LoadUint32(&o.RGCR4.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRGCR4_GPOL(value uint32) {
	volatile.StoreUint32(&o.RGCR4.Reg, volatile.LoadUint32(&o.RGCR4.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRGCR4_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RGCR4.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRGCR4_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RGCR4.Reg, volatile.LoadUint32(&o.RGCR4.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRGCR4_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RGCR4.Reg) & 0xf80000) >> 19
}

// DMAMUX.RGCR5: DMAMux - DMA request generator channel x control register
func (o *DMAMUX_Type) SetRGCR5_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RGCR5.Reg, volatile.LoadUint32(&o.RGCR5.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRGCR5_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RGCR5.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRGCR5_OIE(value uint32) {
	volatile.StoreUint32(&o.RGCR5.Reg, volatile.LoadUint32(&o.RGCR5.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRGCR5_OIE() uint32 {
	return (volatile.LoadUint32(&o.RGCR5.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRGCR5_GE(value uint32) {
	volatile.StoreUint32(&o.RGCR5.Reg, volatile.LoadUint32(&o.RGCR5.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRGCR5_GE() uint32 {
	return (volatile.LoadUint32(&o.RGCR5.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRGCR5_GPOL(value uint32) {
	volatile.StoreUint32(&o.RGCR5.Reg, volatile.LoadUint32(&o.RGCR5.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRGCR5_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RGCR5.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRGCR5_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RGCR5.Reg, volatile.LoadUint32(&o.RGCR5.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRGCR5_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RGCR5.Reg) & 0xf80000) >> 19
}

// DMAMUX.RGCR6: DMAMux - DMA request generator channel x control register
func (o *DMAMUX_Type) SetRGCR6_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RGCR6.Reg, volatile.LoadUint32(&o.RGCR6.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRGCR6_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RGCR6.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRGCR6_OIE(value uint32) {
	volatile.StoreUint32(&o.RGCR6.Reg, volatile.LoadUint32(&o.RGCR6.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRGCR6_OIE() uint32 {
	return (volatile.LoadUint32(&o.RGCR6.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRGCR6_GE(value uint32) {
	volatile.StoreUint32(&o.RGCR6.Reg, volatile.LoadUint32(&o.RGCR6.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRGCR6_GE() uint32 {
	return (volatile.LoadUint32(&o.RGCR6.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRGCR6_GPOL(value uint32) {
	volatile.StoreUint32(&o.RGCR6.Reg, volatile.LoadUint32(&o.RGCR6.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRGCR6_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RGCR6.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRGCR6_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RGCR6.Reg, volatile.LoadUint32(&o.RGCR6.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRGCR6_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RGCR6.Reg) & 0xf80000) >> 19
}

// DMAMUX.RGCR7: DMAMux - DMA request generator channel x control register
func (o *DMAMUX_Type) SetRGCR7_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RGCR7.Reg, volatile.LoadUint32(&o.RGCR7.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRGCR7_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RGCR7.Reg) & 0x1f
}
func (o *DMAMUX_Type) SetRGCR7_OIE(value uint32) {
	volatile.StoreUint32(&o.RGCR7.Reg, volatile.LoadUint32(&o.RGCR7.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRGCR7_OIE() uint32 {
	return (volatile.LoadUint32(&o.RGCR7.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRGCR7_GE(value uint32) {
	volatile.StoreUint32(&o.RGCR7.Reg, volatile.LoadUint32(&o.RGCR7.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRGCR7_GE() uint32 {
	return (volatile.LoadUint32(&o.RGCR7.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRGCR7_GPOL(value uint32) {
	volatile.StoreUint32(&o.RGCR7.Reg, volatile.LoadUint32(&o.RGCR7.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRGCR7_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RGCR7.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRGCR7_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RGCR7.Reg, volatile.LoadUint32(&o.RGCR7.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRGCR7_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RGCR7.Reg) & 0xf80000) >> 19
}

// DMAMUX.RGSR: DMAMux - DMA request generator status register
func (o *DMAMUX_Type) SetRGSR_OF0(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetRGSR_OF0() uint32 {
	return volatile.LoadUint32(&o.RGSR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetRGSR_OF1(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetRGSR_OF1() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetRGSR_OF2(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetRGSR_OF2() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetRGSR_OF3(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetRGSR_OF3() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x8) >> 3
}
func (o *DMAMUX_Type) SetRGSR_OF4(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x10)|value<<4)
}
func (o *DMAMUX_Type) GetRGSR_OF4() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x10) >> 4
}
func (o *DMAMUX_Type) SetRGSR_OF5(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x20)|value<<5)
}
func (o *DMAMUX_Type) GetRGSR_OF5() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x20) >> 5
}
func (o *DMAMUX_Type) SetRGSR_OF6(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetRGSR_OF6() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetRGSR_OF7(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetRGSR_OF7() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x80) >> 7
}

// DMAMUX.RGCFR: DMAMux - DMA request generator clear flag register
func (o *DMAMUX_Type) SetRGCFR_COF0(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetRGCFR_COF0() uint32 {
	return volatile.LoadUint32(&o.RGCFR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetRGCFR_COF1(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetRGCFR_COF1() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetRGCFR_COF2(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetRGCFR_COF2() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetRGCFR_COF3(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetRGCFR_COF3() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x8) >> 3
}
func (o *DMAMUX_Type) SetRGCFR_COF4(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x10)|value<<4)
}
func (o *DMAMUX_Type) GetRGCFR_COF4() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x10) >> 4
}
func (o *DMAMUX_Type) SetRGCFR_COF5(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x20)|value<<5)
}
func (o *DMAMUX_Type) GetRGCFR_COF5() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x20) >> 5
}
func (o *DMAMUX_Type) SetRGCFR_COF6(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetRGCFR_COF6() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetRGCFR_COF7(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetRGCFR_COF7() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x80) >> 7
}

// External interrupt/event controller
type EXTI_Type struct {
	RTSR1   volatile.Register32 // 0x0
	FTSR1   volatile.Register32 // 0x4
	SWIER1  volatile.Register32 // 0x8
	D3PMR1  volatile.Register32 // 0xC
	D3PCR1L volatile.Register32 // 0x10
	D3PCR1H volatile.Register32 // 0x14
	_       [8]byte
	RTSR2   volatile.Register32 // 0x20
	FTSR2   volatile.Register32 // 0x24
	SWIER2  volatile.Register32 // 0x28
	D3PMR2  volatile.Register32 // 0x2C
	D3PCR2L volatile.Register32 // 0x30
	D3PCR2H volatile.Register32 // 0x34
	_       [8]byte
	RTSR3   volatile.Register32 // 0x40
	FTSR3   volatile.Register32 // 0x44
	SWIER3  volatile.Register32 // 0x48
	D3PMR3  volatile.Register32 // 0x4C
	_       [4]byte
	D3PCR3H volatile.Register32 // 0x54
	_       [40]byte
	CPUIMR1 volatile.Register32 // 0x80
	CPUEMR1 volatile.Register32 // 0x84
	CPUPR1  volatile.Register32 // 0x88
	_       [4]byte
	CPUIMR2 volatile.Register32 // 0x90
	CPUEMR2 volatile.Register32 // 0x94
	CPUPR2  volatile.Register32 // 0x98
	_       [4]byte
	CPUIMR3 volatile.Register32 // 0xA0
	CPUEMR3 volatile.Register32 // 0xA4
	CPUPR3  volatile.Register32 // 0xA8
}

// EXTI.RTSR1: EXTI rising trigger selection register
func (o *EXTI_Type) SetRTSR1_TR0(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetRTSR1_TR0() uint32 {
	return volatile.LoadUint32(&o.RTSR1.Reg) & 0x1
}
func (o *EXTI_Type) SetRTSR1_TR1(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetRTSR1_TR1() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetRTSR1_TR2(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetRTSR1_TR2() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetRTSR1_TR3(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetRTSR1_TR3() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetRTSR1_TR4(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetRTSR1_TR4() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetRTSR1_TR5(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetRTSR1_TR5() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetRTSR1_TR6(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetRTSR1_TR6() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetRTSR1_TR7(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetRTSR1_TR7() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetRTSR1_TR8(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetRTSR1_TR8() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetRTSR1_TR9(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetRTSR1_TR9() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetRTSR1_TR10(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetRTSR1_TR10() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetRTSR1_TR11(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetRTSR1_TR11() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetRTSR1_TR12(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetRTSR1_TR12() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetRTSR1_TR13(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetRTSR1_TR13() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetRTSR1_TR14(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetRTSR1_TR14() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetRTSR1_TR15(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetRTSR1_TR15() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetRTSR1_TR16(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetRTSR1_TR16() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetRTSR1_TR17(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetRTSR1_TR17() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetRTSR1_TR18(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetRTSR1_TR18() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetRTSR1_TR19(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetRTSR1_TR19() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetRTSR1_TR20(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetRTSR1_TR20() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetRTSR1_TR21(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetRTSR1_TR21() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x200000) >> 21
}

// EXTI.FTSR1: EXTI falling trigger selection register
func (o *EXTI_Type) SetFTSR1_TR0(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetFTSR1_TR0() uint32 {
	return volatile.LoadUint32(&o.FTSR1.Reg) & 0x1
}
func (o *EXTI_Type) SetFTSR1_TR1(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetFTSR1_TR1() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetFTSR1_TR2(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetFTSR1_TR2() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetFTSR1_TR3(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetFTSR1_TR3() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetFTSR1_TR4(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetFTSR1_TR4() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetFTSR1_TR5(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetFTSR1_TR5() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetFTSR1_TR6(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetFTSR1_TR6() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetFTSR1_TR7(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetFTSR1_TR7() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetFTSR1_TR8(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetFTSR1_TR8() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetFTSR1_TR9(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetFTSR1_TR9() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetFTSR1_TR10(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetFTSR1_TR10() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetFTSR1_TR11(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetFTSR1_TR11() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetFTSR1_TR12(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetFTSR1_TR12() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetFTSR1_TR13(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetFTSR1_TR13() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetFTSR1_TR14(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetFTSR1_TR14() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetFTSR1_TR15(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetFTSR1_TR15() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetFTSR1_TR16(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetFTSR1_TR16() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetFTSR1_TR17(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetFTSR1_TR17() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetFTSR1_TR18(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetFTSR1_TR18() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetFTSR1_TR19(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetFTSR1_TR19() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetFTSR1_TR20(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetFTSR1_TR20() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetFTSR1_TR21(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetFTSR1_TR21() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x200000) >> 21
}

// EXTI.SWIER1: EXTI software interrupt event register
func (o *EXTI_Type) SetSWIER1_SWIER0(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetSWIER1_SWIER0() uint32 {
	return volatile.LoadUint32(&o.SWIER1.Reg) & 0x1
}
func (o *EXTI_Type) SetSWIER1(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetSWIER1() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetSWIER1_SWIER2(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetSWIER1_SWIER2() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetSWIER1_SWIER3(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetSWIER1_SWIER3() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetSWIER1_SWIER4(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetSWIER1_SWIER4() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetSWIER1_SWIER5(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetSWIER1_SWIER5() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetSWIER1_SWIER6(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetSWIER1_SWIER6() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetSWIER1_SWIER7(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetSWIER1_SWIER7() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetSWIER1_SWIER8(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetSWIER1_SWIER8() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetSWIER1_SWIER9(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetSWIER1_SWIER9() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetSWIER1_SWIER10(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetSWIER1_SWIER10() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetSWIER1_SWIER11(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetSWIER1_SWIER11() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetSWIER1_SWIER12(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetSWIER1_SWIER12() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetSWIER1_SWIER13(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetSWIER1_SWIER13() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetSWIER1_SWIER14(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetSWIER1_SWIER14() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetSWIER1_SWIER15(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetSWIER1_SWIER15() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetSWIER1_SWIER16(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetSWIER1_SWIER16() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetSWIER1_SWIER17(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetSWIER1_SWIER17() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetSWIER1_SWIER18(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetSWIER1_SWIER18() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetSWIER1_SWIER19(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetSWIER1_SWIER19() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetSWIER1_SWIER20(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetSWIER1_SWIER20() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetSWIER1_SWIER21(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetSWIER1_SWIER21() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x200000) >> 21
}

// EXTI.D3PMR1: EXTI D3 pending mask register
func (o *EXTI_Type) SetD3PMR1_MR0(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetD3PMR1_MR0() uint32 {
	return volatile.LoadUint32(&o.D3PMR1.Reg) & 0x1
}
func (o *EXTI_Type) SetD3PMR1_MR1(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetD3PMR1_MR1() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetD3PMR1_MR2(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetD3PMR1_MR2() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetD3PMR1_MR3(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetD3PMR1_MR3() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetD3PMR1_MR4(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetD3PMR1_MR4() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetD3PMR1_MR5(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetD3PMR1_MR5() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetD3PMR1_MR6(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetD3PMR1_MR6() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetD3PMR1_MR7(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetD3PMR1_MR7() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetD3PMR1_MR8(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetD3PMR1_MR8() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetD3PMR1_MR9(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetD3PMR1_MR9() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetD3PMR1_MR10(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetD3PMR1_MR10() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetD3PMR1_MR11(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetD3PMR1_MR11() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetD3PMR1_MR12(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetD3PMR1_MR12() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetD3PMR1_MR13(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetD3PMR1_MR13() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetD3PMR1_MR14(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetD3PMR1_MR14() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetD3PMR1_MR15(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetD3PMR1_MR15() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetD3PMR1_MR19(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetD3PMR1_MR19() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetD3PMR1_MR20(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetD3PMR1_MR20() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetD3PMR1_MR21(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetD3PMR1_MR21() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetD3PMR1_MR25(value uint32) {
	volatile.StoreUint32(&o.D3PMR1.Reg, volatile.LoadUint32(&o.D3PMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetD3PMR1_MR25() uint32 {
	return (volatile.LoadUint32(&o.D3PMR1.Reg) & 0x2000000) >> 25
}

// EXTI.D3PCR1L: EXTI D3 pending clear selection register low
func (o *EXTI_Type) SetD3PCR1L_PCS0(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0x3)|value)
}
func (o *EXTI_Type) GetD3PCR1L_PCS0() uint32 {
	return volatile.LoadUint32(&o.D3PCR1L.Reg) & 0x3
}
func (o *EXTI_Type) SetD3PCR1L_PCS1(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0xc)|value<<2)
}
func (o *EXTI_Type) GetD3PCR1L_PCS1() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0xc) >> 2
}
func (o *EXTI_Type) SetD3PCR1L_PCS2(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0x30)|value<<4)
}
func (o *EXTI_Type) GetD3PCR1L_PCS2() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0x30) >> 4
}
func (o *EXTI_Type) SetD3PCR1L_PCS3(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0xc0)|value<<6)
}
func (o *EXTI_Type) GetD3PCR1L_PCS3() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0xc0) >> 6
}
func (o *EXTI_Type) SetD3PCR1L_PCS4(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0x300)|value<<8)
}
func (o *EXTI_Type) GetD3PCR1L_PCS4() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0x300) >> 8
}
func (o *EXTI_Type) SetD3PCR1L_PCS5(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0xc00)|value<<10)
}
func (o *EXTI_Type) GetD3PCR1L_PCS5() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0xc00) >> 10
}
func (o *EXTI_Type) SetD3PCR1L_PCS6(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0x3000)|value<<12)
}
func (o *EXTI_Type) GetD3PCR1L_PCS6() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0x3000) >> 12
}
func (o *EXTI_Type) SetD3PCR1L_PCS7(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0xc000)|value<<14)
}
func (o *EXTI_Type) GetD3PCR1L_PCS7() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0xc000) >> 14
}
func (o *EXTI_Type) SetD3PCR1L_PCS8(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0x30000)|value<<16)
}
func (o *EXTI_Type) GetD3PCR1L_PCS8() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0x30000) >> 16
}
func (o *EXTI_Type) SetD3PCR1L_PCS9(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0xc0000)|value<<18)
}
func (o *EXTI_Type) GetD3PCR1L_PCS9() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0xc0000) >> 18
}
func (o *EXTI_Type) SetD3PCR1L_PCS10(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0x300000)|value<<20)
}
func (o *EXTI_Type) GetD3PCR1L_PCS10() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0x300000) >> 20
}
func (o *EXTI_Type) SetD3PCR1L_PCS11(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0xc00000)|value<<22)
}
func (o *EXTI_Type) GetD3PCR1L_PCS11() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0xc00000) >> 22
}
func (o *EXTI_Type) SetD3PCR1L_PCS12(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0x3000000)|value<<24)
}
func (o *EXTI_Type) GetD3PCR1L_PCS12() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0x3000000) >> 24
}
func (o *EXTI_Type) SetD3PCR1L_PCS13(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0xc000000)|value<<26)
}
func (o *EXTI_Type) GetD3PCR1L_PCS13() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0xc000000) >> 26
}
func (o *EXTI_Type) SetD3PCR1L_PCS14(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0x30000000)|value<<28)
}
func (o *EXTI_Type) GetD3PCR1L_PCS14() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0x30000000) >> 28
}
func (o *EXTI_Type) SetD3PCR1L_PCS15(value uint32) {
	volatile.StoreUint32(&o.D3PCR1L.Reg, volatile.LoadUint32(&o.D3PCR1L.Reg)&^(0xc0000000)|value<<30)
}
func (o *EXTI_Type) GetD3PCR1L_PCS15() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1L.Reg) & 0xc0000000) >> 30
}

// EXTI.D3PCR1H: EXTI D3 pending clear selection register high
func (o *EXTI_Type) SetD3PCR1H_PCS19(value uint32) {
	volatile.StoreUint32(&o.D3PCR1H.Reg, volatile.LoadUint32(&o.D3PCR1H.Reg)&^(0xc0)|value<<6)
}
func (o *EXTI_Type) GetD3PCR1H_PCS19() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1H.Reg) & 0xc0) >> 6
}
func (o *EXTI_Type) SetD3PCR1H_PCS20(value uint32) {
	volatile.StoreUint32(&o.D3PCR1H.Reg, volatile.LoadUint32(&o.D3PCR1H.Reg)&^(0x300)|value<<8)
}
func (o *EXTI_Type) GetD3PCR1H_PCS20() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1H.Reg) & 0x300) >> 8
}
func (o *EXTI_Type) SetD3PCR1H_PCS21(value uint32) {
	volatile.StoreUint32(&o.D3PCR1H.Reg, volatile.LoadUint32(&o.D3PCR1H.Reg)&^(0xc00)|value<<10)
}
func (o *EXTI_Type) GetD3PCR1H_PCS21() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1H.Reg) & 0xc00) >> 10
}
func (o *EXTI_Type) SetD3PCR1H_PCS25(value uint32) {
	volatile.StoreUint32(&o.D3PCR1H.Reg, volatile.LoadUint32(&o.D3PCR1H.Reg)&^(0xc0000)|value<<18)
}
func (o *EXTI_Type) GetD3PCR1H_PCS25() uint32 {
	return (volatile.LoadUint32(&o.D3PCR1H.Reg) & 0xc0000) >> 18
}

// EXTI.RTSR2: EXTI rising trigger selection register
func (o *EXTI_Type) SetRTSR2_TR49(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetRTSR2_TR49() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetRTSR2_TR51(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetRTSR2_TR51() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x80000) >> 19
}

// EXTI.FTSR2: EXTI falling trigger selection register
func (o *EXTI_Type) SetFTSR2_TR49(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetFTSR2_TR49() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetFTSR2_TR51(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetFTSR2_TR51() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x80000) >> 19
}

// EXTI.SWIER2: EXTI software interrupt event register
func (o *EXTI_Type) SetSWIER2_SWIER49(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetSWIER2_SWIER49() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetSWIER2_SWIER51(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetSWIER2_SWIER51() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x80000) >> 19
}

// EXTI.D3PMR2: EXTI D3 pending mask register
func (o *EXTI_Type) SetD3PMR2_MR34(value uint32) {
	volatile.StoreUint32(&o.D3PMR2.Reg, volatile.LoadUint32(&o.D3PMR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetD3PMR2_MR34() uint32 {
	return (volatile.LoadUint32(&o.D3PMR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetD3PMR2_MR35(value uint32) {
	volatile.StoreUint32(&o.D3PMR2.Reg, volatile.LoadUint32(&o.D3PMR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetD3PMR2_MR35() uint32 {
	return (volatile.LoadUint32(&o.D3PMR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetD3PMR2_MR41(value uint32) {
	volatile.StoreUint32(&o.D3PMR2.Reg, volatile.LoadUint32(&o.D3PMR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetD3PMR2_MR41() uint32 {
	return (volatile.LoadUint32(&o.D3PMR2.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetD3PMR2_MR48(value uint32) {
	volatile.StoreUint32(&o.D3PMR2.Reg, volatile.LoadUint32(&o.D3PMR2.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetD3PMR2_MR48() uint32 {
	return (volatile.LoadUint32(&o.D3PMR2.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetD3PMR2_MR49(value uint32) {
	volatile.StoreUint32(&o.D3PMR2.Reg, volatile.LoadUint32(&o.D3PMR2.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetD3PMR2_MR49() uint32 {
	return (volatile.LoadUint32(&o.D3PMR2.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetD3PMR2_MR50(value uint32) {
	volatile.StoreUint32(&o.D3PMR2.Reg, volatile.LoadUint32(&o.D3PMR2.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetD3PMR2_MR50() uint32 {
	return (volatile.LoadUint32(&o.D3PMR2.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetD3PMR2_MR51(value uint32) {
	volatile.StoreUint32(&o.D3PMR2.Reg, volatile.LoadUint32(&o.D3PMR2.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetD3PMR2_MR51() uint32 {
	return (volatile.LoadUint32(&o.D3PMR2.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetD3PMR2_MR52(value uint32) {
	volatile.StoreUint32(&o.D3PMR2.Reg, volatile.LoadUint32(&o.D3PMR2.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetD3PMR2_MR52() uint32 {
	return (volatile.LoadUint32(&o.D3PMR2.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetD3PMR2_MR53(value uint32) {
	volatile.StoreUint32(&o.D3PMR2.Reg, volatile.LoadUint32(&o.D3PMR2.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetD3PMR2_MR53() uint32 {
	return (volatile.LoadUint32(&o.D3PMR2.Reg) & 0x200000) >> 21
}

// EXTI.D3PCR2L: EXTI D3 pending clear selection register low
func (o *EXTI_Type) SetD3PCR2L_PCS35(value uint32) {
	volatile.StoreUint32(&o.D3PCR2L.Reg, volatile.LoadUint32(&o.D3PCR2L.Reg)&^(0xc0)|value<<6)
}
func (o *EXTI_Type) GetD3PCR2L_PCS35() uint32 {
	return (volatile.LoadUint32(&o.D3PCR2L.Reg) & 0xc0) >> 6
}
func (o *EXTI_Type) SetD3PCR2L_PCS34(value uint32) {
	volatile.StoreUint32(&o.D3PCR2L.Reg, volatile.LoadUint32(&o.D3PCR2L.Reg)&^(0x30)|value<<4)
}
func (o *EXTI_Type) GetD3PCR2L_PCS34() uint32 {
	return (volatile.LoadUint32(&o.D3PCR2L.Reg) & 0x30) >> 4
}
func (o *EXTI_Type) SetD3PCR2L_PCS41(value uint32) {
	volatile.StoreUint32(&o.D3PCR2L.Reg, volatile.LoadUint32(&o.D3PCR2L.Reg)&^(0xc0000)|value<<18)
}
func (o *EXTI_Type) GetD3PCR2L_PCS41() uint32 {
	return (volatile.LoadUint32(&o.D3PCR2L.Reg) & 0xc0000) >> 18
}

// EXTI.D3PCR2H: EXTI D3 pending clear selection register high
func (o *EXTI_Type) SetD3PCR2H_PCS48(value uint32) {
	volatile.StoreUint32(&o.D3PCR2H.Reg, volatile.LoadUint32(&o.D3PCR2H.Reg)&^(0x3)|value)
}
func (o *EXTI_Type) GetD3PCR2H_PCS48() uint32 {
	return volatile.LoadUint32(&o.D3PCR2H.Reg) & 0x3
}
func (o *EXTI_Type) SetD3PCR2H_PCS49(value uint32) {
	volatile.StoreUint32(&o.D3PCR2H.Reg, volatile.LoadUint32(&o.D3PCR2H.Reg)&^(0xc)|value<<2)
}
func (o *EXTI_Type) GetD3PCR2H_PCS49() uint32 {
	return (volatile.LoadUint32(&o.D3PCR2H.Reg) & 0xc) >> 2
}
func (o *EXTI_Type) SetD3PCR2H_PCS50(value uint32) {
	volatile.StoreUint32(&o.D3PCR2H.Reg, volatile.LoadUint32(&o.D3PCR2H.Reg)&^(0x30)|value<<4)
}
func (o *EXTI_Type) GetD3PCR2H_PCS50() uint32 {
	return (volatile.LoadUint32(&o.D3PCR2H.Reg) & 0x30) >> 4
}
func (o *EXTI_Type) SetD3PCR2H_PCS51(value uint32) {
	volatile.StoreUint32(&o.D3PCR2H.Reg, volatile.LoadUint32(&o.D3PCR2H.Reg)&^(0xc0)|value<<6)
}
func (o *EXTI_Type) GetD3PCR2H_PCS51() uint32 {
	return (volatile.LoadUint32(&o.D3PCR2H.Reg) & 0xc0) >> 6
}
func (o *EXTI_Type) SetD3PCR2H_PCS52(value uint32) {
	volatile.StoreUint32(&o.D3PCR2H.Reg, volatile.LoadUint32(&o.D3PCR2H.Reg)&^(0x300)|value<<8)
}
func (o *EXTI_Type) GetD3PCR2H_PCS52() uint32 {
	return (volatile.LoadUint32(&o.D3PCR2H.Reg) & 0x300) >> 8
}
func (o *EXTI_Type) SetD3PCR2H_PCS53(value uint32) {
	volatile.StoreUint32(&o.D3PCR2H.Reg, volatile.LoadUint32(&o.D3PCR2H.Reg)&^(0xc00)|value<<10)
}
func (o *EXTI_Type) GetD3PCR2H_PCS53() uint32 {
	return (volatile.LoadUint32(&o.D3PCR2H.Reg) & 0xc00) >> 10
}

// EXTI.RTSR3: EXTI rising trigger selection register
func (o *EXTI_Type) SetRTSR3_TR82(value uint32) {
	volatile.StoreUint32(&o.RTSR3.Reg, volatile.LoadUint32(&o.RTSR3.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetRTSR3_TR82() uint32 {
	return (volatile.LoadUint32(&o.RTSR3.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetRTSR3_TR84(value uint32) {
	volatile.StoreUint32(&o.RTSR3.Reg, volatile.LoadUint32(&o.RTSR3.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetRTSR3_TR84() uint32 {
	return (volatile.LoadUint32(&o.RTSR3.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetRTSR3_TR85(value uint32) {
	volatile.StoreUint32(&o.RTSR3.Reg, volatile.LoadUint32(&o.RTSR3.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetRTSR3_TR85() uint32 {
	return (volatile.LoadUint32(&o.RTSR3.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetRTSR3_TR86(value uint32) {
	volatile.StoreUint32(&o.RTSR3.Reg, volatile.LoadUint32(&o.RTSR3.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetRTSR3_TR86() uint32 {
	return (volatile.LoadUint32(&o.RTSR3.Reg) & 0x400000) >> 22
}

// EXTI.FTSR3: EXTI falling trigger selection register
func (o *EXTI_Type) SetFTSR3_TR82(value uint32) {
	volatile.StoreUint32(&o.FTSR3.Reg, volatile.LoadUint32(&o.FTSR3.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetFTSR3_TR82() uint32 {
	return (volatile.LoadUint32(&o.FTSR3.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetFTSR3_TR84(value uint32) {
	volatile.StoreUint32(&o.FTSR3.Reg, volatile.LoadUint32(&o.FTSR3.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetFTSR3_TR84() uint32 {
	return (volatile.LoadUint32(&o.FTSR3.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetFTSR3_TR85(value uint32) {
	volatile.StoreUint32(&o.FTSR3.Reg, volatile.LoadUint32(&o.FTSR3.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetFTSR3_TR85() uint32 {
	return (volatile.LoadUint32(&o.FTSR3.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetFTSR3_TR86(value uint32) {
	volatile.StoreUint32(&o.FTSR3.Reg, volatile.LoadUint32(&o.FTSR3.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetFTSR3_TR86() uint32 {
	return (volatile.LoadUint32(&o.FTSR3.Reg) & 0x400000) >> 22
}

// EXTI.SWIER3: EXTI software interrupt event register
func (o *EXTI_Type) SetSWIER3_SWIER82(value uint32) {
	volatile.StoreUint32(&o.SWIER3.Reg, volatile.LoadUint32(&o.SWIER3.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetSWIER3_SWIER82() uint32 {
	return (volatile.LoadUint32(&o.SWIER3.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetSWIER3_SWIER84(value uint32) {
	volatile.StoreUint32(&o.SWIER3.Reg, volatile.LoadUint32(&o.SWIER3.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetSWIER3_SWIER84() uint32 {
	return (volatile.LoadUint32(&o.SWIER3.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetSWIER3_SWIER85(value uint32) {
	volatile.StoreUint32(&o.SWIER3.Reg, volatile.LoadUint32(&o.SWIER3.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetSWIER3_SWIER85() uint32 {
	return (volatile.LoadUint32(&o.SWIER3.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetSWIER3_SWIER86(value uint32) {
	volatile.StoreUint32(&o.SWIER3.Reg, volatile.LoadUint32(&o.SWIER3.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetSWIER3_SWIER86() uint32 {
	return (volatile.LoadUint32(&o.SWIER3.Reg) & 0x400000) >> 22
}

// EXTI.D3PMR3: EXTI D3 pending mask register
func (o *EXTI_Type) SetD3PMR3_MR88(value uint32) {
	volatile.StoreUint32(&o.D3PMR3.Reg, volatile.LoadUint32(&o.D3PMR3.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetD3PMR3_MR88() uint32 {
	return (volatile.LoadUint32(&o.D3PMR3.Reg) & 0x1000000) >> 24
}

// EXTI.D3PCR3H: EXTI D3 pending clear selection register high
func (o *EXTI_Type) SetD3PCR3H_PCS88(value uint32) {
	volatile.StoreUint32(&o.D3PCR3H.Reg, volatile.LoadUint32(&o.D3PCR3H.Reg)&^(0xc0000)|value<<18)
}
func (o *EXTI_Type) GetD3PCR3H_PCS88() uint32 {
	return (volatile.LoadUint32(&o.D3PCR3H.Reg) & 0xc0000) >> 18
}

// EXTI.CPUIMR1: EXTI interrupt mask register
func (o *EXTI_Type) SetCPUIMR1_MR0(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetCPUIMR1_MR0() uint32 {
	return volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x1
}
func (o *EXTI_Type) SetCPUIMR1_MR1(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetCPUIMR1_MR1() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetCPUIMR1_MR2(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetCPUIMR1_MR2() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetCPUIMR1_MR3(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetCPUIMR1_MR3() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetCPUIMR1_MR4(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetCPUIMR1_MR4() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetCPUIMR1_MR5(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetCPUIMR1_MR5() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetCPUIMR1_MR6(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetCPUIMR1_MR6() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetCPUIMR1_MR7(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetCPUIMR1_MR7() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetCPUIMR1_MR8(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetCPUIMR1_MR8() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetCPUIMR1_MR9(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetCPUIMR1_MR9() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetCPUIMR1_MR10(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetCPUIMR1_MR10() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetCPUIMR1_MR11(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetCPUIMR1_MR11() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetCPUIMR1_MR12(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetCPUIMR1_MR12() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetCPUIMR1_MR13(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetCPUIMR1_MR13() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetCPUIMR1_MR14(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetCPUIMR1_MR14() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetCPUIMR1_MR15(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetCPUIMR1_MR15() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetCPUIMR1_MR16(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetCPUIMR1_MR16() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetCPUIMR1_MR17(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetCPUIMR1_MR17() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetCPUIMR1_MR18(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetCPUIMR1_MR18() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetCPUIMR1_MR19(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetCPUIMR1_MR19() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetCPUIMR1_MR20(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetCPUIMR1_MR20() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetCPUIMR1_MR21(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetCPUIMR1_MR21() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetCPUIMR1_MR22(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetCPUIMR1_MR22() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetCPUIMR1_MR23(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetCPUIMR1_MR23() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetCPUIMR1_MR24(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetCPUIMR1_MR24() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetCPUIMR1_MR25(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetCPUIMR1_MR25() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetCPUIMR1_MR26(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetCPUIMR1_MR26() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetCPUIMR1_MR27(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetCPUIMR1_MR27() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetCPUIMR1_MR28(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetCPUIMR1_MR28() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetCPUIMR1_MR29(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetCPUIMR1_MR29() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetCPUIMR1_MR30(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetCPUIMR1_MR30() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetCPUIMR1_MR31(value uint32) {
	volatile.StoreUint32(&o.CPUIMR1.Reg, volatile.LoadUint32(&o.CPUIMR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetCPUIMR1_MR31() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR1.Reg) & 0x80000000) >> 31
}

// EXTI.CPUEMR1: EXTI event mask register
func (o *EXTI_Type) SetCPUEMR1_MR0(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetCPUEMR1_MR0() uint32 {
	return volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x1
}
func (o *EXTI_Type) SetCPUEMR1_MR1(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetCPUEMR1_MR1() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetCPUEMR1_MR2(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetCPUEMR1_MR2() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetCPUEMR1_MR3(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetCPUEMR1_MR3() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetCPUEMR1_MR4(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetCPUEMR1_MR4() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetCPUEMR1_MR5(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetCPUEMR1_MR5() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetCPUEMR1_MR6(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetCPUEMR1_MR6() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetCPUEMR1_MR7(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetCPUEMR1_MR7() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetCPUEMR1_MR8(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetCPUEMR1_MR8() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetCPUEMR1_MR9(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetCPUEMR1_MR9() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetCPUEMR1_MR10(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetCPUEMR1_MR10() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetCPUEMR1_MR11(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetCPUEMR1_MR11() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetCPUEMR1_MR12(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetCPUEMR1_MR12() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetCPUEMR1_MR13(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetCPUEMR1_MR13() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetCPUEMR1_MR14(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetCPUEMR1_MR14() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetCPUEMR1_MR15(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetCPUEMR1_MR15() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetCPUEMR1_MR16(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetCPUEMR1_MR16() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetCPUEMR1_MR17(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetCPUEMR1_MR17() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetCPUEMR1_MR18(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetCPUEMR1_MR18() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetCPUEMR1_MR19(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetCPUEMR1_MR19() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetCPUEMR1_MR20(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetCPUEMR1_MR20() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetCPUEMR1_MR21(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetCPUEMR1_MR21() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetCPUEMR1_MR22(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetCPUEMR1_MR22() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetCPUEMR1_MR23(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetCPUEMR1_MR23() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetCPUEMR1_MR24(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetCPUEMR1_MR24() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetCPUEMR1_MR25(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetCPUEMR1_MR25() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetCPUEMR1_MR26(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetCPUEMR1_MR26() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetCPUEMR1_MR27(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetCPUEMR1_MR27() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetCPUEMR1_MR28(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetCPUEMR1_MR28() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetCPUEMR1_MR29(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetCPUEMR1_MR29() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetCPUEMR1_MR30(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetCPUEMR1_MR30() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetCPUEMR1_MR31(value uint32) {
	volatile.StoreUint32(&o.CPUEMR1.Reg, volatile.LoadUint32(&o.CPUEMR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetCPUEMR1_MR31() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR1.Reg) & 0x80000000) >> 31
}

// EXTI.CPUPR1: EXTI pending register
func (o *EXTI_Type) SetCPUPR1_PR0(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetCPUPR1_PR0() uint32 {
	return volatile.LoadUint32(&o.CPUPR1.Reg) & 0x1
}
func (o *EXTI_Type) SetCPUPR1_PR1(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetCPUPR1_PR1() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetCPUPR1_PR2(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetCPUPR1_PR2() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetCPUPR1_PR3(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetCPUPR1_PR3() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetCPUPR1_PR4(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetCPUPR1_PR4() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetCPUPR1_PR5(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetCPUPR1_PR5() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetCPUPR1_PR6(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetCPUPR1_PR6() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetCPUPR1_PR7(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetCPUPR1_PR7() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetCPUPR1_PR8(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetCPUPR1_PR8() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetCPUPR1_PR9(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetCPUPR1_PR9() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetCPUPR1_PR10(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetCPUPR1_PR10() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetCPUPR1_PR11(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetCPUPR1_PR11() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetCPUPR1_PR12(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetCPUPR1_PR12() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetCPUPR1_PR13(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetCPUPR1_PR13() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetCPUPR1_PR14(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetCPUPR1_PR14() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetCPUPR1_PR15(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetCPUPR1_PR15() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetCPUPR1_PR16(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetCPUPR1_PR16() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetCPUPR1_PR17(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetCPUPR1_PR17() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetCPUPR1_PR18(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetCPUPR1_PR18() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetCPUPR1_PR19(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetCPUPR1_PR19() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetCPUPR1_PR20(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetCPUPR1_PR20() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetCPUPR1_PR21(value uint32) {
	volatile.StoreUint32(&o.CPUPR1.Reg, volatile.LoadUint32(&o.CPUPR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetCPUPR1_PR21() uint32 {
	return (volatile.LoadUint32(&o.CPUPR1.Reg) & 0x200000) >> 21
}

// EXTI.CPUIMR2: EXTI interrupt mask register
func (o *EXTI_Type) SetCPUIMR2_MR0(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetCPUIMR2_MR0() uint32 {
	return volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x1
}
func (o *EXTI_Type) SetCPUIMR2_MR1(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetCPUIMR2_MR1() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetCPUIMR2_MR2(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetCPUIMR2_MR2() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetCPUIMR2_MR3(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetCPUIMR2_MR3() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetCPUIMR2_MR4(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetCPUIMR2_MR4() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetCPUIMR2_MR5(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetCPUIMR2_MR5() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetCPUIMR2_MR6(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetCPUIMR2_MR6() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetCPUIMR2_MR7(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetCPUIMR2_MR7() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetCPUIMR2_MR8(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetCPUIMR2_MR8() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetCPUIMR2_MR9(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetCPUIMR2_MR9() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetCPUIMR2_MR10(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetCPUIMR2_MR10() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetCPUIMR2_MR11(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetCPUIMR2_MR11() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetCPUIMR2_MR12(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetCPUIMR2_MR12() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetCPUIMR2_MR14(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetCPUIMR2_MR14() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetCPUIMR2_MR15(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetCPUIMR2_MR15() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetCPUIMR2_MR16(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetCPUIMR2_MR16() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetCPUIMR2_MR17(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetCPUIMR2_MR17() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetCPUIMR2_MR18(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetCPUIMR2_MR18() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetCPUIMR2_MR19(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetCPUIMR2_MR19() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetCPUIMR2_MR20(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetCPUIMR2_MR20() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetCPUIMR2_MR21(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetCPUIMR2_MR21() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetCPUIMR2_MR22(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetCPUIMR2_MR22() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetCPUIMR2_MR23(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetCPUIMR2_MR23() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetCPUIMR2_MR24(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetCPUIMR2_MR24() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetCPUIMR2_MR25(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetCPUIMR2_MR25() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetCPUIMR2_MR26(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetCPUIMR2_MR26() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetCPUIMR2_MR27(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetCPUIMR2_MR27() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetCPUIMR2_MR28(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetCPUIMR2_MR28() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetCPUIMR2_MR29(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetCPUIMR2_MR29() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetCPUIMR2_MR30(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetCPUIMR2_MR30() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetCPUIMR2_MR31(value uint32) {
	volatile.StoreUint32(&o.CPUIMR2.Reg, volatile.LoadUint32(&o.CPUIMR2.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetCPUIMR2_MR31() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR2.Reg) & 0x80000000) >> 31
}

// EXTI.CPUEMR2: EXTI event mask register
func (o *EXTI_Type) SetCPUEMR2_MR32(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetCPUEMR2_MR32() uint32 {
	return volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x1
}
func (o *EXTI_Type) SetCPUEMR2_MR33(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetCPUEMR2_MR33() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetCPUEMR2_MR34(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetCPUEMR2_MR34() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetCPUEMR2_MR35(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetCPUEMR2_MR35() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetCPUEMR2_MR36(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetCPUEMR2_MR36() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetCPUEMR2_MR37(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetCPUEMR2_MR37() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetCPUEMR2_MR38(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetCPUEMR2_MR38() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetCPUEMR2_MR39(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetCPUEMR2_MR39() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetCPUEMR2_MR40(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetCPUEMR2_MR40() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetCPUEMR2_MR41(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetCPUEMR2_MR41() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetCPUEMR2_MR42(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetCPUEMR2_MR42() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetCPUEMR2_MR43(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetCPUEMR2_MR43() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetCPUEMR2_MR44(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetCPUEMR2_MR44() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetCPUEMR2_MR46(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetCPUEMR2_MR46() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetCPUEMR2_MR47(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetCPUEMR2_MR47() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetCPUEMR2_MR48(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetCPUEMR2_MR48() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetCPUEMR2_MR49(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetCPUEMR2_MR49() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetCPUEMR2_MR50(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetCPUEMR2_MR50() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetCPUEMR2_MR51(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetCPUEMR2_MR51() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetCPUEMR2_MR52(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetCPUEMR2_MR52() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetCPUEMR2_MR53(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetCPUEMR2_MR53() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetCPUEMR2_MR54(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetCPUEMR2_MR54() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetCPUEMR2_MR55(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetCPUEMR2_MR55() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetCPUEMR2_MR56(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetCPUEMR2_MR56() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetCPUEMR2_MR57(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetCPUEMR2_MR57() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetCPUEMR2_MR58(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetCPUEMR2_MR58() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetCPUEMR2_MR59(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetCPUEMR2_MR59() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetCPUEMR2_MR60(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetCPUEMR2_MR60() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetCPUEMR2_MR61(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetCPUEMR2_MR61() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetCPUEMR2_MR62(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetCPUEMR2_MR62() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetCPUEMR2_MR63(value uint32) {
	volatile.StoreUint32(&o.CPUEMR2.Reg, volatile.LoadUint32(&o.CPUEMR2.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetCPUEMR2_MR63() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR2.Reg) & 0x80000000) >> 31
}

// EXTI.CPUPR2: EXTI pending register
func (o *EXTI_Type) SetCPUPR2_PR49(value uint32) {
	volatile.StoreUint32(&o.CPUPR2.Reg, volatile.LoadUint32(&o.CPUPR2.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetCPUPR2_PR49() uint32 {
	return (volatile.LoadUint32(&o.CPUPR2.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetCPUPR2_PR51(value uint32) {
	volatile.StoreUint32(&o.CPUPR2.Reg, volatile.LoadUint32(&o.CPUPR2.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetCPUPR2_PR51() uint32 {
	return (volatile.LoadUint32(&o.CPUPR2.Reg) & 0x80000) >> 19
}

// EXTI.CPUIMR3: EXTI interrupt mask register
func (o *EXTI_Type) SetCPUIMR3_MR64(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetCPUIMR3_MR64() uint32 {
	return volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x1
}
func (o *EXTI_Type) SetCPUIMR3_MR65(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetCPUIMR3_MR65() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetCPUIMR3_MR66(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetCPUIMR3_MR66() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetCPUIMR3_MR67(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetCPUIMR3_MR67() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetCPUIMR3_MR68(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetCPUIMR3_MR68() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetCPUIMR3_MR69(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetCPUIMR3_MR69() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetCPUIMR3_MR70(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetCPUIMR3_MR70() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetCPUIMR3_MR71(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetCPUIMR3_MR71() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetCPUIMR3_MR72(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetCPUIMR3_MR72() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetCPUIMR3_MR73(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetCPUIMR3_MR73() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetCPUIMR3_MR74(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetCPUIMR3_MR74() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetCPUIMR3_MR75(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetCPUIMR3_MR75() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetCPUIMR3_MR76(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetCPUIMR3_MR76() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetCPUIMR3_MR77(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetCPUIMR3_MR77() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetCPUIMR3_MR78(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetCPUIMR3_MR78() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetCPUIMR3_MR79(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetCPUIMR3_MR79() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetCPUIMR3_MR80(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetCPUIMR3_MR80() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetCPUIMR3_MR82(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetCPUIMR3_MR82() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetCPUIMR3_MR84(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetCPUIMR3_MR84() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetCPUIMR3_MR85(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetCPUIMR3_MR85() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetCPUIMR3_MR86(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetCPUIMR3_MR86() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetCPUIMR3_MR87(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetCPUIMR3_MR87() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetCPUIMR3_MR88(value uint32) {
	volatile.StoreUint32(&o.CPUIMR3.Reg, volatile.LoadUint32(&o.CPUIMR3.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetCPUIMR3_MR88() uint32 {
	return (volatile.LoadUint32(&o.CPUIMR3.Reg) & 0x1000000) >> 24
}

// EXTI.CPUEMR3: EXTI event mask register
func (o *EXTI_Type) SetCPUEMR3_MR64(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetCPUEMR3_MR64() uint32 {
	return volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x1
}
func (o *EXTI_Type) SetCPUEMR3_MR65(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetCPUEMR3_MR65() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetCPUEMR3_MR66(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetCPUEMR3_MR66() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetCPUEMR3_MR67(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetCPUEMR3_MR67() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetCPUEMR3_MR68(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetCPUEMR3_MR68() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetCPUEMR3_MR69(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetCPUEMR3_MR69() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetCPUEMR3_MR70(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetCPUEMR3_MR70() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetCPUEMR3_MR71(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetCPUEMR3_MR71() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetCPUEMR3_MR72(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetCPUEMR3_MR72() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetCPUEMR3_MR73(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetCPUEMR3_MR73() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetCPUEMR3_MR74(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetCPUEMR3_MR74() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetCPUEMR3_MR75(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetCPUEMR3_MR75() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetCPUEMR3_MR76(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetCPUEMR3_MR76() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetCPUEMR3_MR77(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetCPUEMR3_MR77() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetCPUEMR3_MR78(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetCPUEMR3_MR78() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetCPUEMR3_MR79(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetCPUEMR3_MR79() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetCPUEMR3_MR80(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetCPUEMR3_MR80() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetCPUEMR3_MR82(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetCPUEMR3_MR82() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetCPUEMR3_MR84(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetCPUEMR3_MR84() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetCPUEMR3_MR85(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetCPUEMR3_MR85() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetCPUEMR3_MR86(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetCPUEMR3_MR86() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetCPUEMR3_MR87(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetCPUEMR3_MR87() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetCPUEMR3_MR88(value uint32) {
	volatile.StoreUint32(&o.CPUEMR3.Reg, volatile.LoadUint32(&o.CPUEMR3.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetCPUEMR3_MR88() uint32 {
	return (volatile.LoadUint32(&o.CPUEMR3.Reg) & 0x1000000) >> 24
}

// EXTI.CPUPR3: EXTI pending register
func (o *EXTI_Type) SetCPUPR3_PR82(value uint32) {
	volatile.StoreUint32(&o.CPUPR3.Reg, volatile.LoadUint32(&o.CPUPR3.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetCPUPR3_PR82() uint32 {
	return (volatile.LoadUint32(&o.CPUPR3.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetCPUPR3_PR84(value uint32) {
	volatile.StoreUint32(&o.CPUPR3.Reg, volatile.LoadUint32(&o.CPUPR3.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetCPUPR3_PR84() uint32 {
	return (volatile.LoadUint32(&o.CPUPR3.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetCPUPR3_PR85(value uint32) {
	volatile.StoreUint32(&o.CPUPR3.Reg, volatile.LoadUint32(&o.CPUPR3.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetCPUPR3_PR85() uint32 {
	return (volatile.LoadUint32(&o.CPUPR3.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetCPUPR3_PR86(value uint32) {
	volatile.StoreUint32(&o.CPUPR3.Reg, volatile.LoadUint32(&o.CPUPR3.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetCPUPR3_PR86() uint32 {
	return (volatile.LoadUint32(&o.CPUPR3.Reg) & 0x400000) >> 22
}

// Ethernet: media access control (MAC)
type Ethernet_Type struct {
	MACCR                              volatile.Register32 // 0x0
	MACECR                             volatile.Register32 // 0x4
	MACPFR                             volatile.Register32 // 0x8
	MACWTR                             volatile.Register32 // 0xC
	MACHT0R                            volatile.Register32 // 0x10
	MACHT1R                            volatile.Register32 // 0x14
	_                                  [56]byte
	MACVTR                             volatile.Register32 // 0x50
	_                                  [4]byte
	MACVHTR                            volatile.Register32 // 0x58
	_                                  [4]byte
	MACVIR                             volatile.Register32 // 0x60
	MACIVIR                            volatile.Register32 // 0x64
	_                                  [8]byte
	MACQTxFCR                          volatile.Register32 // 0x70
	_                                  [28]byte
	MACRxFCR                           volatile.Register32 // 0x90
	_                                  [28]byte
	MACISR                             volatile.Register32 // 0xB0
	MACIER                             volatile.Register32 // 0xB4
	MACRxTxSR                          volatile.Register32 // 0xB8
	_                                  [4]byte
	MACPCSR                            volatile.Register32 // 0xC0
	MACRWKPFR                          volatile.Register32 // 0xC4
	_                                  [8]byte
	MACLCSR                            volatile.Register32 // 0xD0
	MACLTCR                            volatile.Register32 // 0xD4
	MACLETR                            volatile.Register32 // 0xD8
	MAC1USTCR                          volatile.Register32 // 0xDC
	_                                  [48]byte
	MACVR                              volatile.Register32 // 0x110
	MACDR                              volatile.Register32 // 0x114
	_                                  [8]byte
	MACHWF1R                           volatile.Register32 // 0x120
	MACHWF2R                           volatile.Register32 // 0x124
	_                                  [216]byte
	MACMDIOAR                          volatile.Register32 // 0x200
	MACMDIODR                          volatile.Register32 // 0x204
	_                                  [248]byte
	MACA0HR                            volatile.Register32 // 0x300
	MACA0LR                            volatile.Register32 // 0x304
	MACA1HR                            volatile.Register32 // 0x308
	MACA1LR                            volatile.Register32 // 0x30C
	MACA2HR                            volatile.Register32 // 0x310
	MACA2LR                            volatile.Register32 // 0x314
	MACA3HR                            volatile.Register32 // 0x318
	MACA3LR                            volatile.Register32 // 0x31C
	_                                  [992]byte
	MMC_CONTROL                        volatile.Register32 // 0x700
	MMC_RX_INTERRUPT                   volatile.Register32 // 0x704
	MMC_TX_INTERRUPT                   volatile.Register32 // 0x708
	MMC_RX_INTERRUPT_MASK              volatile.Register32 // 0x70C
	MMC_TX_INTERRUPT_MASK              volatile.Register32 // 0x710
	_                                  [56]byte
	TX_SINGLE_COLLISION_GOOD_PACKETS   volatile.Register32 // 0x74C
	TX_MULTIPLE_COLLISION_GOOD_PACKETS volatile.Register32 // 0x750
	_                                  [20]byte
	TX_PACKET_COUNT_GOOD               volatile.Register32 // 0x768
	_                                  [40]byte
	RX_CRC_ERROR_PACKETS               volatile.Register32 // 0x794
	RX_ALIGNMENT_ERROR_PACKETS         volatile.Register32 // 0x798
	_                                  [40]byte
	RX_UNICAST_PACKETS_GOOD            volatile.Register32 // 0x7C4
	_                                  [36]byte
	TX_LPI_USEC_CNTR                   volatile.Register32 // 0x7EC
	TX_LPI_TRAN_CNTR                   volatile.Register32 // 0x7F0
	RX_LPI_USEC_CNTR                   volatile.Register32 // 0x7F4
	RX_LPI_TRAN_CNTR                   volatile.Register32 // 0x7F8
	_                                  [260]byte
	MACL3L4C0R                         volatile.Register32 // 0x900
	MACL4A0R                           volatile.Register32 // 0x904
	_                                  [8]byte
	MACL3A00R                          volatile.Register32 // 0x910
	MACL3A10R                          volatile.Register32 // 0x914
	MACL3A20                           volatile.Register32 // 0x918
	MACL3A30                           volatile.Register32 // 0x91C
	_                                  [16]byte
	MACL3L4C1R                         volatile.Register32 // 0x930
	MACL4A1R                           volatile.Register32 // 0x934
	_                                  [8]byte
	MACL3A01R                          volatile.Register32 // 0x940
	MACL3A11R                          volatile.Register32 // 0x944
	MACL3A21R                          volatile.Register32 // 0x948
	MACL3A31R                          volatile.Register32 // 0x94C
	_                                  [400]byte
	MACARPAR                           volatile.Register32 // 0xAE0
	_                                  [28]byte
	MACTSCR                            volatile.Register32 // 0xB00
	MACSSIR                            volatile.Register32 // 0xB04
	MACSTSR                            volatile.Register32 // 0xB08
	MACSTNR                            volatile.Register32 // 0xB0C
	MACSTSUR                           volatile.Register32 // 0xB10
	MACSTNUR                           volatile.Register32 // 0xB14
	MACTSAR                            volatile.Register32 // 0xB18
	_                                  [4]byte
	MACTSSR                            volatile.Register32 // 0xB20
	_                                  [12]byte
	MACTxTSSNR                         volatile.Register32 // 0xB30
	MACTxTSSSR                         volatile.Register32 // 0xB34
	_                                  [8]byte
	MACACR                             volatile.Register32 // 0xB40
	_                                  [4]byte
	MACATSNR                           volatile.Register32 // 0xB48
	MACATSSR                           volatile.Register32 // 0xB4C
	MACTSIACR                          volatile.Register32 // 0xB50
	MACTSEACR                          volatile.Register32 // 0xB54
	MACTSICNR                          volatile.Register32 // 0xB58
	MACTSECNR                          volatile.Register32 // 0xB5C
	_                                  [16]byte
	MACPPSCR                           volatile.Register32 // 0xB70
	_                                  [12]byte
	MACPPSTTSR                         volatile.Register32 // 0xB80
	MACPPSTTNR                         volatile.Register32 // 0xB84
	MACPPSIR                           volatile.Register32 // 0xB88
	MACPPSWR                           volatile.Register32 // 0xB8C
	_                                  [48]byte
	MACPOCR                            volatile.Register32 // 0xBC0
	MACSPI0R                           volatile.Register32 // 0xBC4
	MACSPI1R                           volatile.Register32 // 0xBC8
	MACSPI2R                           volatile.Register32 // 0xBCC
	MACLMIR                            volatile.Register32 // 0xBD0
}

// Ethernet.MACCR: Operating mode configuration register
func (o *Ethernet_Type) SetMACCR_RE(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACCR_RE() uint32 {
	return volatile.LoadUint32(&o.MACCR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACCR_TE(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x2)|value<<1)
}
func (o *Ethernet_Type) GetMACCR_TE() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x2) >> 1
}
func (o *Ethernet_Type) SetMACCR_PRELEN(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0xc)|value<<2)
}
func (o *Ethernet_Type) GetMACCR_PRELEN() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0xc) >> 2
}
func (o *Ethernet_Type) SetMACCR_DC(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x10)|value<<4)
}
func (o *Ethernet_Type) GetMACCR_DC() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x10) >> 4
}
func (o *Ethernet_Type) SetMACCR_BL(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x60)|value<<5)
}
func (o *Ethernet_Type) GetMACCR_BL() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x60) >> 5
}
func (o *Ethernet_Type) SetMACCR_DR(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x100)|value<<8)
}
func (o *Ethernet_Type) GetMACCR_DR() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x100) >> 8
}
func (o *Ethernet_Type) SetMACCR_DCRS(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x200)|value<<9)
}
func (o *Ethernet_Type) GetMACCR_DCRS() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x200) >> 9
}
func (o *Ethernet_Type) SetMACCR_DO(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x400)|value<<10)
}
func (o *Ethernet_Type) GetMACCR_DO() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x400) >> 10
}
func (o *Ethernet_Type) SetMACCR_ECRSFD(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x800)|value<<11)
}
func (o *Ethernet_Type) GetMACCR_ECRSFD() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x800) >> 11
}
func (o *Ethernet_Type) SetMACCR_LM(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x1000)|value<<12)
}
func (o *Ethernet_Type) GetMACCR_LM() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x1000) >> 12
}
func (o *Ethernet_Type) SetMACCR_DM(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x2000)|value<<13)
}
func (o *Ethernet_Type) GetMACCR_DM() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x2000) >> 13
}
func (o *Ethernet_Type) SetMACCR_FES(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x4000)|value<<14)
}
func (o *Ethernet_Type) GetMACCR_FES() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x4000) >> 14
}
func (o *Ethernet_Type) SetMACCR_JE(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x10000)|value<<16)
}
func (o *Ethernet_Type) GetMACCR_JE() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x10000) >> 16
}
func (o *Ethernet_Type) SetMACCR_JD(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x20000)|value<<17)
}
func (o *Ethernet_Type) GetMACCR_JD() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x20000) >> 17
}
func (o *Ethernet_Type) SetMACCR_WD(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x80000)|value<<19)
}
func (o *Ethernet_Type) GetMACCR_WD() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x80000) >> 19
}
func (o *Ethernet_Type) SetMACCR_ACS(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x100000)|value<<20)
}
func (o *Ethernet_Type) GetMACCR_ACS() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x100000) >> 20
}
func (o *Ethernet_Type) SetMACCR_CST(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x200000)|value<<21)
}
func (o *Ethernet_Type) GetMACCR_CST() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x200000) >> 21
}
func (o *Ethernet_Type) SetMACCR_S2KP(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x400000)|value<<22)
}
func (o *Ethernet_Type) GetMACCR_S2KP() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x400000) >> 22
}
func (o *Ethernet_Type) SetMACCR_GPSLCE(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x800000)|value<<23)
}
func (o *Ethernet_Type) GetMACCR_GPSLCE() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x800000) >> 23
}
func (o *Ethernet_Type) SetMACCR_IPG(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x7000000)|value<<24)
}
func (o *Ethernet_Type) GetMACCR_IPG() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x7000000) >> 24
}
func (o *Ethernet_Type) SetMACCR_IPC(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x8000000)|value<<27)
}
func (o *Ethernet_Type) GetMACCR_IPC() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x8000000) >> 27
}
func (o *Ethernet_Type) SetMACCR_SARC(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x70000000)|value<<28)
}
func (o *Ethernet_Type) GetMACCR_SARC() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x70000000) >> 28
}
func (o *Ethernet_Type) SetMACCR_ARPEN(value uint32) {
	volatile.StoreUint32(&o.MACCR.Reg, volatile.LoadUint32(&o.MACCR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACCR_ARPEN() uint32 {
	return (volatile.LoadUint32(&o.MACCR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACECR: Extended operating mode configuration register
func (o *Ethernet_Type) SetMACECR_GPSL(value uint32) {
	volatile.StoreUint32(&o.MACECR.Reg, volatile.LoadUint32(&o.MACECR.Reg)&^(0x3fff)|value)
}
func (o *Ethernet_Type) GetMACECR_GPSL() uint32 {
	return volatile.LoadUint32(&o.MACECR.Reg) & 0x3fff
}
func (o *Ethernet_Type) SetMACECR_DCRCC(value uint32) {
	volatile.StoreUint32(&o.MACECR.Reg, volatile.LoadUint32(&o.MACECR.Reg)&^(0x10000)|value<<16)
}
func (o *Ethernet_Type) GetMACECR_DCRCC() uint32 {
	return (volatile.LoadUint32(&o.MACECR.Reg) & 0x10000) >> 16
}
func (o *Ethernet_Type) SetMACECR_SPEN(value uint32) {
	volatile.StoreUint32(&o.MACECR.Reg, volatile.LoadUint32(&o.MACECR.Reg)&^(0x20000)|value<<17)
}
func (o *Ethernet_Type) GetMACECR_SPEN() uint32 {
	return (volatile.LoadUint32(&o.MACECR.Reg) & 0x20000) >> 17
}
func (o *Ethernet_Type) SetMACECR_USP(value uint32) {
	volatile.StoreUint32(&o.MACECR.Reg, volatile.LoadUint32(&o.MACECR.Reg)&^(0x40000)|value<<18)
}
func (o *Ethernet_Type) GetMACECR_USP() uint32 {
	return (volatile.LoadUint32(&o.MACECR.Reg) & 0x40000) >> 18
}
func (o *Ethernet_Type) SetMACECR_EIPGEN(value uint32) {
	volatile.StoreUint32(&o.MACECR.Reg, volatile.LoadUint32(&o.MACECR.Reg)&^(0x1000000)|value<<24)
}
func (o *Ethernet_Type) GetMACECR_EIPGEN() uint32 {
	return (volatile.LoadUint32(&o.MACECR.Reg) & 0x1000000) >> 24
}
func (o *Ethernet_Type) SetMACECR_EIPG(value uint32) {
	volatile.StoreUint32(&o.MACECR.Reg, volatile.LoadUint32(&o.MACECR.Reg)&^(0x3e000000)|value<<25)
}
func (o *Ethernet_Type) GetMACECR_EIPG() uint32 {
	return (volatile.LoadUint32(&o.MACECR.Reg) & 0x3e000000) >> 25
}

// Ethernet.MACPFR: Packet filtering control register
func (o *Ethernet_Type) SetMACPFR_PR(value uint32) {
	volatile.StoreUint32(&o.MACPFR.Reg, volatile.LoadUint32(&o.MACPFR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACPFR_PR() uint32 {
	return volatile.LoadUint32(&o.MACPFR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACPFR_HUC(value uint32) {
	volatile.StoreUint32(&o.MACPFR.Reg, volatile.LoadUint32(&o.MACPFR.Reg)&^(0x2)|value<<1)
}
func (o *Ethernet_Type) GetMACPFR_HUC() uint32 {
	return (volatile.LoadUint32(&o.MACPFR.Reg) & 0x2) >> 1
}
func (o *Ethernet_Type) SetMACPFR_HMC(value uint32) {
	volatile.StoreUint32(&o.MACPFR.Reg, volatile.LoadUint32(&o.MACPFR.Reg)&^(0x4)|value<<2)
}
func (o *Ethernet_Type) GetMACPFR_HMC() uint32 {
	return (volatile.LoadUint32(&o.MACPFR.Reg) & 0x4) >> 2
}
func (o *Ethernet_Type) SetMACPFR_DAIF(value uint32) {
	volatile.StoreUint32(&o.MACPFR.Reg, volatile.LoadUint32(&o.MACPFR.Reg)&^(0x8)|value<<3)
}
func (o *Ethernet_Type) GetMACPFR_DAIF() uint32 {
	return (volatile.LoadUint32(&o.MACPFR.Reg) & 0x8) >> 3
}
func (o *Ethernet_Type) SetMACPFR_PM(value uint32) {
	volatile.StoreUint32(&o.MACPFR.Reg, volatile.LoadUint32(&o.MACPFR.Reg)&^(0x10)|value<<4)
}
func (o *Ethernet_Type) GetMACPFR_PM() uint32 {
	return (volatile.LoadUint32(&o.MACPFR.Reg) & 0x10) >> 4
}
func (o *Ethernet_Type) SetMACPFR_DBF(value uint32) {
	volatile.StoreUint32(&o.MACPFR.Reg, volatile.LoadUint32(&o.MACPFR.Reg)&^(0x20)|value<<5)
}
func (o *Ethernet_Type) GetMACPFR_DBF() uint32 {
	return (volatile.LoadUint32(&o.MACPFR.Reg) & 0x20) >> 5
}
func (o *Ethernet_Type) SetMACPFR_PCF(value uint32) {
	volatile.StoreUint32(&o.MACPFR.Reg, volatile.LoadUint32(&o.MACPFR.Reg)&^(0xc0)|value<<6)
}
func (o *Ethernet_Type) GetMACPFR_PCF() uint32 {
	return (volatile.LoadUint32(&o.MACPFR.Reg) & 0xc0) >> 6
}
func (o *Ethernet_Type) SetMACPFR_SAIF(value uint32) {
	volatile.StoreUint32(&o.MACPFR.Reg, volatile.LoadUint32(&o.MACPFR.Reg)&^(0x100)|value<<8)
}
func (o *Ethernet_Type) GetMACPFR_SAIF() uint32 {
	return (volatile.LoadUint32(&o.MACPFR.Reg) & 0x100) >> 8
}
func (o *Ethernet_Type) SetMACPFR_SAF(value uint32) {
	volatile.StoreUint32(&o.MACPFR.Reg, volatile.LoadUint32(&o.MACPFR.Reg)&^(0x200)|value<<9)
}
func (o *Ethernet_Type) GetMACPFR_SAF() uint32 {
	return (volatile.LoadUint32(&o.MACPFR.Reg) & 0x200) >> 9
}
func (o *Ethernet_Type) SetMACPFR_HPF(value uint32) {
	volatile.StoreUint32(&o.MACPFR.Reg, volatile.LoadUint32(&o.MACPFR.Reg)&^(0x400)|value<<10)
}
func (o *Ethernet_Type) GetMACPFR_HPF() uint32 {
	return (volatile.LoadUint32(&o.MACPFR.Reg) & 0x400) >> 10
}
func (o *Ethernet_Type) SetMACPFR_VTFE(value uint32) {
	volatile.StoreUint32(&o.MACPFR.Reg, volatile.LoadUint32(&o.MACPFR.Reg)&^(0x10000)|value<<16)
}
func (o *Ethernet_Type) GetMACPFR_VTFE() uint32 {
	return (volatile.LoadUint32(&o.MACPFR.Reg) & 0x10000) >> 16
}
func (o *Ethernet_Type) SetMACPFR_IPFE(value uint32) {
	volatile.StoreUint32(&o.MACPFR.Reg, volatile.LoadUint32(&o.MACPFR.Reg)&^(0x100000)|value<<20)
}
func (o *Ethernet_Type) GetMACPFR_IPFE() uint32 {
	return (volatile.LoadUint32(&o.MACPFR.Reg) & 0x100000) >> 20
}
func (o *Ethernet_Type) SetMACPFR_DNTU(value uint32) {
	volatile.StoreUint32(&o.MACPFR.Reg, volatile.LoadUint32(&o.MACPFR.Reg)&^(0x200000)|value<<21)
}
func (o *Ethernet_Type) GetMACPFR_DNTU() uint32 {
	return (volatile.LoadUint32(&o.MACPFR.Reg) & 0x200000) >> 21
}
func (o *Ethernet_Type) SetMACPFR_RA(value uint32) {
	volatile.StoreUint32(&o.MACPFR.Reg, volatile.LoadUint32(&o.MACPFR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACPFR_RA() uint32 {
	return (volatile.LoadUint32(&o.MACPFR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACWTR: Watchdog timeout register
func (o *Ethernet_Type) SetMACWTR_WTO(value uint32) {
	volatile.StoreUint32(&o.MACWTR.Reg, volatile.LoadUint32(&o.MACWTR.Reg)&^(0xf)|value)
}
func (o *Ethernet_Type) GetMACWTR_WTO() uint32 {
	return volatile.LoadUint32(&o.MACWTR.Reg) & 0xf
}
func (o *Ethernet_Type) SetMACWTR_PWE(value uint32) {
	volatile.StoreUint32(&o.MACWTR.Reg, volatile.LoadUint32(&o.MACWTR.Reg)&^(0x100)|value<<8)
}
func (o *Ethernet_Type) GetMACWTR_PWE() uint32 {
	return (volatile.LoadUint32(&o.MACWTR.Reg) & 0x100) >> 8
}

// Ethernet.MACHT0R: Hash Table 0 register
func (o *Ethernet_Type) SetMACHT0R(value uint32) {
	volatile.StoreUint32(&o.MACHT0R.Reg, value)
}
func (o *Ethernet_Type) GetMACHT0R() uint32 {
	return volatile.LoadUint32(&o.MACHT0R.Reg)
}

// Ethernet.MACHT1R: Hash Table 1 register
func (o *Ethernet_Type) SetMACHT1R(value uint32) {
	volatile.StoreUint32(&o.MACHT1R.Reg, value)
}
func (o *Ethernet_Type) GetMACHT1R() uint32 {
	return volatile.LoadUint32(&o.MACHT1R.Reg)
}

// Ethernet.MACVTR: VLAN tag register
func (o *Ethernet_Type) SetMACVTR_VL(value uint32) {
	volatile.StoreUint32(&o.MACVTR.Reg, volatile.LoadUint32(&o.MACVTR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACVTR_VL() uint32 {
	return volatile.LoadUint32(&o.MACVTR.Reg) & 0xffff
}
func (o *Ethernet_Type) SetMACVTR_ETV(value uint32) {
	volatile.StoreUint32(&o.MACVTR.Reg, volatile.LoadUint32(&o.MACVTR.Reg)&^(0x10000)|value<<16)
}
func (o *Ethernet_Type) GetMACVTR_ETV() uint32 {
	return (volatile.LoadUint32(&o.MACVTR.Reg) & 0x10000) >> 16
}
func (o *Ethernet_Type) SetMACVTR_VTIM(value uint32) {
	volatile.StoreUint32(&o.MACVTR.Reg, volatile.LoadUint32(&o.MACVTR.Reg)&^(0x20000)|value<<17)
}
func (o *Ethernet_Type) GetMACVTR_VTIM() uint32 {
	return (volatile.LoadUint32(&o.MACVTR.Reg) & 0x20000) >> 17
}
func (o *Ethernet_Type) SetMACVTR_ESVL(value uint32) {
	volatile.StoreUint32(&o.MACVTR.Reg, volatile.LoadUint32(&o.MACVTR.Reg)&^(0x40000)|value<<18)
}
func (o *Ethernet_Type) GetMACVTR_ESVL() uint32 {
	return (volatile.LoadUint32(&o.MACVTR.Reg) & 0x40000) >> 18
}
func (o *Ethernet_Type) SetMACVTR_ERSVLM(value uint32) {
	volatile.StoreUint32(&o.MACVTR.Reg, volatile.LoadUint32(&o.MACVTR.Reg)&^(0x80000)|value<<19)
}
func (o *Ethernet_Type) GetMACVTR_ERSVLM() uint32 {
	return (volatile.LoadUint32(&o.MACVTR.Reg) & 0x80000) >> 19
}
func (o *Ethernet_Type) SetMACVTR_DOVLTC(value uint32) {
	volatile.StoreUint32(&o.MACVTR.Reg, volatile.LoadUint32(&o.MACVTR.Reg)&^(0x100000)|value<<20)
}
func (o *Ethernet_Type) GetMACVTR_DOVLTC() uint32 {
	return (volatile.LoadUint32(&o.MACVTR.Reg) & 0x100000) >> 20
}
func (o *Ethernet_Type) SetMACVTR_EVLS(value uint32) {
	volatile.StoreUint32(&o.MACVTR.Reg, volatile.LoadUint32(&o.MACVTR.Reg)&^(0x600000)|value<<21)
}
func (o *Ethernet_Type) GetMACVTR_EVLS() uint32 {
	return (volatile.LoadUint32(&o.MACVTR.Reg) & 0x600000) >> 21
}
func (o *Ethernet_Type) SetMACVTR_EVLRXS(value uint32) {
	volatile.StoreUint32(&o.MACVTR.Reg, volatile.LoadUint32(&o.MACVTR.Reg)&^(0x1000000)|value<<24)
}
func (o *Ethernet_Type) GetMACVTR_EVLRXS() uint32 {
	return (volatile.LoadUint32(&o.MACVTR.Reg) & 0x1000000) >> 24
}
func (o *Ethernet_Type) SetMACVTR_VTHM(value uint32) {
	volatile.StoreUint32(&o.MACVTR.Reg, volatile.LoadUint32(&o.MACVTR.Reg)&^(0x2000000)|value<<25)
}
func (o *Ethernet_Type) GetMACVTR_VTHM() uint32 {
	return (volatile.LoadUint32(&o.MACVTR.Reg) & 0x2000000) >> 25
}
func (o *Ethernet_Type) SetMACVTR_EDVLP(value uint32) {
	volatile.StoreUint32(&o.MACVTR.Reg, volatile.LoadUint32(&o.MACVTR.Reg)&^(0x4000000)|value<<26)
}
func (o *Ethernet_Type) GetMACVTR_EDVLP() uint32 {
	return (volatile.LoadUint32(&o.MACVTR.Reg) & 0x4000000) >> 26
}
func (o *Ethernet_Type) SetMACVTR_ERIVLT(value uint32) {
	volatile.StoreUint32(&o.MACVTR.Reg, volatile.LoadUint32(&o.MACVTR.Reg)&^(0x8000000)|value<<27)
}
func (o *Ethernet_Type) GetMACVTR_ERIVLT() uint32 {
	return (volatile.LoadUint32(&o.MACVTR.Reg) & 0x8000000) >> 27
}
func (o *Ethernet_Type) SetMACVTR_EIVLS(value uint32) {
	volatile.StoreUint32(&o.MACVTR.Reg, volatile.LoadUint32(&o.MACVTR.Reg)&^(0x30000000)|value<<28)
}
func (o *Ethernet_Type) GetMACVTR_EIVLS() uint32 {
	return (volatile.LoadUint32(&o.MACVTR.Reg) & 0x30000000) >> 28
}
func (o *Ethernet_Type) SetMACVTR_EIVLRXS(value uint32) {
	volatile.StoreUint32(&o.MACVTR.Reg, volatile.LoadUint32(&o.MACVTR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACVTR_EIVLRXS() uint32 {
	return (volatile.LoadUint32(&o.MACVTR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACVHTR: VLAN Hash table register
func (o *Ethernet_Type) SetMACVHTR_VLHT(value uint32) {
	volatile.StoreUint32(&o.MACVHTR.Reg, volatile.LoadUint32(&o.MACVHTR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACVHTR_VLHT() uint32 {
	return volatile.LoadUint32(&o.MACVHTR.Reg) & 0xffff
}

// Ethernet.MACVIR: VLAN inclusion register
func (o *Ethernet_Type) SetMACVIR_VLT(value uint32) {
	volatile.StoreUint32(&o.MACVIR.Reg, volatile.LoadUint32(&o.MACVIR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACVIR_VLT() uint32 {
	return volatile.LoadUint32(&o.MACVIR.Reg) & 0xffff
}
func (o *Ethernet_Type) SetMACVIR_VLC(value uint32) {
	volatile.StoreUint32(&o.MACVIR.Reg, volatile.LoadUint32(&o.MACVIR.Reg)&^(0x30000)|value<<16)
}
func (o *Ethernet_Type) GetMACVIR_VLC() uint32 {
	return (volatile.LoadUint32(&o.MACVIR.Reg) & 0x30000) >> 16
}
func (o *Ethernet_Type) SetMACVIR_VLP(value uint32) {
	volatile.StoreUint32(&o.MACVIR.Reg, volatile.LoadUint32(&o.MACVIR.Reg)&^(0x40000)|value<<18)
}
func (o *Ethernet_Type) GetMACVIR_VLP() uint32 {
	return (volatile.LoadUint32(&o.MACVIR.Reg) & 0x40000) >> 18
}
func (o *Ethernet_Type) SetMACVIR_CSVL(value uint32) {
	volatile.StoreUint32(&o.MACVIR.Reg, volatile.LoadUint32(&o.MACVIR.Reg)&^(0x80000)|value<<19)
}
func (o *Ethernet_Type) GetMACVIR_CSVL() uint32 {
	return (volatile.LoadUint32(&o.MACVIR.Reg) & 0x80000) >> 19
}
func (o *Ethernet_Type) SetMACVIR_VLTI(value uint32) {
	volatile.StoreUint32(&o.MACVIR.Reg, volatile.LoadUint32(&o.MACVIR.Reg)&^(0x100000)|value<<20)
}
func (o *Ethernet_Type) GetMACVIR_VLTI() uint32 {
	return (volatile.LoadUint32(&o.MACVIR.Reg) & 0x100000) >> 20
}

// Ethernet.MACIVIR: Inner VLAN inclusion register
func (o *Ethernet_Type) SetMACIVIR_VLT(value uint32) {
	volatile.StoreUint32(&o.MACIVIR.Reg, volatile.LoadUint32(&o.MACIVIR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACIVIR_VLT() uint32 {
	return volatile.LoadUint32(&o.MACIVIR.Reg) & 0xffff
}
func (o *Ethernet_Type) SetMACIVIR_VLC(value uint32) {
	volatile.StoreUint32(&o.MACIVIR.Reg, volatile.LoadUint32(&o.MACIVIR.Reg)&^(0x30000)|value<<16)
}
func (o *Ethernet_Type) GetMACIVIR_VLC() uint32 {
	return (volatile.LoadUint32(&o.MACIVIR.Reg) & 0x30000) >> 16
}
func (o *Ethernet_Type) SetMACIVIR_VLP(value uint32) {
	volatile.StoreUint32(&o.MACIVIR.Reg, volatile.LoadUint32(&o.MACIVIR.Reg)&^(0x40000)|value<<18)
}
func (o *Ethernet_Type) GetMACIVIR_VLP() uint32 {
	return (volatile.LoadUint32(&o.MACIVIR.Reg) & 0x40000) >> 18
}
func (o *Ethernet_Type) SetMACIVIR_CSVL(value uint32) {
	volatile.StoreUint32(&o.MACIVIR.Reg, volatile.LoadUint32(&o.MACIVIR.Reg)&^(0x80000)|value<<19)
}
func (o *Ethernet_Type) GetMACIVIR_CSVL() uint32 {
	return (volatile.LoadUint32(&o.MACIVIR.Reg) & 0x80000) >> 19
}
func (o *Ethernet_Type) SetMACIVIR_VLTI(value uint32) {
	volatile.StoreUint32(&o.MACIVIR.Reg, volatile.LoadUint32(&o.MACIVIR.Reg)&^(0x100000)|value<<20)
}
func (o *Ethernet_Type) GetMACIVIR_VLTI() uint32 {
	return (volatile.LoadUint32(&o.MACIVIR.Reg) & 0x100000) >> 20
}

// Ethernet.MACQTxFCR: Tx Queue flow control register
func (o *Ethernet_Type) SetMACQTxFCR_FCB_BPA(value uint32) {
	volatile.StoreUint32(&o.MACQTxFCR.Reg, volatile.LoadUint32(&o.MACQTxFCR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACQTxFCR_FCB_BPA() uint32 {
	return volatile.LoadUint32(&o.MACQTxFCR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACQTxFCR_TFE(value uint32) {
	volatile.StoreUint32(&o.MACQTxFCR.Reg, volatile.LoadUint32(&o.MACQTxFCR.Reg)&^(0x2)|value<<1)
}
func (o *Ethernet_Type) GetMACQTxFCR_TFE() uint32 {
	return (volatile.LoadUint32(&o.MACQTxFCR.Reg) & 0x2) >> 1
}
func (o *Ethernet_Type) SetMACQTxFCR_PLT(value uint32) {
	volatile.StoreUint32(&o.MACQTxFCR.Reg, volatile.LoadUint32(&o.MACQTxFCR.Reg)&^(0x70)|value<<4)
}
func (o *Ethernet_Type) GetMACQTxFCR_PLT() uint32 {
	return (volatile.LoadUint32(&o.MACQTxFCR.Reg) & 0x70) >> 4
}
func (o *Ethernet_Type) SetMACQTxFCR_DZPQ(value uint32) {
	volatile.StoreUint32(&o.MACQTxFCR.Reg, volatile.LoadUint32(&o.MACQTxFCR.Reg)&^(0x80)|value<<7)
}
func (o *Ethernet_Type) GetMACQTxFCR_DZPQ() uint32 {
	return (volatile.LoadUint32(&o.MACQTxFCR.Reg) & 0x80) >> 7
}
func (o *Ethernet_Type) SetMACQTxFCR_PT(value uint32) {
	volatile.StoreUint32(&o.MACQTxFCR.Reg, volatile.LoadUint32(&o.MACQTxFCR.Reg)&^(0xffff0000)|value<<16)
}
func (o *Ethernet_Type) GetMACQTxFCR_PT() uint32 {
	return (volatile.LoadUint32(&o.MACQTxFCR.Reg) & 0xffff0000) >> 16
}

// Ethernet.MACRxFCR: Rx flow control register
func (o *Ethernet_Type) SetMACRxFCR_RFE(value uint32) {
	volatile.StoreUint32(&o.MACRxFCR.Reg, volatile.LoadUint32(&o.MACRxFCR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACRxFCR_RFE() uint32 {
	return volatile.LoadUint32(&o.MACRxFCR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACRxFCR_UP(value uint32) {
	volatile.StoreUint32(&o.MACRxFCR.Reg, volatile.LoadUint32(&o.MACRxFCR.Reg)&^(0x2)|value<<1)
}
func (o *Ethernet_Type) GetMACRxFCR_UP() uint32 {
	return (volatile.LoadUint32(&o.MACRxFCR.Reg) & 0x2) >> 1
}

// Ethernet.MACISR: Interrupt status register
func (o *Ethernet_Type) SetMACISR_PHYIS(value uint32) {
	volatile.StoreUint32(&o.MACISR.Reg, volatile.LoadUint32(&o.MACISR.Reg)&^(0x8)|value<<3)
}
func (o *Ethernet_Type) GetMACISR_PHYIS() uint32 {
	return (volatile.LoadUint32(&o.MACISR.Reg) & 0x8) >> 3
}
func (o *Ethernet_Type) SetMACISR_PMTIS(value uint32) {
	volatile.StoreUint32(&o.MACISR.Reg, volatile.LoadUint32(&o.MACISR.Reg)&^(0x10)|value<<4)
}
func (o *Ethernet_Type) GetMACISR_PMTIS() uint32 {
	return (volatile.LoadUint32(&o.MACISR.Reg) & 0x10) >> 4
}
func (o *Ethernet_Type) SetMACISR_LPIIS(value uint32) {
	volatile.StoreUint32(&o.MACISR.Reg, volatile.LoadUint32(&o.MACISR.Reg)&^(0x20)|value<<5)
}
func (o *Ethernet_Type) GetMACISR_LPIIS() uint32 {
	return (volatile.LoadUint32(&o.MACISR.Reg) & 0x20) >> 5
}
func (o *Ethernet_Type) SetMACISR_MMCIS(value uint32) {
	volatile.StoreUint32(&o.MACISR.Reg, volatile.LoadUint32(&o.MACISR.Reg)&^(0x100)|value<<8)
}
func (o *Ethernet_Type) GetMACISR_MMCIS() uint32 {
	return (volatile.LoadUint32(&o.MACISR.Reg) & 0x100) >> 8
}
func (o *Ethernet_Type) SetMACISR_MMCRXIS(value uint32) {
	volatile.StoreUint32(&o.MACISR.Reg, volatile.LoadUint32(&o.MACISR.Reg)&^(0x200)|value<<9)
}
func (o *Ethernet_Type) GetMACISR_MMCRXIS() uint32 {
	return (volatile.LoadUint32(&o.MACISR.Reg) & 0x200) >> 9
}
func (o *Ethernet_Type) SetMACISR_MMCTXIS(value uint32) {
	volatile.StoreUint32(&o.MACISR.Reg, volatile.LoadUint32(&o.MACISR.Reg)&^(0x400)|value<<10)
}
func (o *Ethernet_Type) GetMACISR_MMCTXIS() uint32 {
	return (volatile.LoadUint32(&o.MACISR.Reg) & 0x400) >> 10
}
func (o *Ethernet_Type) SetMACISR_TSIS(value uint32) {
	volatile.StoreUint32(&o.MACISR.Reg, volatile.LoadUint32(&o.MACISR.Reg)&^(0x1000)|value<<12)
}
func (o *Ethernet_Type) GetMACISR_TSIS() uint32 {
	return (volatile.LoadUint32(&o.MACISR.Reg) & 0x1000) >> 12
}
func (o *Ethernet_Type) SetMACISR_TXSTSIS(value uint32) {
	volatile.StoreUint32(&o.MACISR.Reg, volatile.LoadUint32(&o.MACISR.Reg)&^(0x2000)|value<<13)
}
func (o *Ethernet_Type) GetMACISR_TXSTSIS() uint32 {
	return (volatile.LoadUint32(&o.MACISR.Reg) & 0x2000) >> 13
}
func (o *Ethernet_Type) SetMACISR_RXSTSIS(value uint32) {
	volatile.StoreUint32(&o.MACISR.Reg, volatile.LoadUint32(&o.MACISR.Reg)&^(0x4000)|value<<14)
}
func (o *Ethernet_Type) GetMACISR_RXSTSIS() uint32 {
	return (volatile.LoadUint32(&o.MACISR.Reg) & 0x4000) >> 14
}

// Ethernet.MACIER: Interrupt enable register
func (o *Ethernet_Type) SetMACIER_PHYIE(value uint32) {
	volatile.StoreUint32(&o.MACIER.Reg, volatile.LoadUint32(&o.MACIER.Reg)&^(0x8)|value<<3)
}
func (o *Ethernet_Type) GetMACIER_PHYIE() uint32 {
	return (volatile.LoadUint32(&o.MACIER.Reg) & 0x8) >> 3
}
func (o *Ethernet_Type) SetMACIER_PMTIE(value uint32) {
	volatile.StoreUint32(&o.MACIER.Reg, volatile.LoadUint32(&o.MACIER.Reg)&^(0x10)|value<<4)
}
func (o *Ethernet_Type) GetMACIER_PMTIE() uint32 {
	return (volatile.LoadUint32(&o.MACIER.Reg) & 0x10) >> 4
}
func (o *Ethernet_Type) SetMACIER_LPIIE(value uint32) {
	volatile.StoreUint32(&o.MACIER.Reg, volatile.LoadUint32(&o.MACIER.Reg)&^(0x20)|value<<5)
}
func (o *Ethernet_Type) GetMACIER_LPIIE() uint32 {
	return (volatile.LoadUint32(&o.MACIER.Reg) & 0x20) >> 5
}
func (o *Ethernet_Type) SetMACIER_TSIE(value uint32) {
	volatile.StoreUint32(&o.MACIER.Reg, volatile.LoadUint32(&o.MACIER.Reg)&^(0x1000)|value<<12)
}
func (o *Ethernet_Type) GetMACIER_TSIE() uint32 {
	return (volatile.LoadUint32(&o.MACIER.Reg) & 0x1000) >> 12
}
func (o *Ethernet_Type) SetMACIER_TXSTSIE(value uint32) {
	volatile.StoreUint32(&o.MACIER.Reg, volatile.LoadUint32(&o.MACIER.Reg)&^(0x2000)|value<<13)
}
func (o *Ethernet_Type) GetMACIER_TXSTSIE() uint32 {
	return (volatile.LoadUint32(&o.MACIER.Reg) & 0x2000) >> 13
}
func (o *Ethernet_Type) SetMACIER_RXSTSIE(value uint32) {
	volatile.StoreUint32(&o.MACIER.Reg, volatile.LoadUint32(&o.MACIER.Reg)&^(0x4000)|value<<14)
}
func (o *Ethernet_Type) GetMACIER_RXSTSIE() uint32 {
	return (volatile.LoadUint32(&o.MACIER.Reg) & 0x4000) >> 14
}

// Ethernet.MACRxTxSR: Rx Tx status register
func (o *Ethernet_Type) SetMACRxTxSR_TJT(value uint32) {
	volatile.StoreUint32(&o.MACRxTxSR.Reg, volatile.LoadUint32(&o.MACRxTxSR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACRxTxSR_TJT() uint32 {
	return volatile.LoadUint32(&o.MACRxTxSR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACRxTxSR_NCARR(value uint32) {
	volatile.StoreUint32(&o.MACRxTxSR.Reg, volatile.LoadUint32(&o.MACRxTxSR.Reg)&^(0x2)|value<<1)
}
func (o *Ethernet_Type) GetMACRxTxSR_NCARR() uint32 {
	return (volatile.LoadUint32(&o.MACRxTxSR.Reg) & 0x2) >> 1
}
func (o *Ethernet_Type) SetMACRxTxSR_LCARR(value uint32) {
	volatile.StoreUint32(&o.MACRxTxSR.Reg, volatile.LoadUint32(&o.MACRxTxSR.Reg)&^(0x4)|value<<2)
}
func (o *Ethernet_Type) GetMACRxTxSR_LCARR() uint32 {
	return (volatile.LoadUint32(&o.MACRxTxSR.Reg) & 0x4) >> 2
}
func (o *Ethernet_Type) SetMACRxTxSR_EXDEF(value uint32) {
	volatile.StoreUint32(&o.MACRxTxSR.Reg, volatile.LoadUint32(&o.MACRxTxSR.Reg)&^(0x8)|value<<3)
}
func (o *Ethernet_Type) GetMACRxTxSR_EXDEF() uint32 {
	return (volatile.LoadUint32(&o.MACRxTxSR.Reg) & 0x8) >> 3
}
func (o *Ethernet_Type) SetMACRxTxSR_LCOL(value uint32) {
	volatile.StoreUint32(&o.MACRxTxSR.Reg, volatile.LoadUint32(&o.MACRxTxSR.Reg)&^(0x10)|value<<4)
}
func (o *Ethernet_Type) GetMACRxTxSR_LCOL() uint32 {
	return (volatile.LoadUint32(&o.MACRxTxSR.Reg) & 0x10) >> 4
}
func (o *Ethernet_Type) SetMACRxTxSR_EXCOL(value uint32) {
	volatile.StoreUint32(&o.MACRxTxSR.Reg, volatile.LoadUint32(&o.MACRxTxSR.Reg)&^(0x20)|value<<5)
}
func (o *Ethernet_Type) GetMACRxTxSR_EXCOL() uint32 {
	return (volatile.LoadUint32(&o.MACRxTxSR.Reg) & 0x20) >> 5
}
func (o *Ethernet_Type) SetMACRxTxSR_RWT(value uint32) {
	volatile.StoreUint32(&o.MACRxTxSR.Reg, volatile.LoadUint32(&o.MACRxTxSR.Reg)&^(0x100)|value<<8)
}
func (o *Ethernet_Type) GetMACRxTxSR_RWT() uint32 {
	return (volatile.LoadUint32(&o.MACRxTxSR.Reg) & 0x100) >> 8
}

// Ethernet.MACPCSR: PMT control status register
func (o *Ethernet_Type) SetMACPCSR_PWRDWN(value uint32) {
	volatile.StoreUint32(&o.MACPCSR.Reg, volatile.LoadUint32(&o.MACPCSR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACPCSR_PWRDWN() uint32 {
	return volatile.LoadUint32(&o.MACPCSR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACPCSR_MGKPKTEN(value uint32) {
	volatile.StoreUint32(&o.MACPCSR.Reg, volatile.LoadUint32(&o.MACPCSR.Reg)&^(0x2)|value<<1)
}
func (o *Ethernet_Type) GetMACPCSR_MGKPKTEN() uint32 {
	return (volatile.LoadUint32(&o.MACPCSR.Reg) & 0x2) >> 1
}
func (o *Ethernet_Type) SetMACPCSR_RWKPKTEN(value uint32) {
	volatile.StoreUint32(&o.MACPCSR.Reg, volatile.LoadUint32(&o.MACPCSR.Reg)&^(0x4)|value<<2)
}
func (o *Ethernet_Type) GetMACPCSR_RWKPKTEN() uint32 {
	return (volatile.LoadUint32(&o.MACPCSR.Reg) & 0x4) >> 2
}
func (o *Ethernet_Type) SetMACPCSR_MGKPRCVD(value uint32) {
	volatile.StoreUint32(&o.MACPCSR.Reg, volatile.LoadUint32(&o.MACPCSR.Reg)&^(0x20)|value<<5)
}
func (o *Ethernet_Type) GetMACPCSR_MGKPRCVD() uint32 {
	return (volatile.LoadUint32(&o.MACPCSR.Reg) & 0x20) >> 5
}
func (o *Ethernet_Type) SetMACPCSR_RWKPRCVD(value uint32) {
	volatile.StoreUint32(&o.MACPCSR.Reg, volatile.LoadUint32(&o.MACPCSR.Reg)&^(0x40)|value<<6)
}
func (o *Ethernet_Type) GetMACPCSR_RWKPRCVD() uint32 {
	return (volatile.LoadUint32(&o.MACPCSR.Reg) & 0x40) >> 6
}
func (o *Ethernet_Type) SetMACPCSR_GLBLUCAST(value uint32) {
	volatile.StoreUint32(&o.MACPCSR.Reg, volatile.LoadUint32(&o.MACPCSR.Reg)&^(0x200)|value<<9)
}
func (o *Ethernet_Type) GetMACPCSR_GLBLUCAST() uint32 {
	return (volatile.LoadUint32(&o.MACPCSR.Reg) & 0x200) >> 9
}
func (o *Ethernet_Type) SetMACPCSR_RWKPFE(value uint32) {
	volatile.StoreUint32(&o.MACPCSR.Reg, volatile.LoadUint32(&o.MACPCSR.Reg)&^(0x400)|value<<10)
}
func (o *Ethernet_Type) GetMACPCSR_RWKPFE() uint32 {
	return (volatile.LoadUint32(&o.MACPCSR.Reg) & 0x400) >> 10
}
func (o *Ethernet_Type) SetMACPCSR_RWKPTR(value uint32) {
	volatile.StoreUint32(&o.MACPCSR.Reg, volatile.LoadUint32(&o.MACPCSR.Reg)&^(0x1f000000)|value<<24)
}
func (o *Ethernet_Type) GetMACPCSR_RWKPTR() uint32 {
	return (volatile.LoadUint32(&o.MACPCSR.Reg) & 0x1f000000) >> 24
}
func (o *Ethernet_Type) SetMACPCSR_RWKFILTRST(value uint32) {
	volatile.StoreUint32(&o.MACPCSR.Reg, volatile.LoadUint32(&o.MACPCSR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACPCSR_RWKFILTRST() uint32 {
	return (volatile.LoadUint32(&o.MACPCSR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACRWKPFR: Remove wakeup packet filter register
func (o *Ethernet_Type) SetMACRWKPFR(value uint32) {
	volatile.StoreUint32(&o.MACRWKPFR.Reg, value)
}
func (o *Ethernet_Type) GetMACRWKPFR() uint32 {
	return volatile.LoadUint32(&o.MACRWKPFR.Reg)
}

// Ethernet.MACLCSR: LPI control status register
func (o *Ethernet_Type) SetMACLCSR_TLPIEN(value uint32) {
	volatile.StoreUint32(&o.MACLCSR.Reg, volatile.LoadUint32(&o.MACLCSR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACLCSR_TLPIEN() uint32 {
	return volatile.LoadUint32(&o.MACLCSR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACLCSR_TLPIEX(value uint32) {
	volatile.StoreUint32(&o.MACLCSR.Reg, volatile.LoadUint32(&o.MACLCSR.Reg)&^(0x2)|value<<1)
}
func (o *Ethernet_Type) GetMACLCSR_TLPIEX() uint32 {
	return (volatile.LoadUint32(&o.MACLCSR.Reg) & 0x2) >> 1
}
func (o *Ethernet_Type) SetMACLCSR_RLPIEN(value uint32) {
	volatile.StoreUint32(&o.MACLCSR.Reg, volatile.LoadUint32(&o.MACLCSR.Reg)&^(0x4)|value<<2)
}
func (o *Ethernet_Type) GetMACLCSR_RLPIEN() uint32 {
	return (volatile.LoadUint32(&o.MACLCSR.Reg) & 0x4) >> 2
}
func (o *Ethernet_Type) SetMACLCSR_RLPIEX(value uint32) {
	volatile.StoreUint32(&o.MACLCSR.Reg, volatile.LoadUint32(&o.MACLCSR.Reg)&^(0x8)|value<<3)
}
func (o *Ethernet_Type) GetMACLCSR_RLPIEX() uint32 {
	return (volatile.LoadUint32(&o.MACLCSR.Reg) & 0x8) >> 3
}
func (o *Ethernet_Type) SetMACLCSR_TLPIST(value uint32) {
	volatile.StoreUint32(&o.MACLCSR.Reg, volatile.LoadUint32(&o.MACLCSR.Reg)&^(0x100)|value<<8)
}
func (o *Ethernet_Type) GetMACLCSR_TLPIST() uint32 {
	return (volatile.LoadUint32(&o.MACLCSR.Reg) & 0x100) >> 8
}
func (o *Ethernet_Type) SetMACLCSR_RLPIST(value uint32) {
	volatile.StoreUint32(&o.MACLCSR.Reg, volatile.LoadUint32(&o.MACLCSR.Reg)&^(0x200)|value<<9)
}
func (o *Ethernet_Type) GetMACLCSR_RLPIST() uint32 {
	return (volatile.LoadUint32(&o.MACLCSR.Reg) & 0x200) >> 9
}
func (o *Ethernet_Type) SetMACLCSR_LPIEN(value uint32) {
	volatile.StoreUint32(&o.MACLCSR.Reg, volatile.LoadUint32(&o.MACLCSR.Reg)&^(0x10000)|value<<16)
}
func (o *Ethernet_Type) GetMACLCSR_LPIEN() uint32 {
	return (volatile.LoadUint32(&o.MACLCSR.Reg) & 0x10000) >> 16
}
func (o *Ethernet_Type) SetMACLCSR_PLS(value uint32) {
	volatile.StoreUint32(&o.MACLCSR.Reg, volatile.LoadUint32(&o.MACLCSR.Reg)&^(0x20000)|value<<17)
}
func (o *Ethernet_Type) GetMACLCSR_PLS() uint32 {
	return (volatile.LoadUint32(&o.MACLCSR.Reg) & 0x20000) >> 17
}
func (o *Ethernet_Type) SetMACLCSR_PLSEN(value uint32) {
	volatile.StoreUint32(&o.MACLCSR.Reg, volatile.LoadUint32(&o.MACLCSR.Reg)&^(0x40000)|value<<18)
}
func (o *Ethernet_Type) GetMACLCSR_PLSEN() uint32 {
	return (volatile.LoadUint32(&o.MACLCSR.Reg) & 0x40000) >> 18
}
func (o *Ethernet_Type) SetMACLCSR_LPITXA(value uint32) {
	volatile.StoreUint32(&o.MACLCSR.Reg, volatile.LoadUint32(&o.MACLCSR.Reg)&^(0x80000)|value<<19)
}
func (o *Ethernet_Type) GetMACLCSR_LPITXA() uint32 {
	return (volatile.LoadUint32(&o.MACLCSR.Reg) & 0x80000) >> 19
}
func (o *Ethernet_Type) SetMACLCSR_LPITE(value uint32) {
	volatile.StoreUint32(&o.MACLCSR.Reg, volatile.LoadUint32(&o.MACLCSR.Reg)&^(0x100000)|value<<20)
}
func (o *Ethernet_Type) GetMACLCSR_LPITE() uint32 {
	return (volatile.LoadUint32(&o.MACLCSR.Reg) & 0x100000) >> 20
}
func (o *Ethernet_Type) SetMACLCSR_LPITCSE(value uint32) {
	volatile.StoreUint32(&o.MACLCSR.Reg, volatile.LoadUint32(&o.MACLCSR.Reg)&^(0x200000)|value<<21)
}
func (o *Ethernet_Type) GetMACLCSR_LPITCSE() uint32 {
	return (volatile.LoadUint32(&o.MACLCSR.Reg) & 0x200000) >> 21
}

// Ethernet.MACLTCR: LPI timers control register
func (o *Ethernet_Type) SetMACLTCR_TWT(value uint32) {
	volatile.StoreUint32(&o.MACLTCR.Reg, volatile.LoadUint32(&o.MACLTCR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACLTCR_TWT() uint32 {
	return volatile.LoadUint32(&o.MACLTCR.Reg) & 0xffff
}
func (o *Ethernet_Type) SetMACLTCR_LST(value uint32) {
	volatile.StoreUint32(&o.MACLTCR.Reg, volatile.LoadUint32(&o.MACLTCR.Reg)&^(0x3ff0000)|value<<16)
}
func (o *Ethernet_Type) GetMACLTCR_LST() uint32 {
	return (volatile.LoadUint32(&o.MACLTCR.Reg) & 0x3ff0000) >> 16
}

// Ethernet.MACLETR: LPI entry timer register
func (o *Ethernet_Type) SetMACLETR_LPIET(value uint32) {
	volatile.StoreUint32(&o.MACLETR.Reg, volatile.LoadUint32(&o.MACLETR.Reg)&^(0xffff8)|value<<3)
}
func (o *Ethernet_Type) GetMACLETR_LPIET() uint32 {
	return (volatile.LoadUint32(&o.MACLETR.Reg) & 0xffff8) >> 3
}

// Ethernet.MAC1USTCR: 1-microsecond-tick counter register
func (o *Ethernet_Type) SetMAC1USTCR_TIC_1US_CNTR(value uint32) {
	volatile.StoreUint32(&o.MAC1USTCR.Reg, volatile.LoadUint32(&o.MAC1USTCR.Reg)&^(0xfff)|value)
}
func (o *Ethernet_Type) GetMAC1USTCR_TIC_1US_CNTR() uint32 {
	return volatile.LoadUint32(&o.MAC1USTCR.Reg) & 0xfff
}

// Ethernet.MACVR: Version register
func (o *Ethernet_Type) SetMACVR_SNPSVER(value uint32) {
	volatile.StoreUint32(&o.MACVR.Reg, volatile.LoadUint32(&o.MACVR.Reg)&^(0xff)|value)
}
func (o *Ethernet_Type) GetMACVR_SNPSVER() uint32 {
	return volatile.LoadUint32(&o.MACVR.Reg) & 0xff
}
func (o *Ethernet_Type) SetMACVR_USERVER(value uint32) {
	volatile.StoreUint32(&o.MACVR.Reg, volatile.LoadUint32(&o.MACVR.Reg)&^(0xff00)|value<<8)
}
func (o *Ethernet_Type) GetMACVR_USERVER() uint32 {
	return (volatile.LoadUint32(&o.MACVR.Reg) & 0xff00) >> 8
}

// Ethernet.MACDR: Debug register
func (o *Ethernet_Type) SetMACDR_RPESTS(value uint32) {
	volatile.StoreUint32(&o.MACDR.Reg, volatile.LoadUint32(&o.MACDR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACDR_RPESTS() uint32 {
	return volatile.LoadUint32(&o.MACDR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACDR_RFCFCSTS(value uint32) {
	volatile.StoreUint32(&o.MACDR.Reg, volatile.LoadUint32(&o.MACDR.Reg)&^(0x6)|value<<1)
}
func (o *Ethernet_Type) GetMACDR_RFCFCSTS() uint32 {
	return (volatile.LoadUint32(&o.MACDR.Reg) & 0x6) >> 1
}
func (o *Ethernet_Type) SetMACDR_TPESTS(value uint32) {
	volatile.StoreUint32(&o.MACDR.Reg, volatile.LoadUint32(&o.MACDR.Reg)&^(0x10000)|value<<16)
}
func (o *Ethernet_Type) GetMACDR_TPESTS() uint32 {
	return (volatile.LoadUint32(&o.MACDR.Reg) & 0x10000) >> 16
}
func (o *Ethernet_Type) SetMACDR_TFCSTS(value uint32) {
	volatile.StoreUint32(&o.MACDR.Reg, volatile.LoadUint32(&o.MACDR.Reg)&^(0x60000)|value<<17)
}
func (o *Ethernet_Type) GetMACDR_TFCSTS() uint32 {
	return (volatile.LoadUint32(&o.MACDR.Reg) & 0x60000) >> 17
}

// Ethernet.MACHWF1R: HW feature 1 register
func (o *Ethernet_Type) SetMACHWF1R_RXFIFOSIZE(value uint32) {
	volatile.StoreUint32(&o.MACHWF1R.Reg, volatile.LoadUint32(&o.MACHWF1R.Reg)&^(0x1f)|value)
}
func (o *Ethernet_Type) GetMACHWF1R_RXFIFOSIZE() uint32 {
	return volatile.LoadUint32(&o.MACHWF1R.Reg) & 0x1f
}
func (o *Ethernet_Type) SetMACHWF1R_TXFIFOSIZE(value uint32) {
	volatile.StoreUint32(&o.MACHWF1R.Reg, volatile.LoadUint32(&o.MACHWF1R.Reg)&^(0x7c0)|value<<6)
}
func (o *Ethernet_Type) GetMACHWF1R_TXFIFOSIZE() uint32 {
	return (volatile.LoadUint32(&o.MACHWF1R.Reg) & 0x7c0) >> 6
}
func (o *Ethernet_Type) SetMACHWF1R_OSTEN(value uint32) {
	volatile.StoreUint32(&o.MACHWF1R.Reg, volatile.LoadUint32(&o.MACHWF1R.Reg)&^(0x800)|value<<11)
}
func (o *Ethernet_Type) GetMACHWF1R_OSTEN() uint32 {
	return (volatile.LoadUint32(&o.MACHWF1R.Reg) & 0x800) >> 11
}
func (o *Ethernet_Type) SetMACHWF1R_PTOEN(value uint32) {
	volatile.StoreUint32(&o.MACHWF1R.Reg, volatile.LoadUint32(&o.MACHWF1R.Reg)&^(0x1000)|value<<12)
}
func (o *Ethernet_Type) GetMACHWF1R_PTOEN() uint32 {
	return (volatile.LoadUint32(&o.MACHWF1R.Reg) & 0x1000) >> 12
}
func (o *Ethernet_Type) SetMACHWF1R_ADVTHWORD(value uint32) {
	volatile.StoreUint32(&o.MACHWF1R.Reg, volatile.LoadUint32(&o.MACHWF1R.Reg)&^(0x2000)|value<<13)
}
func (o *Ethernet_Type) GetMACHWF1R_ADVTHWORD() uint32 {
	return (volatile.LoadUint32(&o.MACHWF1R.Reg) & 0x2000) >> 13
}
func (o *Ethernet_Type) SetMACHWF1R_DCBEN(value uint32) {
	volatile.StoreUint32(&o.MACHWF1R.Reg, volatile.LoadUint32(&o.MACHWF1R.Reg)&^(0x10000)|value<<16)
}
func (o *Ethernet_Type) GetMACHWF1R_DCBEN() uint32 {
	return (volatile.LoadUint32(&o.MACHWF1R.Reg) & 0x10000) >> 16
}
func (o *Ethernet_Type) SetMACHWF1R_SPHEN(value uint32) {
	volatile.StoreUint32(&o.MACHWF1R.Reg, volatile.LoadUint32(&o.MACHWF1R.Reg)&^(0x20000)|value<<17)
}
func (o *Ethernet_Type) GetMACHWF1R_SPHEN() uint32 {
	return (volatile.LoadUint32(&o.MACHWF1R.Reg) & 0x20000) >> 17
}
func (o *Ethernet_Type) SetMACHWF1R_TSOEN(value uint32) {
	volatile.StoreUint32(&o.MACHWF1R.Reg, volatile.LoadUint32(&o.MACHWF1R.Reg)&^(0x40000)|value<<18)
}
func (o *Ethernet_Type) GetMACHWF1R_TSOEN() uint32 {
	return (volatile.LoadUint32(&o.MACHWF1R.Reg) & 0x40000) >> 18
}
func (o *Ethernet_Type) SetMACHWF1R_DBGMEMA(value uint32) {
	volatile.StoreUint32(&o.MACHWF1R.Reg, volatile.LoadUint32(&o.MACHWF1R.Reg)&^(0x80000)|value<<19)
}
func (o *Ethernet_Type) GetMACHWF1R_DBGMEMA() uint32 {
	return (volatile.LoadUint32(&o.MACHWF1R.Reg) & 0x80000) >> 19
}
func (o *Ethernet_Type) SetMACHWF1R_AVSEL(value uint32) {
	volatile.StoreUint32(&o.MACHWF1R.Reg, volatile.LoadUint32(&o.MACHWF1R.Reg)&^(0x100000)|value<<20)
}
func (o *Ethernet_Type) GetMACHWF1R_AVSEL() uint32 {
	return (volatile.LoadUint32(&o.MACHWF1R.Reg) & 0x100000) >> 20
}
func (o *Ethernet_Type) SetMACHWF1R_HASHTBLSZ(value uint32) {
	volatile.StoreUint32(&o.MACHWF1R.Reg, volatile.LoadUint32(&o.MACHWF1R.Reg)&^(0x3000000)|value<<24)
}
func (o *Ethernet_Type) GetMACHWF1R_HASHTBLSZ() uint32 {
	return (volatile.LoadUint32(&o.MACHWF1R.Reg) & 0x3000000) >> 24
}
func (o *Ethernet_Type) SetMACHWF1R_L3L4FNUM(value uint32) {
	volatile.StoreUint32(&o.MACHWF1R.Reg, volatile.LoadUint32(&o.MACHWF1R.Reg)&^(0x78000000)|value<<27)
}
func (o *Ethernet_Type) GetMACHWF1R_L3L4FNUM() uint32 {
	return (volatile.LoadUint32(&o.MACHWF1R.Reg) & 0x78000000) >> 27
}

// Ethernet.MACHWF2R: HW feature 2 register
func (o *Ethernet_Type) SetMACHWF2R_RXQCNT(value uint32) {
	volatile.StoreUint32(&o.MACHWF2R.Reg, volatile.LoadUint32(&o.MACHWF2R.Reg)&^(0xf)|value)
}
func (o *Ethernet_Type) GetMACHWF2R_RXQCNT() uint32 {
	return volatile.LoadUint32(&o.MACHWF2R.Reg) & 0xf
}
func (o *Ethernet_Type) SetMACHWF2R_TXQCNT(value uint32) {
	volatile.StoreUint32(&o.MACHWF2R.Reg, volatile.LoadUint32(&o.MACHWF2R.Reg)&^(0x3c0)|value<<6)
}
func (o *Ethernet_Type) GetMACHWF2R_TXQCNT() uint32 {
	return (volatile.LoadUint32(&o.MACHWF2R.Reg) & 0x3c0) >> 6
}
func (o *Ethernet_Type) SetMACHWF2R_RXCHCNT(value uint32) {
	volatile.StoreUint32(&o.MACHWF2R.Reg, volatile.LoadUint32(&o.MACHWF2R.Reg)&^(0xf000)|value<<12)
}
func (o *Ethernet_Type) GetMACHWF2R_RXCHCNT() uint32 {
	return (volatile.LoadUint32(&o.MACHWF2R.Reg) & 0xf000) >> 12
}
func (o *Ethernet_Type) SetMACHWF2R_TXCHCNT(value uint32) {
	volatile.StoreUint32(&o.MACHWF2R.Reg, volatile.LoadUint32(&o.MACHWF2R.Reg)&^(0x3c0000)|value<<18)
}
func (o *Ethernet_Type) GetMACHWF2R_TXCHCNT() uint32 {
	return (volatile.LoadUint32(&o.MACHWF2R.Reg) & 0x3c0000) >> 18
}
func (o *Ethernet_Type) SetMACHWF2R_PPSOUTNUM(value uint32) {
	volatile.StoreUint32(&o.MACHWF2R.Reg, volatile.LoadUint32(&o.MACHWF2R.Reg)&^(0x7000000)|value<<24)
}
func (o *Ethernet_Type) GetMACHWF2R_PPSOUTNUM() uint32 {
	return (volatile.LoadUint32(&o.MACHWF2R.Reg) & 0x7000000) >> 24
}
func (o *Ethernet_Type) SetMACHWF2R_AUXSNAPNUM(value uint32) {
	volatile.StoreUint32(&o.MACHWF2R.Reg, volatile.LoadUint32(&o.MACHWF2R.Reg)&^(0x70000000)|value<<28)
}
func (o *Ethernet_Type) GetMACHWF2R_AUXSNAPNUM() uint32 {
	return (volatile.LoadUint32(&o.MACHWF2R.Reg) & 0x70000000) >> 28
}

// Ethernet.MACMDIOAR: MDIO address register
func (o *Ethernet_Type) SetMACMDIOAR_MB(value uint32) {
	volatile.StoreUint32(&o.MACMDIOAR.Reg, volatile.LoadUint32(&o.MACMDIOAR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACMDIOAR_MB() uint32 {
	return volatile.LoadUint32(&o.MACMDIOAR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACMDIOAR_C45E(value uint32) {
	volatile.StoreUint32(&o.MACMDIOAR.Reg, volatile.LoadUint32(&o.MACMDIOAR.Reg)&^(0x2)|value<<1)
}
func (o *Ethernet_Type) GetMACMDIOAR_C45E() uint32 {
	return (volatile.LoadUint32(&o.MACMDIOAR.Reg) & 0x2) >> 1
}
func (o *Ethernet_Type) SetMACMDIOAR_GOC(value uint32) {
	volatile.StoreUint32(&o.MACMDIOAR.Reg, volatile.LoadUint32(&o.MACMDIOAR.Reg)&^(0xc)|value<<2)
}
func (o *Ethernet_Type) GetMACMDIOAR_GOC() uint32 {
	return (volatile.LoadUint32(&o.MACMDIOAR.Reg) & 0xc) >> 2
}
func (o *Ethernet_Type) SetMACMDIOAR_SKAP(value uint32) {
	volatile.StoreUint32(&o.MACMDIOAR.Reg, volatile.LoadUint32(&o.MACMDIOAR.Reg)&^(0x10)|value<<4)
}
func (o *Ethernet_Type) GetMACMDIOAR_SKAP() uint32 {
	return (volatile.LoadUint32(&o.MACMDIOAR.Reg) & 0x10) >> 4
}
func (o *Ethernet_Type) SetMACMDIOAR_CR(value uint32) {
	volatile.StoreUint32(&o.MACMDIOAR.Reg, volatile.LoadUint32(&o.MACMDIOAR.Reg)&^(0xf00)|value<<8)
}
func (o *Ethernet_Type) GetMACMDIOAR_CR() uint32 {
	return (volatile.LoadUint32(&o.MACMDIOAR.Reg) & 0xf00) >> 8
}
func (o *Ethernet_Type) SetMACMDIOAR_NTC(value uint32) {
	volatile.StoreUint32(&o.MACMDIOAR.Reg, volatile.LoadUint32(&o.MACMDIOAR.Reg)&^(0x7000)|value<<12)
}
func (o *Ethernet_Type) GetMACMDIOAR_NTC() uint32 {
	return (volatile.LoadUint32(&o.MACMDIOAR.Reg) & 0x7000) >> 12
}
func (o *Ethernet_Type) SetMACMDIOAR_RDA(value uint32) {
	volatile.StoreUint32(&o.MACMDIOAR.Reg, volatile.LoadUint32(&o.MACMDIOAR.Reg)&^(0x1f0000)|value<<16)
}
func (o *Ethernet_Type) GetMACMDIOAR_RDA() uint32 {
	return (volatile.LoadUint32(&o.MACMDIOAR.Reg) & 0x1f0000) >> 16
}
func (o *Ethernet_Type) SetMACMDIOAR_PA(value uint32) {
	volatile.StoreUint32(&o.MACMDIOAR.Reg, volatile.LoadUint32(&o.MACMDIOAR.Reg)&^(0x3e00000)|value<<21)
}
func (o *Ethernet_Type) GetMACMDIOAR_PA() uint32 {
	return (volatile.LoadUint32(&o.MACMDIOAR.Reg) & 0x3e00000) >> 21
}
func (o *Ethernet_Type) SetMACMDIOAR_BTB(value uint32) {
	volatile.StoreUint32(&o.MACMDIOAR.Reg, volatile.LoadUint32(&o.MACMDIOAR.Reg)&^(0x4000000)|value<<26)
}
func (o *Ethernet_Type) GetMACMDIOAR_BTB() uint32 {
	return (volatile.LoadUint32(&o.MACMDIOAR.Reg) & 0x4000000) >> 26
}
func (o *Ethernet_Type) SetMACMDIOAR_PSE(value uint32) {
	volatile.StoreUint32(&o.MACMDIOAR.Reg, volatile.LoadUint32(&o.MACMDIOAR.Reg)&^(0x8000000)|value<<27)
}
func (o *Ethernet_Type) GetMACMDIOAR_PSE() uint32 {
	return (volatile.LoadUint32(&o.MACMDIOAR.Reg) & 0x8000000) >> 27
}

// Ethernet.MACMDIODR: MDIO data register
func (o *Ethernet_Type) SetMACMDIODR_MD(value uint32) {
	volatile.StoreUint32(&o.MACMDIODR.Reg, volatile.LoadUint32(&o.MACMDIODR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACMDIODR_MD() uint32 {
	return volatile.LoadUint32(&o.MACMDIODR.Reg) & 0xffff
}
func (o *Ethernet_Type) SetMACMDIODR_RA(value uint32) {
	volatile.StoreUint32(&o.MACMDIODR.Reg, volatile.LoadUint32(&o.MACMDIODR.Reg)&^(0xffff0000)|value<<16)
}
func (o *Ethernet_Type) GetMACMDIODR_RA() uint32 {
	return (volatile.LoadUint32(&o.MACMDIODR.Reg) & 0xffff0000) >> 16
}

// Ethernet.MACA0HR: Address 0 high register
func (o *Ethernet_Type) SetMACA0HR_ADDRHI(value uint32) {
	volatile.StoreUint32(&o.MACA0HR.Reg, volatile.LoadUint32(&o.MACA0HR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACA0HR_ADDRHI() uint32 {
	return volatile.LoadUint32(&o.MACA0HR.Reg) & 0xffff
}
func (o *Ethernet_Type) SetMACA0HR_AE(value uint32) {
	volatile.StoreUint32(&o.MACA0HR.Reg, volatile.LoadUint32(&o.MACA0HR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACA0HR_AE() uint32 {
	return (volatile.LoadUint32(&o.MACA0HR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACA0LR: Address 0 low register
func (o *Ethernet_Type) SetMACA0LR(value uint32) {
	volatile.StoreUint32(&o.MACA0LR.Reg, value)
}
func (o *Ethernet_Type) GetMACA0LR() uint32 {
	return volatile.LoadUint32(&o.MACA0LR.Reg)
}

// Ethernet.MACA1HR: Address 1 high register
func (o *Ethernet_Type) SetMACA1HR_ADDRHI(value uint32) {
	volatile.StoreUint32(&o.MACA1HR.Reg, volatile.LoadUint32(&o.MACA1HR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACA1HR_ADDRHI() uint32 {
	return volatile.LoadUint32(&o.MACA1HR.Reg) & 0xffff
}
func (o *Ethernet_Type) SetMACA1HR_MBC(value uint32) {
	volatile.StoreUint32(&o.MACA1HR.Reg, volatile.LoadUint32(&o.MACA1HR.Reg)&^(0x3f000000)|value<<24)
}
func (o *Ethernet_Type) GetMACA1HR_MBC() uint32 {
	return (volatile.LoadUint32(&o.MACA1HR.Reg) & 0x3f000000) >> 24
}
func (o *Ethernet_Type) SetMACA1HR_SA(value uint32) {
	volatile.StoreUint32(&o.MACA1HR.Reg, volatile.LoadUint32(&o.MACA1HR.Reg)&^(0x40000000)|value<<30)
}
func (o *Ethernet_Type) GetMACA1HR_SA() uint32 {
	return (volatile.LoadUint32(&o.MACA1HR.Reg) & 0x40000000) >> 30
}
func (o *Ethernet_Type) SetMACA1HR_AE(value uint32) {
	volatile.StoreUint32(&o.MACA1HR.Reg, volatile.LoadUint32(&o.MACA1HR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACA1HR_AE() uint32 {
	return (volatile.LoadUint32(&o.MACA1HR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACA1LR: Address 1 low register
func (o *Ethernet_Type) SetMACA1LR(value uint32) {
	volatile.StoreUint32(&o.MACA1LR.Reg, value)
}
func (o *Ethernet_Type) GetMACA1LR() uint32 {
	return volatile.LoadUint32(&o.MACA1LR.Reg)
}

// Ethernet.MACA2HR: Address 2 high register
func (o *Ethernet_Type) SetMACA2HR_ADDRHI(value uint32) {
	volatile.StoreUint32(&o.MACA2HR.Reg, volatile.LoadUint32(&o.MACA2HR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACA2HR_ADDRHI() uint32 {
	return volatile.LoadUint32(&o.MACA2HR.Reg) & 0xffff
}
func (o *Ethernet_Type) SetMACA2HR_MBC(value uint32) {
	volatile.StoreUint32(&o.MACA2HR.Reg, volatile.LoadUint32(&o.MACA2HR.Reg)&^(0x3f000000)|value<<24)
}
func (o *Ethernet_Type) GetMACA2HR_MBC() uint32 {
	return (volatile.LoadUint32(&o.MACA2HR.Reg) & 0x3f000000) >> 24
}
func (o *Ethernet_Type) SetMACA2HR_SA(value uint32) {
	volatile.StoreUint32(&o.MACA2HR.Reg, volatile.LoadUint32(&o.MACA2HR.Reg)&^(0x40000000)|value<<30)
}
func (o *Ethernet_Type) GetMACA2HR_SA() uint32 {
	return (volatile.LoadUint32(&o.MACA2HR.Reg) & 0x40000000) >> 30
}
func (o *Ethernet_Type) SetMACA2HR_AE(value uint32) {
	volatile.StoreUint32(&o.MACA2HR.Reg, volatile.LoadUint32(&o.MACA2HR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACA2HR_AE() uint32 {
	return (volatile.LoadUint32(&o.MACA2HR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACA2LR: Address 2 low register
func (o *Ethernet_Type) SetMACA2LR(value uint32) {
	volatile.StoreUint32(&o.MACA2LR.Reg, value)
}
func (o *Ethernet_Type) GetMACA2LR() uint32 {
	return volatile.LoadUint32(&o.MACA2LR.Reg)
}

// Ethernet.MACA3HR: Address 3 high register
func (o *Ethernet_Type) SetMACA3HR_ADDRHI(value uint32) {
	volatile.StoreUint32(&o.MACA3HR.Reg, volatile.LoadUint32(&o.MACA3HR.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACA3HR_ADDRHI() uint32 {
	return volatile.LoadUint32(&o.MACA3HR.Reg) & 0xffff
}
func (o *Ethernet_Type) SetMACA3HR_MBC(value uint32) {
	volatile.StoreUint32(&o.MACA3HR.Reg, volatile.LoadUint32(&o.MACA3HR.Reg)&^(0x3f000000)|value<<24)
}
func (o *Ethernet_Type) GetMACA3HR_MBC() uint32 {
	return (volatile.LoadUint32(&o.MACA3HR.Reg) & 0x3f000000) >> 24
}
func (o *Ethernet_Type) SetMACA3HR_SA(value uint32) {
	volatile.StoreUint32(&o.MACA3HR.Reg, volatile.LoadUint32(&o.MACA3HR.Reg)&^(0x40000000)|value<<30)
}
func (o *Ethernet_Type) GetMACA3HR_SA() uint32 {
	return (volatile.LoadUint32(&o.MACA3HR.Reg) & 0x40000000) >> 30
}
func (o *Ethernet_Type) SetMACA3HR_AE(value uint32) {
	volatile.StoreUint32(&o.MACA3HR.Reg, volatile.LoadUint32(&o.MACA3HR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACA3HR_AE() uint32 {
	return (volatile.LoadUint32(&o.MACA3HR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACA3LR: Address 3 low register
func (o *Ethernet_Type) SetMACA3LR(value uint32) {
	volatile.StoreUint32(&o.MACA3LR.Reg, value)
}
func (o *Ethernet_Type) GetMACA3LR() uint32 {
	return volatile.LoadUint32(&o.MACA3LR.Reg)
}

// Ethernet.MMC_CONTROL: MMC control register
func (o *Ethernet_Type) SetMMC_CONTROL_CNTRST(value uint32) {
	volatile.StoreUint32(&o.MMC_CONTROL.Reg, volatile.LoadUint32(&o.MMC_CONTROL.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMMC_CONTROL_CNTRST() uint32 {
	return volatile.LoadUint32(&o.MMC_CONTROL.Reg) & 0x1
}
func (o *Ethernet_Type) SetMMC_CONTROL_CNTSTOPRO(value uint32) {
	volatile.StoreUint32(&o.MMC_CONTROL.Reg, volatile.LoadUint32(&o.MMC_CONTROL.Reg)&^(0x2)|value<<1)
}
func (o *Ethernet_Type) GetMMC_CONTROL_CNTSTOPRO() uint32 {
	return (volatile.LoadUint32(&o.MMC_CONTROL.Reg) & 0x2) >> 1
}
func (o *Ethernet_Type) SetMMC_CONTROL_RSTONRD(value uint32) {
	volatile.StoreUint32(&o.MMC_CONTROL.Reg, volatile.LoadUint32(&o.MMC_CONTROL.Reg)&^(0x4)|value<<2)
}
func (o *Ethernet_Type) GetMMC_CONTROL_RSTONRD() uint32 {
	return (volatile.LoadUint32(&o.MMC_CONTROL.Reg) & 0x4) >> 2
}
func (o *Ethernet_Type) SetMMC_CONTROL_CNTFREEZ(value uint32) {
	volatile.StoreUint32(&o.MMC_CONTROL.Reg, volatile.LoadUint32(&o.MMC_CONTROL.Reg)&^(0x8)|value<<3)
}
func (o *Ethernet_Type) GetMMC_CONTROL_CNTFREEZ() uint32 {
	return (volatile.LoadUint32(&o.MMC_CONTROL.Reg) & 0x8) >> 3
}
func (o *Ethernet_Type) SetMMC_CONTROL_CNTPRST(value uint32) {
	volatile.StoreUint32(&o.MMC_CONTROL.Reg, volatile.LoadUint32(&o.MMC_CONTROL.Reg)&^(0x10)|value<<4)
}
func (o *Ethernet_Type) GetMMC_CONTROL_CNTPRST() uint32 {
	return (volatile.LoadUint32(&o.MMC_CONTROL.Reg) & 0x10) >> 4
}
func (o *Ethernet_Type) SetMMC_CONTROL_CNTPRSTLVL(value uint32) {
	volatile.StoreUint32(&o.MMC_CONTROL.Reg, volatile.LoadUint32(&o.MMC_CONTROL.Reg)&^(0x20)|value<<5)
}
func (o *Ethernet_Type) GetMMC_CONTROL_CNTPRSTLVL() uint32 {
	return (volatile.LoadUint32(&o.MMC_CONTROL.Reg) & 0x20) >> 5
}
func (o *Ethernet_Type) SetMMC_CONTROL_UCDBC(value uint32) {
	volatile.StoreUint32(&o.MMC_CONTROL.Reg, volatile.LoadUint32(&o.MMC_CONTROL.Reg)&^(0x100)|value<<8)
}
func (o *Ethernet_Type) GetMMC_CONTROL_UCDBC() uint32 {
	return (volatile.LoadUint32(&o.MMC_CONTROL.Reg) & 0x100) >> 8
}

// Ethernet.MMC_RX_INTERRUPT: MMC Rx interrupt register
func (o *Ethernet_Type) SetMMC_RX_INTERRUPT_RXCRCERPIS(value uint32) {
	volatile.StoreUint32(&o.MMC_RX_INTERRUPT.Reg, volatile.LoadUint32(&o.MMC_RX_INTERRUPT.Reg)&^(0x20)|value<<5)
}
func (o *Ethernet_Type) GetMMC_RX_INTERRUPT_RXCRCERPIS() uint32 {
	return (volatile.LoadUint32(&o.MMC_RX_INTERRUPT.Reg) & 0x20) >> 5
}
func (o *Ethernet_Type) SetMMC_RX_INTERRUPT_RXALGNERPIS(value uint32) {
	volatile.StoreUint32(&o.MMC_RX_INTERRUPT.Reg, volatile.LoadUint32(&o.MMC_RX_INTERRUPT.Reg)&^(0x40)|value<<6)
}
func (o *Ethernet_Type) GetMMC_RX_INTERRUPT_RXALGNERPIS() uint32 {
	return (volatile.LoadUint32(&o.MMC_RX_INTERRUPT.Reg) & 0x40) >> 6
}
func (o *Ethernet_Type) SetMMC_RX_INTERRUPT_RXUCGPIS(value uint32) {
	volatile.StoreUint32(&o.MMC_RX_INTERRUPT.Reg, volatile.LoadUint32(&o.MMC_RX_INTERRUPT.Reg)&^(0x20000)|value<<17)
}
func (o *Ethernet_Type) GetMMC_RX_INTERRUPT_RXUCGPIS() uint32 {
	return (volatile.LoadUint32(&o.MMC_RX_INTERRUPT.Reg) & 0x20000) >> 17
}
func (o *Ethernet_Type) SetMMC_RX_INTERRUPT_RXLPIUSCIS(value uint32) {
	volatile.StoreUint32(&o.MMC_RX_INTERRUPT.Reg, volatile.LoadUint32(&o.MMC_RX_INTERRUPT.Reg)&^(0x4000000)|value<<26)
}
func (o *Ethernet_Type) GetMMC_RX_INTERRUPT_RXLPIUSCIS() uint32 {
	return (volatile.LoadUint32(&o.MMC_RX_INTERRUPT.Reg) & 0x4000000) >> 26
}
func (o *Ethernet_Type) SetMMC_RX_INTERRUPT_RXLPITRCIS(value uint32) {
	volatile.StoreUint32(&o.MMC_RX_INTERRUPT.Reg, volatile.LoadUint32(&o.MMC_RX_INTERRUPT.Reg)&^(0x8000000)|value<<27)
}
func (o *Ethernet_Type) GetMMC_RX_INTERRUPT_RXLPITRCIS() uint32 {
	return (volatile.LoadUint32(&o.MMC_RX_INTERRUPT.Reg) & 0x8000000) >> 27
}

// Ethernet.MMC_TX_INTERRUPT: MMC Tx interrupt register
func (o *Ethernet_Type) SetMMC_TX_INTERRUPT_TXSCOLGPIS(value uint32) {
	volatile.StoreUint32(&o.MMC_TX_INTERRUPT.Reg, volatile.LoadUint32(&o.MMC_TX_INTERRUPT.Reg)&^(0x4000)|value<<14)
}
func (o *Ethernet_Type) GetMMC_TX_INTERRUPT_TXSCOLGPIS() uint32 {
	return (volatile.LoadUint32(&o.MMC_TX_INTERRUPT.Reg) & 0x4000) >> 14
}
func (o *Ethernet_Type) SetMMC_TX_INTERRUPT_TXMCOLGPIS(value uint32) {
	volatile.StoreUint32(&o.MMC_TX_INTERRUPT.Reg, volatile.LoadUint32(&o.MMC_TX_INTERRUPT.Reg)&^(0x8000)|value<<15)
}
func (o *Ethernet_Type) GetMMC_TX_INTERRUPT_TXMCOLGPIS() uint32 {
	return (volatile.LoadUint32(&o.MMC_TX_INTERRUPT.Reg) & 0x8000) >> 15
}
func (o *Ethernet_Type) SetMMC_TX_INTERRUPT_TXGPKTIS(value uint32) {
	volatile.StoreUint32(&o.MMC_TX_INTERRUPT.Reg, volatile.LoadUint32(&o.MMC_TX_INTERRUPT.Reg)&^(0x200000)|value<<21)
}
func (o *Ethernet_Type) GetMMC_TX_INTERRUPT_TXGPKTIS() uint32 {
	return (volatile.LoadUint32(&o.MMC_TX_INTERRUPT.Reg) & 0x200000) >> 21
}
func (o *Ethernet_Type) SetMMC_TX_INTERRUPT_TXLPIUSCIS(value uint32) {
	volatile.StoreUint32(&o.MMC_TX_INTERRUPT.Reg, volatile.LoadUint32(&o.MMC_TX_INTERRUPT.Reg)&^(0x4000000)|value<<26)
}
func (o *Ethernet_Type) GetMMC_TX_INTERRUPT_TXLPIUSCIS() uint32 {
	return (volatile.LoadUint32(&o.MMC_TX_INTERRUPT.Reg) & 0x4000000) >> 26
}
func (o *Ethernet_Type) SetMMC_TX_INTERRUPT_TXLPITRCIS(value uint32) {
	volatile.StoreUint32(&o.MMC_TX_INTERRUPT.Reg, volatile.LoadUint32(&o.MMC_TX_INTERRUPT.Reg)&^(0x8000000)|value<<27)
}
func (o *Ethernet_Type) GetMMC_TX_INTERRUPT_TXLPITRCIS() uint32 {
	return (volatile.LoadUint32(&o.MMC_TX_INTERRUPT.Reg) & 0x8000000) >> 27
}

// Ethernet.MMC_RX_INTERRUPT_MASK: MMC Rx interrupt mask register
func (o *Ethernet_Type) SetMMC_RX_INTERRUPT_MASK_RXCRCERPIM(value uint32) {
	volatile.StoreUint32(&o.MMC_RX_INTERRUPT_MASK.Reg, volatile.LoadUint32(&o.MMC_RX_INTERRUPT_MASK.Reg)&^(0x20)|value<<5)
}
func (o *Ethernet_Type) GetMMC_RX_INTERRUPT_MASK_RXCRCERPIM() uint32 {
	return (volatile.LoadUint32(&o.MMC_RX_INTERRUPT_MASK.Reg) & 0x20) >> 5
}
func (o *Ethernet_Type) SetMMC_RX_INTERRUPT_MASK_RXALGNERPIM(value uint32) {
	volatile.StoreUint32(&o.MMC_RX_INTERRUPT_MASK.Reg, volatile.LoadUint32(&o.MMC_RX_INTERRUPT_MASK.Reg)&^(0x40)|value<<6)
}
func (o *Ethernet_Type) GetMMC_RX_INTERRUPT_MASK_RXALGNERPIM() uint32 {
	return (volatile.LoadUint32(&o.MMC_RX_INTERRUPT_MASK.Reg) & 0x40) >> 6
}
func (o *Ethernet_Type) SetMMC_RX_INTERRUPT_MASK_RXUCGPIM(value uint32) {
	volatile.StoreUint32(&o.MMC_RX_INTERRUPT_MASK.Reg, volatile.LoadUint32(&o.MMC_RX_INTERRUPT_MASK.Reg)&^(0x20000)|value<<17)
}
func (o *Ethernet_Type) GetMMC_RX_INTERRUPT_MASK_RXUCGPIM() uint32 {
	return (volatile.LoadUint32(&o.MMC_RX_INTERRUPT_MASK.Reg) & 0x20000) >> 17
}
func (o *Ethernet_Type) SetMMC_RX_INTERRUPT_MASK_RXLPIUSCIM(value uint32) {
	volatile.StoreUint32(&o.MMC_RX_INTERRUPT_MASK.Reg, volatile.LoadUint32(&o.MMC_RX_INTERRUPT_MASK.Reg)&^(0x4000000)|value<<26)
}
func (o *Ethernet_Type) GetMMC_RX_INTERRUPT_MASK_RXLPIUSCIM() uint32 {
	return (volatile.LoadUint32(&o.MMC_RX_INTERRUPT_MASK.Reg) & 0x4000000) >> 26
}
func (o *Ethernet_Type) SetMMC_RX_INTERRUPT_MASK_RXLPITRCIM(value uint32) {
	volatile.StoreUint32(&o.MMC_RX_INTERRUPT_MASK.Reg, volatile.LoadUint32(&o.MMC_RX_INTERRUPT_MASK.Reg)&^(0x8000000)|value<<27)
}
func (o *Ethernet_Type) GetMMC_RX_INTERRUPT_MASK_RXLPITRCIM() uint32 {
	return (volatile.LoadUint32(&o.MMC_RX_INTERRUPT_MASK.Reg) & 0x8000000) >> 27
}

// Ethernet.MMC_TX_INTERRUPT_MASK: MMC Tx interrupt mask register
func (o *Ethernet_Type) SetMMC_TX_INTERRUPT_MASK_TXSCOLGPIM(value uint32) {
	volatile.StoreUint32(&o.MMC_TX_INTERRUPT_MASK.Reg, volatile.LoadUint32(&o.MMC_TX_INTERRUPT_MASK.Reg)&^(0x4000)|value<<14)
}
func (o *Ethernet_Type) GetMMC_TX_INTERRUPT_MASK_TXSCOLGPIM() uint32 {
	return (volatile.LoadUint32(&o.MMC_TX_INTERRUPT_MASK.Reg) & 0x4000) >> 14
}
func (o *Ethernet_Type) SetMMC_TX_INTERRUPT_MASK_TXMCOLGPIM(value uint32) {
	volatile.StoreUint32(&o.MMC_TX_INTERRUPT_MASK.Reg, volatile.LoadUint32(&o.MMC_TX_INTERRUPT_MASK.Reg)&^(0x8000)|value<<15)
}
func (o *Ethernet_Type) GetMMC_TX_INTERRUPT_MASK_TXMCOLGPIM() uint32 {
	return (volatile.LoadUint32(&o.MMC_TX_INTERRUPT_MASK.Reg) & 0x8000) >> 15
}
func (o *Ethernet_Type) SetMMC_TX_INTERRUPT_MASK_TXGPKTIM(value uint32) {
	volatile.StoreUint32(&o.MMC_TX_INTERRUPT_MASK.Reg, volatile.LoadUint32(&o.MMC_TX_INTERRUPT_MASK.Reg)&^(0x200000)|value<<21)
}
func (o *Ethernet_Type) GetMMC_TX_INTERRUPT_MASK_TXGPKTIM() uint32 {
	return (volatile.LoadUint32(&o.MMC_TX_INTERRUPT_MASK.Reg) & 0x200000) >> 21
}
func (o *Ethernet_Type) SetMMC_TX_INTERRUPT_MASK_TXLPIUSCIM(value uint32) {
	volatile.StoreUint32(&o.MMC_TX_INTERRUPT_MASK.Reg, volatile.LoadUint32(&o.MMC_TX_INTERRUPT_MASK.Reg)&^(0x4000000)|value<<26)
}
func (o *Ethernet_Type) GetMMC_TX_INTERRUPT_MASK_TXLPIUSCIM() uint32 {
	return (volatile.LoadUint32(&o.MMC_TX_INTERRUPT_MASK.Reg) & 0x4000000) >> 26
}
func (o *Ethernet_Type) SetMMC_TX_INTERRUPT_MASK_TXLPITRCIM(value uint32) {
	volatile.StoreUint32(&o.MMC_TX_INTERRUPT_MASK.Reg, volatile.LoadUint32(&o.MMC_TX_INTERRUPT_MASK.Reg)&^(0x8000000)|value<<27)
}
func (o *Ethernet_Type) GetMMC_TX_INTERRUPT_MASK_TXLPITRCIM() uint32 {
	return (volatile.LoadUint32(&o.MMC_TX_INTERRUPT_MASK.Reg) & 0x8000000) >> 27
}

// Ethernet.TX_SINGLE_COLLISION_GOOD_PACKETS: Tx single collision good packets register
func (o *Ethernet_Type) SetTX_SINGLE_COLLISION_GOOD_PACKETS(value uint32) {
	volatile.StoreUint32(&o.TX_SINGLE_COLLISION_GOOD_PACKETS.Reg, value)
}
func (o *Ethernet_Type) GetTX_SINGLE_COLLISION_GOOD_PACKETS() uint32 {
	return volatile.LoadUint32(&o.TX_SINGLE_COLLISION_GOOD_PACKETS.Reg)
}

// Ethernet.TX_MULTIPLE_COLLISION_GOOD_PACKETS: Tx multiple collision good packets register
func (o *Ethernet_Type) SetTX_MULTIPLE_COLLISION_GOOD_PACKETS(value uint32) {
	volatile.StoreUint32(&o.TX_MULTIPLE_COLLISION_GOOD_PACKETS.Reg, value)
}
func (o *Ethernet_Type) GetTX_MULTIPLE_COLLISION_GOOD_PACKETS() uint32 {
	return volatile.LoadUint32(&o.TX_MULTIPLE_COLLISION_GOOD_PACKETS.Reg)
}

// Ethernet.TX_PACKET_COUNT_GOOD: Tx packet count good register
func (o *Ethernet_Type) SetTX_PACKET_COUNT_GOOD(value uint32) {
	volatile.StoreUint32(&o.TX_PACKET_COUNT_GOOD.Reg, value)
}
func (o *Ethernet_Type) GetTX_PACKET_COUNT_GOOD() uint32 {
	return volatile.LoadUint32(&o.TX_PACKET_COUNT_GOOD.Reg)
}

// Ethernet.RX_CRC_ERROR_PACKETS: Rx CRC error packets register
func (o *Ethernet_Type) SetRX_CRC_ERROR_PACKETS(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_ERROR_PACKETS.Reg, value)
}
func (o *Ethernet_Type) GetRX_CRC_ERROR_PACKETS() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_ERROR_PACKETS.Reg)
}

// Ethernet.RX_ALIGNMENT_ERROR_PACKETS: Rx alignment error packets register
func (o *Ethernet_Type) SetRX_ALIGNMENT_ERROR_PACKETS(value uint32) {
	volatile.StoreUint32(&o.RX_ALIGNMENT_ERROR_PACKETS.Reg, value)
}
func (o *Ethernet_Type) GetRX_ALIGNMENT_ERROR_PACKETS() uint32 {
	return volatile.LoadUint32(&o.RX_ALIGNMENT_ERROR_PACKETS.Reg)
}

// Ethernet.RX_UNICAST_PACKETS_GOOD: Rx unicast packets good register
func (o *Ethernet_Type) SetRX_UNICAST_PACKETS_GOOD(value uint32) {
	volatile.StoreUint32(&o.RX_UNICAST_PACKETS_GOOD.Reg, value)
}
func (o *Ethernet_Type) GetRX_UNICAST_PACKETS_GOOD() uint32 {
	return volatile.LoadUint32(&o.RX_UNICAST_PACKETS_GOOD.Reg)
}

// Ethernet.TX_LPI_USEC_CNTR: Tx LPI microsecond timer register
func (o *Ethernet_Type) SetTX_LPI_USEC_CNTR(value uint32) {
	volatile.StoreUint32(&o.TX_LPI_USEC_CNTR.Reg, value)
}
func (o *Ethernet_Type) GetTX_LPI_USEC_CNTR() uint32 {
	return volatile.LoadUint32(&o.TX_LPI_USEC_CNTR.Reg)
}

// Ethernet.TX_LPI_TRAN_CNTR: Tx LPI transition counter register
func (o *Ethernet_Type) SetTX_LPI_TRAN_CNTR(value uint32) {
	volatile.StoreUint32(&o.TX_LPI_TRAN_CNTR.Reg, value)
}
func (o *Ethernet_Type) GetTX_LPI_TRAN_CNTR() uint32 {
	return volatile.LoadUint32(&o.TX_LPI_TRAN_CNTR.Reg)
}

// Ethernet.RX_LPI_USEC_CNTR: Rx LPI microsecond counter register
func (o *Ethernet_Type) SetRX_LPI_USEC_CNTR(value uint32) {
	volatile.StoreUint32(&o.RX_LPI_USEC_CNTR.Reg, value)
}
func (o *Ethernet_Type) GetRX_LPI_USEC_CNTR() uint32 {
	return volatile.LoadUint32(&o.RX_LPI_USEC_CNTR.Reg)
}

// Ethernet.RX_LPI_TRAN_CNTR: Rx LPI transition counter register
func (o *Ethernet_Type) SetRX_LPI_TRAN_CNTR(value uint32) {
	volatile.StoreUint32(&o.RX_LPI_TRAN_CNTR.Reg, value)
}
func (o *Ethernet_Type) GetRX_LPI_TRAN_CNTR() uint32 {
	return volatile.LoadUint32(&o.RX_LPI_TRAN_CNTR.Reg)
}

// Ethernet.MACL3L4C0R: L3 and L4 control 0 register
func (o *Ethernet_Type) SetMACL3L4C0R_L3PEN0(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C0R.Reg, volatile.LoadUint32(&o.MACL3L4C0R.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACL3L4C0R_L3PEN0() uint32 {
	return volatile.LoadUint32(&o.MACL3L4C0R.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACL3L4C0R_L3SAM0(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C0R.Reg, volatile.LoadUint32(&o.MACL3L4C0R.Reg)&^(0x4)|value<<2)
}
func (o *Ethernet_Type) GetMACL3L4C0R_L3SAM0() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C0R.Reg) & 0x4) >> 2
}
func (o *Ethernet_Type) SetMACL3L4C0R_L3SAIM0(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C0R.Reg, volatile.LoadUint32(&o.MACL3L4C0R.Reg)&^(0x8)|value<<3)
}
func (o *Ethernet_Type) GetMACL3L4C0R_L3SAIM0() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C0R.Reg) & 0x8) >> 3
}
func (o *Ethernet_Type) SetMACL3L4C0R_L3DAM0(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C0R.Reg, volatile.LoadUint32(&o.MACL3L4C0R.Reg)&^(0x10)|value<<4)
}
func (o *Ethernet_Type) GetMACL3L4C0R_L3DAM0() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C0R.Reg) & 0x10) >> 4
}
func (o *Ethernet_Type) SetMACL3L4C0R_L3DAIM0(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C0R.Reg, volatile.LoadUint32(&o.MACL3L4C0R.Reg)&^(0x20)|value<<5)
}
func (o *Ethernet_Type) GetMACL3L4C0R_L3DAIM0() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C0R.Reg) & 0x20) >> 5
}
func (o *Ethernet_Type) SetMACL3L4C0R_L3HSBM0(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C0R.Reg, volatile.LoadUint32(&o.MACL3L4C0R.Reg)&^(0x7c0)|value<<6)
}
func (o *Ethernet_Type) GetMACL3L4C0R_L3HSBM0() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C0R.Reg) & 0x7c0) >> 6
}
func (o *Ethernet_Type) SetMACL3L4C0R_L3HDBM0(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C0R.Reg, volatile.LoadUint32(&o.MACL3L4C0R.Reg)&^(0xf800)|value<<11)
}
func (o *Ethernet_Type) GetMACL3L4C0R_L3HDBM0() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C0R.Reg) & 0xf800) >> 11
}
func (o *Ethernet_Type) SetMACL3L4C0R_L4PEN0(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C0R.Reg, volatile.LoadUint32(&o.MACL3L4C0R.Reg)&^(0x10000)|value<<16)
}
func (o *Ethernet_Type) GetMACL3L4C0R_L4PEN0() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C0R.Reg) & 0x10000) >> 16
}
func (o *Ethernet_Type) SetMACL3L4C0R_L4SPM0(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C0R.Reg, volatile.LoadUint32(&o.MACL3L4C0R.Reg)&^(0x40000)|value<<18)
}
func (o *Ethernet_Type) GetMACL3L4C0R_L4SPM0() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C0R.Reg) & 0x40000) >> 18
}
func (o *Ethernet_Type) SetMACL3L4C0R_L4SPIM0(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C0R.Reg, volatile.LoadUint32(&o.MACL3L4C0R.Reg)&^(0x80000)|value<<19)
}
func (o *Ethernet_Type) GetMACL3L4C0R_L4SPIM0() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C0R.Reg) & 0x80000) >> 19
}
func (o *Ethernet_Type) SetMACL3L4C0R_L4DPM0(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C0R.Reg, volatile.LoadUint32(&o.MACL3L4C0R.Reg)&^(0x100000)|value<<20)
}
func (o *Ethernet_Type) GetMACL3L4C0R_L4DPM0() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C0R.Reg) & 0x100000) >> 20
}
func (o *Ethernet_Type) SetMACL3L4C0R_L4DPIM0(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C0R.Reg, volatile.LoadUint32(&o.MACL3L4C0R.Reg)&^(0x200000)|value<<21)
}
func (o *Ethernet_Type) GetMACL3L4C0R_L4DPIM0() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C0R.Reg) & 0x200000) >> 21
}

// Ethernet.MACL4A0R: Layer4 address filter 0 register
func (o *Ethernet_Type) SetMACL4A0R_L4SP0(value uint32) {
	volatile.StoreUint32(&o.MACL4A0R.Reg, volatile.LoadUint32(&o.MACL4A0R.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACL4A0R_L4SP0() uint32 {
	return volatile.LoadUint32(&o.MACL4A0R.Reg) & 0xffff
}
func (o *Ethernet_Type) SetMACL4A0R_L4DP0(value uint32) {
	volatile.StoreUint32(&o.MACL4A0R.Reg, volatile.LoadUint32(&o.MACL4A0R.Reg)&^(0xffff0000)|value<<16)
}
func (o *Ethernet_Type) GetMACL4A0R_L4DP0() uint32 {
	return (volatile.LoadUint32(&o.MACL4A0R.Reg) & 0xffff0000) >> 16
}

// Ethernet.MACL3A00R: MACL3A00R
func (o *Ethernet_Type) SetMACL3A00R(value uint32) {
	volatile.StoreUint32(&o.MACL3A00R.Reg, value)
}
func (o *Ethernet_Type) GetMACL3A00R() uint32 {
	return volatile.LoadUint32(&o.MACL3A00R.Reg)
}

// Ethernet.MACL3A10R: Layer3 address 1 filter 0 register
func (o *Ethernet_Type) SetMACL3A10R(value uint32) {
	volatile.StoreUint32(&o.MACL3A10R.Reg, value)
}
func (o *Ethernet_Type) GetMACL3A10R() uint32 {
	return volatile.LoadUint32(&o.MACL3A10R.Reg)
}

// Ethernet.MACL3A20: Layer3 Address 2 filter 0 register
func (o *Ethernet_Type) SetMACL3A20(value uint32) {
	volatile.StoreUint32(&o.MACL3A20.Reg, value)
}
func (o *Ethernet_Type) GetMACL3A20() uint32 {
	return volatile.LoadUint32(&o.MACL3A20.Reg)
}

// Ethernet.MACL3A30: Layer3 Address 3 filter 0 register
func (o *Ethernet_Type) SetMACL3A30(value uint32) {
	volatile.StoreUint32(&o.MACL3A30.Reg, value)
}
func (o *Ethernet_Type) GetMACL3A30() uint32 {
	return volatile.LoadUint32(&o.MACL3A30.Reg)
}

// Ethernet.MACL3L4C1R: L3 and L4 control 1 register
func (o *Ethernet_Type) SetMACL3L4C1R_L3PEN1(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C1R.Reg, volatile.LoadUint32(&o.MACL3L4C1R.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACL3L4C1R_L3PEN1() uint32 {
	return volatile.LoadUint32(&o.MACL3L4C1R.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACL3L4C1R_L3SAM1(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C1R.Reg, volatile.LoadUint32(&o.MACL3L4C1R.Reg)&^(0x4)|value<<2)
}
func (o *Ethernet_Type) GetMACL3L4C1R_L3SAM1() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C1R.Reg) & 0x4) >> 2
}
func (o *Ethernet_Type) SetMACL3L4C1R_L3SAIM1(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C1R.Reg, volatile.LoadUint32(&o.MACL3L4C1R.Reg)&^(0x8)|value<<3)
}
func (o *Ethernet_Type) GetMACL3L4C1R_L3SAIM1() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C1R.Reg) & 0x8) >> 3
}
func (o *Ethernet_Type) SetMACL3L4C1R_L3DAM1(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C1R.Reg, volatile.LoadUint32(&o.MACL3L4C1R.Reg)&^(0x10)|value<<4)
}
func (o *Ethernet_Type) GetMACL3L4C1R_L3DAM1() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C1R.Reg) & 0x10) >> 4
}
func (o *Ethernet_Type) SetMACL3L4C1R_L3DAIM1(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C1R.Reg, volatile.LoadUint32(&o.MACL3L4C1R.Reg)&^(0x20)|value<<5)
}
func (o *Ethernet_Type) GetMACL3L4C1R_L3DAIM1() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C1R.Reg) & 0x20) >> 5
}
func (o *Ethernet_Type) SetMACL3L4C1R_L3HSBM1(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C1R.Reg, volatile.LoadUint32(&o.MACL3L4C1R.Reg)&^(0x7c0)|value<<6)
}
func (o *Ethernet_Type) GetMACL3L4C1R_L3HSBM1() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C1R.Reg) & 0x7c0) >> 6
}
func (o *Ethernet_Type) SetMACL3L4C1R_L3HDBM1(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C1R.Reg, volatile.LoadUint32(&o.MACL3L4C1R.Reg)&^(0xf800)|value<<11)
}
func (o *Ethernet_Type) GetMACL3L4C1R_L3HDBM1() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C1R.Reg) & 0xf800) >> 11
}
func (o *Ethernet_Type) SetMACL3L4C1R_L4PEN1(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C1R.Reg, volatile.LoadUint32(&o.MACL3L4C1R.Reg)&^(0x10000)|value<<16)
}
func (o *Ethernet_Type) GetMACL3L4C1R_L4PEN1() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C1R.Reg) & 0x10000) >> 16
}
func (o *Ethernet_Type) SetMACL3L4C1R_L4SPM1(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C1R.Reg, volatile.LoadUint32(&o.MACL3L4C1R.Reg)&^(0x40000)|value<<18)
}
func (o *Ethernet_Type) GetMACL3L4C1R_L4SPM1() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C1R.Reg) & 0x40000) >> 18
}
func (o *Ethernet_Type) SetMACL3L4C1R_L4SPIM1(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C1R.Reg, volatile.LoadUint32(&o.MACL3L4C1R.Reg)&^(0x80000)|value<<19)
}
func (o *Ethernet_Type) GetMACL3L4C1R_L4SPIM1() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C1R.Reg) & 0x80000) >> 19
}
func (o *Ethernet_Type) SetMACL3L4C1R_L4DPM1(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C1R.Reg, volatile.LoadUint32(&o.MACL3L4C1R.Reg)&^(0x100000)|value<<20)
}
func (o *Ethernet_Type) GetMACL3L4C1R_L4DPM1() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C1R.Reg) & 0x100000) >> 20
}
func (o *Ethernet_Type) SetMACL3L4C1R_L4DPIM1(value uint32) {
	volatile.StoreUint32(&o.MACL3L4C1R.Reg, volatile.LoadUint32(&o.MACL3L4C1R.Reg)&^(0x200000)|value<<21)
}
func (o *Ethernet_Type) GetMACL3L4C1R_L4DPIM1() uint32 {
	return (volatile.LoadUint32(&o.MACL3L4C1R.Reg) & 0x200000) >> 21
}

// Ethernet.MACL4A1R: Layer 4 address filter 1 register
func (o *Ethernet_Type) SetMACL4A1R_L4SP1(value uint32) {
	volatile.StoreUint32(&o.MACL4A1R.Reg, volatile.LoadUint32(&o.MACL4A1R.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACL4A1R_L4SP1() uint32 {
	return volatile.LoadUint32(&o.MACL4A1R.Reg) & 0xffff
}
func (o *Ethernet_Type) SetMACL4A1R_L4DP1(value uint32) {
	volatile.StoreUint32(&o.MACL4A1R.Reg, volatile.LoadUint32(&o.MACL4A1R.Reg)&^(0xffff0000)|value<<16)
}
func (o *Ethernet_Type) GetMACL4A1R_L4DP1() uint32 {
	return (volatile.LoadUint32(&o.MACL4A1R.Reg) & 0xffff0000) >> 16
}

// Ethernet.MACL3A01R: Layer3 address 0 filter 1 Register
func (o *Ethernet_Type) SetMACL3A01R(value uint32) {
	volatile.StoreUint32(&o.MACL3A01R.Reg, value)
}
func (o *Ethernet_Type) GetMACL3A01R() uint32 {
	return volatile.LoadUint32(&o.MACL3A01R.Reg)
}

// Ethernet.MACL3A11R: Layer3 address 1 filter 1 register
func (o *Ethernet_Type) SetMACL3A11R(value uint32) {
	volatile.StoreUint32(&o.MACL3A11R.Reg, value)
}
func (o *Ethernet_Type) GetMACL3A11R() uint32 {
	return volatile.LoadUint32(&o.MACL3A11R.Reg)
}

// Ethernet.MACL3A21R: Layer3 address 2 filter 1 Register
func (o *Ethernet_Type) SetMACL3A21R(value uint32) {
	volatile.StoreUint32(&o.MACL3A21R.Reg, value)
}
func (o *Ethernet_Type) GetMACL3A21R() uint32 {
	return volatile.LoadUint32(&o.MACL3A21R.Reg)
}

// Ethernet.MACL3A31R: Layer3 address 3 filter 1 register
func (o *Ethernet_Type) SetMACL3A31R(value uint32) {
	volatile.StoreUint32(&o.MACL3A31R.Reg, value)
}
func (o *Ethernet_Type) GetMACL3A31R() uint32 {
	return volatile.LoadUint32(&o.MACL3A31R.Reg)
}

// Ethernet.MACARPAR: ARP address register
func (o *Ethernet_Type) SetMACARPAR(value uint32) {
	volatile.StoreUint32(&o.MACARPAR.Reg, value)
}
func (o *Ethernet_Type) GetMACARPAR() uint32 {
	return volatile.LoadUint32(&o.MACARPAR.Reg)
}

// Ethernet.MACTSCR: Timestamp control Register
func (o *Ethernet_Type) SetMACTSCR_TSENA(value uint32) {
	volatile.StoreUint32(&o.MACTSCR.Reg, volatile.LoadUint32(&o.MACTSCR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACTSCR_TSENA() uint32 {
	return volatile.LoadUint32(&o.MACTSCR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACTSCR_TSCFUPDT(value uint32) {
	volatile.StoreUint32(&o.MACTSCR.Reg, volatile.LoadUint32(&o.MACTSCR.Reg)&^(0x2)|value<<1)
}
func (o *Ethernet_Type) GetMACTSCR_TSCFUPDT() uint32 {
	return (volatile.LoadUint32(&o.MACTSCR.Reg) & 0x2) >> 1
}
func (o *Ethernet_Type) SetMACTSCR_TSINIT(value uint32) {
	volatile.StoreUint32(&o.MACTSCR.Reg, volatile.LoadUint32(&o.MACTSCR.Reg)&^(0x4)|value<<2)
}
func (o *Ethernet_Type) GetMACTSCR_TSINIT() uint32 {
	return (volatile.LoadUint32(&o.MACTSCR.Reg) & 0x4) >> 2
}
func (o *Ethernet_Type) SetMACTSCR_TSUPDT(value uint32) {
	volatile.StoreUint32(&o.MACTSCR.Reg, volatile.LoadUint32(&o.MACTSCR.Reg)&^(0x8)|value<<3)
}
func (o *Ethernet_Type) GetMACTSCR_TSUPDT() uint32 {
	return (volatile.LoadUint32(&o.MACTSCR.Reg) & 0x8) >> 3
}
func (o *Ethernet_Type) SetMACTSCR_TSADDREG(value uint32) {
	volatile.StoreUint32(&o.MACTSCR.Reg, volatile.LoadUint32(&o.MACTSCR.Reg)&^(0x20)|value<<5)
}
func (o *Ethernet_Type) GetMACTSCR_TSADDREG() uint32 {
	return (volatile.LoadUint32(&o.MACTSCR.Reg) & 0x20) >> 5
}
func (o *Ethernet_Type) SetMACTSCR_TSENALL(value uint32) {
	volatile.StoreUint32(&o.MACTSCR.Reg, volatile.LoadUint32(&o.MACTSCR.Reg)&^(0x100)|value<<8)
}
func (o *Ethernet_Type) GetMACTSCR_TSENALL() uint32 {
	return (volatile.LoadUint32(&o.MACTSCR.Reg) & 0x100) >> 8
}
func (o *Ethernet_Type) SetMACTSCR_TSCTRLSSR(value uint32) {
	volatile.StoreUint32(&o.MACTSCR.Reg, volatile.LoadUint32(&o.MACTSCR.Reg)&^(0x200)|value<<9)
}
func (o *Ethernet_Type) GetMACTSCR_TSCTRLSSR() uint32 {
	return (volatile.LoadUint32(&o.MACTSCR.Reg) & 0x200) >> 9
}
func (o *Ethernet_Type) SetMACTSCR_TSVER2ENA(value uint32) {
	volatile.StoreUint32(&o.MACTSCR.Reg, volatile.LoadUint32(&o.MACTSCR.Reg)&^(0x400)|value<<10)
}
func (o *Ethernet_Type) GetMACTSCR_TSVER2ENA() uint32 {
	return (volatile.LoadUint32(&o.MACTSCR.Reg) & 0x400) >> 10
}
func (o *Ethernet_Type) SetMACTSCR_TSIPENA(value uint32) {
	volatile.StoreUint32(&o.MACTSCR.Reg, volatile.LoadUint32(&o.MACTSCR.Reg)&^(0x800)|value<<11)
}
func (o *Ethernet_Type) GetMACTSCR_TSIPENA() uint32 {
	return (volatile.LoadUint32(&o.MACTSCR.Reg) & 0x800) >> 11
}
func (o *Ethernet_Type) SetMACTSCR_TSIPV6ENA(value uint32) {
	volatile.StoreUint32(&o.MACTSCR.Reg, volatile.LoadUint32(&o.MACTSCR.Reg)&^(0x1000)|value<<12)
}
func (o *Ethernet_Type) GetMACTSCR_TSIPV6ENA() uint32 {
	return (volatile.LoadUint32(&o.MACTSCR.Reg) & 0x1000) >> 12
}
func (o *Ethernet_Type) SetMACTSCR_TSIPV4ENA(value uint32) {
	volatile.StoreUint32(&o.MACTSCR.Reg, volatile.LoadUint32(&o.MACTSCR.Reg)&^(0x2000)|value<<13)
}
func (o *Ethernet_Type) GetMACTSCR_TSIPV4ENA() uint32 {
	return (volatile.LoadUint32(&o.MACTSCR.Reg) & 0x2000) >> 13
}
func (o *Ethernet_Type) SetMACTSCR_TSEVNTENA(value uint32) {
	volatile.StoreUint32(&o.MACTSCR.Reg, volatile.LoadUint32(&o.MACTSCR.Reg)&^(0x4000)|value<<14)
}
func (o *Ethernet_Type) GetMACTSCR_TSEVNTENA() uint32 {
	return (volatile.LoadUint32(&o.MACTSCR.Reg) & 0x4000) >> 14
}
func (o *Ethernet_Type) SetMACTSCR_TSMSTRENA(value uint32) {
	volatile.StoreUint32(&o.MACTSCR.Reg, volatile.LoadUint32(&o.MACTSCR.Reg)&^(0x8000)|value<<15)
}
func (o *Ethernet_Type) GetMACTSCR_TSMSTRENA() uint32 {
	return (volatile.LoadUint32(&o.MACTSCR.Reg) & 0x8000) >> 15
}
func (o *Ethernet_Type) SetMACTSCR_SNAPTYPSEL(value uint32) {
	volatile.StoreUint32(&o.MACTSCR.Reg, volatile.LoadUint32(&o.MACTSCR.Reg)&^(0x30000)|value<<16)
}
func (o *Ethernet_Type) GetMACTSCR_SNAPTYPSEL() uint32 {
	return (volatile.LoadUint32(&o.MACTSCR.Reg) & 0x30000) >> 16
}
func (o *Ethernet_Type) SetMACTSCR_TSENMACADDR(value uint32) {
	volatile.StoreUint32(&o.MACTSCR.Reg, volatile.LoadUint32(&o.MACTSCR.Reg)&^(0x40000)|value<<18)
}
func (o *Ethernet_Type) GetMACTSCR_TSENMACADDR() uint32 {
	return (volatile.LoadUint32(&o.MACTSCR.Reg) & 0x40000) >> 18
}
func (o *Ethernet_Type) SetMACTSCR_CSC(value uint32) {
	volatile.StoreUint32(&o.MACTSCR.Reg, volatile.LoadUint32(&o.MACTSCR.Reg)&^(0x80000)|value<<19)
}
func (o *Ethernet_Type) GetMACTSCR_CSC() uint32 {
	return (volatile.LoadUint32(&o.MACTSCR.Reg) & 0x80000) >> 19
}
func (o *Ethernet_Type) SetMACTSCR_TXTSSTSM(value uint32) {
	volatile.StoreUint32(&o.MACTSCR.Reg, volatile.LoadUint32(&o.MACTSCR.Reg)&^(0x1000000)|value<<24)
}
func (o *Ethernet_Type) GetMACTSCR_TXTSSTSM() uint32 {
	return (volatile.LoadUint32(&o.MACTSCR.Reg) & 0x1000000) >> 24
}

// Ethernet.MACSSIR: Sub-second increment register
func (o *Ethernet_Type) SetMACSSIR_SNSINC(value uint32) {
	volatile.StoreUint32(&o.MACSSIR.Reg, volatile.LoadUint32(&o.MACSSIR.Reg)&^(0xff00)|value<<8)
}
func (o *Ethernet_Type) GetMACSSIR_SNSINC() uint32 {
	return (volatile.LoadUint32(&o.MACSSIR.Reg) & 0xff00) >> 8
}
func (o *Ethernet_Type) SetMACSSIR_SSINC(value uint32) {
	volatile.StoreUint32(&o.MACSSIR.Reg, volatile.LoadUint32(&o.MACSSIR.Reg)&^(0xff0000)|value<<16)
}
func (o *Ethernet_Type) GetMACSSIR_SSINC() uint32 {
	return (volatile.LoadUint32(&o.MACSSIR.Reg) & 0xff0000) >> 16
}

// Ethernet.MACSTSR: System time seconds register
func (o *Ethernet_Type) SetMACSTSR(value uint32) {
	volatile.StoreUint32(&o.MACSTSR.Reg, value)
}
func (o *Ethernet_Type) GetMACSTSR() uint32 {
	return volatile.LoadUint32(&o.MACSTSR.Reg)
}

// Ethernet.MACSTNR: System time nanoseconds register
func (o *Ethernet_Type) SetMACSTNR_TSSS(value uint32) {
	volatile.StoreUint32(&o.MACSTNR.Reg, volatile.LoadUint32(&o.MACSTNR.Reg)&^(0x7fffffff)|value)
}
func (o *Ethernet_Type) GetMACSTNR_TSSS() uint32 {
	return volatile.LoadUint32(&o.MACSTNR.Reg) & 0x7fffffff
}

// Ethernet.MACSTSUR: System time seconds update register
func (o *Ethernet_Type) SetMACSTSUR(value uint32) {
	volatile.StoreUint32(&o.MACSTSUR.Reg, value)
}
func (o *Ethernet_Type) GetMACSTSUR() uint32 {
	return volatile.LoadUint32(&o.MACSTSUR.Reg)
}

// Ethernet.MACSTNUR: System time nanoseconds update register
func (o *Ethernet_Type) SetMACSTNUR_TSSS(value uint32) {
	volatile.StoreUint32(&o.MACSTNUR.Reg, volatile.LoadUint32(&o.MACSTNUR.Reg)&^(0x7fffffff)|value)
}
func (o *Ethernet_Type) GetMACSTNUR_TSSS() uint32 {
	return volatile.LoadUint32(&o.MACSTNUR.Reg) & 0x7fffffff
}
func (o *Ethernet_Type) SetMACSTNUR_ADDSUB(value uint32) {
	volatile.StoreUint32(&o.MACSTNUR.Reg, volatile.LoadUint32(&o.MACSTNUR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACSTNUR_ADDSUB() uint32 {
	return (volatile.LoadUint32(&o.MACSTNUR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACTSAR: Timestamp addend register
func (o *Ethernet_Type) SetMACTSAR(value uint32) {
	volatile.StoreUint32(&o.MACTSAR.Reg, value)
}
func (o *Ethernet_Type) GetMACTSAR() uint32 {
	return volatile.LoadUint32(&o.MACTSAR.Reg)
}

// Ethernet.MACTSSR: Timestamp status register
func (o *Ethernet_Type) SetMACTSSR_TSSOVF(value uint32) {
	volatile.StoreUint32(&o.MACTSSR.Reg, volatile.LoadUint32(&o.MACTSSR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACTSSR_TSSOVF() uint32 {
	return volatile.LoadUint32(&o.MACTSSR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACTSSR_TSTARGT0(value uint32) {
	volatile.StoreUint32(&o.MACTSSR.Reg, volatile.LoadUint32(&o.MACTSSR.Reg)&^(0x2)|value<<1)
}
func (o *Ethernet_Type) GetMACTSSR_TSTARGT0() uint32 {
	return (volatile.LoadUint32(&o.MACTSSR.Reg) & 0x2) >> 1
}
func (o *Ethernet_Type) SetMACTSSR_AUXTSTRIG(value uint32) {
	volatile.StoreUint32(&o.MACTSSR.Reg, volatile.LoadUint32(&o.MACTSSR.Reg)&^(0x4)|value<<2)
}
func (o *Ethernet_Type) GetMACTSSR_AUXTSTRIG() uint32 {
	return (volatile.LoadUint32(&o.MACTSSR.Reg) & 0x4) >> 2
}
func (o *Ethernet_Type) SetMACTSSR_TSTRGTERR0(value uint32) {
	volatile.StoreUint32(&o.MACTSSR.Reg, volatile.LoadUint32(&o.MACTSSR.Reg)&^(0x8)|value<<3)
}
func (o *Ethernet_Type) GetMACTSSR_TSTRGTERR0() uint32 {
	return (volatile.LoadUint32(&o.MACTSSR.Reg) & 0x8) >> 3
}
func (o *Ethernet_Type) SetMACTSSR_TXTSSIS(value uint32) {
	volatile.StoreUint32(&o.MACTSSR.Reg, volatile.LoadUint32(&o.MACTSSR.Reg)&^(0x8000)|value<<15)
}
func (o *Ethernet_Type) GetMACTSSR_TXTSSIS() uint32 {
	return (volatile.LoadUint32(&o.MACTSSR.Reg) & 0x8000) >> 15
}
func (o *Ethernet_Type) SetMACTSSR_ATSSTN(value uint32) {
	volatile.StoreUint32(&o.MACTSSR.Reg, volatile.LoadUint32(&o.MACTSSR.Reg)&^(0xf0000)|value<<16)
}
func (o *Ethernet_Type) GetMACTSSR_ATSSTN() uint32 {
	return (volatile.LoadUint32(&o.MACTSSR.Reg) & 0xf0000) >> 16
}
func (o *Ethernet_Type) SetMACTSSR_ATSSTM(value uint32) {
	volatile.StoreUint32(&o.MACTSSR.Reg, volatile.LoadUint32(&o.MACTSSR.Reg)&^(0x1000000)|value<<24)
}
func (o *Ethernet_Type) GetMACTSSR_ATSSTM() uint32 {
	return (volatile.LoadUint32(&o.MACTSSR.Reg) & 0x1000000) >> 24
}
func (o *Ethernet_Type) SetMACTSSR_ATSNS(value uint32) {
	volatile.StoreUint32(&o.MACTSSR.Reg, volatile.LoadUint32(&o.MACTSSR.Reg)&^(0x3e000000)|value<<25)
}
func (o *Ethernet_Type) GetMACTSSR_ATSNS() uint32 {
	return (volatile.LoadUint32(&o.MACTSSR.Reg) & 0x3e000000) >> 25
}

// Ethernet.MACTxTSSNR: Tx timestamp status nanoseconds register
func (o *Ethernet_Type) SetMACTxTSSNR_TXTSSLO(value uint32) {
	volatile.StoreUint32(&o.MACTxTSSNR.Reg, volatile.LoadUint32(&o.MACTxTSSNR.Reg)&^(0x7fffffff)|value)
}
func (o *Ethernet_Type) GetMACTxTSSNR_TXTSSLO() uint32 {
	return volatile.LoadUint32(&o.MACTxTSSNR.Reg) & 0x7fffffff
}
func (o *Ethernet_Type) SetMACTxTSSNR_TXTSSMIS(value uint32) {
	volatile.StoreUint32(&o.MACTxTSSNR.Reg, volatile.LoadUint32(&o.MACTxTSSNR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACTxTSSNR_TXTSSMIS() uint32 {
	return (volatile.LoadUint32(&o.MACTxTSSNR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACTxTSSSR: Tx timestamp status seconds register
func (o *Ethernet_Type) SetMACTxTSSSR(value uint32) {
	volatile.StoreUint32(&o.MACTxTSSSR.Reg, value)
}
func (o *Ethernet_Type) GetMACTxTSSSR() uint32 {
	return volatile.LoadUint32(&o.MACTxTSSSR.Reg)
}

// Ethernet.MACACR: Auxiliary control register
func (o *Ethernet_Type) SetMACACR_ATSFC(value uint32) {
	volatile.StoreUint32(&o.MACACR.Reg, volatile.LoadUint32(&o.MACACR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACACR_ATSFC() uint32 {
	return volatile.LoadUint32(&o.MACACR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACACR_ATSEN0(value uint32) {
	volatile.StoreUint32(&o.MACACR.Reg, volatile.LoadUint32(&o.MACACR.Reg)&^(0x10)|value<<4)
}
func (o *Ethernet_Type) GetMACACR_ATSEN0() uint32 {
	return (volatile.LoadUint32(&o.MACACR.Reg) & 0x10) >> 4
}
func (o *Ethernet_Type) SetMACACR_ATSEN1(value uint32) {
	volatile.StoreUint32(&o.MACACR.Reg, volatile.LoadUint32(&o.MACACR.Reg)&^(0x20)|value<<5)
}
func (o *Ethernet_Type) GetMACACR_ATSEN1() uint32 {
	return (volatile.LoadUint32(&o.MACACR.Reg) & 0x20) >> 5
}
func (o *Ethernet_Type) SetMACACR_ATSEN2(value uint32) {
	volatile.StoreUint32(&o.MACACR.Reg, volatile.LoadUint32(&o.MACACR.Reg)&^(0x40)|value<<6)
}
func (o *Ethernet_Type) GetMACACR_ATSEN2() uint32 {
	return (volatile.LoadUint32(&o.MACACR.Reg) & 0x40) >> 6
}
func (o *Ethernet_Type) SetMACACR_ATSEN3(value uint32) {
	volatile.StoreUint32(&o.MACACR.Reg, volatile.LoadUint32(&o.MACACR.Reg)&^(0x80)|value<<7)
}
func (o *Ethernet_Type) GetMACACR_ATSEN3() uint32 {
	return (volatile.LoadUint32(&o.MACACR.Reg) & 0x80) >> 7
}

// Ethernet.MACATSNR: Auxiliary timestamp nanoseconds register
func (o *Ethernet_Type) SetMACATSNR_AUXTSLO(value uint32) {
	volatile.StoreUint32(&o.MACATSNR.Reg, volatile.LoadUint32(&o.MACATSNR.Reg)&^(0x7fffffff)|value)
}
func (o *Ethernet_Type) GetMACATSNR_AUXTSLO() uint32 {
	return volatile.LoadUint32(&o.MACATSNR.Reg) & 0x7fffffff
}

// Ethernet.MACATSSR: Auxiliary timestamp seconds register
func (o *Ethernet_Type) SetMACATSSR(value uint32) {
	volatile.StoreUint32(&o.MACATSSR.Reg, value)
}
func (o *Ethernet_Type) GetMACATSSR() uint32 {
	return volatile.LoadUint32(&o.MACATSSR.Reg)
}

// Ethernet.MACTSIACR: Timestamp Ingress asymmetric correction register
func (o *Ethernet_Type) SetMACTSIACR(value uint32) {
	volatile.StoreUint32(&o.MACTSIACR.Reg, value)
}
func (o *Ethernet_Type) GetMACTSIACR() uint32 {
	return volatile.LoadUint32(&o.MACTSIACR.Reg)
}

// Ethernet.MACTSEACR: Timestamp Egress asymmetric correction register
func (o *Ethernet_Type) SetMACTSEACR(value uint32) {
	volatile.StoreUint32(&o.MACTSEACR.Reg, value)
}
func (o *Ethernet_Type) GetMACTSEACR() uint32 {
	return volatile.LoadUint32(&o.MACTSEACR.Reg)
}

// Ethernet.MACTSICNR: Timestamp Ingress correction nanosecond register
func (o *Ethernet_Type) SetMACTSICNR(value uint32) {
	volatile.StoreUint32(&o.MACTSICNR.Reg, value)
}
func (o *Ethernet_Type) GetMACTSICNR() uint32 {
	return volatile.LoadUint32(&o.MACTSICNR.Reg)
}

// Ethernet.MACTSECNR: Timestamp Egress correction nanosecond register
func (o *Ethernet_Type) SetMACTSECNR(value uint32) {
	volatile.StoreUint32(&o.MACTSECNR.Reg, value)
}
func (o *Ethernet_Type) GetMACTSECNR() uint32 {
	return volatile.LoadUint32(&o.MACTSECNR.Reg)
}

// Ethernet.MACPPSCR: PPS control register
func (o *Ethernet_Type) SetMACPPSCR_PPSCTRL(value uint32) {
	volatile.StoreUint32(&o.MACPPSCR.Reg, volatile.LoadUint32(&o.MACPPSCR.Reg)&^(0xf)|value)
}
func (o *Ethernet_Type) GetMACPPSCR_PPSCTRL() uint32 {
	return volatile.LoadUint32(&o.MACPPSCR.Reg) & 0xf
}
func (o *Ethernet_Type) SetMACPPSCR_PPSEN0(value uint32) {
	volatile.StoreUint32(&o.MACPPSCR.Reg, volatile.LoadUint32(&o.MACPPSCR.Reg)&^(0x10)|value<<4)
}
func (o *Ethernet_Type) GetMACPPSCR_PPSEN0() uint32 {
	return (volatile.LoadUint32(&o.MACPPSCR.Reg) & 0x10) >> 4
}
func (o *Ethernet_Type) SetMACPPSCR_TRGTMODSEL0(value uint32) {
	volatile.StoreUint32(&o.MACPPSCR.Reg, volatile.LoadUint32(&o.MACPPSCR.Reg)&^(0x60)|value<<5)
}
func (o *Ethernet_Type) GetMACPPSCR_TRGTMODSEL0() uint32 {
	return (volatile.LoadUint32(&o.MACPPSCR.Reg) & 0x60) >> 5
}

// Ethernet.MACPPSTTSR: PPS target time seconds register
func (o *Ethernet_Type) SetMACPPSTTSR_TSTRH0(value uint32) {
	volatile.StoreUint32(&o.MACPPSTTSR.Reg, volatile.LoadUint32(&o.MACPPSTTSR.Reg)&^(0x7fffffff)|value)
}
func (o *Ethernet_Type) GetMACPPSTTSR_TSTRH0() uint32 {
	return volatile.LoadUint32(&o.MACPPSTTSR.Reg) & 0x7fffffff
}

// Ethernet.MACPPSTTNR: PPS target time nanoseconds register
func (o *Ethernet_Type) SetMACPPSTTNR_TTSL0(value uint32) {
	volatile.StoreUint32(&o.MACPPSTTNR.Reg, volatile.LoadUint32(&o.MACPPSTTNR.Reg)&^(0x7fffffff)|value)
}
func (o *Ethernet_Type) GetMACPPSTTNR_TTSL0() uint32 {
	return volatile.LoadUint32(&o.MACPPSTTNR.Reg) & 0x7fffffff
}
func (o *Ethernet_Type) SetMACPPSTTNR_TRGTBUSY0(value uint32) {
	volatile.StoreUint32(&o.MACPPSTTNR.Reg, volatile.LoadUint32(&o.MACPPSTTNR.Reg)&^(0x80000000)|value<<31)
}
func (o *Ethernet_Type) GetMACPPSTTNR_TRGTBUSY0() uint32 {
	return (volatile.LoadUint32(&o.MACPPSTTNR.Reg) & 0x80000000) >> 31
}

// Ethernet.MACPPSIR: PPS interval register
func (o *Ethernet_Type) SetMACPPSIR(value uint32) {
	volatile.StoreUint32(&o.MACPPSIR.Reg, value)
}
func (o *Ethernet_Type) GetMACPPSIR() uint32 {
	return volatile.LoadUint32(&o.MACPPSIR.Reg)
}

// Ethernet.MACPPSWR: PPS width register
func (o *Ethernet_Type) SetMACPPSWR(value uint32) {
	volatile.StoreUint32(&o.MACPPSWR.Reg, value)
}
func (o *Ethernet_Type) GetMACPPSWR() uint32 {
	return volatile.LoadUint32(&o.MACPPSWR.Reg)
}

// Ethernet.MACPOCR: PTP Offload control register
func (o *Ethernet_Type) SetMACPOCR_PTOEN(value uint32) {
	volatile.StoreUint32(&o.MACPOCR.Reg, volatile.LoadUint32(&o.MACPOCR.Reg)&^(0x1)|value)
}
func (o *Ethernet_Type) GetMACPOCR_PTOEN() uint32 {
	return volatile.LoadUint32(&o.MACPOCR.Reg) & 0x1
}
func (o *Ethernet_Type) SetMACPOCR_ASYNCEN(value uint32) {
	volatile.StoreUint32(&o.MACPOCR.Reg, volatile.LoadUint32(&o.MACPOCR.Reg)&^(0x2)|value<<1)
}
func (o *Ethernet_Type) GetMACPOCR_ASYNCEN() uint32 {
	return (volatile.LoadUint32(&o.MACPOCR.Reg) & 0x2) >> 1
}
func (o *Ethernet_Type) SetMACPOCR_APDREQEN(value uint32) {
	volatile.StoreUint32(&o.MACPOCR.Reg, volatile.LoadUint32(&o.MACPOCR.Reg)&^(0x4)|value<<2)
}
func (o *Ethernet_Type) GetMACPOCR_APDREQEN() uint32 {
	return (volatile.LoadUint32(&o.MACPOCR.Reg) & 0x4) >> 2
}
func (o *Ethernet_Type) SetMACPOCR_ASYNCTRIG(value uint32) {
	volatile.StoreUint32(&o.MACPOCR.Reg, volatile.LoadUint32(&o.MACPOCR.Reg)&^(0x10)|value<<4)
}
func (o *Ethernet_Type) GetMACPOCR_ASYNCTRIG() uint32 {
	return (volatile.LoadUint32(&o.MACPOCR.Reg) & 0x10) >> 4
}
func (o *Ethernet_Type) SetMACPOCR_APDREQTRIG(value uint32) {
	volatile.StoreUint32(&o.MACPOCR.Reg, volatile.LoadUint32(&o.MACPOCR.Reg)&^(0x20)|value<<5)
}
func (o *Ethernet_Type) GetMACPOCR_APDREQTRIG() uint32 {
	return (volatile.LoadUint32(&o.MACPOCR.Reg) & 0x20) >> 5
}
func (o *Ethernet_Type) SetMACPOCR_DRRDIS(value uint32) {
	volatile.StoreUint32(&o.MACPOCR.Reg, volatile.LoadUint32(&o.MACPOCR.Reg)&^(0x40)|value<<6)
}
func (o *Ethernet_Type) GetMACPOCR_DRRDIS() uint32 {
	return (volatile.LoadUint32(&o.MACPOCR.Reg) & 0x40) >> 6
}
func (o *Ethernet_Type) SetMACPOCR_DN(value uint32) {
	volatile.StoreUint32(&o.MACPOCR.Reg, volatile.LoadUint32(&o.MACPOCR.Reg)&^(0xff00)|value<<8)
}
func (o *Ethernet_Type) GetMACPOCR_DN() uint32 {
	return (volatile.LoadUint32(&o.MACPOCR.Reg) & 0xff00) >> 8
}

// Ethernet.MACSPI0R: PTP Source Port Identity 0 Register
func (o *Ethernet_Type) SetMACSPI0R(value uint32) {
	volatile.StoreUint32(&o.MACSPI0R.Reg, value)
}
func (o *Ethernet_Type) GetMACSPI0R() uint32 {
	return volatile.LoadUint32(&o.MACSPI0R.Reg)
}

// Ethernet.MACSPI1R: PTP Source port identity 1 register
func (o *Ethernet_Type) SetMACSPI1R(value uint32) {
	volatile.StoreUint32(&o.MACSPI1R.Reg, value)
}
func (o *Ethernet_Type) GetMACSPI1R() uint32 {
	return volatile.LoadUint32(&o.MACSPI1R.Reg)
}

// Ethernet.MACSPI2R: PTP Source port identity 2 register
func (o *Ethernet_Type) SetMACSPI2R_SPI2(value uint32) {
	volatile.StoreUint32(&o.MACSPI2R.Reg, volatile.LoadUint32(&o.MACSPI2R.Reg)&^(0xffff)|value)
}
func (o *Ethernet_Type) GetMACSPI2R_SPI2() uint32 {
	return volatile.LoadUint32(&o.MACSPI2R.Reg) & 0xffff
}

// Ethernet.MACLMIR: Log message interval register
func (o *Ethernet_Type) SetMACLMIR_LSI(value uint32) {
	volatile.StoreUint32(&o.MACLMIR.Reg, volatile.LoadUint32(&o.MACLMIR.Reg)&^(0xff)|value)
}
func (o *Ethernet_Type) GetMACLMIR_LSI() uint32 {
	return volatile.LoadUint32(&o.MACLMIR.Reg) & 0xff
}
func (o *Ethernet_Type) SetMACLMIR_DRSYNCR(value uint32) {
	volatile.StoreUint32(&o.MACLMIR.Reg, volatile.LoadUint32(&o.MACLMIR.Reg)&^(0x700)|value<<8)
}
func (o *Ethernet_Type) GetMACLMIR_DRSYNCR() uint32 {
	return (volatile.LoadUint32(&o.MACLMIR.Reg) & 0x700) >> 8
}
func (o *Ethernet_Type) SetMACLMIR_LMPDRI(value uint32) {
	volatile.StoreUint32(&o.MACLMIR.Reg, volatile.LoadUint32(&o.MACLMIR.Reg)&^(0xff000000)|value<<24)
}
func (o *Ethernet_Type) GetMACLMIR_LMPDRI() uint32 {
	return (volatile.LoadUint32(&o.MACLMIR.Reg) & 0xff000000) >> 24
}

// FMC
type FMC_Type struct {
	BCR1   volatile.Register32 // 0x0
	BTR1   volatile.Register32 // 0x4
	BCR2   volatile.Register32 // 0x8
	BTR2   volatile.Register32 // 0xC
	BCR3   volatile.Register32 // 0x10
	BTR3   volatile.Register32 // 0x14
	BCR4   volatile.Register32 // 0x18
	BTR4   volatile.Register32 // 0x1C
	_      [96]byte
	PCR    volatile.Register32 // 0x80
	SR     volatile.Register32 // 0x84
	PMEM   volatile.Register32 // 0x88
	PATT   volatile.Register32 // 0x8C
	_      [4]byte
	ECCR   volatile.Register32 // 0x94
	_      [108]byte
	BWTR1  volatile.Register32 // 0x104
	_      [4]byte
	BWTR2  volatile.Register32 // 0x10C
	_      [4]byte
	BWTR3  volatile.Register32 // 0x114
	_      [4]byte
	BWTR4  volatile.Register32 // 0x11C
	_      [32]byte
	SDBANK [2]FMC_SDBANK_Type // 0x140
	_      [8]byte
	SDCMR  volatile.Register32 // 0x150
	SDRTR  volatile.Register32 // 0x154
	SDSR   volatile.Register32 // 0x158
}

// FMC.BCR1: This register contains the control information of each memory bank, used for SRAMs, PSRAM and NOR Flash memories.
func (o *FMC_Type) SetBCR1_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetBCR1_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR1.Reg) & 0x1
}
func (o *FMC_Type) SetBCR1_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetBCR1_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x2) >> 1
}
func (o *FMC_Type) SetBCR1_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0xc)|value<<2)
}
func (o *FMC_Type) GetBCR1_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0xc) >> 2
}
func (o *FMC_Type) SetBCR1_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x30)|value<<4)
}
func (o *FMC_Type) GetBCR1_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x30) >> 4
}
func (o *FMC_Type) SetBCR1_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x40)|value<<6)
}
func (o *FMC_Type) GetBCR1_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x40) >> 6
}
func (o *FMC_Type) SetBCR1_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x100)|value<<8)
}
func (o *FMC_Type) GetBCR1_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x100) >> 8
}
func (o *FMC_Type) SetBCR1_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x200)|value<<9)
}
func (o *FMC_Type) GetBCR1_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x200) >> 9
}
func (o *FMC_Type) SetBCR1_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x800)|value<<11)
}
func (o *FMC_Type) GetBCR1_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x800) >> 11
}
func (o *FMC_Type) SetBCR1_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x1000)|value<<12)
}
func (o *FMC_Type) GetBCR1_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x1000) >> 12
}
func (o *FMC_Type) SetBCR1_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x2000)|value<<13)
}
func (o *FMC_Type) GetBCR1_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x2000) >> 13
}
func (o *FMC_Type) SetBCR1_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x4000)|value<<14)
}
func (o *FMC_Type) GetBCR1_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x4000) >> 14
}
func (o *FMC_Type) SetBCR1_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x8000)|value<<15)
}
func (o *FMC_Type) GetBCR1_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x8000) >> 15
}
func (o *FMC_Type) SetBCR1_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x70000)|value<<16)
}
func (o *FMC_Type) GetBCR1_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x70000) >> 16
}
func (o *FMC_Type) SetBCR1_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x80000)|value<<19)
}
func (o *FMC_Type) GetBCR1_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x80000) >> 19
}
func (o *FMC_Type) SetBCR1_CCLKEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x100000)|value<<20)
}
func (o *FMC_Type) GetBCR1_CCLKEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x100000) >> 20
}
func (o *FMC_Type) SetBCR1_WFDIS(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x200000)|value<<21)
}
func (o *FMC_Type) GetBCR1_WFDIS() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x200000) >> 21
}
func (o *FMC_Type) SetBCR1_BMAP(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x3000000)|value<<24)
}
func (o *FMC_Type) GetBCR1_BMAP() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x3000000) >> 24
}
func (o *FMC_Type) SetBCR1_FMCEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x80000000)|value<<31)
}
func (o *FMC_Type) GetBCR1_FMCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x80000000) >> 31
}

// FMC.BTR1: This register contains the control information of each memory bank, used for SRAMs, PSRAM and NOR Flash memories.If the EXTMOD bit is set in the FMC_BCRx register, then this register is partitioned for write and read access, that is, 2 registers are available: one to configure read accesses (this register) and one to configure write accesses (FMC_BWTRx registers).
func (o *FMC_Type) SetBTR1_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBTR1_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR1.Reg) & 0xf
}
func (o *FMC_Type) SetBTR1_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBTR1_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBTR1_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBTR1_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBTR1_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_Type) GetBTR1_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf0000) >> 16
}
func (o *FMC_Type) SetBTR1_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf00000)|value<<20)
}
func (o *FMC_Type) GetBTR1_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf00000) >> 20
}
func (o *FMC_Type) SetBTR1_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf000000)|value<<24)
}
func (o *FMC_Type) GetBTR1_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf000000) >> 24
}
func (o *FMC_Type) SetBTR1_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBTR1_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0x30000000) >> 28
}

// FMC.BCR2: This register contains the control information of each memory bank, used for SRAMs, PSRAM and NOR Flash memories.
func (o *FMC_Type) SetBCR2_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetBCR2_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR2.Reg) & 0x1
}
func (o *FMC_Type) SetBCR2_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetBCR2_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x2) >> 1
}
func (o *FMC_Type) SetBCR2_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0xc)|value<<2)
}
func (o *FMC_Type) GetBCR2_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0xc) >> 2
}
func (o *FMC_Type) SetBCR2_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x30)|value<<4)
}
func (o *FMC_Type) GetBCR2_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x30) >> 4
}
func (o *FMC_Type) SetBCR2_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x40)|value<<6)
}
func (o *FMC_Type) GetBCR2_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x40) >> 6
}
func (o *FMC_Type) SetBCR2_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x100)|value<<8)
}
func (o *FMC_Type) GetBCR2_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x100) >> 8
}
func (o *FMC_Type) SetBCR2_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x200)|value<<9)
}
func (o *FMC_Type) GetBCR2_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x200) >> 9
}
func (o *FMC_Type) SetBCR2_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x800)|value<<11)
}
func (o *FMC_Type) GetBCR2_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x800) >> 11
}
func (o *FMC_Type) SetBCR2_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x1000)|value<<12)
}
func (o *FMC_Type) GetBCR2_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x1000) >> 12
}
func (o *FMC_Type) SetBCR2_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x2000)|value<<13)
}
func (o *FMC_Type) GetBCR2_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x2000) >> 13
}
func (o *FMC_Type) SetBCR2_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x4000)|value<<14)
}
func (o *FMC_Type) GetBCR2_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x4000) >> 14
}
func (o *FMC_Type) SetBCR2_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x8000)|value<<15)
}
func (o *FMC_Type) GetBCR2_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x8000) >> 15
}
func (o *FMC_Type) SetBCR2_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x70000)|value<<16)
}
func (o *FMC_Type) GetBCR2_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x70000) >> 16
}
func (o *FMC_Type) SetBCR2_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x80000)|value<<19)
}
func (o *FMC_Type) GetBCR2_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x80000) >> 19
}
func (o *FMC_Type) SetBCR2_CCLKEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x100000)|value<<20)
}
func (o *FMC_Type) GetBCR2_CCLKEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x100000) >> 20
}
func (o *FMC_Type) SetBCR2_WFDIS(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x200000)|value<<21)
}
func (o *FMC_Type) GetBCR2_WFDIS() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x200000) >> 21
}
func (o *FMC_Type) SetBCR2_BMAP(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x3000000)|value<<24)
}
func (o *FMC_Type) GetBCR2_BMAP() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x3000000) >> 24
}
func (o *FMC_Type) SetBCR2_FMCEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x80000000)|value<<31)
}
func (o *FMC_Type) GetBCR2_FMCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x80000000) >> 31
}

// FMC.BTR2: This register contains the control information of each memory bank, used for SRAMs, PSRAM and NOR Flash memories.If the EXTMOD bit is set in the FMC_BCRx register, then this register is partitioned for write and read access, that is, 2 registers are available: one to configure read accesses (this register) and one to configure write accesses (FMC_BWTRx registers).
func (o *FMC_Type) SetBTR2_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBTR2_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR2.Reg) & 0xf
}
func (o *FMC_Type) SetBTR2_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBTR2_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBTR2_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBTR2_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBTR2_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_Type) GetBTR2_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf0000) >> 16
}
func (o *FMC_Type) SetBTR2_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf00000)|value<<20)
}
func (o *FMC_Type) GetBTR2_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf00000) >> 20
}
func (o *FMC_Type) SetBTR2_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf000000)|value<<24)
}
func (o *FMC_Type) GetBTR2_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf000000) >> 24
}
func (o *FMC_Type) SetBTR2_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBTR2_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0x30000000) >> 28
}

// FMC.BCR3: This register contains the control information of each memory bank, used for SRAMs, PSRAM and NOR Flash memories.
func (o *FMC_Type) SetBCR3_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetBCR3_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR3.Reg) & 0x1
}
func (o *FMC_Type) SetBCR3_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetBCR3_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x2) >> 1
}
func (o *FMC_Type) SetBCR3_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0xc)|value<<2)
}
func (o *FMC_Type) GetBCR3_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0xc) >> 2
}
func (o *FMC_Type) SetBCR3_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x30)|value<<4)
}
func (o *FMC_Type) GetBCR3_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x30) >> 4
}
func (o *FMC_Type) SetBCR3_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x40)|value<<6)
}
func (o *FMC_Type) GetBCR3_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x40) >> 6
}
func (o *FMC_Type) SetBCR3_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x100)|value<<8)
}
func (o *FMC_Type) GetBCR3_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x100) >> 8
}
func (o *FMC_Type) SetBCR3_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x200)|value<<9)
}
func (o *FMC_Type) GetBCR3_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x200) >> 9
}
func (o *FMC_Type) SetBCR3_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x800)|value<<11)
}
func (o *FMC_Type) GetBCR3_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x800) >> 11
}
func (o *FMC_Type) SetBCR3_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x1000)|value<<12)
}
func (o *FMC_Type) GetBCR3_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x1000) >> 12
}
func (o *FMC_Type) SetBCR3_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x2000)|value<<13)
}
func (o *FMC_Type) GetBCR3_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x2000) >> 13
}
func (o *FMC_Type) SetBCR3_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x4000)|value<<14)
}
func (o *FMC_Type) GetBCR3_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x4000) >> 14
}
func (o *FMC_Type) SetBCR3_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x8000)|value<<15)
}
func (o *FMC_Type) GetBCR3_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x8000) >> 15
}
func (o *FMC_Type) SetBCR3_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x70000)|value<<16)
}
func (o *FMC_Type) GetBCR3_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x70000) >> 16
}
func (o *FMC_Type) SetBCR3_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x80000)|value<<19)
}
func (o *FMC_Type) GetBCR3_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x80000) >> 19
}
func (o *FMC_Type) SetBCR3_CCLKEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x100000)|value<<20)
}
func (o *FMC_Type) GetBCR3_CCLKEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x100000) >> 20
}
func (o *FMC_Type) SetBCR3_WFDIS(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x200000)|value<<21)
}
func (o *FMC_Type) GetBCR3_WFDIS() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x200000) >> 21
}
func (o *FMC_Type) SetBCR3_BMAP(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x3000000)|value<<24)
}
func (o *FMC_Type) GetBCR3_BMAP() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x3000000) >> 24
}
func (o *FMC_Type) SetBCR3_FMCEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x80000000)|value<<31)
}
func (o *FMC_Type) GetBCR3_FMCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x80000000) >> 31
}

// FMC.BTR3: This register contains the control information of each memory bank, used for SRAMs, PSRAM and NOR Flash memories.If the EXTMOD bit is set in the FMC_BCRx register, then this register is partitioned for write and read access, that is, 2 registers are available: one to configure read accesses (this register) and one to configure write accesses (FMC_BWTRx registers).
func (o *FMC_Type) SetBTR3_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBTR3_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR3.Reg) & 0xf
}
func (o *FMC_Type) SetBTR3_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBTR3_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBTR3_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBTR3_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBTR3_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_Type) GetBTR3_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf0000) >> 16
}
func (o *FMC_Type) SetBTR3_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf00000)|value<<20)
}
func (o *FMC_Type) GetBTR3_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf00000) >> 20
}
func (o *FMC_Type) SetBTR3_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf000000)|value<<24)
}
func (o *FMC_Type) GetBTR3_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf000000) >> 24
}
func (o *FMC_Type) SetBTR3_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBTR3_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0x30000000) >> 28
}

// FMC.BCR4: This register contains the control information of each memory bank, used for SRAMs, PSRAM and NOR Flash memories.
func (o *FMC_Type) SetBCR4_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetBCR4_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR4.Reg) & 0x1
}
func (o *FMC_Type) SetBCR4_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetBCR4_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x2) >> 1
}
func (o *FMC_Type) SetBCR4_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0xc)|value<<2)
}
func (o *FMC_Type) GetBCR4_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0xc) >> 2
}
func (o *FMC_Type) SetBCR4_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x30)|value<<4)
}
func (o *FMC_Type) GetBCR4_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x30) >> 4
}
func (o *FMC_Type) SetBCR4_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x40)|value<<6)
}
func (o *FMC_Type) GetBCR4_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x40) >> 6
}
func (o *FMC_Type) SetBCR4_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x100)|value<<8)
}
func (o *FMC_Type) GetBCR4_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x100) >> 8
}
func (o *FMC_Type) SetBCR4_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x200)|value<<9)
}
func (o *FMC_Type) GetBCR4_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x200) >> 9
}
func (o *FMC_Type) SetBCR4_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x800)|value<<11)
}
func (o *FMC_Type) GetBCR4_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x800) >> 11
}
func (o *FMC_Type) SetBCR4_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x1000)|value<<12)
}
func (o *FMC_Type) GetBCR4_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x1000) >> 12
}
func (o *FMC_Type) SetBCR4_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x2000)|value<<13)
}
func (o *FMC_Type) GetBCR4_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x2000) >> 13
}
func (o *FMC_Type) SetBCR4_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x4000)|value<<14)
}
func (o *FMC_Type) GetBCR4_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x4000) >> 14
}
func (o *FMC_Type) SetBCR4_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x8000)|value<<15)
}
func (o *FMC_Type) GetBCR4_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x8000) >> 15
}
func (o *FMC_Type) SetBCR4_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x70000)|value<<16)
}
func (o *FMC_Type) GetBCR4_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x70000) >> 16
}
func (o *FMC_Type) SetBCR4_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x80000)|value<<19)
}
func (o *FMC_Type) GetBCR4_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x80000) >> 19
}
func (o *FMC_Type) SetBCR4_CCLKEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x100000)|value<<20)
}
func (o *FMC_Type) GetBCR4_CCLKEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x100000) >> 20
}
func (o *FMC_Type) SetBCR4_WFDIS(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x200000)|value<<21)
}
func (o *FMC_Type) GetBCR4_WFDIS() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x200000) >> 21
}
func (o *FMC_Type) SetBCR4_BMAP(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x3000000)|value<<24)
}
func (o *FMC_Type) GetBCR4_BMAP() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x3000000) >> 24
}
func (o *FMC_Type) SetBCR4_FMCEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x80000000)|value<<31)
}
func (o *FMC_Type) GetBCR4_FMCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x80000000) >> 31
}

// FMC.BTR4: This register contains the control information of each memory bank, used for SRAMs, PSRAM and NOR Flash memories.If the EXTMOD bit is set in the FMC_BCRx register, then this register is partitioned for write and read access, that is, 2 registers are available: one to configure read accesses (this register) and one to configure write accesses (FMC_BWTRx registers).
func (o *FMC_Type) SetBTR4_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBTR4_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR4.Reg) & 0xf
}
func (o *FMC_Type) SetBTR4_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBTR4_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBTR4_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBTR4_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBTR4_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_Type) GetBTR4_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf0000) >> 16
}
func (o *FMC_Type) SetBTR4_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf00000)|value<<20)
}
func (o *FMC_Type) GetBTR4_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf00000) >> 20
}
func (o *FMC_Type) SetBTR4_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf000000)|value<<24)
}
func (o *FMC_Type) GetBTR4_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf000000) >> 24
}
func (o *FMC_Type) SetBTR4_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBTR4_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0x30000000) >> 28
}

// FMC.PCR: NAND Flash control registers
func (o *FMC_Type) SetPCR_PWAITEN(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetPCR_PWAITEN() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x2) >> 1
}
func (o *FMC_Type) SetPCR_PBKEN(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x4)|value<<2)
}
func (o *FMC_Type) GetPCR_PBKEN() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x4) >> 2
}
func (o *FMC_Type) SetPCR_PWID(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x30)|value<<4)
}
func (o *FMC_Type) GetPCR_PWID() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x30) >> 4
}
func (o *FMC_Type) SetPCR_ECCEN(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x40)|value<<6)
}
func (o *FMC_Type) GetPCR_ECCEN() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x40) >> 6
}
func (o *FMC_Type) SetPCR_TCLR(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x1e00)|value<<9)
}
func (o *FMC_Type) GetPCR_TCLR() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x1e00) >> 9
}
func (o *FMC_Type) SetPCR_TAR(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x1e000)|value<<13)
}
func (o *FMC_Type) GetPCR_TAR() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x1e000) >> 13
}
func (o *FMC_Type) SetPCR_ECCPS(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0xe0000)|value<<17)
}
func (o *FMC_Type) GetPCR_ECCPS() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0xe0000) >> 17
}

// FMC.SR: This register contains information about the FIFO status and interrupt. The FMC features a FIFO that is used when writing to memories to transfer up to 16 words of data.This is used to quickly write to the FIFO and free the AXI bus for transactions to peripherals other than the FMC, while the FMC is draining its FIFO into the memory. One of these register bits indicates the status of the FIFO, for ECC purposes.The ECC is calculated while the data are written to the memory. To read the correct ECC, the software must consequently wait until the FIFO is empty.
func (o *FMC_Type) SetSR_IRS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetSR_IRS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *FMC_Type) SetSR_ILS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetSR_ILS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *FMC_Type) SetSR_IFS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *FMC_Type) GetSR_IFS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *FMC_Type) SetSR_IREN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *FMC_Type) GetSR_IREN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *FMC_Type) SetSR_ILEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *FMC_Type) GetSR_ILEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *FMC_Type) SetSR_IFEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *FMC_Type) GetSR_IFEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *FMC_Type) SetSR_FEMPT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *FMC_Type) GetSR_FEMPT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}

// FMC.PMEM: The FMC_PMEM read/write register contains the timing information for NAND Flash memory bank. This information is used to access either the common memory space of the NAND Flash for command, address write access and data read/write access.
func (o *FMC_Type) SetPMEM_MEMSET(value uint32) {
	volatile.StoreUint32(&o.PMEM.Reg, volatile.LoadUint32(&o.PMEM.Reg)&^(0xff)|value)
}
func (o *FMC_Type) GetPMEM_MEMSET() uint32 {
	return volatile.LoadUint32(&o.PMEM.Reg) & 0xff
}
func (o *FMC_Type) SetPMEM_MEMWAIT(value uint32) {
	volatile.StoreUint32(&o.PMEM.Reg, volatile.LoadUint32(&o.PMEM.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetPMEM_MEMWAIT() uint32 {
	return (volatile.LoadUint32(&o.PMEM.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetPMEM_MEMHOLD(value uint32) {
	volatile.StoreUint32(&o.PMEM.Reg, volatile.LoadUint32(&o.PMEM.Reg)&^(0xff0000)|value<<16)
}
func (o *FMC_Type) GetPMEM_MEMHOLD() uint32 {
	return (volatile.LoadUint32(&o.PMEM.Reg) & 0xff0000) >> 16
}
func (o *FMC_Type) SetPMEM_MEMHIZ(value uint32) {
	volatile.StoreUint32(&o.PMEM.Reg, volatile.LoadUint32(&o.PMEM.Reg)&^(0xff000000)|value<<24)
}
func (o *FMC_Type) GetPMEM_MEMHIZ() uint32 {
	return (volatile.LoadUint32(&o.PMEM.Reg) & 0xff000000) >> 24
}

// FMC.PATT: The FMC_PATT read/write register contains the timing information for NAND Flash memory bank. It is used for 8-bit accesses to the attribute memory space of the NAND Flash for the last address write access if the timing must differ from that of previous accesses (for Ready/Busy management, refer to Section20.8.5: NAND Flash prewait feature).
func (o *FMC_Type) SetPATT_ATTSET(value uint32) {
	volatile.StoreUint32(&o.PATT.Reg, volatile.LoadUint32(&o.PATT.Reg)&^(0xff)|value)
}
func (o *FMC_Type) GetPATT_ATTSET() uint32 {
	return volatile.LoadUint32(&o.PATT.Reg) & 0xff
}
func (o *FMC_Type) SetPATT_ATTWAIT(value uint32) {
	volatile.StoreUint32(&o.PATT.Reg, volatile.LoadUint32(&o.PATT.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetPATT_ATTWAIT() uint32 {
	return (volatile.LoadUint32(&o.PATT.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetPATT_ATTHOLD(value uint32) {
	volatile.StoreUint32(&o.PATT.Reg, volatile.LoadUint32(&o.PATT.Reg)&^(0xff0000)|value<<16)
}
func (o *FMC_Type) GetPATT_ATTHOLD() uint32 {
	return (volatile.LoadUint32(&o.PATT.Reg) & 0xff0000) >> 16
}
func (o *FMC_Type) SetPATT_ATTHIZ(value uint32) {
	volatile.StoreUint32(&o.PATT.Reg, volatile.LoadUint32(&o.PATT.Reg)&^(0xff000000)|value<<24)
}
func (o *FMC_Type) GetPATT_ATTHIZ() uint32 {
	return (volatile.LoadUint32(&o.PATT.Reg) & 0xff000000) >> 24
}

// FMC.ECCR: This register contain the current error correction code value computed by the ECC computation modules of the FMC NAND controller. When the CPU reads/writes the data from a NAND Flash memory page at the correct address (refer to Section20.8.6: Computation of the error correction code (ECC) in NAND Flash memory), the data read/written from/to the NAND Flash memory are processed automatically by the ECC computation module. When X bytes have been read (according to the ECCPS field in the FMC_PCR registers), the CPU must read the computed ECC value from the FMC_ECC registers. It then verifies if these computed parity data are the same as the parity value recorded in the spare area, to determine whether a page is valid, and, to correct it otherwise. The FMC_ECCR register should be cleared after being read by setting the ECCEN bit to 0. To compute a new data block, the ECCEN bit must be set to 1.
func (o *FMC_Type) SetECCR(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, value)
}
func (o *FMC_Type) GetECCR() uint32 {
	return volatile.LoadUint32(&o.ECCR.Reg)
}

// FMC.BWTR1: This register contains the control information of each memory bank. It is used for SRAMs, PSRAMs and NOR Flash memories. When the EXTMOD bit is set in the FMC_BCRx register, then this register is active for write access.
func (o *FMC_Type) SetBWTR1_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBWTR1_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR1.Reg) & 0xf
}
func (o *FMC_Type) SetBWTR1_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBWTR1_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBWTR1_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBWTR1_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBWTR1_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_Type) GetBWTR1_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf0000) >> 16
}
func (o *FMC_Type) SetBWTR1_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBWTR1_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0x30000000) >> 28
}

// FMC.BWTR2: This register contains the control information of each memory bank. It is used for SRAMs, PSRAMs and NOR Flash memories. When the EXTMOD bit is set in the FMC_BCRx register, then this register is active for write access.
func (o *FMC_Type) SetBWTR2_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBWTR2_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR2.Reg) & 0xf
}
func (o *FMC_Type) SetBWTR2_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBWTR2_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBWTR2_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBWTR2_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBWTR2_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_Type) GetBWTR2_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf0000) >> 16
}
func (o *FMC_Type) SetBWTR2_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBWTR2_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0x30000000) >> 28
}

// FMC.BWTR3: This register contains the control information of each memory bank. It is used for SRAMs, PSRAMs and NOR Flash memories. When the EXTMOD bit is set in the FMC_BCRx register, then this register is active for write access.
func (o *FMC_Type) SetBWTR3_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBWTR3_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR3.Reg) & 0xf
}
func (o *FMC_Type) SetBWTR3_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBWTR3_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBWTR3_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBWTR3_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBWTR3_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_Type) GetBWTR3_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf0000) >> 16
}
func (o *FMC_Type) SetBWTR3_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBWTR3_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0x30000000) >> 28
}

// FMC.BWTR4: This register contains the control information of each memory bank. It is used for SRAMs, PSRAMs and NOR Flash memories. When the EXTMOD bit is set in the FMC_BCRx register, then this register is active for write access.
func (o *FMC_Type) SetBWTR4_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf)|value)
}
func (o *FMC_Type) GetBWTR4_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR4.Reg) & 0xf
}
func (o *FMC_Type) SetBWTR4_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_Type) GetBWTR4_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf0) >> 4
}
func (o *FMC_Type) SetBWTR4_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xff00)|value<<8)
}
func (o *FMC_Type) GetBWTR4_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xff00) >> 8
}
func (o *FMC_Type) SetBWTR4_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_Type) GetBWTR4_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf0000) >> 16
}
func (o *FMC_Type) SetBWTR4_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0x30000000)|value<<28)
}
func (o *FMC_Type) GetBWTR4_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0x30000000) >> 28
}

// FMC.SDCMR: This register contains the command issued when the SDRAM device is accessed. This register is used to initialize the SDRAM device, and to activate the Self-refresh and the Power-down modes. As soon as the MODE field is written, the command will be issued only to one or to both SDRAM banks according to CTB1 and CTB2 command bits. This register is the same for both SDRAM banks.
func (o *FMC_Type) SetSDCMR_MODE(value uint32) {
	volatile.StoreUint32(&o.SDCMR.Reg, volatile.LoadUint32(&o.SDCMR.Reg)&^(0x7)|value)
}
func (o *FMC_Type) GetSDCMR_MODE() uint32 {
	return volatile.LoadUint32(&o.SDCMR.Reg) & 0x7
}
func (o *FMC_Type) SetSDCMR_CTB2(value uint32) {
	volatile.StoreUint32(&o.SDCMR.Reg, volatile.LoadUint32(&o.SDCMR.Reg)&^(0x8)|value<<3)
}
func (o *FMC_Type) GetSDCMR_CTB2() uint32 {
	return (volatile.LoadUint32(&o.SDCMR.Reg) & 0x8) >> 3
}
func (o *FMC_Type) SetSDCMR_CTB1(value uint32) {
	volatile.StoreUint32(&o.SDCMR.Reg, volatile.LoadUint32(&o.SDCMR.Reg)&^(0x10)|value<<4)
}
func (o *FMC_Type) GetSDCMR_CTB1() uint32 {
	return (volatile.LoadUint32(&o.SDCMR.Reg) & 0x10) >> 4
}
func (o *FMC_Type) SetSDCMR_NRFS(value uint32) {
	volatile.StoreUint32(&o.SDCMR.Reg, volatile.LoadUint32(&o.SDCMR.Reg)&^(0x1e0)|value<<5)
}
func (o *FMC_Type) GetSDCMR_NRFS() uint32 {
	return (volatile.LoadUint32(&o.SDCMR.Reg) & 0x1e0) >> 5
}
func (o *FMC_Type) SetSDCMR_MRD(value uint32) {
	volatile.StoreUint32(&o.SDCMR.Reg, volatile.LoadUint32(&o.SDCMR.Reg)&^(0x7ffe00)|value<<9)
}
func (o *FMC_Type) GetSDCMR_MRD() uint32 {
	return (volatile.LoadUint32(&o.SDCMR.Reg) & 0x7ffe00) >> 9
}

// FMC.SDRTR: This register sets the refresh rate in number of SDCLK clock cycles between the refresh cycles by configuring the Refresh Timer Count value.Examplewhere 64 ms is the SDRAM refresh period.The refresh rate must be increased by 20 SDRAM clock cycles (as in the above example) to obtain a safe margin if an internal refresh request occurs when a read request has been accepted. It corresponds to a COUNT value of 0000111000000 (448). This 13-bit field is loaded into a timer which is decremented using the SDRAM clock. This timer generates a refresh pulse when zero is reached. The COUNT value must be set at least to 41 SDRAM clock cycles.As soon as the FMC_SDRTR register is programmed, the timer starts counting. If the value programmed in the register is 0, no refresh is carried out. This register must not be reprogrammed after the initialization procedure to avoid modifying the refresh rate.Each time a refresh pulse is generated, this 13-bit COUNT field is reloaded into the counter.If a memory access is in progress, the Auto-refresh request is delayed. However, if the memory access and Auto-refresh requests are generated simultaneously, the Auto-refresh takes precedence. If the memory access occurs during a refresh operation, the request is buffered to be processed when the refresh is complete.This register is common to SDRAM bank 1 and bank 2.
func (o *FMC_Type) SetSDRTR_CRE(value uint32) {
	volatile.StoreUint32(&o.SDRTR.Reg, volatile.LoadUint32(&o.SDRTR.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetSDRTR_CRE() uint32 {
	return volatile.LoadUint32(&o.SDRTR.Reg) & 0x1
}
func (o *FMC_Type) SetSDRTR_COUNT(value uint32) {
	volatile.StoreUint32(&o.SDRTR.Reg, volatile.LoadUint32(&o.SDRTR.Reg)&^(0x3ffe)|value<<1)
}
func (o *FMC_Type) GetSDRTR_COUNT() uint32 {
	return (volatile.LoadUint32(&o.SDRTR.Reg) & 0x3ffe) >> 1
}
func (o *FMC_Type) SetSDRTR_REIE(value uint32) {
	volatile.StoreUint32(&o.SDRTR.Reg, volatile.LoadUint32(&o.SDRTR.Reg)&^(0x4000)|value<<14)
}
func (o *FMC_Type) GetSDRTR_REIE() uint32 {
	return (volatile.LoadUint32(&o.SDRTR.Reg) & 0x4000) >> 14
}

// FMC.SDSR: SDRAM Status register
func (o *FMC_Type) SetSDSR_RE(value uint32) {
	volatile.StoreUint32(&o.SDSR.Reg, volatile.LoadUint32(&o.SDSR.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetSDSR_RE() uint32 {
	return volatile.LoadUint32(&o.SDSR.Reg) & 0x1
}
func (o *FMC_Type) SetSDSR_MODES1(value uint32) {
	volatile.StoreUint32(&o.SDSR.Reg, volatile.LoadUint32(&o.SDSR.Reg)&^(0x6)|value<<1)
}
func (o *FMC_Type) GetSDSR_MODES1() uint32 {
	return (volatile.LoadUint32(&o.SDSR.Reg) & 0x6) >> 1
}
func (o *FMC_Type) SetSDSR_MODES2(value uint32) {
	volatile.StoreUint32(&o.SDSR.Reg, volatile.LoadUint32(&o.SDSR.Reg)&^(0x18)|value<<3)
}
func (o *FMC_Type) GetSDSR_MODES2() uint32 {
	return (volatile.LoadUint32(&o.SDSR.Reg) & 0x18) >> 3
}

// Cluster SDBANK%s, containing SDTR?, SDCR?
type FMC_SDBANK_Type struct {
	SDCR volatile.Register32 // 0x140
	_    [4]byte
	SDTR volatile.Register32 // 0x148
}

// FMC_SDBANK.SDCR: This register contains the control parameters for each SDRAM memory bank
func (o *FMC_SDBANK_Type) SetSDCR_NC(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x3)|value)
}
func (o *FMC_SDBANK_Type) GetSDCR_NC() uint32 {
	return volatile.LoadUint32(&o.SDCR.Reg) & 0x3
}
func (o *FMC_SDBANK_Type) SetSDCR_NR(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0xc)|value<<2)
}
func (o *FMC_SDBANK_Type) GetSDCR_NR() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0xc) >> 2
}
func (o *FMC_SDBANK_Type) SetSDCR_MWID(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x30)|value<<4)
}
func (o *FMC_SDBANK_Type) GetSDCR_MWID() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0x30) >> 4
}
func (o *FMC_SDBANK_Type) SetSDCR_NB(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x40)|value<<6)
}
func (o *FMC_SDBANK_Type) GetSDCR_NB() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0x40) >> 6
}
func (o *FMC_SDBANK_Type) SetSDCR_CAS(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x180)|value<<7)
}
func (o *FMC_SDBANK_Type) GetSDCR_CAS() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0x180) >> 7
}
func (o *FMC_SDBANK_Type) SetSDCR_WP(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x200)|value<<9)
}
func (o *FMC_SDBANK_Type) GetSDCR_WP() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0x200) >> 9
}
func (o *FMC_SDBANK_Type) SetSDCR_SDCLK(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0xc00)|value<<10)
}
func (o *FMC_SDBANK_Type) GetSDCR_SDCLK() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0xc00) >> 10
}
func (o *FMC_SDBANK_Type) SetSDCR_RBURST(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x1000)|value<<12)
}
func (o *FMC_SDBANK_Type) GetSDCR_RBURST() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0x1000) >> 12
}
func (o *FMC_SDBANK_Type) SetSDCR_RPIPE(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x6000)|value<<13)
}
func (o *FMC_SDBANK_Type) GetSDCR_RPIPE() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0x6000) >> 13
}

// FMC_SDBANK.SDTR: This register contains the timing parameters of each SDRAM bank
func (o *FMC_SDBANK_Type) SetSDTR_TMRD(value uint32) {
	volatile.StoreUint32(&o.SDTR.Reg, volatile.LoadUint32(&o.SDTR.Reg)&^(0xf)|value)
}
func (o *FMC_SDBANK_Type) GetSDTR_TMRD() uint32 {
	return volatile.LoadUint32(&o.SDTR.Reg) & 0xf
}
func (o *FMC_SDBANK_Type) SetSDTR_TXSR(value uint32) {
	volatile.StoreUint32(&o.SDTR.Reg, volatile.LoadUint32(&o.SDTR.Reg)&^(0xf0)|value<<4)
}
func (o *FMC_SDBANK_Type) GetSDTR_TXSR() uint32 {
	return (volatile.LoadUint32(&o.SDTR.Reg) & 0xf0) >> 4
}
func (o *FMC_SDBANK_Type) SetSDTR_TRAS(value uint32) {
	volatile.StoreUint32(&o.SDTR.Reg, volatile.LoadUint32(&o.SDTR.Reg)&^(0xf00)|value<<8)
}
func (o *FMC_SDBANK_Type) GetSDTR_TRAS() uint32 {
	return (volatile.LoadUint32(&o.SDTR.Reg) & 0xf00) >> 8
}
func (o *FMC_SDBANK_Type) SetSDTR_TRC(value uint32) {
	volatile.StoreUint32(&o.SDTR.Reg, volatile.LoadUint32(&o.SDTR.Reg)&^(0xf000)|value<<12)
}
func (o *FMC_SDBANK_Type) GetSDTR_TRC() uint32 {
	return (volatile.LoadUint32(&o.SDTR.Reg) & 0xf000) >> 12
}
func (o *FMC_SDBANK_Type) SetSDTR_TWR(value uint32) {
	volatile.StoreUint32(&o.SDTR.Reg, volatile.LoadUint32(&o.SDTR.Reg)&^(0xf0000)|value<<16)
}
func (o *FMC_SDBANK_Type) GetSDTR_TWR() uint32 {
	return (volatile.LoadUint32(&o.SDTR.Reg) & 0xf0000) >> 16
}
func (o *FMC_SDBANK_Type) SetSDTR_TRP(value uint32) {
	volatile.StoreUint32(&o.SDTR.Reg, volatile.LoadUint32(&o.SDTR.Reg)&^(0xf00000)|value<<20)
}
func (o *FMC_SDBANK_Type) GetSDTR_TRP() uint32 {
	return (volatile.LoadUint32(&o.SDTR.Reg) & 0xf00000) >> 20
}
func (o *FMC_SDBANK_Type) SetSDTR_TRCD(value uint32) {
	volatile.StoreUint32(&o.SDTR.Reg, volatile.LoadUint32(&o.SDTR.Reg)&^(0xf000000)|value<<24)
}
func (o *FMC_SDBANK_Type) GetSDTR_TRCD() uint32 {
	return (volatile.LoadUint32(&o.SDTR.Reg) & 0xf000000) >> 24
}

// Floting point unit
type FPU_Type struct {
	FPCCR volatile.Register32 // 0x0
	FPCAR volatile.Register32 // 0x4
	FPSCR volatile.Register32 // 0x8
}

// FPU.FPCCR: Floating-point context control register
func (o *FPU_Type) SetFPCCR_LSPACT(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetFPCCR_LSPACT() uint32 {
	return volatile.LoadUint32(&o.FPCCR.Reg) & 0x1
}
func (o *FPU_Type) SetFPCCR_USER(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x2)|value<<1)
}
func (o *FPU_Type) GetFPCCR_USER() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x2) >> 1
}
func (o *FPU_Type) SetFPCCR_THREAD(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x8)|value<<3)
}
func (o *FPU_Type) GetFPCCR_THREAD() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x8) >> 3
}
func (o *FPU_Type) SetFPCCR_HFRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x10)|value<<4)
}
func (o *FPU_Type) GetFPCCR_HFRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x10) >> 4
}
func (o *FPU_Type) SetFPCCR_MMRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x20)|value<<5)
}
func (o *FPU_Type) GetFPCCR_MMRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x20) >> 5
}
func (o *FPU_Type) SetFPCCR_BFRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x40)|value<<6)
}
func (o *FPU_Type) GetFPCCR_BFRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x40) >> 6
}
func (o *FPU_Type) SetFPCCR_MONRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x100)|value<<8)
}
func (o *FPU_Type) GetFPCCR_MONRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x100) >> 8
}
func (o *FPU_Type) SetFPCCR_LSPEN(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x40000000)|value<<30)
}
func (o *FPU_Type) GetFPCCR_LSPEN() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x40000000) >> 30
}
func (o *FPU_Type) SetFPCCR_ASPEN(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x80000000)|value<<31)
}
func (o *FPU_Type) GetFPCCR_ASPEN() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x80000000) >> 31
}

// FPU.FPCAR: Floating-point context address register
func (o *FPU_Type) SetFPCAR_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.FPCAR.Reg, volatile.LoadUint32(&o.FPCAR.Reg)&^(0xfffffff8)|value<<3)
}
func (o *FPU_Type) GetFPCAR_ADDRESS() uint32 {
	return (volatile.LoadUint32(&o.FPCAR.Reg) & 0xfffffff8) >> 3
}

// FPU.FPSCR: Floating-point status control register
func (o *FPU_Type) SetFPSCR_IOC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetFPSCR_IOC() uint32 {
	return volatile.LoadUint32(&o.FPSCR.Reg) & 0x1
}
func (o *FPU_Type) SetFPSCR_DZC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x2)|value<<1)
}
func (o *FPU_Type) GetFPSCR_DZC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x2) >> 1
}
func (o *FPU_Type) SetFPSCR_OFC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x4)|value<<2)
}
func (o *FPU_Type) GetFPSCR_OFC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x4) >> 2
}
func (o *FPU_Type) SetFPSCR_UFC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x8)|value<<3)
}
func (o *FPU_Type) GetFPSCR_UFC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x8) >> 3
}
func (o *FPU_Type) SetFPSCR_IXC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x10)|value<<4)
}
func (o *FPU_Type) GetFPSCR_IXC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x10) >> 4
}
func (o *FPU_Type) SetFPSCR_IDC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x80)|value<<7)
}
func (o *FPU_Type) GetFPSCR_IDC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x80) >> 7
}
func (o *FPU_Type) SetFPSCR_RMode(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0xc00000)|value<<22)
}
func (o *FPU_Type) GetFPSCR_RMode() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0xc00000) >> 22
}
func (o *FPU_Type) SetFPSCR_FZ(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x1000000)|value<<24)
}
func (o *FPU_Type) GetFPSCR_FZ() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x1000000) >> 24
}
func (o *FPU_Type) SetFPSCR_DN(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x2000000)|value<<25)
}
func (o *FPU_Type) GetFPSCR_DN() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x2000000) >> 25
}
func (o *FPU_Type) SetFPSCR_AHP(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x4000000)|value<<26)
}
func (o *FPU_Type) GetFPSCR_AHP() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x4000000) >> 26
}
func (o *FPU_Type) SetFPSCR_V(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x10000000)|value<<28)
}
func (o *FPU_Type) GetFPSCR_V() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x10000000) >> 28
}
func (o *FPU_Type) SetFPSCR_C(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x20000000)|value<<29)
}
func (o *FPU_Type) GetFPSCR_C() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x20000000) >> 29
}
func (o *FPU_Type) SetFPSCR_Z(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x40000000)|value<<30)
}
func (o *FPU_Type) GetFPSCR_Z() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x40000000) >> 30
}
func (o *FPU_Type) SetFPSCR_N(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x80000000)|value<<31)
}
func (o *FPU_Type) GetFPSCR_N() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x80000000) >> 31
}

// Flash
type FLASH_Type struct {
	ACR  volatile.Register32 // 0x0
	BANK [2]FLASH_BANK_Type  // 0x4
}

// FLASH.ACR: Access control register
func (o *FLASH_Type) SetACR_LATENCY(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x7)|value)
}
func (o *FLASH_Type) GetACR_LATENCY() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x7
}
func (o *FLASH_Type) SetACR_WRHIGHFREQ(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x30)|value<<4)
}
func (o *FLASH_Type) GetACR_WRHIGHFREQ() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x30) >> 4
}

// Cluster BANK%s, containing KEYR?, CR?, SR?, CCR?, PRAR_CUR?, PRAR_PRG?, SCAR_CUR?, SCAR_PRG?, WPSN_CUR?R, WPSN_PRG?R, CRCCR?, CRCSADD?R, CRCEADD?R, ECC_FA?R
type FLASH_BANK_Type struct {
	KEYR      volatile.Register32 // 0x4
	_         [4]byte
	CR        volatile.Register32 // 0xC
	SR        volatile.Register32 // 0x10
	CCR       volatile.Register32 // 0x14
	_         [16]byte
	PRAR_CUR  volatile.Register32 // 0x28
	PRAR_PRG  volatile.Register32 // 0x2C
	SCAR_CUR  volatile.Register32 // 0x30
	SCAR_PRG  volatile.Register32 // 0x34
	WPSN_CURR volatile.Register32 // 0x38
	WPSN_PRGR volatile.Register32 // 0x3C
	_         [16]byte
	CRCCR     volatile.Register32 // 0x50
	CRCSADDR  volatile.Register32 // 0x54
	CRCEADDR  volatile.Register32 // 0x58
	_         [4]byte
	FAR       volatile.Register32 // 0x60
	_         [160]byte
}

// FLASH_BANK.KEYR: FLASH key register for bank 1
func (o *FLASH_BANK_Type) SetKEYR(value uint32) {
	volatile.StoreUint32(&o.KEYR.Reg, value)
}
func (o *FLASH_BANK_Type) GetKEYR() uint32 {
	return volatile.LoadUint32(&o.KEYR.Reg)
}

// FLASH_BANK.CR: FLASH control register for bank 1
func (o *FLASH_BANK_Type) SetCR_LOCK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *FLASH_BANK_Type) GetCR_LOCK() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *FLASH_BANK_Type) SetCR_PG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *FLASH_BANK_Type) GetCR_PG() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *FLASH_BANK_Type) SetCR_SER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *FLASH_BANK_Type) GetCR_SER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *FLASH_BANK_Type) SetCR_BER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *FLASH_BANK_Type) GetCR_BER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *FLASH_BANK_Type) SetCR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30)|value<<4)
}
func (o *FLASH_BANK_Type) GetCR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30) >> 4
}
func (o *FLASH_BANK_Type) SetCR_FW(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *FLASH_BANK_Type) GetCR_FW() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *FLASH_BANK_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *FLASH_BANK_Type) GetCR_START() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *FLASH_BANK_Type) SetCR_SNB(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x700)|value<<8)
}
func (o *FLASH_BANK_Type) GetCR_SNB() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x700) >> 8
}
func (o *FLASH_BANK_Type) SetCR_CRC_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *FLASH_BANK_Type) GetCR_CRC_EN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *FLASH_BANK_Type) SetCR_EOPIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *FLASH_BANK_Type) GetCR_EOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *FLASH_BANK_Type) SetCR_WRPERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *FLASH_BANK_Type) GetCR_WRPERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *FLASH_BANK_Type) SetCR_PGSERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *FLASH_BANK_Type) GetCR_PGSERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *FLASH_BANK_Type) SetCR_STRBERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *FLASH_BANK_Type) GetCR_STRBERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *FLASH_BANK_Type) SetCR_INCERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200000)|value<<21)
}
func (o *FLASH_BANK_Type) GetCR_INCERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200000) >> 21
}
func (o *FLASH_BANK_Type) SetCR_OPERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400000)|value<<22)
}
func (o *FLASH_BANK_Type) GetCR_OPERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400000) >> 22
}
func (o *FLASH_BANK_Type) SetCR_RDPERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *FLASH_BANK_Type) GetCR_RDPERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *FLASH_BANK_Type) SetCR_RDSERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *FLASH_BANK_Type) GetCR_RDSERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *FLASH_BANK_Type) SetCR_SNECCERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *FLASH_BANK_Type) GetCR_SNECCERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *FLASH_BANK_Type) SetCR_DBECCERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *FLASH_BANK_Type) GetCR_DBECCERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}
func (o *FLASH_BANK_Type) SetCR_CRCENDIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000000)|value<<27)
}
func (o *FLASH_BANK_Type) GetCR_CRCENDIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000000) >> 27
}

// FLASH_BANK.SR: FLASH status register for bank 1
func (o *FLASH_BANK_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *FLASH_BANK_Type) GetSR_BSY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *FLASH_BANK_Type) SetSR_WBNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *FLASH_BANK_Type) GetSR_WBNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *FLASH_BANK_Type) SetSR_QW(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *FLASH_BANK_Type) GetSR_QW() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *FLASH_BANK_Type) SetSR_CRC_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *FLASH_BANK_Type) GetSR_CRC_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *FLASH_BANK_Type) SetSR_EOP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *FLASH_BANK_Type) GetSR_EOP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *FLASH_BANK_Type) SetSR_WRPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *FLASH_BANK_Type) GetSR_WRPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *FLASH_BANK_Type) SetSR_PGSERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *FLASH_BANK_Type) GetSR_PGSERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *FLASH_BANK_Type) SetSR_STRBERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *FLASH_BANK_Type) GetSR_STRBERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *FLASH_BANK_Type) SetSR_INCERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200000)|value<<21)
}
func (o *FLASH_BANK_Type) GetSR_INCERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200000) >> 21
}
func (o *FLASH_BANK_Type) SetSR_OPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400000)|value<<22)
}
func (o *FLASH_BANK_Type) GetSR_OPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400000) >> 22
}
func (o *FLASH_BANK_Type) SetSR_RDPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800000)|value<<23)
}
func (o *FLASH_BANK_Type) GetSR_RDPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800000) >> 23
}
func (o *FLASH_BANK_Type) SetSR_RDSERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000000)|value<<24)
}
func (o *FLASH_BANK_Type) GetSR_RDSERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000000) >> 24
}
func (o *FLASH_BANK_Type) SetSR_SNECCERR1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000000)|value<<25)
}
func (o *FLASH_BANK_Type) GetSR_SNECCERR1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000000) >> 25
}
func (o *FLASH_BANK_Type) SetSR_DBECCERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000000)|value<<26)
}
func (o *FLASH_BANK_Type) GetSR_DBECCERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000000) >> 26
}
func (o *FLASH_BANK_Type) SetSR_CRCEND(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000000)|value<<27)
}
func (o *FLASH_BANK_Type) GetSR_CRCEND() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000000) >> 27
}

// FLASH_BANK.CCR: FLASH clear control register for bank 1
func (o *FLASH_BANK_Type) SetCCR_CLR_EOP(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10000)|value<<16)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_EOP() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10000) >> 16
}
func (o *FLASH_BANK_Type) SetCCR_CLR_WRPERR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x20000)|value<<17)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_WRPERR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x20000) >> 17
}
func (o *FLASH_BANK_Type) SetCCR_CLR_PGSERR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x40000)|value<<18)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_PGSERR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x40000) >> 18
}
func (o *FLASH_BANK_Type) SetCCR_CLR_STRBERR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x80000)|value<<19)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_STRBERR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x80000) >> 19
}
func (o *FLASH_BANK_Type) SetCCR_CLR_INCERR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x200000)|value<<21)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_INCERR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x200000) >> 21
}
func (o *FLASH_BANK_Type) SetCCR_CLR_OPERR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x400000)|value<<22)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_OPERR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x400000) >> 22
}
func (o *FLASH_BANK_Type) SetCCR_CLR_RDPERR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x800000)|value<<23)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_RDPERR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x800000) >> 23
}
func (o *FLASH_BANK_Type) SetCCR_CLR_RDSERR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1000000)|value<<24)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_RDSERR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x1000000) >> 24
}
func (o *FLASH_BANK_Type) SetCCR_CLR_SNECCERR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x2000000)|value<<25)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_SNECCERR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x2000000) >> 25
}
func (o *FLASH_BANK_Type) SetCCR_CLR_DBECCERR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x4000000)|value<<26)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_DBECCERR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x4000000) >> 26
}
func (o *FLASH_BANK_Type) SetCCR_CLR_CRCEND(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8000000)|value<<27)
}
func (o *FLASH_BANK_Type) GetCCR_CLR_CRCEND() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8000000) >> 27
}

// FLASH_BANK.PRAR_CUR: FLASH protection address for bank 1
func (o *FLASH_BANK_Type) SetPRAR_CUR_PROT_AREA_START(value uint32) {
	volatile.StoreUint32(&o.PRAR_CUR.Reg, volatile.LoadUint32(&o.PRAR_CUR.Reg)&^(0xfff)|value)
}
func (o *FLASH_BANK_Type) GetPRAR_CUR_PROT_AREA_START() uint32 {
	return volatile.LoadUint32(&o.PRAR_CUR.Reg) & 0xfff
}
func (o *FLASH_BANK_Type) SetPRAR_CUR_PROT_AREA_END(value uint32) {
	volatile.StoreUint32(&o.PRAR_CUR.Reg, volatile.LoadUint32(&o.PRAR_CUR.Reg)&^(0xfff0000)|value<<16)
}
func (o *FLASH_BANK_Type) GetPRAR_CUR_PROT_AREA_END() uint32 {
	return (volatile.LoadUint32(&o.PRAR_CUR.Reg) & 0xfff0000) >> 16
}
func (o *FLASH_BANK_Type) SetPRAR_CUR_DMEP(value uint32) {
	volatile.StoreUint32(&o.PRAR_CUR.Reg, volatile.LoadUint32(&o.PRAR_CUR.Reg)&^(0x80000000)|value<<31)
}
func (o *FLASH_BANK_Type) GetPRAR_CUR_DMEP() uint32 {
	return (volatile.LoadUint32(&o.PRAR_CUR.Reg) & 0x80000000) >> 31
}

// FLASH_BANK.PRAR_PRG: FLASH protection address for bank 1
func (o *FLASH_BANK_Type) SetPRAR_PRG_PROT_AREA_START(value uint32) {
	volatile.StoreUint32(&o.PRAR_PRG.Reg, volatile.LoadUint32(&o.PRAR_PRG.Reg)&^(0xfff)|value)
}
func (o *FLASH_BANK_Type) GetPRAR_PRG_PROT_AREA_START() uint32 {
	return volatile.LoadUint32(&o.PRAR_PRG.Reg) & 0xfff
}
func (o *FLASH_BANK_Type) SetPRAR_PRG_PROT_AREA_END(value uint32) {
	volatile.StoreUint32(&o.PRAR_PRG.Reg, volatile.LoadUint32(&o.PRAR_PRG.Reg)&^(0xfff0000)|value<<16)
}
func (o *FLASH_BANK_Type) GetPRAR_PRG_PROT_AREA_END() uint32 {
	return (volatile.LoadUint32(&o.PRAR_PRG.Reg) & 0xfff0000) >> 16
}
func (o *FLASH_BANK_Type) SetPRAR_PRG_DMEP(value uint32) {
	volatile.StoreUint32(&o.PRAR_PRG.Reg, volatile.LoadUint32(&o.PRAR_PRG.Reg)&^(0x80000000)|value<<31)
}
func (o *FLASH_BANK_Type) GetPRAR_PRG_DMEP() uint32 {
	return (volatile.LoadUint32(&o.PRAR_PRG.Reg) & 0x80000000) >> 31
}

// FLASH_BANK.SCAR_CUR: FLASH secure address for bank 1
func (o *FLASH_BANK_Type) SetSCAR_CUR_SEC_AREA_START(value uint32) {
	volatile.StoreUint32(&o.SCAR_CUR.Reg, volatile.LoadUint32(&o.SCAR_CUR.Reg)&^(0xfff)|value)
}
func (o *FLASH_BANK_Type) GetSCAR_CUR_SEC_AREA_START() uint32 {
	return volatile.LoadUint32(&o.SCAR_CUR.Reg) & 0xfff
}
func (o *FLASH_BANK_Type) SetSCAR_CUR_SEC_AREA_END(value uint32) {
	volatile.StoreUint32(&o.SCAR_CUR.Reg, volatile.LoadUint32(&o.SCAR_CUR.Reg)&^(0xfff0000)|value<<16)
}
func (o *FLASH_BANK_Type) GetSCAR_CUR_SEC_AREA_END() uint32 {
	return (volatile.LoadUint32(&o.SCAR_CUR.Reg) & 0xfff0000) >> 16
}
func (o *FLASH_BANK_Type) SetSCAR_CUR_DMES(value uint32) {
	volatile.StoreUint32(&o.SCAR_CUR.Reg, volatile.LoadUint32(&o.SCAR_CUR.Reg)&^(0x80000000)|value<<31)
}
func (o *FLASH_BANK_Type) GetSCAR_CUR_DMES() uint32 {
	return (volatile.LoadUint32(&o.SCAR_CUR.Reg) & 0x80000000) >> 31
}

// FLASH_BANK.SCAR_PRG: FLASH secure address for bank 1
func (o *FLASH_BANK_Type) SetSCAR_PRG_SEC_AREA_START(value uint32) {
	volatile.StoreUint32(&o.SCAR_PRG.Reg, volatile.LoadUint32(&o.SCAR_PRG.Reg)&^(0xfff)|value)
}
func (o *FLASH_BANK_Type) GetSCAR_PRG_SEC_AREA_START() uint32 {
	return volatile.LoadUint32(&o.SCAR_PRG.Reg) & 0xfff
}
func (o *FLASH_BANK_Type) SetSCAR_PRG_SEC_AREA_END(value uint32) {
	volatile.StoreUint32(&o.SCAR_PRG.Reg, volatile.LoadUint32(&o.SCAR_PRG.Reg)&^(0xfff0000)|value<<16)
}
func (o *FLASH_BANK_Type) GetSCAR_PRG_SEC_AREA_END() uint32 {
	return (volatile.LoadUint32(&o.SCAR_PRG.Reg) & 0xfff0000) >> 16
}
func (o *FLASH_BANK_Type) SetSCAR_PRG_DMES(value uint32) {
	volatile.StoreUint32(&o.SCAR_PRG.Reg, volatile.LoadUint32(&o.SCAR_PRG.Reg)&^(0x80000000)|value<<31)
}
func (o *FLASH_BANK_Type) GetSCAR_PRG_DMES() uint32 {
	return (volatile.LoadUint32(&o.SCAR_PRG.Reg) & 0x80000000) >> 31
}

// FLASH_BANK.WPSN_CURR: FLASH write sector protection for bank 1
func (o *FLASH_BANK_Type) SetWPSN_CURR_WRPSn(value uint32) {
	volatile.StoreUint32(&o.WPSN_CURR.Reg, volatile.LoadUint32(&o.WPSN_CURR.Reg)&^(0xff)|value)
}
func (o *FLASH_BANK_Type) GetWPSN_CURR_WRPSn() uint32 {
	return volatile.LoadUint32(&o.WPSN_CURR.Reg) & 0xff
}

// FLASH_BANK.WPSN_PRGR: FLASH write sector protection for bank 1
func (o *FLASH_BANK_Type) SetWPSN_PRGR_WRPSn(value uint32) {
	volatile.StoreUint32(&o.WPSN_PRGR.Reg, volatile.LoadUint32(&o.WPSN_PRGR.Reg)&^(0xff)|value)
}
func (o *FLASH_BANK_Type) GetWPSN_PRGR_WRPSn() uint32 {
	return volatile.LoadUint32(&o.WPSN_PRGR.Reg) & 0xff
}

// FLASH_BANK.CRCCR: FLASH CRC control register for bank 1
func (o *FLASH_BANK_Type) SetCRCCR_CRC_SECT(value uint32) {
	volatile.StoreUint32(&o.CRCCR.Reg, volatile.LoadUint32(&o.CRCCR.Reg)&^(0x7)|value)
}
func (o *FLASH_BANK_Type) GetCRCCR_CRC_SECT() uint32 {
	return volatile.LoadUint32(&o.CRCCR.Reg) & 0x7
}
func (o *FLASH_BANK_Type) SetCRCCR_ALL_BANK(value uint32) {
	volatile.StoreUint32(&o.CRCCR.Reg, volatile.LoadUint32(&o.CRCCR.Reg)&^(0x80)|value<<7)
}
func (o *FLASH_BANK_Type) GetCRCCR_ALL_BANK() uint32 {
	return (volatile.LoadUint32(&o.CRCCR.Reg) & 0x80) >> 7
}
func (o *FLASH_BANK_Type) SetCRCCR_CRC_BY_SECT(value uint32) {
	volatile.StoreUint32(&o.CRCCR.Reg, volatile.LoadUint32(&o.CRCCR.Reg)&^(0x100)|value<<8)
}
func (o *FLASH_BANK_Type) GetCRCCR_CRC_BY_SECT() uint32 {
	return (volatile.LoadUint32(&o.CRCCR.Reg) & 0x100) >> 8
}
func (o *FLASH_BANK_Type) SetCRCCR_ADD_SECT(value uint32) {
	volatile.StoreUint32(&o.CRCCR.Reg, volatile.LoadUint32(&o.CRCCR.Reg)&^(0x200)|value<<9)
}
func (o *FLASH_BANK_Type) GetCRCCR_ADD_SECT() uint32 {
	return (volatile.LoadUint32(&o.CRCCR.Reg) & 0x200) >> 9
}
func (o *FLASH_BANK_Type) SetCRCCR_CLEAN_SECT(value uint32) {
	volatile.StoreUint32(&o.CRCCR.Reg, volatile.LoadUint32(&o.CRCCR.Reg)&^(0x400)|value<<10)
}
func (o *FLASH_BANK_Type) GetCRCCR_CLEAN_SECT() uint32 {
	return (volatile.LoadUint32(&o.CRCCR.Reg) & 0x400) >> 10
}
func (o *FLASH_BANK_Type) SetCRCCR_START_CRC(value uint32) {
	volatile.StoreUint32(&o.CRCCR.Reg, volatile.LoadUint32(&o.CRCCR.Reg)&^(0x10000)|value<<16)
}
func (o *FLASH_BANK_Type) GetCRCCR_START_CRC() uint32 {
	return (volatile.LoadUint32(&o.CRCCR.Reg) & 0x10000) >> 16
}
func (o *FLASH_BANK_Type) SetCRCCR_CLEAN_CRC(value uint32) {
	volatile.StoreUint32(&o.CRCCR.Reg, volatile.LoadUint32(&o.CRCCR.Reg)&^(0x20000)|value<<17)
}
func (o *FLASH_BANK_Type) GetCRCCR_CLEAN_CRC() uint32 {
	return (volatile.LoadUint32(&o.CRCCR.Reg) & 0x20000) >> 17
}
func (o *FLASH_BANK_Type) SetCRCCR_CRC_BURST(value uint32) {
	volatile.StoreUint32(&o.CRCCR.Reg, volatile.LoadUint32(&o.CRCCR.Reg)&^(0x300000)|value<<20)
}
func (o *FLASH_BANK_Type) GetCRCCR_CRC_BURST() uint32 {
	return (volatile.LoadUint32(&o.CRCCR.Reg) & 0x300000) >> 20
}

// FLASH_BANK.CRCSADDR: FLASH CRC start address register for bank 1
func (o *FLASH_BANK_Type) SetCRCSADDR(value uint32) {
	volatile.StoreUint32(&o.CRCSADDR.Reg, value)
}
func (o *FLASH_BANK_Type) GetCRCSADDR() uint32 {
	return volatile.LoadUint32(&o.CRCSADDR.Reg)
}

// FLASH_BANK.CRCEADDR: FLASH CRC end address register for bank 1
func (o *FLASH_BANK_Type) SetCRCEADDR(value uint32) {
	volatile.StoreUint32(&o.CRCEADDR.Reg, value)
}
func (o *FLASH_BANK_Type) GetCRCEADDR() uint32 {
	return volatile.LoadUint32(&o.CRCEADDR.Reg)
}

// FLASH_BANK.FAR: FLASH ECC fail address for bank 1
func (o *FLASH_BANK_Type) SetFAR_FAIL_ECC_ADDR(value uint32) {
	volatile.StoreUint32(&o.FAR.Reg, volatile.LoadUint32(&o.FAR.Reg)&^(0x7fff)|value)
}
func (o *FLASH_BANK_Type) GetFAR_FAIL_ECC_ADDR() uint32 {
	return volatile.LoadUint32(&o.FAR.Reg) & 0x7fff
}

// GPIO
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
}

// GPIO.MODER: GPIO port mode register
func (o *GPIO_Type) SetMODER_MODER0(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetMODER_MODER0() uint32 {
	return volatile.LoadUint32(&o.MODER.Reg) & 0x3
}
func (o *GPIO_Type) SetMODER_MODER1(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetMODER_MODER1() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetMODER_MODER2(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetMODER_MODER2() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetMODER_MODER3(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetMODER_MODER3() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetMODER_MODER4(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetMODER_MODER4() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetMODER_MODER5(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetMODER_MODER5() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetMODER_MODER6(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetMODER_MODER6() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetMODER_MODER7(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetMODER_MODER7() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetMODER_MODER8(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetMODER_MODER8() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetMODER_MODER9(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetMODER_MODER9() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetMODER_MODER10(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetMODER_MODER10() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetMODER_MODER11(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetMODER_MODER11() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetMODER_MODER12(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetMODER_MODER12() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetMODER_MODER13(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetMODER_MODER13() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetMODER_MODER14(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetMODER_MODER14() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetMODER_MODER15(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetMODER_MODER15() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000000) >> 30
}

// GPIO.OTYPER: GPIO port output type register
func (o *GPIO_Type) SetOTYPER_OT0(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOTYPER_OT0() uint32 {
	return volatile.LoadUint32(&o.OTYPER.Reg) & 0x1
}
func (o *GPIO_Type) SetOTYPER_OT1(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOTYPER_OT1() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOTYPER_OT2(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOTYPER_OT2() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOTYPER_OT3(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOTYPER_OT3() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOTYPER_OT4(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOTYPER_OT4() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOTYPER_OT5(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOTYPER_OT5() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOTYPER_OT6(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOTYPER_OT6() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOTYPER_OT7(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOTYPER_OT7() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOTYPER_OT8(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOTYPER_OT8() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOTYPER_OT9(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOTYPER_OT9() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOTYPER_OT10(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOTYPER_OT10() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOTYPER_OT11(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOTYPER_OT11() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOTYPER_OT12(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOTYPER_OT12() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOTYPER_OT13(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOTYPER_OT13() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOTYPER_OT14(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOTYPER_OT14() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOTYPER_OT15(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOTYPER_OT15() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8000) >> 15
}

// GPIO.OSPEEDR: GPIO port output speed register
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR0(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR0() uint32 {
	return volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR1(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR1() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR2(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR2() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR3(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR3() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR4(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR4() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR5(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR5() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR6(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR6() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR7(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR7() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR8(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR8() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR9(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR9() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR10(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR10() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR11(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR11() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR12(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR12() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR13(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR13() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR14(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR14() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR15(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR15() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000000) >> 30
}

// GPIO.PUPDR: GPIO port pull-up/pull-down register
func (o *GPIO_Type) SetPUPDR_PUPDR0(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPUPDR_PUPDR0() uint32 {
	return volatile.LoadUint32(&o.PUPDR.Reg) & 0x3
}
func (o *GPIO_Type) SetPUPDR_PUPDR1(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetPUPDR_PUPDR1() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetPUPDR_PUPDR2(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetPUPDR_PUPDR2() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetPUPDR_PUPDR3(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetPUPDR_PUPDR3() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetPUPDR_PUPDR4(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetPUPDR_PUPDR4() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetPUPDR_PUPDR5(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetPUPDR_PUPDR5() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetPUPDR_PUPDR6(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetPUPDR_PUPDR6() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetPUPDR_PUPDR7(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetPUPDR_PUPDR7() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetPUPDR_PUPDR8(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetPUPDR_PUPDR8() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetPUPDR_PUPDR9(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetPUPDR_PUPDR9() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetPUPDR_PUPDR10(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetPUPDR_PUPDR10() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetPUPDR_PUPDR11(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetPUPDR_PUPDR11() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetPUPDR_PUPDR12(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetPUPDR_PUPDR12() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetPUPDR_PUPDR13(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetPUPDR_PUPDR13() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetPUPDR_PUPDR14(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetPUPDR_PUPDR14() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetPUPDR_PUPDR15(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetPUPDR_PUPDR15() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000000) >> 30
}

// GPIO.IDR: GPIO port input data register
func (o *GPIO_Type) SetIDR_IDR0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIDR_IDR0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *GPIO_Type) SetIDR_IDR1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIDR_IDR1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIDR_IDR2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIDR_IDR2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIDR_IDR3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIDR_IDR3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIDR_IDR4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIDR_IDR4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIDR_IDR5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIDR_IDR5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIDR_IDR6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIDR_IDR6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIDR_IDR7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIDR_IDR7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIDR_IDR8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIDR_IDR8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIDR_IDR9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIDR_IDR9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIDR_IDR10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIDR_IDR10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIDR_IDR11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIDR_IDR11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIDR_IDR12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIDR_IDR12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIDR_IDR13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIDR_IDR13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIDR_IDR14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIDR_IDR14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIDR_IDR15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIDR_IDR15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}

// GPIO.ODR: GPIO port output data register
func (o *GPIO_Type) SetODR_ODR0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetODR_ODR0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}
func (o *GPIO_Type) SetODR_ODR1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetODR_ODR1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetODR_ODR2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetODR_ODR2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetODR_ODR3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetODR_ODR3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetODR_ODR4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetODR_ODR4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetODR_ODR5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetODR_ODR5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetODR_ODR6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetODR_ODR6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetODR_ODR7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetODR_ODR7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetODR_ODR8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetODR_ODR8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetODR_ODR9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetODR_ODR9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetODR_ODR10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetODR_ODR10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetODR_ODR11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetODR_ODR11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetODR_ODR12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetODR_ODR12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetODR_ODR13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetODR_ODR13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetODR_ODR14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetODR_ODR14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetODR_ODR15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetODR_ODR15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}

// GPIO.BSRR: GPIO port bit set/reset register
func (o *GPIO_Type) SetBSRR_BS0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBSRR_BS0() uint32 {
	return volatile.LoadUint32(&o.BSRR.Reg) & 0x1
}
func (o *GPIO_Type) SetBSRR_BS1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBSRR_BS1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBSRR_BS2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBSRR_BS2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBSRR_BS3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBSRR_BS3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBSRR_BS4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBSRR_BS4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBSRR_BS5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBSRR_BS5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBSRR_BS6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBSRR_BS6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBSRR_BS7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBSRR_BS7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBSRR_BS8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBSRR_BS8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBSRR_BS9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBSRR_BS9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBSRR_BS10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBSRR_BS10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBSRR_BS11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBSRR_BS11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBSRR_BS12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBSRR_BS12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBSRR_BS13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBSRR_BS13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBSRR_BS14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBSRR_BS14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBSRR_BS15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBSRR_BS15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetBSRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetBSRR_BR0() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetBSRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetBSRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetBSRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetBSRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetBSRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetBSRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetBSRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetBSRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetBSRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetBSRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetBSRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetBSRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetBSRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetBSRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetBSRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetBSRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetBSRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetBSRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetBSRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetBSRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetBSRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetBSRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetBSRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetBSRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetBSRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetBSRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetBSRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetBSRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetBSRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetBSRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000000) >> 31
}

// GPIO.LCKR: This register is used to lock the configuration of the port bits when a correct write sequence is applied to bit 16 (LCKK). The value of bits [15:0] is used to lock the configuration of the GPIO. During the write sequence, the value of LCKR[15:0] must not change. When the LOCK sequence has been applied on a port bit, the value of this port bit can no longer be modified until the next MCU reset or peripheral reset.A specific write sequence is used to write to the GPIOx_LCKR register. Only word access (32-bit long) is allowed during this locking sequence.Each lock bit freezes a specific configuration register (control and alternate function registers).
func (o *GPIO_Type) SetLCKR_LCK0(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLCKR_LCK0() uint32 {
	return volatile.LoadUint32(&o.LCKR.Reg) & 0x1
}
func (o *GPIO_Type) SetLCKR_LCK1(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLCKR_LCK1() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLCKR_LCK2(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLCKR_LCK2() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLCKR_LCK3(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLCKR_LCK3() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLCKR_LCK4(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLCKR_LCK4() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLCKR_LCK5(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLCKR_LCK5() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLCKR_LCK6(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLCKR_LCK6() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLCKR_LCK7(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLCKR_LCK7() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLCKR_LCK8(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLCKR_LCK8() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLCKR_LCK9(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLCKR_LCK9() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLCKR_LCK10(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLCKR_LCK10() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLCKR_LCK11(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLCKR_LCK11() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLCKR_LCK12(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLCKR_LCK12() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLCKR_LCK13(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLCKR_LCK13() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLCKR_LCK14(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLCKR_LCK14() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLCKR_LCK15(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLCKR_LCK15() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLCKR_LCKK(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLCKR_LCKK() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10000) >> 16
}

// GPIO.AFRL: GPIO alternate function low register
func (o *GPIO_Type) SetAFRL_AFR0(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRL_AFR0() uint32 {
	return volatile.LoadUint32(&o.AFRL.Reg) & 0xf
}
func (o *GPIO_Type) SetAFRL_AFR1(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRL_AFR1() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRL_AFR2(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRL_AFR2() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRL_AFR3(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRL_AFR3() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRL_AFR4(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRL_AFR4() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRL_AFR5(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRL_AFR5() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRL_AFR6(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRL_AFR6() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRL_AFR7(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRL_AFR7() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000000) >> 28
}

// GPIO.AFRH: GPIO alternate function high register
func (o *GPIO_Type) SetAFRH_AFR8(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRH_AFR8() uint32 {
	return volatile.LoadUint32(&o.AFRH.Reg) & 0xf
}
func (o *GPIO_Type) SetAFRH_AFR9(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRH_AFR9() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRH_AFR10(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRH_AFR10() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRH_AFR11(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRH_AFR11() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRH_AFR12(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRH_AFR12() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRH_AFR13(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRH_AFR13() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRH_AFR14(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRH_AFR14() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRH_AFR15(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRH_AFR15() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000000) >> 28
}

// HSEM
type HSEM_Type struct {
	R0     volatile.Register32 // 0x0
	R1     volatile.Register32 // 0x4
	R2     volatile.Register32 // 0x8
	R3     volatile.Register32 // 0xC
	R4     volatile.Register32 // 0x10
	R5     volatile.Register32 // 0x14
	R6     volatile.Register32 // 0x18
	R7     volatile.Register32 // 0x1C
	R8     volatile.Register32 // 0x20
	R9     volatile.Register32 // 0x24
	R10    volatile.Register32 // 0x28
	R11    volatile.Register32 // 0x2C
	R12    volatile.Register32 // 0x30
	R13    volatile.Register32 // 0x34
	R14    volatile.Register32 // 0x38
	R15    volatile.Register32 // 0x3C
	R16    volatile.Register32 // 0x40
	R17    volatile.Register32 // 0x44
	R18    volatile.Register32 // 0x48
	R19    volatile.Register32 // 0x4C
	R20    volatile.Register32 // 0x50
	R21    volatile.Register32 // 0x54
	R22    volatile.Register32 // 0x58
	R23    volatile.Register32 // 0x5C
	R24    volatile.Register32 // 0x60
	R25    volatile.Register32 // 0x64
	R26    volatile.Register32 // 0x68
	R27    volatile.Register32 // 0x6C
	R28    volatile.Register32 // 0x70
	R29    volatile.Register32 // 0x74
	R30    volatile.Register32 // 0x78
	R31    volatile.Register32 // 0x7C
	RLR0   volatile.Register32 // 0x80
	RLR1   volatile.Register32 // 0x84
	RLR2   volatile.Register32 // 0x88
	RLR3   volatile.Register32 // 0x8C
	RLR4   volatile.Register32 // 0x90
	RLR5   volatile.Register32 // 0x94
	RLR6   volatile.Register32 // 0x98
	RLR7   volatile.Register32 // 0x9C
	RLR8   volatile.Register32 // 0xA0
	RLR9   volatile.Register32 // 0xA4
	RLR10  volatile.Register32 // 0xA8
	RLR11  volatile.Register32 // 0xAC
	RLR12  volatile.Register32 // 0xB0
	RLR13  volatile.Register32 // 0xB4
	RLR14  volatile.Register32 // 0xB8
	RLR15  volatile.Register32 // 0xBC
	RLR16  volatile.Register32 // 0xC0
	RLR17  volatile.Register32 // 0xC4
	RLR18  volatile.Register32 // 0xC8
	RLR19  volatile.Register32 // 0xCC
	RLR20  volatile.Register32 // 0xD0
	RLR21  volatile.Register32 // 0xD4
	RLR22  volatile.Register32 // 0xD8
	RLR23  volatile.Register32 // 0xDC
	RLR24  volatile.Register32 // 0xE0
	RLR25  volatile.Register32 // 0xE4
	RLR26  volatile.Register32 // 0xE8
	RLR27  volatile.Register32 // 0xEC
	RLR28  volatile.Register32 // 0xF0
	RLR29  volatile.Register32 // 0xF4
	RLR30  volatile.Register32 // 0xF8
	RLR31  volatile.Register32 // 0xFC
	C1IER  volatile.Register32 // 0x100
	C1ICR  volatile.Register32 // 0x104
	C1ISR  volatile.Register32 // 0x108
	C1MISR volatile.Register32 // 0x10C
	_      [48]byte
	CR     volatile.Register32 // 0x140
	KEYR   volatile.Register32 // 0x144
}

// HSEM.R0: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR0_PROCID(value uint32) {
	volatile.StoreUint32(&o.R0.Reg, volatile.LoadUint32(&o.R0.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR0_PROCID() uint32 {
	return volatile.LoadUint32(&o.R0.Reg) & 0xff
}
func (o *HSEM_Type) SetR0_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R0.Reg, volatile.LoadUint32(&o.R0.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR0_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R0.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR0_LOCK(value uint32) {
	volatile.StoreUint32(&o.R0.Reg, volatile.LoadUint32(&o.R0.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR0_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R0.Reg) & 0x80000000) >> 31
}

// HSEM.R1: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR1_PROCID(value uint32) {
	volatile.StoreUint32(&o.R1.Reg, volatile.LoadUint32(&o.R1.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR1_PROCID() uint32 {
	return volatile.LoadUint32(&o.R1.Reg) & 0xff
}
func (o *HSEM_Type) SetR1_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R1.Reg, volatile.LoadUint32(&o.R1.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR1_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R1.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR1_LOCK(value uint32) {
	volatile.StoreUint32(&o.R1.Reg, volatile.LoadUint32(&o.R1.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR1_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R1.Reg) & 0x80000000) >> 31
}

// HSEM.R2: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR2_PROCID(value uint32) {
	volatile.StoreUint32(&o.R2.Reg, volatile.LoadUint32(&o.R2.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR2_PROCID() uint32 {
	return volatile.LoadUint32(&o.R2.Reg) & 0xff
}
func (o *HSEM_Type) SetR2_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R2.Reg, volatile.LoadUint32(&o.R2.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR2_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R2.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR2_LOCK(value uint32) {
	volatile.StoreUint32(&o.R2.Reg, volatile.LoadUint32(&o.R2.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR2_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R2.Reg) & 0x80000000) >> 31
}

// HSEM.R3: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR3_PROCID(value uint32) {
	volatile.StoreUint32(&o.R3.Reg, volatile.LoadUint32(&o.R3.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR3_PROCID() uint32 {
	return volatile.LoadUint32(&o.R3.Reg) & 0xff
}
func (o *HSEM_Type) SetR3_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R3.Reg, volatile.LoadUint32(&o.R3.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR3_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R3.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR3_LOCK(value uint32) {
	volatile.StoreUint32(&o.R3.Reg, volatile.LoadUint32(&o.R3.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR3_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R3.Reg) & 0x80000000) >> 31
}

// HSEM.R4: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR4_PROCID(value uint32) {
	volatile.StoreUint32(&o.R4.Reg, volatile.LoadUint32(&o.R4.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR4_PROCID() uint32 {
	return volatile.LoadUint32(&o.R4.Reg) & 0xff
}
func (o *HSEM_Type) SetR4_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R4.Reg, volatile.LoadUint32(&o.R4.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR4_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R4.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR4_LOCK(value uint32) {
	volatile.StoreUint32(&o.R4.Reg, volatile.LoadUint32(&o.R4.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR4_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R4.Reg) & 0x80000000) >> 31
}

// HSEM.R5: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR5_PROCID(value uint32) {
	volatile.StoreUint32(&o.R5.Reg, volatile.LoadUint32(&o.R5.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR5_PROCID() uint32 {
	return volatile.LoadUint32(&o.R5.Reg) & 0xff
}
func (o *HSEM_Type) SetR5_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R5.Reg, volatile.LoadUint32(&o.R5.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR5_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R5.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR5_LOCK(value uint32) {
	volatile.StoreUint32(&o.R5.Reg, volatile.LoadUint32(&o.R5.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR5_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R5.Reg) & 0x80000000) >> 31
}

// HSEM.R6: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR6_PROCID(value uint32) {
	volatile.StoreUint32(&o.R6.Reg, volatile.LoadUint32(&o.R6.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR6_PROCID() uint32 {
	return volatile.LoadUint32(&o.R6.Reg) & 0xff
}
func (o *HSEM_Type) SetR6_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R6.Reg, volatile.LoadUint32(&o.R6.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR6_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R6.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR6_LOCK(value uint32) {
	volatile.StoreUint32(&o.R6.Reg, volatile.LoadUint32(&o.R6.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR6_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R6.Reg) & 0x80000000) >> 31
}

// HSEM.R7: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR7_PROCID(value uint32) {
	volatile.StoreUint32(&o.R7.Reg, volatile.LoadUint32(&o.R7.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR7_PROCID() uint32 {
	return volatile.LoadUint32(&o.R7.Reg) & 0xff
}
func (o *HSEM_Type) SetR7_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R7.Reg, volatile.LoadUint32(&o.R7.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR7_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R7.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR7_LOCK(value uint32) {
	volatile.StoreUint32(&o.R7.Reg, volatile.LoadUint32(&o.R7.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR7_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R7.Reg) & 0x80000000) >> 31
}

// HSEM.R8: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR8_PROCID(value uint32) {
	volatile.StoreUint32(&o.R8.Reg, volatile.LoadUint32(&o.R8.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR8_PROCID() uint32 {
	return volatile.LoadUint32(&o.R8.Reg) & 0xff
}
func (o *HSEM_Type) SetR8_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R8.Reg, volatile.LoadUint32(&o.R8.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR8_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R8.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR8_LOCK(value uint32) {
	volatile.StoreUint32(&o.R8.Reg, volatile.LoadUint32(&o.R8.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR8_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R8.Reg) & 0x80000000) >> 31
}

// HSEM.R9: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR9_PROCID(value uint32) {
	volatile.StoreUint32(&o.R9.Reg, volatile.LoadUint32(&o.R9.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR9_PROCID() uint32 {
	return volatile.LoadUint32(&o.R9.Reg) & 0xff
}
func (o *HSEM_Type) SetR9_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R9.Reg, volatile.LoadUint32(&o.R9.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR9_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R9.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR9_LOCK(value uint32) {
	volatile.StoreUint32(&o.R9.Reg, volatile.LoadUint32(&o.R9.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR9_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R9.Reg) & 0x80000000) >> 31
}

// HSEM.R10: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR10_PROCID(value uint32) {
	volatile.StoreUint32(&o.R10.Reg, volatile.LoadUint32(&o.R10.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR10_PROCID() uint32 {
	return volatile.LoadUint32(&o.R10.Reg) & 0xff
}
func (o *HSEM_Type) SetR10_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R10.Reg, volatile.LoadUint32(&o.R10.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR10_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R10.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR10_LOCK(value uint32) {
	volatile.StoreUint32(&o.R10.Reg, volatile.LoadUint32(&o.R10.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR10_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R10.Reg) & 0x80000000) >> 31
}

// HSEM.R11: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR11_PROCID(value uint32) {
	volatile.StoreUint32(&o.R11.Reg, volatile.LoadUint32(&o.R11.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR11_PROCID() uint32 {
	return volatile.LoadUint32(&o.R11.Reg) & 0xff
}
func (o *HSEM_Type) SetR11_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R11.Reg, volatile.LoadUint32(&o.R11.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR11_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R11.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR11_LOCK(value uint32) {
	volatile.StoreUint32(&o.R11.Reg, volatile.LoadUint32(&o.R11.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR11_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R11.Reg) & 0x80000000) >> 31
}

// HSEM.R12: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR12_PROCID(value uint32) {
	volatile.StoreUint32(&o.R12.Reg, volatile.LoadUint32(&o.R12.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR12_PROCID() uint32 {
	return volatile.LoadUint32(&o.R12.Reg) & 0xff
}
func (o *HSEM_Type) SetR12_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R12.Reg, volatile.LoadUint32(&o.R12.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR12_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R12.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR12_LOCK(value uint32) {
	volatile.StoreUint32(&o.R12.Reg, volatile.LoadUint32(&o.R12.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR12_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R12.Reg) & 0x80000000) >> 31
}

// HSEM.R13: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR13_PROCID(value uint32) {
	volatile.StoreUint32(&o.R13.Reg, volatile.LoadUint32(&o.R13.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR13_PROCID() uint32 {
	return volatile.LoadUint32(&o.R13.Reg) & 0xff
}
func (o *HSEM_Type) SetR13_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R13.Reg, volatile.LoadUint32(&o.R13.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR13_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R13.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR13_LOCK(value uint32) {
	volatile.StoreUint32(&o.R13.Reg, volatile.LoadUint32(&o.R13.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR13_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R13.Reg) & 0x80000000) >> 31
}

// HSEM.R14: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR14_PROCID(value uint32) {
	volatile.StoreUint32(&o.R14.Reg, volatile.LoadUint32(&o.R14.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR14_PROCID() uint32 {
	return volatile.LoadUint32(&o.R14.Reg) & 0xff
}
func (o *HSEM_Type) SetR14_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R14.Reg, volatile.LoadUint32(&o.R14.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR14_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R14.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR14_LOCK(value uint32) {
	volatile.StoreUint32(&o.R14.Reg, volatile.LoadUint32(&o.R14.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR14_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R14.Reg) & 0x80000000) >> 31
}

// HSEM.R15: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR15_PROCID(value uint32) {
	volatile.StoreUint32(&o.R15.Reg, volatile.LoadUint32(&o.R15.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR15_PROCID() uint32 {
	return volatile.LoadUint32(&o.R15.Reg) & 0xff
}
func (o *HSEM_Type) SetR15_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R15.Reg, volatile.LoadUint32(&o.R15.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR15_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R15.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR15_LOCK(value uint32) {
	volatile.StoreUint32(&o.R15.Reg, volatile.LoadUint32(&o.R15.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR15_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R15.Reg) & 0x80000000) >> 31
}

// HSEM.R16: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR16_PROCID(value uint32) {
	volatile.StoreUint32(&o.R16.Reg, volatile.LoadUint32(&o.R16.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR16_PROCID() uint32 {
	return volatile.LoadUint32(&o.R16.Reg) & 0xff
}
func (o *HSEM_Type) SetR16_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R16.Reg, volatile.LoadUint32(&o.R16.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR16_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R16.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR16_LOCK(value uint32) {
	volatile.StoreUint32(&o.R16.Reg, volatile.LoadUint32(&o.R16.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR16_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R16.Reg) & 0x80000000) >> 31
}

// HSEM.R17: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR17_PROCID(value uint32) {
	volatile.StoreUint32(&o.R17.Reg, volatile.LoadUint32(&o.R17.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR17_PROCID() uint32 {
	return volatile.LoadUint32(&o.R17.Reg) & 0xff
}
func (o *HSEM_Type) SetR17_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R17.Reg, volatile.LoadUint32(&o.R17.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR17_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R17.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR17_LOCK(value uint32) {
	volatile.StoreUint32(&o.R17.Reg, volatile.LoadUint32(&o.R17.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR17_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R17.Reg) & 0x80000000) >> 31
}

// HSEM.R18: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR18_PROCID(value uint32) {
	volatile.StoreUint32(&o.R18.Reg, volatile.LoadUint32(&o.R18.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR18_PROCID() uint32 {
	return volatile.LoadUint32(&o.R18.Reg) & 0xff
}
func (o *HSEM_Type) SetR18_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R18.Reg, volatile.LoadUint32(&o.R18.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR18_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R18.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR18_LOCK(value uint32) {
	volatile.StoreUint32(&o.R18.Reg, volatile.LoadUint32(&o.R18.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR18_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R18.Reg) & 0x80000000) >> 31
}

// HSEM.R19: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR19_PROCID(value uint32) {
	volatile.StoreUint32(&o.R19.Reg, volatile.LoadUint32(&o.R19.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR19_PROCID() uint32 {
	return volatile.LoadUint32(&o.R19.Reg) & 0xff
}
func (o *HSEM_Type) SetR19_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R19.Reg, volatile.LoadUint32(&o.R19.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR19_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R19.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR19_LOCK(value uint32) {
	volatile.StoreUint32(&o.R19.Reg, volatile.LoadUint32(&o.R19.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR19_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R19.Reg) & 0x80000000) >> 31
}

// HSEM.R20: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR20_PROCID(value uint32) {
	volatile.StoreUint32(&o.R20.Reg, volatile.LoadUint32(&o.R20.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR20_PROCID() uint32 {
	return volatile.LoadUint32(&o.R20.Reg) & 0xff
}
func (o *HSEM_Type) SetR20_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R20.Reg, volatile.LoadUint32(&o.R20.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR20_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R20.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR20_LOCK(value uint32) {
	volatile.StoreUint32(&o.R20.Reg, volatile.LoadUint32(&o.R20.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR20_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R20.Reg) & 0x80000000) >> 31
}

// HSEM.R21: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR21_PROCID(value uint32) {
	volatile.StoreUint32(&o.R21.Reg, volatile.LoadUint32(&o.R21.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR21_PROCID() uint32 {
	return volatile.LoadUint32(&o.R21.Reg) & 0xff
}
func (o *HSEM_Type) SetR21_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R21.Reg, volatile.LoadUint32(&o.R21.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR21_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R21.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR21_LOCK(value uint32) {
	volatile.StoreUint32(&o.R21.Reg, volatile.LoadUint32(&o.R21.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR21_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R21.Reg) & 0x80000000) >> 31
}

// HSEM.R22: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR22_PROCID(value uint32) {
	volatile.StoreUint32(&o.R22.Reg, volatile.LoadUint32(&o.R22.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR22_PROCID() uint32 {
	return volatile.LoadUint32(&o.R22.Reg) & 0xff
}
func (o *HSEM_Type) SetR22_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R22.Reg, volatile.LoadUint32(&o.R22.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR22_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R22.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR22_LOCK(value uint32) {
	volatile.StoreUint32(&o.R22.Reg, volatile.LoadUint32(&o.R22.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR22_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R22.Reg) & 0x80000000) >> 31
}

// HSEM.R23: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR23_PROCID(value uint32) {
	volatile.StoreUint32(&o.R23.Reg, volatile.LoadUint32(&o.R23.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR23_PROCID() uint32 {
	return volatile.LoadUint32(&o.R23.Reg) & 0xff
}
func (o *HSEM_Type) SetR23_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R23.Reg, volatile.LoadUint32(&o.R23.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR23_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R23.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR23_LOCK(value uint32) {
	volatile.StoreUint32(&o.R23.Reg, volatile.LoadUint32(&o.R23.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR23_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R23.Reg) & 0x80000000) >> 31
}

// HSEM.R24: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR24_PROCID(value uint32) {
	volatile.StoreUint32(&o.R24.Reg, volatile.LoadUint32(&o.R24.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR24_PROCID() uint32 {
	return volatile.LoadUint32(&o.R24.Reg) & 0xff
}
func (o *HSEM_Type) SetR24_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R24.Reg, volatile.LoadUint32(&o.R24.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR24_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R24.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR24_LOCK(value uint32) {
	volatile.StoreUint32(&o.R24.Reg, volatile.LoadUint32(&o.R24.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR24_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R24.Reg) & 0x80000000) >> 31
}

// HSEM.R25: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR25_PROCID(value uint32) {
	volatile.StoreUint32(&o.R25.Reg, volatile.LoadUint32(&o.R25.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR25_PROCID() uint32 {
	return volatile.LoadUint32(&o.R25.Reg) & 0xff
}
func (o *HSEM_Type) SetR25_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R25.Reg, volatile.LoadUint32(&o.R25.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR25_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R25.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR25_LOCK(value uint32) {
	volatile.StoreUint32(&o.R25.Reg, volatile.LoadUint32(&o.R25.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR25_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R25.Reg) & 0x80000000) >> 31
}

// HSEM.R26: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR26_PROCID(value uint32) {
	volatile.StoreUint32(&o.R26.Reg, volatile.LoadUint32(&o.R26.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR26_PROCID() uint32 {
	return volatile.LoadUint32(&o.R26.Reg) & 0xff
}
func (o *HSEM_Type) SetR26_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R26.Reg, volatile.LoadUint32(&o.R26.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR26_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R26.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR26_LOCK(value uint32) {
	volatile.StoreUint32(&o.R26.Reg, volatile.LoadUint32(&o.R26.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR26_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R26.Reg) & 0x80000000) >> 31
}

// HSEM.R27: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR27_PROCID(value uint32) {
	volatile.StoreUint32(&o.R27.Reg, volatile.LoadUint32(&o.R27.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR27_PROCID() uint32 {
	return volatile.LoadUint32(&o.R27.Reg) & 0xff
}
func (o *HSEM_Type) SetR27_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R27.Reg, volatile.LoadUint32(&o.R27.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR27_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R27.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR27_LOCK(value uint32) {
	volatile.StoreUint32(&o.R27.Reg, volatile.LoadUint32(&o.R27.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR27_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R27.Reg) & 0x80000000) >> 31
}

// HSEM.R28: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR28_PROCID(value uint32) {
	volatile.StoreUint32(&o.R28.Reg, volatile.LoadUint32(&o.R28.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR28_PROCID() uint32 {
	return volatile.LoadUint32(&o.R28.Reg) & 0xff
}
func (o *HSEM_Type) SetR28_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R28.Reg, volatile.LoadUint32(&o.R28.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR28_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R28.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR28_LOCK(value uint32) {
	volatile.StoreUint32(&o.R28.Reg, volatile.LoadUint32(&o.R28.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR28_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R28.Reg) & 0x80000000) >> 31
}

// HSEM.R29: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR29_PROCID(value uint32) {
	volatile.StoreUint32(&o.R29.Reg, volatile.LoadUint32(&o.R29.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR29_PROCID() uint32 {
	return volatile.LoadUint32(&o.R29.Reg) & 0xff
}
func (o *HSEM_Type) SetR29_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R29.Reg, volatile.LoadUint32(&o.R29.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR29_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R29.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR29_LOCK(value uint32) {
	volatile.StoreUint32(&o.R29.Reg, volatile.LoadUint32(&o.R29.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR29_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R29.Reg) & 0x80000000) >> 31
}

// HSEM.R30: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR30_PROCID(value uint32) {
	volatile.StoreUint32(&o.R30.Reg, volatile.LoadUint32(&o.R30.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR30_PROCID() uint32 {
	return volatile.LoadUint32(&o.R30.Reg) & 0xff
}
func (o *HSEM_Type) SetR30_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R30.Reg, volatile.LoadUint32(&o.R30.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR30_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R30.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR30_LOCK(value uint32) {
	volatile.StoreUint32(&o.R30.Reg, volatile.LoadUint32(&o.R30.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR30_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R30.Reg) & 0x80000000) >> 31
}

// HSEM.R31: HSEM register HSEM_R0 HSEM_R31
func (o *HSEM_Type) SetR31_PROCID(value uint32) {
	volatile.StoreUint32(&o.R31.Reg, volatile.LoadUint32(&o.R31.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetR31_PROCID() uint32 {
	return volatile.LoadUint32(&o.R31.Reg) & 0xff
}
func (o *HSEM_Type) SetR31_MASTERID(value uint32) {
	volatile.StoreUint32(&o.R31.Reg, volatile.LoadUint32(&o.R31.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetR31_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.R31.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetR31_LOCK(value uint32) {
	volatile.StoreUint32(&o.R31.Reg, volatile.LoadUint32(&o.R31.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetR31_LOCK() uint32 {
	return (volatile.LoadUint32(&o.R31.Reg) & 0x80000000) >> 31
}

// HSEM.RLR0: HSEM Read lock register
func (o *HSEM_Type) SetRLR0_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR0.Reg, volatile.LoadUint32(&o.RLR0.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR0_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR0.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR0_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR0.Reg, volatile.LoadUint32(&o.RLR0.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR0_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR0.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR0_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR0.Reg, volatile.LoadUint32(&o.RLR0.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR0_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR0.Reg) & 0x80000000) >> 31
}

// HSEM.RLR1: HSEM Read lock register
func (o *HSEM_Type) SetRLR1_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR1.Reg, volatile.LoadUint32(&o.RLR1.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR1_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR1.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR1_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR1.Reg, volatile.LoadUint32(&o.RLR1.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR1_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR1.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR1_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR1.Reg, volatile.LoadUint32(&o.RLR1.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR1_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR1.Reg) & 0x80000000) >> 31
}

// HSEM.RLR2: HSEM Read lock register
func (o *HSEM_Type) SetRLR2_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR2.Reg, volatile.LoadUint32(&o.RLR2.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR2_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR2.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR2_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR2.Reg, volatile.LoadUint32(&o.RLR2.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR2_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR2.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR2_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR2.Reg, volatile.LoadUint32(&o.RLR2.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR2_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR2.Reg) & 0x80000000) >> 31
}

// HSEM.RLR3: HSEM Read lock register
func (o *HSEM_Type) SetRLR3_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR3.Reg, volatile.LoadUint32(&o.RLR3.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR3_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR3.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR3_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR3.Reg, volatile.LoadUint32(&o.RLR3.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR3_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR3.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR3_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR3.Reg, volatile.LoadUint32(&o.RLR3.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR3_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR3.Reg) & 0x80000000) >> 31
}

// HSEM.RLR4: HSEM Read lock register
func (o *HSEM_Type) SetRLR4_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR4.Reg, volatile.LoadUint32(&o.RLR4.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR4_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR4.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR4_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR4.Reg, volatile.LoadUint32(&o.RLR4.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR4_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR4.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR4_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR4.Reg, volatile.LoadUint32(&o.RLR4.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR4_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR4.Reg) & 0x80000000) >> 31
}

// HSEM.RLR5: HSEM Read lock register
func (o *HSEM_Type) SetRLR5_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR5.Reg, volatile.LoadUint32(&o.RLR5.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR5_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR5.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR5_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR5.Reg, volatile.LoadUint32(&o.RLR5.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR5_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR5.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR5_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR5.Reg, volatile.LoadUint32(&o.RLR5.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR5_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR5.Reg) & 0x80000000) >> 31
}

// HSEM.RLR6: HSEM Read lock register
func (o *HSEM_Type) SetRLR6_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR6.Reg, volatile.LoadUint32(&o.RLR6.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR6_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR6.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR6_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR6.Reg, volatile.LoadUint32(&o.RLR6.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR6_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR6.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR6_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR6.Reg, volatile.LoadUint32(&o.RLR6.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR6_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR6.Reg) & 0x80000000) >> 31
}

// HSEM.RLR7: HSEM Read lock register
func (o *HSEM_Type) SetRLR7_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR7.Reg, volatile.LoadUint32(&o.RLR7.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR7_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR7.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR7_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR7.Reg, volatile.LoadUint32(&o.RLR7.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR7_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR7.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR7_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR7.Reg, volatile.LoadUint32(&o.RLR7.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR7_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR7.Reg) & 0x80000000) >> 31
}

// HSEM.RLR8: HSEM Read lock register
func (o *HSEM_Type) SetRLR8_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR8.Reg, volatile.LoadUint32(&o.RLR8.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR8_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR8.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR8_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR8.Reg, volatile.LoadUint32(&o.RLR8.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR8_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR8.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR8_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR8.Reg, volatile.LoadUint32(&o.RLR8.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR8_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR8.Reg) & 0x80000000) >> 31
}

// HSEM.RLR9: HSEM Read lock register
func (o *HSEM_Type) SetRLR9_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR9.Reg, volatile.LoadUint32(&o.RLR9.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR9_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR9.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR9_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR9.Reg, volatile.LoadUint32(&o.RLR9.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR9_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR9.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR9_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR9.Reg, volatile.LoadUint32(&o.RLR9.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR9_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR9.Reg) & 0x80000000) >> 31
}

// HSEM.RLR10: HSEM Read lock register
func (o *HSEM_Type) SetRLR10_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR10.Reg, volatile.LoadUint32(&o.RLR10.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR10_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR10.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR10_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR10.Reg, volatile.LoadUint32(&o.RLR10.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR10_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR10.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR10_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR10.Reg, volatile.LoadUint32(&o.RLR10.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR10_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR10.Reg) & 0x80000000) >> 31
}

// HSEM.RLR11: HSEM Read lock register
func (o *HSEM_Type) SetRLR11_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR11.Reg, volatile.LoadUint32(&o.RLR11.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR11_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR11.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR11_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR11.Reg, volatile.LoadUint32(&o.RLR11.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR11_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR11.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR11_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR11.Reg, volatile.LoadUint32(&o.RLR11.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR11_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR11.Reg) & 0x80000000) >> 31
}

// HSEM.RLR12: HSEM Read lock register
func (o *HSEM_Type) SetRLR12_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR12.Reg, volatile.LoadUint32(&o.RLR12.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR12_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR12.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR12_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR12.Reg, volatile.LoadUint32(&o.RLR12.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR12_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR12.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR12_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR12.Reg, volatile.LoadUint32(&o.RLR12.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR12_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR12.Reg) & 0x80000000) >> 31
}

// HSEM.RLR13: HSEM Read lock register
func (o *HSEM_Type) SetRLR13_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR13.Reg, volatile.LoadUint32(&o.RLR13.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR13_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR13.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR13_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR13.Reg, volatile.LoadUint32(&o.RLR13.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR13_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR13.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR13_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR13.Reg, volatile.LoadUint32(&o.RLR13.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR13_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR13.Reg) & 0x80000000) >> 31
}

// HSEM.RLR14: HSEM Read lock register
func (o *HSEM_Type) SetRLR14_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR14.Reg, volatile.LoadUint32(&o.RLR14.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR14_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR14.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR14_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR14.Reg, volatile.LoadUint32(&o.RLR14.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR14_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR14.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR14_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR14.Reg, volatile.LoadUint32(&o.RLR14.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR14_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR14.Reg) & 0x80000000) >> 31
}

// HSEM.RLR15: HSEM Read lock register
func (o *HSEM_Type) SetRLR15_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR15.Reg, volatile.LoadUint32(&o.RLR15.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR15_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR15.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR15_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR15.Reg, volatile.LoadUint32(&o.RLR15.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR15_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR15.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR15_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR15.Reg, volatile.LoadUint32(&o.RLR15.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR15_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR15.Reg) & 0x80000000) >> 31
}

// HSEM.RLR16: HSEM Read lock register
func (o *HSEM_Type) SetRLR16_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR16.Reg, volatile.LoadUint32(&o.RLR16.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR16_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR16.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR16_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR16.Reg, volatile.LoadUint32(&o.RLR16.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR16_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR16.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR16_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR16.Reg, volatile.LoadUint32(&o.RLR16.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR16_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR16.Reg) & 0x80000000) >> 31
}

// HSEM.RLR17: HSEM Read lock register
func (o *HSEM_Type) SetRLR17_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR17.Reg, volatile.LoadUint32(&o.RLR17.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR17_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR17.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR17_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR17.Reg, volatile.LoadUint32(&o.RLR17.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR17_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR17.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR17_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR17.Reg, volatile.LoadUint32(&o.RLR17.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR17_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR17.Reg) & 0x80000000) >> 31
}

// HSEM.RLR18: HSEM Read lock register
func (o *HSEM_Type) SetRLR18_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR18.Reg, volatile.LoadUint32(&o.RLR18.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR18_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR18.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR18_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR18.Reg, volatile.LoadUint32(&o.RLR18.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR18_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR18.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR18_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR18.Reg, volatile.LoadUint32(&o.RLR18.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR18_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR18.Reg) & 0x80000000) >> 31
}

// HSEM.RLR19: HSEM Read lock register
func (o *HSEM_Type) SetRLR19_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR19.Reg, volatile.LoadUint32(&o.RLR19.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR19_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR19.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR19_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR19.Reg, volatile.LoadUint32(&o.RLR19.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR19_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR19.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR19_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR19.Reg, volatile.LoadUint32(&o.RLR19.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR19_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR19.Reg) & 0x80000000) >> 31
}

// HSEM.RLR20: HSEM Read lock register
func (o *HSEM_Type) SetRLR20_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR20.Reg, volatile.LoadUint32(&o.RLR20.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR20_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR20.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR20_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR20.Reg, volatile.LoadUint32(&o.RLR20.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR20_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR20.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR20_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR20.Reg, volatile.LoadUint32(&o.RLR20.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR20_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR20.Reg) & 0x80000000) >> 31
}

// HSEM.RLR21: HSEM Read lock register
func (o *HSEM_Type) SetRLR21_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR21.Reg, volatile.LoadUint32(&o.RLR21.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR21_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR21.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR21_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR21.Reg, volatile.LoadUint32(&o.RLR21.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR21_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR21.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR21_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR21.Reg, volatile.LoadUint32(&o.RLR21.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR21_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR21.Reg) & 0x80000000) >> 31
}

// HSEM.RLR22: HSEM Read lock register
func (o *HSEM_Type) SetRLR22_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR22.Reg, volatile.LoadUint32(&o.RLR22.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR22_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR22.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR22_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR22.Reg, volatile.LoadUint32(&o.RLR22.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR22_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR22.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR22_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR22.Reg, volatile.LoadUint32(&o.RLR22.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR22_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR22.Reg) & 0x80000000) >> 31
}

// HSEM.RLR23: HSEM Read lock register
func (o *HSEM_Type) SetRLR23_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR23.Reg, volatile.LoadUint32(&o.RLR23.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR23_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR23.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR23_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR23.Reg, volatile.LoadUint32(&o.RLR23.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR23_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR23.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR23_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR23.Reg, volatile.LoadUint32(&o.RLR23.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR23_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR23.Reg) & 0x80000000) >> 31
}

// HSEM.RLR24: HSEM Read lock register
func (o *HSEM_Type) SetRLR24_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR24.Reg, volatile.LoadUint32(&o.RLR24.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR24_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR24.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR24_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR24.Reg, volatile.LoadUint32(&o.RLR24.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR24_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR24.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR24_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR24.Reg, volatile.LoadUint32(&o.RLR24.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR24_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR24.Reg) & 0x80000000) >> 31
}

// HSEM.RLR25: HSEM Read lock register
func (o *HSEM_Type) SetRLR25_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR25.Reg, volatile.LoadUint32(&o.RLR25.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR25_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR25.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR25_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR25.Reg, volatile.LoadUint32(&o.RLR25.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR25_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR25.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR25_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR25.Reg, volatile.LoadUint32(&o.RLR25.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR25_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR25.Reg) & 0x80000000) >> 31
}

// HSEM.RLR26: HSEM Read lock register
func (o *HSEM_Type) SetRLR26_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR26.Reg, volatile.LoadUint32(&o.RLR26.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR26_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR26.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR26_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR26.Reg, volatile.LoadUint32(&o.RLR26.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR26_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR26.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR26_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR26.Reg, volatile.LoadUint32(&o.RLR26.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR26_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR26.Reg) & 0x80000000) >> 31
}

// HSEM.RLR27: HSEM Read lock register
func (o *HSEM_Type) SetRLR27_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR27.Reg, volatile.LoadUint32(&o.RLR27.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR27_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR27.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR27_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR27.Reg, volatile.LoadUint32(&o.RLR27.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR27_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR27.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR27_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR27.Reg, volatile.LoadUint32(&o.RLR27.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR27_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR27.Reg) & 0x80000000) >> 31
}

// HSEM.RLR28: HSEM Read lock register
func (o *HSEM_Type) SetRLR28_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR28.Reg, volatile.LoadUint32(&o.RLR28.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR28_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR28.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR28_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR28.Reg, volatile.LoadUint32(&o.RLR28.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR28_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR28.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR28_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR28.Reg, volatile.LoadUint32(&o.RLR28.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR28_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR28.Reg) & 0x80000000) >> 31
}

// HSEM.RLR29: HSEM Read lock register
func (o *HSEM_Type) SetRLR29_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR29.Reg, volatile.LoadUint32(&o.RLR29.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR29_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR29.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR29_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR29.Reg, volatile.LoadUint32(&o.RLR29.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR29_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR29.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR29_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR29.Reg, volatile.LoadUint32(&o.RLR29.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR29_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR29.Reg) & 0x80000000) >> 31
}

// HSEM.RLR30: HSEM Read lock register
func (o *HSEM_Type) SetRLR30_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR30.Reg, volatile.LoadUint32(&o.RLR30.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR30_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR30.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR30_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR30.Reg, volatile.LoadUint32(&o.RLR30.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR30_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR30.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR30_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR30.Reg, volatile.LoadUint32(&o.RLR30.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR30_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR30.Reg) & 0x80000000) >> 31
}

// HSEM.RLR31: HSEM Read lock register
func (o *HSEM_Type) SetRLR31_PROCID(value uint32) {
	volatile.StoreUint32(&o.RLR31.Reg, volatile.LoadUint32(&o.RLR31.Reg)&^(0xff)|value)
}
func (o *HSEM_Type) GetRLR31_PROCID() uint32 {
	return volatile.LoadUint32(&o.RLR31.Reg) & 0xff
}
func (o *HSEM_Type) SetRLR31_MASTERID(value uint32) {
	volatile.StoreUint32(&o.RLR31.Reg, volatile.LoadUint32(&o.RLR31.Reg)&^(0xff00)|value<<8)
}
func (o *HSEM_Type) GetRLR31_MASTERID() uint32 {
	return (volatile.LoadUint32(&o.RLR31.Reg) & 0xff00) >> 8
}
func (o *HSEM_Type) SetRLR31_LOCK(value uint32) {
	volatile.StoreUint32(&o.RLR31.Reg, volatile.LoadUint32(&o.RLR31.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetRLR31_LOCK() uint32 {
	return (volatile.LoadUint32(&o.RLR31.Reg) & 0x80000000) >> 31
}

// HSEM.C1IER: HSEM Interrupt enable register
func (o *HSEM_Type) SetC1IER_ISEM0(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x1)|value)
}
func (o *HSEM_Type) GetC1IER_ISEM0() uint32 {
	return volatile.LoadUint32(&o.C1IER.Reg) & 0x1
}
func (o *HSEM_Type) SetC1IER_ISEM1(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x2)|value<<1)
}
func (o *HSEM_Type) GetC1IER_ISEM1() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x2) >> 1
}
func (o *HSEM_Type) SetC1IER_ISEM2(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x4)|value<<2)
}
func (o *HSEM_Type) GetC1IER_ISEM2() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x4) >> 2
}
func (o *HSEM_Type) SetC1IER_ISEM3(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x8)|value<<3)
}
func (o *HSEM_Type) GetC1IER_ISEM3() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x8) >> 3
}
func (o *HSEM_Type) SetC1IER_ISEM4(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x10)|value<<4)
}
func (o *HSEM_Type) GetC1IER_ISEM4() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x10) >> 4
}
func (o *HSEM_Type) SetC1IER_ISEM5(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x20)|value<<5)
}
func (o *HSEM_Type) GetC1IER_ISEM5() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x20) >> 5
}
func (o *HSEM_Type) SetC1IER_ISEM6(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x40)|value<<6)
}
func (o *HSEM_Type) GetC1IER_ISEM6() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x40) >> 6
}
func (o *HSEM_Type) SetC1IER_ISEM7(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x80)|value<<7)
}
func (o *HSEM_Type) GetC1IER_ISEM7() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x80) >> 7
}
func (o *HSEM_Type) SetC1IER_ISEM8(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x100)|value<<8)
}
func (o *HSEM_Type) GetC1IER_ISEM8() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x100) >> 8
}
func (o *HSEM_Type) SetC1IER_ISEM9(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x200)|value<<9)
}
func (o *HSEM_Type) GetC1IER_ISEM9() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x200) >> 9
}
func (o *HSEM_Type) SetC1IER_ISEM10(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x400)|value<<10)
}
func (o *HSEM_Type) GetC1IER_ISEM10() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x400) >> 10
}
func (o *HSEM_Type) SetC1IER_ISEM11(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x800)|value<<11)
}
func (o *HSEM_Type) GetC1IER_ISEM11() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x800) >> 11
}
func (o *HSEM_Type) SetC1IER_ISEM12(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x1000)|value<<12)
}
func (o *HSEM_Type) GetC1IER_ISEM12() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x1000) >> 12
}
func (o *HSEM_Type) SetC1IER_ISEM13(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x2000)|value<<13)
}
func (o *HSEM_Type) GetC1IER_ISEM13() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x2000) >> 13
}
func (o *HSEM_Type) SetC1IER_ISEM14(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x4000)|value<<14)
}
func (o *HSEM_Type) GetC1IER_ISEM14() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x4000) >> 14
}
func (o *HSEM_Type) SetC1IER_ISEM15(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x8000)|value<<15)
}
func (o *HSEM_Type) GetC1IER_ISEM15() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x8000) >> 15
}
func (o *HSEM_Type) SetC1IER_ISEM16(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x10000)|value<<16)
}
func (o *HSEM_Type) GetC1IER_ISEM16() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x10000) >> 16
}
func (o *HSEM_Type) SetC1IER_ISEM17(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x20000)|value<<17)
}
func (o *HSEM_Type) GetC1IER_ISEM17() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x20000) >> 17
}
func (o *HSEM_Type) SetC1IER_ISEM18(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x40000)|value<<18)
}
func (o *HSEM_Type) GetC1IER_ISEM18() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x40000) >> 18
}
func (o *HSEM_Type) SetC1IER_ISEM19(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x80000)|value<<19)
}
func (o *HSEM_Type) GetC1IER_ISEM19() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x80000) >> 19
}
func (o *HSEM_Type) SetC1IER_ISEM20(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x100000)|value<<20)
}
func (o *HSEM_Type) GetC1IER_ISEM20() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x100000) >> 20
}
func (o *HSEM_Type) SetC1IER_ISEM21(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x200000)|value<<21)
}
func (o *HSEM_Type) GetC1IER_ISEM21() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x200000) >> 21
}
func (o *HSEM_Type) SetC1IER_ISEM22(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x400000)|value<<22)
}
func (o *HSEM_Type) GetC1IER_ISEM22() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x400000) >> 22
}
func (o *HSEM_Type) SetC1IER_ISEM23(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x800000)|value<<23)
}
func (o *HSEM_Type) GetC1IER_ISEM23() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x800000) >> 23
}
func (o *HSEM_Type) SetC1IER_ISEM24(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x1000000)|value<<24)
}
func (o *HSEM_Type) GetC1IER_ISEM24() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x1000000) >> 24
}
func (o *HSEM_Type) SetC1IER_ISEM25(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x2000000)|value<<25)
}
func (o *HSEM_Type) GetC1IER_ISEM25() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x2000000) >> 25
}
func (o *HSEM_Type) SetC1IER_ISEM26(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x4000000)|value<<26)
}
func (o *HSEM_Type) GetC1IER_ISEM26() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x4000000) >> 26
}
func (o *HSEM_Type) SetC1IER_ISEM27(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x8000000)|value<<27)
}
func (o *HSEM_Type) GetC1IER_ISEM27() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x8000000) >> 27
}
func (o *HSEM_Type) SetC1IER_ISEM28(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x10000000)|value<<28)
}
func (o *HSEM_Type) GetC1IER_ISEM28() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x10000000) >> 28
}
func (o *HSEM_Type) SetC1IER_ISEM29(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x20000000)|value<<29)
}
func (o *HSEM_Type) GetC1IER_ISEM29() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x20000000) >> 29
}
func (o *HSEM_Type) SetC1IER_ISEM30(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x40000000)|value<<30)
}
func (o *HSEM_Type) GetC1IER_ISEM30() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x40000000) >> 30
}
func (o *HSEM_Type) SetC1IER_ISEM31(value uint32) {
	volatile.StoreUint32(&o.C1IER.Reg, volatile.LoadUint32(&o.C1IER.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetC1IER_ISEM31() uint32 {
	return (volatile.LoadUint32(&o.C1IER.Reg) & 0x80000000) >> 31
}

// HSEM.C1ICR: HSEM Interrupt clear register
func (o *HSEM_Type) SetC1ICR_ISEM0(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x1)|value)
}
func (o *HSEM_Type) GetC1ICR_ISEM0() uint32 {
	return volatile.LoadUint32(&o.C1ICR.Reg) & 0x1
}
func (o *HSEM_Type) SetC1ICR_ISEM1(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x2)|value<<1)
}
func (o *HSEM_Type) GetC1ICR_ISEM1() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x2) >> 1
}
func (o *HSEM_Type) SetC1ICR_ISEM2(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x4)|value<<2)
}
func (o *HSEM_Type) GetC1ICR_ISEM2() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x4) >> 2
}
func (o *HSEM_Type) SetC1ICR_ISEM3(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x8)|value<<3)
}
func (o *HSEM_Type) GetC1ICR_ISEM3() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x8) >> 3
}
func (o *HSEM_Type) SetC1ICR_ISEM4(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x10)|value<<4)
}
func (o *HSEM_Type) GetC1ICR_ISEM4() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x10) >> 4
}
func (o *HSEM_Type) SetC1ICR_ISEM5(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x20)|value<<5)
}
func (o *HSEM_Type) GetC1ICR_ISEM5() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x20) >> 5
}
func (o *HSEM_Type) SetC1ICR_ISEM6(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x40)|value<<6)
}
func (o *HSEM_Type) GetC1ICR_ISEM6() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x40) >> 6
}
func (o *HSEM_Type) SetC1ICR_ISEM7(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x80)|value<<7)
}
func (o *HSEM_Type) GetC1ICR_ISEM7() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x80) >> 7
}
func (o *HSEM_Type) SetC1ICR_ISEM8(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x100)|value<<8)
}
func (o *HSEM_Type) GetC1ICR_ISEM8() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x100) >> 8
}
func (o *HSEM_Type) SetC1ICR_ISEM9(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x200)|value<<9)
}
func (o *HSEM_Type) GetC1ICR_ISEM9() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x200) >> 9
}
func (o *HSEM_Type) SetC1ICR_ISEM10(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x400)|value<<10)
}
func (o *HSEM_Type) GetC1ICR_ISEM10() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x400) >> 10
}
func (o *HSEM_Type) SetC1ICR_ISEM11(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x800)|value<<11)
}
func (o *HSEM_Type) GetC1ICR_ISEM11() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x800) >> 11
}
func (o *HSEM_Type) SetC1ICR_ISEM12(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x1000)|value<<12)
}
func (o *HSEM_Type) GetC1ICR_ISEM12() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x1000) >> 12
}
func (o *HSEM_Type) SetC1ICR_ISEM13(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x2000)|value<<13)
}
func (o *HSEM_Type) GetC1ICR_ISEM13() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x2000) >> 13
}
func (o *HSEM_Type) SetC1ICR_ISEM14(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x4000)|value<<14)
}
func (o *HSEM_Type) GetC1ICR_ISEM14() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x4000) >> 14
}
func (o *HSEM_Type) SetC1ICR_ISEM15(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x8000)|value<<15)
}
func (o *HSEM_Type) GetC1ICR_ISEM15() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x8000) >> 15
}
func (o *HSEM_Type) SetC1ICR_ISEM16(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x10000)|value<<16)
}
func (o *HSEM_Type) GetC1ICR_ISEM16() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x10000) >> 16
}
func (o *HSEM_Type) SetC1ICR_ISEM17(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x20000)|value<<17)
}
func (o *HSEM_Type) GetC1ICR_ISEM17() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x20000) >> 17
}
func (o *HSEM_Type) SetC1ICR_ISEM18(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x40000)|value<<18)
}
func (o *HSEM_Type) GetC1ICR_ISEM18() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x40000) >> 18
}
func (o *HSEM_Type) SetC1ICR_ISEM19(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x80000)|value<<19)
}
func (o *HSEM_Type) GetC1ICR_ISEM19() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x80000) >> 19
}
func (o *HSEM_Type) SetC1ICR_ISEM20(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x100000)|value<<20)
}
func (o *HSEM_Type) GetC1ICR_ISEM20() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x100000) >> 20
}
func (o *HSEM_Type) SetC1ICR_ISEM21(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x200000)|value<<21)
}
func (o *HSEM_Type) GetC1ICR_ISEM21() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x200000) >> 21
}
func (o *HSEM_Type) SetC1ICR_ISEM22(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x400000)|value<<22)
}
func (o *HSEM_Type) GetC1ICR_ISEM22() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x400000) >> 22
}
func (o *HSEM_Type) SetC1ICR_ISEM23(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x800000)|value<<23)
}
func (o *HSEM_Type) GetC1ICR_ISEM23() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x800000) >> 23
}
func (o *HSEM_Type) SetC1ICR_ISEM24(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSEM_Type) GetC1ICR_ISEM24() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x1000000) >> 24
}
func (o *HSEM_Type) SetC1ICR_ISEM25(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSEM_Type) GetC1ICR_ISEM25() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x2000000) >> 25
}
func (o *HSEM_Type) SetC1ICR_ISEM26(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSEM_Type) GetC1ICR_ISEM26() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x4000000) >> 26
}
func (o *HSEM_Type) SetC1ICR_ISEM27(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSEM_Type) GetC1ICR_ISEM27() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x8000000) >> 27
}
func (o *HSEM_Type) SetC1ICR_ISEM28(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSEM_Type) GetC1ICR_ISEM28() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x10000000) >> 28
}
func (o *HSEM_Type) SetC1ICR_ISEM29(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSEM_Type) GetC1ICR_ISEM29() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x20000000) >> 29
}
func (o *HSEM_Type) SetC1ICR_ISEM30(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSEM_Type) GetC1ICR_ISEM30() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x40000000) >> 30
}
func (o *HSEM_Type) SetC1ICR_ISEM31(value uint32) {
	volatile.StoreUint32(&o.C1ICR.Reg, volatile.LoadUint32(&o.C1ICR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetC1ICR_ISEM31() uint32 {
	return (volatile.LoadUint32(&o.C1ICR.Reg) & 0x80000000) >> 31
}

// HSEM.C1ISR: HSEM Interrupt status register
func (o *HSEM_Type) SetC1ISR_ISEM0(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x1)|value)
}
func (o *HSEM_Type) GetC1ISR_ISEM0() uint32 {
	return volatile.LoadUint32(&o.C1ISR.Reg) & 0x1
}
func (o *HSEM_Type) SetC1ISR_ISEM1(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x2)|value<<1)
}
func (o *HSEM_Type) GetC1ISR_ISEM1() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x2) >> 1
}
func (o *HSEM_Type) SetC1ISR_ISEM2(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x4)|value<<2)
}
func (o *HSEM_Type) GetC1ISR_ISEM2() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x4) >> 2
}
func (o *HSEM_Type) SetC1ISR_ISEM3(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x8)|value<<3)
}
func (o *HSEM_Type) GetC1ISR_ISEM3() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x8) >> 3
}
func (o *HSEM_Type) SetC1ISR_ISEM4(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x10)|value<<4)
}
func (o *HSEM_Type) GetC1ISR_ISEM4() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x10) >> 4
}
func (o *HSEM_Type) SetC1ISR_ISEM5(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x20)|value<<5)
}
func (o *HSEM_Type) GetC1ISR_ISEM5() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x20) >> 5
}
func (o *HSEM_Type) SetC1ISR_ISEM6(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x40)|value<<6)
}
func (o *HSEM_Type) GetC1ISR_ISEM6() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x40) >> 6
}
func (o *HSEM_Type) SetC1ISR_ISEM7(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x80)|value<<7)
}
func (o *HSEM_Type) GetC1ISR_ISEM7() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x80) >> 7
}
func (o *HSEM_Type) SetC1ISR_ISEM8(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x100)|value<<8)
}
func (o *HSEM_Type) GetC1ISR_ISEM8() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x100) >> 8
}
func (o *HSEM_Type) SetC1ISR_ISEM9(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x200)|value<<9)
}
func (o *HSEM_Type) GetC1ISR_ISEM9() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x200) >> 9
}
func (o *HSEM_Type) SetC1ISR_ISEM10(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x400)|value<<10)
}
func (o *HSEM_Type) GetC1ISR_ISEM10() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x400) >> 10
}
func (o *HSEM_Type) SetC1ISR_ISEM11(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x800)|value<<11)
}
func (o *HSEM_Type) GetC1ISR_ISEM11() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x800) >> 11
}
func (o *HSEM_Type) SetC1ISR_ISEM12(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x1000)|value<<12)
}
func (o *HSEM_Type) GetC1ISR_ISEM12() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x1000) >> 12
}
func (o *HSEM_Type) SetC1ISR_ISEM13(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x2000)|value<<13)
}
func (o *HSEM_Type) GetC1ISR_ISEM13() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x2000) >> 13
}
func (o *HSEM_Type) SetC1ISR_ISEM14(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x4000)|value<<14)
}
func (o *HSEM_Type) GetC1ISR_ISEM14() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x4000) >> 14
}
func (o *HSEM_Type) SetC1ISR_ISEM15(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x8000)|value<<15)
}
func (o *HSEM_Type) GetC1ISR_ISEM15() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x8000) >> 15
}
func (o *HSEM_Type) SetC1ISR_ISEM16(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x10000)|value<<16)
}
func (o *HSEM_Type) GetC1ISR_ISEM16() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x10000) >> 16
}
func (o *HSEM_Type) SetC1ISR_ISEM17(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x20000)|value<<17)
}
func (o *HSEM_Type) GetC1ISR_ISEM17() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x20000) >> 17
}
func (o *HSEM_Type) SetC1ISR_ISEM18(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x40000)|value<<18)
}
func (o *HSEM_Type) GetC1ISR_ISEM18() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x40000) >> 18
}
func (o *HSEM_Type) SetC1ISR_ISEM19(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x80000)|value<<19)
}
func (o *HSEM_Type) GetC1ISR_ISEM19() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x80000) >> 19
}
func (o *HSEM_Type) SetC1ISR_ISEM20(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x100000)|value<<20)
}
func (o *HSEM_Type) GetC1ISR_ISEM20() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x100000) >> 20
}
func (o *HSEM_Type) SetC1ISR_ISEM21(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x200000)|value<<21)
}
func (o *HSEM_Type) GetC1ISR_ISEM21() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x200000) >> 21
}
func (o *HSEM_Type) SetC1ISR_ISEM22(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x400000)|value<<22)
}
func (o *HSEM_Type) GetC1ISR_ISEM22() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x400000) >> 22
}
func (o *HSEM_Type) SetC1ISR_ISEM23(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x800000)|value<<23)
}
func (o *HSEM_Type) GetC1ISR_ISEM23() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x800000) >> 23
}
func (o *HSEM_Type) SetC1ISR_ISEM24(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSEM_Type) GetC1ISR_ISEM24() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x1000000) >> 24
}
func (o *HSEM_Type) SetC1ISR_ISEM25(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSEM_Type) GetC1ISR_ISEM25() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x2000000) >> 25
}
func (o *HSEM_Type) SetC1ISR_ISEM26(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSEM_Type) GetC1ISR_ISEM26() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x4000000) >> 26
}
func (o *HSEM_Type) SetC1ISR_ISEM27(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSEM_Type) GetC1ISR_ISEM27() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x8000000) >> 27
}
func (o *HSEM_Type) SetC1ISR_ISEM28(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSEM_Type) GetC1ISR_ISEM28() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x10000000) >> 28
}
func (o *HSEM_Type) SetC1ISR_ISEM29(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSEM_Type) GetC1ISR_ISEM29() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x20000000) >> 29
}
func (o *HSEM_Type) SetC1ISR_ISEM30(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSEM_Type) GetC1ISR_ISEM30() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x40000000) >> 30
}
func (o *HSEM_Type) SetC1ISR_ISEM31(value uint32) {
	volatile.StoreUint32(&o.C1ISR.Reg, volatile.LoadUint32(&o.C1ISR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetC1ISR_ISEM31() uint32 {
	return (volatile.LoadUint32(&o.C1ISR.Reg) & 0x80000000) >> 31
}

// HSEM.C1MISR: HSEM Masked interrupt status register
func (o *HSEM_Type) SetC1MISR_ISEM0(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x1)|value)
}
func (o *HSEM_Type) GetC1MISR_ISEM0() uint32 {
	return volatile.LoadUint32(&o.C1MISR.Reg) & 0x1
}
func (o *HSEM_Type) SetC1MISR_ISEM1(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x2)|value<<1)
}
func (o *HSEM_Type) GetC1MISR_ISEM1() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x2) >> 1
}
func (o *HSEM_Type) SetC1MISR_ISEM2(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x4)|value<<2)
}
func (o *HSEM_Type) GetC1MISR_ISEM2() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x4) >> 2
}
func (o *HSEM_Type) SetC1MISR_ISEM3(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x8)|value<<3)
}
func (o *HSEM_Type) GetC1MISR_ISEM3() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x8) >> 3
}
func (o *HSEM_Type) SetC1MISR_ISEM4(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x10)|value<<4)
}
func (o *HSEM_Type) GetC1MISR_ISEM4() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x10) >> 4
}
func (o *HSEM_Type) SetC1MISR_ISEM5(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x20)|value<<5)
}
func (o *HSEM_Type) GetC1MISR_ISEM5() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x20) >> 5
}
func (o *HSEM_Type) SetC1MISR_ISEM6(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x40)|value<<6)
}
func (o *HSEM_Type) GetC1MISR_ISEM6() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x40) >> 6
}
func (o *HSEM_Type) SetC1MISR_ISEM7(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x80)|value<<7)
}
func (o *HSEM_Type) GetC1MISR_ISEM7() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x80) >> 7
}
func (o *HSEM_Type) SetC1MISR_ISEM8(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x100)|value<<8)
}
func (o *HSEM_Type) GetC1MISR_ISEM8() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x100) >> 8
}
func (o *HSEM_Type) SetC1MISR_ISEM9(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x200)|value<<9)
}
func (o *HSEM_Type) GetC1MISR_ISEM9() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x200) >> 9
}
func (o *HSEM_Type) SetC1MISR_ISEM10(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x400)|value<<10)
}
func (o *HSEM_Type) GetC1MISR_ISEM10() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x400) >> 10
}
func (o *HSEM_Type) SetC1MISR_ISEM11(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x800)|value<<11)
}
func (o *HSEM_Type) GetC1MISR_ISEM11() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x800) >> 11
}
func (o *HSEM_Type) SetC1MISR_ISEM12(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x1000)|value<<12)
}
func (o *HSEM_Type) GetC1MISR_ISEM12() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x1000) >> 12
}
func (o *HSEM_Type) SetC1MISR_ISEM13(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x2000)|value<<13)
}
func (o *HSEM_Type) GetC1MISR_ISEM13() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x2000) >> 13
}
func (o *HSEM_Type) SetC1MISR_ISEM14(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x4000)|value<<14)
}
func (o *HSEM_Type) GetC1MISR_ISEM14() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x4000) >> 14
}
func (o *HSEM_Type) SetC1MISR_ISEM15(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x8000)|value<<15)
}
func (o *HSEM_Type) GetC1MISR_ISEM15() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x8000) >> 15
}
func (o *HSEM_Type) SetC1MISR_ISEM16(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x10000)|value<<16)
}
func (o *HSEM_Type) GetC1MISR_ISEM16() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x10000) >> 16
}
func (o *HSEM_Type) SetC1MISR_ISEM17(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x20000)|value<<17)
}
func (o *HSEM_Type) GetC1MISR_ISEM17() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x20000) >> 17
}
func (o *HSEM_Type) SetC1MISR_ISEM18(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x40000)|value<<18)
}
func (o *HSEM_Type) GetC1MISR_ISEM18() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x40000) >> 18
}
func (o *HSEM_Type) SetC1MISR_ISEM19(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x80000)|value<<19)
}
func (o *HSEM_Type) GetC1MISR_ISEM19() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x80000) >> 19
}
func (o *HSEM_Type) SetC1MISR_ISEM20(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x100000)|value<<20)
}
func (o *HSEM_Type) GetC1MISR_ISEM20() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x100000) >> 20
}
func (o *HSEM_Type) SetC1MISR_ISEM21(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x200000)|value<<21)
}
func (o *HSEM_Type) GetC1MISR_ISEM21() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x200000) >> 21
}
func (o *HSEM_Type) SetC1MISR_ISEM22(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x400000)|value<<22)
}
func (o *HSEM_Type) GetC1MISR_ISEM22() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x400000) >> 22
}
func (o *HSEM_Type) SetC1MISR_ISEM23(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x800000)|value<<23)
}
func (o *HSEM_Type) GetC1MISR_ISEM23() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x800000) >> 23
}
func (o *HSEM_Type) SetC1MISR_ISEM24(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSEM_Type) GetC1MISR_ISEM24() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x1000000) >> 24
}
func (o *HSEM_Type) SetC1MISR_ISEM25(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSEM_Type) GetC1MISR_ISEM25() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x2000000) >> 25
}
func (o *HSEM_Type) SetC1MISR_ISEM26(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSEM_Type) GetC1MISR_ISEM26() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x4000000) >> 26
}
func (o *HSEM_Type) SetC1MISR_ISEM27(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSEM_Type) GetC1MISR_ISEM27() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x8000000) >> 27
}
func (o *HSEM_Type) SetC1MISR_ISEM28(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSEM_Type) GetC1MISR_ISEM28() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x10000000) >> 28
}
func (o *HSEM_Type) SetC1MISR_ISEM29(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSEM_Type) GetC1MISR_ISEM29() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x20000000) >> 29
}
func (o *HSEM_Type) SetC1MISR_ISEM30(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSEM_Type) GetC1MISR_ISEM30() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x40000000) >> 30
}
func (o *HSEM_Type) SetC1MISR_ISEM31(value uint32) {
	volatile.StoreUint32(&o.C1MISR.Reg, volatile.LoadUint32(&o.C1MISR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSEM_Type) GetC1MISR_ISEM31() uint32 {
	return (volatile.LoadUint32(&o.C1MISR.Reg) & 0x80000000) >> 31
}

// HSEM.CR: HSEM Clear register
func (o *HSEM_Type) SetCR_COREID(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00)|value<<8)
}
func (o *HSEM_Type) GetCR_COREID() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00) >> 8
}
func (o *HSEM_Type) SetCR_KEY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xffff0000)|value<<16)
}
func (o *HSEM_Type) GetCR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xffff0000) >> 16
}

// HSEM.KEYR: HSEM Interrupt clear register
func (o *HSEM_Type) SetKEYR_KEY(value uint32) {
	volatile.StoreUint32(&o.KEYR.Reg, volatile.LoadUint32(&o.KEYR.Reg)&^(0xffff0000)|value<<16)
}
func (o *HSEM_Type) GetKEYR_KEY() uint32 {
	return (volatile.LoadUint32(&o.KEYR.Reg) & 0xffff0000) >> 16
}

// I2C
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// I2C.CR1: Access: No wait states, except if a write access occurs while a write access to this register is ongoing. In this case, wait states are inserted in the second write access until the previous one is completed. The latency of the second write access can be up to 2 x PCLK1 + 6 x I2CCLK.
func (o *I2C_Type) SetCR1_PE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCR1_PE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *I2C_Type) SetCR1_TXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCR1_TXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCR1_RXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCR1_RXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCR1_ADDRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCR1_ADDRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCR1_NACKIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCR1_NACKIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCR1_STOPIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCR1_STOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCR1_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCR1_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCR1_DNF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xf00)|value<<8)
}
func (o *I2C_Type) GetCR1_DNF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xf00) >> 8
}
func (o *I2C_Type) SetCR1_ANFOFF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR1_ANFOFF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR1_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR1_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR1_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR1_RXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR1_SBC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetCR1_SBC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetCR1_NOSTRETCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *I2C_Type) GetCR1_NOSTRETCH() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *I2C_Type) SetCR1_WUPEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000)|value<<18)
}
func (o *I2C_Type) GetCR1_WUPEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000) >> 18
}
func (o *I2C_Type) SetCR1_GCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *I2C_Type) GetCR1_GCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *I2C_Type) SetCR1_SMBHEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100000)|value<<20)
}
func (o *I2C_Type) GetCR1_SMBHEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100000) >> 20
}
func (o *I2C_Type) SetCR1_SMBDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200000)|value<<21)
}
func (o *I2C_Type) GetCR1_SMBDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200000) >> 21
}
func (o *I2C_Type) SetCR1_ALERTEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400000)|value<<22)
}
func (o *I2C_Type) GetCR1_ALERTEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400000) >> 22
}
func (o *I2C_Type) SetCR1_PECEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800000)|value<<23)
}
func (o *I2C_Type) GetCR1_PECEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800000) >> 23
}

// I2C.CR2: Access: No wait states, except if a write access occurs while a write access to this register is ongoing. In this case, wait states are inserted in the second write access until the previous one is completed. The latency of the second write access can be up to 2 x PCLK1 + 6 x I2CCLK.
func (o *I2C_Type) SetCR2_RD_WRN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCR2_RD_WRN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCR2_ADD10(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCR2_ADD10() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetCR2_HEAD10R(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR2_HEAD10R() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR2_START(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetCR2_START() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR2_NACK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR2_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR2_NBYTES(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *I2C_Type) GetCR2_NBYTES() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff0000) >> 16
}
func (o *I2C_Type) SetCR2_RELOAD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C_Type) GetCR2_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000000) >> 24
}
func (o *I2C_Type) SetCR2_AUTOEND(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000000)|value<<25)
}
func (o *I2C_Type) GetCR2_AUTOEND() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000000) >> 25
}
func (o *I2C_Type) SetCR2_PECBYTE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000000)|value<<26)
}
func (o *I2C_Type) GetCR2_PECBYTE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000000) >> 26
}
func (o *I2C_Type) SetCR2_SADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetCR2_SADD() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x3ff
}

// I2C.OAR1: Access: No wait states, except if a write access occurs while a write access to this register is ongoing. In this case, wait states are inserted in the second write access until the previous one is completed. The latency of the second write access can be up to 2 x PCLK1 + 6 x I2CCLK.
func (o *I2C_Type) SetOAR1_OA1(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetOAR1_OA1() uint32 {
	return volatile.LoadUint32(&o.OAR1.Reg) & 0x3ff
}
func (o *I2C_Type) SetOAR1_OA1MODE(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetOAR1_OA1MODE() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetOAR1_OA1EN(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR1_OA1EN() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x8000) >> 15
}

// I2C.OAR2: Access: No wait states, except if a write access occurs while a write access to this register is ongoing. In this case, wait states are inserted in the second write access until the previous one is completed. The latency of the second write access can be up to 2 x PCLK1 + 6 x I2CCLK.
func (o *I2C_Type) SetOAR2_OA2(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetOAR2_OA2() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetOAR2_OA2MSK(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x700)|value<<8)
}
func (o *I2C_Type) GetOAR2_OA2MSK() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x700) >> 8
}
func (o *I2C_Type) SetOAR2_OA2EN(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR2_OA2EN() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x8000) >> 15
}

// I2C.TIMINGR: Access: No wait states
func (o *I2C_Type) SetTIMINGR_SCLL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTIMINGR_SCLL() uint32 {
	return volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff
}
func (o *I2C_Type) SetTIMINGR_SCLH(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff00)|value<<8)
}
func (o *I2C_Type) GetTIMINGR_SCLH() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff00) >> 8
}
func (o *I2C_Type) SetTIMINGR_SDADEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000)|value<<16)
}
func (o *I2C_Type) GetTIMINGR_SDADEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000) >> 16
}
func (o *I2C_Type) SetTIMINGR_SCLDEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf00000)|value<<20)
}
func (o *I2C_Type) GetTIMINGR_SCLDEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf00000) >> 20
}
func (o *I2C_Type) SetTIMINGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000000)|value<<28)
}
func (o *I2C_Type) GetTIMINGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000000) >> 28
}

// I2C.TIMEOUTR: Access: No wait states, except if a write access occurs while a write access to this register is ongoing. In this case, wait states are inserted in the second write access until the previous one is completed. The latency of the second write access can be up to 2 x PCLK1 + 6 x I2CCLK.
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTA(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff)|value)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTA() uint32 {
	return volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff
}
func (o *I2C_Type) SetTIMEOUTR_TIDLE(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetTIMEOUTR_TIDLE() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetTIMEOUTR_TIMOUTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetTIMEOUTR_TIMOUTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTB(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff0000)|value<<16)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTB() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff0000) >> 16
}
func (o *I2C_Type) SetTIMEOUTR_TEXTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetTIMEOUTR_TEXTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x80000000) >> 31
}

// I2C.ISR: Access: No wait states
func (o *I2C_Type) SetISR_TXE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetISR_TXE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *I2C_Type) SetISR_TXIS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetISR_TXIS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetISR_ADDR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetISR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetISR_NACKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetISR_NACKF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetISR_STOPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetISR_STOPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetISR_TC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetISR_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetISR_TCR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetISR_TCR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetISR_BERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetISR_BERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetISR_ARLO(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetISR_ARLO() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetISR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetISR_PECERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetISR_PECERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetISR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetISR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetISR_ALERT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetISR_ALERT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetISR_DIR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetISR_DIR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetISR_ADDCODE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xfe0000)|value<<17)
}
func (o *I2C_Type) GetISR_ADDCODE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xfe0000) >> 17
}

// I2C.ICR: Access: No wait states
func (o *I2C_Type) SetICR_ADDRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetICR_ADDRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetICR_NACKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetICR_NACKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetICR_STOPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetICR_STOPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetICR_BERRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetICR_BERRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetICR_ARLOCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetICR_ARLOCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetICR_OVRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetICR_OVRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetICR_PECCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetICR_PECCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetICR_TIMOUTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetICR_TIMOUTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetICR_ALERTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetICR_ALERTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000) >> 13
}

// I2C.PECR: Access: No wait states
func (o *I2C_Type) SetPECR_PEC(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetPECR_PEC() uint32 {
	return volatile.LoadUint32(&o.PECR.Reg) & 0xff
}

// I2C.RXDR: Access: No wait states
func (o *I2C_Type) SetRXDR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RXDR.Reg, volatile.LoadUint32(&o.RXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetRXDR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RXDR.Reg) & 0xff
}

// I2C.TXDR: Access: No wait states
func (o *I2C_Type) SetTXDR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXDR.Reg, volatile.LoadUint32(&o.TXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTXDR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXDR.Reg) & 0xff
}

// IWDG
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// IWDG.KR: Key register
func (o *IWDG_Type) SetKR_KEY(value uint32) {
	volatile.StoreUint32(&o.KR.Reg, volatile.LoadUint32(&o.KR.Reg)&^(0xffff)|value)
}
func (o *IWDG_Type) GetKR_KEY() uint32 {
	return volatile.LoadUint32(&o.KR.Reg) & 0xffff
}

// IWDG.PR: Prescaler register
func (o *IWDG_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x7)|value)
}
func (o *IWDG_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x7
}

// IWDG.RLR: Reload register
func (o *IWDG_Type) SetRLR_RL(value uint32) {
	volatile.StoreUint32(&o.RLR.Reg, volatile.LoadUint32(&o.RLR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetRLR_RL() uint32 {
	return volatile.LoadUint32(&o.RLR.Reg) & 0xfff
}

// IWDG.SR: Status register
func (o *IWDG_Type) SetSR_PVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *IWDG_Type) GetSR_PVU() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *IWDG_Type) SetSR_RVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *IWDG_Type) GetSR_RVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *IWDG_Type) SetSR_WVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *IWDG_Type) GetSR_WVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}

// IWDG.WINR: Window register
func (o *IWDG_Type) SetWINR_WIN(value uint32) {
	volatile.StoreUint32(&o.WINR.Reg, volatile.LoadUint32(&o.WINR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetWINR_WIN() uint32 {
	return volatile.LoadUint32(&o.WINR.Reg) & 0xfff
}

// Low power timer
type LPTIM_Type struct {
	ISR   volatile.Register32 // 0x0
	ICR   volatile.Register32 // 0x4
	IER   volatile.Register32 // 0x8
	CFGR  volatile.Register32 // 0xC
	CR    volatile.Register32 // 0x10
	CMP   volatile.Register32 // 0x14
	ARR   volatile.Register32 // 0x18
	CNT   volatile.Register32 // 0x1C
	_     [4]byte
	CFGR2 volatile.Register32 // 0x24
}

// LPTIM.ISR: Interrupt and Status Register
func (o *LPTIM_Type) SetISR_DOWN(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetISR_DOWN() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetISR_UP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetISR_UP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetISR_ARROK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetISR_ARROK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetISR_CMPOK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetISR_CMPOK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetISR_EXTTRIG(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetISR_EXTTRIG() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetISR_ARRM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetISR_ARRM() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetISR_CMPM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetISR_CMPM() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// LPTIM.ICR: Interrupt Clear Register
func (o *LPTIM_Type) SetICR_DOWNCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetICR_DOWNCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetICR_UPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetICR_UPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetICR_ARROKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetICR_ARROKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetICR_CMPOKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetICR_CMPOKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetICR_EXTTRIGCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetICR_EXTTRIGCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetICR_ARRMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetICR_ARRMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetICR_CMPMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetICR_CMPMCF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// LPTIM.IER: Interrupt Enable Register
func (o *LPTIM_Type) SetIER_DOWNIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetIER_DOWNIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetIER_UPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetIER_UPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetIER_ARROKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetIER_ARROKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetIER_CMPOKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetIER_CMPOKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetIER_EXTTRIGIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetIER_EXTTRIGIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetIER_ARRMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetIER_ARRMIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetIER_CMPMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetIER_CMPMIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// LPTIM.CFGR: Configuration Register
func (o *LPTIM_Type) SetCFGR_ENC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *LPTIM_Type) GetCFGR_ENC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000000) >> 24
}
func (o *LPTIM_Type) SetCFGR_COUNTMODE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *LPTIM_Type) GetCFGR_COUNTMODE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *LPTIM_Type) SetCFGR_PRELOAD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x400000)|value<<22)
}
func (o *LPTIM_Type) GetCFGR_PRELOAD() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x400000) >> 22
}
func (o *LPTIM_Type) SetCFGR_WAVPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x200000)|value<<21)
}
func (o *LPTIM_Type) GetCFGR_WAVPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x200000) >> 21
}
func (o *LPTIM_Type) SetCFGR_WAVE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x100000)|value<<20)
}
func (o *LPTIM_Type) GetCFGR_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x100000) >> 20
}
func (o *LPTIM_Type) SetCFGR_TIMOUT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000)|value<<19)
}
func (o *LPTIM_Type) GetCFGR_TIMOUT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000) >> 19
}
func (o *LPTIM_Type) SetCFGR_TRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x60000)|value<<17)
}
func (o *LPTIM_Type) GetCFGR_TRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x60000) >> 17
}
func (o *LPTIM_Type) SetCFGR_TRIGSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe000)|value<<13)
}
func (o *LPTIM_Type) GetCFGR_TRIGSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe000) >> 13
}
func (o *LPTIM_Type) SetCFGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe00)|value<<9)
}
func (o *LPTIM_Type) GetCFGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe00) >> 9
}
func (o *LPTIM_Type) SetCFGR_TRGFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc0)|value<<6)
}
func (o *LPTIM_Type) GetCFGR_TRGFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc0) >> 6
}
func (o *LPTIM_Type) SetCFGR_CKFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x18)|value<<3)
}
func (o *LPTIM_Type) GetCFGR_CKFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x18) >> 3
}
func (o *LPTIM_Type) SetCFGR_CKPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x6)|value<<1)
}
func (o *LPTIM_Type) GetCFGR_CKPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x6) >> 1
}
func (o *LPTIM_Type) SetCFGR_CKSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCFGR_CKSEL() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x1
}

// LPTIM.CR: Control Register
func (o *LPTIM_Type) SetCR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *LPTIM_Type) SetCR_SNGSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetCR_SNGSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetCR_CNTSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetCR_CNTSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetCR_COUNTRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetCR_COUNTRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetCR_RSTARE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetCR_RSTARE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}

// LPTIM.CMP: Compare Register
func (o *LPTIM_Type) SetCMP(value uint32) {
	volatile.StoreUint32(&o.CMP.Reg, volatile.LoadUint32(&o.CMP.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCMP() uint32 {
	return volatile.LoadUint32(&o.CMP.Reg) & 0xffff
}

// LPTIM.ARR: Autoreload Register
func (o *LPTIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// LPTIM.CNT: Counter Register
func (o *LPTIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// LPTIM.CFGR2: LPTIM configuration register 2
func (o *LPTIM_Type) SetCFGR2_IN1SEL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x3)|value)
}
func (o *LPTIM_Type) GetCFGR2_IN1SEL() uint32 {
	return volatile.LoadUint32(&o.CFGR2.Reg) & 0x3
}
func (o *LPTIM_Type) SetCFGR2_IN2SEL(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x30)|value<<4)
}
func (o *LPTIM_Type) GetCFGR2_IN2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x30) >> 4
}

// LPUART1
type LPUART_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	CR3   volatile.Register32 // 0x8
	BRR   volatile.Register32 // 0xC
	GTPR  volatile.Register32 // 0x10
	RTOR  volatile.Register32 // 0x14
	RQR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	ICR   volatile.Register32 // 0x20
	RDR   volatile.Register32 // 0x24
	TDR   volatile.Register32 // 0x28
	PRESC volatile.Register32 // 0x2C
}

// LPUART.CR1: Control register 1
func (o *LPUART_Type) SetCR1_RXFFIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000000)|value<<31)
}
func (o *LPUART_Type) GetCR1_RXFFIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000000) >> 31
}
func (o *LPUART_Type) SetCR1_TXFEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000000)|value<<30)
}
func (o *LPUART_Type) GetCR1_TXFEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000000) >> 30
}
func (o *LPUART_Type) SetCR1_FIFOEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000000)|value<<29)
}
func (o *LPUART_Type) GetCR1_FIFOEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000000) >> 29
}
func (o *LPUART_Type) SetCR1_M1(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000000)|value<<28)
}
func (o *LPUART_Type) GetCR1_M1() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000000) >> 28
}
func (o *LPUART_Type) SetCR1_DEAT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x3e00000)|value<<21)
}
func (o *LPUART_Type) GetCR1_DEAT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x3e00000) >> 21
}
func (o *LPUART_Type) SetCR1_DEDT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1f0000)|value<<16)
}
func (o *LPUART_Type) GetCR1_DEDT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1f0000) >> 16
}
func (o *LPUART_Type) SetCR1_CMIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *LPUART_Type) GetCR1_CMIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *LPUART_Type) SetCR1_MME(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *LPUART_Type) GetCR1_MME() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *LPUART_Type) SetCR1_M0(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *LPUART_Type) GetCR1_M0() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *LPUART_Type) SetCR1_WAKE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *LPUART_Type) GetCR1_WAKE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *LPUART_Type) SetCR1_PCE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *LPUART_Type) GetCR1_PCE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *LPUART_Type) SetCR1_PS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *LPUART_Type) GetCR1_PS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *LPUART_Type) SetCR1_PEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *LPUART_Type) GetCR1_PEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *LPUART_Type) SetCR1_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *LPUART_Type) GetCR1_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *LPUART_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *LPUART_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *LPUART_Type) SetCR1_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *LPUART_Type) GetCR1_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *LPUART_Type) SetCR1_IDLEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *LPUART_Type) GetCR1_IDLEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *LPUART_Type) SetCR1_TE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *LPUART_Type) GetCR1_TE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *LPUART_Type) SetCR1_RE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *LPUART_Type) GetCR1_RE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *LPUART_Type) SetCR1_UESM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *LPUART_Type) GetCR1_UESM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *LPUART_Type) SetCR1_UE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *LPUART_Type) GetCR1_UE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// LPUART.CR2: Control register 2
func (o *LPUART_Type) SetCR2_ADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff000000)|value<<24)
}
func (o *LPUART_Type) GetCR2_ADD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff000000) >> 24
}
func (o *LPUART_Type) SetCR2_MSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80000)|value<<19)
}
func (o *LPUART_Type) GetCR2_MSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80000) >> 19
}
func (o *LPUART_Type) SetCR2_DATAINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000)|value<<18)
}
func (o *LPUART_Type) GetCR2_DATAINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000) >> 18
}
func (o *LPUART_Type) SetCR2_TXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20000)|value<<17)
}
func (o *LPUART_Type) GetCR2_TXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20000) >> 17
}
func (o *LPUART_Type) SetCR2_RXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *LPUART_Type) GetCR2_RXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *LPUART_Type) SetCR2_SWAP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *LPUART_Type) GetCR2_SWAP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *LPUART_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3000)|value<<12)
}
func (o *LPUART_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x3000) >> 12
}
func (o *LPUART_Type) SetCR2_ADDM7(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *LPUART_Type) GetCR2_ADDM7() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}

// LPUART.CR3: Control register 3
func (o *LPUART_Type) SetCR3_TXFTCFG(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe0000000)|value<<29)
}
func (o *LPUART_Type) GetCR3_TXFTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe0000000) >> 29
}
func (o *LPUART_Type) SetCR3_RXFTIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10000000)|value<<28)
}
func (o *LPUART_Type) GetCR3_RXFTIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10000000) >> 28
}
func (o *LPUART_Type) SetCR3_RXFTCFG(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe000000)|value<<25)
}
func (o *LPUART_Type) GetCR3_RXFTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe000000) >> 25
}
func (o *LPUART_Type) SetCR3_TXFTIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800000)|value<<23)
}
func (o *LPUART_Type) GetCR3_TXFTIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800000) >> 23
}
func (o *LPUART_Type) SetCR3_WUFIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400000)|value<<22)
}
func (o *LPUART_Type) GetCR3_WUFIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400000) >> 22
}
func (o *LPUART_Type) SetCR3_WUS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x300000)|value<<20)
}
func (o *LPUART_Type) GetCR3_WUS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x300000) >> 20
}
func (o *LPUART_Type) SetCR3_DEP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8000)|value<<15)
}
func (o *LPUART_Type) GetCR3_DEP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8000) >> 15
}
func (o *LPUART_Type) SetCR3_DEM(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4000)|value<<14)
}
func (o *LPUART_Type) GetCR3_DEM() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4000) >> 14
}
func (o *LPUART_Type) SetCR3_DDRE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2000)|value<<13)
}
func (o *LPUART_Type) GetCR3_DDRE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2000) >> 13
}
func (o *LPUART_Type) SetCR3_OVRDIS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1000)|value<<12)
}
func (o *LPUART_Type) GetCR3_OVRDIS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x1000) >> 12
}
func (o *LPUART_Type) SetCR3_CTSIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *LPUART_Type) GetCR3_CTSIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *LPUART_Type) SetCR3_CTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x200)|value<<9)
}
func (o *LPUART_Type) GetCR3_CTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x200) >> 9
}
func (o *LPUART_Type) SetCR3_RTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *LPUART_Type) GetCR3_RTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *LPUART_Type) SetCR3_DMAT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x80)|value<<7)
}
func (o *LPUART_Type) GetCR3_DMAT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x80) >> 7
}
func (o *LPUART_Type) SetCR3_DMAR(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x40)|value<<6)
}
func (o *LPUART_Type) GetCR3_DMAR() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x40) >> 6
}
func (o *LPUART_Type) SetCR3_HDSEL(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8)|value<<3)
}
func (o *LPUART_Type) GetCR3_HDSEL() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8) >> 3
}
func (o *LPUART_Type) SetCR3_EIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *LPUART_Type) GetCR3_EIE() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}

// LPUART.BRR: Baud rate register
func (o *LPUART_Type) SetBRR(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0xfffff)|value)
}
func (o *LPUART_Type) GetBRR() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0xfffff
}

// LPUART.GTPR: Guard time and prescaler register
func (o *LPUART_Type) SetGTPR_GT(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff00)|value<<8)
}
func (o *LPUART_Type) GetGTPR_GT() uint32 {
	return (volatile.LoadUint32(&o.GTPR.Reg) & 0xff00) >> 8
}
func (o *LPUART_Type) SetGTPR_PSC(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff)|value)
}
func (o *LPUART_Type) GetGTPR_PSC() uint32 {
	return volatile.LoadUint32(&o.GTPR.Reg) & 0xff
}

// LPUART.RTOR: Receiver timeout register
func (o *LPUART_Type) SetRTOR_BLEN(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xff000000)|value<<24)
}
func (o *LPUART_Type) GetRTOR_BLEN() uint32 {
	return (volatile.LoadUint32(&o.RTOR.Reg) & 0xff000000) >> 24
}
func (o *LPUART_Type) SetRTOR_RTO(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xffffff)|value)
}
func (o *LPUART_Type) GetRTOR_RTO() uint32 {
	return volatile.LoadUint32(&o.RTOR.Reg) & 0xffffff
}

// LPUART.RQR: Request register
func (o *LPUART_Type) SetRQR_TXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x10)|value<<4)
}
func (o *LPUART_Type) GetRQR_TXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x10) >> 4
}
func (o *LPUART_Type) SetRQR_RXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x8)|value<<3)
}
func (o *LPUART_Type) GetRQR_RXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x8) >> 3
}
func (o *LPUART_Type) SetRQR_MMRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x4)|value<<2)
}
func (o *LPUART_Type) GetRQR_MMRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x4) >> 2
}
func (o *LPUART_Type) SetRQR_SBKRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x2)|value<<1)
}
func (o *LPUART_Type) GetRQR_SBKRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x2) >> 1
}
func (o *LPUART_Type) SetRQR_ABRRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x1)|value)
}
func (o *LPUART_Type) GetRQR_ABRRQ() uint32 {
	return volatile.LoadUint32(&o.RQR.Reg) & 0x1
}

// LPUART.ISR: Interrupt & status register
func (o *LPUART_Type) SetISR_TXFT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *LPUART_Type) GetISR_TXFT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *LPUART_Type) SetISR_RXFT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *LPUART_Type) GetISR_RXFT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *LPUART_Type) SetISR_RXFF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *LPUART_Type) GetISR_RXFF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *LPUART_Type) SetISR_TXFE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *LPUART_Type) GetISR_TXFE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *LPUART_Type) SetISR_REACK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *LPUART_Type) GetISR_REACK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *LPUART_Type) SetISR_TEACK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *LPUART_Type) GetISR_TEACK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *LPUART_Type) SetISR_WUF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *LPUART_Type) GetISR_WUF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *LPUART_Type) SetISR_RWU(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *LPUART_Type) GetISR_RWU() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *LPUART_Type) SetISR_SBKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *LPUART_Type) GetISR_SBKF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *LPUART_Type) SetISR_CMF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *LPUART_Type) GetISR_CMF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *LPUART_Type) SetISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *LPUART_Type) GetISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *LPUART_Type) SetISR_CTS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *LPUART_Type) GetISR_CTS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *LPUART_Type) SetISR_CTSIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *LPUART_Type) GetISR_CTSIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *LPUART_Type) SetISR_TXE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *LPUART_Type) GetISR_TXE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *LPUART_Type) SetISR_TC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *LPUART_Type) GetISR_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *LPUART_Type) SetISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *LPUART_Type) GetISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *LPUART_Type) SetISR_IDLE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *LPUART_Type) GetISR_IDLE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *LPUART_Type) SetISR_ORE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *LPUART_Type) GetISR_ORE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *LPUART_Type) SetISR_NE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *LPUART_Type) GetISR_NE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *LPUART_Type) SetISR_FE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *LPUART_Type) GetISR_FE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *LPUART_Type) SetISR_PE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *LPUART_Type) GetISR_PE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// LPUART.ICR: Interrupt flag clear register
func (o *LPUART_Type) SetICR_WUCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100000)|value<<20)
}
func (o *LPUART_Type) GetICR_WUCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100000) >> 20
}
func (o *LPUART_Type) SetICR_CMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20000)|value<<17)
}
func (o *LPUART_Type) GetICR_CMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20000) >> 17
}
func (o *LPUART_Type) SetICR_CTSCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *LPUART_Type) GetICR_CTSCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *LPUART_Type) SetICR_TCCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *LPUART_Type) GetICR_TCCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *LPUART_Type) SetICR_IDLECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *LPUART_Type) GetICR_IDLECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *LPUART_Type) SetICR_ORECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *LPUART_Type) GetICR_ORECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *LPUART_Type) SetICR_NCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *LPUART_Type) GetICR_NCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *LPUART_Type) SetICR_FECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *LPUART_Type) GetICR_FECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *LPUART_Type) SetICR_PECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *LPUART_Type) GetICR_PECF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// LPUART.RDR: Receive data register
func (o *LPUART_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0x1ff)|value)
}
func (o *LPUART_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0x1ff
}

// LPUART.TDR: Transmit data register
func (o *LPUART_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0x1ff)|value)
}
func (o *LPUART_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0x1ff
}

// LPUART.PRESC: Prescaler register
func (o *LPUART_Type) SetPRESC_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.PRESC.Reg, volatile.LoadUint32(&o.PRESC.Reg)&^(0xf)|value)
}
func (o *LPUART_Type) GetPRESC_PRESCALER() uint32 {
	return volatile.LoadUint32(&o.PRESC.Reg) & 0xf
}

// LCD-TFT Controller
type LTDC_Type struct {
	_     [8]byte
	SSCR  volatile.Register32 // 0x8
	BPCR  volatile.Register32 // 0xC
	AWCR  volatile.Register32 // 0x10
	TWCR  volatile.Register32 // 0x14
	GCR   volatile.Register32 // 0x18
	_     [8]byte
	SRCR  volatile.Register32 // 0x24
	_     [4]byte
	BCCR  volatile.Register32 // 0x2C
	_     [4]byte
	IER   volatile.Register32 // 0x34
	ISR   volatile.Register32 // 0x38
	ICR   volatile.Register32 // 0x3C
	LIPCR volatile.Register32 // 0x40
	CPSR  volatile.Register32 // 0x44
	CDSR  volatile.Register32 // 0x48
	_     [56]byte
	LAYER [2]LTDC_LAYER_Type // 0x84
}

// LTDC.SSCR: Synchronization Size Configuration Register
func (o *LTDC_Type) SetSSCR_HSW(value uint32) {
	volatile.StoreUint32(&o.SSCR.Reg, volatile.LoadUint32(&o.SSCR.Reg)&^(0xfff0000)|value<<16)
}
func (o *LTDC_Type) GetSSCR_HSW() uint32 {
	return (volatile.LoadUint32(&o.SSCR.Reg) & 0xfff0000) >> 16
}
func (o *LTDC_Type) SetSSCR_VSH(value uint32) {
	volatile.StoreUint32(&o.SSCR.Reg, volatile.LoadUint32(&o.SSCR.Reg)&^(0x7ff)|value)
}
func (o *LTDC_Type) GetSSCR_VSH() uint32 {
	return volatile.LoadUint32(&o.SSCR.Reg) & 0x7ff
}

// LTDC.BPCR: Back Porch Configuration Register
func (o *LTDC_Type) SetBPCR_AHBP(value uint32) {
	volatile.StoreUint32(&o.BPCR.Reg, volatile.LoadUint32(&o.BPCR.Reg)&^(0xfff0000)|value<<16)
}
func (o *LTDC_Type) GetBPCR_AHBP() uint32 {
	return (volatile.LoadUint32(&o.BPCR.Reg) & 0xfff0000) >> 16
}
func (o *LTDC_Type) SetBPCR_AVBP(value uint32) {
	volatile.StoreUint32(&o.BPCR.Reg, volatile.LoadUint32(&o.BPCR.Reg)&^(0x7ff)|value)
}
func (o *LTDC_Type) GetBPCR_AVBP() uint32 {
	return volatile.LoadUint32(&o.BPCR.Reg) & 0x7ff
}

// LTDC.AWCR: Active Width Configuration Register
func (o *LTDC_Type) SetAWCR_AAW(value uint32) {
	volatile.StoreUint32(&o.AWCR.Reg, volatile.LoadUint32(&o.AWCR.Reg)&^(0xfff0000)|value<<16)
}
func (o *LTDC_Type) GetAWCR_AAW() uint32 {
	return (volatile.LoadUint32(&o.AWCR.Reg) & 0xfff0000) >> 16
}
func (o *LTDC_Type) SetAWCR_AAH(value uint32) {
	volatile.StoreUint32(&o.AWCR.Reg, volatile.LoadUint32(&o.AWCR.Reg)&^(0x7ff)|value)
}
func (o *LTDC_Type) GetAWCR_AAH() uint32 {
	return volatile.LoadUint32(&o.AWCR.Reg) & 0x7ff
}

// LTDC.TWCR: Total Width Configuration Register
func (o *LTDC_Type) SetTWCR_TOTALW(value uint32) {
	volatile.StoreUint32(&o.TWCR.Reg, volatile.LoadUint32(&o.TWCR.Reg)&^(0xfff0000)|value<<16)
}
func (o *LTDC_Type) GetTWCR_TOTALW() uint32 {
	return (volatile.LoadUint32(&o.TWCR.Reg) & 0xfff0000) >> 16
}
func (o *LTDC_Type) SetTWCR_TOTALH(value uint32) {
	volatile.StoreUint32(&o.TWCR.Reg, volatile.LoadUint32(&o.TWCR.Reg)&^(0x7ff)|value)
}
func (o *LTDC_Type) GetTWCR_TOTALH() uint32 {
	return volatile.LoadUint32(&o.TWCR.Reg) & 0x7ff
}

// LTDC.GCR: Global Control Register
func (o *LTDC_Type) SetGCR_HSPOL(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x80000000)|value<<31)
}
func (o *LTDC_Type) GetGCR_HSPOL() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x80000000) >> 31
}
func (o *LTDC_Type) SetGCR_VSPOL(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x40000000)|value<<30)
}
func (o *LTDC_Type) GetGCR_VSPOL() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x40000000) >> 30
}
func (o *LTDC_Type) SetGCR_DEPOL(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x20000000)|value<<29)
}
func (o *LTDC_Type) GetGCR_DEPOL() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x20000000) >> 29
}
func (o *LTDC_Type) SetGCR_PCPOL(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x10000000)|value<<28)
}
func (o *LTDC_Type) GetGCR_PCPOL() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x10000000) >> 28
}
func (o *LTDC_Type) SetGCR_DEN(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x10000)|value<<16)
}
func (o *LTDC_Type) GetGCR_DEN() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x10000) >> 16
}
func (o *LTDC_Type) SetGCR_DRW(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x7000)|value<<12)
}
func (o *LTDC_Type) GetGCR_DRW() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x7000) >> 12
}
func (o *LTDC_Type) SetGCR_DGW(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x700)|value<<8)
}
func (o *LTDC_Type) GetGCR_DGW() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x700) >> 8
}
func (o *LTDC_Type) SetGCR_DBW(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x70)|value<<4)
}
func (o *LTDC_Type) GetGCR_DBW() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x70) >> 4
}
func (o *LTDC_Type) SetGCR_LTDCEN(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x1)|value)
}
func (o *LTDC_Type) GetGCR_LTDCEN() uint32 {
	return volatile.LoadUint32(&o.GCR.Reg) & 0x1
}

// LTDC.SRCR: Shadow Reload Configuration Register
func (o *LTDC_Type) SetSRCR_VBR(value uint32) {
	volatile.StoreUint32(&o.SRCR.Reg, volatile.LoadUint32(&o.SRCR.Reg)&^(0x2)|value<<1)
}
func (o *LTDC_Type) GetSRCR_VBR() uint32 {
	return (volatile.LoadUint32(&o.SRCR.Reg) & 0x2) >> 1
}
func (o *LTDC_Type) SetSRCR_IMR(value uint32) {
	volatile.StoreUint32(&o.SRCR.Reg, volatile.LoadUint32(&o.SRCR.Reg)&^(0x1)|value)
}
func (o *LTDC_Type) GetSRCR_IMR() uint32 {
	return volatile.LoadUint32(&o.SRCR.Reg) & 0x1
}

// LTDC.BCCR: Background Color Configuration Register
func (o *LTDC_Type) SetBCCR_BCBLUE(value uint32) {
	volatile.StoreUint32(&o.BCCR.Reg, volatile.LoadUint32(&o.BCCR.Reg)&^(0xff)|value)
}
func (o *LTDC_Type) GetBCCR_BCBLUE() uint32 {
	return volatile.LoadUint32(&o.BCCR.Reg) & 0xff
}
func (o *LTDC_Type) SetBCCR_BCGREEN(value uint32) {
	volatile.StoreUint32(&o.BCCR.Reg, volatile.LoadUint32(&o.BCCR.Reg)&^(0xff00)|value<<8)
}
func (o *LTDC_Type) GetBCCR_BCGREEN() uint32 {
	return (volatile.LoadUint32(&o.BCCR.Reg) & 0xff00) >> 8
}
func (o *LTDC_Type) SetBCCR_BCRED(value uint32) {
	volatile.StoreUint32(&o.BCCR.Reg, volatile.LoadUint32(&o.BCCR.Reg)&^(0xff0000)|value<<16)
}
func (o *LTDC_Type) GetBCCR_BCRED() uint32 {
	return (volatile.LoadUint32(&o.BCCR.Reg) & 0xff0000) >> 16
}

// LTDC.IER: Interrupt Enable Register
func (o *LTDC_Type) SetIER_RRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *LTDC_Type) GetIER_RRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *LTDC_Type) SetIER_TERRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *LTDC_Type) GetIER_TERRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *LTDC_Type) SetIER_FUIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *LTDC_Type) GetIER_FUIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *LTDC_Type) SetIER_LIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *LTDC_Type) GetIER_LIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// LTDC.ISR: Interrupt Status Register
func (o *LTDC_Type) SetISR_RRIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *LTDC_Type) GetISR_RRIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *LTDC_Type) SetISR_TERRIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *LTDC_Type) GetISR_TERRIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *LTDC_Type) SetISR_FUIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *LTDC_Type) GetISR_FUIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *LTDC_Type) SetISR_LIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *LTDC_Type) GetISR_LIF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// LTDC.ICR: Interrupt Clear Register
func (o *LTDC_Type) SetICR_CRRIF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *LTDC_Type) GetICR_CRRIF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *LTDC_Type) SetICR_CTERRIF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *LTDC_Type) GetICR_CTERRIF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *LTDC_Type) SetICR_CFUIF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *LTDC_Type) GetICR_CFUIF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *LTDC_Type) SetICR_CLIF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *LTDC_Type) GetICR_CLIF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// LTDC.LIPCR: Line Interrupt Position Configuration Register
func (o *LTDC_Type) SetLIPCR_LIPOS(value uint32) {
	volatile.StoreUint32(&o.LIPCR.Reg, volatile.LoadUint32(&o.LIPCR.Reg)&^(0x7ff)|value)
}
func (o *LTDC_Type) GetLIPCR_LIPOS() uint32 {
	return volatile.LoadUint32(&o.LIPCR.Reg) & 0x7ff
}

// LTDC.CPSR: Current Position Status Register
func (o *LTDC_Type) SetCPSR_CXPOS(value uint32) {
	volatile.StoreUint32(&o.CPSR.Reg, volatile.LoadUint32(&o.CPSR.Reg)&^(0xffff0000)|value<<16)
}
func (o *LTDC_Type) GetCPSR_CXPOS() uint32 {
	return (volatile.LoadUint32(&o.CPSR.Reg) & 0xffff0000) >> 16
}
func (o *LTDC_Type) SetCPSR_CYPOS(value uint32) {
	volatile.StoreUint32(&o.CPSR.Reg, volatile.LoadUint32(&o.CPSR.Reg)&^(0xffff)|value)
}
func (o *LTDC_Type) GetCPSR_CYPOS() uint32 {
	return volatile.LoadUint32(&o.CPSR.Reg) & 0xffff
}

// LTDC.CDSR: Current Display Status Register
func (o *LTDC_Type) SetCDSR_HSYNCS(value uint32) {
	volatile.StoreUint32(&o.CDSR.Reg, volatile.LoadUint32(&o.CDSR.Reg)&^(0x8)|value<<3)
}
func (o *LTDC_Type) GetCDSR_HSYNCS() uint32 {
	return (volatile.LoadUint32(&o.CDSR.Reg) & 0x8) >> 3
}
func (o *LTDC_Type) SetCDSR_VSYNCS(value uint32) {
	volatile.StoreUint32(&o.CDSR.Reg, volatile.LoadUint32(&o.CDSR.Reg)&^(0x4)|value<<2)
}
func (o *LTDC_Type) GetCDSR_VSYNCS() uint32 {
	return (volatile.LoadUint32(&o.CDSR.Reg) & 0x4) >> 2
}
func (o *LTDC_Type) SetCDSR_HDES(value uint32) {
	volatile.StoreUint32(&o.CDSR.Reg, volatile.LoadUint32(&o.CDSR.Reg)&^(0x2)|value<<1)
}
func (o *LTDC_Type) GetCDSR_HDES() uint32 {
	return (volatile.LoadUint32(&o.CDSR.Reg) & 0x2) >> 1
}
func (o *LTDC_Type) SetCDSR_VDES(value uint32) {
	volatile.StoreUint32(&o.CDSR.Reg, volatile.LoadUint32(&o.CDSR.Reg)&^(0x1)|value)
}
func (o *LTDC_Type) GetCDSR_VDES() uint32 {
	return volatile.LoadUint32(&o.CDSR.Reg) & 0x1
}

// Cluster LAYER%s, containing L?CR, L?WHPCR, L?WVPCR, L?CKCR, L?PFCR, L?CACR, L?DCCR, L?BFCR, L?CFBAR, L?CFBLR, L?CFBLNR, L?CLUTWR
type LTDC_LAYER_Type struct {
	CR     volatile.Register32 // 0x84
	WHPCR  volatile.Register32 // 0x88
	WVPCR  volatile.Register32 // 0x8C
	CKCR   volatile.Register32 // 0x90
	PFCR   volatile.Register32 // 0x94
	CACR   volatile.Register32 // 0x98
	DCCR   volatile.Register32 // 0x9C
	BFCR   volatile.Register32 // 0xA0
	_      [8]byte
	CFBAR  volatile.Register32 // 0xAC
	CFBLR  volatile.Register32 // 0xB0
	CFBLNR volatile.Register32 // 0xB4
	_      [12]byte
	CLUTWR volatile.Register32 // 0xC4
	_      [60]byte
}

// LTDC_LAYER.CR: Layerx Control Register
func (o *LTDC_LAYER_Type) SetCR_CLUTEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *LTDC_LAYER_Type) GetCR_CLUTEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *LTDC_LAYER_Type) SetCR_COLKEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *LTDC_LAYER_Type) GetCR_COLKEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *LTDC_LAYER_Type) SetCR_LEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *LTDC_LAYER_Type) GetCR_LEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// LTDC_LAYER.WHPCR: Layerx Window Horizontal Position Configuration Register
func (o *LTDC_LAYER_Type) SetWHPCR_WHSPPOS(value uint32) {
	volatile.StoreUint32(&o.WHPCR.Reg, volatile.LoadUint32(&o.WHPCR.Reg)&^(0xfff0000)|value<<16)
}
func (o *LTDC_LAYER_Type) GetWHPCR_WHSPPOS() uint32 {
	return (volatile.LoadUint32(&o.WHPCR.Reg) & 0xfff0000) >> 16
}
func (o *LTDC_LAYER_Type) SetWHPCR_WHSTPOS(value uint32) {
	volatile.StoreUint32(&o.WHPCR.Reg, volatile.LoadUint32(&o.WHPCR.Reg)&^(0xfff)|value)
}
func (o *LTDC_LAYER_Type) GetWHPCR_WHSTPOS() uint32 {
	return volatile.LoadUint32(&o.WHPCR.Reg) & 0xfff
}

// LTDC_LAYER.WVPCR: Layerx Window Vertical Position Configuration Register
func (o *LTDC_LAYER_Type) SetWVPCR_WVSPPOS(value uint32) {
	volatile.StoreUint32(&o.WVPCR.Reg, volatile.LoadUint32(&o.WVPCR.Reg)&^(0x7ff0000)|value<<16)
}
func (o *LTDC_LAYER_Type) GetWVPCR_WVSPPOS() uint32 {
	return (volatile.LoadUint32(&o.WVPCR.Reg) & 0x7ff0000) >> 16
}
func (o *LTDC_LAYER_Type) SetWVPCR_WVSTPOS(value uint32) {
	volatile.StoreUint32(&o.WVPCR.Reg, volatile.LoadUint32(&o.WVPCR.Reg)&^(0x7ff)|value)
}
func (o *LTDC_LAYER_Type) GetWVPCR_WVSTPOS() uint32 {
	return volatile.LoadUint32(&o.WVPCR.Reg) & 0x7ff
}

// LTDC_LAYER.CKCR: Layerx Color Keying Configuration Register
func (o *LTDC_LAYER_Type) SetCKCR_CKRED(value uint32) {
	volatile.StoreUint32(&o.CKCR.Reg, volatile.LoadUint32(&o.CKCR.Reg)&^(0xff0000)|value<<16)
}
func (o *LTDC_LAYER_Type) GetCKCR_CKRED() uint32 {
	return (volatile.LoadUint32(&o.CKCR.Reg) & 0xff0000) >> 16
}
func (o *LTDC_LAYER_Type) SetCKCR_CKGREEN(value uint32) {
	volatile.StoreUint32(&o.CKCR.Reg, volatile.LoadUint32(&o.CKCR.Reg)&^(0xff00)|value<<8)
}
func (o *LTDC_LAYER_Type) GetCKCR_CKGREEN() uint32 {
	return (volatile.LoadUint32(&o.CKCR.Reg) & 0xff00) >> 8
}
func (o *LTDC_LAYER_Type) SetCKCR_CKBLUE(value uint32) {
	volatile.StoreUint32(&o.CKCR.Reg, volatile.LoadUint32(&o.CKCR.Reg)&^(0xff)|value)
}
func (o *LTDC_LAYER_Type) GetCKCR_CKBLUE() uint32 {
	return volatile.LoadUint32(&o.CKCR.Reg) & 0xff
}

// LTDC_LAYER.PFCR: Layerx Pixel Format Configuration Register
func (o *LTDC_LAYER_Type) SetPFCR_PF(value uint32) {
	volatile.StoreUint32(&o.PFCR.Reg, volatile.LoadUint32(&o.PFCR.Reg)&^(0x7)|value)
}
func (o *LTDC_LAYER_Type) GetPFCR_PF() uint32 {
	return volatile.LoadUint32(&o.PFCR.Reg) & 0x7
}

// LTDC_LAYER.CACR: Layerx Constant Alpha Configuration Register
func (o *LTDC_LAYER_Type) SetCACR_CONSTA(value uint32) {
	volatile.StoreUint32(&o.CACR.Reg, volatile.LoadUint32(&o.CACR.Reg)&^(0xff)|value)
}
func (o *LTDC_LAYER_Type) GetCACR_CONSTA() uint32 {
	return volatile.LoadUint32(&o.CACR.Reg) & 0xff
}

// LTDC_LAYER.DCCR: Layerx Default Color Configuration Register
func (o *LTDC_LAYER_Type) SetDCCR_DCALPHA(value uint32) {
	volatile.StoreUint32(&o.DCCR.Reg, volatile.LoadUint32(&o.DCCR.Reg)&^(0xff000000)|value<<24)
}
func (o *LTDC_LAYER_Type) GetDCCR_DCALPHA() uint32 {
	return (volatile.LoadUint32(&o.DCCR.Reg) & 0xff000000) >> 24
}
func (o *LTDC_LAYER_Type) SetDCCR_DCRED(value uint32) {
	volatile.StoreUint32(&o.DCCR.Reg, volatile.LoadUint32(&o.DCCR.Reg)&^(0xff0000)|value<<16)
}
func (o *LTDC_LAYER_Type) GetDCCR_DCRED() uint32 {
	return (volatile.LoadUint32(&o.DCCR.Reg) & 0xff0000) >> 16
}
func (o *LTDC_LAYER_Type) SetDCCR_DCGREEN(value uint32) {
	volatile.StoreUint32(&o.DCCR.Reg, volatile.LoadUint32(&o.DCCR.Reg)&^(0xff00)|value<<8)
}
func (o *LTDC_LAYER_Type) GetDCCR_DCGREEN() uint32 {
	return (volatile.LoadUint32(&o.DCCR.Reg) & 0xff00) >> 8
}
func (o *LTDC_LAYER_Type) SetDCCR_DCBLUE(value uint32) {
	volatile.StoreUint32(&o.DCCR.Reg, volatile.LoadUint32(&o.DCCR.Reg)&^(0xff)|value)
}
func (o *LTDC_LAYER_Type) GetDCCR_DCBLUE() uint32 {
	return volatile.LoadUint32(&o.DCCR.Reg) & 0xff
}

// LTDC_LAYER.BFCR: Layerx Blending Factors Configuration Register
func (o *LTDC_LAYER_Type) SetBFCR_BF1(value uint32) {
	volatile.StoreUint32(&o.BFCR.Reg, volatile.LoadUint32(&o.BFCR.Reg)&^(0x700)|value<<8)
}
func (o *LTDC_LAYER_Type) GetBFCR_BF1() uint32 {
	return (volatile.LoadUint32(&o.BFCR.Reg) & 0x700) >> 8
}
func (o *LTDC_LAYER_Type) SetBFCR_BF2(value uint32) {
	volatile.StoreUint32(&o.BFCR.Reg, volatile.LoadUint32(&o.BFCR.Reg)&^(0x7)|value)
}
func (o *LTDC_LAYER_Type) GetBFCR_BF2() uint32 {
	return volatile.LoadUint32(&o.BFCR.Reg) & 0x7
}

// LTDC_LAYER.CFBAR: Layerx Color Frame Buffer Address Register
func (o *LTDC_LAYER_Type) SetCFBAR(value uint32) {
	volatile.StoreUint32(&o.CFBAR.Reg, value)
}
func (o *LTDC_LAYER_Type) GetCFBAR() uint32 {
	return volatile.LoadUint32(&o.CFBAR.Reg)
}

// LTDC_LAYER.CFBLR: Layerx Color Frame Buffer Length Register
func (o *LTDC_LAYER_Type) SetCFBLR_CFBP(value uint32) {
	volatile.StoreUint32(&o.CFBLR.Reg, volatile.LoadUint32(&o.CFBLR.Reg)&^(0x1fff0000)|value<<16)
}
func (o *LTDC_LAYER_Type) GetCFBLR_CFBP() uint32 {
	return (volatile.LoadUint32(&o.CFBLR.Reg) & 0x1fff0000) >> 16
}
func (o *LTDC_LAYER_Type) SetCFBLR_CFBLL(value uint32) {
	volatile.StoreUint32(&o.CFBLR.Reg, volatile.LoadUint32(&o.CFBLR.Reg)&^(0x1fff)|value)
}
func (o *LTDC_LAYER_Type) GetCFBLR_CFBLL() uint32 {
	return volatile.LoadUint32(&o.CFBLR.Reg) & 0x1fff
}

// LTDC_LAYER.CFBLNR: Layerx ColorFrame Buffer Line Number Register
func (o *LTDC_LAYER_Type) SetCFBLNR_CFBLNBR(value uint32) {
	volatile.StoreUint32(&o.CFBLNR.Reg, volatile.LoadUint32(&o.CFBLNR.Reg)&^(0x7ff)|value)
}
func (o *LTDC_LAYER_Type) GetCFBLNR_CFBLNBR() uint32 {
	return volatile.LoadUint32(&o.CFBLNR.Reg) & 0x7ff
}

// LTDC_LAYER.CLUTWR: Layerx CLUT Write Register
func (o *LTDC_LAYER_Type) SetCLUTWR_CLUTADD(value uint32) {
	volatile.StoreUint32(&o.CLUTWR.Reg, volatile.LoadUint32(&o.CLUTWR.Reg)&^(0xff000000)|value<<24)
}
func (o *LTDC_LAYER_Type) GetCLUTWR_CLUTADD() uint32 {
	return (volatile.LoadUint32(&o.CLUTWR.Reg) & 0xff000000) >> 24
}
func (o *LTDC_LAYER_Type) SetCLUTWR_RED(value uint32) {
	volatile.StoreUint32(&o.CLUTWR.Reg, volatile.LoadUint32(&o.CLUTWR.Reg)&^(0xff0000)|value<<16)
}
func (o *LTDC_LAYER_Type) GetCLUTWR_RED() uint32 {
	return (volatile.LoadUint32(&o.CLUTWR.Reg) & 0xff0000) >> 16
}
func (o *LTDC_LAYER_Type) SetCLUTWR_GREEN(value uint32) {
	volatile.StoreUint32(&o.CLUTWR.Reg, volatile.LoadUint32(&o.CLUTWR.Reg)&^(0xff00)|value<<8)
}
func (o *LTDC_LAYER_Type) GetCLUTWR_GREEN() uint32 {
	return (volatile.LoadUint32(&o.CLUTWR.Reg) & 0xff00) >> 8
}
func (o *LTDC_LAYER_Type) SetCLUTWR_BLUE(value uint32) {
	volatile.StoreUint32(&o.CLUTWR.Reg, volatile.LoadUint32(&o.CLUTWR.Reg)&^(0xff)|value)
}
func (o *LTDC_LAYER_Type) GetCLUTWR_BLUE() uint32 {
	return volatile.LoadUint32(&o.CLUTWR.Reg) & 0xff
}

// Management data input/output slave
type MDIOS_Type struct {
	CR      volatile.Register32 // 0x0
	WRFR    volatile.Register32 // 0x4
	CWRFR   volatile.Register32 // 0x8
	RDFR    volatile.Register32 // 0xC
	CRDFR   volatile.Register32 // 0x10
	SR      volatile.Register32 // 0x14
	CLRFR   volatile.Register32 // 0x18
	DINR0   volatile.Register32 // 0x1C
	DINR1   volatile.Register32 // 0x20
	DINR2   volatile.Register32 // 0x24
	DINR3   volatile.Register32 // 0x28
	DINR4   volatile.Register32 // 0x2C
	DINR5   volatile.Register32 // 0x30
	DINR6   volatile.Register32 // 0x34
	DINR7   volatile.Register32 // 0x38
	DINR8   volatile.Register32 // 0x3C
	DINR9   volatile.Register32 // 0x40
	DINR10  volatile.Register32 // 0x44
	DINR11  volatile.Register32 // 0x48
	DINR12  volatile.Register32 // 0x4C
	DINR13  volatile.Register32 // 0x50
	DINR14  volatile.Register32 // 0x54
	DINR15  volatile.Register32 // 0x58
	DINR16  volatile.Register32 // 0x5C
	DINR17  volatile.Register32 // 0x60
	DINR18  volatile.Register32 // 0x64
	DINR19  volatile.Register32 // 0x68
	DINR20  volatile.Register32 // 0x6C
	DINR21  volatile.Register32 // 0x70
	DINR22  volatile.Register32 // 0x74
	DINR23  volatile.Register32 // 0x78
	DINR24  volatile.Register32 // 0x7C
	DINR25  volatile.Register32 // 0x80
	DINR26  volatile.Register32 // 0x84
	DINR27  volatile.Register32 // 0x88
	DINR28  volatile.Register32 // 0x8C
	DINR29  volatile.Register32 // 0x90
	DINR30  volatile.Register32 // 0x94
	DINR31  volatile.Register32 // 0x98
	DOUTR0  volatile.Register32 // 0x9C
	DOUTR1  volatile.Register32 // 0xA0
	DOUTR2  volatile.Register32 // 0xA4
	DOUTR3  volatile.Register32 // 0xA8
	DOUTR4  volatile.Register32 // 0xAC
	DOUTR5  volatile.Register32 // 0xB0
	DOUTR6  volatile.Register32 // 0xB4
	DOUTR7  volatile.Register32 // 0xB8
	DOUTR8  volatile.Register32 // 0xBC
	DOUTR9  volatile.Register32 // 0xC0
	DOUTR10 volatile.Register32 // 0xC4
	DOUTR11 volatile.Register32 // 0xC8
	DOUTR12 volatile.Register32 // 0xCC
	DOUTR13 volatile.Register32 // 0xD0
	DOUTR14 volatile.Register32 // 0xD4
	DOUTR15 volatile.Register32 // 0xD8
	DOUTR16 volatile.Register32 // 0xDC
	DOUTR17 volatile.Register32 // 0xE0
	DOUTR18 volatile.Register32 // 0xE4
	DOUTR19 volatile.Register32 // 0xE8
	DOUTR20 volatile.Register32 // 0xEC
	DOUTR21 volatile.Register32 // 0xF0
	DOUTR22 volatile.Register32 // 0xF4
	DOUTR23 volatile.Register32 // 0xF8
	DOUTR24 volatile.Register32 // 0xFC
	DOUTR25 volatile.Register32 // 0x100
	DOUTR26 volatile.Register32 // 0x104
	DOUTR27 volatile.Register32 // 0x108
	DOUTR28 volatile.Register32 // 0x10C
	DOUTR29 volatile.Register32 // 0x110
	DOUTR30 volatile.Register32 // 0x114
	DOUTR31 volatile.Register32 // 0x118
}

// MDIOS.CR: MDIOS configuration register
func (o *MDIOS_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *MDIOS_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *MDIOS_Type) SetCR_WRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *MDIOS_Type) GetCR_WRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *MDIOS_Type) SetCR_RDIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *MDIOS_Type) GetCR_RDIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *MDIOS_Type) SetCR_EIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *MDIOS_Type) GetCR_EIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *MDIOS_Type) SetCR_DPC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *MDIOS_Type) GetCR_DPC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *MDIOS_Type) SetCR_PORT_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1f00)|value<<8)
}
func (o *MDIOS_Type) GetCR_PORT_ADDRESS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1f00) >> 8
}

// MDIOS.WRFR: MDIOS write flag register
func (o *MDIOS_Type) SetWRFR(value uint32) {
	volatile.StoreUint32(&o.WRFR.Reg, value)
}
func (o *MDIOS_Type) GetWRFR() uint32 {
	return volatile.LoadUint32(&o.WRFR.Reg)
}

// MDIOS.CWRFR: MDIOS clear write flag register
func (o *MDIOS_Type) SetCWRFR(value uint32) {
	volatile.StoreUint32(&o.CWRFR.Reg, value)
}
func (o *MDIOS_Type) GetCWRFR() uint32 {
	return volatile.LoadUint32(&o.CWRFR.Reg)
}

// MDIOS.RDFR: MDIOS read flag register
func (o *MDIOS_Type) SetRDFR(value uint32) {
	volatile.StoreUint32(&o.RDFR.Reg, value)
}
func (o *MDIOS_Type) GetRDFR() uint32 {
	return volatile.LoadUint32(&o.RDFR.Reg)
}

// MDIOS.CRDFR: MDIOS clear read flag register
func (o *MDIOS_Type) SetCRDFR(value uint32) {
	volatile.StoreUint32(&o.CRDFR.Reg, value)
}
func (o *MDIOS_Type) GetCRDFR() uint32 {
	return volatile.LoadUint32(&o.CRDFR.Reg)
}

// MDIOS.SR: MDIOS status register
func (o *MDIOS_Type) SetSR_PERF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *MDIOS_Type) GetSR_PERF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *MDIOS_Type) SetSR_SERF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *MDIOS_Type) GetSR_SERF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *MDIOS_Type) SetSR_TERF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *MDIOS_Type) GetSR_TERF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}

// MDIOS.CLRFR: MDIOS clear flag register
func (o *MDIOS_Type) SetCLRFR_CPERF(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x1)|value)
}
func (o *MDIOS_Type) GetCLRFR_CPERF() uint32 {
	return volatile.LoadUint32(&o.CLRFR.Reg) & 0x1
}
func (o *MDIOS_Type) SetCLRFR_CSERF(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x2)|value<<1)
}
func (o *MDIOS_Type) GetCLRFR_CSERF() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x2) >> 1
}
func (o *MDIOS_Type) SetCLRFR_CTERF(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x4)|value<<2)
}
func (o *MDIOS_Type) GetCLRFR_CTERF() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x4) >> 2
}

// MDIOS.DINR0: MDIOS input data register 0
func (o *MDIOS_Type) SetDINR0_DIN0(value uint32) {
	volatile.StoreUint32(&o.DINR0.Reg, volatile.LoadUint32(&o.DINR0.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR0_DIN0() uint32 {
	return volatile.LoadUint32(&o.DINR0.Reg) & 0xffff
}

// MDIOS.DINR1: MDIOS input data register 1
func (o *MDIOS_Type) SetDINR1_DIN1(value uint32) {
	volatile.StoreUint32(&o.DINR1.Reg, volatile.LoadUint32(&o.DINR1.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR1_DIN1() uint32 {
	return volatile.LoadUint32(&o.DINR1.Reg) & 0xffff
}

// MDIOS.DINR2: MDIOS input data register 2
func (o *MDIOS_Type) SetDINR2_DIN2(value uint32) {
	volatile.StoreUint32(&o.DINR2.Reg, volatile.LoadUint32(&o.DINR2.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR2_DIN2() uint32 {
	return volatile.LoadUint32(&o.DINR2.Reg) & 0xffff
}

// MDIOS.DINR3: MDIOS input data register 3
func (o *MDIOS_Type) SetDINR3_DIN3(value uint32) {
	volatile.StoreUint32(&o.DINR3.Reg, volatile.LoadUint32(&o.DINR3.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR3_DIN3() uint32 {
	return volatile.LoadUint32(&o.DINR3.Reg) & 0xffff
}

// MDIOS.DINR4: MDIOS input data register 4
func (o *MDIOS_Type) SetDINR4_DIN4(value uint32) {
	volatile.StoreUint32(&o.DINR4.Reg, volatile.LoadUint32(&o.DINR4.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR4_DIN4() uint32 {
	return volatile.LoadUint32(&o.DINR4.Reg) & 0xffff
}

// MDIOS.DINR5: MDIOS input data register 5
func (o *MDIOS_Type) SetDINR5_DIN5(value uint32) {
	volatile.StoreUint32(&o.DINR5.Reg, volatile.LoadUint32(&o.DINR5.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR5_DIN5() uint32 {
	return volatile.LoadUint32(&o.DINR5.Reg) & 0xffff
}

// MDIOS.DINR6: MDIOS input data register 6
func (o *MDIOS_Type) SetDINR6_DIN6(value uint32) {
	volatile.StoreUint32(&o.DINR6.Reg, volatile.LoadUint32(&o.DINR6.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR6_DIN6() uint32 {
	return volatile.LoadUint32(&o.DINR6.Reg) & 0xffff
}

// MDIOS.DINR7: MDIOS input data register 7
func (o *MDIOS_Type) SetDINR7_DIN7(value uint32) {
	volatile.StoreUint32(&o.DINR7.Reg, volatile.LoadUint32(&o.DINR7.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR7_DIN7() uint32 {
	return volatile.LoadUint32(&o.DINR7.Reg) & 0xffff
}

// MDIOS.DINR8: MDIOS input data register 8
func (o *MDIOS_Type) SetDINR8_DIN8(value uint32) {
	volatile.StoreUint32(&o.DINR8.Reg, volatile.LoadUint32(&o.DINR8.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR8_DIN8() uint32 {
	return volatile.LoadUint32(&o.DINR8.Reg) & 0xffff
}

// MDIOS.DINR9: MDIOS input data register 9
func (o *MDIOS_Type) SetDINR9_DIN9(value uint32) {
	volatile.StoreUint32(&o.DINR9.Reg, volatile.LoadUint32(&o.DINR9.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR9_DIN9() uint32 {
	return volatile.LoadUint32(&o.DINR9.Reg) & 0xffff
}

// MDIOS.DINR10: MDIOS input data register 10
func (o *MDIOS_Type) SetDINR10_DIN10(value uint32) {
	volatile.StoreUint32(&o.DINR10.Reg, volatile.LoadUint32(&o.DINR10.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR10_DIN10() uint32 {
	return volatile.LoadUint32(&o.DINR10.Reg) & 0xffff
}

// MDIOS.DINR11: MDIOS input data register 11
func (o *MDIOS_Type) SetDINR11_DIN11(value uint32) {
	volatile.StoreUint32(&o.DINR11.Reg, volatile.LoadUint32(&o.DINR11.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR11_DIN11() uint32 {
	return volatile.LoadUint32(&o.DINR11.Reg) & 0xffff
}

// MDIOS.DINR12: MDIOS input data register 12
func (o *MDIOS_Type) SetDINR12_DIN12(value uint32) {
	volatile.StoreUint32(&o.DINR12.Reg, volatile.LoadUint32(&o.DINR12.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR12_DIN12() uint32 {
	return volatile.LoadUint32(&o.DINR12.Reg) & 0xffff
}

// MDIOS.DINR13: MDIOS input data register 13
func (o *MDIOS_Type) SetDINR13_DIN13(value uint32) {
	volatile.StoreUint32(&o.DINR13.Reg, volatile.LoadUint32(&o.DINR13.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR13_DIN13() uint32 {
	return volatile.LoadUint32(&o.DINR13.Reg) & 0xffff
}

// MDIOS.DINR14: MDIOS input data register 14
func (o *MDIOS_Type) SetDINR14_DIN14(value uint32) {
	volatile.StoreUint32(&o.DINR14.Reg, volatile.LoadUint32(&o.DINR14.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR14_DIN14() uint32 {
	return volatile.LoadUint32(&o.DINR14.Reg) & 0xffff
}

// MDIOS.DINR15: MDIOS input data register 15
func (o *MDIOS_Type) SetDINR15_DIN15(value uint32) {
	volatile.StoreUint32(&o.DINR15.Reg, volatile.LoadUint32(&o.DINR15.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR15_DIN15() uint32 {
	return volatile.LoadUint32(&o.DINR15.Reg) & 0xffff
}

// MDIOS.DINR16: MDIOS input data register 16
func (o *MDIOS_Type) SetDINR16_DIN16(value uint32) {
	volatile.StoreUint32(&o.DINR16.Reg, volatile.LoadUint32(&o.DINR16.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR16_DIN16() uint32 {
	return volatile.LoadUint32(&o.DINR16.Reg) & 0xffff
}

// MDIOS.DINR17: MDIOS input data register 17
func (o *MDIOS_Type) SetDINR17_DIN17(value uint32) {
	volatile.StoreUint32(&o.DINR17.Reg, volatile.LoadUint32(&o.DINR17.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR17_DIN17() uint32 {
	return volatile.LoadUint32(&o.DINR17.Reg) & 0xffff
}

// MDIOS.DINR18: MDIOS input data register 18
func (o *MDIOS_Type) SetDINR18_DIN18(value uint32) {
	volatile.StoreUint32(&o.DINR18.Reg, volatile.LoadUint32(&o.DINR18.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR18_DIN18() uint32 {
	return volatile.LoadUint32(&o.DINR18.Reg) & 0xffff
}

// MDIOS.DINR19: MDIOS input data register 19
func (o *MDIOS_Type) SetDINR19_DIN19(value uint32) {
	volatile.StoreUint32(&o.DINR19.Reg, volatile.LoadUint32(&o.DINR19.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR19_DIN19() uint32 {
	return volatile.LoadUint32(&o.DINR19.Reg) & 0xffff
}

// MDIOS.DINR20: MDIOS input data register 20
func (o *MDIOS_Type) SetDINR20_DIN20(value uint32) {
	volatile.StoreUint32(&o.DINR20.Reg, volatile.LoadUint32(&o.DINR20.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR20_DIN20() uint32 {
	return volatile.LoadUint32(&o.DINR20.Reg) & 0xffff
}

// MDIOS.DINR21: MDIOS input data register 21
func (o *MDIOS_Type) SetDINR21_DIN21(value uint32) {
	volatile.StoreUint32(&o.DINR21.Reg, volatile.LoadUint32(&o.DINR21.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR21_DIN21() uint32 {
	return volatile.LoadUint32(&o.DINR21.Reg) & 0xffff
}

// MDIOS.DINR22: MDIOS input data register 22
func (o *MDIOS_Type) SetDINR22_DIN22(value uint32) {
	volatile.StoreUint32(&o.DINR22.Reg, volatile.LoadUint32(&o.DINR22.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR22_DIN22() uint32 {
	return volatile.LoadUint32(&o.DINR22.Reg) & 0xffff
}

// MDIOS.DINR23: MDIOS input data register 23
func (o *MDIOS_Type) SetDINR23_DIN23(value uint32) {
	volatile.StoreUint32(&o.DINR23.Reg, volatile.LoadUint32(&o.DINR23.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR23_DIN23() uint32 {
	return volatile.LoadUint32(&o.DINR23.Reg) & 0xffff
}

// MDIOS.DINR24: MDIOS input data register 24
func (o *MDIOS_Type) SetDINR24_DIN24(value uint32) {
	volatile.StoreUint32(&o.DINR24.Reg, volatile.LoadUint32(&o.DINR24.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR24_DIN24() uint32 {
	return volatile.LoadUint32(&o.DINR24.Reg) & 0xffff
}

// MDIOS.DINR25: MDIOS input data register 25
func (o *MDIOS_Type) SetDINR25_DIN25(value uint32) {
	volatile.StoreUint32(&o.DINR25.Reg, volatile.LoadUint32(&o.DINR25.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR25_DIN25() uint32 {
	return volatile.LoadUint32(&o.DINR25.Reg) & 0xffff
}

// MDIOS.DINR26: MDIOS input data register 26
func (o *MDIOS_Type) SetDINR26_DIN26(value uint32) {
	volatile.StoreUint32(&o.DINR26.Reg, volatile.LoadUint32(&o.DINR26.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR26_DIN26() uint32 {
	return volatile.LoadUint32(&o.DINR26.Reg) & 0xffff
}

// MDIOS.DINR27: MDIOS input data register 27
func (o *MDIOS_Type) SetDINR27_DIN27(value uint32) {
	volatile.StoreUint32(&o.DINR27.Reg, volatile.LoadUint32(&o.DINR27.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR27_DIN27() uint32 {
	return volatile.LoadUint32(&o.DINR27.Reg) & 0xffff
}

// MDIOS.DINR28: MDIOS input data register 28
func (o *MDIOS_Type) SetDINR28_DIN28(value uint32) {
	volatile.StoreUint32(&o.DINR28.Reg, volatile.LoadUint32(&o.DINR28.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR28_DIN28() uint32 {
	return volatile.LoadUint32(&o.DINR28.Reg) & 0xffff
}

// MDIOS.DINR29: MDIOS input data register 29
func (o *MDIOS_Type) SetDINR29_DIN29(value uint32) {
	volatile.StoreUint32(&o.DINR29.Reg, volatile.LoadUint32(&o.DINR29.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR29_DIN29() uint32 {
	return volatile.LoadUint32(&o.DINR29.Reg) & 0xffff
}

// MDIOS.DINR30: MDIOS input data register 30
func (o *MDIOS_Type) SetDINR30_DIN30(value uint32) {
	volatile.StoreUint32(&o.DINR30.Reg, volatile.LoadUint32(&o.DINR30.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR30_DIN30() uint32 {
	return volatile.LoadUint32(&o.DINR30.Reg) & 0xffff
}

// MDIOS.DINR31: MDIOS input data register 31
func (o *MDIOS_Type) SetDINR31_DIN31(value uint32) {
	volatile.StoreUint32(&o.DINR31.Reg, volatile.LoadUint32(&o.DINR31.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDINR31_DIN31() uint32 {
	return volatile.LoadUint32(&o.DINR31.Reg) & 0xffff
}

// MDIOS.DOUTR0: MDIOS output data register 0
func (o *MDIOS_Type) SetDOUTR0_DOUT0(value uint32) {
	volatile.StoreUint32(&o.DOUTR0.Reg, volatile.LoadUint32(&o.DOUTR0.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR0_DOUT0() uint32 {
	return volatile.LoadUint32(&o.DOUTR0.Reg) & 0xffff
}

// MDIOS.DOUTR1: MDIOS output data register 1
func (o *MDIOS_Type) SetDOUTR1_DOUT1(value uint32) {
	volatile.StoreUint32(&o.DOUTR1.Reg, volatile.LoadUint32(&o.DOUTR1.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR1_DOUT1() uint32 {
	return volatile.LoadUint32(&o.DOUTR1.Reg) & 0xffff
}

// MDIOS.DOUTR2: MDIOS output data register 2
func (o *MDIOS_Type) SetDOUTR2_DOUT2(value uint32) {
	volatile.StoreUint32(&o.DOUTR2.Reg, volatile.LoadUint32(&o.DOUTR2.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR2_DOUT2() uint32 {
	return volatile.LoadUint32(&o.DOUTR2.Reg) & 0xffff
}

// MDIOS.DOUTR3: MDIOS output data register 3
func (o *MDIOS_Type) SetDOUTR3_DOUT3(value uint32) {
	volatile.StoreUint32(&o.DOUTR3.Reg, volatile.LoadUint32(&o.DOUTR3.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR3_DOUT3() uint32 {
	return volatile.LoadUint32(&o.DOUTR3.Reg) & 0xffff
}

// MDIOS.DOUTR4: MDIOS output data register 4
func (o *MDIOS_Type) SetDOUTR4_DOUT4(value uint32) {
	volatile.StoreUint32(&o.DOUTR4.Reg, volatile.LoadUint32(&o.DOUTR4.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR4_DOUT4() uint32 {
	return volatile.LoadUint32(&o.DOUTR4.Reg) & 0xffff
}

// MDIOS.DOUTR5: MDIOS output data register 5
func (o *MDIOS_Type) SetDOUTR5_DOUT5(value uint32) {
	volatile.StoreUint32(&o.DOUTR5.Reg, volatile.LoadUint32(&o.DOUTR5.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR5_DOUT5() uint32 {
	return volatile.LoadUint32(&o.DOUTR5.Reg) & 0xffff
}

// MDIOS.DOUTR6: MDIOS output data register 6
func (o *MDIOS_Type) SetDOUTR6_DOUT6(value uint32) {
	volatile.StoreUint32(&o.DOUTR6.Reg, volatile.LoadUint32(&o.DOUTR6.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR6_DOUT6() uint32 {
	return volatile.LoadUint32(&o.DOUTR6.Reg) & 0xffff
}

// MDIOS.DOUTR7: MDIOS output data register 7
func (o *MDIOS_Type) SetDOUTR7_DOUT7(value uint32) {
	volatile.StoreUint32(&o.DOUTR7.Reg, volatile.LoadUint32(&o.DOUTR7.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR7_DOUT7() uint32 {
	return volatile.LoadUint32(&o.DOUTR7.Reg) & 0xffff
}

// MDIOS.DOUTR8: MDIOS output data register 8
func (o *MDIOS_Type) SetDOUTR8_DOUT8(value uint32) {
	volatile.StoreUint32(&o.DOUTR8.Reg, volatile.LoadUint32(&o.DOUTR8.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR8_DOUT8() uint32 {
	return volatile.LoadUint32(&o.DOUTR8.Reg) & 0xffff
}

// MDIOS.DOUTR9: MDIOS output data register 9
func (o *MDIOS_Type) SetDOUTR9_DOUT9(value uint32) {
	volatile.StoreUint32(&o.DOUTR9.Reg, volatile.LoadUint32(&o.DOUTR9.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR9_DOUT9() uint32 {
	return volatile.LoadUint32(&o.DOUTR9.Reg) & 0xffff
}

// MDIOS.DOUTR10: MDIOS output data register 10
func (o *MDIOS_Type) SetDOUTR10_DOUT10(value uint32) {
	volatile.StoreUint32(&o.DOUTR10.Reg, volatile.LoadUint32(&o.DOUTR10.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR10_DOUT10() uint32 {
	return volatile.LoadUint32(&o.DOUTR10.Reg) & 0xffff
}

// MDIOS.DOUTR11: MDIOS output data register 11
func (o *MDIOS_Type) SetDOUTR11_DOUT11(value uint32) {
	volatile.StoreUint32(&o.DOUTR11.Reg, volatile.LoadUint32(&o.DOUTR11.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR11_DOUT11() uint32 {
	return volatile.LoadUint32(&o.DOUTR11.Reg) & 0xffff
}

// MDIOS.DOUTR12: MDIOS output data register 12
func (o *MDIOS_Type) SetDOUTR12_DOUT12(value uint32) {
	volatile.StoreUint32(&o.DOUTR12.Reg, volatile.LoadUint32(&o.DOUTR12.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR12_DOUT12() uint32 {
	return volatile.LoadUint32(&o.DOUTR12.Reg) & 0xffff
}

// MDIOS.DOUTR13: MDIOS output data register 13
func (o *MDIOS_Type) SetDOUTR13_DOUT13(value uint32) {
	volatile.StoreUint32(&o.DOUTR13.Reg, volatile.LoadUint32(&o.DOUTR13.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR13_DOUT13() uint32 {
	return volatile.LoadUint32(&o.DOUTR13.Reg) & 0xffff
}

// MDIOS.DOUTR14: MDIOS output data register 14
func (o *MDIOS_Type) SetDOUTR14_DOUT14(value uint32) {
	volatile.StoreUint32(&o.DOUTR14.Reg, volatile.LoadUint32(&o.DOUTR14.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR14_DOUT14() uint32 {
	return volatile.LoadUint32(&o.DOUTR14.Reg) & 0xffff
}

// MDIOS.DOUTR15: MDIOS output data register 15
func (o *MDIOS_Type) SetDOUTR15_DOUT15(value uint32) {
	volatile.StoreUint32(&o.DOUTR15.Reg, volatile.LoadUint32(&o.DOUTR15.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR15_DOUT15() uint32 {
	return volatile.LoadUint32(&o.DOUTR15.Reg) & 0xffff
}

// MDIOS.DOUTR16: MDIOS output data register 16
func (o *MDIOS_Type) SetDOUTR16_DOUT16(value uint32) {
	volatile.StoreUint32(&o.DOUTR16.Reg, volatile.LoadUint32(&o.DOUTR16.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR16_DOUT16() uint32 {
	return volatile.LoadUint32(&o.DOUTR16.Reg) & 0xffff
}

// MDIOS.DOUTR17: MDIOS output data register 17
func (o *MDIOS_Type) SetDOUTR17_DOUT17(value uint32) {
	volatile.StoreUint32(&o.DOUTR17.Reg, volatile.LoadUint32(&o.DOUTR17.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR17_DOUT17() uint32 {
	return volatile.LoadUint32(&o.DOUTR17.Reg) & 0xffff
}

// MDIOS.DOUTR18: MDIOS output data register 18
func (o *MDIOS_Type) SetDOUTR18_DOUT18(value uint32) {
	volatile.StoreUint32(&o.DOUTR18.Reg, volatile.LoadUint32(&o.DOUTR18.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR18_DOUT18() uint32 {
	return volatile.LoadUint32(&o.DOUTR18.Reg) & 0xffff
}

// MDIOS.DOUTR19: MDIOS output data register 19
func (o *MDIOS_Type) SetDOUTR19_DOUT19(value uint32) {
	volatile.StoreUint32(&o.DOUTR19.Reg, volatile.LoadUint32(&o.DOUTR19.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR19_DOUT19() uint32 {
	return volatile.LoadUint32(&o.DOUTR19.Reg) & 0xffff
}

// MDIOS.DOUTR20: MDIOS output data register 20
func (o *MDIOS_Type) SetDOUTR20_DOUT20(value uint32) {
	volatile.StoreUint32(&o.DOUTR20.Reg, volatile.LoadUint32(&o.DOUTR20.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR20_DOUT20() uint32 {
	return volatile.LoadUint32(&o.DOUTR20.Reg) & 0xffff
}

// MDIOS.DOUTR21: MDIOS output data register 21
func (o *MDIOS_Type) SetDOUTR21_DOUT21(value uint32) {
	volatile.StoreUint32(&o.DOUTR21.Reg, volatile.LoadUint32(&o.DOUTR21.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR21_DOUT21() uint32 {
	return volatile.LoadUint32(&o.DOUTR21.Reg) & 0xffff
}

// MDIOS.DOUTR22: MDIOS output data register 22
func (o *MDIOS_Type) SetDOUTR22_DOUT22(value uint32) {
	volatile.StoreUint32(&o.DOUTR22.Reg, volatile.LoadUint32(&o.DOUTR22.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR22_DOUT22() uint32 {
	return volatile.LoadUint32(&o.DOUTR22.Reg) & 0xffff
}

// MDIOS.DOUTR23: MDIOS output data register 23
func (o *MDIOS_Type) SetDOUTR23_DOUT23(value uint32) {
	volatile.StoreUint32(&o.DOUTR23.Reg, volatile.LoadUint32(&o.DOUTR23.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR23_DOUT23() uint32 {
	return volatile.LoadUint32(&o.DOUTR23.Reg) & 0xffff
}

// MDIOS.DOUTR24: MDIOS output data register 24
func (o *MDIOS_Type) SetDOUTR24_DOUT24(value uint32) {
	volatile.StoreUint32(&o.DOUTR24.Reg, volatile.LoadUint32(&o.DOUTR24.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR24_DOUT24() uint32 {
	return volatile.LoadUint32(&o.DOUTR24.Reg) & 0xffff
}

// MDIOS.DOUTR25: MDIOS output data register 25
func (o *MDIOS_Type) SetDOUTR25_DOUT25(value uint32) {
	volatile.StoreUint32(&o.DOUTR25.Reg, volatile.LoadUint32(&o.DOUTR25.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR25_DOUT25() uint32 {
	return volatile.LoadUint32(&o.DOUTR25.Reg) & 0xffff
}

// MDIOS.DOUTR26: MDIOS output data register 26
func (o *MDIOS_Type) SetDOUTR26_DOUT26(value uint32) {
	volatile.StoreUint32(&o.DOUTR26.Reg, volatile.LoadUint32(&o.DOUTR26.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR26_DOUT26() uint32 {
	return volatile.LoadUint32(&o.DOUTR26.Reg) & 0xffff
}

// MDIOS.DOUTR27: MDIOS output data register 27
func (o *MDIOS_Type) SetDOUTR27_DOUT27(value uint32) {
	volatile.StoreUint32(&o.DOUTR27.Reg, volatile.LoadUint32(&o.DOUTR27.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR27_DOUT27() uint32 {
	return volatile.LoadUint32(&o.DOUTR27.Reg) & 0xffff
}

// MDIOS.DOUTR28: MDIOS output data register 28
func (o *MDIOS_Type) SetDOUTR28_DOUT28(value uint32) {
	volatile.StoreUint32(&o.DOUTR28.Reg, volatile.LoadUint32(&o.DOUTR28.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR28_DOUT28() uint32 {
	return volatile.LoadUint32(&o.DOUTR28.Reg) & 0xffff
}

// MDIOS.DOUTR29: MDIOS output data register 29
func (o *MDIOS_Type) SetDOUTR29_DOUT29(value uint32) {
	volatile.StoreUint32(&o.DOUTR29.Reg, volatile.LoadUint32(&o.DOUTR29.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR29_DOUT29() uint32 {
	return volatile.LoadUint32(&o.DOUTR29.Reg) & 0xffff
}

// MDIOS.DOUTR30: MDIOS output data register 30
func (o *MDIOS_Type) SetDOUTR30_DOUT30(value uint32) {
	volatile.StoreUint32(&o.DOUTR30.Reg, volatile.LoadUint32(&o.DOUTR30.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR30_DOUT30() uint32 {
	return volatile.LoadUint32(&o.DOUTR30.Reg) & 0xffff
}

// MDIOS.DOUTR31: MDIOS output data register 31
func (o *MDIOS_Type) SetDOUTR31_DOUT31(value uint32) {
	volatile.StoreUint32(&o.DOUTR31.Reg, volatile.LoadUint32(&o.DOUTR31.Reg)&^(0xffff)|value)
}
func (o *MDIOS_Type) GetDOUTR31_DOUT31() uint32 {
	return volatile.LoadUint32(&o.DOUTR31.Reg) & 0xffff
}

// MDMA
type MDMA_Type struct {
	GISR0 volatile.Register32 // 0x0
	_     [60]byte
	CH    [16]MDMA_CH_Type // 0x40
}

// MDMA.GISR0: MDMA Global Interrupt/Status Register
func (o *MDMA_Type) SetGISR0_GIF0(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x1)|value)
}
func (o *MDMA_Type) GetGISR0_GIF0() uint32 {
	return volatile.LoadUint32(&o.GISR0.Reg) & 0x1
}
func (o *MDMA_Type) SetGISR0_GIF1(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x2)|value<<1)
}
func (o *MDMA_Type) GetGISR0_GIF1() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x2) >> 1
}
func (o *MDMA_Type) SetGISR0_GIF2(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x4)|value<<2)
}
func (o *MDMA_Type) GetGISR0_GIF2() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x4) >> 2
}
func (o *MDMA_Type) SetGISR0_GIF3(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x8)|value<<3)
}
func (o *MDMA_Type) GetGISR0_GIF3() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x8) >> 3
}
func (o *MDMA_Type) SetGISR0_GIF4(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x10)|value<<4)
}
func (o *MDMA_Type) GetGISR0_GIF4() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x10) >> 4
}
func (o *MDMA_Type) SetGISR0_GIF5(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x20)|value<<5)
}
func (o *MDMA_Type) GetGISR0_GIF5() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x20) >> 5
}
func (o *MDMA_Type) SetGISR0_GIF6(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x40)|value<<6)
}
func (o *MDMA_Type) GetGISR0_GIF6() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x40) >> 6
}
func (o *MDMA_Type) SetGISR0_GIF7(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x80)|value<<7)
}
func (o *MDMA_Type) GetGISR0_GIF7() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x80) >> 7
}
func (o *MDMA_Type) SetGISR0_GIF8(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x100)|value<<8)
}
func (o *MDMA_Type) GetGISR0_GIF8() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x100) >> 8
}
func (o *MDMA_Type) SetGISR0_GIF9(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x200)|value<<9)
}
func (o *MDMA_Type) GetGISR0_GIF9() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x200) >> 9
}
func (o *MDMA_Type) SetGISR0_GIF10(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x400)|value<<10)
}
func (o *MDMA_Type) GetGISR0_GIF10() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x400) >> 10
}
func (o *MDMA_Type) SetGISR0_GIF11(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x800)|value<<11)
}
func (o *MDMA_Type) GetGISR0_GIF11() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x800) >> 11
}
func (o *MDMA_Type) SetGISR0_GIF12(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x1000)|value<<12)
}
func (o *MDMA_Type) GetGISR0_GIF12() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x1000) >> 12
}
func (o *MDMA_Type) SetGISR0_GIF13(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x2000)|value<<13)
}
func (o *MDMA_Type) GetGISR0_GIF13() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x2000) >> 13
}
func (o *MDMA_Type) SetGISR0_GIF14(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x4000)|value<<14)
}
func (o *MDMA_Type) GetGISR0_GIF14() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x4000) >> 14
}
func (o *MDMA_Type) SetGISR0_GIF15(value uint32) {
	volatile.StoreUint32(&o.GISR0.Reg, volatile.LoadUint32(&o.GISR0.Reg)&^(0x8000)|value<<15)
}
func (o *MDMA_Type) GetGISR0_GIF15() uint32 {
	return (volatile.LoadUint32(&o.GISR0.Reg) & 0x8000) >> 15
}

// Channel cluster: C?ISR, C?IFCR, C?ESR, C?CR, C?TCR, C?BNDTR, C?SAR, C?DAR, C?BRUR, C?LAR, C?TBR, C?MAR and C?MDR registers
type MDMA_CH_Type struct {
	ISR   volatile.Register32 // 0x40
	IFCR  volatile.Register32 // 0x44
	ESR   volatile.Register32 // 0x48
	CR    volatile.Register32 // 0x4C
	TCR   volatile.Register32 // 0x50
	BNDTR volatile.Register32 // 0x54
	SAR   volatile.Register32 // 0x58
	DAR   volatile.Register32 // 0x5C
	BRUR  volatile.Register32 // 0x60
	LAR   volatile.Register32 // 0x64
	TBR   volatile.Register32 // 0x68
	_     [4]byte
	MAR   volatile.Register32 // 0x70
	MDR   volatile.Register32 // 0x74
	_     [8]byte
}

// MDMA_CH.ISR: MDMA channel x interrupt/status register
func (o *MDMA_CH_Type) SetISR_TEIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *MDMA_CH_Type) GetISR_TEIF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *MDMA_CH_Type) SetISR_CTCIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *MDMA_CH_Type) GetISR_CTCIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *MDMA_CH_Type) SetISR_BRTIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *MDMA_CH_Type) GetISR_BRTIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *MDMA_CH_Type) SetISR_BTIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *MDMA_CH_Type) GetISR_BTIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *MDMA_CH_Type) SetISR_TCIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *MDMA_CH_Type) GetISR_TCIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *MDMA_CH_Type) SetISR_CRQA(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *MDMA_CH_Type) GetISR_CRQA() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}

// MDMA_CH.IFCR: MDMA channel x interrupt flag clear register
func (o *MDMA_CH_Type) SetIFCR_CTEIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1)|value)
}
func (o *MDMA_CH_Type) GetIFCR_CTEIF() uint32 {
	return volatile.LoadUint32(&o.IFCR.Reg) & 0x1
}
func (o *MDMA_CH_Type) SetIFCR_CCTCIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2)|value<<1)
}
func (o *MDMA_CH_Type) GetIFCR_CCTCIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2) >> 1
}
func (o *MDMA_CH_Type) SetIFCR_CBRTIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4)|value<<2)
}
func (o *MDMA_CH_Type) GetIFCR_CBRTIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4) >> 2
}
func (o *MDMA_CH_Type) SetIFCR_CBTIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8)|value<<3)
}
func (o *MDMA_CH_Type) GetIFCR_CBTIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8) >> 3
}
func (o *MDMA_CH_Type) SetIFCR_CLTCIF(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10)|value<<4)
}
func (o *MDMA_CH_Type) GetIFCR_CLTCIF() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10) >> 4
}

// MDMA_CH.ESR: MDMA Channel x error status register
func (o *MDMA_CH_Type) SetESR_TEA(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x7f)|value)
}
func (o *MDMA_CH_Type) GetESR_TEA() uint32 {
	return volatile.LoadUint32(&o.ESR.Reg) & 0x7f
}
func (o *MDMA_CH_Type) SetESR_TED(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x80)|value<<7)
}
func (o *MDMA_CH_Type) GetESR_TED() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x80) >> 7
}
func (o *MDMA_CH_Type) SetESR_TELD(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x100)|value<<8)
}
func (o *MDMA_CH_Type) GetESR_TELD() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x100) >> 8
}
func (o *MDMA_CH_Type) SetESR_TEMD(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x200)|value<<9)
}
func (o *MDMA_CH_Type) GetESR_TEMD() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x200) >> 9
}
func (o *MDMA_CH_Type) SetESR_ASE(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x400)|value<<10)
}
func (o *MDMA_CH_Type) GetESR_ASE() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x400) >> 10
}
func (o *MDMA_CH_Type) SetESR_BSE(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x800)|value<<11)
}
func (o *MDMA_CH_Type) GetESR_BSE() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x800) >> 11
}

// MDMA_CH.CR: This register is used to control the concerned channel.
func (o *MDMA_CH_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *MDMA_CH_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *MDMA_CH_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *MDMA_CH_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *MDMA_CH_Type) SetCR_CTCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *MDMA_CH_Type) GetCR_CTCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *MDMA_CH_Type) SetCR_BRTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *MDMA_CH_Type) GetCR_BRTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *MDMA_CH_Type) SetCR_BTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *MDMA_CH_Type) GetCR_BTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *MDMA_CH_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *MDMA_CH_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *MDMA_CH_Type) SetCR_PL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *MDMA_CH_Type) GetCR_PL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}
func (o *MDMA_CH_Type) SetCR_BEX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *MDMA_CH_Type) GetCR_BEX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *MDMA_CH_Type) SetCR_HEX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *MDMA_CH_Type) GetCR_HEX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *MDMA_CH_Type) SetCR_WEX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *MDMA_CH_Type) GetCR_WEX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *MDMA_CH_Type) SetCR_SWRQ(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *MDMA_CH_Type) GetCR_SWRQ() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}

// MDMA_CH.TCR: This register is used to configure the concerned channel.
func (o *MDMA_CH_Type) SetTCR_SINC(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x3)|value)
}
func (o *MDMA_CH_Type) GetTCR_SINC() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0x3
}
func (o *MDMA_CH_Type) SetTCR_DINC(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xc)|value<<2)
}
func (o *MDMA_CH_Type) GetTCR_DINC() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xc) >> 2
}
func (o *MDMA_CH_Type) SetTCR_SSIZE(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x30)|value<<4)
}
func (o *MDMA_CH_Type) GetTCR_SSIZE() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x30) >> 4
}
func (o *MDMA_CH_Type) SetTCR_DSIZE(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xc0)|value<<6)
}
func (o *MDMA_CH_Type) GetTCR_DSIZE() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xc0) >> 6
}
func (o *MDMA_CH_Type) SetTCR_SINCOS(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x300)|value<<8)
}
func (o *MDMA_CH_Type) GetTCR_SINCOS() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x300) >> 8
}
func (o *MDMA_CH_Type) SetTCR_DINCOS(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xc00)|value<<10)
}
func (o *MDMA_CH_Type) GetTCR_DINCOS() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xc00) >> 10
}
func (o *MDMA_CH_Type) SetTCR_SBURST(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x7000)|value<<12)
}
func (o *MDMA_CH_Type) GetTCR_SBURST() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x7000) >> 12
}
func (o *MDMA_CH_Type) SetTCR_DBURST(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x38000)|value<<15)
}
func (o *MDMA_CH_Type) GetTCR_DBURST() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x38000) >> 15
}
func (o *MDMA_CH_Type) SetTCR_TLEN(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x1fc0000)|value<<18)
}
func (o *MDMA_CH_Type) GetTCR_TLEN() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x1fc0000) >> 18
}
func (o *MDMA_CH_Type) SetTCR_PKE(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x2000000)|value<<25)
}
func (o *MDMA_CH_Type) GetTCR_PKE() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x2000000) >> 25
}
func (o *MDMA_CH_Type) SetTCR_PAM(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xc000000)|value<<26)
}
func (o *MDMA_CH_Type) GetTCR_PAM() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xc000000) >> 26
}
func (o *MDMA_CH_Type) SetTCR_TRGM(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x30000000)|value<<28)
}
func (o *MDMA_CH_Type) GetTCR_TRGM() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x30000000) >> 28
}
func (o *MDMA_CH_Type) SetTCR_SWRM(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x40000000)|value<<30)
}
func (o *MDMA_CH_Type) GetTCR_SWRM() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x40000000) >> 30
}
func (o *MDMA_CH_Type) SetTCR_BWM(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x80000000)|value<<31)
}
func (o *MDMA_CH_Type) GetTCR_BWM() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x80000000) >> 31
}

// MDMA_CH.BNDTR: MDMA Channel x block number of data register
func (o *MDMA_CH_Type) SetBNDTR_BNDT(value uint32) {
	volatile.StoreUint32(&o.BNDTR.Reg, volatile.LoadUint32(&o.BNDTR.Reg)&^(0x1ffff)|value)
}
func (o *MDMA_CH_Type) GetBNDTR_BNDT() uint32 {
	return volatile.LoadUint32(&o.BNDTR.Reg) & 0x1ffff
}
func (o *MDMA_CH_Type) SetBNDTR_BRSUM(value uint32) {
	volatile.StoreUint32(&o.BNDTR.Reg, volatile.LoadUint32(&o.BNDTR.Reg)&^(0x40000)|value<<18)
}
func (o *MDMA_CH_Type) GetBNDTR_BRSUM() uint32 {
	return (volatile.LoadUint32(&o.BNDTR.Reg) & 0x40000) >> 18
}
func (o *MDMA_CH_Type) SetBNDTR_BRDUM(value uint32) {
	volatile.StoreUint32(&o.BNDTR.Reg, volatile.LoadUint32(&o.BNDTR.Reg)&^(0x80000)|value<<19)
}
func (o *MDMA_CH_Type) GetBNDTR_BRDUM() uint32 {
	return (volatile.LoadUint32(&o.BNDTR.Reg) & 0x80000) >> 19
}
func (o *MDMA_CH_Type) SetBNDTR_BRC(value uint32) {
	volatile.StoreUint32(&o.BNDTR.Reg, volatile.LoadUint32(&o.BNDTR.Reg)&^(0xfff00000)|value<<20)
}
func (o *MDMA_CH_Type) GetBNDTR_BRC() uint32 {
	return (volatile.LoadUint32(&o.BNDTR.Reg) & 0xfff00000) >> 20
}

// MDMA_CH.SAR: MDMA channel x source address register
func (o *MDMA_CH_Type) SetSAR(value uint32) {
	volatile.StoreUint32(&o.SAR.Reg, value)
}
func (o *MDMA_CH_Type) GetSAR() uint32 {
	return volatile.LoadUint32(&o.SAR.Reg)
}

// MDMA_CH.DAR: MDMA channel x destination address register
func (o *MDMA_CH_Type) SetDAR(value uint32) {
	volatile.StoreUint32(&o.DAR.Reg, value)
}
func (o *MDMA_CH_Type) GetDAR() uint32 {
	return volatile.LoadUint32(&o.DAR.Reg)
}

// MDMA_CH.BRUR: MDMA channel x Block Repeat address Update register
func (o *MDMA_CH_Type) SetBRUR_SUV(value uint32) {
	volatile.StoreUint32(&o.BRUR.Reg, volatile.LoadUint32(&o.BRUR.Reg)&^(0xffff)|value)
}
func (o *MDMA_CH_Type) GetBRUR_SUV() uint32 {
	return volatile.LoadUint32(&o.BRUR.Reg) & 0xffff
}
func (o *MDMA_CH_Type) SetBRUR_DUV(value uint32) {
	volatile.StoreUint32(&o.BRUR.Reg, volatile.LoadUint32(&o.BRUR.Reg)&^(0xffff0000)|value<<16)
}
func (o *MDMA_CH_Type) GetBRUR_DUV() uint32 {
	return (volatile.LoadUint32(&o.BRUR.Reg) & 0xffff0000) >> 16
}

// MDMA_CH.LAR: MDMA channel x Link Address register
func (o *MDMA_CH_Type) SetLAR(value uint32) {
	volatile.StoreUint32(&o.LAR.Reg, value)
}
func (o *MDMA_CH_Type) GetLAR() uint32 {
	return volatile.LoadUint32(&o.LAR.Reg)
}

// MDMA_CH.TBR: MDMA channel x Trigger and Bus selection Register
func (o *MDMA_CH_Type) SetTBR_TSEL(value uint32) {
	volatile.StoreUint32(&o.TBR.Reg, volatile.LoadUint32(&o.TBR.Reg)&^(0x3f)|value)
}
func (o *MDMA_CH_Type) GetTBR_TSEL() uint32 {
	return volatile.LoadUint32(&o.TBR.Reg) & 0x3f
}
func (o *MDMA_CH_Type) SetTBR_SBUS(value uint32) {
	volatile.StoreUint32(&o.TBR.Reg, volatile.LoadUint32(&o.TBR.Reg)&^(0x10000)|value<<16)
}
func (o *MDMA_CH_Type) GetTBR_SBUS() uint32 {
	return (volatile.LoadUint32(&o.TBR.Reg) & 0x10000) >> 16
}
func (o *MDMA_CH_Type) SetTBR_DBUS(value uint32) {
	volatile.StoreUint32(&o.TBR.Reg, volatile.LoadUint32(&o.TBR.Reg)&^(0x20000)|value<<17)
}
func (o *MDMA_CH_Type) GetTBR_DBUS() uint32 {
	return (volatile.LoadUint32(&o.TBR.Reg) & 0x20000) >> 17
}

// MDMA_CH.MAR: MDMA channel x Mask address register
func (o *MDMA_CH_Type) SetMAR(value uint32) {
	volatile.StoreUint32(&o.MAR.Reg, value)
}
func (o *MDMA_CH_Type) GetMAR() uint32 {
	return volatile.LoadUint32(&o.MAR.Reg)
}

// MDMA_CH.MDR: MDMA channel x Mask Data register
func (o *MDMA_CH_Type) SetMDR(value uint32) {
	volatile.StoreUint32(&o.MDR.Reg, value)
}
func (o *MDMA_CH_Type) GetMDR() uint32 {
	return volatile.LoadUint32(&o.MDR.Reg)
}

// Memory protection unit
type MPU_Type struct {
	TYPER volatile.Register32 // 0x0
	CTRL  volatile.Register32 // 0x4
	RNR   volatile.Register32 // 0x8
	RBAR  volatile.Register32 // 0xC
	RASR  volatile.Register32 // 0x10
}

// MPU.TYPER: MPU type register
func (o *MPU_Type) SetTYPER_SEPARATE(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetTYPER_SEPARATE() uint32 {
	return volatile.LoadUint32(&o.TYPER.Reg) & 0x1
}
func (o *MPU_Type) SetTYPER_DREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetTYPER_DREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetTYPER_IREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff0000)|value<<16)
}
func (o *MPU_Type) GetTYPER_IREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff0000) >> 16
}

// MPU.CTRL: MPU control register
func (o *MPU_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *MPU_Type) SetCTRL_HFNMIENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *MPU_Type) GetCTRL_HFNMIENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *MPU_Type) SetCTRL_PRIVDEFENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *MPU_Type) GetCTRL_PRIVDEFENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}

// MPU.RNR: MPU region number register
func (o *MPU_Type) SetRNR_REGION(value uint32) {
	volatile.StoreUint32(&o.RNR.Reg, volatile.LoadUint32(&o.RNR.Reg)&^(0xff)|value)
}
func (o *MPU_Type) GetRNR_REGION() uint32 {
	return volatile.LoadUint32(&o.RNR.Reg) & 0xff
}

// MPU.RBAR: MPU region base address register
func (o *MPU_Type) SetRBAR_REGION(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xf)|value)
}
func (o *MPU_Type) GetRBAR_REGION() uint32 {
	return volatile.LoadUint32(&o.RBAR.Reg) & 0xf
}
func (o *MPU_Type) SetRBAR_VALID(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0x10)|value<<4)
}
func (o *MPU_Type) GetRBAR_VALID() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0x10) >> 4
}
func (o *MPU_Type) SetRBAR_ADDR(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *MPU_Type) GetRBAR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0xffffffe0) >> 5
}

// MPU.RASR: MPU region attribute and size register
func (o *MPU_Type) SetRASR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetRASR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.RASR.Reg) & 0x1
}
func (o *MPU_Type) SetRASR_SIZE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x3e)|value<<1)
}
func (o *MPU_Type) GetRASR_SIZE() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x3e) >> 1
}
func (o *MPU_Type) SetRASR_SRD(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetRASR_SRD() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetRASR_B(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000)|value<<16)
}
func (o *MPU_Type) GetRASR_B() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000) >> 16
}
func (o *MPU_Type) SetRASR_C(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x20000)|value<<17)
}
func (o *MPU_Type) GetRASR_C() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x20000) >> 17
}
func (o *MPU_Type) SetRASR_S(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x40000)|value<<18)
}
func (o *MPU_Type) GetRASR_S() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x40000) >> 18
}
func (o *MPU_Type) SetRASR_TEX(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x380000)|value<<19)
}
func (o *MPU_Type) GetRASR_TEX() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x380000) >> 19
}
func (o *MPU_Type) SetRASR_AP(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x7000000)|value<<24)
}
func (o *MPU_Type) GetRASR_AP() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x7000000) >> 24
}
func (o *MPU_Type) SetRASR_XN(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000000)|value<<28)
}
func (o *MPU_Type) GetRASR_XN() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000000) >> 28
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	ISER2 volatile.Register32 // 0x8
	ISER3 volatile.Register32 // 0xC
	_     [112]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	ICER2 volatile.Register32 // 0x88
	ICER3 volatile.Register32 // 0x8C
	_     [112]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	ISPR2 volatile.Register32 // 0x108
	ISPR3 volatile.Register32 // 0x10C
	_     [112]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	ICPR2 volatile.Register32 // 0x188
	_     [52]byte
	ICPR3 volatile.Register32 // 0x1C0
	_     [60]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	IABR2 volatile.Register32 // 0x208
	IABR3 volatile.Register32 // 0x20C
	_     [240]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
	IPR14 volatile.Register32 // 0x338
	IPR15 volatile.Register32 // 0x33C
	IPR16 volatile.Register32 // 0x340
	IPR17 volatile.Register32 // 0x344
	IPR18 volatile.Register32 // 0x348
	IPR19 volatile.Register32 // 0x34C
	IPR20 volatile.Register32 // 0x350
	IPR21 volatile.Register32 // 0x354
	IPR22 volatile.Register32 // 0x358
	IPR23 volatile.Register32 // 0x35C
	IPR24 volatile.Register32 // 0x360
	IPR25 volatile.Register32 // 0x364
	IPR26 volatile.Register32 // 0x368
	IPR27 volatile.Register32 // 0x36C
	IPR28 volatile.Register32 // 0x370
	IPR29 volatile.Register32 // 0x374
	IPR30 volatile.Register32 // 0x378
	IPR31 volatile.Register32 // 0x37C
	IPR32 volatile.Register32 // 0x380
	IPR33 volatile.Register32 // 0x384
	IPR34 volatile.Register32 // 0x388
	IPR35 volatile.Register32 // 0x38C
	IPR36 volatile.Register32 // 0x390
	IPR37 volatile.Register32 // 0x394
	IPR38 volatile.Register32 // 0x398
}

// NVIC.ISER0: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER0(value uint32) {
	volatile.StoreUint32(&o.ISER0.Reg, value)
}
func (o *NVIC_Type) GetISER0() uint32 {
	return volatile.LoadUint32(&o.ISER0.Reg)
}

// NVIC.ISER1: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER1(value uint32) {
	volatile.StoreUint32(&o.ISER1.Reg, value)
}
func (o *NVIC_Type) GetISER1() uint32 {
	return volatile.LoadUint32(&o.ISER1.Reg)
}

// NVIC.ISER2: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER2(value uint32) {
	volatile.StoreUint32(&o.ISER2.Reg, value)
}
func (o *NVIC_Type) GetISER2() uint32 {
	return volatile.LoadUint32(&o.ISER2.Reg)
}

// NVIC.ICER0: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER0(value uint32) {
	volatile.StoreUint32(&o.ICER0.Reg, value)
}
func (o *NVIC_Type) GetICER0() uint32 {
	return volatile.LoadUint32(&o.ICER0.Reg)
}

// NVIC.ICER1: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER1(value uint32) {
	volatile.StoreUint32(&o.ICER1.Reg, value)
}
func (o *NVIC_Type) GetICER1() uint32 {
	return volatile.LoadUint32(&o.ICER1.Reg)
}

// NVIC.ICER2: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER2(value uint32) {
	volatile.StoreUint32(&o.ICER2.Reg, value)
}
func (o *NVIC_Type) GetICER2() uint32 {
	return volatile.LoadUint32(&o.ICER2.Reg)
}

// NVIC.ISPR0: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR0(value uint32) {
	volatile.StoreUint32(&o.ISPR0.Reg, value)
}
func (o *NVIC_Type) GetISPR0() uint32 {
	return volatile.LoadUint32(&o.ISPR0.Reg)
}

// NVIC.ISPR1: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR1(value uint32) {
	volatile.StoreUint32(&o.ISPR1.Reg, value)
}
func (o *NVIC_Type) GetISPR1() uint32 {
	return volatile.LoadUint32(&o.ISPR1.Reg)
}

// NVIC.ISPR2: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR2(value uint32) {
	volatile.StoreUint32(&o.ISPR2.Reg, value)
}
func (o *NVIC_Type) GetISPR2() uint32 {
	return volatile.LoadUint32(&o.ISPR2.Reg)
}

// NVIC.ICPR0: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR0(value uint32) {
	volatile.StoreUint32(&o.ICPR0.Reg, value)
}
func (o *NVIC_Type) GetICPR0() uint32 {
	return volatile.LoadUint32(&o.ICPR0.Reg)
}

// NVIC.ICPR1: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR1(value uint32) {
	volatile.StoreUint32(&o.ICPR1.Reg, value)
}
func (o *NVIC_Type) GetICPR1() uint32 {
	return volatile.LoadUint32(&o.ICPR1.Reg)
}

// NVIC.ICPR2: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR2(value uint32) {
	volatile.StoreUint32(&o.ICPR2.Reg, value)
}
func (o *NVIC_Type) GetICPR2() uint32 {
	return volatile.LoadUint32(&o.ICPR2.Reg)
}

// NVIC.IABR0: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR0(value uint32) {
	volatile.StoreUint32(&o.IABR0.Reg, value)
}
func (o *NVIC_Type) GetIABR0() uint32 {
	return volatile.LoadUint32(&o.IABR0.Reg)
}

// NVIC.IABR1: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR1(value uint32) {
	volatile.StoreUint32(&o.IABR1.Reg, value)
}
func (o *NVIC_Type) GetIABR1() uint32 {
	return volatile.LoadUint32(&o.IABR1.Reg)
}

// NVIC.IABR2: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR2(value uint32) {
	volatile.StoreUint32(&o.IABR2.Reg, value)
}
func (o *NVIC_Type) GetIABR2() uint32 {
	return volatile.LoadUint32(&o.IABR2.Reg)
}

// NVIC.IPR0: Interrupt Priority Register
func (o *NVIC_Type) SetIPR0_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR0_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR0.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR0_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR0_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR0_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR0_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR0_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR0_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff000000) >> 24
}

// NVIC.IPR1: Interrupt Priority Register
func (o *NVIC_Type) SetIPR1_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR1_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR1.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR1_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR1_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR1_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR1_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR1_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR1_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff000000) >> 24
}

// NVIC.IPR2: Interrupt Priority Register
func (o *NVIC_Type) SetIPR2_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR2_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR2.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR2_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR2_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR2_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR2_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR2_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR2_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff000000) >> 24
}

// NVIC.IPR3: Interrupt Priority Register
func (o *NVIC_Type) SetIPR3_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR3_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR3.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR3_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR3_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR3_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR3_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR3_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR3_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff000000) >> 24
}

// NVIC.IPR4: Interrupt Priority Register
func (o *NVIC_Type) SetIPR4_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR4_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR4.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR4_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR4_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR4_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR4_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR4_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR4_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff000000) >> 24
}

// NVIC.IPR5: Interrupt Priority Register
func (o *NVIC_Type) SetIPR5_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR5_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR5.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR5_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR5_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR5_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR5_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR5_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR5_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff000000) >> 24
}

// NVIC.IPR6: Interrupt Priority Register
func (o *NVIC_Type) SetIPR6_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR6_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR6.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR6_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR6_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR6_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR6_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR6_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR6_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff000000) >> 24
}

// NVIC.IPR7: Interrupt Priority Register
func (o *NVIC_Type) SetIPR7_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR7_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR7.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR7_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR7_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR7_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR7_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR7_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR7_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff000000) >> 24
}

// NVIC.IPR8: Interrupt Priority Register
func (o *NVIC_Type) SetIPR8_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR8_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR8.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR8_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR8_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR8_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR8_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR8_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR8_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff000000) >> 24
}

// NVIC.IPR9: Interrupt Priority Register
func (o *NVIC_Type) SetIPR9_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR9_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR9.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR9_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR9_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR9_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR9_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR9_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR9_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff000000) >> 24
}

// NVIC.IPR10: Interrupt Priority Register
func (o *NVIC_Type) SetIPR10_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR10_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR10.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR10_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR10_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR10_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR10_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR10_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR10_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff000000) >> 24
}

// NVIC.IPR11: Interrupt Priority Register
func (o *NVIC_Type) SetIPR11_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR11_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR11.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR11_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR11_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR11_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR11_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR11_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR11_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff000000) >> 24
}

// NVIC.IPR12: Interrupt Priority Register
func (o *NVIC_Type) SetIPR12_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR12_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR12.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR12_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR12_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR12_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR12_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR12_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR12_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff000000) >> 24
}

// NVIC.IPR13: Interrupt Priority Register
func (o *NVIC_Type) SetIPR13_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR13_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR13.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR13_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR13_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR13_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR13_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR13_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR13_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff000000) >> 24
}

// NVIC.IPR14: Interrupt Priority Register
func (o *NVIC_Type) SetIPR14_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR14_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR14.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR14_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR14_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR14_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR14_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR14_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR14_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff000000) >> 24
}

// NVIC.IPR15: Interrupt Priority Register
func (o *NVIC_Type) SetIPR15_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR15_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR15.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR15_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR15_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR15_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR15_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR15_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR15_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff000000) >> 24
}

// NVIC.IPR16: Interrupt Priority Register
func (o *NVIC_Type) SetIPR16_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR16_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR16.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR16_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR16_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR16_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR16_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR16_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR16_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff000000) >> 24
}

// NVIC.IPR17: Interrupt Priority Register
func (o *NVIC_Type) SetIPR17_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR17_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR17.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR17_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR17_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR17_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR17_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR17_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR17_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff000000) >> 24
}

// NVIC.IPR18: Interrupt Priority Register
func (o *NVIC_Type) SetIPR18_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR18_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR18.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR18_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR18_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR18_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR18_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR18_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR18_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff000000) >> 24
}

// NVIC.IPR19: Interrupt Priority Register
func (o *NVIC_Type) SetIPR19_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR19_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR19.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR19_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR19_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR19_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR19_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR19_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR19_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff000000) >> 24
}

// NVIC.IPR20: Interrupt Priority Register
func (o *NVIC_Type) SetIPR20_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR20_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR20.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR20_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR20_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR20.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR20_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR20_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR20.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR20_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR20_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR20.Reg) & 0xff000000) >> 24
}

// NVIC.IPR21: Interrupt Priority Register
func (o *NVIC_Type) SetIPR21_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR21.Reg, volatile.LoadUint32(&o.IPR21.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR21_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR21.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR21_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR21.Reg, volatile.LoadUint32(&o.IPR21.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR21_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR21.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR21_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR21.Reg, volatile.LoadUint32(&o.IPR21.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR21_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR21.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR21_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR21.Reg, volatile.LoadUint32(&o.IPR21.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR21_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR21.Reg) & 0xff000000) >> 24
}

// NVIC.IPR22: Interrupt Priority Register
func (o *NVIC_Type) SetIPR22_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR22.Reg, volatile.LoadUint32(&o.IPR22.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR22_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR22.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR22_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR22.Reg, volatile.LoadUint32(&o.IPR22.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR22_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR22.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR22_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR22.Reg, volatile.LoadUint32(&o.IPR22.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR22_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR22.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR22_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR22.Reg, volatile.LoadUint32(&o.IPR22.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR22_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR22.Reg) & 0xff000000) >> 24
}

// NVIC.IPR23: Interrupt Priority Register
func (o *NVIC_Type) SetIPR23_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR23.Reg, volatile.LoadUint32(&o.IPR23.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR23_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR23.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR23_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR23.Reg, volatile.LoadUint32(&o.IPR23.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR23_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR23.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR23_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR23.Reg, volatile.LoadUint32(&o.IPR23.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR23_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR23.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR23_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR23.Reg, volatile.LoadUint32(&o.IPR23.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR23_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR23.Reg) & 0xff000000) >> 24
}

// NVIC.IPR24: Interrupt Priority Register
func (o *NVIC_Type) SetIPR24_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR24.Reg, volatile.LoadUint32(&o.IPR24.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR24_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR24.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR24_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR24.Reg, volatile.LoadUint32(&o.IPR24.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR24_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR24.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR24_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR24.Reg, volatile.LoadUint32(&o.IPR24.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR24_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR24.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR24_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR24.Reg, volatile.LoadUint32(&o.IPR24.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR24_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR24.Reg) & 0xff000000) >> 24
}

// NVIC.IPR25: Interrupt Priority Register
func (o *NVIC_Type) SetIPR25_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR25.Reg, volatile.LoadUint32(&o.IPR25.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR25_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR25.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR25_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR25.Reg, volatile.LoadUint32(&o.IPR25.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR25_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR25.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR25_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR25.Reg, volatile.LoadUint32(&o.IPR25.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR25_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR25.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR25_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR25.Reg, volatile.LoadUint32(&o.IPR25.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR25_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR25.Reg) & 0xff000000) >> 24
}

// NVIC.IPR26: Interrupt Priority Register
func (o *NVIC_Type) SetIPR26_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR26.Reg, volatile.LoadUint32(&o.IPR26.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR26_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR26.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR26_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR26.Reg, volatile.LoadUint32(&o.IPR26.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR26_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR26.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR26_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR26.Reg, volatile.LoadUint32(&o.IPR26.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR26_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR26.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR26_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR26.Reg, volatile.LoadUint32(&o.IPR26.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR26_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR26.Reg) & 0xff000000) >> 24
}

// NVIC.IPR27: Interrupt Priority Register
func (o *NVIC_Type) SetIPR27_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR27.Reg, volatile.LoadUint32(&o.IPR27.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR27_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR27.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR27_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR27.Reg, volatile.LoadUint32(&o.IPR27.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR27_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR27.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR27_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR27.Reg, volatile.LoadUint32(&o.IPR27.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR27_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR27.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR27_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR27.Reg, volatile.LoadUint32(&o.IPR27.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR27_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR27.Reg) & 0xff000000) >> 24
}

// NVIC.IPR28: Interrupt Priority Register
func (o *NVIC_Type) SetIPR28_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR28.Reg, volatile.LoadUint32(&o.IPR28.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR28_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR28.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR28_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR28.Reg, volatile.LoadUint32(&o.IPR28.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR28_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR28.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR28_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR28.Reg, volatile.LoadUint32(&o.IPR28.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR28_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR28.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR28_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR28.Reg, volatile.LoadUint32(&o.IPR28.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR28_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR28.Reg) & 0xff000000) >> 24
}

// NVIC.IPR29: Interrupt Priority Register
func (o *NVIC_Type) SetIPR29_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR29.Reg, volatile.LoadUint32(&o.IPR29.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR29_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR29.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR29_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR29.Reg, volatile.LoadUint32(&o.IPR29.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR29_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR29.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR29_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR29.Reg, volatile.LoadUint32(&o.IPR29.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR29_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR29.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR29_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR29.Reg, volatile.LoadUint32(&o.IPR29.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR29_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR29.Reg) & 0xff000000) >> 24
}

// NVIC.IPR30: Interrupt Priority Register
func (o *NVIC_Type) SetIPR30_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR30.Reg, volatile.LoadUint32(&o.IPR30.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR30_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR30.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR30_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR30.Reg, volatile.LoadUint32(&o.IPR30.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR30_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR30.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR30_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR30.Reg, volatile.LoadUint32(&o.IPR30.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR30_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR30.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR30_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR30.Reg, volatile.LoadUint32(&o.IPR30.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR30_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR30.Reg) & 0xff000000) >> 24
}

// NVIC.IPR31: Interrupt Priority Register
func (o *NVIC_Type) SetIPR31_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR31.Reg, volatile.LoadUint32(&o.IPR31.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR31_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR31.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR31_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR31.Reg, volatile.LoadUint32(&o.IPR31.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR31_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR31.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR31_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR31.Reg, volatile.LoadUint32(&o.IPR31.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR31_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR31.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR31_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR31.Reg, volatile.LoadUint32(&o.IPR31.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR31_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR31.Reg) & 0xff000000) >> 24
}

// NVIC.IPR32: Interrupt Priority Register
func (o *NVIC_Type) SetIPR32_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR32.Reg, volatile.LoadUint32(&o.IPR32.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR32_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR32.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR32_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR32.Reg, volatile.LoadUint32(&o.IPR32.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR32_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR32.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR32_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR32.Reg, volatile.LoadUint32(&o.IPR32.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR32_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR32.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR32_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR32.Reg, volatile.LoadUint32(&o.IPR32.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR32_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR32.Reg) & 0xff000000) >> 24
}

// NVIC.IPR33: Interrupt Priority Register
func (o *NVIC_Type) SetIPR33_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR33.Reg, volatile.LoadUint32(&o.IPR33.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR33_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR33.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR33_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR33.Reg, volatile.LoadUint32(&o.IPR33.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR33_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR33.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR33_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR33.Reg, volatile.LoadUint32(&o.IPR33.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR33_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR33.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR33_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR33.Reg, volatile.LoadUint32(&o.IPR33.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR33_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR33.Reg) & 0xff000000) >> 24
}

// NVIC.IPR34: Interrupt Priority Register
func (o *NVIC_Type) SetIPR34_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR34.Reg, volatile.LoadUint32(&o.IPR34.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR34_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR34.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR34_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR34.Reg, volatile.LoadUint32(&o.IPR34.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR34_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR34.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR34_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR34.Reg, volatile.LoadUint32(&o.IPR34.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR34_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR34.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR34_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR34.Reg, volatile.LoadUint32(&o.IPR34.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR34_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR34.Reg) & 0xff000000) >> 24
}

// NVIC.IPR35: Interrupt Priority Register
func (o *NVIC_Type) SetIPR35_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR35.Reg, volatile.LoadUint32(&o.IPR35.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR35_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR35.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR35_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR35.Reg, volatile.LoadUint32(&o.IPR35.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR35_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR35.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR35_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR35.Reg, volatile.LoadUint32(&o.IPR35.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR35_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR35.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR35_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR35.Reg, volatile.LoadUint32(&o.IPR35.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR35_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR35.Reg) & 0xff000000) >> 24
}

// NVIC.IPR36: Interrupt Priority Register
func (o *NVIC_Type) SetIPR36_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR36.Reg, volatile.LoadUint32(&o.IPR36.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR36_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR36.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR36_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR36.Reg, volatile.LoadUint32(&o.IPR36.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR36_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR36.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR36_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR36.Reg, volatile.LoadUint32(&o.IPR36.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR36_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR36.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR36_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR36.Reg, volatile.LoadUint32(&o.IPR36.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR36_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR36.Reg) & 0xff000000) >> 24
}

// NVIC.IPR37: Interrupt Priority Register
func (o *NVIC_Type) SetIPR37_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR37.Reg, volatile.LoadUint32(&o.IPR37.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR37_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR37.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR37_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR37.Reg, volatile.LoadUint32(&o.IPR37.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR37_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR37.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR37_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR37.Reg, volatile.LoadUint32(&o.IPR37.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR37_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR37.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR37_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR37.Reg, volatile.LoadUint32(&o.IPR37.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR37_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR37.Reg) & 0xff000000) >> 24
}

// NVIC.IPR38: Interrupt Priority Register
func (o *NVIC_Type) SetIPR38_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR38.Reg, volatile.LoadUint32(&o.IPR38.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR38_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR38.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR38_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR38.Reg, volatile.LoadUint32(&o.IPR38.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR38_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR38.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR38_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR38.Reg, volatile.LoadUint32(&o.IPR38.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR38_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR38.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR38_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR38.Reg, volatile.LoadUint32(&o.IPR38.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR38_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR38.Reg) & 0xff000000) >> 24
}

// OctoSPI
type OctoSPI_Type struct {
	CR    volatile.Register32 // 0x0
	_     [4]byte
	DCR1  volatile.Register32 // 0x8
	DCR2  volatile.Register32 // 0xC
	DCR3  volatile.Register32 // 0x10
	DCR4  volatile.Register32 // 0x14
	_     [8]byte
	SR    volatile.Register32 // 0x20
	FCR   volatile.Register32 // 0x24
	_     [24]byte
	DLR   volatile.Register32 // 0x40
	_     [4]byte
	AR    volatile.Register32 // 0x48
	_     [4]byte
	DR    volatile.Register32 // 0x50
	_     [44]byte
	PSMKR volatile.Register32 // 0x80
	_     [4]byte
	PSMAR volatile.Register32 // 0x88
	_     [4]byte
	PIR   volatile.Register32 // 0x90
	_     [108]byte
	CCR   volatile.Register32 // 0x100
	_     [4]byte
	TCR   volatile.Register32 // 0x108
	_     [4]byte
	IR    volatile.Register32 // 0x110
	_     [12]byte
	ABR   volatile.Register32 // 0x120
	_     [12]byte
	LPTR  volatile.Register32 // 0x130
	_     [12]byte
	WPCCR volatile.Register32 // 0x140
	_     [4]byte
	WPTCR volatile.Register32 // 0x148
	_     [4]byte
	WPIR  volatile.Register32 // 0x150
	_     [12]byte
	WPABR volatile.Register32 // 0x160
	_     [28]byte
	WCCR  volatile.Register32 // 0x180
	_     [4]byte
	WTCR  volatile.Register32 // 0x188
	_     [4]byte
	WIR   volatile.Register32 // 0x190
	_     [12]byte
	WABR  volatile.Register32 // 0x1A0
	_     [92]byte
	HLCR  volatile.Register32 // 0x200
}

// OctoSPI.CR: control register
func (o *OctoSPI_Type) SetCR_FMODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30000000)|value<<28)
}
func (o *OctoSPI_Type) GetCR_FMODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30000000) >> 28
}
func (o *OctoSPI_Type) SetCR_PMM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *OctoSPI_Type) GetCR_PMM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *OctoSPI_Type) SetCR_APMS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400000)|value<<22)
}
func (o *OctoSPI_Type) GetCR_APMS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400000) >> 22
}
func (o *OctoSPI_Type) SetCR_TOIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *OctoSPI_Type) GetCR_TOIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *OctoSPI_Type) SetCR_SMIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *OctoSPI_Type) GetCR_SMIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *OctoSPI_Type) SetCR_FTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *OctoSPI_Type) GetCR_FTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *OctoSPI_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *OctoSPI_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *OctoSPI_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *OctoSPI_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *OctoSPI_Type) SetCR_FTHRES(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1f00)|value<<8)
}
func (o *OctoSPI_Type) GetCR_FTHRES() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1f00) >> 8
}
func (o *OctoSPI_Type) SetCR_FSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *OctoSPI_Type) GetCR_FSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *OctoSPI_Type) SetCR_DQM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *OctoSPI_Type) GetCR_DQM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *OctoSPI_Type) SetCR_TCEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *OctoSPI_Type) GetCR_TCEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *OctoSPI_Type) SetCR_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *OctoSPI_Type) GetCR_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *OctoSPI_Type) SetCR_ABORT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *OctoSPI_Type) GetCR_ABORT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *OctoSPI_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *OctoSPI_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// OctoSPI.DCR1: device configuration register
func (o *OctoSPI_Type) SetDCR1_CKMODE(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0x1)|value)
}
func (o *OctoSPI_Type) GetDCR1_CKMODE() uint32 {
	return volatile.LoadUint32(&o.DCR1.Reg) & 0x1
}
func (o *OctoSPI_Type) SetDCR1_FRCK(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0x2)|value<<1)
}
func (o *OctoSPI_Type) GetDCR1_FRCK() uint32 {
	return (volatile.LoadUint32(&o.DCR1.Reg) & 0x2) >> 1
}
func (o *OctoSPI_Type) SetDCR1_CSHT(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0x3f00)|value<<8)
}
func (o *OctoSPI_Type) GetDCR1_CSHT() uint32 {
	return (volatile.LoadUint32(&o.DCR1.Reg) & 0x3f00) >> 8
}
func (o *OctoSPI_Type) SetDCR1_DEVSIZE(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0x1f0000)|value<<16)
}
func (o *OctoSPI_Type) GetDCR1_DEVSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCR1.Reg) & 0x1f0000) >> 16
}
func (o *OctoSPI_Type) SetDCR1_MTYP(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0x7000000)|value<<24)
}
func (o *OctoSPI_Type) GetDCR1_MTYP() uint32 {
	return (volatile.LoadUint32(&o.DCR1.Reg) & 0x7000000) >> 24
}
func (o *OctoSPI_Type) SetDCR1_DLYBYP(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0x8)|value<<3)
}
func (o *OctoSPI_Type) GetDCR1_DLYBYP() uint32 {
	return (volatile.LoadUint32(&o.DCR1.Reg) & 0x8) >> 3
}

// OctoSPI.DCR2: device configuration register 2
func (o *OctoSPI_Type) SetDCR2_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.DCR2.Reg, volatile.LoadUint32(&o.DCR2.Reg)&^(0xff)|value)
}
func (o *OctoSPI_Type) GetDCR2_PRESCALER() uint32 {
	return volatile.LoadUint32(&o.DCR2.Reg) & 0xff
}
func (o *OctoSPI_Type) SetDCR2_WRAPSIZE(value uint32) {
	volatile.StoreUint32(&o.DCR2.Reg, volatile.LoadUint32(&o.DCR2.Reg)&^(0x70000)|value<<16)
}
func (o *OctoSPI_Type) GetDCR2_WRAPSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCR2.Reg) & 0x70000) >> 16
}

// OctoSPI.DCR3: device configuration register 3
func (o *OctoSPI_Type) SetDCR3_MAXTRAN(value uint32) {
	volatile.StoreUint32(&o.DCR3.Reg, volatile.LoadUint32(&o.DCR3.Reg)&^(0xff)|value)
}
func (o *OctoSPI_Type) GetDCR3_MAXTRAN() uint32 {
	return volatile.LoadUint32(&o.DCR3.Reg) & 0xff
}
func (o *OctoSPI_Type) SetDCR3_CSBOUND(value uint32) {
	volatile.StoreUint32(&o.DCR3.Reg, volatile.LoadUint32(&o.DCR3.Reg)&^(0x1f0000)|value<<16)
}
func (o *OctoSPI_Type) GetDCR3_CSBOUND() uint32 {
	return (volatile.LoadUint32(&o.DCR3.Reg) & 0x1f0000) >> 16
}

// OctoSPI.DCR4: DCR4
func (o *OctoSPI_Type) SetDCR4(value uint32) {
	volatile.StoreUint32(&o.DCR4.Reg, value)
}
func (o *OctoSPI_Type) GetDCR4() uint32 {
	return volatile.LoadUint32(&o.DCR4.Reg)
}

// OctoSPI.SR: status register
func (o *OctoSPI_Type) SetSR_TEF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *OctoSPI_Type) GetSR_TEF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *OctoSPI_Type) SetSR_TCF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *OctoSPI_Type) GetSR_TCF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *OctoSPI_Type) SetSR_SMF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *OctoSPI_Type) GetSR_SMF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *OctoSPI_Type) SetSR_TOF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *OctoSPI_Type) GetSR_TOF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *OctoSPI_Type) SetSR_FTF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *OctoSPI_Type) GetSR_FTF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *OctoSPI_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *OctoSPI_Type) GetSR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *OctoSPI_Type) SetSR_FLEVEL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x3f00)|value<<8)
}
func (o *OctoSPI_Type) GetSR_FLEVEL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x3f00) >> 8
}

// OctoSPI.FCR: flag clear register
func (o *OctoSPI_Type) SetFCR_CTEF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x1)|value)
}
func (o *OctoSPI_Type) GetFCR_CTEF() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0x1
}
func (o *OctoSPI_Type) SetFCR_CTCF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x2)|value<<1)
}
func (o *OctoSPI_Type) GetFCR_CTCF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x2) >> 1
}
func (o *OctoSPI_Type) SetFCR_CSMF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x8)|value<<3)
}
func (o *OctoSPI_Type) GetFCR_CSMF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x8) >> 3
}
func (o *OctoSPI_Type) SetFCR_CTOF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x10)|value<<4)
}
func (o *OctoSPI_Type) GetFCR_CTOF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x10) >> 4
}

// OctoSPI.DLR: data length register
func (o *OctoSPI_Type) SetDLR(value uint32) {
	volatile.StoreUint32(&o.DLR.Reg, value)
}
func (o *OctoSPI_Type) GetDLR() uint32 {
	return volatile.LoadUint32(&o.DLR.Reg)
}

// OctoSPI.AR: address register
func (o *OctoSPI_Type) SetAR(value uint32) {
	volatile.StoreUint32(&o.AR.Reg, value)
}
func (o *OctoSPI_Type) GetAR() uint32 {
	return volatile.LoadUint32(&o.AR.Reg)
}

// OctoSPI.DR: data register
func (o *OctoSPI_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *OctoSPI_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// OctoSPI.PSMKR: polling status mask register
func (o *OctoSPI_Type) SetPSMKR(value uint32) {
	volatile.StoreUint32(&o.PSMKR.Reg, value)
}
func (o *OctoSPI_Type) GetPSMKR() uint32 {
	return volatile.LoadUint32(&o.PSMKR.Reg)
}

// OctoSPI.PSMAR: polling status match register
func (o *OctoSPI_Type) SetPSMAR(value uint32) {
	volatile.StoreUint32(&o.PSMAR.Reg, value)
}
func (o *OctoSPI_Type) GetPSMAR() uint32 {
	return volatile.LoadUint32(&o.PSMAR.Reg)
}

// OctoSPI.PIR: OCTOSPI polling interval register
func (o *OctoSPI_Type) SetPIR_INTERVAL(value uint32) {
	volatile.StoreUint32(&o.PIR.Reg, volatile.LoadUint32(&o.PIR.Reg)&^(0xffff)|value)
}
func (o *OctoSPI_Type) GetPIR_INTERVAL() uint32 {
	return volatile.LoadUint32(&o.PIR.Reg) & 0xffff
}

// OctoSPI.CCR: polling interval register
func (o *OctoSPI_Type) SetCCR_IMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x7)|value)
}
func (o *OctoSPI_Type) GetCCR_IMODE() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x7
}
func (o *OctoSPI_Type) SetCCR_IDTR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8)|value<<3)
}
func (o *OctoSPI_Type) GetCCR_IDTR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8) >> 3
}
func (o *OctoSPI_Type) SetCCR_ISIZE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x30)|value<<4)
}
func (o *OctoSPI_Type) GetCCR_ISIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x30) >> 4
}
func (o *OctoSPI_Type) SetCCR_ADMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x700)|value<<8)
}
func (o *OctoSPI_Type) GetCCR_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x700) >> 8
}
func (o *OctoSPI_Type) SetCCR_ADDTR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x800)|value<<11)
}
func (o *OctoSPI_Type) GetCCR_ADDTR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x800) >> 11
}
func (o *OctoSPI_Type) SetCCR_ADSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x3000)|value<<12)
}
func (o *OctoSPI_Type) GetCCR_ADSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x3000) >> 12
}
func (o *OctoSPI_Type) SetCCR_ABMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x70000)|value<<16)
}
func (o *OctoSPI_Type) GetCCR_ABMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x70000) >> 16
}
func (o *OctoSPI_Type) SetCCR_ABDTR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x80000)|value<<19)
}
func (o *OctoSPI_Type) GetCCR_ABDTR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x80000) >> 19
}
func (o *OctoSPI_Type) SetCCR_ABSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x300000)|value<<20)
}
func (o *OctoSPI_Type) GetCCR_ABSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x300000) >> 20
}
func (o *OctoSPI_Type) SetCCR_DMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x7000000)|value<<24)
}
func (o *OctoSPI_Type) GetCCR_DMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x7000000) >> 24
}
func (o *OctoSPI_Type) SetCCR_DDTR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8000000)|value<<27)
}
func (o *OctoSPI_Type) GetCCR_DDTR() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8000000) >> 27
}
func (o *OctoSPI_Type) SetCCR_DQSE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x20000000)|value<<29)
}
func (o *OctoSPI_Type) GetCCR_DQSE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x20000000) >> 29
}
func (o *OctoSPI_Type) SetCCR_SIOO(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x80000000)|value<<31)
}
func (o *OctoSPI_Type) GetCCR_SIOO() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x80000000) >> 31
}

// OctoSPI.TCR: communication configuration register
func (o *OctoSPI_Type) SetTCR_DCYC(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x1f)|value)
}
func (o *OctoSPI_Type) GetTCR_DCYC() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0x1f
}
func (o *OctoSPI_Type) SetTCR_DHQC(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x10000000)|value<<28)
}
func (o *OctoSPI_Type) GetTCR_DHQC() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x10000000) >> 28
}
func (o *OctoSPI_Type) SetTCR_SSHIFT(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x40000000)|value<<30)
}
func (o *OctoSPI_Type) GetTCR_SSHIFT() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x40000000) >> 30
}

// OctoSPI.IR: timing configuration register
func (o *OctoSPI_Type) SetIR(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, value)
}
func (o *OctoSPI_Type) GetIR() uint32 {
	return volatile.LoadUint32(&o.IR.Reg)
}

// OctoSPI.ABR: instruction register
func (o *OctoSPI_Type) SetABR(value uint32) {
	volatile.StoreUint32(&o.ABR.Reg, value)
}
func (o *OctoSPI_Type) GetABR() uint32 {
	return volatile.LoadUint32(&o.ABR.Reg)
}

// OctoSPI.LPTR: alternate bytes register
func (o *OctoSPI_Type) SetLPTR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.LPTR.Reg, volatile.LoadUint32(&o.LPTR.Reg)&^(0xffff)|value)
}
func (o *OctoSPI_Type) GetLPTR_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.LPTR.Reg) & 0xffff
}

// OctoSPI.WPCCR: low-power timeout register
func (o *OctoSPI_Type) SetWPCCR_IMODE(value uint32) {
	volatile.StoreUint32(&o.WPCCR.Reg, volatile.LoadUint32(&o.WPCCR.Reg)&^(0x7)|value)
}
func (o *OctoSPI_Type) GetWPCCR_IMODE() uint32 {
	return volatile.LoadUint32(&o.WPCCR.Reg) & 0x7
}
func (o *OctoSPI_Type) SetWPCCR_IDTR(value uint32) {
	volatile.StoreUint32(&o.WPCCR.Reg, volatile.LoadUint32(&o.WPCCR.Reg)&^(0x8)|value<<3)
}
func (o *OctoSPI_Type) GetWPCCR_IDTR() uint32 {
	return (volatile.LoadUint32(&o.WPCCR.Reg) & 0x8) >> 3
}
func (o *OctoSPI_Type) SetWPCCR_ISIZE(value uint32) {
	volatile.StoreUint32(&o.WPCCR.Reg, volatile.LoadUint32(&o.WPCCR.Reg)&^(0x30)|value<<4)
}
func (o *OctoSPI_Type) GetWPCCR_ISIZE() uint32 {
	return (volatile.LoadUint32(&o.WPCCR.Reg) & 0x30) >> 4
}
func (o *OctoSPI_Type) SetWPCCR_ADMODE(value uint32) {
	volatile.StoreUint32(&o.WPCCR.Reg, volatile.LoadUint32(&o.WPCCR.Reg)&^(0x700)|value<<8)
}
func (o *OctoSPI_Type) GetWPCCR_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.WPCCR.Reg) & 0x700) >> 8
}
func (o *OctoSPI_Type) SetWPCCR_ADDTR(value uint32) {
	volatile.StoreUint32(&o.WPCCR.Reg, volatile.LoadUint32(&o.WPCCR.Reg)&^(0x800)|value<<11)
}
func (o *OctoSPI_Type) GetWPCCR_ADDTR() uint32 {
	return (volatile.LoadUint32(&o.WPCCR.Reg) & 0x800) >> 11
}
func (o *OctoSPI_Type) SetWPCCR_ADSIZE(value uint32) {
	volatile.StoreUint32(&o.WPCCR.Reg, volatile.LoadUint32(&o.WPCCR.Reg)&^(0x3000)|value<<12)
}
func (o *OctoSPI_Type) GetWPCCR_ADSIZE() uint32 {
	return (volatile.LoadUint32(&o.WPCCR.Reg) & 0x3000) >> 12
}
func (o *OctoSPI_Type) SetWPCCR_ABMODE(value uint32) {
	volatile.StoreUint32(&o.WPCCR.Reg, volatile.LoadUint32(&o.WPCCR.Reg)&^(0x70000)|value<<16)
}
func (o *OctoSPI_Type) GetWPCCR_ABMODE() uint32 {
	return (volatile.LoadUint32(&o.WPCCR.Reg) & 0x70000) >> 16
}
func (o *OctoSPI_Type) SetWPCCR_ABDTR(value uint32) {
	volatile.StoreUint32(&o.WPCCR.Reg, volatile.LoadUint32(&o.WPCCR.Reg)&^(0x80000)|value<<19)
}
func (o *OctoSPI_Type) GetWPCCR_ABDTR() uint32 {
	return (volatile.LoadUint32(&o.WPCCR.Reg) & 0x80000) >> 19
}
func (o *OctoSPI_Type) SetWPCCR_ABSIZE(value uint32) {
	volatile.StoreUint32(&o.WPCCR.Reg, volatile.LoadUint32(&o.WPCCR.Reg)&^(0x300000)|value<<20)
}
func (o *OctoSPI_Type) GetWPCCR_ABSIZE() uint32 {
	return (volatile.LoadUint32(&o.WPCCR.Reg) & 0x300000) >> 20
}
func (o *OctoSPI_Type) SetWPCCR_DMODE(value uint32) {
	volatile.StoreUint32(&o.WPCCR.Reg, volatile.LoadUint32(&o.WPCCR.Reg)&^(0x7000000)|value<<24)
}
func (o *OctoSPI_Type) GetWPCCR_DMODE() uint32 {
	return (volatile.LoadUint32(&o.WPCCR.Reg) & 0x7000000) >> 24
}
func (o *OctoSPI_Type) SetWPCCR_DDTR(value uint32) {
	volatile.StoreUint32(&o.WPCCR.Reg, volatile.LoadUint32(&o.WPCCR.Reg)&^(0x8000000)|value<<27)
}
func (o *OctoSPI_Type) GetWPCCR_DDTR() uint32 {
	return (volatile.LoadUint32(&o.WPCCR.Reg) & 0x8000000) >> 27
}
func (o *OctoSPI_Type) SetWPCCR_DQSE(value uint32) {
	volatile.StoreUint32(&o.WPCCR.Reg, volatile.LoadUint32(&o.WPCCR.Reg)&^(0x20000000)|value<<29)
}
func (o *OctoSPI_Type) GetWPCCR_DQSE() uint32 {
	return (volatile.LoadUint32(&o.WPCCR.Reg) & 0x20000000) >> 29
}

// OctoSPI.WPTCR: wrap timing configuration register
func (o *OctoSPI_Type) SetWPTCR_DCYC(value uint32) {
	volatile.StoreUint32(&o.WPTCR.Reg, volatile.LoadUint32(&o.WPTCR.Reg)&^(0x1f)|value)
}
func (o *OctoSPI_Type) GetWPTCR_DCYC() uint32 {
	return volatile.LoadUint32(&o.WPTCR.Reg) & 0x1f
}
func (o *OctoSPI_Type) SetWPTCR_DHQC(value uint32) {
	volatile.StoreUint32(&o.WPTCR.Reg, volatile.LoadUint32(&o.WPTCR.Reg)&^(0x10000000)|value<<28)
}
func (o *OctoSPI_Type) GetWPTCR_DHQC() uint32 {
	return (volatile.LoadUint32(&o.WPTCR.Reg) & 0x10000000) >> 28
}
func (o *OctoSPI_Type) SetWPTCR_SSHIFT(value uint32) {
	volatile.StoreUint32(&o.WPTCR.Reg, volatile.LoadUint32(&o.WPTCR.Reg)&^(0x40000000)|value<<30)
}
func (o *OctoSPI_Type) GetWPTCR_SSHIFT() uint32 {
	return (volatile.LoadUint32(&o.WPTCR.Reg) & 0x40000000) >> 30
}

// OctoSPI.WPIR: wrap instruction register
func (o *OctoSPI_Type) SetWPIR(value uint32) {
	volatile.StoreUint32(&o.WPIR.Reg, value)
}
func (o *OctoSPI_Type) GetWPIR() uint32 {
	return volatile.LoadUint32(&o.WPIR.Reg)
}

// OctoSPI.WPABR: wrap alternate bytes register
func (o *OctoSPI_Type) SetWPABR(value uint32) {
	volatile.StoreUint32(&o.WPABR.Reg, value)
}
func (o *OctoSPI_Type) GetWPABR() uint32 {
	return volatile.LoadUint32(&o.WPABR.Reg)
}

// OctoSPI.WCCR: write communication configuration register
func (o *OctoSPI_Type) SetWCCR_IMODE(value uint32) {
	volatile.StoreUint32(&o.WCCR.Reg, volatile.LoadUint32(&o.WCCR.Reg)&^(0x3)|value)
}
func (o *OctoSPI_Type) GetWCCR_IMODE() uint32 {
	return volatile.LoadUint32(&o.WCCR.Reg) & 0x3
}
func (o *OctoSPI_Type) SetWCCR_IDTR(value uint32) {
	volatile.StoreUint32(&o.WCCR.Reg, volatile.LoadUint32(&o.WCCR.Reg)&^(0x4)|value<<2)
}
func (o *OctoSPI_Type) GetWCCR_IDTR() uint32 {
	return (volatile.LoadUint32(&o.WCCR.Reg) & 0x4) >> 2
}
func (o *OctoSPI_Type) SetWCCR_ISIZE(value uint32) {
	volatile.StoreUint32(&o.WCCR.Reg, volatile.LoadUint32(&o.WCCR.Reg)&^(0x8)|value<<3)
}
func (o *OctoSPI_Type) GetWCCR_ISIZE() uint32 {
	return (volatile.LoadUint32(&o.WCCR.Reg) & 0x8) >> 3
}
func (o *OctoSPI_Type) SetWCCR_ADMODE(value uint32) {
	volatile.StoreUint32(&o.WCCR.Reg, volatile.LoadUint32(&o.WCCR.Reg)&^(0x700)|value<<8)
}
func (o *OctoSPI_Type) GetWCCR_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.WCCR.Reg) & 0x700) >> 8
}
func (o *OctoSPI_Type) SetWCCR_ADDTR(value uint32) {
	volatile.StoreUint32(&o.WCCR.Reg, volatile.LoadUint32(&o.WCCR.Reg)&^(0x800)|value<<11)
}
func (o *OctoSPI_Type) GetWCCR_ADDTR() uint32 {
	return (volatile.LoadUint32(&o.WCCR.Reg) & 0x800) >> 11
}
func (o *OctoSPI_Type) SetWCCR_ADSIZE(value uint32) {
	volatile.StoreUint32(&o.WCCR.Reg, volatile.LoadUint32(&o.WCCR.Reg)&^(0x3000)|value<<12)
}
func (o *OctoSPI_Type) GetWCCR_ADSIZE() uint32 {
	return (volatile.LoadUint32(&o.WCCR.Reg) & 0x3000) >> 12
}
func (o *OctoSPI_Type) SetWCCR_ABMODE(value uint32) {
	volatile.StoreUint32(&o.WCCR.Reg, volatile.LoadUint32(&o.WCCR.Reg)&^(0x70000)|value<<16)
}
func (o *OctoSPI_Type) GetWCCR_ABMODE() uint32 {
	return (volatile.LoadUint32(&o.WCCR.Reg) & 0x70000) >> 16
}
func (o *OctoSPI_Type) SetWCCR_ABDTR(value uint32) {
	volatile.StoreUint32(&o.WCCR.Reg, volatile.LoadUint32(&o.WCCR.Reg)&^(0x80000)|value<<19)
}
func (o *OctoSPI_Type) GetWCCR_ABDTR() uint32 {
	return (volatile.LoadUint32(&o.WCCR.Reg) & 0x80000) >> 19
}
func (o *OctoSPI_Type) SetWCCR_ABSIZE(value uint32) {
	volatile.StoreUint32(&o.WCCR.Reg, volatile.LoadUint32(&o.WCCR.Reg)&^(0x300000)|value<<20)
}
func (o *OctoSPI_Type) GetWCCR_ABSIZE() uint32 {
	return (volatile.LoadUint32(&o.WCCR.Reg) & 0x300000) >> 20
}
func (o *OctoSPI_Type) SetWCCR_DMODE(value uint32) {
	volatile.StoreUint32(&o.WCCR.Reg, volatile.LoadUint32(&o.WCCR.Reg)&^(0x7000000)|value<<24)
}
func (o *OctoSPI_Type) GetWCCR_DMODE() uint32 {
	return (volatile.LoadUint32(&o.WCCR.Reg) & 0x7000000) >> 24
}
func (o *OctoSPI_Type) SetWCCR_DDTR(value uint32) {
	volatile.StoreUint32(&o.WCCR.Reg, volatile.LoadUint32(&o.WCCR.Reg)&^(0x8000000)|value<<27)
}
func (o *OctoSPI_Type) GetWCCR_DDTR() uint32 {
	return (volatile.LoadUint32(&o.WCCR.Reg) & 0x8000000) >> 27
}
func (o *OctoSPI_Type) SetWCCR_DQSE(value uint32) {
	volatile.StoreUint32(&o.WCCR.Reg, volatile.LoadUint32(&o.WCCR.Reg)&^(0x20000000)|value<<29)
}
func (o *OctoSPI_Type) GetWCCR_DQSE() uint32 {
	return (volatile.LoadUint32(&o.WCCR.Reg) & 0x20000000) >> 29
}

// OctoSPI.WTCR: write timing configuration register
func (o *OctoSPI_Type) SetWTCR_DCYC(value uint32) {
	volatile.StoreUint32(&o.WTCR.Reg, volatile.LoadUint32(&o.WTCR.Reg)&^(0x1f)|value)
}
func (o *OctoSPI_Type) GetWTCR_DCYC() uint32 {
	return volatile.LoadUint32(&o.WTCR.Reg) & 0x1f
}

// OctoSPI.WIR: instruction register
func (o *OctoSPI_Type) SetWIR(value uint32) {
	volatile.StoreUint32(&o.WIR.Reg, value)
}
func (o *OctoSPI_Type) GetWIR() uint32 {
	return volatile.LoadUint32(&o.WIR.Reg)
}

// OctoSPI.WABR: write alternate bytes register
func (o *OctoSPI_Type) SetWABR(value uint32) {
	volatile.StoreUint32(&o.WABR.Reg, value)
}
func (o *OctoSPI_Type) GetWABR() uint32 {
	return volatile.LoadUint32(&o.WABR.Reg)
}

// OctoSPI.HLCR: HyperBusTM latency configuration register
func (o *OctoSPI_Type) SetHLCR_LM(value uint32) {
	volatile.StoreUint32(&o.HLCR.Reg, volatile.LoadUint32(&o.HLCR.Reg)&^(0x1)|value)
}
func (o *OctoSPI_Type) GetHLCR_LM() uint32 {
	return volatile.LoadUint32(&o.HLCR.Reg) & 0x1
}
func (o *OctoSPI_Type) SetHLCR_WZL(value uint32) {
	volatile.StoreUint32(&o.HLCR.Reg, volatile.LoadUint32(&o.HLCR.Reg)&^(0x2)|value<<1)
}
func (o *OctoSPI_Type) GetHLCR_WZL() uint32 {
	return (volatile.LoadUint32(&o.HLCR.Reg) & 0x2) >> 1
}
func (o *OctoSPI_Type) SetHLCR_TACC(value uint32) {
	volatile.StoreUint32(&o.HLCR.Reg, volatile.LoadUint32(&o.HLCR.Reg)&^(0xff00)|value<<8)
}
func (o *OctoSPI_Type) GetHLCR_TACC() uint32 {
	return (volatile.LoadUint32(&o.HLCR.Reg) & 0xff00) >> 8
}
func (o *OctoSPI_Type) SetHLCR_TRWR(value uint32) {
	volatile.StoreUint32(&o.HLCR.Reg, volatile.LoadUint32(&o.HLCR.Reg)&^(0xff0000)|value<<16)
}
func (o *OctoSPI_Type) GetHLCR_TRWR() uint32 {
	return (volatile.LoadUint32(&o.HLCR.Reg) & 0xff0000) >> 16
}

// Operational amplifiers
type OPAMP_Type struct {
	OPAMP1_CSR   volatile.Register32 // 0x0
	OPAMP1_OTR   volatile.Register32 // 0x4
	OPAMP1_HSOTR volatile.Register32 // 0x8
	_            [4]byte
	OPAMP2_CSR   volatile.Register32 // 0x10
	OPAMP2_OTR   volatile.Register32 // 0x14
	OPAMP2_HSOTR volatile.Register32 // 0x18
}

// OPAMP.OPAMP1_CSR: OPAMP1 control/status register
func (o *OPAMP_Type) SetOPAMP1_CSR_OPAEN(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x1)|value)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_OPAEN() uint32 {
	return volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x1
}
func (o *OPAMP_Type) SetOPAMP1_CSR_FORCE_VP(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x2)|value<<1)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_FORCE_VP() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x2) >> 1
}
func (o *OPAMP_Type) SetOPAMP1_CSR_VP_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0xc)|value<<2)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_VP_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0xc) >> 2
}
func (o *OPAMP_Type) SetOPAMP1_CSR_VM_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x60)|value<<5)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_VM_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x60) >> 5
}
func (o *OPAMP_Type) SetOPAMP1_CSR_OPAHSM(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x100)|value<<8)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_OPAHSM() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x100) >> 8
}
func (o *OPAMP_Type) SetOPAMP1_CSR_CALON(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x800)|value<<11)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_CALON() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x800) >> 11
}
func (o *OPAMP_Type) SetOPAMP1_CSR_CALSEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x3000)|value<<12)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_CALSEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x3000) >> 12
}
func (o *OPAMP_Type) SetOPAMP1_CSR_PGA_GAIN(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x3c000)|value<<14)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_PGA_GAIN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x3c000) >> 14
}
func (o *OPAMP_Type) SetOPAMP1_CSR_USERTRIM(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x40000)|value<<18)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_USERTRIM() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x40000) >> 18
}
func (o *OPAMP_Type) SetOPAMP1_CSR_TSTREF(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x20000000)|value<<29)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_TSTREF() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x20000000) >> 29
}
func (o *OPAMP_Type) SetOPAMP1_CSR_CALOUT(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_CSR.Reg, volatile.LoadUint32(&o.OPAMP1_CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *OPAMP_Type) GetOPAMP1_CSR_CALOUT() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_CSR.Reg) & 0x40000000) >> 30
}

// OPAMP.OPAMP1_OTR: OPAMP1 offset trimming register in normal mode
func (o *OPAMP_Type) SetOPAMP1_OTR_TRIMOFFSETN(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_OTR.Reg, volatile.LoadUint32(&o.OPAMP1_OTR.Reg)&^(0x1f)|value)
}
func (o *OPAMP_Type) GetOPAMP1_OTR_TRIMOFFSETN() uint32 {
	return volatile.LoadUint32(&o.OPAMP1_OTR.Reg) & 0x1f
}
func (o *OPAMP_Type) SetOPAMP1_OTR_TRIMOFFSETP(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_OTR.Reg, volatile.LoadUint32(&o.OPAMP1_OTR.Reg)&^(0x1f00)|value<<8)
}
func (o *OPAMP_Type) GetOPAMP1_OTR_TRIMOFFSETP() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_OTR.Reg) & 0x1f00) >> 8
}

// OPAMP.OPAMP1_HSOTR: OPAMP1 offset trimming register in low-power mode
func (o *OPAMP_Type) SetOPAMP1_HSOTR_TRIMLPOFFSETN(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_HSOTR.Reg, volatile.LoadUint32(&o.OPAMP1_HSOTR.Reg)&^(0x1f)|value)
}
func (o *OPAMP_Type) GetOPAMP1_HSOTR_TRIMLPOFFSETN() uint32 {
	return volatile.LoadUint32(&o.OPAMP1_HSOTR.Reg) & 0x1f
}
func (o *OPAMP_Type) SetOPAMP1_HSOTR_TRIMLPOFFSETP(value uint32) {
	volatile.StoreUint32(&o.OPAMP1_HSOTR.Reg, volatile.LoadUint32(&o.OPAMP1_HSOTR.Reg)&^(0x1f00)|value<<8)
}
func (o *OPAMP_Type) GetOPAMP1_HSOTR_TRIMLPOFFSETP() uint32 {
	return (volatile.LoadUint32(&o.OPAMP1_HSOTR.Reg) & 0x1f00) >> 8
}

// OPAMP.OPAMP2_CSR: OPAMP2 control/status register
func (o *OPAMP_Type) SetOPAMP2_CSR_OPAEN(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x1)|value)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_OPAEN() uint32 {
	return volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x1
}
func (o *OPAMP_Type) SetOPAMP2_CSR_FORCE_VP(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x2)|value<<1)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_FORCE_VP() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x2) >> 1
}
func (o *OPAMP_Type) SetOPAMP2_CSR_VM_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x60)|value<<5)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_VM_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x60) >> 5
}
func (o *OPAMP_Type) SetOPAMP2_CSR_OPAHSM(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x100)|value<<8)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_OPAHSM() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x100) >> 8
}
func (o *OPAMP_Type) SetOPAMP2_CSR_CALON(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x800)|value<<11)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_CALON() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x800) >> 11
}
func (o *OPAMP_Type) SetOPAMP2_CSR_CALSEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x3000)|value<<12)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_CALSEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x3000) >> 12
}
func (o *OPAMP_Type) SetOPAMP2_CSR_PGA_GAIN(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x3c000)|value<<14)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_PGA_GAIN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x3c000) >> 14
}
func (o *OPAMP_Type) SetOPAMP2_CSR_USERTRIM(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x40000)|value<<18)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_USERTRIM() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x40000) >> 18
}
func (o *OPAMP_Type) SetOPAMP2_CSR_TSTREF(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x20000000)|value<<29)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_TSTREF() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x20000000) >> 29
}
func (o *OPAMP_Type) SetOPAMP2_CSR_CALOUT(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_CALOUT() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x40000000) >> 30
}

// OPAMP.OPAMP2_OTR: OPAMP2 offset trimming register in normal mode
func (o *OPAMP_Type) SetOPAMP2_OTR_TRIMOFFSETN(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_OTR.Reg, volatile.LoadUint32(&o.OPAMP2_OTR.Reg)&^(0x1f)|value)
}
func (o *OPAMP_Type) GetOPAMP2_OTR_TRIMOFFSETN() uint32 {
	return volatile.LoadUint32(&o.OPAMP2_OTR.Reg) & 0x1f
}
func (o *OPAMP_Type) SetOPAMP2_OTR_TRIMOFFSETP(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_OTR.Reg, volatile.LoadUint32(&o.OPAMP2_OTR.Reg)&^(0x1f00)|value<<8)
}
func (o *OPAMP_Type) GetOPAMP2_OTR_TRIMOFFSETP() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_OTR.Reg) & 0x1f00) >> 8
}

// OPAMP.OPAMP2_HSOTR: OPAMP2 offset trimming register in low-power mode
func (o *OPAMP_Type) SetOPAMP2_HSOTR_TRIMLPOFFSETN(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_HSOTR.Reg, volatile.LoadUint32(&o.OPAMP2_HSOTR.Reg)&^(0x1f)|value)
}
func (o *OPAMP_Type) GetOPAMP2_HSOTR_TRIMLPOFFSETN() uint32 {
	return volatile.LoadUint32(&o.OPAMP2_HSOTR.Reg) & 0x1f
}
func (o *OPAMP_Type) SetOPAMP2_HSOTR_TRIMLPOFFSETP(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_HSOTR.Reg, volatile.LoadUint32(&o.OPAMP2_HSOTR.Reg)&^(0x1f00)|value<<8)
}
func (o *OPAMP_Type) GetOPAMP2_HSOTR_TRIMLPOFFSETP() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_HSOTR.Reg) & 0x1f00) >> 8
}

// USB 1 on the go high speed
type USB_OTG_HS_Type struct {
	DCFG        volatile.Register32 // 0x0
	DCTL        volatile.Register32 // 0x4
	DSTS        volatile.Register32 // 0x8
	_           [4]byte
	DIEPMSK     volatile.Register32 // 0x10
	DOEPMSK     volatile.Register32 // 0x14
	DAINT       volatile.Register32 // 0x18
	DAINTMSK    volatile.Register32 // 0x1C
	_           [8]byte
	DVBUSDIS    volatile.Register32 // 0x28
	DVBUSPULSE  volatile.Register32 // 0x2C
	DTHRCTL     volatile.Register32 // 0x30
	DIEPEMPMSK  volatile.Register32 // 0x34
	DEACHINT    volatile.Register32 // 0x38
	DEACHINTMSK volatile.Register32 // 0x3C
	_           [192]byte
	DIEPCTL0    volatile.Register32 // 0x100
	_           [4]byte
	DIEPINT0    volatile.Register32 // 0x108
	_           [4]byte
	DIEPTSIZ0   volatile.Register32 // 0x110
	DIEPDMA1    volatile.Register32 // 0x114
	DTXFSTS0    volatile.Register32 // 0x118
	_           [4]byte
	DIEPCTL1    volatile.Register32 // 0x120
	_           [4]byte
	DIEPINT1    volatile.Register32 // 0x128
	_           [4]byte
	DIEPTSIZ1   volatile.Register32 // 0x130
	DIEPDMA2    volatile.Register32 // 0x134
	DTXFSTS1    volatile.Register32 // 0x138
	_           [4]byte
	DIEPCTL2    volatile.Register32 // 0x140
	_           [4]byte
	DIEPINT2    volatile.Register32 // 0x148
	_           [4]byte
	DIEPTSIZ2   volatile.Register32 // 0x150
	DIEPDMA3    volatile.Register32 // 0x154
	DTXFSTS2    volatile.Register32 // 0x158
	_           [4]byte
	DIEPCTL3    volatile.Register32 // 0x160
	_           [4]byte
	DIEPINT3    volatile.Register32 // 0x168
	_           [4]byte
	DIEPTSIZ3   volatile.Register32 // 0x170
	DIEPDMA4    volatile.Register32 // 0x174
	DTXFSTS3    volatile.Register32 // 0x178
	_           [4]byte
	DIEPCTL4    volatile.Register32 // 0x180
	_           [4]byte
	DIEPINT4    volatile.Register32 // 0x188
	_           [4]byte
	DIEPTSIZ4   volatile.Register32 // 0x190
	DIEPDMA5    volatile.Register32 // 0x194
	DTXFSTS4    volatile.Register32 // 0x198
	_           [4]byte
	DIEPCTL5    volatile.Register32 // 0x1A0
	DTXFSTS6    volatile.Register32 // 0x1A4
	DIEPINT5    volatile.Register32 // 0x1A8
	DTXFSTS7    volatile.Register32 // 0x1AC
	DIEPTSIZ5   volatile.Register32 // 0x1B0
	_           [4]byte
	DTXFSTS5    volatile.Register32 // 0x1B8
	_           [4]byte
	DIEPCTL6    volatile.Register32 // 0x1C0
	_           [4]byte
	DIEPINT6    volatile.Register32 // 0x1C8
	_           [20]byte
	DIEPCTL7    volatile.Register32 // 0x1E0
	_           [4]byte
	DIEPINT7    volatile.Register32 // 0x1E8
	_           [276]byte
	DOEPCTL0    volatile.Register32 // 0x300
	_           [4]byte
	DOEPINT0    volatile.Register32 // 0x308
	_           [4]byte
	DOEPTSIZ0   volatile.Register32 // 0x310
	_           [12]byte
	DOEPCTL1    volatile.Register32 // 0x320
	_           [4]byte
	DOEPINT1    volatile.Register32 // 0x328
	_           [4]byte
	DOEPTSIZ1   volatile.Register32 // 0x330
	_           [12]byte
	DOEPCTL2    volatile.Register32 // 0x340
	_           [4]byte
	DOEPINT2    volatile.Register32 // 0x348
	_           [4]byte
	DOEPTSIZ2   volatile.Register32 // 0x350
	_           [12]byte
	DOEPCTL3    volatile.Register32 // 0x360
	_           [4]byte
	DOEPINT3    volatile.Register32 // 0x368
	_           [4]byte
	DOEPTSIZ3   volatile.Register32 // 0x370
	_           [12]byte
	DOEPCTL4    volatile.Register32 // 0x380
	_           [4]byte
	DOEPINT4    volatile.Register32 // 0x388
	_           [4]byte
	DOEPTSIZ4   volatile.Register32 // 0x390
	_           [12]byte
	DOEPCTL5    volatile.Register32 // 0x3A0
	_           [4]byte
	DOEPINT5    volatile.Register32 // 0x3A8
	_           [4]byte
	DOEPTSIZ5   volatile.Register32 // 0x3B0
	_           [12]byte
	DOEPCTL6    volatile.Register32 // 0x3C0
	_           [4]byte
	DOEPINT6    volatile.Register32 // 0x3C8
	_           [4]byte
	DOEPTSIZ6   volatile.Register32 // 0x3D0
	_           [12]byte
	DOEPCTL7    volatile.Register32 // 0x3E0
	_           [4]byte
	DOEPINT7    volatile.Register32 // 0x3E8
	_           [4]byte
	DOEPTSIZ7   volatile.Register32 // 0x3F0
}

// USB_OTG_HS.DCFG: OTG_HS device configuration register
func (o *USB_OTG_HS_Type) SetDCFG_DSPD(value uint32) {
	volatile.StoreUint32(&o.DCFG.Reg, volatile.LoadUint32(&o.DCFG.Reg)&^(0x3)|value)
}
func (o *USB_OTG_HS_Type) GetDCFG_DSPD() uint32 {
	return volatile.LoadUint32(&o.DCFG.Reg) & 0x3
}
func (o *USB_OTG_HS_Type) SetDCFG_NZLSOHSK(value uint32) {
	volatile.StoreUint32(&o.DCFG.Reg, volatile.LoadUint32(&o.DCFG.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetDCFG_NZLSOHSK() uint32 {
	return (volatile.LoadUint32(&o.DCFG.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetDCFG_DAD(value uint32) {
	volatile.StoreUint32(&o.DCFG.Reg, volatile.LoadUint32(&o.DCFG.Reg)&^(0x7f0)|value<<4)
}
func (o *USB_OTG_HS_Type) GetDCFG_DAD() uint32 {
	return (volatile.LoadUint32(&o.DCFG.Reg) & 0x7f0) >> 4
}
func (o *USB_OTG_HS_Type) SetDCFG_PFIVL(value uint32) {
	volatile.StoreUint32(&o.DCFG.Reg, volatile.LoadUint32(&o.DCFG.Reg)&^(0x1800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetDCFG_PFIVL() uint32 {
	return (volatile.LoadUint32(&o.DCFG.Reg) & 0x1800) >> 11
}
func (o *USB_OTG_HS_Type) SetDCFG_PERSCHIVL(value uint32) {
	volatile.StoreUint32(&o.DCFG.Reg, volatile.LoadUint32(&o.DCFG.Reg)&^(0x3000000)|value<<24)
}
func (o *USB_OTG_HS_Type) GetDCFG_PERSCHIVL() uint32 {
	return (volatile.LoadUint32(&o.DCFG.Reg) & 0x3000000) >> 24
}

// USB_OTG_HS.DCTL: OTG_HS device control register
func (o *USB_OTG_HS_Type) SetDCTL_RWUSIG(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetDCTL_RWUSIG() uint32 {
	return volatile.LoadUint32(&o.DCTL.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetDCTL_SDIS(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetDCTL_SDIS() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetDCTL_GINSTS(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetDCTL_GINSTS() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetDCTL_GONSTS(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetDCTL_GONSTS() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetDCTL_TCTL(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x70)|value<<4)
}
func (o *USB_OTG_HS_Type) GetDCTL_TCTL() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x70) >> 4
}
func (o *USB_OTG_HS_Type) SetDCTL_SGINAK(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetDCTL_SGINAK() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetDCTL_CGINAK(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetDCTL_CGINAK() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetDCTL_SGONAK(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetDCTL_SGONAK() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetDCTL_CGONAK(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetDCTL_CGONAK() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x400) >> 10
}
func (o *USB_OTG_HS_Type) SetDCTL_POPRGDNE(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetDCTL_POPRGDNE() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x800) >> 11
}

// USB_OTG_HS.DSTS: OTG_HS device status register
func (o *USB_OTG_HS_Type) SetDSTS_SUSPSTS(value uint32) {
	volatile.StoreUint32(&o.DSTS.Reg, volatile.LoadUint32(&o.DSTS.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetDSTS_SUSPSTS() uint32 {
	return volatile.LoadUint32(&o.DSTS.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetDSTS_ENUMSPD(value uint32) {
	volatile.StoreUint32(&o.DSTS.Reg, volatile.LoadUint32(&o.DSTS.Reg)&^(0x6)|value<<1)
}
func (o *USB_OTG_HS_Type) GetDSTS_ENUMSPD() uint32 {
	return (volatile.LoadUint32(&o.DSTS.Reg) & 0x6) >> 1
}
func (o *USB_OTG_HS_Type) SetDSTS_EERR(value uint32) {
	volatile.StoreUint32(&o.DSTS.Reg, volatile.LoadUint32(&o.DSTS.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetDSTS_EERR() uint32 {
	return (volatile.LoadUint32(&o.DSTS.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetDSTS_FNSOF(value uint32) {
	volatile.StoreUint32(&o.DSTS.Reg, volatile.LoadUint32(&o.DSTS.Reg)&^(0x3fff00)|value<<8)
}
func (o *USB_OTG_HS_Type) GetDSTS_FNSOF() uint32 {
	return (volatile.LoadUint32(&o.DSTS.Reg) & 0x3fff00) >> 8
}

// USB_OTG_HS.DIEPMSK: OTG_HS device IN endpoint common interrupt mask register
func (o *USB_OTG_HS_Type) SetDIEPMSK_XFRCM(value uint32) {
	volatile.StoreUint32(&o.DIEPMSK.Reg, volatile.LoadUint32(&o.DIEPMSK.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPMSK_XFRCM() uint32 {
	return volatile.LoadUint32(&o.DIEPMSK.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetDIEPMSK_EPDM(value uint32) {
	volatile.StoreUint32(&o.DIEPMSK.Reg, volatile.LoadUint32(&o.DIEPMSK.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetDIEPMSK_EPDM() uint32 {
	return (volatile.LoadUint32(&o.DIEPMSK.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetDIEPMSK_TOM(value uint32) {
	volatile.StoreUint32(&o.DIEPMSK.Reg, volatile.LoadUint32(&o.DIEPMSK.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetDIEPMSK_TOM() uint32 {
	return (volatile.LoadUint32(&o.DIEPMSK.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetDIEPMSK_ITTXFEMSK(value uint32) {
	volatile.StoreUint32(&o.DIEPMSK.Reg, volatile.LoadUint32(&o.DIEPMSK.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetDIEPMSK_ITTXFEMSK() uint32 {
	return (volatile.LoadUint32(&o.DIEPMSK.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetDIEPMSK_INEPNMM(value uint32) {
	volatile.StoreUint32(&o.DIEPMSK.Reg, volatile.LoadUint32(&o.DIEPMSK.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetDIEPMSK_INEPNMM() uint32 {
	return (volatile.LoadUint32(&o.DIEPMSK.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetDIEPMSK_INEPNEM(value uint32) {
	volatile.StoreUint32(&o.DIEPMSK.Reg, volatile.LoadUint32(&o.DIEPMSK.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetDIEPMSK_INEPNEM() uint32 {
	return (volatile.LoadUint32(&o.DIEPMSK.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetDIEPMSK_TXFURM(value uint32) {
	volatile.StoreUint32(&o.DIEPMSK.Reg, volatile.LoadUint32(&o.DIEPMSK.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetDIEPMSK_TXFURM() uint32 {
	return (volatile.LoadUint32(&o.DIEPMSK.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetDIEPMSK_BIM(value uint32) {
	volatile.StoreUint32(&o.DIEPMSK.Reg, volatile.LoadUint32(&o.DIEPMSK.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetDIEPMSK_BIM() uint32 {
	return (volatile.LoadUint32(&o.DIEPMSK.Reg) & 0x200) >> 9
}

// USB_OTG_HS.DOEPMSK: OTG_HS device OUT endpoint common interrupt mask register
func (o *USB_OTG_HS_Type) SetDOEPMSK_XFRCM(value uint32) {
	volatile.StoreUint32(&o.DOEPMSK.Reg, volatile.LoadUint32(&o.DOEPMSK.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetDOEPMSK_XFRCM() uint32 {
	return volatile.LoadUint32(&o.DOEPMSK.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetDOEPMSK_EPDM(value uint32) {
	volatile.StoreUint32(&o.DOEPMSK.Reg, volatile.LoadUint32(&o.DOEPMSK.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetDOEPMSK_EPDM() uint32 {
	return (volatile.LoadUint32(&o.DOEPMSK.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetDOEPMSK_STUPM(value uint32) {
	volatile.StoreUint32(&o.DOEPMSK.Reg, volatile.LoadUint32(&o.DOEPMSK.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetDOEPMSK_STUPM() uint32 {
	return (volatile.LoadUint32(&o.DOEPMSK.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetDOEPMSK_OTEPDM(value uint32) {
	volatile.StoreUint32(&o.DOEPMSK.Reg, volatile.LoadUint32(&o.DOEPMSK.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetDOEPMSK_OTEPDM() uint32 {
	return (volatile.LoadUint32(&o.DOEPMSK.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetDOEPMSK_B2BSTUP(value uint32) {
	volatile.StoreUint32(&o.DOEPMSK.Reg, volatile.LoadUint32(&o.DOEPMSK.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetDOEPMSK_B2BSTUP() uint32 {
	return (volatile.LoadUint32(&o.DOEPMSK.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetDOEPMSK_OPEM(value uint32) {
	volatile.StoreUint32(&o.DOEPMSK.Reg, volatile.LoadUint32(&o.DOEPMSK.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetDOEPMSK_OPEM() uint32 {
	return (volatile.LoadUint32(&o.DOEPMSK.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetDOEPMSK_BOIM(value uint32) {
	volatile.StoreUint32(&o.DOEPMSK.Reg, volatile.LoadUint32(&o.DOEPMSK.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetDOEPMSK_BOIM() uint32 {
	return (volatile.LoadUint32(&o.DOEPMSK.Reg) & 0x200) >> 9
}

// USB_OTG_HS.DAINT: OTG_HS device all endpoints interrupt register
func (o *USB_OTG_HS_Type) SetDAINT_IEPINT(value uint32) {
	volatile.StoreUint32(&o.DAINT.Reg, volatile.LoadUint32(&o.DAINT.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetDAINT_IEPINT() uint32 {
	return volatile.LoadUint32(&o.DAINT.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetDAINT_OEPINT(value uint32) {
	volatile.StoreUint32(&o.DAINT.Reg, volatile.LoadUint32(&o.DAINT.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetDAINT_OEPINT() uint32 {
	return (volatile.LoadUint32(&o.DAINT.Reg) & 0xffff0000) >> 16
}

// USB_OTG_HS.DAINTMSK: OTG_HS all endpoints interrupt mask register
func (o *USB_OTG_HS_Type) SetDAINTMSK_IEPM(value uint32) {
	volatile.StoreUint32(&o.DAINTMSK.Reg, volatile.LoadUint32(&o.DAINTMSK.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetDAINTMSK_IEPM() uint32 {
	return volatile.LoadUint32(&o.DAINTMSK.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetDAINTMSK_OEPM(value uint32) {
	volatile.StoreUint32(&o.DAINTMSK.Reg, volatile.LoadUint32(&o.DAINTMSK.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetDAINTMSK_OEPM() uint32 {
	return (volatile.LoadUint32(&o.DAINTMSK.Reg) & 0xffff0000) >> 16
}

// USB_OTG_HS.DVBUSDIS: OTG_HS device VBUS discharge time register
func (o *USB_OTG_HS_Type) SetDVBUSDIS_VBUSDT(value uint32) {
	volatile.StoreUint32(&o.DVBUSDIS.Reg, volatile.LoadUint32(&o.DVBUSDIS.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetDVBUSDIS_VBUSDT() uint32 {
	return volatile.LoadUint32(&o.DVBUSDIS.Reg) & 0xffff
}

// USB_OTG_HS.DVBUSPULSE: OTG_HS device VBUS pulsing time register
func (o *USB_OTG_HS_Type) SetDVBUSPULSE_DVBUSP(value uint32) {
	volatile.StoreUint32(&o.DVBUSPULSE.Reg, volatile.LoadUint32(&o.DVBUSPULSE.Reg)&^(0xfff)|value)
}
func (o *USB_OTG_HS_Type) GetDVBUSPULSE_DVBUSP() uint32 {
	return volatile.LoadUint32(&o.DVBUSPULSE.Reg) & 0xfff
}

// USB_OTG_HS.DTHRCTL: OTG_HS Device threshold control register
func (o *USB_OTG_HS_Type) SetDTHRCTL_NONISOTHREN(value uint32) {
	volatile.StoreUint32(&o.DTHRCTL.Reg, volatile.LoadUint32(&o.DTHRCTL.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetDTHRCTL_NONISOTHREN() uint32 {
	return volatile.LoadUint32(&o.DTHRCTL.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetDTHRCTL_ISOTHREN(value uint32) {
	volatile.StoreUint32(&o.DTHRCTL.Reg, volatile.LoadUint32(&o.DTHRCTL.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetDTHRCTL_ISOTHREN() uint32 {
	return (volatile.LoadUint32(&o.DTHRCTL.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetDTHRCTL_TXTHRLEN(value uint32) {
	volatile.StoreUint32(&o.DTHRCTL.Reg, volatile.LoadUint32(&o.DTHRCTL.Reg)&^(0x7fc)|value<<2)
}
func (o *USB_OTG_HS_Type) GetDTHRCTL_TXTHRLEN() uint32 {
	return (volatile.LoadUint32(&o.DTHRCTL.Reg) & 0x7fc) >> 2
}
func (o *USB_OTG_HS_Type) SetDTHRCTL_RXTHREN(value uint32) {
	volatile.StoreUint32(&o.DTHRCTL.Reg, volatile.LoadUint32(&o.DTHRCTL.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetDTHRCTL_RXTHREN() uint32 {
	return (volatile.LoadUint32(&o.DTHRCTL.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetDTHRCTL_RXTHRLEN(value uint32) {
	volatile.StoreUint32(&o.DTHRCTL.Reg, volatile.LoadUint32(&o.DTHRCTL.Reg)&^(0x3fe0000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetDTHRCTL_RXTHRLEN() uint32 {
	return (volatile.LoadUint32(&o.DTHRCTL.Reg) & 0x3fe0000) >> 17
}
func (o *USB_OTG_HS_Type) SetDTHRCTL_ARPEN(value uint32) {
	volatile.StoreUint32(&o.DTHRCTL.Reg, volatile.LoadUint32(&o.DTHRCTL.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_HS_Type) GetDTHRCTL_ARPEN() uint32 {
	return (volatile.LoadUint32(&o.DTHRCTL.Reg) & 0x8000000) >> 27
}

// USB_OTG_HS.DIEPEMPMSK: OTG_HS device IN endpoint FIFO empty interrupt mask register
func (o *USB_OTG_HS_Type) SetDIEPEMPMSK_INEPTXFEM(value uint32) {
	volatile.StoreUint32(&o.DIEPEMPMSK.Reg, volatile.LoadUint32(&o.DIEPEMPMSK.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPEMPMSK_INEPTXFEM() uint32 {
	return volatile.LoadUint32(&o.DIEPEMPMSK.Reg) & 0xffff
}

// USB_OTG_HS.DEACHINT: OTG_HS device each endpoint interrupt register
func (o *USB_OTG_HS_Type) SetDEACHINT_IEP1INT(value uint32) {
	volatile.StoreUint32(&o.DEACHINT.Reg, volatile.LoadUint32(&o.DEACHINT.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetDEACHINT_IEP1INT() uint32 {
	return (volatile.LoadUint32(&o.DEACHINT.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetDEACHINT_OEP1INT(value uint32) {
	volatile.StoreUint32(&o.DEACHINT.Reg, volatile.LoadUint32(&o.DEACHINT.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetDEACHINT_OEP1INT() uint32 {
	return (volatile.LoadUint32(&o.DEACHINT.Reg) & 0x20000) >> 17
}

// USB_OTG_HS.DEACHINTMSK: OTG_HS device each endpoint interrupt register mask
func (o *USB_OTG_HS_Type) SetDEACHINTMSK_IEP1INTM(value uint32) {
	volatile.StoreUint32(&o.DEACHINTMSK.Reg, volatile.LoadUint32(&o.DEACHINTMSK.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetDEACHINTMSK_IEP1INTM() uint32 {
	return (volatile.LoadUint32(&o.DEACHINTMSK.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetDEACHINTMSK_OEP1INTM(value uint32) {
	volatile.StoreUint32(&o.DEACHINTMSK.Reg, volatile.LoadUint32(&o.DEACHINTMSK.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetDEACHINTMSK_OEP1INTM() uint32 {
	return (volatile.LoadUint32(&o.DEACHINTMSK.Reg) & 0x20000) >> 17
}

// USB_OTG_HS.DIEPCTL0: OTG device endpoint-0 control register
func (o *USB_OTG_HS_Type) SetDIEPCTL0_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL0_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetDIEPCTL0_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL0_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetDIEPCTL0_EONUM_DPID(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL0_EONUM_DPID() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetDIEPCTL0_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL0_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetDIEPCTL0_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL0_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetDIEPCTL0_Stall(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL0_Stall() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_HS_Type) SetDIEPCTL0_TXFNUM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x3c00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL0_TXFNUM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x3c00000) >> 22
}
func (o *USB_OTG_HS_Type) SetDIEPCTL0_CNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL0_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_HS_Type) SetDIEPCTL0_SNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL0_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_HS_Type) SetDIEPCTL0_SD0PID_SEVNFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL0_SD0PID_SEVNFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_HS_Type) SetDIEPCTL0_SODDFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL0_SODDFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetDIEPCTL0_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL0_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetDIEPCTL0_EPENA(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL0_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.DIEPINT0: OTG device endpoint-0 interrupt register
func (o *USB_OTG_HS_Type) SetDIEPINT0_XFRC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPINT0_XFRC() uint32 {
	return volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetDIEPINT0_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetDIEPINT0_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetDIEPINT0_TOC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetDIEPINT0_TOC() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetDIEPINT0_ITTXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetDIEPINT0_ITTXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetDIEPINT0_INEPNE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetDIEPINT0_INEPNE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetDIEPINT0_TXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetDIEPINT0_TXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetDIEPINT0_TXFIFOUDRN(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetDIEPINT0_TXFIFOUDRN() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetDIEPINT0_BNA(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetDIEPINT0_BNA() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetDIEPINT0_PKTDRPSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetDIEPINT0_PKTDRPSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x800) >> 11
}
func (o *USB_OTG_HS_Type) SetDIEPINT0_BERR(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_HS_Type) GetDIEPINT0_BERR() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_HS_Type) SetDIEPINT0_NAK(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x2000)|value<<13)
}
func (o *USB_OTG_HS_Type) GetDIEPINT0_NAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x2000) >> 13
}

// USB_OTG_HS.DIEPTSIZ0: OTG_HS device IN endpoint 0 transfer size register
func (o *USB_OTG_HS_Type) SetDIEPTSIZ0_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ0.Reg, volatile.LoadUint32(&o.DIEPTSIZ0.Reg)&^(0x7f)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPTSIZ0_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPTSIZ0.Reg) & 0x7f
}
func (o *USB_OTG_HS_Type) SetDIEPTSIZ0_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ0.Reg, volatile.LoadUint32(&o.DIEPTSIZ0.Reg)&^(0x180000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetDIEPTSIZ0_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ0.Reg) & 0x180000) >> 19
}

// USB_OTG_HS.DIEPDMA1: OTG_HS device endpoint-1 DMA address register
func (o *USB_OTG_HS_Type) SetDIEPDMA1(value uint32) {
	volatile.StoreUint32(&o.DIEPDMA1.Reg, value)
}
func (o *USB_OTG_HS_Type) GetDIEPDMA1() uint32 {
	return volatile.LoadUint32(&o.DIEPDMA1.Reg)
}

// USB_OTG_HS.DTXFSTS0: OTG_HS device IN endpoint transmit FIFO status register
func (o *USB_OTG_HS_Type) SetDTXFSTS0_INEPTFSAV(value uint32) {
	volatile.StoreUint32(&o.DTXFSTS0.Reg, volatile.LoadUint32(&o.DTXFSTS0.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetDTXFSTS0_INEPTFSAV() uint32 {
	return volatile.LoadUint32(&o.DTXFSTS0.Reg) & 0xffff
}

// USB_OTG_HS.DIEPCTL1: OTG device endpoint-1 control register
func (o *USB_OTG_HS_Type) SetDIEPCTL1_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL1_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetDIEPCTL1_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL1_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetDIEPCTL1_EONUM_DPID(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL1_EONUM_DPID() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetDIEPCTL1_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL1_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetDIEPCTL1_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL1_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetDIEPCTL1_Stall(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL1_Stall() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_HS_Type) SetDIEPCTL1_TXFNUM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x3c00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL1_TXFNUM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x3c00000) >> 22
}
func (o *USB_OTG_HS_Type) SetDIEPCTL1_CNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL1_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_HS_Type) SetDIEPCTL1_SNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL1_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_HS_Type) SetDIEPCTL1_SD0PID_SEVNFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL1_SD0PID_SEVNFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_HS_Type) SetDIEPCTL1_SODDFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL1_SODDFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetDIEPCTL1_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL1_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetDIEPCTL1_EPENA(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL1_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.DIEPINT1: OTG device endpoint-1 interrupt register
func (o *USB_OTG_HS_Type) SetDIEPINT1_XFRC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPINT1_XFRC() uint32 {
	return volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetDIEPINT1_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetDIEPINT1_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetDIEPINT1_TOC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetDIEPINT1_TOC() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetDIEPINT1_ITTXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetDIEPINT1_ITTXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetDIEPINT1_INEPNE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetDIEPINT1_INEPNE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetDIEPINT1_TXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetDIEPINT1_TXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetDIEPINT1_TXFIFOUDRN(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetDIEPINT1_TXFIFOUDRN() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetDIEPINT1_BNA(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetDIEPINT1_BNA() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetDIEPINT1_PKTDRPSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetDIEPINT1_PKTDRPSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x800) >> 11
}
func (o *USB_OTG_HS_Type) SetDIEPINT1_BERR(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_HS_Type) GetDIEPINT1_BERR() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_HS_Type) SetDIEPINT1_NAK(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x2000)|value<<13)
}
func (o *USB_OTG_HS_Type) GetDIEPINT1_NAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x2000) >> 13
}

// USB_OTG_HS.DIEPTSIZ1: OTG_HS device endpoint transfer size register
func (o *USB_OTG_HS_Type) SetDIEPTSIZ1_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ1.Reg, volatile.LoadUint32(&o.DIEPTSIZ1.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPTSIZ1_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPTSIZ1.Reg) & 0x7ffff
}
func (o *USB_OTG_HS_Type) SetDIEPTSIZ1_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ1.Reg, volatile.LoadUint32(&o.DIEPTSIZ1.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetDIEPTSIZ1_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ1.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_HS_Type) SetDIEPTSIZ1_MCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ1.Reg, volatile.LoadUint32(&o.DIEPTSIZ1.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetDIEPTSIZ1_MCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ1.Reg) & 0x60000000) >> 29
}

// USB_OTG_HS.DIEPDMA2: OTG_HS device endpoint-2 DMA address register
func (o *USB_OTG_HS_Type) SetDIEPDMA2(value uint32) {
	volatile.StoreUint32(&o.DIEPDMA2.Reg, value)
}
func (o *USB_OTG_HS_Type) GetDIEPDMA2() uint32 {
	return volatile.LoadUint32(&o.DIEPDMA2.Reg)
}

// USB_OTG_HS.DTXFSTS1: OTG_HS device IN endpoint transmit FIFO status register
func (o *USB_OTG_HS_Type) SetDTXFSTS1_INEPTFSAV(value uint32) {
	volatile.StoreUint32(&o.DTXFSTS1.Reg, volatile.LoadUint32(&o.DTXFSTS1.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetDTXFSTS1_INEPTFSAV() uint32 {
	return volatile.LoadUint32(&o.DTXFSTS1.Reg) & 0xffff
}

// USB_OTG_HS.DIEPCTL2: OTG device endpoint-2 control register
func (o *USB_OTG_HS_Type) SetDIEPCTL2_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL2_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetDIEPCTL2_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL2_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetDIEPCTL2_EONUM_DPID(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL2_EONUM_DPID() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetDIEPCTL2_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL2_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetDIEPCTL2_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL2_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetDIEPCTL2_Stall(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL2_Stall() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_HS_Type) SetDIEPCTL2_TXFNUM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x3c00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL2_TXFNUM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x3c00000) >> 22
}
func (o *USB_OTG_HS_Type) SetDIEPCTL2_CNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL2_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_HS_Type) SetDIEPCTL2_SNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL2_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_HS_Type) SetDIEPCTL2_SD0PID_SEVNFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL2_SD0PID_SEVNFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_HS_Type) SetDIEPCTL2_SODDFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL2_SODDFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetDIEPCTL2_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL2_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetDIEPCTL2_EPENA(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL2_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.DIEPINT2: OTG device endpoint-2 interrupt register
func (o *USB_OTG_HS_Type) SetDIEPINT2_XFRC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPINT2_XFRC() uint32 {
	return volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetDIEPINT2_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetDIEPINT2_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetDIEPINT2_TOC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetDIEPINT2_TOC() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetDIEPINT2_ITTXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetDIEPINT2_ITTXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetDIEPINT2_INEPNE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetDIEPINT2_INEPNE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetDIEPINT2_TXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetDIEPINT2_TXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetDIEPINT2_TXFIFOUDRN(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetDIEPINT2_TXFIFOUDRN() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetDIEPINT2_BNA(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetDIEPINT2_BNA() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetDIEPINT2_PKTDRPSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetDIEPINT2_PKTDRPSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x800) >> 11
}
func (o *USB_OTG_HS_Type) SetDIEPINT2_BERR(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_HS_Type) GetDIEPINT2_BERR() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_HS_Type) SetDIEPINT2_NAK(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x2000)|value<<13)
}
func (o *USB_OTG_HS_Type) GetDIEPINT2_NAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x2000) >> 13
}

// USB_OTG_HS.DIEPTSIZ2: OTG_HS device endpoint transfer size register
func (o *USB_OTG_HS_Type) SetDIEPTSIZ2_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ2.Reg, volatile.LoadUint32(&o.DIEPTSIZ2.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPTSIZ2_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPTSIZ2.Reg) & 0x7ffff
}
func (o *USB_OTG_HS_Type) SetDIEPTSIZ2_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ2.Reg, volatile.LoadUint32(&o.DIEPTSIZ2.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetDIEPTSIZ2_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ2.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_HS_Type) SetDIEPTSIZ2_MCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ2.Reg, volatile.LoadUint32(&o.DIEPTSIZ2.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetDIEPTSIZ2_MCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ2.Reg) & 0x60000000) >> 29
}

// USB_OTG_HS.DIEPDMA3: OTG_HS device endpoint-3 DMA address register
func (o *USB_OTG_HS_Type) SetDIEPDMA3(value uint32) {
	volatile.StoreUint32(&o.DIEPDMA3.Reg, value)
}
func (o *USB_OTG_HS_Type) GetDIEPDMA3() uint32 {
	return volatile.LoadUint32(&o.DIEPDMA3.Reg)
}

// USB_OTG_HS.DTXFSTS2: OTG_HS device IN endpoint transmit FIFO status register
func (o *USB_OTG_HS_Type) SetDTXFSTS2_INEPTFSAV(value uint32) {
	volatile.StoreUint32(&o.DTXFSTS2.Reg, volatile.LoadUint32(&o.DTXFSTS2.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetDTXFSTS2_INEPTFSAV() uint32 {
	return volatile.LoadUint32(&o.DTXFSTS2.Reg) & 0xffff
}

// USB_OTG_HS.DIEPCTL3: OTG device endpoint-3 control register
func (o *USB_OTG_HS_Type) SetDIEPCTL3_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL3_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetDIEPCTL3_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL3_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetDIEPCTL3_EONUM_DPID(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL3_EONUM_DPID() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetDIEPCTL3_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL3_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetDIEPCTL3_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL3_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetDIEPCTL3_Stall(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL3_Stall() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_HS_Type) SetDIEPCTL3_TXFNUM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x3c00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL3_TXFNUM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x3c00000) >> 22
}
func (o *USB_OTG_HS_Type) SetDIEPCTL3_CNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL3_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_HS_Type) SetDIEPCTL3_SNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL3_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_HS_Type) SetDIEPCTL3_SD0PID_SEVNFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL3_SD0PID_SEVNFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_HS_Type) SetDIEPCTL3_SODDFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL3_SODDFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetDIEPCTL3_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL3_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetDIEPCTL3_EPENA(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL3_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.DIEPINT3: OTG device endpoint-3 interrupt register
func (o *USB_OTG_HS_Type) SetDIEPINT3_XFRC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPINT3_XFRC() uint32 {
	return volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetDIEPINT3_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetDIEPINT3_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetDIEPINT3_TOC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetDIEPINT3_TOC() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetDIEPINT3_ITTXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetDIEPINT3_ITTXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetDIEPINT3_INEPNE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetDIEPINT3_INEPNE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetDIEPINT3_TXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetDIEPINT3_TXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetDIEPINT3_TXFIFOUDRN(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetDIEPINT3_TXFIFOUDRN() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetDIEPINT3_BNA(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetDIEPINT3_BNA() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetDIEPINT3_PKTDRPSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetDIEPINT3_PKTDRPSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x800) >> 11
}
func (o *USB_OTG_HS_Type) SetDIEPINT3_BERR(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_HS_Type) GetDIEPINT3_BERR() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_HS_Type) SetDIEPINT3_NAK(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x2000)|value<<13)
}
func (o *USB_OTG_HS_Type) GetDIEPINT3_NAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x2000) >> 13
}

// USB_OTG_HS.DIEPTSIZ3: OTG_HS device endpoint transfer size register
func (o *USB_OTG_HS_Type) SetDIEPTSIZ3_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ3.Reg, volatile.LoadUint32(&o.DIEPTSIZ3.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPTSIZ3_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPTSIZ3.Reg) & 0x7ffff
}
func (o *USB_OTG_HS_Type) SetDIEPTSIZ3_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ3.Reg, volatile.LoadUint32(&o.DIEPTSIZ3.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetDIEPTSIZ3_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ3.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_HS_Type) SetDIEPTSIZ3_MCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ3.Reg, volatile.LoadUint32(&o.DIEPTSIZ3.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetDIEPTSIZ3_MCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ3.Reg) & 0x60000000) >> 29
}

// USB_OTG_HS.DIEPDMA4: OTG_HS device endpoint-4 DMA address register
func (o *USB_OTG_HS_Type) SetDIEPDMA4(value uint32) {
	volatile.StoreUint32(&o.DIEPDMA4.Reg, value)
}
func (o *USB_OTG_HS_Type) GetDIEPDMA4() uint32 {
	return volatile.LoadUint32(&o.DIEPDMA4.Reg)
}

// USB_OTG_HS.DTXFSTS3: OTG_HS device IN endpoint transmit FIFO status register
func (o *USB_OTG_HS_Type) SetDTXFSTS3_INEPTFSAV(value uint32) {
	volatile.StoreUint32(&o.DTXFSTS3.Reg, volatile.LoadUint32(&o.DTXFSTS3.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetDTXFSTS3_INEPTFSAV() uint32 {
	return volatile.LoadUint32(&o.DTXFSTS3.Reg) & 0xffff
}

// USB_OTG_HS.DIEPCTL4: OTG device endpoint-4 control register
func (o *USB_OTG_HS_Type) SetDIEPCTL4_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL4.Reg, volatile.LoadUint32(&o.DIEPCTL4.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL4_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPCTL4.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetDIEPCTL4_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL4.Reg, volatile.LoadUint32(&o.DIEPCTL4.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL4_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL4.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetDIEPCTL4_EONUM_DPID(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL4.Reg, volatile.LoadUint32(&o.DIEPCTL4.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL4_EONUM_DPID() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL4.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetDIEPCTL4_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL4.Reg, volatile.LoadUint32(&o.DIEPCTL4.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL4_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL4.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetDIEPCTL4_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL4.Reg, volatile.LoadUint32(&o.DIEPCTL4.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL4_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL4.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetDIEPCTL4_Stall(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL4.Reg, volatile.LoadUint32(&o.DIEPCTL4.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL4_Stall() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL4.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_HS_Type) SetDIEPCTL4_TXFNUM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL4.Reg, volatile.LoadUint32(&o.DIEPCTL4.Reg)&^(0x3c00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL4_TXFNUM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL4.Reg) & 0x3c00000) >> 22
}
func (o *USB_OTG_HS_Type) SetDIEPCTL4_CNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL4.Reg, volatile.LoadUint32(&o.DIEPCTL4.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL4_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL4.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_HS_Type) SetDIEPCTL4_SNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL4.Reg, volatile.LoadUint32(&o.DIEPCTL4.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL4_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL4.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_HS_Type) SetDIEPCTL4_SD0PID_SEVNFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL4.Reg, volatile.LoadUint32(&o.DIEPCTL4.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL4_SD0PID_SEVNFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL4.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_HS_Type) SetDIEPCTL4_SODDFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL4.Reg, volatile.LoadUint32(&o.DIEPCTL4.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL4_SODDFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL4.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetDIEPCTL4_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL4.Reg, volatile.LoadUint32(&o.DIEPCTL4.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL4_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL4.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetDIEPCTL4_EPENA(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL4.Reg, volatile.LoadUint32(&o.DIEPCTL4.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL4_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL4.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.DIEPINT4: OTG device endpoint-4 interrupt register
func (o *USB_OTG_HS_Type) SetDIEPINT4_XFRC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT4.Reg, volatile.LoadUint32(&o.DIEPINT4.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPINT4_XFRC() uint32 {
	return volatile.LoadUint32(&o.DIEPINT4.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetDIEPINT4_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DIEPINT4.Reg, volatile.LoadUint32(&o.DIEPINT4.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetDIEPINT4_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT4.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetDIEPINT4_TOC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT4.Reg, volatile.LoadUint32(&o.DIEPINT4.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetDIEPINT4_TOC() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT4.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetDIEPINT4_ITTXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT4.Reg, volatile.LoadUint32(&o.DIEPINT4.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetDIEPINT4_ITTXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT4.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetDIEPINT4_INEPNE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT4.Reg, volatile.LoadUint32(&o.DIEPINT4.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetDIEPINT4_INEPNE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT4.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetDIEPINT4_TXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT4.Reg, volatile.LoadUint32(&o.DIEPINT4.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetDIEPINT4_TXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT4.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetDIEPINT4_TXFIFOUDRN(value uint32) {
	volatile.StoreUint32(&o.DIEPINT4.Reg, volatile.LoadUint32(&o.DIEPINT4.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetDIEPINT4_TXFIFOUDRN() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT4.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetDIEPINT4_BNA(value uint32) {
	volatile.StoreUint32(&o.DIEPINT4.Reg, volatile.LoadUint32(&o.DIEPINT4.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetDIEPINT4_BNA() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT4.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetDIEPINT4_PKTDRPSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPINT4.Reg, volatile.LoadUint32(&o.DIEPINT4.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetDIEPINT4_PKTDRPSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT4.Reg) & 0x800) >> 11
}
func (o *USB_OTG_HS_Type) SetDIEPINT4_BERR(value uint32) {
	volatile.StoreUint32(&o.DIEPINT4.Reg, volatile.LoadUint32(&o.DIEPINT4.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_HS_Type) GetDIEPINT4_BERR() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT4.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_HS_Type) SetDIEPINT4_NAK(value uint32) {
	volatile.StoreUint32(&o.DIEPINT4.Reg, volatile.LoadUint32(&o.DIEPINT4.Reg)&^(0x2000)|value<<13)
}
func (o *USB_OTG_HS_Type) GetDIEPINT4_NAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT4.Reg) & 0x2000) >> 13
}

// USB_OTG_HS.DIEPTSIZ4: OTG_HS device endpoint transfer size register
func (o *USB_OTG_HS_Type) SetDIEPTSIZ4_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ4.Reg, volatile.LoadUint32(&o.DIEPTSIZ4.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPTSIZ4_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPTSIZ4.Reg) & 0x7ffff
}
func (o *USB_OTG_HS_Type) SetDIEPTSIZ4_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ4.Reg, volatile.LoadUint32(&o.DIEPTSIZ4.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetDIEPTSIZ4_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ4.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_HS_Type) SetDIEPTSIZ4_MCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ4.Reg, volatile.LoadUint32(&o.DIEPTSIZ4.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetDIEPTSIZ4_MCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ4.Reg) & 0x60000000) >> 29
}

// USB_OTG_HS.DIEPDMA5: OTG_HS device endpoint-5 DMA address register
func (o *USB_OTG_HS_Type) SetDIEPDMA5(value uint32) {
	volatile.StoreUint32(&o.DIEPDMA5.Reg, value)
}
func (o *USB_OTG_HS_Type) GetDIEPDMA5() uint32 {
	return volatile.LoadUint32(&o.DIEPDMA5.Reg)
}

// USB_OTG_HS.DTXFSTS4: OTG_HS device IN endpoint transmit FIFO status register
func (o *USB_OTG_HS_Type) SetDTXFSTS4_INEPTFSAV(value uint32) {
	volatile.StoreUint32(&o.DTXFSTS4.Reg, volatile.LoadUint32(&o.DTXFSTS4.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetDTXFSTS4_INEPTFSAV() uint32 {
	return volatile.LoadUint32(&o.DTXFSTS4.Reg) & 0xffff
}

// USB_OTG_HS.DIEPCTL5: OTG device endpoint-5 control register
func (o *USB_OTG_HS_Type) SetDIEPCTL5_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL5.Reg, volatile.LoadUint32(&o.DIEPCTL5.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL5_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPCTL5.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetDIEPCTL5_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL5.Reg, volatile.LoadUint32(&o.DIEPCTL5.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL5_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL5.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetDIEPCTL5_EONUM_DPID(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL5.Reg, volatile.LoadUint32(&o.DIEPCTL5.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL5_EONUM_DPID() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL5.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetDIEPCTL5_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL5.Reg, volatile.LoadUint32(&o.DIEPCTL5.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL5_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL5.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetDIEPCTL5_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL5.Reg, volatile.LoadUint32(&o.DIEPCTL5.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL5_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL5.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetDIEPCTL5_Stall(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL5.Reg, volatile.LoadUint32(&o.DIEPCTL5.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL5_Stall() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL5.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_HS_Type) SetDIEPCTL5_TXFNUM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL5.Reg, volatile.LoadUint32(&o.DIEPCTL5.Reg)&^(0x3c00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL5_TXFNUM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL5.Reg) & 0x3c00000) >> 22
}
func (o *USB_OTG_HS_Type) SetDIEPCTL5_CNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL5.Reg, volatile.LoadUint32(&o.DIEPCTL5.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL5_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL5.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_HS_Type) SetDIEPCTL5_SNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL5.Reg, volatile.LoadUint32(&o.DIEPCTL5.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL5_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL5.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_HS_Type) SetDIEPCTL5_SD0PID_SEVNFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL5.Reg, volatile.LoadUint32(&o.DIEPCTL5.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL5_SD0PID_SEVNFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL5.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_HS_Type) SetDIEPCTL5_SODDFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL5.Reg, volatile.LoadUint32(&o.DIEPCTL5.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL5_SODDFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL5.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetDIEPCTL5_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL5.Reg, volatile.LoadUint32(&o.DIEPCTL5.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL5_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL5.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetDIEPCTL5_EPENA(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL5.Reg, volatile.LoadUint32(&o.DIEPCTL5.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL5_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL5.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.DTXFSTS6: OTG_HS device IN endpoint transmit FIFO status register
func (o *USB_OTG_HS_Type) SetDTXFSTS6_INEPTFSAV(value uint32) {
	volatile.StoreUint32(&o.DTXFSTS6.Reg, volatile.LoadUint32(&o.DTXFSTS6.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetDTXFSTS6_INEPTFSAV() uint32 {
	return volatile.LoadUint32(&o.DTXFSTS6.Reg) & 0xffff
}

// USB_OTG_HS.DIEPINT5: OTG device endpoint-5 interrupt register
func (o *USB_OTG_HS_Type) SetDIEPINT5_XFRC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT5.Reg, volatile.LoadUint32(&o.DIEPINT5.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPINT5_XFRC() uint32 {
	return volatile.LoadUint32(&o.DIEPINT5.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetDIEPINT5_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DIEPINT5.Reg, volatile.LoadUint32(&o.DIEPINT5.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetDIEPINT5_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT5.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetDIEPINT5_TOC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT5.Reg, volatile.LoadUint32(&o.DIEPINT5.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetDIEPINT5_TOC() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT5.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetDIEPINT5_ITTXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT5.Reg, volatile.LoadUint32(&o.DIEPINT5.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetDIEPINT5_ITTXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT5.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetDIEPINT5_INEPNE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT5.Reg, volatile.LoadUint32(&o.DIEPINT5.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetDIEPINT5_INEPNE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT5.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetDIEPINT5_TXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT5.Reg, volatile.LoadUint32(&o.DIEPINT5.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetDIEPINT5_TXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT5.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetDIEPINT5_TXFIFOUDRN(value uint32) {
	volatile.StoreUint32(&o.DIEPINT5.Reg, volatile.LoadUint32(&o.DIEPINT5.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetDIEPINT5_TXFIFOUDRN() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT5.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetDIEPINT5_BNA(value uint32) {
	volatile.StoreUint32(&o.DIEPINT5.Reg, volatile.LoadUint32(&o.DIEPINT5.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetDIEPINT5_BNA() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT5.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetDIEPINT5_PKTDRPSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPINT5.Reg, volatile.LoadUint32(&o.DIEPINT5.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetDIEPINT5_PKTDRPSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT5.Reg) & 0x800) >> 11
}
func (o *USB_OTG_HS_Type) SetDIEPINT5_BERR(value uint32) {
	volatile.StoreUint32(&o.DIEPINT5.Reg, volatile.LoadUint32(&o.DIEPINT5.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_HS_Type) GetDIEPINT5_BERR() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT5.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_HS_Type) SetDIEPINT5_NAK(value uint32) {
	volatile.StoreUint32(&o.DIEPINT5.Reg, volatile.LoadUint32(&o.DIEPINT5.Reg)&^(0x2000)|value<<13)
}
func (o *USB_OTG_HS_Type) GetDIEPINT5_NAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT5.Reg) & 0x2000) >> 13
}

// USB_OTG_HS.DTXFSTS7: OTG_HS device IN endpoint transmit FIFO status register
func (o *USB_OTG_HS_Type) SetDTXFSTS7_INEPTFSAV(value uint32) {
	volatile.StoreUint32(&o.DTXFSTS7.Reg, volatile.LoadUint32(&o.DTXFSTS7.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetDTXFSTS7_INEPTFSAV() uint32 {
	return volatile.LoadUint32(&o.DTXFSTS7.Reg) & 0xffff
}

// USB_OTG_HS.DIEPTSIZ5: OTG_HS device endpoint transfer size register
func (o *USB_OTG_HS_Type) SetDIEPTSIZ5_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ5.Reg, volatile.LoadUint32(&o.DIEPTSIZ5.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPTSIZ5_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPTSIZ5.Reg) & 0x7ffff
}
func (o *USB_OTG_HS_Type) SetDIEPTSIZ5_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ5.Reg, volatile.LoadUint32(&o.DIEPTSIZ5.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetDIEPTSIZ5_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ5.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_HS_Type) SetDIEPTSIZ5_MCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ5.Reg, volatile.LoadUint32(&o.DIEPTSIZ5.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetDIEPTSIZ5_MCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ5.Reg) & 0x60000000) >> 29
}

// USB_OTG_HS.DTXFSTS5: OTG_HS device IN endpoint transmit FIFO status register
func (o *USB_OTG_HS_Type) SetDTXFSTS5_INEPTFSAV(value uint32) {
	volatile.StoreUint32(&o.DTXFSTS5.Reg, volatile.LoadUint32(&o.DTXFSTS5.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetDTXFSTS5_INEPTFSAV() uint32 {
	return volatile.LoadUint32(&o.DTXFSTS5.Reg) & 0xffff
}

// USB_OTG_HS.DIEPCTL6: OTG device endpoint-6 control register
func (o *USB_OTG_HS_Type) SetDIEPCTL6_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL6.Reg, volatile.LoadUint32(&o.DIEPCTL6.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL6_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPCTL6.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetDIEPCTL6_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL6.Reg, volatile.LoadUint32(&o.DIEPCTL6.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL6_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL6.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetDIEPCTL6_EONUM_DPID(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL6.Reg, volatile.LoadUint32(&o.DIEPCTL6.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL6_EONUM_DPID() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL6.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetDIEPCTL6_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL6.Reg, volatile.LoadUint32(&o.DIEPCTL6.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL6_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL6.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetDIEPCTL6_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL6.Reg, volatile.LoadUint32(&o.DIEPCTL6.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL6_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL6.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetDIEPCTL6_Stall(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL6.Reg, volatile.LoadUint32(&o.DIEPCTL6.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL6_Stall() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL6.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_HS_Type) SetDIEPCTL6_TXFNUM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL6.Reg, volatile.LoadUint32(&o.DIEPCTL6.Reg)&^(0x3c00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL6_TXFNUM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL6.Reg) & 0x3c00000) >> 22
}
func (o *USB_OTG_HS_Type) SetDIEPCTL6_CNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL6.Reg, volatile.LoadUint32(&o.DIEPCTL6.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL6_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL6.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_HS_Type) SetDIEPCTL6_SNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL6.Reg, volatile.LoadUint32(&o.DIEPCTL6.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL6_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL6.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_HS_Type) SetDIEPCTL6_SD0PID_SEVNFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL6.Reg, volatile.LoadUint32(&o.DIEPCTL6.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL6_SD0PID_SEVNFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL6.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_HS_Type) SetDIEPCTL6_SODDFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL6.Reg, volatile.LoadUint32(&o.DIEPCTL6.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL6_SODDFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL6.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetDIEPCTL6_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL6.Reg, volatile.LoadUint32(&o.DIEPCTL6.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL6_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL6.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetDIEPCTL6_EPENA(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL6.Reg, volatile.LoadUint32(&o.DIEPCTL6.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL6_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL6.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.DIEPINT6: OTG device endpoint-6 interrupt register
func (o *USB_OTG_HS_Type) SetDIEPINT6_XFRC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT6.Reg, volatile.LoadUint32(&o.DIEPINT6.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPINT6_XFRC() uint32 {
	return volatile.LoadUint32(&o.DIEPINT6.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetDIEPINT6_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DIEPINT6.Reg, volatile.LoadUint32(&o.DIEPINT6.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetDIEPINT6_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT6.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetDIEPINT6_TOC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT6.Reg, volatile.LoadUint32(&o.DIEPINT6.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetDIEPINT6_TOC() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT6.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetDIEPINT6_ITTXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT6.Reg, volatile.LoadUint32(&o.DIEPINT6.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetDIEPINT6_ITTXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT6.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetDIEPINT6_INEPNE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT6.Reg, volatile.LoadUint32(&o.DIEPINT6.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetDIEPINT6_INEPNE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT6.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetDIEPINT6_TXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT6.Reg, volatile.LoadUint32(&o.DIEPINT6.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetDIEPINT6_TXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT6.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetDIEPINT6_TXFIFOUDRN(value uint32) {
	volatile.StoreUint32(&o.DIEPINT6.Reg, volatile.LoadUint32(&o.DIEPINT6.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetDIEPINT6_TXFIFOUDRN() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT6.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetDIEPINT6_BNA(value uint32) {
	volatile.StoreUint32(&o.DIEPINT6.Reg, volatile.LoadUint32(&o.DIEPINT6.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetDIEPINT6_BNA() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT6.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetDIEPINT6_PKTDRPSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPINT6.Reg, volatile.LoadUint32(&o.DIEPINT6.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetDIEPINT6_PKTDRPSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT6.Reg) & 0x800) >> 11
}
func (o *USB_OTG_HS_Type) SetDIEPINT6_BERR(value uint32) {
	volatile.StoreUint32(&o.DIEPINT6.Reg, volatile.LoadUint32(&o.DIEPINT6.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_HS_Type) GetDIEPINT6_BERR() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT6.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_HS_Type) SetDIEPINT6_NAK(value uint32) {
	volatile.StoreUint32(&o.DIEPINT6.Reg, volatile.LoadUint32(&o.DIEPINT6.Reg)&^(0x2000)|value<<13)
}
func (o *USB_OTG_HS_Type) GetDIEPINT6_NAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT6.Reg) & 0x2000) >> 13
}

// USB_OTG_HS.DIEPCTL7: OTG device endpoint-7 control register
func (o *USB_OTG_HS_Type) SetDIEPCTL7_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL7.Reg, volatile.LoadUint32(&o.DIEPCTL7.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL7_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPCTL7.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetDIEPCTL7_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL7.Reg, volatile.LoadUint32(&o.DIEPCTL7.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL7_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL7.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetDIEPCTL7_EONUM_DPID(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL7.Reg, volatile.LoadUint32(&o.DIEPCTL7.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL7_EONUM_DPID() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL7.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetDIEPCTL7_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL7.Reg, volatile.LoadUint32(&o.DIEPCTL7.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetDIEPCTL7_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL7.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetDIEPCTL7_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL7.Reg, volatile.LoadUint32(&o.DIEPCTL7.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_