/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.tomcat.dbcp.dbcp2.ListException;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyDataSource;

abstract class InstanceKeyDataSourceFactory
implements ObjectFactory {
    private static final Map<String, InstanceKeyDataSource> INSTANCE_MAP = new ConcurrentHashMap<String, InstanceKeyDataSource>();

    InstanceKeyDataSourceFactory() {
    }

    public static void closeAll() throws ListException {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>(INSTANCE_MAP.size());
        INSTANCE_MAP.entrySet().forEach(entry -> {
            if (entry != null) {
                InstanceKeyDataSource instanceKeyDataSource = (InstanceKeyDataSource)entry.getValue();
                Utils.close(instanceKeyDataSource, arrayList::add);
            }
        });
        INSTANCE_MAP.clear();
        if (!arrayList.isEmpty()) {
            throw new ListException("Could not close all InstanceKeyDataSource instances.", arrayList);
        }
    }

    protected static final Object deserialize(byte[] byArray) throws IOException, ClassNotFoundException {
        Object object;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
            object = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(objectInputStream);
            throw throwable;
        }
        Utils.closeQuietly(objectInputStream);
        return object;
    }

    static synchronized String registerNewInstance(InstanceKeyDataSource instanceKeyDataSource) {
        int n = 0;
        for (String string : INSTANCE_MAP.keySet()) {
            if (string == null) continue;
            try {
                n = Math.max(n, Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String string = String.valueOf(n + 1);
        INSTANCE_MAP.put(string, instanceKeyDataSource);
        return string;
    }

    static void removeInstance(String string) {
        if (string != null) {
            INSTANCE_MAP.remove(string);
        }
    }

    protected abstract InstanceKeyDataSource getNewInstance(Reference var1) throws IOException, ClassNotFoundException;

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws IOException, ClassNotFoundException {
        Reference reference;
        InstanceKeyDataSource instanceKeyDataSource = null;
        if (object instanceof Reference && this.isCorrectClass((reference = (Reference)object).getClassName())) {
            RefAddr refAddr = reference.get("instanceKey");
            if (refAddr != null && refAddr.getContent() != null) {
                instanceKeyDataSource = INSTANCE_MAP.get(refAddr.getContent());
            } else {
                String string = null;
                if (name != null) {
                    string = name.toString();
                    instanceKeyDataSource = INSTANCE_MAP.get(string);
                }
                if (instanceKeyDataSource == null) {
                    InstanceKeyDataSource instanceKeyDataSource2 = this.getNewInstance(reference);
                    this.setCommonProperties(reference, instanceKeyDataSource2);
                    instanceKeyDataSource = instanceKeyDataSource2;
                    if (string != null) {
                        INSTANCE_MAP.put(string, instanceKeyDataSource2);
                    }
                }
            }
        }
        return instanceKeyDataSource;
    }

    protected abstract boolean isCorrectClass(String var1);

    boolean parseBoolean(RefAddr refAddr) {
        return Boolean.parseBoolean(this.toString(refAddr));
    }

    int parseInt(RefAddr refAddr) {
        return Integer.parseInt(this.toString(refAddr));
    }

    long parseLong(RefAddr refAddr) {
        return Long.parseLong(this.toString(refAddr));
    }

    private void setCommonProperties(Reference reference, InstanceKeyDataSource instanceKeyDataSource) throws IOException, ClassNotFoundException {
        RefAddr refAddr = reference.get("dataSourceName");
        if (refAddr != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDataSourceName(this.toString(refAddr));
        }
        if ((refAddr = reference.get("description")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDescription(this.toString(refAddr));
        }
        if ((refAddr = reference.get("jndiEnvironment")) != null && refAddr.getContent() != null) {
            byte[] byArray = (byte[])refAddr.getContent();
            instanceKeyDataSource.setJndiEnvironment((Properties)InstanceKeyDataSourceFactory.deserialize(byArray));
        }
        if ((refAddr = reference.get("loginTimeout")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setLoginTimeout(Duration.ofSeconds(this.parseInt(refAddr)));
        }
        if ((refAddr = reference.get("blockWhenExhausted")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultBlockWhenExhausted(this.parseBoolean(refAddr));
        }
        if ((refAddr = reference.get("evictionPolicyClassName")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultEvictionPolicyClassName(this.toString(refAddr));
        }
        if ((refAddr = reference.get("lifo")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultLifo(this.parseBoolean(refAddr));
        }
        if ((refAddr = reference.get("maxIdlePerKey")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultMaxIdle(this.parseInt(refAddr));
        }
        if ((refAddr = reference.get("maxTotalPerKey")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultMaxTotal(this.parseInt(refAddr));
        }
        if ((refAddr = reference.get("maxWaitMillis")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultMaxWait(Duration.ofMillis(this.parseLong(refAddr)));
        }
        if ((refAddr = reference.get("minEvictableIdleTimeMillis")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultMinEvictableIdle(Duration.ofMillis(this.parseLong(refAddr)));
        }
        if ((refAddr = reference.get("minIdlePerKey")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultMinIdle(this.parseInt(refAddr));
        }
        if ((refAddr = reference.get("numTestsPerEvictionRun")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultNumTestsPerEvictionRun(this.parseInt(refAddr));
        }
        if ((refAddr = reference.get("softMinEvictableIdleTimeMillis")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultSoftMinEvictableIdle(Duration.ofMillis(this.parseLong(refAddr)));
        }
        if ((refAddr = reference.get("testOnCreate")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultTestOnCreate(this.parseBoolean(refAddr));
        }
        if ((refAddr = reference.get("testOnBorrow")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultTestOnBorrow(this.parseBoolean(refAddr));
        }
        if ((refAddr = reference.get("testOnReturn")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultTestOnReturn(this.parseBoolean(refAddr));
        }
        if ((refAddr = reference.get("testWhileIdle")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultTestWhileIdle(this.parseBoolean(refAddr));
        }
        if ((refAddr = reference.get("timeBetweenEvictionRunsMillis")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultDurationBetweenEvictionRuns(Duration.ofMillis(this.parseLong(refAddr)));
        }
        if ((refAddr = reference.get("validationQuery")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setValidationQuery(this.toString(refAddr));
        }
        if ((refAddr = reference.get("validationQueryTimeout")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setValidationQueryTimeout(Duration.ofSeconds(this.parseInt(refAddr)));
        }
        if ((refAddr = reference.get("rollbackAfterValidation")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setRollbackAfterValidation(this.parseBoolean(refAddr));
        }
        if ((refAddr = reference.get("maxConnLifetimeMillis")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setMaxConnLifetime(Duration.ofMillis(this.parseLong(refAddr)));
        }
        if ((refAddr = reference.get("defaultAutoCommit")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultAutoCommit(Boolean.valueOf(this.toString(refAddr)));
        }
        if ((refAddr = reference.get("defaultTransactionIsolation")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultTransactionIsolation(this.parseInt(refAddr));
        }
        if ((refAddr = reference.get("defaultReadOnly")) != null && refAddr.getContent() != null) {
            instanceKeyDataSource.setDefaultReadOnly(Boolean.valueOf(this.toString(refAddr)));
        }
    }

    String toString(RefAddr refAddr) {
        return refAddr.getContent().toString();
    }
}

