<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: opentelemetry/proto/metrics/v1/metrics.proto

namespace Opentelemetry\Proto\Metrics\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Defines a Metric which has one or more timeseries.  The following is a
 * brief summary of the Metric data model.  For more details, see:
 *   https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/metrics/data-model.md
 * The data model and relation between entities is shown in the
 * diagram below. Here, "DataPoint" is the term used to refer to any
 * one of the specific data point value types, and "points" is the term used
 * to refer to any one of the lists of points contained in the Metric.
 * - Metric is composed of a metadata and data.
 * - Metadata part contains a name, description, unit.
 * - Data is one of the possible types (Sum, Gauge, Histogram, Summary).
 * - DataPoint contains timestamps, attributes, and one of the possible value type
 *   fields.
 *     Metric
 *  +------------+
 *  |name        |
 *  |description |
 *  |unit        |     +------------------------------------+
 *  |data        |---> |Gauge, Sum, Histogram, Summary, ... |
 *  +------------+     +------------------------------------+
 *    Data [One of Gauge, Sum, Histogram, Summary, ...]
 *  +-----------+
 *  |...        |  // Metadata about the Data.
 *  |points     |--+
 *  +-----------+  |
 *                 |      +---------------------------+
 *                 |      |DataPoint 1                |
 *                 v      |+------+------+   +------+ |
 *              +-----+   ||label |label |...|label | |
 *              |  1  |-->||value1|value2|...|valueN| |
 *              +-----+   |+------+------+   +------+ |
 *              |  .  |   |+-----+                    |
 *              |  .  |   ||value|                    |
 *              |  .  |   |+-----+                    |
 *              |  .  |   +---------------------------+
 *              |  .  |                   .
 *              |  .  |                   .
 *              |  .  |                   .
 *              |  .  |   +---------------------------+
 *              |  .  |   |DataPoint M                |
 *              +-----+   |+------+------+   +------+ |
 *              |  M  |-->||label |label |...|label | |
 *              +-----+   ||value1|value2|...|valueN| |
 *                        |+------+------+   +------+ |
 *                        |+-----+                    |
 *                        ||value|                    |
 *                        |+-----+                    |
 *                        +---------------------------+
 * Each distinct type of DataPoint represents the output of a specific
 * aggregation function, the result of applying the DataPoint's
 * associated function of to one or more measurements.
 * All DataPoint types have three common fields:
 * - Attributes includes key-value pairs associated with the data point
 * - TimeUnixNano is required, set to the end time of the aggregation
 * - StartTimeUnixNano is optional, but strongly encouraged for DataPoints
 *   having an AggregationTemporality field, as discussed below.
 * Both TimeUnixNano and StartTimeUnixNano values are expressed as
 * UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
 * # TimeUnixNano
 * This field is required, having consistent interpretation across
 * DataPoint types.  TimeUnixNano is the moment corresponding to when
 * the data point's aggregate value was captured.
 * Data points with the 0 value for TimeUnixNano SHOULD be rejected
 * by consumers.
 * # StartTimeUnixNano
 * StartTimeUnixNano in general allows detecting when a sequence of
 * observations is unbroken.  This field indicates to consumers the
 * start time for points with cumulative and delta
 * AggregationTemporality, and it should be included whenever possible
 * to support correct rate calculation.  Although it may be omitted
 * when the start time is truly unknown, setting StartTimeUnixNano is
 * strongly encouraged.
 *
 * Generated from protobuf message <code>opentelemetry.proto.metrics.v1.Metric</code>
 */
class Metric extends \Google\Protobuf\Internal\Message
{
    /**
     * name of the metric, including its DNS name prefix. It must be unique.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * description of the metric, which can be used in documentation.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     */
    protected $description = '';
    /**
     * unit in which the metric value is reported. Follows the format
     * described by http://unitsofmeasure.org/ucum.html.
     *
     * Generated from protobuf field <code>string unit = 3;</code>
     */
    protected $unit = '';
    protected $data;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           name of the metric, including its DNS name prefix. It must be unique.
     *     @type string $description
     *           description of the metric, which can be used in documentation.
     *     @type string $unit
     *           unit in which the metric value is reported. Follows the format
     *           described by http://unitsofmeasure.org/ucum.html.
     *     @type \Opentelemetry\Proto\Metrics\V1\Gauge $gauge
     *     @type \Opentelemetry\Proto\Metrics\V1\Sum $sum
     *     @type \Opentelemetry\Proto\Metrics\V1\Histogram $histogram
     *     @type \Opentelemetry\Proto\Metrics\V1\ExponentialHistogram $exponential_histogram
     *     @type \Opentelemetry\Proto\Metrics\V1\Summary $summary
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Opentelemetry\Proto\Metrics\V1\Metrics::initOnce();
        parent::__construct($data);
    }

    /**
     * name of the metric, including its DNS name prefix. It must be unique.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * name of the metric, including its DNS name prefix. It must be unique.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * description of the metric, which can be used in documentation.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * description of the metric, which can be used in documentation.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * unit in which the metric value is reported. Follows the format
     * described by http://unitsofmeasure.org/ucum.html.
     *
     * Generated from protobuf field <code>string unit = 3;</code>
     * @return string
     */
    public function getUnit()
    {
        return $this->unit;
    }

    /**
     * unit in which the metric value is reported. Follows the format
     * described by http://unitsofmeasure.org/ucum.html.
     *
     * Generated from protobuf field <code>string unit = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setUnit($var)
    {
        GPBUtil::checkString($var, True);
        $this->unit = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>.opentelemetry.proto.metrics.v1.Gauge gauge = 5;</code>
     * @return \Opentelemetry\Proto\Metrics\V1\Gauge|null
     */
    public function getGauge()
    {
        return $this->readOneof(5);
    }

    public function hasGauge()
    {
        return $this->hasOneof(5);
    }

    /**
     * Generated from protobuf field <code>.opentelemetry.proto.metrics.v1.Gauge gauge = 5;</code>
     * @param \Opentelemetry\Proto\Metrics\V1\Gauge $var
     * @return $this
     */
    public function setGauge($var)
    {
        GPBUtil::checkMessage($var, \Opentelemetry\Proto\Metrics\V1\Gauge::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.opentelemetry.proto.metrics.v1.Sum sum = 7;</code>
     * @return \Opentelemetry\Proto\Metrics\V1\Sum|null
     */
    public function getSum()
    {
        return $this->readOneof(7);
    }

    public function hasSum()
    {
        return $this->hasOneof(7);
    }

    /**
     * Generated from protobuf field <code>.opentelemetry.proto.metrics.v1.Sum sum = 7;</code>
     * @param \Opentelemetry\Proto\Metrics\V1\Sum $var
     * @return $this
     */
    public function setSum($var)
    {
        GPBUtil::checkMessage($var, \Opentelemetry\Proto\Metrics\V1\Sum::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.opentelemetry.proto.metrics.v1.Histogram histogram = 9;</code>
     * @return \Opentelemetry\Proto\Metrics\V1\Histogram|null
     */
    public function getHistogram()
    {
        return $this->readOneof(9);
    }

    public function hasHistogram()
    {
        return $this->hasOneof(9);
    }

    /**
     * Generated from protobuf field <code>.opentelemetry.proto.metrics.v1.Histogram histogram = 9;</code>
     * @param \Opentelemetry\Proto\Metrics\V1\Histogram $var
     * @return $this
     */
    public function setHistogram($var)
    {
        GPBUtil::checkMessage($var, \Opentelemetry\Proto\Metrics\V1\Histogram::class);
        $this->writeOneof(9, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.opentelemetry.proto.metrics.v1.ExponentialHistogram exponential_histogram = 10;</code>
     * @return \Opentelemetry\Proto\Metrics\V1\ExponentialHistogram|null
     */
    public function getExponentialHistogram()
    {
        return $this->readOneof(10);
    }

    public function hasExponentialHistogram()
    {
        return $this->hasOneof(10);
    }

    /**
     * Generated from protobuf field <code>.opentelemetry.proto.metrics.v1.ExponentialHistogram exponential_histogram = 10;</code>
     * @param \Opentelemetry\Proto\Metrics\V1\ExponentialHistogram $var
     * @return $this
     */
    public function setExponentialHistogram($var)
    {
        GPBUtil::checkMessage($var, \Opentelemetry\Proto\Metrics\V1\ExponentialHistogram::class);
        $this->writeOneof(10, $var);

        return $this;
    }

    /**
     * Generated from protobuf field <code>.opentelemetry.proto.metrics.v1.Summary summary = 11;</code>
     * @return \Opentelemetry\Proto\Metrics\V1\Summary|null
     */
    public function getSummary()
    {
        return $this->readOneof(11);
    }

    public function hasSummary()
    {
        return $this->hasOneof(11);
    }

    /**
     * Generated from protobuf field <code>.opentelemetry.proto.metrics.v1.Summary summary = 11;</code>
     * @param \Opentelemetry\Proto\Metrics\V1\Summary $var
     * @return $this
     */
    public function setSummary($var)
    {
        GPBUtil::checkMessage($var, \Opentelemetry\Proto\Metrics\V1\Summary::class);
        $this->writeOneof(11, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getData()
    {
        return $this->whichOneof("data");
    }

}

