/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.jdk9.model.impl;

import java.lang.annotation.Annotation;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jdk.jfr.DataAmount;
import jdk.jfr.EventType;
import jdk.jfr.Experimental;
import jdk.jfr.Frequency;
import jdk.jfr.MemoryAddress;
import jdk.jfr.Percentage;
import jdk.jfr.Timespan;
import jdk.jfr.Timestamp;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.RecordedClass;
import jdk.jfr.consumer.RecordedClassLoader;
import jdk.jfr.consumer.RecordedThread;
import org.graalvm.visualvm.jfr.jdk9.model.impl.JFRJDK9Event;
import org.graalvm.visualvm.jfr.model.JFRDataDescriptor;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.utils.DurationFormatter;
import org.graalvm.visualvm.jfr.utils.InstantFormatter;
import org.graalvm.visualvm.jfr.utils.ValuesChecker;

final class DisplayableSupport {
    private static final String VALUE_NA = "n/a";
    private static final DefaultProcessor DEFAULT_PROCESSOR = new DefaultProcessor();
    private static final DefaultFormat DEFAULT_FORMAT = new DefaultFormat();
    private static final FormatProcessor[] FORMAT_PROCESSORS = new FormatProcessor[]{new TimestampFormatProcessor(), new TimespanFormatProcessor(), new MemoryAddressFormatProcessor(), new FrequencyFormatProcessor(), new PercentFormatProcessor(), new DataAmountFormatProcessor()};
    private static final TypeProcessor[] TYPE_PROCESSORS = new TypeProcessor[]{new RecordedThreadProcessor(), new RecordedClassProcessor(), new RecordedClassLoaderProcessor()};
    private static final Set<String> PRIMITIVE_NUMERIC = new HashSet<String>(Arrays.asList("byte", "short", "int", "long", "char", "float", "double"));
    private static final NumberFormat DURATION_MS_FORMAT = NumberFormat.getNumberInstance();
    private static final NumberFormat NUMBER_FORMAT;
    private static final NumberFormat PERCENT_FORMAT;

    static Iterator<ValueDescriptor> displayableValueDescriptors(final EventType type, final boolean includeExperimental) {
        return new Iterator<ValueDescriptor>(){
            private final String ID_STACKTRACE;
            private final Iterator<ValueDescriptor> master;
            private ValueDescriptor next;
            {
                this.ID_STACKTRACE = "stackTrace";
                this.master = type.getFields().iterator();
                this.next = this.computeNext();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public ValueDescriptor next() {
                ValueDescriptor ret = this.next;
                this.next = this.computeNext();
                return ret;
            }

            private ValueDescriptor computeNext() {
                while (this.master.hasNext()) {
                    ValueDescriptor _next = this.master.next();
                    if (!this.isDisplayable(_next)) continue;
                    return _next;
                }
                return null;
            }

            private boolean isDisplayable(ValueDescriptor descriptor) {
                if (this.ID_STACKTRACE.equals(descriptor.getName())) {
                    return false;
                }
                return includeExperimental || !DisplayableSupport.isExperimental(descriptor);
            }
        };
    }

    static JFRDataDescriptor getDataDescriptor(ValueDescriptor descriptor) {
        Format dataFormat = null;
        boolean isNumeric = false;
        for (FormatProcessor formatProcessor : FORMAT_PROCESSORS) {
            Object annotation = descriptor.getAnnotation(formatProcessor.getType());
            if (annotation == null || (dataFormat = formatProcessor.createFormat(descriptor, annotation)) == null) continue;
            isNumeric = formatProcessor.isNumeric();
            break;
        }
        if (dataFormat == null) {
            for (TypeProcessor typeProcessor : TYPE_PROCESSORS) {
                String typeName = descriptor.getTypeName();
                if (!typeProcessor.handlesType(typeName) || (dataFormat = typeProcessor.createFormat()) == null) continue;
                isNumeric = typeProcessor.isNumeric();
                break;
            }
        }
        if (dataFormat == null) {
            dataFormat = DEFAULT_FORMAT;
            isNumeric = DEFAULT_PROCESSOR.isNumeric(descriptor);
        }
        Object dataName = descriptor.getLabel();
        if (DisplayableSupport.isExperimental(descriptor)) {
            dataName = "[Experimental] " + (String)dataName;
        }
        return new JFRDataDescriptor((String)dataName, descriptor.getDescription(), dataFormat, null, isNumeric);
    }

    static Comparable getDisplayValue(JFRJDK9Event event, ValueDescriptor descriptor) {
        for (FormatProcessor formatProcessor : FORMAT_PROCESSORS) {
            Object annotation = descriptor.getAnnotation(formatProcessor.getType());
            if (annotation == null) continue;
            try {
                return formatProcessor.createValue(event, descriptor, annotation);
            }
            catch (JFRPropertyNotAvailableException ex) {
                return null;
            }
        }
        for (TypeProcessor typeProcessor : TYPE_PROCESSORS) {
            String typeName = descriptor.getTypeName();
            if (!typeProcessor.handlesType(typeName)) continue;
            try {
                return typeProcessor.createValue(event, descriptor);
            }
            catch (JFRPropertyNotAvailableException ex) {
                return null;
            }
        }
        try {
            return DEFAULT_PROCESSOR.createValue(event, descriptor);
        }
        catch (JFRPropertyNotAvailableException ex) {
            return null;
        }
    }

    private static boolean isExperimental(ValueDescriptor descriptor) {
        return descriptor.getAnnotation(Experimental.class) != null;
    }

    private DisplayableSupport() {
    }

    static {
        DURATION_MS_FORMAT.setMaximumFractionDigits(3);
        DURATION_MS_FORMAT.setMinimumFractionDigits(3);
        NUMBER_FORMAT = NumberFormat.getNumberInstance();
        PERCENT_FORMAT = NumberFormat.getPercentInstance();
        PERCENT_FORMAT.setMaximumFractionDigits(2);
        PERCENT_FORMAT.setMinimumFractionDigits(2);
    }

    private static final class DefaultFormat
    extends DataFormat {
        private DefaultFormat() {
        }

        @Override
        public StringBuffer format(Object o, StringBuffer b, FieldPosition p) {
            if (ValuesChecker.isNAValue((Object)o)) {
                return b.append(DisplayableSupport.VALUE_NA);
            }
            return o instanceof Number ? b.append(NUMBER_FORMAT.format(o)) : (o == null ? b : b.append(o.toString()));
        }
    }

    private static class DefaultProcessor {
        private DefaultProcessor() {
        }

        Comparable createValue(JFRJDK9Event event, ValueDescriptor descriptor) throws JFRPropertyNotAvailableException {
            Object value = event.getValue(descriptor.getName());
            if (value == null) {
                return null;
            }
            if (value instanceof Comparable) {
                return (Comparable)value;
            }
            return value.toString();
        }

        boolean isNumeric(ValueDescriptor descriptor) {
            return PRIMITIVE_NUMERIC.contains(descriptor.getTypeName());
        }
    }

    private static class RecordedClassLoaderProcessor
    extends TypeProcessor {
        private RecordedClassLoaderProcessor() {
        }

        @Override
        boolean handlesType(String typeName) {
            return "jdk.types.ClassLoader".equals(typeName) || "com.oracle.jfr.types.ClassLoader".equals(typeName);
        }

        String createValue(JFRJDK9Event event, ValueDescriptor descriptor) throws JFRPropertyNotAvailableException {
            Object value = event.getValue(descriptor.getName());
            return value instanceof RecordedClassLoader ? ((RecordedClassLoader)value).getType().getName() : "";
        }
    }

    private static class RecordedClassProcessor
    extends TypeProcessor {
        private RecordedClassProcessor() {
        }

        @Override
        boolean handlesType(String typeName) {
            return Class.class.getName().equals(typeName);
        }

        String createValue(JFRJDK9Event event, ValueDescriptor descriptor) throws JFRPropertyNotAvailableException {
            Object value = event.getValue(descriptor.getName());
            return value instanceof RecordedClass ? ((RecordedClass)value).getName() : "";
        }
    }

    private static class RecordedThreadProcessor
    extends TypeProcessor {
        private RecordedThreadProcessor() {
        }

        @Override
        boolean handlesType(String typeName) {
            return Thread.class.getName().equals(typeName);
        }

        String createValue(JFRJDK9Event event, ValueDescriptor descriptor) throws JFRPropertyNotAvailableException {
            RecordedThread thread;
            Object value = event.getValue(descriptor.getName());
            RecordedThread recordedThread = thread = value instanceof RecordedThread ? (RecordedThread)value : null;
            if (thread == null) {
                return "";
            }
            String name = thread.getJavaName();
            return name != null ? name : thread.getOSName();
        }
    }

    private static abstract class TypeProcessor {
        private TypeProcessor() {
        }

        abstract boolean handlesType(String var1);

        Format createFormat() {
            return null;
        }

        Comparable createValue(JFRJDK9Event event, ValueDescriptor descriptor) throws JFRPropertyNotAvailableException {
            Object value = event.getValue(descriptor.getName());
            return value instanceof Comparable ? (Comparable)value : (value == null ? "" : value.toString());
        }

        boolean isNumeric() {
            return false;
        }
    }

    private static final class PercentFormat
    extends DataFormat {
        private PercentFormat() {
        }

        @Override
        public StringBuffer format(Object o, StringBuffer b, FieldPosition p) {
            if (ValuesChecker.isNAValue((Object)o)) {
                return b.append(DisplayableSupport.VALUE_NA);
            }
            return o instanceof Number ? b.append(PERCENT_FORMAT.format(((Number)o).doubleValue())) : (o == null ? b : b.append("<unknown>"));
        }
    }

    private static class PercentFormatProcessor
    extends FormatProcessor<Percentage> {
        private PercentFormatProcessor() {
        }

        @Override
        Class<Percentage> getType() {
            return Percentage.class;
        }

        @Override
        Format createFormat(ValueDescriptor descriptor, Percentage annotation) {
            return new PercentFormat();
        }

        @Override
        boolean isNumeric() {
            return true;
        }
    }

    private static final class DataAmountFormat
    extends DataFormat {
        private final String dataSuffix;

        DataAmountFormat(String dataFormat) {
            this.dataSuffix = "BYTES".equals(dataFormat) ? " B" : ("BITS".equals(dataFormat) ? " b" : "");
        }

        @Override
        public StringBuffer format(Object o, StringBuffer b, FieldPosition p) {
            if (ValuesChecker.isNAValue((Object)o)) {
                return b.append(DisplayableSupport.VALUE_NA);
            }
            return o instanceof Number ? b.append(NUMBER_FORMAT.format(((Number)o).longValue())).append(this.dataSuffix) : (o == null ? b : b.append("<unknown>"));
        }
    }

    private static class DataAmountFormatProcessor
    extends FormatProcessor<DataAmount> {
        private DataAmountFormatProcessor() {
        }

        @Override
        Class<DataAmount> getType() {
            return DataAmount.class;
        }

        @Override
        Format createFormat(ValueDescriptor descriptor, DataAmount annotation) {
            return new DataAmountFormat(annotation.value());
        }

        @Override
        boolean isNumeric() {
            return true;
        }
    }

    private static final class FrequencyFormat
    extends DataFormat {
        private final Format originalFormat;

        FrequencyFormat(Format originalFormat) {
            this.originalFormat = originalFormat;
        }

        @Override
        public StringBuffer format(Object o, StringBuffer b, FieldPosition p) {
            if (ValuesChecker.isNAValue((Object)o)) {
                return b.append(DisplayableSupport.VALUE_NA);
            }
            return o instanceof Number ? FrequencyFormat.formatFrequency((Number)o, b, p, this.originalFormat) : (o == null ? b : b.append("<unknown>"));
        }

        private static StringBuffer formatFrequency(Number n, StringBuffer b, FieldPosition p, Format f) {
            if (f == null) {
                return b.append(NUMBER_FORMAT.format(n.longValue())).append(" Hz");
            }
            return f.format(n, b, p).append("/s");
        }
    }

    private static class FrequencyFormatProcessor
    extends FormatProcessor<Frequency> {
        private FrequencyFormatProcessor() {
        }

        @Override
        Class<Frequency> getType() {
            return Frequency.class;
        }

        @Override
        Format createFormat(ValueDescriptor descriptor, Frequency annotation) {
            FormatProcessor dataAmountProcessor = FORMAT_PROCESSORS[FORMAT_PROCESSORS.length - 1];
            Object dataAmountAnnotation = descriptor.getAnnotation(dataAmountProcessor.getType());
            return new FrequencyFormat(dataAmountAnnotation == null ? null : dataAmountProcessor.createFormat(descriptor, dataAmountAnnotation));
        }

        @Override
        boolean isNumeric() {
            return true;
        }
    }

    private static final class MemoryAddressFormat
    extends DataFormat {
        private MemoryAddressFormat() {
        }

        @Override
        public StringBuffer format(Object o, StringBuffer b, FieldPosition p) {
            if (ValuesChecker.isNAValue((Object)o)) {
                return b.append(DisplayableSupport.VALUE_NA);
            }
            return o instanceof Number ? b.append("0x").append(Long.toHexString(((Number)o).longValue())) : (o == null ? b : b.append("<unknown>"));
        }
    }

    private static class MemoryAddressFormatProcessor
    extends FormatProcessor<MemoryAddress> {
        private MemoryAddressFormatProcessor() {
        }

        @Override
        Class<MemoryAddress> getType() {
            return MemoryAddress.class;
        }

        @Override
        Format createFormat(ValueDescriptor descriptor, MemoryAddress annotation) {
            return new MemoryAddressFormat();
        }

        @Override
        boolean isNumeric() {
            return true;
        }
    }

    private static final class TimespanFormat
    extends DataFormat {
        private TimespanFormat() {
        }

        @Override
        public StringBuffer format(Object o, StringBuffer b, FieldPosition p) {
            if (ValuesChecker.isNAValue((Object)o)) {
                return b.append(DisplayableSupport.VALUE_NA);
            }
            return o instanceof Duration ? DurationFormatter.format((Duration)((Duration)o), (StringBuffer)b) : (o == null ? b : b.append("<unknown>"));
        }
    }

    private static class TimespanFormatProcessor
    extends FormatProcessor<Timespan> {
        private TimespanFormatProcessor() {
        }

        @Override
        Class<Timespan> getType() {
            return Timespan.class;
        }

        @Override
        Format createFormat(ValueDescriptor descriptor, Timespan annotation) {
            return new TimespanFormat();
        }

        @Override
        Comparable createValue(JFRJDK9Event event, ValueDescriptor descriptor, Timespan annotation) throws JFRPropertyNotAvailableException {
            return event.getDuration(descriptor.getName());
        }

        @Override
        boolean isNumeric() {
            return true;
        }
    }

    private static final class TimestampFormat
    extends DataFormat {
        private TimestampFormat() {
        }

        @Override
        public StringBuffer format(Object o, StringBuffer b, FieldPosition p) {
            if (ValuesChecker.isNAValue((Object)o)) {
                return b.append(DisplayableSupport.VALUE_NA);
            }
            return o instanceof Instant ? InstantFormatter.format((Instant)((Instant)o), (StringBuffer)b) : (o == null ? b : b.append("<unknown>"));
        }
    }

    private static class TimestampFormatProcessor
    extends FormatProcessor<Timestamp> {
        private TimestampFormatProcessor() {
        }

        @Override
        Class<Timestamp> getType() {
            return Timestamp.class;
        }

        @Override
        Format createFormat(ValueDescriptor descriptor, Timestamp annotation) {
            return new TimestampFormat();
        }

        @Override
        Comparable createValue(JFRJDK9Event event, ValueDescriptor descriptor, Timestamp annotation) throws JFRPropertyNotAvailableException {
            return event.getInstant(descriptor.getName());
        }
    }

    private static abstract class FormatProcessor<A extends Annotation> {
        private FormatProcessor() {
        }

        abstract Class<A> getType();

        Format createFormat(ValueDescriptor descriptor, A annotation) {
            return null;
        }

        Comparable createValue(JFRJDK9Event event, ValueDescriptor descriptor, A annotation) throws JFRPropertyNotAvailableException {
            Object value = event.getValue(descriptor.getName());
            return value instanceof Comparable ? (Comparable)value : (value != null ? value.toString() : null);
        }

        boolean isNumeric() {
            return false;
        }
    }

    private static abstract class DataFormat
    extends Format {
        private DataFormat() {
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

