/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.GenericGlowingChiclet;

public class ChicletWrapper
implements Runnable {
    private boolean allowVertical = true;
    private boolean leftNotch = false;
    private boolean rightNotch = false;
    private int state = 0;
    private Rectangle bounds = new Rectangle();
    private float[] arcs = new float[4];
    GenericGlowingChiclet chiclet = GenericGlowingChiclet.INSTANCE;
    static int drawCount = 0;
    private static HashMap<CacheEntry, BufferedImage> cache = new HashMap();

    public void setState(int n) {
        this.state = n;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.bounds.setBounds(n, n2, n3, n4);
    }

    public void draw(Graphics graphics) {
        if (this.bounds.width == 0 || this.bounds.height == 0) {
            return;
        }
        BufferedImage bufferedImage = this.findBufferedImage();
        ((Graphics2D)graphics).drawRenderedImage(bufferedImage, AffineTransform.getTranslateInstance(0.0, 0.0));
        if (++drawCount % 100 == 0) {
            SwingUtilities.invokeLater(this);
        }
    }

    public void setArcs(float f, float f2, float f3, float f4) {
        this.arcs[0] = f;
        this.arcs[1] = f2;
        this.arcs[2] = f3;
        this.arcs[3] = f4;
    }

    public void setAllowVertical(boolean bl) {
        this.allowVertical = bl;
    }

    public void setNotch(boolean bl, boolean bl2) {
        this.leftNotch = bl2;
        this.rightNotch = bl;
    }

    public Long hash() {
        long l = (long)(this.state * 701) + Double.doubleToLongBits(this.arcs[0]) * 31L + Double.doubleToLongBits(this.arcs[1]) * 37L + Double.doubleToLongBits(this.arcs[2]) * 43L + Double.doubleToLongBits(this.arcs[3]) * 47L + (long)(this.bounds.width * 6703) + (long)(this.bounds.height * 1783);
        if (this.leftNotch) {
            l *= 3121L;
        }
        if (this.rightNotch) {
            l *= 4817L;
        }
        if (this.allowVertical) {
            l *= 1951L;
        }
        return new Long(l);
    }

    private BufferedImage findBufferedImage() {
        Long l = this.hash();
        CacheEntry cacheEntry = new CacheEntry(l);
        BufferedImage bufferedImage = cache.get(cacheEntry);
        if (bufferedImage == null) {
            bufferedImage = this.createImage();
        }
        cache.put(cacheEntry, bufferedImage);
        return bufferedImage;
    }

    private BufferedImage createImage() {
        BufferedImage bufferedImage = new BufferedImage(this.bounds.width, this.bounds.height, 3);
        this.chiclet.setNotch(this.rightNotch, this.leftNotch);
        this.chiclet.setArcs(this.arcs[0], this.arcs[1], this.arcs[2], this.arcs[3]);
        this.chiclet.setBounds(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        this.chiclet.setAllowVertical(this.allowVertical);
        this.chiclet.setState(this.state);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.translate(-this.bounds.x, -this.bounds.y);
        ColorUtil.setupAntialiasing(graphics);
        this.chiclet.draw((Graphics2D)graphics);
        graphics.translate(this.bounds.x, this.bounds.y);
        return bufferedImage;
    }

    @Override
    public void run() {
        if (cache.size() < 5) {
            return;
        }
        HashMap<CacheEntry, BufferedImage> hashMap = new HashMap<CacheEntry, BufferedImage>(cache);
        long l = System.currentTimeMillis();
        Object[] objectArray = hashMap.keySet().toArray(new CacheEntry[0]);
        Arrays.sort(objectArray);
        for (int i = objectArray.length - 1; i >= objectArray.length / 3; --i) {
            if (l - ((CacheEntry)objectArray[i]).timestamp <= 240000L) continue;
            hashMap.remove(objectArray[i]);
        }
        cache = hashMap;
    }

    private static final class CacheEntry
    implements Comparable {
        private final Long hash;
        long timestamp = System.currentTimeMillis();

        public CacheEntry(Long l) {
            this.hash = l;
        }

        public boolean equals(Object object) {
            if (object instanceof CacheEntry) {
                CacheEntry cacheEntry = (CacheEntry)object;
                return cacheEntry.hash() == this.hash();
            }
            if (object instanceof Long) {
                return ((Long)object).longValue() == this.hash();
            }
            return false;
        }

        long hash() {
            return this.hash;
        }

        public int hashCode() {
            return this.hash.intValue();
        }

        public int compareTo(Object object) {
            CacheEntry cacheEntry = (CacheEntry)object;
            return (int)(this.timestamp - cacheEntry.timestamp);
        }

        public String toString() {
            return "CacheEntry: " + new Date(this.timestamp) + " hash " + this.hash();
        }
    }
}

