/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import org.openide.awt.ColorComboBoxRendererWrapper;
import org.openide.awt.ColorValue;
import org.openide.util.NbBundle;

public final class ColorComboBox
extends JComboBox {
    private final boolean allowCustomColors;
    private ColorValue lastSelection;

    public ColorComboBox() {
        this(new Color[]{Color.BLACK, Color.BLUE, Color.CYAN, Color.DARK_GRAY, Color.GRAY, Color.GREEN, Color.LIGHT_GRAY, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.RED, Color.WHITE, Color.YELLOW}, new String[0], true);
    }

    public ColorComboBox(Color[] colorArray, String[] stringArray, boolean bl) {
        super.setModel(ColorComboBox.createModel(colorArray, stringArray, bl));
        this.allowCustomColors = bl;
        this.setEditable(false);
        this.setRenderer(new ColorComboBoxRendererWrapper(this));
        if (bl) {
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (ColorComboBox.this.getSelectedItem() == ColorValue.CUSTOM_COLOR) {
                                    ColorComboBox.this.pickCustomColor();
                                }
                                ColorComboBox.this.lastSelection = (ColorValue)ColorComboBox.this.getSelectedItem();
                            }
                        });
                    }
                }
            });
        }
    }

    public void setModel(Color[] colorArray, String[] stringArray) {
        super.setModel(ColorComboBox.createModel(colorArray, stringArray, this.allowCustomColors));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColorComboBox.this.repaint();
            }
        });
    }

    public Color getSelectedColor() {
        ColorValue colorValue = (ColorValue)this.getSelectedItem();
        return null == colorValue ? null : colorValue.color;
    }

    public void setSelectedColor(Color color) {
        Object object;
        if (null == color) {
            this.setSelectedIndex(-1);
            return;
        }
        for (int i = 0; i < this.getItemCount(); ++i) {
            object = (ColorValue)this.getItemAt(i);
            if (!color.equals(((ColorValue)object).color)) continue;
            this.setSelectedItem(object);
            return;
        }
        if (this.allowCustomColors) {
            this.removeCustomValue();
            ColorValue colorValue = new ColorValue(color, true);
            object = (DefaultComboBoxModel)this.getModel();
            ((DefaultComboBoxModel)object).insertElementAt(colorValue, 0);
            this.setSelectedItem(colorValue);
        }
    }

    private void removeCustomValue() {
        for (int i = 0; i < this.getItemCount(); ++i) {
            ColorValue colorValue = (ColorValue)this.getItemAt(i);
            if (!colorValue.isCustom) continue;
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.getModel();
            defaultComboBoxModel.removeElementAt(i);
            return;
        }
    }

    private void pickCustomColor() {
        Color color = JColorChooser.showDialog(SwingUtilities.getAncestorOfClass(Dialog.class, this), NbBundle.getMessage(ColorComboBox.class, (String)"SelectColor"), this.lastSelection != null ? this.lastSelection.color : null);
        if (color != null) {
            this.setSelectedColor(color);
        } else if (this.lastSelection != null) {
            this.setSelectedItem(this.lastSelection);
        }
    }

    private static DefaultComboBoxModel<ColorValue> createModel(Color[] colorArray, String[] stringArray, boolean bl) {
        DefaultComboBoxModel<ColorValue> defaultComboBoxModel = new DefaultComboBoxModel<ColorValue>();
        for (int i = 0; i < colorArray.length; ++i) {
            Color color = colorArray[i];
            String string = null;
            if (i < stringArray.length) {
                string = stringArray[i];
            }
            if (null == string) {
                string = ColorValue.toText(color);
            }
            defaultComboBoxModel.addElement(new ColorValue(string, color, false));
        }
        if (bl) {
            defaultComboBoxModel.addElement(ColorValue.CUSTOM_COLOR);
        }
        return defaultComboBoxModel;
    }
}

