/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.cpu;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;
import org.graalvm.visualvm.lib.jfluid.results.ExportDataDumper;
import org.graalvm.visualvm.lib.jfluid.results.FilterSortSupport;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.cpu.PrestimeCPUCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.cpu.PrestimeCPUCCTNodeBacked;
import org.graalvm.visualvm.lib.jfluid.utils.StringUtils;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.UIConstants;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.FilterComponent;
import org.graalvm.visualvm.lib.ui.components.JTreeTable;
import org.graalvm.visualvm.lib.ui.components.table.CustomBarCellRenderer;
import org.graalvm.visualvm.lib.ui.components.table.LabelBracketTableCellRenderer;
import org.graalvm.visualvm.lib.ui.components.table.LabelTableCellRenderer;
import org.graalvm.visualvm.lib.ui.components.tree.EnhancedTreeCellRenderer;
import org.graalvm.visualvm.lib.ui.components.tree.MethodNameTreeCellRenderer;
import org.graalvm.visualvm.lib.ui.components.treetable.AbstractTreeTableModel;
import org.graalvm.visualvm.lib.ui.components.treetable.ExtendedTreeTableModel;
import org.graalvm.visualvm.lib.ui.components.treetable.JTreeTablePanel;
import org.graalvm.visualvm.lib.ui.components.treetable.TreeTableModel;
import org.graalvm.visualvm.lib.ui.cpu.CPUResUserActionsHandler;
import org.graalvm.visualvm.lib.ui.cpu.ScreenshotProvider;
import org.graalvm.visualvm.lib.ui.cpu.SnapshotCPUResultsPanel;

public class SubtreeCallGraphPanel
extends SnapshotCPUResultsPanel
implements ScreenshotProvider {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.cpu.Bundle");
    private static final String PANEL_TITLE = messages.getString("SubtreeCallGraphPanel_PanelTitle");
    private static final String PANEL_TITLE_SHORT = messages.getString("SubtreeCallGraphPanel_PanelTitleShort");
    private static final String METHOD_COLUMN_NAME = messages.getString("SubtreeCallGraphPanel_MethodColumnName");
    private static final String METHOD_COLUMN_TOOLTIP = messages.getString("SubtreeCallGraphPanel_MethodColumnToolTip");
    private static final String METHOD_FILTER_HINT = messages.getString("FlatProfilePanel_MethodFilterHint");
    private static final String CLASS_COLUMN_NAME = messages.getString("SubtreeCallGraphPanel_ClassColumnName");
    private static final String CLASS_COLUMN_TOOLTIP = messages.getString("SubtreeCallGraphPanel_ClassColumnToolTip");
    private static final String CLASS_FILTER_HINT = messages.getString("FlatProfilePanel_ClassFilterHint");
    private static final String PACKAGE_COLUMN_NAME = messages.getString("SubtreeCallGraphPanel_PackageColumnName");
    private static final String PACKAGE_COLUMN_TOOLTIP = messages.getString("SubtreeCallGraphPanel_PackageColumnToolTip");
    private static final String PACKAGE_FILTER_HINT = messages.getString("FlatProfilePanel_PackageFilterHint");
    private static final String TIME_REL_COLUMN_NAME = messages.getString("SubtreeCallGraphPanel_TimeRelColumnName");
    private static final String TIME_REL_COLUMN_TOOLTIP = messages.getString("SubtreeCallGraphPanel_TimeRelColumnToolTip");
    private static final String TIME_COLUMN_NAME = messages.getString("SubtreeCallGraphPanel_TimeColumnName");
    private static final String TIME_COLUMN_TOOLTIP = messages.getString("SubtreeCallGraphPanel_TimeColumnToolTip");
    private static final String TIME_CPU_COLUMN_NAME = messages.getString("SubtreeCallGraphPanel_TimeCpuColumnName");
    private static final String TIME_CPU_COLUMN_TOOLTIP = messages.getString("SubtreeCallGraphPanel_TimeCpuColumnToolTip");
    private static final String INVOCATIONS_COLUMN_NAME = messages.getString("SubtreeCallGraphPanel_InvocationsColumnName");
    private static final String INVOCATIONS_COLUMN_TOOLTIP = messages.getString("SubtreeCallGraphPanel_InvocationsColumnToolTip");
    private static final String TREETABLE_ACCESS_NAME = messages.getString("SubtreeCallGraphPanel_TreeTableAccessName");
    private static final String FILTER_ITEM_NAME = messages.getString("FlatProfilePanel_FilterItemName");
    private static final String SAMPLES_COLUMN_NAME = messages.getString("CCTDisplay_SamplesColumnName");
    private static final String SAMPLES_COLUMN_TOOLTIP = messages.getString("CCTDisplay_SamplesColumnToolTip");
    protected JButton cornerButton;
    protected JTreeTable treeTable;
    protected JTreeTablePanel treeTablePanel;
    protected FilterComponent filterComponent;
    protected PrestimeCPUCCTNode rootNode = null;
    protected boolean sortOrder;
    protected int sortingColumn;
    private AbstractTreeTableModel abstractTreeTableModel;
    private EnhancedTreeCellRenderer enhancedTreeCellRenderer = new MethodNameTreeCellRenderer();
    private ExtendedTreeTableModel treeTableModel;
    private Icon leafIcon = Icons.getIcon((String)"ProfilerIcons.NodeLeaf");
    private Icon nodeIcon = Icons.getIcon((String)"ProfilerIcons.NodeForward");
    private int minNamesColumnWidth;

    public SubtreeCallGraphPanel(CPUResUserActionsHandler actionsHandler, Boolean sampling) {
        super(actionsHandler, sampling);
        this.enhancedTreeCellRenderer.setLeafIcon(this.leafIcon);
        this.enhancedTreeCellRenderer.setClosedIcon(this.nodeIcon);
        this.enhancedTreeCellRenderer.setOpenIcon(this.nodeIcon);
        this.minNamesColumnWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 30;
        this.cornerPopup = new JPopupMenu();
        this.cornerButton = this.createHeaderPopupCornerButton(this.cornerPopup);
        this.setDefaultSorting();
    }

    public void exportData(int exportedFileType, ExportDataDumper eDD, String viewName) {
        this.percentFormat.setMaximumFractionDigits(2);
        this.percentFormat.setMinimumFractionDigits(2);
        PrestimeCPUCCTNodeBacked.setPercentFormat((NumberFormat)this.percentFormat);
        switch (exportedFileType) {
            case 1: {
                eDD.dumpData((CharSequence)this.getCSVHeader(","));
                ((PrestimeCPUCCTNodeBacked)this.abstractTreeTableModel.getRoot()).exportCSVData(",", exportedFileType, eDD);
                eDD.close();
                break;
            }
            case 2: {
                eDD.dumpData((CharSequence)this.getCSVHeader(";"));
                ((PrestimeCPUCCTNodeBacked)this.abstractTreeTableModel.getRoot()).exportCSVData(";", exportedFileType, eDD);
                eDD.close();
                break;
            }
            case 3: {
                eDD.dumpData((CharSequence)this.getXMLHeader(viewName));
                ((PrestimeCPUCCTNodeBacked)this.abstractTreeTableModel.getRoot()).exportXMLData(eDD, "  ");
                eDD.dumpDataAndClose(this.getXMLFooter());
                break;
            }
            case 4: {
                eDD.dumpData((CharSequence)this.getHTMLHeader(viewName));
                ((PrestimeCPUCCTNodeBacked)this.abstractTreeTableModel.getRoot()).exportHTMLData(eDD, 0);
                eDD.dumpDataAndClose(this.getHTMLFooter());
            }
        }
        this.percentFormat.setMaximumFractionDigits(1);
        this.percentFormat.setMinimumFractionDigits(0);
    }

    private StringBuffer getCSVHeader(String separator) {
        String newLine = "\r\n";
        String quote = "\"";
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.columnCount; ++i) {
            result.append(quote).append(this.columnNames[i]).append(quote).append(separator);
        }
        result.append(newLine);
        return result;
    }

    private StringBuffer getHTMLHeader(String viewName) {
        StringBuffer result = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + viewName + "</TITLE><style type=\"text/css\">pre.method{overflow:auto;width:600;height:30;vertical-align:baseline}pre.parent{overflow:auto;width:400;height:30;vertical-align:baseline}td.method{text-align:left;width:600}td.parent{text-align:left;width:400}td.right{text-align:right;white-space:nowrap}</style></HEAD><BODY><table border=\"1\"><tr>");
        for (int i = 0; i < this.columnCount; ++i) {
            result.append("<th>").append(this.columnNames[i]).append(this.columnNames[i].equals("Total Time") ? " [&micro;s]" : "").append("</th>");
        }
        result.append("</tr>");
        return result;
    }

    private StringBuffer getHTMLFooter() {
        return new StringBuffer("</TABLE></BODY></HTML>");
    }

    private StringBuffer getXMLHeader(String viewName) {
        String newline = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + newline + "<ExportedView Name=\"" + viewName + "\" type=\"tree\">" + newline + "<tree>" + newline);
        return result;
    }

    private StringBuffer getXMLFooter() {
        String newline = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer("</tree>" + newline + "</ExportedView>");
        return result;
    }

    @Override
    public int getCurrentThreadId() {
        return this.rootNode != null ? this.rootNode.getThreadId() : 0;
    }

    @Override
    public BufferedImage getCurrentViewScreenshot(boolean onlyVisibleArea) {
        if (this.treeTablePanel == null || this.treeTable == null) {
            return null;
        }
        if (onlyVisibleArea) {
            return UIUtils.createScreenshot(this.treeTablePanel.getScrollPane());
        }
        return UIUtils.createScreenshot(this.treeTable);
    }

    public void setDataToDisplay(CPUResultsSnapshot snapshot, PrestimeCPUCCTNode node, int view) {
        super.setDataToDisplay(snapshot, view);
        this.rootNode = ((PrestimeCPUCCTNodeBacked)node).createRootCopy();
        if (this.popupShowSource != null) {
            this.popupShowSource.setEnabled(this.isShowSourceAvailable());
        }
    }

    public void setDefaultSorting() {
        this.setSorting(1, false);
    }

    @Override
    public String getDefaultViewName() {
        return "cpu-subtree";
    }

    public void setFindString(String findString) {
        this.treeTable.setFindParameters(findString, 0);
    }

    public String getFindString() {
        return this.treeTable.getFindString();
    }

    public boolean isFindStringDefined() {
        return this.treeTable.isFindStringDefined();
    }

    @Override
    public String getSelectedMethodName() {
        int selectedMethodId = this.rootNode.getMethodId();
        String name = this.snapshot.getInstrMethodClasses(this.currentView)[selectedMethodId];
        if (this.currentView == 0) {
            name = name + "." + this.snapshot.getInstrMethodNames()[selectedMethodId] + this.snapshot.getInstrMethodSignatures()[selectedMethodId];
        }
        return name;
    }

    public String getSelectedMethodNameShort() {
        int selectedMethodId = this.rootNode.getMethodId();
        if (this.currentView == 0) {
            return this.snapshot.getInstrMethodNames()[selectedMethodId];
        }
        return this.snapshot.getInstrMethodClasses(this.currentView)[selectedMethodId];
    }

    public String getSelectedThreadName() {
        int threadId = this.rootNode.getThreadId();
        return this.snapshot.getThreadNameForId(threadId);
    }

    public String getShortTitle() {
        return MessageFormat.format(PANEL_TITLE_SHORT, this.getSelectedThreadName(), this.getSelectedMethodNameShort());
    }

    public void setSorting(int sColumn, boolean sOrder) {
        if (sColumn == -1) {
            this.setDefaultSorting();
        } else {
            this.sortingColumn = sColumn;
            this.sortOrder = sOrder;
        }
    }

    @Override
    public int getSortingColumn() {
        return this.sortingColumn;
    }

    @Override
    public boolean getSortingOrder() {
        return this.sortOrder;
    }

    public String getTitle() {
        return MessageFormat.format(PANEL_TITLE, this.getSelectedThreadName(), this.getSelectedMethodName());
    }

    public boolean findFirst() {
        return this.treeTable.findFirst();
    }

    public boolean findNext() {
        return this.treeTable.findNext();
    }

    public boolean findPrevious() {
        return this.treeTable.findPrevious();
    }

    @Override
    public boolean fitsVisibleArea() {
        return !this.treeTablePanel.getScrollPane().getVerticalScrollBar().isEnabled();
    }

    @Override
    public void prepareResults() {
        this.initColumnsData();
        this.abstractTreeTableModel = new AbstractTreeTableModel((CCTNode)this.rootNode, this.sortingColumn, this.sortOrder){

            @Override
            public int getColumnCount() {
                return SubtreeCallGraphPanel.this.columnCount;
            }

            @Override
            public String getColumnName(int column) {
                return SubtreeCallGraphPanel.this.columnNames[column];
            }

            @Override
            public Class getColumnClass(int column) {
                if (column == 0) {
                    return TreeTableModel.class;
                }
                return Object.class;
            }

            @Override
            public Object getValueAt(Object node, int column) {
                if (!SubtreeCallGraphPanel.this.snapshot.isCollectingTwoTimeStamps() && column > 2) {
                    ++column;
                }
                PrestimeCPUCCTNode pNode = (PrestimeCPUCCTNode)node;
                switch (column) {
                    case 0: {
                        return this.getNodeName(pNode);
                    }
                    case 1: {
                        return this.getNodeTimeRel(pNode);
                    }
                    case 2: {
                        return this.getNodeTime(pNode);
                    }
                    case 3: {
                        return this.getNodeSecondaryTime(pNode);
                    }
                    case 4: {
                        return this.getNodeInvocations(pNode);
                    }
                }
                return null;
            }

            @Override
            public String getColumnToolTipText(int col) {
                return SubtreeCallGraphPanel.this.columnToolTips[col];
            }

            private String getNodeName(PrestimeCPUCCTNode pNode) {
                return pNode.toString();
            }

            private Float getNodeTimeRel(PrestimeCPUCCTNode pNode) {
                return new Float(pNode.getTotalTime0InPerCent());
            }

            private String getNodeTime(PrestimeCPUCCTNode pNode) {
                return StringUtils.mcsTimeToString((long)pNode.getTotalTime0()) + " ms (" + SubtreeCallGraphPanel.this.percentFormat.format(pNode.getTotalTime0InPerCent() / 100.0f) + ")";
            }

            private String getNodeSecondaryTime(PrestimeCPUCCTNode pNode) {
                return StringUtils.mcsTimeToString((long)pNode.getTotalTime1()) + " ms";
            }

            private Integer getNodeInvocations(PrestimeCPUCCTNode pNode) {
                return pNode.getNCalls();
            }

            @Override
            public void sortByColumn(int column, boolean order) {
                SubtreeCallGraphPanel.this.sortOrder = order;
                if (!SubtreeCallGraphPanel.this.snapshot.isCollectingTwoTimeStamps() && column > 2) {
                    ++column;
                }
                PrestimeCPUCCTNode pRoot = (PrestimeCPUCCTNode)this.root;
                switch (column) {
                    case 0: {
                        pRoot.sortChildren(1, order);
                        break;
                    }
                    case 1: {
                        pRoot.sortChildren(2, order);
                        break;
                    }
                    case 2: {
                        pRoot.sortChildren(2, order);
                        break;
                    }
                    case 3: {
                        pRoot.sortChildren(3, order);
                        break;
                    }
                    case 4: {
                        pRoot.sortChildren(4, order);
                    }
                }
            }

            @Override
            public boolean getInitialSorting(int column) {
                return column == 0;
            }
        };
        this.treeTableModel = new ExtendedTreeTableModel(this.abstractTreeTableModel);
        if (this.columnsVisibility != null) {
            this.treeTableModel.setColumnsVisibility(this.columnsVisibility);
        }
        this.treeTable = new JTreeTable(this.treeTableModel){

            @Override
            public void doLayout() {
                int columnsWidthsSum = 0;
                int realFirstColumn = -1;
                TableColumnModel colModel = this.getColumnModel();
                for (int i = 0; i < SubtreeCallGraphPanel.this.treeTableModel.getColumnCount(); ++i) {
                    int index = SubtreeCallGraphPanel.this.treeTableModel.getRealColumn(i);
                    if (index == 0) {
                        realFirstColumn = i;
                        continue;
                    }
                    columnsWidthsSum += colModel.getColumn(i).getPreferredWidth();
                }
                if (realFirstColumn != -1) {
                    colModel.getColumn(realFirstColumn).setPreferredWidth(Math.max(this.getWidth() - columnsWidthsSum, SubtreeCallGraphPanel.this.minNamesColumnWidth));
                }
                super.doLayout();
            }
        };
        this.treeTable.getAccessibleContext().setAccessibleName(TREETABLE_ACCESS_NAME);
        this.treeTable.setRowSelectionAllowed(true);
        this.treeTable.setSelectionMode(0);
        this.treeTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.treeTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.treeTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.treeTable.setShowHorizontalLines(false);
        this.treeTable.setShowVerticalLines(true);
        this.treeTable.setRowMargin(0);
        this.treeTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.treeTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.treeTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubtreeCallGraphPanel.this.performDefaultAction();
            }
        });
        HashSet<AWTKeyStroke> keys = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(0));
        keys.add(KeyStroke.getKeyStroke(9, 0));
        this.treeTable.setFocusTraversalKeys(0, keys);
        keys = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(1));
        keys.add(KeyStroke.getKeyStroke(9, 1));
        this.treeTable.setFocusTraversalKeys(1, keys);
        this.setColumnsData();
        UIUtils.autoExpandRoot(this.treeTable.getTree(), 2);
        UIUtils.makeTreeAutoExpandable(this.treeTable.getTree(), 2);
        this.treeTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int selectedRow;
                if ((e.getKeyCode() == 525 || e.getKeyCode() == 121 && e.getModifiers() == 1) && (selectedRow = SubtreeCallGraphPanel.this.treeTable.getSelectedRow()) != -1) {
                    SubtreeCallGraphPanel.this.popupPath = SubtreeCallGraphPanel.this.treeTable.getTree().getPathForRow(selectedRow);
                    PrestimeCPUCCTNode node = (PrestimeCPUCCTNode)SubtreeCallGraphPanel.this.popupPath.getLastPathComponent();
                    SubtreeCallGraphPanel.this.enableDisablePopup(node);
                    Rectangle cellRect = SubtreeCallGraphPanel.this.treeTable.getCellRect(selectedRow, 0, false);
                    SubtreeCallGraphPanel.this.callGraphPopupMenu.show(e.getComponent(), cellRect.x + SubtreeCallGraphPanel.this.treeTable.getSize().width > 50 ? 50 : 5, cellRect.y);
                }
            }
        });
        this.treeTable.addMouseListener(new MouseAdapter(){

            private void showPopupMenu(MouseEvent e) {
                SubtreeCallGraphPanel.this.popupPath = SubtreeCallGraphPanel.this.treeTable.getTree().getPathForRow(SubtreeCallGraphPanel.this.treeTable.rowAtPoint(e.getPoint()));
                if (SubtreeCallGraphPanel.this.popupPath == null) {
                    SubtreeCallGraphPanel.this.treeTable.getTree().clearSelection();
                } else {
                    SubtreeCallGraphPanel.this.treeTable.getTree().setSelectionPath(SubtreeCallGraphPanel.this.popupPath);
                    PrestimeCPUCCTNode node = (PrestimeCPUCCTNode)SubtreeCallGraphPanel.this.popupPath.getLastPathComponent();
                    SubtreeCallGraphPanel.this.enableDisablePopup(node);
                    SubtreeCallGraphPanel.this.callGraphPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                SubtreeCallGraphPanel.this.popupPath = SubtreeCallGraphPanel.this.treeTable.getTree().getPathForRow(SubtreeCallGraphPanel.this.treeTable.rowAtPoint(e.getPoint()));
                if (SubtreeCallGraphPanel.this.popupPath != null) {
                    SubtreeCallGraphPanel.this.treeTable.getTree().setSelectionPath(SubtreeCallGraphPanel.this.popupPath);
                    if (e.getModifiers() == 16 && e.getClickCount() == 2 && SubtreeCallGraphPanel.this.treeTableModel.isLeaf(SubtreeCallGraphPanel.this.popupPath.getPath()[SubtreeCallGraphPanel.this.popupPath.getPath().length - 1])) {
                        SubtreeCallGraphPanel.this.showSourceForMethod(SubtreeCallGraphPanel.this.popupPath);
                    }
                }
            }
        });
        this.treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = SubtreeCallGraphPanel.this.treeTable.getSelectedRow();
                if (selectedRow == -1) {
                    return;
                }
                SubtreeCallGraphPanel.this.popupPath = SubtreeCallGraphPanel.this.treeTable.getTree().getPathForRow(selectedRow);
            }
        });
        this.treeTablePanel = new JTreeTablePanel(this.treeTable);
        this.treeTablePanel.setCorner("UPPER_RIGHT_CORNER", this.cornerButton);
        this.treeTablePanel.clearBorders();
        this.add((Component)this.treeTablePanel, "Center");
        this.initFilterPanel();
        this.initFirstColumnName();
    }

    private void initFilterPanel() {
        this.filterComponent = FilterComponent.create(true, true);
        FilterSortSupport.Configuration config = this.snapshot.getFilterSortInfo((CCTNode)((PrestimeCPUCCTNode)this.treeTableModel.getRoot()));
        this.filterComponent.setFilter(config.getFilterString(), config.getFilterType());
        this.filterComponent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String filterString = SubtreeCallGraphPanel.this.filterComponent.getFilterValue();
                int filterType = SubtreeCallGraphPanel.this.filterComponent.getFilterType();
                SubtreeCallGraphPanel.this.snapshot.filterForward(filterString, filterType, (PrestimeCPUCCTNodeBacked)SubtreeCallGraphPanel.this.treeTableModel.getRoot());
                SubtreeCallGraphPanel.this.treeTable.updateTreeTable();
            }
        });
        this.add((Component)this.filterComponent.getComponent(), "South");
    }

    @Override
    public void requestFocus() {
        if (this.treeTable != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SubtreeCallGraphPanel.this.treeTable.requestFocus();
                }
            });
        }
    }

    @Override
    public void reset() {
        if (this.treeTablePanel != null) {
            this.remove(this.treeTablePanel);
            this.treeTablePanel = null;
            this.remove(this.filterComponent.getComponent());
            this.filterComponent = null;
        }
        this.treeTable = null;
        this.abstractTreeTableModel = null;
        this.treeTableModel = null;
    }

    @Override
    protected boolean isCloseable() {
        return true;
    }

    @Override
    protected void initColumnSelectorItems() {
        this.cornerPopup.removeAll();
        for (int i = 0; i < this.columnCount; ++i) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(this.columnNames[i]);
            menuItem.setActionCommand(Integer.toString(i));
            this.addMenuItemListener(menuItem);
            if (this.treeTable != null) {
                menuItem.setState(this.treeTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    menuItem.setEnabled(false);
                }
            } else {
                menuItem.setState(true);
            }
            this.cornerPopup.add(menuItem);
        }
        this.cornerPopup.addSeparator();
        JCheckBoxMenuItem filterMenuItem = new JCheckBoxMenuItem(FILTER_ITEM_NAME);
        filterMenuItem.setActionCommand("Filter");
        this.addMenuItemListener(filterMenuItem);
        if (this.filterComponent == null) {
            filterMenuItem.setState(true);
        } else {
            filterMenuItem.setState(this.filterComponent.getComponent().isVisible());
        }
        this.cornerPopup.add(filterMenuItem);
        this.cornerPopup.pack();
    }

    private void setColumnsData() {
        TableColumnModel colModel = this.treeTable.getColumnModel();
        this.treeTable.setTreeCellRenderer(this.enhancedTreeCellRenderer);
        colModel.getColumn(0).setPreferredWidth(this.minNamesColumnWidth);
        for (int i = 0; i < this.treeTableModel.getColumnCount(); ++i) {
            int index = this.treeTableModel.getRealColumn(i);
            if (index == 0) continue;
            colModel.getColumn(i).setPreferredWidth(this.columnWidths[index - 1]);
            colModel.getColumn(i).setCellRenderer(this.columnRenderers[index]);
        }
    }

    private void addMenuItemListener(JCheckBoxMenuItem menuItem) {
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Filter")) {
                    SubtreeCallGraphPanel.this.filterComponent.getComponent().setVisible(!SubtreeCallGraphPanel.this.filterComponent.getComponent().isVisible());
                    return;
                }
                boolean sortResults = false;
                int column = Integer.parseInt(e.getActionCommand());
                boolean sortOrder = SubtreeCallGraphPanel.this.treeTable.getSortingOrder();
                int sortingColumn = SubtreeCallGraphPanel.this.treeTable.getSortingColumn();
                int realSortingColumn = SubtreeCallGraphPanel.this.treeTableModel.getRealColumn(sortingColumn);
                boolean isColumnVisible = SubtreeCallGraphPanel.this.treeTableModel.isRealColumnVisible(column);
                if (isColumnVisible && column == realSortingColumn) {
                    sortingColumn = sortingColumn + 1 == SubtreeCallGraphPanel.this.treeTableModel.getColumnCount() ? sortingColumn - 1 : sortingColumn + 1;
                    realSortingColumn = SubtreeCallGraphPanel.this.treeTableModel.getRealColumn(sortingColumn);
                    sortResults = true;
                }
                SubtreeCallGraphPanel.this.treeTableModel.setRealColumnVisibility(column, !isColumnVisible);
                SubtreeCallGraphPanel.this.treeTable.createDefaultColumnsFromModel();
                SubtreeCallGraphPanel.this.treeTable.updateTreeTableHeader();
                sortingColumn = SubtreeCallGraphPanel.this.treeTableModel.getVirtualColumn(realSortingColumn);
                if (sortResults) {
                    sortOrder = SubtreeCallGraphPanel.this.treeTableModel.getInitialSorting(sortingColumn);
                    SubtreeCallGraphPanel.this.treeTableModel.sortByColumn(sortingColumn, sortOrder);
                    SubtreeCallGraphPanel.this.treeTable.updateTreeTable();
                }
                SubtreeCallGraphPanel.this.treeTable.setSortingColumn(sortingColumn);
                SubtreeCallGraphPanel.this.treeTable.setSortingOrder(sortOrder);
                SubtreeCallGraphPanel.this.treeTable.getTableHeader().repaint();
                SubtreeCallGraphPanel.this.setColumnsData();
            }
        });
    }

    private void enableDisablePopup(PrestimeCPUCCTNode node) {
        boolean regularNode;
        boolean bl = regularNode = node.getThreadId() != -1 && node.getMethodId() != 0 && !node.isFiltered();
        if (this.popupShowSource != null) {
            this.popupShowSource.setEnabled(regularNode && this.isShowSourceAvailable());
        }
        if (this.popupShowSubtree != null) {
            this.popupShowSubtree.setEnabled(regularNode);
        }
        if (this.popupShowReverse != null) {
            this.popupShowReverse.setEnabled(regularNode);
        }
        this.popupFind.setEnabled(regularNode);
    }

    private void initColumnsData() {
        this.columnCount = this.snapshot.isCollectingTwoTimeStamps() ? 5 : 4;
        this.columnWidths = new int[this.columnCount - 1];
        this.columnNames = new String[this.columnCount];
        this.columnRenderers = new TableCellRenderer[this.columnCount];
        this.columnsVisibility = new boolean[this.columnCount];
        for (int i = 0; i < this.columnCount - 1; ++i) {
            this.columnsVisibility[i] = true;
        }
        if (this.isSampling() != null && !this.isSampling().booleanValue()) {
            this.columnsVisibility[this.columnCount - 1] = true;
        }
        if (this.columnCount == 5) {
            this.columnNames = new String[]{METHOD_COLUMN_NAME, TIME_REL_COLUMN_NAME, TIME_COLUMN_NAME, TIME_CPU_COLUMN_NAME, INVOCATIONS_COLUMN_NAME};
            this.columnToolTips = new String[]{METHOD_COLUMN_TOOLTIP, TIME_REL_COLUMN_TOOLTIP, TIME_COLUMN_TOOLTIP, TIME_CPU_COLUMN_TOOLTIP, INVOCATIONS_COLUMN_TOOLTIP};
        } else {
            this.columnNames = new String[]{METHOD_COLUMN_NAME, TIME_REL_COLUMN_NAME, TIME_COLUMN_NAME, INVOCATIONS_COLUMN_NAME};
            this.columnToolTips = new String[]{METHOD_COLUMN_TOOLTIP, TIME_REL_COLUMN_TOOLTIP, TIME_COLUMN_TOOLTIP, INVOCATIONS_COLUMN_TOOLTIP};
        }
        if (this.isSampling() != null && this.isSampling().booleanValue()) {
            this.columnNames[this.columnCount - 1] = SAMPLES_COLUMN_NAME;
            this.columnToolTips[this.columnCount - 1] = SAMPLES_COLUMN_TOOLTIP;
        }
        int maxWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 12;
        CustomBarCellRenderer customBarCellRenderer = new CustomBarCellRenderer(0L, 100L);
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(11);
        LabelBracketTableCellRenderer labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        this.columnRenderers[0] = null;
        this.columnWidths[0] = maxWidth;
        this.columnRenderers[1] = customBarCellRenderer;
        this.columnWidths[1] = maxWidth;
        this.columnRenderers[2] = labelBracketTableCellRenderer;
        for (int i = 3; i < this.columnCount; ++i) {
            this.columnWidths[i - 1] = maxWidth;
            this.columnRenderers[i] = labelTableCellRenderer;
        }
        if (this.isSampling() == null) {
            --this.columnCount;
        }
    }

    private void initFirstColumnName() {
        switch (this.currentView) {
            case 0: {
                this.columnNames[0] = METHOD_COLUMN_NAME;
                this.columnToolTips[0] = METHOD_COLUMN_TOOLTIP;
                this.filterComponent.setHint(METHOD_FILTER_HINT);
                break;
            }
            case 1: {
                this.columnNames[0] = CLASS_COLUMN_NAME;
                this.columnToolTips[0] = CLASS_COLUMN_TOOLTIP;
                this.filterComponent.setHint(CLASS_FILTER_HINT);
                break;
            }
            case 2: {
                this.columnNames[0] = PACKAGE_COLUMN_NAME;
                this.columnToolTips[0] = PACKAGE_COLUMN_TOOLTIP;
                this.filterComponent.setHint(PACKAGE_FILTER_HINT);
            }
        }
    }
}

