"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutomatedSingleSignOn = void 0;
const Electron = __importStar(require("electron"));
const eventType_1 = require("../lib/eventType");
const locale_1 = require("../locale");
const config_1 = require("../settings/config");
const dialog = Electron.dialog || require('@electron/remote').dialog;
class AutomatedSingleSignOn {
    showError() {
        return __awaiter(this, void 0, void 0, function* () {
            let detail = (0, locale_1.getText)('wrapperAddAccountErrorMessagePlural');
            let message = (0, locale_1.getText)('wrapperAddAccountErrorTitlePlural');
            if (config_1.config.maximumAccounts === 1) {
                detail = (0, locale_1.getText)('wrapperAddAccountErrorMessageSingular');
                message = (0, locale_1.getText)('wrapperAddAccountErrorTitleSingular');
            }
            yield dialog.showMessageBox({
                detail,
                message,
                type: 'warning',
            });
        });
    }
    start(ssoCode) {
        return __awaiter(this, void 0, void 0, function* () {
            window.addEventListener(eventType_1.EVENT_TYPE.ACTION.CREATE_SSO_ACCOUNT_RESPONSE, (event) => __awaiter(this, void 0, void 0, function* () {
                const data = event.detail;
                if (data === null || data === void 0 ? void 0 : data.reachedMaximumAccounts) {
                    yield this.showError();
                }
            }), {
                once: true,
            });
            window.dispatchEvent(new CustomEvent(eventType_1.EVENT_TYPE.ACTION.CREATE_SSO_ACCOUNT, {
                detail: {
                    code: ssoCode,
                },
            }));
        });
    }
}
exports.AutomatedSingleSignOn = AutomatedSingleSignOn;
//# sourceMappingURL=AutomatedSingleSignOn.js.map