/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
"use strict";

var $protobuf = require("protobufjs/minimal");

// Common aliases
var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;

// Exported root namespace
var $root = $protobuf.roots["default"] || ($protobuf.roots["default"] = {});

$root.proteus = (function() {

    /**
     * Namespace proteus.
     * @exports proteus
     * @namespace
     */
    var proteus = {};

    proteus.UserId = (function() {

        /**
         * Properties of a UserId.
         * @memberof proteus
         * @interface IUserId
         * @property {Uint8Array} uuid UserId uuid
         */

        /**
         * Constructs a new UserId.
         * @memberof proteus
         * @classdesc Represents a UserId.
         * @implements IUserId
         * @constructor
         * @param {proteus.IUserId=} [properties] Properties to set
         */
        function UserId(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * UserId uuid.
         * @member {Uint8Array} uuid
         * @memberof proteus.UserId
         * @instance
         */
        UserId.prototype.uuid = $util.newBuffer([]);

        /**
         * Creates a new UserId instance using the specified properties.
         * @function create
         * @memberof proteus.UserId
         * @static
         * @param {proteus.IUserId=} [properties] Properties to set
         * @returns {proteus.UserId} UserId instance
         */
        UserId.create = function create(properties) {
            return new UserId(properties);
        };

        /**
         * Encodes the specified UserId message. Does not implicitly {@link proteus.UserId.verify|verify} messages.
         * @function encode
         * @memberof proteus.UserId
         * @static
         * @param {proteus.IUserId} message UserId message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UserId.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.uuid);
            return writer;
        };

        /**
         * Encodes the specified UserId message, length delimited. Does not implicitly {@link proteus.UserId.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proteus.UserId
         * @static
         * @param {proteus.IUserId} message UserId message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UserId.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a UserId message from the specified reader or buffer.
         * @function decode
         * @memberof proteus.UserId
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proteus.UserId} UserId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UserId.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proteus.UserId();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.uuid = reader.bytes();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            if (!message.hasOwnProperty("uuid"))
                throw $util.ProtocolError("missing required 'uuid'", { instance: message });
            return message;
        };

        /**
         * Decodes a UserId message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proteus.UserId
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proteus.UserId} UserId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UserId.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a UserId message.
         * @function verify
         * @memberof proteus.UserId
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        UserId.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (!(message.uuid && typeof message.uuid.length === "number" || $util.isString(message.uuid)))
                return "uuid: buffer expected";
            return null;
        };

        /**
         * Creates a UserId message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proteus.UserId
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proteus.UserId} UserId
         */
        UserId.fromObject = function fromObject(object) {
            if (object instanceof $root.proteus.UserId)
                return object;
            var message = new $root.proteus.UserId();
            if (object.uuid != null)
                if (typeof object.uuid === "string")
                    $util.base64.decode(object.uuid, message.uuid = $util.newBuffer($util.base64.length(object.uuid)), 0);
                else if (object.uuid.length >= 0)
                    message.uuid = object.uuid;
            return message;
        };

        /**
         * Creates a plain object from a UserId message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proteus.UserId
         * @static
         * @param {proteus.UserId} message UserId
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        UserId.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                if (options.bytes === String)
                    object.uuid = "";
                else {
                    object.uuid = [];
                    if (options.bytes !== Array)
                        object.uuid = $util.newBuffer(object.uuid);
                }
            if (message.uuid != null && message.hasOwnProperty("uuid"))
                object.uuid = options.bytes === String ? $util.base64.encode(message.uuid, 0, message.uuid.length) : options.bytes === Array ? Array.prototype.slice.call(message.uuid) : message.uuid;
            return object;
        };

        /**
         * Converts this UserId to JSON.
         * @function toJSON
         * @memberof proteus.UserId
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        UserId.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for UserId
         * @function getTypeUrl
         * @memberof proteus.UserId
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        UserId.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proteus.UserId";
        };

        return UserId;
    })();

    proteus.QualifiedUserId = (function() {

        /**
         * Properties of a QualifiedUserId.
         * @memberof proteus
         * @interface IQualifiedUserId
         * @property {string} id QualifiedUserId id
         * @property {string} domain QualifiedUserId domain
         */

        /**
         * Constructs a new QualifiedUserId.
         * @memberof proteus
         * @classdesc Represents a QualifiedUserId.
         * @implements IQualifiedUserId
         * @constructor
         * @param {proteus.IQualifiedUserId=} [properties] Properties to set
         */
        function QualifiedUserId(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * QualifiedUserId id.
         * @member {string} id
         * @memberof proteus.QualifiedUserId
         * @instance
         */
        QualifiedUserId.prototype.id = "";

        /**
         * QualifiedUserId domain.
         * @member {string} domain
         * @memberof proteus.QualifiedUserId
         * @instance
         */
        QualifiedUserId.prototype.domain = "";

        /**
         * Creates a new QualifiedUserId instance using the specified properties.
         * @function create
         * @memberof proteus.QualifiedUserId
         * @static
         * @param {proteus.IQualifiedUserId=} [properties] Properties to set
         * @returns {proteus.QualifiedUserId} QualifiedUserId instance
         */
        QualifiedUserId.create = function create(properties) {
            return new QualifiedUserId(properties);
        };

        /**
         * Encodes the specified QualifiedUserId message. Does not implicitly {@link proteus.QualifiedUserId.verify|verify} messages.
         * @function encode
         * @memberof proteus.QualifiedUserId
         * @static
         * @param {proteus.IQualifiedUserId} message QualifiedUserId message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QualifiedUserId.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.id);
            writer.uint32(/* id 2, wireType 2 =*/18).string(message.domain);
            return writer;
        };

        /**
         * Encodes the specified QualifiedUserId message, length delimited. Does not implicitly {@link proteus.QualifiedUserId.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proteus.QualifiedUserId
         * @static
         * @param {proteus.IQualifiedUserId} message QualifiedUserId message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QualifiedUserId.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a QualifiedUserId message from the specified reader or buffer.
         * @function decode
         * @memberof proteus.QualifiedUserId
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proteus.QualifiedUserId} QualifiedUserId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QualifiedUserId.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proteus.QualifiedUserId();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.id = reader.string();
                        break;
                    }
                case 2: {
                        message.domain = reader.string();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            if (!message.hasOwnProperty("id"))
                throw $util.ProtocolError("missing required 'id'", { instance: message });
            if (!message.hasOwnProperty("domain"))
                throw $util.ProtocolError("missing required 'domain'", { instance: message });
            return message;
        };

        /**
         * Decodes a QualifiedUserId message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proteus.QualifiedUserId
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proteus.QualifiedUserId} QualifiedUserId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QualifiedUserId.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a QualifiedUserId message.
         * @function verify
         * @memberof proteus.QualifiedUserId
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        QualifiedUserId.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (!$util.isString(message.id))
                return "id: string expected";
            if (!$util.isString(message.domain))
                return "domain: string expected";
            return null;
        };

        /**
         * Creates a QualifiedUserId message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proteus.QualifiedUserId
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proteus.QualifiedUserId} QualifiedUserId
         */
        QualifiedUserId.fromObject = function fromObject(object) {
            if (object instanceof $root.proteus.QualifiedUserId)
                return object;
            var message = new $root.proteus.QualifiedUserId();
            if (object.id != null)
                message.id = String(object.id);
            if (object.domain != null)
                message.domain = String(object.domain);
            return message;
        };

        /**
         * Creates a plain object from a QualifiedUserId message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proteus.QualifiedUserId
         * @static
         * @param {proteus.QualifiedUserId} message QualifiedUserId
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        QualifiedUserId.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.id = "";
                object.domain = "";
            }
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            if (message.domain != null && message.hasOwnProperty("domain"))
                object.domain = message.domain;
            return object;
        };

        /**
         * Converts this QualifiedUserId to JSON.
         * @function toJSON
         * @memberof proteus.QualifiedUserId
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        QualifiedUserId.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for QualifiedUserId
         * @function getTypeUrl
         * @memberof proteus.QualifiedUserId
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        QualifiedUserId.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proteus.QualifiedUserId";
        };

        return QualifiedUserId;
    })();

    proteus.ClientId = (function() {

        /**
         * Properties of a ClientId.
         * @memberof proteus
         * @interface IClientId
         * @property {number|Long} client ClientId client
         */

        /**
         * Constructs a new ClientId.
         * @memberof proteus
         * @classdesc Represents a ClientId.
         * @implements IClientId
         * @constructor
         * @param {proteus.IClientId=} [properties] Properties to set
         */
        function ClientId(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ClientId client.
         * @member {number|Long} client
         * @memberof proteus.ClientId
         * @instance
         */
        ClientId.prototype.client = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Creates a new ClientId instance using the specified properties.
         * @function create
         * @memberof proteus.ClientId
         * @static
         * @param {proteus.IClientId=} [properties] Properties to set
         * @returns {proteus.ClientId} ClientId instance
         */
        ClientId.create = function create(properties) {
            return new ClientId(properties);
        };

        /**
         * Encodes the specified ClientId message. Does not implicitly {@link proteus.ClientId.verify|verify} messages.
         * @function encode
         * @memberof proteus.ClientId
         * @static
         * @param {proteus.IClientId} message ClientId message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClientId.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            writer.uint32(/* id 1, wireType 0 =*/8).uint64(message.client);
            return writer;
        };

        /**
         * Encodes the specified ClientId message, length delimited. Does not implicitly {@link proteus.ClientId.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proteus.ClientId
         * @static
         * @param {proteus.IClientId} message ClientId message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClientId.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ClientId message from the specified reader or buffer.
         * @function decode
         * @memberof proteus.ClientId
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proteus.ClientId} ClientId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClientId.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proteus.ClientId();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.client = reader.uint64();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            if (!message.hasOwnProperty("client"))
                throw $util.ProtocolError("missing required 'client'", { instance: message });
            return message;
        };

        /**
         * Decodes a ClientId message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proteus.ClientId
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proteus.ClientId} ClientId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClientId.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ClientId message.
         * @function verify
         * @memberof proteus.ClientId
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ClientId.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (!$util.isInteger(message.client) && !(message.client && $util.isInteger(message.client.low) && $util.isInteger(message.client.high)))
                return "client: integer|Long expected";
            return null;
        };

        /**
         * Creates a ClientId message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proteus.ClientId
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proteus.ClientId} ClientId
         */
        ClientId.fromObject = function fromObject(object) {
            if (object instanceof $root.proteus.ClientId)
                return object;
            var message = new $root.proteus.ClientId();
            if (object.client != null)
                if ($util.Long)
                    (message.client = $util.Long.fromValue(object.client)).unsigned = true;
                else if (typeof object.client === "string")
                    message.client = parseInt(object.client, 10);
                else if (typeof object.client === "number")
                    message.client = object.client;
                else if (typeof object.client === "object")
                    message.client = new $util.LongBits(object.client.low >>> 0, object.client.high >>> 0).toNumber(true);
            return message;
        };

        /**
         * Creates a plain object from a ClientId message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proteus.ClientId
         * @static
         * @param {proteus.ClientId} message ClientId
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ClientId.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.client = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.client = options.longs === String ? "0" : 0;
            if (message.client != null && message.hasOwnProperty("client"))
                if (typeof message.client === "number")
                    object.client = options.longs === String ? String(message.client) : message.client;
                else
                    object.client = options.longs === String ? $util.Long.prototype.toString.call(message.client) : options.longs === Number ? new $util.LongBits(message.client.low >>> 0, message.client.high >>> 0).toNumber(true) : message.client;
            return object;
        };

        /**
         * Converts this ClientId to JSON.
         * @function toJSON
         * @memberof proteus.ClientId
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ClientId.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for ClientId
         * @function getTypeUrl
         * @memberof proteus.ClientId
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        ClientId.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proteus.ClientId";
        };

        return ClientId;
    })();

    proteus.ClientEntry = (function() {

        /**
         * Properties of a ClientEntry.
         * @memberof proteus
         * @interface IClientEntry
         * @property {proteus.IClientId} client ClientEntry client
         * @property {Uint8Array} text ClientEntry text
         */

        /**
         * Constructs a new ClientEntry.
         * @memberof proteus
         * @classdesc Represents a ClientEntry.
         * @implements IClientEntry
         * @constructor
         * @param {proteus.IClientEntry=} [properties] Properties to set
         */
        function ClientEntry(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ClientEntry client.
         * @member {proteus.IClientId} client
         * @memberof proteus.ClientEntry
         * @instance
         */
        ClientEntry.prototype.client = null;

        /**
         * ClientEntry text.
         * @member {Uint8Array} text
         * @memberof proteus.ClientEntry
         * @instance
         */
        ClientEntry.prototype.text = $util.newBuffer([]);

        /**
         * Creates a new ClientEntry instance using the specified properties.
         * @function create
         * @memberof proteus.ClientEntry
         * @static
         * @param {proteus.IClientEntry=} [properties] Properties to set
         * @returns {proteus.ClientEntry} ClientEntry instance
         */
        ClientEntry.create = function create(properties) {
            return new ClientEntry(properties);
        };

        /**
         * Encodes the specified ClientEntry message. Does not implicitly {@link proteus.ClientEntry.verify|verify} messages.
         * @function encode
         * @memberof proteus.ClientEntry
         * @static
         * @param {proteus.IClientEntry} message ClientEntry message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClientEntry.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            $root.proteus.ClientId.encode(message.client, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.text);
            return writer;
        };

        /**
         * Encodes the specified ClientEntry message, length delimited. Does not implicitly {@link proteus.ClientEntry.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proteus.ClientEntry
         * @static
         * @param {proteus.IClientEntry} message ClientEntry message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClientEntry.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ClientEntry message from the specified reader or buffer.
         * @function decode
         * @memberof proteus.ClientEntry
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proteus.ClientEntry} ClientEntry
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClientEntry.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proteus.ClientEntry();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.client = $root.proteus.ClientId.decode(reader, reader.uint32());
                        break;
                    }
                case 2: {
                        message.text = reader.bytes();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            if (!message.hasOwnProperty("client"))
                throw $util.ProtocolError("missing required 'client'", { instance: message });
            if (!message.hasOwnProperty("text"))
                throw $util.ProtocolError("missing required 'text'", { instance: message });
            return message;
        };

        /**
         * Decodes a ClientEntry message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proteus.ClientEntry
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proteus.ClientEntry} ClientEntry
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClientEntry.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ClientEntry message.
         * @function verify
         * @memberof proteus.ClientEntry
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ClientEntry.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            {
                var error = $root.proteus.ClientId.verify(message.client);
                if (error)
                    return "client." + error;
            }
            if (!(message.text && typeof message.text.length === "number" || $util.isString(message.text)))
                return "text: buffer expected";
            return null;
        };

        /**
         * Creates a ClientEntry message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proteus.ClientEntry
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proteus.ClientEntry} ClientEntry
         */
        ClientEntry.fromObject = function fromObject(object) {
            if (object instanceof $root.proteus.ClientEntry)
                return object;
            var message = new $root.proteus.ClientEntry();
            if (object.client != null) {
                if (typeof object.client !== "object")
                    throw TypeError(".proteus.ClientEntry.client: object expected");
                message.client = $root.proteus.ClientId.fromObject(object.client);
            }
            if (object.text != null)
                if (typeof object.text === "string")
                    $util.base64.decode(object.text, message.text = $util.newBuffer($util.base64.length(object.text)), 0);
                else if (object.text.length >= 0)
                    message.text = object.text;
            return message;
        };

        /**
         * Creates a plain object from a ClientEntry message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proteus.ClientEntry
         * @static
         * @param {proteus.ClientEntry} message ClientEntry
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ClientEntry.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.client = null;
                if (options.bytes === String)
                    object.text = "";
                else {
                    object.text = [];
                    if (options.bytes !== Array)
                        object.text = $util.newBuffer(object.text);
                }
            }
            if (message.client != null && message.hasOwnProperty("client"))
                object.client = $root.proteus.ClientId.toObject(message.client, options);
            if (message.text != null && message.hasOwnProperty("text"))
                object.text = options.bytes === String ? $util.base64.encode(message.text, 0, message.text.length) : options.bytes === Array ? Array.prototype.slice.call(message.text) : message.text;
            return object;
        };

        /**
         * Converts this ClientEntry to JSON.
         * @function toJSON
         * @memberof proteus.ClientEntry
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ClientEntry.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for ClientEntry
         * @function getTypeUrl
         * @memberof proteus.ClientEntry
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        ClientEntry.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proteus.ClientEntry";
        };

        return ClientEntry;
    })();

    proteus.UserEntry = (function() {

        /**
         * Properties of a UserEntry.
         * @memberof proteus
         * @interface IUserEntry
         * @property {proteus.IUserId} user UserEntry user
         * @property {Array.<proteus.IClientEntry>|null} [clients] UserEntry clients
         */

        /**
         * Constructs a new UserEntry.
         * @memberof proteus
         * @classdesc Represents a UserEntry.
         * @implements IUserEntry
         * @constructor
         * @param {proteus.IUserEntry=} [properties] Properties to set
         */
        function UserEntry(properties) {
            this.clients = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * UserEntry user.
         * @member {proteus.IUserId} user
         * @memberof proteus.UserEntry
         * @instance
         */
        UserEntry.prototype.user = null;

        /**
         * UserEntry clients.
         * @member {Array.<proteus.IClientEntry>} clients
         * @memberof proteus.UserEntry
         * @instance
         */
        UserEntry.prototype.clients = $util.emptyArray;

        /**
         * Creates a new UserEntry instance using the specified properties.
         * @function create
         * @memberof proteus.UserEntry
         * @static
         * @param {proteus.IUserEntry=} [properties] Properties to set
         * @returns {proteus.UserEntry} UserEntry instance
         */
        UserEntry.create = function create(properties) {
            return new UserEntry(properties);
        };

        /**
         * Encodes the specified UserEntry message. Does not implicitly {@link proteus.UserEntry.verify|verify} messages.
         * @function encode
         * @memberof proteus.UserEntry
         * @static
         * @param {proteus.IUserEntry} message UserEntry message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UserEntry.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            $root.proteus.UserId.encode(message.user, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.clients != null && message.clients.length)
                for (var i = 0; i < message.clients.length; ++i)
                    $root.proteus.ClientEntry.encode(message.clients[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified UserEntry message, length delimited. Does not implicitly {@link proteus.UserEntry.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proteus.UserEntry
         * @static
         * @param {proteus.IUserEntry} message UserEntry message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        UserEntry.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a UserEntry message from the specified reader or buffer.
         * @function decode
         * @memberof proteus.UserEntry
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proteus.UserEntry} UserEntry
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UserEntry.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proteus.UserEntry();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.user = $root.proteus.UserId.decode(reader, reader.uint32());
                        break;
                    }
                case 2: {
                        if (!(message.clients && message.clients.length))
                            message.clients = [];
                        message.clients.push($root.proteus.ClientEntry.decode(reader, reader.uint32()));
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            if (!message.hasOwnProperty("user"))
                throw $util.ProtocolError("missing required 'user'", { instance: message });
            return message;
        };

        /**
         * Decodes a UserEntry message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proteus.UserEntry
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proteus.UserEntry} UserEntry
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        UserEntry.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a UserEntry message.
         * @function verify
         * @memberof proteus.UserEntry
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        UserEntry.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            {
                var error = $root.proteus.UserId.verify(message.user);
                if (error)
                    return "user." + error;
            }
            if (message.clients != null && message.hasOwnProperty("clients")) {
                if (!Array.isArray(message.clients))
                    return "clients: array expected";
                for (var i = 0; i < message.clients.length; ++i) {
                    var error = $root.proteus.ClientEntry.verify(message.clients[i]);
                    if (error)
                        return "clients." + error;
                }
            }
            return null;
        };

        /**
         * Creates a UserEntry message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proteus.UserEntry
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proteus.UserEntry} UserEntry
         */
        UserEntry.fromObject = function fromObject(object) {
            if (object instanceof $root.proteus.UserEntry)
                return object;
            var message = new $root.proteus.UserEntry();
            if (object.user != null) {
                if (typeof object.user !== "object")
                    throw TypeError(".proteus.UserEntry.user: object expected");
                message.user = $root.proteus.UserId.fromObject(object.user);
            }
            if (object.clients) {
                if (!Array.isArray(object.clients))
                    throw TypeError(".proteus.UserEntry.clients: array expected");
                message.clients = [];
                for (var i = 0; i < object.clients.length; ++i) {
                    if (typeof object.clients[i] !== "object")
                        throw TypeError(".proteus.UserEntry.clients: object expected");
                    message.clients[i] = $root.proteus.ClientEntry.fromObject(object.clients[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a UserEntry message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proteus.UserEntry
         * @static
         * @param {proteus.UserEntry} message UserEntry
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        UserEntry.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.clients = [];
            if (options.defaults)
                object.user = null;
            if (message.user != null && message.hasOwnProperty("user"))
                object.user = $root.proteus.UserId.toObject(message.user, options);
            if (message.clients && message.clients.length) {
                object.clients = [];
                for (var j = 0; j < message.clients.length; ++j)
                    object.clients[j] = $root.proteus.ClientEntry.toObject(message.clients[j], options);
            }
            return object;
        };

        /**
         * Converts this UserEntry to JSON.
         * @function toJSON
         * @memberof proteus.UserEntry
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        UserEntry.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for UserEntry
         * @function getTypeUrl
         * @memberof proteus.UserEntry
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        UserEntry.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proteus.UserEntry";
        };

        return UserEntry;
    })();

    proteus.QualifiedUserEntry = (function() {

        /**
         * Properties of a QualifiedUserEntry.
         * @memberof proteus
         * @interface IQualifiedUserEntry
         * @property {string} domain QualifiedUserEntry domain
         * @property {Array.<proteus.IUserEntry>|null} [entries] QualifiedUserEntry entries
         */

        /**
         * Constructs a new QualifiedUserEntry.
         * @memberof proteus
         * @classdesc Represents a QualifiedUserEntry.
         * @implements IQualifiedUserEntry
         * @constructor
         * @param {proteus.IQualifiedUserEntry=} [properties] Properties to set
         */
        function QualifiedUserEntry(properties) {
            this.entries = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * QualifiedUserEntry domain.
         * @member {string} domain
         * @memberof proteus.QualifiedUserEntry
         * @instance
         */
        QualifiedUserEntry.prototype.domain = "";

        /**
         * QualifiedUserEntry entries.
         * @member {Array.<proteus.IUserEntry>} entries
         * @memberof proteus.QualifiedUserEntry
         * @instance
         */
        QualifiedUserEntry.prototype.entries = $util.emptyArray;

        /**
         * Creates a new QualifiedUserEntry instance using the specified properties.
         * @function create
         * @memberof proteus.QualifiedUserEntry
         * @static
         * @param {proteus.IQualifiedUserEntry=} [properties] Properties to set
         * @returns {proteus.QualifiedUserEntry} QualifiedUserEntry instance
         */
        QualifiedUserEntry.create = function create(properties) {
            return new QualifiedUserEntry(properties);
        };

        /**
         * Encodes the specified QualifiedUserEntry message. Does not implicitly {@link proteus.QualifiedUserEntry.verify|verify} messages.
         * @function encode
         * @memberof proteus.QualifiedUserEntry
         * @static
         * @param {proteus.IQualifiedUserEntry} message QualifiedUserEntry message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QualifiedUserEntry.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.domain);
            if (message.entries != null && message.entries.length)
                for (var i = 0; i < message.entries.length; ++i)
                    $root.proteus.UserEntry.encode(message.entries[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified QualifiedUserEntry message, length delimited. Does not implicitly {@link proteus.QualifiedUserEntry.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proteus.QualifiedUserEntry
         * @static
         * @param {proteus.IQualifiedUserEntry} message QualifiedUserEntry message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QualifiedUserEntry.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a QualifiedUserEntry message from the specified reader or buffer.
         * @function decode
         * @memberof proteus.QualifiedUserEntry
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proteus.QualifiedUserEntry} QualifiedUserEntry
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QualifiedUserEntry.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proteus.QualifiedUserEntry();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.domain = reader.string();
                        break;
                    }
                case 2: {
                        if (!(message.entries && message.entries.length))
                            message.entries = [];
                        message.entries.push($root.proteus.UserEntry.decode(reader, reader.uint32()));
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            if (!message.hasOwnProperty("domain"))
                throw $util.ProtocolError("missing required 'domain'", { instance: message });
            return message;
        };

        /**
         * Decodes a QualifiedUserEntry message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proteus.QualifiedUserEntry
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proteus.QualifiedUserEntry} QualifiedUserEntry
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QualifiedUserEntry.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a QualifiedUserEntry message.
         * @function verify
         * @memberof proteus.QualifiedUserEntry
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        QualifiedUserEntry.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (!$util.isString(message.domain))
                return "domain: string expected";
            if (message.entries != null && message.hasOwnProperty("entries")) {
                if (!Array.isArray(message.entries))
                    return "entries: array expected";
                for (var i = 0; i < message.entries.length; ++i) {
                    var error = $root.proteus.UserEntry.verify(message.entries[i]);
                    if (error)
                        return "entries." + error;
                }
            }
            return null;
        };

        /**
         * Creates a QualifiedUserEntry message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proteus.QualifiedUserEntry
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proteus.QualifiedUserEntry} QualifiedUserEntry
         */
        QualifiedUserEntry.fromObject = function fromObject(object) {
            if (object instanceof $root.proteus.QualifiedUserEntry)
                return object;
            var message = new $root.proteus.QualifiedUserEntry();
            if (object.domain != null)
                message.domain = String(object.domain);
            if (object.entries) {
                if (!Array.isArray(object.entries))
                    throw TypeError(".proteus.QualifiedUserEntry.entries: array expected");
                message.entries = [];
                for (var i = 0; i < object.entries.length; ++i) {
                    if (typeof object.entries[i] !== "object")
                        throw TypeError(".proteus.QualifiedUserEntry.entries: object expected");
                    message.entries[i] = $root.proteus.UserEntry.fromObject(object.entries[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a QualifiedUserEntry message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proteus.QualifiedUserEntry
         * @static
         * @param {proteus.QualifiedUserEntry} message QualifiedUserEntry
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        QualifiedUserEntry.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.entries = [];
            if (options.defaults)
                object.domain = "";
            if (message.domain != null && message.hasOwnProperty("domain"))
                object.domain = message.domain;
            if (message.entries && message.entries.length) {
                object.entries = [];
                for (var j = 0; j < message.entries.length; ++j)
                    object.entries[j] = $root.proteus.UserEntry.toObject(message.entries[j], options);
            }
            return object;
        };

        /**
         * Converts this QualifiedUserEntry to JSON.
         * @function toJSON
         * @memberof proteus.QualifiedUserEntry
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        QualifiedUserEntry.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for QualifiedUserEntry
         * @function getTypeUrl
         * @memberof proteus.QualifiedUserEntry
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        QualifiedUserEntry.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proteus.QualifiedUserEntry";
        };

        return QualifiedUserEntry;
    })();

    /**
     * Priority enum.
     * @name proteus.Priority
     * @enum {number}
     * @property {number} LOW_PRIORITY=1 LOW_PRIORITY value
     * @property {number} HIGH_PRIORITY=2 HIGH_PRIORITY value
     */
    proteus.Priority = (function() {
        var valuesById = {}, values = Object.create(valuesById);
        values[valuesById[1] = "LOW_PRIORITY"] = 1;
        values[valuesById[2] = "HIGH_PRIORITY"] = 2;
        return values;
    })();

    proteus.NewOtrMessage = (function() {

        /**
         * Properties of a NewOtrMessage.
         * @memberof proteus
         * @interface INewOtrMessage
         * @property {proteus.IClientId} sender NewOtrMessage sender
         * @property {Array.<proteus.IUserEntry>|null} [recipients] NewOtrMessage recipients
         * @property {boolean|null} [nativePush] NewOtrMessage nativePush
         * @property {Uint8Array|null} [blob] NewOtrMessage blob
         * @property {proteus.Priority|null} [nativePriority] NewOtrMessage nativePriority
         * @property {boolean|null} [transient] NewOtrMessage transient
         * @property {Array.<proteus.IUserId>|null} [reportMissing] NewOtrMessage reportMissing
         */

        /**
         * Constructs a new NewOtrMessage.
         * @memberof proteus
         * @classdesc Represents a NewOtrMessage.
         * @implements INewOtrMessage
         * @constructor
         * @param {proteus.INewOtrMessage=} [properties] Properties to set
         */
        function NewOtrMessage(properties) {
            this.recipients = [];
            this.reportMissing = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * NewOtrMessage sender.
         * @member {proteus.IClientId} sender
         * @memberof proteus.NewOtrMessage
         * @instance
         */
        NewOtrMessage.prototype.sender = null;

        /**
         * NewOtrMessage recipients.
         * @member {Array.<proteus.IUserEntry>} recipients
         * @memberof proteus.NewOtrMessage
         * @instance
         */
        NewOtrMessage.prototype.recipients = $util.emptyArray;

        /**
         * NewOtrMessage nativePush.
         * @member {boolean} nativePush
         * @memberof proteus.NewOtrMessage
         * @instance
         */
        NewOtrMessage.prototype.nativePush = true;

        /**
         * NewOtrMessage blob.
         * @member {Uint8Array} blob
         * @memberof proteus.NewOtrMessage
         * @instance
         */
        NewOtrMessage.prototype.blob = $util.newBuffer([]);

        /**
         * NewOtrMessage nativePriority.
         * @member {proteus.Priority} nativePriority
         * @memberof proteus.NewOtrMessage
         * @instance
         */
        NewOtrMessage.prototype.nativePriority = 1;

        /**
         * NewOtrMessage transient.
         * @member {boolean} transient
         * @memberof proteus.NewOtrMessage
         * @instance
         */
        NewOtrMessage.prototype.transient = false;

        /**
         * NewOtrMessage reportMissing.
         * @member {Array.<proteus.IUserId>} reportMissing
         * @memberof proteus.NewOtrMessage
         * @instance
         */
        NewOtrMessage.prototype.reportMissing = $util.emptyArray;

        /**
         * Creates a new NewOtrMessage instance using the specified properties.
         * @function create
         * @memberof proteus.NewOtrMessage
         * @static
         * @param {proteus.INewOtrMessage=} [properties] Properties to set
         * @returns {proteus.NewOtrMessage} NewOtrMessage instance
         */
        NewOtrMessage.create = function create(properties) {
            return new NewOtrMessage(properties);
        };

        /**
         * Encodes the specified NewOtrMessage message. Does not implicitly {@link proteus.NewOtrMessage.verify|verify} messages.
         * @function encode
         * @memberof proteus.NewOtrMessage
         * @static
         * @param {proteus.INewOtrMessage} message NewOtrMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        NewOtrMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            $root.proteus.ClientId.encode(message.sender, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.recipients != null && message.recipients.length)
                for (var i = 0; i < message.recipients.length; ++i)
                    $root.proteus.UserEntry.encode(message.recipients[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.nativePush != null && Object.hasOwnProperty.call(message, "nativePush"))
                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.nativePush);
            if (message.blob != null && Object.hasOwnProperty.call(message, "blob"))
                writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.blob);
            if (message.nativePriority != null && Object.hasOwnProperty.call(message, "nativePriority"))
                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.nativePriority);
            if (message.transient != null && Object.hasOwnProperty.call(message, "transient"))
                writer.uint32(/* id 6, wireType 0 =*/48).bool(message.transient);
            if (message.reportMissing != null && message.reportMissing.length)
                for (var i = 0; i < message.reportMissing.length; ++i)
                    $root.proteus.UserId.encode(message.reportMissing[i], writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified NewOtrMessage message, length delimited. Does not implicitly {@link proteus.NewOtrMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proteus.NewOtrMessage
         * @static
         * @param {proteus.INewOtrMessage} message NewOtrMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        NewOtrMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a NewOtrMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proteus.NewOtrMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proteus.NewOtrMessage} NewOtrMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        NewOtrMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proteus.NewOtrMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.sender = $root.proteus.ClientId.decode(reader, reader.uint32());
                        break;
                    }
                case 2: {
                        if (!(message.recipients && message.recipients.length))
                            message.recipients = [];
                        message.recipients.push($root.proteus.UserEntry.decode(reader, reader.uint32()));
                        break;
                    }
                case 3: {
                        message.nativePush = reader.bool();
                        break;
                    }
                case 4: {
                        message.blob = reader.bytes();
                        break;
                    }
                case 5: {
                        message.nativePriority = reader.int32();
                        break;
                    }
                case 6: {
                        message.transient = reader.bool();
                        break;
                    }
                case 7: {
                        if (!(message.reportMissing && message.reportMissing.length))
                            message.reportMissing = [];
                        message.reportMissing.push($root.proteus.UserId.decode(reader, reader.uint32()));
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            if (!message.hasOwnProperty("sender"))
                throw $util.ProtocolError("missing required 'sender'", { instance: message });
            return message;
        };

        /**
         * Decodes a NewOtrMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proteus.NewOtrMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proteus.NewOtrMessage} NewOtrMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        NewOtrMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a NewOtrMessage message.
         * @function verify
         * @memberof proteus.NewOtrMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        NewOtrMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            {
                var error = $root.proteus.ClientId.verify(message.sender);
                if (error)
                    return "sender." + error;
            }
            if (message.recipients != null && message.hasOwnProperty("recipients")) {
                if (!Array.isArray(message.recipients))
                    return "recipients: array expected";
                for (var i = 0; i < message.recipients.length; ++i) {
                    var error = $root.proteus.UserEntry.verify(message.recipients[i]);
                    if (error)
                        return "recipients." + error;
                }
            }
            if (message.nativePush != null && message.hasOwnProperty("nativePush"))
                if (typeof message.nativePush !== "boolean")
                    return "nativePush: boolean expected";
            if (message.blob != null && message.hasOwnProperty("blob"))
                if (!(message.blob && typeof message.blob.length === "number" || $util.isString(message.blob)))
                    return "blob: buffer expected";
            if (message.nativePriority != null && message.hasOwnProperty("nativePriority"))
                switch (message.nativePriority) {
                default:
                    return "nativePriority: enum value expected";
                case 1:
                case 2:
                    break;
                }
            if (message.transient != null && message.hasOwnProperty("transient"))
                if (typeof message.transient !== "boolean")
                    return "transient: boolean expected";
            if (message.reportMissing != null && message.hasOwnProperty("reportMissing")) {
                if (!Array.isArray(message.reportMissing))
                    return "reportMissing: array expected";
                for (var i = 0; i < message.reportMissing.length; ++i) {
                    var error = $root.proteus.UserId.verify(message.reportMissing[i]);
                    if (error)
                        return "reportMissing." + error;
                }
            }
            return null;
        };

        /**
         * Creates a NewOtrMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proteus.NewOtrMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proteus.NewOtrMessage} NewOtrMessage
         */
        NewOtrMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proteus.NewOtrMessage)
                return object;
            var message = new $root.proteus.NewOtrMessage();
            if (object.sender != null) {
                if (typeof object.sender !== "object")
                    throw TypeError(".proteus.NewOtrMessage.sender: object expected");
                message.sender = $root.proteus.ClientId.fromObject(object.sender);
            }
            if (object.recipients) {
                if (!Array.isArray(object.recipients))
                    throw TypeError(".proteus.NewOtrMessage.recipients: array expected");
                message.recipients = [];
                for (var i = 0; i < object.recipients.length; ++i) {
                    if (typeof object.recipients[i] !== "object")
                        throw TypeError(".proteus.NewOtrMessage.recipients: object expected");
                    message.recipients[i] = $root.proteus.UserEntry.fromObject(object.recipients[i]);
                }
            }
            if (object.nativePush != null)
                message.nativePush = Boolean(object.nativePush);
            if (object.blob != null)
                if (typeof object.blob === "string")
                    $util.base64.decode(object.blob, message.blob = $util.newBuffer($util.base64.length(object.blob)), 0);
                else if (object.blob.length >= 0)
                    message.blob = object.blob;
            switch (object.nativePriority) {
            default:
                if (typeof object.nativePriority === "number") {
                    message.nativePriority = object.nativePriority;
                    break;
                }
                break;
            case "LOW_PRIORITY":
            case 1:
                message.nativePriority = 1;
                break;
            case "HIGH_PRIORITY":
            case 2:
                message.nativePriority = 2;
                break;
            }
            if (object.transient != null)
                message.transient = Boolean(object.transient);
            if (object.reportMissing) {
                if (!Array.isArray(object.reportMissing))
                    throw TypeError(".proteus.NewOtrMessage.reportMissing: array expected");
                message.reportMissing = [];
                for (var i = 0; i < object.reportMissing.length; ++i) {
                    if (typeof object.reportMissing[i] !== "object")
                        throw TypeError(".proteus.NewOtrMessage.reportMissing: object expected");
                    message.reportMissing[i] = $root.proteus.UserId.fromObject(object.reportMissing[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a NewOtrMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proteus.NewOtrMessage
         * @static
         * @param {proteus.NewOtrMessage} message NewOtrMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        NewOtrMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults) {
                object.recipients = [];
                object.reportMissing = [];
            }
            if (options.defaults) {
                object.sender = null;
                object.nativePush = true;
                if (options.bytes === String)
                    object.blob = "";
                else {
                    object.blob = [];
                    if (options.bytes !== Array)
                        object.blob = $util.newBuffer(object.blob);
                }
                object.nativePriority = options.enums === String ? "LOW_PRIORITY" : 1;
                object.transient = false;
            }
            if (message.sender != null && message.hasOwnProperty("sender"))
                object.sender = $root.proteus.ClientId.toObject(message.sender, options);
            if (message.recipients && message.recipients.length) {
                object.recipients = [];
                for (var j = 0; j < message.recipients.length; ++j)
                    object.recipients[j] = $root.proteus.UserEntry.toObject(message.recipients[j], options);
            }
            if (message.nativePush != null && message.hasOwnProperty("nativePush"))
                object.nativePush = message.nativePush;
            if (message.blob != null && message.hasOwnProperty("blob"))
                object.blob = options.bytes === String ? $util.base64.encode(message.blob, 0, message.blob.length) : options.bytes === Array ? Array.prototype.slice.call(message.blob) : message.blob;
            if (message.nativePriority != null && message.hasOwnProperty("nativePriority"))
                object.nativePriority = options.enums === String ? $root.proteus.Priority[message.nativePriority] === undefined ? message.nativePriority : $root.proteus.Priority[message.nativePriority] : message.nativePriority;
            if (message.transient != null && message.hasOwnProperty("transient"))
                object.transient = message.transient;
            if (message.reportMissing && message.reportMissing.length) {
                object.reportMissing = [];
                for (var j = 0; j < message.reportMissing.length; ++j)
                    object.reportMissing[j] = $root.proteus.UserId.toObject(message.reportMissing[j], options);
            }
            return object;
        };

        /**
         * Converts this NewOtrMessage to JSON.
         * @function toJSON
         * @memberof proteus.NewOtrMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        NewOtrMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for NewOtrMessage
         * @function getTypeUrl
         * @memberof proteus.NewOtrMessage
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        NewOtrMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proteus.NewOtrMessage";
        };

        return NewOtrMessage;
    })();

    proteus.QualifiedNewOtrMessage = (function() {

        /**
         * Properties of a QualifiedNewOtrMessage.
         * @memberof proteus
         * @interface IQualifiedNewOtrMessage
         * @property {proteus.IClientId} sender QualifiedNewOtrMessage sender
         * @property {Array.<proteus.IQualifiedUserEntry>|null} [recipients] QualifiedNewOtrMessage recipients
         * @property {boolean|null} [nativePush] QualifiedNewOtrMessage nativePush
         * @property {Uint8Array|null} [blob] QualifiedNewOtrMessage blob
         * @property {proteus.Priority|null} [nativePriority] QualifiedNewOtrMessage nativePriority
         * @property {boolean|null} [transient] QualifiedNewOtrMessage transient
         * @property {proteus.ClientMismatchStrategy.IReportAll|null} [reportAll] QualifiedNewOtrMessage reportAll
         * @property {proteus.ClientMismatchStrategy.IIgnoreAll|null} [ignoreAll] QualifiedNewOtrMessage ignoreAll
         * @property {proteus.ClientMismatchStrategy.IReportOnly|null} [reportOnly] QualifiedNewOtrMessage reportOnly
         * @property {proteus.ClientMismatchStrategy.IIgnoreOnly|null} [ignoreOnly] QualifiedNewOtrMessage ignoreOnly
         */

        /**
         * Constructs a new QualifiedNewOtrMessage.
         * @memberof proteus
         * @classdesc Represents a QualifiedNewOtrMessage.
         * @implements IQualifiedNewOtrMessage
         * @constructor
         * @param {proteus.IQualifiedNewOtrMessage=} [properties] Properties to set
         */
        function QualifiedNewOtrMessage(properties) {
            this.recipients = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * QualifiedNewOtrMessage sender.
         * @member {proteus.IClientId} sender
         * @memberof proteus.QualifiedNewOtrMessage
         * @instance
         */
        QualifiedNewOtrMessage.prototype.sender = null;

        /**
         * QualifiedNewOtrMessage recipients.
         * @member {Array.<proteus.IQualifiedUserEntry>} recipients
         * @memberof proteus.QualifiedNewOtrMessage
         * @instance
         */
        QualifiedNewOtrMessage.prototype.recipients = $util.emptyArray;

        /**
         * QualifiedNewOtrMessage nativePush.
         * @member {boolean} nativePush
         * @memberof proteus.QualifiedNewOtrMessage
         * @instance
         */
        QualifiedNewOtrMessage.prototype.nativePush = true;

        /**
         * QualifiedNewOtrMessage blob.
         * @member {Uint8Array} blob
         * @memberof proteus.QualifiedNewOtrMessage
         * @instance
         */
        QualifiedNewOtrMessage.prototype.blob = $util.newBuffer([]);

        /**
         * QualifiedNewOtrMessage nativePriority.
         * @member {proteus.Priority} nativePriority
         * @memberof proteus.QualifiedNewOtrMessage
         * @instance
         */
        QualifiedNewOtrMessage.prototype.nativePriority = 1;

        /**
         * QualifiedNewOtrMessage transient.
         * @member {boolean} transient
         * @memberof proteus.QualifiedNewOtrMessage
         * @instance
         */
        QualifiedNewOtrMessage.prototype.transient = false;

        /**
         * QualifiedNewOtrMessage reportAll.
         * @member {proteus.ClientMismatchStrategy.IReportAll|null|undefined} reportAll
         * @memberof proteus.QualifiedNewOtrMessage
         * @instance
         */
        QualifiedNewOtrMessage.prototype.reportAll = null;

        /**
         * QualifiedNewOtrMessage ignoreAll.
         * @member {proteus.ClientMismatchStrategy.IIgnoreAll|null|undefined} ignoreAll
         * @memberof proteus.QualifiedNewOtrMessage
         * @instance
         */
        QualifiedNewOtrMessage.prototype.ignoreAll = null;

        /**
         * QualifiedNewOtrMessage reportOnly.
         * @member {proteus.ClientMismatchStrategy.IReportOnly|null|undefined} reportOnly
         * @memberof proteus.QualifiedNewOtrMessage
         * @instance
         */
        QualifiedNewOtrMessage.prototype.reportOnly = null;

        /**
         * QualifiedNewOtrMessage ignoreOnly.
         * @member {proteus.ClientMismatchStrategy.IIgnoreOnly|null|undefined} ignoreOnly
         * @memberof proteus.QualifiedNewOtrMessage
         * @instance
         */
        QualifiedNewOtrMessage.prototype.ignoreOnly = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * QualifiedNewOtrMessage clientMismatchStrategy.
         * @member {"reportAll"|"ignoreAll"|"reportOnly"|"ignoreOnly"|undefined} clientMismatchStrategy
         * @memberof proteus.QualifiedNewOtrMessage
         * @instance
         */
        Object.defineProperty(QualifiedNewOtrMessage.prototype, "clientMismatchStrategy", {
            get: $util.oneOfGetter($oneOfFields = ["reportAll", "ignoreAll", "reportOnly", "ignoreOnly"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new QualifiedNewOtrMessage instance using the specified properties.
         * @function create
         * @memberof proteus.QualifiedNewOtrMessage
         * @static
         * @param {proteus.IQualifiedNewOtrMessage=} [properties] Properties to set
         * @returns {proteus.QualifiedNewOtrMessage} QualifiedNewOtrMessage instance
         */
        QualifiedNewOtrMessage.create = function create(properties) {
            return new QualifiedNewOtrMessage(properties);
        };

        /**
         * Encodes the specified QualifiedNewOtrMessage message. Does not implicitly {@link proteus.QualifiedNewOtrMessage.verify|verify} messages.
         * @function encode
         * @memberof proteus.QualifiedNewOtrMessage
         * @static
         * @param {proteus.IQualifiedNewOtrMessage} message QualifiedNewOtrMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QualifiedNewOtrMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            $root.proteus.ClientId.encode(message.sender, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.recipients != null && message.recipients.length)
                for (var i = 0; i < message.recipients.length; ++i)
                    $root.proteus.QualifiedUserEntry.encode(message.recipients[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.nativePush != null && Object.hasOwnProperty.call(message, "nativePush"))
                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.nativePush);
            if (message.blob != null && Object.hasOwnProperty.call(message, "blob"))
                writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.blob);
            if (message.nativePriority != null && Object.hasOwnProperty.call(message, "nativePriority"))
                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.nativePriority);
            if (message.transient != null && Object.hasOwnProperty.call(message, "transient"))
                writer.uint32(/* id 6, wireType 0 =*/48).bool(message.transient);
            if (message.reportAll != null && Object.hasOwnProperty.call(message, "reportAll"))
                $root.proteus.ClientMismatchStrategy.ReportAll.encode(message.reportAll, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
            if (message.ignoreAll != null && Object.hasOwnProperty.call(message, "ignoreAll"))
                $root.proteus.ClientMismatchStrategy.IgnoreAll.encode(message.ignoreAll, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
            if (message.reportOnly != null && Object.hasOwnProperty.call(message, "reportOnly"))
                $root.proteus.ClientMismatchStrategy.ReportOnly.encode(message.reportOnly, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
            if (message.ignoreOnly != null && Object.hasOwnProperty.call(message, "ignoreOnly"))
                $root.proteus.ClientMismatchStrategy.IgnoreOnly.encode(message.ignoreOnly, writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified QualifiedNewOtrMessage message, length delimited. Does not implicitly {@link proteus.QualifiedNewOtrMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proteus.QualifiedNewOtrMessage
         * @static
         * @param {proteus.IQualifiedNewOtrMessage} message QualifiedNewOtrMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        QualifiedNewOtrMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a QualifiedNewOtrMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proteus.QualifiedNewOtrMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proteus.QualifiedNewOtrMessage} QualifiedNewOtrMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QualifiedNewOtrMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proteus.QualifiedNewOtrMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.sender = $root.proteus.ClientId.decode(reader, reader.uint32());
                        break;
                    }
                case 2: {
                        if (!(message.recipients && message.recipients.length))
                            message.recipients = [];
                        message.recipients.push($root.proteus.QualifiedUserEntry.decode(reader, reader.uint32()));
                        break;
                    }
                case 3: {
                        message.nativePush = reader.bool();
                        break;
                    }
                case 4: {
                        message.blob = reader.bytes();
                        break;
                    }
                case 5: {
                        message.nativePriority = reader.int32();
                        break;
                    }
                case 6: {
                        message.transient = reader.bool();
                        break;
                    }
                case 7: {
                        message.reportAll = $root.proteus.ClientMismatchStrategy.ReportAll.decode(reader, reader.uint32());
                        break;
                    }
                case 8: {
                        message.ignoreAll = $root.proteus.ClientMismatchStrategy.IgnoreAll.decode(reader, reader.uint32());
                        break;
                    }
                case 9: {
                        message.reportOnly = $root.proteus.ClientMismatchStrategy.ReportOnly.decode(reader, reader.uint32());
                        break;
                    }
                case 10: {
                        message.ignoreOnly = $root.proteus.ClientMismatchStrategy.IgnoreOnly.decode(reader, reader.uint32());
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            if (!message.hasOwnProperty("sender"))
                throw $util.ProtocolError("missing required 'sender'", { instance: message });
            return message;
        };

        /**
         * Decodes a QualifiedNewOtrMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proteus.QualifiedNewOtrMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proteus.QualifiedNewOtrMessage} QualifiedNewOtrMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        QualifiedNewOtrMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a QualifiedNewOtrMessage message.
         * @function verify
         * @memberof proteus.QualifiedNewOtrMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        QualifiedNewOtrMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            {
                var error = $root.proteus.ClientId.verify(message.sender);
                if (error)
                    return "sender." + error;
            }
            if (message.recipients != null && message.hasOwnProperty("recipients")) {
                if (!Array.isArray(message.recipients))
                    return "recipients: array expected";
                for (var i = 0; i < message.recipients.length; ++i) {
                    var error = $root.proteus.QualifiedUserEntry.verify(message.recipients[i]);
                    if (error)
                        return "recipients." + error;
                }
            }
            if (message.nativePush != null && message.hasOwnProperty("nativePush"))
                if (typeof message.nativePush !== "boolean")
                    return "nativePush: boolean expected";
            if (message.blob != null && message.hasOwnProperty("blob"))
                if (!(message.blob && typeof message.blob.length === "number" || $util.isString(message.blob)))
                    return "blob: buffer expected";
            if (message.nativePriority != null && message.hasOwnProperty("nativePriority"))
                switch (message.nativePriority) {
                default:
                    return "nativePriority: enum value expected";
                case 1:
                case 2:
                    break;
                }
            if (message.transient != null && message.hasOwnProperty("transient"))
                if (typeof message.transient !== "boolean")
                    return "transient: boolean expected";
            if (message.reportAll != null && message.hasOwnProperty("reportAll")) {
                properties.clientMismatchStrategy = 1;
                {
                    var error = $root.proteus.ClientMismatchStrategy.ReportAll.verify(message.reportAll);
                    if (error)
                        return "reportAll." + error;
                }
            }
            if (message.ignoreAll != null && message.hasOwnProperty("ignoreAll")) {
                if (properties.clientMismatchStrategy === 1)
                    return "clientMismatchStrategy: multiple values";
                properties.clientMismatchStrategy = 1;
                {
                    var error = $root.proteus.ClientMismatchStrategy.IgnoreAll.verify(message.ignoreAll);
                    if (error)
                        return "ignoreAll." + error;
                }
            }
            if (message.reportOnly != null && message.hasOwnProperty("reportOnly")) {
                if (properties.clientMismatchStrategy === 1)
                    return "clientMismatchStrategy: multiple values";
                properties.clientMismatchStrategy = 1;
                {
                    var error = $root.proteus.ClientMismatchStrategy.ReportOnly.verify(message.reportOnly);
                    if (error)
                        return "reportOnly." + error;
                }
            }
            if (message.ignoreOnly != null && message.hasOwnProperty("ignoreOnly")) {
                if (properties.clientMismatchStrategy === 1)
                    return "clientMismatchStrategy: multiple values";
                properties.clientMismatchStrategy = 1;
                {
                    var error = $root.proteus.ClientMismatchStrategy.IgnoreOnly.verify(message.ignoreOnly);
                    if (error)
                        return "ignoreOnly." + error;
                }
            }
            return null;
        };

        /**
         * Creates a QualifiedNewOtrMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proteus.QualifiedNewOtrMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proteus.QualifiedNewOtrMessage} QualifiedNewOtrMessage
         */
        QualifiedNewOtrMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proteus.QualifiedNewOtrMessage)
                return object;
            var message = new $root.proteus.QualifiedNewOtrMessage();
            if (object.sender != null) {
                if (typeof object.sender !== "object")
                    throw TypeError(".proteus.QualifiedNewOtrMessage.sender: object expected");
                message.sender = $root.proteus.ClientId.fromObject(object.sender);
            }
            if (object.recipients) {
                if (!Array.isArray(object.recipients))
                    throw TypeError(".proteus.QualifiedNewOtrMessage.recipients: array expected");
                message.recipients = [];
                for (var i = 0; i < object.recipients.length; ++i) {
                    if (typeof object.recipients[i] !== "object")
                        throw TypeError(".proteus.QualifiedNewOtrMessage.recipients: object expected");
                    message.recipients[i] = $root.proteus.QualifiedUserEntry.fromObject(object.recipients[i]);
                }
            }
            if (object.nativePush != null)
                message.nativePush = Boolean(object.nativePush);
            if (object.blob != null)
                if (typeof object.blob === "string")
                    $util.base64.decode(object.blob, message.blob = $util.newBuffer($util.base64.length(object.blob)), 0);
                else if (object.blob.length >= 0)
                    message.blob = object.blob;
            switch (object.nativePriority) {
            default:
                if (typeof object.nativePriority === "number") {
                    message.nativePriority = object.nativePriority;
                    break;
                }
                break;
            case "LOW_PRIORITY":
            case 1:
                message.nativePriority = 1;
                break;
            case "HIGH_PRIORITY":
            case 2:
                message.nativePriority = 2;
                break;
            }
            if (object.transient != null)
                message.transient = Boolean(object.transient);
            if (object.reportAll != null) {
                if (typeof object.reportAll !== "object")
                    throw TypeError(".proteus.QualifiedNewOtrMessage.reportAll: object expected");
                message.reportAll = $root.proteus.ClientMismatchStrategy.ReportAll.fromObject(object.reportAll);
            }
            if (object.ignoreAll != null) {
                if (typeof object.ignoreAll !== "object")
                    throw TypeError(".proteus.QualifiedNewOtrMessage.ignoreAll: object expected");
                message.ignoreAll = $root.proteus.ClientMismatchStrategy.IgnoreAll.fromObject(object.ignoreAll);
            }
            if (object.reportOnly != null) {
                if (typeof object.reportOnly !== "object")
                    throw TypeError(".proteus.QualifiedNewOtrMessage.reportOnly: object expected");
                message.reportOnly = $root.proteus.ClientMismatchStrategy.ReportOnly.fromObject(object.reportOnly);
            }
            if (object.ignoreOnly != null) {
                if (typeof object.ignoreOnly !== "object")
                    throw TypeError(".proteus.QualifiedNewOtrMessage.ignoreOnly: object expected");
                message.ignoreOnly = $root.proteus.ClientMismatchStrategy.IgnoreOnly.fromObject(object.ignoreOnly);
            }
            return message;
        };

        /**
         * Creates a plain object from a QualifiedNewOtrMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proteus.QualifiedNewOtrMessage
         * @static
         * @param {proteus.QualifiedNewOtrMessage} message QualifiedNewOtrMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        QualifiedNewOtrMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.recipients = [];
            if (options.defaults) {
                object.sender = null;
                object.nativePush = true;
                if (options.bytes === String)
                    object.blob = "";
                else {
                    object.blob = [];
                    if (options.bytes !== Array)
                        object.blob = $util.newBuffer(object.blob);
                }
                object.nativePriority = options.enums === String ? "LOW_PRIORITY" : 1;
                object.transient = false;
            }
            if (message.sender != null && message.hasOwnProperty("sender"))
                object.sender = $root.proteus.ClientId.toObject(message.sender, options);
            if (message.recipients && message.recipients.length) {
                object.recipients = [];
                for (var j = 0; j < message.recipients.length; ++j)
                    object.recipients[j] = $root.proteus.QualifiedUserEntry.toObject(message.recipients[j], options);
            }
            if (message.nativePush != null && message.hasOwnProperty("nativePush"))
                object.nativePush = message.nativePush;
            if (message.blob != null && message.hasOwnProperty("blob"))
                object.blob = options.bytes === String ? $util.base64.encode(message.blob, 0, message.blob.length) : options.bytes === Array ? Array.prototype.slice.call(message.blob) : message.blob;
            if (message.nativePriority != null && message.hasOwnProperty("nativePriority"))
                object.nativePriority = options.enums === String ? $root.proteus.Priority[message.nativePriority] === undefined ? message.nativePriority : $root.proteus.Priority[message.nativePriority] : message.nativePriority;
            if (message.transient != null && message.hasOwnProperty("transient"))
                object.transient = message.transient;
            if (message.reportAll != null && message.hasOwnProperty("reportAll")) {
                object.reportAll = $root.proteus.ClientMismatchStrategy.ReportAll.toObject(message.reportAll, options);
                if (options.oneofs)
                    object.clientMismatchStrategy = "reportAll";
            }
            if (message.ignoreAll != null && message.hasOwnProperty("ignoreAll")) {
                object.ignoreAll = $root.proteus.ClientMismatchStrategy.IgnoreAll.toObject(message.ignoreAll, options);
                if (options.oneofs)
                    object.clientMismatchStrategy = "ignoreAll";
            }
            if (message.reportOnly != null && message.hasOwnProperty("reportOnly")) {
                object.reportOnly = $root.proteus.ClientMismatchStrategy.ReportOnly.toObject(message.reportOnly, options);
                if (options.oneofs)
                    object.clientMismatchStrategy = "reportOnly";
            }
            if (message.ignoreOnly != null && message.hasOwnProperty("ignoreOnly")) {
                object.ignoreOnly = $root.proteus.ClientMismatchStrategy.IgnoreOnly.toObject(message.ignoreOnly, options);
                if (options.oneofs)
                    object.clientMismatchStrategy = "ignoreOnly";
            }
            return object;
        };

        /**
         * Converts this QualifiedNewOtrMessage to JSON.
         * @function toJSON
         * @memberof proteus.QualifiedNewOtrMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        QualifiedNewOtrMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for QualifiedNewOtrMessage
         * @function getTypeUrl
         * @memberof proteus.QualifiedNewOtrMessage
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        QualifiedNewOtrMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proteus.QualifiedNewOtrMessage";
        };

        return QualifiedNewOtrMessage;
    })();

    proteus.ClientMismatchStrategy = (function() {

        /**
         * Properties of a ClientMismatchStrategy.
         * @memberof proteus
         * @interface IClientMismatchStrategy
         */

        /**
         * Constructs a new ClientMismatchStrategy.
         * @memberof proteus
         * @classdesc Represents a ClientMismatchStrategy.
         * @implements IClientMismatchStrategy
         * @constructor
         * @param {proteus.IClientMismatchStrategy=} [properties] Properties to set
         */
        function ClientMismatchStrategy(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new ClientMismatchStrategy instance using the specified properties.
         * @function create
         * @memberof proteus.ClientMismatchStrategy
         * @static
         * @param {proteus.IClientMismatchStrategy=} [properties] Properties to set
         * @returns {proteus.ClientMismatchStrategy} ClientMismatchStrategy instance
         */
        ClientMismatchStrategy.create = function create(properties) {
            return new ClientMismatchStrategy(properties);
        };

        /**
         * Encodes the specified ClientMismatchStrategy message. Does not implicitly {@link proteus.ClientMismatchStrategy.verify|verify} messages.
         * @function encode
         * @memberof proteus.ClientMismatchStrategy
         * @static
         * @param {proteus.IClientMismatchStrategy} message ClientMismatchStrategy message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClientMismatchStrategy.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified ClientMismatchStrategy message, length delimited. Does not implicitly {@link proteus.ClientMismatchStrategy.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proteus.ClientMismatchStrategy
         * @static
         * @param {proteus.IClientMismatchStrategy} message ClientMismatchStrategy message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClientMismatchStrategy.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ClientMismatchStrategy message from the specified reader or buffer.
         * @function decode
         * @memberof proteus.ClientMismatchStrategy
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proteus.ClientMismatchStrategy} ClientMismatchStrategy
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClientMismatchStrategy.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proteus.ClientMismatchStrategy();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ClientMismatchStrategy message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proteus.ClientMismatchStrategy
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proteus.ClientMismatchStrategy} ClientMismatchStrategy
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClientMismatchStrategy.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ClientMismatchStrategy message.
         * @function verify
         * @memberof proteus.ClientMismatchStrategy
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ClientMismatchStrategy.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a ClientMismatchStrategy message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proteus.ClientMismatchStrategy
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proteus.ClientMismatchStrategy} ClientMismatchStrategy
         */
        ClientMismatchStrategy.fromObject = function fromObject(object) {
            if (object instanceof $root.proteus.ClientMismatchStrategy)
                return object;
            return new $root.proteus.ClientMismatchStrategy();
        };

        /**
         * Creates a plain object from a ClientMismatchStrategy message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proteus.ClientMismatchStrategy
         * @static
         * @param {proteus.ClientMismatchStrategy} message ClientMismatchStrategy
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ClientMismatchStrategy.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this ClientMismatchStrategy to JSON.
         * @function toJSON
         * @memberof proteus.ClientMismatchStrategy
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ClientMismatchStrategy.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for ClientMismatchStrategy
         * @function getTypeUrl
         * @memberof proteus.ClientMismatchStrategy
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        ClientMismatchStrategy.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proteus.ClientMismatchStrategy";
        };

        ClientMismatchStrategy.ReportAll = (function() {

            /**
             * Properties of a ReportAll.
             * @memberof proteus.ClientMismatchStrategy
             * @interface IReportAll
             */

            /**
             * Constructs a new ReportAll.
             * @memberof proteus.ClientMismatchStrategy
             * @classdesc Represents a ReportAll.
             * @implements IReportAll
             * @constructor
             * @param {proteus.ClientMismatchStrategy.IReportAll=} [properties] Properties to set
             */
            function ReportAll(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * Creates a new ReportAll instance using the specified properties.
             * @function create
             * @memberof proteus.ClientMismatchStrategy.ReportAll
             * @static
             * @param {proteus.ClientMismatchStrategy.IReportAll=} [properties] Properties to set
             * @returns {proteus.ClientMismatchStrategy.ReportAll} ReportAll instance
             */
            ReportAll.create = function create(properties) {
                return new ReportAll(properties);
            };

            /**
             * Encodes the specified ReportAll message. Does not implicitly {@link proteus.ClientMismatchStrategy.ReportAll.verify|verify} messages.
             * @function encode
             * @memberof proteus.ClientMismatchStrategy.ReportAll
             * @static
             * @param {proteus.ClientMismatchStrategy.IReportAll} message ReportAll message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            ReportAll.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                return writer;
            };

            /**
             * Encodes the specified ReportAll message, length delimited. Does not implicitly {@link proteus.ClientMismatchStrategy.ReportAll.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proteus.ClientMismatchStrategy.ReportAll
             * @static
             * @param {proteus.ClientMismatchStrategy.IReportAll} message ReportAll message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            ReportAll.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a ReportAll message from the specified reader or buffer.
             * @function decode
             * @memberof proteus.ClientMismatchStrategy.ReportAll
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proteus.ClientMismatchStrategy.ReportAll} ReportAll
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            ReportAll.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proteus.ClientMismatchStrategy.ReportAll();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a ReportAll message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proteus.ClientMismatchStrategy.ReportAll
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proteus.ClientMismatchStrategy.ReportAll} ReportAll
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            ReportAll.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a ReportAll message.
             * @function verify
             * @memberof proteus.ClientMismatchStrategy.ReportAll
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            ReportAll.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                return null;
            };

            /**
             * Creates a ReportAll message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proteus.ClientMismatchStrategy.ReportAll
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proteus.ClientMismatchStrategy.ReportAll} ReportAll
             */
            ReportAll.fromObject = function fromObject(object) {
                if (object instanceof $root.proteus.ClientMismatchStrategy.ReportAll)
                    return object;
                return new $root.proteus.ClientMismatchStrategy.ReportAll();
            };

            /**
             * Creates a plain object from a ReportAll message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proteus.ClientMismatchStrategy.ReportAll
             * @static
             * @param {proteus.ClientMismatchStrategy.ReportAll} message ReportAll
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            ReportAll.toObject = function toObject() {
                return {};
            };

            /**
             * Converts this ReportAll to JSON.
             * @function toJSON
             * @memberof proteus.ClientMismatchStrategy.ReportAll
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            ReportAll.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * Gets the default type url for ReportAll
             * @function getTypeUrl
             * @memberof proteus.ClientMismatchStrategy.ReportAll
             * @static
             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns {string} The default type url
             */
            ReportAll.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proteus.ClientMismatchStrategy.ReportAll";
            };

            return ReportAll;
        })();

        ClientMismatchStrategy.IgnoreAll = (function() {

            /**
             * Properties of an IgnoreAll.
             * @memberof proteus.ClientMismatchStrategy
             * @interface IIgnoreAll
             */

            /**
             * Constructs a new IgnoreAll.
             * @memberof proteus.ClientMismatchStrategy
             * @classdesc Represents an IgnoreAll.
             * @implements IIgnoreAll
             * @constructor
             * @param {proteus.ClientMismatchStrategy.IIgnoreAll=} [properties] Properties to set
             */
            function IgnoreAll(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * Creates a new IgnoreAll instance using the specified properties.
             * @function create
             * @memberof proteus.ClientMismatchStrategy.IgnoreAll
             * @static
             * @param {proteus.ClientMismatchStrategy.IIgnoreAll=} [properties] Properties to set
             * @returns {proteus.ClientMismatchStrategy.IgnoreAll} IgnoreAll instance
             */
            IgnoreAll.create = function create(properties) {
                return new IgnoreAll(properties);
            };

            /**
             * Encodes the specified IgnoreAll message. Does not implicitly {@link proteus.ClientMismatchStrategy.IgnoreAll.verify|verify} messages.
             * @function encode
             * @memberof proteus.ClientMismatchStrategy.IgnoreAll
             * @static
             * @param {proteus.ClientMismatchStrategy.IIgnoreAll} message IgnoreAll message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            IgnoreAll.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                return writer;
            };

            /**
             * Encodes the specified IgnoreAll message, length delimited. Does not implicitly {@link proteus.ClientMismatchStrategy.IgnoreAll.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proteus.ClientMismatchStrategy.IgnoreAll
             * @static
             * @param {proteus.ClientMismatchStrategy.IIgnoreAll} message IgnoreAll message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            IgnoreAll.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes an IgnoreAll message from the specified reader or buffer.
             * @function decode
             * @memberof proteus.ClientMismatchStrategy.IgnoreAll
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proteus.ClientMismatchStrategy.IgnoreAll} IgnoreAll
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            IgnoreAll.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proteus.ClientMismatchStrategy.IgnoreAll();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes an IgnoreAll message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proteus.ClientMismatchStrategy.IgnoreAll
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proteus.ClientMismatchStrategy.IgnoreAll} IgnoreAll
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            IgnoreAll.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies an IgnoreAll message.
             * @function verify
             * @memberof proteus.ClientMismatchStrategy.IgnoreAll
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            IgnoreAll.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                return null;
            };

            /**
             * Creates an IgnoreAll message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proteus.ClientMismatchStrategy.IgnoreAll
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proteus.ClientMismatchStrategy.IgnoreAll} IgnoreAll
             */
            IgnoreAll.fromObject = function fromObject(object) {
                if (object instanceof $root.proteus.ClientMismatchStrategy.IgnoreAll)
                    return object;
                return new $root.proteus.ClientMismatchStrategy.IgnoreAll();
            };

            /**
             * Creates a plain object from an IgnoreAll message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proteus.ClientMismatchStrategy.IgnoreAll
             * @static
             * @param {proteus.ClientMismatchStrategy.IgnoreAll} message IgnoreAll
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            IgnoreAll.toObject = function toObject() {
                return {};
            };

            /**
             * Converts this IgnoreAll to JSON.
             * @function toJSON
             * @memberof proteus.ClientMismatchStrategy.IgnoreAll
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            IgnoreAll.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * Gets the default type url for IgnoreAll
             * @function getTypeUrl
             * @memberof proteus.ClientMismatchStrategy.IgnoreAll
             * @static
             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns {string} The default type url
             */
            IgnoreAll.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proteus.ClientMismatchStrategy.IgnoreAll";
            };

            return IgnoreAll;
        })();

        ClientMismatchStrategy.ReportOnly = (function() {

            /**
             * Properties of a ReportOnly.
             * @memberof proteus.ClientMismatchStrategy
             * @interface IReportOnly
             * @property {Array.<proteus.IQualifiedUserId>|null} [userIds] ReportOnly userIds
             */

            /**
             * Constructs a new ReportOnly.
             * @memberof proteus.ClientMismatchStrategy
             * @classdesc Represents a ReportOnly.
             * @implements IReportOnly
             * @constructor
             * @param {proteus.ClientMismatchStrategy.IReportOnly=} [properties] Properties to set
             */
            function ReportOnly(properties) {
                this.userIds = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * ReportOnly userIds.
             * @member {Array.<proteus.IQualifiedUserId>} userIds
             * @memberof proteus.ClientMismatchStrategy.ReportOnly
             * @instance
             */
            ReportOnly.prototype.userIds = $util.emptyArray;

            /**
             * Creates a new ReportOnly instance using the specified properties.
             * @function create
             * @memberof proteus.ClientMismatchStrategy.ReportOnly
             * @static
             * @param {proteus.ClientMismatchStrategy.IReportOnly=} [properties] Properties to set
             * @returns {proteus.ClientMismatchStrategy.ReportOnly} ReportOnly instance
             */
            ReportOnly.create = function create(properties) {
                return new ReportOnly(properties);
            };

            /**
             * Encodes the specified ReportOnly message. Does not implicitly {@link proteus.ClientMismatchStrategy.ReportOnly.verify|verify} messages.
             * @function encode
             * @memberof proteus.ClientMismatchStrategy.ReportOnly
             * @static
             * @param {proteus.ClientMismatchStrategy.IReportOnly} message ReportOnly message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            ReportOnly.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.userIds != null && message.userIds.length)
                    for (var i = 0; i < message.userIds.length; ++i)
                        $root.proteus.QualifiedUserId.encode(message.userIds[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified ReportOnly message, length delimited. Does not implicitly {@link proteus.ClientMismatchStrategy.ReportOnly.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proteus.ClientMismatchStrategy.ReportOnly
             * @static
             * @param {proteus.ClientMismatchStrategy.IReportOnly} message ReportOnly message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            ReportOnly.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a ReportOnly message from the specified reader or buffer.
             * @function decode
             * @memberof proteus.ClientMismatchStrategy.ReportOnly
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proteus.ClientMismatchStrategy.ReportOnly} ReportOnly
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            ReportOnly.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proteus.ClientMismatchStrategy.ReportOnly();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1: {
                            if (!(message.userIds && message.userIds.length))
                                message.userIds = [];
                            message.userIds.push($root.proteus.QualifiedUserId.decode(reader, reader.uint32()));
                            break;
                        }
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a ReportOnly message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proteus.ClientMismatchStrategy.ReportOnly
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proteus.ClientMismatchStrategy.ReportOnly} ReportOnly
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            ReportOnly.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a ReportOnly message.
             * @function verify
             * @memberof proteus.ClientMismatchStrategy.ReportOnly
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            ReportOnly.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.userIds != null && message.hasOwnProperty("userIds")) {
                    if (!Array.isArray(message.userIds))
                        return "userIds: array expected";
                    for (var i = 0; i < message.userIds.length; ++i) {
                        var error = $root.proteus.QualifiedUserId.verify(message.userIds[i]);
                        if (error)
                            return "userIds." + error;
                    }
                }
                return null;
            };

            /**
             * Creates a ReportOnly message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proteus.ClientMismatchStrategy.ReportOnly
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proteus.ClientMismatchStrategy.ReportOnly} ReportOnly
             */
            ReportOnly.fromObject = function fromObject(object) {
                if (object instanceof $root.proteus.ClientMismatchStrategy.ReportOnly)
                    return object;
                var message = new $root.proteus.ClientMismatchStrategy.ReportOnly();
                if (object.userIds) {
                    if (!Array.isArray(object.userIds))
                        throw TypeError(".proteus.ClientMismatchStrategy.ReportOnly.userIds: array expected");
                    message.userIds = [];
                    for (var i = 0; i < object.userIds.length; ++i) {
                        if (typeof object.userIds[i] !== "object")
                            throw TypeError(".proteus.ClientMismatchStrategy.ReportOnly.userIds: object expected");
                        message.userIds[i] = $root.proteus.QualifiedUserId.fromObject(object.userIds[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from a ReportOnly message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proteus.ClientMismatchStrategy.ReportOnly
             * @static
             * @param {proteus.ClientMismatchStrategy.ReportOnly} message ReportOnly
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            ReportOnly.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.userIds = [];
                if (message.userIds && message.userIds.length) {
                    object.userIds = [];
                    for (var j = 0; j < message.userIds.length; ++j)
                        object.userIds[j] = $root.proteus.QualifiedUserId.toObject(message.userIds[j], options);
                }
                return object;
            };

            /**
             * Converts this ReportOnly to JSON.
             * @function toJSON
             * @memberof proteus.ClientMismatchStrategy.ReportOnly
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            ReportOnly.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * Gets the default type url for ReportOnly
             * @function getTypeUrl
             * @memberof proteus.ClientMismatchStrategy.ReportOnly
             * @static
             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns {string} The default type url
             */
            ReportOnly.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proteus.ClientMismatchStrategy.ReportOnly";
            };

            return ReportOnly;
        })();

        ClientMismatchStrategy.IgnoreOnly = (function() {

            /**
             * Properties of an IgnoreOnly.
             * @memberof proteus.ClientMismatchStrategy
             * @interface IIgnoreOnly
             * @property {Array.<proteus.IQualifiedUserId>|null} [userIds] IgnoreOnly userIds
             */

            /**
             * Constructs a new IgnoreOnly.
             * @memberof proteus.ClientMismatchStrategy
             * @classdesc Represents an IgnoreOnly.
             * @implements IIgnoreOnly
             * @constructor
             * @param {proteus.ClientMismatchStrategy.IIgnoreOnly=} [properties] Properties to set
             */
            function IgnoreOnly(properties) {
                this.userIds = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * IgnoreOnly userIds.
             * @member {Array.<proteus.IQualifiedUserId>} userIds
             * @memberof proteus.ClientMismatchStrategy.IgnoreOnly
             * @instance
             */
            IgnoreOnly.prototype.userIds = $util.emptyArray;

            /**
             * Creates a new IgnoreOnly instance using the specified properties.
             * @function create
             * @memberof proteus.ClientMismatchStrategy.IgnoreOnly
             * @static
             * @param {proteus.ClientMismatchStrategy.IIgnoreOnly=} [properties] Properties to set
             * @returns {proteus.ClientMismatchStrategy.IgnoreOnly} IgnoreOnly instance
             */
            IgnoreOnly.create = function create(properties) {
                return new IgnoreOnly(properties);
            };

            /**
             * Encodes the specified IgnoreOnly message. Does not implicitly {@link proteus.ClientMismatchStrategy.IgnoreOnly.verify|verify} messages.
             * @function encode
             * @memberof proteus.ClientMismatchStrategy.IgnoreOnly
             * @static
             * @param {proteus.ClientMismatchStrategy.IIgnoreOnly} message IgnoreOnly message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            IgnoreOnly.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.userIds != null && message.userIds.length)
                    for (var i = 0; i < message.userIds.length; ++i)
                        $root.proteus.QualifiedUserId.encode(message.userIds[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                return writer;
            };

            /**
             * Encodes the specified IgnoreOnly message, length delimited. Does not implicitly {@link proteus.ClientMismatchStrategy.IgnoreOnly.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proteus.ClientMismatchStrategy.IgnoreOnly
             * @static
             * @param {proteus.ClientMismatchStrategy.IIgnoreOnly} message IgnoreOnly message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            IgnoreOnly.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes an IgnoreOnly message from the specified reader or buffer.
             * @function decode
             * @memberof proteus.ClientMismatchStrategy.IgnoreOnly
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proteus.ClientMismatchStrategy.IgnoreOnly} IgnoreOnly
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            IgnoreOnly.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proteus.ClientMismatchStrategy.IgnoreOnly();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1: {
                            if (!(message.userIds && message.userIds.length))
                                message.userIds = [];
                            message.userIds.push($root.proteus.QualifiedUserId.decode(reader, reader.uint32()));
                            break;
                        }
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes an IgnoreOnly message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proteus.ClientMismatchStrategy.IgnoreOnly
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proteus.ClientMismatchStrategy.IgnoreOnly} IgnoreOnly
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            IgnoreOnly.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies an IgnoreOnly message.
             * @function verify
             * @memberof proteus.ClientMismatchStrategy.IgnoreOnly
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            IgnoreOnly.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.userIds != null && message.hasOwnProperty("userIds")) {
                    if (!Array.isArray(message.userIds))
                        return "userIds: array expected";
                    for (var i = 0; i < message.userIds.length; ++i) {
                        var error = $root.proteus.QualifiedUserId.verify(message.userIds[i]);
                        if (error)
                            return "userIds." + error;
                    }
                }
                return null;
            };

            /**
             * Creates an IgnoreOnly message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proteus.ClientMismatchStrategy.IgnoreOnly
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proteus.ClientMismatchStrategy.IgnoreOnly} IgnoreOnly
             */
            IgnoreOnly.fromObject = function fromObject(object) {
                if (object instanceof $root.proteus.ClientMismatchStrategy.IgnoreOnly)
                    return object;
                var message = new $root.proteus.ClientMismatchStrategy.IgnoreOnly();
                if (object.userIds) {
                    if (!Array.isArray(object.userIds))
                        throw TypeError(".proteus.ClientMismatchStrategy.IgnoreOnly.userIds: array expected");
                    message.userIds = [];
                    for (var i = 0; i < object.userIds.length; ++i) {
                        if (typeof object.userIds[i] !== "object")
                            throw TypeError(".proteus.ClientMismatchStrategy.IgnoreOnly.userIds: object expected");
                        message.userIds[i] = $root.proteus.QualifiedUserId.fromObject(object.userIds[i]);
                    }
                }
                return message;
            };

            /**
             * Creates a plain object from an IgnoreOnly message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proteus.ClientMismatchStrategy.IgnoreOnly
             * @static
             * @param {proteus.ClientMismatchStrategy.IgnoreOnly} message IgnoreOnly
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            IgnoreOnly.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.arrays || options.defaults)
                    object.userIds = [];
                if (message.userIds && message.userIds.length) {
                    object.userIds = [];
                    for (var j = 0; j < message.userIds.length; ++j)
                        object.userIds[j] = $root.proteus.QualifiedUserId.toObject(message.userIds[j], options);
                }
                return object;
            };

            /**
             * Converts this IgnoreOnly to JSON.
             * @function toJSON
             * @memberof proteus.ClientMismatchStrategy.IgnoreOnly
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            IgnoreOnly.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * Gets the default type url for IgnoreOnly
             * @function getTypeUrl
             * @memberof proteus.ClientMismatchStrategy.IgnoreOnly
             * @static
             * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns {string} The default type url
             */
            IgnoreOnly.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proteus.ClientMismatchStrategy.IgnoreOnly";
            };

            return IgnoreOnly;
        })();

        return ClientMismatchStrategy;
    })();

    proteus.OtrAssetMeta = (function() {

        /**
         * Properties of an OtrAssetMeta.
         * @memberof proteus
         * @interface IOtrAssetMeta
         * @property {proteus.IClientId} sender OtrAssetMeta sender
         * @property {Array.<proteus.IUserEntry>|null} [recipients] OtrAssetMeta recipients
         * @property {boolean|null} [isInline] OtrAssetMeta isInline
         * @property {boolean|null} [nativePush] OtrAssetMeta nativePush
         */

        /**
         * Constructs a new OtrAssetMeta.
         * @memberof proteus
         * @classdesc Represents an OtrAssetMeta.
         * @implements IOtrAssetMeta
         * @constructor
         * @param {proteus.IOtrAssetMeta=} [properties] Properties to set
         */
        function OtrAssetMeta(properties) {
            this.recipients = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * OtrAssetMeta sender.
         * @member {proteus.IClientId} sender
         * @memberof proteus.OtrAssetMeta
         * @instance
         */
        OtrAssetMeta.prototype.sender = null;

        /**
         * OtrAssetMeta recipients.
         * @member {Array.<proteus.IUserEntry>} recipients
         * @memberof proteus.OtrAssetMeta
         * @instance
         */
        OtrAssetMeta.prototype.recipients = $util.emptyArray;

        /**
         * OtrAssetMeta isInline.
         * @member {boolean} isInline
         * @memberof proteus.OtrAssetMeta
         * @instance
         */
        OtrAssetMeta.prototype.isInline = false;

        /**
         * OtrAssetMeta nativePush.
         * @member {boolean} nativePush
         * @memberof proteus.OtrAssetMeta
         * @instance
         */
        OtrAssetMeta.prototype.nativePush = true;

        /**
         * Creates a new OtrAssetMeta instance using the specified properties.
         * @function create
         * @memberof proteus.OtrAssetMeta
         * @static
         * @param {proteus.IOtrAssetMeta=} [properties] Properties to set
         * @returns {proteus.OtrAssetMeta} OtrAssetMeta instance
         */
        OtrAssetMeta.create = function create(properties) {
            return new OtrAssetMeta(properties);
        };

        /**
         * Encodes the specified OtrAssetMeta message. Does not implicitly {@link proteus.OtrAssetMeta.verify|verify} messages.
         * @function encode
         * @memberof proteus.OtrAssetMeta
         * @static
         * @param {proteus.IOtrAssetMeta} message OtrAssetMeta message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        OtrAssetMeta.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            $root.proteus.ClientId.encode(message.sender, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.recipients != null && message.recipients.length)
                for (var i = 0; i < message.recipients.length; ++i)
                    $root.proteus.UserEntry.encode(message.recipients[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.isInline != null && Object.hasOwnProperty.call(message, "isInline"))
                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.isInline);
            if (message.nativePush != null && Object.hasOwnProperty.call(message, "nativePush"))
                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.nativePush);
            return writer;
        };

        /**
         * Encodes the specified OtrAssetMeta message, length delimited. Does not implicitly {@link proteus.OtrAssetMeta.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proteus.OtrAssetMeta
         * @static
         * @param {proteus.IOtrAssetMeta} message OtrAssetMeta message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        OtrAssetMeta.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an OtrAssetMeta message from the specified reader or buffer.
         * @function decode
         * @memberof proteus.OtrAssetMeta
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proteus.OtrAssetMeta} OtrAssetMeta
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        OtrAssetMeta.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proteus.OtrAssetMeta();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1: {
                        message.sender = $root.proteus.ClientId.decode(reader, reader.uint32());
                        break;
                    }
                case 2: {
                        if (!(message.recipients && message.recipients.length))
                            message.recipients = [];
                        message.recipients.push($root.proteus.UserEntry.decode(reader, reader.uint32()));
                        break;
                    }
                case 3: {
                        message.isInline = reader.bool();
                        break;
                    }
                case 4: {
                        message.nativePush = reader.bool();
                        break;
                    }
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            if (!message.hasOwnProperty("sender"))
                throw $util.ProtocolError("missing required 'sender'", { instance: message });
            return message;
        };

        /**
         * Decodes an OtrAssetMeta message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proteus.OtrAssetMeta
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proteus.OtrAssetMeta} OtrAssetMeta
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        OtrAssetMeta.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an OtrAssetMeta message.
         * @function verify
         * @memberof proteus.OtrAssetMeta
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        OtrAssetMeta.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            {
                var error = $root.proteus.ClientId.verify(message.sender);
                if (error)
                    return "sender." + error;
            }
            if (message.recipients != null && message.hasOwnProperty("recipients")) {
                if (!Array.isArray(message.recipients))
                    return "recipients: array expected";
                for (var i = 0; i < message.recipients.length; ++i) {
                    var error = $root.proteus.UserEntry.verify(message.recipients[i]);
                    if (error)
                        return "recipients." + error;
                }
            }
            if (message.isInline != null && message.hasOwnProperty("isInline"))
                if (typeof message.isInline !== "boolean")
                    return "isInline: boolean expected";
            if (message.nativePush != null && message.hasOwnProperty("nativePush"))
                if (typeof message.nativePush !== "boolean")
                    return "nativePush: boolean expected";
            return null;
        };

        /**
         * Creates an OtrAssetMeta message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proteus.OtrAssetMeta
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proteus.OtrAssetMeta} OtrAssetMeta
         */
        OtrAssetMeta.fromObject = function fromObject(object) {
            if (object instanceof $root.proteus.OtrAssetMeta)
                return object;
            var message = new $root.proteus.OtrAssetMeta();
            if (object.sender != null) {
                if (typeof object.sender !== "object")
                    throw TypeError(".proteus.OtrAssetMeta.sender: object expected");
                message.sender = $root.proteus.ClientId.fromObject(object.sender);
            }
            if (object.recipients) {
                if (!Array.isArray(object.recipients))
                    throw TypeError(".proteus.OtrAssetMeta.recipients: array expected");
                message.recipients = [];
                for (var i = 0; i < object.recipients.length; ++i) {
                    if (typeof object.recipients[i] !== "object")
                        throw TypeError(".proteus.OtrAssetMeta.recipients: object expected");
                    message.recipients[i] = $root.proteus.UserEntry.fromObject(object.recipients[i]);
                }
            }
            if (object.isInline != null)
                message.isInline = Boolean(object.isInline);
            if (object.nativePush != null)
                message.nativePush = Boolean(object.nativePush);
            return message;
        };

        /**
         * Creates a plain object from an OtrAssetMeta message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proteus.OtrAssetMeta
         * @static
         * @param {proteus.OtrAssetMeta} message OtrAssetMeta
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        OtrAssetMeta.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.recipients = [];
            if (options.defaults) {
                object.sender = null;
                object.isInline = false;
                object.nativePush = true;
            }
            if (message.sender != null && message.hasOwnProperty("sender"))
                object.sender = $root.proteus.ClientId.toObject(message.sender, options);
            if (message.recipients && message.recipients.length) {
                object.recipients = [];
                for (var j = 0; j < message.recipients.length; ++j)
                    object.recipients[j] = $root.proteus.UserEntry.toObject(message.recipients[j], options);
            }
            if (message.isInline != null && message.hasOwnProperty("isInline"))
                object.isInline = message.isInline;
            if (message.nativePush != null && message.hasOwnProperty("nativePush"))
                object.nativePush = message.nativePush;
            return object;
        };

        /**
         * Converts this OtrAssetMeta to JSON.
         * @function toJSON
         * @memberof proteus.OtrAssetMeta
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        OtrAssetMeta.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Gets the default type url for OtrAssetMeta
         * @function getTypeUrl
         * @memberof proteus.OtrAssetMeta
         * @static
         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns {string} The default type url
         */
        OtrAssetMeta.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proteus.OtrAssetMeta";
        };

        return OtrAssetMeta;
    })();

    return proteus;
})();

module.exports = $root;
