"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Avatar = exports.DEFAULT_AVATAR_SIZE = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
/*
 * Wire
 * Copyright (C) 2019 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
const react_1 = require("react");
const colors_1 = require("./colors");
const motions_1 = require("./motions");
const Misc_1 = require("../Misc/");
const util_1 = require("../util");
exports.DEFAULT_AVATAR_SIZE = 28;
const avatarStyle = ({ color = colors_1.COLOR.WHITE, url, borderColor, backgroundColor = colors_1.COLOR.GRAY, size = exports.DEFAULT_AVATAR_SIZE, isAvatarGridItem, }) => {
    const BORDER_SIZE_LIMIT = 32;
    const borderSize = size > BORDER_SIZE_LIMIT ? 2 : 1;
    const borderWidth = url ? 0 : borderSize;
    const fontSize = `${Math.ceil(size / 2.2)}px`;
    return {
        alignItems: 'center',
        backgroundColor: backgroundColor,
        borderRadius: isAvatarGridItem ? '0' : '50%',
        boxShadow: isAvatarGridItem ? 'none' : `inset 0 0 0 ${borderWidth}px ${borderColor}`,
        color,
        display: 'flex',
        fontSize,
        fontWeight: isAvatarGridItem ? 700 : 400,
        height: `${size}px`,
        justifyContent: 'center',
        minHeight: `${size}px`,
        minWidth: `${size}px`,
        overflow: 'hidden',
        width: `${size}px`,
    };
};
const filteredAvatarProps = (props) => (0, util_1.filterProps)(props, [
    'size',
    'forceInitials',
    'name',
    'url',
    'borderColor',
    'backgroundColor',
    'fetchImage',
    'isAvatarGridItem',
]);
const Avatar = (props) => {
    const { url, forceInitials, name, fetchImage, isAvatarGridItem } = props;
    const [scale, setScale] = (0, react_1.useState)(0);
    (0, react_1.useEffect)(() => {
        if (url) {
            requestAnimationFrame(() => setScale(1));
        }
    }, [url]);
    const getInitials = (name = '') => name
        .split(' ')
        .filter(Boolean)
        .map(([initial]) => initial.toUpperCase())
        .join('')
        .substring(0, isAvatarGridItem ? 1 : 2);
    return ((0, jsx_runtime_1.jsx)(Misc_1.IsInViewport, Object.assign({ checkViewportOnce: true, onEnterViewport: fetchImage, disabled: !!url, css: avatarStyle(props), "data-uie-name": !forceInitials && url ? 'element-avatar-image' : 'element-avatar-initials' }, filteredAvatarProps(props), { children: forceInitials || !url ? (getInitials(name)) : ((0, jsx_runtime_1.jsx)("div", { css: {
                backgroundImage: url && `url(${url})`,
                backgroundPosition: 'center',
                backgroundSize: 'cover',
                borderRadius: isAvatarGridItem ? '0' : '50%',
                minHeight: '100%',
                minWidth: '100%',
                opacity: scale,
                transform: `scale(${scale})`,
                transition: `all ${motions_1.DURATION.DEFAULT}ms ${motions_1.EASE.QUART}`,
                width: '100%',
            } })) })));
};
exports.Avatar = Avatar;
