/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.parosproxy.paros.network.HttpHeaderField;
import org.parosproxy.paros.network.HttpMessage;

public class SpiderResourceFound {
    private final HttpMessage message;
    private final int depth;
    private final String method;
    private final String uri;
    private final String body;
    private final boolean shouldIgnore;
    private final List<HttpHeaderField> headers;

    private SpiderResourceFound(HttpMessage message, int depth, String uri, String method, String body, boolean shouldIgnore, List<HttpHeaderField> headers) {
        this.message = message;
        this.depth = depth;
        this.uri = uri;
        this.method = method;
        this.body = body;
        this.shouldIgnore = shouldIgnore;
        this.headers = headers;
    }

    public HttpMessage getMessage() {
        return this.message;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUri() {
        return this.uri;
    }

    public String getBody() {
        return this.body;
    }

    public boolean isShouldIgnore() {
        return this.shouldIgnore;
    }

    public List<HttpHeaderField> getHeaders() {
        return this.headers;
    }

    public int hashCode() {
        return Objects.hash(this.body, this.depth, this.headers, this.message, this.method, this.shouldIgnore, this.uri);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SpiderResourceFound)) {
            return false;
        }
        SpiderResourceFound other = (SpiderResourceFound)obj;
        return Objects.equals(this.body, other.body) && this.depth == other.depth && Objects.equals(this.headers, other.headers) && Objects.equals(this.message, other.message) && Objects.equals(this.method, other.method) && this.shouldIgnore == other.shouldIgnore && Objects.equals(this.uri, other.uri);
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder(75);
        strBuilder.append("[Method=").append(this.method).append(", URI=").append(this.uri).append(", Headers=").append(this.headers).append(", Body=").append(this.body).append(", ShouldIgnore=").append(this.shouldIgnore).append(", Depth=").append(this.depth).append(", Message=").append(this.message);
        return strBuilder.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SpiderResourceFound spiderResourceFound) {
        if (spiderResourceFound == null) {
            throw new IllegalArgumentException("Parameter spiderResourceFound must not be null.");
        }
        return new Builder(spiderResourceFound);
    }

    public static class Builder {
        private HttpMessage message;
        private int depth;
        private String method;
        private String uri;
        private String body;
        private boolean shouldIgnore;
        private List<HttpHeaderField> headers;

        private Builder() {
            this.message = null;
            this.depth = 0;
            this.method = "GET";
            this.uri = "";
            this.body = "";
            this.shouldIgnore = false;
            this.headers = Collections.emptyList();
        }

        private Builder(SpiderResourceFound resourceFound) {
            this.message = resourceFound.getMessage();
            this.depth = resourceFound.getDepth();
            this.method = resourceFound.getMethod();
            this.uri = resourceFound.getUri();
            this.body = resourceFound.getBody();
            this.shouldIgnore = resourceFound.isShouldIgnore();
            this.headers = resourceFound.getHeaders();
        }

        public Builder setMessage(HttpMessage message) {
            this.message = message;
            return this;
        }

        public Builder setDepth(int depth) {
            if (depth < 0) {
                throw new IllegalArgumentException("Parameter depth must not be negative.");
            }
            this.depth = depth;
            return this;
        }

        public Builder setMethod(String method) {
            if (method == null) {
                throw new IllegalArgumentException("Parameter method must not be null.");
            }
            this.method = method;
            return this;
        }

        public Builder setUri(String uri) {
            if (uri == null) {
                throw new IllegalArgumentException("Parameter uri must not be null.");
            }
            this.uri = uri;
            return this;
        }

        public Builder setBody(String body) {
            if (body == null) {
                throw new IllegalArgumentException("Parameter body must not be null.");
            }
            this.body = body;
            return this;
        }

        public Builder setShouldIgnore(boolean shouldIgnore) {
            this.shouldIgnore = shouldIgnore;
            return this;
        }

        public Builder setHeaders(List<HttpHeaderField> headers) {
            if (headers == null) {
                throw new IllegalArgumentException("Parameter headers must not be null.");
            }
            if (!headers.isEmpty()) {
                ArrayList<HttpHeaderField> validHeaders = new ArrayList<HttpHeaderField>();
                for (HttpHeaderField headerField : headers) {
                    if (headerField == null) {
                        throw new IllegalArgumentException("Element of headers must not be null.");
                    }
                    if (headerField.getName() == null || headerField.getName().trim().isEmpty() || headerField.getValue() == null) continue;
                    validHeaders.add(headerField);
                }
                this.headers = Collections.unmodifiableList(validHeaders);
            } else {
                this.headers = Collections.emptyList();
            }
            return this;
        }

        public SpiderResourceFound build() {
            return new SpiderResourceFound(this.message, this.depth, this.uri, this.method, this.body, this.shouldIgnore, this.headers);
        }
    }
}

