/**
 * SECTION:web-service-details
 * @short_description: Object representing a web service contact that can have some parameters associated with it.
 * 
 * <para>See <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link>.</para>
 *
 * Since: 0.6.0
 */
/**
 * FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS:
 * 
 * The type for <link linkend="FolksWebServiceFieldDetails"><type>FolksWebServiceFieldDetails</type></link>.
 */
/**
 * folks_web_service_field_details_new:
 * @value: (in): &nbsp;.  <para>the value of the field, a non-empty web service address </para>
 * @parameters: (in) (allow-none): &nbsp;.  <para>initial parameters. See <link linkend="FolksAbstractFieldDetails--parameters"><type>"parameters"</type></link>. A <code>null</code> value is equivalent to an empty map of parameters. </para>
 * 
 * Create a new WebServiceFieldDetails.
 * 
 * Returns: <para>a new WebServiceFieldDetails </para>
 *
 * Since: 0.6.0
 */
/**
 * FolksWebServiceFieldDetails:
 * 
 * Object representing a web service contact that can have some parameters associated with it.
 * 
 * <para>See <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link>.</para>
 *
 * Since: 0.6.0
 */
/**
 * FolksWebServiceFieldDetailsClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-WEB-SERVICE-FIELD-DETAILS:CAPS"><literal>FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * folks_web_service_details_change_web_service_addresses:
 * @self: the <link linkend="FolksWebServiceDetails"><type>FolksWebServiceDetails</type></link> instance
 * @web_service_addresses: (in): &nbsp;.  <para>the set of addresses </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change the contact&apos;s web service addresses.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksWebServiceDetails--web-service-addresses"><type>"web-service-addresses"</type></link> directly, as this method gives error notification and will only return once the addresses have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the addresses failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-web-service-details-change-web-service-addresses-finish"><function>folks_web_service_details_change_web_service_addresses_finish()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_web_service_details_change_web_service_addresses_finish:
 * @self: the <link linkend="FolksWebServiceDetails"><type>FolksWebServiceDetails</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change the contact&apos;s web service addresses.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksWebServiceDetails--web-service-addresses"><type>"web-service-addresses"</type></link> directly, as this method gives error notification and will only return once the addresses have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the addresses failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-web-service-details-change-web-service-addresses"><function>folks_web_service_details_change_web_service_addresses()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * FolksWebServiceDetails:web-service-addresses:
 * 
 * A mapping of web service to an (unordered) set of web service addresses.
 * 
 * <para>Each mapping is from an arbitrary web service identifier to a set of web service addresses for the contact, listed in no particular order.</para><para>Web service addresses are guaranteed to be unique per web service, but not necessarily unique amongst all web services.</para>
 *
 * Since: 0.6.0
 */
/**
 * folks_web_service_details_get_web_service_addresses:
 * @self: the <link linkend="FolksWebServiceDetails"><type>FolksWebServiceDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksWebServiceDetails--web-service-addresses"><type>"web-service-addresses"</type></link> property.
 * 
 * A mapping of web service to an (unordered) set of web service addresses.
 * 
 * <para>Each mapping is from an arbitrary web service identifier to a set of web service addresses for the contact, listed in no particular order.</para><para>Web service addresses are guaranteed to be unique per web service, but not necessarily unique amongst all web services.</para>
 * 
 * Returns: the value of the <link linkend="FolksWebServiceDetails--web-service-addresses"><type>"web-service-addresses"</type></link> property
 *
 * Since: 0.6.0
 */
/**
 * folks_web_service_details_set_web_service_addresses:
 * @self: the <link linkend="FolksWebServiceDetails"><type>FolksWebServiceDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksWebServiceDetails--web-service-addresses"><type>"web-service-addresses"</type></link> property
 * 
 * Set the value of the <link linkend="FolksWebServiceDetails--web-service-addresses"><type>"web-service-addresses"</type></link> property to @value.
 * 
 * A mapping of web service to an (unordered) set of web service addresses.
 * 
 * <para>Each mapping is from an arbitrary web service identifier to a set of web service addresses for the contact, listed in no particular order.</para><para>Web service addresses are guaranteed to be unique per web service, but not necessarily unique amongst all web services.</para>
 *
 * Since: 0.6.0
 */
/**
 * FolksWebServiceDetails:
 * 
 * Web service contact details.
 *
 * Since: 0.5.0
 */
/**
 * FolksWebServiceDetailsIface:
 * @change_web_service_addresses: virtual method called by <link linkend="folks-web-service-details-change-web-service-addresses"><function>folks_web_service_details_change_web_service_addresses()</function></link>
 * @change_web_service_addresses_finish: asynchronous finish function for <structfield>change_web_service_addresses</structfield>, called by <link linkend="folks-web-service-details-change-web-service-addresses"><function>folks_web_service_details_change_web_service_addresses()</function></link>
 * @get_web_service_addresses: getter method for the abstract property <link linkend="FolksWebServiceDetails--web-service-addresses"><type>"web-service-addresses"</type></link>
 * @set_web_service_addresses: setter method for the abstract property <link linkend="FolksWebServiceDetails--web-service-addresses"><type>"web-service-addresses"</type></link>
 * @parent_iface: the parent interface structure
 * 
 * Interface for creating <link linkend="FolksWebServiceDetails"><type>FolksWebServiceDetails</type></link> implementations.
 */
