/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.cmd.AppendRangeCmd;
import tim.prune.cmd.CompoundCommand;
import tim.prune.cmd.DeleteAllPointsCmd;
import tim.prune.cmd.RemoveCorrelatedMediaCmd;
import tim.prune.data.Checker;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.FieldList;
import tim.prune.data.PointCreateOptions;
import tim.prune.data.SourceInfo;
import tim.prune.load.ItemToLoad;
import tim.prune.load.MediaLinkInfo;
import tim.prune.load.xml.XmlHandler;

public class FileTypeLoader {
    private final App _app;

    public FileTypeLoader(App app) {
        this._app = app;
    }

    protected App getApp() {
        return this._app;
    }

    protected int getAppendOption(boolean bl) {
        if (bl || this._app.getTrackInfo().getTrack().getNumPoints() == 0) {
            return 0;
        }
        return JOptionPane.showConfirmDialog(this._app.getFrame(), I18nManager.getText("dialog.openappend.text"), I18nManager.getText("dialog.openappend.title"), 1);
    }

    protected void loadData(List<DataPoint> list, SourceInfo sourceInfo, boolean bl) {
        int n = 0;
        for (DataPoint object2 : list) {
            object2.setSourceInfo(sourceInfo);
            object2.setOriginalIndex(n++);
        }
        if (sourceInfo != null) {
            sourceInfo.setNumPoints(list.size());
        }
        CompoundCommand compoundCommand = new CompoundCommand(64);
        if (bl) {
            compoundCommand.addCommand(new AppendRangeCmd(list));
        } else {
            compoundCommand.addCommand(new RemoveCorrelatedMediaCmd()).addCommand(new DeleteAllPointsCmd()).addCommand(new AppendRangeCmd(list));
        }
        String string = sourceInfo == null ? I18nManager.getTextWithNumber("undo.loadpoints", list.size()) : I18nManager.getText("undo.loadfile", this.getFilename(sourceInfo));
        compoundCommand.setDescription(string);
        compoundCommand.setConfirmText(I18nManager.getTextWithNumber("confirm.pointsadded", list.size()));
        if (this._app.execute(compoundCommand)) {
            Checker.DoubleStatus doubleStatus = Checker.isDoubledTrack(list);
            if (doubleStatus != Checker.DoubleStatus.NOTHING) {
                String bl2 = doubleStatus == Checker.DoubleStatus.DOUBLED_WAYPOINTS_TRACKPOINTS ? "contentsdoubled.wayandtrack" : "contentsdoubled";
                JOptionPane.showMessageDialog(this._app.getFrame(), I18nManager.getText("dialog.open." + bl2), I18nManager.getText("function.open"), 2);
            }
            if (sourceInfo != null) {
                boolean bl2 = sourceInfo.getFileType() != SourceInfo.FILE_TYPE.GPSBABEL;
                this._app.addRecentFile(sourceInfo.getFile(), bl2);
            }
        }
    }

    private String getFilename(SourceInfo sourceInfo) {
        if (sourceInfo == null || sourceInfo.getFile() == null) {
            return "";
        }
        String string = sourceInfo.getFile().getName();
        if (string.length() > 20) {
            return String.valueOf(string.substring(0, 20)) + "...";
        }
        return string;
    }

    protected List<DataPoint> createPoints(Field[] fieldArray, Object[][] objectArray, PointCreateOptions pointCreateOptions) {
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        boolean bl = true;
        FieldList fieldList = new FieldList(fieldArray);
        Object[][] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray3 = objectArray2[n2];
            DataPoint dataPoint = new DataPoint((String[])objectArray3, fieldList, pointCreateOptions);
            if (dataPoint.isValid()) {
                if (bl) {
                    dataPoint.setSegmentStart(true);
                }
                arrayList.add(dataPoint);
                bl = false;
            }
            ++n2;
        }
        return arrayList;
    }

    public void loadData(XmlHandler xmlHandler, SourceInfo sourceInfo, boolean bl, MediaLinkInfo mediaLinkInfo) {
        int n = this.getAppendOption(bl);
        if (n == 2) {
            return;
        }
        List<DataPoint> list = this.createPoints(xmlHandler.getFieldArray(), xmlHandler.getDataArray(), null);
        this.loadData(list, sourceInfo, n == 0);
        if (mediaLinkInfo != null && mediaLinkInfo.getLinkArray() != null && mediaLinkInfo.getLinkArray().length == list.size()) {
            ArrayList<ItemToLoad> arrayList = new ArrayList<ItemToLoad>();
            int n2 = 0;
            while (n2 < list.size()) {
                String string = mediaLinkInfo.getLinkArray()[n2];
                if (string != null) {
                    DataPoint dataPoint = list.get(n2);
                    if (FileTypeLoader.looksLikeUrl(string)) {
                        try {
                            arrayList.add(ItemToLoad.mediaUrl(new URL(string), dataPoint));
                        }
                        catch (MalformedURLException malformedURLException) {}
                    } else {
                        arrayList.add(ItemToLoad.archivedFile(sourceInfo.getFile(), string, dataPoint));
                    }
                }
                ++n2;
            }
            this._app.loadLinkedMedia(arrayList);
        }
    }

    private static boolean looksLikeUrl(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.toLowerCase();
        return string2.startsWith("http://") || string2.startsWith("https://");
    }
}

