/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.tools.ConfidenceKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfidenceMapLoader {
    private static final Logger logger = LoggerFactory.getLogger(ConfidenceMapLoader.class);

    ConfidenceMapLoader() {
    }

    Map<ConfidenceKey, Float> load(File filePattern) throws IOException {
        if (!filePattern.toString().contains("{lang}")) {
            throw new RuntimeException("The 'ruleIdToConfidenceFile' parameter must contain '{lang}' as a placeholder for the language code");
        }
        HashMap<ConfidenceKey, Float> confMap = new HashMap<ConfidenceKey, Float>();
        for (Language lang : Languages.get()) {
            int loadCount = 0;
            String fileName = filePattern.getAbsolutePath().replace("{lang}", lang.getShortCode());
            if (!Paths.get(fileName, new String[0]).toFile().exists()) continue;
            List<String> lines = Files.readAllLines(Paths.get(fileName, new String[0]), StandardCharsets.UTF_8);
            for (String line : lines) {
                if (line.startsWith("#")) continue;
                String[] parts = line.split(",");
                if (parts.length >= 2) {
                    try {
                        float confidence = Float.parseFloat(parts[1]);
                        confMap.put(new ConfidenceKey(lang, parts[0]), Float.valueOf(confidence));
                        ++loadCount;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Invalid confidence float value in " + fileName + ", expected 'RULE_ID,float_value[,...]': " + line);
                    }
                }
                throw new RuntimeException("Invalid line in " + fileName + ", expected 'RULE_ID,float_value[,...]': " + line);
            }
            logger.info("Loaded " + loadCount + " mappings for " + lang + " from confidence map for rules from " + fileName);
        }
        if (confMap.size() == 0) {
            throw new RuntimeException("No confidence values could be loaded for " + filePattern + " -- please check there are actually files that match this pattern");
        }
        return confMap;
    }
}

