/* daemon.c generated by valac 0.56.18, the Vala compiler
 * generated from daemon.vala, do not modify */

/*
 *  pamac-vala
 *
 *  Copyright (C) 2014-2023 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* i18n*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <alpm.h>
#include <float.h>
#include <math.h>
#include <polkit/polkit.h>
#include <glib/gi18n-lib.h>
#include <locale.h>

#define GETTEXT_PACKAGE "pamac"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PAMAC_TYPE_DAEMON (pamac_daemon_get_type ())
#define PAMAC_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_DAEMON, PamacDaemon))
#define PAMAC_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_DAEMON, PamacDaemonClass))
#define PAMAC_IS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_DAEMON))
#define PAMAC_IS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_DAEMON))
#define PAMAC_DAEMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_DAEMON, PamacDaemonClass))

typedef struct _PamacDaemon PamacDaemon;
typedef struct _PamacDaemonClass PamacDaemonClass;
typedef struct _PamacDaemonPrivate PamacDaemonPrivate;

#define PAMAC_TYPE_CONFIG (pamac_config_get_type ())
#define PAMAC_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_CONFIG, PamacConfig))
#define PAMAC_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_CONFIG, PamacConfigClass))
#define PAMAC_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_CONFIG))
#define PAMAC_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_CONFIG))
#define PAMAC_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_CONFIG, PamacConfigClass))

typedef struct _PamacConfig PamacConfig;
typedef struct _PamacConfigClass PamacConfigClass;

#define PAMAC_TYPE_ALPM_UTILS (pamac_alpm_utils_get_type ())
#define PAMAC_ALPM_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_ALPM_UTILS, PamacAlpmUtils))
#define PAMAC_ALPM_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_ALPM_UTILS, PamacAlpmUtilsClass))
#define PAMAC_IS_ALPM_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_ALPM_UTILS))
#define PAMAC_IS_ALPM_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_ALPM_UTILS))
#define PAMAC_ALPM_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_ALPM_UTILS, PamacAlpmUtilsClass))

typedef struct _PamacAlpmUtils PamacAlpmUtils;
typedef struct _PamacAlpmUtilsClass PamacAlpmUtilsClass;

#define PAMAC_TYPE_SNAP_PLUGIN (pamac_snap_plugin_get_type ())
#define PAMAC_SNAP_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_SNAP_PLUGIN, PamacSnapPlugin))
#define PAMAC_IS_SNAP_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_SNAP_PLUGIN))
#define PAMAC_SNAP_PLUGIN_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PAMAC_TYPE_SNAP_PLUGIN, PamacSnapPluginIface))

typedef struct _PamacSnapPlugin PamacSnapPlugin;
typedef struct _PamacSnapPluginIface PamacSnapPluginIface;

#define PAMAC_TYPE_PACKAGE (pamac_package_get_type ())
#define PAMAC_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_PACKAGE, PamacPackage))
#define PAMAC_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_PACKAGE, PamacPackageClass))
#define PAMAC_IS_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_PACKAGE))
#define PAMAC_IS_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_PACKAGE))
#define PAMAC_PACKAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_PACKAGE, PamacPackageClass))

typedef struct _PamacPackage PamacPackage;
typedef struct _PamacPackageClass PamacPackageClass;

#define PAMAC_TYPE_SNAP_PACKAGE (pamac_snap_package_get_type ())
#define PAMAC_SNAP_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_SNAP_PACKAGE, PamacSnapPackage))
#define PAMAC_SNAP_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_SNAP_PACKAGE, PamacSnapPackageClass))
#define PAMAC_IS_SNAP_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_SNAP_PACKAGE))
#define PAMAC_IS_SNAP_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_SNAP_PACKAGE))
#define PAMAC_SNAP_PACKAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_SNAP_PACKAGE, PamacSnapPackageClass))

typedef struct _PamacSnapPackage PamacSnapPackage;
typedef struct _PamacSnapPackageClass PamacSnapPackageClass;

#define PAMAC_TYPE_FLATPAK_PLUGIN (pamac_flatpak_plugin_get_type ())
#define PAMAC_FLATPAK_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_FLATPAK_PLUGIN, PamacFlatpakPlugin))
#define PAMAC_IS_FLATPAK_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_FLATPAK_PLUGIN))
#define PAMAC_FLATPAK_PLUGIN_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PAMAC_TYPE_FLATPAK_PLUGIN, PamacFlatpakPluginIface))

typedef struct _PamacFlatpakPlugin PamacFlatpakPlugin;
typedef struct _PamacFlatpakPluginIface PamacFlatpakPluginIface;

#define PAMAC_TYPE_FLATPAK_PACKAGE (pamac_flatpak_package_get_type ())
#define PAMAC_FLATPAK_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_FLATPAK_PACKAGE, PamacFlatpakPackage))
#define PAMAC_FLATPAK_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_FLATPAK_PACKAGE, PamacFlatpakPackageClass))
#define PAMAC_IS_FLATPAK_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_FLATPAK_PACKAGE))
#define PAMAC_IS_FLATPAK_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_FLATPAK_PACKAGE))
#define PAMAC_FLATPAK_PACKAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_FLATPAK_PACKAGE, PamacFlatpakPackageClass))

typedef struct _PamacFlatpakPackage PamacFlatpakPackage;
typedef struct _PamacFlatpakPackageClass PamacFlatpakPackageClass;
enum  {
	PAMAC_DAEMON_0_PROPERTY,
	PAMAC_DAEMON_NUM_PROPERTIES
};
static GParamSpec* pamac_daemon_properties[PAMAC_DAEMON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _PamacAlpmUtilsPrivate PamacAlpmUtilsPrivate;

#define TYPE_ALPM_CONFIG (alpm_config_get_type ())
#define ALPM_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALPM_CONFIG, AlpmConfig))
#define ALPM_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALPM_CONFIG, AlpmConfigClass))
#define IS_ALPM_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALPM_CONFIG))
#define IS_ALPM_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALPM_CONFIG))
#define ALPM_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALPM_CONFIG, AlpmConfigClass))

typedef struct _AlpmConfig AlpmConfig;
typedef struct _AlpmConfigClass AlpmConfigClass;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _PamacDaemonCheckAuthorizationData PamacDaemonCheckAuthorizationData;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;
typedef struct _Block15Data Block15Data;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block16Data Block16Data;
typedef struct _Block17Data Block17Data;
typedef struct _Block18Data Block18Data;
typedef struct _Block19Data Block19Data;
typedef struct _Block20Data Block20Data;
typedef struct _Block21Data Block21Data;
typedef struct _Block22Data Block22Data;
typedef struct _Block23Data Block23Data;
typedef struct _Block24Data Block24Data;
typedef struct _Block25Data Block25Data;
typedef struct _Block26Data Block26Data;
typedef struct _Block27Data Block27Data;
typedef struct _Block28Data Block28Data;
typedef struct _Block29Data Block29Data;
typedef struct _Block30Data Block30Data;
enum  {
	PAMAC_DAEMON_EMIT_ACTION_SIGNAL,
	PAMAC_DAEMON_EMIT_ACTION_PROGRESS_SIGNAL,
	PAMAC_DAEMON_EMIT_DOWNLOAD_PROGRESS_SIGNAL,
	PAMAC_DAEMON_EMIT_HOOK_PROGRESS_SIGNAL,
	PAMAC_DAEMON_EMIT_SCRIPT_OUTPUT_SIGNAL,
	PAMAC_DAEMON_EMIT_WARNING_SIGNAL,
	PAMAC_DAEMON_EMIT_ERROR_SIGNAL,
	PAMAC_DAEMON_IMPORTANT_DETAILS_OUTPOUT_SIGNAL,
	PAMAC_DAEMON_START_DOWNLOADING_SIGNAL,
	PAMAC_DAEMON_STOP_DOWNLOADING_SIGNAL,
	PAMAC_DAEMON_SET_PKGREASON_FINISHED_SIGNAL,
	PAMAC_DAEMON_START_WAITING_SIGNAL,
	PAMAC_DAEMON_STOP_WAITING_SIGNAL,
	PAMAC_DAEMON_TRANS_REFRESH_FINISHED_SIGNAL,
	PAMAC_DAEMON_TRANS_REFRESH_FILES_FINISHED_SIGNAL,
	PAMAC_DAEMON_TRANS_REFRESH_AUR_FINISHED_SIGNAL,
	PAMAC_DAEMON_TRANS_RUN_FINISHED_SIGNAL,
	PAMAC_DAEMON_DOWNLOAD_UPDATES_FINISHED_SIGNAL,
	PAMAC_DAEMON_DOWNLOAD_PKGS_FINISHED_SIGNAL,
	PAMAC_DAEMON_GET_AUTHORIZATION_FINISHED_SIGNAL,
	PAMAC_DAEMON_WRITE_ALPM_CONFIG_FINISHED_SIGNAL,
	PAMAC_DAEMON_WRITE_PAMAC_CONFIG_FINISHED_SIGNAL,
	PAMAC_DAEMON_GENERATE_MIRRORS_LIST_DATA_SIGNAL,
	PAMAC_DAEMON_GENERATE_MIRRORS_LIST_FINISHED_SIGNAL,
	PAMAC_DAEMON_CLEAN_CACHE_FINISHED_SIGNAL,
	PAMAC_DAEMON_CLEAN_BUILD_FILES_FINISHED_SIGNAL,
	PAMAC_DAEMON_SNAP_TRANS_RUN_FINISHED_SIGNAL,
	PAMAC_DAEMON_SNAP_SWITCH_CHANNEL_FINISHED_SIGNAL,
	PAMAC_DAEMON_FLATPAK_TRANS_RUN_FINISHED_SIGNAL,
	PAMAC_DAEMON_NUM_SIGNALS
};
static guint pamac_daemon_signals[PAMAC_DAEMON_NUM_SIGNALS] = {0};

struct _PamacDaemon {
	GObject parent_instance;
	PamacDaemonPrivate * priv;
};

struct _PamacDaemonClass {
	GObjectClass parent_class;
};

struct _PamacSnapPluginIface {
	GTypeInterface parent_iface;
	void (*search_snaps) (PamacSnapPlugin* self, const gchar* search_string, GPtrArray** pkgs);
	void (*search_uninstalled_snaps_sync) (PamacSnapPlugin* self, const gchar* search_string, GPtrArray** pkgs);
	gboolean (*is_installed_snap) (PamacSnapPlugin* self, const gchar* name);
	PamacSnapPackage* (*get_snap) (PamacSnapPlugin* self, const gchar* name);
	PamacSnapPackage* (*get_snap_by_app_id) (PamacSnapPlugin* self, const gchar* app_id);
	void (*get_installed_snaps) (PamacSnapPlugin* self, GPtrArray** pkgs);
	gchar* (*get_installed_snap_icon) (PamacSnapPlugin* self, const gchar* name, GError** error);
	void (*get_category_snaps) (PamacSnapPlugin* self, const gchar* category, GPtrArray** pkgs);
	gboolean (*trans_run) (PamacSnapPlugin* self, const gchar* sender, gchar** to_install, gint to_install_length1, gchar** to_remove, gint to_remove_length1);
	gboolean (*switch_channel) (PamacSnapPlugin* self, const gchar* sender, const gchar* name, const gchar* channel);
	void (*trans_cancel) (PamacSnapPlugin* self, const gchar* sender);
	void (*refresh) (PamacSnapPlugin* self);
};

struct _PamacFlatpakPluginIface {
	GTypeInterface parent_iface;
	gboolean (*refresh_appstream_data) (PamacFlatpakPlugin* self);
	void (*load_appstream_data) (PamacFlatpakPlugin* self);
	void (*get_remotes_names) (PamacFlatpakPlugin* self, GPtrArray** remotes_names);
	void (*search_flatpaks) (PamacFlatpakPlugin* self, const gchar* search_string, GPtrArray** pkgs);
	void (*search_uninstalled_flatpaks_sync) (PamacFlatpakPlugin* self, gchar** search_terms, gint search_terms_length1, GPtrArray** pkgs);
	gboolean (*is_installed_flatpak) (PamacFlatpakPlugin* self, const gchar* name);
	PamacFlatpakPackage* (*get_flatpak_by_app_id) (PamacFlatpakPlugin* self, const gchar* app_id);
	PamacFlatpakPackage* (*get_flatpak) (PamacFlatpakPlugin* self, const gchar* id);
	void (*get_installed_flatpaks) (PamacFlatpakPlugin* self, GPtrArray** pkgs);
	void (*get_category_flatpaks) (PamacFlatpakPlugin* self, const gchar* category, GPtrArray** pkgs);
	void (*get_flatpak_updates) (PamacFlatpakPlugin* self, GPtrArray** pkgs);
	gboolean (*trans_run) (PamacFlatpakPlugin* self, const gchar* sender, gchar** to_install, gint to_install_length1, gchar** to_remove, gint to_remove_length1, gchar** to_upgrade, gint to_upgrade_length1);
	void (*trans_cancel) (PamacFlatpakPlugin* self, const gchar* sender);
	void (*refresh) (PamacFlatpakPlugin* self);
	guint64 (*get_refresh_period) (PamacFlatpakPlugin* self);
	void (*set_refresh_period) (PamacFlatpakPlugin* self, guint64 value);
};

struct _PamacDaemonPrivate {
	PamacConfig* config;
	PamacAlpmUtils* alpm_utils;
	gint running_threads;
	GFileMonitor* lockfile_monitor;
	GCond lockfile_cond;
	GMutex lockfile_mutex;
	GCond answer_cond;
	GMutex answer_mutex;
	GMutex authorization_mutex;
	GHashTable* authorized_senders;
	GHashTable* cancellables_table;
	PamacSnapPlugin* snap_plugin;
	PamacFlatpakPlugin* flatpak_plugin;
};

struct _PamacAlpmUtils {
	GObject parent_instance;
	PamacAlpmUtilsPrivate * priv;
	AlpmConfig* alpm_config;
	GFile* lockfile;
	alpm_handle_t* alpm_handle;
	GCancellable* cancellable;
	gboolean downloading_updates;
	gchar* current_filename;
	gchar* current_action;
	gdouble current_progress;
	GPtrArray* unresolvables;
	guint64 total_download;
	guint64 already_downloaded;
	GHashTable* multi_progress;
	GTimer* rate_timer;
};

struct _PamacAlpmUtilsClass {
	GObjectClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	PamacDaemon* self;
	GMainLoop* tmp_loop;
};

struct _PamacDaemonCheckAuthorizationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PamacDaemon* self;
	char* sender;
	gboolean result;
	gboolean authorized;
	PolkitAuthority* authority;
	PolkitAuthority* _tmp0_;
	PolkitSubject* subject;
	PolkitSystemBusName* _tmp1_;
	PolkitAuthorizationResult* _result_;
	PolkitAuthority* _tmp2_;
	PolkitSubject* _tmp3_;
	PolkitAuthorizationResult* _tmp4_;
	PolkitAuthorizationResult* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError* e;
	GError* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	GError* _inner_error0_;
};

struct _Block3Data {
	int _ref_count_;
	PamacDaemon* self;
	char* sender;
};

struct _Block4Data {
	int _ref_count_;
	PamacDaemon* self;
	GHashTable* new_alpm_conf;
	char* sender;
};

struct _Block5Data {
	int _ref_count_;
	PamacDaemon* self;
	GHashTable* new_pamac_conf;
	char* sender;
};

struct _Block6Data {
	int _ref_count_;
	PamacDaemon* self;
	gchar* country;
	char* sender;
};

struct _Block7Data {
	int _ref_count_;
	PamacDaemon* self;
	gchar** names;
	gint names_length1;
	gint _names_size_;
	char* sender;
};

struct _Block8Data {
	int _ref_count_;
	PamacDaemon* self;
	gchar* aur_build_dir;
	char* sender;
};

struct _Block9Data {
	int _ref_count_;
	PamacDaemon* self;
	gchar* pkgname;
	guint reason;
	char* sender;
};

struct _Block10Data {
	int _ref_count_;
	PamacDaemon* self;
	char* sender;
};

struct _Block11Data {
	int _ref_count_;
	Block10Data * _data10_;
	GCancellable* cancellable;
};

struct _Block12Data {
	int _ref_count_;
	Block11Data * _data11_;
	gboolean success;
};

struct _Block13Data {
	int _ref_count_;
	PamacDaemon* self;
	gchar** urls_copy;
	gint urls_copy_length1;
	gint _urls_copy_size_;
	char* sender;
};

struct _Block14Data {
	int _ref_count_;
	Block13Data * _data13_;
	GCancellable* cancellable;
};

struct _Block15Data {
	int _ref_count_;
	Block14Data * _data14_;
	GPtrArray* dload_paths;
	gboolean success;
};

struct _Block16Data {
	int _ref_count_;
	PamacDaemon* self;
	gboolean force;
	char* sender;
};

struct _Block17Data {
	int _ref_count_;
	Block16Data * _data16_;
	GCancellable* cancellable;
};

struct _Block18Data {
	int _ref_count_;
	Block17Data * _data17_;
	gboolean success;
};

struct _Block19Data {
	int _ref_count_;
	PamacDaemon* self;
	gboolean force;
	char* sender;
};

struct _Block20Data {
	int _ref_count_;
	Block19Data * _data19_;
	GCancellable* cancellable;
};

struct _Block21Data {
	int _ref_count_;
	Block20Data * _data20_;
	gboolean success;
};

struct _Block22Data {
	int _ref_count_;
	PamacDaemon* self;
	gboolean force;
	char* sender;
};

struct _Block23Data {
	int _ref_count_;
	Block22Data * _data22_;
	GCancellable* cancellable;
};

struct _Block24Data {
	int _ref_count_;
	Block23Data * _data23_;
	gboolean success;
};

struct _Block25Data {
	int _ref_count_;
	PamacDaemon* self;
	gchar** to_install_copy;
	gint to_install_copy_length1;
	gint _to_install_copy_size_;
	gchar** to_remove_copy;
	gint to_remove_copy_length1;
	gint _to_remove_copy_size_;
	gchar** to_load_local_copy;
	gint to_load_local_copy_length1;
	gint _to_load_local_copy_size_;
	gchar** to_load_remote_copy;
	gint to_load_remote_copy_length1;
	gint _to_load_remote_copy_size_;
	gchar** to_install_as_dep_copy;
	gint to_install_as_dep_copy_length1;
	gint _to_install_as_dep_copy_size_;
	gchar** ignorepkgs_copy;
	gint ignorepkgs_copy_length1;
	gint _ignorepkgs_copy_size_;
	gchar** overwrite_files_copy;
	gint overwrite_files_copy_length1;
	gint _overwrite_files_copy_size_;
	gboolean sysupgrade;
	gboolean enable_downgrade;
	gboolean simple_install;
	gboolean keep_built_pkgs;
	gint trans_flags;
	char* sender;
};

struct _Block26Data {
	int _ref_count_;
	Block25Data * _data25_;
	GCancellable* cancellable;
};

struct _Block27Data {
	int _ref_count_;
	Block26Data * _data26_;
	gboolean success;
};

struct _Block28Data {
	int _ref_count_;
	PamacDaemon* self;
	gchar** to_install_copy;
	gint to_install_copy_length1;
	gint _to_install_copy_size_;
	gchar** to_remove_copy;
	gint to_remove_copy_length1;
	gint _to_remove_copy_size_;
	char* sender;
};

struct _Block29Data {
	int _ref_count_;
	PamacDaemon* self;
	gchar* snap_name;
	gchar* snap_channel;
	char* sender;
};

struct _Block30Data {
	int _ref_count_;
	PamacDaemon* self;
	gchar** to_install_copy;
	gint to_install_copy_length1;
	gint _to_install_copy_size_;
	gchar** to_remove_copy;
	gint to_remove_copy_length1;
	gint _to_remove_copy_size_;
	gchar** to_upgrade_copy;
	gint to_upgrade_copy_length1;
	gint _to_upgrade_copy_size_;
	char* sender;
};

VALA_EXTERN PamacDaemon* system_daemon;
PamacDaemon* system_daemon = NULL;
VALA_EXTERN GMainLoop* loop;
GMainLoop* loop = NULL;
static gint PamacDaemon_private_offset;
static gpointer pamac_daemon_parent_class = NULL;

VALA_EXTERN GType pamac_daemon_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacDaemon, g_object_unref)
VALA_EXTERN guint pamac_daemon_register_object (void* object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error);
VALA_EXTERN GType pamac_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacConfig, g_object_unref)
VALA_EXTERN GType pamac_alpm_utils_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacAlpmUtils, g_object_unref)
VALA_EXTERN GType pamac_package_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacPackage, g_object_unref)
VALA_EXTERN GType pamac_snap_package_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacSnapPackage, g_object_unref)
VALA_EXTERN GType pamac_snap_plugin_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacSnapPlugin, g_object_unref)
VALA_EXTERN GType pamac_flatpak_package_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacFlatpakPackage, g_object_unref)
VALA_EXTERN GType pamac_flatpak_plugin_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacFlatpakPlugin, g_object_unref)
VALA_EXTERN PamacDaemon* pamac_daemon_new (void);
VALA_EXTERN PamacDaemon* pamac_daemon_construct (GType object_type);
VALA_EXTERN PamacConfig* pamac_config_new (const gchar* conf_path);
VALA_EXTERN PamacConfig* pamac_config_construct (GType object_type,
                                     const gchar* conf_path);
VALA_EXTERN gchar* get_user_agent (void);
VALA_EXTERN PamacAlpmUtils* pamac_alpm_utils_new (PamacConfig* config);
VALA_EXTERN PamacAlpmUtils* pamac_alpm_utils_construct (GType object_type,
                                            PamacConfig* config);
VALA_EXTERN gpointer alpm_config_ref (gpointer instance);
VALA_EXTERN void alpm_config_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alpm_config (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_alpm_config (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_alpm_config (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_alpm_config (const GValue* value);
VALA_EXTERN GType alpm_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AlpmConfig, alpm_config_unref)
static gint pamac_daemon_set_extern_lock (PamacDaemon* self);
static gpointer _pamac_daemon_set_extern_lock_gthread_func (gpointer self);
static void pamac_daemon_check_extern_lock (PamacDaemon* self,
                                     GFile* src,
                                     GFile* dest,
                                     GFileMonitorEvent event_type);
static void _pamac_daemon_check_extern_lock_g_file_monitor_changed (GFileMonitor* _sender,
                                                             GFile* file,
                                                             GFile* other_file,
                                                             GFileMonitorEvent event_type,
                                                             gpointer self);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void __lambda46_ (PamacDaemon* self,
                  const gchar* sender,
                  const gchar* action);
static void ___lambda46__pamac_alpm_utils_emit_action (PamacAlpmUtils* _sender,
                                                const gchar* sender,
                                                const gchar* action,
                                                gpointer self);
static void __lambda47_ (PamacDaemon* self,
                  const gchar* sender,
                  const gchar* action,
                  const gchar* status,
                  gdouble progress);
static void ___lambda47__pamac_alpm_utils_emit_action_progress (PamacAlpmUtils* _sender,
                                                         const gchar* sender,
                                                         const gchar* action,
                                                         const gchar* status,
                                                         gdouble progress,
                                                         gpointer self);
static void __lambda48_ (PamacDaemon* self,
                  const gchar* sender,
                  const gchar* action,
                  const gchar* details,
                  const gchar* status,
                  gdouble progress);
static void ___lambda48__pamac_alpm_utils_emit_hook_progress (PamacAlpmUtils* _sender,
                                                       const gchar* sender,
                                                       const gchar* action,
                                                       const gchar* details,
                                                       const gchar* status,
                                                       gdouble progress,
                                                       gpointer self);
static void __lambda49_ (PamacDaemon* self,
                  const gchar* sender,
                  const gchar* action,
                  const gchar* status,
                  gdouble progress);
static void ___lambda49__pamac_alpm_utils_emit_download_progress (PamacAlpmUtils* _sender,
                                                           const gchar* sender,
                                                           const gchar* action,
                                                           const gchar* status,
                                                           gdouble progress,
                                                           gpointer self);
static void __lambda50_ (PamacDaemon* self,
                  const gchar* sender);
static void ___lambda50__pamac_alpm_utils_start_downloading (PamacAlpmUtils* _sender,
                                                      const gchar* sender,
                                                      gpointer self);
static void __lambda51_ (PamacDaemon* self,
                  const gchar* sender);
static void ___lambda51__pamac_alpm_utils_stop_downloading (PamacAlpmUtils* _sender,
                                                     const gchar* sender,
                                                     gpointer self);
static void __lambda52_ (PamacDaemon* self,
                  const gchar* sender,
                  const gchar* message);
static void ___lambda52__pamac_alpm_utils_emit_script_output (PamacAlpmUtils* _sender,
                                                       const gchar* sender,
                                                       const gchar* message,
                                                       gpointer self);
static void __lambda53_ (PamacDaemon* self,
                  const gchar* sender,
                  const gchar* message);
static void ___lambda53__pamac_alpm_utils_emit_warning (PamacAlpmUtils* _sender,
                                                 const gchar* sender,
                                                 const gchar* message,
                                                 gpointer self);
static void __lambda54_ (PamacDaemon* self,
                  const gchar* sender,
                  const gchar* message,
                  GPtrArray* details);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void ___lambda54__pamac_alpm_utils_emit_error (PamacAlpmUtils* _sender,
                                               const gchar* sender,
                                               const gchar* message,
                                               GPtrArray* details,
                                               gpointer self);
static void __lambda55_ (PamacDaemon* self,
                  const gchar* sender,
                  gboolean must_show);
static void ___lambda55__pamac_alpm_utils_important_details_outpout (PamacAlpmUtils* _sender,
                                                              const gchar* sender,
                                                              gboolean must_show,
                                                              gpointer self);
VALA_EXTERN gboolean pamac_config_get_support_snap (PamacConfig* self);
VALA_EXTERN PamacSnapPlugin* pamac_config_get_snap_plugin (PamacConfig* self);
static void ___lambda56_ (PamacDaemon* self,
                   const gchar* sender,
                   const gchar* action,
                   const gchar* status,
                   gdouble progress);
static void ____lambda56__pamac_snap_plugin_emit_action_progress (PamacSnapPlugin* _sender,
                                                           const gchar* sender,
                                                           const gchar* action,
                                                           const gchar* status,
                                                           gdouble progress,
                                                           gpointer self);
static void ___lambda57_ (PamacDaemon* self,
                   const gchar* sender,
                   const gchar* action,
                   const gchar* status,
                   gdouble progress);
static void ____lambda57__pamac_snap_plugin_emit_download_progress (PamacSnapPlugin* _sender,
                                                             const gchar* sender,
                                                             const gchar* action,
                                                             const gchar* status,
                                                             gdouble progress,
                                                             gpointer self);
static void ___lambda58_ (PamacDaemon* self,
                   const gchar* sender,
                   const gchar* message);
static void ____lambda58__pamac_snap_plugin_emit_script_output (PamacSnapPlugin* _sender,
                                                         const gchar* sender,
                                                         const gchar* message,
                                                         gpointer self);
static void ___lambda59_ (PamacDaemon* self,
                   const gchar* sender,
                   const gchar* message,
                   gchar** details,
                   gint details_length1);
static void ____lambda59__pamac_snap_plugin_emit_error (PamacSnapPlugin* _sender,
                                                 const gchar* sender,
                                                 const gchar* message,
                                                 gchar** details,
                                                 gint details_length1,
                                                 gpointer self);
static void ___lambda60_ (PamacDaemon* self,
                   const gchar* sender);
static void ____lambda60__pamac_snap_plugin_start_downloading (PamacSnapPlugin* _sender,
                                                        const gchar* sender,
                                                        gpointer self);
static void ___lambda61_ (PamacDaemon* self,
                   const gchar* sender);
static void ____lambda61__pamac_snap_plugin_stop_downloading (PamacSnapPlugin* _sender,
                                                       const gchar* sender,
                                                       gpointer self);
VALA_EXTERN gboolean pamac_config_get_support_flatpak (PamacConfig* self);
VALA_EXTERN PamacFlatpakPlugin* pamac_config_get_flatpak_plugin (PamacConfig* self);
static void ___lambda62_ (PamacDaemon* self,
                   const gchar* sender,
                   const gchar* action,
                   const gchar* status,
                   gdouble progress);
static void ____lambda62__pamac_flatpak_plugin_emit_action_progress (PamacFlatpakPlugin* _sender,
                                                              const gchar* sender,
                                                              const gchar* action,
                                                              const gchar* status,
                                                              gdouble progress,
                                                              gpointer self);
static void ___lambda63_ (PamacDaemon* self,
                   const gchar* sender,
                   const gchar* message);
static void ____lambda63__pamac_flatpak_plugin_emit_script_output (PamacFlatpakPlugin* _sender,
                                                            const gchar* sender,
                                                            const gchar* message,
                                                            gpointer self);
static void ___lambda64_ (PamacDaemon* self,
                   const gchar* sender,
                   const gchar* message,
                   gchar** details,
                   gint details_length1);
static void ____lambda64__pamac_flatpak_plugin_emit_error (PamacFlatpakPlugin* _sender,
                                                    const gchar* sender,
                                                    const gchar* message,
                                                    gchar** details,
                                                    gint details_length1,
                                                    gpointer self);
VALA_EXTERN void pamac_daemon_set_environment_variables (PamacDaemon* self,
                                             GHashTable* variables,
                                             GError** error);
VALA_EXTERN gchar* pamac_daemon_get_sender (PamacDaemon* self,
                                const char* sender,
                                GError** error);
VALA_EXTERN gchar* pamac_daemon_get_lockfile (PamacDaemon* self,
                                  GError** error);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ____lambda45_ (Block2Data* _data2_,
                    GFile* src,
                    GFile* dest,
                    GFileMonitorEvent event_type);
static void _____lambda45__g_file_monitor_changed (GFileMonitor* _sender,
                                            GFile* file,
                                            GFile* other_file,
                                            GFileMonitorEvent event_type,
                                            gpointer self);
static void pamac_daemon_check_authorization_data_free (gpointer _data);
static void pamac_daemon_check_authorization (PamacDaemon* self,
                                       const char* sender,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static gboolean pamac_daemon_check_authorization_finish (PamacDaemon* self,
                                                  GAsyncResult* _res_);
static gboolean pamac_daemon_check_authorization_co (PamacDaemonCheckAuthorizationData* _data_);
static void pamac_daemon_check_authorization_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
VALA_EXTERN void pamac_daemon_start_get_authorization (PamacDaemon* self,
                                           const char* sender,
                                           GError** error);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean ___lambda65_ (Block3Data* _data3_);
static gboolean ____lambda65__gsource_func (gpointer self);
static void __lambda66_ (Block3Data* _data3_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda66__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void pamac_daemon_remove_authorization (PamacDaemon* self,
                                        const char* sender,
                                        GError** error);
VALA_EXTERN void pamac_daemon_start_write_alpm_config (PamacDaemon* self,
                                           GHashTable* new_alpm_conf,
                                           const char* sender,
                                           GError** error);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda67_ (Block4Data* _data4_,
                  GObject* obj,
                  GAsyncResult* res);
static gint ____lambda68_ (Block4Data* _data4_);
VALA_EXTERN void alpm_config_write (AlpmConfig* self,
                        GHashTable* new_conf);
VALA_EXTERN void alpm_config_reload (AlpmConfig* self);
static gpointer _____lambda68__gthread_func (gpointer self);
static void ___lambda67__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void pamac_daemon_start_write_pamac_config (PamacDaemon* self,
                                            GHashTable* new_pamac_conf,
                                            const char* sender,
                                            GError** error);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda69_ (Block5Data* _data5_,
                  GObject* obj,
                  GAsyncResult* res);
VALA_EXTERN void pamac_config_write (PamacConfig* self,
                         GHashTable* new_conf);
VALA_EXTERN void pamac_config_reload (PamacConfig* self);
VALA_EXTERN gboolean pamac_config_get_enable_snap (PamacConfig* self);
VALA_EXTERN gboolean pamac_config_get_offline_upgrade (PamacConfig* self);
static void ___lambda69__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void pamac_daemon_start_generate_mirrors_list (PamacDaemon* self,
                                               const gchar* country,
                                               const char* sender,
                                               GError** error);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda70_ (Block6Data* _data6_,
                  GObject* obj,
                  GAsyncResult* res);
static gint ____lambda71_ (Block6Data* _data6_);
static gpointer _____lambda71__gthread_func (gpointer self);
static void ___lambda70__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void pamac_daemon_start_clean_cache (PamacDaemon* self,
                                     gchar** filenames,
                                     gint filenames_length1,
                                     const char* sender,
                                     GError** error);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static void __lambda72_ (Block7Data* _data7_,
                  GObject* obj,
                  GAsyncResult* res);
VALA_EXTERN gboolean pamac_alpm_utils_clean_cache (PamacAlpmUtils* self,
                                       gchar** filenames,
                                       gint filenames_length1);
static void ___lambda72__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void pamac_daemon_start_clean_build_files (PamacDaemon* self,
                                           const gchar* aur_build_dir,
                                           const char* sender,
                                           GError** error);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda73_ (Block8Data* _data8_,
                  GObject* obj,
                  GAsyncResult* res);
VALA_EXTERN gboolean pamac_alpm_utils_clean_build_files (PamacAlpmUtils* self,
                                             const gchar* aur_build_dir);
static void ___lambda73__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void pamac_daemon_start_set_pkgreason (PamacDaemon* self,
                                       const gchar* pkgname,
                                       guint reason,
                                       const char* sender,
                                       GError** error);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda74_ (Block9Data* _data9_,
                  GObject* obj,
                  GAsyncResult* res);
static gint ____lambda75_ (Block9Data* _data9_);
VALA_EXTERN gboolean pamac_alpm_utils_set_pkgreason (PamacAlpmUtils* self,
                                         const gchar* sender,
                                         const gchar* pkgname,
                                         guint reason);
static gpointer _____lambda75__gthread_func (gpointer self);
static void ___lambda74__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void pamac_daemon_start_download_updates (PamacDaemon* self,
                                          const char* sender,
                                          GError** error);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static gint ___lambda76_ (Block11Data* _data11_);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static gboolean pamac_daemon_wait_for_lock (PamacDaemon* self,
                                     const gchar* sender,
                                     GCancellable* cancellable,
                                     gboolean quiet);
static gint ____lambda77_ (Block12Data* _data12_);
VALA_EXTERN gboolean pamac_alpm_utils_download_updates (PamacAlpmUtils* self,
                                            const gchar* sender);
static gpointer _____lambda77__gthread_func (gpointer self);
static gpointer ____lambda76__gthread_func (gpointer self);
VALA_EXTERN void pamac_daemon_start_download_pkgs (PamacDaemon* self,
                                       gchar** urls,
                                       gint urls_length1,
                                       const char* sender,
                                       GError** error);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static void __lambda78_ (Block13Data* _data13_,
                  GObject* obj,
                  GAsyncResult* res);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static gint ____lambda79_ (Block14Data* _data14_);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static gint ____lambda80_ (Block15Data* _data15_);
VALA_EXTERN gboolean pamac_alpm_utils_download_pkgs (PamacAlpmUtils* self,
                                         const gchar* sender,
                                         gchar** urls,
                                         gint urls_length1,
                                         GPtrArray** dload_paths);
static gpointer _____lambda80__gthread_func (gpointer self);
static gpointer _____lambda79__gthread_func (gpointer self);
static void ___lambda78__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void pamac_daemon_start_trans_refresh (PamacDaemon* self,
                                       gboolean force,
                                       const char* sender,
                                       GError** error);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static gint ___lambda81_ (Block17Data* _data17_);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static gint ____lambda82_ (Block18Data* _data18_);
VALA_EXTERN gboolean pamac_alpm_utils_trans_refresh (PamacAlpmUtils* self,
                                         const gchar* sender,
                                         gboolean force_refresh);
static gpointer _____lambda82__gthread_func (gpointer self);
static gpointer ____lambda81__gthread_func (gpointer self);
VALA_EXTERN void pamac_daemon_start_trans_refresh_files (PamacDaemon* self,
                                             gboolean force,
                                             const char* sender,
                                             GError** error);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static gint ___lambda83_ (Block20Data* _data20_);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static gint ____lambda84_ (Block21Data* _data21_);
VALA_EXTERN gboolean pamac_alpm_utils_trans_refresh_files (PamacAlpmUtils* self,
                                               const gchar* sender,
                                               gboolean force_refresh);
static gpointer _____lambda84__gthread_func (gpointer self);
static gpointer ____lambda83__gthread_func (gpointer self);
VALA_EXTERN void pamac_daemon_start_trans_refresh_aur (PamacDaemon* self,
                                           gboolean force,
                                           const char* sender,
                                           GError** error);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static gint ___lambda85_ (Block23Data* _data23_);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static gint ____lambda86_ (Block24Data* _data24_);
VALA_EXTERN gboolean pamac_alpm_utils_trans_refresh_aur (PamacAlpmUtils* self,
                                             const gchar* sender,
                                             gboolean force_refresh);
static gpointer _____lambda86__gthread_func (gpointer self);
static gpointer ____lambda85__gthread_func (gpointer self);
VALA_EXTERN void pamac_daemon_start_trans_run (PamacDaemon* self,
                                   gboolean sysupgrade,
                                   gboolean enable_downgrade,
                                   gboolean simple_install,
                                   gboolean keep_built_pkgs,
                                   gint trans_flags,
                                   gchar** to_install,
                                   gint to_install_length1,
                                   gchar** to_remove,
                                   gint to_remove_length1,
                                   gchar** to_load_local,
                                   gint to_load_local_length1,
                                   gchar** to_load_remote,
                                   gint to_load_remote_length1,
                                   gchar** to_install_as_dep,
                                   gint to_install_as_dep_length1,
                                   gchar** ignorepkgs,
                                   gint ignorepkgs_length1,
                                   gchar** overwrite_files,
                                   gint overwrite_files_length1,
                                   const char* sender,
                                   GError** error);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static gchar** _vala_array_dup4 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup5 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup6 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup7 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup8 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup9 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup10 (gchar** self,
                           gssize length);
static void __lambda87_ (Block25Data* _data25_,
                  GObject* obj,
                  GAsyncResult* res);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
static gint ____lambda88_ (Block26Data* _data26_);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
static gint ____lambda89_ (Block27Data* _data27_);
VALA_EXTERN gboolean pamac_alpm_utils_trans_run (PamacAlpmUtils* self,
                                     const gchar* sender,
                                     gboolean sysupgrade,
                                     gboolean enable_downgrade,
                                     gboolean simple_install,
                                     gboolean keep_built_pkgs,
                                     gint trans_flags,
                                     gchar** to_install,
                                     gint to_install_length1,
                                     gchar** to_remove,
                                     gint to_remove_length1,
                                     gchar** to_load_local,
                                     gint to_load_local_length1,
                                     gchar** to_load_remote,
                                     gint to_load_remote_length1,
                                     gchar** to_install_as_dep,
                                     gint to_install_as_dep_length1,
                                     gchar** ignorepkgs,
                                     gint ignorepkgs_length1,
                                     gchar** overwrite_files,
                                     gint overwrite_files_length1);
static gpointer _____lambda89__gthread_func (gpointer self);
static gpointer _____lambda88__gthread_func (gpointer self);
static void ___lambda87__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void pamac_daemon_start_snap_trans_run (PamacDaemon* self,
                                        gchar** to_install,
                                        gint to_install_length1,
                                        gchar** to_remove,
                                        gint to_remove_length1,
                                        const char* sender,
                                        GError** error);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
static gboolean ___lambda90_ (Block28Data* _data28_);
static gboolean ____lambda90__gsource_func (gpointer self);
static gchar** _vala_array_dup11 (gchar** self,
                           gssize length);
static gchar** _vala_array_dup12 (gchar** self,
                           gssize length);
static void __lambda91_ (Block28Data* _data28_,
                  GObject* obj,
                  GAsyncResult* res);
static gint ____lambda92_ (Block28Data* _data28_);
VALA_EXTERN gboolean pamac_snap_plugin_trans_run (PamacSnapPlugin* self,
                                      const gchar* sender,
                                      gchar** to_install,
                                      gint to_install_length1,
                                      gchar** to_remove,
                                      gint to_remove_length1);
static gpointer _____lambda92__gthread_func (gpointer self);
static void ___lambda91__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void pamac_daemon_start_snap_switch_channel (PamacDaemon* self,
                                             const gchar* snap_name,
                                             const gchar* snap_channel,
                                             const char* sender,
                                             GError** error);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
static gboolean ___lambda93_ (Block29Data* _data29_);
static gboolean ____lambda93__gsource_func (gpointer self);
static gint ___lambda94_ (Block29Data* _data29_);
VALA_EXTERN gboolean pamac_snap_plugin_switch_channel (PamacSnapPlugin* self,
                                           const gchar* sender,
                                           const gchar* name,
                                           const gchar* channel);
static gpointer ____lambda94__gthread_func (gpointer self);
VALA_EXTERN void pamac_daemon_start_flatpak_trans_run (PamacDaemon* self,
                                           gchar** to_install,
                                           gint to_install_length1,
                                           gchar** to_remove,
                                           gint to_remove_length1,
                                           gchar** to_upgrade,
                                           gint to_upgrade_length1,
                                           const char* sender,
                                           GError** error);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (void * _userdata_);
VALA_EXTERN gboolean pamac_config_get_enable_flatpak (PamacConfig* self);
static gboolean ___lambda95_ (Block30Data* _data30_);
static gboolean ____lambda95__gsource_func (gpointer self);
static gchar** _vala_array_dup13 (gchar** self,
                           gssize length);
static gchar** _vala_array_dup14 (gchar** self,
                           gssize length);
static gchar** _vala_array_dup15 (gchar** self,
                           gssize length);
static void __lambda96_ (Block30Data* _data30_,
                  GObject* obj,
                  GAsyncResult* res);
static gint ____lambda97_ (Block30Data* _data30_);
VALA_EXTERN gboolean pamac_flatpak_plugin_trans_run (PamacFlatpakPlugin* self,
                                         const gchar* sender,
                                         gchar** to_install,
                                         gint to_install_length1,
                                         gchar** to_remove,
                                         gint to_remove_length1,
                                         gchar** to_upgrade,
                                         gint to_upgrade_length1);
static gpointer _____lambda97__gthread_func (gpointer self);
static void ___lambda96__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void pamac_daemon_trans_cancel (PamacDaemon* self,
                                const char* sender,
                                GError** error);
VALA_EXTERN void pamac_snap_plugin_trans_cancel (PamacSnapPlugin* self,
                                     const gchar* sender);
VALA_EXTERN void pamac_flatpak_plugin_trans_cancel (PamacFlatpakPlugin* self,
                                        const gchar* sender);
VALA_EXTERN void pamac_alpm_utils_trans_cancel (PamacAlpmUtils* self,
                                    const gchar* sender);
VALA_EXTERN void pamac_daemon_quit (PamacDaemon* self,
                        GError** error);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING_DOUBLE (GClosure * closure,
                                                                GValue * return_value,
                                                                guint n_param_values,
                                                                const GValue * param_values,
                                                                gpointer invocation_hint,
                                                                gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING_STRING_DOUBLE (GClosure * closure,
                                                                       GValue * return_value,
                                                                       guint n_param_values,
                                                                       const GValue * param_values,
                                                                       gpointer invocation_hint,
                                                                       gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING_BOXED_INT (GClosure * closure,
                                                            GValue * return_value,
                                                            guint n_param_values,
                                                            const GValue * param_values,
                                                            gpointer invocation_hint,
                                                            gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_BOOLEAN (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_BOXED_INT (GClosure * closure,
                                                     GValue * return_value,
                                                     guint n_param_values,
                                                     const GValue * param_values,
                                                     gpointer invocation_hint,
                                                     gpointer marshal_data);
static void pamac_daemon_finalize (GObject * obj);
static GType pamac_daemon_get_type_once (void);
static void _dbus_pamac_daemon_set_environment_variables (PamacDaemon* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_get_sender (PamacDaemon* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_get_lockfile (PamacDaemon* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_get_authorization (PamacDaemon* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_remove_authorization (PamacDaemon* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_write_alpm_config (PamacDaemon* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_write_pamac_config (PamacDaemon* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_generate_mirrors_list (PamacDaemon* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_clean_cache (PamacDaemon* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_clean_build_files (PamacDaemon* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_set_pkgreason (PamacDaemon* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_download_updates (PamacDaemon* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_download_pkgs (PamacDaemon* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_trans_refresh (PamacDaemon* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_trans_refresh_files (PamacDaemon* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_trans_refresh_aur (PamacDaemon* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_trans_run (PamacDaemon* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_snap_trans_run (PamacDaemon* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_snap_switch_channel (PamacDaemon* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_flatpak_trans_run (PamacDaemon* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_trans_cancel (PamacDaemon* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_quit (PamacDaemon* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation);
static void pamac_daemon_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data);
static GVariant* pamac_daemon_dbus_interface_get_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GError** error,
                                                    gpointer user_data);
static gboolean pamac_daemon_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data);
static void _dbus_pamac_daemon_emit_action (GObject* _sender,
                                     const gchar* sender,
                                     const gchar* action,
                                     gpointer* _data);
static void _dbus_pamac_daemon_emit_action_progress (GObject* _sender,
                                              const gchar* sender,
                                              const gchar* action,
                                              const gchar* status,
                                              gdouble progress,
                                              gpointer* _data);
static void _dbus_pamac_daemon_emit_download_progress (GObject* _sender,
                                                const gchar* sender,
                                                const gchar* action,
                                                const gchar* status,
                                                gdouble progress,
                                                gpointer* _data);
static void _dbus_pamac_daemon_emit_hook_progress (GObject* _sender,
                                            const gchar* sender,
                                            const gchar* action,
                                            const gchar* details,
                                            const gchar* status,
                                            gdouble progress,
                                            gpointer* _data);
static void _dbus_pamac_daemon_emit_script_output (GObject* _sender,
                                            const gchar* sender,
                                            const gchar* message,
                                            gpointer* _data);
static void _dbus_pamac_daemon_emit_warning (GObject* _sender,
                                      const gchar* sender,
                                      const gchar* message,
                                      gpointer* _data);
static void _dbus_pamac_daemon_emit_error (GObject* _sender,
                                    const gchar* sender,
                                    const gchar* message,
                                    gchar** details,
                                    gint details_length1,
                                    gpointer* _data);
static void _dbus_pamac_daemon_important_details_outpout (GObject* _sender,
                                                   const gchar* sender,
                                                   gboolean must_show,
                                                   gpointer* _data);
static void _dbus_pamac_daemon_start_downloading (GObject* _sender,
                                           const gchar* sender,
                                           gpointer* _data);
static void _dbus_pamac_daemon_stop_downloading (GObject* _sender,
                                          const gchar* sender,
                                          gpointer* _data);
static void _dbus_pamac_daemon_set_pkgreason_finished (GObject* _sender,
                                                const gchar* sender,
                                                gboolean success,
                                                gpointer* _data);
static void _dbus_pamac_daemon_start_waiting (GObject* _sender,
                                       const gchar* sender,
                                       gpointer* _data);
static void _dbus_pamac_daemon_stop_waiting (GObject* _sender,
                                      const gchar* sender,
                                      gpointer* _data);
static void _dbus_pamac_daemon_trans_refresh_finished (GObject* _sender,
                                                const gchar* sender,
                                                gboolean success,
                                                gpointer* _data);
static void _dbus_pamac_daemon_trans_refresh_files_finished (GObject* _sender,
                                                      const gchar* sender,
                                                      gboolean success,
                                                      gpointer* _data);
static void _dbus_pamac_daemon_trans_refresh_aur_finished (GObject* _sender,
                                                    const gchar* sender,
                                                    gboolean success,
                                                    gpointer* _data);
static void _dbus_pamac_daemon_trans_run_finished (GObject* _sender,
                                            const gchar* sender,
                                            gboolean success,
                                            gpointer* _data);
static void _dbus_pamac_daemon_download_updates_finished (GObject* _sender,
                                                   const gchar* sender,
                                                   gboolean success,
                                                   gpointer* _data);
static void _dbus_pamac_daemon_download_pkgs_finished (GObject* _sender,
                                                const gchar* sender,
                                                gchar** dload_paths,
                                                gint dload_paths_length1,
                                                gpointer* _data);
static void _dbus_pamac_daemon_get_authorization_finished (GObject* _sender,
                                                    const gchar* sender,
                                                    gboolean authorized,
                                                    gpointer* _data);
static void _dbus_pamac_daemon_write_alpm_config_finished (GObject* _sender,
                                                    const gchar* sender,
                                                    gpointer* _data);
static void _dbus_pamac_daemon_write_pamac_config_finished (GObject* _sender,
                                                     const gchar* sender,
                                                     gpointer* _data);
static void _dbus_pamac_daemon_generate_mirrors_list_data (GObject* _sender,
                                                    const gchar* sender,
                                                    const gchar* line,
                                                    gpointer* _data);
static void _dbus_pamac_daemon_generate_mirrors_list_finished (GObject* _sender,
                                                        const gchar* sender,
                                                        gpointer* _data);
static void _dbus_pamac_daemon_clean_cache_finished (GObject* _sender,
                                              const gchar* sender,
                                              gboolean success,
                                              gpointer* _data);
static void _dbus_pamac_daemon_clean_build_files_finished (GObject* _sender,
                                                    const gchar* sender,
                                                    gboolean success,
                                                    gpointer* _data);
static void _dbus_pamac_daemon_snap_trans_run_finished (GObject* _sender,
                                                 const gchar* sender,
                                                 gboolean success,
                                                 gpointer* _data);
static void _dbus_pamac_daemon_snap_switch_channel_finished (GObject* _sender,
                                                      const gchar* sender,
                                                      gboolean success,
                                                      gpointer* _data);
static void _dbus_pamac_daemon_flatpak_trans_run_finished (GObject* _sender,
                                                    const gchar* sender,
                                                    gboolean success,
                                                    gpointer* _data);
static void _pamac_daemon_unregister_object (gpointer user_data);
VALA_EXTERN void on_bus_acquired (GDBusConnection* conn);
static void _vala_main (void);
static void _on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                              const gchar* name,
                                              gpointer self);
static void __lambda98_ (void);
static void ___lambda98__gbus_name_lost_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           gpointer self);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

static const GDBusArgInfo _pamac_daemon_dbus_arg_info_set_environment_variables_variables = {-1, "variables", "a{ss}", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_set_environment_variables_in[] = {&_pamac_daemon_dbus_arg_info_set_environment_variables_variables, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_set_environment_variables_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_set_environment_variables = {-1, "SetEnvironmentVariables", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_set_environment_variables_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_set_environment_variables_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_get_sender_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_get_sender_in[] = {NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_get_sender_out[] = {&_pamac_daemon_dbus_arg_info_get_sender_result, NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_get_sender = {-1, "GetSender", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_get_sender_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_get_sender_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_get_lockfile_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_get_lockfile_in[] = {NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_get_lockfile_out[] = {&_pamac_daemon_dbus_arg_info_get_lockfile_result, NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_get_lockfile = {-1, "GetLockfile", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_get_lockfile_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_get_lockfile_out), NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_get_authorization_in[] = {NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_get_authorization_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_get_authorization = {-1, "StartGetAuthorization", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_get_authorization_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_get_authorization_out), NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_remove_authorization_in[] = {NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_remove_authorization_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_remove_authorization = {-1, "RemoveAuthorization", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_remove_authorization_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_remove_authorization_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_write_alpm_config_new_alpm_conf = {-1, "new_alpm_conf", "a{sv}", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_write_alpm_config_in[] = {&_pamac_daemon_dbus_arg_info_start_write_alpm_config_new_alpm_conf, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_write_alpm_config_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_write_alpm_config = {-1, "StartWriteAlpmConfig", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_write_alpm_config_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_write_alpm_config_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_write_pamac_config_new_pamac_conf = {-1, "new_pamac_conf", "a{sv}", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_write_pamac_config_in[] = {&_pamac_daemon_dbus_arg_info_start_write_pamac_config_new_pamac_conf, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_write_pamac_config_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_write_pamac_config = {-1, "StartWritePamacConfig", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_write_pamac_config_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_write_pamac_config_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_generate_mirrors_list_country = {-1, "country", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_generate_mirrors_list_in[] = {&_pamac_daemon_dbus_arg_info_start_generate_mirrors_list_country, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_generate_mirrors_list_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_generate_mirrors_list = {-1, "StartGenerateMirrorsList", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_generate_mirrors_list_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_generate_mirrors_list_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_clean_cache_filenames = {-1, "filenames", "as", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_clean_cache_in[] = {&_pamac_daemon_dbus_arg_info_start_clean_cache_filenames, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_clean_cache_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_clean_cache = {-1, "StartCleanCache", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_clean_cache_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_clean_cache_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_clean_build_files_aur_build_dir = {-1, "aur_build_dir", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_clean_build_files_in[] = {&_pamac_daemon_dbus_arg_info_start_clean_build_files_aur_build_dir, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_clean_build_files_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_clean_build_files = {-1, "StartCleanBuildFiles", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_clean_build_files_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_clean_build_files_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_set_pkgreason_pkgname = {-1, "pkgname", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_set_pkgreason_reason = {-1, "reason", "u", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_set_pkgreason_in[] = {&_pamac_daemon_dbus_arg_info_start_set_pkgreason_pkgname, &_pamac_daemon_dbus_arg_info_start_set_pkgreason_reason, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_set_pkgreason_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_set_pkgreason = {-1, "StartSetPkgreason", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_set_pkgreason_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_set_pkgreason_out), NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_download_updates_in[] = {NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_download_updates_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_download_updates = {-1, "StartDownloadUpdates", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_download_updates_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_download_updates_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_download_pkgs_urls = {-1, "urls", "as", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_download_pkgs_in[] = {&_pamac_daemon_dbus_arg_info_start_download_pkgs_urls, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_download_pkgs_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_download_pkgs = {-1, "StartDownloadPkgs", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_download_pkgs_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_download_pkgs_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_refresh_force = {-1, "force", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_trans_refresh_in[] = {&_pamac_daemon_dbus_arg_info_start_trans_refresh_force, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_trans_refresh_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_trans_refresh = {-1, "StartTransRefresh", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_trans_refresh_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_trans_refresh_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_refresh_files_force = {-1, "force", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_trans_refresh_files_in[] = {&_pamac_daemon_dbus_arg_info_start_trans_refresh_files_force, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_trans_refresh_files_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_trans_refresh_files = {-1, "StartTransRefreshFiles", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_trans_refresh_files_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_trans_refresh_files_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_refresh_aur_force = {-1, "force", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_trans_refresh_aur_in[] = {&_pamac_daemon_dbus_arg_info_start_trans_refresh_aur_force, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_trans_refresh_aur_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_trans_refresh_aur = {-1, "StartTransRefreshAur", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_trans_refresh_aur_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_trans_refresh_aur_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_sysupgrade = {-1, "sysupgrade", "b", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_enable_downgrade = {-1, "enable_downgrade", "b", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_simple_install = {-1, "simple_install", "b", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_keep_built_pkgs = {-1, "keep_built_pkgs", "b", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_trans_flags = {-1, "trans_flags", "i", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_to_install = {-1, "to_install", "as", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_to_remove = {-1, "to_remove", "as", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_to_load_local = {-1, "to_load_local", "as", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_to_load_remote = {-1, "to_load_remote", "as", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_to_install_as_dep = {-1, "to_install_as_dep", "as", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_ignorepkgs = {-1, "ignorepkgs", "as", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_overwrite_files = {-1, "overwrite_files", "as", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_trans_run_in[] = {&_pamac_daemon_dbus_arg_info_start_trans_run_sysupgrade, &_pamac_daemon_dbus_arg_info_start_trans_run_enable_downgrade, &_pamac_daemon_dbus_arg_info_start_trans_run_simple_install, &_pamac_daemon_dbus_arg_info_start_trans_run_keep_built_pkgs, &_pamac_daemon_dbus_arg_info_start_trans_run_trans_flags, &_pamac_daemon_dbus_arg_info_start_trans_run_to_install, &_pamac_daemon_dbus_arg_info_start_trans_run_to_remove, &_pamac_daemon_dbus_arg_info_start_trans_run_to_load_local, &_pamac_daemon_dbus_arg_info_start_trans_run_to_load_remote, &_pamac_daemon_dbus_arg_info_start_trans_run_to_install_as_dep, &_pamac_daemon_dbus_arg_info_start_trans_run_ignorepkgs, &_pamac_daemon_dbus_arg_info_start_trans_run_overwrite_files, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_trans_run_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_trans_run = {-1, "StartTransRun", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_trans_run_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_trans_run_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_snap_trans_run_to_install = {-1, "to_install", "as", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_snap_trans_run_to_remove = {-1, "to_remove", "as", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_snap_trans_run_in[] = {&_pamac_daemon_dbus_arg_info_start_snap_trans_run_to_install, &_pamac_daemon_dbus_arg_info_start_snap_trans_run_to_remove, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_snap_trans_run_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_snap_trans_run = {-1, "StartSnapTransRun", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_snap_trans_run_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_snap_trans_run_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_snap_switch_channel_snap_name = {-1, "snap_name", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_snap_switch_channel_snap_channel = {-1, "snap_channel", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_snap_switch_channel_in[] = {&_pamac_daemon_dbus_arg_info_start_snap_switch_channel_snap_name, &_pamac_daemon_dbus_arg_info_start_snap_switch_channel_snap_channel, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_snap_switch_channel_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_snap_switch_channel = {-1, "StartSnapSwitchChannel", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_snap_switch_channel_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_snap_switch_channel_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_flatpak_trans_run_to_install = {-1, "to_install", "as", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_flatpak_trans_run_to_remove = {-1, "to_remove", "as", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_flatpak_trans_run_to_upgrade = {-1, "to_upgrade", "as", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_flatpak_trans_run_in[] = {&_pamac_daemon_dbus_arg_info_start_flatpak_trans_run_to_install, &_pamac_daemon_dbus_arg_info_start_flatpak_trans_run_to_remove, &_pamac_daemon_dbus_arg_info_start_flatpak_trans_run_to_upgrade, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_flatpak_trans_run_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_flatpak_trans_run = {-1, "StartFlatpakTransRun", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_flatpak_trans_run_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_flatpak_trans_run_out), NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_trans_cancel_in[] = {NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_trans_cancel_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_trans_cancel = {-1, "TransCancel", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_trans_cancel_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_trans_cancel_out), NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_quit_in[] = {NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_quit_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_quit = {-1, "Quit", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_quit_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_quit_out), NULL};
static const GDBusMethodInfo * const _pamac_daemon_dbus_method_info[] = {&_pamac_daemon_dbus_method_info_set_environment_variables, &_pamac_daemon_dbus_method_info_get_sender, &_pamac_daemon_dbus_method_info_get_lockfile, &_pamac_daemon_dbus_method_info_start_get_authorization, &_pamac_daemon_dbus_method_info_remove_authorization, &_pamac_daemon_dbus_method_info_start_write_alpm_config, &_pamac_daemon_dbus_method_info_start_write_pamac_config, &_pamac_daemon_dbus_method_info_start_generate_mirrors_list, &_pamac_daemon_dbus_method_info_start_clean_cache, &_pamac_daemon_dbus_method_info_start_clean_build_files, &_pamac_daemon_dbus_method_info_start_set_pkgreason, &_pamac_daemon_dbus_method_info_start_download_updates, &_pamac_daemon_dbus_method_info_start_download_pkgs, &_pamac_daemon_dbus_method_info_start_trans_refresh, &_pamac_daemon_dbus_method_info_start_trans_refresh_files, &_pamac_daemon_dbus_method_info_start_trans_refresh_aur, &_pamac_daemon_dbus_method_info_start_trans_run, &_pamac_daemon_dbus_method_info_start_snap_trans_run, &_pamac_daemon_dbus_method_info_start_snap_switch_channel, &_pamac_daemon_dbus_method_info_start_flatpak_trans_run, &_pamac_daemon_dbus_method_info_trans_cancel, &_pamac_daemon_dbus_method_info_quit, NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_action_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_action_action = {-1, "action", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_emit_action[] = {&_pamac_daemon_dbus_arg_info_emit_action_sender, &_pamac_daemon_dbus_arg_info_emit_action_action, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_emit_action = {-1, "EmitAction", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_emit_action), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_action_progress_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_action_progress_action = {-1, "action", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_action_progress_status = {-1, "status", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_action_progress_progress = {-1, "progress", "d", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_emit_action_progress[] = {&_pamac_daemon_dbus_arg_info_emit_action_progress_sender, &_pamac_daemon_dbus_arg_info_emit_action_progress_action, &_pamac_daemon_dbus_arg_info_emit_action_progress_status, &_pamac_daemon_dbus_arg_info_emit_action_progress_progress, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_emit_action_progress = {-1, "EmitActionProgress", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_emit_action_progress), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_download_progress_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_download_progress_action = {-1, "action", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_download_progress_status = {-1, "status", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_download_progress_progress = {-1, "progress", "d", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_emit_download_progress[] = {&_pamac_daemon_dbus_arg_info_emit_download_progress_sender, &_pamac_daemon_dbus_arg_info_emit_download_progress_action, &_pamac_daemon_dbus_arg_info_emit_download_progress_status, &_pamac_daemon_dbus_arg_info_emit_download_progress_progress, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_emit_download_progress = {-1, "EmitDownloadProgress", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_emit_download_progress), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_hook_progress_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_hook_progress_action = {-1, "action", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_hook_progress_details = {-1, "details", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_hook_progress_status = {-1, "status", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_hook_progress_progress = {-1, "progress", "d", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_emit_hook_progress[] = {&_pamac_daemon_dbus_arg_info_emit_hook_progress_sender, &_pamac_daemon_dbus_arg_info_emit_hook_progress_action, &_pamac_daemon_dbus_arg_info_emit_hook_progress_details, &_pamac_daemon_dbus_arg_info_emit_hook_progress_status, &_pamac_daemon_dbus_arg_info_emit_hook_progress_progress, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_emit_hook_progress = {-1, "EmitHookProgress", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_emit_hook_progress), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_script_output_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_script_output_message = {-1, "message", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_emit_script_output[] = {&_pamac_daemon_dbus_arg_info_emit_script_output_sender, &_pamac_daemon_dbus_arg_info_emit_script_output_message, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_emit_script_output = {-1, "EmitScriptOutput", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_emit_script_output), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_warning_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_warning_message = {-1, "message", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_emit_warning[] = {&_pamac_daemon_dbus_arg_info_emit_warning_sender, &_pamac_daemon_dbus_arg_info_emit_warning_message, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_emit_warning = {-1, "EmitWarning", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_emit_warning), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_error_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_error_message = {-1, "message", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_error_details = {-1, "details", "as", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_emit_error[] = {&_pamac_daemon_dbus_arg_info_emit_error_sender, &_pamac_daemon_dbus_arg_info_emit_error_message, &_pamac_daemon_dbus_arg_info_emit_error_details, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_emit_error = {-1, "EmitError", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_emit_error), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_important_details_outpout_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_important_details_outpout_must_show = {-1, "must_show", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_important_details_outpout[] = {&_pamac_daemon_dbus_arg_info_important_details_outpout_sender, &_pamac_daemon_dbus_arg_info_important_details_outpout_must_show, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_important_details_outpout = {-1, "ImportantDetailsOutpout", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_important_details_outpout), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_downloading_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_downloading[] = {&_pamac_daemon_dbus_arg_info_start_downloading_sender, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_start_downloading = {-1, "StartDownloading", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_downloading), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_stop_downloading_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_stop_downloading[] = {&_pamac_daemon_dbus_arg_info_stop_downloading_sender, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_stop_downloading = {-1, "StopDownloading", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_stop_downloading), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_set_pkgreason_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_set_pkgreason_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_set_pkgreason_finished[] = {&_pamac_daemon_dbus_arg_info_set_pkgreason_finished_sender, &_pamac_daemon_dbus_arg_info_set_pkgreason_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_set_pkgreason_finished = {-1, "SetPkgreasonFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_set_pkgreason_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_waiting_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_waiting[] = {&_pamac_daemon_dbus_arg_info_start_waiting_sender, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_start_waiting = {-1, "StartWaiting", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_waiting), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_stop_waiting_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_stop_waiting[] = {&_pamac_daemon_dbus_arg_info_stop_waiting_sender, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_stop_waiting = {-1, "StopWaiting", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_stop_waiting), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_trans_refresh_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_trans_refresh_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_trans_refresh_finished[] = {&_pamac_daemon_dbus_arg_info_trans_refresh_finished_sender, &_pamac_daemon_dbus_arg_info_trans_refresh_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_trans_refresh_finished = {-1, "TransRefreshFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_trans_refresh_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_trans_refresh_files_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_trans_refresh_files_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_trans_refresh_files_finished[] = {&_pamac_daemon_dbus_arg_info_trans_refresh_files_finished_sender, &_pamac_daemon_dbus_arg_info_trans_refresh_files_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_trans_refresh_files_finished = {-1, "TransRefreshFilesFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_trans_refresh_files_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_trans_refresh_aur_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_trans_refresh_aur_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_trans_refresh_aur_finished[] = {&_pamac_daemon_dbus_arg_info_trans_refresh_aur_finished_sender, &_pamac_daemon_dbus_arg_info_trans_refresh_aur_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_trans_refresh_aur_finished = {-1, "TransRefreshAurFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_trans_refresh_aur_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_trans_run_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_trans_run_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_trans_run_finished[] = {&_pamac_daemon_dbus_arg_info_trans_run_finished_sender, &_pamac_daemon_dbus_arg_info_trans_run_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_trans_run_finished = {-1, "TransRunFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_trans_run_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_download_updates_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_download_updates_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_download_updates_finished[] = {&_pamac_daemon_dbus_arg_info_download_updates_finished_sender, &_pamac_daemon_dbus_arg_info_download_updates_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_download_updates_finished = {-1, "DownloadUpdatesFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_download_updates_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_download_pkgs_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_download_pkgs_finished_dload_paths = {-1, "dload_paths", "as", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_download_pkgs_finished[] = {&_pamac_daemon_dbus_arg_info_download_pkgs_finished_sender, &_pamac_daemon_dbus_arg_info_download_pkgs_finished_dload_paths, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_download_pkgs_finished = {-1, "DownloadPkgsFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_download_pkgs_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_get_authorization_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_get_authorization_finished_authorized = {-1, "authorized", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_get_authorization_finished[] = {&_pamac_daemon_dbus_arg_info_get_authorization_finished_sender, &_pamac_daemon_dbus_arg_info_get_authorization_finished_authorized, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_get_authorization_finished = {-1, "GetAuthorizationFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_get_authorization_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_write_alpm_config_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_write_alpm_config_finished[] = {&_pamac_daemon_dbus_arg_info_write_alpm_config_finished_sender, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_write_alpm_config_finished = {-1, "WriteAlpmConfigFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_write_alpm_config_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_write_pamac_config_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_write_pamac_config_finished[] = {&_pamac_daemon_dbus_arg_info_write_pamac_config_finished_sender, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_write_pamac_config_finished = {-1, "WritePamacConfigFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_write_pamac_config_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_generate_mirrors_list_data_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_generate_mirrors_list_data_line = {-1, "line", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_generate_mirrors_list_data[] = {&_pamac_daemon_dbus_arg_info_generate_mirrors_list_data_sender, &_pamac_daemon_dbus_arg_info_generate_mirrors_list_data_line, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_generate_mirrors_list_data = {-1, "GenerateMirrorsListData", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_generate_mirrors_list_data), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_generate_mirrors_list_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_generate_mirrors_list_finished[] = {&_pamac_daemon_dbus_arg_info_generate_mirrors_list_finished_sender, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_generate_mirrors_list_finished = {-1, "GenerateMirrorsListFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_generate_mirrors_list_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_clean_cache_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_clean_cache_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_clean_cache_finished[] = {&_pamac_daemon_dbus_arg_info_clean_cache_finished_sender, &_pamac_daemon_dbus_arg_info_clean_cache_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_clean_cache_finished = {-1, "CleanCacheFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_clean_cache_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_clean_build_files_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_clean_build_files_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_clean_build_files_finished[] = {&_pamac_daemon_dbus_arg_info_clean_build_files_finished_sender, &_pamac_daemon_dbus_arg_info_clean_build_files_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_clean_build_files_finished = {-1, "CleanBuildFilesFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_clean_build_files_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_snap_trans_run_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_snap_trans_run_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_snap_trans_run_finished[] = {&_pamac_daemon_dbus_arg_info_snap_trans_run_finished_sender, &_pamac_daemon_dbus_arg_info_snap_trans_run_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_snap_trans_run_finished = {-1, "SnapTransRunFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_snap_trans_run_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_snap_switch_channel_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_snap_switch_channel_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_snap_switch_channel_finished[] = {&_pamac_daemon_dbus_arg_info_snap_switch_channel_finished_sender, &_pamac_daemon_dbus_arg_info_snap_switch_channel_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_snap_switch_channel_finished = {-1, "SnapSwitchChannelFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_snap_switch_channel_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_flatpak_trans_run_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_flatpak_trans_run_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_flatpak_trans_run_finished[] = {&_pamac_daemon_dbus_arg_info_flatpak_trans_run_finished_sender, &_pamac_daemon_dbus_arg_info_flatpak_trans_run_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_flatpak_trans_run_finished = {-1, "FlatpakTransRunFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_flatpak_trans_run_finished), NULL};
static const GDBusSignalInfo * const _pamac_daemon_dbus_signal_info[] = {&_pamac_daemon_dbus_signal_info_emit_action, &_pamac_daemon_dbus_signal_info_emit_action_progress, &_pamac_daemon_dbus_signal_info_emit_download_progress, &_pamac_daemon_dbus_signal_info_emit_hook_progress, &_pamac_daemon_dbus_signal_info_emit_script_output, &_pamac_daemon_dbus_signal_info_emit_warning, &_pamac_daemon_dbus_signal_info_emit_error, &_pamac_daemon_dbus_signal_info_important_details_outpout, &_pamac_daemon_dbus_signal_info_start_downloading, &_pamac_daemon_dbus_signal_info_stop_downloading, &_pamac_daemon_dbus_signal_info_set_pkgreason_finished, &_pamac_daemon_dbus_signal_info_start_waiting, &_pamac_daemon_dbus_signal_info_stop_waiting, &_pamac_daemon_dbus_signal_info_trans_refresh_finished, &_pamac_daemon_dbus_signal_info_trans_refresh_files_finished, &_pamac_daemon_dbus_signal_info_trans_refresh_aur_finished, &_pamac_daemon_dbus_signal_info_trans_run_finished, &_pamac_daemon_dbus_signal_info_download_updates_finished, &_pamac_daemon_dbus_signal_info_download_pkgs_finished, &_pamac_daemon_dbus_signal_info_get_authorization_finished, &_pamac_daemon_dbus_signal_info_write_alpm_config_finished, &_pamac_daemon_dbus_signal_info_write_pamac_config_finished, &_pamac_daemon_dbus_signal_info_generate_mirrors_list_data, &_pamac_daemon_dbus_signal_info_generate_mirrors_list_finished, &_pamac_daemon_dbus_signal_info_clean_cache_finished, &_pamac_daemon_dbus_signal_info_clean_build_files_finished, &_pamac_daemon_dbus_signal_info_snap_trans_run_finished, &_pamac_daemon_dbus_signal_info_snap_switch_channel_finished, &_pamac_daemon_dbus_signal_info_flatpak_trans_run_finished, NULL};
static const GDBusPropertyInfo * const _pamac_daemon_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _pamac_daemon_dbus_interface_info = {-1, "org.manjaro.pamac.daemon", (GDBusMethodInfo **) (&_pamac_daemon_dbus_method_info), (GDBusSignalInfo **) (&_pamac_daemon_dbus_signal_info), (GDBusPropertyInfo **) (&_pamac_daemon_dbus_property_info), NULL};
static const GDBusInterfaceVTable _pamac_daemon_dbus_interface_vtable = {pamac_daemon_dbus_interface_method_call, pamac_daemon_dbus_interface_get_property, pamac_daemon_dbus_interface_set_property};

static inline gpointer
pamac_daemon_get_instance_private (PamacDaemon* self)
{
	return G_STRUCT_MEMBER_P (self, PamacDaemon_private_offset);
}

static gpointer
_pamac_daemon_set_extern_lock_gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) pamac_daemon_set_extern_lock ((PamacDaemon*) self));
	g_object_unref (self);
	return result;
}

static void
_pamac_daemon_check_extern_lock_g_file_monitor_changed (GFileMonitor* _sender,
                                                        GFile* file,
                                                        GFile* other_file,
                                                        GFileMonitorEvent event_type,
                                                        gpointer self)
{
	pamac_daemon_check_extern_lock ((PamacDaemon*) self, file, other_file, event_type);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
__lambda46_ (PamacDaemon* self,
             const gchar* sender,
             const gchar* action)
{
	g_return_if_fail (sender != NULL);
	g_return_if_fail (action != NULL);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ACTION_SIGNAL], 0, sender, action);
}

static void
___lambda46__pamac_alpm_utils_emit_action (PamacAlpmUtils* _sender,
                                           const gchar* sender,
                                           const gchar* action,
                                           gpointer self)
{
	__lambda46_ ((PamacDaemon*) self, sender, action);
}

static void
__lambda47_ (PamacDaemon* self,
             const gchar* sender,
             const gchar* action,
             const gchar* status,
             gdouble progress)
{
	g_return_if_fail (sender != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (status != NULL);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ACTION_PROGRESS_SIGNAL], 0, sender, action, status, progress);
}

static void
___lambda47__pamac_alpm_utils_emit_action_progress (PamacAlpmUtils* _sender,
                                                    const gchar* sender,
                                                    const gchar* action,
                                                    const gchar* status,
                                                    gdouble progress,
                                                    gpointer self)
{
	__lambda47_ ((PamacDaemon*) self, sender, action, status, progress);
}

static void
__lambda48_ (PamacDaemon* self,
             const gchar* sender,
             const gchar* action,
             const gchar* details,
             const gchar* status,
             gdouble progress)
{
	g_return_if_fail (sender != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (details != NULL);
	g_return_if_fail (status != NULL);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_HOOK_PROGRESS_SIGNAL], 0, sender, action, details, status, progress);
}

static void
___lambda48__pamac_alpm_utils_emit_hook_progress (PamacAlpmUtils* _sender,
                                                  const gchar* sender,
                                                  const gchar* action,
                                                  const gchar* details,
                                                  const gchar* status,
                                                  gdouble progress,
                                                  gpointer self)
{
	__lambda48_ ((PamacDaemon*) self, sender, action, details, status, progress);
}

static void
__lambda49_ (PamacDaemon* self,
             const gchar* sender,
             const gchar* action,
             const gchar* status,
             gdouble progress)
{
	g_return_if_fail (sender != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (status != NULL);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_DOWNLOAD_PROGRESS_SIGNAL], 0, sender, action, status, progress);
}

static void
___lambda49__pamac_alpm_utils_emit_download_progress (PamacAlpmUtils* _sender,
                                                      const gchar* sender,
                                                      const gchar* action,
                                                      const gchar* status,
                                                      gdouble progress,
                                                      gpointer self)
{
	__lambda49_ ((PamacDaemon*) self, sender, action, status, progress);
}

static void
__lambda50_ (PamacDaemon* self,
             const gchar* sender)
{
	g_return_if_fail (sender != NULL);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_START_DOWNLOADING_SIGNAL], 0, sender);
}

static void
___lambda50__pamac_alpm_utils_start_downloading (PamacAlpmUtils* _sender,
                                                 const gchar* sender,
                                                 gpointer self)
{
	__lambda50_ ((PamacDaemon*) self, sender);
}

static void
__lambda51_ (PamacDaemon* self,
             const gchar* sender)
{
	g_return_if_fail (sender != NULL);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_STOP_DOWNLOADING_SIGNAL], 0, sender);
}

static void
___lambda51__pamac_alpm_utils_stop_downloading (PamacAlpmUtils* _sender,
                                                const gchar* sender,
                                                gpointer self)
{
	__lambda51_ ((PamacDaemon*) self, sender);
}

static void
__lambda52_ (PamacDaemon* self,
             const gchar* sender,
             const gchar* message)
{
	g_return_if_fail (sender != NULL);
	g_return_if_fail (message != NULL);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_SCRIPT_OUTPUT_SIGNAL], 0, sender, message);
}

static void
___lambda52__pamac_alpm_utils_emit_script_output (PamacAlpmUtils* _sender,
                                                  const gchar* sender,
                                                  const gchar* message,
                                                  gpointer self)
{
	__lambda52_ ((PamacDaemon*) self, sender, message);
}

static void
__lambda53_ (PamacDaemon* self,
             const gchar* sender,
             const gchar* message)
{
	g_return_if_fail (sender != NULL);
	g_return_if_fail (message != NULL);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_WARNING_SIGNAL], 0, sender, message);
}

static void
___lambda53__pamac_alpm_utils_emit_warning (PamacAlpmUtils* _sender,
                                            const gchar* sender,
                                            const gchar* message,
                                            gpointer self)
{
	__lambda53_ ((PamacDaemon*) self, sender, message);
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
__lambda54_ (PamacDaemon* self,
             const gchar* sender,
             const gchar* message,
             GPtrArray* details)
{
	gchar** details_copy = NULL;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint details_copy_length1;
	gint _details_copy_size_;
	g_return_if_fail (sender != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (details != NULL);
	_tmp0_ = details->pdata;
	_tmp0__length1 = details->len;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	details_copy = _tmp1_;
	details_copy_length1 = _tmp1__length1;
	_details_copy_size_ = details_copy_length1;
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, sender, message, details_copy, (gint) details_copy_length1);
	details_copy = (_vala_array_free (details_copy, details_copy_length1, (GDestroyNotify) g_free), NULL);
}

static void
___lambda54__pamac_alpm_utils_emit_error (PamacAlpmUtils* _sender,
                                          const gchar* sender,
                                          const gchar* message,
                                          GPtrArray* details,
                                          gpointer self)
{
	__lambda54_ ((PamacDaemon*) self, sender, message, details);
}

static void
__lambda55_ (PamacDaemon* self,
             const gchar* sender,
             gboolean must_show)
{
	g_return_if_fail (sender != NULL);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_IMPORTANT_DETAILS_OUTPOUT_SIGNAL], 0, sender, must_show);
}

static void
___lambda55__pamac_alpm_utils_important_details_outpout (PamacAlpmUtils* _sender,
                                                         const gchar* sender,
                                                         gboolean must_show,
                                                         gpointer self)
{
	__lambda55_ ((PamacDaemon*) self, sender, must_show);
}

static void
___lambda56_ (PamacDaemon* self,
              const gchar* sender,
              const gchar* action,
              const gchar* status,
              gdouble progress)
{
	g_return_if_fail (sender != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (status != NULL);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ACTION_PROGRESS_SIGNAL], 0, sender, action, status, progress);
}

static void
____lambda56__pamac_snap_plugin_emit_action_progress (PamacSnapPlugin* _sender,
                                                      const gchar* sender,
                                                      const gchar* action,
                                                      const gchar* status,
                                                      gdouble progress,
                                                      gpointer self)
{
	___lambda56_ ((PamacDaemon*) self, sender, action, status, progress);
}

static void
___lambda57_ (PamacDaemon* self,
              const gchar* sender,
              const gchar* action,
              const gchar* status,
              gdouble progress)
{
	g_return_if_fail (sender != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (status != NULL);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_DOWNLOAD_PROGRESS_SIGNAL], 0, sender, action, status, progress);
}

static void
____lambda57__pamac_snap_plugin_emit_download_progress (PamacSnapPlugin* _sender,
                                                        const gchar* sender,
                                                        const gchar* action,
                                                        const gchar* status,
                                                        gdouble progress,
                                                        gpointer self)
{
	___lambda57_ ((PamacDaemon*) self, sender, action, status, progress);
}

static void
___lambda58_ (PamacDaemon* self,
              const gchar* sender,
              const gchar* message)
{
	g_return_if_fail (sender != NULL);
	g_return_if_fail (message != NULL);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_SCRIPT_OUTPUT_SIGNAL], 0, sender, message);
}

static void
____lambda58__pamac_snap_plugin_emit_script_output (PamacSnapPlugin* _sender,
                                                    const gchar* sender,
                                                    const gchar* message,
                                                    gpointer self)
{
	___lambda58_ ((PamacDaemon*) self, sender, message);
}

static void
___lambda59_ (PamacDaemon* self,
              const gchar* sender,
              const gchar* message,
              gchar** details,
              gint details_length1)
{
	g_return_if_fail (sender != NULL);
	g_return_if_fail (message != NULL);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, sender, message, details, (gint) details_length1);
}

static void
____lambda59__pamac_snap_plugin_emit_error (PamacSnapPlugin* _sender,
                                            const gchar* sender,
                                            const gchar* message,
                                            gchar** details,
                                            gint details_length1,
                                            gpointer self)
{
	___lambda59_ ((PamacDaemon*) self, sender, message, details, details_length1);
}

static void
___lambda60_ (PamacDaemon* self,
              const gchar* sender)
{
	g_return_if_fail (sender != NULL);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_START_DOWNLOADING_SIGNAL], 0, sender);
}

static void
____lambda60__pamac_snap_plugin_start_downloading (PamacSnapPlugin* _sender,
                                                   const gchar* sender,
                                                   gpointer self)
{
	___lambda60_ ((PamacDaemon*) self, sender);
}

static void
___lambda61_ (PamacDaemon* self,
              const gchar* sender)
{
	g_return_if_fail (sender != NULL);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_STOP_DOWNLOADING_SIGNAL], 0, sender);
}

static void
____lambda61__pamac_snap_plugin_stop_downloading (PamacSnapPlugin* _sender,
                                                  const gchar* sender,
                                                  gpointer self)
{
	___lambda61_ ((PamacDaemon*) self, sender);
}

static void
___lambda62_ (PamacDaemon* self,
              const gchar* sender,
              const gchar* action,
              const gchar* status,
              gdouble progress)
{
	g_return_if_fail (sender != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (status != NULL);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ACTION_PROGRESS_SIGNAL], 0, sender, action, status, progress);
}

static void
____lambda62__pamac_flatpak_plugin_emit_action_progress (PamacFlatpakPlugin* _sender,
                                                         const gchar* sender,
                                                         const gchar* action,
                                                         const gchar* status,
                                                         gdouble progress,
                                                         gpointer self)
{
	___lambda62_ ((PamacDaemon*) self, sender, action, status, progress);
}

static void
___lambda63_ (PamacDaemon* self,
              const gchar* sender,
              const gchar* message)
{
	g_return_if_fail (sender != NULL);
	g_return_if_fail (message != NULL);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_SCRIPT_OUTPUT_SIGNAL], 0, sender, message);
}

static void
____lambda63__pamac_flatpak_plugin_emit_script_output (PamacFlatpakPlugin* _sender,
                                                       const gchar* sender,
                                                       const gchar* message,
                                                       gpointer self)
{
	___lambda63_ ((PamacDaemon*) self, sender, message);
}

static void
___lambda64_ (PamacDaemon* self,
              const gchar* sender,
              const gchar* message,
              gchar** details,
              gint details_length1)
{
	g_return_if_fail (sender != NULL);
	g_return_if_fail (message != NULL);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, sender, message, details, (gint) details_length1);
}

static void
____lambda64__pamac_flatpak_plugin_emit_error (PamacFlatpakPlugin* _sender,
                                               const gchar* sender,
                                               const gchar* message,
                                               gchar** details,
                                               gint details_length1,
                                               gpointer self)
{
	___lambda64_ ((PamacDaemon*) self, sender, message, details, details_length1);
}

PamacDaemon*
pamac_daemon_construct (GType object_type)
{
	PamacDaemon * self = NULL;
	PamacConfig* _tmp0_;
	gchar* user_agent = NULL;
	gchar* _tmp1_;
	PamacConfig* _tmp2_;
	PamacAlpmUtils* _tmp3_;
	const gchar* _tmp4_;
	PamacAlpmUtils* _tmp5_;
	GFile* _tmp6_;
	GHashFunc _tmp19_;
	GEqualFunc _tmp20_;
	GHashTable* _tmp21_;
	GHashFunc _tmp22_;
	GEqualFunc _tmp23_;
	GHashTable* _tmp24_;
	PamacAlpmUtils* _tmp25_;
	PamacAlpmUtils* _tmp26_;
	PamacAlpmUtils* _tmp27_;
	PamacAlpmUtils* _tmp28_;
	PamacAlpmUtils* _tmp29_;
	PamacAlpmUtils* _tmp30_;
	PamacAlpmUtils* _tmp31_;
	PamacAlpmUtils* _tmp32_;
	PamacAlpmUtils* _tmp33_;
	PamacAlpmUtils* _tmp34_;
	PamacConfig* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	PamacConfig* _tmp46_;
	gboolean _tmp47_;
	gboolean _tmp48_;
	GError* _inner_error0_ = NULL;
	self = (PamacDaemon*) g_object_new (object_type, NULL);
	_tmp0_ = pamac_config_new ("/etc/pamac.conf");
	_g_object_unref0 (self->priv->config);
	self->priv->config = _tmp0_;
	_tmp1_ = get_user_agent ();
	user_agent = _tmp1_;
	_tmp2_ = self->priv->config;
	_tmp3_ = pamac_alpm_utils_new (_tmp2_);
	_g_object_unref0 (self->priv->alpm_utils);
	self->priv->alpm_utils = _tmp3_;
	_tmp4_ = user_agent;
	g_setenv ("HTTP_USER_AGENT", _tmp4_, TRUE);
	_vala_clear_GCond (&self->priv->lockfile_cond);
	g_cond_init (&self->priv->lockfile_cond);
	_vala_clear_GMutex (&self->priv->lockfile_mutex);
	g_mutex_init (&self->priv->lockfile_mutex);
	_tmp5_ = self->priv->alpm_utils;
	_tmp6_ = _tmp5_->lockfile;
	if (g_file_query_exists (_tmp6_, NULL)) {
		{
			GThread* _tmp7_;
			GThread* _tmp8_;
			_tmp7_ = g_thread_try_new ("set_extern_lock", _pamac_daemon_set_extern_lock_gthread_func, g_object_ref (self), &_inner_error0_);
			_tmp8_ = _tmp7_;
			_g_thread_unref0 (_tmp8_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_warning ("daemon.vala:85: %s", _tmp10_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (user_agent);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	{
		GFileMonitor* _tmp11_ = NULL;
		PamacAlpmUtils* _tmp12_;
		GFile* _tmp13_;
		GFileMonitor* _tmp14_;
		GFileMonitor* _tmp15_;
		GFileMonitor* _tmp16_;
		_tmp12_ = self->priv->alpm_utils;
		_tmp13_ = _tmp12_->lockfile;
		_tmp14_ = g_file_monitor (_tmp13_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		_g_object_unref0 (self->priv->lockfile_monitor);
		self->priv->lockfile_monitor = _tmp15_;
		_tmp16_ = self->priv->lockfile_monitor;
		g_signal_connect_object (_tmp16_, "changed", (GCallback) _pamac_daemon_check_extern_lock_g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp11_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_warning ("daemon.vala:92: %s", _tmp18_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (user_agent);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	self->priv->running_threads = 0;
	_vala_clear_GCond (&self->priv->answer_cond);
	g_cond_init (&self->priv->answer_cond);
	_vala_clear_GMutex (&self->priv->answer_mutex);
	g_mutex_init (&self->priv->answer_mutex);
	_vala_clear_GMutex (&self->priv->authorization_mutex);
	g_mutex_init (&self->priv->authorization_mutex);
	_tmp19_ = g_str_hash;
	_tmp20_ = g_str_equal;
	_tmp21_ = g_hash_table_new_full (_tmp19_, _tmp20_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->authorized_senders);
	self->priv->authorized_senders = _tmp21_;
	_tmp22_ = g_str_hash;
	_tmp23_ = g_str_equal;
	_tmp24_ = g_hash_table_new_full (_tmp22_, _tmp23_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->cancellables_table);
	self->priv->cancellables_table = _tmp24_;
	_tmp25_ = self->priv->alpm_utils;
	g_signal_connect_object (_tmp25_, "emit-action", (GCallback) ___lambda46__pamac_alpm_utils_emit_action, self, 0);
	_tmp26_ = self->priv->alpm_utils;
	g_signal_connect_object (_tmp26_, "emit-action-progress", (GCallback) ___lambda47__pamac_alpm_utils_emit_action_progress, self, 0);
	_tmp27_ = self->priv->alpm_utils;
	g_signal_connect_object (_tmp27_, "emit-hook-progress", (GCallback) ___lambda48__pamac_alpm_utils_emit_hook_progress, self, 0);
	_tmp28_ = self->priv->alpm_utils;
	g_signal_connect_object (_tmp28_, "emit-download-progress", (GCallback) ___lambda49__pamac_alpm_utils_emit_download_progress, self, 0);
	_tmp29_ = self->priv->alpm_utils;
	g_signal_connect_object (_tmp29_, "start-downloading", (GCallback) ___lambda50__pamac_alpm_utils_start_downloading, self, 0);
	_tmp30_ = self->priv->alpm_utils;
	g_signal_connect_object (_tmp30_, "stop-downloading", (GCallback) ___lambda51__pamac_alpm_utils_stop_downloading, self, 0);
	_tmp31_ = self->priv->alpm_utils;
	g_signal_connect_object (_tmp31_, "emit-script-output", (GCallback) ___lambda52__pamac_alpm_utils_emit_script_output, self, 0);
	_tmp32_ = self->priv->alpm_utils;
	g_signal_connect_object (_tmp32_, "emit-warning", (GCallback) ___lambda53__pamac_alpm_utils_emit_warning, self, 0);
	_tmp33_ = self->priv->alpm_utils;
	g_signal_connect_object (_tmp33_, "emit-error", (GCallback) ___lambda54__pamac_alpm_utils_emit_error, self, 0);
	_tmp34_ = self->priv->alpm_utils;
	g_signal_connect_object (_tmp34_, "important-details-outpout", (GCallback) ___lambda55__pamac_alpm_utils_important_details_outpout, self, 0);
	_tmp35_ = self->priv->config;
	_tmp36_ = pamac_config_get_support_snap (_tmp35_);
	_tmp37_ = _tmp36_;
	if (_tmp37_) {
		PamacConfig* _tmp38_;
		PamacSnapPlugin* _tmp39_;
		PamacSnapPlugin* _tmp40_;
		PamacSnapPlugin* _tmp41_;
		PamacSnapPlugin* _tmp42_;
		PamacSnapPlugin* _tmp43_;
		PamacSnapPlugin* _tmp44_;
		PamacSnapPlugin* _tmp45_;
		_tmp38_ = self->priv->config;
		_tmp39_ = pamac_config_get_snap_plugin (_tmp38_);
		_g_object_unref0 (self->priv->snap_plugin);
		self->priv->snap_plugin = _tmp39_;
		_tmp40_ = self->priv->snap_plugin;
		g_signal_connect_object (_tmp40_, "emit-action-progress", (GCallback) ____lambda56__pamac_snap_plugin_emit_action_progress, self, 0);
		_tmp41_ = self->priv->snap_plugin;
		g_signal_connect_object (_tmp41_, "emit-download-progress", (GCallback) ____lambda57__pamac_snap_plugin_emit_download_progress, self, 0);
		_tmp42_ = self->priv->snap_plugin;
		g_signal_connect_object (_tmp42_, "emit-script-output", (GCallback) ____lambda58__pamac_snap_plugin_emit_script_output, self, 0);
		_tmp43_ = self->priv->snap_plugin;
		g_signal_connect_object (_tmp43_, "emit-error", (GCallback) ____lambda59__pamac_snap_plugin_emit_error, self, 0);
		_tmp44_ = self->priv->snap_plugin;
		g_signal_connect_object (_tmp44_, "start-downloading", (GCallback) ____lambda60__pamac_snap_plugin_start_downloading, self, 0);
		_tmp45_ = self->priv->snap_plugin;
		g_signal_connect_object (_tmp45_, "stop-downloading", (GCallback) ____lambda61__pamac_snap_plugin_stop_downloading, self, 0);
	}
	_tmp46_ = self->priv->config;
	_tmp47_ = pamac_config_get_support_flatpak (_tmp46_);
	_tmp48_ = _tmp47_;
	if (_tmp48_) {
		PamacConfig* _tmp49_;
		PamacFlatpakPlugin* _tmp50_;
		PamacFlatpakPlugin* _tmp51_;
		PamacFlatpakPlugin* _tmp52_;
		PamacFlatpakPlugin* _tmp53_;
		_tmp49_ = self->priv->config;
		_tmp50_ = pamac_config_get_flatpak_plugin (_tmp49_);
		_g_object_unref0 (self->priv->flatpak_plugin);
		self->priv->flatpak_plugin = _tmp50_;
		_tmp51_ = self->priv->flatpak_plugin;
		g_signal_connect_object (_tmp51_, "emit-action-progress", (GCallback) ____lambda62__pamac_flatpak_plugin_emit_action_progress, self, 0);
		_tmp52_ = self->priv->flatpak_plugin;
		g_signal_connect_object (_tmp52_, "emit-script-output", (GCallback) ____lambda63__pamac_flatpak_plugin_emit_script_output, self, 0);
		_tmp53_ = self->priv->flatpak_plugin;
		g_signal_connect_object (_tmp53_, "emit-error", (GCallback) ____lambda64__pamac_flatpak_plugin_emit_error, self, 0);
	}
	_g_free0 (user_agent);
	return self;
}

PamacDaemon*
pamac_daemon_new (void)
{
	return pamac_daemon_construct (PAMAC_TYPE_DAEMON);
}

void
pamac_daemon_set_environment_variables (PamacDaemon* self,
                                        GHashTable* variables,
                                        GError** error)
{
	gchar** keys = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint keys_length1;
	gint _keys_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variables != NULL);
	_tmp0_ = g_strdup ("http_proxy");
	_tmp1_ = g_strdup ("https_proxy");
	_tmp2_ = g_strdup ("ftp_proxy");
	_tmp3_ = g_strdup ("socks_proxy");
	_tmp4_ = g_strdup ("no_proxy");
	_tmp5_ = g_new0 (gchar*, 5 + 1);
	_tmp5_[0] = _tmp0_;
	_tmp5_[1] = _tmp1_;
	_tmp5_[2] = _tmp2_;
	_tmp5_[3] = _tmp3_;
	_tmp5_[4] = _tmp4_;
	keys = _tmp5_;
	keys_length1 = 5;
	_keys_size_ = keys_length1;
	_tmp6_ = keys;
	_tmp6__length1 = keys_length1;
	{
		gchar** key_collection = NULL;
		gint key_collection_length1 = 0;
		gint _key_collection_size_ = 0;
		gint key_it = 0;
		key_collection = _tmp6_;
		key_collection_length1 = _tmp6__length1;
		for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
			const gchar* key = NULL;
			key = key_collection[key_it];
			{
				const gchar* val = NULL;
				const gchar* _tmp7_;
				gconstpointer _tmp8_ = NULL;
				gboolean _tmp9_;
				_tmp7_ = key;
				_tmp9_ = g_hash_table_lookup_extended (variables, _tmp7_, NULL, &_tmp8_);
				val = (const gchar*) _tmp8_;
				if (_tmp9_) {
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					_tmp10_ = key;
					_tmp11_ = val;
					g_setenv (_tmp10_, _tmp11_, TRUE);
				}
			}
		}
	}
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
}

gchar*
pamac_daemon_get_sender (PamacDaemon* self,
                         const char* sender,
                         GError** error)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sender != NULL, NULL);
	_tmp0_ = g_strdup ((gchar*) sender);
	result = _tmp0_;
	return result;
}

gchar*
pamac_daemon_get_lockfile (PamacDaemon* self,
                           GError** error)
{
	PamacAlpmUtils* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->alpm_utils;
	_tmp1_ = _tmp0_->lockfile;
	_tmp2_ = g_file_get_path (_tmp1_);
	result = _tmp2_;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		PamacDaemon* self;
		self = _data2_->self;
		_g_main_loop_unref0 (_data2_->tmp_loop);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
____lambda45_ (Block2Data* _data2_,
               GFile* src,
               GFile* dest,
               GFileMonitorEvent event_type)
{
	PamacDaemon* self;
	self = _data2_->self;
	g_return_if_fail (src != NULL);
	if (event_type == G_FILE_MONITOR_EVENT_DELETED) {
		GMainLoop* _tmp0_;
		g_mutex_unlock (&self->priv->lockfile_mutex);
		_tmp0_ = _data2_->tmp_loop;
		g_main_loop_quit (_tmp0_);
	}
}

static void
_____lambda45__g_file_monitor_changed (GFileMonitor* _sender,
                                       GFile* file,
                                       GFile* other_file,
                                       GFileMonitorEvent event_type,
                                       gpointer self)
{
	____lambda45_ (self, file, other_file, event_type);
}

static gint
pamac_daemon_set_extern_lock (PamacDaemon* self)
{
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (g_mutex_trylock (&self->priv->lockfile_mutex)) {
		{
			Block2Data* _data2_;
			GMainLoop* _tmp0_;
			GFileMonitor* unlock_monitor = NULL;
			PamacAlpmUtils* _tmp1_;
			GFile* _tmp2_;
			GFileMonitor* _tmp3_;
			GFileMonitor* _tmp4_;
			PamacAlpmUtils* _tmp5_;
			GFile* _tmp6_;
			GMainLoop* _tmp7_;
			_data2_ = g_slice_new0 (Block2Data);
			_data2_->_ref_count_ = 1;
			_data2_->self = g_object_ref (self);
			_tmp0_ = g_main_loop_new (NULL, FALSE);
			_data2_->tmp_loop = _tmp0_;
			_tmp1_ = self->priv->alpm_utils;
			_tmp2_ = _tmp1_->lockfile;
			_tmp3_ = g_file_monitor (_tmp2_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
			unlock_monitor = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				block2_data_unref (_data2_);
				_data2_ = NULL;
				goto __catch0_g_error;
			}
			_tmp4_ = unlock_monitor;
			g_signal_connect_data (_tmp4_, "changed", (GCallback) _____lambda45__g_file_monitor_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
			_tmp5_ = self->priv->alpm_utils;
			_tmp6_ = _tmp5_->lockfile;
			if (!g_file_query_exists (_tmp6_, NULL)) {
				g_mutex_unlock (&self->priv->lockfile_mutex);
				result = 0;
				_g_object_unref0 (unlock_monitor);
				block2_data_unref (_data2_);
				_data2_ = NULL;
				return result;
			}
			_tmp7_ = _data2_->tmp_loop;
			g_main_loop_run (_tmp7_);
			_g_object_unref0 (unlock_monitor);
			block2_data_unref (_data2_);
			_data2_ = NULL;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_warning ("daemon.vala:206: %s", _tmp9_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp10_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp10_;
		}
	}
	result = 0;
	return result;
}

static void
pamac_daemon_check_extern_lock (PamacDaemon* self,
                                GFile* src,
                                GFile* dest,
                                GFileMonitorEvent event_type)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
	if (event_type == G_FILE_MONITOR_EVENT_CREATED) {
		{
			GThread* _tmp0_;
			GThread* _tmp1_;
			_tmp0_ = g_thread_try_new ("check_extern_lock", _pamac_daemon_set_extern_lock_gthread_func, g_object_ref (self), &_inner_error0_);
			_tmp1_ = _tmp0_;
			_g_thread_unref0 (_tmp1_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			g_warning ("daemon.vala:217: %s", _tmp3_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
pamac_daemon_check_authorization_data_free (gpointer _data)
{
	PamacDaemonCheckAuthorizationData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sender);
	_g_object_unref0 (_data_->self);
	g_slice_free (PamacDaemonCheckAuthorizationData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
pamac_daemon_check_authorization (PamacDaemon* self,
                                  const char* sender,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	PamacDaemonCheckAuthorizationData* _data_;
	PamacDaemon* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	_data_ = g_slice_new0 (PamacDaemonCheckAuthorizationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pamac_daemon_check_authorization_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (sender);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp1_;
	pamac_daemon_check_authorization_co (_data_);
}

static gboolean
pamac_daemon_check_authorization_finish (PamacDaemon* self,
                                         GAsyncResult* _res_)
{
	gboolean result;
	PamacDaemonCheckAuthorizationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
pamac_daemon_check_authorization_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	PamacDaemonCheckAuthorizationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	pamac_daemon_check_authorization_co (_data_);
}

static gboolean
pamac_daemon_check_authorization_co (PamacDaemonCheckAuthorizationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->authorized = FALSE;
	{
		_data_->_state_ = 1;
		polkit_authority_get_async (NULL, pamac_daemon_check_authorization_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = polkit_authority_get_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->authority = _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp1_ = (PolkitSystemBusName*) polkit_system_bus_name_new ((const gchar*) _data_->sender);
		_data_->subject = (PolkitSubject*) _data_->_tmp1_;
		_data_->_tmp2_ = _data_->authority;
		_data_->_tmp3_ = _data_->subject;
		_data_->_state_ = 2;
		polkit_authority_check_authorization (_data_->_tmp2_, _data_->_tmp3_, "org.manjaro.pamac.commit", NULL, POLKIT_CHECK_AUTHORIZATION_FLAGS_ALLOW_USER_INTERACTION, NULL, pamac_daemon_check_authorization_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp4_ = polkit_authority_check_authorization_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_result_ = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->subject);
			_g_object_unref0 (_data_->authority);
			goto __catch0_g_error;
		}
		_data_->_tmp5_ = _data_->_result_;
		_data_->authorized = polkit_authorization_result_get_is_authorized (_data_->_tmp5_);
		if (!_data_->authorized) {
			_data_->_tmp6_ = g_new0 (gchar*, 0 + 1);
			_data_->_tmp7_ = _data_->_tmp6_;
			_data_->_tmp7__length1 = 0;
			g_signal_emit (_data_->self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, (const gchar*) _data_->sender, _ ("Authentication failed"), _data_->_tmp7_, (gint) 0);
			_data_->_tmp7_ = (_vala_array_free (_data_->_tmp7_, _data_->_tmp7__length1, (GDestroyNotify) g_free), NULL);
		}
		_g_object_unref0 (_data_->_result_);
		_g_object_unref0 (_data_->subject);
		_g_object_unref0 (_data_->authority);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->e;
		_data_->_tmp9_ = _data_->_tmp8_->message;
		_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
		_data_->_tmp11_ = g_new0 (gchar*, 1 + 1);
		_data_->_tmp11_[0] = _data_->_tmp10_;
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp12__length1 = 1;
		g_signal_emit (_data_->self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, (const gchar*) _data_->sender, _ ("Authentication failed"), _data_->_tmp12_, (gint) 1);
		_data_->_tmp12_ = (_vala_array_free (_data_->_tmp12_, _data_->_tmp12__length1, (GDestroyNotify) g_free), NULL);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->authorized;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		PamacDaemon* self;
		self = _data3_->self;
		_g_free0 (_data3_->sender);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
___lambda65_ (Block3Data* _data3_)
{
	PamacDaemon* self;
	gboolean result;
	self = _data3_->self;
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_GET_AUTHORIZATION_FINISHED_SIGNAL], 0, (const gchar*) _data3_->sender, TRUE);
	result = FALSE;
	return result;
}

static gboolean
____lambda65__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda65_ (self);
	return result;
}

static void
__lambda66_ (Block3Data* _data3_,
             GObject* obj,
             GAsyncResult* res)
{
	PamacDaemon* self;
	gboolean authorized = FALSE;
	self = _data3_->self;
	g_return_if_fail (res != NULL);
	authorized = pamac_daemon_check_authorization_finish (self, res);
	if (authorized) {
		GHashTable* _tmp0_;
		gchar* _tmp1_;
		g_mutex_lock (&self->priv->authorization_mutex);
		_tmp0_ = self->priv->authorized_senders;
		_tmp1_ = g_strdup ((gchar*) _data3_->sender);
		g_hash_table_add (_tmp0_, _tmp1_);
		g_mutex_unlock (&self->priv->authorization_mutex);
	}
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_GET_AUTHORIZATION_FINISHED_SIGNAL], 0, (const gchar*) _data3_->sender, authorized);
}

static void
___lambda66__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda66_ (self, source_object, res);
	block3_data_unref (self);
}

void
pamac_daemon_start_get_authorization (PamacDaemon* self,
                                      const char* sender,
                                      GError** error)
{
	Block3Data* _data3_;
	char* _tmp0_;
	gboolean fast_authorized = FALSE;
	GHashTable* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = g_strdup (sender);
	_g_free0 (_data3_->sender);
	_data3_->sender = _tmp0_;
	g_mutex_lock (&self->priv->authorization_mutex);
	_tmp1_ = self->priv->authorized_senders;
	fast_authorized = g_hash_table_contains (_tmp1_, (const gchar*) _data3_->sender);
	g_mutex_unlock (&self->priv->authorization_mutex);
	if (fast_authorized) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda65__gsource_func, block3_data_ref (_data3_), block3_data_unref);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	pamac_daemon_check_authorization (self, _data3_->sender, ___lambda66__gasync_ready_callback, block3_data_ref (_data3_));
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

void
pamac_daemon_remove_authorization (PamacDaemon* self,
                                   const char* sender,
                                   GError** error)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_mutex_lock (&self->priv->authorization_mutex);
	_tmp0_ = self->priv->authorized_senders;
	g_hash_table_remove (_tmp0_, (const gchar*) sender);
	g_mutex_unlock (&self->priv->authorization_mutex);
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		PamacDaemon* self;
		self = _data4_->self;
		_g_hash_table_unref0 (_data4_->new_alpm_conf);
		_g_free0 (_data4_->sender);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gint
____lambda68_ (Block4Data* _data4_)
{
	PamacDaemon* self;
	PamacAlpmUtils* _tmp0_;
	AlpmConfig* _tmp1_;
	PamacAlpmUtils* _tmp2_;
	AlpmConfig* _tmp3_;
	gint result;
	self = _data4_->self;
	g_atomic_int_inc ((volatile gint *) (&self->priv->running_threads));
	g_mutex_lock (&self->priv->lockfile_mutex);
	_tmp0_ = self->priv->alpm_utils;
	_tmp1_ = _tmp0_->alpm_config;
	alpm_config_write (_tmp1_, _data4_->new_alpm_conf);
	_tmp2_ = self->priv->alpm_utils;
	_tmp3_ = _tmp2_->alpm_config;
	alpm_config_reload (_tmp3_);
	g_mutex_unlock (&self->priv->lockfile_mutex);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_WRITE_ALPM_CONFIG_FINISHED_SIGNAL], 0, (const gchar*) _data4_->sender);
	g_atomic_int_dec_and_test ((volatile gint *) (&self->priv->running_threads));
	result = 0;
	return result;
}

static gpointer
_____lambda68__gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) ____lambda68_ (self));
	block4_data_unref (self);
	return result;
}

static void
__lambda67_ (Block4Data* _data4_,
             GObject* obj,
             GAsyncResult* res)
{
	PamacDaemon* self;
	gboolean authorized = FALSE;
	GError* _inner_error0_ = NULL;
	self = _data4_->self;
	g_return_if_fail (res != NULL);
	authorized = pamac_daemon_check_authorization_finish (self, res);
	if (authorized) {
		{
			GThread* _tmp0_;
			GThread* _tmp1_;
			_tmp0_ = g_thread_try_new ("write_alpm_config", _____lambda68__gthread_func, block4_data_ref (_data4_), &_inner_error0_);
			_tmp1_ = _tmp0_;
			_g_thread_unref0 (_tmp1_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar** _tmp5_;
			gchar** _tmp6_;
			gint _tmp6__length1;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			_tmp4_ = g_strdup (_tmp3_);
			_tmp5_ = g_new0 (gchar*, 1 + 1);
			_tmp5_[0] = _tmp4_;
			_tmp6_ = _tmp5_;
			_tmp6__length1 = 1;
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, (const gchar*) _data4_->sender, "Daemon Error", _tmp6_, (gint) 1);
			_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_WRITE_ALPM_CONFIG_FINISHED_SIGNAL], 0, (const gchar*) _data4_->sender);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
___lambda67__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda67_ (self, source_object, res);
	block4_data_unref (self);
}

void
pamac_daemon_start_write_alpm_config (PamacDaemon* self,
                                      GHashTable* new_alpm_conf,
                                      const char* sender,
                                      GError** error)
{
	Block4Data* _data4_;
	GHashTable* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_alpm_conf != NULL);
	g_return_if_fail (sender != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_hash_table_ref0 (new_alpm_conf);
	_g_hash_table_unref0 (_data4_->new_alpm_conf);
	_data4_->new_alpm_conf = _tmp0_;
	_tmp1_ = g_strdup (sender);
	_g_free0 (_data4_->sender);
	_data4_->sender = _tmp1_;
	pamac_daemon_check_authorization (self, _data4_->sender, ___lambda67__gasync_ready_callback, block4_data_ref (_data4_));
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		PamacDaemon* self;
		self = _data5_->self;
		_g_hash_table_unref0 (_data5_->new_pamac_conf);
		_g_free0 (_data5_->sender);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda69_ (Block5Data* _data5_,
             GObject* obj,
             GAsyncResult* res)
{
	PamacDaemon* self;
	gboolean authorized = FALSE;
	GError* _inner_error0_ = NULL;
	self = _data5_->self;
	g_return_if_fail (res != NULL);
	authorized = pamac_daemon_check_authorization_finish (self, res);
	if (authorized) {
		PamacConfig* _tmp0_;
		PamacConfig* _tmp1_;
		PamacConfig* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		PamacConfig* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp0_ = self->priv->config;
		pamac_config_write (_tmp0_, _data5_->new_pamac_conf);
		_tmp1_ = self->priv->config;
		pamac_config_reload (_tmp1_);
		_tmp2_ = self->priv->config;
		_tmp3_ = pamac_config_get_enable_snap (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			{
				g_spawn_command_line_async ("systemctl enable --now snapd.service", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_SPAWN_ERROR) {
						goto __catch0_g_spawn_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			goto __finally0;
			__catch0_g_spawn_error:
			{
				GError* e = NULL;
				GError* _tmp5_;
				const gchar* _tmp6_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp5_ = e;
				_tmp6_ = _tmp5_->message;
				g_warning ("daemon.vala:303: %s", _tmp6_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp7_ = self->priv->config;
		_tmp8_ = pamac_config_get_offline_upgrade (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_) {
			{
				g_spawn_command_line_async ("systemctl enable pamac-offline-upgrade.service", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_SPAWN_ERROR) {
						goto __catch1_g_spawn_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			goto __finally1;
			__catch1_g_spawn_error:
			{
				GError* e = NULL;
				GError* _tmp10_;
				const gchar* _tmp11_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp10_ = e;
				_tmp11_ = _tmp10_->message;
				g_warning ("daemon.vala:310: %s", _tmp11_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		} else {
			{
				g_spawn_command_line_async ("systemctl disable pamac-offline-upgrade.service", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_SPAWN_ERROR) {
						goto __catch2_g_spawn_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			goto __finally2;
			__catch2_g_spawn_error:
			{
				GError* e = NULL;
				GError* _tmp12_;
				const gchar* _tmp13_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp12_ = e;
				_tmp13_ = _tmp12_->message;
				g_warning ("daemon.vala:316: %s", _tmp13_);
				_g_error_free0 (e);
			}
			__finally2:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_WRITE_PAMAC_CONFIG_FINISHED_SIGNAL], 0, (const gchar*) _data5_->sender);
}

static void
___lambda69__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda69_ (self, source_object, res);
	block5_data_unref (self);
}

void
pamac_daemon_start_write_pamac_config (PamacDaemon* self,
                                       GHashTable* new_pamac_conf,
                                       const char* sender,
                                       GError** error)
{
	Block5Data* _data5_;
	GHashTable* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_pamac_conf != NULL);
	g_return_if_fail (sender != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_hash_table_ref0 (new_pamac_conf);
	_g_hash_table_unref0 (_data5_->new_pamac_conf);
	_data5_->new_pamac_conf = _tmp0_;
	_tmp1_ = g_strdup (sender);
	_g_free0 (_data5_->sender);
	_data5_->sender = _tmp1_;
	pamac_daemon_check_authorization (self, _data5_->sender, ___lambda69__gasync_ready_callback, block5_data_ref (_data5_));
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		PamacDaemon* self;
		self = _data6_->self;
		_g_free0 (_data6_->country);
		_g_free0 (_data6_->sender);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static gint
____lambda71_ (Block6Data* _data6_)
{
	PamacDaemon* self;
	PamacAlpmUtils* _tmp23_;
	AlpmConfig* _tmp24_;
	GError* _inner_error0_ = NULL;
	gint result;
	self = _data6_->self;
	g_atomic_int_inc ((volatile gint *) (&self->priv->running_threads));
	{
		GSubprocess* process = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar** _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		GSubprocess* _tmp6_;
		GSubprocess* _tmp7_;
		GDataInputStream* dis = NULL;
		GSubprocess* _tmp8_;
		GInputStream* _tmp9_;
		GDataInputStream* _tmp10_;
		gchar* line = NULL;
		_tmp0_ = g_strdup ("pacman-mirrors");
		_tmp1_ = g_strdup ("--no-color");
		_tmp2_ = g_strdup ("-c");
		_tmp3_ = g_strdup (_data6_->country);
		_tmp4_ = g_new0 (gchar*, 4 + 1);
		_tmp4_[0] = _tmp0_;
		_tmp4_[1] = _tmp1_;
		_tmp4_[2] = _tmp2_;
		_tmp4_[3] = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp5__length1 = 4;
		_tmp6_ = g_subprocess_newv (_tmp5_, G_SUBPROCESS_FLAGS_STDOUT_PIPE | G_SUBPROCESS_FLAGS_STDERR_MERGE, &_inner_error0_);
		_tmp7_ = _tmp6_;
		_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
		process = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = process;
		_tmp9_ = g_subprocess_get_stdout_pipe (_tmp8_);
		_tmp10_ = g_data_input_stream_new (_tmp9_);
		dis = _tmp10_;
		while (TRUE) {
			gchar* _tmp11_ = NULL;
			GDataInputStream* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp12_ = dis;
			_tmp13_ = g_data_input_stream_read_line (_tmp12_, NULL, NULL, &_inner_error0_);
			_tmp11_ = _tmp13_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (dis);
				_g_object_unref0 (process);
				goto __catch0_g_error;
			}
			_tmp14_ = _tmp11_;
			_tmp11_ = NULL;
			_g_free0 (line);
			line = _tmp14_;
			_tmp15_ = line;
			if (!(_tmp15_ != NULL)) {
				_g_free0 (_tmp11_);
				break;
			}
			_tmp16_ = line;
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_GENERATE_MIRRORS_LIST_DATA_SIGNAL], 0, (const gchar*) _data6_->sender, _tmp16_);
			_g_free0 (_tmp11_);
		}
		_g_free0 (line);
		_g_object_unref0 (dis);
		_g_object_unref0 (process);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar** _tmp20_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		_tmp19_ = g_strdup (_tmp18_);
		_tmp20_ = g_new0 (gchar*, 1 + 1);
		_tmp20_[0] = _tmp19_;
		_tmp21_ = _tmp20_;
		_tmp21__length1 = 1;
		g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, (const gchar*) _data6_->sender, "Daemon Error", _tmp21_, (gint) 1);
		_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_free), NULL);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp22_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp22_;
	}
	g_mutex_lock (&self->priv->lockfile_mutex);
	_tmp23_ = self->priv->alpm_utils;
	_tmp24_ = _tmp23_->alpm_config;
	alpm_config_reload (_tmp24_);
	g_mutex_unlock (&self->priv->lockfile_mutex);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_GENERATE_MIRRORS_LIST_FINISHED_SIGNAL], 0, (const gchar*) _data6_->sender);
	g_atomic_int_dec_and_test ((volatile gint *) (&self->priv->running_threads));
	result = 0;
	return result;
}

static gpointer
_____lambda71__gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) ____lambda71_ (self));
	block6_data_unref (self);
	return result;
}

static void
__lambda70_ (Block6Data* _data6_,
             GObject* obj,
             GAsyncResult* res)
{
	PamacDaemon* self;
	gboolean authorized = FALSE;
	GError* _inner_error0_ = NULL;
	self = _data6_->self;
	g_return_if_fail (res != NULL);
	authorized = pamac_daemon_check_authorization_finish (self, res);
	if (authorized) {
		{
			GThread* _tmp0_;
			GThread* _tmp1_;
			_tmp0_ = g_thread_try_new ("generate_mirrors_list", _____lambda71__gthread_func, block6_data_ref (_data6_), &_inner_error0_);
			_tmp1_ = _tmp0_;
			_g_thread_unref0 (_tmp1_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar** _tmp5_;
			gchar** _tmp6_;
			gint _tmp6__length1;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			_tmp4_ = g_strdup (_tmp3_);
			_tmp5_ = g_new0 (gchar*, 1 + 1);
			_tmp5_[0] = _tmp4_;
			_tmp6_ = _tmp5_;
			_tmp6__length1 = 1;
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, (const gchar*) _data6_->sender, "Daemon Error", _tmp6_, (gint) 1);
			_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_GENERATE_MIRRORS_LIST_FINISHED_SIGNAL], 0, (const gchar*) _data6_->sender);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
___lambda70__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda70_ (self, source_object, res);
	block6_data_unref (self);
}

void
pamac_daemon_start_generate_mirrors_list (PamacDaemon* self,
                                          const gchar* country,
                                          const char* sender,
                                          GError** error)
{
	Block6Data* _data6_;
	gchar* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (country != NULL);
	g_return_if_fail (sender != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = g_strdup (country);
	_g_free0 (_data6_->country);
	_data6_->country = _tmp0_;
	_tmp1_ = g_strdup (sender);
	_g_free0 (_data6_->sender);
	_data6_->sender = _tmp1_;
	pamac_daemon_check_authorization (self, _data6_->sender, ___lambda70__gasync_ready_callback, block6_data_ref (_data6_));
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		PamacDaemon* self;
		self = _data7_->self;
		_data7_->names = (_vala_array_free (_data7_->names, _data7_->names_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data7_->sender);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
__lambda72_ (Block7Data* _data7_,
             GObject* obj,
             GAsyncResult* res)
{
	PamacDaemon* self;
	gboolean authorized = FALSE;
	self = _data7_->self;
	g_return_if_fail (res != NULL);
	authorized = pamac_daemon_check_authorization_finish (self, res);
	if (authorized) {
		PamacAlpmUtils* _tmp0_;
		_tmp0_ = self->priv->alpm_utils;
		pamac_alpm_utils_clean_cache (_tmp0_, _data7_->names, (gint) _data7_->names_length1);
	}
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_CLEAN_CACHE_FINISHED_SIGNAL], 0, (const gchar*) _data7_->sender, authorized);
}

static void
___lambda72__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda72_ (self, source_object, res);
	block7_data_unref (self);
}

void
pamac_daemon_start_clean_cache (PamacDaemon* self,
                                gchar** filenames,
                                gint filenames_length1,
                                const char* sender,
                                GError** error)
{
	Block7Data* _data7_;
	char* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = g_strdup (sender);
	_g_free0 (_data7_->sender);
	_data7_->sender = _tmp0_;
	_tmp1_ = (filenames != NULL) ? _vala_array_dup2 (filenames, filenames_length1) : filenames;
	_tmp1__length1 = filenames_length1;
	_data7_->names = _tmp1_;
	_data7_->names_length1 = _tmp1__length1;
	_data7_->_names_size_ = _data7_->names_length1;
	pamac_daemon_check_authorization (self, _data7_->sender, ___lambda72__gasync_ready_callback, block7_data_ref (_data7_));
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		PamacDaemon* self;
		self = _data8_->self;
		_g_free0 (_data8_->aur_build_dir);
		_g_free0 (_data8_->sender);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda73_ (Block8Data* _data8_,
             GObject* obj,
             GAsyncResult* res)
{
	PamacDaemon* self;
	gboolean authorized = FALSE;
	self = _data8_->self;
	g_return_if_fail (res != NULL);
	authorized = pamac_daemon_check_authorization_finish (self, res);
	if (authorized) {
		PamacAlpmUtils* _tmp0_;
		_tmp0_ = self->priv->alpm_utils;
		pamac_alpm_utils_clean_build_files (_tmp0_, _data8_->aur_build_dir);
	}
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_CLEAN_BUILD_FILES_FINISHED_SIGNAL], 0, (const gchar*) _data8_->sender, authorized);
}

static void
___lambda73__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda73_ (self, source_object, res);
	block8_data_unref (self);
}

void
pamac_daemon_start_clean_build_files (PamacDaemon* self,
                                      const gchar* aur_build_dir,
                                      const char* sender,
                                      GError** error)
{
	Block8Data* _data8_;
	gchar* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (aur_build_dir != NULL);
	g_return_if_fail (sender != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = g_strdup (aur_build_dir);
	_g_free0 (_data8_->aur_build_dir);
	_data8_->aur_build_dir = _tmp0_;
	_tmp1_ = g_strdup (sender);
	_g_free0 (_data8_->sender);
	_data8_->sender = _tmp1_;
	pamac_daemon_check_authorization (self, _data8_->sender, ___lambda73__gasync_ready_callback, block8_data_ref (_data8_));
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		PamacDaemon* self;
		self = _data9_->self;
		_g_free0 (_data9_->pkgname);
		_g_free0 (_data9_->sender);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static gint
____lambda75_ (Block9Data* _data9_)
{
	PamacDaemon* self;
	gboolean success = FALSE;
	PamacAlpmUtils* _tmp0_;
	gint result;
	self = _data9_->self;
	g_atomic_int_inc ((volatile gint *) (&self->priv->running_threads));
	g_mutex_lock (&self->priv->lockfile_mutex);
	_tmp0_ = self->priv->alpm_utils;
	success = pamac_alpm_utils_set_pkgreason (_tmp0_, (const gchar*) _data9_->sender, _data9_->pkgname, _data9_->reason);
	g_mutex_unlock (&self->priv->lockfile_mutex);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_SET_PKGREASON_FINISHED_SIGNAL], 0, (const gchar*) _data9_->sender, success);
	g_atomic_int_dec_and_test ((volatile gint *) (&self->priv->running_threads));
	result = 0;
	return result;
}

static gpointer
_____lambda75__gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) ____lambda75_ (self));
	block9_data_unref (self);
	return result;
}

static void
__lambda74_ (Block9Data* _data9_,
             GObject* obj,
             GAsyncResult* res)
{
	PamacDaemon* self;
	gboolean authorized = FALSE;
	GError* _inner_error0_ = NULL;
	self = _data9_->self;
	g_return_if_fail (res != NULL);
	authorized = pamac_daemon_check_authorization_finish (self, res);
	if (authorized) {
		{
			GThread* _tmp0_;
			GThread* _tmp1_;
			_tmp0_ = g_thread_try_new ("set_pkgreason", _____lambda75__gthread_func, block9_data_ref (_data9_), &_inner_error0_);
			_tmp1_ = _tmp0_;
			_g_thread_unref0 (_tmp1_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar** _tmp5_;
			gchar** _tmp6_;
			gint _tmp6__length1;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			_tmp4_ = g_strdup (_tmp3_);
			_tmp5_ = g_new0 (gchar*, 1 + 1);
			_tmp5_[0] = _tmp4_;
			_tmp6_ = _tmp5_;
			_tmp6__length1 = 1;
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, (const gchar*) _data9_->sender, "Daemon Error", _tmp6_, (gint) 1);
			_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_SET_PKGREASON_FINISHED_SIGNAL], 0, (const gchar*) _data9_->sender, FALSE);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
___lambda74__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda74_ (self, source_object, res);
	block9_data_unref (self);
}

void
pamac_daemon_start_set_pkgreason (PamacDaemon* self,
                                  const gchar* pkgname,
                                  guint reason,
                                  const char* sender,
                                  GError** error)
{
	Block9Data* _data9_;
	gchar* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pkgname != NULL);
	g_return_if_fail (sender != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = g_strdup (pkgname);
	_g_free0 (_data9_->pkgname);
	_data9_->pkgname = _tmp0_;
	_data9_->reason = reason;
	_tmp1_ = g_strdup (sender);
	_g_free0 (_data9_->sender);
	_data9_->sender = _tmp1_;
	pamac_daemon_check_authorization (self, _data9_->sender, ___lambda74__gasync_ready_callback, block9_data_ref (_data9_));
	block9_data_unref (_data9_);
	_data9_ = NULL;
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		PamacDaemon* self;
		self = _data10_->self;
		_g_free0 (_data10_->sender);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		PamacDaemon* self;
		self = _data11_->_data10_->self;
		_g_object_unref0 (_data11_->cancellable);
		block10_data_unref (_data11_->_data10_);
		_data11_->_data10_ = NULL;
		g_slice_free (Block11Data, _data11_);
	}
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		PamacDaemon* self;
		self = _data12_->_data11_->_data10_->self;
		block11_data_unref (_data12_->_data11_);
		_data12_->_data11_ = NULL;
		g_slice_free (Block12Data, _data12_);
	}
}

static gint
____lambda77_ (Block12Data* _data12_)
{
	Block11Data* _data11_;
	Block10Data* _data10_;
	PamacDaemon* self;
	PamacAlpmUtils* _tmp0_;
	gint result;
	_data11_ = _data12_->_data11_;
	_data10_ = _data11_->_data10_;
	self = _data10_->self;
	_tmp0_ = self->priv->alpm_utils;
	_data12_->success = pamac_alpm_utils_download_updates (_tmp0_, (const gchar*) _data10_->sender);
	result = 0;
	return result;
}

static gpointer
_____lambda77__gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) ____lambda77_ (self));
	block12_data_unref (self);
	return result;
}

static gint
___lambda76_ (Block11Data* _data11_)
{
	Block10Data* _data10_;
	PamacDaemon* self;
	Block12Data* _data12_;
	GCancellable* _tmp0_;
	GError* _inner_error0_ = NULL;
	gint result;
	_data10_ = _data11_->_data10_;
	self = _data10_->self;
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->_data11_ = block11_data_ref (_data11_);
	g_atomic_int_inc ((volatile gint *) (&self->priv->running_threads));
	_tmp0_ = _data11_->cancellable;
	_data12_->success = pamac_daemon_wait_for_lock (self, (const gchar*) _data10_->sender, _tmp0_, TRUE);
	if (_data12_->success) {
		{
			GThread* thread = NULL;
			GThread* _tmp1_;
			GThread* _tmp2_;
			_tmp1_ = g_thread_try_new ("download_updates2", _____lambda77__gthread_func, block12_data_ref (_data12_), &_inner_error0_);
			thread = _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp2_ = thread;
			thread = NULL;
			g_thread_join (_tmp2_);
			_g_thread_unref0 (thread);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			gchar** _tmp6_;
			gchar** _tmp7_;
			gint _tmp7__length1;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = e;
			_tmp4_ = _tmp3_->message;
			_tmp5_ = g_strdup (_tmp4_);
			_tmp6_ = g_new0 (gchar*, 1 + 1);
			_tmp6_[0] = _tmp5_;
			_tmp7_ = _tmp6_;
			_tmp7__length1 = 1;
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, (const gchar*) _data10_->sender, "Daemon Error", _tmp7_, (gint) 1);
			_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_DOWNLOAD_UPDATES_FINISHED_SIGNAL], 0, (const gchar*) _data10_->sender, FALSE);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp8_ = -1;
			block12_data_unref (_data12_);
			_data12_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp8_;
		}
		g_mutex_unlock (&self->priv->lockfile_mutex);
	}
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_DOWNLOAD_UPDATES_FINISHED_SIGNAL], 0, (const gchar*) _data10_->sender, _data12_->success);
	g_atomic_int_dec_and_test ((volatile gint *) (&self->priv->running_threads));
	result = 0;
	block12_data_unref (_data12_);
	_data12_ = NULL;
	return result;
}

static gpointer
____lambda76__gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) ___lambda76_ (self));
	block11_data_unref (self);
	return result;
}

void
pamac_daemon_start_download_updates (PamacDaemon* self,
                                     const char* sender,
                                     GError** error)
{
	Block10Data* _data10_;
	char* _tmp0_;
	PamacAlpmUtils* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = g_strdup (sender);
	_g_free0 (_data10_->sender);
	_data10_->sender = _tmp0_;
	_tmp1_ = self->priv->alpm_utils;
	if (_tmp1_->downloading_updates) {
		block10_data_unref (_data10_);
		_data10_ = NULL;
		return;
	}
	{
		Block11Data* _data11_;
		GHashTable* _tmp2_;
		GHashTable* _tmp6_;
		gconstpointer _tmp7_;
		GCancellable* _tmp8_;
		GThread* _tmp9_;
		GThread* _tmp10_;
		_data11_ = g_slice_new0 (Block11Data);
		_data11_->_ref_count_ = 1;
		_data11_->_data10_ = block10_data_ref (_data10_);
		_tmp2_ = self->priv->cancellables_table;
		if (!g_hash_table_contains (_tmp2_, (const gchar*) _data10_->sender)) {
			GHashTable* _tmp3_;
			gchar* _tmp4_;
			GCancellable* _tmp5_;
			_tmp3_ = self->priv->cancellables_table;
			_tmp4_ = g_strdup ((gchar*) _data10_->sender);
			_tmp5_ = g_cancellable_new ();
			g_hash_table_insert (_tmp3_, _tmp4_, _tmp5_);
		}
		_tmp6_ = self->priv->cancellables_table;
		_tmp7_ = g_hash_table_lookup (_tmp6_, (const gchar*) _data10_->sender);
		_tmp8_ = _g_object_ref0 ((GCancellable*) _tmp7_);
		_data11_->cancellable = _tmp8_;
		_tmp9_ = g_thread_try_new ("download_updates", ____lambda76__gthread_func, block11_data_ref (_data11_), &_inner_error0_);
		_tmp10_ = _tmp9_;
		_g_thread_unref0 (_tmp10_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block11_data_unref (_data11_);
			_data11_ = NULL;
			goto __catch0_g_error;
		}
		block11_data_unref (_data11_);
		_data11_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		_tmp13_ = g_strdup (_tmp12_);
		_tmp14_ = g_new0 (gchar*, 1 + 1);
		_tmp14_[0] = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp15__length1 = 1;
		g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, (const gchar*) _data10_->sender, "Daemon Error", _tmp15_, (gint) 1);
		_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
		g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_DOWNLOAD_UPDATES_FINISHED_SIGNAL], 0, (const gchar*) _data10_->sender, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block10_data_unref (_data10_);
		_data10_ = NULL;
		return;
	}
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		PamacDaemon* self;
		self = _data13_->self;
		_data13_->urls_copy = (_vala_array_free (_data13_->urls_copy, _data13_->urls_copy_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data13_->sender);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		PamacDaemon* self;
		self = _data14_->_data13_->self;
		_g_object_unref0 (_data14_->cancellable);
		block13_data_unref (_data14_->_data13_);
		_data14_->_data13_ = NULL;
		g_slice_free (Block14Data, _data14_);
	}
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		PamacDaemon* self;
		self = _data15_->_data14_->_data13_->self;
		_g_ptr_array_unref0 (_data15_->dload_paths);
		block14_data_unref (_data15_->_data14_);
		_data15_->_data14_ = NULL;
		g_slice_free (Block15Data, _data15_);
	}
}

static gint
____lambda80_ (Block15Data* _data15_)
{
	Block14Data* _data14_;
	Block13Data* _data13_;
	PamacDaemon* self;
	PamacAlpmUtils* _tmp0_;
	gboolean _tmp1_;
	gint result;
	_data14_ = _data15_->_data14_;
	_data13_ = _data14_->_data13_;
	self = _data13_->self;
	_tmp0_ = self->priv->alpm_utils;
	_tmp1_ = pamac_alpm_utils_download_pkgs (_tmp0_, (const gchar*) _data13_->sender, _data13_->urls_copy, (gint) _data13_->urls_copy_length1, &_data15_->dload_paths);
	_data15_->success = _tmp1_;
	result = 0;
	return result;
}

static gpointer
_____lambda80__gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) ____lambda80_ (self));
	block15_data_unref (self);
	return result;
}

static gint
____lambda79_ (Block14Data* _data14_)
{
	Block13Data* _data13_;
	PamacDaemon* self;
	Block15Data* _data15_;
	GPtrArray* _tmp0_;
	GCancellable* _tmp1_;
	GPtrArray* _tmp12_;
	gpointer* _tmp13_;
	gint _tmp13__length1;
	GError* _inner_error0_ = NULL;
	gint result;
	_data13_ = _data14_->_data13_;
	self = _data13_->self;
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->_data14_ = block14_data_ref (_data14_);
	g_atomic_int_inc ((volatile gint *) (&self->priv->running_threads));
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_data15_->dload_paths = _tmp0_;
	_tmp1_ = _data14_->cancellable;
	_data15_->success = pamac_daemon_wait_for_lock (self, (const gchar*) _data13_->sender, _tmp1_, TRUE);
	if (_data15_->success) {
		{
			GThread* thread = NULL;
			GThread* _tmp2_;
			GThread* _tmp3_;
			_tmp2_ = g_thread_try_new ("download_pkgs2", _____lambda80__gthread_func, block15_data_ref (_data15_), &_inner_error0_);
			thread = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp3_ = thread;
			thread = NULL;
			g_thread_join (_tmp3_);
			_g_thread_unref0 (thread);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			gchar** _tmp7_;
			gchar** _tmp8_;
			gint _tmp8__length1;
			gchar** _tmp9_;
			gchar** _tmp10_;
			gint _tmp10__length1;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			_tmp6_ = g_strdup (_tmp5_);
			_tmp7_ = g_new0 (gchar*, 1 + 1);
			_tmp7_[0] = _tmp6_;
			_tmp8_ = _tmp7_;
			_tmp8__length1 = 1;
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, (const gchar*) _data13_->sender, "Daemon Error", _tmp8_, (gint) 1);
			_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
			_tmp9_ = g_new0 (gchar*, 0 + 1);
			_tmp10_ = _tmp9_;
			_tmp10__length1 = 0;
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_DOWNLOAD_PKGS_FINISHED_SIGNAL], 0, (const gchar*) _data13_->sender, _tmp10_, (gint) 0);
			_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp11_ = -1;
			block15_data_unref (_data15_);
			_data15_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp11_;
		}
		g_mutex_unlock (&self->priv->lockfile_mutex);
	}
	_tmp12_ = _data15_->dload_paths;
	_tmp13_ = _tmp12_->pdata;
	_tmp13__length1 = _tmp12_->len;
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_DOWNLOAD_PKGS_FINISHED_SIGNAL], 0, (const gchar*) _data13_->sender, _tmp13_, (gint) _tmp13__length1);
	g_atomic_int_dec_and_test ((volatile gint *) (&self->priv->running_threads));
	result = 0;
	block15_data_unref (_data15_);
	_data15_ = NULL;
	return result;
}

static gpointer
_____lambda79__gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) ____lambda79_ (self));
	block14_data_unref (self);
	return result;
}

static void
__lambda78_ (Block13Data* _data13_,
             GObject* obj,
             GAsyncResult* res)
{
	PamacDaemon* self;
	gboolean authorized = FALSE;
	GError* _inner_error0_ = NULL;
	self = _data13_->self;
	g_return_if_fail (res != NULL);
	authorized = pamac_daemon_check_authorization_finish (self, res);
	if (authorized) {
		{
			Block14Data* _data14_;
			GHashTable* _tmp0_;
			GHashTable* _tmp4_;
			gconstpointer _tmp5_;
			GCancellable* _tmp6_;
			GThread* _tmp7_;
			GThread* _tmp8_;
			_data14_ = g_slice_new0 (Block14Data);
			_data14_->_ref_count_ = 1;
			_data14_->_data13_ = block13_data_ref (_data13_);
			_tmp0_ = self->priv->cancellables_table;
			if (!g_hash_table_contains (_tmp0_, (const gchar*) _data13_->sender)) {
				GHashTable* _tmp1_;
				gchar* _tmp2_;
				GCancellable* _tmp3_;
				_tmp1_ = self->priv->cancellables_table;
				_tmp2_ = g_strdup ((gchar*) _data13_->sender);
				_tmp3_ = g_cancellable_new ();
				g_hash_table_insert (_tmp1_, _tmp2_, _tmp3_);
			}
			_tmp4_ = self->priv->cancellables_table;
			_tmp5_ = g_hash_table_lookup (_tmp4_, (const gchar*) _data13_->sender);
			_tmp6_ = _g_object_ref0 ((GCancellable*) _tmp5_);
			_data14_->cancellable = _tmp6_;
			_tmp7_ = g_thread_try_new ("download_pkgs", _____lambda79__gthread_func, block14_data_ref (_data14_), &_inner_error0_);
			_tmp8_ = _tmp7_;
			_g_thread_unref0 (_tmp8_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				block14_data_unref (_data14_);
				_data14_ = NULL;
				goto __catch0_g_error;
			}
			block14_data_unref (_data14_);
			_data14_ = NULL;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar** _tmp12_;
			gchar** _tmp13_;
			gint _tmp13__length1;
			gchar** _tmp14_;
			gchar** _tmp15_;
			gint _tmp15__length1;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			_tmp11_ = g_strdup (_tmp10_);
			_tmp12_ = g_new0 (gchar*, 1 + 1);
			_tmp12_[0] = _tmp11_;
			_tmp13_ = _tmp12_;
			_tmp13__length1 = 1;
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, (const gchar*) _data13_->sender, "Daemon Error", _tmp13_, (gint) 1);
			_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
			_tmp14_ = g_new0 (gchar*, 0 + 1);
			_tmp15_ = _tmp14_;
			_tmp15__length1 = 0;
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_DOWNLOAD_PKGS_FINISHED_SIGNAL], 0, (const gchar*) _data13_->sender, _tmp15_, (gint) 0);
			_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
___lambda78__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda78_ (self, source_object, res);
	block13_data_unref (self);
}

void
pamac_daemon_start_download_pkgs (PamacDaemon* self,
                                  gchar** urls,
                                  gint urls_length1,
                                  const char* sender,
                                  GError** error)
{
	Block13Data* _data13_;
	char* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_tmp0_ = g_strdup (sender);
	_g_free0 (_data13_->sender);
	_data13_->sender = _tmp0_;
	_tmp1_ = (urls != NULL) ? _vala_array_dup3 (urls, urls_length1) : urls;
	_tmp1__length1 = urls_length1;
	_data13_->urls_copy = _tmp1_;
	_data13_->urls_copy_length1 = _tmp1__length1;
	_data13_->_urls_copy_size_ = _data13_->urls_copy_length1;
	pamac_daemon_check_authorization (self, _data13_->sender, ___lambda78__gasync_ready_callback, block13_data_ref (_data13_));
	block13_data_unref (_data13_);
	_data13_ = NULL;
}

static gboolean
pamac_daemon_wait_for_lock (PamacDaemon* self,
                            const gchar* sender,
                            GCancellable* cancellable,
                            gboolean quiet)
{
	gboolean waiting = FALSE;
	gboolean success = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	g_return_val_if_fail (cancellable != NULL, FALSE);
	waiting = FALSE;
	success = FALSE;
	g_cancellable_reset (cancellable);
	if (!g_mutex_trylock (&self->priv->lockfile_mutex)) {
		gint i = 0;
		waiting = TRUE;
		g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_START_WAITING_SIGNAL], 0, sender);
		if (!quiet) {
			gchar* _tmp0_;
			gchar* _tmp1_;
			_tmp0_ = g_strconcat (_ ("Waiting for another package manager to quit"), "...", NULL);
			_tmp1_ = _tmp0_;
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ACTION_SIGNAL], 0, sender, _tmp1_);
			_g_free0 (_tmp1_);
		}
		g_mutex_lock (&self->priv->answer_mutex);
		i = 0;
		while (TRUE) {
			gint64 end_time = 0LL;
			gint _tmp2_;
			if (!(!g_cancellable_is_cancelled (cancellable))) {
				break;
			}
			end_time = g_get_monotonic_time () + (200 * G_TIME_SPAN_MILLISECOND);
			g_cond_wait_until (&self->priv->answer_cond, &self->priv->answer_mutex, end_time);
			if (g_mutex_trylock (&self->priv->lockfile_mutex)) {
				success = TRUE;
				break;
			}
			_tmp2_ = i;
			i = _tmp2_ + 1;
			if (i == 1500) {
				g_cancellable_cancel (cancellable);
				if (!quiet) {
					gchar* _tmp3_;
					gchar* _tmp4_;
					_tmp3_ = g_strdup_printf ("%s: %s.", _ ("Transaction cancelled"), _ ("Timeout expired"));
					_tmp4_ = _tmp3_;
					g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ACTION_SIGNAL], 0, sender, _tmp4_);
					_g_free0 (_tmp4_);
				}
			}
		}
		g_mutex_unlock (&self->priv->answer_mutex);
	} else {
		success = TRUE;
	}
	if (waiting) {
		g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_STOP_WAITING_SIGNAL], 0, sender);
	}
	result = success;
	return result;
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		PamacDaemon* self;
		self = _data16_->self;
		_g_free0 (_data16_->sender);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		PamacDaemon* self;
		self = _data17_->_data16_->self;
		_g_object_unref0 (_data17_->cancellable);
		block16_data_unref (_data17_->_data16_);
		_data17_->_data16_ = NULL;
		g_slice_free (Block17Data, _data17_);
	}
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		PamacDaemon* self;
		self = _data18_->_data17_->_data16_->self;
		block17_data_unref (_data18_->_data17_);
		_data18_->_data17_ = NULL;
		g_slice_free (Block18Data, _data18_);
	}
}

static gint
____lambda82_ (Block18Data* _data18_)
{
	Block17Data* _data17_;
	Block16Data* _data16_;
	PamacDaemon* self;
	PamacAlpmUtils* _tmp0_;
	gint result;
	_data17_ = _data18_->_data17_;
	_data16_ = _data17_->_data16_;
	self = _data16_->self;
	_tmp0_ = self->priv->alpm_utils;
	_data18_->success = pamac_alpm_utils_trans_refresh (_tmp0_, (const gchar*) _data16_->sender, _data16_->force);
	result = 0;
	return result;
}

static gpointer
_____lambda82__gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) ____lambda82_ (self));
	block18_data_unref (self);
	return result;
}

static gint
___lambda81_ (Block17Data* _data17_)
{
	Block16Data* _data16_;
	PamacDaemon* self;
	Block18Data* _data18_;
	PamacAlpmUtils* _tmp0_;
	GError* _inner_error0_ = NULL;
	gint result;
	_data16_ = _data17_->_data16_;
	self = _data16_->self;
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->_data17_ = block17_data_ref (_data17_);
	g_atomic_int_inc ((volatile gint *) (&self->priv->running_threads));
	_tmp0_ = self->priv->alpm_utils;
	if (_tmp0_->downloading_updates) {
		PamacAlpmUtils* _tmp1_;
		GCancellable* _tmp2_;
		_tmp1_ = self->priv->alpm_utils;
		_tmp2_ = _tmp1_->cancellable;
		g_cancellable_cancel (_tmp2_);
	}
	_data18_->success = pamac_daemon_wait_for_lock (self, (const gchar*) _data16_->sender, _data17_->cancellable, FALSE);
	if (_data18_->success) {
		{
			GThread* thread = NULL;
			GThread* _tmp3_;
			gint ret = 0;
			GThread* _tmp4_;
			gpointer _tmp5_;
			_tmp3_ = g_thread_try_new ("trans_refresh2", _____lambda82__gthread_func, block18_data_ref (_data18_), &_inner_error0_);
			thread = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp4_ = thread;
			thread = NULL;
			_tmp5_ = g_thread_join (_tmp4_);
			ret = (gint) ((gintptr) _tmp5_);
			if (ret == -1) {
				_data18_->success = FALSE;
			}
			_g_thread_unref0 (thread);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar** _tmp9_;
			gchar** _tmp10_;
			gint _tmp10__length1;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			_tmp8_ = g_strdup (_tmp7_);
			_tmp9_ = g_new0 (gchar*, 1 + 1);
			_tmp9_[0] = _tmp8_;
			_tmp10_ = _tmp9_;
			_tmp10__length1 = 1;
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, (const gchar*) _data16_->sender, "Daemon Error", _tmp10_, (gint) 1);
			_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_TRANS_REFRESH_FINISHED_SIGNAL], 0, (const gchar*) _data16_->sender, FALSE);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp11_ = -1;
			block18_data_unref (_data18_);
			_data18_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp11_;
		}
		g_mutex_unlock (&self->priv->lockfile_mutex);
	}
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_TRANS_REFRESH_FINISHED_SIGNAL], 0, (const gchar*) _data16_->sender, _data18_->success);
	g_atomic_int_dec_and_test ((volatile gint *) (&self->priv->running_threads));
	result = 0;
	block18_data_unref (_data18_);
	_data18_ = NULL;
	return result;
}

static gpointer
____lambda81__gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) ___lambda81_ (self));
	block17_data_unref (self);
	return result;
}

void
pamac_daemon_start_trans_refresh (PamacDaemon* self,
                                  gboolean force,
                                  const char* sender,
                                  GError** error)
{
	Block16Data* _data16_;
	char* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_data16_->force = force;
	_tmp0_ = g_strdup (sender);
	_g_free0 (_data16_->sender);
	_data16_->sender = _tmp0_;
	{
		Block17Data* _data17_;
		GHashTable* _tmp1_;
		GHashTable* _tmp5_;
		gconstpointer _tmp6_;
		GCancellable* _tmp7_;
		GThread* _tmp8_;
		GThread* _tmp9_;
		_data17_ = g_slice_new0 (Block17Data);
		_data17_->_ref_count_ = 1;
		_data17_->_data16_ = block16_data_ref (_data16_);
		_tmp1_ = self->priv->cancellables_table;
		if (!g_hash_table_contains (_tmp1_, (const gchar*) _data16_->sender)) {
			GHashTable* _tmp2_;
			gchar* _tmp3_;
			GCancellable* _tmp4_;
			_tmp2_ = self->priv->cancellables_table;
			_tmp3_ = g_strdup ((gchar*) _data16_->sender);
			_tmp4_ = g_cancellable_new ();
			g_hash_table_insert (_tmp2_, _tmp3_, _tmp4_);
		}
		_tmp5_ = self->priv->cancellables_table;
		_tmp6_ = g_hash_table_lookup (_tmp5_, (const gchar*) _data16_->sender);
		_tmp7_ = _g_object_ref0 ((GCancellable*) _tmp6_);
		_data17_->cancellable = _tmp7_;
		_tmp8_ = g_thread_try_new ("trans_refresh", ____lambda81__gthread_func, block17_data_ref (_data17_), &_inner_error0_);
		_tmp9_ = _tmp8_;
		_g_thread_unref0 (_tmp9_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block17_data_unref (_data17_);
			_data17_ = NULL;
			goto __catch0_g_error;
		}
		block17_data_unref (_data17_);
		_data17_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar** _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		_tmp12_ = g_strdup (_tmp11_);
		_tmp13_ = g_new0 (gchar*, 1 + 1);
		_tmp13_[0] = _tmp12_;
		_tmp14_ = _tmp13_;
		_tmp14__length1 = 1;
		g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, (const gchar*) _data16_->sender, "Daemon Error", _tmp14_, (gint) 1);
		_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
		g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_TRANS_REFRESH_FINISHED_SIGNAL], 0, (const gchar*) _data16_->sender, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block16_data_unref (_data16_);
		_data16_ = NULL;
		return;
	}
	block16_data_unref (_data16_);
	_data16_ = NULL;
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		PamacDaemon* self;
		self = _data19_->self;
		_g_free0 (_data19_->sender);
		_g_object_unref0 (self);
		g_slice_free (Block19Data, _data19_);
	}
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		PamacDaemon* self;
		self = _data20_->_data19_->self;
		_g_object_unref0 (_data20_->cancellable);
		block19_data_unref (_data20_->_data19_);
		_data20_->_data19_ = NULL;
		g_slice_free (Block20Data, _data20_);
	}
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		PamacDaemon* self;
		self = _data21_->_data20_->_data19_->self;
		block20_data_unref (_data21_->_data20_);
		_data21_->_data20_ = NULL;
		g_slice_free (Block21Data, _data21_);
	}
}

static gint
____lambda84_ (Block21Data* _data21_)
{
	Block20Data* _data20_;
	Block19Data* _data19_;
	PamacDaemon* self;
	PamacAlpmUtils* _tmp0_;
	gint result;
	_data20_ = _data21_->_data20_;
	_data19_ = _data20_->_data19_;
	self = _data19_->self;
	_tmp0_ = self->priv->alpm_utils;
	_data21_->success = pamac_alpm_utils_trans_refresh_files (_tmp0_, (const gchar*) _data19_->sender, _data19_->force);
	result = 0;
	return result;
}

static gpointer
_____lambda84__gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) ____lambda84_ (self));
	block21_data_unref (self);
	return result;
}

static gint
___lambda83_ (Block20Data* _data20_)
{
	Block19Data* _data19_;
	PamacDaemon* self;
	Block21Data* _data21_;
	PamacAlpmUtils* _tmp0_;
	GError* _inner_error0_ = NULL;
	gint result;
	_data19_ = _data20_->_data19_;
	self = _data19_->self;
	_data21_ = g_slice_new0 (Block21Data);
	_data21_->_ref_count_ = 1;
	_data21_->_data20_ = block20_data_ref (_data20_);
	g_atomic_int_inc ((volatile gint *) (&self->priv->running_threads));
	_tmp0_ = self->priv->alpm_utils;
	if (_tmp0_->downloading_updates) {
		PamacAlpmUtils* _tmp1_;
		GCancellable* _tmp2_;
		_tmp1_ = self->priv->alpm_utils;
		_tmp2_ = _tmp1_->cancellable;
		g_cancellable_cancel (_tmp2_);
	}
	_data21_->success = pamac_daemon_wait_for_lock (self, (const gchar*) _data19_->sender, _data20_->cancellable, FALSE);
	if (_data21_->success) {
		{
			GThread* thread = NULL;
			GThread* _tmp3_;
			gint ret = 0;
			GThread* _tmp4_;
			gpointer _tmp5_;
			_tmp3_ = g_thread_try_new ("trans_refresh_files2", _____lambda84__gthread_func, block21_data_ref (_data21_), &_inner_error0_);
			thread = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp4_ = thread;
			thread = NULL;
			_tmp5_ = g_thread_join (_tmp4_);
			ret = (gint) ((gintptr) _tmp5_);
			if (ret == -1) {
				_data21_->success = FALSE;
			}
			_g_thread_unref0 (thread);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar** _tmp9_;
			gchar** _tmp10_;
			gint _tmp10__length1;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			_tmp8_ = g_strdup (_tmp7_);
			_tmp9_ = g_new0 (gchar*, 1 + 1);
			_tmp9_[0] = _tmp8_;
			_tmp10_ = _tmp9_;
			_tmp10__length1 = 1;
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, (const gchar*) _data19_->sender, "Daemon Error", _tmp10_, (gint) 1);
			_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_TRANS_REFRESH_FILES_FINISHED_SIGNAL], 0, (const gchar*) _data19_->sender, FALSE);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp11_ = -1;
			block21_data_unref (_data21_);
			_data21_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp11_;
		}
		g_mutex_unlock (&self->priv->lockfile_mutex);
	}
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_TRANS_REFRESH_FILES_FINISHED_SIGNAL], 0, (const gchar*) _data19_->sender, _data21_->success);
	g_atomic_int_dec_and_test ((volatile gint *) (&self->priv->running_threads));
	result = 0;
	block21_data_unref (_data21_);
	_data21_ = NULL;
	return result;
}

static gpointer
____lambda83__gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) ___lambda83_ (self));
	block20_data_unref (self);
	return result;
}

void
pamac_daemon_start_trans_refresh_files (PamacDaemon* self,
                                        gboolean force,
                                        const char* sender,
                                        GError** error)
{
	Block19Data* _data19_;
	char* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	_data19_ = g_slice_new0 (Block19Data);
	_data19_->_ref_count_ = 1;
	_data19_->self = g_object_ref (self);
	_data19_->force = force;
	_tmp0_ = g_strdup (sender);
	_g_free0 (_data19_->sender);
	_data19_->sender = _tmp0_;
	{
		Block20Data* _data20_;
		GHashTable* _tmp1_;
		GHashTable* _tmp5_;
		gconstpointer _tmp6_;
		GCancellable* _tmp7_;
		GThread* _tmp8_;
		GThread* _tmp9_;
		_data20_ = g_slice_new0 (Block20Data);
		_data20_->_ref_count_ = 1;
		_data20_->_data19_ = block19_data_ref (_data19_);
		_tmp1_ = self->priv->cancellables_table;
		if (!g_hash_table_contains (_tmp1_, (const gchar*) _data19_->sender)) {
			GHashTable* _tmp2_;
			gchar* _tmp3_;
			GCancellable* _tmp4_;
			_tmp2_ = self->priv->cancellables_table;
			_tmp3_ = g_strdup ((gchar*) _data19_->sender);
			_tmp4_ = g_cancellable_new ();
			g_hash_table_insert (_tmp2_, _tmp3_, _tmp4_);
		}
		_tmp5_ = self->priv->cancellables_table;
		_tmp6_ = g_hash_table_lookup (_tmp5_, (const gchar*) _data19_->sender);
		_tmp7_ = _g_object_ref0 ((GCancellable*) _tmp6_);
		_data20_->cancellable = _tmp7_;
		_tmp8_ = g_thread_try_new ("trans_refresh_files", ____lambda83__gthread_func, block20_data_ref (_data20_), &_inner_error0_);
		_tmp9_ = _tmp8_;
		_g_thread_unref0 (_tmp9_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block20_data_unref (_data20_);
			_data20_ = NULL;
			goto __catch0_g_error;
		}
		block20_data_unref (_data20_);
		_data20_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar** _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		_tmp12_ = g_strdup (_tmp11_);
		_tmp13_ = g_new0 (gchar*, 1 + 1);
		_tmp13_[0] = _tmp12_;
		_tmp14_ = _tmp13_;
		_tmp14__length1 = 1;
		g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, (const gchar*) _data19_->sender, "Daemon Error", _tmp14_, (gint) 1);
		_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
		g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_TRANS_REFRESH_FILES_FINISHED_SIGNAL], 0, (const gchar*) _data19_->sender, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block19_data_unref (_data19_);
		_data19_ = NULL;
		return;
	}
	block19_data_unref (_data19_);
	_data19_ = NULL;
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		PamacDaemon* self;
		self = _data22_->self;
		_g_free0 (_data22_->sender);
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		PamacDaemon* self;
		self = _data23_->_data22_->self;
		_g_object_unref0 (_data23_->cancellable);
		block22_data_unref (_data23_->_data22_);
		_data23_->_data22_ = NULL;
		g_slice_free (Block23Data, _data23_);
	}
}

static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		PamacDaemon* self;
		self = _data24_->_data23_->_data22_->self;
		block23_data_unref (_data24_->_data23_);
		_data24_->_data23_ = NULL;
		g_slice_free (Block24Data, _data24_);
	}
}

static gint
____lambda86_ (Block24Data* _data24_)
{
	Block23Data* _data23_;
	Block22Data* _data22_;
	PamacDaemon* self;
	PamacAlpmUtils* _tmp0_;
	gint result;
	_data23_ = _data24_->_data23_;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	_tmp0_ = self->priv->alpm_utils;
	_data24_->success = pamac_alpm_utils_trans_refresh_aur (_tmp0_, (const gchar*) _data22_->sender, _data22_->force);
	result = 0;
	return result;
}

static gpointer
_____lambda86__gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) ____lambda86_ (self));
	block24_data_unref (self);
	return result;
}

static gint
___lambda85_ (Block23Data* _data23_)
{
	Block22Data* _data22_;
	PamacDaemon* self;
	Block24Data* _data24_;
	PamacAlpmUtils* _tmp0_;
	GError* _inner_error0_ = NULL;
	gint result;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	_data24_ = g_slice_new0 (Block24Data);
	_data24_->_ref_count_ = 1;
	_data24_->_data23_ = block23_data_ref (_data23_);
	g_atomic_int_inc ((volatile gint *) (&self->priv->running_threads));
	_tmp0_ = self->priv->alpm_utils;
	if (_tmp0_->downloading_updates) {
		PamacAlpmUtils* _tmp1_;
		GCancellable* _tmp2_;
		_tmp1_ = self->priv->alpm_utils;
		_tmp2_ = _tmp1_->cancellable;
		g_cancellable_cancel (_tmp2_);
	}
	_data24_->success = pamac_daemon_wait_for_lock (self, (const gchar*) _data22_->sender, _data23_->cancellable, FALSE);
	if (_data24_->success) {
		{
			GThread* thread = NULL;
			GThread* _tmp3_;
			gint ret = 0;
			GThread* _tmp4_;
			gpointer _tmp5_;
			_tmp3_ = g_thread_try_new ("trans_refresh_aur2", _____lambda86__gthread_func, block24_data_ref (_data24_), &_inner_error0_);
			thread = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp4_ = thread;
			thread = NULL;
			_tmp5_ = g_thread_join (_tmp4_);
			ret = (gint) ((gintptr) _tmp5_);
			if (ret == -1) {
				_data24_->success = FALSE;
			}
			_g_thread_unref0 (thread);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar** _tmp9_;
			gchar** _tmp10_;
			gint _tmp10__length1;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			_tmp8_ = g_strdup (_tmp7_);
			_tmp9_ = g_new0 (gchar*, 1 + 1);
			_tmp9_[0] = _tmp8_;
			_tmp10_ = _tmp9_;
			_tmp10__length1 = 1;
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, (const gchar*) _data22_->sender, "Daemon Error", _tmp10_, (gint) 1);
			_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_TRANS_REFRESH_AUR_FINISHED_SIGNAL], 0, (const gchar*) _data22_->sender, FALSE);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp11_ = -1;
			block24_data_unref (_data24_);
			_data24_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp11_;
		}
		g_mutex_unlock (&self->priv->lockfile_mutex);
	}
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_TRANS_REFRESH_AUR_FINISHED_SIGNAL], 0, (const gchar*) _data22_->sender, _data24_->success);
	g_atomic_int_dec_and_test ((volatile gint *) (&self->priv->running_threads));
	result = 0;
	block24_data_unref (_data24_);
	_data24_ = NULL;
	return result;
}

static gpointer
____lambda85__gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) ___lambda85_ (self));
	block23_data_unref (self);
	return result;
}

void
pamac_daemon_start_trans_refresh_aur (PamacDaemon* self,
                                      gboolean force,
                                      const char* sender,
                                      GError** error)
{
	Block22Data* _data22_;
	char* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->self = g_object_ref (self);
	_data22_->force = force;
	_tmp0_ = g_strdup (sender);
	_g_free0 (_data22_->sender);
	_data22_->sender = _tmp0_;
	{
		Block23Data* _data23_;
		GHashTable* _tmp1_;
		GHashTable* _tmp5_;
		gconstpointer _tmp6_;
		GCancellable* _tmp7_;
		GThread* _tmp8_;
		GThread* _tmp9_;
		_data23_ = g_slice_new0 (Block23Data);
		_data23_->_ref_count_ = 1;
		_data23_->_data22_ = block22_data_ref (_data22_);
		_tmp1_ = self->priv->cancellables_table;
		if (!g_hash_table_contains (_tmp1_, (const gchar*) _data22_->sender)) {
			GHashTable* _tmp2_;
			gchar* _tmp3_;
			GCancellable* _tmp4_;
			_tmp2_ = self->priv->cancellables_table;
			_tmp3_ = g_strdup ((gchar*) _data22_->sender);
			_tmp4_ = g_cancellable_new ();
			g_hash_table_insert (_tmp2_, _tmp3_, _tmp4_);
		}
		_tmp5_ = self->priv->cancellables_table;
		_tmp6_ = g_hash_table_lookup (_tmp5_, (const gchar*) _data22_->sender);
		_tmp7_ = _g_object_ref0 ((GCancellable*) _tmp6_);
		_data23_->cancellable = _tmp7_;
		_tmp8_ = g_thread_try_new ("trans_refresh_aur", ____lambda85__gthread_func, block23_data_ref (_data23_), &_inner_error0_);
		_tmp9_ = _tmp8_;
		_g_thread_unref0 (_tmp9_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block23_data_unref (_data23_);
			_data23_ = NULL;
			goto __catch0_g_error;
		}
		block23_data_unref (_data23_);
		_data23_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar** _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		_tmp12_ = g_strdup (_tmp11_);
		_tmp13_ = g_new0 (gchar*, 1 + 1);
		_tmp13_[0] = _tmp12_;
		_tmp14_ = _tmp13_;
		_tmp14__length1 = 1;
		g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, (const gchar*) _data22_->sender, "Daemon Error", _tmp14_, (gint) 1);
		_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
		g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_TRANS_REFRESH_AUR_FINISHED_SIGNAL], 0, (const gchar*) _data22_->sender, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block22_data_unref (_data22_);
		_data22_ = NULL;
		return;
	}
	block22_data_unref (_data22_);
	_data22_ = NULL;
}

static Block25Data*
block25_data_ref (Block25Data* _data25_)
{
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}

static void
block25_data_unref (void * _userdata_)
{
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		PamacDaemon* self;
		self = _data25_->self;
		_data25_->overwrite_files_copy = (_vala_array_free (_data25_->overwrite_files_copy, _data25_->overwrite_files_copy_length1, (GDestroyNotify) g_free), NULL);
		_data25_->ignorepkgs_copy = (_vala_array_free (_data25_->ignorepkgs_copy, _data25_->ignorepkgs_copy_length1, (GDestroyNotify) g_free), NULL);
		_data25_->to_install_as_dep_copy = (_vala_array_free (_data25_->to_install_as_dep_copy, _data25_->to_install_as_dep_copy_length1, (GDestroyNotify) g_free), NULL);
		_data25_->to_load_remote_copy = (_vala_array_free (_data25_->to_load_remote_copy, _data25_->to_load_remote_copy_length1, (GDestroyNotify) g_free), NULL);
		_data25_->to_load_local_copy = (_vala_array_free (_data25_->to_load_local_copy, _data25_->to_load_local_copy_length1, (GDestroyNotify) g_free), NULL);
		_data25_->to_remove_copy = (_vala_array_free (_data25_->to_remove_copy, _data25_->to_remove_copy_length1, (GDestroyNotify) g_free), NULL);
		_data25_->to_install_copy = (_vala_array_free (_data25_->to_install_copy, _data25_->to_install_copy_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data25_->sender);
		_g_object_unref0 (self);
		g_slice_free (Block25Data, _data25_);
	}
}

static gchar**
_vala_array_dup4 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup5 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup6 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup7 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup8 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup9 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup10 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static Block26Data*
block26_data_ref (Block26Data* _data26_)
{
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}

static void
block26_data_unref (void * _userdata_)
{
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		PamacDaemon* self;
		self = _data26_->_data25_->self;
		_g_object_unref0 (_data26_->cancellable);
		block25_data_unref (_data26_->_data25_);
		_data26_->_data25_ = NULL;
		g_slice_free (Block26Data, _data26_);
	}
}

static Block27Data*
block27_data_ref (Block27Data* _data27_)
{
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}

static void
block27_data_unref (void * _userdata_)
{
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		PamacDaemon* self;
		self = _data27_->_data26_->_data25_->self;
		block26_data_unref (_data27_->_data26_);
		_data27_->_data26_ = NULL;
		g_slice_free (Block27Data, _data27_);
	}
}

static gint
____lambda89_ (Block27Data* _data27_)
{
	Block26Data* _data26_;
	Block25Data* _data25_;
	PamacDaemon* self;
	PamacAlpmUtils* _tmp0_;
	gint result;
	_data26_ = _data27_->_data26_;
	_data25_ = _data26_->_data25_;
	self = _data25_->self;
	_tmp0_ = self->priv->alpm_utils;
	_data27_->success = pamac_alpm_utils_trans_run (_tmp0_, (const gchar*) _data25_->sender, _data25_->sysupgrade, _data25_->enable_downgrade, _data25_->simple_install, _data25_->keep_built_pkgs, _data25_->trans_flags, _data25_->to_install_copy, (gint) _data25_->to_install_copy_length1, _data25_->to_remove_copy, (gint) _data25_->to_remove_copy_length1, _data25_->to_load_local_copy, (gint) _data25_->to_load_local_copy_length1, _data25_->to_load_remote_copy, (gint) _data25_->to_load_remote_copy_length1, _data25_->to_install_as_dep_copy, (gint) _data25_->to_install_as_dep_copy_length1, _data25_->ignorepkgs_copy, (gint) _data25_->ignorepkgs_copy_length1, _data25_->overwrite_files_copy, (gint) _data25_->overwrite_files_copy_length1);
	result = 0;
	return result;
}

static gpointer
_____lambda89__gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) ____lambda89_ (self));
	block27_data_unref (self);
	return result;
}

static gint
____lambda88_ (Block26Data* _data26_)
{
	Block25Data* _data25_;
	PamacDaemon* self;
	Block27Data* _data27_;
	PamacAlpmUtils* _tmp0_;
	GCancellable* _tmp3_;
	GError* _inner_error0_ = NULL;
	gint result;
	_data25_ = _data26_->_data25_;
	self = _data25_->self;
	_data27_ = g_slice_new0 (Block27Data);
	_data27_->_ref_count_ = 1;
	_data27_->_data26_ = block26_data_ref (_data26_);
	g_atomic_int_inc ((volatile gint *) (&self->priv->running_threads));
	_tmp0_ = self->priv->alpm_utils;
	if (_tmp0_->downloading_updates) {
		PamacAlpmUtils* _tmp1_;
		GCancellable* _tmp2_;
		_tmp1_ = self->priv->alpm_utils;
		_tmp2_ = _tmp1_->cancellable;
		g_cancellable_cancel (_tmp2_);
	}
	_tmp3_ = _data26_->cancellable;
	_data27_->success = pamac_daemon_wait_for_lock (self, (const gchar*) _data25_->sender, _tmp3_, FALSE);
	if (_data27_->success) {
		{
			GThread* thread = NULL;
			GThread* _tmp4_;
			GThread* _tmp5_;
			_tmp4_ = g_thread_try_new ("trans_run2", _____lambda89__gthread_func, block27_data_ref (_data27_), &_inner_error0_);
			thread = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = thread;
			thread = NULL;
			g_thread_join (_tmp5_);
			_g_thread_unref0 (thread);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar** _tmp9_;
			gchar** _tmp10_;
			gint _tmp10__length1;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			_tmp8_ = g_strdup (_tmp7_);
			_tmp9_ = g_new0 (gchar*, 1 + 1);
			_tmp9_[0] = _tmp8_;
			_tmp10_ = _tmp9_;
			_tmp10__length1 = 1;
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, (const gchar*) _data25_->sender, "Daemon Error", _tmp10_, (gint) 1);
			_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_TRANS_RUN_FINISHED_SIGNAL], 0, (const gchar*) _data25_->sender, FALSE);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp11_ = -1;
			block27_data_unref (_data27_);
			_data27_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp11_;
		}
		g_mutex_unlock (&self->priv->lockfile_mutex);
	}
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_TRANS_RUN_FINISHED_SIGNAL], 0, (const gchar*) _data25_->sender, _data27_->success);
	g_atomic_int_dec_and_test ((volatile gint *) (&self->priv->running_threads));
	result = 0;
	block27_data_unref (_data27_);
	_data27_ = NULL;
	return result;
}

static gpointer
_____lambda88__gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) ____lambda88_ (self));
	block26_data_unref (self);
	return result;
}

static void
__lambda87_ (Block25Data* _data25_,
             GObject* obj,
             GAsyncResult* res)
{
	PamacDaemon* self;
	gboolean authorized = FALSE;
	GError* _inner_error0_ = NULL;
	self = _data25_->self;
	g_return_if_fail (res != NULL);
	authorized = pamac_daemon_check_authorization_finish (self, res);
	if (authorized) {
		{
			Block26Data* _data26_;
			GHashTable* _tmp0_;
			GHashTable* _tmp4_;
			gconstpointer _tmp5_;
			GCancellable* _tmp6_;
			GThread* _tmp7_;
			GThread* _tmp8_;
			_data26_ = g_slice_new0 (Block26Data);
			_data26_->_ref_count_ = 1;
			_data26_->_data25_ = block25_data_ref (_data25_);
			_tmp0_ = self->priv->cancellables_table;
			if (!g_hash_table_contains (_tmp0_, (const gchar*) _data25_->sender)) {
				GHashTable* _tmp1_;
				gchar* _tmp2_;
				GCancellable* _tmp3_;
				_tmp1_ = self->priv->cancellables_table;
				_tmp2_ = g_strdup ((gchar*) _data25_->sender);
				_tmp3_ = g_cancellable_new ();
				g_hash_table_insert (_tmp1_, _tmp2_, _tmp3_);
			}
			_tmp4_ = self->priv->cancellables_table;
			_tmp5_ = g_hash_table_lookup (_tmp4_, (const gchar*) _data25_->sender);
			_tmp6_ = _g_object_ref0 ((GCancellable*) _tmp5_);
			_data26_->cancellable = _tmp6_;
			_tmp7_ = g_thread_try_new ("trans_run", _____lambda88__gthread_func, block26_data_ref (_data26_), &_inner_error0_);
			_tmp8_ = _tmp7_;
			_g_thread_unref0 (_tmp8_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				block26_data_unref (_data26_);
				_data26_ = NULL;
				goto __catch0_g_error;
			}
			block26_data_unref (_data26_);
			_data26_ = NULL;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar** _tmp12_;
			gchar** _tmp13_;
			gint _tmp13__length1;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			_tmp11_ = g_strdup (_tmp10_);
			_tmp12_ = g_new0 (gchar*, 1 + 1);
			_tmp12_[0] = _tmp11_;
			_tmp13_ = _tmp12_;
			_tmp13__length1 = 1;
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, (const gchar*) _data25_->sender, "Daemon Error", _tmp13_, (gint) 1);
			_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_TRANS_RUN_FINISHED_SIGNAL], 0, (const gchar*) _data25_->sender, FALSE);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_TRANS_RUN_FINISHED_SIGNAL], 0, (const gchar*) _data25_->sender, FALSE);
	}
}

static void
___lambda87__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda87_ (self, source_object, res);
	block25_data_unref (self);
}

void
pamac_daemon_start_trans_run (PamacDaemon* self,
                              gboolean sysupgrade,
                              gboolean enable_downgrade,
                              gboolean simple_install,
                              gboolean keep_built_pkgs,
                              gint trans_flags,
                              gchar** to_install,
                              gint to_install_length1,
                              gchar** to_remove,
                              gint to_remove_length1,
                              gchar** to_load_local,
                              gint to_load_local_length1,
                              gchar** to_load_remote,
                              gint to_load_remote_length1,
                              gchar** to_install_as_dep,
                              gint to_install_as_dep_length1,
                              gchar** ignorepkgs,
                              gint ignorepkgs_length1,
                              gchar** overwrite_files,
                              gint overwrite_files_length1,
                              const char* sender,
                              GError** error)
{
	Block25Data* _data25_;
	char* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	_data25_ = g_slice_new0 (Block25Data);
	_data25_->_ref_count_ = 1;
	_data25_->self = g_object_ref (self);
	_data25_->sysupgrade = sysupgrade;
	_data25_->enable_downgrade = enable_downgrade;
	_data25_->simple_install = simple_install;
	_data25_->keep_built_pkgs = keep_built_pkgs;
	_data25_->trans_flags = trans_flags;
	_tmp0_ = g_strdup (sender);
	_g_free0 (_data25_->sender);
	_data25_->sender = _tmp0_;
	_tmp1_ = (to_install != NULL) ? _vala_array_dup4 (to_install, to_install_length1) : to_install;
	_tmp1__length1 = to_install_length1;
	_data25_->to_install_copy = _tmp1_;
	_data25_->to_install_copy_length1 = _tmp1__length1;
	_data25_->_to_install_copy_size_ = _data25_->to_install_copy_length1;
	_tmp2_ = (to_remove != NULL) ? _vala_array_dup5 (to_remove, to_remove_length1) : to_remove;
	_tmp2__length1 = to_remove_length1;
	_data25_->to_remove_copy = _tmp2_;
	_data25_->to_remove_copy_length1 = _tmp2__length1;
	_data25_->_to_remove_copy_size_ = _data25_->to_remove_copy_length1;
	_tmp3_ = (to_load_local != NULL) ? _vala_array_dup6 (to_load_local, to_load_local_length1) : to_load_local;
	_tmp3__length1 = to_load_local_length1;
	_data25_->to_load_local_copy = _tmp3_;
	_data25_->to_load_local_copy_length1 = _tmp3__length1;
	_data25_->_to_load_local_copy_size_ = _data25_->to_load_local_copy_length1;
	_tmp4_ = (to_load_remote != NULL) ? _vala_array_dup7 (to_load_remote, to_load_remote_length1) : to_load_remote;
	_tmp4__length1 = to_load_remote_length1;
	_data25_->to_load_remote_copy = _tmp4_;
	_data25_->to_load_remote_copy_length1 = _tmp4__length1;
	_data25_->_to_load_remote_copy_size_ = _data25_->to_load_remote_copy_length1;
	_tmp5_ = (to_install_as_dep != NULL) ? _vala_array_dup8 (to_install_as_dep, to_install_as_dep_length1) : to_install_as_dep;
	_tmp5__length1 = to_install_as_dep_length1;
	_data25_->to_install_as_dep_copy = _tmp5_;
	_data25_->to_install_as_dep_copy_length1 = _tmp5__length1;
	_data25_->_to_install_as_dep_copy_size_ = _data25_->to_install_as_dep_copy_length1;
	_tmp6_ = (ignorepkgs != NULL) ? _vala_array_dup9 (ignorepkgs, ignorepkgs_length1) : ignorepkgs;
	_tmp6__length1 = ignorepkgs_length1;
	_data25_->ignorepkgs_copy = _tmp6_;
	_data25_->ignorepkgs_copy_length1 = _tmp6__length1;
	_data25_->_ignorepkgs_copy_size_ = _data25_->ignorepkgs_copy_length1;
	_tmp7_ = (overwrite_files != NULL) ? _vala_array_dup10 (overwrite_files, overwrite_files_length1) : overwrite_files;
	_tmp7__length1 = overwrite_files_length1;
	_data25_->overwrite_files_copy = _tmp7_;
	_data25_->overwrite_files_copy_length1 = _tmp7__length1;
	_data25_->_overwrite_files_copy_size_ = _data25_->overwrite_files_copy_length1;
	pamac_daemon_check_authorization (self, _data25_->sender, ___lambda87__gasync_ready_callback, block25_data_ref (_data25_));
	block25_data_unref (_data25_);
	_data25_ = NULL;
}

static Block28Data*
block28_data_ref (Block28Data* _data28_)
{
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}

static void
block28_data_unref (void * _userdata_)
{
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		PamacDaemon* self;
		self = _data28_->self;
		_data28_->to_remove_copy = (_vala_array_free (_data28_->to_remove_copy, _data28_->to_remove_copy_length1, (GDestroyNotify) g_free), NULL);
		_data28_->to_install_copy = (_vala_array_free (_data28_->to_install_copy, _data28_->to_install_copy_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data28_->sender);
		_g_object_unref0 (self);
		g_slice_free (Block28Data, _data28_);
	}
}

static gboolean
___lambda90_ (Block28Data* _data28_)
{
	PamacDaemon* self;
	gboolean result;
	self = _data28_->self;
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_SNAP_TRANS_RUN_FINISHED_SIGNAL], 0, (const gchar*) _data28_->sender, FALSE);
	result = FALSE;
	return result;
}

static gboolean
____lambda90__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda90_ (self);
	return result;
}

static gchar**
_vala_array_dup11 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup12 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gint
____lambda92_ (Block28Data* _data28_)
{
	PamacDaemon* self;
	gboolean success = FALSE;
	PamacSnapPlugin* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint result;
	self = _data28_->self;
	g_atomic_int_inc ((volatile gint *) (&self->priv->running_threads));
	_tmp0_ = self->priv->snap_plugin;
	_tmp1_ = _data28_->to_install_copy;
	_tmp1__length1 = _data28_->to_install_copy_length1;
	_tmp2_ = _data28_->to_remove_copy;
	_tmp2__length1 = _data28_->to_remove_copy_length1;
	success = pamac_snap_plugin_trans_run (_tmp0_, (const gchar*) _data28_->sender, _tmp1_, (gint) _tmp1__length1, _tmp2_, (gint) _tmp2__length1);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_SNAP_TRANS_RUN_FINISHED_SIGNAL], 0, (const gchar*) _data28_->sender, success);
	g_atomic_int_dec_and_test ((volatile gint *) (&self->priv->running_threads));
	result = 0;
	return result;
}

static gpointer
_____lambda92__gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) ____lambda92_ (self));
	block28_data_unref (self);
	return result;
}

static void
__lambda91_ (Block28Data* _data28_,
             GObject* obj,
             GAsyncResult* res)
{
	PamacDaemon* self;
	gboolean authorized = FALSE;
	GError* _inner_error0_ = NULL;
	self = _data28_->self;
	g_return_if_fail (res != NULL);
	authorized = pamac_daemon_check_authorization_finish (self, res);
	if (authorized) {
		{
			GThread* _tmp0_;
			GThread* _tmp1_;
			_tmp0_ = g_thread_try_new ("snap_trans_run", _____lambda92__gthread_func, block28_data_ref (_data28_), &_inner_error0_);
			_tmp1_ = _tmp0_;
			_g_thread_unref0 (_tmp1_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar** _tmp5_;
			gchar** _tmp6_;
			gint _tmp6__length1;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			_tmp4_ = g_strdup (_tmp3_);
			_tmp5_ = g_new0 (gchar*, 1 + 1);
			_tmp5_[0] = _tmp4_;
			_tmp6_ = _tmp5_;
			_tmp6__length1 = 1;
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, (const gchar*) _data28_->sender, "Daemon Error", _tmp6_, (gint) 1);
			_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_SNAP_TRANS_RUN_FINISHED_SIGNAL], 0, (const gchar*) _data28_->sender, FALSE);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_SNAP_TRANS_RUN_FINISHED_SIGNAL], 0, (const gchar*) _data28_->sender, FALSE);
	}
}

static void
___lambda91__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda91_ (self, source_object, res);
	block28_data_unref (self);
}

void
pamac_daemon_start_snap_trans_run (PamacDaemon* self,
                                   gchar** to_install,
                                   gint to_install_length1,
                                   gchar** to_remove,
                                   gint to_remove_length1,
                                   const char* sender,
                                   GError** error)
{
	Block28Data* _data28_;
	char* _tmp0_;
	PamacConfig* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	_data28_ = g_slice_new0 (Block28Data);
	_data28_->_ref_count_ = 1;
	_data28_->self = g_object_ref (self);
	_tmp0_ = g_strdup (sender);
	_g_free0 (_data28_->sender);
	_data28_->sender = _tmp0_;
	_tmp1_ = self->priv->config;
	_tmp2_ = pamac_config_get_enable_snap (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda90__gsource_func, block28_data_ref (_data28_), block28_data_unref);
		block28_data_unref (_data28_);
		_data28_ = NULL;
		return;
	}
	_tmp4_ = (to_install != NULL) ? _vala_array_dup11 (to_install, to_install_length1) : to_install;
	_tmp4__length1 = to_install_length1;
	_data28_->to_install_copy = _tmp4_;
	_data28_->to_install_copy_length1 = _tmp4__length1;
	_data28_->_to_install_copy_size_ = _data28_->to_install_copy_length1;
	_tmp5_ = (to_remove != NULL) ? _vala_array_dup12 (to_remove, to_remove_length1) : to_remove;
	_tmp5__length1 = to_remove_length1;
	_data28_->to_remove_copy = _tmp5_;
	_data28_->to_remove_copy_length1 = _tmp5__length1;
	_data28_->_to_remove_copy_size_ = _data28_->to_remove_copy_length1;
	pamac_daemon_check_authorization (self, _data28_->sender, ___lambda91__gasync_ready_callback, block28_data_ref (_data28_));
	block28_data_unref (_data28_);
	_data28_ = NULL;
}

static Block29Data*
block29_data_ref (Block29Data* _data29_)
{
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}

static void
block29_data_unref (void * _userdata_)
{
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		PamacDaemon* self;
		self = _data29_->self;
		_g_free0 (_data29_->snap_name);
		_g_free0 (_data29_->snap_channel);
		_g_free0 (_data29_->sender);
		_g_object_unref0 (self);
		g_slice_free (Block29Data, _data29_);
	}
}

static gboolean
___lambda93_ (Block29Data* _data29_)
{
	PamacDaemon* self;
	gboolean result;
	self = _data29_->self;
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_SNAP_SWITCH_CHANNEL_FINISHED_SIGNAL], 0, (const gchar*) _data29_->sender, FALSE);
	result = FALSE;
	return result;
}

static gboolean
____lambda93__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda93_ (self);
	return result;
}

static gint
___lambda94_ (Block29Data* _data29_)
{
	PamacDaemon* self;
	gboolean success = FALSE;
	PamacSnapPlugin* _tmp0_;
	gint result;
	self = _data29_->self;
	g_atomic_int_inc ((volatile gint *) (&self->priv->running_threads));
	_tmp0_ = self->priv->snap_plugin;
	success = pamac_snap_plugin_switch_channel (_tmp0_, (const gchar*) _data29_->sender, _data29_->snap_name, _data29_->snap_channel);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_SNAP_SWITCH_CHANNEL_FINISHED_SIGNAL], 0, (const gchar*) _data29_->sender, success);
	g_atomic_int_dec_and_test ((volatile gint *) (&self->priv->running_threads));
	result = 0;
	return result;
}

static gpointer
____lambda94__gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) ___lambda94_ (self));
	block29_data_unref (self);
	return result;
}

void
pamac_daemon_start_snap_switch_channel (PamacDaemon* self,
                                        const gchar* snap_name,
                                        const gchar* snap_channel,
                                        const char* sender,
                                        GError** error)
{
	Block29Data* _data29_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	char* _tmp2_;
	PamacConfig* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (snap_name != NULL);
	g_return_if_fail (snap_channel != NULL);
	g_return_if_fail (sender != NULL);
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_data29_->self = g_object_ref (self);
	_tmp0_ = g_strdup (snap_name);
	_g_free0 (_data29_->snap_name);
	_data29_->snap_name = _tmp0_;
	_tmp1_ = g_strdup (snap_channel);
	_g_free0 (_data29_->snap_channel);
	_data29_->snap_channel = _tmp1_;
	_tmp2_ = g_strdup (sender);
	_g_free0 (_data29_->sender);
	_data29_->sender = _tmp2_;
	_tmp3_ = self->priv->config;
	_tmp4_ = pamac_config_get_enable_snap (_tmp3_);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda93__gsource_func, block29_data_ref (_data29_), block29_data_unref);
		block29_data_unref (_data29_);
		_data29_ = NULL;
		return;
	}
	{
		GThread* _tmp6_;
		GThread* _tmp7_;
		_tmp6_ = g_thread_try_new ("snap_switch_channel", ____lambda94__gthread_func, block29_data_ref (_data29_), &_inner_error0_);
		_tmp7_ = _tmp6_;
		_g_thread_unref0 (_tmp7_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar** _tmp11_;
		gchar** _tmp12_;
		gint _tmp12__length1;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		_tmp10_ = g_strdup (_tmp9_);
		_tmp11_ = g_new0 (gchar*, 1 + 1);
		_tmp11_[0] = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp12__length1 = 1;
		g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, (const gchar*) _data29_->sender, "Daemon Error", _tmp12_, (gint) 1);
		_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
		g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_SNAP_SWITCH_CHANNEL_FINISHED_SIGNAL], 0, (const gchar*) _data29_->sender, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block29_data_unref (_data29_);
		_data29_ = NULL;
		return;
	}
	block29_data_unref (_data29_);
	_data29_ = NULL;
}

static Block30Data*
block30_data_ref (Block30Data* _data30_)
{
	g_atomic_int_inc (&_data30_->_ref_count_);
	return _data30_;
}

static void
block30_data_unref (void * _userdata_)
{
	Block30Data* _data30_;
	_data30_ = (Block30Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
		PamacDaemon* self;
		self = _data30_->self;
		_data30_->to_upgrade_copy = (_vala_array_free (_data30_->to_upgrade_copy, _data30_->to_upgrade_copy_length1, (GDestroyNotify) g_free), NULL);
		_data30_->to_remove_copy = (_vala_array_free (_data30_->to_remove_copy, _data30_->to_remove_copy_length1, (GDestroyNotify) g_free), NULL);
		_data30_->to_install_copy = (_vala_array_free (_data30_->to_install_copy, _data30_->to_install_copy_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data30_->sender);
		_g_object_unref0 (self);
		g_slice_free (Block30Data, _data30_);
	}
}

static gboolean
___lambda95_ (Block30Data* _data30_)
{
	PamacDaemon* self;
	gboolean result;
	self = _data30_->self;
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_FLATPAK_TRANS_RUN_FINISHED_SIGNAL], 0, (const gchar*) _data30_->sender, FALSE);
	result = FALSE;
	return result;
}

static gboolean
____lambda95__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda95_ (self);
	return result;
}

static gchar**
_vala_array_dup13 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup14 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup15 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gint
____lambda97_ (Block30Data* _data30_)
{
	PamacDaemon* self;
	gboolean success = FALSE;
	PamacFlatpakPlugin* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint result;
	self = _data30_->self;
	g_atomic_int_inc ((volatile gint *) (&self->priv->running_threads));
	_tmp0_ = self->priv->flatpak_plugin;
	_tmp1_ = _data30_->to_install_copy;
	_tmp1__length1 = _data30_->to_install_copy_length1;
	_tmp2_ = _data30_->to_remove_copy;
	_tmp2__length1 = _data30_->to_remove_copy_length1;
	_tmp3_ = _data30_->to_upgrade_copy;
	_tmp3__length1 = _data30_->to_upgrade_copy_length1;
	success = pamac_flatpak_plugin_trans_run (_tmp0_, (const gchar*) _data30_->sender, _tmp1_, (gint) _tmp1__length1, _tmp2_, (gint) _tmp2__length1, _tmp3_, (gint) _tmp3__length1);
	g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_FLATPAK_TRANS_RUN_FINISHED_SIGNAL], 0, (const gchar*) _data30_->sender, success);
	g_atomic_int_dec_and_test ((volatile gint *) (&self->priv->running_threads));
	result = 0;
	return result;
}

static gpointer
_____lambda97__gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) ____lambda97_ (self));
	block30_data_unref (self);
	return result;
}

static void
__lambda96_ (Block30Data* _data30_,
             GObject* obj,
             GAsyncResult* res)
{
	PamacDaemon* self;
	gboolean authorized = FALSE;
	GError* _inner_error0_ = NULL;
	self = _data30_->self;
	g_return_if_fail (res != NULL);
	authorized = pamac_daemon_check_authorization_finish (self, res);
	if (authorized) {
		{
			GThread* _tmp0_;
			GThread* _tmp1_;
			_tmp0_ = g_thread_try_new ("flatpak_trans_run", _____lambda97__gthread_func, block30_data_ref (_data30_), &_inner_error0_);
			_tmp1_ = _tmp0_;
			_g_thread_unref0 (_tmp1_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar** _tmp5_;
			gchar** _tmp6_;
			gint _tmp6__length1;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			_tmp4_ = g_strdup (_tmp3_);
			_tmp5_ = g_new0 (gchar*, 1 + 1);
			_tmp5_[0] = _tmp4_;
			_tmp6_ = _tmp5_;
			_tmp6__length1 = 1;
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL], 0, (const gchar*) _data30_->sender, "Daemon Error", _tmp6_, (gint) 1);
			_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
			g_signal_emit (self, pamac_daemon_signals[PAMAC_DAEMON_FLATPAK_TRANS_RUN_FINISHED_SIGNAL], 0, (const gchar*) _data30_->sender, FALSE);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
___lambda96__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda96_ (self, source_object, res);
	block30_data_unref (self);
}

void
pamac_daemon_start_flatpak_trans_run (PamacDaemon* self,
                                      gchar** to_install,
                                      gint to_install_length1,
                                      gchar** to_remove,
                                      gint to_remove_length1,
                                      gchar** to_upgrade,
                                      gint to_upgrade_length1,
                                      const char* sender,
                                      GError** error)
{
	Block30Data* _data30_;
	char* _tmp0_;
	PamacConfig* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	_data30_ = g_slice_new0 (Block30Data);
	_data30_->_ref_count_ = 1;
	_data30_->self = g_object_ref (self);
	_tmp0_ = g_strdup (sender);
	_g_free0 (_data30_->sender);
	_data30_->sender = _tmp0_;
	_tmp1_ = self->priv->config;
	_tmp2_ = pamac_config_get_enable_flatpak (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda95__gsource_func, block30_data_ref (_data30_), block30_data_unref);
		block30_data_unref (_data30_);
		_data30_ = NULL;
		return;
	}
	_tmp4_ = (to_install != NULL) ? _vala_array_dup13 (to_install, to_install_length1) : to_install;
	_tmp4__length1 = to_install_length1;
	_data30_->to_install_copy = _tmp4_;
	_data30_->to_install_copy_length1 = _tmp4__length1;
	_data30_->_to_install_copy_size_ = _data30_->to_install_copy_length1;
	_tmp5_ = (to_remove != NULL) ? _vala_array_dup14 (to_remove, to_remove_length1) : to_remove;
	_tmp5__length1 = to_remove_length1;
	_data30_->to_remove_copy = _tmp5_;
	_data30_->to_remove_copy_length1 = _tmp5__length1;
	_data30_->_to_remove_copy_size_ = _data30_->to_remove_copy_length1;
	_tmp6_ = (to_upgrade != NULL) ? _vala_array_dup15 (to_upgrade, to_upgrade_length1) : to_upgrade;
	_tmp6__length1 = to_upgrade_length1;
	_data30_->to_upgrade_copy = _tmp6_;
	_data30_->to_upgrade_copy_length1 = _tmp6__length1;
	_data30_->_to_upgrade_copy_size_ = _data30_->to_upgrade_copy_length1;
	pamac_daemon_check_authorization (self, _data30_->sender, ___lambda96__gasync_ready_callback, block30_data_ref (_data30_));
	block30_data_unref (_data30_);
	_data30_ = NULL;
}

void
pamac_daemon_trans_cancel (PamacDaemon* self,
                           const char* sender,
                           GError** error)
{
	GCancellable* cancellable = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	PamacConfig* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	PamacConfig* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	PamacAlpmUtils* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	_tmp0_ = self->priv->cancellables_table;
	_tmp1_ = g_hash_table_lookup (_tmp0_, (const gchar*) sender);
	_tmp2_ = _g_object_ref0 ((GCancellable*) _tmp1_);
	cancellable = _tmp2_;
	_tmp3_ = cancellable;
	if (_tmp3_ != NULL) {
		GCancellable* _tmp4_;
		g_mutex_lock (&self->priv->answer_mutex);
		_tmp4_ = cancellable;
		g_cancellable_cancel (_tmp4_);
		g_cond_signal (&self->priv->answer_cond);
		g_mutex_unlock (&self->priv->answer_mutex);
	}
	_tmp5_ = self->priv->config;
	_tmp6_ = pamac_config_get_enable_snap (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		PamacSnapPlugin* _tmp8_;
		_tmp8_ = self->priv->snap_plugin;
		pamac_snap_plugin_trans_cancel (_tmp8_, (const gchar*) sender);
	}
	_tmp9_ = self->priv->config;
	_tmp10_ = pamac_config_get_enable_flatpak (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		PamacFlatpakPlugin* _tmp12_;
		_tmp12_ = self->priv->flatpak_plugin;
		pamac_flatpak_plugin_trans_cancel (_tmp12_, (const gchar*) sender);
	}
	_tmp13_ = self->priv->alpm_utils;
	pamac_alpm_utils_trans_cancel (_tmp13_, (const gchar*) sender);
	_g_object_unref0 (cancellable);
}

void
pamac_daemon_quit (PamacDaemon* self,
                   GError** error)
{
	PamacAlpmUtils* _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->alpm_utils;
	if (_tmp0_->downloading_updates) {
		return;
	}
	_tmp1_ = g_atomic_int_get ((volatile gint *) (&self->priv->running_threads));
	if (_tmp1_ == 0) {
		GMainLoop* _tmp2_;
		_tmp2_ = loop;
		g_main_loop_quit (_tmp2_);
	}
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_STRING_DOUBLE (GClosure * closure,
                                                           GValue * return_value,
                                                           guint n_param_values,
                                                           const GValue * param_values,
                                                           gpointer invocation_hint,
                                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING_DOUBLE) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gdouble arg_4, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), g_value_get_double (param_values + 4), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_STRING_STRING_DOUBLE (GClosure * closure,
                                                                  GValue * return_value,
                                                                  guint n_param_values,
                                                                  const GValue * param_values,
                                                                  gpointer invocation_hint,
                                                                  gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING_STRING_DOUBLE) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, const char* arg_4, gdouble arg_5, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING_STRING_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING_STRING_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), g_value_get_double (param_values + 5), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_BOXED_INT (GClosure * closure,
                                                       GValue * return_value,
                                                       guint n_param_values,
                                                       const GValue * param_values,
                                                       gpointer invocation_hint,
                                                       gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_BOXED_INT) (gpointer data1, const char* arg_1, const char* arg_2, gpointer arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_BOXED_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_BOXED_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_boxed (param_values + 3), g_value_get_int (param_values + 4), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_BOOLEAN (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_BOOLEAN) (gpointer data1, const char* arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_BOXED_INT (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_BOXED_INT) (gpointer data1, const char* arg_1, gpointer arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOXED_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOXED_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), g_value_get_int (param_values + 3), data2);
}

static void
pamac_daemon_class_init (PamacDaemonClass * klass,
                         gpointer klass_data)
{
	pamac_daemon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacDaemon_private_offset);
	G_OBJECT_CLASS (klass)->finalize = pamac_daemon_finalize;
	pamac_daemon_signals[PAMAC_DAEMON_EMIT_ACTION_SIGNAL] = g_signal_new ("emit-action", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_EMIT_ACTION_PROGRESS_SIGNAL] = g_signal_new ("emit-action-progress", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_DOUBLE, G_TYPE_NONE, 4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_DOUBLE);
	pamac_daemon_signals[PAMAC_DAEMON_EMIT_DOWNLOAD_PROGRESS_SIGNAL] = g_signal_new ("emit-download-progress", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_DOUBLE, G_TYPE_NONE, 4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_DOUBLE);
	pamac_daemon_signals[PAMAC_DAEMON_EMIT_HOOK_PROGRESS_SIGNAL] = g_signal_new ("emit-hook-progress", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_STRING_DOUBLE, G_TYPE_NONE, 5, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_DOUBLE);
	pamac_daemon_signals[PAMAC_DAEMON_EMIT_SCRIPT_OUTPUT_SIGNAL] = g_signal_new ("emit-script-output", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_EMIT_WARNING_SIGNAL] = g_signal_new ("emit-warning", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL] = g_signal_new ("emit-error", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_BOXED_INT, G_TYPE_NONE, 4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_INT);
	pamac_daemon_signals[PAMAC_DAEMON_IMPORTANT_DETAILS_OUTPOUT_SIGNAL] = g_signal_new ("important-details-outpout", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_START_DOWNLOADING_SIGNAL] = g_signal_new ("start-downloading", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_STOP_DOWNLOADING_SIGNAL] = g_signal_new ("stop-downloading", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_SET_PKGREASON_FINISHED_SIGNAL] = g_signal_new ("set-pkgreason-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_START_WAITING_SIGNAL] = g_signal_new ("start-waiting", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_STOP_WAITING_SIGNAL] = g_signal_new ("stop-waiting", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_TRANS_REFRESH_FINISHED_SIGNAL] = g_signal_new ("trans-refresh-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_TRANS_REFRESH_FILES_FINISHED_SIGNAL] = g_signal_new ("trans-refresh-files-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_TRANS_REFRESH_AUR_FINISHED_SIGNAL] = g_signal_new ("trans-refresh-aur-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_TRANS_RUN_FINISHED_SIGNAL] = g_signal_new ("trans-run-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_DOWNLOAD_UPDATES_FINISHED_SIGNAL] = g_signal_new ("download-updates-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_DOWNLOAD_PKGS_FINISHED_SIGNAL] = g_signal_new ("download-pkgs-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED_INT, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_INT);
	pamac_daemon_signals[PAMAC_DAEMON_GET_AUTHORIZATION_FINISHED_SIGNAL] = g_signal_new ("get-authorization-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_WRITE_ALPM_CONFIG_FINISHED_SIGNAL] = g_signal_new ("write-alpm-config-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_WRITE_PAMAC_CONFIG_FINISHED_SIGNAL] = g_signal_new ("write-pamac-config-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_GENERATE_MIRRORS_LIST_DATA_SIGNAL] = g_signal_new ("generate-mirrors-list-data", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_GENERATE_MIRRORS_LIST_FINISHED_SIGNAL] = g_signal_new ("generate-mirrors-list-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_CLEAN_CACHE_FINISHED_SIGNAL] = g_signal_new ("clean-cache-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_CLEAN_BUILD_FILES_FINISHED_SIGNAL] = g_signal_new ("clean-build-files-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_SNAP_TRANS_RUN_FINISHED_SIGNAL] = g_signal_new ("snap-trans-run-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_SNAP_SWITCH_CHANNEL_FINISHED_SIGNAL] = g_signal_new ("snap-switch-channel-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_FLATPAK_TRANS_RUN_FINISHED_SIGNAL] = g_signal_new ("flatpak-trans-run-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
}

static void
pamac_daemon_instance_init (PamacDaemon * self,
                            gpointer klass)
{
	self->priv = pamac_daemon_get_instance_private (self);
}

static void
pamac_daemon_finalize (GObject * obj)
{
	PamacDaemon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_DAEMON, PamacDaemon);
	_g_object_unref0 (self->priv->config);
	_g_object_unref0 (self->priv->alpm_utils);
	_g_object_unref0 (self->priv->lockfile_monitor);
	_vala_clear_GCond (&self->priv->lockfile_cond);
	_vala_clear_GMutex (&self->priv->lockfile_mutex);
	_vala_clear_GCond (&self->priv->answer_cond);
	_vala_clear_GMutex (&self->priv->answer_mutex);
	_vala_clear_GMutex (&self->priv->authorization_mutex);
	_g_hash_table_unref0 (self->priv->authorized_senders);
	_g_hash_table_unref0 (self->priv->cancellables_table);
	_g_object_unref0 (self->priv->snap_plugin);
	_g_object_unref0 (self->priv->flatpak_plugin);
	G_OBJECT_CLASS (pamac_daemon_parent_class)->finalize (obj);
}

static GType
pamac_daemon_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacDaemonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_daemon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacDaemon), 0, (GInstanceInitFunc) pamac_daemon_instance_init, NULL };
	GType pamac_daemon_type_id;
	pamac_daemon_type_id = g_type_register_static (G_TYPE_OBJECT, "PamacDaemon", &g_define_type_info, 0);
	g_type_set_qdata (pamac_daemon_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) pamac_daemon_register_object);
	PamacDaemon_private_offset = g_type_add_instance_private (pamac_daemon_type_id, sizeof (PamacDaemonPrivate));
	return pamac_daemon_type_id;
}

GType
pamac_daemon_get_type (void)
{
	static volatile gsize pamac_daemon_type_id__once = 0;
	if (g_once_init_enter (&pamac_daemon_type_id__once)) {
		GType pamac_daemon_type_id;
		pamac_daemon_type_id = pamac_daemon_get_type_once ();
		g_once_init_leave (&pamac_daemon_type_id__once, pamac_daemon_type_id);
	}
	return pamac_daemon_type_id__once;
}

static void
_dbus_pamac_daemon_set_environment_variables (PamacDaemon* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GHashTable* variables = NULL;
	GVariant* _tmp0_;
	GHashTable* _tmp1_;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	g_variant_iter_init (&_tmp2_, _tmp0_);
	while (g_variant_iter_loop (&_tmp2_, "{?*}", &_tmp3_, &_tmp4_)) {
		g_hash_table_insert (_tmp1_, g_variant_dup_string (_tmp3_, NULL), g_variant_dup_string (_tmp4_, NULL));
	}
	variables = _tmp1_;
	g_variant_unref (_tmp0_);
	pamac_daemon_set_environment_variables (self, variables, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_hash_table_unref0 (variables);
	;
}

static void
_dbus_pamac_daemon_get_sender (PamacDaemon* self,
                               GVariant* _parameters_,
                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = pamac_daemon_get_sender (self, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pamac_daemon_get_lockfile (PamacDaemon* self,
                                 GVariant* _parameters_,
                                 GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = pamac_daemon_get_lockfile (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pamac_daemon_start_get_authorization (PamacDaemon* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	pamac_daemon_start_get_authorization (self, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pamac_daemon_remove_authorization (PamacDaemon* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	pamac_daemon_remove_authorization (self, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pamac_daemon_start_write_alpm_config (PamacDaemon* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GHashTable* new_alpm_conf = NULL;
	GVariant* _tmp5_;
	GHashTable* _tmp6_;
	GVariantIter _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp6_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp7_, _tmp5_);
	while (g_variant_iter_loop (&_tmp7_, "{?*}", &_tmp8_, &_tmp9_)) {
		g_hash_table_insert (_tmp6_, g_variant_dup_string (_tmp8_, NULL), g_variant_get_variant (_tmp9_));
	}
	new_alpm_conf = _tmp6_;
	g_variant_unref (_tmp5_);
	pamac_daemon_start_write_alpm_config (self, new_alpm_conf, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_hash_table_unref0 (new_alpm_conf);
	;
}

static void
_dbus_pamac_daemon_start_write_pamac_config (PamacDaemon* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GHashTable* new_pamac_conf = NULL;
	GVariant* _tmp10_;
	GHashTable* _tmp11_;
	GVariantIter _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp10_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp11_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp12_, _tmp10_);
	while (g_variant_iter_loop (&_tmp12_, "{?*}", &_tmp13_, &_tmp14_)) {
		g_hash_table_insert (_tmp11_, g_variant_dup_string (_tmp13_, NULL), g_variant_get_variant (_tmp14_));
	}
	new_pamac_conf = _tmp11_;
	g_variant_unref (_tmp10_);
	pamac_daemon_start_write_pamac_config (self, new_pamac_conf, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_hash_table_unref0 (new_pamac_conf);
	;
}

static void
_dbus_pamac_daemon_start_generate_mirrors_list (PamacDaemon* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* country = NULL;
	GVariant* _tmp15_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp15_ = g_variant_iter_next_value (&_arguments_iter);
	country = g_variant_dup_string (_tmp15_, NULL);
	g_variant_unref (_tmp15_);
	pamac_daemon_start_generate_mirrors_list (self, country, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (country);
	;
}

static void
_dbus_pamac_daemon_start_clean_cache (PamacDaemon* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** filenames = NULL;
	gint filenames_length1 = 0;
	GVariant* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length;
	gint _tmp17__size;
	gint _tmp17__length1;
	GVariantIter _tmp18_;
	GVariant* _tmp19_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp16_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp17_ = g_new (gchar*, 5);
	_tmp17__length = 0;
	_tmp17__size = 4;
	_tmp17__length1 = 0;
	g_variant_iter_init (&_tmp18_, _tmp16_);
	for (; (_tmp19_ = g_variant_iter_next_value (&_tmp18_)) != NULL; _tmp17__length1++) {
		if (_tmp17__size == _tmp17__length) {
			_tmp17__size = 2 * _tmp17__size;
			_tmp17_ = g_renew (gchar*, _tmp17_, _tmp17__size + 1);
		}
		_tmp17_[_tmp17__length++] = g_variant_dup_string (_tmp19_, NULL);
		g_variant_unref (_tmp19_);
	}
	filenames_length1 = _tmp17__length1;
	_tmp17_[_tmp17__length] = NULL;
	filenames = _tmp17_;
	g_variant_unref (_tmp16_);
	pamac_daemon_start_clean_cache (self, filenames, filenames_length1, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	filenames = (_vala_array_free (filenames, filenames_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_pamac_daemon_start_clean_build_files (PamacDaemon* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* aur_build_dir = NULL;
	GVariant* _tmp20_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp20_ = g_variant_iter_next_value (&_arguments_iter);
	aur_build_dir = g_variant_dup_string (_tmp20_, NULL);
	g_variant_unref (_tmp20_);
	pamac_daemon_start_clean_build_files (self, aur_build_dir, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (aur_build_dir);
	;
}

static void
_dbus_pamac_daemon_start_set_pkgreason (PamacDaemon* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* pkgname = NULL;
	GVariant* _tmp21_;
	guint reason = 0U;
	GVariant* _tmp22_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp21_ = g_variant_iter_next_value (&_arguments_iter);
	pkgname = g_variant_dup_string (_tmp21_, NULL);
	g_variant_unref (_tmp21_);
	_tmp22_ = g_variant_iter_next_value (&_arguments_iter);
	reason = g_variant_get_uint32 (_tmp22_);
	g_variant_unref (_tmp22_);
	pamac_daemon_start_set_pkgreason (self, pkgname, reason, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (pkgname);
	;
}

static void
_dbus_pamac_daemon_start_download_updates (PamacDaemon* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	pamac_daemon_start_download_updates (self, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pamac_daemon_start_download_pkgs (PamacDaemon* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** urls = NULL;
	gint urls_length1 = 0;
	GVariant* _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length;
	gint _tmp24__size;
	gint _tmp24__length1;
	GVariantIter _tmp25_;
	GVariant* _tmp26_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp23_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp24_ = g_new (gchar*, 5);
	_tmp24__length = 0;
	_tmp24__size = 4;
	_tmp24__length1 = 0;
	g_variant_iter_init (&_tmp25_, _tmp23_);
	for (; (_tmp26_ = g_variant_iter_next_value (&_tmp25_)) != NULL; _tmp24__length1++) {
		if (_tmp24__size == _tmp24__length) {
			_tmp24__size = 2 * _tmp24__size;
			_tmp24_ = g_renew (gchar*, _tmp24_, _tmp24__size + 1);
		}
		_tmp24_[_tmp24__length++] = g_variant_dup_string (_tmp26_, NULL);
		g_variant_unref (_tmp26_);
	}
	urls_length1 = _tmp24__length1;
	_tmp24_[_tmp24__length] = NULL;
	urls = _tmp24_;
	g_variant_unref (_tmp23_);
	pamac_daemon_start_download_pkgs (self, urls, urls_length1, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	urls = (_vala_array_free (urls, urls_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_pamac_daemon_start_trans_refresh (PamacDaemon* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gboolean force = FALSE;
	GVariant* _tmp27_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp27_ = g_variant_iter_next_value (&_arguments_iter);
	force = g_variant_get_boolean (_tmp27_);
	g_variant_unref (_tmp27_);
	pamac_daemon_start_trans_refresh (self, force, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pamac_daemon_start_trans_refresh_files (PamacDaemon* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gboolean force = FALSE;
	GVariant* _tmp28_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp28_ = g_variant_iter_next_value (&_arguments_iter);
	force = g_variant_get_boolean (_tmp28_);
	g_variant_unref (_tmp28_);
	pamac_daemon_start_trans_refresh_files (self, force, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pamac_daemon_start_trans_refresh_aur (PamacDaemon* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gboolean force = FALSE;
	GVariant* _tmp29_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp29_ = g_variant_iter_next_value (&_arguments_iter);
	force = g_variant_get_boolean (_tmp29_);
	g_variant_unref (_tmp29_);
	pamac_daemon_start_trans_refresh_aur (self, force, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pamac_daemon_start_trans_run (PamacDaemon* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gboolean sysupgrade = FALSE;
	GVariant* _tmp30_;
	gboolean enable_downgrade = FALSE;
	GVariant* _tmp31_;
	gboolean simple_install = FALSE;
	GVariant* _tmp32_;
	gboolean keep_built_pkgs = FALSE;
	GVariant* _tmp33_;
	gint trans_flags = 0;
	GVariant* _tmp34_;
	gchar** to_install = NULL;
	gint to_install_length1 = 0;
	GVariant* _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length;
	gint _tmp36__size;
	gint _tmp36__length1;
	GVariantIter _tmp37_;
	GVariant* _tmp38_;
	gchar** to_remove = NULL;
	gint to_remove_length1 = 0;
	GVariant* _tmp39_;
	gchar** _tmp40_;
	gint _tmp40__length;
	gint _tmp40__size;
	gint _tmp40__length1;
	GVariantIter _tmp41_;
	GVariant* _tmp42_;
	gchar** to_load_local = NULL;
	gint to_load_local_length1 = 0;
	GVariant* _tmp43_;
	gchar** _tmp44_;
	gint _tmp44__length;
	gint _tmp44__size;
	gint _tmp44__length1;
	GVariantIter _tmp45_;
	GVariant* _tmp46_;
	gchar** to_load_remote = NULL;
	gint to_load_remote_length1 = 0;
	GVariant* _tmp47_;
	gchar** _tmp48_;
	gint _tmp48__length;
	gint _tmp48__size;
	gint _tmp48__length1;
	GVariantIter _tmp49_;
	GVariant* _tmp50_;
	gchar** to_install_as_dep = NULL;
	gint to_install_as_dep_length1 = 0;
	GVariant* _tmp51_;
	gchar** _tmp52_;
	gint _tmp52__length;
	gint _tmp52__size;
	gint _tmp52__length1;
	GVariantIter _tmp53_;
	GVariant* _tmp54_;
	gchar** ignorepkgs = NULL;
	gint ignorepkgs_length1 = 0;
	GVariant* _tmp55_;
	gchar** _tmp56_;
	gint _tmp56__length;
	gint _tmp56__size;
	gint _tmp56__length1;
	GVariantIter _tmp57_;
	GVariant* _tmp58_;
	gchar** overwrite_files = NULL;
	gint overwrite_files_length1 = 0;
	GVariant* _tmp59_;
	gchar** _tmp60_;
	gint _tmp60__length;
	gint _tmp60__size;
	gint _tmp60__length1;
	GVariantIter _tmp61_;
	GVariant* _tmp62_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp30_ = g_variant_iter_next_value (&_arguments_iter);
	sysupgrade = g_variant_get_boolean (_tmp30_);
	g_variant_unref (_tmp30_);
	_tmp31_ = g_variant_iter_next_value (&_arguments_iter);
	enable_downgrade = g_variant_get_boolean (_tmp31_);
	g_variant_unref (_tmp31_);
	_tmp32_ = g_variant_iter_next_value (&_arguments_iter);
	simple_install = g_variant_get_boolean (_tmp32_);
	g_variant_unref (_tmp32_);
	_tmp33_ = g_variant_iter_next_value (&_arguments_iter);
	keep_built_pkgs = g_variant_get_boolean (_tmp33_);
	g_variant_unref (_tmp33_);
	_tmp34_ = g_variant_iter_next_value (&_arguments_iter);
	trans_flags = g_variant_get_int32 (_tmp34_);
	g_variant_unref (_tmp34_);
	_tmp35_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp36_ = g_new (gchar*, 5);
	_tmp36__length = 0;
	_tmp36__size = 4;
	_tmp36__length1 = 0;
	g_variant_iter_init (&_tmp37_, _tmp35_);
	for (; (_tmp38_ = g_variant_iter_next_value (&_tmp37_)) != NULL; _tmp36__length1++) {
		if (_tmp36__size == _tmp36__length) {
			_tmp36__size = 2 * _tmp36__size;
			_tmp36_ = g_renew (gchar*, _tmp36_, _tmp36__size + 1);
		}
		_tmp36_[_tmp36__length++] = g_variant_dup_string (_tmp38_, NULL);
		g_variant_unref (_tmp38_);
	}
	to_install_length1 = _tmp36__length1;
	_tmp36_[_tmp36__length] = NULL;
	to_install = _tmp36_;
	g_variant_unref (_tmp35_);
	_tmp39_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp40_ = g_new (gchar*, 5);
	_tmp40__length = 0;
	_tmp40__size = 4;
	_tmp40__length1 = 0;
	g_variant_iter_init (&_tmp41_, _tmp39_);
	for (; (_tmp42_ = g_variant_iter_next_value (&_tmp41_)) != NULL; _tmp40__length1++) {
		if (_tmp40__size == _tmp40__length) {
			_tmp40__size = 2 * _tmp40__size;
			_tmp40_ = g_renew (gchar*, _tmp40_, _tmp40__size + 1);
		}
		_tmp40_[_tmp40__length++] = g_variant_dup_string (_tmp42_, NULL);
		g_variant_unref (_tmp42_);
	}
	to_remove_length1 = _tmp40__length1;
	_tmp40_[_tmp40__length] = NULL;
	to_remove = _tmp40_;
	g_variant_unref (_tmp39_);
	_tmp43_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp44_ = g_new (gchar*, 5);
	_tmp44__length = 0;
	_tmp44__size = 4;
	_tmp44__length1 = 0;
	g_variant_iter_init (&_tmp45_, _tmp43_);
	for (; (_tmp46_ = g_variant_iter_next_value (&_tmp45_)) != NULL; _tmp44__length1++) {
		if (_tmp44__size == _tmp44__length) {
			_tmp44__size = 2 * _tmp44__size;
			_tmp44_ = g_renew (gchar*, _tmp44_, _tmp44__size + 1);
		}
		_tmp44_[_tmp44__length++] = g_variant_dup_string (_tmp46_, NULL);
		g_variant_unref (_tmp46_);
	}
	to_load_local_length1 = _tmp44__length1;
	_tmp44_[_tmp44__length] = NULL;
	to_load_local = _tmp44_;
	g_variant_unref (_tmp43_);
	_tmp47_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp48_ = g_new (gchar*, 5);
	_tmp48__length = 0;
	_tmp48__size = 4;
	_tmp48__length1 = 0;
	g_variant_iter_init (&_tmp49_, _tmp47_);
	for (; (_tmp50_ = g_variant_iter_next_value (&_tmp49_)) != NULL; _tmp48__length1++) {
		if (_tmp48__size == _tmp48__length) {
			_tmp48__size = 2 * _tmp48__size;
			_tmp48_ = g_renew (gchar*, _tmp48_, _tmp48__size + 1);
		}
		_tmp48_[_tmp48__length++] = g_variant_dup_string (_tmp50_, NULL);
		g_variant_unref (_tmp50_);
	}
	to_load_remote_length1 = _tmp48__length1;
	_tmp48_[_tmp48__length] = NULL;
	to_load_remote = _tmp48_;
	g_variant_unref (_tmp47_);
	_tmp51_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp52_ = g_new (gchar*, 5);
	_tmp52__length = 0;
	_tmp52__size = 4;
	_tmp52__length1 = 0;
	g_variant_iter_init (&_tmp53_, _tmp51_);
	for (; (_tmp54_ = g_variant_iter_next_value (&_tmp53_)) != NULL; _tmp52__length1++) {
		if (_tmp52__size == _tmp52__length) {
			_tmp52__size = 2 * _tmp52__size;
			_tmp52_ = g_renew (gchar*, _tmp52_, _tmp52__size + 1);
		}
		_tmp52_[_tmp52__length++] = g_variant_dup_string (_tmp54_, NULL);
		g_variant_unref (_tmp54_);
	}
	to_install_as_dep_length1 = _tmp52__length1;
	_tmp52_[_tmp52__length] = NULL;
	to_install_as_dep = _tmp52_;
	g_variant_unref (_tmp51_);
	_tmp55_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp56_ = g_new (gchar*, 5);
	_tmp56__length = 0;
	_tmp56__size = 4;
	_tmp56__length1 = 0;
	g_variant_iter_init (&_tmp57_, _tmp55_);
	for (; (_tmp58_ = g_variant_iter_next_value (&_tmp57_)) != NULL; _tmp56__length1++) {
		if (_tmp56__size == _tmp56__length) {
			_tmp56__size = 2 * _tmp56__size;
			_tmp56_ = g_renew (gchar*, _tmp56_, _tmp56__size + 1);
		}
		_tmp56_[_tmp56__length++] = g_variant_dup_string (_tmp58_, NULL);
		g_variant_unref (_tmp58_);
	}
	ignorepkgs_length1 = _tmp56__length1;
	_tmp56_[_tmp56__length] = NULL;
	ignorepkgs = _tmp56_;
	g_variant_unref (_tmp55_);
	_tmp59_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp60_ = g_new (gchar*, 5);
	_tmp60__length = 0;
	_tmp60__size = 4;
	_tmp60__length1 = 0;
	g_variant_iter_init (&_tmp61_, _tmp59_);
	for (; (_tmp62_ = g_variant_iter_next_value (&_tmp61_)) != NULL; _tmp60__length1++) {
		if (_tmp60__size == _tmp60__length) {
			_tmp60__size = 2 * _tmp60__size;
			_tmp60_ = g_renew (gchar*, _tmp60_, _tmp60__size + 1);
		}
		_tmp60_[_tmp60__length++] = g_variant_dup_string (_tmp62_, NULL);
		g_variant_unref (_tmp62_);
	}
	overwrite_files_length1 = _tmp60__length1;
	_tmp60_[_tmp60__length] = NULL;
	overwrite_files = _tmp60_;
	g_variant_unref (_tmp59_);
	pamac_daemon_start_trans_run (self, sysupgrade, enable_downgrade, simple_install, keep_built_pkgs, trans_flags, to_install, to_install_length1, to_remove, to_remove_length1, to_load_local, to_load_local_length1, to_load_remote, to_load_remote_length1, to_install_as_dep, to_install_as_dep_length1, ignorepkgs, ignorepkgs_length1, overwrite_files, overwrite_files_length1, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	to_install = (_vala_array_free (to_install, to_install_length1, (GDestroyNotify) g_free), NULL);
	to_remove = (_vala_array_free (to_remove, to_remove_length1, (GDestroyNotify) g_free), NULL);
	to_load_local = (_vala_array_free (to_load_local, to_load_local_length1, (GDestroyNotify) g_free), NULL);
	to_load_remote = (_vala_array_free (to_load_remote, to_load_remote_length1, (GDestroyNotify) g_free), NULL);
	to_install_as_dep = (_vala_array_free (to_install_as_dep, to_install_as_dep_length1, (GDestroyNotify) g_free), NULL);
	ignorepkgs = (_vala_array_free (ignorepkgs, ignorepkgs_length1, (GDestroyNotify) g_free), NULL);
	overwrite_files = (_vala_array_free (overwrite_files, overwrite_files_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_pamac_daemon_start_snap_trans_run (PamacDaemon* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** to_install = NULL;
	gint to_install_length1 = 0;
	GVariant* _tmp63_;
	gchar** _tmp64_;
	gint _tmp64__length;
	gint _tmp64__size;
	gint _tmp64__length1;
	GVariantIter _tmp65_;
	GVariant* _tmp66_;
	gchar** to_remove = NULL;
	gint to_remove_length1 = 0;
	GVariant* _tmp67_;
	gchar** _tmp68_;
	gint _tmp68__length;
	gint _tmp68__size;
	gint _tmp68__length1;
	GVariantIter _tmp69_;
	GVariant* _tmp70_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp63_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp64_ = g_new (gchar*, 5);
	_tmp64__length = 0;
	_tmp64__size = 4;
	_tmp64__length1 = 0;
	g_variant_iter_init (&_tmp65_, _tmp63_);
	for (; (_tmp66_ = g_variant_iter_next_value (&_tmp65_)) != NULL; _tmp64__length1++) {
		if (_tmp64__size == _tmp64__length) {
			_tmp64__size = 2 * _tmp64__size;
			_tmp64_ = g_renew (gchar*, _tmp64_, _tmp64__size + 1);
		}
		_tmp64_[_tmp64__length++] = g_variant_dup_string (_tmp66_, NULL);
		g_variant_unref (_tmp66_);
	}
	to_install_length1 = _tmp64__length1;
	_tmp64_[_tmp64__length] = NULL;
	to_install = _tmp64_;
	g_variant_unref (_tmp63_);
	_tmp67_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp68_ = g_new (gchar*, 5);
	_tmp68__length = 0;
	_tmp68__size = 4;
	_tmp68__length1 = 0;
	g_variant_iter_init (&_tmp69_, _tmp67_);
	for (; (_tmp70_ = g_variant_iter_next_value (&_tmp69_)) != NULL; _tmp68__length1++) {
		if (_tmp68__size == _tmp68__length) {
			_tmp68__size = 2 * _tmp68__size;
			_tmp68_ = g_renew (gchar*, _tmp68_, _tmp68__size + 1);
		}
		_tmp68_[_tmp68__length++] = g_variant_dup_string (_tmp70_, NULL);
		g_variant_unref (_tmp70_);
	}
	to_remove_length1 = _tmp68__length1;
	_tmp68_[_tmp68__length] = NULL;
	to_remove = _tmp68_;
	g_variant_unref (_tmp67_);
	pamac_daemon_start_snap_trans_run (self, to_install, to_install_length1, to_remove, to_remove_length1, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	to_install = (_vala_array_free (to_install, to_install_length1, (GDestroyNotify) g_free), NULL);
	to_remove = (_vala_array_free (to_remove, to_remove_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_pamac_daemon_start_snap_switch_channel (PamacDaemon* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* snap_name = NULL;
	GVariant* _tmp71_;
	gchar* snap_channel = NULL;
	GVariant* _tmp72_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp71_ = g_variant_iter_next_value (&_arguments_iter);
	snap_name = g_variant_dup_string (_tmp71_, NULL);
	g_variant_unref (_tmp71_);
	_tmp72_ = g_variant_iter_next_value (&_arguments_iter);
	snap_channel = g_variant_dup_string (_tmp72_, NULL);
	g_variant_unref (_tmp72_);
	pamac_daemon_start_snap_switch_channel (self, snap_name, snap_channel, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (snap_name);
	_g_free0 (snap_channel);
	;
}

static void
_dbus_pamac_daemon_start_flatpak_trans_run (PamacDaemon* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** to_install = NULL;
	gint to_install_length1 = 0;
	GVariant* _tmp73_;
	gchar** _tmp74_;
	gint _tmp74__length;
	gint _tmp74__size;
	gint _tmp74__length1;
	GVariantIter _tmp75_;
	GVariant* _tmp76_;
	gchar** to_remove = NULL;
	gint to_remove_length1 = 0;
	GVariant* _tmp77_;
	gchar** _tmp78_;
	gint _tmp78__length;
	gint _tmp78__size;
	gint _tmp78__length1;
	GVariantIter _tmp79_;
	GVariant* _tmp80_;
	gchar** to_upgrade = NULL;
	gint to_upgrade_length1 = 0;
	GVariant* _tmp81_;
	gchar** _tmp82_;
	gint _tmp82__length;
	gint _tmp82__size;
	gint _tmp82__length1;
	GVariantIter _tmp83_;
	GVariant* _tmp84_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp73_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp74_ = g_new (gchar*, 5);
	_tmp74__length = 0;
	_tmp74__size = 4;
	_tmp74__length1 = 0;
	g_variant_iter_init (&_tmp75_, _tmp73_);
	for (; (_tmp76_ = g_variant_iter_next_value (&_tmp75_)) != NULL; _tmp74__length1++) {
		if (_tmp74__size == _tmp74__length) {
			_tmp74__size = 2 * _tmp74__size;
			_tmp74_ = g_renew (gchar*, _tmp74_, _tmp74__size + 1);
		}
		_tmp74_[_tmp74__length++] = g_variant_dup_string (_tmp76_, NULL);
		g_variant_unref (_tmp76_);
	}
	to_install_length1 = _tmp74__length1;
	_tmp74_[_tmp74__length] = NULL;
	to_install = _tmp74_;
	g_variant_unref (_tmp73_);
	_tmp77_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp78_ = g_new (gchar*, 5);
	_tmp78__length = 0;
	_tmp78__size = 4;
	_tmp78__length1 = 0;
	g_variant_iter_init (&_tmp79_, _tmp77_);
	for (; (_tmp80_ = g_variant_iter_next_value (&_tmp79_)) != NULL; _tmp78__length1++) {
		if (_tmp78__size == _tmp78__length) {
			_tmp78__size = 2 * _tmp78__size;
			_tmp78_ = g_renew (gchar*, _tmp78_, _tmp78__size + 1);
		}
		_tmp78_[_tmp78__length++] = g_variant_dup_string (_tmp80_, NULL);
		g_variant_unref (_tmp80_);
	}
	to_remove_length1 = _tmp78__length1;
	_tmp78_[_tmp78__length] = NULL;
	to_remove = _tmp78_;
	g_variant_unref (_tmp77_);
	_tmp81_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp82_ = g_new (gchar*, 5);
	_tmp82__length = 0;
	_tmp82__size = 4;
	_tmp82__length1 = 0;
	g_variant_iter_init (&_tmp83_, _tmp81_);
	for (; (_tmp84_ = g_variant_iter_next_value (&_tmp83_)) != NULL; _tmp82__length1++) {
		if (_tmp82__size == _tmp82__length) {
			_tmp82__size = 2 * _tmp82__size;
			_tmp82_ = g_renew (gchar*, _tmp82_, _tmp82__size + 1);
		}
		_tmp82_[_tmp82__length++] = g_variant_dup_string (_tmp84_, NULL);
		g_variant_unref (_tmp84_);
	}
	to_upgrade_length1 = _tmp82__length1;
	_tmp82_[_tmp82__length] = NULL;
	to_upgrade = _tmp82_;
	g_variant_unref (_tmp81_);
	pamac_daemon_start_flatpak_trans_run (self, to_install, to_install_length1, to_remove, to_remove_length1, to_upgrade, to_upgrade_length1, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	to_install = (_vala_array_free (to_install, to_install_length1, (GDestroyNotify) g_free), NULL);
	to_remove = (_vala_array_free (to_remove, to_remove_length1, (GDestroyNotify) g_free), NULL);
	to_upgrade = (_vala_array_free (to_upgrade, to_upgrade_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_pamac_daemon_trans_cancel (PamacDaemon* self,
                                 GVariant* _parameters_,
                                 GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	pamac_daemon_trans_cancel (self, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pamac_daemon_quit (PamacDaemon* self,
                         GVariant* _parameters_,
                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	pamac_daemon_quit (self, &error);
}

static void
pamac_daemon_dbus_interface_method_call (GDBusConnection* connection,
                                         const gchar* sender,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* method_name,
                                         GVariant* parameters,
                                         GDBusMethodInvocation* invocation,
                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SetEnvironmentVariables") == 0) {
		_dbus_pamac_daemon_set_environment_variables (object, parameters, invocation);
	} else if (strcmp (method_name, "GetSender") == 0) {
		_dbus_pamac_daemon_get_sender (object, parameters, invocation);
	} else if (strcmp (method_name, "GetLockfile") == 0) {
		_dbus_pamac_daemon_get_lockfile (object, parameters, invocation);
	} else if (strcmp (method_name, "StartGetAuthorization") == 0) {
		_dbus_pamac_daemon_start_get_authorization (object, parameters, invocation);
	} else if (strcmp (method_name, "RemoveAuthorization") == 0) {
		_dbus_pamac_daemon_remove_authorization (object, parameters, invocation);
	} else if (strcmp (method_name, "StartWriteAlpmConfig") == 0) {
		_dbus_pamac_daemon_start_write_alpm_config (object, parameters, invocation);
	} else if (strcmp (method_name, "StartWritePamacConfig") == 0) {
		_dbus_pamac_daemon_start_write_pamac_config (object, parameters, invocation);
	} else if (strcmp (method_name, "StartGenerateMirrorsList") == 0) {
		_dbus_pamac_daemon_start_generate_mirrors_list (object, parameters, invocation);
	} else if (strcmp (method_name, "StartCleanCache") == 0) {
		_dbus_pamac_daemon_start_clean_cache (object, parameters, invocation);
	} else if (strcmp (method_name, "StartCleanBuildFiles") == 0) {
		_dbus_pamac_daemon_start_clean_build_files (object, parameters, invocation);
	} else if (strcmp (method_name, "StartSetPkgreason") == 0) {
		_dbus_pamac_daemon_start_set_pkgreason (object, parameters, invocation);
	} else if (strcmp (method_name, "StartDownloadUpdates") == 0) {
		_dbus_pamac_daemon_start_download_updates (object, parameters, invocation);
	} else if (strcmp (method_name, "StartDownloadPkgs") == 0) {
		_dbus_pamac_daemon_start_download_pkgs (object, parameters, invocation);
	} else if (strcmp (method_name, "StartTransRefresh") == 0) {
		_dbus_pamac_daemon_start_trans_refresh (object, parameters, invocation);
	} else if (strcmp (method_name, "StartTransRefreshFiles") == 0) {
		_dbus_pamac_daemon_start_trans_refresh_files (object, parameters, invocation);
	} else if (strcmp (method_name, "StartTransRefreshAur") == 0) {
		_dbus_pamac_daemon_start_trans_refresh_aur (object, parameters, invocation);
	} else if (strcmp (method_name, "StartTransRun") == 0) {
		_dbus_pamac_daemon_start_trans_run (object, parameters, invocation);
	} else if (strcmp (method_name, "StartSnapTransRun") == 0) {
		_dbus_pamac_daemon_start_snap_trans_run (object, parameters, invocation);
	} else if (strcmp (method_name, "StartSnapSwitchChannel") == 0) {
		_dbus_pamac_daemon_start_snap_switch_channel (object, parameters, invocation);
	} else if (strcmp (method_name, "StartFlatpakTransRun") == 0) {
		_dbus_pamac_daemon_start_flatpak_trans_run (object, parameters, invocation);
	} else if (strcmp (method_name, "TransCancel") == 0) {
		_dbus_pamac_daemon_trans_cancel (object, parameters, invocation);
	} else if (strcmp (method_name, "Quit") == 0) {
		_dbus_pamac_daemon_quit (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
pamac_daemon_dbus_interface_get_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
pamac_daemon_dbus_interface_set_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GVariant* value,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_pamac_daemon_emit_action (GObject* _sender,
                                const gchar* sender,
                                const gchar* action,
                                gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (action));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "EmitAction", _arguments, NULL);
}

static void
_dbus_pamac_daemon_emit_action_progress (GObject* _sender,
                                         const gchar* sender,
                                         const gchar* action,
                                         const gchar* status,
                                         gdouble progress,
                                         gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (action));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (status));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_double (progress));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "EmitActionProgress", _arguments, NULL);
}

static void
_dbus_pamac_daemon_emit_download_progress (GObject* _sender,
                                           const gchar* sender,
                                           const gchar* action,
                                           const gchar* status,
                                           gdouble progress,
                                           gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (action));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (status));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_double (progress));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "EmitDownloadProgress", _arguments, NULL);
}

static void
_dbus_pamac_daemon_emit_hook_progress (GObject* _sender,
                                       const gchar* sender,
                                       const gchar* action,
                                       const gchar* details,
                                       const gchar* status,
                                       gdouble progress,
                                       gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (action));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (details));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (status));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_double (progress));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "EmitHookProgress", _arguments, NULL);
}

static void
_dbus_pamac_daemon_emit_script_output (GObject* _sender,
                                       const gchar* sender,
                                       const gchar* message,
                                       gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (message));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "EmitScriptOutput", _arguments, NULL);
}

static void
_dbus_pamac_daemon_emit_warning (GObject* _sender,
                                 const gchar* sender,
                                 const gchar* message,
                                 gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (message));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "EmitWarning", _arguments, NULL);
}

static void
_dbus_pamac_daemon_emit_error (GObject* _sender,
                               const gchar* sender,
                               const gchar* message,
                               gchar** details,
                               gint details_length1,
                               gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp85_;
	GVariantBuilder _tmp86_;
	gint _tmp87_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (message));
	_tmp85_ = details;
	g_variant_builder_init (&_tmp86_, G_VARIANT_TYPE ("as"));
	for (_tmp87_ = 0; _tmp87_ < details_length1; _tmp87_++) {
		g_variant_builder_add_value (&_tmp86_, g_variant_new_string (*_tmp85_));
		_tmp85_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp86_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "EmitError", _arguments, NULL);
}

static void
_dbus_pamac_daemon_important_details_outpout (GObject* _sender,
                                              const gchar* sender,
                                              gboolean must_show,
                                              gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (must_show));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "ImportantDetailsOutpout", _arguments, NULL);
}

static void
_dbus_pamac_daemon_start_downloading (GObject* _sender,
                                      const gchar* sender,
                                      gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "StartDownloading", _arguments, NULL);
}

static void
_dbus_pamac_daemon_stop_downloading (GObject* _sender,
                                     const gchar* sender,
                                     gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "StopDownloading", _arguments, NULL);
}

static void
_dbus_pamac_daemon_set_pkgreason_finished (GObject* _sender,
                                           const gchar* sender,
                                           gboolean success,
                                           gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "SetPkgreasonFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_start_waiting (GObject* _sender,
                                  const gchar* sender,
                                  gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "StartWaiting", _arguments, NULL);
}

static void
_dbus_pamac_daemon_stop_waiting (GObject* _sender,
                                 const gchar* sender,
                                 gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "StopWaiting", _arguments, NULL);
}

static void
_dbus_pamac_daemon_trans_refresh_finished (GObject* _sender,
                                           const gchar* sender,
                                           gboolean success,
                                           gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "TransRefreshFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_trans_refresh_files_finished (GObject* _sender,
                                                 const gchar* sender,
                                                 gboolean success,
                                                 gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "TransRefreshFilesFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_trans_refresh_aur_finished (GObject* _sender,
                                               const gchar* sender,
                                               gboolean success,
                                               gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "TransRefreshAurFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_trans_run_finished (GObject* _sender,
                                       const gchar* sender,
                                       gboolean success,
                                       gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "TransRunFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_download_updates_finished (GObject* _sender,
                                              const gchar* sender,
                                              gboolean success,
                                              gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "DownloadUpdatesFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_download_pkgs_finished (GObject* _sender,
                                           const gchar* sender,
                                           gchar** dload_paths,
                                           gint dload_paths_length1,
                                           gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp88_;
	GVariantBuilder _tmp89_;
	gint _tmp90_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	_tmp88_ = dload_paths;
	g_variant_builder_init (&_tmp89_, G_VARIANT_TYPE ("as"));
	for (_tmp90_ = 0; _tmp90_ < dload_paths_length1; _tmp90_++) {
		g_variant_builder_add_value (&_tmp89_, g_variant_new_string (*_tmp88_));
		_tmp88_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp89_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "DownloadPkgsFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_get_authorization_finished (GObject* _sender,
                                               const gchar* sender,
                                               gboolean authorized,
                                               gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (authorized));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "GetAuthorizationFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_write_alpm_config_finished (GObject* _sender,
                                               const gchar* sender,
                                               gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "WriteAlpmConfigFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_write_pamac_config_finished (GObject* _sender,
                                                const gchar* sender,
                                                gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "WritePamacConfigFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_generate_mirrors_list_data (GObject* _sender,
                                               const gchar* sender,
                                               const gchar* line,
                                               gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (line));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "GenerateMirrorsListData", _arguments, NULL);
}

static void
_dbus_pamac_daemon_generate_mirrors_list_finished (GObject* _sender,
                                                   const gchar* sender,
                                                   gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "GenerateMirrorsListFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_clean_cache_finished (GObject* _sender,
                                         const gchar* sender,
                                         gboolean success,
                                         gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "CleanCacheFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_clean_build_files_finished (GObject* _sender,
                                               const gchar* sender,
                                               gboolean success,
                                               gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "CleanBuildFilesFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_snap_trans_run_finished (GObject* _sender,
                                            const gchar* sender,
                                            gboolean success,
                                            gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "SnapTransRunFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_snap_switch_channel_finished (GObject* _sender,
                                                 const gchar* sender,
                                                 gboolean success,
                                                 gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "SnapSwitchChannelFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_flatpak_trans_run_finished (GObject* _sender,
                                               const gchar* sender,
                                               gboolean success,
                                               gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "FlatpakTransRunFinished", _arguments, NULL);
}

guint
pamac_daemon_register_object (gpointer object,
                              GDBusConnection* connection,
                              const gchar* path,
                              GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_pamac_daemon_dbus_interface_info), &_pamac_daemon_dbus_interface_vtable, data, _pamac_daemon_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "emit-action", (GCallback) _dbus_pamac_daemon_emit_action, data);
	g_signal_connect (object, "emit-action-progress", (GCallback) _dbus_pamac_daemon_emit_action_progress, data);
	g_signal_connect (object, "emit-download-progress", (GCallback) _dbus_pamac_daemon_emit_download_progress, data);
	g_signal_connect (object, "emit-hook-progress", (GCallback) _dbus_pamac_daemon_emit_hook_progress, data);
	g_signal_connect (object, "emit-script-output", (GCallback) _dbus_pamac_daemon_emit_script_output, data);
	g_signal_connect (object, "emit-warning", (GCallback) _dbus_pamac_daemon_emit_warning, data);
	g_signal_connect (object, "emit-error", (GCallback) _dbus_pamac_daemon_emit_error, data);
	g_signal_connect (object, "important-details-outpout", (GCallback) _dbus_pamac_daemon_important_details_outpout, data);
	g_signal_connect (object, "start-downloading", (GCallback) _dbus_pamac_daemon_start_downloading, data);
	g_signal_connect (object, "stop-downloading", (GCallback) _dbus_pamac_daemon_stop_downloading, data);
	g_signal_connect (object, "set-pkgreason-finished", (GCallback) _dbus_pamac_daemon_set_pkgreason_finished, data);
	g_signal_connect (object, "start-waiting", (GCallback) _dbus_pamac_daemon_start_waiting, data);
	g_signal_connect (object, "stop-waiting", (GCallback) _dbus_pamac_daemon_stop_waiting, data);
	g_signal_connect (object, "trans-refresh-finished", (GCallback) _dbus_pamac_daemon_trans_refresh_finished, data);
	g_signal_connect (object, "trans-refresh-files-finished", (GCallback) _dbus_pamac_daemon_trans_refresh_files_finished, data);
	g_signal_connect (object, "trans-refresh-aur-finished", (GCallback) _dbus_pamac_daemon_trans_refresh_aur_finished, data);
	g_signal_connect (object, "trans-run-finished", (GCallback) _dbus_pamac_daemon_trans_run_finished, data);
	g_signal_connect (object, "download-updates-finished", (GCallback) _dbus_pamac_daemon_download_updates_finished, data);
	g_signal_connect (object, "download-pkgs-finished", (GCallback) _dbus_pamac_daemon_download_pkgs_finished, data);
	g_signal_connect (object, "get-authorization-finished", (GCallback) _dbus_pamac_daemon_get_authorization_finished, data);
	g_signal_connect (object, "write-alpm-config-finished", (GCallback) _dbus_pamac_daemon_write_alpm_config_finished, data);
	g_signal_connect (object, "write-pamac-config-finished", (GCallback) _dbus_pamac_daemon_write_pamac_config_finished, data);
	g_signal_connect (object, "generate-mirrors-list-data", (GCallback) _dbus_pamac_daemon_generate_mirrors_list_data, data);
	g_signal_connect (object, "generate-mirrors-list-finished", (GCallback) _dbus_pamac_daemon_generate_mirrors_list_finished, data);
	g_signal_connect (object, "clean-cache-finished", (GCallback) _dbus_pamac_daemon_clean_cache_finished, data);
	g_signal_connect (object, "clean-build-files-finished", (GCallback) _dbus_pamac_daemon_clean_build_files_finished, data);
	g_signal_connect (object, "snap-trans-run-finished", (GCallback) _dbus_pamac_daemon_snap_trans_run_finished, data);
	g_signal_connect (object, "snap-switch-channel-finished", (GCallback) _dbus_pamac_daemon_snap_switch_channel_finished, data);
	g_signal_connect (object, "flatpak-trans-run-finished", (GCallback) _dbus_pamac_daemon_flatpak_trans_run_finished, data);
	return result;
}

static void
_pamac_daemon_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_emit_action, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_emit_action_progress, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_emit_download_progress, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_emit_hook_progress, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_emit_script_output, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_emit_warning, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_emit_error, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_important_details_outpout, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_start_downloading, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_stop_downloading, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_set_pkgreason_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_start_waiting, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_stop_waiting, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_trans_refresh_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_trans_refresh_files_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_trans_refresh_aur_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_trans_run_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_download_updates_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_download_pkgs_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_get_authorization_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_write_alpm_config_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_write_pamac_config_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_generate_mirrors_list_data, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_generate_mirrors_list_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_clean_cache_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_clean_build_files_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_snap_trans_run_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_snap_switch_channel_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_flatpak_trans_run_finished, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
on_bus_acquired (GDBusConnection* conn)
{
	PamacDaemon* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (conn != NULL);
	_tmp0_ = pamac_daemon_new ();
	_g_object_unref0 (system_daemon);
	system_daemon = _tmp0_;
	{
		PamacDaemon* _tmp1_;
		_tmp1_ = system_daemon;
		pamac_daemon_register_object (_tmp1_, conn, "/org/manjaro/pamac/daemon", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GMainLoop* _tmp2_;
		g_clear_error (&_inner_error0_);
		g_warning ("daemon.vala:834: Could not register service");
		_tmp2_ = loop;
		g_main_loop_quit (_tmp2_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                         const gchar* name,
                                         gpointer self)
{
	on_bus_acquired (connection);
}

static void
__lambda98_ (void)
{
	GMainLoop* _tmp0_;
	g_warning ("daemon.vala:850: Could not acquire name");
	_tmp0_ = loop;
	g_main_loop_quit (_tmp0_);
}

static void
___lambda98__gbus_name_lost_callback (GDBusConnection* connection,
                                      const gchar* name,
                                      gpointer self)
{
	__lambda98_ ();
}

static void
_vala_main (void)
{
	GMainLoop* _tmp0_;
	GMainLoop* _tmp1_;
	setlocale (LC_ALL, "");
	textdomain (GETTEXT_PACKAGE);
	g_bus_own_name_with_closures (G_BUS_TYPE_SYSTEM, "org.manjaro.pamac.daemon", G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) g_cclosure_new ((GCallback) _on_bus_acquired_gbus_acquired_callback, NULL, (GClosureNotify) NULL), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((___lambda98__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda98__gbus_name_lost_callback, NULL, (GClosureNotify) NULL)));
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (loop);
	loop = _tmp0_;
	_tmp1_ = loop;
	g_main_loop_run (_tmp1_);
}

int
main (int argc,
      char ** argv)
{
	_vala_main ();
	return 0;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

