/*
 * Decompiled with CFR 0.152.
 */
package com.ejt.internal.i18n;

import com.ejt.internal.i18n.AbstractMessages;
import com.ejt.internal.util.CommonStringUtil;
import com.ejt.internal.util.XMLEnum;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public enum SupportedLocale implements XMLEnum<SupportedLocale>
{
    AUTO_DETECT(""),
    ENGLISH("en"),
    SIMPLIFIED_CHINESE("zh_CN"),
    REVERSE_ENGLISH("zz");

    private static final SupportedLocale DEFAULT;
    private static SupportedLocale current;
    private static SupportedLocale resolved;
    private final String code;

    private SupportedLocale(String code) {
        this.code = code;
    }

    public static SupportedLocale getByCode(@NotNull String code) {
        for (SupportedLocale supportedLocale : SupportedLocale.values()) {
            if (!supportedLocale.code.equals(code)) continue;
            return supportedLocale;
        }
        return AUTO_DETECT;
    }

    public static String getResolvedNonDefaultSuffix() {
        return resolved == null || resolved == DEFAULT ? "" : "_" + SupportedLocale.resolved.code;
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getXMLValue() {
        return this.code;
    }

    public SupportedLocale[] getXMLEnums() {
        return SupportedLocale.values();
    }

    @NotNull
    public static SupportedLocale getCurrent() {
        return current;
    }

    public void setCurrent(boolean applyLocale) {
        current = this;
        resolved = this.code.isEmpty() ? this.getAutoDetected() : this;
        if (applyLocale) {
            Locale.setDefault(this.createLocale());
            AbstractMessages.invalidateAll();
        }
    }

    public void initActual() {
        this.createLocale();
    }

    @NotNull
    public static SupportedLocale getResolved() {
        return resolved != null ? resolved : current;
    }

    @NotNull
    private Locale createLocale() {
        if (this.code.isEmpty()) {
            return resolved.createLocale();
        }
        String[] parts = this.code.split("_");
        int length = parts.length;
        if (length == 1) {
            return new Locale(parts[0]);
        }
        if (length == 2) {
            return new Locale(parts[0], parts[1]);
        }
        if (length == 3) {
            return new Locale(parts[0], parts[1], parts[1]);
        }
        throw new IllegalStateException(this.code + " has more than 3 components");
    }

    @NotNull
    private SupportedLocale getAutoDetected() {
        ArrayDeque<String> parts = new ArrayDeque<String>(Arrays.asList(Locale.getDefault().toString().split("_")));
        while (!parts.isEmpty()) {
            String truncatedCode = CommonStringUtil.join("_", parts);
            for (SupportedLocale supportedLocale : SupportedLocale.values()) {
                if (!supportedLocale.getCode().equals(truncatedCode)) continue;
                return supportedLocale;
            }
            parts.removeLast();
        }
        return DEFAULT;
    }

    public boolean isCapitalizeWordsSupported() {
        return this == ENGLISH;
    }

    static {
        DEFAULT = ENGLISH;
        current = AUTO_DETECT;
    }
}

