/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.sort;

import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;

public class SortUtils {
    public static RowSorter.SortKey getFirstSortingKey(List<? extends RowSorter.SortKey> keys2) {
        for (RowSorter.SortKey sortKey : keys2) {
            if (!SortUtils.isSorted(sortKey.getSortOrder())) continue;
            return sortKey;
        }
        return null;
    }

    public static RowSorter.SortKey getFirstSortKeyForColumn(List<? extends RowSorter.SortKey> keys2, int modelColumn) {
        for (RowSorter.SortKey sortKey : keys2) {
            if (sortKey.getColumn() != modelColumn) continue;
            return sortKey;
        }
        return null;
    }

    public static RowSorter.SortKey removeFirstSortKeyForColumn(List<? extends RowSorter.SortKey> keys2, int modelColumn) {
        for (RowSorter.SortKey sortKey : keys2) {
            if (sortKey.getColumn() != modelColumn) continue;
            keys2.remove(sortKey);
            return sortKey;
        }
        return null;
    }

    public static boolean isSorted(SortOrder sortOrder) {
        return sortOrder != null && SortOrder.UNSORTED != sortOrder;
    }

    public static boolean isAscending(SortOrder sortOrder) {
        return sortOrder == SortOrder.ASCENDING;
    }

    public static boolean isSorted(SortOrder sortOrder, boolean ascending) {
        return SortUtils.isSorted(sortOrder) && ascending == SortUtils.isAscending(sortOrder);
    }

    private SortUtils() {
    }
}

